mlmdquery
=========

[![mlmdquery](https://img.shields.io/crates/v/mlmdquery.svg)](https://crates.io/crates/mlmdquery)
[![Documentation](https://docs.rs/mlmdquery/badge.svg)](https://docs.rs/mlmdquery)
[![Actions Status](https://github.com/sile/mlmdquery/workflows/CI/badge.svg)](https://github.com/sile/mlmdquery/actions)
[![License: MIT](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

A command-line tool to query the contents of an [ml-metadata](https://github.com/google/ml-metadata) DB.

Features:
- It is possible to specify more flexible search queries than the original Python API
- You can get the number of items that match your query without having to fetch all the data

Usage Examples
--------------

### Note

The following examples use a SQLite database file (`mlmd.db`).
The database contents were generated by the example code described in
[the official getting started guide](https://github.com/google/ml-metadata/blob/master/g3doc/get_started.md).

---

Get the artifacts in the DB:
```console
$ mlmdquery get artifacts --db sqlite://mlmd.db
[
  {
    "id": 2,
    "name": null,
    "type": "SavedModel",
    "uri": "path/to/model/file",
    "state": "UNKNOWN",
    "ctime": 1628605220.769,
    "mtime": 1628605220.904,
    "properties": {
      "name": "MNIST-v1",
      "version": 1
    },
    "custom_properties": {}
  },
  {
    "id": 1,
    "name": null,
    "type": "DataSet",
    "uri": "path/to/data",
    "state": "UNKNOWN",
    "ctime": 1628605220.108,
    "mtime": 1628605220.235,
    "properties": {
      "day": 1,
      "split": "train"
    },
    "custom_properties": {}
  }
]
```

Count the artifacts in the DB:
```console
$ export MLMD_DB=sqlite://mlmd.db
$ mlmdquery count artifacts
2
```

Specify the maximum number of artifacts:
```console
$ mlmdquery get artifacts --limit 1
[
  {
    "id": 2,
    "name": null,
    "type": "SavedModel",
    "uri": "path/to/model/file",
    "state": "UNKNOWN",
    "ctime": 1628605220.769,
    "mtime": 1628605220.904,
    "properties": {
      "name": "MNIST-v1",
      "version": 1
    },
    "custom_properties": {}
  }
]

Specify the URI of the target artifact:
```console
$ export MLMD_DB=sqlite://mlmd.db
$ mlmdquery get artifacts --uri path/to/data
[
  {
    "id": 1,
    "name": null,
    "type": "DataSet",
    "uri": "path/to/data",
    "state": "UNKNOWN",
    "ctime": 1628605220.108,
    "mtime": 1628605220.235,
    "properties": {
      "day": 1,
      "split": "train"
    },
    "custom_properties": {}
  }
]
```

Available options of `$ mlmdquery get artifacts`:
```console
$ mlmdquery get artifacts -h
Gets artifacts

USAGE:
    mlmdquery get artifacts [FLAGS] [OPTIONS] --db <db>

FLAGS:
        --asc        If specified, the search results will be sorted in ascending order
    -h, --help       Prints help information
    -V, --version    Prints version information

OPTIONS:
        --context <context>            Context ID to which target artifacts belong
        --ctime-end <ctime-end>        End of creation time (UNIX timestamp seconds)
        --ctime-start <ctime-start>    Start of creation time (UNIX timestamp seconds)
        --db <db>                      Database URL [env: MLMD_DB]
        --id <ids>...                  Target artifact IDs
        --limit <limit>                Maximum number of artifacts in a search result [default: 100]
        --mtime-end <mtime-end>        End of update time (UNIX timestamp seconds)
        --mtime-start <mtime-start>    Start of update time (UNIX timestamp seconds)
        --name <name>                  Target artifact name
        --offset <offset>              Number of artifacts to be skipped from a search result [default: 0]
        --order-by <order-by>          Field to be used to sort a search result [default: id]  [possible values: id,
                                       name, ctime, mtime]
        --type <type-name>             Target artifact type
        --uri <uri>                    Target artifact URI
```

Available commands:
```console
$ mlmdquery -h
mlmdquery 0.1.0

USAGE:
    mlmdquery <SUBCOMMAND>

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

SUBCOMMANDS:
    count    Counts artifacts/executions/contexts/events
    get      Gets artifacts/executions/contexts/events
    help     Prints this message or the help of the given subcommand(s)

$ mlmdquery get -h
mlmdquery-get 0.1.0
Gets artifacts/executions/contexts/events

USAGE:
    mlmdquery get <SUBCOMMAND>

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

SUBCOMMANDS:
    artifact-types     Gets artifact types
    artifacts          Gets artifacts
    context-types      Gets context types
    contexts           Gets contexts
    events             Gets events
    execution-types    Gets execution types
    executions         Gets executions
    help               Prints this message or the help of the given subcommand(s)
```

How to build a static binary?
-----------------------------

Please use [rust-musl-builder](https://github.com/emk/rust-musl-builder).
