use super::*;
use super::super::*;
use super::super::templates::*;
use super::super::ElementContent::*;
use super::super::database::Class;
use std::rc::Rc;
use std::vec::Vec;
use std::string::String;

macro_rules! t {
    ($n:ident, $i:expr, $o:expr) => { #[test] fn $n() { assert_eq!(generate(&$i), $o); } }
}

macro_rules! concat_vectors {
    ($v1:expr, $v2:expr) => { { let mut x = $v1; x.extend((*$v2).iter().cloned()); x } }
}

t!(t1 , el_bin(Class::Void, vec![]), vec!(0xEC, 0x80));
t!(t2 , el_bin(Class::Void, vec![0xFF]), vec!(0xEC, 0x81, 0xFF));
t!(t3 , el_bin(Class::Void, vec![0x00,0x01]), vec!(0xEC, 0x82, 0x00,0x01));
t!(t4 , el_bin(Class::SimpleBlock, concat_vectors!(vec![0x81,0x00], &[0xFF ; 0x5000])),
    concat_vectors!(vec!(0xA3, 0x20, 0x50, 0x02, 0x81,0x00), &[0xFF ; 0x5000]));
t!(t5 , el_uns(Class::FlagForced, 0x1234), vec![0x55,0xAA,0x82,0x12,0x34]);
t!(t6 , el_uns(Class::TrackOffset, 0x40), vec![0x53,0x7F,0x81,0x40]);
t!(t7 , el_sig(Class::TrackOffset, 0x7F), vec![0x53,0x7F,0x81,0x7F]);
t!(t8 , el_sig(Class::TrackOffset, 0x80), vec![0x53,0x7F,0x82,0x00,0x80]);
t!(t9 , el_sig(Class::TrackOffset, -0x80), vec![0x53,0x7F,0x81,0x80]);
t!(t10, el_sig(Class::TrackOffset, -0x81), vec![0x53,0x7F,0x82,0xFF,0x7F]);
t!(t11, el_flo(Class::Duration, 1240406000.0), vec![0x44, 0x89, 0x84,   0x4e, 0x93, 0xde, 0x30]);
t!(t12, el_txt(Class::FileName, String::from("ABC")), vec![0x46, 0x6E, 0x83,   0x41, 0x42, 0x43]);
t!(t13, cluster_with_one_simple_block(0x12,  vec![0x84, 0x00, 0x44]),
  vec![0x1F,0x43,0xB6,0x75,0x88,  0xE7, 0x81,0x12,   0xA3, 0x83, 0x84, 0x00, 0x44]);
t!(t14, ebml_header(false),
  vec![   0x1a, 0x45, 0xdf, 0xa3, 0xa3, 0x42, 0x86, 0x81, 0x01, 0x42, 0xf7, 0x81,
          0x01, 0x42, 0xf2, 0x81, 0x04, 0x42, 0xf3, 0x81, 0x08, 0x42, 0x82, 0x88,
          0x6d, 0x61, 0x74, 0x72, 0x6f, 0x73, 0x6b, 0x61, 0x42, 0x87, 0x81, 0x02,
          0x42, 0x85, 0x81, 0x02 ] );
