#[macro_use]
extern crate futures;
extern crate tokio;
extern crate rocket;




use rocket::{Response, Request, get, routes, launch};
use rocket::fs::{FileServer, NamedFile, relative};
use std::path::{Path, PathBuf};

#[get("/<path>")]
async fn page(path: &str) -> Option<NamedFile> {
    let mut tmp;
    if path.is_empty(){
        tmp = Path::new("index.html");
    }
    match path{
        "book" =>  tmp = Path::new("books.html"),
        "proj" => tmp = Path::new("projects.html"),
        _ => panic!("AAHHH")
    }
    let mut path = Path::new(relative!(".")).join(tmp);
    if path.is_dir(){
        path.push("index.html");
    }
    NamedFile::open(path).await.ok()
}

#[get("/download/<path..>")]
async fn download(path: PathBuf) -> Option<NamedFile> {
    let mut path = Path::new(relative!("files")).join(path);
    NamedFile::open(path).await.ok()
}

#[launch]
fn rocket() -> _ {
    rocket::build()
        .mount("/", routes![page, download])
        .mount("/", FileServer::from("."))

}
