use crate::model::{clip::Clip, id::Id};

use serde::Serialize;

#[derive(Serialize, Debug, Clone)]
#[serde(rename_all = "camelCase")]
pub struct Request {
    pub clip_id: Id<Clip>,
}

impl misskey_core::Request for Request {
    type Response = ();
    const ENDPOINT: &'static str = "clips/delete";
}

#[cfg(test)]
mod tests {
    use super::Request;
    use crate::test::{ClientExt, TestClient};

    #[tokio::test]
    async fn request() {
        let client = TestClient::new();
        let clip = client
            .test(crate::endpoint::clips::create::Request {
                name: "clip test".to_string(),
                #[cfg(feature = "12-57-0")]
                is_public: None,
                #[cfg(feature = "12-57-0")]
                description: None,
            })
            .await;

        client.test(Request { clip_id: clip.id }).await;
    }
}
