<h1 align="center">MirrorCache</h1>

<div align="center">
  <a href="https://github.com/SeanChao/mirror-cache/actions/workflows/ci.yml">
    <img src="https://img.shields.io/github/license/SeanChao/mirror-cache?color=blue&style=flat-square" alt="license"/>
    <img src="https://img.shields.io/github/workflow/status/seanchao/mirror-cache/Test?label=Test&logo=github&style=flat-square" alt="GitHub Actions CI testing status"/>
    <img src="https://img.shields.io/docker/v/seanchao/mirror-cache?label=docker&style=flat-square" alt="docker hub latest release version"/>
  </a>
</div>

A reverse proxy supporting multiple cache policies, customized rules, configuration hot reloading. For mirror sites and also personal users!

[docs](docs/README.md) | [demo server](https://mirrors.seanchao.xyz)

## Features

- Cache your dependencies on limited disk space with LRU/TTL cache policies
- Reload updated config without restarting the program
- Support customized rules
- Expose metrics like cache hit rate per rule, task count and more

## Quick start

1. Download the [latest release](https://github.com/SeanChao/mirror-cache/releases/latest), or build from source:

```sh
cargo run
```

2. Prepare a [configuration file](config.yml)

3. Try it out:

```sh
pip install -i http://localhost:9000 requests

conda install -c http://localhost:9000 requests
conda config --set custom_channels.pytorch http://localhost:9000/anaconda/cloud/ && conda install -c pytorch -y --download-only -v torchtext

# Ubuntu
# In /etc/apt/sources.list: change links like http://xxx.ubuntu.com/ubuntu into http://localhost:9000/ubuntu
apt-get update
```
