/*
 * Copyright (c) 2012-2020 MIRACL UK Ltd.
 *
 * This file is part of MIRACL Core
 * (see https://github.com/miracl/core).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

use crate::arch::Chunk;
use crate::bls48581::big::NLEN;

// Base Bits= 60
pub const MODULUS:[Chunk;NLEN]=[0xEDC154E6565912B,0x8FDF721A4A48AC3,0x7A5513170EE0A57,0x394F4736DAF6836,0xAF6E082ACD9CD30,0xF3975444A48AE43,0x22131BB3BE6C0F1,0x12A0056E84F8D1,0x76F313824E31D47,0x1280F73FF34];
pub const ROI:[Chunk;NLEN]=[0xEDC154E6565912A,0x8FDF721A4A48AC3,0x7A5513170EE0A57,0x394F4736DAF6836,0xAF6E082ACD9CD30,0xF3975444A48AE43,0x22131BB3BE6C0F1,0x12A0056E84F8D1,0x76F313824E31D47,0x1280F73FF34];
pub const R2MODP:[Chunk;NLEN]=[0x79868479F1B5833,0xFB6EBA8FCB82D07,0x9CC8A7F1FD84C7F,0x402C51CF5CC3CBB,0x3F3114F078502C,0xFC90829BDC8336E,0xC7BE91DE9CA8EED,0xD4D273BB17BFADB,0x6EC7C9A81E792CA,0x1DC317A6E4];
pub const MCONST:Chunk=0x148B81FC39D5A7D;
pub const SQRTM3:[Chunk;NLEN]=[0x51EDFC2A1D65A0A,0xD62DAA292D8CDBF,0x24112478269D616,0x6C25D3CABF8AD71,0xC8E9B16B5D3E4CD,0xF50A03B738960EE,0x1A664376FED4343,0xBFFD8FB8925AE06,0x600908C6A28DEAA,0x1280F73F9A7];
pub const FRA:[Chunk;NLEN]=[0x62EB6CFE42AEB25,0xDB41942760AD3F9,0xA7DF2570715ECE4,0x90377B51208AC0F,0x6848493E1C8C418,0xF496307E298187E,0x58740E3CAFD6B62,0xF6067D047983E78,0x49FA75CD7E73E55,0xFD30DB501];
pub const FRB:[Chunk;NLEN]=[0x62EB6CFE42AEB25,0xDB41942760AD3F9,0xA7DF2570715ECE4,0x90377B51208AC0F,0x6848493E1C8C418,0xF496307E298187E,0x58740E3CAFD6B62,0xF6067D047983E78,0x49FA75CD7E73E55,0xFD30DB501];
pub const TWK:[Chunk;NLEN]=[0x7B433D25F426953,0xACE45923B9863D,0xC28BBDFA2D37E16,0x62FFCC8AFB4BC18,0x661B4392F002C4F,0x2ED27E951A14781,0x670A6683B853246,0xAEB8C9BA138A075,0xC10075769CDDD9E,0x3A65A537B];

//*** rom curve parameters *****
// Base Bits= 60
// Ate Bits= 33
// G2 Table size= 36

pub const CURVE_COF_I:isize = 0;
pub const CURVE_COF:[Chunk;NLEN]=[0x140000382,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0];
pub const CURVE_B_I:isize = 1;
pub const CURVE_B:[Chunk;NLEN]=[0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0];
pub const CURVE_ORDER:[Chunk;NLEN]=[0x8A5FE6FCD671C01,0xBE599467C24DA11,0xC7CD0562303C4CC,0x9D34C4C92016A85,0xBC972C2E6E74196,0x3F0B3CBE003FAD6,0x615C0D6C635387A,0xE2885E233A9CCC1,0x2386F8A925,0x0];
pub const CURVE_GX:[Chunk;NLEN]=[0xBCE8732315AF640,0x74DA5D3A1E6D8C3,0x57DB368B11786CB,0x665D859236EBDBC,0x46A9DF6F9645847,0xEDFFB9F75445505,0xE86868CF61ABDBA,0x93F860DE3F257E0,0x40F2BAF2B73DF1E,0x2AF59B7AC3];
pub const CURVE_GY:[Chunk;NLEN]=[0xDBB5DE3E2587A70,0xF37AEF7B926B576,0xF77C2876D1B2E35,0x78584C3EF22F487,0xFFB98AEE53E80F6,0xD41B720EF7BB7BE,0xFEB8A52E991279D,0xB398A488A553C9E,0x31F91F86B3A2D1F,0xCEFDA44F65];
pub const CURVE_HTPC:[Chunk;NLEN]=[0x393F0BE031193EC,0xC28896440758243,0xDBE4AA8E70D4620,0x6B27BD55EFD560E,0x24A9624BEECD070,0xE2626AD7C53B361,0xDD845A98030C755,0x29389B4E6A62C2D,0x5AF94F05D8A9FD4,0x92348CD5DC];
pub const CURVE_BNX:[Chunk;NLEN]=[0x140000381,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0];
pub const CRU:[Chunk;NLEN]=[0x4DE9AC5E1C79B90,0x5CD8E3F88E5DE82,0xAB21F74F7421A20,0x6694B9B60DB5D62,0x73422B5FB82F431,0xFF46A846B5FA6AA,0x83D66C1E5FCBED6,0x2096384F2AFA565,0x8B75055DD5D1F4E,0x2C6];
pub const CURVE_PXAAA:[Chunk;NLEN]=[0x34FD0B4ACE8BFAB,0xB79766322154DEC,0x4D80491F510317,0x3CA0612F4005030,0xBAAD1A8C42281A6,0x3A2EF156C46FF79,0x344DBCCB7DE64DB,0x2775DEBABBEFC70,0x71E4A38237FA45A,0x5D615D9A78];
pub const CURVE_PXAAB:[Chunk;NLEN]=[0x669B36676B47C57,0x5556A01AFA143F1,0x7630D979630FFD7,0x6AFFA62504F0C3C,0xABFEDF16214A7,0x12307F4E1C3943A,0xE1623E9526F6DA,0xBC07E8B22BB6D98,0x258512069B0E86A,0x7C4973ECE2];
pub const CURVE_PXABA:[Chunk;NLEN]=[0x488156CA55A3E6A,0xEF4CDED6B3F0B46,0xCBDFBB879D5FEA8,0x66F0D2A6D55F028,0xC1DBD19242FFAE7,0xCCBAB5AB6860161,0xAE237CA7A6D6957,0xAD83BC73A8A6CA9,0xF1334E1B2EA1853,0x1FCCC70198];
pub const CURVE_PXABB:[Chunk;NLEN]=[0x9A7033CBB7FEAFE,0x10B8CB4E80BC3F0,0x1C5257C200CA523,0x43B1B279B9468C3,0x5F63E1C776E6EC1,0x393F8BE0CC218A9,0x62F3E5821B7B92A,0x54D4BFE8F5985AC,0xEB6185C78D80129,0xBE2218C25C];
pub const CURVE_PXBAA:[Chunk;NLEN]=[0x39C3A1C53F8CCE5,0x5B5F746C9D4CBB7,0xD55FC1889AA80C6,0xEF492AE589274FA,0x9E48199D5AC10B2,0xC5805386699981F,0xB1642B5675FF0E7,0xA9DD63007C675D0,0x35913A3C598E4CA,0x38B91C600B];
pub const CURVE_PXBAB:[Chunk;NLEN]=[0x2004D914A3C093A,0x7960910FCE3370F,0xA9F177612F097FC,0x40B9C0B15DD7595,0x3835D28997EB57B,0x7BB037418181DF6,0xEF0977A3D1A5867,0xCDA088F7B8F35DC,0x738603F1311E4E,0xC96C7797EB];
pub const CURVE_PXBBA:[Chunk;NLEN]=[0x41607E60750E057,0x4B5B0E205C3354E,0xCBE4324C22D6333,0xAA5EFCF3432AAD1,0xF293B13CED0FD0C,0xA2C0B7A449CEF11,0x9D13852B6DB908B,0x8AEE660DEA41B3,0x61EE3F0197A4989,0xB9B7951C60];
pub const CURVE_PXBBB:[Chunk;NLEN]=[0xE19DA00FBC6AE34,0x6AF2FC9E97C3F84,0x9BD6AEBF9FC44E5,0x90B7E2B0D458547,0xA93F29CFF364A71,0x719728A7F9F8CFC,0xFAF47B5211CF741,0x4AAA2B1E5D7A9DE,0x2BDEC5282624C4F,0x827D5C22FB];
pub const CURVE_PYAAA:[Chunk;NLEN]=[0x3EDD3FE4D2D7971,0x45012AB12C0FF32,0x9ABF77EEA6D6590,0x336D8AE5163C159,0x35AFA27748D90F7,0xBFC435FAAB09062,0x59A577E6F3B39E,0x2F3024B918B4238,0x75B5DFA49721645,0xEB53356C3];
pub const CURVE_PYAAB:[Chunk;NLEN]=[0x1471DB936CD5665,0x8B423525FFC7B11,0x2FA097D760E2E58,0xD1892AB24E1DD21,0x6B243B1F192C5C3,0x64732FCBF3AFB09,0xA325E6FBA01D729,0x5FCADC2B75A422B,0xE0FF144DA653181,0x284DC75979];
pub const CURVE_PYABA:[Chunk;NLEN]=[0x8332A526A2A8474,0xBC7C46FC3B8FDE6,0x1D35D51A652269C,0x36CA3295E5E2F0C,0xC99D0E904115155,0xD370514475F7D5,0x216D5B119D3A48,0x67669EF2C2FC503,0x8523E421EFB703,0xB36A201DD0];
pub const CURVE_PYABB:[Chunk;NLEN]=[0x6213DA92841589D,0xB3D8B8A1E533731,0x7BDA503EE5E578F,0x817742770BA10D6,0x224333FA40DCED2,0x10E122D2742C89B,0x60DCEE23DD8B0E7,0x78762B1C2CDED33,0xEDC0688223FBBD4,0xAEC25A4621];
pub const CURVE_PYBAA:[Chunk;NLEN]=[0x47831F982E50137,0x857FDDDFCF7A43F,0x30135945D137B08,0xCA4E512B64F59F4,0x7FA238CDCE8A1E2,0x5F1129857ED85C7,0xB43DD93B5A95980,0x88325A2554DC541,0xA9C46916503FA5A,0xD209D5A223];
pub const CURVE_PYBAB:[Chunk;NLEN]=[0x4EEDC58CF90BEE4,0xA59ED8226CF3A59,0xFC198CAA72B679D,0xF47C180D139E3AA,0xE8C270841F6824,0x55AB7504FA8342,0xB16722B589D82E2,0xD537B90421AD66E,0x36B7A513D339D5A,0x7D0D037457];
pub const CURVE_PYBBA:[Chunk;NLEN]=[0xD41FAEAFEB23986,0xE884017D9AA62B3,0x40FA639F53DCCC9,0xAB8C74B2618B5BB,0x5AE3A2864F22C1F,0xE4C819A6DF98F42,0xC0841B064155F14,0xD17AF8A006F364F,0xE65EA25C2D05DFD,0x896767811B];
pub const CURVE_PYBBB:[Chunk;NLEN]=[0x667FFCB732718B6,0x5AC66E84069C55D,0xD8C4AB33F748E,0x333EC7192054173,0x8E69C31E97E1AD0,0xEF8ECA9A9533A3F,0x6BE8E50C87549B6,0x4F981B5E068F140,0x9029D393A5C07E8,0x35E2524FF8];
//pub const CURVE_W:[[Chunk;NLEN];2]=[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]];
//pub const CURVE_SB:[[[Chunk;NLEN];2];2]=[[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]],[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]]];
//pub const CURVE_WB:[[Chunk;NLEN];4]=[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]];
//pub const CURVE_BB:[[[Chunk;NLEN];4];4]=[[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]],[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]],[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]],[[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0],[0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0]]];

pub const USE_GLV: bool = true;
pub const USE_GS_G2: bool = true;
pub const USE_GS_GT: bool = true;
pub const GT_STRONG: bool = false;
