/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const VULKAN_H_: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 31;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LONG_DOUBLE_USES_FLOAT128: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const VULKAN_CORE_H_: u32 = 1;
pub const VK_VERSION_1_0: u32 = 1;
pub const VK_HEADER_VERSION: u32 = 170;
pub const VK_NULL_HANDLE: u32 = 0;
pub const VK_ATTACHMENT_UNUSED: i32 = -1;
pub const VK_FALSE: u32 = 0;
pub const VK_LOD_CLAMP_NONE: f64 = 1000.0;
pub const VK_QUEUE_FAMILY_IGNORED: i32 = -1;
pub const VK_REMAINING_ARRAY_LAYERS: i32 = -1;
pub const VK_REMAINING_MIP_LEVELS: i32 = -1;
pub const VK_SUBPASS_EXTERNAL: i32 = -1;
pub const VK_TRUE: u32 = 1;
pub const VK_WHOLE_SIZE: i32 = -1;
pub const VK_MAX_MEMORY_TYPES: u32 = 32;
pub const VK_MAX_MEMORY_HEAPS: u32 = 16;
pub const VK_MAX_PHYSICAL_DEVICE_NAME_SIZE: u32 = 256;
pub const VK_UUID_SIZE: u32 = 16;
pub const VK_MAX_EXTENSION_NAME_SIZE: u32 = 256;
pub const VK_MAX_DESCRIPTION_SIZE: u32 = 256;
pub const VK_VERSION_1_1: u32 = 1;
pub const VK_MAX_DEVICE_GROUP_SIZE: u32 = 32;
pub const VK_LUID_SIZE: u32 = 8;
pub const VK_QUEUE_FAMILY_EXTERNAL: i32 = -2;
pub const VK_VERSION_1_2: u32 = 1;
pub const VK_MAX_DRIVER_NAME_SIZE: u32 = 256;
pub const VK_MAX_DRIVER_INFO_SIZE: u32 = 256;
pub const VK_KHR_surface: u32 = 1;
pub const VK_KHR_SURFACE_SPEC_VERSION: u32 = 25;
pub const VK_KHR_SURFACE_EXTENSION_NAME: &[u8; 15usize] = b"VK_KHR_surface\0";
pub const VK_KHR_swapchain: u32 = 1;
pub const VK_KHR_SWAPCHAIN_SPEC_VERSION: u32 = 70;
pub const VK_KHR_SWAPCHAIN_EXTENSION_NAME: &[u8; 17usize] = b"VK_KHR_swapchain\0";
pub const VK_KHR_display: u32 = 1;
pub const VK_KHR_DISPLAY_SPEC_VERSION: u32 = 23;
pub const VK_KHR_DISPLAY_EXTENSION_NAME: &[u8; 15usize] = b"VK_KHR_display\0";
pub const VK_KHR_display_swapchain: u32 = 1;
pub const VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION: u32 = 10;
pub const VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME: &[u8; 25usize] = b"VK_KHR_display_swapchain\0";
pub const VK_KHR_sampler_mirror_clamp_to_edge: u32 = 1;
pub const VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION: u32 = 3;
pub const VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_EXTENSION_NAME: &[u8; 36usize] =
    b"VK_KHR_sampler_mirror_clamp_to_edge\0";
pub const VK_KHR_multiview: u32 = 1;
pub const VK_KHR_MULTIVIEW_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MULTIVIEW_EXTENSION_NAME: &[u8; 17usize] = b"VK_KHR_multiview\0";
pub const VK_KHR_get_physical_device_properties2: u32 = 1;
pub const VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION: u32 = 2;
pub const VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME: &[u8; 39usize] =
    b"VK_KHR_get_physical_device_properties2\0";
pub const VK_KHR_device_group: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_SPEC_VERSION: u32 = 4;
pub const VK_KHR_DEVICE_GROUP_EXTENSION_NAME: &[u8; 20usize] = b"VK_KHR_device_group\0";
pub const VK_KHR_shader_draw_parameters: u32 = 1;
pub const VK_KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_DRAW_PARAMETERS_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_KHR_shader_draw_parameters\0";
pub const VK_KHR_maintenance1: u32 = 1;
pub const VK_KHR_MAINTENANCE1_SPEC_VERSION: u32 = 2;
pub const VK_KHR_MAINTENANCE1_EXTENSION_NAME: &[u8; 20usize] = b"VK_KHR_maintenance1\0";
pub const VK_KHR_device_group_creation: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_KHR_device_group_creation\0";
pub const VK_MAX_DEVICE_GROUP_SIZE_KHR: u32 = 32;
pub const VK_KHR_external_memory_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME: &[u8; 36usize] =
    b"VK_KHR_external_memory_capabilities\0";
pub const VK_LUID_SIZE_KHR: u32 = 8;
pub const VK_KHR_external_memory: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME: &[u8; 23usize] = b"VK_KHR_external_memory\0";
pub const VK_QUEUE_FAMILY_EXTERNAL_KHR: i32 = -2;
pub const VK_KHR_external_memory_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME: &[u8; 26usize] = b"VK_KHR_external_memory_fd\0";
pub const VK_KHR_external_semaphore_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_EXTENSION_NAME: &[u8; 39usize] =
    b"VK_KHR_external_semaphore_capabilities\0";
pub const VK_KHR_external_semaphore: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME: &[u8; 26usize] = b"VK_KHR_external_semaphore\0";
pub const VK_KHR_external_semaphore_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_KHR_external_semaphore_fd\0";
pub const VK_KHR_push_descriptor: u32 = 1;
pub const VK_KHR_PUSH_DESCRIPTOR_SPEC_VERSION: u32 = 2;
pub const VK_KHR_PUSH_DESCRIPTOR_EXTENSION_NAME: &[u8; 23usize] = b"VK_KHR_push_descriptor\0";
pub const VK_KHR_shader_float16_int8: u32 = 1;
pub const VK_KHR_SHADER_FLOAT16_INT8_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_FLOAT16_INT8_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_KHR_shader_float16_int8\0";
pub const VK_KHR_16bit_storage: u32 = 1;
pub const VK_KHR_16BIT_STORAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_16BIT_STORAGE_EXTENSION_NAME: &[u8; 21usize] = b"VK_KHR_16bit_storage\0";
pub const VK_KHR_incremental_present: u32 = 1;
pub const VK_KHR_INCREMENTAL_PRESENT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_INCREMENTAL_PRESENT_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_KHR_incremental_present\0";
pub const VK_KHR_descriptor_update_template: u32 = 1;
pub const VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME: &[u8; 34usize] =
    b"VK_KHR_descriptor_update_template\0";
pub const VK_KHR_imageless_framebuffer: u32 = 1;
pub const VK_KHR_IMAGELESS_FRAMEBUFFER_SPEC_VERSION: u32 = 1;
pub const VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_KHR_imageless_framebuffer\0";
pub const VK_KHR_create_renderpass2: u32 = 1;
pub const VK_KHR_CREATE_RENDERPASS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_CREATE_RENDERPASS_2_EXTENSION_NAME: &[u8; 26usize] =
    b"VK_KHR_create_renderpass2\0";
pub const VK_KHR_shared_presentable_image: u32 = 1;
pub const VK_KHR_SHARED_PRESENTABLE_IMAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHARED_PRESENTABLE_IMAGE_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_KHR_shared_presentable_image\0";
pub const VK_KHR_external_fence_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_CAPABILITIES_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_KHR_external_fence_capabilities\0";
pub const VK_KHR_external_fence: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_EXTENSION_NAME: &[u8; 22usize] = b"VK_KHR_external_fence\0";
pub const VK_KHR_external_fence_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME: &[u8; 25usize] = b"VK_KHR_external_fence_fd\0";
pub const VK_KHR_performance_query: u32 = 1;
pub const VK_KHR_PERFORMANCE_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PERFORMANCE_QUERY_EXTENSION_NAME: &[u8; 25usize] = b"VK_KHR_performance_query\0";
pub const VK_KHR_maintenance2: u32 = 1;
pub const VK_KHR_MAINTENANCE2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE2_EXTENSION_NAME: &[u8; 20usize] = b"VK_KHR_maintenance2\0";
pub const VK_KHR_get_surface_capabilities2: u32 = 1;
pub const VK_KHR_GET_SURFACE_CAPABILITIES_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_SURFACE_CAPABILITIES_2_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_KHR_get_surface_capabilities2\0";
pub const VK_KHR_variable_pointers: u32 = 1;
pub const VK_KHR_VARIABLE_POINTERS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_VARIABLE_POINTERS_EXTENSION_NAME: &[u8; 25usize] = b"VK_KHR_variable_pointers\0";
pub const VK_KHR_get_display_properties2: u32 = 1;
pub const VK_KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME: &[u8; 31usize] =
    b"VK_KHR_get_display_properties2\0";
pub const VK_KHR_dedicated_allocation: u32 = 1;
pub const VK_KHR_DEDICATED_ALLOCATION_SPEC_VERSION: u32 = 3;
pub const VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_KHR_dedicated_allocation\0";
pub const VK_KHR_storage_buffer_storage_class: u32 = 1;
pub const VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_EXTENSION_NAME: &[u8; 36usize] =
    b"VK_KHR_storage_buffer_storage_class\0";
pub const VK_KHR_relaxed_block_layout: u32 = 1;
pub const VK_KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RELAXED_BLOCK_LAYOUT_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_KHR_relaxed_block_layout\0";
pub const VK_KHR_get_memory_requirements2: u32 = 1;
pub const VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_KHR_get_memory_requirements2\0";
pub const VK_KHR_image_format_list: u32 = 1;
pub const VK_KHR_IMAGE_FORMAT_LIST_SPEC_VERSION: u32 = 1;
pub const VK_KHR_IMAGE_FORMAT_LIST_EXTENSION_NAME: &[u8; 25usize] = b"VK_KHR_image_format_list\0";
pub const VK_KHR_sampler_ycbcr_conversion: u32 = 1;
pub const VK_KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION: u32 = 14;
pub const VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_KHR_sampler_ycbcr_conversion\0";
pub const VK_KHR_bind_memory2: u32 = 1;
pub const VK_KHR_BIND_MEMORY_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_BIND_MEMORY_2_EXTENSION_NAME: &[u8; 20usize] = b"VK_KHR_bind_memory2\0";
pub const VK_KHR_maintenance3: u32 = 1;
pub const VK_KHR_MAINTENANCE3_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE3_EXTENSION_NAME: &[u8; 20usize] = b"VK_KHR_maintenance3\0";
pub const VK_KHR_draw_indirect_count: u32 = 1;
pub const VK_KHR_DRAW_INDIRECT_COUNT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DRAW_INDIRECT_COUNT_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_KHR_draw_indirect_count\0";
pub const VK_KHR_shader_subgroup_extended_types: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION_NAME: &[u8; 38usize] =
    b"VK_KHR_shader_subgroup_extended_types\0";
pub const VK_KHR_8bit_storage: u32 = 1;
pub const VK_KHR_8BIT_STORAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_8BIT_STORAGE_EXTENSION_NAME: &[u8; 20usize] = b"VK_KHR_8bit_storage\0";
pub const VK_KHR_shader_atomic_int64: u32 = 1;
pub const VK_KHR_SHADER_ATOMIC_INT64_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_ATOMIC_INT64_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_KHR_shader_atomic_int64\0";
pub const VK_KHR_shader_clock: u32 = 1;
pub const VK_KHR_SHADER_CLOCK_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_CLOCK_EXTENSION_NAME: &[u8; 20usize] = b"VK_KHR_shader_clock\0";
pub const VK_KHR_driver_properties: u32 = 1;
pub const VK_KHR_DRIVER_PROPERTIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DRIVER_PROPERTIES_EXTENSION_NAME: &[u8; 25usize] = b"VK_KHR_driver_properties\0";
pub const VK_MAX_DRIVER_NAME_SIZE_KHR: u32 = 256;
pub const VK_MAX_DRIVER_INFO_SIZE_KHR: u32 = 256;
pub const VK_KHR_shader_float_controls: u32 = 1;
pub const VK_KHR_SHADER_FLOAT_CONTROLS_SPEC_VERSION: u32 = 4;
pub const VK_KHR_SHADER_FLOAT_CONTROLS_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_KHR_shader_float_controls\0";
pub const VK_KHR_depth_stencil_resolve: u32 = 1;
pub const VK_KHR_DEPTH_STENCIL_RESOLVE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_KHR_depth_stencil_resolve\0";
pub const VK_KHR_swapchain_mutable_format: u32 = 1;
pub const VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_KHR_swapchain_mutable_format\0";
pub const VK_KHR_timeline_semaphore: u32 = 1;
pub const VK_KHR_TIMELINE_SEMAPHORE_SPEC_VERSION: u32 = 2;
pub const VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME: &[u8; 26usize] = b"VK_KHR_timeline_semaphore\0";
pub const VK_KHR_vulkan_memory_model: u32 = 1;
pub const VK_KHR_VULKAN_MEMORY_MODEL_SPEC_VERSION: u32 = 3;
pub const VK_KHR_VULKAN_MEMORY_MODEL_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_KHR_vulkan_memory_model\0";
pub const VK_KHR_shader_terminate_invocation: u32 = 1;
pub const VK_KHR_SHADER_TERMINATE_INVOCATION_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_TERMINATE_INVOCATION_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_KHR_shader_terminate_invocation\0";
pub const VK_KHR_fragment_shading_rate: u32 = 1;
pub const VK_KHR_FRAGMENT_SHADING_RATE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_FRAGMENT_SHADING_RATE_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_KHR_fragment_shading_rate\0";
pub const VK_KHR_spirv_1_4: u32 = 1;
pub const VK_KHR_SPIRV_1_4_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SPIRV_1_4_EXTENSION_NAME: &[u8; 17usize] = b"VK_KHR_spirv_1_4\0";
pub const VK_KHR_surface_protected_capabilities: u32 = 1;
pub const VK_KHR_SURFACE_PROTECTED_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SURFACE_PROTECTED_CAPABILITIES_EXTENSION_NAME: &[u8; 38usize] =
    b"VK_KHR_surface_protected_capabilities\0";
pub const VK_KHR_separate_depth_stencil_layouts: u32 = 1;
pub const VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME: &[u8; 38usize] =
    b"VK_KHR_separate_depth_stencil_layouts\0";
pub const VK_KHR_uniform_buffer_standard_layout: u32 = 1;
pub const VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION_NAME: &[u8; 38usize] =
    b"VK_KHR_uniform_buffer_standard_layout\0";
pub const VK_KHR_buffer_device_address: u32 = 1;
pub const VK_KHR_BUFFER_DEVICE_ADDRESS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_KHR_buffer_device_address\0";
pub const VK_KHR_deferred_host_operations: u32 = 1;
pub const VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION: u32 = 4;
pub const VK_KHR_DEFERRED_HOST_OPERATIONS_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_KHR_deferred_host_operations\0";
pub const VK_KHR_pipeline_executable_properties: u32 = 1;
pub const VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_EXTENSION_NAME: &[u8; 38usize] =
    b"VK_KHR_pipeline_executable_properties\0";
pub const VK_KHR_pipeline_library: u32 = 1;
pub const VK_KHR_PIPELINE_LIBRARY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PIPELINE_LIBRARY_EXTENSION_NAME: &[u8; 24usize] = b"VK_KHR_pipeline_library\0";
pub const VK_KHR_shader_non_semantic_info: u32 = 1;
pub const VK_KHR_SHADER_NON_SEMANTIC_INFO_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_NON_SEMANTIC_INFO_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_KHR_shader_non_semantic_info\0";
pub const VK_KHR_synchronization2: u32 = 1;
pub const VK_KHR_SYNCHRONIZATION_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME: &[u8; 24usize] = b"VK_KHR_synchronization2\0";
pub const VK_KHR_zero_initialize_workgroup_memory: u32 = 1;
pub const VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION_NAME: &[u8; 40usize] =
    b"VK_KHR_zero_initialize_workgroup_memory\0";
pub const VK_KHR_workgroup_memory_explicit_layout: u32 = 1;
pub const VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_EXTENSION_NAME: &[u8; 40usize] =
    b"VK_KHR_workgroup_memory_explicit_layout\0";
pub const VK_KHR_copy_commands2: u32 = 1;
pub const VK_KHR_COPY_COMMANDS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_COPY_COMMANDS_2_EXTENSION_NAME: &[u8; 22usize] = b"VK_KHR_copy_commands2\0";
pub const VK_EXT_debug_report: u32 = 1;
pub const VK_EXT_DEBUG_REPORT_SPEC_VERSION: u32 = 9;
pub const VK_EXT_DEBUG_REPORT_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_debug_report\0";
pub const VK_NV_glsl_shader: u32 = 1;
pub const VK_NV_GLSL_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_NV_GLSL_SHADER_EXTENSION_NAME: &[u8; 18usize] = b"VK_NV_glsl_shader\0";
pub const VK_EXT_depth_range_unrestricted: u32 = 1;
pub const VK_EXT_DEPTH_RANGE_UNRESTRICTED_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DEPTH_RANGE_UNRESTRICTED_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_EXT_depth_range_unrestricted\0";
pub const VK_IMG_filter_cubic: u32 = 1;
pub const VK_IMG_FILTER_CUBIC_SPEC_VERSION: u32 = 1;
pub const VK_IMG_FILTER_CUBIC_EXTENSION_NAME: &[u8; 20usize] = b"VK_IMG_filter_cubic\0";
pub const VK_AMD_rasterization_order: u32 = 1;
pub const VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_RASTERIZATION_ORDER_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_AMD_rasterization_order\0";
pub const VK_AMD_shader_trinary_minmax: u32 = 1;
pub const VK_AMD_SHADER_TRINARY_MINMAX_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_TRINARY_MINMAX_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_AMD_shader_trinary_minmax\0";
pub const VK_AMD_shader_explicit_vertex_parameter: u32 = 1;
pub const VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_EXTENSION_NAME: &[u8; 40usize] =
    b"VK_AMD_shader_explicit_vertex_parameter\0";
pub const VK_EXT_debug_marker: u32 = 1;
pub const VK_EXT_DEBUG_MARKER_SPEC_VERSION: u32 = 4;
pub const VK_EXT_DEBUG_MARKER_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_debug_marker\0";
pub const VK_AMD_gcn_shader: u32 = 1;
pub const VK_AMD_GCN_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_GCN_SHADER_EXTENSION_NAME: &[u8; 18usize] = b"VK_AMD_gcn_shader\0";
pub const VK_NV_dedicated_allocation: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_NV_dedicated_allocation\0";
pub const VK_EXT_transform_feedback: u32 = 1;
pub const VK_EXT_TRANSFORM_FEEDBACK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TRANSFORM_FEEDBACK_EXTENSION_NAME: &[u8; 26usize] = b"VK_EXT_transform_feedback\0";
pub const VK_NVX_image_view_handle: u32 = 1;
pub const VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION: u32 = 2;
pub const VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME: &[u8; 25usize] = b"VK_NVX_image_view_handle\0";
pub const VK_AMD_draw_indirect_count: u32 = 1;
pub const VK_AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION: u32 = 2;
pub const VK_AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_AMD_draw_indirect_count\0";
pub const VK_AMD_negative_viewport_height: u32 = 1;
pub const VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_SPEC_VERSION: u32 = 1;
pub const VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_AMD_negative_viewport_height\0";
pub const VK_AMD_gpu_shader_half_float: u32 = 1;
pub const VK_AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION: u32 = 2;
pub const VK_AMD_GPU_SHADER_HALF_FLOAT_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_AMD_gpu_shader_half_float\0";
pub const VK_AMD_shader_ballot: u32 = 1;
pub const VK_AMD_SHADER_BALLOT_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_BALLOT_EXTENSION_NAME: &[u8; 21usize] = b"VK_AMD_shader_ballot\0";
pub const VK_AMD_texture_gather_bias_lod: u32 = 1;
pub const VK_AMD_TEXTURE_GATHER_BIAS_LOD_SPEC_VERSION: u32 = 1;
pub const VK_AMD_TEXTURE_GATHER_BIAS_LOD_EXTENSION_NAME: &[u8; 31usize] =
    b"VK_AMD_texture_gather_bias_lod\0";
pub const VK_AMD_shader_info: u32 = 1;
pub const VK_AMD_SHADER_INFO_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_INFO_EXTENSION_NAME: &[u8; 19usize] = b"VK_AMD_shader_info\0";
pub const VK_AMD_shader_image_load_store_lod: u32 = 1;
pub const VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_AMD_shader_image_load_store_lod\0";
pub const VK_NV_corner_sampled_image: u32 = 1;
pub const VK_NV_CORNER_SAMPLED_IMAGE_SPEC_VERSION: u32 = 2;
pub const VK_NV_CORNER_SAMPLED_IMAGE_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_NV_corner_sampled_image\0";
pub const VK_IMG_format_pvrtc: u32 = 1;
pub const VK_IMG_FORMAT_PVRTC_SPEC_VERSION: u32 = 1;
pub const VK_IMG_FORMAT_PVRTC_EXTENSION_NAME: &[u8; 20usize] = b"VK_IMG_format_pvrtc\0";
pub const VK_NV_external_memory_capabilities: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_NV_external_memory_capabilities\0";
pub const VK_NV_external_memory: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_EXTENSION_NAME: &[u8; 22usize] = b"VK_NV_external_memory\0";
pub const VK_EXT_validation_flags: u32 = 1;
pub const VK_EXT_VALIDATION_FLAGS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_VALIDATION_FLAGS_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_validation_flags\0";
pub const VK_EXT_shader_subgroup_ballot: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_BALLOT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_BALLOT_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_EXT_shader_subgroup_ballot\0";
pub const VK_EXT_shader_subgroup_vote: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_VOTE_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_EXT_shader_subgroup_vote\0";
pub const VK_EXT_texture_compression_astc_hdr: u32 = 1;
pub const VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME: &[u8; 36usize] =
    b"VK_EXT_texture_compression_astc_hdr\0";
pub const VK_EXT_astc_decode_mode: u32 = 1;
pub const VK_EXT_ASTC_DECODE_MODE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ASTC_DECODE_MODE_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_astc_decode_mode\0";
pub const VK_EXT_conditional_rendering: u32 = 1;
pub const VK_EXT_CONDITIONAL_RENDERING_SPEC_VERSION: u32 = 2;
pub const VK_EXT_CONDITIONAL_RENDERING_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_EXT_conditional_rendering\0";
pub const VK_NV_clip_space_w_scaling: u32 = 1;
pub const VK_NV_CLIP_SPACE_W_SCALING_SPEC_VERSION: u32 = 1;
pub const VK_NV_CLIP_SPACE_W_SCALING_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_NV_clip_space_w_scaling\0";
pub const VK_EXT_direct_mode_display: u32 = 1;
pub const VK_EXT_DIRECT_MODE_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DIRECT_MODE_DISPLAY_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_EXT_direct_mode_display\0";
pub const VK_EXT_display_surface_counter: u32 = 1;
pub const VK_EXT_DISPLAY_SURFACE_COUNTER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISPLAY_SURFACE_COUNTER_EXTENSION_NAME: &[u8; 31usize] =
    b"VK_EXT_display_surface_counter\0";
pub const VK_EXT_display_control: u32 = 1;
pub const VK_EXT_DISPLAY_CONTROL_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISPLAY_CONTROL_EXTENSION_NAME: &[u8; 23usize] = b"VK_EXT_display_control\0";
pub const VK_GOOGLE_display_timing: u32 = 1;
pub const VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME: &[u8; 25usize] = b"VK_GOOGLE_display_timing\0";
pub const VK_NV_sample_mask_override_coverage: u32 = 1;
pub const VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_SPEC_VERSION: u32 = 1;
pub const VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_EXTENSION_NAME: &[u8; 36usize] =
    b"VK_NV_sample_mask_override_coverage\0";
pub const VK_NV_geometry_shader_passthrough: u32 = 1;
pub const VK_NV_GEOMETRY_SHADER_PASSTHROUGH_SPEC_VERSION: u32 = 1;
pub const VK_NV_GEOMETRY_SHADER_PASSTHROUGH_EXTENSION_NAME: &[u8; 34usize] =
    b"VK_NV_geometry_shader_passthrough\0";
pub const VK_NV_viewport_array2: u32 = 1;
pub const VK_NV_VIEWPORT_ARRAY2_SPEC_VERSION: u32 = 1;
pub const VK_NV_VIEWPORT_ARRAY2_EXTENSION_NAME: &[u8; 22usize] = b"VK_NV_viewport_array2\0";
pub const VK_NVX_multiview_per_view_attributes: u32 = 1;
pub const VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_SPEC_VERSION: u32 = 1;
pub const VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_EXTENSION_NAME: &[u8; 37usize] =
    b"VK_NVX_multiview_per_view_attributes\0";
pub const VK_NV_viewport_swizzle: u32 = 1;
pub const VK_NV_VIEWPORT_SWIZZLE_SPEC_VERSION: u32 = 1;
pub const VK_NV_VIEWPORT_SWIZZLE_EXTENSION_NAME: &[u8; 23usize] = b"VK_NV_viewport_swizzle\0";
pub const VK_EXT_discard_rectangles: u32 = 1;
pub const VK_EXT_DISCARD_RECTANGLES_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISCARD_RECTANGLES_EXTENSION_NAME: &[u8; 26usize] = b"VK_EXT_discard_rectangles\0";
pub const VK_EXT_conservative_rasterization: u32 = 1;
pub const VK_EXT_CONSERVATIVE_RASTERIZATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_CONSERVATIVE_RASTERIZATION_EXTENSION_NAME: &[u8; 34usize] =
    b"VK_EXT_conservative_rasterization\0";
pub const VK_EXT_depth_clip_enable: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_ENABLE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_ENABLE_EXTENSION_NAME: &[u8; 25usize] = b"VK_EXT_depth_clip_enable\0";
pub const VK_EXT_swapchain_colorspace: u32 = 1;
pub const VK_EXT_SWAPCHAIN_COLOR_SPACE_SPEC_VERSION: u32 = 4;
pub const VK_EXT_SWAPCHAIN_COLOR_SPACE_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_EXT_swapchain_colorspace\0";
pub const VK_EXT_hdr_metadata: u32 = 1;
pub const VK_EXT_HDR_METADATA_SPEC_VERSION: u32 = 2;
pub const VK_EXT_HDR_METADATA_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_hdr_metadata\0";
pub const VK_EXT_external_memory_dma_buf: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_DMA_BUF_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_DMA_BUF_EXTENSION_NAME: &[u8; 31usize] =
    b"VK_EXT_external_memory_dma_buf\0";
pub const VK_EXT_queue_family_foreign: u32 = 1;
pub const VK_EXT_QUEUE_FAMILY_FOREIGN_SPEC_VERSION: u32 = 1;
pub const VK_EXT_QUEUE_FAMILY_FOREIGN_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_EXT_queue_family_foreign\0";
pub const VK_QUEUE_FAMILY_FOREIGN_EXT: i32 = -3;
pub const VK_EXT_debug_utils: u32 = 1;
pub const VK_EXT_DEBUG_UTILS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DEBUG_UTILS_EXTENSION_NAME: &[u8; 19usize] = b"VK_EXT_debug_utils\0";
pub const VK_EXT_sampler_filter_minmax: u32 = 1;
pub const VK_EXT_SAMPLER_FILTER_MINMAX_SPEC_VERSION: u32 = 2;
pub const VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_EXT_sampler_filter_minmax\0";
pub const VK_AMD_gpu_shader_int16: u32 = 1;
pub const VK_AMD_GPU_SHADER_INT16_SPEC_VERSION: u32 = 2;
pub const VK_AMD_GPU_SHADER_INT16_EXTENSION_NAME: &[u8; 24usize] = b"VK_AMD_gpu_shader_int16\0";
pub const VK_AMD_mixed_attachment_samples: u32 = 1;
pub const VK_AMD_MIXED_ATTACHMENT_SAMPLES_SPEC_VERSION: u32 = 1;
pub const VK_AMD_MIXED_ATTACHMENT_SAMPLES_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_AMD_mixed_attachment_samples\0";
pub const VK_AMD_shader_fragment_mask: u32 = 1;
pub const VK_AMD_SHADER_FRAGMENT_MASK_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_FRAGMENT_MASK_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_AMD_shader_fragment_mask\0";
pub const VK_EXT_inline_uniform_block: u32 = 1;
pub const VK_EXT_INLINE_UNIFORM_BLOCK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_EXT_inline_uniform_block\0";
pub const VK_EXT_shader_stencil_export: u32 = 1;
pub const VK_EXT_SHADER_STENCIL_EXPORT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_STENCIL_EXPORT_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_EXT_shader_stencil_export\0";
pub const VK_EXT_sample_locations: u32 = 1;
pub const VK_EXT_SAMPLE_LOCATIONS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SAMPLE_LOCATIONS_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_sample_locations\0";
pub const VK_EXT_blend_operation_advanced: u32 = 1;
pub const VK_EXT_BLEND_OPERATION_ADVANCED_SPEC_VERSION: u32 = 2;
pub const VK_EXT_BLEND_OPERATION_ADVANCED_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_EXT_blend_operation_advanced\0";
pub const VK_NV_fragment_coverage_to_color: u32 = 1;
pub const VK_NV_FRAGMENT_COVERAGE_TO_COLOR_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_COVERAGE_TO_COLOR_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_NV_fragment_coverage_to_color\0";
pub const VK_NV_framebuffer_mixed_samples: u32 = 1;
pub const VK_NV_FRAMEBUFFER_MIXED_SAMPLES_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAMEBUFFER_MIXED_SAMPLES_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_NV_framebuffer_mixed_samples\0";
pub const VK_NV_fill_rectangle: u32 = 1;
pub const VK_NV_FILL_RECTANGLE_SPEC_VERSION: u32 = 1;
pub const VK_NV_FILL_RECTANGLE_EXTENSION_NAME: &[u8; 21usize] = b"VK_NV_fill_rectangle\0";
pub const VK_NV_shader_sm_builtins: u32 = 1;
pub const VK_NV_SHADER_SM_BUILTINS_SPEC_VERSION: u32 = 1;
pub const VK_NV_SHADER_SM_BUILTINS_EXTENSION_NAME: &[u8; 25usize] = b"VK_NV_shader_sm_builtins\0";
pub const VK_EXT_post_depth_coverage: u32 = 1;
pub const VK_EXT_POST_DEPTH_COVERAGE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_POST_DEPTH_COVERAGE_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_EXT_post_depth_coverage\0";
pub const VK_EXT_image_drm_format_modifier: u32 = 1;
pub const VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_EXT_image_drm_format_modifier\0";
pub const VK_EXT_validation_cache: u32 = 1;
pub const VK_EXT_VALIDATION_CACHE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_VALIDATION_CACHE_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_validation_cache\0";
pub const VK_EXT_descriptor_indexing: u32 = 1;
pub const VK_EXT_DESCRIPTOR_INDEXING_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_EXT_descriptor_indexing\0";
pub const VK_EXT_shader_viewport_index_layer: u32 = 1;
pub const VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_EXT_shader_viewport_index_layer\0";
pub const VK_NV_shading_rate_image: u32 = 1;
pub const VK_NV_SHADING_RATE_IMAGE_SPEC_VERSION: u32 = 3;
pub const VK_NV_SHADING_RATE_IMAGE_EXTENSION_NAME: &[u8; 25usize] = b"VK_NV_shading_rate_image\0";
pub const VK_NV_ray_tracing: u32 = 1;
pub const VK_NV_RAY_TRACING_SPEC_VERSION: u32 = 3;
pub const VK_NV_RAY_TRACING_EXTENSION_NAME: &[u8; 18usize] = b"VK_NV_ray_tracing\0";
pub const VK_SHADER_UNUSED_KHR: i32 = -1;
pub const VK_SHADER_UNUSED_NV: i32 = -1;
pub const VK_NV_representative_fragment_test: u32 = 1;
pub const VK_NV_REPRESENTATIVE_FRAGMENT_TEST_SPEC_VERSION: u32 = 2;
pub const VK_NV_REPRESENTATIVE_FRAGMENT_TEST_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_NV_representative_fragment_test\0";
pub const VK_EXT_filter_cubic: u32 = 1;
pub const VK_EXT_FILTER_CUBIC_SPEC_VERSION: u32 = 3;
pub const VK_EXT_FILTER_CUBIC_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_filter_cubic\0";
pub const VK_QCOM_render_pass_shader_resolve: u32 = 1;
pub const VK_QCOM_RENDER_PASS_SHADER_RESOLVE_SPEC_VERSION: u32 = 4;
pub const VK_QCOM_RENDER_PASS_SHADER_RESOLVE_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_QCOM_render_pass_shader_resolve\0";
pub const VK_EXT_global_priority: u32 = 1;
pub const VK_EXT_GLOBAL_PRIORITY_SPEC_VERSION: u32 = 2;
pub const VK_EXT_GLOBAL_PRIORITY_EXTENSION_NAME: &[u8; 23usize] = b"VK_EXT_global_priority\0";
pub const VK_EXT_external_memory_host: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_HOST_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_HOST_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_EXT_external_memory_host\0";
pub const VK_AMD_buffer_marker: u32 = 1;
pub const VK_AMD_BUFFER_MARKER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_BUFFER_MARKER_EXTENSION_NAME: &[u8; 21usize] = b"VK_AMD_buffer_marker\0";
pub const VK_AMD_pipeline_compiler_control: u32 = 1;
pub const VK_AMD_PIPELINE_COMPILER_CONTROL_SPEC_VERSION: u32 = 1;
pub const VK_AMD_PIPELINE_COMPILER_CONTROL_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_AMD_pipeline_compiler_control\0";
pub const VK_EXT_calibrated_timestamps: u32 = 1;
pub const VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_CALIBRATED_TIMESTAMPS_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_EXT_calibrated_timestamps\0";
pub const VK_AMD_shader_core_properties: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_SPEC_VERSION: u32 = 2;
pub const VK_AMD_SHADER_CORE_PROPERTIES_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_AMD_shader_core_properties\0";
pub const VK_AMD_memory_overallocation_behavior: u32 = 1;
pub const VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_SPEC_VERSION: u32 = 1;
pub const VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_EXTENSION_NAME: &[u8; 38usize] =
    b"VK_AMD_memory_overallocation_behavior\0";
pub const VK_EXT_vertex_attribute_divisor: u32 = 1;
pub const VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION: u32 = 3;
pub const VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_EXT_vertex_attribute_divisor\0";
pub const VK_EXT_pipeline_creation_feedback: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_FEEDBACK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION_NAME: &[u8; 34usize] =
    b"VK_EXT_pipeline_creation_feedback\0";
pub const VK_NV_shader_subgroup_partitioned: u32 = 1;
pub const VK_NV_SHADER_SUBGROUP_PARTITIONED_SPEC_VERSION: u32 = 1;
pub const VK_NV_SHADER_SUBGROUP_PARTITIONED_EXTENSION_NAME: &[u8; 34usize] =
    b"VK_NV_shader_subgroup_partitioned\0";
pub const VK_NV_compute_shader_derivatives: u32 = 1;
pub const VK_NV_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION: u32 = 1;
pub const VK_NV_COMPUTE_SHADER_DERIVATIVES_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_NV_compute_shader_derivatives\0";
pub const VK_NV_mesh_shader: u32 = 1;
pub const VK_NV_MESH_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_NV_MESH_SHADER_EXTENSION_NAME: &[u8; 18usize] = b"VK_NV_mesh_shader\0";
pub const VK_NV_fragment_shader_barycentric: u32 = 1;
pub const VK_NV_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION_NAME: &[u8; 34usize] =
    b"VK_NV_fragment_shader_barycentric\0";
pub const VK_NV_shader_image_footprint: u32 = 1;
pub const VK_NV_SHADER_IMAGE_FOOTPRINT_SPEC_VERSION: u32 = 2;
pub const VK_NV_SHADER_IMAGE_FOOTPRINT_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_NV_shader_image_footprint\0";
pub const VK_NV_scissor_exclusive: u32 = 1;
pub const VK_NV_SCISSOR_EXCLUSIVE_SPEC_VERSION: u32 = 1;
pub const VK_NV_SCISSOR_EXCLUSIVE_EXTENSION_NAME: &[u8; 24usize] = b"VK_NV_scissor_exclusive\0";
pub const VK_NV_device_diagnostic_checkpoints: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION: u32 = 2;
pub const VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME: &[u8; 36usize] =
    b"VK_NV_device_diagnostic_checkpoints\0";
pub const VK_INTEL_shader_integer_functions2: u32 = 1;
pub const VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_SPEC_VERSION: u32 = 1;
pub const VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_EXTENSION_NAME: &[u8; 35usize] =
    b"VK_INTEL_shader_integer_functions2\0";
pub const VK_INTEL_performance_query: u32 = 1;
pub const VK_INTEL_PERFORMANCE_QUERY_SPEC_VERSION: u32 = 2;
pub const VK_INTEL_PERFORMANCE_QUERY_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_INTEL_performance_query\0";
pub const VK_EXT_pci_bus_info: u32 = 1;
pub const VK_EXT_PCI_BUS_INFO_SPEC_VERSION: u32 = 2;
pub const VK_EXT_PCI_BUS_INFO_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_pci_bus_info\0";
pub const VK_AMD_display_native_hdr: u32 = 1;
pub const VK_AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION: u32 = 1;
pub const VK_AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME: &[u8; 26usize] = b"VK_AMD_display_native_hdr\0";
pub const VK_EXT_fragment_density_map: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_EXT_fragment_density_map\0";
pub const VK_EXT_scalar_block_layout: u32 = 1;
pub const VK_EXT_SCALAR_BLOCK_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SCALAR_BLOCK_LAYOUT_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_EXT_scalar_block_layout\0";
pub const VK_GOOGLE_hlsl_functionality1: u32 = 1;
pub const VK_GOOGLE_HLSL_FUNCTIONALITY1_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_HLSL_FUNCTIONALITY1_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_GOOGLE_hlsl_functionality1\0";
pub const VK_GOOGLE_decorate_string: u32 = 1;
pub const VK_GOOGLE_DECORATE_STRING_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_DECORATE_STRING_EXTENSION_NAME: &[u8; 26usize] = b"VK_GOOGLE_decorate_string\0";
pub const VK_EXT_subgroup_size_control: u32 = 1;
pub const VK_EXT_SUBGROUP_SIZE_CONTROL_SPEC_VERSION: u32 = 2;
pub const VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_EXT_subgroup_size_control\0";
pub const VK_AMD_shader_core_properties2: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_2_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_2_EXTENSION_NAME: &[u8; 31usize] =
    b"VK_AMD_shader_core_properties2\0";
pub const VK_AMD_device_coherent_memory: u32 = 1;
pub const VK_AMD_DEVICE_COHERENT_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_AMD_DEVICE_COHERENT_MEMORY_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_AMD_device_coherent_memory\0";
pub const VK_EXT_shader_image_atomic_int64: u32 = 1;
pub const VK_EXT_SHADER_IMAGE_ATOMIC_INT64_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_IMAGE_ATOMIC_INT64_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_EXT_shader_image_atomic_int64\0";
pub const VK_EXT_memory_budget: u32 = 1;
pub const VK_EXT_MEMORY_BUDGET_SPEC_VERSION: u32 = 1;
pub const VK_EXT_MEMORY_BUDGET_EXTENSION_NAME: &[u8; 21usize] = b"VK_EXT_memory_budget\0";
pub const VK_EXT_memory_priority: u32 = 1;
pub const VK_EXT_MEMORY_PRIORITY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_MEMORY_PRIORITY_EXTENSION_NAME: &[u8; 23usize] = b"VK_EXT_memory_priority\0";
pub const VK_NV_dedicated_allocation_image_aliasing: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_EXTENSION_NAME: &[u8; 42usize] =
    b"VK_NV_dedicated_allocation_image_aliasing\0";
pub const VK_EXT_buffer_device_address: u32 = 1;
pub const VK_EXT_BUFFER_DEVICE_ADDRESS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_EXT_buffer_device_address\0";
pub const VK_EXT_tooling_info: u32 = 1;
pub const VK_EXT_TOOLING_INFO_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TOOLING_INFO_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_tooling_info\0";
pub const VK_EXT_separate_stencil_usage: u32 = 1;
pub const VK_EXT_SEPARATE_STENCIL_USAGE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SEPARATE_STENCIL_USAGE_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_EXT_separate_stencil_usage\0";
pub const VK_EXT_validation_features: u32 = 1;
pub const VK_EXT_VALIDATION_FEATURES_SPEC_VERSION: u32 = 4;
pub const VK_EXT_VALIDATION_FEATURES_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_EXT_validation_features\0";
pub const VK_NV_cooperative_matrix: u32 = 1;
pub const VK_NV_COOPERATIVE_MATRIX_SPEC_VERSION: u32 = 1;
pub const VK_NV_COOPERATIVE_MATRIX_EXTENSION_NAME: &[u8; 25usize] = b"VK_NV_cooperative_matrix\0";
pub const VK_NV_coverage_reduction_mode: u32 = 1;
pub const VK_NV_COVERAGE_REDUCTION_MODE_SPEC_VERSION: u32 = 1;
pub const VK_NV_COVERAGE_REDUCTION_MODE_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_NV_coverage_reduction_mode\0";
pub const VK_EXT_fragment_shader_interlock: u32 = 1;
pub const VK_EXT_FRAGMENT_SHADER_INTERLOCK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_SHADER_INTERLOCK_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_EXT_fragment_shader_interlock\0";
pub const VK_EXT_ycbcr_image_arrays: u32 = 1;
pub const VK_EXT_YCBCR_IMAGE_ARRAYS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_YCBCR_IMAGE_ARRAYS_EXTENSION_NAME: &[u8; 26usize] = b"VK_EXT_ycbcr_image_arrays\0";
pub const VK_EXT_headless_surface: u32 = 1;
pub const VK_EXT_HEADLESS_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_HEADLESS_SURFACE_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_headless_surface\0";
pub const VK_EXT_line_rasterization: u32 = 1;
pub const VK_EXT_LINE_RASTERIZATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_LINE_RASTERIZATION_EXTENSION_NAME: &[u8; 26usize] = b"VK_EXT_line_rasterization\0";
pub const VK_EXT_shader_atomic_float: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_EXT_shader_atomic_float\0";
pub const VK_EXT_host_query_reset: u32 = 1;
pub const VK_EXT_HOST_QUERY_RESET_SPEC_VERSION: u32 = 1;
pub const VK_EXT_HOST_QUERY_RESET_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_host_query_reset\0";
pub const VK_EXT_index_type_uint8: u32 = 1;
pub const VK_EXT_INDEX_TYPE_UINT8_SPEC_VERSION: u32 = 1;
pub const VK_EXT_INDEX_TYPE_UINT8_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_index_type_uint8\0";
pub const VK_EXT_extended_dynamic_state: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_EXT_extended_dynamic_state\0";
pub const VK_EXT_shader_demote_to_helper_invocation: u32 = 1;
pub const VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION_NAME: &[u8; 42usize] =
    b"VK_EXT_shader_demote_to_helper_invocation\0";
pub const VK_NV_device_generated_commands: u32 = 1;
pub const VK_NV_DEVICE_GENERATED_COMMANDS_SPEC_VERSION: u32 = 3;
pub const VK_NV_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_NV_device_generated_commands\0";
pub const VK_EXT_texel_buffer_alignment: u32 = 1;
pub const VK_EXT_TEXEL_BUFFER_ALIGNMENT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_EXT_texel_buffer_alignment\0";
pub const VK_QCOM_render_pass_transform: u32 = 1;
pub const VK_QCOM_RENDER_PASS_TRANSFORM_SPEC_VERSION: u32 = 1;
pub const VK_QCOM_RENDER_PASS_TRANSFORM_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_QCOM_render_pass_transform\0";
pub const VK_EXT_device_memory_report: u32 = 1;
pub const VK_EXT_DEVICE_MEMORY_REPORT_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DEVICE_MEMORY_REPORT_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_EXT_device_memory_report\0";
pub const VK_EXT_robustness2: u32 = 1;
pub const VK_EXT_ROBUSTNESS_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ROBUSTNESS_2_EXTENSION_NAME: &[u8; 19usize] = b"VK_EXT_robustness2\0";
pub const VK_EXT_custom_border_color: u32 = 1;
pub const VK_EXT_CUSTOM_BORDER_COLOR_SPEC_VERSION: u32 = 12;
pub const VK_EXT_CUSTOM_BORDER_COLOR_EXTENSION_NAME: &[u8; 27usize] =
    b"VK_EXT_custom_border_color\0";
pub const VK_GOOGLE_user_type: u32 = 1;
pub const VK_GOOGLE_USER_TYPE_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_USER_TYPE_EXTENSION_NAME: &[u8; 20usize] = b"VK_GOOGLE_user_type\0";
pub const VK_EXT_private_data: u32 = 1;
pub const VK_EXT_PRIVATE_DATA_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PRIVATE_DATA_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_private_data\0";
pub const VK_EXT_pipeline_creation_cache_control: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_SPEC_VERSION: u32 = 3;
pub const VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION_NAME: &[u8; 39usize] =
    b"VK_EXT_pipeline_creation_cache_control\0";
pub const VK_NV_device_diagnostics_config: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTICS_CONFIG_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTICS_CONFIG_EXTENSION_NAME: &[u8; 32usize] =
    b"VK_NV_device_diagnostics_config\0";
pub const VK_QCOM_render_pass_store_ops: u32 = 1;
pub const VK_QCOM_render_pass_store_ops_SPEC_VERSION: u32 = 2;
pub const VK_QCOM_render_pass_store_ops_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_QCOM_render_pass_store_ops\0";
pub const VK_NV_fragment_shading_rate_enums: u32 = 1;
pub const VK_NV_FRAGMENT_SHADING_RATE_ENUMS_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_SHADING_RATE_ENUMS_EXTENSION_NAME: &[u8; 34usize] =
    b"VK_NV_fragment_shading_rate_enums\0";
pub const VK_EXT_fragment_density_map2: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_2_EXTENSION_NAME: &[u8; 29usize] =
    b"VK_EXT_fragment_density_map2\0";
pub const VK_QCOM_rotated_copy_commands: u32 = 1;
pub const VK_QCOM_ROTATED_COPY_COMMANDS_SPEC_VERSION: u32 = 0;
pub const VK_QCOM_ROTATED_COPY_COMMANDS_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_QCOM_rotated_copy_commands\0";
pub const VK_EXT_image_robustness: u32 = 1;
pub const VK_EXT_IMAGE_ROBUSTNESS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_IMAGE_ROBUSTNESS_EXTENSION_NAME: &[u8; 24usize] = b"VK_EXT_image_robustness\0";
pub const VK_EXT_4444_formats: u32 = 1;
pub const VK_EXT_4444_FORMATS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_4444_FORMATS_EXTENSION_NAME: &[u8; 20usize] = b"VK_EXT_4444_formats\0";
pub const VK_NV_acquire_winrt_display: u32 = 1;
pub const VK_NV_ACQUIRE_WINRT_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_NV_ACQUIRE_WINRT_DISPLAY_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_NV_acquire_winrt_display\0";
pub const VK_VALVE_mutable_descriptor_type: u32 = 1;
pub const VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_SPEC_VERSION: u32 = 1;
pub const VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_EXTENSION_NAME: &[u8; 33usize] =
    b"VK_VALVE_mutable_descriptor_type\0";
pub const VK_KHR_acceleration_structure: u32 = 1;
pub const VK_KHR_ACCELERATION_STRUCTURE_SPEC_VERSION: u32 = 11;
pub const VK_KHR_ACCELERATION_STRUCTURE_EXTENSION_NAME: &[u8; 30usize] =
    b"VK_KHR_acceleration_structure\0";
pub const VK_KHR_ray_tracing_pipeline: u32 = 1;
pub const VK_KHR_RAY_TRACING_PIPELINE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RAY_TRACING_PIPELINE_EXTENSION_NAME: &[u8; 28usize] =
    b"VK_KHR_ray_tracing_pipeline\0";
pub const VK_KHR_ray_query: u32 = 1;
pub const VK_KHR_RAY_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RAY_QUERY_EXTENSION_NAME: &[u8; 17usize] = b"VK_KHR_ray_query\0";
pub const VMA_VULKAN_VERSION: u32 = 1002000;
pub const VMA_DEDICATED_ALLOCATION: u32 = 1;
pub const VMA_BIND_MEMORY2: u32 = 1;
pub const VMA_MEMORY_BUDGET: u32 = 1;
pub const VMA_BUFFER_DEVICE_ADDRESS: u32 = 1;
pub const VMA_MEMORY_PRIORITY: u32 = 1;
pub const VMA_EXTERNAL_MEMORY: u32 = 1;
pub const VMA_STATS_STRING_ENABLED: u32 = 1;
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type VkBool32 = u32;
pub type VkDeviceAddress = u64;
pub type VkDeviceSize = u64;
pub type VkFlags = u32;
pub type VkSampleMask = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBuffer_T {
    _unused: [u8; 0],
}
pub type VkBuffer = *mut VkBuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImage_T {
    _unused: [u8; 0],
}
pub type VkImage = *mut VkImage_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInstance_T {
    _unused: [u8; 0],
}
pub type VkInstance = *mut VkInstance_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice_T {
    _unused: [u8; 0],
}
pub type VkPhysicalDevice = *mut VkPhysicalDevice_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDevice_T {
    _unused: [u8; 0],
}
pub type VkDevice = *mut VkDevice_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueue_T {
    _unused: [u8; 0],
}
pub type VkQueue = *mut VkQueue_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphore_T {
    _unused: [u8; 0],
}
pub type VkSemaphore = *mut VkSemaphore_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBuffer_T {
    _unused: [u8; 0],
}
pub type VkCommandBuffer = *mut VkCommandBuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFence_T {
    _unused: [u8; 0],
}
pub type VkFence = *mut VkFence_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemory_T {
    _unused: [u8; 0],
}
pub type VkDeviceMemory = *mut VkDeviceMemory_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkEvent_T {
    _unused: [u8; 0],
}
pub type VkEvent = *mut VkEvent_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPool_T {
    _unused: [u8; 0],
}
pub type VkQueryPool = *mut VkQueryPool_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferView_T {
    _unused: [u8; 0],
}
pub type VkBufferView = *mut VkBufferView_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageView_T {
    _unused: [u8; 0],
}
pub type VkImageView = *mut VkImageView_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModule_T {
    _unused: [u8; 0],
}
pub type VkShaderModule = *mut VkShaderModule_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCache_T {
    _unused: [u8; 0],
}
pub type VkPipelineCache = *mut VkPipelineCache_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLayout_T {
    _unused: [u8; 0],
}
pub type VkPipelineLayout = *mut VkPipelineLayout_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipeline_T {
    _unused: [u8; 0],
}
pub type VkPipeline = *mut VkPipeline_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPass_T {
    _unused: [u8; 0],
}
pub type VkRenderPass = *mut VkRenderPass_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayout_T {
    _unused: [u8; 0],
}
pub type VkDescriptorSetLayout = *mut VkDescriptorSetLayout_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSampler_T {
    _unused: [u8; 0],
}
pub type VkSampler = *mut VkSampler_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSet_T {
    _unused: [u8; 0],
}
pub type VkDescriptorSet = *mut VkDescriptorSet_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPool_T {
    _unused: [u8; 0],
}
pub type VkDescriptorPool = *mut VkDescriptorPool_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebuffer_T {
    _unused: [u8; 0],
}
pub type VkFramebuffer = *mut VkFramebuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandPool_T {
    _unused: [u8; 0],
}
pub type VkCommandPool = *mut VkCommandPool_T;
pub const VkResult_VK_SUCCESS: VkResult = 0;
pub const VkResult_VK_NOT_READY: VkResult = 1;
pub const VkResult_VK_TIMEOUT: VkResult = 2;
pub const VkResult_VK_EVENT_SET: VkResult = 3;
pub const VkResult_VK_EVENT_RESET: VkResult = 4;
pub const VkResult_VK_INCOMPLETE: VkResult = 5;
pub const VkResult_VK_ERROR_OUT_OF_HOST_MEMORY: VkResult = -1;
pub const VkResult_VK_ERROR_OUT_OF_DEVICE_MEMORY: VkResult = -2;
pub const VkResult_VK_ERROR_INITIALIZATION_FAILED: VkResult = -3;
pub const VkResult_VK_ERROR_DEVICE_LOST: VkResult = -4;
pub const VkResult_VK_ERROR_MEMORY_MAP_FAILED: VkResult = -5;
pub const VkResult_VK_ERROR_LAYER_NOT_PRESENT: VkResult = -6;
pub const VkResult_VK_ERROR_EXTENSION_NOT_PRESENT: VkResult = -7;
pub const VkResult_VK_ERROR_FEATURE_NOT_PRESENT: VkResult = -8;
pub const VkResult_VK_ERROR_INCOMPATIBLE_DRIVER: VkResult = -9;
pub const VkResult_VK_ERROR_TOO_MANY_OBJECTS: VkResult = -10;
pub const VkResult_VK_ERROR_FORMAT_NOT_SUPPORTED: VkResult = -11;
pub const VkResult_VK_ERROR_FRAGMENTED_POOL: VkResult = -12;
pub const VkResult_VK_ERROR_UNKNOWN: VkResult = -13;
pub const VkResult_VK_ERROR_OUT_OF_POOL_MEMORY: VkResult = -1000069000;
pub const VkResult_VK_ERROR_INVALID_EXTERNAL_HANDLE: VkResult = -1000072003;
pub const VkResult_VK_ERROR_FRAGMENTATION: VkResult = -1000161000;
pub const VkResult_VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS: VkResult = -1000257000;
pub const VkResult_VK_ERROR_SURFACE_LOST_KHR: VkResult = -1000000000;
pub const VkResult_VK_ERROR_NATIVE_WINDOW_IN_USE_KHR: VkResult = -1000000001;
pub const VkResult_VK_SUBOPTIMAL_KHR: VkResult = 1000001003;
pub const VkResult_VK_ERROR_OUT_OF_DATE_KHR: VkResult = -1000001004;
pub const VkResult_VK_ERROR_INCOMPATIBLE_DISPLAY_KHR: VkResult = -1000003001;
pub const VkResult_VK_ERROR_VALIDATION_FAILED_EXT: VkResult = -1000011001;
pub const VkResult_VK_ERROR_INVALID_SHADER_NV: VkResult = -1000012000;
pub const VkResult_VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT: VkResult = -1000158000;
pub const VkResult_VK_ERROR_NOT_PERMITTED_EXT: VkResult = -1000174001;
pub const VkResult_VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT: VkResult = -1000255000;
pub const VkResult_VK_THREAD_IDLE_KHR: VkResult = 1000268000;
pub const VkResult_VK_THREAD_DONE_KHR: VkResult = 1000268001;
pub const VkResult_VK_OPERATION_DEFERRED_KHR: VkResult = 1000268002;
pub const VkResult_VK_OPERATION_NOT_DEFERRED_KHR: VkResult = 1000268003;
pub const VkResult_VK_PIPELINE_COMPILE_REQUIRED_EXT: VkResult = 1000297000;
pub const VkResult_VK_ERROR_OUT_OF_POOL_MEMORY_KHR: VkResult = -1000069000;
pub const VkResult_VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR: VkResult = -1000072003;
pub const VkResult_VK_ERROR_FRAGMENTATION_EXT: VkResult = -1000161000;
pub const VkResult_VK_ERROR_INVALID_DEVICE_ADDRESS_EXT: VkResult = -1000257000;
pub const VkResult_VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR: VkResult = -1000257000;
pub const VkResult_VK_ERROR_PIPELINE_COMPILE_REQUIRED_EXT: VkResult = 1000297000;
pub const VkResult_VK_RESULT_MAX_ENUM: VkResult = 2147483647;
pub type VkResult = ::std::os::raw::c_int;
pub const VkStructureType_VK_STRUCTURE_TYPE_APPLICATION_INFO: VkStructureType = 0;
pub const VkStructureType_VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO: VkStructureType = 1;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO: VkStructureType = 2;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO: VkStructureType = 3;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBMIT_INFO: VkStructureType = 4;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO: VkStructureType = 5;
pub const VkStructureType_VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE: VkStructureType = 6;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_SPARSE_INFO: VkStructureType = 7;
pub const VkStructureType_VK_STRUCTURE_TYPE_FENCE_CREATE_INFO: VkStructureType = 8;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO: VkStructureType = 9;
pub const VkStructureType_VK_STRUCTURE_TYPE_EVENT_CREATE_INFO: VkStructureType = 10;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO: VkStructureType = 11;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO: VkStructureType = 12;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO: VkStructureType = 13;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO: VkStructureType = 14;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO: VkStructureType = 15;
pub const VkStructureType_VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: VkStructureType = 16;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO: VkStructureType = 17;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO: VkStructureType = 18;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO:
    VkStructureType = 19;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO:
    VkStructureType = 20;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO:
    VkStructureType = 21;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO: VkStructureType =
    22;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO:
    VkStructureType = 23;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO:
    VkStructureType = 24;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO:
    VkStructureType = 25;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO:
    VkStructureType = 26;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO: VkStructureType =
    27;
pub const VkStructureType_VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO: VkStructureType = 28;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO: VkStructureType = 29;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO: VkStructureType = 30;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO: VkStructureType = 31;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO: VkStructureType = 32;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO: VkStructureType = 33;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO: VkStructureType = 34;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET: VkStructureType = 35;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET: VkStructureType = 36;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO: VkStructureType = 37;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO: VkStructureType = 38;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO: VkStructureType = 39;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO: VkStructureType = 40;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO: VkStructureType = 41;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO: VkStructureType = 42;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO: VkStructureType = 43;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER: VkStructureType = 44;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER: VkStructureType = 45;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_BARRIER: VkStructureType = 46;
pub const VkStructureType_VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO: VkStructureType = 47;
pub const VkStructureType_VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO: VkStructureType = 48;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: VkStructureType =
    1000094000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO: VkStructureType = 1000157000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO: VkStructureType = 1000157001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
    VkStructureType = 1000083000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: VkStructureType =
    1000127000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: VkStructureType =
    1000127001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: VkStructureType =
    1000060000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: VkStructureType =
    1000060003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
    VkStructureType = 1000060004;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: VkStructureType = 1000060005;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: VkStructureType =
    1000060006;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: VkStructureType =
    1000060013;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: VkStructureType =
    1000060014;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES: VkStructureType =
    1000070000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: VkStructureType =
    1000070001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2: VkStructureType =
    1000146000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2: VkStructureType =
    1000146001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2:
    VkStructureType = 1000146002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2: VkStructureType = 1000146003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2: VkStructureType =
    1000146004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: VkStructureType =
    1000059000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2: VkStructureType =
    1000059001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2: VkStructureType = 1000059002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2: VkStructureType = 1000059003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2: VkStructureType =
    1000059004;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2: VkStructureType = 1000059005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2: VkStructureType =
    1000059006;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2: VkStructureType =
    1000059007;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2:
    VkStructureType = 1000059008;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
    VkStructureType = 1000117000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
    VkStructureType = 1000117001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: VkStructureType =
    1000117002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO : VkStructureType = 1000117003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: VkStructureType =
    1000053000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: VkStructureType =
    1000053001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: VkStructureType =
    1000053002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: VkStructureType = 1000145000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
    VkStructureType = 1000145001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
    VkStructureType = 1000145002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2: VkStructureType = 1000145003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO: VkStructureType =
    1000156000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: VkStructureType =
    1000156001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: VkStructureType =
    1000156002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: VkStructureType =
    1000156003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
    VkStructureType = 1000156004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
    VkStructureType = 1000156005;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO:
    VkStructureType = 1000085000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
    VkStructureType = 1000071000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: VkStructureType =
    1000071001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO: VkStructureType =
    1000071002;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES: VkStructureType =
    1000071003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: VkStructureType =
    1000071004;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: VkStructureType =
    1000072000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: VkStructureType =
    1000072001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: VkStructureType =
    1000072002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO: VkStructureType =
    1000112000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES: VkStructureType = 1000112001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: VkStructureType = 1000113000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: VkStructureType =
    1000077000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO:
    VkStructureType = 1000076000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES: VkStructureType =
    1000076001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
    VkStructureType = 1000168000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT: VkStructureType =
    1000168001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
    VkStructureType = 1000063000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: VkStructureType =
    49;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: VkStructureType =
    50;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: VkStructureType =
    51;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: VkStructureType =
    52;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: VkStructureType =
    1000147000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2: VkStructureType = 1000109000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2: VkStructureType = 1000109001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2: VkStructureType = 1000109002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2: VkStructureType = 1000109003;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2: VkStructureType = 1000109004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO: VkStructureType = 1000109005;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_END_INFO: VkStructureType = 1000109006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: VkStructureType =
    1000177000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: VkStructureType =
    1000196000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
    VkStructureType = 1000180000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
    VkStructureType = 1000082000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
    VkStructureType = 1000197000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
    VkStructureType = 1000161000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
    VkStructureType = 1000161001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
    VkStructureType = 1000161002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO : VkStructureType = 1000161003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT : VkStructureType = 1000161004 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
    VkStructureType = 1000199000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
    VkStructureType = 1000199001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
    VkStructureType = 1000221000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: VkStructureType =
    1000246000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
    VkStructureType = 1000130000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: VkStructureType =
    1000130001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
    VkStructureType = 1000211000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
    VkStructureType = 1000108000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: VkStructureType =
    1000108001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO: VkStructureType =
    1000108002;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: VkStructureType =
    1000108003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES : VkStructureType = 1000253000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES : VkStructureType = 1000175000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES : VkStructureType = 1000241000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: VkStructureType =
    1000241001;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: VkStructureType =
    1000241002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
    VkStructureType = 1000261000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
    VkStructureType = 1000207000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
    VkStructureType = 1000207001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: VkStructureType =
    1000207002;
pub const VkStructureType_VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: VkStructureType =
    1000207003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO: VkStructureType = 1000207004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO: VkStructureType = 1000207005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
    VkStructureType = 1000257000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO: VkStructureType =
    1000244001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
    VkStructureType = 1000257002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
    VkStructureType = 1000257003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO:
    VkStructureType = 1000257004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR: VkStructureType = 1000001000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_INFO_KHR: VkStructureType = 1000001001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR: VkStructureType =
    1000060007;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR: VkStructureType =
    1000060008;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: VkStructureType =
    1000060009;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR: VkStructureType =
    1000060010;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: VkStructureType =
    1000060011;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR:
    VkStructureType = 1000060012;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR: VkStructureType =
    1000002000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000002001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: VkStructureType = 1000003000;
pub const VkStructureType_VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000004000;
pub const VkStructureType_VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000005000;
pub const VkStructureType_VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000006000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000008000;
pub const VkStructureType_VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000009000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: VkStructureType =
    1000011000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD:
    VkStructureType = 1000018000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT: VkStructureType =
    1000022000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT: VkStructureType =
    1000022001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT: VkStructureType =
    1000022002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV:
    VkStructureType = 1000026000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV:
    VkStructureType = 1000026001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV:
    VkStructureType = 1000026002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
    VkStructureType = 1000028000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
    VkStructureType = 1000028001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
    VkStructureType = 1000028002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX: VkStructureType =
    1000030000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX: VkStructureType =
    1000030001;
pub const VkStructureType_VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD:
    VkStructureType = 1000041000;
pub const VkStructureType_VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP:
    VkStructureType = 1000049000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV:
    VkStructureType = 1000050000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: VkStructureType =
    1000056000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: VkStructureType =
    1000056001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV: VkStructureType =
    1000057000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV: VkStructureType =
    1000057001;
pub const VkStructureType_VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV:
    VkStructureType = 1000058000;
pub const VkStructureType_VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: VkStructureType = 1000061000;
pub const VkStructureType_VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN: VkStructureType = 1000062000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT : VkStructureType = 1000066000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: VkStructureType =
    1000067000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT:
    VkStructureType = 1000067001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR: VkStructureType =
    1000073002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073003;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: VkStructureType = 1000074000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR: VkStructureType = 1000074001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR: VkStructureType = 1000074002;
pub const VkStructureType_VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR:
    VkStructureType = 1000075000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
    VkStructureType = 1000078000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
    VkStructureType = 1000078001;
pub const VkStructureType_VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR: VkStructureType =
    1000078002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000078003;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR: VkStructureType =
    1000079000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR: VkStructureType = 1000079001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
    VkStructureType = 1000080000;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT : VkStructureType = 1000081000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
    VkStructureType = 1000081001;
pub const VkStructureType_VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT: VkStructureType =
    1000081002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: VkStructureType = 1000084000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV:
    VkStructureType = 1000087000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT: VkStructureType =
    1000090000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT: VkStructureType = 1000091000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT: VkStructureType = 1000091001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT: VkStructureType = 1000091002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: VkStructureType =
    1000091003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: VkStructureType = 1000092000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX : VkStructureType = 1000097000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV:
    VkStructureType = 1000098000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT:
    VkStructureType = 1000099000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000099001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT : VkStructureType = 1000101000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT : VkStructureType = 1000101001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
    VkStructureType = 1000102000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT : VkStructureType = 1000102001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_HDR_METADATA_EXT: VkStructureType = 1000105000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR:
    VkStructureType = 1000111000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR: VkStructureType = 1000115000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR: VkStructureType = 1000115001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR:
    VkStructureType = 1000116000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR:
    VkStructureType = 1000116001;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR:
    VkStructureType = 1000116002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR: VkStructureType =
    1000116003;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR: VkStructureType =
    1000116004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR: VkStructureType = 1000116005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR: VkStructureType =
    1000116006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR: VkStructureType =
    1000119000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR: VkStructureType =
    1000119001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR: VkStructureType = 1000119002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR: VkStructureType = 1000121000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR: VkStructureType =
    1000121001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR: VkStructureType =
    1000121002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR: VkStructureType = 1000121003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR: VkStructureType =
    1000121004;
pub const VkStructureType_VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK: VkStructureType =
    1000122000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK: VkStructureType =
    1000123000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: VkStructureType =
    1000128000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT: VkStructureType =
    1000128001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT: VkStructureType = 1000128002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT:
    VkStructureType = 1000128003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: VkStructureType =
    1000128004;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID: VkStructureType =
    1000129000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID:
    VkStructureType = 1000129001;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID:
    VkStructureType = 1000129002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
    VkStructureType = 1000129003;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
    VkStructureType = 1000129004;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID: VkStructureType = 1000129005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT:
    VkStructureType = 1000138000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT:
    VkStructureType = 1000138001;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT:
    VkStructureType = 1000138002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT:
    VkStructureType = 1000138003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: VkStructureType = 1000143000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT:
    VkStructureType = 1000143001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000143002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT:
    VkStructureType = 1000143003;
pub const VkStructureType_VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT: VkStructureType =
    1000143004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT : VkStructureType = 1000148000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT : VkStructureType = 1000148001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000148002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV:
    VkStructureType = 1000149000;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR:
    VkStructureType = 1000150007;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR:
    VkStructureType = 1000150000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR:
    VkStructureType = 1000150002;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR:
    VkStructureType = 1000150003;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR:
    VkStructureType = 1000150004;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR:
    VkStructureType = 1000150005;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR: VkStructureType =
    1000150006;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR:
    VkStructureType = 1000150009;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR: VkStructureType =
    1000150010;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR:
    VkStructureType = 1000150011;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR:
    VkStructureType = 1000150012;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
    VkStructureType = 1000150013;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR : VkStructureType = 1000150014 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR:
    VkStructureType = 1000150017;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR:
    VkStructureType = 1000150020;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
    VkStructureType = 1000347000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR:
    VkStructureType = 1000347001;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR: VkStructureType =
    1000150015;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR:
    VkStructureType = 1000150016;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR:
    VkStructureType = 1000150018;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
    VkStructureType = 1000348013;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV:
    VkStructureType = 1000152000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV:
    VkStructureType = 1000154000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV:
    VkStructureType = 1000154001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
    VkStructureType = 1000158000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
    VkStructureType = 1000158002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
    VkStructureType = 1000158003;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
    VkStructureType = 1000158004;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT:
    VkStructureType = 1000158005;
pub const VkStructureType_VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT: VkStructureType =
    1000160000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT:
    VkStructureType = 1000160001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR:
    VkStructureType = 1000163000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR:
    VkStructureType = 1000163001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV : VkStructureType = 1000164000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV:
    VkStructureType = 1000164001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV:
    VkStructureType = 1000164002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV : VkStructureType = 1000164005 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV: VkStructureType =
    1000165000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV: VkStructureType =
    1000165001;
pub const VkStructureType_VK_STRUCTURE_TYPE_GEOMETRY_NV: VkStructureType = 1000165003;
pub const VkStructureType_VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV: VkStructureType = 1000165004;
pub const VkStructureType_VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV: VkStructureType = 1000165005;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV:
    VkStructureType = 1000165006;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV:
    VkStructureType = 1000165007;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV:
    VkStructureType = 1000165008;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV:
    VkStructureType = 1000165009;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV:
    VkStructureType = 1000165011;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV: VkStructureType =
    1000165012;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV : VkStructureType = 1000166000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV : VkStructureType = 1000166001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT:
    VkStructureType = 1000170000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT:
    VkStructureType = 1000170001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT:
    VkStructureType = 1000174000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: VkStructureType =
    1000178000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT: VkStructureType =
    1000178001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT:
    VkStructureType = 1000178002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
    VkStructureType = 1000181000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD:
    VkStructureType = 1000183000;
pub const VkStructureType_VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT: VkStructureType =
    1000184000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD:
    VkStructureType = 1000185000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD:
    VkStructureType = 1000189000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT : VkStructureType = 1000190000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000190001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT : VkStructureType = 1000190002 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP: VkStructureType = 1000191000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT:
    VkStructureType = 1000192000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV : VkStructureType = 1000201000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV:
    VkStructureType = 1000202000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV:
    VkStructureType = 1000202001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV : VkStructureType = 1000203000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV:
    VkStructureType = 1000204000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV : VkStructureType = 1000205000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV:
    VkStructureType = 1000205002;
pub const VkStructureType_VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV: VkStructureType = 1000206000;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV: VkStructureType =
    1000206001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL : VkStructureType = 1000209000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL:
    VkStructureType = 1000210000;
pub const VkStructureType_VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL: VkStructureType =
    1000210001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL: VkStructureType =
    1000210002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL: VkStructureType =
    1000210003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL: VkStructureType =
    1000210004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL:
    VkStructureType = 1000210005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
    VkStructureType = 1000212000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD:
    VkStructureType = 1000213000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD:
    VkStructureType = 1000213001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA: VkStructureType =
    1000214000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR : VkStructureType = 1000215000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000217000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
    VkStructureType = 1000218000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
    VkStructureType = 1000218001;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
    VkStructureType = 1000218002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT:
    VkStructureType = 1000225000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT : VkStructureType = 1000225001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT:
    VkStructureType = 1000225002;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
    VkStructureType = 1000226000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR:
    VkStructureType = 1000226001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR:
    VkStructureType = 1000226002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
    VkStructureType = 1000226003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR:
    VkStructureType = 1000226004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD:
    VkStructureType = 1000227000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD:
    VkStructureType = 1000229000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT : VkStructureType = 1000234000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
    VkStructureType = 1000237000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT:
    VkStructureType = 1000238000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT: VkStructureType =
    1000238001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: VkStructureType =
    1000239000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV : VkStructureType = 1000240000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
    VkStructureType = 1000244000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT: VkStructureType =
    1000244002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT: VkStructureType =
    1000245000;
pub const VkStructureType_VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: VkStructureType = 1000247000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV:
    VkStructureType = 1000249000;
pub const VkStructureType_VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV: VkStructureType =
    1000249001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV:
    VkStructureType = 1000249002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV:
    VkStructureType = 1000250000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV:
    VkStructureType = 1000250001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV:
    VkStructureType = 1000250002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT : VkStructureType = 1000251000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
    VkStructureType = 1000252000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT:
    VkStructureType = 1000255000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT:
    VkStructureType = 1000255002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT:
    VkStructureType = 1000255001;
pub const VkStructureType_VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000256000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
    VkStructureType = 1000259000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000259001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
    VkStructureType = 1000259002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
    VkStructureType = 1000260000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
    VkStructureType = 1000265000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
    VkStructureType = 1000267000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR : VkStructureType = 1000269000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR: VkStructureType = 1000269001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR: VkStructureType =
    1000269002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR: VkStructureType =
    1000269003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR: VkStructureType =
    1000269004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR:
    VkStructureType = 1000269005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT : VkStructureType = 1000276000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV : VkStructureType = 1000277000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV: VkStructureType =
    1000277001;
pub const VkStructureType_VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV:
    VkStructureType = 1000277002;
pub const VkStructureType_VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV: VkStructureType =
    1000277003;
pub const VkStructureType_VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV:
    VkStructureType = 1000277004;
pub const VkStructureType_VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV: VkStructureType =
    1000277005;
pub const VkStructureType_VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV:
    VkStructureType = 1000277006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV : VkStructureType = 1000277007 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
    VkStructureType = 1000281000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT : VkStructureType = 1000281001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM : VkStructureType = 1000282000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM: VkStructureType =
    1000282001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
    VkStructureType = 1000284000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
    VkStructureType = 1000284001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT:
    VkStructureType = 1000284002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
    VkStructureType = 1000286000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
    VkStructureType = 1000286001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
    VkStructureType = 1000287000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
    VkStructureType = 1000287001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
    VkStructureType = 1000287002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: VkStructureType =
    1000290000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT:
    VkStructureType = 1000295000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT: VkStructureType =
    1000295001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT: VkStructureType =
    1000295002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT : VkStructureType = 1000297000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV:
    VkStructureType = 1000300000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV:
    VkStructureType = 1000300001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR: VkStructureType = 1000314000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR: VkStructureType =
    1000314001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR: VkStructureType =
    1000314002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR: VkStructureType = 1000314003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR: VkStructureType = 1000314004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR: VkStructureType = 1000314005;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR: VkStructureType =
    1000314006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR:
    VkStructureType = 1000314007;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV:
    VkStructureType = 1000314008;
pub const VkStructureType_VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV: VkStructureType = 1000314009;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR : VkStructureType = 1000325000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV : VkStructureType = 1000326000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV : VkStructureType = 1000326001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV : VkStructureType = 1000326002 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT:
    VkStructureType = 1000332000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT : VkStructureType = 1000332001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM: VkStructureType =
    1000333000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT:
    VkStructureType = 1000335000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR : VkStructureType = 1000336000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR: VkStructureType = 1000337000;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR: VkStructureType = 1000337001;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR: VkStructureType =
    1000337002;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR: VkStructureType =
    1000337003;
pub const VkStructureType_VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR: VkStructureType = 1000337004;
pub const VkStructureType_VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR: VkStructureType = 1000337005;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR: VkStructureType = 1000337006;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR: VkStructureType = 1000337007;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR: VkStructureType = 1000337008;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR: VkStructureType = 1000337009;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR: VkStructureType = 1000337010;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
    VkStructureType = 1000340000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000346000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE : VkStructureType = 1000351000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE:
    VkStructureType = 1000351002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES:
    VkStructureType = 1000063000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT: VkStructureType =
    1000011000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR: VkStructureType =
    1000053000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR:
    VkStructureType = 1000053001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR:
    VkStructureType = 1000053002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR: VkStructureType =
    1000059000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR: VkStructureType =
    1000059001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR: VkStructureType = 1000059002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR: VkStructureType =
    1000059003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR:
    VkStructureType = 1000059004;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR: VkStructureType =
    1000059005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR:
    VkStructureType = 1000059006;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR: VkStructureType =
    1000059007;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR:
    VkStructureType = 1000059008;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR: VkStructureType =
    1000060000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR:
    VkStructureType = 1000060003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR:
    VkStructureType = 1000060004;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR: VkStructureType =
    1000060005;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR: VkStructureType =
    1000060006;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR:
    VkStructureType = 1000060013;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR:
    VkStructureType = 1000060014;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR: VkStructureType =
    1000070000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR: VkStructureType =
    1000070001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR:
    VkStructureType = 1000071000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR: VkStructureType =
    1000071001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR:
    VkStructureType = 1000071002;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR: VkStructureType =
    1000071003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR: VkStructureType =
    1000071004;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR:
    VkStructureType = 1000072000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR: VkStructureType =
    1000072001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR: VkStructureType =
    1000072002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR:
    VkStructureType = 1000076000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR: VkStructureType =
    1000076001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR: VkStructureType =
    1000077000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR:
    VkStructureType = 1000082000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR:
    VkStructureType = 1000082000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR:
    VkStructureType = 1000083000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR:
    VkStructureType = 1000085000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES2_EXT: VkStructureType = 1000090000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR:
    VkStructureType = 1000108000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR:
    VkStructureType = 1000108001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR: VkStructureType =
    1000108002;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR: VkStructureType =
    1000108003;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR: VkStructureType =
    1000109000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR: VkStructureType =
    1000109001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR: VkStructureType = 1000109002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR: VkStructureType = 1000109003;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR: VkStructureType =
    1000109004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR: VkStructureType = 1000109005;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_END_INFO_KHR: VkStructureType = 1000109006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR:
    VkStructureType = 1000112000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR: VkStructureType =
    1000112001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR: VkStructureType =
    1000113000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR:
    VkStructureType = 1000117000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR:
    VkStructureType = 1000117001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR: VkStructureType =
    1000117002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR : VkStructureType = 1000117003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR: VkStructureType =
    1000127000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR: VkStructureType =
    1000127001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT:
    VkStructureType = 1000130000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT:
    VkStructureType = 1000130001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR: VkStructureType =
    1000146000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR: VkStructureType =
    1000146001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR:
    VkStructureType = 1000146002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR: VkStructureType = 1000146003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR:
    VkStructureType = 1000146004;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR: VkStructureType =
    1000147000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR:
    VkStructureType = 1000156000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR: VkStructureType =
    1000156001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR: VkStructureType =
    1000156002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR:
    VkStructureType = 1000156003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR : VkStructureType = 1000156004 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR:
    VkStructureType = 1000156005;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR: VkStructureType =
    1000157000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR: VkStructureType =
    1000157001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT:
    VkStructureType = 1000161000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT:
    VkStructureType = 1000161001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT:
    VkStructureType = 1000161002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT : VkStructureType = 1000161003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT : VkStructureType = 1000161004 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR:
    VkStructureType = 1000168000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR: VkStructureType =
    1000168001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR : VkStructureType = 1000175000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR:
    VkStructureType = 1000177000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR:
    VkStructureType = 1000180000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR: VkStructureType =
    1000196000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR:
    VkStructureType = 1000197000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR:
    VkStructureType = 1000199000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR:
    VkStructureType = 1000199001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR:
    VkStructureType = 1000207000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR:
    VkStructureType = 1000207001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR: VkStructureType =
    1000207002;
pub const VkStructureType_VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR: VkStructureType =
    1000207003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR: VkStructureType = 1000207004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR: VkStructureType = 1000207005;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL: VkStructureType =
    1000210000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR:
    VkStructureType = 1000211000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT:
    VkStructureType = 1000221000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR : VkStructureType = 1000241000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR:
    VkStructureType = 1000241001;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR:
    VkStructureType = 1000241002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT:
    VkStructureType = 1000244000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT: VkStructureType =
    1000244001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT: VkStructureType =
    1000246000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR : VkStructureType = 1000253000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR:
    VkStructureType = 1000257000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR: VkStructureType =
    1000244001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR:
    VkStructureType = 1000257002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR:
    VkStructureType = 1000257003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR:
    VkStructureType = 1000257004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT:
    VkStructureType = 1000261000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MAX_ENUM: VkStructureType = 2147483647;
pub type VkStructureType = ::std::os::raw::c_uint;
pub const VkImageLayout_VK_IMAGE_LAYOUT_UNDEFINED: VkImageLayout = 0;
pub const VkImageLayout_VK_IMAGE_LAYOUT_GENERAL: VkImageLayout = 1;
pub const VkImageLayout_VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL: VkImageLayout = 2;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout = 3;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout = 4;
pub const VkImageLayout_VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL: VkImageLayout = 5;
pub const VkImageLayout_VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL: VkImageLayout = 6;
pub const VkImageLayout_VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL: VkImageLayout = 7;
pub const VkImageLayout_VK_IMAGE_LAYOUT_PREINITIALIZED: VkImageLayout = 8;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout =
    1000117000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout =
    1000117001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL: VkImageLayout = 1000241000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL: VkImageLayout = 1000241001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout = 1000241002;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout = 1000241003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_PRESENT_SRC_KHR: VkImageLayout = 1000001002;
pub const VkImageLayout_VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR: VkImageLayout = 1000111000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV: VkImageLayout = 1000164003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT: VkImageLayout =
    1000218000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000314000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000314001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR:
    VkImageLayout = 1000117000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR:
    VkImageLayout = 1000117001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR:
    VkImageLayout = 1000164003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000241000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000241001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000241002;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000241003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_MAX_ENUM: VkImageLayout = 2147483647;
pub type VkImageLayout = ::std::os::raw::c_uint;
pub const VkObjectType_VK_OBJECT_TYPE_UNKNOWN: VkObjectType = 0;
pub const VkObjectType_VK_OBJECT_TYPE_INSTANCE: VkObjectType = 1;
pub const VkObjectType_VK_OBJECT_TYPE_PHYSICAL_DEVICE: VkObjectType = 2;
pub const VkObjectType_VK_OBJECT_TYPE_DEVICE: VkObjectType = 3;
pub const VkObjectType_VK_OBJECT_TYPE_QUEUE: VkObjectType = 4;
pub const VkObjectType_VK_OBJECT_TYPE_SEMAPHORE: VkObjectType = 5;
pub const VkObjectType_VK_OBJECT_TYPE_COMMAND_BUFFER: VkObjectType = 6;
pub const VkObjectType_VK_OBJECT_TYPE_FENCE: VkObjectType = 7;
pub const VkObjectType_VK_OBJECT_TYPE_DEVICE_MEMORY: VkObjectType = 8;
pub const VkObjectType_VK_OBJECT_TYPE_BUFFER: VkObjectType = 9;
pub const VkObjectType_VK_OBJECT_TYPE_IMAGE: VkObjectType = 10;
pub const VkObjectType_VK_OBJECT_TYPE_EVENT: VkObjectType = 11;
pub const VkObjectType_VK_OBJECT_TYPE_QUERY_POOL: VkObjectType = 12;
pub const VkObjectType_VK_OBJECT_TYPE_BUFFER_VIEW: VkObjectType = 13;
pub const VkObjectType_VK_OBJECT_TYPE_IMAGE_VIEW: VkObjectType = 14;
pub const VkObjectType_VK_OBJECT_TYPE_SHADER_MODULE: VkObjectType = 15;
pub const VkObjectType_VK_OBJECT_TYPE_PIPELINE_CACHE: VkObjectType = 16;
pub const VkObjectType_VK_OBJECT_TYPE_PIPELINE_LAYOUT: VkObjectType = 17;
pub const VkObjectType_VK_OBJECT_TYPE_RENDER_PASS: VkObjectType = 18;
pub const VkObjectType_VK_OBJECT_TYPE_PIPELINE: VkObjectType = 19;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT: VkObjectType = 20;
pub const VkObjectType_VK_OBJECT_TYPE_SAMPLER: VkObjectType = 21;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_POOL: VkObjectType = 22;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_SET: VkObjectType = 23;
pub const VkObjectType_VK_OBJECT_TYPE_FRAMEBUFFER: VkObjectType = 24;
pub const VkObjectType_VK_OBJECT_TYPE_COMMAND_POOL: VkObjectType = 25;
pub const VkObjectType_VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION: VkObjectType = 1000156000;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE: VkObjectType = 1000085000;
pub const VkObjectType_VK_OBJECT_TYPE_SURFACE_KHR: VkObjectType = 1000000000;
pub const VkObjectType_VK_OBJECT_TYPE_SWAPCHAIN_KHR: VkObjectType = 1000001000;
pub const VkObjectType_VK_OBJECT_TYPE_DISPLAY_KHR: VkObjectType = 1000002000;
pub const VkObjectType_VK_OBJECT_TYPE_DISPLAY_MODE_KHR: VkObjectType = 1000002001;
pub const VkObjectType_VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT: VkObjectType = 1000011000;
pub const VkObjectType_VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT: VkObjectType = 1000128000;
pub const VkObjectType_VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR: VkObjectType = 1000150000;
pub const VkObjectType_VK_OBJECT_TYPE_VALIDATION_CACHE_EXT: VkObjectType = 1000160000;
pub const VkObjectType_VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV: VkObjectType = 1000165000;
pub const VkObjectType_VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL: VkObjectType = 1000210000;
pub const VkObjectType_VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR: VkObjectType = 1000268000;
pub const VkObjectType_VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV: VkObjectType = 1000277000;
pub const VkObjectType_VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT: VkObjectType = 1000295000;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR: VkObjectType = 1000085000;
pub const VkObjectType_VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR: VkObjectType = 1000156000;
pub const VkObjectType_VK_OBJECT_TYPE_MAX_ENUM: VkObjectType = 2147483647;
pub type VkObjectType = ::std::os::raw::c_uint;
pub const VkVendorId_VK_VENDOR_ID_VIV: VkVendorId = 65537;
pub const VkVendorId_VK_VENDOR_ID_VSI: VkVendorId = 65538;
pub const VkVendorId_VK_VENDOR_ID_KAZAN: VkVendorId = 65539;
pub const VkVendorId_VK_VENDOR_ID_CODEPLAY: VkVendorId = 65540;
pub const VkVendorId_VK_VENDOR_ID_MESA: VkVendorId = 65541;
pub const VkVendorId_VK_VENDOR_ID_POCL: VkVendorId = 65542;
pub const VkVendorId_VK_VENDOR_ID_MAX_ENUM: VkVendorId = 2147483647;
pub type VkVendorId = ::std::os::raw::c_uint;
pub const VkPipelineCacheHeaderVersion_VK_PIPELINE_CACHE_HEADER_VERSION_ONE:
    VkPipelineCacheHeaderVersion = 1;
pub const VkPipelineCacheHeaderVersion_VK_PIPELINE_CACHE_HEADER_VERSION_MAX_ENUM:
    VkPipelineCacheHeaderVersion = 2147483647;
pub type VkPipelineCacheHeaderVersion = ::std::os::raw::c_uint;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_COMMAND: VkSystemAllocationScope = 0;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_OBJECT: VkSystemAllocationScope = 1;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_CACHE: VkSystemAllocationScope = 2;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_DEVICE: VkSystemAllocationScope = 3;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE: VkSystemAllocationScope = 4;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM: VkSystemAllocationScope =
    2147483647;
pub type VkSystemAllocationScope = ::std::os::raw::c_uint;
pub const VkInternalAllocationType_VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE:
    VkInternalAllocationType = 0;
pub const VkInternalAllocationType_VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM: VkInternalAllocationType =
    2147483647;
pub type VkInternalAllocationType = ::std::os::raw::c_uint;
pub const VkFormat_VK_FORMAT_UNDEFINED: VkFormat = 0;
pub const VkFormat_VK_FORMAT_R4G4_UNORM_PACK8: VkFormat = 1;
pub const VkFormat_VK_FORMAT_R4G4B4A4_UNORM_PACK16: VkFormat = 2;
pub const VkFormat_VK_FORMAT_B4G4R4A4_UNORM_PACK16: VkFormat = 3;
pub const VkFormat_VK_FORMAT_R5G6B5_UNORM_PACK16: VkFormat = 4;
pub const VkFormat_VK_FORMAT_B5G6R5_UNORM_PACK16: VkFormat = 5;
pub const VkFormat_VK_FORMAT_R5G5B5A1_UNORM_PACK16: VkFormat = 6;
pub const VkFormat_VK_FORMAT_B5G5R5A1_UNORM_PACK16: VkFormat = 7;
pub const VkFormat_VK_FORMAT_A1R5G5B5_UNORM_PACK16: VkFormat = 8;
pub const VkFormat_VK_FORMAT_R8_UNORM: VkFormat = 9;
pub const VkFormat_VK_FORMAT_R8_SNORM: VkFormat = 10;
pub const VkFormat_VK_FORMAT_R8_USCALED: VkFormat = 11;
pub const VkFormat_VK_FORMAT_R8_SSCALED: VkFormat = 12;
pub const VkFormat_VK_FORMAT_R8_UINT: VkFormat = 13;
pub const VkFormat_VK_FORMAT_R8_SINT: VkFormat = 14;
pub const VkFormat_VK_FORMAT_R8_SRGB: VkFormat = 15;
pub const VkFormat_VK_FORMAT_R8G8_UNORM: VkFormat = 16;
pub const VkFormat_VK_FORMAT_R8G8_SNORM: VkFormat = 17;
pub const VkFormat_VK_FORMAT_R8G8_USCALED: VkFormat = 18;
pub const VkFormat_VK_FORMAT_R8G8_SSCALED: VkFormat = 19;
pub const VkFormat_VK_FORMAT_R8G8_UINT: VkFormat = 20;
pub const VkFormat_VK_FORMAT_R8G8_SINT: VkFormat = 21;
pub const VkFormat_VK_FORMAT_R8G8_SRGB: VkFormat = 22;
pub const VkFormat_VK_FORMAT_R8G8B8_UNORM: VkFormat = 23;
pub const VkFormat_VK_FORMAT_R8G8B8_SNORM: VkFormat = 24;
pub const VkFormat_VK_FORMAT_R8G8B8_USCALED: VkFormat = 25;
pub const VkFormat_VK_FORMAT_R8G8B8_SSCALED: VkFormat = 26;
pub const VkFormat_VK_FORMAT_R8G8B8_UINT: VkFormat = 27;
pub const VkFormat_VK_FORMAT_R8G8B8_SINT: VkFormat = 28;
pub const VkFormat_VK_FORMAT_R8G8B8_SRGB: VkFormat = 29;
pub const VkFormat_VK_FORMAT_B8G8R8_UNORM: VkFormat = 30;
pub const VkFormat_VK_FORMAT_B8G8R8_SNORM: VkFormat = 31;
pub const VkFormat_VK_FORMAT_B8G8R8_USCALED: VkFormat = 32;
pub const VkFormat_VK_FORMAT_B8G8R8_SSCALED: VkFormat = 33;
pub const VkFormat_VK_FORMAT_B8G8R8_UINT: VkFormat = 34;
pub const VkFormat_VK_FORMAT_B8G8R8_SINT: VkFormat = 35;
pub const VkFormat_VK_FORMAT_B8G8R8_SRGB: VkFormat = 36;
pub const VkFormat_VK_FORMAT_R8G8B8A8_UNORM: VkFormat = 37;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SNORM: VkFormat = 38;
pub const VkFormat_VK_FORMAT_R8G8B8A8_USCALED: VkFormat = 39;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SSCALED: VkFormat = 40;
pub const VkFormat_VK_FORMAT_R8G8B8A8_UINT: VkFormat = 41;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SINT: VkFormat = 42;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SRGB: VkFormat = 43;
pub const VkFormat_VK_FORMAT_B8G8R8A8_UNORM: VkFormat = 44;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SNORM: VkFormat = 45;
pub const VkFormat_VK_FORMAT_B8G8R8A8_USCALED: VkFormat = 46;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SSCALED: VkFormat = 47;
pub const VkFormat_VK_FORMAT_B8G8R8A8_UINT: VkFormat = 48;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SINT: VkFormat = 49;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SRGB: VkFormat = 50;
pub const VkFormat_VK_FORMAT_A8B8G8R8_UNORM_PACK32: VkFormat = 51;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SNORM_PACK32: VkFormat = 52;
pub const VkFormat_VK_FORMAT_A8B8G8R8_USCALED_PACK32: VkFormat = 53;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SSCALED_PACK32: VkFormat = 54;
pub const VkFormat_VK_FORMAT_A8B8G8R8_UINT_PACK32: VkFormat = 55;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SINT_PACK32: VkFormat = 56;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SRGB_PACK32: VkFormat = 57;
pub const VkFormat_VK_FORMAT_A2R10G10B10_UNORM_PACK32: VkFormat = 58;
pub const VkFormat_VK_FORMAT_A2R10G10B10_SNORM_PACK32: VkFormat = 59;
pub const VkFormat_VK_FORMAT_A2R10G10B10_USCALED_PACK32: VkFormat = 60;
pub const VkFormat_VK_FORMAT_A2R10G10B10_SSCALED_PACK32: VkFormat = 61;
pub const VkFormat_VK_FORMAT_A2R10G10B10_UINT_PACK32: VkFormat = 62;
pub const VkFormat_VK_FORMAT_A2R10G10B10_SINT_PACK32: VkFormat = 63;
pub const VkFormat_VK_FORMAT_A2B10G10R10_UNORM_PACK32: VkFormat = 64;
pub const VkFormat_VK_FORMAT_A2B10G10R10_SNORM_PACK32: VkFormat = 65;
pub const VkFormat_VK_FORMAT_A2B10G10R10_USCALED_PACK32: VkFormat = 66;
pub const VkFormat_VK_FORMAT_A2B10G10R10_SSCALED_PACK32: VkFormat = 67;
pub const VkFormat_VK_FORMAT_A2B10G10R10_UINT_PACK32: VkFormat = 68;
pub const VkFormat_VK_FORMAT_A2B10G10R10_SINT_PACK32: VkFormat = 69;
pub const VkFormat_VK_FORMAT_R16_UNORM: VkFormat = 70;
pub const VkFormat_VK_FORMAT_R16_SNORM: VkFormat = 71;
pub const VkFormat_VK_FORMAT_R16_USCALED: VkFormat = 72;
pub const VkFormat_VK_FORMAT_R16_SSCALED: VkFormat = 73;
pub const VkFormat_VK_FORMAT_R16_UINT: VkFormat = 74;
pub const VkFormat_VK_FORMAT_R16_SINT: VkFormat = 75;
pub const VkFormat_VK_FORMAT_R16_SFLOAT: VkFormat = 76;
pub const VkFormat_VK_FORMAT_R16G16_UNORM: VkFormat = 77;
pub const VkFormat_VK_FORMAT_R16G16_SNORM: VkFormat = 78;
pub const VkFormat_VK_FORMAT_R16G16_USCALED: VkFormat = 79;
pub const VkFormat_VK_FORMAT_R16G16_SSCALED: VkFormat = 80;
pub const VkFormat_VK_FORMAT_R16G16_UINT: VkFormat = 81;
pub const VkFormat_VK_FORMAT_R16G16_SINT: VkFormat = 82;
pub const VkFormat_VK_FORMAT_R16G16_SFLOAT: VkFormat = 83;
pub const VkFormat_VK_FORMAT_R16G16B16_UNORM: VkFormat = 84;
pub const VkFormat_VK_FORMAT_R16G16B16_SNORM: VkFormat = 85;
pub const VkFormat_VK_FORMAT_R16G16B16_USCALED: VkFormat = 86;
pub const VkFormat_VK_FORMAT_R16G16B16_SSCALED: VkFormat = 87;
pub const VkFormat_VK_FORMAT_R16G16B16_UINT: VkFormat = 88;
pub const VkFormat_VK_FORMAT_R16G16B16_SINT: VkFormat = 89;
pub const VkFormat_VK_FORMAT_R16G16B16_SFLOAT: VkFormat = 90;
pub const VkFormat_VK_FORMAT_R16G16B16A16_UNORM: VkFormat = 91;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SNORM: VkFormat = 92;
pub const VkFormat_VK_FORMAT_R16G16B16A16_USCALED: VkFormat = 93;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SSCALED: VkFormat = 94;
pub const VkFormat_VK_FORMAT_R16G16B16A16_UINT: VkFormat = 95;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SINT: VkFormat = 96;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SFLOAT: VkFormat = 97;
pub const VkFormat_VK_FORMAT_R32_UINT: VkFormat = 98;
pub const VkFormat_VK_FORMAT_R32_SINT: VkFormat = 99;
pub const VkFormat_VK_FORMAT_R32_SFLOAT: VkFormat = 100;
pub const VkFormat_VK_FORMAT_R32G32_UINT: VkFormat = 101;
pub const VkFormat_VK_FORMAT_R32G32_SINT: VkFormat = 102;
pub const VkFormat_VK_FORMAT_R32G32_SFLOAT: VkFormat = 103;
pub const VkFormat_VK_FORMAT_R32G32B32_UINT: VkFormat = 104;
pub const VkFormat_VK_FORMAT_R32G32B32_SINT: VkFormat = 105;
pub const VkFormat_VK_FORMAT_R32G32B32_SFLOAT: VkFormat = 106;
pub const VkFormat_VK_FORMAT_R32G32B32A32_UINT: VkFormat = 107;
pub const VkFormat_VK_FORMAT_R32G32B32A32_SINT: VkFormat = 108;
pub const VkFormat_VK_FORMAT_R32G32B32A32_SFLOAT: VkFormat = 109;
pub const VkFormat_VK_FORMAT_R64_UINT: VkFormat = 110;
pub const VkFormat_VK_FORMAT_R64_SINT: VkFormat = 111;
pub const VkFormat_VK_FORMAT_R64_SFLOAT: VkFormat = 112;
pub const VkFormat_VK_FORMAT_R64G64_UINT: VkFormat = 113;
pub const VkFormat_VK_FORMAT_R64G64_SINT: VkFormat = 114;
pub const VkFormat_VK_FORMAT_R64G64_SFLOAT: VkFormat = 115;
pub const VkFormat_VK_FORMAT_R64G64B64_UINT: VkFormat = 116;
pub const VkFormat_VK_FORMAT_R64G64B64_SINT: VkFormat = 117;
pub const VkFormat_VK_FORMAT_R64G64B64_SFLOAT: VkFormat = 118;
pub const VkFormat_VK_FORMAT_R64G64B64A64_UINT: VkFormat = 119;
pub const VkFormat_VK_FORMAT_R64G64B64A64_SINT: VkFormat = 120;
pub const VkFormat_VK_FORMAT_R64G64B64A64_SFLOAT: VkFormat = 121;
pub const VkFormat_VK_FORMAT_B10G11R11_UFLOAT_PACK32: VkFormat = 122;
pub const VkFormat_VK_FORMAT_E5B9G9R9_UFLOAT_PACK32: VkFormat = 123;
pub const VkFormat_VK_FORMAT_D16_UNORM: VkFormat = 124;
pub const VkFormat_VK_FORMAT_X8_D24_UNORM_PACK32: VkFormat = 125;
pub const VkFormat_VK_FORMAT_D32_SFLOAT: VkFormat = 126;
pub const VkFormat_VK_FORMAT_S8_UINT: VkFormat = 127;
pub const VkFormat_VK_FORMAT_D16_UNORM_S8_UINT: VkFormat = 128;
pub const VkFormat_VK_FORMAT_D24_UNORM_S8_UINT: VkFormat = 129;
pub const VkFormat_VK_FORMAT_D32_SFLOAT_S8_UINT: VkFormat = 130;
pub const VkFormat_VK_FORMAT_BC1_RGB_UNORM_BLOCK: VkFormat = 131;
pub const VkFormat_VK_FORMAT_BC1_RGB_SRGB_BLOCK: VkFormat = 132;
pub const VkFormat_VK_FORMAT_BC1_RGBA_UNORM_BLOCK: VkFormat = 133;
pub const VkFormat_VK_FORMAT_BC1_RGBA_SRGB_BLOCK: VkFormat = 134;
pub const VkFormat_VK_FORMAT_BC2_UNORM_BLOCK: VkFormat = 135;
pub const VkFormat_VK_FORMAT_BC2_SRGB_BLOCK: VkFormat = 136;
pub const VkFormat_VK_FORMAT_BC3_UNORM_BLOCK: VkFormat = 137;
pub const VkFormat_VK_FORMAT_BC3_SRGB_BLOCK: VkFormat = 138;
pub const VkFormat_VK_FORMAT_BC4_UNORM_BLOCK: VkFormat = 139;
pub const VkFormat_VK_FORMAT_BC4_SNORM_BLOCK: VkFormat = 140;
pub const VkFormat_VK_FORMAT_BC5_UNORM_BLOCK: VkFormat = 141;
pub const VkFormat_VK_FORMAT_BC5_SNORM_BLOCK: VkFormat = 142;
pub const VkFormat_VK_FORMAT_BC6H_UFLOAT_BLOCK: VkFormat = 143;
pub const VkFormat_VK_FORMAT_BC6H_SFLOAT_BLOCK: VkFormat = 144;
pub const VkFormat_VK_FORMAT_BC7_UNORM_BLOCK: VkFormat = 145;
pub const VkFormat_VK_FORMAT_BC7_SRGB_BLOCK: VkFormat = 146;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK: VkFormat = 147;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK: VkFormat = 148;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK: VkFormat = 149;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK: VkFormat = 150;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK: VkFormat = 151;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK: VkFormat = 152;
pub const VkFormat_VK_FORMAT_EAC_R11_UNORM_BLOCK: VkFormat = 153;
pub const VkFormat_VK_FORMAT_EAC_R11_SNORM_BLOCK: VkFormat = 154;
pub const VkFormat_VK_FORMAT_EAC_R11G11_UNORM_BLOCK: VkFormat = 155;
pub const VkFormat_VK_FORMAT_EAC_R11G11_SNORM_BLOCK: VkFormat = 156;
pub const VkFormat_VK_FORMAT_ASTC_4x4_UNORM_BLOCK: VkFormat = 157;
pub const VkFormat_VK_FORMAT_ASTC_4x4_SRGB_BLOCK: VkFormat = 158;
pub const VkFormat_VK_FORMAT_ASTC_5x4_UNORM_BLOCK: VkFormat = 159;
pub const VkFormat_VK_FORMAT_ASTC_5x4_SRGB_BLOCK: VkFormat = 160;
pub const VkFormat_VK_FORMAT_ASTC_5x5_UNORM_BLOCK: VkFormat = 161;
pub const VkFormat_VK_FORMAT_ASTC_5x5_SRGB_BLOCK: VkFormat = 162;
pub const VkFormat_VK_FORMAT_ASTC_6x5_UNORM_BLOCK: VkFormat = 163;
pub const VkFormat_VK_FORMAT_ASTC_6x5_SRGB_BLOCK: VkFormat = 164;
pub const VkFormat_VK_FORMAT_ASTC_6x6_UNORM_BLOCK: VkFormat = 165;
pub const VkFormat_VK_FORMAT_ASTC_6x6_SRGB_BLOCK: VkFormat = 166;
pub const VkFormat_VK_FORMAT_ASTC_8x5_UNORM_BLOCK: VkFormat = 167;
pub const VkFormat_VK_FORMAT_ASTC_8x5_SRGB_BLOCK: VkFormat = 168;
pub const VkFormat_VK_FORMAT_ASTC_8x6_UNORM_BLOCK: VkFormat = 169;
pub const VkFormat_VK_FORMAT_ASTC_8x6_SRGB_BLOCK: VkFormat = 170;
pub const VkFormat_VK_FORMAT_ASTC_8x8_UNORM_BLOCK: VkFormat = 171;
pub const VkFormat_VK_FORMAT_ASTC_8x8_SRGB_BLOCK: VkFormat = 172;
pub const VkFormat_VK_FORMAT_ASTC_10x5_UNORM_BLOCK: VkFormat = 173;
pub const VkFormat_VK_FORMAT_ASTC_10x5_SRGB_BLOCK: VkFormat = 174;
pub const VkFormat_VK_FORMAT_ASTC_10x6_UNORM_BLOCK: VkFormat = 175;
pub const VkFormat_VK_FORMAT_ASTC_10x6_SRGB_BLOCK: VkFormat = 176;
pub const VkFormat_VK_FORMAT_ASTC_10x8_UNORM_BLOCK: VkFormat = 177;
pub const VkFormat_VK_FORMAT_ASTC_10x8_SRGB_BLOCK: VkFormat = 178;
pub const VkFormat_VK_FORMAT_ASTC_10x10_UNORM_BLOCK: VkFormat = 179;
pub const VkFormat_VK_FORMAT_ASTC_10x10_SRGB_BLOCK: VkFormat = 180;
pub const VkFormat_VK_FORMAT_ASTC_12x10_UNORM_BLOCK: VkFormat = 181;
pub const VkFormat_VK_FORMAT_ASTC_12x10_SRGB_BLOCK: VkFormat = 182;
pub const VkFormat_VK_FORMAT_ASTC_12x12_UNORM_BLOCK: VkFormat = 183;
pub const VkFormat_VK_FORMAT_ASTC_12x12_SRGB_BLOCK: VkFormat = 184;
pub const VkFormat_VK_FORMAT_G8B8G8R8_422_UNORM: VkFormat = 1000156000;
pub const VkFormat_VK_FORMAT_B8G8R8G8_422_UNORM: VkFormat = 1000156001;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM: VkFormat = 1000156002;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_420_UNORM: VkFormat = 1000156003;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM: VkFormat = 1000156004;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_422_UNORM: VkFormat = 1000156005;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM: VkFormat = 1000156006;
pub const VkFormat_VK_FORMAT_R10X6_UNORM_PACK16: VkFormat = 1000156007;
pub const VkFormat_VK_FORMAT_R10X6G10X6_UNORM_2PACK16: VkFormat = 1000156008;
pub const VkFormat_VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16: VkFormat = 1000156009;
pub const VkFormat_VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: VkFormat = 1000156010;
pub const VkFormat_VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: VkFormat = 1000156011;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16: VkFormat = 1000156012;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16: VkFormat = 1000156013;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16: VkFormat = 1000156014;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16: VkFormat = 1000156015;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16: VkFormat = 1000156016;
pub const VkFormat_VK_FORMAT_R12X4_UNORM_PACK16: VkFormat = 1000156017;
pub const VkFormat_VK_FORMAT_R12X4G12X4_UNORM_2PACK16: VkFormat = 1000156018;
pub const VkFormat_VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16: VkFormat = 1000156019;
pub const VkFormat_VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: VkFormat = 1000156020;
pub const VkFormat_VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: VkFormat = 1000156021;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16: VkFormat = 1000156022;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16: VkFormat = 1000156023;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16: VkFormat = 1000156024;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16: VkFormat = 1000156025;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16: VkFormat = 1000156026;
pub const VkFormat_VK_FORMAT_G16B16G16R16_422_UNORM: VkFormat = 1000156027;
pub const VkFormat_VK_FORMAT_B16G16R16G16_422_UNORM: VkFormat = 1000156028;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM: VkFormat = 1000156029;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_420_UNORM: VkFormat = 1000156030;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM: VkFormat = 1000156031;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_422_UNORM: VkFormat = 1000156032;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM: VkFormat = 1000156033;
pub const VkFormat_VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG: VkFormat = 1000054000;
pub const VkFormat_VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG: VkFormat = 1000054001;
pub const VkFormat_VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG: VkFormat = 1000054002;
pub const VkFormat_VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG: VkFormat = 1000054003;
pub const VkFormat_VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG: VkFormat = 1000054004;
pub const VkFormat_VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG: VkFormat = 1000054005;
pub const VkFormat_VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG: VkFormat = 1000054006;
pub const VkFormat_VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG: VkFormat = 1000054007;
pub const VkFormat_VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT: VkFormat = 1000066000;
pub const VkFormat_VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT: VkFormat = 1000066001;
pub const VkFormat_VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066002;
pub const VkFormat_VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066003;
pub const VkFormat_VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066004;
pub const VkFormat_VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066005;
pub const VkFormat_VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066006;
pub const VkFormat_VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT: VkFormat = 1000066007;
pub const VkFormat_VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066008;
pub const VkFormat_VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066009;
pub const VkFormat_VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT: VkFormat = 1000066010;
pub const VkFormat_VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT: VkFormat = 1000066011;
pub const VkFormat_VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT: VkFormat = 1000066012;
pub const VkFormat_VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT: VkFormat = 1000066013;
pub const VkFormat_VK_FORMAT_A4R4G4B4_UNORM_PACK16_EXT: VkFormat = 1000340000;
pub const VkFormat_VK_FORMAT_A4B4G4R4_UNORM_PACK16_EXT: VkFormat = 1000340001;
pub const VkFormat_VK_FORMAT_G8B8G8R8_422_UNORM_KHR: VkFormat = 1000156000;
pub const VkFormat_VK_FORMAT_B8G8R8G8_422_UNORM_KHR: VkFormat = 1000156001;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR: VkFormat = 1000156002;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR: VkFormat = 1000156003;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR: VkFormat = 1000156004;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR: VkFormat = 1000156005;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR: VkFormat = 1000156006;
pub const VkFormat_VK_FORMAT_R10X6_UNORM_PACK16_KHR: VkFormat = 1000156007;
pub const VkFormat_VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR: VkFormat = 1000156008;
pub const VkFormat_VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR: VkFormat = 1000156009;
pub const VkFormat_VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR: VkFormat = 1000156010;
pub const VkFormat_VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR: VkFormat = 1000156011;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156012;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156013;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156014;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156015;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR: VkFormat = 1000156016;
pub const VkFormat_VK_FORMAT_R12X4_UNORM_PACK16_KHR: VkFormat = 1000156017;
pub const VkFormat_VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR: VkFormat = 1000156018;
pub const VkFormat_VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR: VkFormat = 1000156019;
pub const VkFormat_VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR: VkFormat = 1000156020;
pub const VkFormat_VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR: VkFormat = 1000156021;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156022;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156023;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156024;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156025;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR: VkFormat = 1000156026;
pub const VkFormat_VK_FORMAT_G16B16G16R16_422_UNORM_KHR: VkFormat = 1000156027;
pub const VkFormat_VK_FORMAT_B16G16R16G16_422_UNORM_KHR: VkFormat = 1000156028;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR: VkFormat = 1000156029;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR: VkFormat = 1000156030;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR: VkFormat = 1000156031;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR: VkFormat = 1000156032;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR: VkFormat = 1000156033;
pub const VkFormat_VK_FORMAT_MAX_ENUM: VkFormat = 2147483647;
pub type VkFormat = ::std::os::raw::c_uint;
pub const VkImageTiling_VK_IMAGE_TILING_OPTIMAL: VkImageTiling = 0;
pub const VkImageTiling_VK_IMAGE_TILING_LINEAR: VkImageTiling = 1;
pub const VkImageTiling_VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT: VkImageTiling = 1000158000;
pub const VkImageTiling_VK_IMAGE_TILING_MAX_ENUM: VkImageTiling = 2147483647;
pub type VkImageTiling = ::std::os::raw::c_uint;
pub const VkImageType_VK_IMAGE_TYPE_1D: VkImageType = 0;
pub const VkImageType_VK_IMAGE_TYPE_2D: VkImageType = 1;
pub const VkImageType_VK_IMAGE_TYPE_3D: VkImageType = 2;
pub const VkImageType_VK_IMAGE_TYPE_MAX_ENUM: VkImageType = 2147483647;
pub type VkImageType = ::std::os::raw::c_uint;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_OTHER: VkPhysicalDeviceType = 0;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU: VkPhysicalDeviceType = 1;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU: VkPhysicalDeviceType = 2;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU: VkPhysicalDeviceType = 3;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_CPU: VkPhysicalDeviceType = 4;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_MAX_ENUM: VkPhysicalDeviceType = 2147483647;
pub type VkPhysicalDeviceType = ::std::os::raw::c_uint;
pub const VkQueryType_VK_QUERY_TYPE_OCCLUSION: VkQueryType = 0;
pub const VkQueryType_VK_QUERY_TYPE_PIPELINE_STATISTICS: VkQueryType = 1;
pub const VkQueryType_VK_QUERY_TYPE_TIMESTAMP: VkQueryType = 2;
pub const VkQueryType_VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT: VkQueryType = 1000028004;
pub const VkQueryType_VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR: VkQueryType = 1000116000;
pub const VkQueryType_VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR: VkQueryType =
    1000150000;
pub const VkQueryType_VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR: VkQueryType =
    1000150001;
pub const VkQueryType_VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV: VkQueryType =
    1000165000;
pub const VkQueryType_VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL: VkQueryType = 1000210000;
pub const VkQueryType_VK_QUERY_TYPE_MAX_ENUM: VkQueryType = 2147483647;
pub type VkQueryType = ::std::os::raw::c_uint;
pub const VkSharingMode_VK_SHARING_MODE_EXCLUSIVE: VkSharingMode = 0;
pub const VkSharingMode_VK_SHARING_MODE_CONCURRENT: VkSharingMode = 1;
pub const VkSharingMode_VK_SHARING_MODE_MAX_ENUM: VkSharingMode = 2147483647;
pub type VkSharingMode = ::std::os::raw::c_uint;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_IDENTITY: VkComponentSwizzle = 0;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_ZERO: VkComponentSwizzle = 1;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_ONE: VkComponentSwizzle = 2;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_R: VkComponentSwizzle = 3;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_G: VkComponentSwizzle = 4;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_B: VkComponentSwizzle = 5;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_A: VkComponentSwizzle = 6;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_MAX_ENUM: VkComponentSwizzle = 2147483647;
pub type VkComponentSwizzle = ::std::os::raw::c_uint;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_1D: VkImageViewType = 0;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_2D: VkImageViewType = 1;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_3D: VkImageViewType = 2;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_CUBE: VkImageViewType = 3;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_1D_ARRAY: VkImageViewType = 4;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_2D_ARRAY: VkImageViewType = 5;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_CUBE_ARRAY: VkImageViewType = 6;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_MAX_ENUM: VkImageViewType = 2147483647;
pub type VkImageViewType = ::std::os::raw::c_uint;
pub const VkBlendFactor_VK_BLEND_FACTOR_ZERO: VkBlendFactor = 0;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE: VkBlendFactor = 1;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC_COLOR: VkBlendFactor = 2;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR: VkBlendFactor = 3;
pub const VkBlendFactor_VK_BLEND_FACTOR_DST_COLOR: VkBlendFactor = 4;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR: VkBlendFactor = 5;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC_ALPHA: VkBlendFactor = 6;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA: VkBlendFactor = 7;
pub const VkBlendFactor_VK_BLEND_FACTOR_DST_ALPHA: VkBlendFactor = 8;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA: VkBlendFactor = 9;
pub const VkBlendFactor_VK_BLEND_FACTOR_CONSTANT_COLOR: VkBlendFactor = 10;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR: VkBlendFactor = 11;
pub const VkBlendFactor_VK_BLEND_FACTOR_CONSTANT_ALPHA: VkBlendFactor = 12;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA: VkBlendFactor = 13;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC_ALPHA_SATURATE: VkBlendFactor = 14;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC1_COLOR: VkBlendFactor = 15;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR: VkBlendFactor = 16;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC1_ALPHA: VkBlendFactor = 17;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA: VkBlendFactor = 18;
pub const VkBlendFactor_VK_BLEND_FACTOR_MAX_ENUM: VkBlendFactor = 2147483647;
pub type VkBlendFactor = ::std::os::raw::c_uint;
pub const VkBlendOp_VK_BLEND_OP_ADD: VkBlendOp = 0;
pub const VkBlendOp_VK_BLEND_OP_SUBTRACT: VkBlendOp = 1;
pub const VkBlendOp_VK_BLEND_OP_REVERSE_SUBTRACT: VkBlendOp = 2;
pub const VkBlendOp_VK_BLEND_OP_MIN: VkBlendOp = 3;
pub const VkBlendOp_VK_BLEND_OP_MAX: VkBlendOp = 4;
pub const VkBlendOp_VK_BLEND_OP_ZERO_EXT: VkBlendOp = 1000148000;
pub const VkBlendOp_VK_BLEND_OP_SRC_EXT: VkBlendOp = 1000148001;
pub const VkBlendOp_VK_BLEND_OP_DST_EXT: VkBlendOp = 1000148002;
pub const VkBlendOp_VK_BLEND_OP_SRC_OVER_EXT: VkBlendOp = 1000148003;
pub const VkBlendOp_VK_BLEND_OP_DST_OVER_EXT: VkBlendOp = 1000148004;
pub const VkBlendOp_VK_BLEND_OP_SRC_IN_EXT: VkBlendOp = 1000148005;
pub const VkBlendOp_VK_BLEND_OP_DST_IN_EXT: VkBlendOp = 1000148006;
pub const VkBlendOp_VK_BLEND_OP_SRC_OUT_EXT: VkBlendOp = 1000148007;
pub const VkBlendOp_VK_BLEND_OP_DST_OUT_EXT: VkBlendOp = 1000148008;
pub const VkBlendOp_VK_BLEND_OP_SRC_ATOP_EXT: VkBlendOp = 1000148009;
pub const VkBlendOp_VK_BLEND_OP_DST_ATOP_EXT: VkBlendOp = 1000148010;
pub const VkBlendOp_VK_BLEND_OP_XOR_EXT: VkBlendOp = 1000148011;
pub const VkBlendOp_VK_BLEND_OP_MULTIPLY_EXT: VkBlendOp = 1000148012;
pub const VkBlendOp_VK_BLEND_OP_SCREEN_EXT: VkBlendOp = 1000148013;
pub const VkBlendOp_VK_BLEND_OP_OVERLAY_EXT: VkBlendOp = 1000148014;
pub const VkBlendOp_VK_BLEND_OP_DARKEN_EXT: VkBlendOp = 1000148015;
pub const VkBlendOp_VK_BLEND_OP_LIGHTEN_EXT: VkBlendOp = 1000148016;
pub const VkBlendOp_VK_BLEND_OP_COLORDODGE_EXT: VkBlendOp = 1000148017;
pub const VkBlendOp_VK_BLEND_OP_COLORBURN_EXT: VkBlendOp = 1000148018;
pub const VkBlendOp_VK_BLEND_OP_HARDLIGHT_EXT: VkBlendOp = 1000148019;
pub const VkBlendOp_VK_BLEND_OP_SOFTLIGHT_EXT: VkBlendOp = 1000148020;
pub const VkBlendOp_VK_BLEND_OP_DIFFERENCE_EXT: VkBlendOp = 1000148021;
pub const VkBlendOp_VK_BLEND_OP_EXCLUSION_EXT: VkBlendOp = 1000148022;
pub const VkBlendOp_VK_BLEND_OP_INVERT_EXT: VkBlendOp = 1000148023;
pub const VkBlendOp_VK_BLEND_OP_INVERT_RGB_EXT: VkBlendOp = 1000148024;
pub const VkBlendOp_VK_BLEND_OP_LINEARDODGE_EXT: VkBlendOp = 1000148025;
pub const VkBlendOp_VK_BLEND_OP_LINEARBURN_EXT: VkBlendOp = 1000148026;
pub const VkBlendOp_VK_BLEND_OP_VIVIDLIGHT_EXT: VkBlendOp = 1000148027;
pub const VkBlendOp_VK_BLEND_OP_LINEARLIGHT_EXT: VkBlendOp = 1000148028;
pub const VkBlendOp_VK_BLEND_OP_PINLIGHT_EXT: VkBlendOp = 1000148029;
pub const VkBlendOp_VK_BLEND_OP_HARDMIX_EXT: VkBlendOp = 1000148030;
pub const VkBlendOp_VK_BLEND_OP_HSL_HUE_EXT: VkBlendOp = 1000148031;
pub const VkBlendOp_VK_BLEND_OP_HSL_SATURATION_EXT: VkBlendOp = 1000148032;
pub const VkBlendOp_VK_BLEND_OP_HSL_COLOR_EXT: VkBlendOp = 1000148033;
pub const VkBlendOp_VK_BLEND_OP_HSL_LUMINOSITY_EXT: VkBlendOp = 1000148034;
pub const VkBlendOp_VK_BLEND_OP_PLUS_EXT: VkBlendOp = 1000148035;
pub const VkBlendOp_VK_BLEND_OP_PLUS_CLAMPED_EXT: VkBlendOp = 1000148036;
pub const VkBlendOp_VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT: VkBlendOp = 1000148037;
pub const VkBlendOp_VK_BLEND_OP_PLUS_DARKER_EXT: VkBlendOp = 1000148038;
pub const VkBlendOp_VK_BLEND_OP_MINUS_EXT: VkBlendOp = 1000148039;
pub const VkBlendOp_VK_BLEND_OP_MINUS_CLAMPED_EXT: VkBlendOp = 1000148040;
pub const VkBlendOp_VK_BLEND_OP_CONTRAST_EXT: VkBlendOp = 1000148041;
pub const VkBlendOp_VK_BLEND_OP_INVERT_OVG_EXT: VkBlendOp = 1000148042;
pub const VkBlendOp_VK_BLEND_OP_RED_EXT: VkBlendOp = 1000148043;
pub const VkBlendOp_VK_BLEND_OP_GREEN_EXT: VkBlendOp = 1000148044;
pub const VkBlendOp_VK_BLEND_OP_BLUE_EXT: VkBlendOp = 1000148045;
pub const VkBlendOp_VK_BLEND_OP_MAX_ENUM: VkBlendOp = 2147483647;
pub type VkBlendOp = ::std::os::raw::c_uint;
pub const VkCompareOp_VK_COMPARE_OP_NEVER: VkCompareOp = 0;
pub const VkCompareOp_VK_COMPARE_OP_LESS: VkCompareOp = 1;
pub const VkCompareOp_VK_COMPARE_OP_EQUAL: VkCompareOp = 2;
pub const VkCompareOp_VK_COMPARE_OP_LESS_OR_EQUAL: VkCompareOp = 3;
pub const VkCompareOp_VK_COMPARE_OP_GREATER: VkCompareOp = 4;
pub const VkCompareOp_VK_COMPARE_OP_NOT_EQUAL: VkCompareOp = 5;
pub const VkCompareOp_VK_COMPARE_OP_GREATER_OR_EQUAL: VkCompareOp = 6;
pub const VkCompareOp_VK_COMPARE_OP_ALWAYS: VkCompareOp = 7;
pub const VkCompareOp_VK_COMPARE_OP_MAX_ENUM: VkCompareOp = 2147483647;
pub type VkCompareOp = ::std::os::raw::c_uint;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT: VkDynamicState = 0;
pub const VkDynamicState_VK_DYNAMIC_STATE_SCISSOR: VkDynamicState = 1;
pub const VkDynamicState_VK_DYNAMIC_STATE_LINE_WIDTH: VkDynamicState = 2;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_BIAS: VkDynamicState = 3;
pub const VkDynamicState_VK_DYNAMIC_STATE_BLEND_CONSTANTS: VkDynamicState = 4;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_BOUNDS: VkDynamicState = 5;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK: VkDynamicState = 6;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_WRITE_MASK: VkDynamicState = 7;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_REFERENCE: VkDynamicState = 8;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV: VkDynamicState = 1000087000;
pub const VkDynamicState_VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT: VkDynamicState = 1000099000;
pub const VkDynamicState_VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT: VkDynamicState = 1000143000;
pub const VkDynamicState_VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR: VkDynamicState =
    1000347000;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV: VkDynamicState =
    1000164004;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV: VkDynamicState =
    1000164006;
pub const VkDynamicState_VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV: VkDynamicState = 1000205001;
pub const VkDynamicState_VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR: VkDynamicState = 1000226000;
pub const VkDynamicState_VK_DYNAMIC_STATE_LINE_STIPPLE_EXT: VkDynamicState = 1000259000;
pub const VkDynamicState_VK_DYNAMIC_STATE_CULL_MODE_EXT: VkDynamicState = 1000267000;
pub const VkDynamicState_VK_DYNAMIC_STATE_FRONT_FACE_EXT: VkDynamicState = 1000267001;
pub const VkDynamicState_VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT: VkDynamicState = 1000267002;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT: VkDynamicState = 1000267003;
pub const VkDynamicState_VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT: VkDynamicState = 1000267004;
pub const VkDynamicState_VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT: VkDynamicState =
    1000267005;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT: VkDynamicState = 1000267006;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT: VkDynamicState = 1000267007;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT: VkDynamicState = 1000267008;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT: VkDynamicState = 1000267009;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT: VkDynamicState = 1000267010;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_OP_EXT: VkDynamicState = 1000267011;
pub const VkDynamicState_VK_DYNAMIC_STATE_MAX_ENUM: VkDynamicState = 2147483647;
pub type VkDynamicState = ::std::os::raw::c_uint;
pub const VkFrontFace_VK_FRONT_FACE_COUNTER_CLOCKWISE: VkFrontFace = 0;
pub const VkFrontFace_VK_FRONT_FACE_CLOCKWISE: VkFrontFace = 1;
pub const VkFrontFace_VK_FRONT_FACE_MAX_ENUM: VkFrontFace = 2147483647;
pub type VkFrontFace = ::std::os::raw::c_uint;
pub const VkVertexInputRate_VK_VERTEX_INPUT_RATE_VERTEX: VkVertexInputRate = 0;
pub const VkVertexInputRate_VK_VERTEX_INPUT_RATE_INSTANCE: VkVertexInputRate = 1;
pub const VkVertexInputRate_VK_VERTEX_INPUT_RATE_MAX_ENUM: VkVertexInputRate = 2147483647;
pub type VkVertexInputRate = ::std::os::raw::c_uint;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_POINT_LIST: VkPrimitiveTopology = 0;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_LIST: VkPrimitiveTopology = 1;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_STRIP: VkPrimitiveTopology = 2;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST: VkPrimitiveTopology = 3;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP: VkPrimitiveTopology = 4;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN: VkPrimitiveTopology = 5;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY: VkPrimitiveTopology =
    6;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY: VkPrimitiveTopology =
    7;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY:
    VkPrimitiveTopology = 8;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY:
    VkPrimitiveTopology = 9;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_PATCH_LIST: VkPrimitiveTopology = 10;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_MAX_ENUM: VkPrimitiveTopology = 2147483647;
pub type VkPrimitiveTopology = ::std::os::raw::c_uint;
pub const VkPolygonMode_VK_POLYGON_MODE_FILL: VkPolygonMode = 0;
pub const VkPolygonMode_VK_POLYGON_MODE_LINE: VkPolygonMode = 1;
pub const VkPolygonMode_VK_POLYGON_MODE_POINT: VkPolygonMode = 2;
pub const VkPolygonMode_VK_POLYGON_MODE_FILL_RECTANGLE_NV: VkPolygonMode = 1000153000;
pub const VkPolygonMode_VK_POLYGON_MODE_MAX_ENUM: VkPolygonMode = 2147483647;
pub type VkPolygonMode = ::std::os::raw::c_uint;
pub const VkStencilOp_VK_STENCIL_OP_KEEP: VkStencilOp = 0;
pub const VkStencilOp_VK_STENCIL_OP_ZERO: VkStencilOp = 1;
pub const VkStencilOp_VK_STENCIL_OP_REPLACE: VkStencilOp = 2;
pub const VkStencilOp_VK_STENCIL_OP_INCREMENT_AND_CLAMP: VkStencilOp = 3;
pub const VkStencilOp_VK_STENCIL_OP_DECREMENT_AND_CLAMP: VkStencilOp = 4;
pub const VkStencilOp_VK_STENCIL_OP_INVERT: VkStencilOp = 5;
pub const VkStencilOp_VK_STENCIL_OP_INCREMENT_AND_WRAP: VkStencilOp = 6;
pub const VkStencilOp_VK_STENCIL_OP_DECREMENT_AND_WRAP: VkStencilOp = 7;
pub const VkStencilOp_VK_STENCIL_OP_MAX_ENUM: VkStencilOp = 2147483647;
pub type VkStencilOp = ::std::os::raw::c_uint;
pub const VkLogicOp_VK_LOGIC_OP_CLEAR: VkLogicOp = 0;
pub const VkLogicOp_VK_LOGIC_OP_AND: VkLogicOp = 1;
pub const VkLogicOp_VK_LOGIC_OP_AND_REVERSE: VkLogicOp = 2;
pub const VkLogicOp_VK_LOGIC_OP_COPY: VkLogicOp = 3;
pub const VkLogicOp_VK_LOGIC_OP_AND_INVERTED: VkLogicOp = 4;
pub const VkLogicOp_VK_LOGIC_OP_NO_OP: VkLogicOp = 5;
pub const VkLogicOp_VK_LOGIC_OP_XOR: VkLogicOp = 6;
pub const VkLogicOp_VK_LOGIC_OP_OR: VkLogicOp = 7;
pub const VkLogicOp_VK_LOGIC_OP_NOR: VkLogicOp = 8;
pub const VkLogicOp_VK_LOGIC_OP_EQUIVALENT: VkLogicOp = 9;
pub const VkLogicOp_VK_LOGIC_OP_INVERT: VkLogicOp = 10;
pub const VkLogicOp_VK_LOGIC_OP_OR_REVERSE: VkLogicOp = 11;
pub const VkLogicOp_VK_LOGIC_OP_COPY_INVERTED: VkLogicOp = 12;
pub const VkLogicOp_VK_LOGIC_OP_OR_INVERTED: VkLogicOp = 13;
pub const VkLogicOp_VK_LOGIC_OP_NAND: VkLogicOp = 14;
pub const VkLogicOp_VK_LOGIC_OP_SET: VkLogicOp = 15;
pub const VkLogicOp_VK_LOGIC_OP_MAX_ENUM: VkLogicOp = 2147483647;
pub type VkLogicOp = ::std::os::raw::c_uint;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK: VkBorderColor = 0;
pub const VkBorderColor_VK_BORDER_COLOR_INT_TRANSPARENT_BLACK: VkBorderColor = 1;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK: VkBorderColor = 2;
pub const VkBorderColor_VK_BORDER_COLOR_INT_OPAQUE_BLACK: VkBorderColor = 3;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE: VkBorderColor = 4;
pub const VkBorderColor_VK_BORDER_COLOR_INT_OPAQUE_WHITE: VkBorderColor = 5;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_CUSTOM_EXT: VkBorderColor = 1000287003;
pub const VkBorderColor_VK_BORDER_COLOR_INT_CUSTOM_EXT: VkBorderColor = 1000287004;
pub const VkBorderColor_VK_BORDER_COLOR_MAX_ENUM: VkBorderColor = 2147483647;
pub type VkBorderColor = ::std::os::raw::c_uint;
pub const VkFilter_VK_FILTER_NEAREST: VkFilter = 0;
pub const VkFilter_VK_FILTER_LINEAR: VkFilter = 1;
pub const VkFilter_VK_FILTER_CUBIC_IMG: VkFilter = 1000015000;
pub const VkFilter_VK_FILTER_CUBIC_EXT: VkFilter = 1000015000;
pub const VkFilter_VK_FILTER_MAX_ENUM: VkFilter = 2147483647;
pub type VkFilter = ::std::os::raw::c_uint;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_REPEAT: VkSamplerAddressMode = 0;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT: VkSamplerAddressMode = 1;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE: VkSamplerAddressMode = 2;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER: VkSamplerAddressMode = 3;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE: VkSamplerAddressMode =
    4;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE_KHR:
    VkSamplerAddressMode = 4;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MAX_ENUM: VkSamplerAddressMode = 2147483647;
pub type VkSamplerAddressMode = ::std::os::raw::c_uint;
pub const VkSamplerMipmapMode_VK_SAMPLER_MIPMAP_MODE_NEAREST: VkSamplerMipmapMode = 0;
pub const VkSamplerMipmapMode_VK_SAMPLER_MIPMAP_MODE_LINEAR: VkSamplerMipmapMode = 1;
pub const VkSamplerMipmapMode_VK_SAMPLER_MIPMAP_MODE_MAX_ENUM: VkSamplerMipmapMode = 2147483647;
pub type VkSamplerMipmapMode = ::std::os::raw::c_uint;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_SAMPLER: VkDescriptorType = 0;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER: VkDescriptorType = 1;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE: VkDescriptorType = 2;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_IMAGE: VkDescriptorType = 3;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER: VkDescriptorType = 4;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER: VkDescriptorType = 5;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER: VkDescriptorType = 6;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_BUFFER: VkDescriptorType = 7;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC: VkDescriptorType = 8;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC: VkDescriptorType = 9;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT: VkDescriptorType = 10;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT: VkDescriptorType =
    1000138000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR: VkDescriptorType =
    1000150000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV: VkDescriptorType =
    1000165000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_MUTABLE_VALVE: VkDescriptorType = 1000351000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_MAX_ENUM: VkDescriptorType = 2147483647;
pub type VkDescriptorType = ::std::os::raw::c_uint;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_LOAD: VkAttachmentLoadOp = 0;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_CLEAR: VkAttachmentLoadOp = 1;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_DONT_CARE: VkAttachmentLoadOp = 2;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_MAX_ENUM: VkAttachmentLoadOp = 2147483647;
pub type VkAttachmentLoadOp = ::std::os::raw::c_uint;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_STORE: VkAttachmentStoreOp = 0;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_DONT_CARE: VkAttachmentStoreOp = 1;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_NONE_QCOM: VkAttachmentStoreOp = 1000301000;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_MAX_ENUM: VkAttachmentStoreOp = 2147483647;
pub type VkAttachmentStoreOp = ::std::os::raw::c_uint;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_GRAPHICS: VkPipelineBindPoint = 0;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_COMPUTE: VkPipelineBindPoint = 1;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR: VkPipelineBindPoint =
    1000165000;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_RAY_TRACING_NV: VkPipelineBindPoint =
    1000165000;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_MAX_ENUM: VkPipelineBindPoint = 2147483647;
pub type VkPipelineBindPoint = ::std::os::raw::c_uint;
pub const VkCommandBufferLevel_VK_COMMAND_BUFFER_LEVEL_PRIMARY: VkCommandBufferLevel = 0;
pub const VkCommandBufferLevel_VK_COMMAND_BUFFER_LEVEL_SECONDARY: VkCommandBufferLevel = 1;
pub const VkCommandBufferLevel_VK_COMMAND_BUFFER_LEVEL_MAX_ENUM: VkCommandBufferLevel = 2147483647;
pub type VkCommandBufferLevel = ::std::os::raw::c_uint;
pub const VkIndexType_VK_INDEX_TYPE_UINT16: VkIndexType = 0;
pub const VkIndexType_VK_INDEX_TYPE_UINT32: VkIndexType = 1;
pub const VkIndexType_VK_INDEX_TYPE_NONE_KHR: VkIndexType = 1000165000;
pub const VkIndexType_VK_INDEX_TYPE_UINT8_EXT: VkIndexType = 1000265000;
pub const VkIndexType_VK_INDEX_TYPE_NONE_NV: VkIndexType = 1000165000;
pub const VkIndexType_VK_INDEX_TYPE_MAX_ENUM: VkIndexType = 2147483647;
pub type VkIndexType = ::std::os::raw::c_uint;
pub const VkSubpassContents_VK_SUBPASS_CONTENTS_INLINE: VkSubpassContents = 0;
pub const VkSubpassContents_VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS: VkSubpassContents = 1;
pub const VkSubpassContents_VK_SUBPASS_CONTENTS_MAX_ENUM: VkSubpassContents = 2147483647;
pub type VkSubpassContents = ::std::os::raw::c_uint;
pub const VkAccessFlagBits_VK_ACCESS_INDIRECT_COMMAND_READ_BIT: VkAccessFlagBits = 1;
pub const VkAccessFlagBits_VK_ACCESS_INDEX_READ_BIT: VkAccessFlagBits = 2;
pub const VkAccessFlagBits_VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT: VkAccessFlagBits = 4;
pub const VkAccessFlagBits_VK_ACCESS_UNIFORM_READ_BIT: VkAccessFlagBits = 8;
pub const VkAccessFlagBits_VK_ACCESS_INPUT_ATTACHMENT_READ_BIT: VkAccessFlagBits = 16;
pub const VkAccessFlagBits_VK_ACCESS_SHADER_READ_BIT: VkAccessFlagBits = 32;
pub const VkAccessFlagBits_VK_ACCESS_SHADER_WRITE_BIT: VkAccessFlagBits = 64;
pub const VkAccessFlagBits_VK_ACCESS_COLOR_ATTACHMENT_READ_BIT: VkAccessFlagBits = 128;
pub const VkAccessFlagBits_VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT: VkAccessFlagBits = 256;
pub const VkAccessFlagBits_VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT: VkAccessFlagBits = 512;
pub const VkAccessFlagBits_VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT: VkAccessFlagBits = 1024;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFER_READ_BIT: VkAccessFlagBits = 2048;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFER_WRITE_BIT: VkAccessFlagBits = 4096;
pub const VkAccessFlagBits_VK_ACCESS_HOST_READ_BIT: VkAccessFlagBits = 8192;
pub const VkAccessFlagBits_VK_ACCESS_HOST_WRITE_BIT: VkAccessFlagBits = 16384;
pub const VkAccessFlagBits_VK_ACCESS_MEMORY_READ_BIT: VkAccessFlagBits = 32768;
pub const VkAccessFlagBits_VK_ACCESS_MEMORY_WRITE_BIT: VkAccessFlagBits = 65536;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT: VkAccessFlagBits = 33554432;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT: VkAccessFlagBits =
    67108864;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT: VkAccessFlagBits =
    134217728;
pub const VkAccessFlagBits_VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT: VkAccessFlagBits = 1048576;
pub const VkAccessFlagBits_VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT: VkAccessFlagBits =
    524288;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR: VkAccessFlagBits =
    2097152;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR: VkAccessFlagBits =
    4194304;
pub const VkAccessFlagBits_VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV: VkAccessFlagBits = 8388608;
pub const VkAccessFlagBits_VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT: VkAccessFlagBits = 16777216;
pub const VkAccessFlagBits_VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV: VkAccessFlagBits = 131072;
pub const VkAccessFlagBits_VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV: VkAccessFlagBits = 262144;
pub const VkAccessFlagBits_VK_ACCESS_NONE_KHR: VkAccessFlagBits = 0;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV: VkAccessFlagBits = 2097152;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV: VkAccessFlagBits =
    4194304;
pub const VkAccessFlagBits_VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR:
    VkAccessFlagBits = 8388608;
pub const VkAccessFlagBits_VK_ACCESS_FLAG_BITS_MAX_ENUM: VkAccessFlagBits = 2147483647;
pub type VkAccessFlagBits = ::std::os::raw::c_uint;
pub type VkAccessFlags = VkFlags;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_COLOR_BIT: VkImageAspectFlagBits = 1;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_DEPTH_BIT: VkImageAspectFlagBits = 2;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_STENCIL_BIT: VkImageAspectFlagBits = 4;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_METADATA_BIT: VkImageAspectFlagBits = 8;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_0_BIT: VkImageAspectFlagBits = 16;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_1_BIT: VkImageAspectFlagBits = 32;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_2_BIT: VkImageAspectFlagBits = 64;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT: VkImageAspectFlagBits = 128;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT: VkImageAspectFlagBits = 256;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT: VkImageAspectFlagBits = 512;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT: VkImageAspectFlagBits =
    1024;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_0_BIT_KHR: VkImageAspectFlagBits = 16;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_1_BIT_KHR: VkImageAspectFlagBits = 32;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_2_BIT_KHR: VkImageAspectFlagBits = 64;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM: VkImageAspectFlagBits =
    2147483647;
pub type VkImageAspectFlagBits = ::std::os::raw::c_uint;
pub type VkImageAspectFlags = VkFlags;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT: VkFormatFeatureFlagBits = 1;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT: VkFormatFeatureFlagBits = 2;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT:
    VkFormatFeatureFlagBits = 4;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT:
    VkFormatFeatureFlagBits = 8;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT:
    VkFormatFeatureFlagBits = 16;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT:
    VkFormatFeatureFlagBits = 32;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT: VkFormatFeatureFlagBits = 64;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT: VkFormatFeatureFlagBits =
    128;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT:
    VkFormatFeatureFlagBits = 256;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT:
    VkFormatFeatureFlagBits = 512;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_BLIT_SRC_BIT: VkFormatFeatureFlagBits = 1024;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_BLIT_DST_BIT: VkFormatFeatureFlagBits = 2048;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT:
    VkFormatFeatureFlagBits = 4096;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_SRC_BIT: VkFormatFeatureFlagBits =
    16384;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_DST_BIT: VkFormatFeatureFlagBits =
    32768;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT:
    VkFormatFeatureFlagBits = 131072;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT : VkFormatFeatureFlagBits = 262144 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT : VkFormatFeatureFlagBits = 524288 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT : VkFormatFeatureFlagBits = 1048576 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT : VkFormatFeatureFlagBits = 2097152 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_DISJOINT_BIT: VkFormatFeatureFlagBits = 4194304;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT:
    VkFormatFeatureFlagBits = 8388608;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT:
    VkFormatFeatureFlagBits = 65536;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG:
    VkFormatFeatureFlagBits = 8192;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR:
    VkFormatFeatureFlagBits = 536870912;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT:
    VkFormatFeatureFlagBits = 16777216;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkFormatFeatureFlagBits = 1073741824;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR: VkFormatFeatureFlagBits =
    16384;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR: VkFormatFeatureFlagBits =
    32768;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT:
    VkFormatFeatureFlagBits = 65536;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR:
    VkFormatFeatureFlagBits = 131072;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR : VkFormatFeatureFlagBits = 262144 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR : VkFormatFeatureFlagBits = 524288 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR : VkFormatFeatureFlagBits = 1048576 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR : VkFormatFeatureFlagBits = 2097152 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_DISJOINT_BIT_KHR: VkFormatFeatureFlagBits =
    4194304;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR:
    VkFormatFeatureFlagBits = 8388608;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT:
    VkFormatFeatureFlagBits = 8192;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM: VkFormatFeatureFlagBits =
    2147483647;
pub type VkFormatFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkFormatFeatureFlags = VkFlags;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPARSE_BINDING_BIT: VkImageCreateFlagBits = 1;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT: VkImageCreateFlagBits = 2;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPARSE_ALIASED_BIT: VkImageCreateFlagBits = 4;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT: VkImageCreateFlagBits = 8;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT: VkImageCreateFlagBits = 16;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_ALIAS_BIT: VkImageCreateFlagBits = 1024;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT:
    VkImageCreateFlagBits = 64;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT: VkImageCreateFlagBits = 32;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT:
    VkImageCreateFlagBits = 128;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_EXTENDED_USAGE_BIT: VkImageCreateFlagBits = 256;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_PROTECTED_BIT: VkImageCreateFlagBits = 2048;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_DISJOINT_BIT: VkImageCreateFlagBits = 512;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV: VkImageCreateFlagBits = 8192;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT:
    VkImageCreateFlagBits = 4096;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT: VkImageCreateFlagBits = 16384;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR:
    VkImageCreateFlagBits = 64;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR: VkImageCreateFlagBits =
    32;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR:
    VkImageCreateFlagBits = 128;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR: VkImageCreateFlagBits = 256;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_DISJOINT_BIT_KHR: VkImageCreateFlagBits = 512;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_ALIAS_BIT_KHR: VkImageCreateFlagBits = 1024;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM: VkImageCreateFlagBits =
    2147483647;
pub type VkImageCreateFlagBits = ::std::os::raw::c_uint;
pub type VkImageCreateFlags = VkFlags;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_1_BIT: VkSampleCountFlagBits = 1;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_2_BIT: VkSampleCountFlagBits = 2;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_4_BIT: VkSampleCountFlagBits = 4;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_8_BIT: VkSampleCountFlagBits = 8;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_16_BIT: VkSampleCountFlagBits = 16;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_32_BIT: VkSampleCountFlagBits = 32;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_64_BIT: VkSampleCountFlagBits = 64;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_FLAG_BITS_MAX_ENUM: VkSampleCountFlagBits =
    2147483647;
pub type VkSampleCountFlagBits = ::std::os::raw::c_uint;
pub type VkSampleCountFlags = VkFlags;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_TRANSFER_SRC_BIT: VkImageUsageFlagBits = 1;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_TRANSFER_DST_BIT: VkImageUsageFlagBits = 2;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_SAMPLED_BIT: VkImageUsageFlagBits = 4;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_STORAGE_BIT: VkImageUsageFlagBits = 8;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT: VkImageUsageFlagBits = 16;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT: VkImageUsageFlagBits =
    32;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT: VkImageUsageFlagBits = 64;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT: VkImageUsageFlagBits = 128;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV: VkImageUsageFlagBits = 256;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT: VkImageUsageFlagBits =
    512;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkImageUsageFlagBits = 256;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM: VkImageUsageFlagBits = 2147483647;
pub type VkImageUsageFlagBits = ::std::os::raw::c_uint;
pub type VkImageUsageFlags = VkFlags;
pub type VkInstanceCreateFlags = VkFlags;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_DEVICE_LOCAL_BIT: VkMemoryHeapFlagBits = 1;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_MULTI_INSTANCE_BIT: VkMemoryHeapFlagBits = 2;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR: VkMemoryHeapFlagBits = 2;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_FLAG_BITS_MAX_ENUM: VkMemoryHeapFlagBits = 2147483647;
pub type VkMemoryHeapFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryHeapFlags = VkFlags;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT: VkMemoryPropertyFlagBits =
    1;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT: VkMemoryPropertyFlagBits =
    2;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_HOST_COHERENT_BIT: VkMemoryPropertyFlagBits =
    4;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_HOST_CACHED_BIT: VkMemoryPropertyFlagBits = 8;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT:
    VkMemoryPropertyFlagBits = 16;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_PROTECTED_BIT: VkMemoryPropertyFlagBits = 32;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD:
    VkMemoryPropertyFlagBits = 64;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD:
    VkMemoryPropertyFlagBits = 128;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_FLAG_BITS_MAX_ENUM: VkMemoryPropertyFlagBits =
    2147483647;
pub type VkMemoryPropertyFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryPropertyFlags = VkFlags;
pub const VkQueueFlagBits_VK_QUEUE_GRAPHICS_BIT: VkQueueFlagBits = 1;
pub const VkQueueFlagBits_VK_QUEUE_COMPUTE_BIT: VkQueueFlagBits = 2;
pub const VkQueueFlagBits_VK_QUEUE_TRANSFER_BIT: VkQueueFlagBits = 4;
pub const VkQueueFlagBits_VK_QUEUE_SPARSE_BINDING_BIT: VkQueueFlagBits = 8;
pub const VkQueueFlagBits_VK_QUEUE_PROTECTED_BIT: VkQueueFlagBits = 16;
pub const VkQueueFlagBits_VK_QUEUE_FLAG_BITS_MAX_ENUM: VkQueueFlagBits = 2147483647;
pub type VkQueueFlagBits = ::std::os::raw::c_uint;
pub type VkQueueFlags = VkFlags;
pub type VkDeviceCreateFlags = VkFlags;
pub const VkDeviceQueueCreateFlagBits_VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT:
    VkDeviceQueueCreateFlagBits = 1;
pub const VkDeviceQueueCreateFlagBits_VK_DEVICE_QUEUE_CREATE_FLAG_BITS_MAX_ENUM:
    VkDeviceQueueCreateFlagBits = 2147483647;
pub type VkDeviceQueueCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDeviceQueueCreateFlags = VkFlags;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT: VkPipelineStageFlagBits = 1;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT: VkPipelineStageFlagBits = 2;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_VERTEX_INPUT_BIT: VkPipelineStageFlagBits = 4;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_VERTEX_SHADER_BIT: VkPipelineStageFlagBits = 8;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT:
    VkPipelineStageFlagBits = 16;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT:
    VkPipelineStageFlagBits = 32;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT: VkPipelineStageFlagBits =
    64;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT: VkPipelineStageFlagBits =
    128;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT:
    VkPipelineStageFlagBits = 256;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT:
    VkPipelineStageFlagBits = 512;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT:
    VkPipelineStageFlagBits = 1024;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT: VkPipelineStageFlagBits =
    2048;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TRANSFER_BIT: VkPipelineStageFlagBits = 4096;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT: VkPipelineStageFlagBits =
    8192;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_HOST_BIT: VkPipelineStageFlagBits = 16384;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT: VkPipelineStageFlagBits =
    32768;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ALL_COMMANDS_BIT: VkPipelineStageFlagBits =
    65536;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT:
    VkPipelineStageFlagBits = 16777216;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT:
    VkPipelineStageFlagBits = 262144;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR:
    VkPipelineStageFlagBits = 33554432;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR:
    VkPipelineStageFlagBits = 2097152;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV:
    VkPipelineStageFlagBits = 4194304;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV: VkPipelineStageFlagBits =
    524288;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV: VkPipelineStageFlagBits =
    1048576;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT:
    VkPipelineStageFlagBits = 8388608;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV:
    VkPipelineStageFlagBits = 131072;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_NONE_KHR: VkPipelineStageFlagBits = 0;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_NV:
    VkPipelineStageFlagBits = 2097152;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_NV:
    VkPipelineStageFlagBits = 33554432;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkPipelineStageFlagBits = 4194304;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM: VkPipelineStageFlagBits =
    2147483647;
pub type VkPipelineStageFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineStageFlags = VkFlags;
pub type VkMemoryMapFlags = VkFlags;
pub const VkSparseMemoryBindFlagBits_VK_SPARSE_MEMORY_BIND_METADATA_BIT:
    VkSparseMemoryBindFlagBits = 1;
pub const VkSparseMemoryBindFlagBits_VK_SPARSE_MEMORY_BIND_FLAG_BITS_MAX_ENUM:
    VkSparseMemoryBindFlagBits = 2147483647;
pub type VkSparseMemoryBindFlagBits = ::std::os::raw::c_uint;
pub type VkSparseMemoryBindFlags = VkFlags;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT:
    VkSparseImageFormatFlagBits = 1;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT:
    VkSparseImageFormatFlagBits = 2;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT:
    VkSparseImageFormatFlagBits = 4;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_FLAG_BITS_MAX_ENUM:
    VkSparseImageFormatFlagBits = 2147483647;
pub type VkSparseImageFormatFlagBits = ::std::os::raw::c_uint;
pub type VkSparseImageFormatFlags = VkFlags;
pub const VkFenceCreateFlagBits_VK_FENCE_CREATE_SIGNALED_BIT: VkFenceCreateFlagBits = 1;
pub const VkFenceCreateFlagBits_VK_FENCE_CREATE_FLAG_BITS_MAX_ENUM: VkFenceCreateFlagBits =
    2147483647;
pub type VkFenceCreateFlagBits = ::std::os::raw::c_uint;
pub type VkFenceCreateFlags = VkFlags;
pub type VkSemaphoreCreateFlags = VkFlags;
pub const VkEventCreateFlagBits_VK_EVENT_CREATE_DEVICE_ONLY_BIT_KHR: VkEventCreateFlagBits = 1;
pub const VkEventCreateFlagBits_VK_EVENT_CREATE_FLAG_BITS_MAX_ENUM: VkEventCreateFlagBits =
    2147483647;
pub type VkEventCreateFlagBits = ::std::os::raw::c_uint;
pub type VkEventCreateFlags = VkFlags;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT : VkQueryPipelineStatisticFlagBits = 1 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT : VkQueryPipelineStatisticFlagBits = 2 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 4 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 8 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT : VkQueryPipelineStatisticFlagBits = 16 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT:
    VkQueryPipelineStatisticFlagBits = 32;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT:
    VkQueryPipelineStatisticFlagBits = 64;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 128 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT : VkQueryPipelineStatisticFlagBits = 256 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 512 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 1024 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM:
    VkQueryPipelineStatisticFlagBits = 2147483647;
pub type VkQueryPipelineStatisticFlagBits = ::std::os::raw::c_uint;
pub type VkQueryPipelineStatisticFlags = VkFlags;
pub type VkQueryPoolCreateFlags = VkFlags;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_64_BIT: VkQueryResultFlagBits = 1;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_WAIT_BIT: VkQueryResultFlagBits = 2;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_WITH_AVAILABILITY_BIT: VkQueryResultFlagBits = 4;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_PARTIAL_BIT: VkQueryResultFlagBits = 8;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_FLAG_BITS_MAX_ENUM: VkQueryResultFlagBits =
    2147483647;
pub type VkQueryResultFlagBits = ::std::os::raw::c_uint;
pub type VkQueryResultFlags = VkFlags;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_SPARSE_BINDING_BIT: VkBufferCreateFlagBits = 1;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT: VkBufferCreateFlagBits = 2;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_SPARSE_ALIASED_BIT: VkBufferCreateFlagBits = 4;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_PROTECTED_BIT: VkBufferCreateFlagBits = 8;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT:
    VkBufferCreateFlagBits = 16;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT:
    VkBufferCreateFlagBits = 16;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR:
    VkBufferCreateFlagBits = 16;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_FLAG_BITS_MAX_ENUM: VkBufferCreateFlagBits =
    2147483647;
pub type VkBufferCreateFlagBits = ::std::os::raw::c_uint;
pub type VkBufferCreateFlags = VkFlags;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFER_SRC_BIT: VkBufferUsageFlagBits = 1;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFER_DST_BIT: VkBufferUsageFlagBits = 2;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT: VkBufferUsageFlagBits = 4;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT: VkBufferUsageFlagBits = 8;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT: VkBufferUsageFlagBits = 16;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_STORAGE_BUFFER_BIT: VkBufferUsageFlagBits = 32;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_INDEX_BUFFER_BIT: VkBufferUsageFlagBits = 64;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_VERTEX_BUFFER_BIT: VkBufferUsageFlagBits = 128;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT: VkBufferUsageFlagBits = 256;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT: VkBufferUsageFlagBits =
    131072;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT:
    VkBufferUsageFlagBits = 2048;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT:
    VkBufferUsageFlagBits = 4096;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT:
    VkBufferUsageFlagBits = 512;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR : VkBufferUsageFlagBits = 524288 ;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR:
    VkBufferUsageFlagBits = 1048576;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR:
    VkBufferUsageFlagBits = 1024;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_RAY_TRACING_BIT_NV: VkBufferUsageFlagBits = 1024;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_EXT:
    VkBufferUsageFlagBits = 131072;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_KHR:
    VkBufferUsageFlagBits = 131072;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_FLAG_BITS_MAX_ENUM: VkBufferUsageFlagBits =
    2147483647;
pub type VkBufferUsageFlagBits = ::std::os::raw::c_uint;
pub type VkBufferUsageFlags = VkFlags;
pub type VkBufferViewCreateFlags = VkFlags;
pub const VkImageViewCreateFlagBits_VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT:
    VkImageViewCreateFlagBits = 1;
pub const VkImageViewCreateFlagBits_VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT:
    VkImageViewCreateFlagBits = 2;
pub const VkImageViewCreateFlagBits_VK_IMAGE_VIEW_CREATE_FLAG_BITS_MAX_ENUM:
    VkImageViewCreateFlagBits = 2147483647;
pub type VkImageViewCreateFlagBits = ::std::os::raw::c_uint;
pub type VkImageViewCreateFlags = VkFlags;
pub const VkShaderModuleCreateFlagBits_VK_SHADER_MODULE_CREATE_FLAG_BITS_MAX_ENUM:
    VkShaderModuleCreateFlagBits = 2147483647;
pub type VkShaderModuleCreateFlagBits = ::std::os::raw::c_uint;
pub type VkShaderModuleCreateFlags = VkFlags;
pub const VkPipelineCacheCreateFlagBits_VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT_EXT:
    VkPipelineCacheCreateFlagBits = 1;
pub const VkPipelineCacheCreateFlagBits_VK_PIPELINE_CACHE_CREATE_FLAG_BITS_MAX_ENUM:
    VkPipelineCacheCreateFlagBits = 2147483647;
pub type VkPipelineCacheCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineCacheCreateFlags = VkFlags;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_R_BIT: VkColorComponentFlagBits = 1;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_G_BIT: VkColorComponentFlagBits = 2;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_B_BIT: VkColorComponentFlagBits = 4;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_A_BIT: VkColorComponentFlagBits = 8;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_FLAG_BITS_MAX_ENUM: VkColorComponentFlagBits =
    2147483647;
pub type VkColorComponentFlagBits = ::std::os::raw::c_uint;
pub type VkColorComponentFlags = VkFlags;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT:
    VkPipelineCreateFlagBits = 1;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT:
    VkPipelineCreateFlagBits = 2;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DERIVATIVE_BIT: VkPipelineCreateFlagBits = 4;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT:
    VkPipelineCreateFlagBits = 8;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISPATCH_BASE_BIT: VkPipelineCreateFlagBits =
    16;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 16384 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 32768 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR:
    VkPipelineCreateFlagBits = 65536;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 131072 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR:
    VkPipelineCreateFlagBits = 4096;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR:
    VkPipelineCreateFlagBits = 8192;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR : VkPipelineCreateFlagBits = 524288 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV:
    VkPipelineCreateFlagBits = 32;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR:
    VkPipelineCreateFlagBits = 64;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR:
    VkPipelineCreateFlagBits = 128;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV:
    VkPipelineCreateFlagBits = 262144;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_LIBRARY_BIT_KHR: VkPipelineCreateFlagBits =
    2048;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT:
    VkPipelineCreateFlagBits = 256;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT:
    VkPipelineCreateFlagBits = 512;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISPATCH_BASE: VkPipelineCreateFlagBits = 16;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR:
    VkPipelineCreateFlagBits = 8;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISPATCH_BASE_KHR: VkPipelineCreateFlagBits =
    16;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_FLAG_BITS_MAX_ENUM: VkPipelineCreateFlagBits =
    2147483647;
pub type VkPipelineCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineCreateFlags = VkFlags;
pub const VkPipelineShaderStageCreateFlagBits_VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT : VkPipelineShaderStageCreateFlagBits = 1 ;
pub const VkPipelineShaderStageCreateFlagBits_VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT : VkPipelineShaderStageCreateFlagBits = 2 ;
pub const VkPipelineShaderStageCreateFlagBits_VK_PIPELINE_SHADER_STAGE_CREATE_FLAG_BITS_MAX_ENUM:
    VkPipelineShaderStageCreateFlagBits = 2147483647;
pub type VkPipelineShaderStageCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineShaderStageCreateFlags = VkFlags;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_VERTEX_BIT: VkShaderStageFlagBits = 1;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT: VkShaderStageFlagBits = 2;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT: VkShaderStageFlagBits =
    4;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_GEOMETRY_BIT: VkShaderStageFlagBits = 8;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_FRAGMENT_BIT: VkShaderStageFlagBits = 16;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_COMPUTE_BIT: VkShaderStageFlagBits = 32;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ALL_GRAPHICS: VkShaderStageFlagBits = 31;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ALL: VkShaderStageFlagBits = 2147483647;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_RAYGEN_BIT_KHR: VkShaderStageFlagBits = 256;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ANY_HIT_BIT_KHR: VkShaderStageFlagBits = 512;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR: VkShaderStageFlagBits = 1024;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_MISS_BIT_KHR: VkShaderStageFlagBits = 2048;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_INTERSECTION_BIT_KHR: VkShaderStageFlagBits = 4096;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CALLABLE_BIT_KHR: VkShaderStageFlagBits = 8192;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_TASK_BIT_NV: VkShaderStageFlagBits = 64;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_MESH_BIT_NV: VkShaderStageFlagBits = 128;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_RAYGEN_BIT_NV: VkShaderStageFlagBits = 256;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ANY_HIT_BIT_NV: VkShaderStageFlagBits = 512;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV: VkShaderStageFlagBits = 1024;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_MISS_BIT_NV: VkShaderStageFlagBits = 2048;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_INTERSECTION_BIT_NV: VkShaderStageFlagBits = 4096;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CALLABLE_BIT_NV: VkShaderStageFlagBits = 8192;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM: VkShaderStageFlagBits =
    2147483647;
pub type VkShaderStageFlagBits = ::std::os::raw::c_uint;
pub const VkCullModeFlagBits_VK_CULL_MODE_NONE: VkCullModeFlagBits = 0;
pub const VkCullModeFlagBits_VK_CULL_MODE_FRONT_BIT: VkCullModeFlagBits = 1;
pub const VkCullModeFlagBits_VK_CULL_MODE_BACK_BIT: VkCullModeFlagBits = 2;
pub const VkCullModeFlagBits_VK_CULL_MODE_FRONT_AND_BACK: VkCullModeFlagBits = 3;
pub const VkCullModeFlagBits_VK_CULL_MODE_FLAG_BITS_MAX_ENUM: VkCullModeFlagBits = 2147483647;
pub type VkCullModeFlagBits = ::std::os::raw::c_uint;
pub type VkCullModeFlags = VkFlags;
pub type VkPipelineVertexInputStateCreateFlags = VkFlags;
pub type VkPipelineInputAssemblyStateCreateFlags = VkFlags;
pub type VkPipelineTessellationStateCreateFlags = VkFlags;
pub type VkPipelineViewportStateCreateFlags = VkFlags;
pub type VkPipelineRasterizationStateCreateFlags = VkFlags;
pub type VkPipelineMultisampleStateCreateFlags = VkFlags;
pub type VkPipelineDepthStencilStateCreateFlags = VkFlags;
pub type VkPipelineColorBlendStateCreateFlags = VkFlags;
pub type VkPipelineDynamicStateCreateFlags = VkFlags;
pub type VkPipelineLayoutCreateFlags = VkFlags;
pub type VkShaderStageFlags = VkFlags;
pub const VkSamplerCreateFlagBits_VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT: VkSamplerCreateFlagBits = 1;
pub const VkSamplerCreateFlagBits_VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT:
    VkSamplerCreateFlagBits = 2;
pub const VkSamplerCreateFlagBits_VK_SAMPLER_CREATE_FLAG_BITS_MAX_ENUM: VkSamplerCreateFlagBits =
    2147483647;
pub type VkSamplerCreateFlagBits = ::std::os::raw::c_uint;
pub type VkSamplerCreateFlags = VkFlags;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT:
    VkDescriptorPoolCreateFlagBits = 1;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT:
    VkDescriptorPoolCreateFlagBits = 2;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE:
    VkDescriptorPoolCreateFlagBits = 4;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT_EXT:
    VkDescriptorPoolCreateFlagBits = 2;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_FLAG_BITS_MAX_ENUM:
    VkDescriptorPoolCreateFlagBits = 2147483647;
pub type VkDescriptorPoolCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorPoolCreateFlags = VkFlags;
pub type VkDescriptorPoolResetFlags = VkFlags;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT : VkDescriptorSetLayoutCreateFlagBits = 2 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR : VkDescriptorSetLayoutCreateFlagBits = 1 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE : VkDescriptorSetLayoutCreateFlagBits = 4 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT_EXT : VkDescriptorSetLayoutCreateFlagBits = 2 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_FLAG_BITS_MAX_ENUM:
    VkDescriptorSetLayoutCreateFlagBits = 2147483647;
pub type VkDescriptorSetLayoutCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorSetLayoutCreateFlags = VkFlags;
pub const VkAttachmentDescriptionFlagBits_VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT:
    VkAttachmentDescriptionFlagBits = 1;
pub const VkAttachmentDescriptionFlagBits_VK_ATTACHMENT_DESCRIPTION_FLAG_BITS_MAX_ENUM:
    VkAttachmentDescriptionFlagBits = 2147483647;
pub type VkAttachmentDescriptionFlagBits = ::std::os::raw::c_uint;
pub type VkAttachmentDescriptionFlags = VkFlags;
pub const VkDependencyFlagBits_VK_DEPENDENCY_BY_REGION_BIT: VkDependencyFlagBits = 1;
pub const VkDependencyFlagBits_VK_DEPENDENCY_DEVICE_GROUP_BIT: VkDependencyFlagBits = 4;
pub const VkDependencyFlagBits_VK_DEPENDENCY_VIEW_LOCAL_BIT: VkDependencyFlagBits = 2;
pub const VkDependencyFlagBits_VK_DEPENDENCY_VIEW_LOCAL_BIT_KHR: VkDependencyFlagBits = 2;
pub const VkDependencyFlagBits_VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR: VkDependencyFlagBits = 4;
pub const VkDependencyFlagBits_VK_DEPENDENCY_FLAG_BITS_MAX_ENUM: VkDependencyFlagBits = 2147483647;
pub type VkDependencyFlagBits = ::std::os::raw::c_uint;
pub type VkDependencyFlags = VkFlags;
pub const VkFramebufferCreateFlagBits_VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT:
    VkFramebufferCreateFlagBits = 1;
pub const VkFramebufferCreateFlagBits_VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT_KHR:
    VkFramebufferCreateFlagBits = 1;
pub const VkFramebufferCreateFlagBits_VK_FRAMEBUFFER_CREATE_FLAG_BITS_MAX_ENUM:
    VkFramebufferCreateFlagBits = 2147483647;
pub type VkFramebufferCreateFlagBits = ::std::os::raw::c_uint;
pub type VkFramebufferCreateFlags = VkFlags;
pub const VkRenderPassCreateFlagBits_VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM:
    VkRenderPassCreateFlagBits = 2;
pub const VkRenderPassCreateFlagBits_VK_RENDER_PASS_CREATE_FLAG_BITS_MAX_ENUM:
    VkRenderPassCreateFlagBits = 2147483647;
pub type VkRenderPassCreateFlagBits = ::std::os::raw::c_uint;
pub type VkRenderPassCreateFlags = VkFlags;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX:
    VkSubpassDescriptionFlagBits = 1;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX:
    VkSubpassDescriptionFlagBits = 2;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM:
    VkSubpassDescriptionFlagBits = 4;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM:
    VkSubpassDescriptionFlagBits = 8;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_FLAG_BITS_MAX_ENUM:
    VkSubpassDescriptionFlagBits = 2147483647;
pub type VkSubpassDescriptionFlagBits = ::std::os::raw::c_uint;
pub type VkSubpassDescriptionFlags = VkFlags;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_TRANSIENT_BIT:
    VkCommandPoolCreateFlagBits = 1;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT:
    VkCommandPoolCreateFlagBits = 2;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_PROTECTED_BIT:
    VkCommandPoolCreateFlagBits = 4;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_FLAG_BITS_MAX_ENUM:
    VkCommandPoolCreateFlagBits = 2147483647;
pub type VkCommandPoolCreateFlagBits = ::std::os::raw::c_uint;
pub type VkCommandPoolCreateFlags = VkFlags;
pub const VkCommandPoolResetFlagBits_VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT:
    VkCommandPoolResetFlagBits = 1;
pub const VkCommandPoolResetFlagBits_VK_COMMAND_POOL_RESET_FLAG_BITS_MAX_ENUM:
    VkCommandPoolResetFlagBits = 2147483647;
pub type VkCommandPoolResetFlagBits = ::std::os::raw::c_uint;
pub type VkCommandPoolResetFlags = VkFlags;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT:
    VkCommandBufferUsageFlagBits = 1;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT:
    VkCommandBufferUsageFlagBits = 2;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT:
    VkCommandBufferUsageFlagBits = 4;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_FLAG_BITS_MAX_ENUM:
    VkCommandBufferUsageFlagBits = 2147483647;
pub type VkCommandBufferUsageFlagBits = ::std::os::raw::c_uint;
pub type VkCommandBufferUsageFlags = VkFlags;
pub const VkQueryControlFlagBits_VK_QUERY_CONTROL_PRECISE_BIT: VkQueryControlFlagBits = 1;
pub const VkQueryControlFlagBits_VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM: VkQueryControlFlagBits =
    2147483647;
pub type VkQueryControlFlagBits = ::std::os::raw::c_uint;
pub type VkQueryControlFlags = VkFlags;
pub const VkCommandBufferResetFlagBits_VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT:
    VkCommandBufferResetFlagBits = 1;
pub const VkCommandBufferResetFlagBits_VK_COMMAND_BUFFER_RESET_FLAG_BITS_MAX_ENUM:
    VkCommandBufferResetFlagBits = 2147483647;
pub type VkCommandBufferResetFlagBits = ::std::os::raw::c_uint;
pub type VkCommandBufferResetFlags = VkFlags;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_FRONT_BIT: VkStencilFaceFlagBits = 1;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_BACK_BIT: VkStencilFaceFlagBits = 2;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_FRONT_AND_BACK: VkStencilFaceFlagBits = 3;
pub const VkStencilFaceFlagBits_VK_STENCIL_FRONT_AND_BACK: VkStencilFaceFlagBits = 3;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_FLAG_BITS_MAX_ENUM: VkStencilFaceFlagBits =
    2147483647;
pub type VkStencilFaceFlagBits = ::std::os::raw::c_uint;
pub type VkStencilFaceFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtent2D {
    pub width: u32,
    pub height: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkOffset2D {
    pub x: i32,
    pub y: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkOffset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRect2D {
    pub offset: VkOffset2D,
    pub extent: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBaseInStructure {
    pub sType: VkStructureType,
    pub pNext: *const VkBaseInStructure,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBaseOutStructure {
    pub sType: VkStructureType,
    pub pNext: *mut VkBaseOutStructure,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawIndexedIndirectCommand {
    pub indexCount: u32,
    pub instanceCount: u32,
    pub firstIndex: u32,
    pub vertexOffset: i32,
    pub firstInstance: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawIndirectCommand {
    pub vertexCount: u32,
    pub instanceCount: u32,
    pub firstVertex: u32,
    pub firstInstance: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresourceRange {
    pub aspectMask: VkImageAspectFlags,
    pub baseMipLevel: u32,
    pub levelCount: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub oldLayout: VkImageLayout,
    pub newLayout: VkImageLayout,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub image: VkImage,
    pub subresourceRange: VkImageSubresourceRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
}
pub type PFN_vkAllocationFunction = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        alignment: size_t,
        allocationScope: VkSystemAllocationScope,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type PFN_vkFreeFunction = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        pMemory: *mut ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkInternalAllocationNotification = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        allocationType: VkInternalAllocationType,
        allocationScope: VkSystemAllocationScope,
    ),
>;
pub type PFN_vkInternalFreeNotification = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        allocationType: VkInternalAllocationType,
        allocationScope: VkSystemAllocationScope,
    ),
>;
pub type PFN_vkReallocationFunction = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        pOriginal: *mut ::std::os::raw::c_void,
        size: size_t,
        alignment: size_t,
        allocationScope: VkSystemAllocationScope,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type PFN_vkVoidFunction = ::std::option::Option<unsafe extern "C" fn()>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAllocationCallbacks {
    pub pUserData: *mut ::std::os::raw::c_void,
    pub pfnAllocation: PFN_vkAllocationFunction,
    pub pfnReallocation: PFN_vkReallocationFunction,
    pub pfnFree: PFN_vkFreeFunction,
    pub pfnInternalAllocation: PFN_vkInternalAllocationNotification,
    pub pfnInternalFree: PFN_vkInternalFreeNotification,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkApplicationInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pApplicationName: *const ::std::os::raw::c_char,
    pub applicationVersion: u32,
    pub pEngineName: *const ::std::os::raw::c_char,
    pub engineVersion: u32,
    pub apiVersion: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFormatProperties {
    pub linearTilingFeatures: VkFormatFeatureFlags,
    pub optimalTilingFeatures: VkFormatFeatureFlags,
    pub bufferFeatures: VkFormatFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatProperties {
    pub maxExtent: VkExtent3D,
    pub maxMipLevels: u32,
    pub maxArrayLayers: u32,
    pub sampleCounts: VkSampleCountFlags,
    pub maxResourceSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInstanceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkInstanceCreateFlags,
    pub pApplicationInfo: *const VkApplicationInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const ::std::os::raw::c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryHeap {
    pub size: VkDeviceSize,
    pub flags: VkMemoryHeapFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryType {
    pub propertyFlags: VkMemoryPropertyFlags,
    pub heapIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFeatures {
    pub robustBufferAccess: VkBool32,
    pub fullDrawIndexUint32: VkBool32,
    pub imageCubeArray: VkBool32,
    pub independentBlend: VkBool32,
    pub geometryShader: VkBool32,
    pub tessellationShader: VkBool32,
    pub sampleRateShading: VkBool32,
    pub dualSrcBlend: VkBool32,
    pub logicOp: VkBool32,
    pub multiDrawIndirect: VkBool32,
    pub drawIndirectFirstInstance: VkBool32,
    pub depthClamp: VkBool32,
    pub depthBiasClamp: VkBool32,
    pub fillModeNonSolid: VkBool32,
    pub depthBounds: VkBool32,
    pub wideLines: VkBool32,
    pub largePoints: VkBool32,
    pub alphaToOne: VkBool32,
    pub multiViewport: VkBool32,
    pub samplerAnisotropy: VkBool32,
    pub textureCompressionETC2: VkBool32,
    pub textureCompressionASTC_LDR: VkBool32,
    pub textureCompressionBC: VkBool32,
    pub occlusionQueryPrecise: VkBool32,
    pub pipelineStatisticsQuery: VkBool32,
    pub vertexPipelineStoresAndAtomics: VkBool32,
    pub fragmentStoresAndAtomics: VkBool32,
    pub shaderTessellationAndGeometryPointSize: VkBool32,
    pub shaderImageGatherExtended: VkBool32,
    pub shaderStorageImageExtendedFormats: VkBool32,
    pub shaderStorageImageMultisample: VkBool32,
    pub shaderStorageImageReadWithoutFormat: VkBool32,
    pub shaderStorageImageWriteWithoutFormat: VkBool32,
    pub shaderUniformBufferArrayDynamicIndexing: VkBool32,
    pub shaderSampledImageArrayDynamicIndexing: VkBool32,
    pub shaderStorageBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageImageArrayDynamicIndexing: VkBool32,
    pub shaderClipDistance: VkBool32,
    pub shaderCullDistance: VkBool32,
    pub shaderFloat64: VkBool32,
    pub shaderInt64: VkBool32,
    pub shaderInt16: VkBool32,
    pub shaderResourceResidency: VkBool32,
    pub shaderResourceMinLod: VkBool32,
    pub sparseBinding: VkBool32,
    pub sparseResidencyBuffer: VkBool32,
    pub sparseResidencyImage2D: VkBool32,
    pub sparseResidencyImage3D: VkBool32,
    pub sparseResidency2Samples: VkBool32,
    pub sparseResidency4Samples: VkBool32,
    pub sparseResidency8Samples: VkBool32,
    pub sparseResidency16Samples: VkBool32,
    pub sparseResidencyAliased: VkBool32,
    pub variableMultisampleRate: VkBool32,
    pub inheritedQueries: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLimits {
    pub maxImageDimension1D: u32,
    pub maxImageDimension2D: u32,
    pub maxImageDimension3D: u32,
    pub maxImageDimensionCube: u32,
    pub maxImageArrayLayers: u32,
    pub maxTexelBufferElements: u32,
    pub maxUniformBufferRange: u32,
    pub maxStorageBufferRange: u32,
    pub maxPushConstantsSize: u32,
    pub maxMemoryAllocationCount: u32,
    pub maxSamplerAllocationCount: u32,
    pub bufferImageGranularity: VkDeviceSize,
    pub sparseAddressSpaceSize: VkDeviceSize,
    pub maxBoundDescriptorSets: u32,
    pub maxPerStageDescriptorSamplers: u32,
    pub maxPerStageDescriptorUniformBuffers: u32,
    pub maxPerStageDescriptorStorageBuffers: u32,
    pub maxPerStageDescriptorSampledImages: u32,
    pub maxPerStageDescriptorStorageImages: u32,
    pub maxPerStageDescriptorInputAttachments: u32,
    pub maxPerStageResources: u32,
    pub maxDescriptorSetSamplers: u32,
    pub maxDescriptorSetUniformBuffers: u32,
    pub maxDescriptorSetUniformBuffersDynamic: u32,
    pub maxDescriptorSetStorageBuffers: u32,
    pub maxDescriptorSetStorageBuffersDynamic: u32,
    pub maxDescriptorSetSampledImages: u32,
    pub maxDescriptorSetStorageImages: u32,
    pub maxDescriptorSetInputAttachments: u32,
    pub maxVertexInputAttributes: u32,
    pub maxVertexInputBindings: u32,
    pub maxVertexInputAttributeOffset: u32,
    pub maxVertexInputBindingStride: u32,
    pub maxVertexOutputComponents: u32,
    pub maxTessellationGenerationLevel: u32,
    pub maxTessellationPatchSize: u32,
    pub maxTessellationControlPerVertexInputComponents: u32,
    pub maxTessellationControlPerVertexOutputComponents: u32,
    pub maxTessellationControlPerPatchOutputComponents: u32,
    pub maxTessellationControlTotalOutputComponents: u32,
    pub maxTessellationEvaluationInputComponents: u32,
    pub maxTessellationEvaluationOutputComponents: u32,
    pub maxGeometryShaderInvocations: u32,
    pub maxGeometryInputComponents: u32,
    pub maxGeometryOutputComponents: u32,
    pub maxGeometryOutputVertices: u32,
    pub maxGeometryTotalOutputComponents: u32,
    pub maxFragmentInputComponents: u32,
    pub maxFragmentOutputAttachments: u32,
    pub maxFragmentDualSrcAttachments: u32,
    pub maxFragmentCombinedOutputResources: u32,
    pub maxComputeSharedMemorySize: u32,
    pub maxComputeWorkGroupCount: [u32; 3usize],
    pub maxComputeWorkGroupInvocations: u32,
    pub maxComputeWorkGroupSize: [u32; 3usize],
    pub subPixelPrecisionBits: u32,
    pub subTexelPrecisionBits: u32,
    pub mipmapPrecisionBits: u32,
    pub maxDrawIndexedIndexValue: u32,
    pub maxDrawIndirectCount: u32,
    pub maxSamplerLodBias: f32,
    pub maxSamplerAnisotropy: f32,
    pub maxViewports: u32,
    pub maxViewportDimensions: [u32; 2usize],
    pub viewportBoundsRange: [f32; 2usize],
    pub viewportSubPixelBits: u32,
    pub minMemoryMapAlignment: size_t,
    pub minTexelBufferOffsetAlignment: VkDeviceSize,
    pub minUniformBufferOffsetAlignment: VkDeviceSize,
    pub minStorageBufferOffsetAlignment: VkDeviceSize,
    pub minTexelOffset: i32,
    pub maxTexelOffset: u32,
    pub minTexelGatherOffset: i32,
    pub maxTexelGatherOffset: u32,
    pub minInterpolationOffset: f32,
    pub maxInterpolationOffset: f32,
    pub subPixelInterpolationOffsetBits: u32,
    pub maxFramebufferWidth: u32,
    pub maxFramebufferHeight: u32,
    pub maxFramebufferLayers: u32,
    pub framebufferColorSampleCounts: VkSampleCountFlags,
    pub framebufferDepthSampleCounts: VkSampleCountFlags,
    pub framebufferStencilSampleCounts: VkSampleCountFlags,
    pub framebufferNoAttachmentsSampleCounts: VkSampleCountFlags,
    pub maxColorAttachments: u32,
    pub sampledImageColorSampleCounts: VkSampleCountFlags,
    pub sampledImageIntegerSampleCounts: VkSampleCountFlags,
    pub sampledImageDepthSampleCounts: VkSampleCountFlags,
    pub sampledImageStencilSampleCounts: VkSampleCountFlags,
    pub storageImageSampleCounts: VkSampleCountFlags,
    pub maxSampleMaskWords: u32,
    pub timestampComputeAndGraphics: VkBool32,
    pub timestampPeriod: f32,
    pub maxClipDistances: u32,
    pub maxCullDistances: u32,
    pub maxCombinedClipAndCullDistances: u32,
    pub discreteQueuePriorities: u32,
    pub pointSizeRange: [f32; 2usize],
    pub lineWidthRange: [f32; 2usize],
    pub pointSizeGranularity: f32,
    pub lineWidthGranularity: f32,
    pub strictLines: VkBool32,
    pub standardSampleLocations: VkBool32,
    pub optimalBufferCopyOffsetAlignment: VkDeviceSize,
    pub optimalBufferCopyRowPitchAlignment: VkDeviceSize,
    pub nonCoherentAtomSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryProperties {
    pub memoryTypeCount: u32,
    pub memoryTypes: [VkMemoryType; 32usize],
    pub memoryHeapCount: u32,
    pub memoryHeaps: [VkMemoryHeap; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSparseProperties {
    pub residencyStandard2DBlockShape: VkBool32,
    pub residencyStandard2DMultisampleBlockShape: VkBool32,
    pub residencyStandard3DBlockShape: VkBool32,
    pub residencyAlignedMipSize: VkBool32,
    pub residencyNonResidentStrict: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProperties {
    pub apiVersion: u32,
    pub driverVersion: u32,
    pub vendorID: u32,
    pub deviceID: u32,
    pub deviceType: VkPhysicalDeviceType,
    pub deviceName: [::std::os::raw::c_char; 256usize],
    pub pipelineCacheUUID: [u8; 16usize],
    pub limits: VkPhysicalDeviceLimits,
    pub sparseProperties: VkPhysicalDeviceSparseProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyProperties {
    pub queueFlags: VkQueueFlags,
    pub queueCount: u32,
    pub timestampValidBits: u32,
    pub minImageTransferGranularity: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueCount: u32,
    pub pQueuePriorities: *const f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceCreateFlags,
    pub queueCreateInfoCount: u32,
    pub pQueueCreateInfos: *const VkDeviceQueueCreateInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const ::std::os::raw::c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const ::std::os::raw::c_char,
    pub pEnabledFeatures: *const VkPhysicalDeviceFeatures,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtensionProperties {
    pub extensionName: [::std::os::raw::c_char; 256usize],
    pub specVersion: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkLayerProperties {
    pub layerName: [::std::os::raw::c_char; 256usize],
    pub specVersion: u32,
    pub implementationVersion: u32,
    pub description: [::std::os::raw::c_char; 256usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub pWaitDstStageMask: *const VkPipelineStageFlags,
    pub commandBufferCount: u32,
    pub pCommandBuffers: *const VkCommandBuffer,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const VkSemaphore,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMappedMemoryRange {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub allocationSize: VkDeviceSize,
    pub memoryTypeIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryRequirements {
    pub size: VkDeviceSize,
    pub alignment: VkDeviceSize,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseMemoryBind {
    pub resourceOffset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub flags: VkSparseMemoryBindFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseBufferMemoryBindInfo {
    pub buffer: VkBuffer,
    pub bindCount: u32,
    pub pBinds: *const VkSparseMemoryBind,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageOpaqueMemoryBindInfo {
    pub image: VkImage,
    pub bindCount: u32,
    pub pBinds: *const VkSparseMemoryBind,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresource {
    pub aspectMask: VkImageAspectFlags,
    pub mipLevel: u32,
    pub arrayLayer: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryBind {
    pub subresource: VkImageSubresource,
    pub offset: VkOffset3D,
    pub extent: VkExtent3D,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub flags: VkSparseMemoryBindFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryBindInfo {
    pub image: VkImage,
    pub bindCount: u32,
    pub pBinds: *const VkSparseImageMemoryBind,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindSparseInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub bufferBindCount: u32,
    pub pBufferBinds: *const VkSparseBufferMemoryBindInfo,
    pub imageOpaqueBindCount: u32,
    pub pImageOpaqueBinds: *const VkSparseImageOpaqueMemoryBindInfo,
    pub imageBindCount: u32,
    pub pImageBinds: *const VkSparseImageMemoryBindInfo,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const VkSemaphore,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageFormatProperties {
    pub aspectMask: VkImageAspectFlags,
    pub imageGranularity: VkExtent3D,
    pub flags: VkSparseImageFormatFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryRequirements {
    pub formatProperties: VkSparseImageFormatProperties,
    pub imageMipTailFirstLod: u32,
    pub imageMipTailSize: VkDeviceSize,
    pub imageMipTailOffset: VkDeviceSize,
    pub imageMipTailStride: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFenceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkFenceCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSemaphoreCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkEventCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkEventCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkQueryPoolCreateFlags,
    pub queryType: VkQueryType,
    pub queryCount: u32,
    pub pipelineStatistics: VkQueryPipelineStatisticFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferCreateFlags,
    pub size: VkDeviceSize,
    pub usage: VkBufferUsageFlags,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferViewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferViewCreateFlags,
    pub buffer: VkBuffer,
    pub format: VkFormat,
    pub offset: VkDeviceSize,
    pub range: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageCreateFlags,
    pub imageType: VkImageType,
    pub format: VkFormat,
    pub extent: VkExtent3D,
    pub mipLevels: u32,
    pub arrayLayers: u32,
    pub samples: VkSampleCountFlagBits,
    pub tiling: VkImageTiling,
    pub usage: VkImageUsageFlags,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
    pub initialLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubresourceLayout {
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub rowPitch: VkDeviceSize,
    pub arrayPitch: VkDeviceSize,
    pub depthPitch: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkComponentMapping {
    pub r: VkComponentSwizzle,
    pub g: VkComponentSwizzle,
    pub b: VkComponentSwizzle,
    pub a: VkComponentSwizzle,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageViewCreateFlags,
    pub image: VkImage,
    pub viewType: VkImageViewType,
    pub format: VkFormat,
    pub components: VkComponentMapping,
    pub subresourceRange: VkImageSubresourceRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModuleCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkShaderModuleCreateFlags,
    pub codeSize: size_t,
    pub pCode: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCacheCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCacheCreateFlags,
    pub initialDataSize: size_t,
    pub pInitialData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSpecializationMapEntry {
    pub constantID: u32,
    pub offset: u32,
    pub size: size_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSpecializationInfo {
    pub mapEntryCount: u32,
    pub pMapEntries: *const VkSpecializationMapEntry,
    pub dataSize: size_t,
    pub pData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineShaderStageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineShaderStageCreateFlags,
    pub stage: VkShaderStageFlagBits,
    pub module: VkShaderModule,
    pub pName: *const ::std::os::raw::c_char,
    pub pSpecializationInfo: *const VkSpecializationInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkComputePipelineCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stage: VkPipelineShaderStageCreateInfo,
    pub layout: VkPipelineLayout,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub inputRate: VkVertexInputRate,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: VkFormat,
    pub offset: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineVertexInputStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineVertexInputStateCreateFlags,
    pub vertexBindingDescriptionCount: u32,
    pub pVertexBindingDescriptions: *const VkVertexInputBindingDescription,
    pub vertexAttributeDescriptionCount: u32,
    pub pVertexAttributeDescriptions: *const VkVertexInputAttributeDescription,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineInputAssemblyStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineInputAssemblyStateCreateFlags,
    pub topology: VkPrimitiveTopology,
    pub primitiveRestartEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineTessellationStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineTessellationStateCreateFlags,
    pub patchControlPoints: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub minDepth: f32,
    pub maxDepth: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineViewportStateCreateFlags,
    pub viewportCount: u32,
    pub pViewports: *const VkViewport,
    pub scissorCount: u32,
    pub pScissors: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationStateCreateFlags,
    pub depthClampEnable: VkBool32,
    pub rasterizerDiscardEnable: VkBool32,
    pub polygonMode: VkPolygonMode,
    pub cullMode: VkCullModeFlags,
    pub frontFace: VkFrontFace,
    pub depthBiasEnable: VkBool32,
    pub depthBiasConstantFactor: f32,
    pub depthBiasClamp: f32,
    pub depthBiasSlopeFactor: f32,
    pub lineWidth: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineMultisampleStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineMultisampleStateCreateFlags,
    pub rasterizationSamples: VkSampleCountFlagBits,
    pub sampleShadingEnable: VkBool32,
    pub minSampleShading: f32,
    pub pSampleMask: *const VkSampleMask,
    pub alphaToCoverageEnable: VkBool32,
    pub alphaToOneEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkStencilOpState {
    pub failOp: VkStencilOp,
    pub passOp: VkStencilOp,
    pub depthFailOp: VkStencilOp,
    pub compareOp: VkCompareOp,
    pub compareMask: u32,
    pub writeMask: u32,
    pub reference: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDepthStencilStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDepthStencilStateCreateFlags,
    pub depthTestEnable: VkBool32,
    pub depthWriteEnable: VkBool32,
    pub depthCompareOp: VkCompareOp,
    pub depthBoundsTestEnable: VkBool32,
    pub stencilTestEnable: VkBool32,
    pub front: VkStencilOpState,
    pub back: VkStencilOpState,
    pub minDepthBounds: f32,
    pub maxDepthBounds: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendAttachmentState {
    pub blendEnable: VkBool32,
    pub srcColorBlendFactor: VkBlendFactor,
    pub dstColorBlendFactor: VkBlendFactor,
    pub colorBlendOp: VkBlendOp,
    pub srcAlphaBlendFactor: VkBlendFactor,
    pub dstAlphaBlendFactor: VkBlendFactor,
    pub alphaBlendOp: VkBlendOp,
    pub colorWriteMask: VkColorComponentFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineColorBlendStateCreateFlags,
    pub logicOpEnable: VkBool32,
    pub logicOp: VkLogicOp,
    pub attachmentCount: u32,
    pub pAttachments: *const VkPipelineColorBlendAttachmentState,
    pub blendConstants: [f32; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDynamicStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDynamicStateCreateFlags,
    pub dynamicStateCount: u32,
    pub pDynamicStates: *const VkDynamicState,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsPipelineCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub pVertexInputState: *const VkPipelineVertexInputStateCreateInfo,
    pub pInputAssemblyState: *const VkPipelineInputAssemblyStateCreateInfo,
    pub pTessellationState: *const VkPipelineTessellationStateCreateInfo,
    pub pViewportState: *const VkPipelineViewportStateCreateInfo,
    pub pRasterizationState: *const VkPipelineRasterizationStateCreateInfo,
    pub pMultisampleState: *const VkPipelineMultisampleStateCreateInfo,
    pub pDepthStencilState: *const VkPipelineDepthStencilStateCreateInfo,
    pub pColorBlendState: *const VkPipelineColorBlendStateCreateInfo,
    pub pDynamicState: *const VkPipelineDynamicStateCreateInfo,
    pub layout: VkPipelineLayout,
    pub renderPass: VkRenderPass,
    pub subpass: u32,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPushConstantRange {
    pub stageFlags: VkShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLayoutCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineLayoutCreateFlags,
    pub setLayoutCount: u32,
    pub pSetLayouts: *const VkDescriptorSetLayout,
    pub pushConstantRangeCount: u32,
    pub pPushConstantRanges: *const VkPushConstantRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSamplerCreateFlags,
    pub magFilter: VkFilter,
    pub minFilter: VkFilter,
    pub mipmapMode: VkSamplerMipmapMode,
    pub addressModeU: VkSamplerAddressMode,
    pub addressModeV: VkSamplerAddressMode,
    pub addressModeW: VkSamplerAddressMode,
    pub mipLodBias: f32,
    pub anisotropyEnable: VkBool32,
    pub maxAnisotropy: f32,
    pub compareEnable: VkBool32,
    pub compareOp: VkCompareOp,
    pub minLod: f32,
    pub maxLod: f32,
    pub borderColor: VkBorderColor,
    pub unnormalizedCoordinates: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyDescriptorSet {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSet: VkDescriptorSet,
    pub srcBinding: u32,
    pub srcArrayElement: u32,
    pub dstSet: VkDescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorBufferInfo {
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub range: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorImageInfo {
    pub sampler: VkSampler,
    pub imageView: VkImageView,
    pub imageLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolSize {
    pub type_: VkDescriptorType,
    pub descriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorPoolCreateFlags,
    pub maxSets: u32,
    pub poolSizeCount: u32,
    pub pPoolSizes: *const VkDescriptorPoolSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub descriptorPool: VkDescriptorPool,
    pub descriptorSetCount: u32,
    pub pSetLayouts: *const VkDescriptorSetLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutBinding {
    pub binding: u32,
    pub descriptorType: VkDescriptorType,
    pub descriptorCount: u32,
    pub stageFlags: VkShaderStageFlags,
    pub pImmutableSamplers: *const VkSampler,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorSetLayoutCreateFlags,
    pub bindingCount: u32,
    pub pBindings: *const VkDescriptorSetLayoutBinding,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSet {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dstSet: VkDescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: VkDescriptorType,
    pub pImageInfo: *const VkDescriptorImageInfo,
    pub pBufferInfo: *const VkDescriptorBufferInfo,
    pub pTexelBufferView: *const VkBufferView,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescription {
    pub flags: VkAttachmentDescriptionFlags,
    pub format: VkFormat,
    pub samples: VkSampleCountFlagBits,
    pub loadOp: VkAttachmentLoadOp,
    pub storeOp: VkAttachmentStoreOp,
    pub stencilLoadOp: VkAttachmentLoadOp,
    pub stencilStoreOp: VkAttachmentStoreOp,
    pub initialLayout: VkImageLayout,
    pub finalLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReference {
    pub attachment: u32,
    pub layout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkFramebufferCreateFlags,
    pub renderPass: VkRenderPass,
    pub attachmentCount: u32,
    pub pAttachments: *const VkImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescription {
    pub flags: VkSubpassDescriptionFlags,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const VkAttachmentReference,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const VkAttachmentReference,
    pub pResolveAttachments: *const VkAttachmentReference,
    pub pDepthStencilAttachment: *const VkAttachmentReference,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDependency {
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: VkPipelineStageFlags,
    pub dstStageMask: VkPipelineStageFlags,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub dependencyFlags: VkDependencyFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const VkAttachmentDescription,
    pub subpassCount: u32,
    pub pSubpasses: *const VkSubpassDescription,
    pub dependencyCount: u32,
    pub pDependencies: *const VkSubpassDependency,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkCommandPoolCreateFlags,
    pub queueFamilyIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub commandPool: VkCommandPool,
    pub level: VkCommandBufferLevel,
    pub commandBufferCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub renderPass: VkRenderPass,
    pub subpass: u32,
    pub framebuffer: VkFramebuffer,
    pub occlusionQueryEnable: VkBool32,
    pub queryFlags: VkQueryControlFlags,
    pub pipelineStatistics: VkQueryPipelineStatisticFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkCommandBufferUsageFlags,
    pub pInheritanceInfo: *const VkCommandBufferInheritanceInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCopy {
    pub srcOffset: VkDeviceSize,
    pub dstOffset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresourceLayers {
    pub aspectMask: VkImageAspectFlags,
    pub mipLevel: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferImageCopy {
    pub bufferOffset: VkDeviceSize,
    pub bufferRowLength: u32,
    pub bufferImageHeight: u32,
    pub imageSubresource: VkImageSubresourceLayers,
    pub imageOffset: VkOffset3D,
    pub imageExtent: VkExtent3D,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkClearColorValue {
    pub float32: [f32; 4usize],
    pub int32: [i32; 4usize],
    pub uint32: [u32; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkClearValue {
    pub color: VkClearColorValue,
    pub depthStencil: VkClearDepthStencilValue,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkClearAttachment {
    pub aspectMask: VkImageAspectFlags,
    pub colorAttachment: u32,
    pub clearValue: VkClearValue,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkClearRect {
    pub rect: VkRect2D,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageBlit {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffsets: [VkOffset3D; 2usize],
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffsets: [VkOffset3D; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCopy {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageResolve {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub renderPass: VkRenderPass,
    pub framebuffer: VkFramebuffer,
    pub renderArea: VkRect2D,
    pub clearValueCount: u32,
    pub pClearValues: *const VkClearValue,
}
pub type PFN_vkCreateInstance = ::std::option::Option<
    unsafe extern "C" fn(
        pCreateInfo: *const VkInstanceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pInstance: *mut VkInstance,
    ) -> VkResult,
>;
pub type PFN_vkDestroyInstance = ::std::option::Option<
    unsafe extern "C" fn(instance: VkInstance, pAllocator: *const VkAllocationCallbacks),
>;
pub type PFN_vkEnumeratePhysicalDevices = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceCount: *mut u32,
        pPhysicalDevices: *mut VkPhysicalDevice,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceFeatures = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures,
    ),
>;
pub type PFN_vkGetPhysicalDeviceFormatProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        pImageFormatProperties: *mut VkImageFormatProperties,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceMemoryProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties,
    ),
>;
pub type PFN_vkGetInstanceProcAddr = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction,
>;
pub type PFN_vkGetDeviceProcAddr = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction,
>;
pub type PFN_vkCreateDevice = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pCreateInfo: *const VkDeviceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDevice: *mut VkDevice,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDevice = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pAllocator: *const VkAllocationCallbacks),
>;
pub type PFN_vkEnumerateInstanceExtensionProperties = ::std::option::Option<
    unsafe extern "C" fn(
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult,
>;
pub type PFN_vkEnumerateDeviceExtensionProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult,
>;
pub type PFN_vkEnumerateInstanceLayerProperties = ::std::option::Option<
    unsafe extern "C" fn(pPropertyCount: *mut u32, pProperties: *mut VkLayerProperties) -> VkResult,
>;
pub type PFN_vkEnumerateDeviceLayerProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkLayerProperties,
    ) -> VkResult,
>;
pub type PFN_vkGetDeviceQueue = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queueFamilyIndex: u32,
        queueIndex: u32,
        pQueue: *mut VkQueue,
    ),
>;
pub type PFN_vkQueueSubmit = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo,
        fence: VkFence,
    ) -> VkResult,
>;
pub type PFN_vkQueueWaitIdle =
    ::std::option::Option<unsafe extern "C" fn(queue: VkQueue) -> VkResult>;
pub type PFN_vkDeviceWaitIdle =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice) -> VkResult>;
pub type PFN_vkAllocateMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkMemoryAllocateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pMemory: *mut VkDeviceMemory,
    ) -> VkResult,
>;
pub type PFN_vkFreeMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkMapMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        offset: VkDeviceSize,
        size: VkDeviceSize,
        flags: VkMemoryMapFlags,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkUnmapMemory =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, memory: VkDeviceMemory)>;
pub type PFN_vkFlushMappedMemoryRanges = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult,
>;
pub type PFN_vkInvalidateMappedMemoryRanges = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult,
>;
pub type PFN_vkGetDeviceMemoryCommitment = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        pCommittedMemoryInBytes: *mut VkDeviceSize,
    ),
>;
pub type PFN_vkBindBufferMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult,
>;
pub type PFN_vkBindImageMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult,
>;
pub type PFN_vkGetBufferMemoryRequirements = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        pMemoryRequirements: *mut VkMemoryRequirements,
    ),
>;
pub type PFN_vkGetImageMemoryRequirements = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pMemoryRequirements: *mut VkMemoryRequirements,
    ),
>;
pub type PFN_vkGetImageSparseMemoryRequirements = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements,
    ),
>;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        samples: VkSampleCountFlagBits,
        usage: VkImageUsageFlags,
        tiling: VkImageTiling,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties,
    ),
>;
pub type PFN_vkQueueBindSparse = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        bindInfoCount: u32,
        pBindInfo: *const VkBindSparseInfo,
        fence: VkFence,
    ) -> VkResult,
>;
pub type PFN_vkCreateFence = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkFenceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult,
>;
pub type PFN_vkDestroyFence = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        fence: VkFence,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkResetFences = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, fenceCount: u32, pFences: *const VkFence) -> VkResult,
>;
pub type PFN_vkGetFenceStatus =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, fence: VkFence) -> VkResult>;
pub type PFN_vkWaitForFences = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        fenceCount: u32,
        pFences: *const VkFence,
        waitAll: VkBool32,
        timeout: u64,
    ) -> VkResult,
>;
pub type PFN_vkCreateSemaphore = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSemaphoreCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSemaphore: *mut VkSemaphore,
    ) -> VkResult,
>;
pub type PFN_vkDestroySemaphore = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        semaphore: VkSemaphore,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateEvent = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkEventCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pEvent: *mut VkEvent,
    ) -> VkResult,
>;
pub type PFN_vkDestroyEvent = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        event: VkEvent,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetEventStatus =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult>;
pub type PFN_vkSetEvent =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult>;
pub type PFN_vkResetEvent =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult>;
pub type PFN_vkCreateQueryPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkQueryPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pQueryPool: *mut VkQueryPool,
    ) -> VkResult,
>;
pub type PFN_vkDestroyQueryPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetQueryPoolResults = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    ) -> VkResult,
>;
pub type PFN_vkCreateBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkBufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pBuffer: *mut VkBuffer,
    ) -> VkResult,
>;
pub type PFN_vkDestroyBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateBufferView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkBufferViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkBufferView,
    ) -> VkResult,
>;
pub type PFN_vkDestroyBufferView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bufferView: VkBufferView,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateImage = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkImageCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pImage: *mut VkImage,
    ) -> VkResult,
>;
pub type PFN_vkDestroyImage = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetImageSubresourceLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pSubresource: *const VkImageSubresource,
        pLayout: *mut VkSubresourceLayout,
    ),
>;
pub type PFN_vkCreateImageView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkImageViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkImageView,
    ) -> VkResult,
>;
pub type PFN_vkDestroyImageView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        imageView: VkImageView,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateShaderModule = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkShaderModuleCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pShaderModule: *mut VkShaderModule,
    ) -> VkResult,
>;
pub type PFN_vkDestroyShaderModule = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        shaderModule: VkShaderModule,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreatePipelineCache = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPipelineCacheCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineCache: *mut VkPipelineCache,
    ) -> VkResult,
>;
pub type PFN_vkDestroyPipelineCache = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetPipelineCacheData = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkMergePipelineCaches = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        dstCache: VkPipelineCache,
        srcCacheCount: u32,
        pSrcCaches: *const VkPipelineCache,
    ) -> VkResult,
>;
pub type PFN_vkCreateGraphicsPipelines = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkGraphicsPipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult,
>;
pub type PFN_vkCreateComputePipelines = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkComputePipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult,
>;
pub type PFN_vkDestroyPipeline = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreatePipelineLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPipelineLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineLayout: *mut VkPipelineLayout,
    ) -> VkResult,
>;
pub type PFN_vkDestroyPipelineLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineLayout: VkPipelineLayout,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateSampler = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSampler: *mut VkSampler,
    ) -> VkResult,
>;
pub type PFN_vkDestroySampler = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        sampler: VkSampler,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateDescriptorSetLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSetLayout: *mut VkDescriptorSetLayout,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDescriptorSetLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSetLayout: VkDescriptorSetLayout,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateDescriptorPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorPool: *mut VkDescriptorPool,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDescriptorPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkResetDescriptorPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        flags: VkDescriptorPoolResetFlags,
    ) -> VkResult,
>;
pub type PFN_vkAllocateDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkDescriptorSetAllocateInfo,
        pDescriptorSets: *mut VkDescriptorSet,
    ) -> VkResult,
>;
pub type PFN_vkFreeDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
    ) -> VkResult,
>;
pub type PFN_vkUpdateDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
        descriptorCopyCount: u32,
        pDescriptorCopies: *const VkCopyDescriptorSet,
    ),
>;
pub type PFN_vkCreateFramebuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkFramebufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFramebuffer: *mut VkFramebuffer,
    ) -> VkResult,
>;
pub type PFN_vkDestroyFramebuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        framebuffer: VkFramebuffer,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateRenderPass = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult,
>;
pub type PFN_vkDestroyRenderPass = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        renderPass: VkRenderPass,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetRenderAreaGranularity = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, renderPass: VkRenderPass, pGranularity: *mut VkExtent2D),
>;
pub type PFN_vkCreateCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkCommandPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pCommandPool: *mut VkCommandPool,
    ) -> VkResult,
>;
pub type PFN_vkDestroyCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkResetCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolResetFlags,
    ) -> VkResult,
>;
pub type PFN_vkAllocateCommandBuffers = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkCommandBufferAllocateInfo,
        pCommandBuffers: *mut VkCommandBuffer,
    ) -> VkResult,
>;
pub type PFN_vkFreeCommandBuffers = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    ),
>;
pub type PFN_vkBeginCommandBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pBeginInfo: *const VkCommandBufferBeginInfo,
    ) -> VkResult,
>;
pub type PFN_vkEndCommandBuffer =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer) -> VkResult>;
pub type PFN_vkResetCommandBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        flags: VkCommandBufferResetFlags,
    ) -> VkResult,
>;
pub type PFN_vkCmdBindPipeline = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
    ),
>;
pub type PFN_vkCmdSetViewport = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewports: *const VkViewport,
    ),
>;
pub type PFN_vkCmdSetScissor = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstScissor: u32,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    ),
>;
pub type PFN_vkCmdSetLineWidth =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer, lineWidth: f32)>;
pub type PFN_vkCmdSetDepthBias = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        depthBiasConstantFactor: f32,
        depthBiasClamp: f32,
        depthBiasSlopeFactor: f32,
    ),
>;
pub type PFN_vkCmdSetBlendConstants = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, blendConstants: *const f32),
>;
pub type PFN_vkCmdSetDepthBounds = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, minDepthBounds: f32, maxDepthBounds: f32),
>;
pub type PFN_vkCmdSetStencilCompareMask = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        compareMask: u32,
    ),
>;
pub type PFN_vkCmdSetStencilWriteMask = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        writeMask: u32,
    ),
>;
pub type PFN_vkCmdSetStencilReference = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        reference: u32,
    ),
>;
pub type PFN_vkCmdBindDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        firstSet: u32,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
        dynamicOffsetCount: u32,
        pDynamicOffsets: *const u32,
    ),
>;
pub type PFN_vkCmdBindIndexBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        indexType: VkIndexType,
    ),
>;
pub type PFN_vkCmdBindVertexBuffers = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
    ),
>;
pub type PFN_vkCmdDraw = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        vertexCount: u32,
        instanceCount: u32,
        firstVertex: u32,
        firstInstance: u32,
    ),
>;
pub type PFN_vkCmdDrawIndexed = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        indexCount: u32,
        instanceCount: u32,
        firstIndex: u32,
        vertexOffset: i32,
        firstInstance: u32,
    ),
>;
pub type PFN_vkCmdDrawIndirect = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDrawIndexedIndirect = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDispatch = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ),
>;
pub type PFN_vkCmdDispatchIndirect = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, buffer: VkBuffer, offset: VkDeviceSize),
>;
pub type PFN_vkCmdCopyBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferCopy,
    ),
>;
pub type PFN_vkCmdCopyImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageCopy,
    ),
>;
pub type PFN_vkCmdBlitImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageBlit,
        filter: VkFilter,
    ),
>;
pub type PFN_vkCmdCopyBufferToImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    ),
>;
pub type PFN_vkCmdCopyImageToBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    ),
>;
pub type PFN_vkCmdUpdateBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        dataSize: VkDeviceSize,
        pData: *const ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkCmdFillBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        size: VkDeviceSize,
        data: u32,
    ),
>;
pub type PFN_vkCmdClearColorImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pColor: *const VkClearColorValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    ),
>;
pub type PFN_vkCmdClearDepthStencilImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pDepthStencil: *const VkClearDepthStencilValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    ),
>;
pub type PFN_vkCmdClearAttachments = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        attachmentCount: u32,
        pAttachments: *const VkClearAttachment,
        rectCount: u32,
        pRects: *const VkClearRect,
    ),
>;
pub type PFN_vkCmdResolveImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageResolve,
    ),
>;
pub type PFN_vkCmdSetEvent = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    ),
>;
pub type PFN_vkCmdResetEvent = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    ),
>;
pub type PFN_vkCmdWaitEvents = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    ),
>;
pub type PFN_vkCmdPipelineBarrier = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        dependencyFlags: VkDependencyFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    ),
>;
pub type PFN_vkCmdBeginQuery = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
    ),
>;
pub type PFN_vkCmdEndQuery = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, queryPool: VkQueryPool, query: u32),
>;
pub type PFN_vkCmdResetQueryPool = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    ),
>;
pub type PFN_vkCmdWriteTimestamp = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        queryPool: VkQueryPool,
        query: u32,
    ),
>;
pub type PFN_vkCmdCopyQueryPoolResults = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    ),
>;
pub type PFN_vkCmdPushConstants = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        layout: VkPipelineLayout,
        stageFlags: VkShaderStageFlags,
        offset: u32,
        size: u32,
        pValues: *const ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkCmdBeginRenderPass = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        contents: VkSubpassContents,
    ),
>;
pub type PFN_vkCmdNextSubpass = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, contents: VkSubpassContents),
>;
pub type PFN_vkCmdEndRenderPass =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer)>;
pub type PFN_vkCmdExecuteCommands = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    ),
>;
extern "C" {
    pub fn vkCreateInstance(
        pCreateInfo: *const VkInstanceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pInstance: *mut VkInstance,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyInstance(instance: VkInstance, pAllocator: *const VkAllocationCallbacks);
}
extern "C" {
    pub fn vkEnumeratePhysicalDevices(
        instance: VkInstance,
        pPhysicalDeviceCount: *mut u32,
        pPhysicalDevices: *mut VkPhysicalDevice,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceFeatures(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceFormatProperties(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceImageFormatProperties(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        pImageFormatProperties: *mut VkImageFormatProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceProperties(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceQueueFamilyProperties(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceMemoryProperties(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties,
    );
}
extern "C" {
    pub fn vkGetInstanceProcAddr(
        instance: VkInstance,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction;
}
extern "C" {
    pub fn vkGetDeviceProcAddr(
        device: VkDevice,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction;
}
extern "C" {
    pub fn vkCreateDevice(
        physicalDevice: VkPhysicalDevice,
        pCreateInfo: *const VkDeviceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDevice: *mut VkDevice,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDevice(device: VkDevice, pAllocator: *const VkAllocationCallbacks);
}
extern "C" {
    pub fn vkEnumerateInstanceExtensionProperties(
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEnumerateDeviceExtensionProperties(
        physicalDevice: VkPhysicalDevice,
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEnumerateInstanceLayerProperties(
        pPropertyCount: *mut u32,
        pProperties: *mut VkLayerProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEnumerateDeviceLayerProperties(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkLayerProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceQueue(
        device: VkDevice,
        queueFamilyIndex: u32,
        queueIndex: u32,
        pQueue: *mut VkQueue,
    );
}
extern "C" {
    pub fn vkQueueSubmit(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo,
        fence: VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkQueueWaitIdle(queue: VkQueue) -> VkResult;
}
extern "C" {
    pub fn vkDeviceWaitIdle(device: VkDevice) -> VkResult;
}
extern "C" {
    pub fn vkAllocateMemory(
        device: VkDevice,
        pAllocateInfo: *const VkMemoryAllocateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pMemory: *mut VkDeviceMemory,
    ) -> VkResult;
}
extern "C" {
    pub fn vkFreeMemory(
        device: VkDevice,
        memory: VkDeviceMemory,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkMapMemory(
        device: VkDevice,
        memory: VkDeviceMemory,
        offset: VkDeviceSize,
        size: VkDeviceSize,
        flags: VkMemoryMapFlags,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkUnmapMemory(device: VkDevice, memory: VkDeviceMemory);
}
extern "C" {
    pub fn vkFlushMappedMemoryRanges(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult;
}
extern "C" {
    pub fn vkInvalidateMappedMemoryRanges(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceMemoryCommitment(
        device: VkDevice,
        memory: VkDeviceMemory,
        pCommittedMemoryInBytes: *mut VkDeviceSize,
    );
}
extern "C" {
    pub fn vkBindBufferMemory(
        device: VkDevice,
        buffer: VkBuffer,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    pub fn vkBindImageMemory(
        device: VkDevice,
        image: VkImage,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetBufferMemoryRequirements(
        device: VkDevice,
        buffer: VkBuffer,
        pMemoryRequirements: *mut VkMemoryRequirements,
    );
}
extern "C" {
    pub fn vkGetImageMemoryRequirements(
        device: VkDevice,
        image: VkImage,
        pMemoryRequirements: *mut VkMemoryRequirements,
    );
}
extern "C" {
    pub fn vkGetImageSparseMemoryRequirements(
        device: VkDevice,
        image: VkImage,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceSparseImageFormatProperties(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        samples: VkSampleCountFlagBits,
        usage: VkImageUsageFlags,
        tiling: VkImageTiling,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties,
    );
}
extern "C" {
    pub fn vkQueueBindSparse(
        queue: VkQueue,
        bindInfoCount: u32,
        pBindInfo: *const VkBindSparseInfo,
        fence: VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateFence(
        device: VkDevice,
        pCreateInfo: *const VkFenceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyFence(
        device: VkDevice,
        fence: VkFence,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkResetFences(device: VkDevice, fenceCount: u32, pFences: *const VkFence) -> VkResult;
}
extern "C" {
    pub fn vkGetFenceStatus(device: VkDevice, fence: VkFence) -> VkResult;
}
extern "C" {
    pub fn vkWaitForFences(
        device: VkDevice,
        fenceCount: u32,
        pFences: *const VkFence,
        waitAll: VkBool32,
        timeout: u64,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateSemaphore(
        device: VkDevice,
        pCreateInfo: *const VkSemaphoreCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSemaphore: *mut VkSemaphore,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySemaphore(
        device: VkDevice,
        semaphore: VkSemaphore,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateEvent(
        device: VkDevice,
        pCreateInfo: *const VkEventCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pEvent: *mut VkEvent,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyEvent(
        device: VkDevice,
        event: VkEvent,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetEventStatus(device: VkDevice, event: VkEvent) -> VkResult;
}
extern "C" {
    pub fn vkSetEvent(device: VkDevice, event: VkEvent) -> VkResult;
}
extern "C" {
    pub fn vkResetEvent(device: VkDevice, event: VkEvent) -> VkResult;
}
extern "C" {
    pub fn vkCreateQueryPool(
        device: VkDevice,
        pCreateInfo: *const VkQueryPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pQueryPool: *mut VkQueryPool,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyQueryPool(
        device: VkDevice,
        queryPool: VkQueryPool,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetQueryPoolResults(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateBuffer(
        device: VkDevice,
        pCreateInfo: *const VkBufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pBuffer: *mut VkBuffer,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyBuffer(
        device: VkDevice,
        buffer: VkBuffer,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateBufferView(
        device: VkDevice,
        pCreateInfo: *const VkBufferViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkBufferView,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyBufferView(
        device: VkDevice,
        bufferView: VkBufferView,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateImage(
        device: VkDevice,
        pCreateInfo: *const VkImageCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pImage: *mut VkImage,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyImage(
        device: VkDevice,
        image: VkImage,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetImageSubresourceLayout(
        device: VkDevice,
        image: VkImage,
        pSubresource: *const VkImageSubresource,
        pLayout: *mut VkSubresourceLayout,
    );
}
extern "C" {
    pub fn vkCreateImageView(
        device: VkDevice,
        pCreateInfo: *const VkImageViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkImageView,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyImageView(
        device: VkDevice,
        imageView: VkImageView,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateShaderModule(
        device: VkDevice,
        pCreateInfo: *const VkShaderModuleCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pShaderModule: *mut VkShaderModule,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyShaderModule(
        device: VkDevice,
        shaderModule: VkShaderModule,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreatePipelineCache(
        device: VkDevice,
        pCreateInfo: *const VkPipelineCacheCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineCache: *mut VkPipelineCache,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyPipelineCache(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetPipelineCacheData(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkMergePipelineCaches(
        device: VkDevice,
        dstCache: VkPipelineCache,
        srcCacheCount: u32,
        pSrcCaches: *const VkPipelineCache,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateGraphicsPipelines(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkGraphicsPipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateComputePipelines(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkComputePipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyPipeline(
        device: VkDevice,
        pipeline: VkPipeline,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreatePipelineLayout(
        device: VkDevice,
        pCreateInfo: *const VkPipelineLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineLayout: *mut VkPipelineLayout,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyPipelineLayout(
        device: VkDevice,
        pipelineLayout: VkPipelineLayout,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateSampler(
        device: VkDevice,
        pCreateInfo: *const VkSamplerCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSampler: *mut VkSampler,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySampler(
        device: VkDevice,
        sampler: VkSampler,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateDescriptorSetLayout(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSetLayout: *mut VkDescriptorSetLayout,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDescriptorSetLayout(
        device: VkDevice,
        descriptorSetLayout: VkDescriptorSetLayout,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateDescriptorPool(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorPool: *mut VkDescriptorPool,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDescriptorPool(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkResetDescriptorPool(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        flags: VkDescriptorPoolResetFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkAllocateDescriptorSets(
        device: VkDevice,
        pAllocateInfo: *const VkDescriptorSetAllocateInfo,
        pDescriptorSets: *mut VkDescriptorSet,
    ) -> VkResult;
}
extern "C" {
    pub fn vkFreeDescriptorSets(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
    ) -> VkResult;
}
extern "C" {
    pub fn vkUpdateDescriptorSets(
        device: VkDevice,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
        descriptorCopyCount: u32,
        pDescriptorCopies: *const VkCopyDescriptorSet,
    );
}
extern "C" {
    pub fn vkCreateFramebuffer(
        device: VkDevice,
        pCreateInfo: *const VkFramebufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFramebuffer: *mut VkFramebuffer,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyFramebuffer(
        device: VkDevice,
        framebuffer: VkFramebuffer,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateRenderPass(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyRenderPass(
        device: VkDevice,
        renderPass: VkRenderPass,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetRenderAreaGranularity(
        device: VkDevice,
        renderPass: VkRenderPass,
        pGranularity: *mut VkExtent2D,
    );
}
extern "C" {
    pub fn vkCreateCommandPool(
        device: VkDevice,
        pCreateInfo: *const VkCommandPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pCommandPool: *mut VkCommandPool,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyCommandPool(
        device: VkDevice,
        commandPool: VkCommandPool,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkResetCommandPool(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolResetFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkAllocateCommandBuffers(
        device: VkDevice,
        pAllocateInfo: *const VkCommandBufferAllocateInfo,
        pCommandBuffers: *mut VkCommandBuffer,
    ) -> VkResult;
}
extern "C" {
    pub fn vkFreeCommandBuffers(
        device: VkDevice,
        commandPool: VkCommandPool,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    );
}
extern "C" {
    pub fn vkBeginCommandBuffer(
        commandBuffer: VkCommandBuffer,
        pBeginInfo: *const VkCommandBufferBeginInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEndCommandBuffer(commandBuffer: VkCommandBuffer) -> VkResult;
}
extern "C" {
    pub fn vkResetCommandBuffer(
        commandBuffer: VkCommandBuffer,
        flags: VkCommandBufferResetFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdBindPipeline(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
    );
}
extern "C" {
    pub fn vkCmdSetViewport(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewports: *const VkViewport,
    );
}
extern "C" {
    pub fn vkCmdSetScissor(
        commandBuffer: VkCommandBuffer,
        firstScissor: u32,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    );
}
extern "C" {
    pub fn vkCmdSetLineWidth(commandBuffer: VkCommandBuffer, lineWidth: f32);
}
extern "C" {
    pub fn vkCmdSetDepthBias(
        commandBuffer: VkCommandBuffer,
        depthBiasConstantFactor: f32,
        depthBiasClamp: f32,
        depthBiasSlopeFactor: f32,
    );
}
extern "C" {
    pub fn vkCmdSetBlendConstants(commandBuffer: VkCommandBuffer, blendConstants: *const f32);
}
extern "C" {
    pub fn vkCmdSetDepthBounds(
        commandBuffer: VkCommandBuffer,
        minDepthBounds: f32,
        maxDepthBounds: f32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilCompareMask(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        compareMask: u32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilWriteMask(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        writeMask: u32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilReference(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        reference: u32,
    );
}
extern "C" {
    pub fn vkCmdBindDescriptorSets(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        firstSet: u32,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
        dynamicOffsetCount: u32,
        pDynamicOffsets: *const u32,
    );
}
extern "C" {
    pub fn vkCmdBindIndexBuffer(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        indexType: VkIndexType,
    );
}
extern "C" {
    pub fn vkCmdBindVertexBuffers(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdDraw(
        commandBuffer: VkCommandBuffer,
        vertexCount: u32,
        instanceCount: u32,
        firstVertex: u32,
        firstInstance: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndexed(
        commandBuffer: VkCommandBuffer,
        indexCount: u32,
        instanceCount: u32,
        firstIndex: u32,
        vertexOffset: i32,
        firstInstance: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndirect(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndexedIndirect(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDispatch(
        commandBuffer: VkCommandBuffer,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    );
}
extern "C" {
    pub fn vkCmdDispatchIndirect(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdCopyBuffer(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferCopy,
    );
}
extern "C" {
    pub fn vkCmdCopyImage(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageCopy,
    );
}
extern "C" {
    pub fn vkCmdBlitImage(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageBlit,
        filter: VkFilter,
    );
}
extern "C" {
    pub fn vkCmdCopyBufferToImage(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    );
}
extern "C" {
    pub fn vkCmdCopyImageToBuffer(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    );
}
extern "C" {
    pub fn vkCmdUpdateBuffer(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        dataSize: VkDeviceSize,
        pData: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn vkCmdFillBuffer(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        size: VkDeviceSize,
        data: u32,
    );
}
extern "C" {
    pub fn vkCmdClearColorImage(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pColor: *const VkClearColorValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    );
}
extern "C" {
    pub fn vkCmdClearDepthStencilImage(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pDepthStencil: *const VkClearDepthStencilValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    );
}
extern "C" {
    pub fn vkCmdClearAttachments(
        commandBuffer: VkCommandBuffer,
        attachmentCount: u32,
        pAttachments: *const VkClearAttachment,
        rectCount: u32,
        pRects: *const VkClearRect,
    );
}
extern "C" {
    pub fn vkCmdResolveImage(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageResolve,
    );
}
extern "C" {
    pub fn vkCmdSetEvent(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    );
}
extern "C" {
    pub fn vkCmdResetEvent(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    );
}
extern "C" {
    pub fn vkCmdWaitEvents(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    );
}
extern "C" {
    pub fn vkCmdPipelineBarrier(
        commandBuffer: VkCommandBuffer,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        dependencyFlags: VkDependencyFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    );
}
extern "C" {
    pub fn vkCmdBeginQuery(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
    );
}
extern "C" {
    pub fn vkCmdEndQuery(commandBuffer: VkCommandBuffer, queryPool: VkQueryPool, query: u32);
}
extern "C" {
    pub fn vkCmdResetQueryPool(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    );
}
extern "C" {
    pub fn vkCmdWriteTimestamp(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        queryPool: VkQueryPool,
        query: u32,
    );
}
extern "C" {
    pub fn vkCmdCopyQueryPoolResults(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    );
}
extern "C" {
    pub fn vkCmdPushConstants(
        commandBuffer: VkCommandBuffer,
        layout: VkPipelineLayout,
        stageFlags: VkShaderStageFlags,
        offset: u32,
        size: u32,
        pValues: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn vkCmdBeginRenderPass(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        contents: VkSubpassContents,
    );
}
extern "C" {
    pub fn vkCmdNextSubpass(commandBuffer: VkCommandBuffer, contents: VkSubpassContents);
}
extern "C" {
    pub fn vkCmdEndRenderPass(commandBuffer: VkCommandBuffer);
}
extern "C" {
    pub fn vkCmdExecuteCommands(
        commandBuffer: VkCommandBuffer,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversion_T {
    _unused: [u8; 0],
}
pub type VkSamplerYcbcrConversion = *mut VkSamplerYcbcrConversion_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplate_T {
    _unused: [u8; 0],
}
pub type VkDescriptorUpdateTemplate = *mut VkDescriptorUpdateTemplate_T;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES:
    VkPointClippingBehavior = 0;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY:
    VkPointClippingBehavior = 1;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES_KHR:
    VkPointClippingBehavior = 0;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY_KHR:
    VkPointClippingBehavior = 1;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_MAX_ENUM: VkPointClippingBehavior =
    2147483647;
pub type VkPointClippingBehavior = ::std::os::raw::c_uint;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT:
    VkTessellationDomainOrigin = 0;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT:
    VkTessellationDomainOrigin = 1;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT_KHR:
    VkTessellationDomainOrigin = 0;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT_KHR:
    VkTessellationDomainOrigin = 1;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_MAX_ENUM:
    VkTessellationDomainOrigin = 2147483647;
pub type VkTessellationDomainOrigin = ::std::os::raw::c_uint;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY:
    VkSamplerYcbcrModelConversion = 0;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY:
    VkSamplerYcbcrModelConversion = 1;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709:
    VkSamplerYcbcrModelConversion = 2;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601:
    VkSamplerYcbcrModelConversion = 3;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020:
    VkSamplerYcbcrModelConversion = 4;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY_KHR:
    VkSamplerYcbcrModelConversion = 0;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY_KHR:
    VkSamplerYcbcrModelConversion = 1;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709_KHR:
    VkSamplerYcbcrModelConversion = 2;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601_KHR:
    VkSamplerYcbcrModelConversion = 3;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020_KHR:
    VkSamplerYcbcrModelConversion = 4;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_MAX_ENUM:
    VkSamplerYcbcrModelConversion = 2147483647;
pub type VkSamplerYcbcrModelConversion = ::std::os::raw::c_uint;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_FULL: VkSamplerYcbcrRange = 0;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_NARROW: VkSamplerYcbcrRange = 1;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_FULL_KHR: VkSamplerYcbcrRange = 0;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_NARROW_KHR: VkSamplerYcbcrRange = 1;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_MAX_ENUM: VkSamplerYcbcrRange = 2147483647;
pub type VkSamplerYcbcrRange = ::std::os::raw::c_uint;
pub const VkChromaLocation_VK_CHROMA_LOCATION_COSITED_EVEN: VkChromaLocation = 0;
pub const VkChromaLocation_VK_CHROMA_LOCATION_MIDPOINT: VkChromaLocation = 1;
pub const VkChromaLocation_VK_CHROMA_LOCATION_COSITED_EVEN_KHR: VkChromaLocation = 0;
pub const VkChromaLocation_VK_CHROMA_LOCATION_MIDPOINT_KHR: VkChromaLocation = 1;
pub const VkChromaLocation_VK_CHROMA_LOCATION_MAX_ENUM: VkChromaLocation = 2147483647;
pub type VkChromaLocation = ::std::os::raw::c_uint;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET:
    VkDescriptorUpdateTemplateType = 0;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR:
    VkDescriptorUpdateTemplateType = 1;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR:
    VkDescriptorUpdateTemplateType = 0;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_MAX_ENUM:
    VkDescriptorUpdateTemplateType = 2147483647;
pub type VkDescriptorUpdateTemplateType = ::std::os::raw::c_uint;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_BASIC_BIT: VkSubgroupFeatureFlagBits = 1;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_VOTE_BIT: VkSubgroupFeatureFlagBits = 2;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_ARITHMETIC_BIT: VkSubgroupFeatureFlagBits =
    4;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_BALLOT_BIT: VkSubgroupFeatureFlagBits = 8;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_SHUFFLE_BIT: VkSubgroupFeatureFlagBits = 16;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT:
    VkSubgroupFeatureFlagBits = 32;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_CLUSTERED_BIT: VkSubgroupFeatureFlagBits =
    64;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_QUAD_BIT: VkSubgroupFeatureFlagBits = 128;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV:
    VkSubgroupFeatureFlagBits = 256;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_FLAG_BITS_MAX_ENUM:
    VkSubgroupFeatureFlagBits = 2147483647;
pub type VkSubgroupFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkSubgroupFeatureFlags = VkFlags;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT:
    VkPeerMemoryFeatureFlagBits = 1;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_DST_BIT:
    VkPeerMemoryFeatureFlagBits = 2;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT:
    VkPeerMemoryFeatureFlagBits = 4;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT:
    VkPeerMemoryFeatureFlagBits = 8;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 1;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 2;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 4;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 8;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM:
    VkPeerMemoryFeatureFlagBits = 2147483647;
pub type VkPeerMemoryFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkPeerMemoryFeatureFlags = VkFlags;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT: VkMemoryAllocateFlagBits = 1;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT: VkMemoryAllocateFlagBits =
    2;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT:
    VkMemoryAllocateFlagBits = 4;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR:
    VkMemoryAllocateFlagBits = 1;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT_KHR:
    VkMemoryAllocateFlagBits = 2;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR:
    VkMemoryAllocateFlagBits = 4;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_FLAG_BITS_MAX_ENUM: VkMemoryAllocateFlagBits =
    2147483647;
pub type VkMemoryAllocateFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryAllocateFlags = VkFlags;
pub type VkCommandPoolTrimFlags = VkFlags;
pub type VkDescriptorUpdateTemplateCreateFlags = VkFlags;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalMemoryHandleTypeFlagBits = 1;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT:
    VkExternalMemoryHandleTypeFlagBits = 2;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT:
    VkExternalMemoryHandleTypeFlagBits = 4;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT:
    VkExternalMemoryHandleTypeFlagBits = 8;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT : VkExternalMemoryHandleTypeFlagBits = 16 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT:
    VkExternalMemoryHandleTypeFlagBits = 32;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT:
    VkExternalMemoryHandleTypeFlagBits = 64;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT:
    VkExternalMemoryHandleTypeFlagBits = 512;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID : VkExternalMemoryHandleTypeFlagBits = 1024 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT : VkExternalMemoryHandleTypeFlagBits = 128 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT : VkExternalMemoryHandleTypeFlagBits = 256 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 1;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 2;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 4 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 8 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 16 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 32;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 64 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM:
    VkExternalMemoryHandleTypeFlagBits = 2147483647;
pub type VkExternalMemoryHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalMemoryHandleTypeFlags = VkFlags;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT:
    VkExternalMemoryFeatureFlagBits = 1;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT:
    VkExternalMemoryFeatureFlagBits = 2;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT:
    VkExternalMemoryFeatureFlagBits = 4;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 1;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 2;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 4;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalMemoryFeatureFlagBits = 2147483647;
pub type VkExternalMemoryFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalMemoryFeatureFlags = VkFlags;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalFenceHandleTypeFlagBits = 1;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT:
    VkExternalFenceHandleTypeFlagBits = 2;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT:
    VkExternalFenceHandleTypeFlagBits = 4;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT:
    VkExternalFenceHandleTypeFlagBits = 8;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 1;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 2;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalFenceHandleTypeFlagBits = 4 ;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 8;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM:
    VkExternalFenceHandleTypeFlagBits = 2147483647;
pub type VkExternalFenceHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalFenceHandleTypeFlags = VkFlags;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT:
    VkExternalFenceFeatureFlagBits = 1;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT:
    VkExternalFenceFeatureFlagBits = 2;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalFenceFeatureFlagBits = 1;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalFenceFeatureFlagBits = 2;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalFenceFeatureFlagBits = 2147483647;
pub type VkExternalFenceFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalFenceFeatureFlags = VkFlags;
pub const VkFenceImportFlagBits_VK_FENCE_IMPORT_TEMPORARY_BIT: VkFenceImportFlagBits = 1;
pub const VkFenceImportFlagBits_VK_FENCE_IMPORT_TEMPORARY_BIT_KHR: VkFenceImportFlagBits = 1;
pub const VkFenceImportFlagBits_VK_FENCE_IMPORT_FLAG_BITS_MAX_ENUM: VkFenceImportFlagBits =
    2147483647;
pub type VkFenceImportFlagBits = ::std::os::raw::c_uint;
pub type VkFenceImportFlags = VkFlags;
pub const VkSemaphoreImportFlagBits_VK_SEMAPHORE_IMPORT_TEMPORARY_BIT: VkSemaphoreImportFlagBits =
    1;
pub const VkSemaphoreImportFlagBits_VK_SEMAPHORE_IMPORT_TEMPORARY_BIT_KHR:
    VkSemaphoreImportFlagBits = 1;
pub const VkSemaphoreImportFlagBits_VK_SEMAPHORE_IMPORT_FLAG_BITS_MAX_ENUM:
    VkSemaphoreImportFlagBits = 2147483647;
pub type VkSemaphoreImportFlagBits = ::std::os::raw::c_uint;
pub type VkSemaphoreImportFlags = VkFlags;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalSemaphoreHandleTypeFlagBits = 1;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT : VkExternalSemaphoreHandleTypeFlagBits = 2 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT : VkExternalSemaphoreHandleTypeFlagBits = 4 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT:
    VkExternalSemaphoreHandleTypeFlagBits = 16;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE_BIT : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 1 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 2 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 4 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 16 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM : VkExternalSemaphoreHandleTypeFlagBits = 2147483647 ;
pub type VkExternalSemaphoreHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalSemaphoreHandleTypeFlags = VkFlags;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT:
    VkExternalSemaphoreFeatureFlagBits = 1;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT:
    VkExternalSemaphoreFeatureFlagBits = 2;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalSemaphoreFeatureFlagBits = 1;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalSemaphoreFeatureFlagBits = 2;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalSemaphoreFeatureFlagBits = 2147483647;
pub type VkExternalSemaphoreFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalSemaphoreFeatureFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubgroupProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subgroupSize: u32,
    pub supportedStages: VkShaderStageFlags,
    pub supportedOperations: VkSubgroupFeatureFlags,
    pub quadOperationsInAllStages: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindBufferMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice16BitStorageFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer16BitAccess: VkBool32,
    pub uniformAndStorageBuffer16BitAccess: VkBool32,
    pub storagePushConstant16: VkBool32,
    pub storageInputOutput16: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryDedicatedRequirements {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub prefersDedicatedAllocation: VkBool32,
    pub requiresDedicatedAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryDedicatedAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub buffer: VkBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryAllocateFlagsInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkMemoryAllocateFlags,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupRenderPassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceMask: u32,
    pub deviceRenderAreaCount: u32,
    pub pDeviceRenderAreas: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupCommandBufferBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphoreDeviceIndices: *const u32,
    pub commandBufferCount: u32,
    pub pCommandBufferDeviceMasks: *const u32,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphoreDeviceIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupBindSparseInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub resourceDeviceIndex: u32,
    pub memoryDeviceIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindBufferMemoryDeviceGroupInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemoryDeviceGroupInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
    pub splitInstanceBindRegionCount: u32,
    pub pSplitInstanceBindRegions: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceGroupProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub physicalDeviceCount: u32,
    pub physicalDevices: [VkPhysicalDevice; 32usize],
    pub subsetAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupDeviceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub physicalDeviceCount: u32,
    pub pPhysicalDevices: *const VkPhysicalDevice,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSparseMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryRequirements2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryRequirements: VkMemoryRequirements,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryRequirements2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryRequirements: VkSparseImageMemoryRequirements,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFeatures2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub features: VkPhysicalDeviceFeatures,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub properties: VkPhysicalDeviceProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub formatProperties: VkFormatProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageFormatProperties: VkImageFormatProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageFormatInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub type_: VkImageType,
    pub tiling: VkImageTiling,
    pub usage: VkImageUsageFlags,
    pub flags: VkImageCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub queueFamilyProperties: VkQueueFamilyProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryProperties: VkPhysicalDeviceMemoryProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub properties: VkSparseImageFormatProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSparseImageFormatInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub type_: VkImageType,
    pub samples: VkSampleCountFlagBits,
    pub usage: VkImageUsageFlags,
    pub tiling: VkImageTiling,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePointClippingProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pointClippingBehavior: VkPointClippingBehavior,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInputAttachmentAspectReference {
    pub subpass: u32,
    pub inputAttachmentIndex: u32,
    pub aspectMask: VkImageAspectFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassInputAttachmentAspectCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub aspectReferenceCount: u32,
    pub pAspectReferences: *const VkInputAttachmentAspectReference,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewUsageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub usage: VkImageUsageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineTessellationDomainOriginStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub domainOrigin: VkTessellationDomainOrigin,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassMultiviewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub subpassCount: u32,
    pub pViewMasks: *const u32,
    pub dependencyCount: u32,
    pub pViewOffsets: *const i32,
    pub correlationMaskCount: u32,
    pub pCorrelationMasks: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub multiview: VkBool32,
    pub multiviewGeometryShader: VkBool32,
    pub multiviewTessellationShader: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxMultiviewViewCount: u32,
    pub maxMultiviewInstanceIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVariablePointersFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub variablePointersStorageBuffer: VkBool32,
    pub variablePointers: VkBool32,
}
pub type VkPhysicalDeviceVariablePointerFeatures = VkPhysicalDeviceVariablePointersFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProtectedMemoryFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub protectedMemory: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProtectedMemoryProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub protectedNoFault: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkProtectedSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub protectedSubmit: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub ycbcrModel: VkSamplerYcbcrModelConversion,
    pub ycbcrRange: VkSamplerYcbcrRange,
    pub components: VkComponentMapping,
    pub xChromaOffset: VkChromaLocation,
    pub yChromaOffset: VkChromaLocation,
    pub chromaFilter: VkFilter,
    pub forceExplicitReconstruction: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub conversion: VkSamplerYcbcrConversion,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImagePlaneMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub planeAspect: VkImageAspectFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImagePlaneMemoryRequirementsInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub planeAspect: VkImageAspectFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSamplerYcbcrConversionFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub samplerYcbcrConversion: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionImageFormatProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub combinedImageSamplerDescriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplateEntry {
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: VkDescriptorType,
    pub offset: size_t,
    pub stride: size_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorUpdateTemplateCreateFlags,
    pub descriptorUpdateEntryCount: u32,
    pub pDescriptorUpdateEntries: *const VkDescriptorUpdateTemplateEntry,
    pub templateType: VkDescriptorUpdateTemplateType,
    pub descriptorSetLayout: VkDescriptorSetLayout,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub pipelineLayout: VkPipelineLayout,
    pub set: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryProperties {
    pub externalMemoryFeatures: VkExternalMemoryFeatureFlags,
    pub exportFromImportedHandleTypes: VkExternalMemoryHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalImageFormatInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalImageFormatProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalMemoryProperties: VkExternalMemoryProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalBufferInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferCreateFlags,
    pub usage: VkBufferUsageFlags,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalBufferProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalMemoryProperties: VkExternalMemoryProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceIDProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceUUID: [u8; 16usize],
    pub driverUUID: [u8; 16usize],
    pub deviceLUID: [u8; 8usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryImageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryBufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportMemoryAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalFenceInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalFenceProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exportFromImportedHandleTypes: VkExternalFenceHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalFenceHandleTypeFlags,
    pub externalFenceFeatures: VkExternalFenceFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportFenceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalFenceHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportSemaphoreCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalSemaphoreHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalSemaphoreInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalSemaphoreProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exportFromImportedHandleTypes: VkExternalSemaphoreHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalSemaphoreHandleTypeFlags,
    pub externalSemaphoreFeatures: VkExternalSemaphoreFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMaintenance3Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutSupport {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supported: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderDrawParametersFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderDrawParameters: VkBool32,
}
pub type VkPhysicalDeviceShaderDrawParameterFeatures = VkPhysicalDeviceShaderDrawParametersFeatures;
pub type PFN_vkEnumerateInstanceVersion =
    ::std::option::Option<unsafe extern "C" fn(pApiVersion: *mut u32) -> VkResult>;
pub type PFN_vkBindBufferMemory2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult,
>;
pub type PFN_vkBindImageMemory2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult,
>;
pub type PFN_vkGetDeviceGroupPeerMemoryFeatures = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    ),
>;
pub type PFN_vkCmdSetDeviceMask =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer, deviceMask: u32)>;
pub type PFN_vkCmdDispatchBase = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ),
>;
pub type PFN_vkEnumeratePhysicalDeviceGroups = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult,
>;
pub type PFN_vkGetImageMemoryRequirements2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    ),
>;
pub type PFN_vkGetBufferMemoryRequirements2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    ),
>;
pub type PFN_vkGetImageSparseMemoryRequirements2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceFeatures2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceFormatProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceMemoryProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    ),
>;
pub type PFN_vkTrimCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    ),
>;
pub type PFN_vkGetDeviceQueue2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pQueueInfo: *const VkDeviceQueueInfo2,
        pQueue: *mut VkQueue,
    ),
>;
pub type PFN_vkCreateSamplerYcbcrConversion = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult,
>;
pub type PFN_vkDestroySamplerYcbcrConversion = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateDescriptorUpdateTemplate = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDescriptorUpdateTemplate = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkUpdateDescriptorSetWithTemplate = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkGetPhysicalDeviceExternalBufferProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceExternalFenceProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceExternalSemaphoreProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    ),
>;
pub type PFN_vkGetDescriptorSetLayoutSupport = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    ),
>;
extern "C" {
    pub fn vkEnumerateInstanceVersion(pApiVersion: *mut u32) -> VkResult;
}
extern "C" {
    pub fn vkBindBufferMemory2(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkBindImageMemory2(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceGroupPeerMemoryFeatures(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    );
}
extern "C" {
    pub fn vkCmdSetDeviceMask(commandBuffer: VkCommandBuffer, deviceMask: u32);
}
extern "C" {
    pub fn vkCmdDispatchBase(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    );
}
extern "C" {
    pub fn vkEnumeratePhysicalDeviceGroups(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetImageMemoryRequirements2(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetBufferMemoryRequirements2(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetImageSparseMemoryRequirements2(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceFeatures2(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceProperties2(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceFormatProperties2(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceImageFormatProperties2(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceQueueFamilyProperties2(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceMemoryProperties2(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceSparseImageFormatProperties2(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    );
}
extern "C" {
    pub fn vkTrimCommandPool(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    );
}
extern "C" {
    pub fn vkGetDeviceQueue2(
        device: VkDevice,
        pQueueInfo: *const VkDeviceQueueInfo2,
        pQueue: *mut VkQueue,
    );
}
extern "C" {
    pub fn vkCreateSamplerYcbcrConversion(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySamplerYcbcrConversion(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateDescriptorUpdateTemplate(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDescriptorUpdateTemplate(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkUpdateDescriptorSetWithTemplate(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceExternalBufferProperties(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceExternalFenceProperties(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceExternalSemaphoreProperties(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    );
}
extern "C" {
    pub fn vkGetDescriptorSetLayoutSupport(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    );
}
pub const VkDriverId_VK_DRIVER_ID_AMD_PROPRIETARY: VkDriverId = 1;
pub const VkDriverId_VK_DRIVER_ID_AMD_OPEN_SOURCE: VkDriverId = 2;
pub const VkDriverId_VK_DRIVER_ID_MESA_RADV: VkDriverId = 3;
pub const VkDriverId_VK_DRIVER_ID_NVIDIA_PROPRIETARY: VkDriverId = 4;
pub const VkDriverId_VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS: VkDriverId = 5;
pub const VkDriverId_VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA: VkDriverId = 6;
pub const VkDriverId_VK_DRIVER_ID_IMAGINATION_PROPRIETARY: VkDriverId = 7;
pub const VkDriverId_VK_DRIVER_ID_QUALCOMM_PROPRIETARY: VkDriverId = 8;
pub const VkDriverId_VK_DRIVER_ID_ARM_PROPRIETARY: VkDriverId = 9;
pub const VkDriverId_VK_DRIVER_ID_GOOGLE_SWIFTSHADER: VkDriverId = 10;
pub const VkDriverId_VK_DRIVER_ID_GGP_PROPRIETARY: VkDriverId = 11;
pub const VkDriverId_VK_DRIVER_ID_BROADCOM_PROPRIETARY: VkDriverId = 12;
pub const VkDriverId_VK_DRIVER_ID_MESA_LLVMPIPE: VkDriverId = 13;
pub const VkDriverId_VK_DRIVER_ID_MOLTENVK: VkDriverId = 14;
pub const VkDriverId_VK_DRIVER_ID_AMD_PROPRIETARY_KHR: VkDriverId = 1;
pub const VkDriverId_VK_DRIVER_ID_AMD_OPEN_SOURCE_KHR: VkDriverId = 2;
pub const VkDriverId_VK_DRIVER_ID_MESA_RADV_KHR: VkDriverId = 3;
pub const VkDriverId_VK_DRIVER_ID_NVIDIA_PROPRIETARY_KHR: VkDriverId = 4;
pub const VkDriverId_VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS_KHR: VkDriverId = 5;
pub const VkDriverId_VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA_KHR: VkDriverId = 6;
pub const VkDriverId_VK_DRIVER_ID_IMAGINATION_PROPRIETARY_KHR: VkDriverId = 7;
pub const VkDriverId_VK_DRIVER_ID_QUALCOMM_PROPRIETARY_KHR: VkDriverId = 8;
pub const VkDriverId_VK_DRIVER_ID_ARM_PROPRIETARY_KHR: VkDriverId = 9;
pub const VkDriverId_VK_DRIVER_ID_GOOGLE_SWIFTSHADER_KHR: VkDriverId = 10;
pub const VkDriverId_VK_DRIVER_ID_GGP_PROPRIETARY_KHR: VkDriverId = 11;
pub const VkDriverId_VK_DRIVER_ID_BROADCOM_PROPRIETARY_KHR: VkDriverId = 12;
pub const VkDriverId_VK_DRIVER_ID_MAX_ENUM: VkDriverId = 2147483647;
pub type VkDriverId = ::std::os::raw::c_uint;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY:
    VkShaderFloatControlsIndependence = 0;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL:
    VkShaderFloatControlsIndependence = 1;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE:
    VkShaderFloatControlsIndependence = 2;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY_KHR : VkShaderFloatControlsIndependence = 0 ;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL_KHR:
    VkShaderFloatControlsIndependence = 1;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE_KHR:
    VkShaderFloatControlsIndependence = 2;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_MAX_ENUM:
    VkShaderFloatControlsIndependence = 2147483647;
pub type VkShaderFloatControlsIndependence = ::std::os::raw::c_uint;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE:
    VkSamplerReductionMode = 0;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MIN: VkSamplerReductionMode = 1;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MAX: VkSamplerReductionMode = 2;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_EXT:
    VkSamplerReductionMode = 0;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MIN_EXT: VkSamplerReductionMode = 1;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MAX_EXT: VkSamplerReductionMode = 2;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MAX_ENUM: VkSamplerReductionMode =
    2147483647;
pub type VkSamplerReductionMode = ::std::os::raw::c_uint;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_BINARY: VkSemaphoreType = 0;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_TIMELINE: VkSemaphoreType = 1;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_BINARY_KHR: VkSemaphoreType = 0;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_TIMELINE_KHR: VkSemaphoreType = 1;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_MAX_ENUM: VkSemaphoreType = 2147483647;
pub type VkSemaphoreType = ::std::os::raw::c_uint;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_NONE: VkResolveModeFlagBits = 0;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_SAMPLE_ZERO_BIT: VkResolveModeFlagBits = 1;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_AVERAGE_BIT: VkResolveModeFlagBits = 2;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MIN_BIT: VkResolveModeFlagBits = 4;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MAX_BIT: VkResolveModeFlagBits = 8;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_NONE_KHR: VkResolveModeFlagBits = 0;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_SAMPLE_ZERO_BIT_KHR: VkResolveModeFlagBits = 1;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_AVERAGE_BIT_KHR: VkResolveModeFlagBits = 2;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MIN_BIT_KHR: VkResolveModeFlagBits = 4;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MAX_BIT_KHR: VkResolveModeFlagBits = 8;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_FLAG_BITS_MAX_ENUM: VkResolveModeFlagBits =
    2147483647;
pub type VkResolveModeFlagBits = ::std::os::raw::c_uint;
pub type VkResolveModeFlags = VkFlags;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT:
    VkDescriptorBindingFlagBits = 1;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT:
    VkDescriptorBindingFlagBits = 2;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT:
    VkDescriptorBindingFlagBits = 4;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT:
    VkDescriptorBindingFlagBits = 8;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT_EXT:
    VkDescriptorBindingFlagBits = 1;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT_EXT:
    VkDescriptorBindingFlagBits = 2;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT_EXT:
    VkDescriptorBindingFlagBits = 4;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT_EXT:
    VkDescriptorBindingFlagBits = 8;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_FLAG_BITS_MAX_ENUM:
    VkDescriptorBindingFlagBits = 2147483647;
pub type VkDescriptorBindingFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorBindingFlags = VkFlags;
pub const VkSemaphoreWaitFlagBits_VK_SEMAPHORE_WAIT_ANY_BIT: VkSemaphoreWaitFlagBits = 1;
pub const VkSemaphoreWaitFlagBits_VK_SEMAPHORE_WAIT_ANY_BIT_KHR: VkSemaphoreWaitFlagBits = 1;
pub const VkSemaphoreWaitFlagBits_VK_SEMAPHORE_WAIT_FLAG_BITS_MAX_ENUM: VkSemaphoreWaitFlagBits =
    2147483647;
pub type VkSemaphoreWaitFlagBits = ::std::os::raw::c_uint;
pub type VkSemaphoreWaitFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan11Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer16BitAccess: VkBool32,
    pub uniformAndStorageBuffer16BitAccess: VkBool32,
    pub storagePushConstant16: VkBool32,
    pub storageInputOutput16: VkBool32,
    pub multiview: VkBool32,
    pub multiviewGeometryShader: VkBool32,
    pub multiviewTessellationShader: VkBool32,
    pub variablePointersStorageBuffer: VkBool32,
    pub variablePointers: VkBool32,
    pub protectedMemory: VkBool32,
    pub samplerYcbcrConversion: VkBool32,
    pub shaderDrawParameters: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan11Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceUUID: [u8; 16usize],
    pub driverUUID: [u8; 16usize],
    pub deviceLUID: [u8; 8usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: VkBool32,
    pub subgroupSize: u32,
    pub subgroupSupportedStages: VkShaderStageFlags,
    pub subgroupSupportedOperations: VkSubgroupFeatureFlags,
    pub subgroupQuadOperationsInAllStages: VkBool32,
    pub pointClippingBehavior: VkPointClippingBehavior,
    pub maxMultiviewViewCount: u32,
    pub maxMultiviewInstanceIndex: u32,
    pub protectedNoFault: VkBool32,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan12Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub samplerMirrorClampToEdge: VkBool32,
    pub drawIndirectCount: VkBool32,
    pub storageBuffer8BitAccess: VkBool32,
    pub uniformAndStorageBuffer8BitAccess: VkBool32,
    pub storagePushConstant8: VkBool32,
    pub shaderBufferInt64Atomics: VkBool32,
    pub shaderSharedInt64Atomics: VkBool32,
    pub shaderFloat16: VkBool32,
    pub shaderInt8: VkBool32,
    pub descriptorIndexing: VkBool32,
    pub shaderInputAttachmentArrayDynamicIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderUniformBufferArrayNonUniformIndexing: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexing: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexing: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: VkBool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingSampledImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUpdateUnusedWhilePending: VkBool32,
    pub descriptorBindingPartiallyBound: VkBool32,
    pub descriptorBindingVariableDescriptorCount: VkBool32,
    pub runtimeDescriptorArray: VkBool32,
    pub samplerFilterMinmax: VkBool32,
    pub scalarBlockLayout: VkBool32,
    pub imagelessFramebuffer: VkBool32,
    pub uniformBufferStandardLayout: VkBool32,
    pub shaderSubgroupExtendedTypes: VkBool32,
    pub separateDepthStencilLayouts: VkBool32,
    pub hostQueryReset: VkBool32,
    pub timelineSemaphore: VkBool32,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
    pub vulkanMemoryModel: VkBool32,
    pub vulkanMemoryModelDeviceScope: VkBool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: VkBool32,
    pub shaderOutputViewportIndex: VkBool32,
    pub shaderOutputLayer: VkBool32,
    pub subgroupBroadcastDynamicId: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan12Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub driverID: VkDriverId,
    pub driverName: [::std::os::raw::c_char; 256usize],
    pub driverInfo: [::std::os::raw::c_char; 256usize],
    pub conformanceVersion: VkConformanceVersion,
    pub denormBehaviorIndependence: VkShaderFloatControlsIndependence,
    pub roundingModeIndependence: VkShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat32: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat64: VkBool32,
    pub shaderDenormPreserveFloat16: VkBool32,
    pub shaderDenormPreserveFloat32: VkBool32,
    pub shaderDenormPreserveFloat64: VkBool32,
    pub shaderDenormFlushToZeroFloat16: VkBool32,
    pub shaderDenormFlushToZeroFloat32: VkBool32,
    pub shaderDenormFlushToZeroFloat64: VkBool32,
    pub shaderRoundingModeRTEFloat16: VkBool32,
    pub shaderRoundingModeRTEFloat32: VkBool32,
    pub shaderRoundingModeRTEFloat64: VkBool32,
    pub shaderRoundingModeRTZFloat16: VkBool32,
    pub shaderRoundingModeRTZFloat32: VkBool32,
    pub shaderRoundingModeRTZFloat64: VkBool32,
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: VkBool32,
    pub robustBufferAccessUpdateAfterBind: VkBool32,
    pub quadDivergentImplicitLod: VkBool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
    pub supportedDepthResolveModes: VkResolveModeFlags,
    pub supportedStencilResolveModes: VkResolveModeFlags,
    pub independentResolveNone: VkBool32,
    pub independentResolve: VkBool32,
    pub filterMinmaxSingleComponentFormats: VkBool32,
    pub filterMinmaxImageComponentMapping: VkBool32,
    pub maxTimelineSemaphoreValueDifference: u64,
    pub framebufferIntegerColorSampleCounts: VkSampleCountFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatListCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub viewFormatCount: u32,
    pub pViewFormats: *const VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescription2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkAttachmentDescriptionFlags,
    pub format: VkFormat,
    pub samples: VkSampleCountFlagBits,
    pub loadOp: VkAttachmentLoadOp,
    pub storeOp: VkAttachmentStoreOp,
    pub stencilLoadOp: VkAttachmentLoadOp,
    pub stencilStoreOp: VkAttachmentStoreOp,
    pub initialLayout: VkImageLayout,
    pub finalLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReference2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachment: u32,
    pub layout: VkImageLayout,
    pub aspectMask: VkImageAspectFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescription2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSubpassDescriptionFlags,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub viewMask: u32,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const VkAttachmentReference2,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const VkAttachmentReference2,
    pub pResolveAttachments: *const VkAttachmentReference2,
    pub pDepthStencilAttachment: *const VkAttachmentReference2,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDependency2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: VkPipelineStageFlags,
    pub dstStageMask: VkPipelineStageFlags,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub dependencyFlags: VkDependencyFlags,
    pub viewOffset: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassCreateInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const VkAttachmentDescription2,
    pub subpassCount: u32,
    pub pSubpasses: *const VkSubpassDescription2,
    pub dependencyCount: u32,
    pub pDependencies: *const VkSubpassDependency2,
    pub correlatedViewMaskCount: u32,
    pub pCorrelatedViewMasks: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub contents: VkSubpassContents,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassEndInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice8BitStorageFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer8BitAccess: VkBool32,
    pub uniformAndStorageBuffer8BitAccess: VkBool32,
    pub storagePushConstant8: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDriverProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub driverID: VkDriverId,
    pub driverName: [::std::os::raw::c_char; 256usize],
    pub driverInfo: [::std::os::raw::c_char; 256usize],
    pub conformanceVersion: VkConformanceVersion,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderAtomicInt64Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderBufferInt64Atomics: VkBool32,
    pub shaderSharedInt64Atomics: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderFloat16Int8Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderFloat16: VkBool32,
    pub shaderInt8: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFloatControlsProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub denormBehaviorIndependence: VkShaderFloatControlsIndependence,
    pub roundingModeIndependence: VkShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat32: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat64: VkBool32,
    pub shaderDenormPreserveFloat16: VkBool32,
    pub shaderDenormPreserveFloat32: VkBool32,
    pub shaderDenormPreserveFloat64: VkBool32,
    pub shaderDenormFlushToZeroFloat16: VkBool32,
    pub shaderDenormFlushToZeroFloat32: VkBool32,
    pub shaderDenormFlushToZeroFloat64: VkBool32,
    pub shaderRoundingModeRTEFloat16: VkBool32,
    pub shaderRoundingModeRTEFloat32: VkBool32,
    pub shaderRoundingModeRTEFloat64: VkBool32,
    pub shaderRoundingModeRTZFloat16: VkBool32,
    pub shaderRoundingModeRTZFloat32: VkBool32,
    pub shaderRoundingModeRTZFloat64: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutBindingFlagsCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub bindingCount: u32,
    pub pBindingFlags: *const VkDescriptorBindingFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDescriptorIndexingFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderInputAttachmentArrayDynamicIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderUniformBufferArrayNonUniformIndexing: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexing: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexing: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: VkBool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingSampledImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUpdateUnusedWhilePending: VkBool32,
    pub descriptorBindingPartiallyBound: VkBool32,
    pub descriptorBindingVariableDescriptorCount: VkBool32,
    pub runtimeDescriptorArray: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDescriptorIndexingProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: VkBool32,
    pub robustBufferAccessUpdateAfterBind: VkBool32,
    pub quadDivergentImplicitLod: VkBool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetVariableDescriptorCountAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub descriptorSetCount: u32,
    pub pDescriptorCounts: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetVariableDescriptorCountLayoutSupport {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxVariableDescriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescriptionDepthStencilResolve {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub depthResolveMode: VkResolveModeFlagBits,
    pub stencilResolveMode: VkResolveModeFlagBits,
    pub pDepthStencilResolveAttachment: *const VkAttachmentReference2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDepthStencilResolveProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supportedDepthResolveModes: VkResolveModeFlags,
    pub supportedStencilResolveModes: VkResolveModeFlags,
    pub independentResolveNone: VkBool32,
    pub independentResolve: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceScalarBlockLayoutFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub scalarBlockLayout: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageStencilUsageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stencilUsage: VkImageUsageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerReductionModeCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub reductionMode: VkSamplerReductionMode,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSamplerFilterMinmaxProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub filterMinmaxSingleComponentFormats: VkBool32,
    pub filterMinmaxImageComponentMapping: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkanMemoryModelFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub vulkanMemoryModel: VkBool32,
    pub vulkanMemoryModelDeviceScope: VkBool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImagelessFramebufferFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imagelessFramebuffer: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferAttachmentImageInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageCreateFlags,
    pub usage: VkImageUsageFlags,
    pub width: u32,
    pub height: u32,
    pub layerCount: u32,
    pub viewFormatCount: u32,
    pub pViewFormats: *const VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferAttachmentsCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentImageInfoCount: u32,
    pub pAttachmentImageInfos: *const VkFramebufferAttachmentImageInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassAttachmentBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentCount: u32,
    pub pAttachments: *const VkImageView,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub uniformBufferStandardLayout: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSubgroupExtendedTypes: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub separateDepthStencilLayouts: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReferenceStencilLayout {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stencilLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescriptionStencilLayout {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stencilInitialLayout: VkImageLayout,
    pub stencilFinalLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceHostQueryResetFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub hostQueryReset: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTimelineSemaphoreFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub timelineSemaphore: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTimelineSemaphoreProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxTimelineSemaphoreValueDifference: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreTypeCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphoreType: VkSemaphoreType,
    pub initialValue: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTimelineSemaphoreSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreValueCount: u32,
    pub pWaitSemaphoreValues: *const u64,
    pub signalSemaphoreValueCount: u32,
    pub pSignalSemaphoreValues: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreWaitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSemaphoreWaitFlags,
    pub semaphoreCount: u32,
    pub pSemaphores: *const VkSemaphore,
    pub pValues: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreSignalInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub value: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBufferDeviceAddressFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferDeviceAddressInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferOpaqueCaptureAddressCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub opaqueCaptureAddress: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryOpaqueCaptureAddressAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub opaqueCaptureAddress: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemoryOpaqueCaptureAddressInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
}
pub type PFN_vkCmdDrawIndirectCount = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDrawIndexedIndirectCount = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCreateRenderPass2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo2,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult,
>;
pub type PFN_vkCmdBeginRenderPass2 = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
    ),
>;
pub type PFN_vkCmdNextSubpass2 = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    ),
>;
pub type PFN_vkCmdEndRenderPass2 = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pSubpassEndInfo: *const VkSubpassEndInfo),
>;
pub type PFN_vkResetQueryPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    ),
>;
pub type PFN_vkGetSemaphoreCounterValue = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, semaphore: VkSemaphore, pValue: *mut u64) -> VkResult,
>;
pub type PFN_vkWaitSemaphores = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pWaitInfo: *const VkSemaphoreWaitInfo,
        timeout: u64,
    ) -> VkResult,
>;
pub type PFN_vkSignalSemaphore = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pSignalInfo: *const VkSemaphoreSignalInfo) -> VkResult,
>;
pub type PFN_vkGetBufferDeviceAddress = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress,
>;
pub type PFN_vkGetBufferOpaqueCaptureAddress = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkBufferDeviceAddressInfo) -> u64,
>;
pub type PFN_vkGetDeviceMemoryOpaqueCaptureAddress = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64,
>;
extern "C" {
    pub fn vkCmdDrawIndirectCount(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndexedIndirectCount(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCreateRenderPass2(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo2,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdBeginRenderPass2(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
    );
}
extern "C" {
    pub fn vkCmdNextSubpass2(
        commandBuffer: VkCommandBuffer,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    );
}
extern "C" {
    pub fn vkCmdEndRenderPass2(
        commandBuffer: VkCommandBuffer,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    );
}
extern "C" {
    pub fn vkResetQueryPool(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    );
}
extern "C" {
    pub fn vkGetSemaphoreCounterValue(
        device: VkDevice,
        semaphore: VkSemaphore,
        pValue: *mut u64,
    ) -> VkResult;
}
extern "C" {
    pub fn vkWaitSemaphores(
        device: VkDevice,
        pWaitInfo: *const VkSemaphoreWaitInfo,
        timeout: u64,
    ) -> VkResult;
}
extern "C" {
    pub fn vkSignalSemaphore(
        device: VkDevice,
        pSignalInfo: *const VkSemaphoreSignalInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetBufferDeviceAddress(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress;
}
extern "C" {
    pub fn vkGetBufferOpaqueCaptureAddress(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> u64;
}
extern "C" {
    pub fn vkGetDeviceMemoryOpaqueCaptureAddress(
        device: VkDevice,
        pInfo: *const VkDeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceKHR_T {
    _unused: [u8; 0],
}
pub type VkSurfaceKHR = *mut VkSurfaceKHR_T;
pub const VkPresentModeKHR_VK_PRESENT_MODE_IMMEDIATE_KHR: VkPresentModeKHR = 0;
pub const VkPresentModeKHR_VK_PRESENT_MODE_MAILBOX_KHR: VkPresentModeKHR = 1;
pub const VkPresentModeKHR_VK_PRESENT_MODE_FIFO_KHR: VkPresentModeKHR = 2;
pub const VkPresentModeKHR_VK_PRESENT_MODE_FIFO_RELAXED_KHR: VkPresentModeKHR = 3;
pub const VkPresentModeKHR_VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR: VkPresentModeKHR = 1000111000;
pub const VkPresentModeKHR_VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR: VkPresentModeKHR =
    1000111001;
pub const VkPresentModeKHR_VK_PRESENT_MODE_MAX_ENUM_KHR: VkPresentModeKHR = 2147483647;
pub type VkPresentModeKHR = ::std::os::raw::c_uint;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_SRGB_NONLINEAR_KHR: VkColorSpaceKHR = 0;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT: VkColorSpaceKHR = 1000104001;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT: VkColorSpaceKHR = 1000104002;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT: VkColorSpaceKHR = 1000104003;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT: VkColorSpaceKHR = 1000104004;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_BT709_LINEAR_EXT: VkColorSpaceKHR = 1000104005;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_BT709_NONLINEAR_EXT: VkColorSpaceKHR = 1000104006;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_BT2020_LINEAR_EXT: VkColorSpaceKHR = 1000104007;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_HDR10_ST2084_EXT: VkColorSpaceKHR = 1000104008;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_DOLBYVISION_EXT: VkColorSpaceKHR = 1000104009;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_HDR10_HLG_EXT: VkColorSpaceKHR = 1000104010;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT: VkColorSpaceKHR = 1000104011;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT: VkColorSpaceKHR = 1000104012;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_PASS_THROUGH_EXT: VkColorSpaceKHR = 1000104013;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT: VkColorSpaceKHR = 1000104014;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_DISPLAY_NATIVE_AMD: VkColorSpaceKHR = 1000213000;
pub const VkColorSpaceKHR_VK_COLORSPACE_SRGB_NONLINEAR_KHR: VkColorSpaceKHR = 0;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_DCI_P3_LINEAR_EXT: VkColorSpaceKHR = 1000104003;
pub const VkColorSpaceKHR_VK_COLOR_SPACE_MAX_ENUM_KHR: VkColorSpaceKHR = 2147483647;
pub type VkColorSpaceKHR = ::std::os::raw::c_uint;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 1;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 2;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 4;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 8;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 16;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 32;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR : VkSurfaceTransformFlagBitsKHR = 64 ;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR : VkSurfaceTransformFlagBitsKHR = 128 ;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 256;
pub const VkSurfaceTransformFlagBitsKHR_VK_SURFACE_TRANSFORM_FLAG_BITS_MAX_ENUM_KHR:
    VkSurfaceTransformFlagBitsKHR = 2147483647;
pub type VkSurfaceTransformFlagBitsKHR = ::std::os::raw::c_uint;
pub const VkCompositeAlphaFlagBitsKHR_VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 1;
pub const VkCompositeAlphaFlagBitsKHR_VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 2;
pub const VkCompositeAlphaFlagBitsKHR_VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 4;
pub const VkCompositeAlphaFlagBitsKHR_VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 8;
pub const VkCompositeAlphaFlagBitsKHR_VK_COMPOSITE_ALPHA_FLAG_BITS_MAX_ENUM_KHR:
    VkCompositeAlphaFlagBitsKHR = 2147483647;
pub type VkCompositeAlphaFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkCompositeAlphaFlagsKHR = VkFlags;
pub type VkSurfaceTransformFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceCapabilitiesKHR {
    pub minImageCount: u32,
    pub maxImageCount: u32,
    pub currentExtent: VkExtent2D,
    pub minImageExtent: VkExtent2D,
    pub maxImageExtent: VkExtent2D,
    pub maxImageArrayLayers: u32,
    pub supportedTransforms: VkSurfaceTransformFlagsKHR,
    pub currentTransform: VkSurfaceTransformFlagBitsKHR,
    pub supportedCompositeAlpha: VkCompositeAlphaFlagsKHR,
    pub supportedUsageFlags: VkImageUsageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceFormatKHR {
    pub format: VkFormat,
    pub colorSpace: VkColorSpaceKHR,
}
pub type PFN_vkDestroySurfaceKHR = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        surface: VkSurfaceKHR,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetPhysicalDeviceSurfaceSupportKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        surface: VkSurfaceKHR,
        pSupported: *mut VkBool32,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilitiesKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceSurfaceFormatsKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut VkSurfaceFormatKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceSurfacePresentModesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pPresentModeCount: *mut u32,
        pPresentModes: *mut VkPresentModeKHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkDestroySurfaceKHR(
        instance: VkInstance,
        surface: VkSurfaceKHR,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceSurfaceSupportKHR(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        surface: VkSurfaceKHR,
        pSupported: *mut VkBool32,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceSurfaceCapabilitiesKHR(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilitiesKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceSurfaceFormatsKHR(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut VkSurfaceFormatKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceSurfacePresentModesKHR(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pPresentModeCount: *mut u32,
        pPresentModes: *mut VkPresentModeKHR,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainKHR_T {
    _unused: [u8; 0],
}
pub type VkSwapchainKHR = *mut VkSwapchainKHR_T;
pub const VkSwapchainCreateFlagBitsKHR_VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR:
    VkSwapchainCreateFlagBitsKHR = 1;
pub const VkSwapchainCreateFlagBitsKHR_VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR:
    VkSwapchainCreateFlagBitsKHR = 2;
pub const VkSwapchainCreateFlagBitsKHR_VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR:
    VkSwapchainCreateFlagBitsKHR = 4;
pub const VkSwapchainCreateFlagBitsKHR_VK_SWAPCHAIN_CREATE_FLAG_BITS_MAX_ENUM_KHR:
    VkSwapchainCreateFlagBitsKHR = 2147483647;
pub type VkSwapchainCreateFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkSwapchainCreateFlagsKHR = VkFlags;
pub const VkDeviceGroupPresentModeFlagBitsKHR_VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR:
    VkDeviceGroupPresentModeFlagBitsKHR = 1;
pub const VkDeviceGroupPresentModeFlagBitsKHR_VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR:
    VkDeviceGroupPresentModeFlagBitsKHR = 2;
pub const VkDeviceGroupPresentModeFlagBitsKHR_VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR:
    VkDeviceGroupPresentModeFlagBitsKHR = 4;
pub const VkDeviceGroupPresentModeFlagBitsKHR_VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR : VkDeviceGroupPresentModeFlagBitsKHR = 8 ;
pub const VkDeviceGroupPresentModeFlagBitsKHR_VK_DEVICE_GROUP_PRESENT_MODE_FLAG_BITS_MAX_ENUM_KHR : VkDeviceGroupPresentModeFlagBitsKHR = 2147483647 ;
pub type VkDeviceGroupPresentModeFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkDeviceGroupPresentModeFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSwapchainCreateFlagsKHR,
    pub surface: VkSurfaceKHR,
    pub minImageCount: u32,
    pub imageFormat: VkFormat,
    pub imageColorSpace: VkColorSpaceKHR,
    pub imageExtent: VkExtent2D,
    pub imageArrayLayers: u32,
    pub imageUsage: VkImageUsageFlags,
    pub imageSharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
    pub preTransform: VkSurfaceTransformFlagBitsKHR,
    pub compositeAlpha: VkCompositeAlphaFlagBitsKHR,
    pub presentMode: VkPresentModeKHR,
    pub clipped: VkBool32,
    pub oldSwapchain: VkSwapchainKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub swapchainCount: u32,
    pub pSwapchains: *const VkSwapchainKHR,
    pub pImageIndices: *const u32,
    pub pResults: *mut VkResult,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSwapchainCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchain: VkSwapchainKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemorySwapchainInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchain: VkSwapchainKHR,
    pub imageIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAcquireNextImageInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchain: VkSwapchainKHR,
    pub timeout: u64,
    pub semaphore: VkSemaphore,
    pub fence: VkFence,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupPresentCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub presentMask: [u32; 32usize],
    pub modes: VkDeviceGroupPresentModeFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupPresentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchainCount: u32,
    pub pDeviceMasks: *const u32,
    pub mode: VkDeviceGroupPresentModeFlagBitsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupSwapchainCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub modes: VkDeviceGroupPresentModeFlagsKHR,
}
pub type PFN_vkCreateSwapchainKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSwapchainCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSwapchain: *mut VkSwapchainKHR,
    ) -> VkResult,
>;
pub type PFN_vkDestroySwapchainKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetSwapchainImagesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pSwapchainImageCount: *mut u32,
        pSwapchainImages: *mut VkImage,
    ) -> VkResult,
>;
pub type PFN_vkAcquireNextImageKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        timeout: u64,
        semaphore: VkSemaphore,
        fence: VkFence,
        pImageIndex: *mut u32,
    ) -> VkResult,
>;
pub type PFN_vkQueuePresentKHR = ::std::option::Option<
    unsafe extern "C" fn(queue: VkQueue, pPresentInfo: *const VkPresentInfoKHR) -> VkResult,
>;
pub type PFN_vkGetDeviceGroupPresentCapabilitiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pDeviceGroupPresentCapabilities: *mut VkDeviceGroupPresentCapabilitiesKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetDeviceGroupSurfacePresentModesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        surface: VkSurfaceKHR,
        pModes: *mut VkDeviceGroupPresentModeFlagsKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDevicePresentRectanglesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pRectCount: *mut u32,
        pRects: *mut VkRect2D,
    ) -> VkResult,
>;
pub type PFN_vkAcquireNextImage2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAcquireInfo: *const VkAcquireNextImageInfoKHR,
        pImageIndex: *mut u32,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkCreateSwapchainKHR(
        device: VkDevice,
        pCreateInfo: *const VkSwapchainCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSwapchain: *mut VkSwapchainKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySwapchainKHR(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetSwapchainImagesKHR(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pSwapchainImageCount: *mut u32,
        pSwapchainImages: *mut VkImage,
    ) -> VkResult;
}
extern "C" {
    pub fn vkAcquireNextImageKHR(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        timeout: u64,
        semaphore: VkSemaphore,
        fence: VkFence,
        pImageIndex: *mut u32,
    ) -> VkResult;
}
extern "C" {
    pub fn vkQueuePresentKHR(queue: VkQueue, pPresentInfo: *const VkPresentInfoKHR) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceGroupPresentCapabilitiesKHR(
        device: VkDevice,
        pDeviceGroupPresentCapabilities: *mut VkDeviceGroupPresentCapabilitiesKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceGroupSurfacePresentModesKHR(
        device: VkDevice,
        surface: VkSurfaceKHR,
        pModes: *mut VkDeviceGroupPresentModeFlagsKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDevicePresentRectanglesKHR(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pRectCount: *mut u32,
        pRects: *mut VkRect2D,
    ) -> VkResult;
}
extern "C" {
    pub fn vkAcquireNextImage2KHR(
        device: VkDevice,
        pAcquireInfo: *const VkAcquireNextImageInfoKHR,
        pImageIndex: *mut u32,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayKHR_T {
    _unused: [u8; 0],
}
pub type VkDisplayKHR = *mut VkDisplayKHR_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeKHR_T {
    _unused: [u8; 0],
}
pub type VkDisplayModeKHR = *mut VkDisplayModeKHR_T;
pub type VkDisplayModeCreateFlagsKHR = VkFlags;
pub const VkDisplayPlaneAlphaFlagBitsKHR_VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 1;
pub const VkDisplayPlaneAlphaFlagBitsKHR_VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 2;
pub const VkDisplayPlaneAlphaFlagBitsKHR_VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 4;
pub const VkDisplayPlaneAlphaFlagBitsKHR_VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 8;
pub const VkDisplayPlaneAlphaFlagBitsKHR_VK_DISPLAY_PLANE_ALPHA_FLAG_BITS_MAX_ENUM_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 2147483647;
pub type VkDisplayPlaneAlphaFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkDisplayPlaneAlphaFlagsKHR = VkFlags;
pub type VkDisplaySurfaceCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeParametersKHR {
    pub visibleRegion: VkExtent2D,
    pub refreshRate: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDisplayModeCreateFlagsKHR,
    pub parameters: VkDisplayModeParametersKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModePropertiesKHR {
    pub displayMode: VkDisplayModeKHR,
    pub parameters: VkDisplayModeParametersKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneCapabilitiesKHR {
    pub supportedAlpha: VkDisplayPlaneAlphaFlagsKHR,
    pub minSrcPosition: VkOffset2D,
    pub maxSrcPosition: VkOffset2D,
    pub minSrcExtent: VkExtent2D,
    pub maxSrcExtent: VkExtent2D,
    pub minDstPosition: VkOffset2D,
    pub maxDstPosition: VkOffset2D,
    pub minDstExtent: VkExtent2D,
    pub maxDstExtent: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlanePropertiesKHR {
    pub currentDisplay: VkDisplayKHR,
    pub currentStackIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPropertiesKHR {
    pub display: VkDisplayKHR,
    pub displayName: *const ::std::os::raw::c_char,
    pub physicalDimensions: VkExtent2D,
    pub physicalResolution: VkExtent2D,
    pub supportedTransforms: VkSurfaceTransformFlagsKHR,
    pub planeReorderPossible: VkBool32,
    pub persistentContent: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplaySurfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDisplaySurfaceCreateFlagsKHR,
    pub displayMode: VkDisplayModeKHR,
    pub planeIndex: u32,
    pub planeStackIndex: u32,
    pub transform: VkSurfaceTransformFlagBitsKHR,
    pub globalAlpha: f32,
    pub alphaMode: VkDisplayPlaneAlphaFlagBitsKHR,
    pub imageExtent: VkExtent2D,
}
pub type PFN_vkGetPhysicalDeviceDisplayPropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPropertiesKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPlanePropertiesKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetDisplayPlaneSupportedDisplaysKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        planeIndex: u32,
        pDisplayCount: *mut u32,
        pDisplays: *mut VkDisplayKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetDisplayModePropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayModePropertiesKHR,
    ) -> VkResult,
>;
pub type PFN_vkCreateDisplayModeKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pCreateInfo: *const VkDisplayModeCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pMode: *mut VkDisplayModeKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetDisplayPlaneCapabilitiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        mode: VkDisplayModeKHR,
        planeIndex: u32,
        pCapabilities: *mut VkDisplayPlaneCapabilitiesKHR,
    ) -> VkResult,
>;
pub type PFN_vkCreateDisplayPlaneSurfaceKHR = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkDisplaySurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceDisplayPropertiesKHR(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPropertiesKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceDisplayPlanePropertiesKHR(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPlanePropertiesKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDisplayPlaneSupportedDisplaysKHR(
        physicalDevice: VkPhysicalDevice,
        planeIndex: u32,
        pDisplayCount: *mut u32,
        pDisplays: *mut VkDisplayKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDisplayModePropertiesKHR(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayModePropertiesKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateDisplayModeKHR(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pCreateInfo: *const VkDisplayModeCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pMode: *mut VkDisplayModeKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDisplayPlaneCapabilitiesKHR(
        physicalDevice: VkPhysicalDevice,
        mode: VkDisplayModeKHR,
        planeIndex: u32,
        pCapabilities: *mut VkDisplayPlaneCapabilitiesKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateDisplayPlaneSurfaceKHR(
        instance: VkInstance,
        pCreateInfo: *const VkDisplaySurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPresentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcRect: VkRect2D,
    pub dstRect: VkRect2D,
    pub persistent: VkBool32,
}
pub type PFN_vkCreateSharedSwapchainsKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchainCount: u32,
        pCreateInfos: *const VkSwapchainCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSwapchains: *mut VkSwapchainKHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkCreateSharedSwapchainsKHR(
        device: VkDevice,
        swapchainCount: u32,
        pCreateInfos: *const VkSwapchainCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSwapchains: *mut VkSwapchainKHR,
    ) -> VkResult;
}
pub type VkRenderPassMultiviewCreateInfoKHR = VkRenderPassMultiviewCreateInfo;
pub type VkPhysicalDeviceMultiviewFeaturesKHR = VkPhysicalDeviceMultiviewFeatures;
pub type VkPhysicalDeviceMultiviewPropertiesKHR = VkPhysicalDeviceMultiviewProperties;
pub type VkPhysicalDeviceFeatures2KHR = VkPhysicalDeviceFeatures2;
pub type VkPhysicalDeviceProperties2KHR = VkPhysicalDeviceProperties2;
pub type VkFormatProperties2KHR = VkFormatProperties2;
pub type VkImageFormatProperties2KHR = VkImageFormatProperties2;
pub type VkPhysicalDeviceImageFormatInfo2KHR = VkPhysicalDeviceImageFormatInfo2;
pub type VkQueueFamilyProperties2KHR = VkQueueFamilyProperties2;
pub type VkPhysicalDeviceMemoryProperties2KHR = VkPhysicalDeviceMemoryProperties2;
pub type VkSparseImageFormatProperties2KHR = VkSparseImageFormatProperties2;
pub type VkPhysicalDeviceSparseImageFormatInfo2KHR = VkPhysicalDeviceSparseImageFormatInfo2;
pub type PFN_vkGetPhysicalDeviceFeatures2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceFormatProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceMemoryProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    ),
>;
extern "C" {
    pub fn vkGetPhysicalDeviceFeatures2KHR(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceFormatProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceImageFormatProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceQueueFamilyProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceMemoryProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceSparseImageFormatProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    );
}
pub type VkPeerMemoryFeatureFlagsKHR = VkPeerMemoryFeatureFlags;
pub use self::VkPeerMemoryFeatureFlagBits as VkPeerMemoryFeatureFlagBitsKHR;
pub type VkMemoryAllocateFlagsKHR = VkMemoryAllocateFlags;
pub use self::VkMemoryAllocateFlagBits as VkMemoryAllocateFlagBitsKHR;
pub type VkMemoryAllocateFlagsInfoKHR = VkMemoryAllocateFlagsInfo;
pub type VkDeviceGroupRenderPassBeginInfoKHR = VkDeviceGroupRenderPassBeginInfo;
pub type VkDeviceGroupCommandBufferBeginInfoKHR = VkDeviceGroupCommandBufferBeginInfo;
pub type VkDeviceGroupSubmitInfoKHR = VkDeviceGroupSubmitInfo;
pub type VkDeviceGroupBindSparseInfoKHR = VkDeviceGroupBindSparseInfo;
pub type VkBindBufferMemoryDeviceGroupInfoKHR = VkBindBufferMemoryDeviceGroupInfo;
pub type VkBindImageMemoryDeviceGroupInfoKHR = VkBindImageMemoryDeviceGroupInfo;
pub type PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    ),
>;
pub type PFN_vkCmdSetDeviceMaskKHR =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer, deviceMask: u32)>;
pub type PFN_vkCmdDispatchBaseKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ),
>;
extern "C" {
    pub fn vkGetDeviceGroupPeerMemoryFeaturesKHR(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    );
}
extern "C" {
    pub fn vkCmdSetDeviceMaskKHR(commandBuffer: VkCommandBuffer, deviceMask: u32);
}
extern "C" {
    pub fn vkCmdDispatchBaseKHR(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    );
}
pub type VkCommandPoolTrimFlagsKHR = VkCommandPoolTrimFlags;
pub type PFN_vkTrimCommandPoolKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    ),
>;
extern "C" {
    pub fn vkTrimCommandPoolKHR(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    );
}
pub type VkPhysicalDeviceGroupPropertiesKHR = VkPhysicalDeviceGroupProperties;
pub type VkDeviceGroupDeviceCreateInfoKHR = VkDeviceGroupDeviceCreateInfo;
pub type PFN_vkEnumeratePhysicalDeviceGroupsKHR = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkEnumeratePhysicalDeviceGroupsKHR(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult;
}
pub type VkExternalMemoryHandleTypeFlagsKHR = VkExternalMemoryHandleTypeFlags;
pub use self::VkExternalMemoryHandleTypeFlagBits as VkExternalMemoryHandleTypeFlagBitsKHR;
pub type VkExternalMemoryFeatureFlagsKHR = VkExternalMemoryFeatureFlags;
pub use self::VkExternalMemoryFeatureFlagBits as VkExternalMemoryFeatureFlagBitsKHR;
pub type VkExternalMemoryPropertiesKHR = VkExternalMemoryProperties;
pub type VkPhysicalDeviceExternalImageFormatInfoKHR = VkPhysicalDeviceExternalImageFormatInfo;
pub type VkExternalImageFormatPropertiesKHR = VkExternalImageFormatProperties;
pub type VkPhysicalDeviceExternalBufferInfoKHR = VkPhysicalDeviceExternalBufferInfo;
pub type VkExternalBufferPropertiesKHR = VkExternalBufferProperties;
pub type VkPhysicalDeviceIDPropertiesKHR = VkPhysicalDeviceIDProperties;
pub type PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    ),
>;
extern "C" {
    pub fn vkGetPhysicalDeviceExternalBufferPropertiesKHR(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    );
}
pub type VkExternalMemoryImageCreateInfoKHR = VkExternalMemoryImageCreateInfo;
pub type VkExternalMemoryBufferCreateInfoKHR = VkExternalMemoryBufferCreateInfo;
pub type VkExportMemoryAllocateInfoKHR = VkExportMemoryAllocateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
    pub fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryFdPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryGetFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
pub type PFN_vkGetMemoryFdKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pGetFdInfo: *const VkMemoryGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult,
>;
pub type PFN_vkGetMemoryFdPropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        fd: ::std::os::raw::c_int,
        pMemoryFdProperties: *mut VkMemoryFdPropertiesKHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetMemoryFdKHR(
        device: VkDevice,
        pGetFdInfo: *const VkMemoryGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetMemoryFdPropertiesKHR(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        fd: ::std::os::raw::c_int,
        pMemoryFdProperties: *mut VkMemoryFdPropertiesKHR,
    ) -> VkResult;
}
pub type VkExternalSemaphoreHandleTypeFlagsKHR = VkExternalSemaphoreHandleTypeFlags;
pub use self::VkExternalSemaphoreHandleTypeFlagBits as VkExternalSemaphoreHandleTypeFlagBitsKHR;
pub type VkExternalSemaphoreFeatureFlagsKHR = VkExternalSemaphoreFeatureFlags;
pub use self::VkExternalSemaphoreFeatureFlagBits as VkExternalSemaphoreFeatureFlagBitsKHR;
pub type VkPhysicalDeviceExternalSemaphoreInfoKHR = VkPhysicalDeviceExternalSemaphoreInfo;
pub type VkExternalSemaphorePropertiesKHR = VkExternalSemaphoreProperties;
pub type PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    ),
>;
extern "C" {
    pub fn vkGetPhysicalDeviceExternalSemaphorePropertiesKHR(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    );
}
pub type VkSemaphoreImportFlagsKHR = VkSemaphoreImportFlags;
pub use self::VkSemaphoreImportFlagBits as VkSemaphoreImportFlagBitsKHR;
pub type VkExportSemaphoreCreateInfoKHR = VkExportSemaphoreCreateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportSemaphoreFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub flags: VkSemaphoreImportFlags,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
    pub fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreGetFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
}
pub type PFN_vkImportSemaphoreFdKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pImportSemaphoreFdInfo: *const VkImportSemaphoreFdInfoKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetSemaphoreFdKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pGetFdInfo: *const VkSemaphoreGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkImportSemaphoreFdKHR(
        device: VkDevice,
        pImportSemaphoreFdInfo: *const VkImportSemaphoreFdInfoKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetSemaphoreFdKHR(
        device: VkDevice,
        pGetFdInfo: *const VkSemaphoreGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePushDescriptorPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxPushDescriptors: u32,
}
pub type PFN_vkCmdPushDescriptorSetKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        set: u32,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
    ),
>;
pub type PFN_vkCmdPushDescriptorSetWithTemplateKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        layout: VkPipelineLayout,
        set: u32,
        pData: *const ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub fn vkCmdPushDescriptorSetKHR(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        set: u32,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
    );
}
extern "C" {
    pub fn vkCmdPushDescriptorSetWithTemplateKHR(
        commandBuffer: VkCommandBuffer,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        layout: VkPipelineLayout,
        set: u32,
        pData: *const ::std::os::raw::c_void,
    );
}
pub type VkPhysicalDeviceShaderFloat16Int8FeaturesKHR = VkPhysicalDeviceShaderFloat16Int8Features;
pub type VkPhysicalDeviceFloat16Int8FeaturesKHR = VkPhysicalDeviceShaderFloat16Int8Features;
pub type VkPhysicalDevice16BitStorageFeaturesKHR = VkPhysicalDevice16BitStorageFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRectLayerKHR {
    pub offset: VkOffset2D,
    pub extent: VkExtent2D,
    pub layer: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentRegionKHR {
    pub rectangleCount: u32,
    pub pRectangles: *const VkRectLayerKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentRegionsKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchainCount: u32,
    pub pRegions: *const VkPresentRegionKHR,
}
pub type VkDescriptorUpdateTemplateKHR = VkDescriptorUpdateTemplate;
pub use self::VkDescriptorUpdateTemplateType as VkDescriptorUpdateTemplateTypeKHR;
pub type VkDescriptorUpdateTemplateCreateFlagsKHR = VkDescriptorUpdateTemplateCreateFlags;
pub type VkDescriptorUpdateTemplateEntryKHR = VkDescriptorUpdateTemplateEntry;
pub type VkDescriptorUpdateTemplateCreateInfoKHR = VkDescriptorUpdateTemplateCreateInfo;
pub type PFN_vkCreateDescriptorUpdateTemplateKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDescriptorUpdateTemplateKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkUpdateDescriptorSetWithTemplateKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub fn vkCreateDescriptorUpdateTemplateKHR(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDescriptorUpdateTemplateKHR(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkUpdateDescriptorSetWithTemplateKHR(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    );
}
pub type VkPhysicalDeviceImagelessFramebufferFeaturesKHR =
    VkPhysicalDeviceImagelessFramebufferFeatures;
pub type VkFramebufferAttachmentsCreateInfoKHR = VkFramebufferAttachmentsCreateInfo;
pub type VkFramebufferAttachmentImageInfoKHR = VkFramebufferAttachmentImageInfo;
pub type VkRenderPassAttachmentBeginInfoKHR = VkRenderPassAttachmentBeginInfo;
pub type VkRenderPassCreateInfo2KHR = VkRenderPassCreateInfo2;
pub type VkAttachmentDescription2KHR = VkAttachmentDescription2;
pub type VkAttachmentReference2KHR = VkAttachmentReference2;
pub type VkSubpassDescription2KHR = VkSubpassDescription2;
pub type VkSubpassDependency2KHR = VkSubpassDependency2;
pub type VkSubpassBeginInfoKHR = VkSubpassBeginInfo;
pub type VkSubpassEndInfoKHR = VkSubpassEndInfo;
pub type PFN_vkCreateRenderPass2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo2,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult,
>;
pub type PFN_vkCmdBeginRenderPass2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
    ),
>;
pub type PFN_vkCmdNextSubpass2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    ),
>;
pub type PFN_vkCmdEndRenderPass2KHR = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pSubpassEndInfo: *const VkSubpassEndInfo),
>;
extern "C" {
    pub fn vkCreateRenderPass2KHR(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo2,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdBeginRenderPass2KHR(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
    );
}
extern "C" {
    pub fn vkCmdNextSubpass2KHR(
        commandBuffer: VkCommandBuffer,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    );
}
extern "C" {
    pub fn vkCmdEndRenderPass2KHR(
        commandBuffer: VkCommandBuffer,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSharedPresentSurfaceCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub sharedPresentSupportedUsageFlags: VkImageUsageFlags,
}
pub type PFN_vkGetSwapchainStatusKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, swapchain: VkSwapchainKHR) -> VkResult,
>;
extern "C" {
    pub fn vkGetSwapchainStatusKHR(device: VkDevice, swapchain: VkSwapchainKHR) -> VkResult;
}
pub type VkExternalFenceHandleTypeFlagsKHR = VkExternalFenceHandleTypeFlags;
pub use self::VkExternalFenceHandleTypeFlagBits as VkExternalFenceHandleTypeFlagBitsKHR;
pub type VkExternalFenceFeatureFlagsKHR = VkExternalFenceFeatureFlags;
pub use self::VkExternalFenceFeatureFlagBits as VkExternalFenceFeatureFlagBitsKHR;
pub type VkPhysicalDeviceExternalFenceInfoKHR = VkPhysicalDeviceExternalFenceInfo;
pub type VkExternalFencePropertiesKHR = VkExternalFenceProperties;
pub type PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    ),
>;
extern "C" {
    pub fn vkGetPhysicalDeviceExternalFencePropertiesKHR(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    );
}
pub type VkFenceImportFlagsKHR = VkFenceImportFlags;
pub use self::VkFenceImportFlagBits as VkFenceImportFlagBitsKHR;
pub type VkExportFenceCreateInfoKHR = VkExportFenceCreateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportFenceFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fence: VkFence,
    pub flags: VkFenceImportFlags,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
    pub fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFenceGetFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fence: VkFence,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
}
pub type PFN_vkImportFenceFdKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pImportFenceFdInfo: *const VkImportFenceFdInfoKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetFenceFdKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pGetFdInfo: *const VkFenceGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkImportFenceFdKHR(
        device: VkDevice,
        pImportFenceFdInfo: *const VkImportFenceFdInfoKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetFenceFdKHR(
        device: VkDevice,
        pGetFdInfo: *const VkFenceGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult;
}
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR:
    VkPerformanceCounterUnitKHR = 0;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR:
    VkPerformanceCounterUnitKHR = 1;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR:
    VkPerformanceCounterUnitKHR = 2;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR:
    VkPerformanceCounterUnitKHR = 3;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR:
    VkPerformanceCounterUnitKHR = 4;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR:
    VkPerformanceCounterUnitKHR = 5;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR:
    VkPerformanceCounterUnitKHR = 6;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR:
    VkPerformanceCounterUnitKHR = 7;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR:
    VkPerformanceCounterUnitKHR = 8;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR:
    VkPerformanceCounterUnitKHR = 9;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR:
    VkPerformanceCounterUnitKHR = 10;
pub const VkPerformanceCounterUnitKHR_VK_PERFORMANCE_COUNTER_UNIT_MAX_ENUM_KHR:
    VkPerformanceCounterUnitKHR = 2147483647;
pub type VkPerformanceCounterUnitKHR = ::std::os::raw::c_uint;
pub const VkPerformanceCounterScopeKHR_VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR:
    VkPerformanceCounterScopeKHR = 0;
pub const VkPerformanceCounterScopeKHR_VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR:
    VkPerformanceCounterScopeKHR = 1;
pub const VkPerformanceCounterScopeKHR_VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR:
    VkPerformanceCounterScopeKHR = 2;
pub const VkPerformanceCounterScopeKHR_VK_QUERY_SCOPE_COMMAND_BUFFER_KHR:
    VkPerformanceCounterScopeKHR = 0;
pub const VkPerformanceCounterScopeKHR_VK_QUERY_SCOPE_RENDER_PASS_KHR:
    VkPerformanceCounterScopeKHR = 1;
pub const VkPerformanceCounterScopeKHR_VK_QUERY_SCOPE_COMMAND_KHR: VkPerformanceCounterScopeKHR = 2;
pub const VkPerformanceCounterScopeKHR_VK_PERFORMANCE_COUNTER_SCOPE_MAX_ENUM_KHR:
    VkPerformanceCounterScopeKHR = 2147483647;
pub type VkPerformanceCounterScopeKHR = ::std::os::raw::c_uint;
pub const VkPerformanceCounterStorageKHR_VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR:
    VkPerformanceCounterStorageKHR = 0;
pub const VkPerformanceCounterStorageKHR_VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR:
    VkPerformanceCounterStorageKHR = 1;
pub const VkPerformanceCounterStorageKHR_VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR:
    VkPerformanceCounterStorageKHR = 2;
pub const VkPerformanceCounterStorageKHR_VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR:
    VkPerformanceCounterStorageKHR = 3;
pub const VkPerformanceCounterStorageKHR_VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR:
    VkPerformanceCounterStorageKHR = 4;
pub const VkPerformanceCounterStorageKHR_VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR:
    VkPerformanceCounterStorageKHR = 5;
pub const VkPerformanceCounterStorageKHR_VK_PERFORMANCE_COUNTER_STORAGE_MAX_ENUM_KHR:
    VkPerformanceCounterStorageKHR = 2147483647;
pub type VkPerformanceCounterStorageKHR = ::std::os::raw::c_uint;
pub const VkPerformanceCounterDescriptionFlagBitsKHR_VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 1 ;
pub const VkPerformanceCounterDescriptionFlagBitsKHR_VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 2 ;
pub const VkPerformanceCounterDescriptionFlagBitsKHR_VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 1 ;
pub const VkPerformanceCounterDescriptionFlagBitsKHR_VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 2 ;
pub const VkPerformanceCounterDescriptionFlagBitsKHR_VK_PERFORMANCE_COUNTER_DESCRIPTION_FLAG_BITS_MAX_ENUM_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 2147483647 ;
pub type VkPerformanceCounterDescriptionFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkPerformanceCounterDescriptionFlagsKHR = VkFlags;
pub const VkAcquireProfilingLockFlagBitsKHR_VK_ACQUIRE_PROFILING_LOCK_FLAG_BITS_MAX_ENUM_KHR:
    VkAcquireProfilingLockFlagBitsKHR = 2147483647;
pub type VkAcquireProfilingLockFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkAcquireProfilingLockFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePerformanceQueryFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub performanceCounterQueryPools: VkBool32,
    pub performanceCounterMultipleQueryPools: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePerformanceQueryPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub allowCommandBufferQueryCopies: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceCounterKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub unit: VkPerformanceCounterUnitKHR,
    pub scope: VkPerformanceCounterScopeKHR,
    pub storage: VkPerformanceCounterStorageKHR,
    pub uuid: [u8; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceCounterDescriptionKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPerformanceCounterDescriptionFlagsKHR,
    pub name: [::std::os::raw::c_char; 256usize],
    pub category: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPoolPerformanceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub queueFamilyIndex: u32,
    pub counterIndexCount: u32,
    pub pCounterIndices: *const u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkPerformanceCounterResultKHR {
    pub int32: i32,
    pub int64: i64,
    pub uint32: u32,
    pub uint64: u64,
    pub float32: f32,
    pub float64: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAcquireProfilingLockInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkAcquireProfilingLockFlagsKHR,
    pub timeout: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceQuerySubmitInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub counterPassIndex: u32,
}
pub type PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR =
    ::std::option::Option<
        unsafe extern "C" fn(
            physicalDevice: VkPhysicalDevice,
            queueFamilyIndex: u32,
            pCounterCount: *mut u32,
            pCounters: *mut VkPerformanceCounterKHR,
            pCounterDescriptions: *mut VkPerformanceCounterDescriptionKHR,
        ) -> VkResult,
    >;
pub type PFN_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPerformanceQueryCreateInfo: *const VkQueryPoolPerformanceCreateInfoKHR,
        pNumPasses: *mut u32,
    ),
>;
pub type PFN_vkAcquireProfilingLockKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkAcquireProfilingLockInfoKHR) -> VkResult,
>;
pub type PFN_vkReleaseProfilingLockKHR =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice)>;
extern "C" {
    pub fn vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        pCounterCount: *mut u32,
        pCounters: *mut VkPerformanceCounterKHR,
        pCounterDescriptions: *mut VkPerformanceCounterDescriptionKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(
        physicalDevice: VkPhysicalDevice,
        pPerformanceQueryCreateInfo: *const VkQueryPoolPerformanceCreateInfoKHR,
        pNumPasses: *mut u32,
    );
}
extern "C" {
    pub fn vkAcquireProfilingLockKHR(
        device: VkDevice,
        pInfo: *const VkAcquireProfilingLockInfoKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkReleaseProfilingLockKHR(device: VkDevice);
}
pub use self::VkPointClippingBehavior as VkPointClippingBehaviorKHR;
pub use self::VkTessellationDomainOrigin as VkTessellationDomainOriginKHR;
pub type VkPhysicalDevicePointClippingPropertiesKHR = VkPhysicalDevicePointClippingProperties;
pub type VkRenderPassInputAttachmentAspectCreateInfoKHR =
    VkRenderPassInputAttachmentAspectCreateInfo;
pub type VkInputAttachmentAspectReferenceKHR = VkInputAttachmentAspectReference;
pub type VkImageViewUsageCreateInfoKHR = VkImageViewUsageCreateInfo;
pub type VkPipelineTessellationDomainOriginStateCreateInfoKHR =
    VkPipelineTessellationDomainOriginStateCreateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSurfaceInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub surface: VkSurfaceKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceCapabilities2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub surfaceCapabilities: VkSurfaceCapabilitiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceFormat2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub surfaceFormat: VkSurfaceFormatKHR,
}
pub type PFN_vkGetPhysicalDeviceSurfaceCapabilities2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilities2KHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceSurfaceFormats2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut VkSurfaceFormat2KHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceSurfaceCapabilities2KHR(
        physicalDevice: VkPhysicalDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilities2KHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceSurfaceFormats2KHR(
        physicalDevice: VkPhysicalDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut VkSurfaceFormat2KHR,
    ) -> VkResult;
}
pub type VkPhysicalDeviceVariablePointerFeaturesKHR = VkPhysicalDeviceVariablePointersFeatures;
pub type VkPhysicalDeviceVariablePointersFeaturesKHR = VkPhysicalDeviceVariablePointersFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub displayProperties: VkDisplayPropertiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub displayPlaneProperties: VkDisplayPlanePropertiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub displayModeProperties: VkDisplayModePropertiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub mode: VkDisplayModeKHR,
    pub planeIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneCapabilities2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub capabilities: VkDisplayPlaneCapabilitiesKHR,
}
pub type PFN_vkGetPhysicalDeviceDisplayProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayProperties2KHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceDisplayPlaneProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPlaneProperties2KHR,
    ) -> VkResult,
>;
pub type PFN_vkGetDisplayModeProperties2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayModeProperties2KHR,
    ) -> VkResult,
>;
pub type PFN_vkGetDisplayPlaneCapabilities2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pDisplayPlaneInfo: *const VkDisplayPlaneInfo2KHR,
        pCapabilities: *mut VkDisplayPlaneCapabilities2KHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceDisplayProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayProperties2KHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceDisplayPlaneProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPlaneProperties2KHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDisplayModeProperties2KHR(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayModeProperties2KHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDisplayPlaneCapabilities2KHR(
        physicalDevice: VkPhysicalDevice,
        pDisplayPlaneInfo: *const VkDisplayPlaneInfo2KHR,
        pCapabilities: *mut VkDisplayPlaneCapabilities2KHR,
    ) -> VkResult;
}
pub type VkMemoryDedicatedRequirementsKHR = VkMemoryDedicatedRequirements;
pub type VkMemoryDedicatedAllocateInfoKHR = VkMemoryDedicatedAllocateInfo;
pub type VkBufferMemoryRequirementsInfo2KHR = VkBufferMemoryRequirementsInfo2;
pub type VkImageMemoryRequirementsInfo2KHR = VkImageMemoryRequirementsInfo2;
pub type VkImageSparseMemoryRequirementsInfo2KHR = VkImageSparseMemoryRequirementsInfo2;
pub type VkMemoryRequirements2KHR = VkMemoryRequirements2;
pub type VkSparseImageMemoryRequirements2KHR = VkSparseImageMemoryRequirements2;
pub type PFN_vkGetImageMemoryRequirements2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    ),
>;
pub type PFN_vkGetBufferMemoryRequirements2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    ),
>;
pub type PFN_vkGetImageSparseMemoryRequirements2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    ),
>;
extern "C" {
    pub fn vkGetImageMemoryRequirements2KHR(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetBufferMemoryRequirements2KHR(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetImageSparseMemoryRequirements2KHR(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    );
}
pub type VkImageFormatListCreateInfoKHR = VkImageFormatListCreateInfo;
pub type VkSamplerYcbcrConversionKHR = VkSamplerYcbcrConversion;
pub use self::VkChromaLocation as VkChromaLocationKHR;
pub use self::VkSamplerYcbcrModelConversion as VkSamplerYcbcrModelConversionKHR;
pub use self::VkSamplerYcbcrRange as VkSamplerYcbcrRangeKHR;
pub type VkSamplerYcbcrConversionCreateInfoKHR = VkSamplerYcbcrConversionCreateInfo;
pub type VkSamplerYcbcrConversionInfoKHR = VkSamplerYcbcrConversionInfo;
pub type VkBindImagePlaneMemoryInfoKHR = VkBindImagePlaneMemoryInfo;
pub type VkImagePlaneMemoryRequirementsInfoKHR = VkImagePlaneMemoryRequirementsInfo;
pub type VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR =
    VkPhysicalDeviceSamplerYcbcrConversionFeatures;
pub type VkSamplerYcbcrConversionImageFormatPropertiesKHR =
    VkSamplerYcbcrConversionImageFormatProperties;
pub type PFN_vkCreateSamplerYcbcrConversionKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult,
>;
pub type PFN_vkDestroySamplerYcbcrConversionKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
extern "C" {
    pub fn vkCreateSamplerYcbcrConversionKHR(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySamplerYcbcrConversionKHR(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    );
}
pub type VkBindBufferMemoryInfoKHR = VkBindBufferMemoryInfo;
pub type VkBindImageMemoryInfoKHR = VkBindImageMemoryInfo;
pub type PFN_vkBindBufferMemory2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult,
>;
pub type PFN_vkBindImageMemory2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkBindBufferMemory2KHR(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkBindImageMemory2KHR(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult;
}
pub type VkPhysicalDeviceMaintenance3PropertiesKHR = VkPhysicalDeviceMaintenance3Properties;
pub type VkDescriptorSetLayoutSupportKHR = VkDescriptorSetLayoutSupport;
pub type PFN_vkGetDescriptorSetLayoutSupportKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    ),
>;
extern "C" {
    pub fn vkGetDescriptorSetLayoutSupportKHR(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    );
}
pub type PFN_vkCmdDrawIndirectCountKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDrawIndexedIndirectCountKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ),
>;
extern "C" {
    pub fn vkCmdDrawIndirectCountKHR(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndexedIndirectCountKHR(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    );
}
pub type VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR =
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures;
pub type VkPhysicalDevice8BitStorageFeaturesKHR = VkPhysicalDevice8BitStorageFeatures;
pub type VkPhysicalDeviceShaderAtomicInt64FeaturesKHR = VkPhysicalDeviceShaderAtomicInt64Features;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderClockFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSubgroupClock: VkBool32,
    pub shaderDeviceClock: VkBool32,
}
pub use self::VkDriverId as VkDriverIdKHR;
pub type VkConformanceVersionKHR = VkConformanceVersion;
pub type VkPhysicalDeviceDriverPropertiesKHR = VkPhysicalDeviceDriverProperties;
pub use self::VkShaderFloatControlsIndependence as VkShaderFloatControlsIndependenceKHR;
pub type VkPhysicalDeviceFloatControlsPropertiesKHR = VkPhysicalDeviceFloatControlsProperties;
pub use self::VkResolveModeFlagBits as VkResolveModeFlagBitsKHR;
pub type VkResolveModeFlagsKHR = VkResolveModeFlags;
pub type VkSubpassDescriptionDepthStencilResolveKHR = VkSubpassDescriptionDepthStencilResolve;
pub type VkPhysicalDeviceDepthStencilResolvePropertiesKHR =
    VkPhysicalDeviceDepthStencilResolveProperties;
pub use self::VkSemaphoreType as VkSemaphoreTypeKHR;
pub use self::VkSemaphoreWaitFlagBits as VkSemaphoreWaitFlagBitsKHR;
pub type VkSemaphoreWaitFlagsKHR = VkSemaphoreWaitFlags;
pub type VkPhysicalDeviceTimelineSemaphoreFeaturesKHR = VkPhysicalDeviceTimelineSemaphoreFeatures;
pub type VkPhysicalDeviceTimelineSemaphorePropertiesKHR =
    VkPhysicalDeviceTimelineSemaphoreProperties;
pub type VkSemaphoreTypeCreateInfoKHR = VkSemaphoreTypeCreateInfo;
pub type VkTimelineSemaphoreSubmitInfoKHR = VkTimelineSemaphoreSubmitInfo;
pub type VkSemaphoreWaitInfoKHR = VkSemaphoreWaitInfo;
pub type VkSemaphoreSignalInfoKHR = VkSemaphoreSignalInfo;
pub type PFN_vkGetSemaphoreCounterValueKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, semaphore: VkSemaphore, pValue: *mut u64) -> VkResult,
>;
pub type PFN_vkWaitSemaphoresKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pWaitInfo: *const VkSemaphoreWaitInfo,
        timeout: u64,
    ) -> VkResult,
>;
pub type PFN_vkSignalSemaphoreKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pSignalInfo: *const VkSemaphoreSignalInfo) -> VkResult,
>;
extern "C" {
    pub fn vkGetSemaphoreCounterValueKHR(
        device: VkDevice,
        semaphore: VkSemaphore,
        pValue: *mut u64,
    ) -> VkResult;
}
extern "C" {
    pub fn vkWaitSemaphoresKHR(
        device: VkDevice,
        pWaitInfo: *const VkSemaphoreWaitInfo,
        timeout: u64,
    ) -> VkResult;
}
extern "C" {
    pub fn vkSignalSemaphoreKHR(
        device: VkDevice,
        pSignalInfo: *const VkSemaphoreSignalInfo,
    ) -> VkResult;
}
pub type VkPhysicalDeviceVulkanMemoryModelFeaturesKHR = VkPhysicalDeviceVulkanMemoryModelFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderTerminateInvocation: VkBool32,
}
pub const VkFragmentShadingRateCombinerOpKHR_VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR:
    VkFragmentShadingRateCombinerOpKHR = 0;
pub const VkFragmentShadingRateCombinerOpKHR_VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR:
    VkFragmentShadingRateCombinerOpKHR = 1;
pub const VkFragmentShadingRateCombinerOpKHR_VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR:
    VkFragmentShadingRateCombinerOpKHR = 2;
pub const VkFragmentShadingRateCombinerOpKHR_VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR:
    VkFragmentShadingRateCombinerOpKHR = 3;
pub const VkFragmentShadingRateCombinerOpKHR_VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR:
    VkFragmentShadingRateCombinerOpKHR = 4;
pub const VkFragmentShadingRateCombinerOpKHR_VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_ENUM_KHR:
    VkFragmentShadingRateCombinerOpKHR = 2147483647;
pub type VkFragmentShadingRateCombinerOpKHR = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFragmentShadingRateAttachmentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pFragmentShadingRateAttachment: *const VkAttachmentReference2,
    pub shadingRateAttachmentTexelSize: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineFragmentShadingRateStateCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fragmentSize: VkExtent2D,
    pub combinerOps: [VkFragmentShadingRateCombinerOpKHR; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pipelineFragmentShadingRate: VkBool32,
    pub primitiveFragmentShadingRate: VkBool32,
    pub attachmentFragmentShadingRate: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minFragmentShadingRateAttachmentTexelSize: VkExtent2D,
    pub maxFragmentShadingRateAttachmentTexelSize: VkExtent2D,
    pub maxFragmentShadingRateAttachmentTexelSizeAspectRatio: u32,
    pub primitiveFragmentShadingRateWithMultipleViewports: VkBool32,
    pub layeredShadingRateAttachments: VkBool32,
    pub fragmentShadingRateNonTrivialCombinerOps: VkBool32,
    pub maxFragmentSize: VkExtent2D,
    pub maxFragmentSizeAspectRatio: u32,
    pub maxFragmentShadingRateCoverageSamples: u32,
    pub maxFragmentShadingRateRasterizationSamples: VkSampleCountFlagBits,
    pub fragmentShadingRateWithShaderDepthStencilWrites: VkBool32,
    pub fragmentShadingRateWithSampleMask: VkBool32,
    pub fragmentShadingRateWithShaderSampleMask: VkBool32,
    pub fragmentShadingRateWithConservativeRasterization: VkBool32,
    pub fragmentShadingRateWithFragmentShaderInterlock: VkBool32,
    pub fragmentShadingRateWithCustomSampleLocations: VkBool32,
    pub fragmentShadingRateStrictMultiplyCombiner: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub sampleCounts: VkSampleCountFlags,
    pub fragmentSize: VkExtent2D,
}
pub type PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFragmentShadingRateCount: *mut u32,
        pFragmentShadingRates: *mut VkPhysicalDeviceFragmentShadingRateKHR,
    ) -> VkResult,
>;
pub type PFN_vkCmdSetFragmentShadingRateKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pFragmentSize: *const VkExtent2D,
        combinerOps: *const VkFragmentShadingRateCombinerOpKHR,
    ),
>;
extern "C" {
    pub fn vkGetPhysicalDeviceFragmentShadingRatesKHR(
        physicalDevice: VkPhysicalDevice,
        pFragmentShadingRateCount: *mut u32,
        pFragmentShadingRates: *mut VkPhysicalDeviceFragmentShadingRateKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdSetFragmentShadingRateKHR(
        commandBuffer: VkCommandBuffer,
        pFragmentSize: *const VkExtent2D,
        combinerOps: *const VkFragmentShadingRateCombinerOpKHR,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceProtectedCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub supportsProtected: VkBool32,
}
pub type VkPhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR =
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures;
pub type VkAttachmentReferenceStencilLayoutKHR = VkAttachmentReferenceStencilLayout;
pub type VkAttachmentDescriptionStencilLayoutKHR = VkAttachmentDescriptionStencilLayout;
pub type VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR =
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures;
pub type VkPhysicalDeviceBufferDeviceAddressFeaturesKHR =
    VkPhysicalDeviceBufferDeviceAddressFeatures;
pub type VkBufferDeviceAddressInfoKHR = VkBufferDeviceAddressInfo;
pub type VkBufferOpaqueCaptureAddressCreateInfoKHR = VkBufferOpaqueCaptureAddressCreateInfo;
pub type VkMemoryOpaqueCaptureAddressAllocateInfoKHR = VkMemoryOpaqueCaptureAddressAllocateInfo;
pub type VkDeviceMemoryOpaqueCaptureAddressInfoKHR = VkDeviceMemoryOpaqueCaptureAddressInfo;
pub type PFN_vkGetBufferDeviceAddressKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress,
>;
pub type PFN_vkGetBufferOpaqueCaptureAddressKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkBufferDeviceAddressInfo) -> u64,
>;
pub type PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64,
>;
extern "C" {
    pub fn vkGetBufferDeviceAddressKHR(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress;
}
extern "C" {
    pub fn vkGetBufferOpaqueCaptureAddressKHR(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> u64;
}
extern "C" {
    pub fn vkGetDeviceMemoryOpaqueCaptureAddressKHR(
        device: VkDevice,
        pInfo: *const VkDeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeferredOperationKHR_T {
    _unused: [u8; 0],
}
pub type VkDeferredOperationKHR = *mut VkDeferredOperationKHR_T;
pub type PFN_vkCreateDeferredOperationKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocator: *const VkAllocationCallbacks,
        pDeferredOperation: *mut VkDeferredOperationKHR,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDeferredOperationKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        operation: VkDeferredOperationKHR,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetDeferredOperationMaxConcurrencyKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, operation: VkDeferredOperationKHR) -> u32,
>;
pub type PFN_vkGetDeferredOperationResultKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, operation: VkDeferredOperationKHR) -> VkResult,
>;
pub type PFN_vkDeferredOperationJoinKHR = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, operation: VkDeferredOperationKHR) -> VkResult,
>;
extern "C" {
    pub fn vkCreateDeferredOperationKHR(
        device: VkDevice,
        pAllocator: *const VkAllocationCallbacks,
        pDeferredOperation: *mut VkDeferredOperationKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDeferredOperationKHR(
        device: VkDevice,
        operation: VkDeferredOperationKHR,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetDeferredOperationMaxConcurrencyKHR(
        device: VkDevice,
        operation: VkDeferredOperationKHR,
    ) -> u32;
}
extern "C" {
    pub fn vkGetDeferredOperationResultKHR(
        device: VkDevice,
        operation: VkDeferredOperationKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDeferredOperationJoinKHR(
        device: VkDevice,
        operation: VkDeferredOperationKHR,
    ) -> VkResult;
}
pub const VkPipelineExecutableStatisticFormatKHR_VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR : VkPipelineExecutableStatisticFormatKHR = 0 ;
pub const VkPipelineExecutableStatisticFormatKHR_VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR : VkPipelineExecutableStatisticFormatKHR = 1 ;
pub const VkPipelineExecutableStatisticFormatKHR_VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR : VkPipelineExecutableStatisticFormatKHR = 2 ;
pub const VkPipelineExecutableStatisticFormatKHR_VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR : VkPipelineExecutableStatisticFormatKHR = 3 ;
pub const VkPipelineExecutableStatisticFormatKHR_VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_MAX_ENUM_KHR : VkPipelineExecutableStatisticFormatKHR = 2147483647 ;
pub type VkPipelineExecutableStatisticFormatKHR = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pipelineExecutableInfo: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipeline: VkPipeline,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineExecutablePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stages: VkShaderStageFlags,
    pub name: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
    pub subgroupSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineExecutableInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipeline: VkPipeline,
    pub executableIndex: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkPipelineExecutableStatisticValueKHR {
    pub b32: VkBool32,
    pub i64_: i64,
    pub u64_: u64,
    pub f64_: f64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPipelineExecutableStatisticKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub name: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
    pub format: VkPipelineExecutableStatisticFormatKHR,
    pub value: VkPipelineExecutableStatisticValueKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineExecutableInternalRepresentationKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub name: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
    pub isText: VkBool32,
    pub dataSize: size_t,
    pub pData: *mut ::std::os::raw::c_void,
}
pub type PFN_vkGetPipelineExecutablePropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pPipelineInfo: *const VkPipelineInfoKHR,
        pExecutableCount: *mut u32,
        pProperties: *mut VkPipelineExecutablePropertiesKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPipelineExecutableStatisticsKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pExecutableInfo: *const VkPipelineExecutableInfoKHR,
        pStatisticCount: *mut u32,
        pStatistics: *mut VkPipelineExecutableStatisticKHR,
    ) -> VkResult,
>;
pub type PFN_vkGetPipelineExecutableInternalRepresentationsKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pExecutableInfo: *const VkPipelineExecutableInfoKHR,
        pInternalRepresentationCount: *mut u32,
        pInternalRepresentations: *mut VkPipelineExecutableInternalRepresentationKHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPipelineExecutablePropertiesKHR(
        device: VkDevice,
        pPipelineInfo: *const VkPipelineInfoKHR,
        pExecutableCount: *mut u32,
        pProperties: *mut VkPipelineExecutablePropertiesKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPipelineExecutableStatisticsKHR(
        device: VkDevice,
        pExecutableInfo: *const VkPipelineExecutableInfoKHR,
        pStatisticCount: *mut u32,
        pStatistics: *mut VkPipelineExecutableStatisticKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPipelineExecutableInternalRepresentationsKHR(
        device: VkDevice,
        pExecutableInfo: *const VkPipelineExecutableInfoKHR,
        pInternalRepresentationCount: *mut u32,
        pInternalRepresentations: *mut VkPipelineExecutableInternalRepresentationKHR,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLibraryCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub libraryCount: u32,
    pub pLibraries: *const VkPipeline,
}
pub type VkFlags64 = u64;
pub type VkPipelineStageFlags2KHR = VkFlags64;
pub const VK_PIPELINE_STAGE_2_NONE_KHR: VkPipelineStageFlags2KHR = 0;
pub const VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT_KHR: VkPipelineStageFlags2KHR = 1;
pub const VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR: VkPipelineStageFlags2KHR = 2;
pub const VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR: VkPipelineStageFlags2KHR = 4;
pub const VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT_KHR: VkPipelineStageFlags2KHR = 8;
pub const VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR: VkPipelineStageFlags2KHR = 16;
pub const VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR: VkPipelineStageFlags2KHR = 32;
pub const VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR: VkPipelineStageFlags2KHR = 64;
pub const VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR: VkPipelineStageFlags2KHR = 128;
pub const VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR: VkPipelineStageFlags2KHR = 256;
pub const VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR: VkPipelineStageFlags2KHR = 512;
pub const VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR: VkPipelineStageFlags2KHR = 1024;
pub const VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT_KHR: VkPipelineStageFlags2KHR = 2048;
pub const VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR: VkPipelineStageFlags2KHR = 4096;
pub const VK_PIPELINE_STAGE_2_TRANSFER_BIT_KHR: VkPipelineStageFlags2KHR = 4096;
pub const VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT_KHR: VkPipelineStageFlags2KHR = 8192;
pub const VK_PIPELINE_STAGE_2_HOST_BIT_KHR: VkPipelineStageFlags2KHR = 16384;
pub const VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR: VkPipelineStageFlags2KHR = 32768;
pub const VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR: VkPipelineStageFlags2KHR = 65536;
pub const VK_PIPELINE_STAGE_2_COPY_BIT_KHR: VkPipelineStageFlags2KHR = 4294967296;
pub const VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR: VkPipelineStageFlags2KHR = 8589934592;
pub const VK_PIPELINE_STAGE_2_BLIT_BIT_KHR: VkPipelineStageFlags2KHR = 17179869184;
pub const VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR: VkPipelineStageFlags2KHR = 34359738368;
pub const VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR: VkPipelineStageFlags2KHR = 68719476736;
pub const VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR: VkPipelineStageFlags2KHR =
    137438953472;
pub const VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT_KHR: VkPipelineStageFlags2KHR =
    274877906944;
pub const VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT: VkPipelineStageFlags2KHR = 16777216;
pub const VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT: VkPipelineStageFlags2KHR = 262144;
pub const VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV: VkPipelineStageFlags2KHR = 131072;
pub const VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: VkPipelineStageFlags2KHR =
    4194304;
pub const VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV: VkPipelineStageFlags2KHR = 4194304;
pub const VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR: VkPipelineStageFlags2KHR =
    33554432;
pub const VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR: VkPipelineStageFlags2KHR = 2097152;
pub const VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_NV: VkPipelineStageFlags2KHR = 2097152;
pub const VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_NV: VkPipelineStageFlags2KHR =
    33554432;
pub const VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT: VkPipelineStageFlags2KHR = 8388608;
pub const VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV: VkPipelineStageFlags2KHR = 524288;
pub const VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV: VkPipelineStageFlags2KHR = 1048576;
pub type VkAccessFlags2KHR = VkFlags64;
pub const VK_ACCESS_2_NONE_KHR: VkAccessFlags2KHR = 0;
pub const VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR: VkAccessFlags2KHR = 1;
pub const VK_ACCESS_2_INDEX_READ_BIT_KHR: VkAccessFlags2KHR = 2;
pub const VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR: VkAccessFlags2KHR = 4;
pub const VK_ACCESS_2_UNIFORM_READ_BIT_KHR: VkAccessFlags2KHR = 8;
pub const VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR: VkAccessFlags2KHR = 16;
pub const VK_ACCESS_2_SHADER_READ_BIT_KHR: VkAccessFlags2KHR = 32;
pub const VK_ACCESS_2_SHADER_WRITE_BIT_KHR: VkAccessFlags2KHR = 64;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR: VkAccessFlags2KHR = 128;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR: VkAccessFlags2KHR = 256;
pub const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR: VkAccessFlags2KHR = 512;
pub const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR: VkAccessFlags2KHR = 1024;
pub const VK_ACCESS_2_TRANSFER_READ_BIT_KHR: VkAccessFlags2KHR = 2048;
pub const VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR: VkAccessFlags2KHR = 4096;
pub const VK_ACCESS_2_HOST_READ_BIT_KHR: VkAccessFlags2KHR = 8192;
pub const VK_ACCESS_2_HOST_WRITE_BIT_KHR: VkAccessFlags2KHR = 16384;
pub const VK_ACCESS_2_MEMORY_READ_BIT_KHR: VkAccessFlags2KHR = 32768;
pub const VK_ACCESS_2_MEMORY_WRITE_BIT_KHR: VkAccessFlags2KHR = 65536;
pub const VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR: VkAccessFlags2KHR = 4294967296;
pub const VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR: VkAccessFlags2KHR = 8589934592;
pub const VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR: VkAccessFlags2KHR = 17179869184;
pub const VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT: VkAccessFlags2KHR = 33554432;
pub const VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT: VkAccessFlags2KHR = 67108864;
pub const VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT: VkAccessFlags2KHR = 134217728;
pub const VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT: VkAccessFlags2KHR = 1048576;
pub const VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV: VkAccessFlags2KHR = 131072;
pub const VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV: VkAccessFlags2KHR = 262144;
pub const VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR: VkAccessFlags2KHR = 8388608;
pub const VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV: VkAccessFlags2KHR = 8388608;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR: VkAccessFlags2KHR = 2097152;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR: VkAccessFlags2KHR = 4194304;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_NV: VkAccessFlags2KHR = 2097152;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_NV: VkAccessFlags2KHR = 4194304;
pub const VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT: VkAccessFlags2KHR = 16777216;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT: VkAccessFlags2KHR = 524288;
pub const VkSubmitFlagBitsKHR_VK_SUBMIT_PROTECTED_BIT_KHR: VkSubmitFlagBitsKHR = 1;
pub const VkSubmitFlagBitsKHR_VK_SUBMIT_FLAG_BITS_MAX_ENUM_KHR: VkSubmitFlagBitsKHR = 2147483647;
pub type VkSubmitFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkSubmitFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryBarrier2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcStageMask: VkPipelineStageFlags2KHR,
    pub srcAccessMask: VkAccessFlags2KHR,
    pub dstStageMask: VkPipelineStageFlags2KHR,
    pub dstAccessMask: VkAccessFlags2KHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryBarrier2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcStageMask: VkPipelineStageFlags2KHR,
    pub srcAccessMask: VkAccessFlags2KHR,
    pub dstStageMask: VkPipelineStageFlags2KHR,
    pub dstAccessMask: VkAccessFlags2KHR,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryBarrier2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcStageMask: VkPipelineStageFlags2KHR,
    pub srcAccessMask: VkAccessFlags2KHR,
    pub dstStageMask: VkPipelineStageFlags2KHR,
    pub dstAccessMask: VkAccessFlags2KHR,
    pub oldLayout: VkImageLayout,
    pub newLayout: VkImageLayout,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub image: VkImage,
    pub subresourceRange: VkImageSubresourceRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDependencyInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dependencyFlags: VkDependencyFlags,
    pub memoryBarrierCount: u32,
    pub pMemoryBarriers: *const VkMemoryBarrier2KHR,
    pub bufferMemoryBarrierCount: u32,
    pub pBufferMemoryBarriers: *const VkBufferMemoryBarrier2KHR,
    pub imageMemoryBarrierCount: u32,
    pub pImageMemoryBarriers: *const VkImageMemoryBarrier2KHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreSubmitInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub value: u64,
    pub stageMask: VkPipelineStageFlags2KHR,
    pub deviceIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferSubmitInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub commandBuffer: VkCommandBuffer,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubmitInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSubmitFlagsKHR,
    pub waitSemaphoreInfoCount: u32,
    pub pWaitSemaphoreInfos: *const VkSemaphoreSubmitInfoKHR,
    pub commandBufferInfoCount: u32,
    pub pCommandBufferInfos: *const VkCommandBufferSubmitInfoKHR,
    pub signalSemaphoreInfoCount: u32,
    pub pSignalSemaphoreInfos: *const VkSemaphoreSubmitInfoKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSynchronization2FeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub synchronization2: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyCheckpointProperties2NV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub checkpointExecutionStageMask: VkPipelineStageFlags2KHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCheckpointData2NV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stage: VkPipelineStageFlags2KHR,
    pub pCheckpointMarker: *mut ::std::os::raw::c_void,
}
pub type PFN_vkCmdSetEvent2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        pDependencyInfo: *const VkDependencyInfoKHR,
    ),
>;
pub type PFN_vkCmdResetEvent2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags2KHR,
    ),
>;
pub type PFN_vkCmdWaitEvents2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        pDependencyInfos: *const VkDependencyInfoKHR,
    ),
>;
pub type PFN_vkCmdPipelineBarrier2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pDependencyInfo: *const VkDependencyInfoKHR,
    ),
>;
pub type PFN_vkCmdWriteTimestamp2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        stage: VkPipelineStageFlags2KHR,
        queryPool: VkQueryPool,
        query: u32,
    ),
>;
pub type PFN_vkQueueSubmit2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo2KHR,
        fence: VkFence,
    ) -> VkResult,
>;
pub type PFN_vkCmdWriteBufferMarker2AMD = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        stage: VkPipelineStageFlags2KHR,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        marker: u32,
    ),
>;
pub type PFN_vkGetQueueCheckpointData2NV = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut VkCheckpointData2NV,
    ),
>;
extern "C" {
    pub fn vkCmdSetEvent2KHR(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        pDependencyInfo: *const VkDependencyInfoKHR,
    );
}
extern "C" {
    pub fn vkCmdResetEvent2KHR(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags2KHR,
    );
}
extern "C" {
    pub fn vkCmdWaitEvents2KHR(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        pDependencyInfos: *const VkDependencyInfoKHR,
    );
}
extern "C" {
    pub fn vkCmdPipelineBarrier2KHR(
        commandBuffer: VkCommandBuffer,
        pDependencyInfo: *const VkDependencyInfoKHR,
    );
}
extern "C" {
    pub fn vkCmdWriteTimestamp2KHR(
        commandBuffer: VkCommandBuffer,
        stage: VkPipelineStageFlags2KHR,
        queryPool: VkQueryPool,
        query: u32,
    );
}
extern "C" {
    pub fn vkQueueSubmit2KHR(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo2KHR,
        fence: VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdWriteBufferMarker2AMD(
        commandBuffer: VkCommandBuffer,
        stage: VkPipelineStageFlags2KHR,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        marker: u32,
    );
}
extern "C" {
    pub fn vkGetQueueCheckpointData2NV(
        queue: VkQueue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut VkCheckpointData2NV,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderZeroInitializeWorkgroupMemory: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub workgroupMemoryExplicitLayout: VkBool32,
    pub workgroupMemoryExplicitLayoutScalarBlockLayout: VkBool32,
    pub workgroupMemoryExplicitLayout8BitAccess: VkBool32,
    pub workgroupMemoryExplicitLayout16BitAccess: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCopy2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcOffset: VkDeviceSize,
    pub dstOffset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyBufferInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcBuffer: VkBuffer,
    pub dstBuffer: VkBuffer,
    pub regionCount: u32,
    pub pRegions: *const VkBufferCopy2KHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCopy2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyImageInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkImageCopy2KHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferImageCopy2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub bufferOffset: VkDeviceSize,
    pub bufferRowLength: u32,
    pub bufferImageHeight: u32,
    pub imageSubresource: VkImageSubresourceLayers,
    pub imageOffset: VkOffset3D,
    pub imageExtent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyBufferToImageInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcBuffer: VkBuffer,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkBufferImageCopy2KHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyImageToBufferInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstBuffer: VkBuffer,
    pub regionCount: u32,
    pub pRegions: *const VkBufferImageCopy2KHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageBlit2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffsets: [VkOffset3D; 2usize],
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffsets: [VkOffset3D; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBlitImageInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkImageBlit2KHR,
    pub filter: VkFilter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageResolve2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkResolveImageInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkImageResolve2KHR,
}
pub type PFN_vkCmdCopyBuffer2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyBufferInfo: *const VkCopyBufferInfo2KHR,
    ),
>;
pub type PFN_vkCmdCopyImage2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyImageInfo: *const VkCopyImageInfo2KHR,
    ),
>;
pub type PFN_vkCmdCopyBufferToImage2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyBufferToImageInfo: *const VkCopyBufferToImageInfo2KHR,
    ),
>;
pub type PFN_vkCmdCopyImageToBuffer2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyImageToBufferInfo: *const VkCopyImageToBufferInfo2KHR,
    ),
>;
pub type PFN_vkCmdBlitImage2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pBlitImageInfo: *const VkBlitImageInfo2KHR,
    ),
>;
pub type PFN_vkCmdResolveImage2KHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pResolveImageInfo: *const VkResolveImageInfo2KHR,
    ),
>;
extern "C" {
    pub fn vkCmdCopyBuffer2KHR(
        commandBuffer: VkCommandBuffer,
        pCopyBufferInfo: *const VkCopyBufferInfo2KHR,
    );
}
extern "C" {
    pub fn vkCmdCopyImage2KHR(
        commandBuffer: VkCommandBuffer,
        pCopyImageInfo: *const VkCopyImageInfo2KHR,
    );
}
extern "C" {
    pub fn vkCmdCopyBufferToImage2KHR(
        commandBuffer: VkCommandBuffer,
        pCopyBufferToImageInfo: *const VkCopyBufferToImageInfo2KHR,
    );
}
extern "C" {
    pub fn vkCmdCopyImageToBuffer2KHR(
        commandBuffer: VkCommandBuffer,
        pCopyImageToBufferInfo: *const VkCopyImageToBufferInfo2KHR,
    );
}
extern "C" {
    pub fn vkCmdBlitImage2KHR(
        commandBuffer: VkCommandBuffer,
        pBlitImageInfo: *const VkBlitImageInfo2KHR,
    );
}
extern "C" {
    pub fn vkCmdResolveImage2KHR(
        commandBuffer: VkCommandBuffer,
        pResolveImageInfo: *const VkResolveImageInfo2KHR,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugReportCallbackEXT_T {
    _unused: [u8; 0],
}
pub type VkDebugReportCallbackEXT = *mut VkDebugReportCallbackEXT_T;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT:
    VkDebugReportObjectTypeEXT = 0;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT:
    VkDebugReportObjectTypeEXT = 1;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT:
    VkDebugReportObjectTypeEXT = 2;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT:
    VkDebugReportObjectTypeEXT = 3;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT:
    VkDebugReportObjectTypeEXT = 4;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT:
    VkDebugReportObjectTypeEXT = 5;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT:
    VkDebugReportObjectTypeEXT = 6;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT:
    VkDebugReportObjectTypeEXT = 7;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT:
    VkDebugReportObjectTypeEXT = 8;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT:
    VkDebugReportObjectTypeEXT = 9;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT:
    VkDebugReportObjectTypeEXT = 10;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT:
    VkDebugReportObjectTypeEXT = 11;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT:
    VkDebugReportObjectTypeEXT = 12;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT:
    VkDebugReportObjectTypeEXT = 13;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT:
    VkDebugReportObjectTypeEXT = 14;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT:
    VkDebugReportObjectTypeEXT = 15;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT:
    VkDebugReportObjectTypeEXT = 16;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT:
    VkDebugReportObjectTypeEXT = 17;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT:
    VkDebugReportObjectTypeEXT = 18;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT:
    VkDebugReportObjectTypeEXT = 19;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT:
    VkDebugReportObjectTypeEXT = 20;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT:
    VkDebugReportObjectTypeEXT = 21;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT:
    VkDebugReportObjectTypeEXT = 22;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT:
    VkDebugReportObjectTypeEXT = 23;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT:
    VkDebugReportObjectTypeEXT = 24;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT:
    VkDebugReportObjectTypeEXT = 25;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT:
    VkDebugReportObjectTypeEXT = 26;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT:
    VkDebugReportObjectTypeEXT = 27;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT:
    VkDebugReportObjectTypeEXT = 28;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT:
    VkDebugReportObjectTypeEXT = 29;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT:
    VkDebugReportObjectTypeEXT = 30;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT:
    VkDebugReportObjectTypeEXT = 33;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT:
    VkDebugReportObjectTypeEXT = 1000156000;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT:
    VkDebugReportObjectTypeEXT = 1000085000;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT:
    VkDebugReportObjectTypeEXT = 1000150000;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT:
    VkDebugReportObjectTypeEXT = 1000165000;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_EXT:
    VkDebugReportObjectTypeEXT = 28;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT:
    VkDebugReportObjectTypeEXT = 33;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR_EXT : VkDebugReportObjectTypeEXT = 1000085000 ;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR_EXT : VkDebugReportObjectTypeEXT = 1000156000 ;
pub const VkDebugReportObjectTypeEXT_VK_DEBUG_REPORT_OBJECT_TYPE_MAX_ENUM_EXT:
    VkDebugReportObjectTypeEXT = 2147483647;
pub type VkDebugReportObjectTypeEXT = ::std::os::raw::c_uint;
pub const VkDebugReportFlagBitsEXT_VK_DEBUG_REPORT_INFORMATION_BIT_EXT: VkDebugReportFlagBitsEXT =
    1;
pub const VkDebugReportFlagBitsEXT_VK_DEBUG_REPORT_WARNING_BIT_EXT: VkDebugReportFlagBitsEXT = 2;
pub const VkDebugReportFlagBitsEXT_VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT:
    VkDebugReportFlagBitsEXT = 4;
pub const VkDebugReportFlagBitsEXT_VK_DEBUG_REPORT_ERROR_BIT_EXT: VkDebugReportFlagBitsEXT = 8;
pub const VkDebugReportFlagBitsEXT_VK_DEBUG_REPORT_DEBUG_BIT_EXT: VkDebugReportFlagBitsEXT = 16;
pub const VkDebugReportFlagBitsEXT_VK_DEBUG_REPORT_FLAG_BITS_MAX_ENUM_EXT:
    VkDebugReportFlagBitsEXT = 2147483647;
pub type VkDebugReportFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkDebugReportFlagsEXT = VkFlags;
pub type PFN_vkDebugReportCallbackEXT = ::std::option::Option<
    unsafe extern "C" fn(
        flags: VkDebugReportFlagsEXT,
        objectType: VkDebugReportObjectTypeEXT,
        object: u64,
        location: size_t,
        messageCode: i32,
        pLayerPrefix: *const ::std::os::raw::c_char,
        pMessage: *const ::std::os::raw::c_char,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> VkBool32,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugReportCallbackCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDebugReportFlagsEXT,
    pub pfnCallback: PFN_vkDebugReportCallbackEXT,
    pub pUserData: *mut ::std::os::raw::c_void,
}
pub type PFN_vkCreateDebugReportCallbackEXT = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkDebugReportCallbackCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pCallback: *mut VkDebugReportCallbackEXT,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDebugReportCallbackEXT = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        callback: VkDebugReportCallbackEXT,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkDebugReportMessageEXT = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        flags: VkDebugReportFlagsEXT,
        objectType: VkDebugReportObjectTypeEXT,
        object: u64,
        location: size_t,
        messageCode: i32,
        pLayerPrefix: *const ::std::os::raw::c_char,
        pMessage: *const ::std::os::raw::c_char,
    ),
>;
extern "C" {
    pub fn vkCreateDebugReportCallbackEXT(
        instance: VkInstance,
        pCreateInfo: *const VkDebugReportCallbackCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pCallback: *mut VkDebugReportCallbackEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDebugReportCallbackEXT(
        instance: VkInstance,
        callback: VkDebugReportCallbackEXT,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkDebugReportMessageEXT(
        instance: VkInstance,
        flags: VkDebugReportFlagsEXT,
        objectType: VkDebugReportObjectTypeEXT,
        object: u64,
        location: size_t,
        messageCode: i32,
        pLayerPrefix: *const ::std::os::raw::c_char,
        pMessage: *const ::std::os::raw::c_char,
    );
}
pub const VkRasterizationOrderAMD_VK_RASTERIZATION_ORDER_STRICT_AMD: VkRasterizationOrderAMD = 0;
pub const VkRasterizationOrderAMD_VK_RASTERIZATION_ORDER_RELAXED_AMD: VkRasterizationOrderAMD = 1;
pub const VkRasterizationOrderAMD_VK_RASTERIZATION_ORDER_MAX_ENUM_AMD: VkRasterizationOrderAMD =
    2147483647;
pub type VkRasterizationOrderAMD = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationStateRasterizationOrderAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub rasterizationOrder: VkRasterizationOrderAMD,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugMarkerObjectNameInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkDebugReportObjectTypeEXT,
    pub object: u64,
    pub pObjectName: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugMarkerObjectTagInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkDebugReportObjectTypeEXT,
    pub object: u64,
    pub tagName: u64,
    pub tagSize: size_t,
    pub pTag: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugMarkerMarkerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pMarkerName: *const ::std::os::raw::c_char,
    pub color: [f32; 4usize],
}
pub type PFN_vkDebugMarkerSetObjectTagEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pTagInfo: *const VkDebugMarkerObjectTagInfoEXT,
    ) -> VkResult,
>;
pub type PFN_vkDebugMarkerSetObjectNameEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pNameInfo: *const VkDebugMarkerObjectNameInfoEXT,
    ) -> VkResult,
>;
pub type PFN_vkCmdDebugMarkerBeginEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkDebugMarkerMarkerInfoEXT,
    ),
>;
pub type PFN_vkCmdDebugMarkerEndEXT =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer)>;
pub type PFN_vkCmdDebugMarkerInsertEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkDebugMarkerMarkerInfoEXT,
    ),
>;
extern "C" {
    pub fn vkDebugMarkerSetObjectTagEXT(
        device: VkDevice,
        pTagInfo: *const VkDebugMarkerObjectTagInfoEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDebugMarkerSetObjectNameEXT(
        device: VkDevice,
        pNameInfo: *const VkDebugMarkerObjectNameInfoEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdDebugMarkerBeginEXT(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkDebugMarkerMarkerInfoEXT,
    );
}
extern "C" {
    pub fn vkCmdDebugMarkerEndEXT(commandBuffer: VkCommandBuffer);
}
extern "C" {
    pub fn vkCmdDebugMarkerInsertEXT(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkDebugMarkerMarkerInfoEXT,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDedicatedAllocationImageCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dedicatedAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDedicatedAllocationBufferCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dedicatedAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDedicatedAllocationMemoryAllocateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub buffer: VkBuffer,
}
pub type VkPipelineRasterizationStateStreamCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTransformFeedbackFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub transformFeedback: VkBool32,
    pub geometryStreams: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTransformFeedbackPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxTransformFeedbackStreams: u32,
    pub maxTransformFeedbackBuffers: u32,
    pub maxTransformFeedbackBufferSize: VkDeviceSize,
    pub maxTransformFeedbackStreamDataSize: u32,
    pub maxTransformFeedbackBufferDataSize: u32,
    pub maxTransformFeedbackBufferDataStride: u32,
    pub transformFeedbackQueries: VkBool32,
    pub transformFeedbackStreamsLinesTriangles: VkBool32,
    pub transformFeedbackRasterizationStreamSelect: VkBool32,
    pub transformFeedbackDraw: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationStateStreamCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationStateStreamCreateFlagsEXT,
    pub rasterizationStream: u32,
}
pub type PFN_vkCmdBindTransformFeedbackBuffersEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
        pSizes: *const VkDeviceSize,
    ),
>;
pub type PFN_vkCmdBeginTransformFeedbackEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const VkBuffer,
        pCounterBufferOffsets: *const VkDeviceSize,
    ),
>;
pub type PFN_vkCmdEndTransformFeedbackEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const VkBuffer,
        pCounterBufferOffsets: *const VkDeviceSize,
    ),
>;
pub type PFN_vkCmdBeginQueryIndexedEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
        index: u32,
    ),
>;
pub type PFN_vkCmdEndQueryIndexedEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        index: u32,
    ),
>;
pub type PFN_vkCmdDrawIndirectByteCountEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        instanceCount: u32,
        firstInstance: u32,
        counterBuffer: VkBuffer,
        counterBufferOffset: VkDeviceSize,
        counterOffset: u32,
        vertexStride: u32,
    ),
>;
extern "C" {
    pub fn vkCmdBindTransformFeedbackBuffersEXT(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
        pSizes: *const VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdBeginTransformFeedbackEXT(
        commandBuffer: VkCommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const VkBuffer,
        pCounterBufferOffsets: *const VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdEndTransformFeedbackEXT(
        commandBuffer: VkCommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const VkBuffer,
        pCounterBufferOffsets: *const VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdBeginQueryIndexedEXT(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
        index: u32,
    );
}
extern "C" {
    pub fn vkCmdEndQueryIndexedEXT(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        index: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndirectByteCountEXT(
        commandBuffer: VkCommandBuffer,
        instanceCount: u32,
        firstInstance: u32,
        counterBuffer: VkBuffer,
        counterBufferOffset: VkDeviceSize,
        counterOffset: u32,
        vertexStride: u32,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewHandleInfoNVX {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub imageView: VkImageView,
    pub descriptorType: VkDescriptorType,
    pub sampler: VkSampler,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewAddressPropertiesNVX {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceAddress: VkDeviceAddress,
    pub size: VkDeviceSize,
}
pub type PFN_vkGetImageViewHandleNVX = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkImageViewHandleInfoNVX) -> u32,
>;
pub type PFN_vkGetImageViewAddressNVX = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        imageView: VkImageView,
        pProperties: *mut VkImageViewAddressPropertiesNVX,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetImageViewHandleNVX(device: VkDevice, pInfo: *const VkImageViewHandleInfoNVX)
        -> u32;
}
extern "C" {
    pub fn vkGetImageViewAddressNVX(
        device: VkDevice,
        imageView: VkImageView,
        pProperties: *mut VkImageViewAddressPropertiesNVX,
    ) -> VkResult;
}
pub type PFN_vkCmdDrawIndirectCountAMD = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDrawIndexedIndirectCountAMD = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ),
>;
extern "C" {
    pub fn vkCmdDrawIndirectCountAMD(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndexedIndirectCountAMD(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTextureLODGatherFormatPropertiesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supportsTextureGatherLODBiasAMD: VkBool32,
}
pub const VkShaderInfoTypeAMD_VK_SHADER_INFO_TYPE_STATISTICS_AMD: VkShaderInfoTypeAMD = 0;
pub const VkShaderInfoTypeAMD_VK_SHADER_INFO_TYPE_BINARY_AMD: VkShaderInfoTypeAMD = 1;
pub const VkShaderInfoTypeAMD_VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD: VkShaderInfoTypeAMD = 2;
pub const VkShaderInfoTypeAMD_VK_SHADER_INFO_TYPE_MAX_ENUM_AMD: VkShaderInfoTypeAMD = 2147483647;
pub type VkShaderInfoTypeAMD = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderResourceUsageAMD {
    pub numUsedVgprs: u32,
    pub numUsedSgprs: u32,
    pub ldsSizePerLocalWorkGroup: u32,
    pub ldsUsageSizeInBytes: size_t,
    pub scratchMemUsageInBytes: size_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderStatisticsInfoAMD {
    pub shaderStageMask: VkShaderStageFlags,
    pub resourceUsage: VkShaderResourceUsageAMD,
    pub numPhysicalVgprs: u32,
    pub numPhysicalSgprs: u32,
    pub numAvailableVgprs: u32,
    pub numAvailableSgprs: u32,
    pub computeWorkGroupSize: [u32; 3usize],
}
pub type PFN_vkGetShaderInfoAMD = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        shaderStage: VkShaderStageFlagBits,
        infoType: VkShaderInfoTypeAMD,
        pInfoSize: *mut size_t,
        pInfo: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetShaderInfoAMD(
        device: VkDevice,
        pipeline: VkPipeline,
        shaderStage: VkShaderStageFlagBits,
        infoType: VkShaderInfoTypeAMD,
        pInfoSize: *mut size_t,
        pInfo: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCornerSampledImageFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub cornerSampledImage: VkBool32,
}
pub const VkExternalMemoryHandleTypeFlagBitsNV_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV : VkExternalMemoryHandleTypeFlagBitsNV = 1 ;
pub const VkExternalMemoryHandleTypeFlagBitsNV_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV : VkExternalMemoryHandleTypeFlagBitsNV = 2 ;
pub const VkExternalMemoryHandleTypeFlagBitsNV_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV:
    VkExternalMemoryHandleTypeFlagBitsNV = 4;
pub const VkExternalMemoryHandleTypeFlagBitsNV_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV : VkExternalMemoryHandleTypeFlagBitsNV = 8 ;
pub const VkExternalMemoryHandleTypeFlagBitsNV_VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM_NV : VkExternalMemoryHandleTypeFlagBitsNV = 2147483647 ;
pub type VkExternalMemoryHandleTypeFlagBitsNV = ::std::os::raw::c_uint;
pub type VkExternalMemoryHandleTypeFlagsNV = VkFlags;
pub const VkExternalMemoryFeatureFlagBitsNV_VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV:
    VkExternalMemoryFeatureFlagBitsNV = 1;
pub const VkExternalMemoryFeatureFlagBitsNV_VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV:
    VkExternalMemoryFeatureFlagBitsNV = 2;
pub const VkExternalMemoryFeatureFlagBitsNV_VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV:
    VkExternalMemoryFeatureFlagBitsNV = 4;
pub const VkExternalMemoryFeatureFlagBitsNV_VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM_NV:
    VkExternalMemoryFeatureFlagBitsNV = 2147483647;
pub type VkExternalMemoryFeatureFlagBitsNV = ::std::os::raw::c_uint;
pub type VkExternalMemoryFeatureFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalImageFormatPropertiesNV {
    pub imageFormatProperties: VkImageFormatProperties,
    pub externalMemoryFeatures: VkExternalMemoryFeatureFlagsNV,
    pub exportFromImportedHandleTypes: VkExternalMemoryHandleTypeFlagsNV,
    pub compatibleHandleTypes: VkExternalMemoryHandleTypeFlagsNV,
}
pub type PFN_vkGetPhysicalDeviceExternalImageFormatPropertiesNV = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        externalHandleType: VkExternalMemoryHandleTypeFlagsNV,
        pExternalImageFormatProperties: *mut VkExternalImageFormatPropertiesNV,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceExternalImageFormatPropertiesNV(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        externalHandleType: VkExternalMemoryHandleTypeFlagsNV,
        pExternalImageFormatProperties: *mut VkExternalImageFormatPropertiesNV,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryImageCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlagsNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportMemoryAllocateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlagsNV,
}
pub const VkValidationCheckEXT_VK_VALIDATION_CHECK_ALL_EXT: VkValidationCheckEXT = 0;
pub const VkValidationCheckEXT_VK_VALIDATION_CHECK_SHADERS_EXT: VkValidationCheckEXT = 1;
pub const VkValidationCheckEXT_VK_VALIDATION_CHECK_MAX_ENUM_EXT: VkValidationCheckEXT = 2147483647;
pub type VkValidationCheckEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationFlagsEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub disabledValidationCheckCount: u32,
    pub pDisabledValidationChecks: *const VkValidationCheckEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub textureCompressionASTC_HDR: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewASTCDecodeModeEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub decodeMode: VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceASTCDecodeFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub decodeModeSharedExponent: VkBool32,
}
pub const VkConditionalRenderingFlagBitsEXT_VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT:
    VkConditionalRenderingFlagBitsEXT = 1;
pub const VkConditionalRenderingFlagBitsEXT_VK_CONDITIONAL_RENDERING_FLAG_BITS_MAX_ENUM_EXT:
    VkConditionalRenderingFlagBitsEXT = 2147483647;
pub type VkConditionalRenderingFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkConditionalRenderingFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkConditionalRenderingBeginInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub flags: VkConditionalRenderingFlagsEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceConditionalRenderingFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub conditionalRendering: VkBool32,
    pub inheritedConditionalRendering: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceConditionalRenderingInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub conditionalRenderingEnable: VkBool32,
}
pub type PFN_vkCmdBeginConditionalRenderingEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pConditionalRenderingBegin: *const VkConditionalRenderingBeginInfoEXT,
    ),
>;
pub type PFN_vkCmdEndConditionalRenderingEXT =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer)>;
extern "C" {
    pub fn vkCmdBeginConditionalRenderingEXT(
        commandBuffer: VkCommandBuffer,
        pConditionalRenderingBegin: *const VkConditionalRenderingBeginInfoEXT,
    );
}
extern "C" {
    pub fn vkCmdEndConditionalRenderingEXT(commandBuffer: VkCommandBuffer);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViewportWScalingNV {
    pub xcoeff: f32,
    pub ycoeff: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportWScalingStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub viewportWScalingEnable: VkBool32,
    pub viewportCount: u32,
    pub pViewportWScalings: *const VkViewportWScalingNV,
}
pub type PFN_vkCmdSetViewportWScalingNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewportWScalings: *const VkViewportWScalingNV,
    ),
>;
extern "C" {
    pub fn vkCmdSetViewportWScalingNV(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewportWScalings: *const VkViewportWScalingNV,
    );
}
pub type PFN_vkReleaseDisplayEXT = ::std::option::Option<
    unsafe extern "C" fn(physicalDevice: VkPhysicalDevice, display: VkDisplayKHR) -> VkResult,
>;
extern "C" {
    pub fn vkReleaseDisplayEXT(physicalDevice: VkPhysicalDevice, display: VkDisplayKHR)
        -> VkResult;
}
pub const VkSurfaceCounterFlagBitsEXT_VK_SURFACE_COUNTER_VBLANK_BIT_EXT:
    VkSurfaceCounterFlagBitsEXT = 1;
pub const VkSurfaceCounterFlagBitsEXT_VK_SURFACE_COUNTER_VBLANK_EXT: VkSurfaceCounterFlagBitsEXT =
    1;
pub const VkSurfaceCounterFlagBitsEXT_VK_SURFACE_COUNTER_FLAG_BITS_MAX_ENUM_EXT:
    VkSurfaceCounterFlagBitsEXT = 2147483647;
pub type VkSurfaceCounterFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkSurfaceCounterFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceCapabilities2EXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minImageCount: u32,
    pub maxImageCount: u32,
    pub currentExtent: VkExtent2D,
    pub minImageExtent: VkExtent2D,
    pub maxImageExtent: VkExtent2D,
    pub maxImageArrayLayers: u32,
    pub supportedTransforms: VkSurfaceTransformFlagsKHR,
    pub currentTransform: VkSurfaceTransformFlagBitsKHR,
    pub supportedCompositeAlpha: VkCompositeAlphaFlagsKHR,
    pub supportedUsageFlags: VkImageUsageFlags,
    pub supportedSurfaceCounters: VkSurfaceCounterFlagsEXT,
}
pub type PFN_vkGetPhysicalDeviceSurfaceCapabilities2EXT = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilities2EXT,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceSurfaceCapabilities2EXT(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilities2EXT,
    ) -> VkResult;
}
pub const VkDisplayPowerStateEXT_VK_DISPLAY_POWER_STATE_OFF_EXT: VkDisplayPowerStateEXT = 0;
pub const VkDisplayPowerStateEXT_VK_DISPLAY_POWER_STATE_SUSPEND_EXT: VkDisplayPowerStateEXT = 1;
pub const VkDisplayPowerStateEXT_VK_DISPLAY_POWER_STATE_ON_EXT: VkDisplayPowerStateEXT = 2;
pub const VkDisplayPowerStateEXT_VK_DISPLAY_POWER_STATE_MAX_ENUM_EXT: VkDisplayPowerStateEXT =
    2147483647;
pub type VkDisplayPowerStateEXT = ::std::os::raw::c_uint;
pub const VkDeviceEventTypeEXT_VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT: VkDeviceEventTypeEXT = 0;
pub const VkDeviceEventTypeEXT_VK_DEVICE_EVENT_TYPE_MAX_ENUM_EXT: VkDeviceEventTypeEXT = 2147483647;
pub type VkDeviceEventTypeEXT = ::std::os::raw::c_uint;
pub const VkDisplayEventTypeEXT_VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT: VkDisplayEventTypeEXT =
    0;
pub const VkDisplayEventTypeEXT_VK_DISPLAY_EVENT_TYPE_MAX_ENUM_EXT: VkDisplayEventTypeEXT =
    2147483647;
pub type VkDisplayEventTypeEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPowerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub powerState: VkDisplayPowerStateEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceEventInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceEvent: VkDeviceEventTypeEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayEventInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub displayEvent: VkDisplayEventTypeEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainCounterCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub surfaceCounters: VkSurfaceCounterFlagsEXT,
}
pub type PFN_vkDisplayPowerControlEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        display: VkDisplayKHR,
        pDisplayPowerInfo: *const VkDisplayPowerInfoEXT,
    ) -> VkResult,
>;
pub type PFN_vkRegisterDeviceEventEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pDeviceEventInfo: *const VkDeviceEventInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult,
>;
pub type PFN_vkRegisterDisplayEventEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        display: VkDisplayKHR,
        pDisplayEventInfo: *const VkDisplayEventInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult,
>;
pub type PFN_vkGetSwapchainCounterEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        counter: VkSurfaceCounterFlagBitsEXT,
        pCounterValue: *mut u64,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkDisplayPowerControlEXT(
        device: VkDevice,
        display: VkDisplayKHR,
        pDisplayPowerInfo: *const VkDisplayPowerInfoEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkRegisterDeviceEventEXT(
        device: VkDevice,
        pDeviceEventInfo: *const VkDeviceEventInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkRegisterDisplayEventEXT(
        device: VkDevice,
        display: VkDisplayKHR,
        pDisplayEventInfo: *const VkDisplayEventInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetSwapchainCounterEXT(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        counter: VkSurfaceCounterFlagBitsEXT,
        pCounterValue: *mut u64,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRefreshCycleDurationGOOGLE {
    pub refreshDuration: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPastPresentationTimingGOOGLE {
    pub presentID: u32,
    pub desiredPresentTime: u64,
    pub actualPresentTime: u64,
    pub earliestPresentTime: u64,
    pub presentMargin: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentTimeGOOGLE {
    pub presentID: u32,
    pub desiredPresentTime: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentTimesInfoGOOGLE {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchainCount: u32,
    pub pTimes: *const VkPresentTimeGOOGLE,
}
pub type PFN_vkGetRefreshCycleDurationGOOGLE = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pDisplayTimingProperties: *mut VkRefreshCycleDurationGOOGLE,
    ) -> VkResult,
>;
pub type PFN_vkGetPastPresentationTimingGOOGLE = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pPresentationTimingCount: *mut u32,
        pPresentationTimings: *mut VkPastPresentationTimingGOOGLE,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetRefreshCycleDurationGOOGLE(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pDisplayTimingProperties: *mut VkRefreshCycleDurationGOOGLE,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPastPresentationTimingGOOGLE(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pPresentationTimingCount: *mut u32,
        pPresentationTimings: *mut VkPastPresentationTimingGOOGLE,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub perViewPositionAllComponents: VkBool32,
}
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV:
    VkViewportCoordinateSwizzleNV = 0;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV:
    VkViewportCoordinateSwizzleNV = 1;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV:
    VkViewportCoordinateSwizzleNV = 2;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV:
    VkViewportCoordinateSwizzleNV = 3;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV:
    VkViewportCoordinateSwizzleNV = 4;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV:
    VkViewportCoordinateSwizzleNV = 5;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV:
    VkViewportCoordinateSwizzleNV = 6;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV:
    VkViewportCoordinateSwizzleNV = 7;
pub const VkViewportCoordinateSwizzleNV_VK_VIEWPORT_COORDINATE_SWIZZLE_MAX_ENUM_NV:
    VkViewportCoordinateSwizzleNV = 2147483647;
pub type VkViewportCoordinateSwizzleNV = ::std::os::raw::c_uint;
pub type VkPipelineViewportSwizzleStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViewportSwizzleNV {
    pub x: VkViewportCoordinateSwizzleNV,
    pub y: VkViewportCoordinateSwizzleNV,
    pub z: VkViewportCoordinateSwizzleNV,
    pub w: VkViewportCoordinateSwizzleNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportSwizzleStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineViewportSwizzleStateCreateFlagsNV,
    pub viewportCount: u32,
    pub pViewportSwizzles: *const VkViewportSwizzleNV,
}
pub const VkDiscardRectangleModeEXT_VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT:
    VkDiscardRectangleModeEXT = 0;
pub const VkDiscardRectangleModeEXT_VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT:
    VkDiscardRectangleModeEXT = 1;
pub const VkDiscardRectangleModeEXT_VK_DISCARD_RECTANGLE_MODE_MAX_ENUM_EXT:
    VkDiscardRectangleModeEXT = 2147483647;
pub type VkDiscardRectangleModeEXT = ::std::os::raw::c_uint;
pub type VkPipelineDiscardRectangleStateCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDiscardRectanglePropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxDiscardRectangles: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDiscardRectangleStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDiscardRectangleStateCreateFlagsEXT,
    pub discardRectangleMode: VkDiscardRectangleModeEXT,
    pub discardRectangleCount: u32,
    pub pDiscardRectangles: *const VkRect2D,
}
pub type PFN_vkCmdSetDiscardRectangleEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstDiscardRectangle: u32,
        discardRectangleCount: u32,
        pDiscardRectangles: *const VkRect2D,
    ),
>;
extern "C" {
    pub fn vkCmdSetDiscardRectangleEXT(
        commandBuffer: VkCommandBuffer,
        firstDiscardRectangle: u32,
        discardRectangleCount: u32,
        pDiscardRectangles: *const VkRect2D,
    );
}
pub const VkConservativeRasterizationModeEXT_VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT:
    VkConservativeRasterizationModeEXT = 0;
pub const VkConservativeRasterizationModeEXT_VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT:
    VkConservativeRasterizationModeEXT = 1;
pub const VkConservativeRasterizationModeEXT_VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT : VkConservativeRasterizationModeEXT = 2 ;
pub const VkConservativeRasterizationModeEXT_VK_CONSERVATIVE_RASTERIZATION_MODE_MAX_ENUM_EXT:
    VkConservativeRasterizationModeEXT = 2147483647;
pub type VkConservativeRasterizationModeEXT = ::std::os::raw::c_uint;
pub type VkPipelineRasterizationConservativeStateCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub primitiveOverestimationSize: f32,
    pub maxExtraPrimitiveOverestimationSize: f32,
    pub extraPrimitiveOverestimationSizeGranularity: f32,
    pub primitiveUnderestimation: VkBool32,
    pub conservativePointAndLineRasterization: VkBool32,
    pub degenerateTrianglesRasterized: VkBool32,
    pub degenerateLinesRasterized: VkBool32,
    pub fullyCoveredFragmentShaderInputVariable: VkBool32,
    pub conservativeRasterizationPostDepthCoverage: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationConservativeStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationConservativeStateCreateFlagsEXT,
    pub conservativeRasterizationMode: VkConservativeRasterizationModeEXT,
    pub extraPrimitiveOverestimationSize: f32,
}
pub type VkPipelineRasterizationDepthClipStateCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDepthClipEnableFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub depthClipEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationDepthClipStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationDepthClipStateCreateFlagsEXT,
    pub depthClipEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkXYColorEXT {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkHdrMetadataEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub displayPrimaryRed: VkXYColorEXT,
    pub displayPrimaryGreen: VkXYColorEXT,
    pub displayPrimaryBlue: VkXYColorEXT,
    pub whitePoint: VkXYColorEXT,
    pub maxLuminance: f32,
    pub minLuminance: f32,
    pub maxContentLightLevel: f32,
    pub maxFrameAverageLightLevel: f32,
}
pub type PFN_vkSetHdrMetadataEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        swapchainCount: u32,
        pSwapchains: *const VkSwapchainKHR,
        pMetadata: *const VkHdrMetadataEXT,
    ),
>;
extern "C" {
    pub fn vkSetHdrMetadataEXT(
        device: VkDevice,
        swapchainCount: u32,
        pSwapchains: *const VkSwapchainKHR,
        pMetadata: *const VkHdrMetadataEXT,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsMessengerEXT_T {
    _unused: [u8; 0],
}
pub type VkDebugUtilsMessengerEXT = *mut VkDebugUtilsMessengerEXT_T;
pub type VkDebugUtilsMessengerCallbackDataFlagsEXT = VkFlags;
pub const VkDebugUtilsMessageSeverityFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 1;
pub const VkDebugUtilsMessageSeverityFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 16;
pub const VkDebugUtilsMessageSeverityFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 256;
pub const VkDebugUtilsMessageSeverityFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 4096;
pub const VkDebugUtilsMessageSeverityFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_SEVERITY_FLAG_BITS_MAX_ENUM_EXT : VkDebugUtilsMessageSeverityFlagBitsEXT = 2147483647 ;
pub type VkDebugUtilsMessageSeverityFlagBitsEXT = ::std::os::raw::c_uint;
pub const VkDebugUtilsMessageTypeFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 1;
pub const VkDebugUtilsMessageTypeFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 2;
pub const VkDebugUtilsMessageTypeFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 4;
pub const VkDebugUtilsMessageTypeFlagBitsEXT_VK_DEBUG_UTILS_MESSAGE_TYPE_FLAG_BITS_MAX_ENUM_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 2147483647;
pub type VkDebugUtilsMessageTypeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkDebugUtilsMessageTypeFlagsEXT = VkFlags;
pub type VkDebugUtilsMessageSeverityFlagsEXT = VkFlags;
pub type VkDebugUtilsMessengerCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsLabelEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pLabelName: *const ::std::os::raw::c_char,
    pub color: [f32; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsObjectNameInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkObjectType,
    pub objectHandle: u64,
    pub pObjectName: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsMessengerCallbackDataEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDebugUtilsMessengerCallbackDataFlagsEXT,
    pub pMessageIdName: *const ::std::os::raw::c_char,
    pub messageIdNumber: i32,
    pub pMessage: *const ::std::os::raw::c_char,
    pub queueLabelCount: u32,
    pub pQueueLabels: *const VkDebugUtilsLabelEXT,
    pub cmdBufLabelCount: u32,
    pub pCmdBufLabels: *const VkDebugUtilsLabelEXT,
    pub objectCount: u32,
    pub pObjects: *const VkDebugUtilsObjectNameInfoEXT,
}
pub type PFN_vkDebugUtilsMessengerCallbackEXT = ::std::option::Option<
    unsafe extern "C" fn(
        messageSeverity: VkDebugUtilsMessageSeverityFlagBitsEXT,
        messageTypes: VkDebugUtilsMessageTypeFlagsEXT,
        pCallbackData: *const VkDebugUtilsMessengerCallbackDataEXT,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> VkBool32,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsMessengerCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDebugUtilsMessengerCreateFlagsEXT,
    pub messageSeverity: VkDebugUtilsMessageSeverityFlagsEXT,
    pub messageType: VkDebugUtilsMessageTypeFlagsEXT,
    pub pfnUserCallback: PFN_vkDebugUtilsMessengerCallbackEXT,
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsObjectTagInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkObjectType,
    pub objectHandle: u64,
    pub tagName: u64,
    pub tagSize: size_t,
    pub pTag: *const ::std::os::raw::c_void,
}
pub type PFN_vkSetDebugUtilsObjectNameEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pNameInfo: *const VkDebugUtilsObjectNameInfoEXT,
    ) -> VkResult,
>;
pub type PFN_vkSetDebugUtilsObjectTagEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pTagInfo: *const VkDebugUtilsObjectTagInfoEXT,
    ) -> VkResult,
>;
pub type PFN_vkQueueBeginDebugUtilsLabelEXT = ::std::option::Option<
    unsafe extern "C" fn(queue: VkQueue, pLabelInfo: *const VkDebugUtilsLabelEXT),
>;
pub type PFN_vkQueueEndDebugUtilsLabelEXT =
    ::std::option::Option<unsafe extern "C" fn(queue: VkQueue)>;
pub type PFN_vkQueueInsertDebugUtilsLabelEXT = ::std::option::Option<
    unsafe extern "C" fn(queue: VkQueue, pLabelInfo: *const VkDebugUtilsLabelEXT),
>;
pub type PFN_vkCmdBeginDebugUtilsLabelEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pLabelInfo: *const VkDebugUtilsLabelEXT),
>;
pub type PFN_vkCmdEndDebugUtilsLabelEXT =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer)>;
pub type PFN_vkCmdInsertDebugUtilsLabelEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pLabelInfo: *const VkDebugUtilsLabelEXT),
>;
pub type PFN_vkCreateDebugUtilsMessengerEXT = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkDebugUtilsMessengerCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pMessenger: *mut VkDebugUtilsMessengerEXT,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDebugUtilsMessengerEXT = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        messenger: VkDebugUtilsMessengerEXT,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkSubmitDebugUtilsMessageEXT = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        messageSeverity: VkDebugUtilsMessageSeverityFlagBitsEXT,
        messageTypes: VkDebugUtilsMessageTypeFlagsEXT,
        pCallbackData: *const VkDebugUtilsMessengerCallbackDataEXT,
    ),
>;
extern "C" {
    pub fn vkSetDebugUtilsObjectNameEXT(
        device: VkDevice,
        pNameInfo: *const VkDebugUtilsObjectNameInfoEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkSetDebugUtilsObjectTagEXT(
        device: VkDevice,
        pTagInfo: *const VkDebugUtilsObjectTagInfoEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkQueueBeginDebugUtilsLabelEXT(queue: VkQueue, pLabelInfo: *const VkDebugUtilsLabelEXT);
}
extern "C" {
    pub fn vkQueueEndDebugUtilsLabelEXT(queue: VkQueue);
}
extern "C" {
    pub fn vkQueueInsertDebugUtilsLabelEXT(queue: VkQueue, pLabelInfo: *const VkDebugUtilsLabelEXT);
}
extern "C" {
    pub fn vkCmdBeginDebugUtilsLabelEXT(
        commandBuffer: VkCommandBuffer,
        pLabelInfo: *const VkDebugUtilsLabelEXT,
    );
}
extern "C" {
    pub fn vkCmdEndDebugUtilsLabelEXT(commandBuffer: VkCommandBuffer);
}
extern "C" {
    pub fn vkCmdInsertDebugUtilsLabelEXT(
        commandBuffer: VkCommandBuffer,
        pLabelInfo: *const VkDebugUtilsLabelEXT,
    );
}
extern "C" {
    pub fn vkCreateDebugUtilsMessengerEXT(
        instance: VkInstance,
        pCreateInfo: *const VkDebugUtilsMessengerCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pMessenger: *mut VkDebugUtilsMessengerEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDebugUtilsMessengerEXT(
        instance: VkInstance,
        messenger: VkDebugUtilsMessengerEXT,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkSubmitDebugUtilsMessageEXT(
        instance: VkInstance,
        messageSeverity: VkDebugUtilsMessageSeverityFlagBitsEXT,
        messageTypes: VkDebugUtilsMessageTypeFlagsEXT,
        pCallbackData: *const VkDebugUtilsMessengerCallbackDataEXT,
    );
}
pub use self::VkSamplerReductionMode as VkSamplerReductionModeEXT;
pub type VkSamplerReductionModeCreateInfoEXT = VkSamplerReductionModeCreateInfo;
pub type VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT =
    VkPhysicalDeviceSamplerFilterMinmaxProperties;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceInlineUniformBlockFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub inlineUniformBlock: VkBool32,
    pub descriptorBindingInlineUniformBlockUpdateAfterBind: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceInlineUniformBlockPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxInlineUniformBlockSize: u32,
    pub maxPerStageDescriptorInlineUniformBlocks: u32,
    pub maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks: u32,
    pub maxDescriptorSetInlineUniformBlocks: u32,
    pub maxDescriptorSetUpdateAfterBindInlineUniformBlocks: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSetInlineUniformBlockEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dataSize: u32,
    pub pData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolInlineUniformBlockCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxInlineUniformBlockBindings: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSampleLocationEXT {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSampleLocationsInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub sampleLocationsPerPixel: VkSampleCountFlagBits,
    pub sampleLocationGridSize: VkExtent2D,
    pub sampleLocationsCount: u32,
    pub pSampleLocations: *const VkSampleLocationEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentSampleLocationsEXT {
    pub attachmentIndex: u32,
    pub sampleLocationsInfo: VkSampleLocationsInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassSampleLocationsEXT {
    pub subpassIndex: u32,
    pub sampleLocationsInfo: VkSampleLocationsInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassSampleLocationsBeginInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentInitialSampleLocationsCount: u32,
    pub pAttachmentInitialSampleLocations: *const VkAttachmentSampleLocationsEXT,
    pub postSubpassSampleLocationsCount: u32,
    pub pPostSubpassSampleLocations: *const VkSubpassSampleLocationsEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineSampleLocationsStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub sampleLocationsEnable: VkBool32,
    pub sampleLocationsInfo: VkSampleLocationsInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSampleLocationsPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub sampleLocationSampleCounts: VkSampleCountFlags,
    pub maxSampleLocationGridSize: VkExtent2D,
    pub sampleLocationCoordinateRange: [f32; 2usize],
    pub sampleLocationSubPixelBits: u32,
    pub variableSampleLocations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMultisamplePropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxSampleLocationGridSize: VkExtent2D,
}
pub type PFN_vkCmdSetSampleLocationsEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pSampleLocationsInfo: *const VkSampleLocationsInfoEXT,
    ),
>;
pub type PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        samples: VkSampleCountFlagBits,
        pMultisampleProperties: *mut VkMultisamplePropertiesEXT,
    ),
>;
extern "C" {
    pub fn vkCmdSetSampleLocationsEXT(
        commandBuffer: VkCommandBuffer,
        pSampleLocationsInfo: *const VkSampleLocationsInfoEXT,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceMultisamplePropertiesEXT(
        physicalDevice: VkPhysicalDevice,
        samples: VkSampleCountFlagBits,
        pMultisampleProperties: *mut VkMultisamplePropertiesEXT,
    );
}
pub const VkBlendOverlapEXT_VK_BLEND_OVERLAP_UNCORRELATED_EXT: VkBlendOverlapEXT = 0;
pub const VkBlendOverlapEXT_VK_BLEND_OVERLAP_DISJOINT_EXT: VkBlendOverlapEXT = 1;
pub const VkBlendOverlapEXT_VK_BLEND_OVERLAP_CONJOINT_EXT: VkBlendOverlapEXT = 2;
pub const VkBlendOverlapEXT_VK_BLEND_OVERLAP_MAX_ENUM_EXT: VkBlendOverlapEXT = 2147483647;
pub type VkBlendOverlapEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub advancedBlendCoherentOperations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub advancedBlendMaxColorAttachments: u32,
    pub advancedBlendIndependentBlend: VkBool32,
    pub advancedBlendNonPremultipliedSrcColor: VkBool32,
    pub advancedBlendNonPremultipliedDstColor: VkBool32,
    pub advancedBlendCorrelatedOverlap: VkBool32,
    pub advancedBlendAllOperations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendAdvancedStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcPremultiplied: VkBool32,
    pub dstPremultiplied: VkBool32,
    pub blendOverlap: VkBlendOverlapEXT,
}
pub type VkPipelineCoverageToColorStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCoverageToColorStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCoverageToColorStateCreateFlagsNV,
    pub coverageToColorEnable: VkBool32,
    pub coverageToColorLocation: u32,
}
pub const VkCoverageModulationModeNV_VK_COVERAGE_MODULATION_MODE_NONE_NV:
    VkCoverageModulationModeNV = 0;
pub const VkCoverageModulationModeNV_VK_COVERAGE_MODULATION_MODE_RGB_NV:
    VkCoverageModulationModeNV = 1;
pub const VkCoverageModulationModeNV_VK_COVERAGE_MODULATION_MODE_ALPHA_NV:
    VkCoverageModulationModeNV = 2;
pub const VkCoverageModulationModeNV_VK_COVERAGE_MODULATION_MODE_RGBA_NV:
    VkCoverageModulationModeNV = 3;
pub const VkCoverageModulationModeNV_VK_COVERAGE_MODULATION_MODE_MAX_ENUM_NV:
    VkCoverageModulationModeNV = 2147483647;
pub type VkCoverageModulationModeNV = ::std::os::raw::c_uint;
pub type VkPipelineCoverageModulationStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCoverageModulationStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCoverageModulationStateCreateFlagsNV,
    pub coverageModulationMode: VkCoverageModulationModeNV,
    pub coverageModulationTableEnable: VkBool32,
    pub coverageModulationTableCount: u32,
    pub pCoverageModulationTable: *const f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSMCount: u32,
    pub shaderWarpsPerSM: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSMBuiltinsFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSMBuiltins: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrmFormatModifierPropertiesEXT {
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub drmFormatModifierTilingFeatures: VkFormatFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrmFormatModifierPropertiesListEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifierProperties: *mut VkDrmFormatModifierPropertiesEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub drmFormatModifier: u64,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageDrmFormatModifierListCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifiers: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageDrmFormatModifierExplicitCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub pPlaneLayouts: *const VkSubresourceLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageDrmFormatModifierPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub drmFormatModifier: u64,
}
pub type PFN_vkGetImageDrmFormatModifierPropertiesEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pProperties: *mut VkImageDrmFormatModifierPropertiesEXT,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetImageDrmFormatModifierPropertiesEXT(
        device: VkDevice,
        image: VkImage,
        pProperties: *mut VkImageDrmFormatModifierPropertiesEXT,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationCacheEXT_T {
    _unused: [u8; 0],
}
pub type VkValidationCacheEXT = *mut VkValidationCacheEXT_T;
pub const VkValidationCacheHeaderVersionEXT_VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT:
    VkValidationCacheHeaderVersionEXT = 1;
pub const VkValidationCacheHeaderVersionEXT_VK_VALIDATION_CACHE_HEADER_VERSION_MAX_ENUM_EXT:
    VkValidationCacheHeaderVersionEXT = 2147483647;
pub type VkValidationCacheHeaderVersionEXT = ::std::os::raw::c_uint;
pub type VkValidationCacheCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationCacheCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkValidationCacheCreateFlagsEXT,
    pub initialDataSize: size_t,
    pub pInitialData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModuleValidationCacheCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub validationCache: VkValidationCacheEXT,
}
pub type PFN_vkCreateValidationCacheEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkValidationCacheCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pValidationCache: *mut VkValidationCacheEXT,
    ) -> VkResult,
>;
pub type PFN_vkDestroyValidationCacheEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        validationCache: VkValidationCacheEXT,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkMergeValidationCachesEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        dstCache: VkValidationCacheEXT,
        srcCacheCount: u32,
        pSrcCaches: *const VkValidationCacheEXT,
    ) -> VkResult,
>;
pub type PFN_vkGetValidationCacheDataEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        validationCache: VkValidationCacheEXT,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkCreateValidationCacheEXT(
        device: VkDevice,
        pCreateInfo: *const VkValidationCacheCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pValidationCache: *mut VkValidationCacheEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyValidationCacheEXT(
        device: VkDevice,
        validationCache: VkValidationCacheEXT,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkMergeValidationCachesEXT(
        device: VkDevice,
        dstCache: VkValidationCacheEXT,
        srcCacheCount: u32,
        pSrcCaches: *const VkValidationCacheEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetValidationCacheDataEXT(
        device: VkDevice,
        validationCache: VkValidationCacheEXT,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
pub use self::VkDescriptorBindingFlagBits as VkDescriptorBindingFlagBitsEXT;
pub type VkDescriptorBindingFlagsEXT = VkDescriptorBindingFlags;
pub type VkDescriptorSetLayoutBindingFlagsCreateInfoEXT =
    VkDescriptorSetLayoutBindingFlagsCreateInfo;
pub type VkPhysicalDeviceDescriptorIndexingFeaturesEXT = VkPhysicalDeviceDescriptorIndexingFeatures;
pub type VkPhysicalDeviceDescriptorIndexingPropertiesEXT =
    VkPhysicalDeviceDescriptorIndexingProperties;
pub type VkDescriptorSetVariableDescriptorCountAllocateInfoEXT =
    VkDescriptorSetVariableDescriptorCountAllocateInfo;
pub type VkDescriptorSetVariableDescriptorCountLayoutSupportEXT =
    VkDescriptorSetVariableDescriptorCountLayoutSupport;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV:
    VkShadingRatePaletteEntryNV = 0;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 1;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 2;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 3;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 4;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 5;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV : VkShadingRatePaletteEntryNV = 6 ;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV : VkShadingRatePaletteEntryNV = 7 ;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV : VkShadingRatePaletteEntryNV = 8 ;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV : VkShadingRatePaletteEntryNV = 9 ;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV : VkShadingRatePaletteEntryNV = 10 ;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV : VkShadingRatePaletteEntryNV = 11 ;
pub const VkShadingRatePaletteEntryNV_VK_SHADING_RATE_PALETTE_ENTRY_MAX_ENUM_NV:
    VkShadingRatePaletteEntryNV = 2147483647;
pub type VkShadingRatePaletteEntryNV = ::std::os::raw::c_uint;
pub const VkCoarseSampleOrderTypeNV_VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV:
    VkCoarseSampleOrderTypeNV = 0;
pub const VkCoarseSampleOrderTypeNV_VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV:
    VkCoarseSampleOrderTypeNV = 1;
pub const VkCoarseSampleOrderTypeNV_VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV:
    VkCoarseSampleOrderTypeNV = 2;
pub const VkCoarseSampleOrderTypeNV_VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV:
    VkCoarseSampleOrderTypeNV = 3;
pub const VkCoarseSampleOrderTypeNV_VK_COARSE_SAMPLE_ORDER_TYPE_MAX_ENUM_NV:
    VkCoarseSampleOrderTypeNV = 2147483647;
pub type VkCoarseSampleOrderTypeNV = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShadingRatePaletteNV {
    pub shadingRatePaletteEntryCount: u32,
    pub pShadingRatePaletteEntries: *const VkShadingRatePaletteEntryNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportShadingRateImageStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub shadingRateImageEnable: VkBool32,
    pub viewportCount: u32,
    pub pShadingRatePalettes: *const VkShadingRatePaletteNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShadingRateImageFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shadingRateImage: VkBool32,
    pub shadingRateCoarseSampleOrder: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShadingRateImagePropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shadingRateTexelSize: VkExtent2D,
    pub shadingRatePaletteSize: u32,
    pub shadingRateMaxCoarseSamples: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCoarseSampleLocationNV {
    pub pixelX: u32,
    pub pixelY: u32,
    pub sample: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCoarseSampleOrderCustomNV {
    pub shadingRate: VkShadingRatePaletteEntryNV,
    pub sampleCount: u32,
    pub sampleLocationCount: u32,
    pub pSampleLocations: *const VkCoarseSampleLocationNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub sampleOrderType: VkCoarseSampleOrderTypeNV,
    pub customSampleOrderCount: u32,
    pub pCustomSampleOrders: *const VkCoarseSampleOrderCustomNV,
}
pub type PFN_vkCmdBindShadingRateImageNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        imageView: VkImageView,
        imageLayout: VkImageLayout,
    ),
>;
pub type PFN_vkCmdSetViewportShadingRatePaletteNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pShadingRatePalettes: *const VkShadingRatePaletteNV,
    ),
>;
pub type PFN_vkCmdSetCoarseSampleOrderNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        sampleOrderType: VkCoarseSampleOrderTypeNV,
        customSampleOrderCount: u32,
        pCustomSampleOrders: *const VkCoarseSampleOrderCustomNV,
    ),
>;
extern "C" {
    pub fn vkCmdBindShadingRateImageNV(
        commandBuffer: VkCommandBuffer,
        imageView: VkImageView,
        imageLayout: VkImageLayout,
    );
}
extern "C" {
    pub fn vkCmdSetViewportShadingRatePaletteNV(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pShadingRatePalettes: *const VkShadingRatePaletteNV,
    );
}
extern "C" {
    pub fn vkCmdSetCoarseSampleOrderNV(
        commandBuffer: VkCommandBuffer,
        sampleOrderType: VkCoarseSampleOrderTypeNV,
        customSampleOrderCount: u32,
        pCustomSampleOrders: *const VkCoarseSampleOrderCustomNV,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureNV_T {
    _unused: [u8; 0],
}
pub type VkAccelerationStructureNV = *mut VkAccelerationStructureNV_T;
pub const VkRayTracingShaderGroupTypeKHR_VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR:
    VkRayTracingShaderGroupTypeKHR = 0;
pub const VkRayTracingShaderGroupTypeKHR_VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR : VkRayTracingShaderGroupTypeKHR = 1 ;
pub const VkRayTracingShaderGroupTypeKHR_VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR : VkRayTracingShaderGroupTypeKHR = 2 ;
pub const VkRayTracingShaderGroupTypeKHR_VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV:
    VkRayTracingShaderGroupTypeKHR = 0;
pub const VkRayTracingShaderGroupTypeKHR_VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV:
    VkRayTracingShaderGroupTypeKHR = 1;
pub const VkRayTracingShaderGroupTypeKHR_VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV : VkRayTracingShaderGroupTypeKHR = 2 ;
pub const VkRayTracingShaderGroupTypeKHR_VK_RAY_TRACING_SHADER_GROUP_TYPE_MAX_ENUM_KHR:
    VkRayTracingShaderGroupTypeKHR = 2147483647;
pub type VkRayTracingShaderGroupTypeKHR = ::std::os::raw::c_uint;
pub use self::VkRayTracingShaderGroupTypeKHR as VkRayTracingShaderGroupTypeNV;
pub const VkGeometryTypeKHR_VK_GEOMETRY_TYPE_TRIANGLES_KHR: VkGeometryTypeKHR = 0;
pub const VkGeometryTypeKHR_VK_GEOMETRY_TYPE_AABBS_KHR: VkGeometryTypeKHR = 1;
pub const VkGeometryTypeKHR_VK_GEOMETRY_TYPE_INSTANCES_KHR: VkGeometryTypeKHR = 2;
pub const VkGeometryTypeKHR_VK_GEOMETRY_TYPE_TRIANGLES_NV: VkGeometryTypeKHR = 0;
pub const VkGeometryTypeKHR_VK_GEOMETRY_TYPE_AABBS_NV: VkGeometryTypeKHR = 1;
pub const VkGeometryTypeKHR_VK_GEOMETRY_TYPE_MAX_ENUM_KHR: VkGeometryTypeKHR = 2147483647;
pub type VkGeometryTypeKHR = ::std::os::raw::c_uint;
pub use self::VkGeometryTypeKHR as VkGeometryTypeNV;
pub const VkAccelerationStructureTypeKHR_VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR:
    VkAccelerationStructureTypeKHR = 0;
pub const VkAccelerationStructureTypeKHR_VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR:
    VkAccelerationStructureTypeKHR = 1;
pub const VkAccelerationStructureTypeKHR_VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR:
    VkAccelerationStructureTypeKHR = 2;
pub const VkAccelerationStructureTypeKHR_VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV:
    VkAccelerationStructureTypeKHR = 0;
pub const VkAccelerationStructureTypeKHR_VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV:
    VkAccelerationStructureTypeKHR = 1;
pub const VkAccelerationStructureTypeKHR_VK_ACCELERATION_STRUCTURE_TYPE_MAX_ENUM_KHR:
    VkAccelerationStructureTypeKHR = 2147483647;
pub type VkAccelerationStructureTypeKHR = ::std::os::raw::c_uint;
pub use self::VkAccelerationStructureTypeKHR as VkAccelerationStructureTypeNV;
pub const VkCopyAccelerationStructureModeKHR_VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR:
    VkCopyAccelerationStructureModeKHR = 0;
pub const VkCopyAccelerationStructureModeKHR_VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR:
    VkCopyAccelerationStructureModeKHR = 1;
pub const VkCopyAccelerationStructureModeKHR_VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR:
    VkCopyAccelerationStructureModeKHR = 2;
pub const VkCopyAccelerationStructureModeKHR_VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR:
    VkCopyAccelerationStructureModeKHR = 3;
pub const VkCopyAccelerationStructureModeKHR_VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_NV:
    VkCopyAccelerationStructureModeKHR = 0;
pub const VkCopyAccelerationStructureModeKHR_VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_NV:
    VkCopyAccelerationStructureModeKHR = 1;
pub const VkCopyAccelerationStructureModeKHR_VK_COPY_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR:
    VkCopyAccelerationStructureModeKHR = 2147483647;
pub type VkCopyAccelerationStructureModeKHR = ::std::os::raw::c_uint;
pub use self::VkCopyAccelerationStructureModeKHR as VkCopyAccelerationStructureModeNV;
pub const VkAccelerationStructureMemoryRequirementsTypeNV_VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 0 ;
pub const VkAccelerationStructureMemoryRequirementsTypeNV_VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 1 ;
pub const VkAccelerationStructureMemoryRequirementsTypeNV_VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 2 ;
pub const VkAccelerationStructureMemoryRequirementsTypeNV_VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_MAX_ENUM_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 2147483647 ;
pub type VkAccelerationStructureMemoryRequirementsTypeNV = ::std::os::raw::c_uint;
pub const VkGeometryFlagBitsKHR_VK_GEOMETRY_OPAQUE_BIT_KHR: VkGeometryFlagBitsKHR = 1;
pub const VkGeometryFlagBitsKHR_VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR:
    VkGeometryFlagBitsKHR = 2;
pub const VkGeometryFlagBitsKHR_VK_GEOMETRY_OPAQUE_BIT_NV: VkGeometryFlagBitsKHR = 1;
pub const VkGeometryFlagBitsKHR_VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_NV:
    VkGeometryFlagBitsKHR = 2;
pub const VkGeometryFlagBitsKHR_VK_GEOMETRY_FLAG_BITS_MAX_ENUM_KHR: VkGeometryFlagBitsKHR =
    2147483647;
pub type VkGeometryFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkGeometryFlagsKHR = VkFlags;
pub type VkGeometryFlagsNV = VkGeometryFlagsKHR;
pub use self::VkGeometryFlagBitsKHR as VkGeometryFlagBitsNV;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR : VkGeometryInstanceFlagBitsKHR = 1 ;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_KHR : VkGeometryInstanceFlagBitsKHR = 2 ;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR:
    VkGeometryInstanceFlagBitsKHR = 4;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR:
    VkGeometryInstanceFlagBitsKHR = 8;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_TRIANGLE_CULL_DISABLE_BIT_NV:
    VkGeometryInstanceFlagBitsKHR = 1;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_NV : VkGeometryInstanceFlagBitsKHR = 2 ;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_NV:
    VkGeometryInstanceFlagBitsKHR = 4;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_NV:
    VkGeometryInstanceFlagBitsKHR = 8;
pub const VkGeometryInstanceFlagBitsKHR_VK_GEOMETRY_INSTANCE_FLAG_BITS_MAX_ENUM_KHR:
    VkGeometryInstanceFlagBitsKHR = 2147483647;
pub type VkGeometryInstanceFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkGeometryInstanceFlagsKHR = VkFlags;
pub type VkGeometryInstanceFlagsNV = VkGeometryInstanceFlagsKHR;
pub use self::VkGeometryInstanceFlagBitsKHR as VkGeometryInstanceFlagBitsNV;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 1 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 2 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 4 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 8 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 16 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 1 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 2 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 4 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 8 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 16 ;
pub const VkBuildAccelerationStructureFlagBitsKHR_VK_BUILD_ACCELERATION_STRUCTURE_FLAG_BITS_MAX_ENUM_KHR : VkBuildAccelerationStructureFlagBitsKHR = 2147483647 ;
pub type VkBuildAccelerationStructureFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkBuildAccelerationStructureFlagsKHR = VkFlags;
pub type VkBuildAccelerationStructureFlagsNV = VkBuildAccelerationStructureFlagsKHR;
pub use self::VkBuildAccelerationStructureFlagBitsKHR as VkBuildAccelerationStructureFlagBitsNV;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingShaderGroupCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkRayTracingShaderGroupTypeKHR,
    pub generalShader: u32,
    pub closestHitShader: u32,
    pub anyHitShader: u32,
    pub intersectionShader: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingPipelineCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub groupCount: u32,
    pub pGroups: *const VkRayTracingShaderGroupCreateInfoNV,
    pub maxRecursionDepth: u32,
    pub layout: VkPipelineLayout,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryTrianglesNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vertexData: VkBuffer,
    pub vertexOffset: VkDeviceSize,
    pub vertexCount: u32,
    pub vertexStride: VkDeviceSize,
    pub vertexFormat: VkFormat,
    pub indexData: VkBuffer,
    pub indexOffset: VkDeviceSize,
    pub indexCount: u32,
    pub indexType: VkIndexType,
    pub transformData: VkBuffer,
    pub transformOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryAABBNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub aabbData: VkBuffer,
    pub numAABBs: u32,
    pub stride: u32,
    pub offset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryDataNV {
    pub triangles: VkGeometryTrianglesNV,
    pub aabbs: VkGeometryAABBNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub geometryType: VkGeometryTypeKHR,
    pub geometry: VkGeometryDataNV,
    pub flags: VkGeometryFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkAccelerationStructureTypeNV,
    pub flags: VkBuildAccelerationStructureFlagsNV,
    pub instanceCount: u32,
    pub geometryCount: u32,
    pub pGeometries: *const VkGeometryNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub compactedSize: VkDeviceSize,
    pub info: VkAccelerationStructureInfoNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindAccelerationStructureMemoryInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructure: VkAccelerationStructureNV,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSetAccelerationStructureNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructureCount: u32,
    pub pAccelerationStructures: *const VkAccelerationStructureNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureMemoryRequirementsInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkAccelerationStructureMemoryRequirementsTypeNV,
    pub accelerationStructure: VkAccelerationStructureNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayTracingPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderGroupHandleSize: u32,
    pub maxRecursionDepth: u32,
    pub maxShaderGroupStride: u32,
    pub shaderGroupBaseAlignment: u32,
    pub maxGeometryCount: u64,
    pub maxInstanceCount: u64,
    pub maxTriangleCount: u64,
    pub maxDescriptorSetAccelerationStructures: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTransformMatrixKHR {
    pub matrix: [[f32; 4usize]; 3usize],
}
pub type VkTransformMatrixNV = VkTransformMatrixKHR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAabbPositionsKHR {
    pub minX: f32,
    pub minY: f32,
    pub minZ: f32,
    pub maxX: f32,
    pub maxY: f32,
    pub maxZ: f32,
}
pub type VkAabbPositionsNV = VkAabbPositionsKHR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureInstanceKHR {
    pub transform: VkTransformMatrixKHR,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub accelerationStructureReference: u64,
}
impl VkAccelerationStructureInstanceKHR {
    #[inline]
    pub fn instanceCustomIndex(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceCustomIndex(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn instanceShaderBindingTableRecordOffset(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceShaderBindingTableRecordOffset(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> VkGeometryInstanceFlagsKHR {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: VkGeometryInstanceFlagsKHR) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        instanceCustomIndex: u32,
        mask: u32,
        instanceShaderBindingTableRecordOffset: u32,
        flags: VkGeometryInstanceFlagsKHR,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let instanceCustomIndex: u32 = unsafe { ::std::mem::transmute(instanceCustomIndex) };
            instanceCustomIndex as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mask: u32 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(32usize, 24u8, {
            let instanceShaderBindingTableRecordOffset: u32 =
                unsafe { ::std::mem::transmute(instanceShaderBindingTableRecordOffset) };
            instanceShaderBindingTableRecordOffset as u64
        });
        __bindgen_bitfield_unit.set(56usize, 8u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type VkAccelerationStructureInstanceNV = VkAccelerationStructureInstanceKHR;
pub type PFN_vkCreateAccelerationStructureNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkAccelerationStructureCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pAccelerationStructure: *mut VkAccelerationStructureNV,
    ) -> VkResult,
>;
pub type PFN_vkDestroyAccelerationStructureNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureNV,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetAccelerationStructureMemoryRequirementsNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkAccelerationStructureMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut VkMemoryRequirements2KHR,
    ),
>;
pub type PFN_vkBindAccelerationStructureMemoryNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindAccelerationStructureMemoryInfoNV,
    ) -> VkResult,
>;
pub type PFN_vkCmdBuildAccelerationStructureNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkAccelerationStructureInfoNV,
        instanceData: VkBuffer,
        instanceOffset: VkDeviceSize,
        update: VkBool32,
        dst: VkAccelerationStructureNV,
        src: VkAccelerationStructureNV,
        scratch: VkBuffer,
        scratchOffset: VkDeviceSize,
    ),
>;
pub type PFN_vkCmdCopyAccelerationStructureNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dst: VkAccelerationStructureNV,
        src: VkAccelerationStructureNV,
        mode: VkCopyAccelerationStructureModeKHR,
    ),
>;
pub type PFN_vkCmdTraceRaysNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        raygenShaderBindingTableBuffer: VkBuffer,
        raygenShaderBindingOffset: VkDeviceSize,
        missShaderBindingTableBuffer: VkBuffer,
        missShaderBindingOffset: VkDeviceSize,
        missShaderBindingStride: VkDeviceSize,
        hitShaderBindingTableBuffer: VkBuffer,
        hitShaderBindingOffset: VkDeviceSize,
        hitShaderBindingStride: VkDeviceSize,
        callableShaderBindingTableBuffer: VkBuffer,
        callableShaderBindingOffset: VkDeviceSize,
        callableShaderBindingStride: VkDeviceSize,
        width: u32,
        height: u32,
        depth: u32,
    ),
>;
pub type PFN_vkCreateRayTracingPipelinesNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkRayTracingPipelineCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult,
>;
pub type PFN_vkGetRayTracingShaderGroupHandlesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkGetRayTracingShaderGroupHandlesNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkGetAccelerationStructureHandleNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureNV,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkCmdWriteAccelerationStructuresPropertiesNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureNV,
        queryType: VkQueryType,
        queryPool: VkQueryPool,
        firstQuery: u32,
    ),
>;
pub type PFN_vkCompileDeferredNV = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pipeline: VkPipeline, shader: u32) -> VkResult,
>;
extern "C" {
    pub fn vkCreateAccelerationStructureNV(
        device: VkDevice,
        pCreateInfo: *const VkAccelerationStructureCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pAccelerationStructure: *mut VkAccelerationStructureNV,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyAccelerationStructureNV(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureNV,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetAccelerationStructureMemoryRequirementsNV(
        device: VkDevice,
        pInfo: *const VkAccelerationStructureMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut VkMemoryRequirements2KHR,
    );
}
extern "C" {
    pub fn vkBindAccelerationStructureMemoryNV(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindAccelerationStructureMemoryInfoNV,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdBuildAccelerationStructureNV(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkAccelerationStructureInfoNV,
        instanceData: VkBuffer,
        instanceOffset: VkDeviceSize,
        update: VkBool32,
        dst: VkAccelerationStructureNV,
        src: VkAccelerationStructureNV,
        scratch: VkBuffer,
        scratchOffset: VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdCopyAccelerationStructureNV(
        commandBuffer: VkCommandBuffer,
        dst: VkAccelerationStructureNV,
        src: VkAccelerationStructureNV,
        mode: VkCopyAccelerationStructureModeKHR,
    );
}
extern "C" {
    pub fn vkCmdTraceRaysNV(
        commandBuffer: VkCommandBuffer,
        raygenShaderBindingTableBuffer: VkBuffer,
        raygenShaderBindingOffset: VkDeviceSize,
        missShaderBindingTableBuffer: VkBuffer,
        missShaderBindingOffset: VkDeviceSize,
        missShaderBindingStride: VkDeviceSize,
        hitShaderBindingTableBuffer: VkBuffer,
        hitShaderBindingOffset: VkDeviceSize,
        hitShaderBindingStride: VkDeviceSize,
        callableShaderBindingTableBuffer: VkBuffer,
        callableShaderBindingOffset: VkDeviceSize,
        callableShaderBindingStride: VkDeviceSize,
        width: u32,
        height: u32,
        depth: u32,
    );
}
extern "C" {
    pub fn vkCreateRayTracingPipelinesNV(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkRayTracingPipelineCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetRayTracingShaderGroupHandlesKHR(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetRayTracingShaderGroupHandlesNV(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetAccelerationStructureHandleNV(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureNV,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdWriteAccelerationStructuresPropertiesNV(
        commandBuffer: VkCommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureNV,
        queryType: VkQueryType,
        queryPool: VkQueryPool,
        firstQuery: u32,
    );
}
extern "C" {
    pub fn vkCompileDeferredNV(device: VkDevice, pipeline: VkPipeline, shader: u32) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub representativeFragmentTest: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRepresentativeFragmentTestStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub representativeFragmentTestEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageViewImageFormatInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageViewType: VkImageViewType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFilterCubicImageViewImageFormatPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub filterCubic: VkBool32,
    pub filterCubicMinmax: VkBool32,
}
pub const VkQueueGlobalPriorityEXT_VK_QUEUE_GLOBAL_PRIORITY_LOW_EXT: VkQueueGlobalPriorityEXT = 128;
pub const VkQueueGlobalPriorityEXT_VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT: VkQueueGlobalPriorityEXT =
    256;
pub const VkQueueGlobalPriorityEXT_VK_QUEUE_GLOBAL_PRIORITY_HIGH_EXT: VkQueueGlobalPriorityEXT =
    512;
pub const VkQueueGlobalPriorityEXT_VK_QUEUE_GLOBAL_PRIORITY_REALTIME_EXT: VkQueueGlobalPriorityEXT =
    1024;
pub const VkQueueGlobalPriorityEXT_VK_QUEUE_GLOBAL_PRIORITY_MAX_ENUM_EXT: VkQueueGlobalPriorityEXT =
    2147483647;
pub type VkQueueGlobalPriorityEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueGlobalPriorityCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub globalPriority: VkQueueGlobalPriorityEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryHostPointerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
    pub pHostPointer: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryHostPointerPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minImportedHostPointerAlignment: VkDeviceSize,
}
pub type PFN_vkGetMemoryHostPointerPropertiesEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        pHostPointer: *const ::std::os::raw::c_void,
        pMemoryHostPointerProperties: *mut VkMemoryHostPointerPropertiesEXT,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetMemoryHostPointerPropertiesEXT(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        pHostPointer: *const ::std::os::raw::c_void,
        pMemoryHostPointerProperties: *mut VkMemoryHostPointerPropertiesEXT,
    ) -> VkResult;
}
pub type PFN_vkCmdWriteBufferMarkerAMD = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        marker: u32,
    ),
>;
extern "C" {
    pub fn vkCmdWriteBufferMarkerAMD(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        marker: u32,
    );
}
pub const VkPipelineCompilerControlFlagBitsAMD_VK_PIPELINE_COMPILER_CONTROL_FLAG_BITS_MAX_ENUM_AMD : VkPipelineCompilerControlFlagBitsAMD = 2147483647 ;
pub type VkPipelineCompilerControlFlagBitsAMD = ::std::os::raw::c_uint;
pub type VkPipelineCompilerControlFlagsAMD = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCompilerControlCreateInfoAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub compilerControlFlags: VkPipelineCompilerControlFlagsAMD,
}
pub const VkTimeDomainEXT_VK_TIME_DOMAIN_DEVICE_EXT: VkTimeDomainEXT = 0;
pub const VkTimeDomainEXT_VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT: VkTimeDomainEXT = 1;
pub const VkTimeDomainEXT_VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT: VkTimeDomainEXT = 2;
pub const VkTimeDomainEXT_VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT: VkTimeDomainEXT = 3;
pub const VkTimeDomainEXT_VK_TIME_DOMAIN_MAX_ENUM_EXT: VkTimeDomainEXT = 2147483647;
pub type VkTimeDomainEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCalibratedTimestampInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub timeDomain: VkTimeDomainEXT,
}
pub type PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pTimeDomainCount: *mut u32,
        pTimeDomains: *mut VkTimeDomainEXT,
    ) -> VkResult,
>;
pub type PFN_vkGetCalibratedTimestampsEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        timestampCount: u32,
        pTimestampInfos: *const VkCalibratedTimestampInfoEXT,
        pTimestamps: *mut u64,
        pMaxDeviation: *mut u64,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(
        physicalDevice: VkPhysicalDevice,
        pTimeDomainCount: *mut u32,
        pTimeDomains: *mut VkTimeDomainEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetCalibratedTimestampsEXT(
        device: VkDevice,
        timestampCount: u32,
        pTimestampInfos: *const VkCalibratedTimestampInfoEXT,
        pTimestamps: *mut u64,
        pMaxDeviation: *mut u64,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderCorePropertiesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderEngineCount: u32,
    pub shaderArraysPerEngineCount: u32,
    pub computeUnitsPerShaderArray: u32,
    pub simdPerComputeUnit: u32,
    pub wavefrontsPerSimd: u32,
    pub wavefrontSize: u32,
    pub sgprsPerSimd: u32,
    pub minSgprAllocation: u32,
    pub maxSgprAllocation: u32,
    pub sgprAllocationGranularity: u32,
    pub vgprsPerSimd: u32,
    pub minVgprAllocation: u32,
    pub maxVgprAllocation: u32,
    pub vgprAllocationGranularity: u32,
}
pub const VkMemoryOverallocationBehaviorAMD_VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD:
    VkMemoryOverallocationBehaviorAMD = 0;
pub const VkMemoryOverallocationBehaviorAMD_VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD:
    VkMemoryOverallocationBehaviorAMD = 1;
pub const VkMemoryOverallocationBehaviorAMD_VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD:
    VkMemoryOverallocationBehaviorAMD = 2;
pub const VkMemoryOverallocationBehaviorAMD_VK_MEMORY_OVERALLOCATION_BEHAVIOR_MAX_ENUM_AMD:
    VkMemoryOverallocationBehaviorAMD = 2147483647;
pub type VkMemoryOverallocationBehaviorAMD = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemoryOverallocationCreateInfoAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub overallocationBehavior: VkMemoryOverallocationBehaviorAMD,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxVertexAttribDivisor: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputBindingDivisorDescriptionEXT {
    pub binding: u32,
    pub divisor: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineVertexInputDivisorStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vertexBindingDivisorCount: u32,
    pub pVertexBindingDivisors: *const VkVertexInputBindingDivisorDescriptionEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub vertexAttributeInstanceRateDivisor: VkBool32,
    pub vertexAttributeInstanceRateZeroDivisor: VkBool32,
}
pub const VkPipelineCreationFeedbackFlagBitsEXT_VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT_EXT:
    VkPipelineCreationFeedbackFlagBitsEXT = 1;
pub const VkPipelineCreationFeedbackFlagBitsEXT_VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT_EXT : VkPipelineCreationFeedbackFlagBitsEXT = 2 ;
pub const VkPipelineCreationFeedbackFlagBitsEXT_VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT_EXT : VkPipelineCreationFeedbackFlagBitsEXT = 4 ;
pub const VkPipelineCreationFeedbackFlagBitsEXT_VK_PIPELINE_CREATION_FEEDBACK_FLAG_BITS_MAX_ENUM_EXT : VkPipelineCreationFeedbackFlagBitsEXT = 2147483647 ;
pub type VkPipelineCreationFeedbackFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkPipelineCreationFeedbackFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCreationFeedbackEXT {
    pub flags: VkPipelineCreationFeedbackFlagsEXT,
    pub duration: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCreationFeedbackCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pPipelineCreationFeedback: *mut VkPipelineCreationFeedbackEXT,
    pub pipelineStageCreationFeedbackCount: u32,
    pub pPipelineStageCreationFeedbacks: *mut VkPipelineCreationFeedbackEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub computeDerivativeGroupQuads: VkBool32,
    pub computeDerivativeGroupLinear: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMeshShaderFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub taskShader: VkBool32,
    pub meshShader: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMeshShaderPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxDrawMeshTasksCount: u32,
    pub maxTaskWorkGroupInvocations: u32,
    pub maxTaskWorkGroupSize: [u32; 3usize],
    pub maxTaskTotalMemorySize: u32,
    pub maxTaskOutputCount: u32,
    pub maxMeshWorkGroupInvocations: u32,
    pub maxMeshWorkGroupSize: [u32; 3usize],
    pub maxMeshTotalMemorySize: u32,
    pub maxMeshOutputVertices: u32,
    pub maxMeshOutputPrimitives: u32,
    pub maxMeshMultiviewViewCount: u32,
    pub meshOutputPerVertexGranularity: u32,
    pub meshOutputPerPrimitiveGranularity: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawMeshTasksIndirectCommandNV {
    pub taskCount: u32,
    pub firstTask: u32,
}
pub type PFN_vkCmdDrawMeshTasksNV = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, taskCount: u32, firstTask: u32),
>;
pub type PFN_vkCmdDrawMeshTasksIndirectNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDrawMeshTasksIndirectCountNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    ),
>;
extern "C" {
    pub fn vkCmdDrawMeshTasksNV(commandBuffer: VkCommandBuffer, taskCount: u32, firstTask: u32);
}
extern "C" {
    pub fn vkCmdDrawMeshTasksIndirectNV(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawMeshTasksIndirectCountNV(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentShaderBarycentric: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderImageFootprintFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageFootprint: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportExclusiveScissorStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub exclusiveScissorCount: u32,
    pub pExclusiveScissors: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExclusiveScissorFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exclusiveScissor: VkBool32,
}
pub type PFN_vkCmdSetExclusiveScissorNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstExclusiveScissor: u32,
        exclusiveScissorCount: u32,
        pExclusiveScissors: *const VkRect2D,
    ),
>;
extern "C" {
    pub fn vkCmdSetExclusiveScissorNV(
        commandBuffer: VkCommandBuffer,
        firstExclusiveScissor: u32,
        exclusiveScissorCount: u32,
        pExclusiveScissors: *const VkRect2D,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyCheckpointPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub checkpointExecutionStageMask: VkPipelineStageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCheckpointDataNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stage: VkPipelineStageFlagBits,
    pub pCheckpointMarker: *mut ::std::os::raw::c_void,
}
pub type PFN_vkCmdSetCheckpointNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCheckpointMarker: *const ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkGetQueueCheckpointDataNV = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut VkCheckpointDataNV,
    ),
>;
extern "C" {
    pub fn vkCmdSetCheckpointNV(
        commandBuffer: VkCommandBuffer,
        pCheckpointMarker: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn vkGetQueueCheckpointDataNV(
        queue: VkQueue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut VkCheckpointDataNV,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderIntegerFunctions2: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceConfigurationINTEL_T {
    _unused: [u8; 0],
}
pub type VkPerformanceConfigurationINTEL = *mut VkPerformanceConfigurationINTEL_T;
pub const VkPerformanceConfigurationTypeINTEL_VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL : VkPerformanceConfigurationTypeINTEL = 0 ;
pub const VkPerformanceConfigurationTypeINTEL_VK_PERFORMANCE_CONFIGURATION_TYPE_MAX_ENUM_INTEL:
    VkPerformanceConfigurationTypeINTEL = 2147483647;
pub type VkPerformanceConfigurationTypeINTEL = ::std::os::raw::c_uint;
pub const VkQueryPoolSamplingModeINTEL_VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL:
    VkQueryPoolSamplingModeINTEL = 0;
pub const VkQueryPoolSamplingModeINTEL_VK_QUERY_POOL_SAMPLING_MODE_MAX_ENUM_INTEL:
    VkQueryPoolSamplingModeINTEL = 2147483647;
pub type VkQueryPoolSamplingModeINTEL = ::std::os::raw::c_uint;
pub const VkPerformanceOverrideTypeINTEL_VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL:
    VkPerformanceOverrideTypeINTEL = 0;
pub const VkPerformanceOverrideTypeINTEL_VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL:
    VkPerformanceOverrideTypeINTEL = 1;
pub const VkPerformanceOverrideTypeINTEL_VK_PERFORMANCE_OVERRIDE_TYPE_MAX_ENUM_INTEL:
    VkPerformanceOverrideTypeINTEL = 2147483647;
pub type VkPerformanceOverrideTypeINTEL = ::std::os::raw::c_uint;
pub const VkPerformanceParameterTypeINTEL_VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL : VkPerformanceParameterTypeINTEL = 0 ;
pub const VkPerformanceParameterTypeINTEL_VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL : VkPerformanceParameterTypeINTEL = 1 ;
pub const VkPerformanceParameterTypeINTEL_VK_PERFORMANCE_PARAMETER_TYPE_MAX_ENUM_INTEL:
    VkPerformanceParameterTypeINTEL = 2147483647;
pub type VkPerformanceParameterTypeINTEL = ::std::os::raw::c_uint;
pub const VkPerformanceValueTypeINTEL_VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL:
    VkPerformanceValueTypeINTEL = 0;
pub const VkPerformanceValueTypeINTEL_VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL:
    VkPerformanceValueTypeINTEL = 1;
pub const VkPerformanceValueTypeINTEL_VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL:
    VkPerformanceValueTypeINTEL = 2;
pub const VkPerformanceValueTypeINTEL_VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL:
    VkPerformanceValueTypeINTEL = 3;
pub const VkPerformanceValueTypeINTEL_VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL:
    VkPerformanceValueTypeINTEL = 4;
pub const VkPerformanceValueTypeINTEL_VK_PERFORMANCE_VALUE_TYPE_MAX_ENUM_INTEL:
    VkPerformanceValueTypeINTEL = 2147483647;
pub type VkPerformanceValueTypeINTEL = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkPerformanceValueDataINTEL {
    pub value32: u32,
    pub value64: u64,
    pub valueFloat: f32,
    pub valueBool: VkBool32,
    pub valueString: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPerformanceValueINTEL {
    pub type_: VkPerformanceValueTypeINTEL,
    pub data: VkPerformanceValueDataINTEL,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInitializePerformanceApiInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPoolPerformanceQueryCreateInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub performanceCountersSampling: VkQueryPoolSamplingModeINTEL,
}
pub type VkQueryPoolCreateInfoINTEL = VkQueryPoolPerformanceQueryCreateInfoINTEL;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceMarkerInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub marker: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceStreamMarkerInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub marker: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceOverrideInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkPerformanceOverrideTypeINTEL,
    pub enable: VkBool32,
    pub parameter: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceConfigurationAcquireInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkPerformanceConfigurationTypeINTEL,
}
pub type PFN_vkInitializePerformanceApiINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInitializeInfo: *const VkInitializePerformanceApiInfoINTEL,
    ) -> VkResult,
>;
pub type PFN_vkUninitializePerformanceApiINTEL =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice)>;
pub type PFN_vkCmdSetPerformanceMarkerINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkPerformanceMarkerInfoINTEL,
    ) -> VkResult,
>;
pub type PFN_vkCmdSetPerformanceStreamMarkerINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkPerformanceStreamMarkerInfoINTEL,
    ) -> VkResult,
>;
pub type PFN_vkCmdSetPerformanceOverrideINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pOverrideInfo: *const VkPerformanceOverrideInfoINTEL,
    ) -> VkResult,
>;
pub type PFN_vkAcquirePerformanceConfigurationINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAcquireInfo: *const VkPerformanceConfigurationAcquireInfoINTEL,
        pConfiguration: *mut VkPerformanceConfigurationINTEL,
    ) -> VkResult,
>;
pub type PFN_vkReleasePerformanceConfigurationINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        configuration: VkPerformanceConfigurationINTEL,
    ) -> VkResult,
>;
pub type PFN_vkQueueSetPerformanceConfigurationINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        configuration: VkPerformanceConfigurationINTEL,
    ) -> VkResult,
>;
pub type PFN_vkGetPerformanceParameterINTEL = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        parameter: VkPerformanceParameterTypeINTEL,
        pValue: *mut VkPerformanceValueINTEL,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkInitializePerformanceApiINTEL(
        device: VkDevice,
        pInitializeInfo: *const VkInitializePerformanceApiInfoINTEL,
    ) -> VkResult;
}
extern "C" {
    pub fn vkUninitializePerformanceApiINTEL(device: VkDevice);
}
extern "C" {
    pub fn vkCmdSetPerformanceMarkerINTEL(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkPerformanceMarkerInfoINTEL,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdSetPerformanceStreamMarkerINTEL(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkPerformanceStreamMarkerInfoINTEL,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdSetPerformanceOverrideINTEL(
        commandBuffer: VkCommandBuffer,
        pOverrideInfo: *const VkPerformanceOverrideInfoINTEL,
    ) -> VkResult;
}
extern "C" {
    pub fn vkAcquirePerformanceConfigurationINTEL(
        device: VkDevice,
        pAcquireInfo: *const VkPerformanceConfigurationAcquireInfoINTEL,
        pConfiguration: *mut VkPerformanceConfigurationINTEL,
    ) -> VkResult;
}
extern "C" {
    pub fn vkReleasePerformanceConfigurationINTEL(
        device: VkDevice,
        configuration: VkPerformanceConfigurationINTEL,
    ) -> VkResult;
}
extern "C" {
    pub fn vkQueueSetPerformanceConfigurationINTEL(
        queue: VkQueue,
        configuration: VkPerformanceConfigurationINTEL,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPerformanceParameterINTEL(
        device: VkDevice,
        parameter: VkPerformanceParameterTypeINTEL,
        pValue: *mut VkPerformanceValueINTEL,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePCIBusInfoPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pciDomain: u32,
    pub pciBus: u32,
    pub pciDevice: u32,
    pub pciFunction: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayNativeHdrSurfaceCapabilitiesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub localDimmingSupport: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainDisplayNativeHdrCreateInfoAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub localDimmingEnable: VkBool32,
}
pub type PFN_vkSetLocalDimmingAMD = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, swapChain: VkSwapchainKHR, localDimmingEnable: VkBool32),
>;
extern "C" {
    pub fn vkSetLocalDimmingAMD(
        device: VkDevice,
        swapChain: VkSwapchainKHR,
        localDimmingEnable: VkBool32,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentDensityMap: VkBool32,
    pub fragmentDensityMapDynamic: VkBool32,
    pub fragmentDensityMapNonSubsampledImages: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minFragmentDensityTexelSize: VkExtent2D,
    pub maxFragmentDensityTexelSize: VkExtent2D,
    pub fragmentDensityInvocations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassFragmentDensityMapCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fragmentDensityMapAttachment: VkAttachmentReference,
}
pub type VkPhysicalDeviceScalarBlockLayoutFeaturesEXT = VkPhysicalDeviceScalarBlockLayoutFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubgroupSizeControlFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subgroupSizeControl: VkBool32,
    pub computeFullSubgroups: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubgroupSizeControlPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minSubgroupSize: u32,
    pub maxSubgroupSize: u32,
    pub maxComputeWorkgroupSubgroups: u32,
    pub requiredSubgroupSizeStages: VkShaderStageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub requiredSubgroupSize: u32,
}
pub const VkShaderCorePropertiesFlagBitsAMD_VK_SHADER_CORE_PROPERTIES_FLAG_BITS_MAX_ENUM_AMD:
    VkShaderCorePropertiesFlagBitsAMD = 2147483647;
pub type VkShaderCorePropertiesFlagBitsAMD = ::std::os::raw::c_uint;
pub type VkShaderCorePropertiesFlagsAMD = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderCoreProperties2AMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderCoreFeatures: VkShaderCorePropertiesFlagsAMD,
    pub activeComputeUnitCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCoherentMemoryFeaturesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceCoherentMemory: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderImageInt64Atomics: VkBool32,
    pub sparseImageInt64Atomics: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryBudgetPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub heapBudget: [VkDeviceSize; 16usize],
    pub heapUsage: [VkDeviceSize; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryPriorityFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryPriority: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryPriorityAllocateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub priority: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub dedicatedAllocationImageAliasing: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
}
pub type VkPhysicalDeviceBufferAddressFeaturesEXT = VkPhysicalDeviceBufferDeviceAddressFeaturesEXT;
pub type VkBufferDeviceAddressInfoEXT = VkBufferDeviceAddressInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferDeviceAddressCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceAddress: VkDeviceAddress,
}
pub type PFN_vkGetBufferDeviceAddressEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress,
>;
extern "C" {
    pub fn vkGetBufferDeviceAddressEXT(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress;
}
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_VALIDATION_BIT_EXT: VkToolPurposeFlagBitsEXT = 1;
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_PROFILING_BIT_EXT: VkToolPurposeFlagBitsEXT = 2;
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_TRACING_BIT_EXT: VkToolPurposeFlagBitsEXT = 4;
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT_EXT:
    VkToolPurposeFlagBitsEXT = 8;
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT_EXT:
    VkToolPurposeFlagBitsEXT = 16;
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT:
    VkToolPurposeFlagBitsEXT = 32;
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT: VkToolPurposeFlagBitsEXT =
    64;
pub const VkToolPurposeFlagBitsEXT_VK_TOOL_PURPOSE_FLAG_BITS_MAX_ENUM_EXT:
    VkToolPurposeFlagBitsEXT = 2147483647;
pub type VkToolPurposeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkToolPurposeFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceToolPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub name: [::std::os::raw::c_char; 256usize],
    pub version: [::std::os::raw::c_char; 256usize],
    pub purposes: VkToolPurposeFlagsEXT,
    pub description: [::std::os::raw::c_char; 256usize],
    pub layer: [::std::os::raw::c_char; 256usize],
}
pub type PFN_vkGetPhysicalDeviceToolPropertiesEXT = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pToolCount: *mut u32,
        pToolProperties: *mut VkPhysicalDeviceToolPropertiesEXT,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceToolPropertiesEXT(
        physicalDevice: VkPhysicalDevice,
        pToolCount: *mut u32,
        pToolProperties: *mut VkPhysicalDeviceToolPropertiesEXT,
    ) -> VkResult;
}
pub type VkImageStencilUsageCreateInfoEXT = VkImageStencilUsageCreateInfo;
pub const VkValidationFeatureEnableEXT_VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT:
    VkValidationFeatureEnableEXT = 0;
pub const VkValidationFeatureEnableEXT_VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT : VkValidationFeatureEnableEXT = 1 ;
pub const VkValidationFeatureEnableEXT_VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT:
    VkValidationFeatureEnableEXT = 2;
pub const VkValidationFeatureEnableEXT_VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT:
    VkValidationFeatureEnableEXT = 3;
pub const VkValidationFeatureEnableEXT_VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT : VkValidationFeatureEnableEXT = 4 ;
pub const VkValidationFeatureEnableEXT_VK_VALIDATION_FEATURE_ENABLE_MAX_ENUM_EXT:
    VkValidationFeatureEnableEXT = 2147483647;
pub type VkValidationFeatureEnableEXT = ::std::os::raw::c_uint;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_ALL_EXT:
    VkValidationFeatureDisableEXT = 0;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT:
    VkValidationFeatureDisableEXT = 1;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT:
    VkValidationFeatureDisableEXT = 2;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT:
    VkValidationFeatureDisableEXT = 3;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT:
    VkValidationFeatureDisableEXT = 4;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT:
    VkValidationFeatureDisableEXT = 5;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT:
    VkValidationFeatureDisableEXT = 6;
pub const VkValidationFeatureDisableEXT_VK_VALIDATION_FEATURE_DISABLE_MAX_ENUM_EXT:
    VkValidationFeatureDisableEXT = 2147483647;
pub type VkValidationFeatureDisableEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub enabledValidationFeatureCount: u32,
    pub pEnabledValidationFeatures: *const VkValidationFeatureEnableEXT,
    pub disabledValidationFeatureCount: u32,
    pub pDisabledValidationFeatures: *const VkValidationFeatureDisableEXT,
}
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_FLOAT16_NV: VkComponentTypeNV = 0;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_FLOAT32_NV: VkComponentTypeNV = 1;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_FLOAT64_NV: VkComponentTypeNV = 2;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_SINT8_NV: VkComponentTypeNV = 3;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_SINT16_NV: VkComponentTypeNV = 4;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_SINT32_NV: VkComponentTypeNV = 5;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_SINT64_NV: VkComponentTypeNV = 6;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_UINT8_NV: VkComponentTypeNV = 7;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_UINT16_NV: VkComponentTypeNV = 8;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_UINT32_NV: VkComponentTypeNV = 9;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_UINT64_NV: VkComponentTypeNV = 10;
pub const VkComponentTypeNV_VK_COMPONENT_TYPE_MAX_ENUM_NV: VkComponentTypeNV = 2147483647;
pub type VkComponentTypeNV = ::std::os::raw::c_uint;
pub const VkScopeNV_VK_SCOPE_DEVICE_NV: VkScopeNV = 1;
pub const VkScopeNV_VK_SCOPE_WORKGROUP_NV: VkScopeNV = 2;
pub const VkScopeNV_VK_SCOPE_SUBGROUP_NV: VkScopeNV = 3;
pub const VkScopeNV_VK_SCOPE_QUEUE_FAMILY_NV: VkScopeNV = 5;
pub const VkScopeNV_VK_SCOPE_MAX_ENUM_NV: VkScopeNV = 2147483647;
pub type VkScopeNV = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCooperativeMatrixPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub MSize: u32,
    pub NSize: u32,
    pub KSize: u32,
    pub AType: VkComponentTypeNV,
    pub BType: VkComponentTypeNV,
    pub CType: VkComponentTypeNV,
    pub DType: VkComponentTypeNV,
    pub scope: VkScopeNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCooperativeMatrixFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub cooperativeMatrix: VkBool32,
    pub cooperativeMatrixRobustBufferAccess: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCooperativeMatrixPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub cooperativeMatrixSupportedStages: VkShaderStageFlags,
}
pub type PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkCooperativeMatrixPropertiesNV,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkGetPhysicalDeviceCooperativeMatrixPropertiesNV(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkCooperativeMatrixPropertiesNV,
    ) -> VkResult;
}
pub const VkCoverageReductionModeNV_VK_COVERAGE_REDUCTION_MODE_MERGE_NV: VkCoverageReductionModeNV =
    0;
pub const VkCoverageReductionModeNV_VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV:
    VkCoverageReductionModeNV = 1;
pub const VkCoverageReductionModeNV_VK_COVERAGE_REDUCTION_MODE_MAX_ENUM_NV:
    VkCoverageReductionModeNV = 2147483647;
pub type VkCoverageReductionModeNV = ::std::os::raw::c_uint;
pub type VkPipelineCoverageReductionStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCoverageReductionModeFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub coverageReductionMode: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCoverageReductionStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCoverageReductionStateCreateFlagsNV,
    pub coverageReductionMode: VkCoverageReductionModeNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferMixedSamplesCombinationNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub coverageReductionMode: VkCoverageReductionModeNV,
    pub rasterizationSamples: VkSampleCountFlagBits,
    pub depthStencilSamples: VkSampleCountFlags,
    pub colorSamples: VkSampleCountFlags,
}
pub type PFN_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV =
    ::std::option::Option<
        unsafe extern "C" fn(
            physicalDevice: VkPhysicalDevice,
            pCombinationCount: *mut u32,
            pCombinations: *mut VkFramebufferMixedSamplesCombinationNV,
        ) -> VkResult,
    >;
extern "C" {
    pub fn vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(
        physicalDevice: VkPhysicalDevice,
        pCombinationCount: *mut u32,
        pCombinations: *mut VkFramebufferMixedSamplesCombinationNV,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentShaderSampleInterlock: VkBool32,
    pub fragmentShaderPixelInterlock: VkBool32,
    pub fragmentShaderShadingRateInterlock: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub ycbcrImageArrays: VkBool32,
}
pub type VkHeadlessSurfaceCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkHeadlessSurfaceCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkHeadlessSurfaceCreateFlagsEXT,
}
pub type PFN_vkCreateHeadlessSurfaceEXT = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkHeadlessSurfaceCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkCreateHeadlessSurfaceEXT(
        instance: VkInstance,
        pCreateInfo: *const VkHeadlessSurfaceCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult;
}
pub const VkLineRasterizationModeEXT_VK_LINE_RASTERIZATION_MODE_DEFAULT_EXT:
    VkLineRasterizationModeEXT = 0;
pub const VkLineRasterizationModeEXT_VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT:
    VkLineRasterizationModeEXT = 1;
pub const VkLineRasterizationModeEXT_VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT:
    VkLineRasterizationModeEXT = 2;
pub const VkLineRasterizationModeEXT_VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT:
    VkLineRasterizationModeEXT = 3;
pub const VkLineRasterizationModeEXT_VK_LINE_RASTERIZATION_MODE_MAX_ENUM_EXT:
    VkLineRasterizationModeEXT = 2147483647;
pub type VkLineRasterizationModeEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLineRasterizationFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rectangularLines: VkBool32,
    pub bresenhamLines: VkBool32,
    pub smoothLines: VkBool32,
    pub stippledRectangularLines: VkBool32,
    pub stippledBresenhamLines: VkBool32,
    pub stippledSmoothLines: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLineRasterizationPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub lineSubPixelPrecisionBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationLineStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub lineRasterizationMode: VkLineRasterizationModeEXT,
    pub stippledLineEnable: VkBool32,
    pub lineStippleFactor: u32,
    pub lineStipplePattern: u16,
}
pub type PFN_vkCmdSetLineStippleEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        lineStippleFactor: u32,
        lineStipplePattern: u16,
    ),
>;
extern "C" {
    pub fn vkCmdSetLineStippleEXT(
        commandBuffer: VkCommandBuffer,
        lineStippleFactor: u32,
        lineStipplePattern: u16,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderBufferFloat32Atomics: VkBool32,
    pub shaderBufferFloat32AtomicAdd: VkBool32,
    pub shaderBufferFloat64Atomics: VkBool32,
    pub shaderBufferFloat64AtomicAdd: VkBool32,
    pub shaderSharedFloat32Atomics: VkBool32,
    pub shaderSharedFloat32AtomicAdd: VkBool32,
    pub shaderSharedFloat64Atomics: VkBool32,
    pub shaderSharedFloat64AtomicAdd: VkBool32,
    pub shaderImageFloat32Atomics: VkBool32,
    pub shaderImageFloat32AtomicAdd: VkBool32,
    pub sparseImageFloat32Atomics: VkBool32,
    pub sparseImageFloat32AtomicAdd: VkBool32,
}
pub type VkPhysicalDeviceHostQueryResetFeaturesEXT = VkPhysicalDeviceHostQueryResetFeatures;
pub type PFN_vkResetQueryPoolEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    ),
>;
extern "C" {
    pub fn vkResetQueryPoolEXT(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub indexTypeUint8: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub extendedDynamicState: VkBool32,
}
pub type PFN_vkCmdSetCullModeEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, cullMode: VkCullModeFlags),
>;
pub type PFN_vkCmdSetFrontFaceEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, frontFace: VkFrontFace),
>;
pub type PFN_vkCmdSetPrimitiveTopologyEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, primitiveTopology: VkPrimitiveTopology),
>;
pub type PFN_vkCmdSetViewportWithCountEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        viewportCount: u32,
        pViewports: *const VkViewport,
    ),
>;
pub type PFN_vkCmdSetScissorWithCountEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    ),
>;
pub type PFN_vkCmdBindVertexBuffers2EXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
        pSizes: *const VkDeviceSize,
        pStrides: *const VkDeviceSize,
    ),
>;
pub type PFN_vkCmdSetDepthTestEnableEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthTestEnable: VkBool32),
>;
pub type PFN_vkCmdSetDepthWriteEnableEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthWriteEnable: VkBool32),
>;
pub type PFN_vkCmdSetDepthCompareOpEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthCompareOp: VkCompareOp),
>;
pub type PFN_vkCmdSetDepthBoundsTestEnableEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthBoundsTestEnable: VkBool32),
>;
pub type PFN_vkCmdSetStencilTestEnableEXT = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, stencilTestEnable: VkBool32),
>;
pub type PFN_vkCmdSetStencilOpEXT = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        failOp: VkStencilOp,
        passOp: VkStencilOp,
        depthFailOp: VkStencilOp,
        compareOp: VkCompareOp,
    ),
>;
extern "C" {
    pub fn vkCmdSetCullModeEXT(commandBuffer: VkCommandBuffer, cullMode: VkCullModeFlags);
}
extern "C" {
    pub fn vkCmdSetFrontFaceEXT(commandBuffer: VkCommandBuffer, frontFace: VkFrontFace);
}
extern "C" {
    pub fn vkCmdSetPrimitiveTopologyEXT(
        commandBuffer: VkCommandBuffer,
        primitiveTopology: VkPrimitiveTopology,
    );
}
extern "C" {
    pub fn vkCmdSetViewportWithCountEXT(
        commandBuffer: VkCommandBuffer,
        viewportCount: u32,
        pViewports: *const VkViewport,
    );
}
extern "C" {
    pub fn vkCmdSetScissorWithCountEXT(
        commandBuffer: VkCommandBuffer,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    );
}
extern "C" {
    pub fn vkCmdBindVertexBuffers2EXT(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
        pSizes: *const VkDeviceSize,
        pStrides: *const VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdSetDepthTestEnableEXT(commandBuffer: VkCommandBuffer, depthTestEnable: VkBool32);
}
extern "C" {
    pub fn vkCmdSetDepthWriteEnableEXT(commandBuffer: VkCommandBuffer, depthWriteEnable: VkBool32);
}
extern "C" {
    pub fn vkCmdSetDepthCompareOpEXT(commandBuffer: VkCommandBuffer, depthCompareOp: VkCompareOp);
}
extern "C" {
    pub fn vkCmdSetDepthBoundsTestEnableEXT(
        commandBuffer: VkCommandBuffer,
        depthBoundsTestEnable: VkBool32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilTestEnableEXT(
        commandBuffer: VkCommandBuffer,
        stencilTestEnable: VkBool32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilOpEXT(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        failOp: VkStencilOp,
        passOp: VkStencilOp,
        depthFailOp: VkStencilOp,
        compareOp: VkCompareOp,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderDemoteToHelperInvocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsLayoutNV_T {
    _unused: [u8; 0],
}
pub type VkIndirectCommandsLayoutNV = *mut VkIndirectCommandsLayoutNV_T;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV:
    VkIndirectCommandsTokenTypeNV = 0;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV:
    VkIndirectCommandsTokenTypeNV = 1;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV:
    VkIndirectCommandsTokenTypeNV = 2;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV:
    VkIndirectCommandsTokenTypeNV = 3;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV:
    VkIndirectCommandsTokenTypeNV = 4;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV:
    VkIndirectCommandsTokenTypeNV = 5;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV:
    VkIndirectCommandsTokenTypeNV = 6;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV:
    VkIndirectCommandsTokenTypeNV = 7;
pub const VkIndirectCommandsTokenTypeNV_VK_INDIRECT_COMMANDS_TOKEN_TYPE_MAX_ENUM_NV:
    VkIndirectCommandsTokenTypeNV = 2147483647;
pub type VkIndirectCommandsTokenTypeNV = ::std::os::raw::c_uint;
pub const VkIndirectStateFlagBitsNV_VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV:
    VkIndirectStateFlagBitsNV = 1;
pub const VkIndirectStateFlagBitsNV_VK_INDIRECT_STATE_FLAG_BITS_MAX_ENUM_NV:
    VkIndirectStateFlagBitsNV = 2147483647;
pub type VkIndirectStateFlagBitsNV = ::std::os::raw::c_uint;
pub type VkIndirectStateFlagsNV = VkFlags;
pub const VkIndirectCommandsLayoutUsageFlagBitsNV_VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 1 ;
pub const VkIndirectCommandsLayoutUsageFlagBitsNV_VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 2 ;
pub const VkIndirectCommandsLayoutUsageFlagBitsNV_VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 4 ;
pub const VkIndirectCommandsLayoutUsageFlagBitsNV_VK_INDIRECT_COMMANDS_LAYOUT_USAGE_FLAG_BITS_MAX_ENUM_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 2147483647 ;
pub type VkIndirectCommandsLayoutUsageFlagBitsNV = ::std::os::raw::c_uint;
pub type VkIndirectCommandsLayoutUsageFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxGraphicsShaderGroupCount: u32,
    pub maxIndirectSequenceCount: u32,
    pub maxIndirectCommandsTokenCount: u32,
    pub maxIndirectCommandsStreamCount: u32,
    pub maxIndirectCommandsTokenOffset: u32,
    pub maxIndirectCommandsStreamStride: u32,
    pub minSequencesCountBufferOffsetAlignment: u32,
    pub minSequencesIndexBufferOffsetAlignment: u32,
    pub minIndirectCommandsBufferOffsetAlignment: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceGeneratedCommands: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsShaderGroupCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub pVertexInputState: *const VkPipelineVertexInputStateCreateInfo,
    pub pTessellationState: *const VkPipelineTessellationStateCreateInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsPipelineShaderGroupsCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub groupCount: u32,
    pub pGroups: *const VkGraphicsShaderGroupCreateInfoNV,
    pub pipelineCount: u32,
    pub pPipelines: *const VkPipeline,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindShaderGroupIndirectCommandNV {
    pub groupIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindIndexBufferIndirectCommandNV {
    pub bufferAddress: VkDeviceAddress,
    pub size: u32,
    pub indexType: VkIndexType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindVertexBufferIndirectCommandNV {
    pub bufferAddress: VkDeviceAddress,
    pub size: u32,
    pub stride: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSetStateFlagsIndirectCommandNV {
    pub data: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsStreamNV {
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsLayoutTokenNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub tokenType: VkIndirectCommandsTokenTypeNV,
    pub stream: u32,
    pub offset: u32,
    pub vertexBindingUnit: u32,
    pub vertexDynamicStride: VkBool32,
    pub pushconstantPipelineLayout: VkPipelineLayout,
    pub pushconstantShaderStageFlags: VkShaderStageFlags,
    pub pushconstantOffset: u32,
    pub pushconstantSize: u32,
    pub indirectStateFlags: VkIndirectStateFlagsNV,
    pub indexTypeCount: u32,
    pub pIndexTypes: *const VkIndexType,
    pub pIndexTypeValues: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsLayoutCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkIndirectCommandsLayoutUsageFlagsNV,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub tokenCount: u32,
    pub pTokens: *const VkIndirectCommandsLayoutTokenNV,
    pub streamCount: u32,
    pub pStreamStrides: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeneratedCommandsInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub pipeline: VkPipeline,
    pub indirectCommandsLayout: VkIndirectCommandsLayoutNV,
    pub streamCount: u32,
    pub pStreams: *const VkIndirectCommandsStreamNV,
    pub sequencesCount: u32,
    pub preprocessBuffer: VkBuffer,
    pub preprocessOffset: VkDeviceSize,
    pub preprocessSize: VkDeviceSize,
    pub sequencesCountBuffer: VkBuffer,
    pub sequencesCountOffset: VkDeviceSize,
    pub sequencesIndexBuffer: VkBuffer,
    pub sequencesIndexOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeneratedCommandsMemoryRequirementsInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub pipeline: VkPipeline,
    pub indirectCommandsLayout: VkIndirectCommandsLayoutNV,
    pub maxSequencesCount: u32,
}
pub type PFN_vkGetGeneratedCommandsMemoryRequirementsNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkGeneratedCommandsMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    ),
>;
pub type PFN_vkCmdPreprocessGeneratedCommandsNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pGeneratedCommandsInfo: *const VkGeneratedCommandsInfoNV,
    ),
>;
pub type PFN_vkCmdExecuteGeneratedCommandsNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        isPreprocessed: VkBool32,
        pGeneratedCommandsInfo: *const VkGeneratedCommandsInfoNV,
    ),
>;
pub type PFN_vkCmdBindPipelineShaderGroupNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
        groupIndex: u32,
    ),
>;
pub type PFN_vkCreateIndirectCommandsLayoutNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkIndirectCommandsLayoutCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pIndirectCommandsLayout: *mut VkIndirectCommandsLayoutNV,
    ) -> VkResult,
>;
pub type PFN_vkDestroyIndirectCommandsLayoutNV = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        indirectCommandsLayout: VkIndirectCommandsLayoutNV,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
extern "C" {
    pub fn vkGetGeneratedCommandsMemoryRequirementsNV(
        device: VkDevice,
        pInfo: *const VkGeneratedCommandsMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkCmdPreprocessGeneratedCommandsNV(
        commandBuffer: VkCommandBuffer,
        pGeneratedCommandsInfo: *const VkGeneratedCommandsInfoNV,
    );
}
extern "C" {
    pub fn vkCmdExecuteGeneratedCommandsNV(
        commandBuffer: VkCommandBuffer,
        isPreprocessed: VkBool32,
        pGeneratedCommandsInfo: *const VkGeneratedCommandsInfoNV,
    );
}
extern "C" {
    pub fn vkCmdBindPipelineShaderGroupNV(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
        groupIndex: u32,
    );
}
extern "C" {
    pub fn vkCreateIndirectCommandsLayoutNV(
        device: VkDevice,
        pCreateInfo: *const VkIndirectCommandsLayoutCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pIndirectCommandsLayout: *mut VkIndirectCommandsLayoutNV,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyIndirectCommandsLayoutNV(
        device: VkDevice,
        indirectCommandsLayout: VkIndirectCommandsLayoutNV,
        pAllocator: *const VkAllocationCallbacks,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub texelBufferAlignment: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageTexelBufferOffsetAlignmentBytes: VkDeviceSize,
    pub storageTexelBufferOffsetSingleTexelAlignment: VkBool32,
    pub uniformTexelBufferOffsetAlignmentBytes: VkDeviceSize,
    pub uniformTexelBufferOffsetSingleTexelAlignment: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassTransformBeginInfoQCOM {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub transform: VkSurfaceTransformFlagBitsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub transform: VkSurfaceTransformFlagBitsKHR,
    pub renderArea: VkRect2D,
}
pub const VkDeviceMemoryReportEventTypeEXT_VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT:
    VkDeviceMemoryReportEventTypeEXT = 0;
pub const VkDeviceMemoryReportEventTypeEXT_VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT:
    VkDeviceMemoryReportEventTypeEXT = 1;
pub const VkDeviceMemoryReportEventTypeEXT_VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT:
    VkDeviceMemoryReportEventTypeEXT = 2;
pub const VkDeviceMemoryReportEventTypeEXT_VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT:
    VkDeviceMemoryReportEventTypeEXT = 3;
pub const VkDeviceMemoryReportEventTypeEXT_VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT : VkDeviceMemoryReportEventTypeEXT = 4 ;
pub const VkDeviceMemoryReportEventTypeEXT_VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_MAX_ENUM_EXT:
    VkDeviceMemoryReportEventTypeEXT = 2147483647;
pub type VkDeviceMemoryReportEventTypeEXT = ::std::os::raw::c_uint;
pub type VkDeviceMemoryReportFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDeviceMemoryReportFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceMemoryReport: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemoryReportCallbackDataEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceMemoryReportFlagsEXT,
    pub type_: VkDeviceMemoryReportEventTypeEXT,
    pub memoryObjectId: u64,
    pub size: VkDeviceSize,
    pub objectType: VkObjectType,
    pub objectHandle: u64,
    pub heapIndex: u32,
}
pub type PFN_vkDeviceMemoryReportCallbackEXT = ::std::option::Option<
    unsafe extern "C" fn(
        pCallbackData: *const VkDeviceMemoryReportCallbackDataEXT,
        pUserData: *mut ::std::os::raw::c_void,
    ),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceDeviceMemoryReportCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceMemoryReportFlagsEXT,
    pub pfnUserCallback: PFN_vkDeviceMemoryReportCallbackEXT,
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRobustness2FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub robustBufferAccess2: VkBool32,
    pub robustImageAccess2: VkBool32,
    pub nullDescriptor: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRobustness2PropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub robustStorageBufferAccessSizeAlignment: VkDeviceSize,
    pub robustUniformBufferAccessSizeAlignment: VkDeviceSize,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkSamplerCustomBorderColorCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub customBorderColor: VkClearColorValue,
    pub format: VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCustomBorderColorPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxCustomBorderColorSamplers: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCustomBorderColorFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub customBorderColors: VkBool32,
    pub customBorderColorWithoutFormat: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPrivateDataSlotEXT_T {
    _unused: [u8; 0],
}
pub type VkPrivateDataSlotEXT = *mut VkPrivateDataSlotEXT_T;
pub const VkPrivateDataSlotCreateFlagBitsEXT_VK_PRIVATE_DATA_SLOT_CREATE_FLAG_BITS_MAX_ENUM_EXT:
    VkPrivateDataSlotCreateFlagBitsEXT = 2147483647;
pub type VkPrivateDataSlotCreateFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkPrivateDataSlotCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePrivateDataFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub privateData: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDevicePrivateDataCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub privateDataSlotRequestCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPrivateDataSlotCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPrivateDataSlotCreateFlagsEXT,
}
pub type PFN_vkCreatePrivateDataSlotEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPrivateDataSlotCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pPrivateDataSlot: *mut VkPrivateDataSlotEXT,
    ) -> VkResult,
>;
pub type PFN_vkDestroyPrivateDataSlotEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        privateDataSlot: VkPrivateDataSlotEXT,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkSetPrivateDataEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlotEXT,
        data: u64,
    ) -> VkResult,
>;
pub type PFN_vkGetPrivateDataEXT = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlotEXT,
        pData: *mut u64,
    ),
>;
extern "C" {
    pub fn vkCreatePrivateDataSlotEXT(
        device: VkDevice,
        pCreateInfo: *const VkPrivateDataSlotCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pPrivateDataSlot: *mut VkPrivateDataSlotEXT,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyPrivateDataSlotEXT(
        device: VkDevice,
        privateDataSlot: VkPrivateDataSlotEXT,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkSetPrivateDataEXT(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlotEXT,
        data: u64,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPrivateDataEXT(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlotEXT,
        pData: *mut u64,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pipelineCreationCacheControl: VkBool32,
}
pub const VkDeviceDiagnosticsConfigFlagBitsNV_VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV : VkDeviceDiagnosticsConfigFlagBitsNV = 1 ;
pub const VkDeviceDiagnosticsConfigFlagBitsNV_VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV : VkDeviceDiagnosticsConfigFlagBitsNV = 2 ;
pub const VkDeviceDiagnosticsConfigFlagBitsNV_VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV : VkDeviceDiagnosticsConfigFlagBitsNV = 4 ;
pub const VkDeviceDiagnosticsConfigFlagBitsNV_VK_DEVICE_DIAGNOSTICS_CONFIG_FLAG_BITS_MAX_ENUM_NV:
    VkDeviceDiagnosticsConfigFlagBitsNV = 2147483647;
pub type VkDeviceDiagnosticsConfigFlagBitsNV = ::std::os::raw::c_uint;
pub type VkDeviceDiagnosticsConfigFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDiagnosticsConfigFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub diagnosticsConfig: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceDiagnosticsConfigCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceDiagnosticsConfigFlagsNV,
}
pub const VkFragmentShadingRateTypeNV_VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV:
    VkFragmentShadingRateTypeNV = 0;
pub const VkFragmentShadingRateTypeNV_VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV:
    VkFragmentShadingRateTypeNV = 1;
pub const VkFragmentShadingRateTypeNV_VK_FRAGMENT_SHADING_RATE_TYPE_MAX_ENUM_NV:
    VkFragmentShadingRateTypeNV = 2147483647;
pub type VkFragmentShadingRateTypeNV = ::std::os::raw::c_uint;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 0;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV:
    VkFragmentShadingRateNV = 1;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV:
    VkFragmentShadingRateNV = 4;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV:
    VkFragmentShadingRateNV = 5;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV:
    VkFragmentShadingRateNV = 6;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV:
    VkFragmentShadingRateNV = 9;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV:
    VkFragmentShadingRateNV = 10;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 11;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 12;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 13;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 14;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV:
    VkFragmentShadingRateNV = 15;
pub const VkFragmentShadingRateNV_VK_FRAGMENT_SHADING_RATE_MAX_ENUM_NV: VkFragmentShadingRateNV =
    2147483647;
pub type VkFragmentShadingRateNV = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentShadingRateEnums: VkBool32,
    pub supersampleFragmentShadingRates: VkBool32,
    pub noInvocationFragmentShadingRates: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxFragmentShadingRateInvocationCount: VkSampleCountFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub shadingRateType: VkFragmentShadingRateTypeNV,
    pub shadingRate: VkFragmentShadingRateNV,
    pub combinerOps: [VkFragmentShadingRateCombinerOpKHR; 2usize],
}
pub type PFN_vkCmdSetFragmentShadingRateEnumNV = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        shadingRate: VkFragmentShadingRateNV,
        combinerOps: *const VkFragmentShadingRateCombinerOpKHR,
    ),
>;
extern "C" {
    pub fn vkCmdSetFragmentShadingRateEnumNV(
        commandBuffer: VkCommandBuffer,
        shadingRate: VkFragmentShadingRateNV,
        combinerOps: *const VkFragmentShadingRateCombinerOpKHR,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMap2FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentDensityMapDeferred: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subsampledLoads: VkBool32,
    pub subsampledCoarseReconstructionEarlyAccess: VkBool32,
    pub maxSubsampledArrayLayers: u32,
    pub maxDescriptorSetSubsampledSamplers: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyCommandTransformInfoQCOM {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub transform: VkSurfaceTransformFlagBitsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageRobustnessFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub robustImageAccess: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice4444FormatsFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub formatA4R4G4B4: VkBool32,
    pub formatA4B4G4R4: VkBool32,
}
pub type PFN_vkAcquireWinrtDisplayNV = ::std::option::Option<
    unsafe extern "C" fn(physicalDevice: VkPhysicalDevice, display: VkDisplayKHR) -> VkResult,
>;
pub type PFN_vkGetWinrtDisplayNV = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        deviceRelativeId: u32,
        pDisplay: *mut VkDisplayKHR,
    ) -> VkResult,
>;
extern "C" {
    pub fn vkAcquireWinrtDisplayNV(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetWinrtDisplayNV(
        physicalDevice: VkPhysicalDevice,
        deviceRelativeId: u32,
        pDisplay: *mut VkDisplayKHR,
    ) -> VkResult;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub mutableDescriptorType: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMutableDescriptorTypeListVALVE {
    pub descriptorTypeCount: u32,
    pub pDescriptorTypes: *const VkDescriptorType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMutableDescriptorTypeCreateInfoVALVE {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub mutableDescriptorTypeListCount: u32,
    pub pMutableDescriptorTypeLists: *const VkMutableDescriptorTypeListVALVE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureKHR_T {
    _unused: [u8; 0],
}
pub type VkAccelerationStructureKHR = *mut VkAccelerationStructureKHR_T;
pub const VkBuildAccelerationStructureModeKHR_VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR:
    VkBuildAccelerationStructureModeKHR = 0;
pub const VkBuildAccelerationStructureModeKHR_VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR:
    VkBuildAccelerationStructureModeKHR = 1;
pub const VkBuildAccelerationStructureModeKHR_VK_BUILD_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR:
    VkBuildAccelerationStructureModeKHR = 2147483647;
pub type VkBuildAccelerationStructureModeKHR = ::std::os::raw::c_uint;
pub const VkAccelerationStructureBuildTypeKHR_VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR:
    VkAccelerationStructureBuildTypeKHR = 0;
pub const VkAccelerationStructureBuildTypeKHR_VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR:
    VkAccelerationStructureBuildTypeKHR = 1;
pub const VkAccelerationStructureBuildTypeKHR_VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR : VkAccelerationStructureBuildTypeKHR = 2 ;
pub const VkAccelerationStructureBuildTypeKHR_VK_ACCELERATION_STRUCTURE_BUILD_TYPE_MAX_ENUM_KHR:
    VkAccelerationStructureBuildTypeKHR = 2147483647;
pub type VkAccelerationStructureBuildTypeKHR = ::std::os::raw::c_uint;
pub const VkAccelerationStructureCompatibilityKHR_VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR : VkAccelerationStructureCompatibilityKHR = 0 ;
pub const VkAccelerationStructureCompatibilityKHR_VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR : VkAccelerationStructureCompatibilityKHR = 1 ;
pub const VkAccelerationStructureCompatibilityKHR_VK_ACCELERATION_STRUCTURE_COMPATIBILITY_MAX_ENUM_KHR : VkAccelerationStructureCompatibilityKHR = 2147483647 ;
pub type VkAccelerationStructureCompatibilityKHR = ::std::os::raw::c_uint;
pub const VkAccelerationStructureCreateFlagBitsKHR_VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR : VkAccelerationStructureCreateFlagBitsKHR = 1 ;
pub const VkAccelerationStructureCreateFlagBitsKHR_VK_ACCELERATION_STRUCTURE_CREATE_FLAG_BITS_MAX_ENUM_KHR : VkAccelerationStructureCreateFlagBitsKHR = 2147483647 ;
pub type VkAccelerationStructureCreateFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkAccelerationStructureCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkDeviceOrHostAddressKHR {
    pub deviceAddress: VkDeviceAddress,
    pub hostAddress: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkDeviceOrHostAddressConstKHR {
    pub deviceAddress: VkDeviceAddress,
    pub hostAddress: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureBuildRangeInfoKHR {
    pub primitiveCount: u32,
    pub primitiveOffset: u32,
    pub firstVertex: u32,
    pub transformOffset: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryTrianglesDataKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vertexFormat: VkFormat,
    pub vertexData: VkDeviceOrHostAddressConstKHR,
    pub vertexStride: VkDeviceSize,
    pub maxVertex: u32,
    pub indexType: VkIndexType,
    pub indexData: VkDeviceOrHostAddressConstKHR,
    pub transformData: VkDeviceOrHostAddressConstKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryAabbsDataKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub data: VkDeviceOrHostAddressConstKHR,
    pub stride: VkDeviceSize,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryInstancesDataKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub arrayOfPointers: VkBool32,
    pub data: VkDeviceOrHostAddressConstKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkAccelerationStructureGeometryDataKHR {
    pub triangles: VkAccelerationStructureGeometryTrianglesDataKHR,
    pub aabbs: VkAccelerationStructureGeometryAabbsDataKHR,
    pub instances: VkAccelerationStructureGeometryInstancesDataKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub geometryType: VkGeometryTypeKHR,
    pub geometry: VkAccelerationStructureGeometryDataKHR,
    pub flags: VkGeometryFlagsKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureBuildGeometryInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkAccelerationStructureTypeKHR,
    pub flags: VkBuildAccelerationStructureFlagsKHR,
    pub mode: VkBuildAccelerationStructureModeKHR,
    pub srcAccelerationStructure: VkAccelerationStructureKHR,
    pub dstAccelerationStructure: VkAccelerationStructureKHR,
    pub geometryCount: u32,
    pub pGeometries: *const VkAccelerationStructureGeometryKHR,
    pub ppGeometries: *const *const VkAccelerationStructureGeometryKHR,
    pub scratchData: VkDeviceOrHostAddressKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub createFlags: VkAccelerationStructureCreateFlagsKHR,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub type_: VkAccelerationStructureTypeKHR,
    pub deviceAddress: VkDeviceAddress,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSetAccelerationStructureKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructureCount: u32,
    pub pAccelerationStructures: *const VkAccelerationStructureKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceAccelerationStructureFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub accelerationStructure: VkBool32,
    pub accelerationStructureCaptureReplay: VkBool32,
    pub accelerationStructureIndirectBuild: VkBool32,
    pub accelerationStructureHostCommands: VkBool32,
    pub descriptorBindingAccelerationStructureUpdateAfterBind: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceAccelerationStructurePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxGeometryCount: u64,
    pub maxInstanceCount: u64,
    pub maxPrimitiveCount: u64,
    pub maxPerStageDescriptorAccelerationStructures: u32,
    pub maxPerStageDescriptorUpdateAfterBindAccelerationStructures: u32,
    pub maxDescriptorSetAccelerationStructures: u32,
    pub maxDescriptorSetUpdateAfterBindAccelerationStructures: u32,
    pub minAccelerationStructureScratchOffsetAlignment: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureDeviceAddressInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructure: VkAccelerationStructureKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureVersionInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pVersionData: *const u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkCopyAccelerationStructureToMemoryInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub src: VkAccelerationStructureKHR,
    pub dst: VkDeviceOrHostAddressKHR,
    pub mode: VkCopyAccelerationStructureModeKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkCopyMemoryToAccelerationStructureInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub src: VkDeviceOrHostAddressConstKHR,
    pub dst: VkAccelerationStructureKHR,
    pub mode: VkCopyAccelerationStructureModeKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyAccelerationStructureInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub src: VkAccelerationStructureKHR,
    pub dst: VkAccelerationStructureKHR,
    pub mode: VkCopyAccelerationStructureModeKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureBuildSizesInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructureSize: VkDeviceSize,
    pub updateScratchSize: VkDeviceSize,
    pub buildScratchSize: VkDeviceSize,
}
pub type PFN_vkCreateAccelerationStructureKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkAccelerationStructureCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pAccelerationStructure: *mut VkAccelerationStructureKHR,
    ) -> VkResult,
>;
pub type PFN_vkDestroyAccelerationStructureKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureKHR,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCmdBuildAccelerationStructuresKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const VkAccelerationStructureBuildRangeInfoKHR,
    ),
>;
pub type PFN_vkCmdBuildAccelerationStructuresIndirectKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        pIndirectDeviceAddresses: *const VkDeviceAddress,
        pIndirectStrides: *const u32,
        ppMaxPrimitiveCounts: *const *const u32,
    ),
>;
pub type PFN_vkBuildAccelerationStructuresKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const VkAccelerationStructureBuildRangeInfoKHR,
    ) -> VkResult,
>;
pub type PFN_vkCopyAccelerationStructureKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyAccelerationStructureInfoKHR,
    ) -> VkResult,
>;
pub type PFN_vkCopyAccelerationStructureToMemoryKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyAccelerationStructureToMemoryInfoKHR,
    ) -> VkResult,
>;
pub type PFN_vkCopyMemoryToAccelerationStructureKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyMemoryToAccelerationStructureInfoKHR,
    ) -> VkResult,
>;
pub type PFN_vkWriteAccelerationStructuresPropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureKHR,
        queryType: VkQueryType,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: size_t,
    ) -> VkResult,
>;
pub type PFN_vkCmdCopyAccelerationStructureKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyAccelerationStructureInfoKHR,
    ),
>;
pub type PFN_vkCmdCopyAccelerationStructureToMemoryKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyAccelerationStructureToMemoryInfoKHR,
    ),
>;
pub type PFN_vkCmdCopyMemoryToAccelerationStructureKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyMemoryToAccelerationStructureInfoKHR,
    ),
>;
pub type PFN_vkGetAccelerationStructureDeviceAddressKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkAccelerationStructureDeviceAddressInfoKHR,
    ) -> VkDeviceAddress,
>;
pub type PFN_vkCmdWriteAccelerationStructuresPropertiesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureKHR,
        queryType: VkQueryType,
        queryPool: VkQueryPool,
        firstQuery: u32,
    ),
>;
pub type PFN_vkGetDeviceAccelerationStructureCompatibilityKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pVersionInfo: *const VkAccelerationStructureVersionInfoKHR,
        pCompatibility: *mut VkAccelerationStructureCompatibilityKHR,
    ),
>;
pub type PFN_vkGetAccelerationStructureBuildSizesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        buildType: VkAccelerationStructureBuildTypeKHR,
        pBuildInfo: *const VkAccelerationStructureBuildGeometryInfoKHR,
        pMaxPrimitiveCounts: *const u32,
        pSizeInfo: *mut VkAccelerationStructureBuildSizesInfoKHR,
    ),
>;
extern "C" {
    pub fn vkCreateAccelerationStructureKHR(
        device: VkDevice,
        pCreateInfo: *const VkAccelerationStructureCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pAccelerationStructure: *mut VkAccelerationStructureKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyAccelerationStructureKHR(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureKHR,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCmdBuildAccelerationStructuresKHR(
        commandBuffer: VkCommandBuffer,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const VkAccelerationStructureBuildRangeInfoKHR,
    );
}
extern "C" {
    pub fn vkCmdBuildAccelerationStructuresIndirectKHR(
        commandBuffer: VkCommandBuffer,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        pIndirectDeviceAddresses: *const VkDeviceAddress,
        pIndirectStrides: *const u32,
        ppMaxPrimitiveCounts: *const *const u32,
    );
}
extern "C" {
    pub fn vkBuildAccelerationStructuresKHR(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const VkAccelerationStructureBuildRangeInfoKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCopyAccelerationStructureKHR(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyAccelerationStructureInfoKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCopyAccelerationStructureToMemoryKHR(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyAccelerationStructureToMemoryInfoKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCopyMemoryToAccelerationStructureKHR(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyMemoryToAccelerationStructureInfoKHR,
    ) -> VkResult;
}
extern "C" {
    pub fn vkWriteAccelerationStructuresPropertiesKHR(
        device: VkDevice,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureKHR,
        queryType: VkQueryType,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: size_t,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdCopyAccelerationStructureKHR(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyAccelerationStructureInfoKHR,
    );
}
extern "C" {
    pub fn vkCmdCopyAccelerationStructureToMemoryKHR(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyAccelerationStructureToMemoryInfoKHR,
    );
}
extern "C" {
    pub fn vkCmdCopyMemoryToAccelerationStructureKHR(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyMemoryToAccelerationStructureInfoKHR,
    );
}
extern "C" {
    pub fn vkGetAccelerationStructureDeviceAddressKHR(
        device: VkDevice,
        pInfo: *const VkAccelerationStructureDeviceAddressInfoKHR,
    ) -> VkDeviceAddress;
}
extern "C" {
    pub fn vkCmdWriteAccelerationStructuresPropertiesKHR(
        commandBuffer: VkCommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureKHR,
        queryType: VkQueryType,
        queryPool: VkQueryPool,
        firstQuery: u32,
    );
}
extern "C" {
    pub fn vkGetDeviceAccelerationStructureCompatibilityKHR(
        device: VkDevice,
        pVersionInfo: *const VkAccelerationStructureVersionInfoKHR,
        pCompatibility: *mut VkAccelerationStructureCompatibilityKHR,
    );
}
extern "C" {
    pub fn vkGetAccelerationStructureBuildSizesKHR(
        device: VkDevice,
        buildType: VkAccelerationStructureBuildTypeKHR,
        pBuildInfo: *const VkAccelerationStructureBuildGeometryInfoKHR,
        pMaxPrimitiveCounts: *const u32,
        pSizeInfo: *mut VkAccelerationStructureBuildSizesInfoKHR,
    );
}
pub const VkShaderGroupShaderKHR_VK_SHADER_GROUP_SHADER_GENERAL_KHR: VkShaderGroupShaderKHR = 0;
pub const VkShaderGroupShaderKHR_VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR: VkShaderGroupShaderKHR = 1;
pub const VkShaderGroupShaderKHR_VK_SHADER_GROUP_SHADER_ANY_HIT_KHR: VkShaderGroupShaderKHR = 2;
pub const VkShaderGroupShaderKHR_VK_SHADER_GROUP_SHADER_INTERSECTION_KHR: VkShaderGroupShaderKHR =
    3;
pub const VkShaderGroupShaderKHR_VK_SHADER_GROUP_SHADER_MAX_ENUM_KHR: VkShaderGroupShaderKHR =
    2147483647;
pub type VkShaderGroupShaderKHR = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingShaderGroupCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkRayTracingShaderGroupTypeKHR,
    pub generalShader: u32,
    pub closestHitShader: u32,
    pub anyHitShader: u32,
    pub intersectionShader: u32,
    pub pShaderGroupCaptureReplayHandle: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingPipelineInterfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxPipelineRayPayloadSize: u32,
    pub maxPipelineRayHitAttributeSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingPipelineCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub groupCount: u32,
    pub pGroups: *const VkRayTracingShaderGroupCreateInfoKHR,
    pub maxPipelineRayRecursionDepth: u32,
    pub pLibraryInfo: *const VkPipelineLibraryCreateInfoKHR,
    pub pLibraryInterface: *const VkRayTracingPipelineInterfaceCreateInfoKHR,
    pub pDynamicState: *const VkPipelineDynamicStateCreateInfo,
    pub layout: VkPipelineLayout,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayTracingPipelineFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rayTracingPipeline: VkBool32,
    pub rayTracingPipelineShaderGroupHandleCaptureReplay: VkBool32,
    pub rayTracingPipelineShaderGroupHandleCaptureReplayMixed: VkBool32,
    pub rayTracingPipelineTraceRaysIndirect: VkBool32,
    pub rayTraversalPrimitiveCulling: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayTracingPipelinePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderGroupHandleSize: u32,
    pub maxRayRecursionDepth: u32,
    pub maxShaderGroupStride: u32,
    pub shaderGroupBaseAlignment: u32,
    pub shaderGroupHandleCaptureReplaySize: u32,
    pub maxRayDispatchInvocationCount: u32,
    pub shaderGroupHandleAlignment: u32,
    pub maxRayHitAttributeSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkStridedDeviceAddressRegionKHR {
    pub deviceAddress: VkDeviceAddress,
    pub stride: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTraceRaysIndirectCommandKHR {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
pub type PFN_vkCmdTraceRaysKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRaygenShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        width: u32,
        height: u32,
        depth: u32,
    ),
>;
pub type PFN_vkCreateRayTracingPipelinesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkRayTracingPipelineCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult,
>;
pub type PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkCmdTraceRaysIndirectKHR = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRaygenShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        indirectDeviceAddress: VkDeviceAddress,
    ),
>;
pub type PFN_vkGetRayTracingShaderGroupStackSizeKHR = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        group: u32,
        groupShader: VkShaderGroupShaderKHR,
    ) -> VkDeviceSize,
>;
pub type PFN_vkCmdSetRayTracingPipelineStackSizeKHR = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pipelineStackSize: u32),
>;
extern "C" {
    pub fn vkCmdTraceRaysKHR(
        commandBuffer: VkCommandBuffer,
        pRaygenShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        width: u32,
        height: u32,
        depth: u32,
    );
}
extern "C" {
    pub fn vkCreateRayTracingPipelinesKHR(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkRayTracingPipelineCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetRayTracingCaptureReplayShaderGroupHandlesKHR(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdTraceRaysIndirectKHR(
        commandBuffer: VkCommandBuffer,
        pRaygenShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        indirectDeviceAddress: VkDeviceAddress,
    );
}
extern "C" {
    pub fn vkGetRayTracingShaderGroupStackSizeKHR(
        device: VkDevice,
        pipeline: VkPipeline,
        group: u32,
        groupShader: VkShaderGroupShaderKHR,
    ) -> VkDeviceSize;
}
extern "C" {
    pub fn vkCmdSetRayTracingPipelineStackSizeKHR(
        commandBuffer: VkCommandBuffer,
        pipelineStackSize: u32,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayQueryFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rayQuery: VkBool32,
}
#[doc = " \\brief Allocator and all objects created from it will not be synchronized internally, so you must guarantee they are used from only one thread at a time or synchronized externally by you."]
#[doc = ""]
#[doc = "Using this flag may increase performance because internal mutexes are not used."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_EXTERNALLY_SYNCHRONIZED_BIT:
    VmaAllocatorCreateFlagBits = 1;
#[doc = " \\brief Enables usage of VK_KHR_dedicated_allocation extension."]
#[doc = ""]
#[doc = "The flag works only if VmaAllocatorCreateInfo::vulkanApiVersion `== VK_API_VERSION_1_0`."]
#[doc = "When it is `VK_API_VERSION_1_1`, the flag is ignored because the extension has been promoted to Vulkan 1.1."]
#[doc = ""]
#[doc = "Using this extension will automatically allocate dedicated blocks of memory for"]
#[doc = "some buffers and images instead of suballocating place for them out of bigger"]
#[doc = "memory blocks (as if you explicitly used #VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT"]
#[doc = "flag) when it is recommended by the driver. It may improve performance on some"]
#[doc = "GPUs."]
#[doc = ""]
#[doc = "You may set this flag only if you found out that following device extensions are"]
#[doc = "supported, you enabled them while creating Vulkan device passed as"]
#[doc = "VmaAllocatorCreateInfo::device, and you want them to be used internally by this"]
#[doc = "library:"]
#[doc = ""]
#[doc = "- VK_KHR_get_memory_requirements2 (device extension)"]
#[doc = "- VK_KHR_dedicated_allocation (device extension)"]
#[doc = ""]
#[doc = "When this flag is set, you can experience following warnings reported by Vulkan"]
#[doc = "validation layer. You can ignore them."]
#[doc = ""]
#[doc = "> vkBindBufferMemory(): Binding memory to buffer 0x2d but vkGetBufferMemoryRequirements() has not been called on that buffer."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_KHR_DEDICATED_ALLOCATION_BIT:
    VmaAllocatorCreateFlagBits = 2;
#[doc = "Enables usage of VK_KHR_bind_memory2 extension."]
#[doc = ""]
#[doc = "The flag works only if VmaAllocatorCreateInfo::vulkanApiVersion `== VK_API_VERSION_1_0`."]
#[doc = "When it is `VK_API_VERSION_1_1`, the flag is ignored because the extension has been promoted to Vulkan 1.1."]
#[doc = ""]
#[doc = "You may set this flag only if you found out that this device extension is supported,"]
#[doc = "you enabled it while creating Vulkan device passed as VmaAllocatorCreateInfo::device,"]
#[doc = "and you want it to be used internally by this library."]
#[doc = ""]
#[doc = "The extension provides functions `vkBindBufferMemory2KHR` and `vkBindImageMemory2KHR`,"]
#[doc = "which allow to pass a chain of `pNext` structures while binding."]
#[doc = "This flag is required if you use `pNext` parameter in vmaBindBufferMemory2() or vmaBindImageMemory2()."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_KHR_BIND_MEMORY2_BIT:
    VmaAllocatorCreateFlagBits = 4;
#[doc = "Enables usage of VK_EXT_memory_budget extension."]
#[doc = ""]
#[doc = "You may set this flag only if you found out that this device extension is supported,"]
#[doc = "you enabled it while creating Vulkan device passed as VmaAllocatorCreateInfo::device,"]
#[doc = "and you want it to be used internally by this library, along with another instance extension"]
#[doc = "VK_KHR_get_physical_device_properties2, which is required by it (or Vulkan 1.1, where this extension is promoted)."]
#[doc = ""]
#[doc = "The extension provides query for current memory usage and budget, which will probably"]
#[doc = "be more accurate than an estimation used by the library otherwise."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_EXT_MEMORY_BUDGET_BIT:
    VmaAllocatorCreateFlagBits = 8;
#[doc = "Enables usage of VK_AMD_device_coherent_memory extension."]
#[doc = ""]
#[doc = "You may set this flag only if you:"]
#[doc = ""]
#[doc = "- found out that this device extension is supported and enabled it while creating Vulkan device passed as VmaAllocatorCreateInfo::device,"]
#[doc = "- checked that `VkPhysicalDeviceCoherentMemoryFeaturesAMD::deviceCoherentMemory` is true and set it while creating the Vulkan device,"]
#[doc = "- want it to be used internally by this library."]
#[doc = ""]
#[doc = "The extension and accompanying device feature provide access to memory types with"]
#[doc = "`VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD` and `VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD` flags."]
#[doc = "They are useful mostly for writing breadcrumb markers - a common method for debugging GPU crash/hang/TDR."]
#[doc = ""]
#[doc = "When the extension is not enabled, such memory types are still enumerated, but their usage is illegal."]
#[doc = "To protect from this error, if you don't create the allocator with this flag, it will refuse to allocate any memory or create a custom pool in such memory type,"]
#[doc = "returning `VK_ERROR_FEATURE_NOT_PRESENT`."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_AMD_DEVICE_COHERENT_MEMORY_BIT:
    VmaAllocatorCreateFlagBits = 16;
#[doc = "Enables usage of \"buffer device address\" feature, which allows you to use function"]
#[doc = "`vkGetBufferDeviceAddress*` to get raw GPU pointer to a buffer and pass it for usage inside a shader."]
#[doc = ""]
#[doc = "You may set this flag only if you:"]
#[doc = ""]
#[doc = "1. (For Vulkan version < 1.2) Found as available and enabled device extension"]
#[doc = "VK_KHR_buffer_device_address."]
#[doc = "This extension is promoted to core Vulkan 1.2."]
#[doc = "2. Found as available and enabled device feature `VkPhysicalDeviceBufferDeviceAddressFeatures::bufferDeviceAddress`."]
#[doc = ""]
#[doc = "When this flag is set, you can create buffers with `VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT` using VMA."]
#[doc = "The library automatically adds `VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT` to"]
#[doc = "allocated memory blocks wherever it might be needed."]
#[doc = ""]
#[doc = "For more information, see documentation chapter \\ref enabling_buffer_device_address."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_BUFFER_DEVICE_ADDRESS_BIT:
    VmaAllocatorCreateFlagBits = 32;
#[doc = "Enables usage of VK_EXT_memory_priority extension in the library."]
#[doc = ""]
#[doc = "You may set this flag only if you found available and enabled this device extension,"]
#[doc = "along with `VkPhysicalDeviceMemoryPriorityFeaturesEXT::memoryPriority == VK_TRUE`,"]
#[doc = "while creating Vulkan device passed as VmaAllocatorCreateInfo::device."]
#[doc = ""]
#[doc = "When this flag is used, VmaAllocationCreateInfo::priority and VmaPoolCreateInfo::priority"]
#[doc = "are used to set priorities of allocated Vulkan memory. Without it, these variables are ignored."]
#[doc = ""]
#[doc = "A priority must be a floating-point value between 0 and 1, indicating the priority of the allocation relative to other memory allocations."]
#[doc = "Larger values are higher priority. The granularity of the priorities is implementation-dependent."]
#[doc = "It is automatically passed to every call to `vkAllocateMemory` done by the library using structure `VkMemoryPriorityAllocateInfoEXT`."]
#[doc = "The value to be used for default priority is 0.5."]
#[doc = "For more details, see the documentation of the VK_EXT_memory_priority extension."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_EXT_MEMORY_PRIORITY_BIT:
    VmaAllocatorCreateFlagBits = 64;
#[doc = "Enables usage of VK_EXT_memory_priority extension in the library."]
#[doc = ""]
#[doc = "You may set this flag only if you found available and enabled this device extension,"]
#[doc = "along with `VkPhysicalDeviceMemoryPriorityFeaturesEXT::memoryPriority == VK_TRUE`,"]
#[doc = "while creating Vulkan device passed as VmaAllocatorCreateInfo::device."]
#[doc = ""]
#[doc = "When this flag is used, VmaAllocationCreateInfo::priority and VmaPoolCreateInfo::priority"]
#[doc = "are used to set priorities of allocated Vulkan memory. Without it, these variables are ignored."]
#[doc = ""]
#[doc = "A priority must be a floating-point value between 0 and 1, indicating the priority of the allocation relative to other memory allocations."]
#[doc = "Larger values are higher priority. The granularity of the priorities is implementation-dependent."]
#[doc = "It is automatically passed to every call to `vkAllocateMemory` done by the library using structure `VkMemoryPriorityAllocateInfoEXT`."]
#[doc = "The value to be used for default priority is 0.5."]
#[doc = "For more details, see the documentation of the VK_EXT_memory_priority extension."]
pub const VmaAllocatorCreateFlagBits_VMA_ALLOCATOR_CREATE_FLAG_BITS_MAX_ENUM:
    VmaAllocatorCreateFlagBits = 2147483647;
#[doc = " Flags for created #VmaAllocator."]
pub type VmaAllocatorCreateFlagBits = ::std::os::raw::c_uint;
pub type VmaAllocatorCreateFlags = VkFlags;
#[doc = " No intended memory usage specified."]
#[doc = "Use other members of VmaAllocationCreateInfo to specify your requirements."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_UNKNOWN: VmaMemoryUsage = 0;
#[doc = "\\deprecated Obsolete, preserved for backward compatibility."]
#[doc = "Prefers `VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT`."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_GPU_ONLY: VmaMemoryUsage = 1;
#[doc = "\\deprecated Obsolete, preserved for backward compatibility."]
#[doc = "Guarantees `VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT` and `VK_MEMORY_PROPERTY_HOST_COHERENT_BIT`."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_CPU_ONLY: VmaMemoryUsage = 2;
#[doc = "\\deprecated Obsolete, preserved for backward compatibility."]
#[doc = "Guarantees `VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT`, prefers `VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT`."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_CPU_TO_GPU: VmaMemoryUsage = 3;
#[doc = "\\deprecated Obsolete, preserved for backward compatibility."]
#[doc = "Guarantees `VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT`, prefers `VK_MEMORY_PROPERTY_HOST_CACHED_BIT`."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_GPU_TO_CPU: VmaMemoryUsage = 4;
#[doc = "\\deprecated Obsolete, preserved for backward compatibility."]
#[doc = "Prefers not `VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT`."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_CPU_COPY: VmaMemoryUsage = 5;
#[doc = "Lazily allocated GPU memory having `VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT`."]
#[doc = "Exists mostly on mobile platforms. Using it on desktop PC or other GPUs with no such memory type present will fail the allocation."]
#[doc = ""]
#[doc = "Usage: Memory for transient attachment images (color attachments, depth attachments etc.), created with `VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT`."]
#[doc = ""]
#[doc = "Allocations with this usage are always created as dedicated - it implies #VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_GPU_LAZILY_ALLOCATED: VmaMemoryUsage = 6;
#[doc = "Selects best memory type automatically."]
#[doc = "This flag is recommended for most common use cases."]
#[doc = ""]
#[doc = "When using this flag, if you want to map the allocation (using vmaMapMemory() or #VMA_ALLOCATION_CREATE_MAPPED_BIT),"]
#[doc = "you must pass one of the flags: #VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT or #VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT"]
#[doc = "in VmaAllocationCreateInfo::flags."]
#[doc = ""]
#[doc = "It can be used only with functions that let the library know `VkBufferCreateInfo` or `VkImageCreateInfo`, e.g."]
#[doc = "vmaCreateBuffer(), vmaCreateImage(), vmaFindMemoryTypeIndexForBufferInfo(), vmaFindMemoryTypeIndexForImageInfo()"]
#[doc = "and not with generic memory allocation functions."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_AUTO: VmaMemoryUsage = 7;
#[doc = "Selects best memory type automatically with preference for GPU (device) memory."]
#[doc = ""]
#[doc = "When using this flag, if you want to map the allocation (using vmaMapMemory() or #VMA_ALLOCATION_CREATE_MAPPED_BIT),"]
#[doc = "you must pass one of the flags: #VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT or #VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT"]
#[doc = "in VmaAllocationCreateInfo::flags."]
#[doc = ""]
#[doc = "It can be used only with functions that let the library know `VkBufferCreateInfo` or `VkImageCreateInfo`, e.g."]
#[doc = "vmaCreateBuffer(), vmaCreateImage(), vmaFindMemoryTypeIndexForBufferInfo(), vmaFindMemoryTypeIndexForImageInfo()"]
#[doc = "and not with generic memory allocation functions."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_AUTO_PREFER_DEVICE: VmaMemoryUsage = 8;
#[doc = "Selects best memory type automatically with preference for CPU (host) memory."]
#[doc = ""]
#[doc = "When using this flag, if you want to map the allocation (using vmaMapMemory() or #VMA_ALLOCATION_CREATE_MAPPED_BIT),"]
#[doc = "you must pass one of the flags: #VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT or #VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT"]
#[doc = "in VmaAllocationCreateInfo::flags."]
#[doc = ""]
#[doc = "It can be used only with functions that let the library know `VkBufferCreateInfo` or `VkImageCreateInfo`, e.g."]
#[doc = "vmaCreateBuffer(), vmaCreateImage(), vmaFindMemoryTypeIndexForBufferInfo(), vmaFindMemoryTypeIndexForImageInfo()"]
#[doc = "and not with generic memory allocation functions."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_AUTO_PREFER_HOST: VmaMemoryUsage = 9;
#[doc = "Selects best memory type automatically with preference for CPU (host) memory."]
#[doc = ""]
#[doc = "When using this flag, if you want to map the allocation (using vmaMapMemory() or #VMA_ALLOCATION_CREATE_MAPPED_BIT),"]
#[doc = "you must pass one of the flags: #VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT or #VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT"]
#[doc = "in VmaAllocationCreateInfo::flags."]
#[doc = ""]
#[doc = "It can be used only with functions that let the library know `VkBufferCreateInfo` or `VkImageCreateInfo`, e.g."]
#[doc = "vmaCreateBuffer(), vmaCreateImage(), vmaFindMemoryTypeIndexForBufferInfo(), vmaFindMemoryTypeIndexForImageInfo()"]
#[doc = "and not with generic memory allocation functions."]
pub const VmaMemoryUsage_VMA_MEMORY_USAGE_MAX_ENUM: VmaMemoryUsage = 2147483647;
#[doc = " \\brief Intended usage of the allocated memory."]
pub type VmaMemoryUsage = ::std::os::raw::c_uint;
#[doc = " \\brief Set this flag if the allocation should have its own memory block."]
#[doc = ""]
#[doc = "Use it for special, big resources, like fullscreen images used as attachments."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT:
    VmaAllocationCreateFlagBits = 1;
#[doc = " \\brief Set this flag to only try to allocate from existing `VkDeviceMemory` blocks and never create new such block."]
#[doc = ""]
#[doc = "If new allocation cannot be placed in any of the existing blocks, allocation"]
#[doc = "fails with `VK_ERROR_OUT_OF_DEVICE_MEMORY` error."]
#[doc = ""]
#[doc = "You should not use #VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT and"]
#[doc = "#VMA_ALLOCATION_CREATE_NEVER_ALLOCATE_BIT at the same time. It makes no sense."]
#[doc = ""]
#[doc = "If VmaAllocationCreateInfo::pool is not null, this flag is implied and ignored."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_NEVER_ALLOCATE_BIT:
    VmaAllocationCreateFlagBits = 2;
#[doc = " \\brief Set this flag to use a memory that will be persistently mapped and retrieve pointer to it."]
#[doc = ""]
#[doc = "Pointer to mapped memory will be returned through VmaAllocationInfo::pMappedData."]
#[doc = ""]
#[doc = "It is valid to use this flag for allocation made from memory type that is not"]
#[doc = "`HOST_VISIBLE`. This flag is then ignored and memory is not mapped. This is"]
#[doc = "useful if you need an allocation that is efficient to use on GPU"]
#[doc = "(`DEVICE_LOCAL`) and still want to map it directly if possible on platforms that"]
#[doc = "support it (e.g. Intel GPU)."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_MAPPED_BIT:
    VmaAllocationCreateFlagBits = 4;
#[doc = " \\deprecated Removed. Do not use."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_RESERVED_1_BIT:
    VmaAllocationCreateFlagBits = 8;
#[doc = " \\deprecated Removed. Do not use."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_RESERVED_2_BIT:
    VmaAllocationCreateFlagBits = 16;
#[doc = " Set this flag to treat VmaAllocationCreateInfo::pUserData as pointer to a"]
#[doc = "null-terminated string. Instead of copying pointer value, a local copy of the"]
#[doc = "string is made and stored in allocation's `pUserData`. The string is automatically"]
#[doc = "freed together with the allocation. It is also used in vmaBuildStatsString()."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_USER_DATA_COPY_STRING_BIT:
    VmaAllocationCreateFlagBits = 32;
#[doc = " Allocation will be created from upper stack in a double stack pool."]
#[doc = ""]
#[doc = "This flag is only allowed for custom pools created with #VMA_POOL_CREATE_LINEAR_ALGORITHM_BIT flag."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_UPPER_ADDRESS_BIT:
    VmaAllocationCreateFlagBits = 64;
#[doc = " Create both buffer/image and allocation, but don't bind them together."]
#[doc = "It is useful when you want to bind yourself to do some more advanced binding, e.g. using some extensions."]
#[doc = "The flag is meaningful only with functions that bind by default: vmaCreateBuffer(), vmaCreateImage()."]
#[doc = "Otherwise it is ignored."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_DONT_BIND_BIT:
    VmaAllocationCreateFlagBits = 128;
#[doc = " Create allocation only if additional device memory required for it, if any, won't exceed"]
#[doc = "memory budget. Otherwise return `VK_ERROR_OUT_OF_DEVICE_MEMORY`."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_WITHIN_BUDGET_BIT:
    VmaAllocationCreateFlagBits = 256;
#[doc = " \\brief Set this flag if the allocated memory will have aliasing resources."]
#[doc = ""]
#[doc = "Usage of this flag prevents supplying `VkMemoryDedicatedAllocateInfoKHR` when #VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT is specified."]
#[doc = "Otherwise created dedicated memory will not be suitable for aliasing resources, resulting in Vulkan Validation Layer errors."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_CAN_ALIAS_BIT:
    VmaAllocationCreateFlagBits = 512;
#[doc = "Requests possibility to map the allocation (using vmaMapMemory() or #VMA_ALLOCATION_CREATE_MAPPED_BIT)."]
#[doc = ""]
#[doc = "- If you use #VMA_MEMORY_USAGE_AUTO or other `VMA_MEMORY_USAGE_AUTO*` value,"]
#[doc = "you must use this flag to be able to map the allocation. Otherwise, mapping is incorrect."]
#[doc = "- If you use other value of #VmaMemoryUsage, this flag is ignored and mapping is always possible in memory types that are `HOST_VISIBLE`."]
#[doc = "This includes allocations created in \\ref custom_memory_pools."]
#[doc = ""]
#[doc = "Declares that mapped memory will only be written sequentially, e.g. using `memcpy()` or a loop writing number-by-number,"]
#[doc = "never read or accessed randomly, so a memory type can be selected that is uncached and write-combined."]
#[doc = ""]
#[doc = "\\warning Violating this declaration may work correctly, but will likely be very slow."]
#[doc = "Watch out for implicit reads introduces by doing e.g. `pMappedData[i] += x;`"]
#[doc = "Better prepare your data in a local variable and `memcpy()` it to the mapped pointer all at once."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT:
    VmaAllocationCreateFlagBits = 1024;
#[doc = "Requests possibility to map the allocation (using vmaMapMemory() or #VMA_ALLOCATION_CREATE_MAPPED_BIT)."]
#[doc = ""]
#[doc = "- If you use #VMA_MEMORY_USAGE_AUTO or other `VMA_MEMORY_USAGE_AUTO*` value,"]
#[doc = "you must use this flag to be able to map the allocation. Otherwise, mapping is incorrect."]
#[doc = "- If you use other value of #VmaMemoryUsage, this flag is ignored and mapping is always possible in memory types that are `HOST_VISIBLE`."]
#[doc = "This includes allocations created in \\ref custom_memory_pools."]
#[doc = ""]
#[doc = "Declares that mapped memory can be read, written, and accessed in random order,"]
#[doc = "so a `HOST_CACHED` memory type is preferred."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT:
    VmaAllocationCreateFlagBits = 2048;
#[doc = "Together with #VMA_ALLOCATION_CREATE_HOST_ACCESS_SEQUENTIAL_WRITE_BIT or #VMA_ALLOCATION_CREATE_HOST_ACCESS_RANDOM_BIT,"]
#[doc = "it says that despite request for host access, a not-`HOST_VISIBLE` memory type can be selected"]
#[doc = "if it may improve performance."]
#[doc = ""]
#[doc = "By using this flag, you declare that you will check if the allocation ended up in a `HOST_VISIBLE` memory type"]
#[doc = "(e.g. using vmaGetAllocationMemoryProperties()) and if not, you will create some \"staging\" buffer and"]
#[doc = "issue an explicit transfer to write/read your data."]
#[doc = "To prepare for this possibility, don't forget to add appropriate flags like"]
#[doc = "`VK_BUFFER_USAGE_TRANSFER_DST_BIT`, `VK_BUFFER_USAGE_TRANSFER_SRC_BIT` to the parameters of created buffer or image."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_HOST_ACCESS_ALLOW_TRANSFER_INSTEAD_BIT : VmaAllocationCreateFlagBits = 4096 ;
#[doc = " Allocation strategy that chooses smallest possible free range for the allocation"]
#[doc = "to minimize memory usage and fragmentation, possibly at the expense of allocation time."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT:
    VmaAllocationCreateFlagBits = 65536;
#[doc = " Allocation strategy that chooses first suitable free range for the allocation -"]
#[doc = "not necessarily in terms of the smallest offset but the one that is easiest and fastest to find"]
#[doc = "to minimize allocation time, possibly at the expense of allocation quality."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT:
    VmaAllocationCreateFlagBits = 131072;
#[doc = " Alias to #VMA_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_STRATEGY_BEST_FIT_BIT:
    VmaAllocationCreateFlagBits = 65536;
#[doc = " Alias to #VMA_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_STRATEGY_FIRST_FIT_BIT:
    VmaAllocationCreateFlagBits = 131072;
#[doc = " A bit mask to extract only `STRATEGY` bits from entire set of flags."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_STRATEGY_MASK:
    VmaAllocationCreateFlagBits = 196608;
#[doc = " A bit mask to extract only `STRATEGY` bits from entire set of flags."]
pub const VmaAllocationCreateFlagBits_VMA_ALLOCATION_CREATE_FLAG_BITS_MAX_ENUM:
    VmaAllocationCreateFlagBits = 2147483647;
#[doc = " Flags to be passed as VmaAllocationCreateInfo::flags."]
pub type VmaAllocationCreateFlagBits = ::std::os::raw::c_uint;
pub type VmaAllocationCreateFlags = VkFlags;
#[doc = " \\brief Use this flag if you always allocate only buffers and linear images or only optimal images out of this pool and so Buffer-Image Granularity can be ignored."]
#[doc = ""]
#[doc = "This is an optional optimization flag."]
#[doc = ""]
#[doc = "If you always allocate using vmaCreateBuffer(), vmaCreateImage(),"]
#[doc = "vmaAllocateMemoryForBuffer(), then you don't need to use it because allocator"]
#[doc = "knows exact type of your allocations so it can handle Buffer-Image Granularity"]
#[doc = "in the optimal way."]
#[doc = ""]
#[doc = "If you also allocate using vmaAllocateMemoryForImage() or vmaAllocateMemory(),"]
#[doc = "exact type of such allocations is not known, so allocator must be conservative"]
#[doc = "in handling Buffer-Image Granularity, which can lead to suboptimal allocation"]
#[doc = "(wasted memory). In that case, if you can make sure you always allocate only"]
#[doc = "buffers and linear images or only optimal images out of this pool, use this flag"]
#[doc = "to make allocator disregard Buffer-Image Granularity and so make allocations"]
#[doc = "faster and more optimal."]
pub const VmaPoolCreateFlagBits_VMA_POOL_CREATE_IGNORE_BUFFER_IMAGE_GRANULARITY_BIT:
    VmaPoolCreateFlagBits = 2;
#[doc = " \\brief Enables alternative, linear allocation algorithm in this pool."]
#[doc = ""]
#[doc = "Specify this flag to enable linear allocation algorithm, which always creates"]
#[doc = "new allocations after last one and doesn't reuse space from allocations freed in"]
#[doc = "between. It trades memory consumption for simplified algorithm and data"]
#[doc = "structure, which has better performance and uses less memory for metadata."]
#[doc = ""]
#[doc = "By using this flag, you can achieve behavior of free-at-once, stack,"]
#[doc = "ring buffer, and double stack."]
#[doc = "For details, see documentation chapter \\ref linear_algorithm."]
pub const VmaPoolCreateFlagBits_VMA_POOL_CREATE_LINEAR_ALGORITHM_BIT: VmaPoolCreateFlagBits = 4;
#[doc = " \\brief Enables alternative, buddy allocation algorithm in this pool."]
#[doc = ""]
#[doc = "It operates on a tree of blocks, each having size that is a power of two and"]
#[doc = "a half of its parent's size. Comparing to default algorithm, this one provides"]
#[doc = "faster allocation and deallocation and decreased external fragmentation,"]
#[doc = "at the expense of more memory wasted (internal fragmentation)."]
#[doc = "For details, see documentation chapter \\ref buddy_algorithm."]
pub const VmaPoolCreateFlagBits_VMA_POOL_CREATE_BUDDY_ALGORITHM_BIT: VmaPoolCreateFlagBits = 8;
#[doc = " \\brief Enables alternative, Two-Level Segregated Fit (TLSF) allocation algorithm in this pool."]
#[doc = ""]
#[doc = "This algorithm is based on 2-level lists dividing address space into smaller"]
#[doc = "chunks. The first level is aligned to power of two which serves as buckets for requested"]
#[doc = "memory to fall into, and the second level is lineary subdivided into lists of free memory."]
#[doc = "This algorithm aims to achieve bounded response time even in the worst case scenario."]
#[doc = "Allocation time can be sometimes slightly longer than compared to other algorithms"]
#[doc = "but in return the application can avoid stalls in case of fragmentation, giving"]
#[doc = "predictable results, suitable for real-time use cases."]
pub const VmaPoolCreateFlagBits_VMA_POOL_CREATE_TLSF_ALGORITHM_BIT: VmaPoolCreateFlagBits = 16;
#[doc = " Bit mask to extract only `ALGORITHM` bits from entire set of flags."]
pub const VmaPoolCreateFlagBits_VMA_POOL_CREATE_ALGORITHM_MASK: VmaPoolCreateFlagBits = 28;
#[doc = " Bit mask to extract only `ALGORITHM` bits from entire set of flags."]
pub const VmaPoolCreateFlagBits_VMA_POOL_CREATE_FLAG_BITS_MAX_ENUM: VmaPoolCreateFlagBits =
    2147483647;
#[doc = " Flags to be passed as VmaPoolCreateInfo::flags."]
pub type VmaPoolCreateFlagBits = ::std::os::raw::c_uint;
#[doc = " Flags to be passed as VmaPoolCreateInfo::flags. See #VmaPoolCreateFlagBits."]
pub type VmaPoolCreateFlags = VkFlags;
pub const VmaDefragmentationFlagBits_VMA_DEFRAGMENTATION_FLAG_INCREMENTAL:
    VmaDefragmentationFlagBits = 1;
pub const VmaDefragmentationFlagBits_VMA_DEFRAGMENTATION_FLAG_BITS_MAX_ENUM:
    VmaDefragmentationFlagBits = 2147483647;
#[doc = " Flags to be used in vmaDefragmentationBegin(). None at the moment. Reserved for future use."]
pub type VmaDefragmentationFlagBits = ::std::os::raw::c_uint;
pub type VmaDefragmentationFlags = VkFlags;
#[doc = " \\brief Enables alternative, linear allocation algorithm in this virtual block."]
#[doc = ""]
#[doc = "Specify this flag to enable linear allocation algorithm, which always creates"]
#[doc = "new allocations after last one and doesn't reuse space from allocations freed in"]
#[doc = "between. It trades memory consumption for simplified algorithm and data"]
#[doc = "structure, which has better performance and uses less memory for metadata."]
#[doc = ""]
#[doc = "By using this flag, you can achieve behavior of free-at-once, stack,"]
#[doc = "ring buffer, and double stack."]
#[doc = "For details, see documentation chapter \\ref linear_algorithm."]
pub const VmaVirtualBlockCreateFlagBits_VMA_VIRTUAL_BLOCK_CREATE_LINEAR_ALGORITHM_BIT:
    VmaVirtualBlockCreateFlagBits = 1;
#[doc = " \\brief Enables alternative, buddy allocation algorithm in this virtual block."]
#[doc = ""]
#[doc = "It operates on a tree of blocks, each having size that is a power of two and"]
#[doc = "a half of its parent's size. Comparing to default algorithm, this one provides"]
#[doc = "faster allocation and deallocation and decreased external fragmentation,"]
#[doc = "at the expense of more memory wasted (internal fragmentation)."]
#[doc = "For details, see documentation chapter \\ref buddy_algorithm."]
pub const VmaVirtualBlockCreateFlagBits_VMA_VIRTUAL_BLOCK_CREATE_BUDDY_ALGORITHM_BIT:
    VmaVirtualBlockCreateFlagBits = 2;
#[doc = " \\brief Enables alternative, TLSF allocation algorithm in virtual block."]
#[doc = ""]
#[doc = "This algorithm is based on 2-level lists dividing address space into smaller"]
#[doc = "chunks. The first level is aligned to power of two which serves as buckets for requested"]
#[doc = "memory to fall into, and the second level is lineary subdivided into lists of free memory."]
#[doc = "This algorithm aims to achieve bounded response time even in the worst case scenario."]
#[doc = "Allocation time can be sometimes slightly longer than compared to other algorithms"]
#[doc = "but in return the application can avoid stalls in case of fragmentation, giving"]
#[doc = "predictable results, suitable for real-time use cases."]
pub const VmaVirtualBlockCreateFlagBits_VMA_VIRTUAL_BLOCK_CREATE_TLSF_ALGORITHM_BIT:
    VmaVirtualBlockCreateFlagBits = 4;
#[doc = " \\brief Bit mask to extract only `ALGORITHM` bits from entire set of flags."]
pub const VmaVirtualBlockCreateFlagBits_VMA_VIRTUAL_BLOCK_CREATE_ALGORITHM_MASK:
    VmaVirtualBlockCreateFlagBits = 7;
#[doc = " \\brief Bit mask to extract only `ALGORITHM` bits from entire set of flags."]
pub const VmaVirtualBlockCreateFlagBits_VMA_VIRTUAL_BLOCK_CREATE_FLAG_BITS_MAX_ENUM:
    VmaVirtualBlockCreateFlagBits = 2147483647;
#[doc = " Flags to be passed as VmaVirtualBlockCreateInfo::flags."]
pub type VmaVirtualBlockCreateFlagBits = ::std::os::raw::c_uint;
#[doc = " Flags to be passed as VmaVirtualBlockCreateInfo::flags. See #VmaVirtualBlockCreateFlagBits."]
pub type VmaVirtualBlockCreateFlags = VkFlags;
#[doc = " \\brief Allocation will be created from upper stack in a double stack pool."]
#[doc = ""]
#[doc = "This flag is only allowed for virtual blocks created with #VMA_VIRTUAL_BLOCK_CREATE_LINEAR_ALGORITHM_BIT flag."]
pub const VmaVirtualAllocationCreateFlagBits_VMA_VIRTUAL_ALLOCATION_CREATE_UPPER_ADDRESS_BIT:
    VmaVirtualAllocationCreateFlagBits = 64;
#[doc = " \\brief Allocation strategy that tries to minimize memory usage."]
pub const VmaVirtualAllocationCreateFlagBits_VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MIN_MEMORY_BIT : VmaVirtualAllocationCreateFlagBits = 65536 ;
#[doc = " \\brief Allocation strategy that tries to minimize allocation time."]
pub const VmaVirtualAllocationCreateFlagBits_VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MIN_TIME_BIT:
    VmaVirtualAllocationCreateFlagBits = 131072;
#[doc = " \\brief A bit mask to extract only `STRATEGY` bits from entire set of flags."]
#[doc = ""]
#[doc = "These strategy flags are binary compatible with equivalent flags in #VmaAllocationCreateFlagBits."]
pub const VmaVirtualAllocationCreateFlagBits_VMA_VIRTUAL_ALLOCATION_CREATE_STRATEGY_MASK:
    VmaVirtualAllocationCreateFlagBits = 196608;
#[doc = " \\brief A bit mask to extract only `STRATEGY` bits from entire set of flags."]
#[doc = ""]
#[doc = "These strategy flags are binary compatible with equivalent flags in #VmaAllocationCreateFlagBits."]
pub const VmaVirtualAllocationCreateFlagBits_VMA_VIRTUAL_ALLOCATION_CREATE_FLAG_BITS_MAX_ENUM:
    VmaVirtualAllocationCreateFlagBits = 2147483647;
#[doc = " Flags to be passed as VmaVirtualAllocationCreateInfo::flags."]
pub type VmaVirtualAllocationCreateFlagBits = ::std::os::raw::c_uint;
#[doc = " Flags to be passed as VmaVirtualAllocationCreateInfo::flags. See #VmaVirtualAllocationCreateFlagBits."]
pub type VmaVirtualAllocationCreateFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaAllocator_T {
    _unused: [u8; 0],
}
pub type VmaAllocator = *mut VmaAllocator_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaPool_T {
    _unused: [u8; 0],
}
pub type VmaPool = *mut VmaPool_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaAllocation_T {
    _unused: [u8; 0],
}
pub type VmaAllocation = *mut VmaAllocation_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaDefragmentationContext_T {
    _unused: [u8; 0],
}
pub type VmaDefragmentationContext = *mut VmaDefragmentationContext_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaVirtualAllocation_T {
    _unused: [u8; 0],
}
pub type VmaVirtualAllocation = *mut VmaVirtualAllocation_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaVirtualBlock_T {
    _unused: [u8; 0],
}
pub type VmaVirtualBlock = *mut VmaVirtualBlock_T;
#[doc = " Callback function called after successful vkAllocateMemory."]
pub type PFN_vmaAllocateDeviceMemoryFunction = ::std::option::Option<
    unsafe extern "C" fn(
        allocator: VmaAllocator,
        memoryType: u32,
        memory: VkDeviceMemory,
        size: VkDeviceSize,
        pUserData: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " Callback function called before vkFreeMemory."]
pub type PFN_vmaFreeDeviceMemoryFunction = ::std::option::Option<
    unsafe extern "C" fn(
        allocator: VmaAllocator,
        memoryType: u32,
        memory: VkDeviceMemory,
        size: VkDeviceSize,
        pUserData: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " \\brief Set of callbacks that the library will call for `vkAllocateMemory` and `vkFreeMemory`."]
#[doc = ""]
#[doc = "Provided for informative purpose, e.g. to gather statistics about number of"]
#[doc = "allocations or total amount of memory allocated in Vulkan."]
#[doc = ""]
#[doc = "Used in VmaAllocatorCreateInfo::pDeviceMemoryCallbacks."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaDeviceMemoryCallbacks {
    #[doc = " Optional, can be null."]
    pub pfnAllocate: PFN_vmaAllocateDeviceMemoryFunction,
    #[doc = " Optional, can be null."]
    pub pfnFree: PFN_vmaFreeDeviceMemoryFunction,
    #[doc = " Optional, can be null."]
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[doc = " \\brief Pointers to some Vulkan functions - a subset used by the library."]
#[doc = ""]
#[doc = "Used in VmaAllocatorCreateInfo::pVulkanFunctions."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaVulkanFunctions {
    #[doc = " Required when using VMA_DYNAMIC_VULKAN_FUNCTIONS."]
    pub vkGetInstanceProcAddr: PFN_vkGetInstanceProcAddr,
    #[doc = " Required when using VMA_DYNAMIC_VULKAN_FUNCTIONS."]
    pub vkGetDeviceProcAddr: PFN_vkGetDeviceProcAddr,
    pub vkGetPhysicalDeviceProperties: PFN_vkGetPhysicalDeviceProperties,
    pub vkGetPhysicalDeviceMemoryProperties: PFN_vkGetPhysicalDeviceMemoryProperties,
    pub vkAllocateMemory: PFN_vkAllocateMemory,
    pub vkFreeMemory: PFN_vkFreeMemory,
    pub vkMapMemory: PFN_vkMapMemory,
    pub vkUnmapMemory: PFN_vkUnmapMemory,
    pub vkFlushMappedMemoryRanges: PFN_vkFlushMappedMemoryRanges,
    pub vkInvalidateMappedMemoryRanges: PFN_vkInvalidateMappedMemoryRanges,
    pub vkBindBufferMemory: PFN_vkBindBufferMemory,
    pub vkBindImageMemory: PFN_vkBindImageMemory,
    pub vkGetBufferMemoryRequirements: PFN_vkGetBufferMemoryRequirements,
    pub vkGetImageMemoryRequirements: PFN_vkGetImageMemoryRequirements,
    pub vkCreateBuffer: PFN_vkCreateBuffer,
    pub vkDestroyBuffer: PFN_vkDestroyBuffer,
    pub vkCreateImage: PFN_vkCreateImage,
    pub vkDestroyImage: PFN_vkDestroyImage,
    pub vkCmdCopyBuffer: PFN_vkCmdCopyBuffer,
    #[doc = " Fetch \"vkGetBufferMemoryRequirements2\" on Vulkan >= 1.1, fetch \"vkGetBufferMemoryRequirements2KHR\" when using VK_KHR_dedicated_allocation extension."]
    pub vkGetBufferMemoryRequirements2KHR: PFN_vkGetBufferMemoryRequirements2KHR,
    #[doc = " Fetch \"vkGetImageMemoryRequirements 2\" on Vulkan >= 1.1, fetch \"vkGetImageMemoryRequirements2KHR\" when using VK_KHR_dedicated_allocation extension."]
    pub vkGetImageMemoryRequirements2KHR: PFN_vkGetImageMemoryRequirements2KHR,
    #[doc = " Fetch \"vkBindBufferMemory2\" on Vulkan >= 1.1, fetch \"vkBindBufferMemory2KHR\" when using VK_KHR_bind_memory2 extension."]
    pub vkBindBufferMemory2KHR: PFN_vkBindBufferMemory2KHR,
    #[doc = " Fetch \"vkBindImageMemory2\" on Vulkan >= 1.1, fetch \"vkBindImageMemory2KHR\" when using VK_KHR_bind_memory2 extension."]
    pub vkBindImageMemory2KHR: PFN_vkBindImageMemory2KHR,
    pub vkGetPhysicalDeviceMemoryProperties2KHR: PFN_vkGetPhysicalDeviceMemoryProperties2KHR,
}
#[doc = " Description of a Allocator to be created."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaAllocatorCreateInfo {
    #[doc = " Flags for created allocator. Use #VmaAllocatorCreateFlagBits enum."]
    pub flags: VmaAllocatorCreateFlags,
    #[doc = " Vulkan physical device."]
    #[doc = "** It must be valid throughout whole lifetime of created allocator. */"]
    pub physicalDevice: VkPhysicalDevice,
    #[doc = " Vulkan device."]
    #[doc = "** It must be valid throughout whole lifetime of created allocator. */"]
    pub device: VkDevice,
    #[doc = " Preferred size of a single `VkDeviceMemory` block to be allocated from large heaps > 1 GiB. Optional."]
    #[doc = "** Set to 0 to use default, which is currently 256 MiB. */"]
    pub preferredLargeHeapBlockSize: VkDeviceSize,
    #[doc = " Custom CPU memory allocation callbacks. Optional."]
    #[doc = "** Optional, can be null. When specified, will also be used for all CPU-side memory allocations. */"]
    pub pAllocationCallbacks: *const VkAllocationCallbacks,
    #[doc = " Informative callbacks for `vkAllocateMemory`, `vkFreeMemory`. Optional."]
    #[doc = "** Optional, can be null. */"]
    pub pDeviceMemoryCallbacks: *const VmaDeviceMemoryCallbacks,
    #[doc = " \\brief Either null or a pointer to an array of limits on maximum number of bytes that can be allocated out of particular Vulkan memory heap."]
    #[doc = ""]
    #[doc = "If not NULL, it must be a pointer to an array of"]
    #[doc = "`VkPhysicalDeviceMemoryProperties::memoryHeapCount` elements, defining limit on"]
    #[doc = "maximum number of bytes that can be allocated out of particular Vulkan memory"]
    #[doc = "heap."]
    #[doc = ""]
    #[doc = "Any of the elements may be equal to `VK_WHOLE_SIZE`, which means no limit on that"]
    #[doc = "heap. This is also the default in case of `pHeapSizeLimit` = NULL."]
    #[doc = ""]
    #[doc = "If there is a limit defined for a heap:"]
    #[doc = ""]
    #[doc = "- If user tries to allocate more memory from that heap using this allocator,"]
    #[doc = "the allocation fails with `VK_ERROR_OUT_OF_DEVICE_MEMORY`."]
    #[doc = "- If the limit is smaller than heap size reported in `VkMemoryHeap::size`, the"]
    #[doc = "value of this limit will be reported instead when using vmaGetMemoryProperties()."]
    #[doc = ""]
    #[doc = "Warning! Using this feature may not be equivalent to installing a GPU with"]
    #[doc = "smaller amount of memory, because graphics driver doesn't necessary fail new"]
    #[doc = "allocations with `VK_ERROR_OUT_OF_DEVICE_MEMORY` result when memory capacity is"]
    #[doc = "exceeded. It may return success and just silently migrate some device memory"]
    #[doc = "blocks to system RAM. This driver behavior can also be controlled using"]
    #[doc = "VK_AMD_memory_overallocation_behavior extension."]
    pub pHeapSizeLimit: *const VkDeviceSize,
    #[doc = " \\brief Pointers to Vulkan functions. Can be null."]
    #[doc = ""]
    #[doc = "For details see [Pointers to Vulkan functions](@ref config_Vulkan_functions)."]
    pub pVulkanFunctions: *const VmaVulkanFunctions,
    #[doc = " \\brief Handle to Vulkan instance object."]
    #[doc = ""]
    #[doc = "Starting from version 3.0.0 this member is no longer optional, it must be set!"]
    pub instance: VkInstance,
    #[doc = " \\brief Optional. The highest version of Vulkan that the application is designed to use."]
    #[doc = ""]
    #[doc = "It must be a value in the format as created by macro `VK_MAKE_VERSION` or a constant like: `VK_API_VERSION_1_1`, `VK_API_VERSION_1_0`."]
    #[doc = "The patch version number specified is ignored. Only the major and minor versions are considered."]
    #[doc = "It must be less or equal (preferably equal) to value as passed to `vkCreateInstance` as `VkApplicationInfo::apiVersion`."]
    #[doc = "Only versions 1.0, 1.1, 1.2, 1.3 are supported by the current implementation."]
    #[doc = "Leaving it initialized to zero is equivalent to `VK_API_VERSION_1_0`."]
    pub vulkanApiVersion: u32,
    #[doc = " \\brief Either null or a pointer to an array of external memory handle types for each Vulkan memory type."]
    #[doc = ""]
    #[doc = "If not NULL, it must be a pointer to an array of `VkPhysicalDeviceMemoryProperties::memoryTypeCount`"]
    #[doc = "elements, defining external memory handle types of particular Vulkan memory type,"]
    #[doc = "to be passed using `VkExportMemoryAllocateInfoKHR`."]
    #[doc = ""]
    #[doc = "Any of the elements may be equal to 0, which means not to use `VkExportMemoryAllocateInfoKHR` on this memory type."]
    #[doc = "This is also the default in case of `pTypeExternalMemoryHandleTypes` = NULL."]
    pub pTypeExternalMemoryHandleTypes: *const VkExternalMemoryHandleTypeFlagsKHR,
}
#[doc = " Information about existing #VmaAllocator object."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaAllocatorInfo {
    #[doc = " \\brief Handle to Vulkan instance object."]
    #[doc = ""]
    #[doc = "This is the same value as has been passed through VmaAllocatorCreateInfo::instance."]
    pub instance: VkInstance,
    #[doc = " \\brief Handle to Vulkan physical device object."]
    #[doc = ""]
    #[doc = "This is the same value as has been passed through VmaAllocatorCreateInfo::physicalDevice."]
    pub physicalDevice: VkPhysicalDevice,
    #[doc = " \\brief Handle to Vulkan device object."]
    #[doc = ""]
    #[doc = "This is the same value as has been passed through VmaAllocatorCreateInfo::device."]
    pub device: VkDevice,
}
#[doc = " Calculated statistics of memory usage in entire allocator."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaStatInfo {
    #[doc = " Number of `VkDeviceMemory` Vulkan memory blocks allocated."]
    pub blockCount: u32,
    #[doc = " Number of #VmaAllocation allocation objects allocated."]
    pub allocationCount: u32,
    #[doc = " Number of free ranges of memory between allocations."]
    pub unusedRangeCount: u32,
    #[doc = " Total number of bytes occupied by all allocations."]
    pub usedBytes: VkDeviceSize,
    #[doc = " Total number of bytes occupied by unused ranges."]
    pub unusedBytes: VkDeviceSize,
    pub allocationSizeMin: VkDeviceSize,
    pub allocationSizeAvg: VkDeviceSize,
    pub allocationSizeMax: VkDeviceSize,
    pub unusedRangeSizeMin: VkDeviceSize,
    pub unusedRangeSizeAvg: VkDeviceSize,
    pub unusedRangeSizeMax: VkDeviceSize,
}
#[doc = " General statistics from current state of Allocator."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaStats {
    pub memoryType: [VmaStatInfo; 32usize],
    pub memoryHeap: [VmaStatInfo; 16usize],
    pub total: VmaStatInfo,
}
#[doc = " Statistics of current memory usage and available budget, in bytes, for specific memory heap."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaBudget {
    #[doc = " \\brief Sum size of all `VkDeviceMemory` blocks allocated from particular heap, in bytes."]
    pub blockBytes: VkDeviceSize,
    #[doc = " \\brief Sum size of all allocations created in particular heap, in bytes."]
    #[doc = ""]
    #[doc = "Usually less or equal than `blockBytes`."]
    #[doc = "Difference `blockBytes - allocationBytes` is the amount of memory allocated but unused -"]
    #[doc = "available for new allocations or wasted due to fragmentation."]
    pub allocationBytes: VkDeviceSize,
    #[doc = " \\brief Estimated current memory usage of the program, in bytes."]
    #[doc = ""]
    #[doc = "Fetched from system using `VK_EXT_memory_budget` extension if enabled."]
    #[doc = ""]
    #[doc = "It might be different than `blockBytes` (usually higher) due to additional implicit objects"]
    #[doc = "also occupying the memory, like swapchain, pipelines, descriptor heaps, command buffers, or"]
    #[doc = "`VkDeviceMemory` blocks allocated outside of this library, if any."]
    pub usage: VkDeviceSize,
    #[doc = " \\brief Estimated amount of memory available to the program, in bytes."]
    #[doc = ""]
    #[doc = "Fetched from system using `VK_EXT_memory_budget` extension if enabled."]
    #[doc = ""]
    #[doc = "It might be different (most probably smaller) than `VkMemoryHeap::size[heapIndex]` due to factors"]
    #[doc = "external to the program, like other programs also consuming system resources."]
    #[doc = "Difference `budget - usage` is the amount of additional memory that can probably"]
    #[doc = "be allocated without problems. Exceeding the budget may result in various problems."]
    pub budget: VkDeviceSize,
}
#[doc = "\\addtogroup group_alloc"]
#[doc = "@{"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaAllocationCreateInfo {
    #[doc = " Use #VmaAllocationCreateFlagBits enum."]
    pub flags: VmaAllocationCreateFlags,
    #[doc = " \\brief Intended usage of memory."]
    #[doc = ""]
    #[doc = "You can leave #VMA_MEMORY_USAGE_UNKNOWN if you specify memory requirements in other way. \\n"]
    #[doc = "If `pool` is not null, this member is ignored."]
    pub usage: VmaMemoryUsage,
    #[doc = " \\brief Flags that must be set in a Memory Type chosen for an allocation."]
    #[doc = ""]
    #[doc = "Leave 0 if you specify memory requirements in other way. \\n"]
    #[doc = "If `pool` is not null, this member is ignored."]
    pub requiredFlags: VkMemoryPropertyFlags,
    #[doc = " \\brief Flags that preferably should be set in a memory type chosen for an allocation."]
    #[doc = ""]
    #[doc = "Set to 0 if no additional flags are preferred. \\n"]
    #[doc = "If `pool` is not null, this member is ignored."]
    pub preferredFlags: VkMemoryPropertyFlags,
    #[doc = " \\brief Bitmask containing one bit set for every memory type acceptable for this allocation."]
    #[doc = ""]
    #[doc = "Value 0 is equivalent to `UINT32_MAX` - it means any memory type is accepted if"]
    #[doc = "it meets other requirements specified by this structure, with no further"]
    #[doc = "restrictions on memory type index. \\n"]
    #[doc = "If `pool` is not null, this member is ignored."]
    pub memoryTypeBits: u32,
    #[doc = " \\brief Pool that this allocation should be created in."]
    #[doc = ""]
    #[doc = "Leave `VK_NULL_HANDLE` to allocate from default pool. If not null, members:"]
    #[doc = "`usage`, `requiredFlags`, `preferredFlags`, `memoryTypeBits` are ignored."]
    pub pool: VmaPool,
    #[doc = " \\brief Custom general-purpose pointer that will be stored in #VmaAllocation, can be read as VmaAllocationInfo::pUserData and changed using vmaSetAllocationUserData()."]
    #[doc = ""]
    #[doc = "If #VMA_ALLOCATION_CREATE_USER_DATA_COPY_STRING_BIT is used, it must be either"]
    #[doc = "null or pointer to a null-terminated string. The string will be then copied to"]
    #[doc = "internal buffer, so it doesn't need to be valid after allocation call."]
    pub pUserData: *mut ::std::os::raw::c_void,
    #[doc = " \\brief A floating-point value between 0 and 1, indicating the priority of the allocation relative to other memory allocations."]
    #[doc = ""]
    #[doc = "It is used only when #VMA_ALLOCATOR_CREATE_EXT_MEMORY_PRIORITY_BIT flag was used during creation of the #VmaAllocator object"]
    #[doc = "and this allocation ends up as dedicated or is explicitly forced as dedicated using #VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT."]
    #[doc = "Otherwise, it has the priority of a memory block where it is placed and this variable is ignored."]
    pub priority: f32,
}
#[doc = " Describes parameter of created #VmaPool."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaPoolCreateInfo {
    #[doc = " \\brief Vulkan memory type index to allocate this pool from."]
    pub memoryTypeIndex: u32,
    #[doc = " \\brief Use combination of #VmaPoolCreateFlagBits."]
    pub flags: VmaPoolCreateFlags,
    #[doc = " \\brief Size of a single `VkDeviceMemory` block to be allocated as part of this pool, in bytes. Optional."]
    #[doc = ""]
    #[doc = "Specify nonzero to set explicit, constant size of memory blocks used by this"]
    #[doc = "pool."]
    #[doc = ""]
    #[doc = "Leave 0 to use default and let the library manage block sizes automatically."]
    #[doc = "Sizes of particular blocks may vary."]
    #[doc = "In this case, the pool will also support dedicated allocations."]
    pub blockSize: VkDeviceSize,
    #[doc = " \\brief Minimum number of blocks to be always allocated in this pool, even if they stay empty."]
    #[doc = ""]
    #[doc = "Set to 0 to have no preallocated blocks and allow the pool be completely empty."]
    pub minBlockCount: size_t,
    #[doc = " \\brief Maximum number of blocks that can be allocated in this pool. Optional."]
    #[doc = ""]
    #[doc = "Set to 0 to use default, which is `SIZE_MAX`, which means no limit."]
    #[doc = ""]
    #[doc = "Set to same value as VmaPoolCreateInfo::minBlockCount to have fixed amount of memory allocated"]
    #[doc = "throughout whole lifetime of this pool."]
    pub maxBlockCount: size_t,
    #[doc = " \\brief A floating-point value between 0 and 1, indicating the priority of the allocations in this pool relative to other memory allocations."]
    #[doc = ""]
    #[doc = "It is used only when #VMA_ALLOCATOR_CREATE_EXT_MEMORY_PRIORITY_BIT flag was used during creation of the #VmaAllocator object."]
    #[doc = "Otherwise, this variable is ignored."]
    pub priority: f32,
    #[doc = " \\brief Additional minimum alignment to be used for all allocations created from this pool. Can be 0."]
    #[doc = ""]
    #[doc = "Leave 0 (default) not to impose any additional alignment. If not 0, it must be a power of two."]
    #[doc = "It can be useful in cases where alignment returned by Vulkan by functions like `vkGetBufferMemoryRequirements` is not enough,"]
    #[doc = "e.g. when doing interop with OpenGL."]
    pub minAllocationAlignment: VkDeviceSize,
    #[doc = " \\brief Additional `pNext` chain to be attached to `VkMemoryAllocateInfo` used for every allocation made by this pool. Optional."]
    #[doc = ""]
    #[doc = "Optional, can be null. If not null, it must point to a `pNext` chain of structures that can be attached to `VkMemoryAllocateInfo`."]
    #[doc = "It can be useful for special needs such as adding `VkExportMemoryAllocateInfoKHR`."]
    #[doc = "Structures pointed by this member must remain alive and unchanged for the whole lifetime of the custom pool."]
    #[doc = ""]
    #[doc = "Please note that some structures, e.g. `VkMemoryPriorityAllocateInfoEXT`, `VkMemoryDedicatedAllocateInfoKHR`,"]
    #[doc = "can be attached automatically by this library when using other, more convenient of its features."]
    pub pMemoryAllocateNext: *mut ::std::os::raw::c_void,
}
#[doc = " Describes parameter of existing #VmaPool."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaPoolStats {
    #[doc = " \\brief Total amount of `VkDeviceMemory` allocated from Vulkan for this pool, in bytes."]
    pub size: VkDeviceSize,
    #[doc = " \\brief Total number of bytes in the pool not used by any #VmaAllocation."]
    pub unusedSize: VkDeviceSize,
    #[doc = " \\brief Number of #VmaAllocation objects created from this pool that were not destroyed."]
    pub allocationCount: size_t,
    #[doc = " \\brief Number of continuous memory ranges in the pool not used by any #VmaAllocation."]
    pub unusedRangeCount: size_t,
    #[doc = " \\brief Number of `VkDeviceMemory` blocks allocated for this pool."]
    pub blockCount: size_t,
}
#[doc = " Parameters of #VmaAllocation objects, that can be retrieved using function vmaGetAllocationInfo()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaAllocationInfo {
    #[doc = " \\brief Memory type index that this allocation was allocated from."]
    #[doc = ""]
    #[doc = "It never changes."]
    pub memoryType: u32,
    #[doc = " \\brief Handle to Vulkan memory object."]
    #[doc = ""]
    #[doc = "Same memory object can be shared by multiple allocations."]
    #[doc = ""]
    #[doc = "It can change after call to vmaDefragment() if this allocation is passed to the function."]
    pub deviceMemory: VkDeviceMemory,
    #[doc = " \\brief Offset in `VkDeviceMemory` object to the beginning of this allocation, in bytes. `(deviceMemory, offset)` pair is unique to this allocation."]
    #[doc = ""]
    #[doc = "You usually don't need to use this offset. If you create a buffer or an image together with the allocation using e.g. function"]
    #[doc = "vmaCreateBuffer(), vmaCreateImage(), functions that operate on these resources refer to the beginning of the buffer or image,"]
    #[doc = "not entire device memory block. Functions like vmaMapMemory(), vmaBindBufferMemory() also refer to the beginning of the allocation"]
    #[doc = "and apply this offset automatically."]
    #[doc = ""]
    #[doc = "It can change after call to vmaDefragment() if this allocation is passed to the function."]
    pub offset: VkDeviceSize,
    #[doc = " \\brief Size of this allocation, in bytes."]
    #[doc = ""]
    #[doc = "It never changes."]
    #[doc = ""]
    #[doc = "\\note Allocation size returned in this variable may be greater than the size"]
    #[doc = "requested for the resource e.g. as `VkBufferCreateInfo::size`. Whole size of the"]
    #[doc = "allocation is accessible for operations on memory e.g. using a pointer after"]
    #[doc = "mapping with vmaMapMemory(), but operations on the resource e.g. using"]
    #[doc = "`vkCmdCopyBuffer` must be limited to the size of the resource."]
    pub size: VkDeviceSize,
    #[doc = " \\brief Pointer to the beginning of this allocation as mapped data."]
    #[doc = ""]
    #[doc = "If the allocation hasn't been mapped using vmaMapMemory() and hasn't been"]
    #[doc = "created with #VMA_ALLOCATION_CREATE_MAPPED_BIT flag, this value is null."]
    #[doc = ""]
    #[doc = "It can change after call to vmaMapMemory(), vmaUnmapMemory()."]
    #[doc = "It can also change after call to vmaDefragment() if this allocation is passed to the function."]
    pub pMappedData: *mut ::std::os::raw::c_void,
    #[doc = " \\brief Custom general-purpose pointer that was passed as VmaAllocationCreateInfo::pUserData or set using vmaSetAllocationUserData()."]
    #[doc = ""]
    #[doc = "It can change after call to vmaSetAllocationUserData() for this allocation."]
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[doc = " \\brief Parameters for defragmentation."]
#[doc = ""]
#[doc = "To be used with function vmaDefragmentationBegin()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaDefragmentationInfo2 {
    #[doc = " \\brief Reserved for future use. Should be 0."]
    pub flags: VmaDefragmentationFlags,
    #[doc = " \\brief Number of allocations in `pAllocations` array."]
    pub allocationCount: u32,
    #[doc = " \\brief Pointer to array of allocations that can be defragmented."]
    #[doc = ""]
    #[doc = "The array should have `allocationCount` elements."]
    #[doc = "The array should not contain nulls."]
    #[doc = "Elements in the array should be unique - same allocation cannot occur twice."]
    #[doc = "All allocations not present in this array are considered non-moveable during this defragmentation."]
    pub pAllocations: *mut VmaAllocation,
    #[doc = " \\brief Optional, output. Pointer to array that will be filled with information whether the allocation at certain index has been changed during defragmentation."]
    #[doc = ""]
    #[doc = "The array should have `allocationCount` elements."]
    #[doc = "You can pass null if you are not interested in this information."]
    pub pAllocationsChanged: *mut VkBool32,
    #[doc = " \\brief Numer of pools in `pPools` array."]
    pub poolCount: u32,
    #[doc = " \\brief Either null or pointer to array of pools to be defragmented."]
    #[doc = ""]
    #[doc = "All the allocations in the specified pools can be moved during defragmentation"]
    #[doc = "and there is no way to check if they were really moved as in `pAllocationsChanged`,"]
    #[doc = "so you must query all the allocations in all these pools for new `VkDeviceMemory`"]
    #[doc = "and offset using vmaGetAllocationInfo() if you might need to recreate buffers"]
    #[doc = "and images bound to them."]
    #[doc = ""]
    #[doc = "The array should have `poolCount` elements."]
    #[doc = "The array should not contain nulls."]
    #[doc = "Elements in the array should be unique - same pool cannot occur twice."]
    #[doc = ""]
    #[doc = "Using this array is equivalent to specifying all allocations from the pools in `pAllocations`."]
    #[doc = "It might be more efficient."]
    pub pPools: *mut VmaPool,
    #[doc = " \\brief Maximum total numbers of bytes that can be copied while moving allocations to different places using transfers on CPU side, like `memcpy()`, `memmove()`."]
    #[doc = ""]
    #[doc = "`VK_WHOLE_SIZE` means no limit."]
    pub maxCpuBytesToMove: VkDeviceSize,
    #[doc = " \\brief Maximum number of allocations that can be moved to a different place using transfers on CPU side, like `memcpy()`, `memmove()`."]
    #[doc = ""]
    #[doc = "`UINT32_MAX` means no limit."]
    pub maxCpuAllocationsToMove: u32,
    #[doc = " \\brief Maximum total numbers of bytes that can be copied while moving allocations to different places using transfers on GPU side, posted to `commandBuffer`."]
    #[doc = ""]
    #[doc = "`VK_WHOLE_SIZE` means no limit."]
    pub maxGpuBytesToMove: VkDeviceSize,
    #[doc = " \\brief Maximum number of allocations that can be moved to a different place using transfers on GPU side, posted to `commandBuffer`."]
    #[doc = ""]
    #[doc = "`UINT32_MAX` means no limit."]
    pub maxGpuAllocationsToMove: u32,
    #[doc = " \\brief Optional. Command buffer where GPU copy commands will be posted."]
    #[doc = ""]
    #[doc = "If not null, it must be a valid command buffer handle that supports Transfer queue type."]
    #[doc = "It must be in the recording state and outside of a render pass instance."]
    #[doc = "You need to submit it and make sure it finished execution before calling vmaDefragmentationEnd()."]
    #[doc = ""]
    #[doc = "Passing null means that only CPU defragmentation will be performed."]
    pub commandBuffer: VkCommandBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaDefragmentationPassMoveInfo {
    pub allocation: VmaAllocation,
    pub memory: VkDeviceMemory,
    pub offset: VkDeviceSize,
}
#[doc = " \\brief Parameters for incremental defragmentation steps."]
#[doc = ""]
#[doc = "To be used with function vmaBeginDefragmentationPass()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaDefragmentationPassInfo {
    pub moveCount: u32,
    pub pMoves: *mut VmaDefragmentationPassMoveInfo,
}
#[doc = " \\brief Deprecated. Optional configuration parameters to be passed to function vmaDefragment()."]
#[doc = ""]
#[doc = "\\deprecated This is a part of the old interface. It is recommended to use structure #VmaDefragmentationInfo2 and function vmaDefragmentationBegin() instead."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaDefragmentationInfo {
    #[doc = " \\brief Maximum total numbers of bytes that can be copied while moving allocations to different places."]
    #[doc = ""]
    #[doc = "Default is `VK_WHOLE_SIZE`, which means no limit."]
    pub maxBytesToMove: VkDeviceSize,
    #[doc = " \\brief Maximum number of allocations that can be moved to different place."]
    #[doc = ""]
    #[doc = "Default is `UINT32_MAX`, which means no limit."]
    pub maxAllocationsToMove: u32,
}
#[doc = " Statistics returned by function vmaDefragment()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaDefragmentationStats {
    #[doc = " Total number of bytes that have been copied while moving allocations to different places."]
    pub bytesMoved: VkDeviceSize,
    #[doc = " Total number of bytes that have been released to the system by freeing empty `VkDeviceMemory` objects."]
    pub bytesFreed: VkDeviceSize,
    #[doc = " Number of allocations that have been moved to different places."]
    pub allocationsMoved: u32,
    #[doc = " Number of empty `VkDeviceMemory` objects that have been released to the system."]
    pub deviceMemoryBlocksFreed: u32,
}
#[doc = " Parameters of created #VmaVirtualBlock object to be passed to vmaCreateVirtualBlock()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaVirtualBlockCreateInfo {
    #[doc = " \\brief Total size of the virtual block."]
    #[doc = ""]
    #[doc = "Sizes can be expressed in bytes or any units you want as long as you are consistent in using them."]
    #[doc = "For example, if you allocate from some array of structures, 1 can mean single instance of entire structure."]
    pub size: VkDeviceSize,
    #[doc = " \\brief Use combination of #VmaVirtualBlockCreateFlagBits."]
    pub flags: VmaVirtualBlockCreateFlags,
    #[doc = " \\brief Custom CPU memory allocation callbacks. Optional."]
    #[doc = ""]
    #[doc = "Optional, can be null. When specified, they will be used for all CPU-side memory allocations."]
    pub pAllocationCallbacks: *const VkAllocationCallbacks,
}
#[doc = " Parameters of created virtual allocation to be passed to vmaVirtualAllocate()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaVirtualAllocationCreateInfo {
    #[doc = " \\brief Size of the allocation."]
    #[doc = ""]
    #[doc = "Cannot be zero."]
    pub size: VkDeviceSize,
    #[doc = " \\brief Required alignment of the allocation. Optional."]
    #[doc = ""]
    #[doc = "Must be power of two. Special value 0 has the same meaning as 1 - means no special alignment is required, so allocation can start at any offset."]
    pub alignment: VkDeviceSize,
    #[doc = " \\brief Use combination of #VmaVirtualAllocationCreateFlagBits."]
    pub flags: VmaVirtualAllocationCreateFlags,
    #[doc = " \\brief Custom pointer to be associated with the allocation. Optional."]
    #[doc = ""]
    #[doc = "It can be any value and can be used for user-defined purposes. It can be fetched or changed later."]
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[doc = " Parameters of an existing virtual allocation, returned by vmaGetVirtualAllocationInfo()."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VmaVirtualAllocationInfo {
    #[doc = " \\brief Offset of the allocation."]
    #[doc = ""]
    #[doc = "Offset at which the allocation was made."]
    pub offset: VkDeviceSize,
    #[doc = " \\brief Size of the allocation."]
    #[doc = ""]
    #[doc = "Same value as passed in VmaVirtualAllocationCreateInfo::size."]
    pub size: VkDeviceSize,
    #[doc = " \\brief Custom pointer associated with the allocation."]
    #[doc = ""]
    #[doc = "Same value as passed in VmaVirtualAllocationCreateInfo::pUserData or to vmaSetVirtualAllocationUserData()."]
    pub pUserData: *mut ::std::os::raw::c_void,
}
extern "C" {
    #[doc = " Creates #VmaAllocator object."]
    pub fn vmaCreateAllocator(
        pCreateInfo: *const VmaAllocatorCreateInfo,
        pAllocator: *mut VmaAllocator,
    ) -> VkResult;
}
extern "C" {
    #[doc = " Destroys allocator object."]
    pub fn vmaDestroyAllocator(allocator: VmaAllocator);
}
extern "C" {
    #[doc = " \\brief Returns information about existing #VmaAllocator object - handle to Vulkan device etc."]
    #[doc = ""]
    #[doc = "It might be useful if you want to keep just the #VmaAllocator handle and fetch other required handles to"]
    #[doc = "`VkPhysicalDevice`, `VkDevice` etc. every time using this function."]
    pub fn vmaGetAllocatorInfo(allocator: VmaAllocator, pAllocatorInfo: *mut VmaAllocatorInfo);
}
extern "C" {
    #[doc = "PhysicalDeviceProperties are fetched from physicalDevice by the allocator."]
    #[doc = "You can access it here, without fetching it again on your own."]
    pub fn vmaGetPhysicalDeviceProperties(
        allocator: VmaAllocator,
        ppPhysicalDeviceProperties: *mut *const VkPhysicalDeviceProperties,
    );
}
extern "C" {
    #[doc = "PhysicalDeviceMemoryProperties are fetched from physicalDevice by the allocator."]
    #[doc = "You can access it here, without fetching it again on your own."]
    pub fn vmaGetMemoryProperties(
        allocator: VmaAllocator,
        ppPhysicalDeviceMemoryProperties: *mut *const VkPhysicalDeviceMemoryProperties,
    );
}
extern "C" {
    #[doc = "\\brief Given Memory Type Index, returns Property Flags of this memory type."]
    #[doc = ""]
    #[doc = "This is just a convenience function. Same information can be obtained using"]
    #[doc = "vmaGetMemoryProperties()."]
    pub fn vmaGetMemoryTypeProperties(
        allocator: VmaAllocator,
        memoryTypeIndex: u32,
        pFlags: *mut VkMemoryPropertyFlags,
    );
}
extern "C" {
    #[doc = " \\brief Sets index of the current frame."]
    pub fn vmaSetCurrentFrameIndex(allocator: VmaAllocator, frameIndex: u32);
}
extern "C" {
    #[doc = " \\brief Retrieves statistics from current state of the Allocator."]
    #[doc = ""]
    #[doc = "This function is called \"calculate\" not \"get\" because it has to traverse all"]
    #[doc = "internal data structures, so it may be quite slow. For faster but more brief statistics"]
    #[doc = "suitable to be called every frame or every allocation, use vmaGetHeapBudgets()."]
    #[doc = ""]
    #[doc = "Note that when using allocator from multiple threads, returned information may immediately"]
    #[doc = "become outdated."]
    pub fn vmaCalculateStats(allocator: VmaAllocator, pStats: *mut VmaStats);
}
extern "C" {
    #[doc = " \\brief Retrieves information about current memory budget for all memory heaps."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param[out] pBudgets Must point to array with number of elements at least equal to number of memory heaps in physical device used."]
    #[doc = ""]
    #[doc = "This function is called \"get\" not \"calculate\" because it is very fast, suitable to be called"]
    #[doc = "every frame or every allocation. For more detailed statistics use vmaCalculateStats()."]
    #[doc = ""]
    #[doc = "Note that when using allocator from multiple threads, returned information may immediately"]
    #[doc = "become outdated."]
    pub fn vmaGetHeapBudgets(allocator: VmaAllocator, pBudgets: *mut VmaBudget);
}
extern "C" {
    #[doc = "\\brief Helps to find memoryTypeIndex, given memoryTypeBits and VmaAllocationCreateInfo."]
    #[doc = ""]
    #[doc = "This algorithm tries to find a memory type that:"]
    #[doc = ""]
    #[doc = "- Is allowed by memoryTypeBits."]
    #[doc = "- Contains all the flags from pAllocationCreateInfo->requiredFlags."]
    #[doc = "- Matches intended usage."]
    #[doc = "- Has as many flags from pAllocationCreateInfo->preferredFlags as possible."]
    #[doc = ""]
    #[doc = "\\return Returns VK_ERROR_FEATURE_NOT_PRESENT if not found. Receiving such result"]
    #[doc = "from this function or any other allocating function probably means that your"]
    #[doc = "device doesn't support any memory type with requested features for the specific"]
    #[doc = "type of resource you want to use it for. Please check parameters of your"]
    #[doc = "resource, like image layout (OPTIMAL versus LINEAR) or mip level count."]
    pub fn vmaFindMemoryTypeIndex(
        allocator: VmaAllocator,
        memoryTypeBits: u32,
        pAllocationCreateInfo: *const VmaAllocationCreateInfo,
        pMemoryTypeIndex: *mut u32,
    ) -> VkResult;
}
extern "C" {
    #[doc = "\\brief Helps to find memoryTypeIndex, given VkBufferCreateInfo and VmaAllocationCreateInfo."]
    #[doc = ""]
    #[doc = "It can be useful e.g. to determine value to be used as VmaPoolCreateInfo::memoryTypeIndex."]
    #[doc = "It internally creates a temporary, dummy buffer that never has memory bound."]
    pub fn vmaFindMemoryTypeIndexForBufferInfo(
        allocator: VmaAllocator,
        pBufferCreateInfo: *const VkBufferCreateInfo,
        pAllocationCreateInfo: *const VmaAllocationCreateInfo,
        pMemoryTypeIndex: *mut u32,
    ) -> VkResult;
}
extern "C" {
    #[doc = "\\brief Helps to find memoryTypeIndex, given VkImageCreateInfo and VmaAllocationCreateInfo."]
    #[doc = ""]
    #[doc = "It can be useful e.g. to determine value to be used as VmaPoolCreateInfo::memoryTypeIndex."]
    #[doc = "It internally creates a temporary, dummy image that never has memory bound."]
    pub fn vmaFindMemoryTypeIndexForImageInfo(
        allocator: VmaAllocator,
        pImageCreateInfo: *const VkImageCreateInfo,
        pAllocationCreateInfo: *const VmaAllocationCreateInfo,
        pMemoryTypeIndex: *mut u32,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Allocates Vulkan device memory and creates #VmaPool object."]
    #[doc = ""]
    #[doc = "\\param allocator Allocator object."]
    #[doc = "\\param pCreateInfo Parameters of pool to create."]
    #[doc = "\\param[out] pPool Handle to created pool."]
    pub fn vmaCreatePool(
        allocator: VmaAllocator,
        pCreateInfo: *const VmaPoolCreateInfo,
        pPool: *mut VmaPool,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Destroys #VmaPool object and frees Vulkan device memory."]
    pub fn vmaDestroyPool(allocator: VmaAllocator, pool: VmaPool);
}
extern "C" {
    #[doc = " \\brief Retrieves statistics of existing #VmaPool object."]
    #[doc = ""]
    #[doc = "\\param allocator Allocator object."]
    #[doc = "\\param pool Pool object."]
    #[doc = "\\param[out] pPoolStats Statistics of specified pool."]
    pub fn vmaGetPoolStats(allocator: VmaAllocator, pool: VmaPool, pPoolStats: *mut VmaPoolStats);
}
extern "C" {
    #[doc = " \\brief Checks magic number in margins around all allocations in given memory pool in search for corruptions."]
    #[doc = ""]
    #[doc = "Corruption detection is enabled only when `VMA_DEBUG_DETECT_CORRUPTION` macro is defined to nonzero,"]
    #[doc = "`VMA_DEBUG_MARGIN` is defined to nonzero and the pool is created in memory type that is"]
    #[doc = "`HOST_VISIBLE` and `HOST_COHERENT`. For more information, see [Corruption detection](@ref debugging_memory_usage_corruption_detection)."]
    #[doc = ""]
    #[doc = "Possible return values:"]
    #[doc = ""]
    #[doc = "- `VK_ERROR_FEATURE_NOT_PRESENT` - corruption detection is not enabled for specified pool."]
    #[doc = "- `VK_SUCCESS` - corruption detection has been performed and succeeded."]
    #[doc = "- `VK_ERROR_UNKNOWN` - corruption detection has been performed and found memory corruptions around one of the allocations."]
    #[doc = "`VMA_ASSERT` is also fired in that case."]
    #[doc = "- Other value: Error returned by Vulkan, e.g. memory mapping failure."]
    pub fn vmaCheckPoolCorruption(allocator: VmaAllocator, pool: VmaPool) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Retrieves name of a custom pool."]
    #[doc = ""]
    #[doc = "After the call `ppName` is either null or points to an internally-owned null-terminated string"]
    #[doc = "containing name of the pool that was previously set. The pointer becomes invalid when the pool is"]
    #[doc = "destroyed or its name is changed using vmaSetPoolName()."]
    pub fn vmaGetPoolName(
        allocator: VmaAllocator,
        pool: VmaPool,
        ppName: *mut *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[doc = " \\brief Sets name of a custom pool."]
    #[doc = ""]
    #[doc = "`pName` can be either null or pointer to a null-terminated string with new name for the pool."]
    #[doc = "Function makes internal copy of the string, so it can be changed or freed immediately after this call."]
    pub fn vmaSetPoolName(
        allocator: VmaAllocator,
        pool: VmaPool,
        pName: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[doc = " \\brief General purpose memory allocation."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param pVkMemoryRequirements"]
    #[doc = "\\param pCreateInfo"]
    #[doc = "\\param[out] pAllocation Handle to allocated memory."]
    #[doc = "\\param[out] pAllocationInfo Optional. Information about allocated memory. It can be later fetched using function vmaGetAllocationInfo()."]
    #[doc = ""]
    #[doc = "You should free the memory using vmaFreeMemory() or vmaFreeMemoryPages()."]
    #[doc = ""]
    #[doc = "It is recommended to use vmaAllocateMemoryForBuffer(), vmaAllocateMemoryForImage(),"]
    #[doc = "vmaCreateBuffer(), vmaCreateImage() instead whenever possible."]
    pub fn vmaAllocateMemory(
        allocator: VmaAllocator,
        pVkMemoryRequirements: *const VkMemoryRequirements,
        pCreateInfo: *const VmaAllocationCreateInfo,
        pAllocation: *mut VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief General purpose memory allocation for multiple allocation objects at once."]
    #[doc = ""]
    #[doc = "\\param allocator Allocator object."]
    #[doc = "\\param pVkMemoryRequirements Memory requirements for each allocation."]
    #[doc = "\\param pCreateInfo Creation parameters for each allocation."]
    #[doc = "\\param allocationCount Number of allocations to make."]
    #[doc = "\\param[out] pAllocations Pointer to array that will be filled with handles to created allocations."]
    #[doc = "\\param[out] pAllocationInfo Optional. Pointer to array that will be filled with parameters of created allocations."]
    #[doc = ""]
    #[doc = "You should free the memory using vmaFreeMemory() or vmaFreeMemoryPages()."]
    #[doc = ""]
    #[doc = "Word \"pages\" is just a suggestion to use this function to allocate pieces of memory needed for sparse binding."]
    #[doc = "It is just a general purpose allocation function able to make multiple allocations at once."]
    #[doc = "It may be internally optimized to be more efficient than calling vmaAllocateMemory() `allocationCount` times."]
    #[doc = ""]
    #[doc = "All allocations are made using same parameters. All of them are created out of the same memory pool and type."]
    #[doc = "If any allocation fails, all allocations already made within this function call are also freed, so that when"]
    #[doc = "returned result is not `VK_SUCCESS`, `pAllocation` array is always entirely filled with `VK_NULL_HANDLE`."]
    pub fn vmaAllocateMemoryPages(
        allocator: VmaAllocator,
        pVkMemoryRequirements: *const VkMemoryRequirements,
        pCreateInfo: *const VmaAllocationCreateInfo,
        allocationCount: size_t,
        pAllocations: *mut VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    ) -> VkResult;
}
extern "C" {
    #[doc = "\\param allocator"]
    #[doc = "\\param buffer"]
    #[doc = "\\param pCreateInfo"]
    #[doc = "\\param[out] pAllocation Handle to allocated memory."]
    #[doc = "\\param[out] pAllocationInfo Optional. Information about allocated memory. It can be later fetched using function vmaGetAllocationInfo()."]
    #[doc = ""]
    #[doc = "You should free the memory using vmaFreeMemory()."]
    pub fn vmaAllocateMemoryForBuffer(
        allocator: VmaAllocator,
        buffer: VkBuffer,
        pCreateInfo: *const VmaAllocationCreateInfo,
        pAllocation: *mut VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    ) -> VkResult;
}
extern "C" {
    #[doc = " Function similar to vmaAllocateMemoryForBuffer()."]
    pub fn vmaAllocateMemoryForImage(
        allocator: VmaAllocator,
        image: VkImage,
        pCreateInfo: *const VmaAllocationCreateInfo,
        pAllocation: *mut VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Frees memory previously allocated using vmaAllocateMemory(), vmaAllocateMemoryForBuffer(), or vmaAllocateMemoryForImage()."]
    #[doc = ""]
    #[doc = "Passing `VK_NULL_HANDLE` as `allocation` is valid. Such function call is just skipped."]
    pub fn vmaFreeMemory(allocator: VmaAllocator, allocation: VmaAllocation);
}
extern "C" {
    #[doc = " \\brief Frees memory and destroys multiple allocations."]
    #[doc = ""]
    #[doc = "Word \"pages\" is just a suggestion to use this function to free pieces of memory used for sparse binding."]
    #[doc = "It is just a general purpose function to free memory and destroy allocations made using e.g. vmaAllocateMemory(),"]
    #[doc = "vmaAllocateMemoryPages() and other functions."]
    #[doc = "It may be internally optimized to be more efficient than calling vmaFreeMemory() `allocationCount` times."]
    #[doc = ""]
    #[doc = "Allocations in `pAllocations` array can come from any memory pools and types."]
    #[doc = "Passing `VK_NULL_HANDLE` as elements of `pAllocations` array is valid. Such entries are just skipped."]
    pub fn vmaFreeMemoryPages(
        allocator: VmaAllocator,
        allocationCount: size_t,
        pAllocations: *mut VmaAllocation,
    );
}
extern "C" {
    #[doc = " \\brief Returns current information about specified allocation."]
    #[doc = ""]
    #[doc = "Current paramteres of given allocation are returned in `pAllocationInfo`."]
    #[doc = ""]
    #[doc = "Although this function doesn't lock any mutex, so it should be quite efficient,"]
    #[doc = "you should avoid calling it too often."]
    #[doc = "You can retrieve same VmaAllocationInfo structure while creating your resource, from function"]
    #[doc = "vmaCreateBuffer(), vmaCreateImage(). You can remember it if you are sure parameters don't change"]
    #[doc = "(e.g. due to defragmentation)."]
    pub fn vmaGetAllocationInfo(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    );
}
extern "C" {
    #[doc = " \\brief Sets pUserData in given allocation to new value."]
    #[doc = ""]
    #[doc = "If the allocation was created with VMA_ALLOCATION_CREATE_USER_DATA_COPY_STRING_BIT,"]
    #[doc = "pUserData must be either null, or pointer to a null-terminated string. The function"]
    #[doc = "makes local copy of the string and sets it as allocation's `pUserData`. String"]
    #[doc = "passed as pUserData doesn't need to be valid for whole lifetime of the allocation -"]
    #[doc = "you can free it after this call. String previously pointed by allocation's"]
    #[doc = "pUserData is freed from memory."]
    #[doc = ""]
    #[doc = "If the flag was not used, the value of pointer `pUserData` is just copied to"]
    #[doc = "allocation's `pUserData`. It is opaque, so you can use it however you want - e.g."]
    #[doc = "as a pointer, ordinal number or some handle to you own data."]
    pub fn vmaSetAllocationUserData(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        pUserData: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = "\\brief Given an allocation, returns Property Flags of its memory type."]
    #[doc = ""]
    #[doc = "This is just a convenience function. Same information can be obtained using"]
    #[doc = "vmaGetAllocationInfo() + vmaGetMemoryProperties()."]
    pub fn vmaGetAllocationMemoryProperties(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        pFlags: *mut VkMemoryPropertyFlags,
    );
}
extern "C" {
    #[doc = " \\brief Maps memory represented by given allocation and returns pointer to it."]
    #[doc = ""]
    #[doc = "Maps memory represented by given allocation to make it accessible to CPU code."]
    #[doc = "When succeeded, `*ppData` contains pointer to first byte of this memory."]
    #[doc = ""]
    #[doc = "\\warning"]
    #[doc = "If the allocation is part of a bigger `VkDeviceMemory` block, returned pointer is"]
    #[doc = "correctly offsetted to the beginning of region assigned to this particular allocation."]
    #[doc = "Unlike the result of `vkMapMemory`, it points to the allocation, not to the beginning of the whole block."]
    #[doc = "You should not add VmaAllocationInfo::offset to it!"]
    #[doc = ""]
    #[doc = "Mapping is internally reference-counted and synchronized, so despite raw Vulkan"]
    #[doc = "function `vkMapMemory()` cannot be used to map same block of `VkDeviceMemory`"]
    #[doc = "multiple times simultaneously, it is safe to call this function on allocations"]
    #[doc = "assigned to the same memory block. Actual Vulkan memory will be mapped on first"]
    #[doc = "mapping and unmapped on last unmapping."]
    #[doc = ""]
    #[doc = "If the function succeeded, you must call vmaUnmapMemory() to unmap the"]
    #[doc = "allocation when mapping is no longer needed or before freeing the allocation, at"]
    #[doc = "the latest."]
    #[doc = ""]
    #[doc = "It also safe to call this function multiple times on the same allocation. You"]
    #[doc = "must call vmaUnmapMemory() same number of times as you called vmaMapMemory()."]
    #[doc = ""]
    #[doc = "It is also safe to call this function on allocation created with"]
    #[doc = "#VMA_ALLOCATION_CREATE_MAPPED_BIT flag. Its memory stays mapped all the time."]
    #[doc = "You must still call vmaUnmapMemory() same number of times as you called"]
    #[doc = "vmaMapMemory(). You must not call vmaUnmapMemory() additional time to free the"]
    #[doc = "\"0-th\" mapping made automatically due to #VMA_ALLOCATION_CREATE_MAPPED_BIT flag."]
    #[doc = ""]
    #[doc = "This function fails when used on allocation made in memory type that is not"]
    #[doc = "`HOST_VISIBLE`."]
    #[doc = ""]
    #[doc = "This function doesn't automatically flush or invalidate caches."]
    #[doc = "If the allocation is made from a memory types that is not `HOST_COHERENT`,"]
    #[doc = "you also need to use vmaInvalidateAllocation() / vmaFlushAllocation(), as required by Vulkan specification."]
    pub fn vmaMapMemory(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Unmaps memory represented by given allocation, mapped previously using vmaMapMemory()."]
    #[doc = ""]
    #[doc = "For details, see description of vmaMapMemory()."]
    #[doc = ""]
    #[doc = "This function doesn't automatically flush or invalidate caches."]
    #[doc = "If the allocation is made from a memory types that is not `HOST_COHERENT`,"]
    #[doc = "you also need to use vmaInvalidateAllocation() / vmaFlushAllocation(), as required by Vulkan specification."]
    pub fn vmaUnmapMemory(allocator: VmaAllocator, allocation: VmaAllocation);
}
extern "C" {
    #[doc = " \\brief Flushes memory of given allocation."]
    #[doc = ""]
    #[doc = "Calls `vkFlushMappedMemoryRanges()` for memory associated with given range of given allocation."]
    #[doc = "It needs to be called after writing to a mapped memory for memory types that are not `HOST_COHERENT`."]
    #[doc = "Unmap operation doesn't do that automatically."]
    #[doc = ""]
    #[doc = "- `offset` must be relative to the beginning of allocation."]
    #[doc = "- `size` can be `VK_WHOLE_SIZE`. It means all memory from `offset` the the end of given allocation."]
    #[doc = "- `offset` and `size` don't have to be aligned."]
    #[doc = "They are internally rounded down/up to multiply of `nonCoherentAtomSize`."]
    #[doc = "- If `size` is 0, this call is ignored."]
    #[doc = "- If memory type that the `allocation` belongs to is not `HOST_VISIBLE` or it is `HOST_COHERENT`,"]
    #[doc = "this call is ignored."]
    #[doc = ""]
    #[doc = "Warning! `offset` and `size` are relative to the contents of given `allocation`."]
    #[doc = "If you mean whole allocation, you can pass 0 and `VK_WHOLE_SIZE`, respectively."]
    #[doc = "Do not pass allocation's offset as `offset`!!!"]
    #[doc = ""]
    #[doc = "This function returns the `VkResult` from `vkFlushMappedMemoryRanges` if it is"]
    #[doc = "called, otherwise `VK_SUCCESS`."]
    pub fn vmaFlushAllocation(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        offset: VkDeviceSize,
        size: VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Invalidates memory of given allocation."]
    #[doc = ""]
    #[doc = "Calls `vkInvalidateMappedMemoryRanges()` for memory associated with given range of given allocation."]
    #[doc = "It needs to be called before reading from a mapped memory for memory types that are not `HOST_COHERENT`."]
    #[doc = "Map operation doesn't do that automatically."]
    #[doc = ""]
    #[doc = "- `offset` must be relative to the beginning of allocation."]
    #[doc = "- `size` can be `VK_WHOLE_SIZE`. It means all memory from `offset` the the end of given allocation."]
    #[doc = "- `offset` and `size` don't have to be aligned."]
    #[doc = "They are internally rounded down/up to multiply of `nonCoherentAtomSize`."]
    #[doc = "- If `size` is 0, this call is ignored."]
    #[doc = "- If memory type that the `allocation` belongs to is not `HOST_VISIBLE` or it is `HOST_COHERENT`,"]
    #[doc = "this call is ignored."]
    #[doc = ""]
    #[doc = "Warning! `offset` and `size` are relative to the contents of given `allocation`."]
    #[doc = "If you mean whole allocation, you can pass 0 and `VK_WHOLE_SIZE`, respectively."]
    #[doc = "Do not pass allocation's offset as `offset`!!!"]
    #[doc = ""]
    #[doc = "This function returns the `VkResult` from `vkInvalidateMappedMemoryRanges` if"]
    #[doc = "it is called, otherwise `VK_SUCCESS`."]
    pub fn vmaInvalidateAllocation(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        offset: VkDeviceSize,
        size: VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Flushes memory of given set of allocations."]
    #[doc = ""]
    #[doc = "Calls `vkFlushMappedMemoryRanges()` for memory associated with given ranges of given allocations."]
    #[doc = "For more information, see documentation of vmaFlushAllocation()."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param allocationCount"]
    #[doc = "\\param allocations"]
    #[doc = "\\param offsets If not null, it must point to an array of offsets of regions to flush, relative to the beginning of respective allocations. Null means all ofsets are zero."]
    #[doc = "\\param sizes If not null, it must point to an array of sizes of regions to flush in respective allocations. Null means `VK_WHOLE_SIZE` for all allocations."]
    #[doc = ""]
    #[doc = "This function returns the `VkResult` from `vkFlushMappedMemoryRanges` if it is"]
    #[doc = "called, otherwise `VK_SUCCESS`."]
    pub fn vmaFlushAllocations(
        allocator: VmaAllocator,
        allocationCount: u32,
        allocations: *mut VmaAllocation,
        offsets: *const VkDeviceSize,
        sizes: *const VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Invalidates memory of given set of allocations."]
    #[doc = ""]
    #[doc = "Calls `vkInvalidateMappedMemoryRanges()` for memory associated with given ranges of given allocations."]
    #[doc = "For more information, see documentation of vmaInvalidateAllocation()."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param allocationCount"]
    #[doc = "\\param allocations"]
    #[doc = "\\param offsets If not null, it must point to an array of offsets of regions to flush, relative to the beginning of respective allocations. Null means all ofsets are zero."]
    #[doc = "\\param sizes If not null, it must point to an array of sizes of regions to flush in respective allocations. Null means `VK_WHOLE_SIZE` for all allocations."]
    #[doc = ""]
    #[doc = "This function returns the `VkResult` from `vkInvalidateMappedMemoryRanges` if it is"]
    #[doc = "called, otherwise `VK_SUCCESS`."]
    pub fn vmaInvalidateAllocations(
        allocator: VmaAllocator,
        allocationCount: u32,
        allocations: *mut VmaAllocation,
        offsets: *const VkDeviceSize,
        sizes: *const VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Checks magic number in margins around all allocations in given memory types (in both default and custom pools) in search for corruptions."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param memoryTypeBits Bit mask, where each bit set means that a memory type with that index should be checked."]
    #[doc = ""]
    #[doc = "Corruption detection is enabled only when `VMA_DEBUG_DETECT_CORRUPTION` macro is defined to nonzero,"]
    #[doc = "`VMA_DEBUG_MARGIN` is defined to nonzero and only for memory types that are"]
    #[doc = "`HOST_VISIBLE` and `HOST_COHERENT`. For more information, see [Corruption detection](@ref debugging_memory_usage_corruption_detection)."]
    #[doc = ""]
    #[doc = "Possible return values:"]
    #[doc = ""]
    #[doc = "- `VK_ERROR_FEATURE_NOT_PRESENT` - corruption detection is not enabled for any of specified memory types."]
    #[doc = "- `VK_SUCCESS` - corruption detection has been performed and succeeded."]
    #[doc = "- `VK_ERROR_UNKNOWN` - corruption detection has been performed and found memory corruptions around one of the allocations."]
    #[doc = "`VMA_ASSERT` is also fired in that case."]
    #[doc = "- Other value: Error returned by Vulkan, e.g. memory mapping failure."]
    pub fn vmaCheckCorruption(allocator: VmaAllocator, memoryTypeBits: u32) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Begins defragmentation process."]
    #[doc = ""]
    #[doc = "\\param allocator Allocator object."]
    #[doc = "\\param pInfo Structure filled with parameters of defragmentation."]
    #[doc = "\\param[out] pStats Optional. Statistics of defragmentation. You can pass null if you are not interested in this information."]
    #[doc = "\\param[out] pContext Context object that must be passed to vmaDefragmentationEnd() to finish defragmentation."]
    #[doc = "\\return `VK_SUCCESS` and `*pContext == null` if defragmentation finished within this function call. `VK_NOT_READY` and `*pContext != null` if defragmentation has been started and you need to call vmaDefragmentationEnd() to finish it. Negative value in case of error."]
    #[doc = ""]
    #[doc = "Use this function instead of old, deprecated vmaDefragment()."]
    #[doc = ""]
    #[doc = "Warning! Between the call to vmaDefragmentationBegin() and vmaDefragmentationEnd():"]
    #[doc = ""]
    #[doc = "- You should not use any of allocations passed as `pInfo->pAllocations` or"]
    #[doc = "any allocations that belong to pools passed as `pInfo->pPools`,"]
    #[doc = "including calling vmaGetAllocationInfo(), or access"]
    #[doc = "their data."]
    #[doc = "- Some mutexes protecting internal data structures may be locked, so trying to"]
    #[doc = "make or free any allocations, bind buffers or images, map memory, or launch"]
    #[doc = "another simultaneous defragmentation in between may cause stall (when done on"]
    #[doc = "another thread) or deadlock (when done on the same thread), unless you are"]
    #[doc = "100% sure that defragmented allocations are in different pools."]
    #[doc = "- Information returned via `pStats` and `pInfo->pAllocationsChanged` are undefined."]
    #[doc = "They become valid after call to vmaDefragmentationEnd()."]
    #[doc = "- If `pInfo->commandBuffer` is not null, you must submit that command buffer"]
    #[doc = "and make sure it finished execution before calling vmaDefragmentationEnd()."]
    #[doc = ""]
    #[doc = "For more information and important limitations regarding defragmentation, see documentation chapter:"]
    #[doc = "[Defragmentation](@ref defragmentation)."]
    pub fn vmaDefragmentationBegin(
        allocator: VmaAllocator,
        pInfo: *const VmaDefragmentationInfo2,
        pStats: *mut VmaDefragmentationStats,
        pContext: *mut VmaDefragmentationContext,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Ends defragmentation process."]
    #[doc = ""]
    #[doc = "Use this function to finish defragmentation started by vmaDefragmentationBegin()."]
    #[doc = "It is safe to pass `context == null`. The function then does nothing."]
    pub fn vmaDefragmentationEnd(
        allocator: VmaAllocator,
        context: VmaDefragmentationContext,
    ) -> VkResult;
}
extern "C" {
    pub fn vmaBeginDefragmentationPass(
        allocator: VmaAllocator,
        context: VmaDefragmentationContext,
        pInfo: *mut VmaDefragmentationPassInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vmaEndDefragmentationPass(
        allocator: VmaAllocator,
        context: VmaDefragmentationContext,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Deprecated. Compacts memory by moving allocations."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param pAllocations Array of allocations that can be moved during this compation."]
    #[doc = "\\param allocationCount Number of elements in pAllocations and pAllocationsChanged arrays."]
    #[doc = "\\param[out] pAllocationsChanged Array of boolean values that will indicate whether matching allocation in pAllocations array has been moved. This parameter is optional. Pass null if you don't need this information."]
    #[doc = "\\param pDefragmentationInfo Configuration parameters. Optional - pass null to use default values."]
    #[doc = "\\param[out] pDefragmentationStats Statistics returned by the function. Optional - pass null if you don't need this information."]
    #[doc = "\\return `VK_SUCCESS` if completed, negative error code in case of error."]
    #[doc = ""]
    #[doc = "\\deprecated This is a part of the old interface. It is recommended to use structure #VmaDefragmentationInfo2 and function vmaDefragmentationBegin() instead."]
    #[doc = ""]
    #[doc = "This function works by moving allocations to different places (different"]
    #[doc = "`VkDeviceMemory` objects and/or different offsets) in order to optimize memory"]
    #[doc = "usage. Only allocations that are in `pAllocations` array can be moved. All other"]
    #[doc = "allocations are considered nonmovable in this call. Basic rules:"]
    #[doc = ""]
    #[doc = "- Only allocations made in memory types that have"]
    #[doc = "`VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT` and `VK_MEMORY_PROPERTY_HOST_COHERENT_BIT`"]
    #[doc = "flags can be compacted. You may pass other allocations but it makes no sense -"]
    #[doc = "these will never be moved."]
    #[doc = "- Custom pools created with #VMA_POOL_CREATE_LINEAR_ALGORITHM_BIT or"]
    #[doc = "#VMA_POOL_CREATE_BUDDY_ALGORITHM_BIT flag are not defragmented. Allocations"]
    #[doc = "passed to this function that come from such pools are ignored."]
    #[doc = "- Allocations created with #VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT or"]
    #[doc = "created as dedicated allocations for any other reason are also ignored."]
    #[doc = "- Both allocations made with or without #VMA_ALLOCATION_CREATE_MAPPED_BIT"]
    #[doc = "flag can be compacted. If not persistently mapped, memory will be mapped"]
    #[doc = "temporarily inside this function if needed."]
    #[doc = "- You must not pass same #VmaAllocation object multiple times in `pAllocations` array."]
    #[doc = ""]
    #[doc = "The function also frees empty `VkDeviceMemory` blocks."]
    #[doc = ""]
    #[doc = "Warning: This function may be time-consuming, so you shouldn't call it too often"]
    #[doc = "(like after every resource creation/destruction)."]
    #[doc = "You can call it on special occasions (like when reloading a game level or"]
    #[doc = "when you just destroyed a lot of objects). Calling it every frame may be OK, but"]
    #[doc = "you should measure that on your platform."]
    #[doc = ""]
    #[doc = "For more information, see [Defragmentation](@ref defragmentation) chapter."]
    pub fn vmaDefragment(
        allocator: VmaAllocator,
        pAllocations: *mut VmaAllocation,
        allocationCount: size_t,
        pAllocationsChanged: *mut VkBool32,
        pDefragmentationInfo: *const VmaDefragmentationInfo,
        pDefragmentationStats: *mut VmaDefragmentationStats,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Binds buffer to allocation."]
    #[doc = ""]
    #[doc = "Binds specified buffer to region of memory represented by specified allocation."]
    #[doc = "Gets `VkDeviceMemory` handle and offset from the allocation."]
    #[doc = "If you want to create a buffer, allocate memory for it and bind them together separately,"]
    #[doc = "you should use this function for binding instead of standard `vkBindBufferMemory()`,"]
    #[doc = "because it ensures proper synchronization so that when a `VkDeviceMemory` object is used by multiple"]
    #[doc = "allocations, calls to `vkBind*Memory()` or `vkMapMemory()` won't happen from multiple threads simultaneously"]
    #[doc = "(which is illegal in Vulkan)."]
    #[doc = ""]
    #[doc = "It is recommended to use function vmaCreateBuffer() instead of this one."]
    pub fn vmaBindBufferMemory(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        buffer: VkBuffer,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Binds buffer to allocation with additional parameters."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param allocation"]
    #[doc = "\\param allocationLocalOffset Additional offset to be added while binding, relative to the beginning of the `allocation`. Normally it should be 0."]
    #[doc = "\\param buffer"]
    #[doc = "\\param pNext A chain of structures to be attached to `VkBindBufferMemoryInfoKHR` structure used internally. Normally it should be null."]
    #[doc = ""]
    #[doc = "This function is similar to vmaBindBufferMemory(), but it provides additional parameters."]
    #[doc = ""]
    #[doc = "If `pNext` is not null, #VmaAllocator object must have been created with #VMA_ALLOCATOR_CREATE_KHR_BIND_MEMORY2_BIT flag"]
    #[doc = "or with VmaAllocatorCreateInfo::vulkanApiVersion `>= VK_API_VERSION_1_1`. Otherwise the call fails."]
    pub fn vmaBindBufferMemory2(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        allocationLocalOffset: VkDeviceSize,
        buffer: VkBuffer,
        pNext: *const ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Binds image to allocation."]
    #[doc = ""]
    #[doc = "Binds specified image to region of memory represented by specified allocation."]
    #[doc = "Gets `VkDeviceMemory` handle and offset from the allocation."]
    #[doc = "If you want to create an image, allocate memory for it and bind them together separately,"]
    #[doc = "you should use this function for binding instead of standard `vkBindImageMemory()`,"]
    #[doc = "because it ensures proper synchronization so that when a `VkDeviceMemory` object is used by multiple"]
    #[doc = "allocations, calls to `vkBind*Memory()` or `vkMapMemory()` won't happen from multiple threads simultaneously"]
    #[doc = "(which is illegal in Vulkan)."]
    #[doc = ""]
    #[doc = "It is recommended to use function vmaCreateImage() instead of this one."]
    pub fn vmaBindImageMemory(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        image: VkImage,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Binds image to allocation with additional parameters."]
    #[doc = ""]
    #[doc = "\\param allocator"]
    #[doc = "\\param allocation"]
    #[doc = "\\param allocationLocalOffset Additional offset to be added while binding, relative to the beginning of the `allocation`. Normally it should be 0."]
    #[doc = "\\param image"]
    #[doc = "\\param pNext A chain of structures to be attached to `VkBindImageMemoryInfoKHR` structure used internally. Normally it should be null."]
    #[doc = ""]
    #[doc = "This function is similar to vmaBindImageMemory(), but it provides additional parameters."]
    #[doc = ""]
    #[doc = "If `pNext` is not null, #VmaAllocator object must have been created with #VMA_ALLOCATOR_CREATE_KHR_BIND_MEMORY2_BIT flag"]
    #[doc = "or with VmaAllocatorCreateInfo::vulkanApiVersion `>= VK_API_VERSION_1_1`. Otherwise the call fails."]
    pub fn vmaBindImageMemory2(
        allocator: VmaAllocator,
        allocation: VmaAllocation,
        allocationLocalOffset: VkDeviceSize,
        image: VkImage,
        pNext: *const ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    #[doc = "\\param allocator"]
    #[doc = "\\param pBufferCreateInfo"]
    #[doc = "\\param pAllocationCreateInfo"]
    #[doc = "\\param[out] pBuffer Buffer that was created."]
    #[doc = "\\param[out] pAllocation Allocation that was created."]
    #[doc = "\\param[out] pAllocationInfo Optional. Information about allocated memory. It can be later fetched using function vmaGetAllocationInfo()."]
    #[doc = ""]
    #[doc = "This function automatically:"]
    #[doc = ""]
    #[doc = "-# Creates buffer."]
    #[doc = "-# Allocates appropriate memory for it."]
    #[doc = "-# Binds the buffer with the memory."]
    #[doc = ""]
    #[doc = "If any of these operations fail, buffer and allocation are not created,"]
    #[doc = "returned value is negative error code, *pBuffer and *pAllocation are null."]
    #[doc = ""]
    #[doc = "If the function succeeded, you must destroy both buffer and allocation when you"]
    #[doc = "no longer need them using either convenience function vmaDestroyBuffer() or"]
    #[doc = "separately, using `vkDestroyBuffer()` and vmaFreeMemory()."]
    #[doc = ""]
    #[doc = "If #VMA_ALLOCATOR_CREATE_KHR_DEDICATED_ALLOCATION_BIT flag was used,"]
    #[doc = "VK_KHR_dedicated_allocation extension is used internally to query driver whether"]
    #[doc = "it requires or prefers the new buffer to have dedicated allocation. If yes,"]
    #[doc = "and if dedicated allocation is possible"]
    #[doc = "(#VMA_ALLOCATION_CREATE_NEVER_ALLOCATE_BIT is not used), it creates dedicated"]
    #[doc = "allocation for this buffer, just like when using"]
    #[doc = "#VMA_ALLOCATION_CREATE_DEDICATED_MEMORY_BIT."]
    #[doc = ""]
    #[doc = "\\note This function creates a new `VkBuffer`. Sub-allocation of parts of one large buffer,"]
    #[doc = "although recommended as a good practice, is out of scope of this library and could be implemented"]
    #[doc = "by the user as a higher-level logic on top of VMA."]
    pub fn vmaCreateBuffer(
        allocator: VmaAllocator,
        pBufferCreateInfo: *const VkBufferCreateInfo,
        pAllocationCreateInfo: *const VmaAllocationCreateInfo,
        pBuffer: *mut VkBuffer,
        pAllocation: *mut VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Creates a buffer with additional minimum alignment."]
    #[doc = ""]
    #[doc = "Similar to vmaCreateBuffer() but provides additional parameter `minAlignment` which allows to specify custom,"]
    #[doc = "minimum alignment to be used when placing the buffer inside a larger memory block, which may be needed e.g."]
    #[doc = "for interop with OpenGL."]
    pub fn vmaCreateBufferWithAlignment(
        allocator: VmaAllocator,
        pBufferCreateInfo: *const VkBufferCreateInfo,
        pAllocationCreateInfo: *const VmaAllocationCreateInfo,
        minAlignment: VkDeviceSize,
        pBuffer: *mut VkBuffer,
        pAllocation: *mut VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Destroys Vulkan buffer and frees allocated memory."]
    #[doc = ""]
    #[doc = "This is just a convenience function equivalent to:"]
    #[doc = ""]
    #[doc = "\\code"]
    #[doc = "vkDestroyBuffer(device, buffer, allocationCallbacks);"]
    #[doc = "vmaFreeMemory(allocator, allocation);"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "It it safe to pass null as buffer and/or allocation."]
    pub fn vmaDestroyBuffer(allocator: VmaAllocator, buffer: VkBuffer, allocation: VmaAllocation);
}
extern "C" {
    #[doc = " Function similar to vmaCreateBuffer()."]
    pub fn vmaCreateImage(
        allocator: VmaAllocator,
        pImageCreateInfo: *const VkImageCreateInfo,
        pAllocationCreateInfo: *const VmaAllocationCreateInfo,
        pImage: *mut VkImage,
        pAllocation: *mut VmaAllocation,
        pAllocationInfo: *mut VmaAllocationInfo,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Destroys Vulkan image and frees allocated memory."]
    #[doc = ""]
    #[doc = "This is just a convenience function equivalent to:"]
    #[doc = ""]
    #[doc = "\\code"]
    #[doc = "vkDestroyImage(device, image, allocationCallbacks);"]
    #[doc = "vmaFreeMemory(allocator, allocation);"]
    #[doc = "\\endcode"]
    #[doc = ""]
    #[doc = "It it safe to pass null as image and/or allocation."]
    pub fn vmaDestroyImage(allocator: VmaAllocator, image: VkImage, allocation: VmaAllocation);
}
extern "C" {
    #[doc = " \\brief Creates new #VmaVirtualBlock object."]
    #[doc = ""]
    #[doc = "\\param pCreateInfo Parameters for creation."]
    #[doc = "\\param[out] pVirtualBlock Returned virtual block object or `VMA_NULL` if creation failed."]
    pub fn vmaCreateVirtualBlock(
        pCreateInfo: *const VmaVirtualBlockCreateInfo,
        pVirtualBlock: *mut VmaVirtualBlock,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Destroys #VmaVirtualBlock object."]
    #[doc = ""]
    #[doc = "Please note that you should consciously handle virtual allocations that could remain unfreed in the block."]
    #[doc = "You should either free them individually using vmaVirtualFree() or call vmaClearVirtualBlock()"]
    #[doc = "if you are sure this is what you want. If you do neither, an assert is called."]
    #[doc = ""]
    #[doc = "If you keep pointers to some additional metadata associated with your virtual allocations in their `pUserData`,"]
    #[doc = "don't forget to free them."]
    pub fn vmaDestroyVirtualBlock(virtualBlock: VmaVirtualBlock);
}
extern "C" {
    #[doc = " \\brief Returns true of the #VmaVirtualBlock is empty - contains 0 virtual allocations and has all its space available for new allocations."]
    pub fn vmaIsVirtualBlockEmpty(virtualBlock: VmaVirtualBlock) -> VkBool32;
}
extern "C" {
    #[doc = " \\brief Returns information about a specific virtual allocation within a virtual block, like its size and `pUserData` pointer."]
    pub fn vmaGetVirtualAllocationInfo(
        virtualBlock: VmaVirtualBlock,
        allocation: VmaVirtualAllocation,
        pVirtualAllocInfo: *mut VmaVirtualAllocationInfo,
    );
}
extern "C" {
    #[doc = " \\brief Allocates new virtual allocation inside given #VmaVirtualBlock."]
    #[doc = ""]
    #[doc = "If the allocation fails due to not enough free space available, `VK_ERROR_OUT_OF_DEVICE_MEMORY` is returned"]
    #[doc = "(despite the function doesn't ever allocate actual GPU memory)."]
    #[doc = "`pAllocation` is then set to `VK_NULL_HANDLE` and `pOffset`, if not null, it set to `UINT64_MAX`."]
    #[doc = ""]
    #[doc = "\\param virtualBlock Virtual block"]
    #[doc = "\\param pCreateInfo Parameters for the allocation"]
    #[doc = "\\param[out] pAllocation Returned handle of the new allocation"]
    #[doc = "\\param[out] pOffset Returned offset of the new allocation. Optional, can be null."]
    pub fn vmaVirtualAllocate(
        virtualBlock: VmaVirtualBlock,
        pCreateInfo: *const VmaVirtualAllocationCreateInfo,
        pAllocation: *mut VmaVirtualAllocation,
        pOffset: *mut VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    #[doc = " \\brief Frees virtual allocation inside given #VmaVirtualBlock."]
    #[doc = ""]
    #[doc = "It is correct to call this function with `allocation == VK_NULL_HANDLE` - it does nothing."]
    pub fn vmaVirtualFree(virtualBlock: VmaVirtualBlock, allocation: VmaVirtualAllocation);
}
extern "C" {
    #[doc = " \\brief Frees all virtual allocations inside given #VmaVirtualBlock."]
    #[doc = ""]
    #[doc = "You must either call this function or free each virtual allocation individually with vmaVirtualFree()"]
    #[doc = "before destroying a virtual block. Otherwise, an assert is called."]
    #[doc = ""]
    #[doc = "If you keep pointer to some additional metadata associated with your virtual allocation in its `pUserData`,"]
    #[doc = "don't forget to free it as well."]
    pub fn vmaClearVirtualBlock(virtualBlock: VmaVirtualBlock);
}
extern "C" {
    #[doc = " \\brief Changes custom pointer associated with given virtual allocation."]
    pub fn vmaSetVirtualAllocationUserData(
        virtualBlock: VmaVirtualBlock,
        allocation: VmaVirtualAllocation,
        pUserData: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[doc = " \\brief Calculates and returns statistics about virtual allocations and memory usage in given #VmaVirtualBlock."]
    pub fn vmaCalculateVirtualBlockStats(
        virtualBlock: VmaVirtualBlock,
        pStatInfo: *mut VmaStatInfo,
    );
}
extern "C" {
    #[doc = " \\brief Builds and returns a null-terminated string in JSON format with information about given #VmaVirtualBlock."]
    #[doc = "\\param virtualBlock Virtual block."]
    #[doc = "\\param[out] ppStatsString Returned string."]
    #[doc = "\\param detailedMap Pass `VK_FALSE` to only obtain statistics as returned by vmaCalculateVirtualBlockStats(). Pass `VK_TRUE` to also obtain full list of allocations and free spaces."]
    #[doc = ""]
    #[doc = "Returned string must be freed using vmaFreeVirtualBlockStatsString()."]
    pub fn vmaBuildVirtualBlockStatsString(
        virtualBlock: VmaVirtualBlock,
        ppStatsString: *mut *mut ::std::os::raw::c_char,
        detailedMap: VkBool32,
    );
}
extern "C" {
    #[doc = " Frees a string returned by vmaBuildVirtualBlockStatsString()."]
    pub fn vmaFreeVirtualBlockStatsString(
        virtualBlock: VmaVirtualBlock,
        pStatsString: *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    #[doc = " \\brief Builds and returns statistics as a null-terminated string in JSON format."]
    #[doc = "\\param allocator"]
    #[doc = "\\param[out] ppStatsString Must be freed using vmaFreeStatsString() function."]
    #[doc = "\\param detailedMap"]
    pub fn vmaBuildStatsString(
        allocator: VmaAllocator,
        ppStatsString: *mut *mut ::std::os::raw::c_char,
        detailedMap: VkBool32,
    );
}
extern "C" {
    pub fn vmaFreeStatsString(allocator: VmaAllocator, pStatsString: *mut ::std::os::raw::c_char);
}
