#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const VULKAN_CORE_H_: u32 = 1;
pub const VK_VERSION_1_0: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 31;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LONG_DOUBLE_USES_FLOAT128: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const VK_USE_64_BIT_PTR_DEFINES: u32 = 1;
pub const VK_HEADER_VERSION: u32 = 212;
pub const VK_UUID_SIZE: u32 = 16;
pub const VK_ATTACHMENT_UNUSED: i32 = -1;
pub const VK_FALSE: u32 = 0;
pub const VK_LOD_CLAMP_NONE: f64 = 1000.0;
pub const VK_QUEUE_FAMILY_IGNORED: i32 = -1;
pub const VK_REMAINING_ARRAY_LAYERS: i32 = -1;
pub const VK_REMAINING_MIP_LEVELS: i32 = -1;
pub const VK_SUBPASS_EXTERNAL: i32 = -1;
pub const VK_TRUE: u32 = 1;
pub const VK_WHOLE_SIZE: i32 = -1;
pub const VK_MAX_MEMORY_TYPES: u32 = 32;
pub const VK_MAX_MEMORY_HEAPS: u32 = 16;
pub const VK_MAX_PHYSICAL_DEVICE_NAME_SIZE: u32 = 256;
pub const VK_MAX_EXTENSION_NAME_SIZE: u32 = 256;
pub const VK_MAX_DESCRIPTION_SIZE: u32 = 256;
pub const VK_VERSION_1_1: u32 = 1;
pub const VK_MAX_DEVICE_GROUP_SIZE: u32 = 32;
pub const VK_LUID_SIZE: u32 = 8;
pub const VK_QUEUE_FAMILY_EXTERNAL: i32 = -2;
pub const VK_VERSION_1_2: u32 = 1;
pub const VK_MAX_DRIVER_NAME_SIZE: u32 = 256;
pub const VK_MAX_DRIVER_INFO_SIZE: u32 = 256;
pub const VK_VERSION_1_3: u32 = 1;
pub const VK_KHR_surface: u32 = 1;
pub const VK_KHR_SURFACE_SPEC_VERSION: u32 = 25;
pub const VK_KHR_SURFACE_EXTENSION_NAME: &'static [u8; 15usize] = b"VK_KHR_surface\0";
pub const VK_KHR_swapchain: u32 = 1;
pub const VK_KHR_SWAPCHAIN_SPEC_VERSION: u32 = 70;
pub const VK_KHR_SWAPCHAIN_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_swapchain\0";
pub const VK_KHR_display: u32 = 1;
pub const VK_KHR_DISPLAY_SPEC_VERSION: u32 = 23;
pub const VK_KHR_DISPLAY_EXTENSION_NAME: &'static [u8; 15usize] = b"VK_KHR_display\0";
pub const VK_KHR_display_swapchain: u32 = 1;
pub const VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION: u32 = 10;
pub const VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_display_swapchain\0";
pub const VK_KHR_sampler_mirror_clamp_to_edge: u32 = 1;
pub const VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION: u32 = 3;
pub const VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_KHR_sampler_mirror_clamp_to_edge\0";
pub const VK_KHR_dynamic_rendering: u32 = 1;
pub const VK_KHR_DYNAMIC_RENDERING_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DYNAMIC_RENDERING_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_dynamic_rendering\0";
pub const VK_KHR_multiview: u32 = 1;
pub const VK_KHR_MULTIVIEW_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MULTIVIEW_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_multiview\0";
pub const VK_KHR_get_physical_device_properties2: u32 = 1;
pub const VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION: u32 = 2;
pub const VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME: &'static [u8; 39usize] =
    b"VK_KHR_get_physical_device_properties2\0";
pub const VK_KHR_device_group: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_SPEC_VERSION: u32 = 4;
pub const VK_KHR_DEVICE_GROUP_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_device_group\0";
pub const VK_KHR_shader_draw_parameters: u32 = 1;
pub const VK_KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_DRAW_PARAMETERS_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_KHR_shader_draw_parameters\0";
pub const VK_KHR_maintenance1: u32 = 1;
pub const VK_KHR_MAINTENANCE_1_SPEC_VERSION: u32 = 2;
pub const VK_KHR_MAINTENANCE_1_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance1\0";
pub const VK_KHR_MAINTENANCE1_SPEC_VERSION: u32 = 2;
pub const VK_KHR_MAINTENANCE1_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance1\0";
pub const VK_KHR_device_group_creation: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_device_group_creation\0";
pub const VK_MAX_DEVICE_GROUP_SIZE_KHR: u32 = 32;
pub const VK_KHR_external_memory_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_KHR_external_memory_capabilities\0";
pub const VK_LUID_SIZE_KHR: u32 = 8;
pub const VK_KHR_external_memory: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_KHR_external_memory\0";
pub const VK_QUEUE_FAMILY_EXTERNAL_KHR: i32 = -2;
pub const VK_KHR_external_memory_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_external_memory_fd\0";
pub const VK_KHR_external_semaphore_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_EXTENSION_NAME: &'static [u8; 39usize] =
    b"VK_KHR_external_semaphore_capabilities\0";
pub const VK_KHR_external_semaphore: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_external_semaphore\0";
pub const VK_KHR_external_semaphore_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_external_semaphore_fd\0";
pub const VK_KHR_push_descriptor: u32 = 1;
pub const VK_KHR_PUSH_DESCRIPTOR_SPEC_VERSION: u32 = 2;
pub const VK_KHR_PUSH_DESCRIPTOR_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_KHR_push_descriptor\0";
pub const VK_KHR_shader_float16_int8: u32 = 1;
pub const VK_KHR_SHADER_FLOAT16_INT8_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_FLOAT16_INT8_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_shader_float16_int8\0";
pub const VK_KHR_16bit_storage: u32 = 1;
pub const VK_KHR_16BIT_STORAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_16BIT_STORAGE_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_KHR_16bit_storage\0";
pub const VK_KHR_incremental_present: u32 = 1;
pub const VK_KHR_INCREMENTAL_PRESENT_SPEC_VERSION: u32 = 2;
pub const VK_KHR_INCREMENTAL_PRESENT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_incremental_present\0";
pub const VK_KHR_descriptor_update_template: u32 = 1;
pub const VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_KHR_descriptor_update_template\0";
pub const VK_KHR_imageless_framebuffer: u32 = 1;
pub const VK_KHR_IMAGELESS_FRAMEBUFFER_SPEC_VERSION: u32 = 1;
pub const VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_imageless_framebuffer\0";
pub const VK_KHR_create_renderpass2: u32 = 1;
pub const VK_KHR_CREATE_RENDERPASS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_CREATE_RENDERPASS_2_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_create_renderpass2\0";
pub const VK_KHR_shared_presentable_image: u32 = 1;
pub const VK_KHR_SHARED_PRESENTABLE_IMAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHARED_PRESENTABLE_IMAGE_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_shared_presentable_image\0";
pub const VK_KHR_external_fence_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_CAPABILITIES_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_KHR_external_fence_capabilities\0";
pub const VK_KHR_external_fence: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_EXTENSION_NAME: &'static [u8; 22usize] = b"VK_KHR_external_fence\0";
pub const VK_KHR_external_fence_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_external_fence_fd\0";
pub const VK_KHR_performance_query: u32 = 1;
pub const VK_KHR_PERFORMANCE_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PERFORMANCE_QUERY_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_performance_query\0";
pub const VK_KHR_maintenance2: u32 = 1;
pub const VK_KHR_MAINTENANCE_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE_2_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance2\0";
pub const VK_KHR_MAINTENANCE2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE2_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance2\0";
pub const VK_KHR_get_surface_capabilities2: u32 = 1;
pub const VK_KHR_GET_SURFACE_CAPABILITIES_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_SURFACE_CAPABILITIES_2_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_KHR_get_surface_capabilities2\0";
pub const VK_KHR_variable_pointers: u32 = 1;
pub const VK_KHR_VARIABLE_POINTERS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_VARIABLE_POINTERS_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_variable_pointers\0";
pub const VK_KHR_get_display_properties2: u32 = 1;
pub const VK_KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_KHR_get_display_properties2\0";
pub const VK_KHR_dedicated_allocation: u32 = 1;
pub const VK_KHR_DEDICATED_ALLOCATION_SPEC_VERSION: u32 = 3;
pub const VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_KHR_dedicated_allocation\0";
pub const VK_KHR_storage_buffer_storage_class: u32 = 1;
pub const VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_KHR_storage_buffer_storage_class\0";
pub const VK_KHR_relaxed_block_layout: u32 = 1;
pub const VK_KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RELAXED_BLOCK_LAYOUT_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_KHR_relaxed_block_layout\0";
pub const VK_KHR_get_memory_requirements2: u32 = 1;
pub const VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_get_memory_requirements2\0";
pub const VK_KHR_image_format_list: u32 = 1;
pub const VK_KHR_IMAGE_FORMAT_LIST_SPEC_VERSION: u32 = 1;
pub const VK_KHR_IMAGE_FORMAT_LIST_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_image_format_list\0";
pub const VK_KHR_sampler_ycbcr_conversion: u32 = 1;
pub const VK_KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION: u32 = 14;
pub const VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_sampler_ycbcr_conversion\0";
pub const VK_KHR_bind_memory2: u32 = 1;
pub const VK_KHR_BIND_MEMORY_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_BIND_MEMORY_2_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_bind_memory2\0";
pub const VK_KHR_maintenance3: u32 = 1;
pub const VK_KHR_MAINTENANCE_3_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE_3_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance3\0";
pub const VK_KHR_MAINTENANCE3_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE3_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance3\0";
pub const VK_KHR_draw_indirect_count: u32 = 1;
pub const VK_KHR_DRAW_INDIRECT_COUNT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DRAW_INDIRECT_COUNT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_draw_indirect_count\0";
pub const VK_KHR_shader_subgroup_extended_types: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_shader_subgroup_extended_types\0";
pub const VK_KHR_8bit_storage: u32 = 1;
pub const VK_KHR_8BIT_STORAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_8BIT_STORAGE_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_8bit_storage\0";
pub const VK_KHR_shader_atomic_int64: u32 = 1;
pub const VK_KHR_SHADER_ATOMIC_INT64_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_ATOMIC_INT64_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_shader_atomic_int64\0";
pub const VK_KHR_shader_clock: u32 = 1;
pub const VK_KHR_SHADER_CLOCK_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_CLOCK_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_shader_clock\0";
pub const VK_KHR_global_priority: u32 = 1;
pub const VK_MAX_GLOBAL_PRIORITY_SIZE_KHR: u32 = 16;
pub const VK_KHR_GLOBAL_PRIORITY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GLOBAL_PRIORITY_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_KHR_global_priority\0";
pub const VK_KHR_driver_properties: u32 = 1;
pub const VK_KHR_DRIVER_PROPERTIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DRIVER_PROPERTIES_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_driver_properties\0";
pub const VK_MAX_DRIVER_NAME_SIZE_KHR: u32 = 256;
pub const VK_MAX_DRIVER_INFO_SIZE_KHR: u32 = 256;
pub const VK_KHR_shader_float_controls: u32 = 1;
pub const VK_KHR_SHADER_FLOAT_CONTROLS_SPEC_VERSION: u32 = 4;
pub const VK_KHR_SHADER_FLOAT_CONTROLS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_shader_float_controls\0";
pub const VK_KHR_depth_stencil_resolve: u32 = 1;
pub const VK_KHR_DEPTH_STENCIL_RESOLVE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_depth_stencil_resolve\0";
pub const VK_KHR_swapchain_mutable_format: u32 = 1;
pub const VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_swapchain_mutable_format\0";
pub const VK_KHR_timeline_semaphore: u32 = 1;
pub const VK_KHR_TIMELINE_SEMAPHORE_SPEC_VERSION: u32 = 2;
pub const VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_timeline_semaphore\0";
pub const VK_KHR_vulkan_memory_model: u32 = 1;
pub const VK_KHR_VULKAN_MEMORY_MODEL_SPEC_VERSION: u32 = 3;
pub const VK_KHR_VULKAN_MEMORY_MODEL_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_vulkan_memory_model\0";
pub const VK_KHR_shader_terminate_invocation: u32 = 1;
pub const VK_KHR_SHADER_TERMINATE_INVOCATION_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_TERMINATE_INVOCATION_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_KHR_shader_terminate_invocation\0";
pub const VK_KHR_fragment_shading_rate: u32 = 1;
pub const VK_KHR_FRAGMENT_SHADING_RATE_SPEC_VERSION: u32 = 2;
pub const VK_KHR_FRAGMENT_SHADING_RATE_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_fragment_shading_rate\0";
pub const VK_KHR_spirv_1_4: u32 = 1;
pub const VK_KHR_SPIRV_1_4_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SPIRV_1_4_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_spirv_1_4\0";
pub const VK_KHR_surface_protected_capabilities: u32 = 1;
pub const VK_KHR_SURFACE_PROTECTED_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SURFACE_PROTECTED_CAPABILITIES_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_surface_protected_capabilities\0";
pub const VK_KHR_separate_depth_stencil_layouts: u32 = 1;
pub const VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_separate_depth_stencil_layouts\0";
pub const VK_KHR_present_wait: u32 = 1;
pub const VK_KHR_PRESENT_WAIT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PRESENT_WAIT_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_present_wait\0";
pub const VK_KHR_uniform_buffer_standard_layout: u32 = 1;
pub const VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_uniform_buffer_standard_layout\0";
pub const VK_KHR_buffer_device_address: u32 = 1;
pub const VK_KHR_BUFFER_DEVICE_ADDRESS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_buffer_device_address\0";
pub const VK_KHR_deferred_host_operations: u32 = 1;
pub const VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION: u32 = 4;
pub const VK_KHR_DEFERRED_HOST_OPERATIONS_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_deferred_host_operations\0";
pub const VK_KHR_pipeline_executable_properties: u32 = 1;
pub const VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_pipeline_executable_properties\0";
pub const VK_KHR_shader_integer_dot_product: u32 = 1;
pub const VK_KHR_SHADER_INTEGER_DOT_PRODUCT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_INTEGER_DOT_PRODUCT_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_KHR_shader_integer_dot_product\0";
pub const VK_KHR_pipeline_library: u32 = 1;
pub const VK_KHR_PIPELINE_LIBRARY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PIPELINE_LIBRARY_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_KHR_pipeline_library\0";
pub const VK_KHR_shader_non_semantic_info: u32 = 1;
pub const VK_KHR_SHADER_NON_SEMANTIC_INFO_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_NON_SEMANTIC_INFO_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_shader_non_semantic_info\0";
pub const VK_KHR_present_id: u32 = 1;
pub const VK_KHR_PRESENT_ID_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PRESENT_ID_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_KHR_present_id\0";
pub const VK_KHR_synchronization2: u32 = 1;
pub const VK_KHR_SYNCHRONIZATION_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_KHR_synchronization2\0";
pub const VK_KHR_shader_subgroup_uniform_control_flow: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_EXTENSION_NAME: &'static [u8; 44usize] =
    b"VK_KHR_shader_subgroup_uniform_control_flow\0";
pub const VK_KHR_zero_initialize_workgroup_memory: u32 = 1;
pub const VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION_NAME: &'static [u8; 40usize] =
    b"VK_KHR_zero_initialize_workgroup_memory\0";
pub const VK_KHR_workgroup_memory_explicit_layout: u32 = 1;
pub const VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_EXTENSION_NAME: &'static [u8; 40usize] =
    b"VK_KHR_workgroup_memory_explicit_layout\0";
pub const VK_KHR_copy_commands2: u32 = 1;
pub const VK_KHR_COPY_COMMANDS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_COPY_COMMANDS_2_EXTENSION_NAME: &'static [u8; 22usize] =
    b"VK_KHR_copy_commands2\0";
pub const VK_KHR_format_feature_flags2: u32 = 1;
pub const VK_KHR_FORMAT_FEATURE_FLAGS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_FORMAT_FEATURE_FLAGS_2_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_format_feature_flags2\0";
pub const VK_KHR_portability_enumeration: u32 = 1;
pub const VK_KHR_PORTABILITY_ENUMERATION_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PORTABILITY_ENUMERATION_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_KHR_portability_enumeration\0";
pub const VK_KHR_maintenance4: u32 = 1;
pub const VK_KHR_MAINTENANCE_4_SPEC_VERSION: u32 = 2;
pub const VK_KHR_MAINTENANCE_4_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance4\0";
pub const VK_EXT_debug_report: u32 = 1;
pub const VK_EXT_DEBUG_REPORT_SPEC_VERSION: u32 = 10;
pub const VK_EXT_DEBUG_REPORT_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_debug_report\0";
pub const VK_NV_glsl_shader: u32 = 1;
pub const VK_NV_GLSL_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_NV_GLSL_SHADER_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_NV_glsl_shader\0";
pub const VK_EXT_depth_range_unrestricted: u32 = 1;
pub const VK_EXT_DEPTH_RANGE_UNRESTRICTED_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DEPTH_RANGE_UNRESTRICTED_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_EXT_depth_range_unrestricted\0";
pub const VK_IMG_filter_cubic: u32 = 1;
pub const VK_IMG_FILTER_CUBIC_SPEC_VERSION: u32 = 1;
pub const VK_IMG_FILTER_CUBIC_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_IMG_filter_cubic\0";
pub const VK_AMD_rasterization_order: u32 = 1;
pub const VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_RASTERIZATION_ORDER_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_AMD_rasterization_order\0";
pub const VK_AMD_shader_trinary_minmax: u32 = 1;
pub const VK_AMD_SHADER_TRINARY_MINMAX_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_TRINARY_MINMAX_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_AMD_shader_trinary_minmax\0";
pub const VK_AMD_shader_explicit_vertex_parameter: u32 = 1;
pub const VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_EXTENSION_NAME: &'static [u8; 40usize] =
    b"VK_AMD_shader_explicit_vertex_parameter\0";
pub const VK_EXT_debug_marker: u32 = 1;
pub const VK_EXT_DEBUG_MARKER_SPEC_VERSION: u32 = 4;
pub const VK_EXT_DEBUG_MARKER_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_debug_marker\0";
pub const VK_AMD_gcn_shader: u32 = 1;
pub const VK_AMD_GCN_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_GCN_SHADER_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_AMD_gcn_shader\0";
pub const VK_NV_dedicated_allocation: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_NV_dedicated_allocation\0";
pub const VK_EXT_transform_feedback: u32 = 1;
pub const VK_EXT_TRANSFORM_FEEDBACK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TRANSFORM_FEEDBACK_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_transform_feedback\0";
pub const VK_NVX_binary_import: u32 = 1;
pub const VK_NVX_BINARY_IMPORT_SPEC_VERSION: u32 = 1;
pub const VK_NVX_BINARY_IMPORT_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_NVX_binary_import\0";
pub const VK_NVX_image_view_handle: u32 = 1;
pub const VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION: u32 = 2;
pub const VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NVX_image_view_handle\0";
pub const VK_AMD_draw_indirect_count: u32 = 1;
pub const VK_AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION: u32 = 2;
pub const VK_AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_AMD_draw_indirect_count\0";
pub const VK_AMD_negative_viewport_height: u32 = 1;
pub const VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_SPEC_VERSION: u32 = 1;
pub const VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_AMD_negative_viewport_height\0";
pub const VK_AMD_gpu_shader_half_float: u32 = 1;
pub const VK_AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION: u32 = 2;
pub const VK_AMD_GPU_SHADER_HALF_FLOAT_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_AMD_gpu_shader_half_float\0";
pub const VK_AMD_shader_ballot: u32 = 1;
pub const VK_AMD_SHADER_BALLOT_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_BALLOT_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_AMD_shader_ballot\0";
pub const VK_AMD_texture_gather_bias_lod: u32 = 1;
pub const VK_AMD_TEXTURE_GATHER_BIAS_LOD_SPEC_VERSION: u32 = 1;
pub const VK_AMD_TEXTURE_GATHER_BIAS_LOD_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_AMD_texture_gather_bias_lod\0";
pub const VK_AMD_shader_info: u32 = 1;
pub const VK_AMD_SHADER_INFO_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_INFO_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_AMD_shader_info\0";
pub const VK_AMD_shader_image_load_store_lod: u32 = 1;
pub const VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_AMD_shader_image_load_store_lod\0";
pub const VK_NV_corner_sampled_image: u32 = 1;
pub const VK_NV_CORNER_SAMPLED_IMAGE_SPEC_VERSION: u32 = 2;
pub const VK_NV_CORNER_SAMPLED_IMAGE_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_NV_corner_sampled_image\0";
pub const VK_IMG_format_pvrtc: u32 = 1;
pub const VK_IMG_FORMAT_PVRTC_SPEC_VERSION: u32 = 1;
pub const VK_IMG_FORMAT_PVRTC_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_IMG_format_pvrtc\0";
pub const VK_NV_external_memory_capabilities: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_NV_external_memory_capabilities\0";
pub const VK_NV_external_memory: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_EXTENSION_NAME: &'static [u8; 22usize] = b"VK_NV_external_memory\0";
pub const VK_EXT_validation_flags: u32 = 1;
pub const VK_EXT_VALIDATION_FLAGS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_VALIDATION_FLAGS_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_validation_flags\0";
pub const VK_EXT_shader_subgroup_ballot: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_BALLOT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_BALLOT_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_shader_subgroup_ballot\0";
pub const VK_EXT_shader_subgroup_vote: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_VOTE_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_shader_subgroup_vote\0";
pub const VK_EXT_texture_compression_astc_hdr: u32 = 1;
pub const VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_EXT_texture_compression_astc_hdr\0";
pub const VK_EXT_astc_decode_mode: u32 = 1;
pub const VK_EXT_ASTC_DECODE_MODE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ASTC_DECODE_MODE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_astc_decode_mode\0";
pub const VK_EXT_conditional_rendering: u32 = 1;
pub const VK_EXT_CONDITIONAL_RENDERING_SPEC_VERSION: u32 = 2;
pub const VK_EXT_CONDITIONAL_RENDERING_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_conditional_rendering\0";
pub const VK_NV_clip_space_w_scaling: u32 = 1;
pub const VK_NV_CLIP_SPACE_W_SCALING_SPEC_VERSION: u32 = 1;
pub const VK_NV_CLIP_SPACE_W_SCALING_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_NV_clip_space_w_scaling\0";
pub const VK_EXT_direct_mode_display: u32 = 1;
pub const VK_EXT_DIRECT_MODE_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DIRECT_MODE_DISPLAY_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_direct_mode_display\0";
pub const VK_EXT_display_surface_counter: u32 = 1;
pub const VK_EXT_DISPLAY_SURFACE_COUNTER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISPLAY_SURFACE_COUNTER_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_EXT_display_surface_counter\0";
pub const VK_EXT_display_control: u32 = 1;
pub const VK_EXT_DISPLAY_CONTROL_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISPLAY_CONTROL_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_EXT_display_control\0";
pub const VK_GOOGLE_display_timing: u32 = 1;
pub const VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_GOOGLE_display_timing\0";
pub const VK_NV_sample_mask_override_coverage: u32 = 1;
pub const VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_SPEC_VERSION: u32 = 1;
pub const VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_NV_sample_mask_override_coverage\0";
pub const VK_NV_geometry_shader_passthrough: u32 = 1;
pub const VK_NV_GEOMETRY_SHADER_PASSTHROUGH_SPEC_VERSION: u32 = 1;
pub const VK_NV_GEOMETRY_SHADER_PASSTHROUGH_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_geometry_shader_passthrough\0";
pub const VK_NV_viewport_array2: u32 = 1;
pub const VK_NV_VIEWPORT_ARRAY_2_SPEC_VERSION: u32 = 1;
pub const VK_NV_VIEWPORT_ARRAY_2_EXTENSION_NAME: &'static [u8; 22usize] =
    b"VK_NV_viewport_array2\0";
pub const VK_NV_VIEWPORT_ARRAY2_SPEC_VERSION: u32 = 1;
pub const VK_NV_VIEWPORT_ARRAY2_EXTENSION_NAME: &'static [u8; 22usize] = b"VK_NV_viewport_array2\0";
pub const VK_NVX_multiview_per_view_attributes: u32 = 1;
pub const VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_SPEC_VERSION: u32 = 1;
pub const VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_EXTENSION_NAME: &'static [u8; 37usize] =
    b"VK_NVX_multiview_per_view_attributes\0";
pub const VK_NV_viewport_swizzle: u32 = 1;
pub const VK_NV_VIEWPORT_SWIZZLE_SPEC_VERSION: u32 = 1;
pub const VK_NV_VIEWPORT_SWIZZLE_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_NV_viewport_swizzle\0";
pub const VK_EXT_discard_rectangles: u32 = 1;
pub const VK_EXT_DISCARD_RECTANGLES_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISCARD_RECTANGLES_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_discard_rectangles\0";
pub const VK_EXT_conservative_rasterization: u32 = 1;
pub const VK_EXT_CONSERVATIVE_RASTERIZATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_CONSERVATIVE_RASTERIZATION_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_EXT_conservative_rasterization\0";
pub const VK_EXT_depth_clip_enable: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_ENABLE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_ENABLE_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_EXT_depth_clip_enable\0";
pub const VK_EXT_swapchain_colorspace: u32 = 1;
pub const VK_EXT_SWAPCHAIN_COLOR_SPACE_SPEC_VERSION: u32 = 4;
pub const VK_EXT_SWAPCHAIN_COLOR_SPACE_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_swapchain_colorspace\0";
pub const VK_EXT_hdr_metadata: u32 = 1;
pub const VK_EXT_HDR_METADATA_SPEC_VERSION: u32 = 2;
pub const VK_EXT_HDR_METADATA_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_hdr_metadata\0";
pub const VK_EXT_external_memory_dma_buf: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_DMA_BUF_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_DMA_BUF_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_EXT_external_memory_dma_buf\0";
pub const VK_EXT_queue_family_foreign: u32 = 1;
pub const VK_EXT_QUEUE_FAMILY_FOREIGN_SPEC_VERSION: u32 = 1;
pub const VK_EXT_QUEUE_FAMILY_FOREIGN_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_queue_family_foreign\0";
pub const VK_QUEUE_FAMILY_FOREIGN_EXT: i32 = -3;
pub const VK_EXT_debug_utils: u32 = 1;
pub const VK_EXT_DEBUG_UTILS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DEBUG_UTILS_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_EXT_debug_utils\0";
pub const VK_EXT_sampler_filter_minmax: u32 = 1;
pub const VK_EXT_SAMPLER_FILTER_MINMAX_SPEC_VERSION: u32 = 2;
pub const VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_sampler_filter_minmax\0";
pub const VK_AMD_gpu_shader_int16: u32 = 1;
pub const VK_AMD_GPU_SHADER_INT16_SPEC_VERSION: u32 = 2;
pub const VK_AMD_GPU_SHADER_INT16_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_AMD_gpu_shader_int16\0";
pub const VK_AMD_mixed_attachment_samples: u32 = 1;
pub const VK_AMD_MIXED_ATTACHMENT_SAMPLES_SPEC_VERSION: u32 = 1;
pub const VK_AMD_MIXED_ATTACHMENT_SAMPLES_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_AMD_mixed_attachment_samples\0";
pub const VK_AMD_shader_fragment_mask: u32 = 1;
pub const VK_AMD_SHADER_FRAGMENT_MASK_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_FRAGMENT_MASK_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_AMD_shader_fragment_mask\0";
pub const VK_EXT_inline_uniform_block: u32 = 1;
pub const VK_EXT_INLINE_UNIFORM_BLOCK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_inline_uniform_block\0";
pub const VK_EXT_shader_stencil_export: u32 = 1;
pub const VK_EXT_SHADER_STENCIL_EXPORT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_STENCIL_EXPORT_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_shader_stencil_export\0";
pub const VK_EXT_sample_locations: u32 = 1;
pub const VK_EXT_SAMPLE_LOCATIONS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SAMPLE_LOCATIONS_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_sample_locations\0";
pub const VK_EXT_blend_operation_advanced: u32 = 1;
pub const VK_EXT_BLEND_OPERATION_ADVANCED_SPEC_VERSION: u32 = 2;
pub const VK_EXT_BLEND_OPERATION_ADVANCED_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_EXT_blend_operation_advanced\0";
pub const VK_NV_fragment_coverage_to_color: u32 = 1;
pub const VK_NV_FRAGMENT_COVERAGE_TO_COLOR_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_COVERAGE_TO_COLOR_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_NV_fragment_coverage_to_color\0";
pub const VK_NV_framebuffer_mixed_samples: u32 = 1;
pub const VK_NV_FRAMEBUFFER_MIXED_SAMPLES_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAMEBUFFER_MIXED_SAMPLES_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_NV_framebuffer_mixed_samples\0";
pub const VK_NV_fill_rectangle: u32 = 1;
pub const VK_NV_FILL_RECTANGLE_SPEC_VERSION: u32 = 1;
pub const VK_NV_FILL_RECTANGLE_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_NV_fill_rectangle\0";
pub const VK_NV_shader_sm_builtins: u32 = 1;
pub const VK_NV_SHADER_SM_BUILTINS_SPEC_VERSION: u32 = 1;
pub const VK_NV_SHADER_SM_BUILTINS_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NV_shader_sm_builtins\0";
pub const VK_EXT_post_depth_coverage: u32 = 1;
pub const VK_EXT_POST_DEPTH_COVERAGE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_POST_DEPTH_COVERAGE_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_post_depth_coverage\0";
pub const VK_EXT_image_drm_format_modifier: u32 = 1;
pub const VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_SPEC_VERSION: u32 = 2;
pub const VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_EXT_image_drm_format_modifier\0";
pub const VK_EXT_validation_cache: u32 = 1;
pub const VK_EXT_VALIDATION_CACHE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_VALIDATION_CACHE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_validation_cache\0";
pub const VK_EXT_descriptor_indexing: u32 = 1;
pub const VK_EXT_DESCRIPTOR_INDEXING_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_descriptor_indexing\0";
pub const VK_EXT_shader_viewport_index_layer: u32 = 1;
pub const VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_EXT_shader_viewport_index_layer\0";
pub const VK_NV_shading_rate_image: u32 = 1;
pub const VK_NV_SHADING_RATE_IMAGE_SPEC_VERSION: u32 = 3;
pub const VK_NV_SHADING_RATE_IMAGE_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NV_shading_rate_image\0";
pub const VK_NV_ray_tracing: u32 = 1;
pub const VK_NV_RAY_TRACING_SPEC_VERSION: u32 = 3;
pub const VK_NV_RAY_TRACING_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_NV_ray_tracing\0";
pub const VK_SHADER_UNUSED_KHR: i32 = -1;
pub const VK_SHADER_UNUSED_NV: i32 = -1;
pub const VK_NV_representative_fragment_test: u32 = 1;
pub const VK_NV_REPRESENTATIVE_FRAGMENT_TEST_SPEC_VERSION: u32 = 2;
pub const VK_NV_REPRESENTATIVE_FRAGMENT_TEST_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_NV_representative_fragment_test\0";
pub const VK_EXT_filter_cubic: u32 = 1;
pub const VK_EXT_FILTER_CUBIC_SPEC_VERSION: u32 = 3;
pub const VK_EXT_FILTER_CUBIC_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_filter_cubic\0";
pub const VK_QCOM_render_pass_shader_resolve: u32 = 1;
pub const VK_QCOM_RENDER_PASS_SHADER_RESOLVE_SPEC_VERSION: u32 = 4;
pub const VK_QCOM_RENDER_PASS_SHADER_RESOLVE_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_QCOM_render_pass_shader_resolve\0";
pub const VK_EXT_global_priority: u32 = 1;
pub const VK_EXT_GLOBAL_PRIORITY_SPEC_VERSION: u32 = 2;
pub const VK_EXT_GLOBAL_PRIORITY_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_EXT_global_priority\0";
pub const VK_EXT_external_memory_host: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_HOST_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_HOST_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_external_memory_host\0";
pub const VK_AMD_buffer_marker: u32 = 1;
pub const VK_AMD_BUFFER_MARKER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_BUFFER_MARKER_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_AMD_buffer_marker\0";
pub const VK_AMD_pipeline_compiler_control: u32 = 1;
pub const VK_AMD_PIPELINE_COMPILER_CONTROL_SPEC_VERSION: u32 = 1;
pub const VK_AMD_PIPELINE_COMPILER_CONTROL_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_AMD_pipeline_compiler_control\0";
pub const VK_EXT_calibrated_timestamps: u32 = 1;
pub const VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_CALIBRATED_TIMESTAMPS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_calibrated_timestamps\0";
pub const VK_AMD_shader_core_properties: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_SPEC_VERSION: u32 = 2;
pub const VK_AMD_SHADER_CORE_PROPERTIES_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_AMD_shader_core_properties\0";
pub const VK_AMD_memory_overallocation_behavior: u32 = 1;
pub const VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_SPEC_VERSION: u32 = 1;
pub const VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_AMD_memory_overallocation_behavior\0";
pub const VK_EXT_vertex_attribute_divisor: u32 = 1;
pub const VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION: u32 = 3;
pub const VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_EXT_vertex_attribute_divisor\0";
pub const VK_EXT_pipeline_creation_feedback: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_FEEDBACK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_EXT_pipeline_creation_feedback\0";
pub const VK_NV_shader_subgroup_partitioned: u32 = 1;
pub const VK_NV_SHADER_SUBGROUP_PARTITIONED_SPEC_VERSION: u32 = 1;
pub const VK_NV_SHADER_SUBGROUP_PARTITIONED_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_shader_subgroup_partitioned\0";
pub const VK_NV_compute_shader_derivatives: u32 = 1;
pub const VK_NV_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION: u32 = 1;
pub const VK_NV_COMPUTE_SHADER_DERIVATIVES_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_NV_compute_shader_derivatives\0";
pub const VK_NV_mesh_shader: u32 = 1;
pub const VK_NV_MESH_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_NV_MESH_SHADER_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_NV_mesh_shader\0";
pub const VK_NV_fragment_shader_barycentric: u32 = 1;
pub const VK_NV_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_fragment_shader_barycentric\0";
pub const VK_NV_shader_image_footprint: u32 = 1;
pub const VK_NV_SHADER_IMAGE_FOOTPRINT_SPEC_VERSION: u32 = 2;
pub const VK_NV_SHADER_IMAGE_FOOTPRINT_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_NV_shader_image_footprint\0";
pub const VK_NV_scissor_exclusive: u32 = 1;
pub const VK_NV_SCISSOR_EXCLUSIVE_SPEC_VERSION: u32 = 1;
pub const VK_NV_SCISSOR_EXCLUSIVE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_NV_scissor_exclusive\0";
pub const VK_NV_device_diagnostic_checkpoints: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION: u32 = 2;
pub const VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_NV_device_diagnostic_checkpoints\0";
pub const VK_INTEL_shader_integer_functions2: u32 = 1;
pub const VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_SPEC_VERSION: u32 = 1;
pub const VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_INTEL_shader_integer_functions2\0";
pub const VK_INTEL_performance_query: u32 = 1;
pub const VK_INTEL_PERFORMANCE_QUERY_SPEC_VERSION: u32 = 2;
pub const VK_INTEL_PERFORMANCE_QUERY_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_INTEL_performance_query\0";
pub const VK_EXT_pci_bus_info: u32 = 1;
pub const VK_EXT_PCI_BUS_INFO_SPEC_VERSION: u32 = 2;
pub const VK_EXT_PCI_BUS_INFO_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_pci_bus_info\0";
pub const VK_AMD_display_native_hdr: u32 = 1;
pub const VK_AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION: u32 = 1;
pub const VK_AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_AMD_display_native_hdr\0";
pub const VK_EXT_fragment_density_map: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_SPEC_VERSION: u32 = 2;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_fragment_density_map\0";
pub const VK_EXT_scalar_block_layout: u32 = 1;
pub const VK_EXT_SCALAR_BLOCK_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SCALAR_BLOCK_LAYOUT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_scalar_block_layout\0";
pub const VK_GOOGLE_hlsl_functionality1: u32 = 1;
pub const VK_GOOGLE_HLSL_FUNCTIONALITY_1_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_HLSL_FUNCTIONALITY_1_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_GOOGLE_hlsl_functionality1\0";
pub const VK_GOOGLE_HLSL_FUNCTIONALITY1_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_HLSL_FUNCTIONALITY1_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_GOOGLE_hlsl_functionality1\0";
pub const VK_GOOGLE_decorate_string: u32 = 1;
pub const VK_GOOGLE_DECORATE_STRING_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_DECORATE_STRING_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_GOOGLE_decorate_string\0";
pub const VK_EXT_subgroup_size_control: u32 = 1;
pub const VK_EXT_SUBGROUP_SIZE_CONTROL_SPEC_VERSION: u32 = 2;
pub const VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_subgroup_size_control\0";
pub const VK_AMD_shader_core_properties2: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_2_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_2_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_AMD_shader_core_properties2\0";
pub const VK_AMD_device_coherent_memory: u32 = 1;
pub const VK_AMD_DEVICE_COHERENT_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_AMD_DEVICE_COHERENT_MEMORY_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_AMD_device_coherent_memory\0";
pub const VK_EXT_shader_image_atomic_int64: u32 = 1;
pub const VK_EXT_SHADER_IMAGE_ATOMIC_INT64_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_IMAGE_ATOMIC_INT64_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_EXT_shader_image_atomic_int64\0";
pub const VK_EXT_memory_budget: u32 = 1;
pub const VK_EXT_MEMORY_BUDGET_SPEC_VERSION: u32 = 1;
pub const VK_EXT_MEMORY_BUDGET_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_EXT_memory_budget\0";
pub const VK_EXT_memory_priority: u32 = 1;
pub const VK_EXT_MEMORY_PRIORITY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_MEMORY_PRIORITY_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_EXT_memory_priority\0";
pub const VK_NV_dedicated_allocation_image_aliasing: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_EXTENSION_NAME: &'static [u8; 42usize] =
    b"VK_NV_dedicated_allocation_image_aliasing\0";
pub const VK_EXT_buffer_device_address: u32 = 1;
pub const VK_EXT_BUFFER_DEVICE_ADDRESS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_buffer_device_address\0";
pub const VK_EXT_tooling_info: u32 = 1;
pub const VK_EXT_TOOLING_INFO_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TOOLING_INFO_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_tooling_info\0";
pub const VK_EXT_separate_stencil_usage: u32 = 1;
pub const VK_EXT_SEPARATE_STENCIL_USAGE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SEPARATE_STENCIL_USAGE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_separate_stencil_usage\0";
pub const VK_EXT_validation_features: u32 = 1;
pub const VK_EXT_VALIDATION_FEATURES_SPEC_VERSION: u32 = 5;
pub const VK_EXT_VALIDATION_FEATURES_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_validation_features\0";
pub const VK_NV_cooperative_matrix: u32 = 1;
pub const VK_NV_COOPERATIVE_MATRIX_SPEC_VERSION: u32 = 1;
pub const VK_NV_COOPERATIVE_MATRIX_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NV_cooperative_matrix\0";
pub const VK_NV_coverage_reduction_mode: u32 = 1;
pub const VK_NV_COVERAGE_REDUCTION_MODE_SPEC_VERSION: u32 = 1;
pub const VK_NV_COVERAGE_REDUCTION_MODE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_NV_coverage_reduction_mode\0";
pub const VK_EXT_fragment_shader_interlock: u32 = 1;
pub const VK_EXT_FRAGMENT_SHADER_INTERLOCK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_SHADER_INTERLOCK_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_EXT_fragment_shader_interlock\0";
pub const VK_EXT_ycbcr_image_arrays: u32 = 1;
pub const VK_EXT_YCBCR_IMAGE_ARRAYS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_YCBCR_IMAGE_ARRAYS_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_ycbcr_image_arrays\0";
pub const VK_EXT_provoking_vertex: u32 = 1;
pub const VK_EXT_PROVOKING_VERTEX_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PROVOKING_VERTEX_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_provoking_vertex\0";
pub const VK_EXT_headless_surface: u32 = 1;
pub const VK_EXT_HEADLESS_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_HEADLESS_SURFACE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_headless_surface\0";
pub const VK_EXT_line_rasterization: u32 = 1;
pub const VK_EXT_LINE_RASTERIZATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_LINE_RASTERIZATION_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_line_rasterization\0";
pub const VK_EXT_shader_atomic_float: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_shader_atomic_float\0";
pub const VK_EXT_host_query_reset: u32 = 1;
pub const VK_EXT_HOST_QUERY_RESET_SPEC_VERSION: u32 = 1;
pub const VK_EXT_HOST_QUERY_RESET_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_host_query_reset\0";
pub const VK_EXT_index_type_uint8: u32 = 1;
pub const VK_EXT_INDEX_TYPE_UINT8_SPEC_VERSION: u32 = 1;
pub const VK_EXT_INDEX_TYPE_UINT8_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_index_type_uint8\0";
pub const VK_EXT_extended_dynamic_state: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_extended_dynamic_state\0";
pub const VK_EXT_shader_atomic_float2: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_2_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_shader_atomic_float2\0";
pub const VK_EXT_shader_demote_to_helper_invocation: u32 = 1;
pub const VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION_NAME: &'static [u8; 42usize] =
    b"VK_EXT_shader_demote_to_helper_invocation\0";
pub const VK_NV_device_generated_commands: u32 = 1;
pub const VK_NV_DEVICE_GENERATED_COMMANDS_SPEC_VERSION: u32 = 3;
pub const VK_NV_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_NV_device_generated_commands\0";
pub const VK_NV_inherited_viewport_scissor: u32 = 1;
pub const VK_NV_INHERITED_VIEWPORT_SCISSOR_SPEC_VERSION: u32 = 1;
pub const VK_NV_INHERITED_VIEWPORT_SCISSOR_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_NV_inherited_viewport_scissor\0";
pub const VK_EXT_texel_buffer_alignment: u32 = 1;
pub const VK_EXT_TEXEL_BUFFER_ALIGNMENT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_texel_buffer_alignment\0";
pub const VK_QCOM_render_pass_transform: u32 = 1;
pub const VK_QCOM_RENDER_PASS_TRANSFORM_SPEC_VERSION: u32 = 2;
pub const VK_QCOM_RENDER_PASS_TRANSFORM_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_QCOM_render_pass_transform\0";
pub const VK_EXT_device_memory_report: u32 = 1;
pub const VK_EXT_DEVICE_MEMORY_REPORT_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DEVICE_MEMORY_REPORT_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_device_memory_report\0";
pub const VK_EXT_acquire_drm_display: u32 = 1;
pub const VK_EXT_ACQUIRE_DRM_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ACQUIRE_DRM_DISPLAY_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_acquire_drm_display\0";
pub const VK_EXT_robustness2: u32 = 1;
pub const VK_EXT_ROBUSTNESS_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ROBUSTNESS_2_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_EXT_robustness2\0";
pub const VK_EXT_custom_border_color: u32 = 1;
pub const VK_EXT_CUSTOM_BORDER_COLOR_SPEC_VERSION: u32 = 12;
pub const VK_EXT_CUSTOM_BORDER_COLOR_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_custom_border_color\0";
pub const VK_GOOGLE_user_type: u32 = 1;
pub const VK_GOOGLE_USER_TYPE_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_USER_TYPE_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_GOOGLE_user_type\0";
pub const VK_EXT_private_data: u32 = 1;
pub const VK_EXT_PRIVATE_DATA_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PRIVATE_DATA_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_private_data\0";
pub const VK_EXT_pipeline_creation_cache_control: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_SPEC_VERSION: u32 = 3;
pub const VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION_NAME: &'static [u8; 39usize] =
    b"VK_EXT_pipeline_creation_cache_control\0";
pub const VK_NV_device_diagnostics_config: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTICS_CONFIG_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTICS_CONFIG_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_NV_device_diagnostics_config\0";
pub const VK_QCOM_render_pass_store_ops: u32 = 1;
pub const VK_QCOM_RENDER_PASS_STORE_OPS_SPEC_VERSION: u32 = 2;
pub const VK_QCOM_RENDER_PASS_STORE_OPS_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_QCOM_render_pass_store_ops\0";
pub const VK_EXT_graphics_pipeline_library: u32 = 1;
pub const VK_EXT_GRAPHICS_PIPELINE_LIBRARY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_GRAPHICS_PIPELINE_LIBRARY_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_EXT_graphics_pipeline_library\0";
pub const VK_NV_fragment_shading_rate_enums: u32 = 1;
pub const VK_NV_FRAGMENT_SHADING_RATE_ENUMS_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_SHADING_RATE_ENUMS_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_fragment_shading_rate_enums\0";
pub const VK_NV_ray_tracing_motion_blur: u32 = 1;
pub const VK_NV_RAY_TRACING_MOTION_BLUR_SPEC_VERSION: u32 = 1;
pub const VK_NV_RAY_TRACING_MOTION_BLUR_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_NV_ray_tracing_motion_blur\0";
pub const VK_EXT_ycbcr_2plane_444_formats: u32 = 1;
pub const VK_EXT_YCBCR_2PLANE_444_FORMATS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_YCBCR_2PLANE_444_FORMATS_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_EXT_ycbcr_2plane_444_formats\0";
pub const VK_EXT_fragment_density_map2: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_2_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_fragment_density_map2\0";
pub const VK_QCOM_rotated_copy_commands: u32 = 1;
pub const VK_QCOM_ROTATED_COPY_COMMANDS_SPEC_VERSION: u32 = 1;
pub const VK_QCOM_ROTATED_COPY_COMMANDS_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_QCOM_rotated_copy_commands\0";
pub const VK_EXT_image_robustness: u32 = 1;
pub const VK_EXT_IMAGE_ROBUSTNESS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_IMAGE_ROBUSTNESS_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_image_robustness\0";
pub const VK_EXT_4444_formats: u32 = 1;
pub const VK_EXT_4444_FORMATS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_4444_FORMATS_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_4444_formats\0";
pub const VK_ARM_rasterization_order_attachment_access: u32 = 1;
pub const VK_ARM_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_SPEC_VERSION: u32 = 1;
pub const VK_ARM_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_EXTENSION_NAME: &'static [u8; 45usize] =
    b"VK_ARM_rasterization_order_attachment_access\0";
pub const VK_EXT_rgba10x6_formats: u32 = 1;
pub const VK_EXT_RGBA10X6_FORMATS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_RGBA10X6_FORMATS_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_rgba10x6_formats\0";
pub const VK_NV_acquire_winrt_display: u32 = 1;
pub const VK_NV_ACQUIRE_WINRT_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_NV_ACQUIRE_WINRT_DISPLAY_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_NV_acquire_winrt_display\0";
pub const VK_VALVE_mutable_descriptor_type: u32 = 1;
pub const VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_SPEC_VERSION: u32 = 1;
pub const VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_VALVE_mutable_descriptor_type\0";
pub const VK_EXT_vertex_input_dynamic_state: u32 = 1;
pub const VK_EXT_VERTEX_INPUT_DYNAMIC_STATE_SPEC_VERSION: u32 = 2;
pub const VK_EXT_VERTEX_INPUT_DYNAMIC_STATE_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_EXT_vertex_input_dynamic_state\0";
pub const VK_EXT_physical_device_drm: u32 = 1;
pub const VK_EXT_PHYSICAL_DEVICE_DRM_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PHYSICAL_DEVICE_DRM_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_physical_device_drm\0";
pub const VK_EXT_depth_clip_control: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_CONTROL_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_CONTROL_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_depth_clip_control\0";
pub const VK_EXT_primitive_topology_list_restart: u32 = 1;
pub const VK_EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PRIMITIVE_TOPOLOGY_LIST_RESTART_EXTENSION_NAME: &'static [u8; 39usize] =
    b"VK_EXT_primitive_topology_list_restart\0";
pub const VK_HUAWEI_subpass_shading: u32 = 1;
pub const VK_HUAWEI_SUBPASS_SHADING_SPEC_VERSION: u32 = 2;
pub const VK_HUAWEI_SUBPASS_SHADING_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_HUAWEI_subpass_shading\0";
pub const VK_HUAWEI_invocation_mask: u32 = 1;
pub const VK_HUAWEI_INVOCATION_MASK_SPEC_VERSION: u32 = 1;
pub const VK_HUAWEI_INVOCATION_MASK_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_HUAWEI_invocation_mask\0";
pub const VK_NV_external_memory_rdma: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_RDMA_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_RDMA_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_NV_external_memory_rdma\0";
pub const VK_EXT_extended_dynamic_state2: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_2_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_EXT_extended_dynamic_state2\0";
pub const VK_EXT_color_write_enable: u32 = 1;
pub const VK_EXT_COLOR_WRITE_ENABLE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_COLOR_WRITE_ENABLE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_color_write_enable\0";
pub const VK_EXT_primitives_generated_query: u32 = 1;
pub const VK_EXT_PRIMITIVES_GENERATED_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PRIMITIVES_GENERATED_QUERY_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_EXT_primitives_generated_query\0";
pub const VK_EXT_global_priority_query: u32 = 1;
pub const VK_EXT_GLOBAL_PRIORITY_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_GLOBAL_PRIORITY_QUERY_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_global_priority_query\0";
pub const VK_MAX_GLOBAL_PRIORITY_SIZE_EXT: u32 = 16;
pub const VK_EXT_image_view_min_lod: u32 = 1;
pub const VK_EXT_IMAGE_VIEW_MIN_LOD_SPEC_VERSION: u32 = 1;
pub const VK_EXT_IMAGE_VIEW_MIN_LOD_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_image_view_min_lod\0";
pub const VK_EXT_multi_draw: u32 = 1;
pub const VK_EXT_MULTI_DRAW_SPEC_VERSION: u32 = 1;
pub const VK_EXT_MULTI_DRAW_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_EXT_multi_draw\0";
pub const VK_EXT_image_2d_view_of_3d: u32 = 1;
pub const VK_EXT_IMAGE_2D_VIEW_OF_3D_SPEC_VERSION: u32 = 1;
pub const VK_EXT_IMAGE_2D_VIEW_OF_3D_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_image_2d_view_of_3d\0";
pub const VK_EXT_load_store_op_none: u32 = 1;
pub const VK_EXT_LOAD_STORE_OP_NONE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_LOAD_STORE_OP_NONE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_load_store_op_none\0";
pub const VK_EXT_border_color_swizzle: u32 = 1;
pub const VK_EXT_BORDER_COLOR_SWIZZLE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_BORDER_COLOR_SWIZZLE_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_border_color_swizzle\0";
pub const VK_EXT_pageable_device_local_memory: u32 = 1;
pub const VK_EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PAGEABLE_DEVICE_LOCAL_MEMORY_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_EXT_pageable_device_local_memory\0";
pub const VK_VALVE_descriptor_set_host_mapping: u32 = 1;
pub const VK_VALVE_DESCRIPTOR_SET_HOST_MAPPING_SPEC_VERSION: u32 = 1;
pub const VK_VALVE_DESCRIPTOR_SET_HOST_MAPPING_EXTENSION_NAME: &'static [u8; 37usize] =
    b"VK_VALVE_descriptor_set_host_mapping\0";
pub const VK_QCOM_fragment_density_map_offset: u32 = 1;
pub const VK_QCOM_FRAGMENT_DENSITY_MAP_OFFSET_SPEC_VERSION: u32 = 1;
pub const VK_QCOM_FRAGMENT_DENSITY_MAP_OFFSET_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_QCOM_fragment_density_map_offset\0";
pub const VK_NV_linear_color_attachment: u32 = 1;
pub const VK_NV_LINEAR_COLOR_ATTACHMENT_SPEC_VERSION: u32 = 1;
pub const VK_NV_LINEAR_COLOR_ATTACHMENT_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_NV_linear_color_attachment\0";
pub const VK_GOOGLE_surfaceless_query: u32 = 1;
pub const VK_GOOGLE_SURFACELESS_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_SURFACELESS_QUERY_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_GOOGLE_surfaceless_query\0";
pub const VK_KHR_acceleration_structure: u32 = 1;
pub const VK_KHR_ACCELERATION_STRUCTURE_SPEC_VERSION: u32 = 13;
pub const VK_KHR_ACCELERATION_STRUCTURE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_KHR_acceleration_structure\0";
pub const VK_KHR_ray_tracing_pipeline: u32 = 1;
pub const VK_KHR_RAY_TRACING_PIPELINE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RAY_TRACING_PIPELINE_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_KHR_ray_tracing_pipeline\0";
pub const VK_KHR_ray_query: u32 = 1;
pub const VK_KHR_RAY_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RAY_QUERY_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_ray_query\0";
pub const VULKAN_ANDROID_H_: u32 = 1;
pub const VK_KHR_android_surface: u32 = 1;
pub const VK_KHR_ANDROID_SURFACE_SPEC_VERSION: u32 = 6;
pub const VK_KHR_ANDROID_SURFACE_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_KHR_android_surface\0";
pub const VK_ANDROID_external_memory_android_hardware_buffer: u32 = 1;
pub const VK_ANDROID_EXTERNAL_MEMORY_ANDROID_HARDWARE_BUFFER_SPEC_VERSION: u32 = 5;
pub const VK_ANDROID_EXTERNAL_MEMORY_ANDROID_HARDWARE_BUFFER_EXTENSION_NAME: &'static [u8;
             51usize] = b"VK_ANDROID_external_memory_android_hardware_buffer\0";
pub const VULKAN_BETA_H_: u32 = 1;
pub const VK_KHR_video_queue: u32 = 1;
pub const VK_KHR_VIDEO_QUEUE_SPEC_VERSION: u32 = 3;
pub const VK_KHR_VIDEO_QUEUE_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_KHR_video_queue\0";
pub const VK_KHR_video_decode_queue: u32 = 1;
pub const VK_KHR_VIDEO_DECODE_QUEUE_SPEC_VERSION: u32 = 4;
pub const VK_KHR_VIDEO_DECODE_QUEUE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_video_decode_queue\0";
pub const VK_KHR_portability_subset: u32 = 1;
pub const VK_KHR_PORTABILITY_SUBSET_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PORTABILITY_SUBSET_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_portability_subset\0";
pub const VK_KHR_video_encode_queue: u32 = 1;
pub const VK_KHR_VIDEO_ENCODE_QUEUE_SPEC_VERSION: u32 = 5;
pub const VK_KHR_VIDEO_ENCODE_QUEUE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_video_encode_queue\0";
pub const VK_EXT_video_encode_h264: u32 = 1;
pub const VULKAN_VIDEO_CODEC_H264STD_H_: u32 = 1;
pub const vulkan_video_codec_h264std: u32 = 1;
pub const STD_VIDEO_H264_CPB_CNT_LIST_SIZE: u32 = 32;
pub const STD_VIDEO_H264_SCALING_LIST_4X4_NUM_LISTS: u32 = 6;
pub const STD_VIDEO_H264_SCALING_LIST_4X4_NUM_ELEMENTS: u32 = 16;
pub const STD_VIDEO_H264_SCALING_LIST_8X8_NUM_LISTS: u32 = 2;
pub const STD_VIDEO_H264_SCALING_LIST_8X8_NUM_ELEMENTS: u32 = 64;
pub const STD_VIDEO_H264_MAX_NUM_LIST_REF: u32 = 32;
pub const STD_VIDEO_H264_MAX_CHROMA_PLANES: u32 = 2;
pub const VULKAN_VIDEO_CODEC_H264STD_ENCODE_H_: u32 = 1;
pub const vulkan_video_codec_h264std_encode: u32 = 1;
pub const VK_STD_VULKAN_VIDEO_CODEC_H264_ENCODE_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_STD_vulkan_video_codec_h264_encode\0";
pub const VK_EXT_VIDEO_ENCODE_H264_SPEC_VERSION: u32 = 7;
pub const VK_EXT_VIDEO_ENCODE_H264_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_EXT_video_encode_h264\0";
pub const VK_EXT_video_encode_h265: u32 = 1;
pub const VULKAN_VIDEO_CODEC_H265STD_H_: u32 = 1;
pub const vulkan_video_codec_h265std: u32 = 1;
pub const STD_VIDEO_H265_SUBLAYERS_MINUS1_LIST_SIZE: u32 = 7;
pub const STD_VIDEO_H265_CPB_CNT_LIST_SIZE: u32 = 32;
pub const STD_VIDEO_H265_SCALING_LIST_4X4_NUM_LISTS: u32 = 6;
pub const STD_VIDEO_H265_SCALING_LIST_4X4_NUM_ELEMENTS: u32 = 16;
pub const STD_VIDEO_H265_SCALING_LIST_8X8_NUM_LISTS: u32 = 6;
pub const STD_VIDEO_H265_SCALING_LIST_8X8_NUM_ELEMENTS: u32 = 64;
pub const STD_VIDEO_H265_SCALING_LIST_16X16_NUM_LISTS: u32 = 6;
pub const STD_VIDEO_H265_SCALING_LIST_16X16_NUM_ELEMENTS: u32 = 64;
pub const STD_VIDEO_H265_SCALING_LIST_32X32_NUM_LISTS: u32 = 2;
pub const STD_VIDEO_H265_SCALING_LIST_32X32_NUM_ELEMENTS: u32 = 64;
pub const STD_VIDEO_H265_PREDICTOR_PALETTE_COMPONENTS_LIST_SIZE: u32 = 3;
pub const STD_VIDEO_H265_PREDICTOR_PALETTE_COMP_ENTRIES_LIST_SIZE: u32 = 128;
pub const STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_COLS_LIST_SIZE: u32 = 19;
pub const STD_VIDEO_H265_CHROMA_QP_OFFSET_TILE_ROWS_LIST_SIZE: u32 = 21;
pub const STD_VIDEO_H265_CHROMA_QP_OFFSET_LIST_SIZE: u32 = 6;
pub const STD_VIDEO_H265_MAX_NUM_LIST_REF: u32 = 15;
pub const STD_VIDEO_H265_MAX_CHROMA_PLANES: u32 = 2;
pub const VULKAN_VIDEO_CODEC_H265STD_ENCODE_H_: u32 = 1;
pub const vulkan_video_codec_h265std_encode: u32 = 1;
pub const VK_STD_VULKAN_VIDEO_CODEC_H265_ENCODE_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_STD_vulkan_video_codec_h265_encode\0";
pub const VK_EXT_VIDEO_ENCODE_H265_SPEC_VERSION: u32 = 7;
pub const VK_EXT_VIDEO_ENCODE_H265_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_EXT_video_encode_h265\0";
pub const VK_EXT_video_decode_h264: u32 = 1;
pub const VULKAN_VIDEO_CODEC_H264STD_DECODE_H_: u32 = 1;
pub const vulkan_video_codec_h264std_decode: u32 = 1;
pub const STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_LIST_SIZE: u32 = 2;
pub const STD_VIDEO_DECODE_H264_MVC_REF_LIST_SIZE: u32 = 15;
pub const VK_STD_VULKAN_VIDEO_CODEC_H264_DECODE_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_STD_vulkan_video_codec_h264_decode\0";
pub const VK_EXT_VIDEO_DECODE_H264_SPEC_VERSION: u32 = 5;
pub const VK_EXT_VIDEO_DECODE_H264_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_EXT_video_decode_h264\0";
pub const VK_EXT_video_decode_h265: u32 = 1;
pub const VULKAN_VIDEO_CODEC_H265STD_DECODE_H_: u32 = 1;
pub const vulkan_video_codec_h265std_decode: u32 = 1;
pub const STD_VIDEO_DECODE_H265_REF_PIC_SET_LIST_SIZE: u32 = 8;
pub const VK_STD_VULKAN_VIDEO_CODEC_H265_DECODE_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_STD_vulkan_video_codec_h265_decode\0";
pub const VK_EXT_VIDEO_DECODE_H265_SPEC_VERSION: u32 = 3;
pub const VK_EXT_VIDEO_DECODE_H265_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_EXT_video_decode_h265\0";
pub const VULKAN_DIRECTFB_H_: u32 = 1;
pub const VK_EXT_directfb_surface: u32 = 1;
pub const VK_EXT_DIRECTFB_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DIRECTFB_SURFACE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_directfb_surface\0";
pub const VULKAN_FUCHSIA_H_: u32 = 1;
pub const VK_FUCHSIA_imagepipe_surface: u32 = 1;
pub const VK_FUCHSIA_IMAGEPIPE_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_FUCHSIA_IMAGEPIPE_SURFACE_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_FUCHSIA_imagepipe_surface\0";
pub const VK_FUCHSIA_external_memory: u32 = 1;
pub const VK_FUCHSIA_EXTERNAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_FUCHSIA_EXTERNAL_MEMORY_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_FUCHSIA_external_memory\0";
pub const VK_FUCHSIA_external_semaphore: u32 = 1;
pub const VK_FUCHSIA_EXTERNAL_SEMAPHORE_SPEC_VERSION: u32 = 1;
pub const VK_FUCHSIA_EXTERNAL_SEMAPHORE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_FUCHSIA_external_semaphore\0";
pub const VK_FUCHSIA_buffer_collection: u32 = 1;
pub const VK_FUCHSIA_BUFFER_COLLECTION_SPEC_VERSION: u32 = 2;
pub const VK_FUCHSIA_BUFFER_COLLECTION_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_FUCHSIA_buffer_collection\0";
pub const VULKAN_IOS_H_: u32 = 1;
pub const VK_MVK_ios_surface: u32 = 1;
pub const VK_MVK_IOS_SURFACE_SPEC_VERSION: u32 = 3;
pub const VK_MVK_IOS_SURFACE_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_MVK_ios_surface\0";
pub const VULKAN_MACOS_H_: u32 = 1;
pub const VK_MVK_macos_surface: u32 = 1;
pub const VK_MVK_MACOS_SURFACE_SPEC_VERSION: u32 = 3;
pub const VK_MVK_MACOS_SURFACE_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_MVK_macos_surface\0";
pub const VULKAN_METAL_H_: u32 = 1;
pub const VK_EXT_metal_surface: u32 = 1;
pub const VK_EXT_METAL_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_METAL_SURFACE_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_EXT_metal_surface\0";
pub const VULKAN_SCREEN_H_: u32 = 1;
pub const VK_QNX_screen_surface: u32 = 1;
pub const VK_QNX_SCREEN_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_QNX_SCREEN_SURFACE_EXTENSION_NAME: &'static [u8; 22usize] = b"VK_QNX_screen_surface\0";
pub const VULKAN_VI_H_: u32 = 1;
pub const VK_NN_vi_surface: u32 = 1;
pub const VK_NN_VI_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_NN_VI_SURFACE_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_NN_vi_surface\0";
pub const VULKAN_WAYLAND_H_: u32 = 1;
pub const VK_KHR_wayland_surface: u32 = 1;
pub const VK_KHR_WAYLAND_SURFACE_SPEC_VERSION: u32 = 6;
pub const VK_KHR_WAYLAND_SURFACE_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_KHR_wayland_surface\0";
pub const VULKAN_WIN32_H_: u32 = 1;
pub const VK_KHR_win32_surface: u32 = 1;
pub const VK_KHR_WIN32_SURFACE_SPEC_VERSION: u32 = 6;
pub const VK_KHR_WIN32_SURFACE_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_KHR_win32_surface\0";
pub const VK_KHR_external_memory_win32: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_WIN32_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_external_memory_win32\0";
pub const VK_KHR_win32_keyed_mutex: u32 = 1;
pub const VK_KHR_WIN32_KEYED_MUTEX_SPEC_VERSION: u32 = 1;
pub const VK_KHR_WIN32_KEYED_MUTEX_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_win32_keyed_mutex\0";
pub const VK_KHR_external_semaphore_win32: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_WIN32_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_WIN32_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_external_semaphore_win32\0";
pub const VK_KHR_external_fence_win32: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_WIN32_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_WIN32_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_KHR_external_fence_win32\0";
pub const VK_NV_external_memory_win32: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_WIN32_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_WIN32_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_NV_external_memory_win32\0";
pub const VK_NV_win32_keyed_mutex: u32 = 1;
pub const VK_NV_WIN32_KEYED_MUTEX_SPEC_VERSION: u32 = 2;
pub const VK_NV_WIN32_KEYED_MUTEX_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_NV_win32_keyed_mutex\0";
pub const VK_EXT_full_screen_exclusive: u32 = 1;
pub const VK_EXT_FULL_SCREEN_EXCLUSIVE_SPEC_VERSION: u32 = 4;
pub const VK_EXT_FULL_SCREEN_EXCLUSIVE_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_full_screen_exclusive\0";
pub const VULKAN_XCB_H_: u32 = 1;
pub const VK_KHR_xcb_surface: u32 = 1;
pub const VK_KHR_XCB_SURFACE_SPEC_VERSION: u32 = 6;
pub const VK_KHR_XCB_SURFACE_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_KHR_xcb_surface\0";
pub const VULKAN_XLIB_H_: u32 = 1;
pub const VK_KHR_xlib_surface: u32 = 1;
pub const VK_KHR_XLIB_SURFACE_SPEC_VERSION: u32 = 6;
pub const VK_KHR_XLIB_SURFACE_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_xlib_surface\0";
pub const VULKAN_XLIB_XRANDR_H_: u32 = 1;
pub const VK_EXT_acquire_xlib_display: u32 = 1;
pub const VK_EXT_ACQUIRE_XLIB_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ACQUIRE_XLIB_DISPLAY_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_acquire_xlib_display\0";
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type VkBool32 = u32;
pub type VkDeviceAddress = u64;
pub type VkDeviceSize = u64;
pub type VkFlags = u32;
pub type VkSampleMask = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBuffer_T {
    _unused: [u8; 0],
}
pub type VkBuffer = *mut VkBuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImage_T {
    _unused: [u8; 0],
}
pub type VkImage = *mut VkImage_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInstance_T {
    _unused: [u8; 0],
}
pub type VkInstance = *mut VkInstance_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice_T {
    _unused: [u8; 0],
}
pub type VkPhysicalDevice = *mut VkPhysicalDevice_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDevice_T {
    _unused: [u8; 0],
}
pub type VkDevice = *mut VkDevice_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueue_T {
    _unused: [u8; 0],
}
pub type VkQueue = *mut VkQueue_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphore_T {
    _unused: [u8; 0],
}
pub type VkSemaphore = *mut VkSemaphore_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBuffer_T {
    _unused: [u8; 0],
}
pub type VkCommandBuffer = *mut VkCommandBuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFence_T {
    _unused: [u8; 0],
}
pub type VkFence = *mut VkFence_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemory_T {
    _unused: [u8; 0],
}
pub type VkDeviceMemory = *mut VkDeviceMemory_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkEvent_T {
    _unused: [u8; 0],
}
pub type VkEvent = *mut VkEvent_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPool_T {
    _unused: [u8; 0],
}
pub type VkQueryPool = *mut VkQueryPool_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferView_T {
    _unused: [u8; 0],
}
pub type VkBufferView = *mut VkBufferView_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageView_T {
    _unused: [u8; 0],
}
pub type VkImageView = *mut VkImageView_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModule_T {
    _unused: [u8; 0],
}
pub type VkShaderModule = *mut VkShaderModule_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCache_T {
    _unused: [u8; 0],
}
pub type VkPipelineCache = *mut VkPipelineCache_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLayout_T {
    _unused: [u8; 0],
}
pub type VkPipelineLayout = *mut VkPipelineLayout_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipeline_T {
    _unused: [u8; 0],
}
pub type VkPipeline = *mut VkPipeline_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPass_T {
    _unused: [u8; 0],
}
pub type VkRenderPass = *mut VkRenderPass_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayout_T {
    _unused: [u8; 0],
}
pub type VkDescriptorSetLayout = *mut VkDescriptorSetLayout_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSampler_T {
    _unused: [u8; 0],
}
pub type VkSampler = *mut VkSampler_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSet_T {
    _unused: [u8; 0],
}
pub type VkDescriptorSet = *mut VkDescriptorSet_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPool_T {
    _unused: [u8; 0],
}
pub type VkDescriptorPool = *mut VkDescriptorPool_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebuffer_T {
    _unused: [u8; 0],
}
pub type VkFramebuffer = *mut VkFramebuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandPool_T {
    _unused: [u8; 0],
}
pub type VkCommandPool = *mut VkCommandPool_T;
pub const VK_SUCCESS: VkResult = 0;
pub const VK_NOT_READY: VkResult = 1;
pub const VK_TIMEOUT: VkResult = 2;
pub const VK_EVENT_SET: VkResult = 3;
pub const VK_EVENT_RESET: VkResult = 4;
pub const VK_INCOMPLETE: VkResult = 5;
pub const VK_ERROR_OUT_OF_HOST_MEMORY: VkResult = -1;
pub const VK_ERROR_OUT_OF_DEVICE_MEMORY: VkResult = -2;
pub const VK_ERROR_INITIALIZATION_FAILED: VkResult = -3;
pub const VK_ERROR_DEVICE_LOST: VkResult = -4;
pub const VK_ERROR_MEMORY_MAP_FAILED: VkResult = -5;
pub const VK_ERROR_LAYER_NOT_PRESENT: VkResult = -6;
pub const VK_ERROR_EXTENSION_NOT_PRESENT: VkResult = -7;
pub const VK_ERROR_FEATURE_NOT_PRESENT: VkResult = -8;
pub const VK_ERROR_INCOMPATIBLE_DRIVER: VkResult = -9;
pub const VK_ERROR_TOO_MANY_OBJECTS: VkResult = -10;
pub const VK_ERROR_FORMAT_NOT_SUPPORTED: VkResult = -11;
pub const VK_ERROR_FRAGMENTED_POOL: VkResult = -12;
pub const VK_ERROR_UNKNOWN: VkResult = -13;
pub const VK_ERROR_OUT_OF_POOL_MEMORY: VkResult = -1000069000;
pub const VK_ERROR_INVALID_EXTERNAL_HANDLE: VkResult = -1000072003;
pub const VK_ERROR_FRAGMENTATION: VkResult = -1000161000;
pub const VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS: VkResult = -1000257000;
pub const VK_PIPELINE_COMPILE_REQUIRED: VkResult = 1000297000;
pub const VK_ERROR_SURFACE_LOST_KHR: VkResult = -1000000000;
pub const VK_ERROR_NATIVE_WINDOW_IN_USE_KHR: VkResult = -1000000001;
pub const VK_SUBOPTIMAL_KHR: VkResult = 1000001003;
pub const VK_ERROR_OUT_OF_DATE_KHR: VkResult = -1000001004;
pub const VK_ERROR_INCOMPATIBLE_DISPLAY_KHR: VkResult = -1000003001;
pub const VK_ERROR_VALIDATION_FAILED_EXT: VkResult = -1000011001;
pub const VK_ERROR_INVALID_SHADER_NV: VkResult = -1000012000;
pub const VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT: VkResult = -1000158000;
pub const VK_ERROR_NOT_PERMITTED_KHR: VkResult = -1000174001;
pub const VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT: VkResult = -1000255000;
pub const VK_THREAD_IDLE_KHR: VkResult = 1000268000;
pub const VK_THREAD_DONE_KHR: VkResult = 1000268001;
pub const VK_OPERATION_DEFERRED_KHR: VkResult = 1000268002;
pub const VK_OPERATION_NOT_DEFERRED_KHR: VkResult = 1000268003;
pub const VK_ERROR_OUT_OF_POOL_MEMORY_KHR: VkResult = -1000069000;
pub const VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR: VkResult = -1000072003;
pub const VK_ERROR_FRAGMENTATION_EXT: VkResult = -1000161000;
pub const VK_ERROR_NOT_PERMITTED_EXT: VkResult = -1000174001;
pub const VK_ERROR_INVALID_DEVICE_ADDRESS_EXT: VkResult = -1000257000;
pub const VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR: VkResult = -1000257000;
pub const VK_PIPELINE_COMPILE_REQUIRED_EXT: VkResult = 1000297000;
pub const VK_ERROR_PIPELINE_COMPILE_REQUIRED_EXT: VkResult = 1000297000;
pub const VK_RESULT_MAX_ENUM: VkResult = 2147483647;
pub type VkResult = ::std::os::raw::c_int;
pub const VK_STRUCTURE_TYPE_APPLICATION_INFO: VkStructureType = 0;
pub const VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO: VkStructureType = 1;
pub const VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO: VkStructureType = 2;
pub const VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO: VkStructureType = 3;
pub const VK_STRUCTURE_TYPE_SUBMIT_INFO: VkStructureType = 4;
pub const VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO: VkStructureType = 5;
pub const VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE: VkStructureType = 6;
pub const VK_STRUCTURE_TYPE_BIND_SPARSE_INFO: VkStructureType = 7;
pub const VK_STRUCTURE_TYPE_FENCE_CREATE_INFO: VkStructureType = 8;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO: VkStructureType = 9;
pub const VK_STRUCTURE_TYPE_EVENT_CREATE_INFO: VkStructureType = 10;
pub const VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO: VkStructureType = 11;
pub const VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO: VkStructureType = 12;
pub const VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO: VkStructureType = 13;
pub const VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO: VkStructureType = 14;
pub const VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO: VkStructureType = 15;
pub const VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: VkStructureType = 16;
pub const VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO: VkStructureType = 17;
pub const VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO: VkStructureType = 18;
pub const VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO:
    VkStructureType = 19;
pub const VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO:
    VkStructureType = 20;
pub const VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO:
    VkStructureType = 21;
pub const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO: VkStructureType =
    22;
pub const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO:
    VkStructureType = 23;
pub const VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO:
    VkStructureType = 24;
pub const VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO:
    VkStructureType = 25;
pub const VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO:
    VkStructureType = 26;
pub const VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO: VkStructureType =
    27;
pub const VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO: VkStructureType = 28;
pub const VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO: VkStructureType = 29;
pub const VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO: VkStructureType = 30;
pub const VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO: VkStructureType = 31;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO: VkStructureType = 32;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO: VkStructureType = 33;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO: VkStructureType = 34;
pub const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET: VkStructureType = 35;
pub const VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET: VkStructureType = 36;
pub const VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO: VkStructureType = 37;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO: VkStructureType = 38;
pub const VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO: VkStructureType = 39;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO: VkStructureType = 40;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO: VkStructureType = 41;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO: VkStructureType = 42;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO: VkStructureType = 43;
pub const VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER: VkStructureType = 44;
pub const VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER: VkStructureType = 45;
pub const VK_STRUCTURE_TYPE_MEMORY_BARRIER: VkStructureType = 46;
pub const VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO: VkStructureType = 47;
pub const VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO: VkStructureType = 48;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: VkStructureType =
    1000094000;
pub const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO: VkStructureType = 1000157000;
pub const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO: VkStructureType = 1000157001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
    VkStructureType = 1000083000;
pub const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: VkStructureType =
    1000127000;
pub const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: VkStructureType =
    1000127001;
pub const VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: VkStructureType =
    1000060000;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: VkStructureType =
    1000060003;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
    VkStructureType = 1000060004;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: VkStructureType = 1000060005;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: VkStructureType =
    1000060006;
pub const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: VkStructureType =
    1000060013;
pub const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: VkStructureType =
    1000060014;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES: VkStructureType =
    1000070000;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: VkStructureType =
    1000070001;
pub const VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2: VkStructureType =
    1000146000;
pub const VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2: VkStructureType =
    1000146001;
pub const VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2:
    VkStructureType = 1000146002;
pub const VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2: VkStructureType = 1000146003;
pub const VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2: VkStructureType =
    1000146004;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: VkStructureType =
    1000059000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2: VkStructureType =
    1000059001;
pub const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2: VkStructureType = 1000059002;
pub const VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2: VkStructureType = 1000059003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2: VkStructureType =
    1000059004;
pub const VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2: VkStructureType = 1000059005;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2: VkStructureType =
    1000059006;
pub const VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2: VkStructureType =
    1000059007;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2:
    VkStructureType = 1000059008;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
    VkStructureType = 1000117000;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
    VkStructureType = 1000117001;
pub const VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: VkStructureType =
    1000117002;
pub const VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO : VkStructureType = 1000117003 ;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: VkStructureType =
    1000053000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: VkStructureType =
    1000053001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: VkStructureType =
    1000053002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
    VkStructureType = 1000120000;
pub const VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: VkStructureType = 1000145000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
    VkStructureType = 1000145001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
    VkStructureType = 1000145002;
pub const VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2: VkStructureType = 1000145003;
pub const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO: VkStructureType =
    1000156000;
pub const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: VkStructureType =
    1000156001;
pub const VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: VkStructureType =
    1000156002;
pub const VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: VkStructureType =
    1000156003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
    VkStructureType = 1000156004;
pub const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
    VkStructureType = 1000156005;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO:
    VkStructureType = 1000085000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
    VkStructureType = 1000071000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: VkStructureType =
    1000071001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO: VkStructureType =
    1000071002;
pub const VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES: VkStructureType =
    1000071003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: VkStructureType =
    1000071004;
pub const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: VkStructureType =
    1000072000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: VkStructureType =
    1000072001;
pub const VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: VkStructureType =
    1000072002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO: VkStructureType =
    1000112000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES: VkStructureType = 1000112001;
pub const VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: VkStructureType = 1000113000;
pub const VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: VkStructureType =
    1000077000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO:
    VkStructureType = 1000076000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES: VkStructureType =
    1000076001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
    VkStructureType = 1000168000;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT: VkStructureType =
    1000168001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
    VkStructureType = 1000063000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: VkStructureType =
    49;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: VkStructureType =
    50;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: VkStructureType =
    51;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: VkStructureType =
    52;
pub const VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: VkStructureType =
    1000147000;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2: VkStructureType = 1000109000;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2: VkStructureType = 1000109001;
pub const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2: VkStructureType = 1000109002;
pub const VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2: VkStructureType = 1000109003;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2: VkStructureType = 1000109004;
pub const VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO: VkStructureType = 1000109005;
pub const VK_STRUCTURE_TYPE_SUBPASS_END_INFO: VkStructureType = 1000109006;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: VkStructureType =
    1000177000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: VkStructureType =
    1000196000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
    VkStructureType = 1000180000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
    VkStructureType = 1000082000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
    VkStructureType = 1000197000;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
    VkStructureType = 1000161000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
    VkStructureType = 1000161001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
    VkStructureType = 1000161002;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO : VkStructureType = 1000161003 ;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT : VkStructureType = 1000161004 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
    VkStructureType = 1000199000;
pub const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
    VkStructureType = 1000199001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
    VkStructureType = 1000221000;
pub const VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: VkStructureType =
    1000246000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
    VkStructureType = 1000130000;
pub const VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: VkStructureType =
    1000130001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
    VkStructureType = 1000211000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
    VkStructureType = 1000108000;
pub const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: VkStructureType =
    1000108001;
pub const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO: VkStructureType =
    1000108002;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: VkStructureType =
    1000108003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES : VkStructureType = 1000253000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES : VkStructureType = 1000175000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES : VkStructureType = 1000241000 ;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: VkStructureType =
    1000241001;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: VkStructureType =
    1000241002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
    VkStructureType = 1000261000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
    VkStructureType = 1000207000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
    VkStructureType = 1000207001;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: VkStructureType =
    1000207002;
pub const VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: VkStructureType =
    1000207003;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO: VkStructureType = 1000207004;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO: VkStructureType = 1000207005;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
    VkStructureType = 1000257000;
pub const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO: VkStructureType =
    1000244001;
pub const VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
    VkStructureType = 1000257002;
pub const VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
    VkStructureType = 1000257003;
pub const VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO:
    VkStructureType = 1000257004;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: VkStructureType =
    53;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: VkStructureType =
    54;
pub const VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO:
    VkStructureType = 1000192000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
    VkStructureType = 1000215000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES: VkStructureType =
    1000245000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES : VkStructureType = 1000276000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: VkStructureType =
    1000295000;
pub const VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: VkStructureType =
    1000295001;
pub const VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO: VkStructureType =
    1000295002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES : VkStructureType = 1000297000 ;
pub const VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: VkStructureType = 1000314000;
pub const VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2: VkStructureType = 1000314001;
pub const VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2: VkStructureType = 1000314002;
pub const VK_STRUCTURE_TYPE_DEPENDENCY_INFO: VkStructureType = 1000314003;
pub const VK_STRUCTURE_TYPE_SUBMIT_INFO_2: VkStructureType = 1000314004;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO: VkStructureType = 1000314005;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO: VkStructureType =
    1000314006;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
    VkStructureType = 1000314007;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES : VkStructureType = 1000325000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
    VkStructureType = 1000335000;
pub const VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2: VkStructureType = 1000337000;
pub const VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2: VkStructureType = 1000337001;
pub const VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2: VkStructureType =
    1000337002;
pub const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2: VkStructureType =
    1000337003;
pub const VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2: VkStructureType = 1000337004;
pub const VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2: VkStructureType = 1000337005;
pub const VK_STRUCTURE_TYPE_BUFFER_COPY_2: VkStructureType = 1000337006;
pub const VK_STRUCTURE_TYPE_IMAGE_COPY_2: VkStructureType = 1000337007;
pub const VK_STRUCTURE_TYPE_IMAGE_BLIT_2: VkStructureType = 1000337008;
pub const VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2: VkStructureType = 1000337009;
pub const VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2: VkStructureType = 1000337010;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
    VkStructureType = 1000225000;
pub const VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO : VkStructureType = 1000225001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
    VkStructureType = 1000225002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
    VkStructureType = 1000138000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
    VkStructureType = 1000138001;
pub const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK:
    VkStructureType = 1000138002;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO:
    VkStructureType = 1000138003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES : VkStructureType = 1000066000 ;
pub const VK_STRUCTURE_TYPE_RENDERING_INFO: VkStructureType = 1000044000;
pub const VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO: VkStructureType = 1000044001;
pub const VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: VkStructureType =
    1000044002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
    VkStructureType = 1000044003;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO:
    VkStructureType = 1000044004;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
    VkStructureType = 1000280000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES : VkStructureType = 1000280001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
    VkStructureType = 1000281001;
pub const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: VkStructureType = 1000360000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
    VkStructureType = 1000413000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
    VkStructureType = 1000413001;
pub const VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS: VkStructureType =
    1000413002;
pub const VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS: VkStructureType =
    1000413003;
pub const VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR: VkStructureType = 1000001000;
pub const VK_STRUCTURE_TYPE_PRESENT_INFO_KHR: VkStructureType = 1000001001;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR: VkStructureType =
    1000060007;
pub const VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR: VkStructureType =
    1000060008;
pub const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: VkStructureType =
    1000060009;
pub const VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR: VkStructureType =
    1000060010;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: VkStructureType =
    1000060011;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR:
    VkStructureType = 1000060012;
pub const VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR: VkStructureType =
    1000002000;
pub const VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000002001;
pub const VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: VkStructureType = 1000003000;
pub const VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000004000;
pub const VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000005000;
pub const VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000006000;
pub const VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000008000;
pub const VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000009000;
pub const VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: VkStructureType =
    1000011000;
pub const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD:
    VkStructureType = 1000018000;
pub const VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT: VkStructureType =
    1000022000;
pub const VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT: VkStructureType =
    1000022001;
pub const VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT: VkStructureType =
    1000022002;
pub const VK_STRUCTURE_TYPE_VIDEO_PROFILE_KHR: VkStructureType = 1000023000;
pub const VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR: VkStructureType = 1000023001;
pub const VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_KHR: VkStructureType =
    1000023002;
pub const VK_STRUCTURE_TYPE_VIDEO_GET_MEMORY_PROPERTIES_KHR: VkStructureType =
    1000023003;
pub const VK_STRUCTURE_TYPE_VIDEO_BIND_MEMORY_KHR: VkStructureType = 1000023004;
pub const VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR: VkStructureType =
    1000023005;
pub const VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR:
    VkStructureType = 1000023006;
pub const VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR:
    VkStructureType = 1000023007;
pub const VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR: VkStructureType =
    1000023008;
pub const VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR: VkStructureType = 1000023009;
pub const VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR: VkStructureType =
    1000023010;
pub const VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_KHR: VkStructureType = 1000023011;
pub const VK_STRUCTURE_TYPE_VIDEO_QUEUE_FAMILY_PROPERTIES_2_KHR: VkStructureType =
    1000023012;
pub const VK_STRUCTURE_TYPE_VIDEO_PROFILES_KHR: VkStructureType = 1000023013;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR: VkStructureType =
    1000023014;
pub const VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR: VkStructureType =
    1000023015;
pub const VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_2_KHR:
    VkStructureType = 1000023016;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR: VkStructureType = 1000024000;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR: VkStructureType =
    1000024001;
pub const VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV:
    VkStructureType = 1000026000;
pub const VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV:
    VkStructureType = 1000026001;
pub const VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV:
    VkStructureType = 1000026002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
    VkStructureType = 1000028000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
    VkStructureType = 1000028001;
pub const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
    VkStructureType = 1000028002;
pub const VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX: VkStructureType = 1000029000;
pub const VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX: VkStructureType =
    1000029001;
pub const VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX: VkStructureType = 1000029002;
pub const VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX: VkStructureType =
    1000030000;
pub const VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX: VkStructureType =
    1000030001;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_EXT: VkStructureType =
    1000038000;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT:
    VkStructureType = 1000038001;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT:
    VkStructureType = 1000038002;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_VCL_FRAME_INFO_EXT: VkStructureType =
    1000038003;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT: VkStructureType =
    1000038004;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_EXT: VkStructureType =
    1000038005;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_EMIT_PICTURE_PARAMETERS_EXT:
    VkStructureType = 1000038006;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_EXT: VkStructureType =
    1000038007;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_EXT:
    VkStructureType = 1000038008;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_EXT:
    VkStructureType = 1000038009;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_REFERENCE_LISTS_EXT: VkStructureType =
    1000038010;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_EXT: VkStructureType =
    1000039000;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_EXT:
    VkStructureType = 1000039001;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT:
    VkStructureType = 1000039002;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_VCL_FRAME_INFO_EXT: VkStructureType =
    1000039003;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_EXT: VkStructureType =
    1000039004;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_EXT:
    VkStructureType = 1000039005;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_EMIT_PICTURE_PARAMETERS_EXT:
    VkStructureType = 1000039006;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_EXT: VkStructureType =
    1000039007;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_REFERENCE_LISTS_EXT: VkStructureType =
    1000039008;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_EXT:
    VkStructureType = 1000039009;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_EXT:
    VkStructureType = 1000039010;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_EXT: VkStructureType =
    1000040000;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_EXT: VkStructureType =
    1000040001;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_MVC_EXT: VkStructureType = 1000040002;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_EXT: VkStructureType =
    1000040003;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT:
    VkStructureType = 1000040004;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT:
    VkStructureType = 1000040005;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_EXT: VkStructureType =
    1000040006;
pub const VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD:
    VkStructureType = 1000041000;
pub const VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
    VkStructureType = 1000044006;
pub const VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT:
    VkStructureType = 1000044007;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: VkStructureType =
    1000044008;
pub const VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX:
    VkStructureType = 1000044009;
pub const VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP:
    VkStructureType = 1000049000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV:
    VkStructureType = 1000050000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: VkStructureType =
    1000056000;
pub const VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: VkStructureType =
    1000056001;
pub const VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV: VkStructureType =
    1000057000;
pub const VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV: VkStructureType =
    1000057001;
pub const VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV:
    VkStructureType = 1000058000;
pub const VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: VkStructureType = 1000061000;
pub const VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN: VkStructureType = 1000062000;
pub const VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: VkStructureType =
    1000067000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT:
    VkStructureType = 1000067001;
pub const VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073000;
pub const VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073001;
pub const VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR: VkStructureType =
    1000073002;
pub const VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073003;
pub const VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: VkStructureType = 1000074000;
pub const VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR: VkStructureType = 1000074001;
pub const VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR: VkStructureType = 1000074002;
pub const VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR:
    VkStructureType = 1000075000;
pub const VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
    VkStructureType = 1000078000;
pub const VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
    VkStructureType = 1000078001;
pub const VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR: VkStructureType =
    1000078002;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000078003;
pub const VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR: VkStructureType =
    1000079000;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR: VkStructureType = 1000079001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
    VkStructureType = 1000080000;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT : VkStructureType = 1000081000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
    VkStructureType = 1000081001;
pub const VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT: VkStructureType =
    1000081002;
pub const VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: VkStructureType = 1000084000;
pub const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV:
    VkStructureType = 1000087000;
pub const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT: VkStructureType =
    1000090000;
pub const VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT: VkStructureType = 1000091000;
pub const VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT: VkStructureType = 1000091001;
pub const VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT: VkStructureType = 1000091002;
pub const VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: VkStructureType =
    1000091003;
pub const VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: VkStructureType = 1000092000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX : VkStructureType = 1000097000 ;
pub const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV:
    VkStructureType = 1000098000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT:
    VkStructureType = 1000099000;
pub const VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000099001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT : VkStructureType = 1000101000 ;
pub const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT : VkStructureType = 1000101001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
    VkStructureType = 1000102000;
pub const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT : VkStructureType = 1000102001 ;
pub const VK_STRUCTURE_TYPE_HDR_METADATA_EXT: VkStructureType = 1000105000;
pub const VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR:
    VkStructureType = 1000111000;
pub const VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114000;
pub const VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114001;
pub const VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114002;
pub const VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR: VkStructureType = 1000115000;
pub const VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR: VkStructureType = 1000115001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR:
    VkStructureType = 1000116000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR:
    VkStructureType = 1000116001;
pub const VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR:
    VkStructureType = 1000116002;
pub const VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR: VkStructureType =
    1000116003;
pub const VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR: VkStructureType =
    1000116004;
pub const VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR: VkStructureType = 1000116005;
pub const VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR: VkStructureType =
    1000116006;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR: VkStructureType =
    1000119000;
pub const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR: VkStructureType =
    1000119001;
pub const VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR: VkStructureType = 1000119002;
pub const VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR: VkStructureType = 1000121000;
pub const VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR: VkStructureType =
    1000121001;
pub const VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR: VkStructureType =
    1000121002;
pub const VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR: VkStructureType = 1000121003;
pub const VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR: VkStructureType =
    1000121004;
pub const VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK: VkStructureType =
    1000122000;
pub const VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK: VkStructureType =
    1000123000;
pub const VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: VkStructureType =
    1000128000;
pub const VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT: VkStructureType =
    1000128001;
pub const VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT: VkStructureType = 1000128002;
pub const VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT:
    VkStructureType = 1000128003;
pub const VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: VkStructureType =
    1000128004;
pub const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID: VkStructureType =
    1000129000;
pub const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID:
    VkStructureType = 1000129001;
pub const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID:
    VkStructureType = 1000129002;
pub const VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
    VkStructureType = 1000129003;
pub const VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
    VkStructureType = 1000129004;
pub const VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID: VkStructureType = 1000129005;
pub const VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_2_ANDROID:
    VkStructureType = 1000129006;
pub const VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: VkStructureType = 1000143000;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT:
    VkStructureType = 1000143001;
pub const VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000143002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT:
    VkStructureType = 1000143003;
pub const VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT: VkStructureType =
    1000143004;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT : VkStructureType = 1000148000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT : VkStructureType = 1000148001 ;
pub const VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000148002;
pub const VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV:
    VkStructureType = 1000149000;
pub const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR:
    VkStructureType = 1000150007;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR:
    VkStructureType = 1000150000;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR:
    VkStructureType = 1000150002;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR:
    VkStructureType = 1000150003;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR:
    VkStructureType = 1000150004;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR:
    VkStructureType = 1000150005;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR: VkStructureType =
    1000150006;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR:
    VkStructureType = 1000150009;
pub const VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR: VkStructureType =
    1000150010;
pub const VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR:
    VkStructureType = 1000150011;
pub const VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR:
    VkStructureType = 1000150012;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
    VkStructureType = 1000150013;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR : VkStructureType = 1000150014 ;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR:
    VkStructureType = 1000150017;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR:
    VkStructureType = 1000150020;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
    VkStructureType = 1000347000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR:
    VkStructureType = 1000347001;
pub const VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR: VkStructureType =
    1000150015;
pub const VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR:
    VkStructureType = 1000150016;
pub const VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR:
    VkStructureType = 1000150018;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
    VkStructureType = 1000348013;
pub const VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV:
    VkStructureType = 1000152000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV:
    VkStructureType = 1000154000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV:
    VkStructureType = 1000154001;
pub const VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
    VkStructureType = 1000158000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
    VkStructureType = 1000158002;
pub const VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
    VkStructureType = 1000158003;
pub const VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
    VkStructureType = 1000158004;
pub const VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT:
    VkStructureType = 1000158005;
pub const VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
    VkStructureType = 1000158006;
pub const VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT: VkStructureType =
    1000160000;
pub const VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT:
    VkStructureType = 1000160001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR:
    VkStructureType = 1000163000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR:
    VkStructureType = 1000163001;
pub const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV : VkStructureType = 1000164000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV:
    VkStructureType = 1000164001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV:
    VkStructureType = 1000164002;
pub const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV : VkStructureType = 1000164005 ;
pub const VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV: VkStructureType =
    1000165000;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV: VkStructureType =
    1000165001;
pub const VK_STRUCTURE_TYPE_GEOMETRY_NV: VkStructureType = 1000165003;
pub const VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV: VkStructureType = 1000165004;
pub const VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV: VkStructureType = 1000165005;
pub const VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV:
    VkStructureType = 1000165006;
pub const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV:
    VkStructureType = 1000165007;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV:
    VkStructureType = 1000165008;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV:
    VkStructureType = 1000165009;
pub const VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV:
    VkStructureType = 1000165011;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV: VkStructureType =
    1000165012;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV : VkStructureType = 1000166000 ;
pub const VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV : VkStructureType = 1000166001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT:
    VkStructureType = 1000170000;
pub const VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT:
    VkStructureType = 1000170001;
pub const VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: VkStructureType =
    1000178000;
pub const VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT: VkStructureType =
    1000178001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT:
    VkStructureType = 1000178002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
    VkStructureType = 1000181000;
pub const VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD:
    VkStructureType = 1000183000;
pub const VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT: VkStructureType =
    1000184000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD:
    VkStructureType = 1000185000;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_EXT: VkStructureType =
    1000187000;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_EXT:
    VkStructureType = 1000187001;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_EXT:
    VkStructureType = 1000187002;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_EXT: VkStructureType =
    1000187003;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_EXT: VkStructureType =
    1000187004;
pub const VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_EXT: VkStructureType =
    1000187005;
pub const VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_KHR:
    VkStructureType = 1000174000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_KHR:
    VkStructureType = 1000388000;
pub const VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_KHR:
    VkStructureType = 1000388001;
pub const VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD:
    VkStructureType = 1000189000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT : VkStructureType = 1000190000 ;
pub const VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000190001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT : VkStructureType = 1000190002 ;
pub const VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP: VkStructureType = 1000191000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV : VkStructureType = 1000201000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV:
    VkStructureType = 1000202000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV:
    VkStructureType = 1000202001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV : VkStructureType = 1000203000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV:
    VkStructureType = 1000204000;
pub const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV : VkStructureType = 1000205000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV:
    VkStructureType = 1000205002;
pub const VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV: VkStructureType = 1000206000;
pub const VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV: VkStructureType =
    1000206001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL : VkStructureType = 1000209000 ;
pub const VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL:
    VkStructureType = 1000210000;
pub const VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL: VkStructureType =
    1000210001;
pub const VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL: VkStructureType =
    1000210002;
pub const VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL: VkStructureType =
    1000210003;
pub const VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL: VkStructureType =
    1000210004;
pub const VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL:
    VkStructureType = 1000210005;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
    VkStructureType = 1000212000;
pub const VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD:
    VkStructureType = 1000213000;
pub const VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD:
    VkStructureType = 1000213001;
pub const VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA: VkStructureType =
    1000214000;
pub const VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000217000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
    VkStructureType = 1000218000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
    VkStructureType = 1000218001;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
    VkStructureType = 1000218002;
pub const VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
    VkStructureType = 1000226000;
pub const VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR:
    VkStructureType = 1000226001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR:
    VkStructureType = 1000226002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
    VkStructureType = 1000226003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR:
    VkStructureType = 1000226004;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD:
    VkStructureType = 1000227000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD:
    VkStructureType = 1000229000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT : VkStructureType = 1000234000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
    VkStructureType = 1000237000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT:
    VkStructureType = 1000238000;
pub const VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT: VkStructureType =
    1000238001;
pub const VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: VkStructureType =
    1000239000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV : VkStructureType = 1000240000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
    VkStructureType = 1000244000;
pub const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT: VkStructureType =
    1000244002;
pub const VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: VkStructureType = 1000247000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR:
    VkStructureType = 1000248000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV:
    VkStructureType = 1000249000;
pub const VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV: VkStructureType =
    1000249001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV:
    VkStructureType = 1000249002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV:
    VkStructureType = 1000250000;
pub const VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV:
    VkStructureType = 1000250001;
pub const VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV:
    VkStructureType = 1000250002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT : VkStructureType = 1000251000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
    VkStructureType = 1000252000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
    VkStructureType = 1000254000;
pub const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT : VkStructureType = 1000254001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
    VkStructureType = 1000254002;
pub const VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT:
    VkStructureType = 1000255000;
pub const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT:
    VkStructureType = 1000255002;
pub const VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT:
    VkStructureType = 1000255001;
pub const VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000256000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
    VkStructureType = 1000259000;
pub const VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000259001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
    VkStructureType = 1000259002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
    VkStructureType = 1000260000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
    VkStructureType = 1000265000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
    VkStructureType = 1000267000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR : VkStructureType = 1000269000 ;
pub const VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR: VkStructureType = 1000269001;
pub const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR: VkStructureType =
    1000269002;
pub const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR: VkStructureType =
    1000269003;
pub const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR: VkStructureType =
    1000269004;
pub const VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR:
    VkStructureType = 1000269005;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT:
    VkStructureType = 1000273000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV : VkStructureType = 1000277000 ;
pub const VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV: VkStructureType =
    1000277001;
pub const VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV:
    VkStructureType = 1000277002;
pub const VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV: VkStructureType =
    1000277003;
pub const VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV:
    VkStructureType = 1000277004;
pub const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV: VkStructureType =
    1000277005;
pub const VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV:
    VkStructureType = 1000277006;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV : VkStructureType = 1000277007 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV : VkStructureType = 1000278000 ;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV:
    VkStructureType = 1000278001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
    VkStructureType = 1000281000;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM : VkStructureType = 1000282000 ;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM: VkStructureType =
    1000282001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
    VkStructureType = 1000284000;
pub const VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
    VkStructureType = 1000284001;
pub const VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT:
    VkStructureType = 1000284002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
    VkStructureType = 1000286000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
    VkStructureType = 1000286001;
pub const VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
    VkStructureType = 1000287000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
    VkStructureType = 1000287001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
    VkStructureType = 1000287002;
pub const VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: VkStructureType =
    1000290000;
pub const VK_STRUCTURE_TYPE_PRESENT_ID_KHR: VkStructureType = 1000294000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR:
    VkStructureType = 1000294001;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR: VkStructureType = 1000299000;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR: VkStructureType =
    1000299001;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR:
    VkStructureType = 1000299002;
pub const VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR: VkStructureType =
    1000299003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV:
    VkStructureType = 1000300000;
pub const VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV:
    VkStructureType = 1000300001;
pub const VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV:
    VkStructureType = 1000314008;
pub const VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV: VkStructureType = 1000314009;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT : VkStructureType = 1000320000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT : VkStructureType = 1000320001 ;
pub const VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT:
    VkStructureType = 1000320002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR : VkStructureType = 1000323000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV : VkStructureType = 1000326000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV : VkStructureType = 1000326001 ;
pub const VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV : VkStructureType = 1000326002 ;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV : VkStructureType = 1000327000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV:
    VkStructureType = 1000327001;
pub const VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV: VkStructureType =
    1000327002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT : VkStructureType = 1000330000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT:
    VkStructureType = 1000332000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT : VkStructureType = 1000332001 ;
pub const VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM: VkStructureType =
    1000333000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR : VkStructureType = 1000336000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
    VkStructureType = 1000340000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_ARM : VkStructureType = 1000342000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT:
    VkStructureType = 1000344000;
pub const VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000346000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE : VkStructureType = 1000351000 ;
pub const VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE:
    VkStructureType = 1000351002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT : VkStructureType = 1000352000 ;
pub const VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT:
    VkStructureType = 1000352001;
pub const VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT:
    VkStructureType = 1000352002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT: VkStructureType =
    1000353000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
    VkStructureType = 1000355000;
pub const VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT:
    VkStructureType = 1000355001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT : VkStructureType = 1000356000 ;
pub const VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA:
    VkStructureType = 1000364000;
pub const VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA:
    VkStructureType = 1000364001;
pub const VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA: VkStructureType =
    1000364002;
pub const VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA:
    VkStructureType = 1000365000;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA:
    VkStructureType = 1000365001;
pub const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CREATE_INFO_FUCHSIA: VkStructureType =
    1000366000;
pub const VK_STRUCTURE_TYPE_IMPORT_MEMORY_BUFFER_COLLECTION_FUCHSIA:
    VkStructureType = 1000366001;
pub const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_IMAGE_CREATE_INFO_FUCHSIA:
    VkStructureType = 1000366002;
pub const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_PROPERTIES_FUCHSIA: VkStructureType =
    1000366003;
pub const VK_STRUCTURE_TYPE_BUFFER_CONSTRAINTS_INFO_FUCHSIA: VkStructureType =
    1000366004;
pub const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_BUFFER_CREATE_INFO_FUCHSIA:
    VkStructureType = 1000366005;
pub const VK_STRUCTURE_TYPE_IMAGE_CONSTRAINTS_INFO_FUCHSIA: VkStructureType =
    1000366006;
pub const VK_STRUCTURE_TYPE_IMAGE_FORMAT_CONSTRAINTS_INFO_FUCHSIA: VkStructureType =
    1000366007;
pub const VK_STRUCTURE_TYPE_SYSMEM_COLOR_SPACE_FUCHSIA: VkStructureType =
    1000366008;
pub const VK_STRUCTURE_TYPE_BUFFER_COLLECTION_CONSTRAINTS_INFO_FUCHSIA:
    VkStructureType = 1000366009;
pub const VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI:
    VkStructureType = 1000369000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI:
    VkStructureType = 1000369001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI:
    VkStructureType = 1000369002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI:
    VkStructureType = 1000370000;
pub const VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV: VkStructureType =
    1000371000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV:
    VkStructureType = 1000371001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT : VkStructureType = 1000377000 ;
pub const VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX: VkStructureType =
    1000378000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
    VkStructureType = 1000381000;
pub const VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT: VkStructureType =
    1000381001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT : VkStructureType = 1000382000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
    VkStructureType = 1000391000;
pub const VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT: VkStructureType =
    1000391001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
    VkStructureType = 1000392000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
    VkStructureType = 1000392001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
    VkStructureType = 1000393000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
    VkStructureType = 1000411000;
pub const VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT : VkStructureType = 1000411001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT : VkStructureType = 1000412000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE : VkStructureType = 1000420000 ;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE:
    VkStructureType = 1000420001;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE:
    VkStructureType = 1000420002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM : VkStructureType = 1000425000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM : VkStructureType = 1000425001 ;
pub const VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM:
    VkStructureType = 1000425002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV:
    VkStructureType = 1000430000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES:
    VkStructureType = 1000120000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES:
    VkStructureType = 1000063000;
pub const VK_STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT: VkStructureType =
    1000011000;
pub const VK_STRUCTURE_TYPE_RENDERING_INFO_KHR: VkStructureType = 1000044000;
pub const VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO_KHR: VkStructureType =
    1000044001;
pub const VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO_KHR: VkStructureType =
    1000044002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES_KHR:
    VkStructureType = 1000044003;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO_KHR:
    VkStructureType = 1000044004;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_NV: VkStructureType =
    1000044008;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR: VkStructureType =
    1000053000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR:
    VkStructureType = 1000053001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR:
    VkStructureType = 1000053002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR: VkStructureType =
    1000059000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR: VkStructureType =
    1000059001;
pub const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR: VkStructureType = 1000059002;
pub const VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR: VkStructureType =
    1000059003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR:
    VkStructureType = 1000059004;
pub const VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR: VkStructureType =
    1000059005;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR:
    VkStructureType = 1000059006;
pub const VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR: VkStructureType =
    1000059007;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR:
    VkStructureType = 1000059008;
pub const VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR: VkStructureType =
    1000060000;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR:
    VkStructureType = 1000060003;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR:
    VkStructureType = 1000060004;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR: VkStructureType =
    1000060005;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR: VkStructureType =
    1000060006;
pub const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR:
    VkStructureType = 1000060013;
pub const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR:
    VkStructureType = 1000060014;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT : VkStructureType = 1000066000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR: VkStructureType =
    1000070000;
pub const VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR: VkStructureType =
    1000070001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR:
    VkStructureType = 1000071000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR: VkStructureType =
    1000071001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR:
    VkStructureType = 1000071002;
pub const VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR: VkStructureType =
    1000071003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR: VkStructureType =
    1000071004;
pub const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR:
    VkStructureType = 1000072000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR: VkStructureType =
    1000072001;
pub const VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR: VkStructureType =
    1000072002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR:
    VkStructureType = 1000076000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR: VkStructureType =
    1000076001;
pub const VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR: VkStructureType =
    1000077000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR:
    VkStructureType = 1000082000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR:
    VkStructureType = 1000082000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR:
    VkStructureType = 1000083000;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR:
    VkStructureType = 1000085000;
pub const VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES2_EXT: VkStructureType = 1000090000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR:
    VkStructureType = 1000108000;
pub const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR:
    VkStructureType = 1000108001;
pub const VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR: VkStructureType =
    1000108002;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR: VkStructureType =
    1000108003;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR: VkStructureType =
    1000109000;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR: VkStructureType =
    1000109001;
pub const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR: VkStructureType = 1000109002;
pub const VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR: VkStructureType = 1000109003;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR: VkStructureType =
    1000109004;
pub const VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR: VkStructureType = 1000109005;
pub const VK_STRUCTURE_TYPE_SUBPASS_END_INFO_KHR: VkStructureType = 1000109006;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR:
    VkStructureType = 1000112000;
pub const VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR: VkStructureType =
    1000112001;
pub const VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR: VkStructureType =
    1000113000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR:
    VkStructureType = 1000117000;
pub const VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR:
    VkStructureType = 1000117001;
pub const VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR: VkStructureType =
    1000117002;
pub const VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR : VkStructureType = 1000117003 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR:
    VkStructureType = 1000120000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR:
    VkStructureType = 1000120000;
pub const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR: VkStructureType =
    1000127000;
pub const VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR: VkStructureType =
    1000127001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT:
    VkStructureType = 1000130000;
pub const VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT:
    VkStructureType = 1000130001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT:
    VkStructureType = 1000138000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT:
    VkStructureType = 1000138001;
pub const VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT:
    VkStructureType = 1000138002;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT:
    VkStructureType = 1000138003;
pub const VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR: VkStructureType =
    1000146000;
pub const VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR: VkStructureType =
    1000146001;
pub const VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR:
    VkStructureType = 1000146002;
pub const VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR: VkStructureType = 1000146003;
pub const VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR:
    VkStructureType = 1000146004;
pub const VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR: VkStructureType =
    1000147000;
pub const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR:
    VkStructureType = 1000156000;
pub const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR: VkStructureType =
    1000156001;
pub const VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR: VkStructureType =
    1000156002;
pub const VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR:
    VkStructureType = 1000156003;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR : VkStructureType = 1000156004 ;
pub const VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR:
    VkStructureType = 1000156005;
pub const VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR: VkStructureType =
    1000157000;
pub const VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR: VkStructureType =
    1000157001;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT:
    VkStructureType = 1000161000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT:
    VkStructureType = 1000161001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT:
    VkStructureType = 1000161002;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT : VkStructureType = 1000161003 ;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT : VkStructureType = 1000161004 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR:
    VkStructureType = 1000168000;
pub const VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR: VkStructureType =
    1000168001;
pub const VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT:
    VkStructureType = 1000174000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR : VkStructureType = 1000175000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR:
    VkStructureType = 1000177000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR:
    VkStructureType = 1000180000;
pub const VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT:
    VkStructureType = 1000192000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR: VkStructureType =
    1000196000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR:
    VkStructureType = 1000197000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR:
    VkStructureType = 1000199000;
pub const VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR:
    VkStructureType = 1000199001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR:
    VkStructureType = 1000207000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR:
    VkStructureType = 1000207001;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR: VkStructureType =
    1000207002;
pub const VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR: VkStructureType =
    1000207003;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR: VkStructureType = 1000207004;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR: VkStructureType = 1000207005;
pub const VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL: VkStructureType =
    1000210000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR:
    VkStructureType = 1000211000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR : VkStructureType = 1000215000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT:
    VkStructureType = 1000221000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT:
    VkStructureType = 1000225000;
pub const VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT : VkStructureType = 1000225001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT:
    VkStructureType = 1000225002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR : VkStructureType = 1000241000 ;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR:
    VkStructureType = 1000241001;
pub const VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR:
    VkStructureType = 1000241002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT:
    VkStructureType = 1000244000;
pub const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT: VkStructureType =
    1000244001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT: VkStructureType =
    1000245000;
pub const VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT: VkStructureType =
    1000246000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR : VkStructureType = 1000253000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR:
    VkStructureType = 1000257000;
pub const VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR: VkStructureType =
    1000244001;
pub const VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR:
    VkStructureType = 1000257002;
pub const VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR:
    VkStructureType = 1000257003;
pub const VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR:
    VkStructureType = 1000257004;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT:
    VkStructureType = 1000261000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT : VkStructureType = 1000276000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR : VkStructureType = 1000280000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR : VkStructureType = 1000280001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT : VkStructureType = 1000281001 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT:
    VkStructureType = 1000295000;
pub const VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT: VkStructureType =
    1000295001;
pub const VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT: VkStructureType =
    1000295002;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT : VkStructureType = 1000297000 ;
pub const VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR: VkStructureType = 1000314000;
pub const VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR: VkStructureType =
    1000314001;
pub const VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR: VkStructureType =
    1000314002;
pub const VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR: VkStructureType = 1000314003;
pub const VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR: VkStructureType = 1000314004;
pub const VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR: VkStructureType = 1000314005;
pub const VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR: VkStructureType =
    1000314006;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR:
    VkStructureType = 1000314007;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR : VkStructureType = 1000325000 ;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT:
    VkStructureType = 1000335000;
pub const VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR: VkStructureType = 1000337000;
pub const VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR: VkStructureType = 1000337001;
pub const VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR: VkStructureType =
    1000337002;
pub const VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR: VkStructureType =
    1000337003;
pub const VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR: VkStructureType = 1000337004;
pub const VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR: VkStructureType = 1000337005;
pub const VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR: VkStructureType = 1000337006;
pub const VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR: VkStructureType = 1000337007;
pub const VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR: VkStructureType = 1000337008;
pub const VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR: VkStructureType = 1000337009;
pub const VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR: VkStructureType = 1000337010;
pub const VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3_KHR: VkStructureType = 1000360000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES_EXT:
    VkStructureType = 1000388000;
pub const VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES_EXT:
    VkStructureType = 1000388001;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES_KHR:
    VkStructureType = 1000413000;
pub const VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES_KHR:
    VkStructureType = 1000413001;
pub const VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS_KHR: VkStructureType =
    1000413002;
pub const VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS_KHR: VkStructureType =
    1000413003;
pub const VK_STRUCTURE_TYPE_MAX_ENUM: VkStructureType = 2147483647;
pub type VkStructureType = ::std::os::raw::c_uint;
pub const VK_IMAGE_LAYOUT_UNDEFINED: VkImageLayout = 0;
pub const VK_IMAGE_LAYOUT_GENERAL: VkImageLayout = 1;
pub const VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL: VkImageLayout = 2;
pub const VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout = 3;
pub const VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout = 4;
pub const VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL: VkImageLayout = 5;
pub const VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL: VkImageLayout = 6;
pub const VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL: VkImageLayout = 7;
pub const VK_IMAGE_LAYOUT_PREINITIALIZED: VkImageLayout = 8;
pub const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout =
    1000117000;
pub const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout =
    1000117001;
pub const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL: VkImageLayout = 1000241000;
pub const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL: VkImageLayout = 1000241001;
pub const VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout = 1000241002;
pub const VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout = 1000241003;
pub const VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL: VkImageLayout = 1000314000;
pub const VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL: VkImageLayout = 1000314001;
pub const VK_IMAGE_LAYOUT_PRESENT_SRC_KHR: VkImageLayout = 1000001002;
pub const VK_IMAGE_LAYOUT_VIDEO_DECODE_DST_KHR: VkImageLayout = 1000024000;
pub const VK_IMAGE_LAYOUT_VIDEO_DECODE_SRC_KHR: VkImageLayout = 1000024001;
pub const VK_IMAGE_LAYOUT_VIDEO_DECODE_DPB_KHR: VkImageLayout = 1000024002;
pub const VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR: VkImageLayout = 1000111000;
pub const VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT: VkImageLayout =
    1000218000;
pub const VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR:
    VkImageLayout = 1000164003;
pub const VK_IMAGE_LAYOUT_VIDEO_ENCODE_DST_KHR: VkImageLayout = 1000299000;
pub const VK_IMAGE_LAYOUT_VIDEO_ENCODE_SRC_KHR: VkImageLayout = 1000299001;
pub const VK_IMAGE_LAYOUT_VIDEO_ENCODE_DPB_KHR: VkImageLayout = 1000299002;
pub const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR:
    VkImageLayout = 1000117000;
pub const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR:
    VkImageLayout = 1000117001;
pub const VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV: VkImageLayout = 1000164003;
pub const VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000241000;
pub const VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000241001;
pub const VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000241002;
pub const VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000241003;
pub const VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000314000;
pub const VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000314001;
pub const VK_IMAGE_LAYOUT_MAX_ENUM: VkImageLayout = 2147483647;
pub type VkImageLayout = ::std::os::raw::c_uint;
pub const VK_OBJECT_TYPE_UNKNOWN: VkObjectType = 0;
pub const VK_OBJECT_TYPE_INSTANCE: VkObjectType = 1;
pub const VK_OBJECT_TYPE_PHYSICAL_DEVICE: VkObjectType = 2;
pub const VK_OBJECT_TYPE_DEVICE: VkObjectType = 3;
pub const VK_OBJECT_TYPE_QUEUE: VkObjectType = 4;
pub const VK_OBJECT_TYPE_SEMAPHORE: VkObjectType = 5;
pub const VK_OBJECT_TYPE_COMMAND_BUFFER: VkObjectType = 6;
pub const VK_OBJECT_TYPE_FENCE: VkObjectType = 7;
pub const VK_OBJECT_TYPE_DEVICE_MEMORY: VkObjectType = 8;
pub const VK_OBJECT_TYPE_BUFFER: VkObjectType = 9;
pub const VK_OBJECT_TYPE_IMAGE: VkObjectType = 10;
pub const VK_OBJECT_TYPE_EVENT: VkObjectType = 11;
pub const VK_OBJECT_TYPE_QUERY_POOL: VkObjectType = 12;
pub const VK_OBJECT_TYPE_BUFFER_VIEW: VkObjectType = 13;
pub const VK_OBJECT_TYPE_IMAGE_VIEW: VkObjectType = 14;
pub const VK_OBJECT_TYPE_SHADER_MODULE: VkObjectType = 15;
pub const VK_OBJECT_TYPE_PIPELINE_CACHE: VkObjectType = 16;
pub const VK_OBJECT_TYPE_PIPELINE_LAYOUT: VkObjectType = 17;
pub const VK_OBJECT_TYPE_RENDER_PASS: VkObjectType = 18;
pub const VK_OBJECT_TYPE_PIPELINE: VkObjectType = 19;
pub const VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT: VkObjectType = 20;
pub const VK_OBJECT_TYPE_SAMPLER: VkObjectType = 21;
pub const VK_OBJECT_TYPE_DESCRIPTOR_POOL: VkObjectType = 22;
pub const VK_OBJECT_TYPE_DESCRIPTOR_SET: VkObjectType = 23;
pub const VK_OBJECT_TYPE_FRAMEBUFFER: VkObjectType = 24;
pub const VK_OBJECT_TYPE_COMMAND_POOL: VkObjectType = 25;
pub const VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION: VkObjectType = 1000156000;
pub const VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE: VkObjectType = 1000085000;
pub const VK_OBJECT_TYPE_PRIVATE_DATA_SLOT: VkObjectType = 1000295000;
pub const VK_OBJECT_TYPE_SURFACE_KHR: VkObjectType = 1000000000;
pub const VK_OBJECT_TYPE_SWAPCHAIN_KHR: VkObjectType = 1000001000;
pub const VK_OBJECT_TYPE_DISPLAY_KHR: VkObjectType = 1000002000;
pub const VK_OBJECT_TYPE_DISPLAY_MODE_KHR: VkObjectType = 1000002001;
pub const VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT: VkObjectType = 1000011000;
pub const VK_OBJECT_TYPE_VIDEO_SESSION_KHR: VkObjectType = 1000023000;
pub const VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR: VkObjectType = 1000023001;
pub const VK_OBJECT_TYPE_CU_MODULE_NVX: VkObjectType = 1000029000;
pub const VK_OBJECT_TYPE_CU_FUNCTION_NVX: VkObjectType = 1000029001;
pub const VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT: VkObjectType = 1000128000;
pub const VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR: VkObjectType = 1000150000;
pub const VK_OBJECT_TYPE_VALIDATION_CACHE_EXT: VkObjectType = 1000160000;
pub const VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV: VkObjectType = 1000165000;
pub const VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL: VkObjectType = 1000210000;
pub const VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR: VkObjectType = 1000268000;
pub const VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV: VkObjectType = 1000277000;
pub const VK_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA: VkObjectType = 1000366000;
pub const VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR: VkObjectType = 1000085000;
pub const VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR: VkObjectType = 1000156000;
pub const VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT: VkObjectType = 1000295000;
pub const VK_OBJECT_TYPE_MAX_ENUM: VkObjectType = 2147483647;
pub type VkObjectType = ::std::os::raw::c_uint;
pub const VK_PIPELINE_CACHE_HEADER_VERSION_ONE:
    VkPipelineCacheHeaderVersion = 1;
pub const VK_PIPELINE_CACHE_HEADER_VERSION_MAX_ENUM:
    VkPipelineCacheHeaderVersion = 2147483647;
pub type VkPipelineCacheHeaderVersion = ::std::os::raw::c_uint;
pub const VK_VENDOR_ID_VIV: VkVendorId = 65537;
pub const VK_VENDOR_ID_VSI: VkVendorId = 65538;
pub const VK_VENDOR_ID_KAZAN: VkVendorId = 65539;
pub const VK_VENDOR_ID_CODEPLAY: VkVendorId = 65540;
pub const VK_VENDOR_ID_MESA: VkVendorId = 65541;
pub const VK_VENDOR_ID_POCL: VkVendorId = 65542;
pub const VK_VENDOR_ID_MAX_ENUM: VkVendorId = 2147483647;
pub type VkVendorId = ::std::os::raw::c_uint;
pub const VK_SYSTEM_ALLOCATION_SCOPE_COMMAND: VkSystemAllocationScope = 0;
pub const VK_SYSTEM_ALLOCATION_SCOPE_OBJECT: VkSystemAllocationScope = 1;
pub const VK_SYSTEM_ALLOCATION_SCOPE_CACHE: VkSystemAllocationScope = 2;
pub const VK_SYSTEM_ALLOCATION_SCOPE_DEVICE: VkSystemAllocationScope = 3;
pub const VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE: VkSystemAllocationScope = 4;
pub const VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM: VkSystemAllocationScope =
    2147483647;
pub type VkSystemAllocationScope = ::std::os::raw::c_uint;
pub const VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE:
    VkInternalAllocationType = 0;
pub const VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM: VkInternalAllocationType =
    2147483647;
pub type VkInternalAllocationType = ::std::os::raw::c_uint;
pub const VK_FORMAT_UNDEFINED: VkFormat = 0;
pub const VK_FORMAT_R4G4_UNORM_PACK8: VkFormat = 1;
pub const VK_FORMAT_R4G4B4A4_UNORM_PACK16: VkFormat = 2;
pub const VK_FORMAT_B4G4R4A4_UNORM_PACK16: VkFormat = 3;
pub const VK_FORMAT_R5G6B5_UNORM_PACK16: VkFormat = 4;
pub const VK_FORMAT_B5G6R5_UNORM_PACK16: VkFormat = 5;
pub const VK_FORMAT_R5G5B5A1_UNORM_PACK16: VkFormat = 6;
pub const VK_FORMAT_B5G5R5A1_UNORM_PACK16: VkFormat = 7;
pub const VK_FORMAT_A1R5G5B5_UNORM_PACK16: VkFormat = 8;
pub const VK_FORMAT_R8_UNORM: VkFormat = 9;
pub const VK_FORMAT_R8_SNORM: VkFormat = 10;
pub const VK_FORMAT_R8_USCALED: VkFormat = 11;
pub const VK_FORMAT_R8_SSCALED: VkFormat = 12;
pub const VK_FORMAT_R8_UINT: VkFormat = 13;
pub const VK_FORMAT_R8_SINT: VkFormat = 14;
pub const VK_FORMAT_R8_SRGB: VkFormat = 15;
pub const VK_FORMAT_R8G8_UNORM: VkFormat = 16;
pub const VK_FORMAT_R8G8_SNORM: VkFormat = 17;
pub const VK_FORMAT_R8G8_USCALED: VkFormat = 18;
pub const VK_FORMAT_R8G8_SSCALED: VkFormat = 19;
pub const VK_FORMAT_R8G8_UINT: VkFormat = 20;
pub const VK_FORMAT_R8G8_SINT: VkFormat = 21;
pub const VK_FORMAT_R8G8_SRGB: VkFormat = 22;
pub const VK_FORMAT_R8G8B8_UNORM: VkFormat = 23;
pub const VK_FORMAT_R8G8B8_SNORM: VkFormat = 24;
pub const VK_FORMAT_R8G8B8_USCALED: VkFormat = 25;
pub const VK_FORMAT_R8G8B8_SSCALED: VkFormat = 26;
pub const VK_FORMAT_R8G8B8_UINT: VkFormat = 27;
pub const VK_FORMAT_R8G8B8_SINT: VkFormat = 28;
pub const VK_FORMAT_R8G8B8_SRGB: VkFormat = 29;
pub const VK_FORMAT_B8G8R8_UNORM: VkFormat = 30;
pub const VK_FORMAT_B8G8R8_SNORM: VkFormat = 31;
pub const VK_FORMAT_B8G8R8_USCALED: VkFormat = 32;
pub const VK_FORMAT_B8G8R8_SSCALED: VkFormat = 33;
pub const VK_FORMAT_B8G8R8_UINT: VkFormat = 34;
pub const VK_FORMAT_B8G8R8_SINT: VkFormat = 35;
pub const VK_FORMAT_B8G8R8_SRGB: VkFormat = 36;
pub const VK_FORMAT_R8G8B8A8_UNORM: VkFormat = 37;
pub const VK_FORMAT_R8G8B8A8_SNORM: VkFormat = 38;
pub const VK_FORMAT_R8G8B8A8_USCALED: VkFormat = 39;
pub const VK_FORMAT_R8G8B8A8_SSCALED: VkFormat = 40;
pub const VK_FORMAT_R8G8B8A8_UINT: VkFormat = 41;
pub const VK_FORMAT_R8G8B8A8_SINT: VkFormat = 42;
pub const VK_FORMAT_R8G8B8A8_SRGB: VkFormat = 43;
pub const VK_FORMAT_B8G8R8A8_UNORM: VkFormat = 44;
pub const VK_FORMAT_B8G8R8A8_SNORM: VkFormat = 45;
pub const VK_FORMAT_B8G8R8A8_USCALED: VkFormat = 46;
pub const VK_FORMAT_B8G8R8A8_SSCALED: VkFormat = 47;
pub const VK_FORMAT_B8G8R8A8_UINT: VkFormat = 48;
pub const VK_FORMAT_B8G8R8A8_SINT: VkFormat = 49;
pub const VK_FORMAT_B8G8R8A8_SRGB: VkFormat = 50;
pub const VK_FORMAT_A8B8G8R8_UNORM_PACK32: VkFormat = 51;
pub const VK_FORMAT_A8B8G8R8_SNORM_PACK32: VkFormat = 52;
pub const VK_FORMAT_A8B8G8R8_USCALED_PACK32: VkFormat = 53;
pub const VK_FORMAT_A8B8G8R8_SSCALED_PACK32: VkFormat = 54;
pub const VK_FORMAT_A8B8G8R8_UINT_PACK32: VkFormat = 55;
pub const VK_FORMAT_A8B8G8R8_SINT_PACK32: VkFormat = 56;
pub const VK_FORMAT_A8B8G8R8_SRGB_PACK32: VkFormat = 57;
pub const VK_FORMAT_A2R10G10B10_UNORM_PACK32: VkFormat = 58;
pub const VK_FORMAT_A2R10G10B10_SNORM_PACK32: VkFormat = 59;
pub const VK_FORMAT_A2R10G10B10_USCALED_PACK32: VkFormat = 60;
pub const VK_FORMAT_A2R10G10B10_SSCALED_PACK32: VkFormat = 61;
pub const VK_FORMAT_A2R10G10B10_UINT_PACK32: VkFormat = 62;
pub const VK_FORMAT_A2R10G10B10_SINT_PACK32: VkFormat = 63;
pub const VK_FORMAT_A2B10G10R10_UNORM_PACK32: VkFormat = 64;
pub const VK_FORMAT_A2B10G10R10_SNORM_PACK32: VkFormat = 65;
pub const VK_FORMAT_A2B10G10R10_USCALED_PACK32: VkFormat = 66;
pub const VK_FORMAT_A2B10G10R10_SSCALED_PACK32: VkFormat = 67;
pub const VK_FORMAT_A2B10G10R10_UINT_PACK32: VkFormat = 68;
pub const VK_FORMAT_A2B10G10R10_SINT_PACK32: VkFormat = 69;
pub const VK_FORMAT_R16_UNORM: VkFormat = 70;
pub const VK_FORMAT_R16_SNORM: VkFormat = 71;
pub const VK_FORMAT_R16_USCALED: VkFormat = 72;
pub const VK_FORMAT_R16_SSCALED: VkFormat = 73;
pub const VK_FORMAT_R16_UINT: VkFormat = 74;
pub const VK_FORMAT_R16_SINT: VkFormat = 75;
pub const VK_FORMAT_R16_SFLOAT: VkFormat = 76;
pub const VK_FORMAT_R16G16_UNORM: VkFormat = 77;
pub const VK_FORMAT_R16G16_SNORM: VkFormat = 78;
pub const VK_FORMAT_R16G16_USCALED: VkFormat = 79;
pub const VK_FORMAT_R16G16_SSCALED: VkFormat = 80;
pub const VK_FORMAT_R16G16_UINT: VkFormat = 81;
pub const VK_FORMAT_R16G16_SINT: VkFormat = 82;
pub const VK_FORMAT_R16G16_SFLOAT: VkFormat = 83;
pub const VK_FORMAT_R16G16B16_UNORM: VkFormat = 84;
pub const VK_FORMAT_R16G16B16_SNORM: VkFormat = 85;
pub const VK_FORMAT_R16G16B16_USCALED: VkFormat = 86;
pub const VK_FORMAT_R16G16B16_SSCALED: VkFormat = 87;
pub const VK_FORMAT_R16G16B16_UINT: VkFormat = 88;
pub const VK_FORMAT_R16G16B16_SINT: VkFormat = 89;
pub const VK_FORMAT_R16G16B16_SFLOAT: VkFormat = 90;
pub const VK_FORMAT_R16G16B16A16_UNORM: VkFormat = 91;
pub const VK_FORMAT_R16G16B16A16_SNORM: VkFormat = 92;
pub const VK_FORMAT_R16G16B16A16_USCALED: VkFormat = 93;
pub const VK_FORMAT_R16G16B16A16_SSCALED: VkFormat = 94;
pub const VK_FORMAT_R16G16B16A16_UINT: VkFormat = 95;
pub const VK_FORMAT_R16G16B16A16_SINT: VkFormat = 96;
pub const VK_FORMAT_R16G16B16A16_SFLOAT: VkFormat = 97;
pub const VK_FORMAT_R32_UINT: VkFormat = 98;
pub const VK_FORMAT_R32_SINT: VkFormat = 99;
pub const VK_FORMAT_R32_SFLOAT: VkFormat = 100;
pub const VK_FORMAT_R32G32_UINT: VkFormat = 101;
pub const VK_FORMAT_R32G32_SINT: VkFormat = 102;
pub const VK_FORMAT_R32G32_SFLOAT: VkFormat = 103;
pub const VK_FORMAT_R32G32B32_UINT: VkFormat = 104;
pub const VK_FORMAT_R32G32B32_SINT: VkFormat = 105;
pub const VK_FORMAT_R32G32B32_SFLOAT: VkFormat = 106;
pub const VK_FORMAT_R32G32B32A32_UINT: VkFormat = 107;
pub const VK_FORMAT_R32G32B32A32_SINT: VkFormat = 108;
pub const VK_FORMAT_R32G32B32A32_SFLOAT: VkFormat = 109;
pub const VK_FORMAT_R64_UINT: VkFormat = 110;
pub const VK_FORMAT_R64_SINT: VkFormat = 111;
pub const VK_FORMAT_R64_SFLOAT: VkFormat = 112;
pub const VK_FORMAT_R64G64_UINT: VkFormat = 113;
pub const VK_FORMAT_R64G64_SINT: VkFormat = 114;
pub const VK_FORMAT_R64G64_SFLOAT: VkFormat = 115;
pub const VK_FORMAT_R64G64B64_UINT: VkFormat = 116;
pub const VK_FORMAT_R64G64B64_SINT: VkFormat = 117;
pub const VK_FORMAT_R64G64B64_SFLOAT: VkFormat = 118;
pub const VK_FORMAT_R64G64B64A64_UINT: VkFormat = 119;
pub const VK_FORMAT_R64G64B64A64_SINT: VkFormat = 120;
pub const VK_FORMAT_R64G64B64A64_SFLOAT: VkFormat = 121;
pub const VK_FORMAT_B10G11R11_UFLOAT_PACK32: VkFormat = 122;
pub const VK_FORMAT_E5B9G9R9_UFLOAT_PACK32: VkFormat = 123;
pub const VK_FORMAT_D16_UNORM: VkFormat = 124;
pub const VK_FORMAT_X8_D24_UNORM_PACK32: VkFormat = 125;
pub const VK_FORMAT_D32_SFLOAT: VkFormat = 126;
pub const VK_FORMAT_S8_UINT: VkFormat = 127;
pub const VK_FORMAT_D16_UNORM_S8_UINT: VkFormat = 128;
pub const VK_FORMAT_D24_UNORM_S8_UINT: VkFormat = 129;
pub const VK_FORMAT_D32_SFLOAT_S8_UINT: VkFormat = 130;
pub const VK_FORMAT_BC1_RGB_UNORM_BLOCK: VkFormat = 131;
pub const VK_FORMAT_BC1_RGB_SRGB_BLOCK: VkFormat = 132;
pub const VK_FORMAT_BC1_RGBA_UNORM_BLOCK: VkFormat = 133;
pub const VK_FORMAT_BC1_RGBA_SRGB_BLOCK: VkFormat = 134;
pub const VK_FORMAT_BC2_UNORM_BLOCK: VkFormat = 135;
pub const VK_FORMAT_BC2_SRGB_BLOCK: VkFormat = 136;
pub const VK_FORMAT_BC3_UNORM_BLOCK: VkFormat = 137;
pub const VK_FORMAT_BC3_SRGB_BLOCK: VkFormat = 138;
pub const VK_FORMAT_BC4_UNORM_BLOCK: VkFormat = 139;
pub const VK_FORMAT_BC4_SNORM_BLOCK: VkFormat = 140;
pub const VK_FORMAT_BC5_UNORM_BLOCK: VkFormat = 141;
pub const VK_FORMAT_BC5_SNORM_BLOCK: VkFormat = 142;
pub const VK_FORMAT_BC6H_UFLOAT_BLOCK: VkFormat = 143;
pub const VK_FORMAT_BC6H_SFLOAT_BLOCK: VkFormat = 144;
pub const VK_FORMAT_BC7_UNORM_BLOCK: VkFormat = 145;
pub const VK_FORMAT_BC7_SRGB_BLOCK: VkFormat = 146;
pub const VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK: VkFormat = 147;
pub const VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK: VkFormat = 148;
pub const VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK: VkFormat = 149;
pub const VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK: VkFormat = 150;
pub const VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK: VkFormat = 151;
pub const VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK: VkFormat = 152;
pub const VK_FORMAT_EAC_R11_UNORM_BLOCK: VkFormat = 153;
pub const VK_FORMAT_EAC_R11_SNORM_BLOCK: VkFormat = 154;
pub const VK_FORMAT_EAC_R11G11_UNORM_BLOCK: VkFormat = 155;
pub const VK_FORMAT_EAC_R11G11_SNORM_BLOCK: VkFormat = 156;
pub const VK_FORMAT_ASTC_4x4_UNORM_BLOCK: VkFormat = 157;
pub const VK_FORMAT_ASTC_4x4_SRGB_BLOCK: VkFormat = 158;
pub const VK_FORMAT_ASTC_5x4_UNORM_BLOCK: VkFormat = 159;
pub const VK_FORMAT_ASTC_5x4_SRGB_BLOCK: VkFormat = 160;
pub const VK_FORMAT_ASTC_5x5_UNORM_BLOCK: VkFormat = 161;
pub const VK_FORMAT_ASTC_5x5_SRGB_BLOCK: VkFormat = 162;
pub const VK_FORMAT_ASTC_6x5_UNORM_BLOCK: VkFormat = 163;
pub const VK_FORMAT_ASTC_6x5_SRGB_BLOCK: VkFormat = 164;
pub const VK_FORMAT_ASTC_6x6_UNORM_BLOCK: VkFormat = 165;
pub const VK_FORMAT_ASTC_6x6_SRGB_BLOCK: VkFormat = 166;
pub const VK_FORMAT_ASTC_8x5_UNORM_BLOCK: VkFormat = 167;
pub const VK_FORMAT_ASTC_8x5_SRGB_BLOCK: VkFormat = 168;
pub const VK_FORMAT_ASTC_8x6_UNORM_BLOCK: VkFormat = 169;
pub const VK_FORMAT_ASTC_8x6_SRGB_BLOCK: VkFormat = 170;
pub const VK_FORMAT_ASTC_8x8_UNORM_BLOCK: VkFormat = 171;
pub const VK_FORMAT_ASTC_8x8_SRGB_BLOCK: VkFormat = 172;
pub const VK_FORMAT_ASTC_10x5_UNORM_BLOCK: VkFormat = 173;
pub const VK_FORMAT_ASTC_10x5_SRGB_BLOCK: VkFormat = 174;
pub const VK_FORMAT_ASTC_10x6_UNORM_BLOCK: VkFormat = 175;
pub const VK_FORMAT_ASTC_10x6_SRGB_BLOCK: VkFormat = 176;
pub const VK_FORMAT_ASTC_10x8_UNORM_BLOCK: VkFormat = 177;
pub const VK_FORMAT_ASTC_10x8_SRGB_BLOCK: VkFormat = 178;
pub const VK_FORMAT_ASTC_10x10_UNORM_BLOCK: VkFormat = 179;
pub const VK_FORMAT_ASTC_10x10_SRGB_BLOCK: VkFormat = 180;
pub const VK_FORMAT_ASTC_12x10_UNORM_BLOCK: VkFormat = 181;
pub const VK_FORMAT_ASTC_12x10_SRGB_BLOCK: VkFormat = 182;
pub const VK_FORMAT_ASTC_12x12_UNORM_BLOCK: VkFormat = 183;
pub const VK_FORMAT_ASTC_12x12_SRGB_BLOCK: VkFormat = 184;
pub const VK_FORMAT_G8B8G8R8_422_UNORM: VkFormat = 1000156000;
pub const VK_FORMAT_B8G8R8G8_422_UNORM: VkFormat = 1000156001;
pub const VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM: VkFormat = 1000156002;
pub const VK_FORMAT_G8_B8R8_2PLANE_420_UNORM: VkFormat = 1000156003;
pub const VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM: VkFormat = 1000156004;
pub const VK_FORMAT_G8_B8R8_2PLANE_422_UNORM: VkFormat = 1000156005;
pub const VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM: VkFormat = 1000156006;
pub const VK_FORMAT_R10X6_UNORM_PACK16: VkFormat = 1000156007;
pub const VK_FORMAT_R10X6G10X6_UNORM_2PACK16: VkFormat = 1000156008;
pub const VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16: VkFormat = 1000156009;
pub const VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: VkFormat = 1000156010;
pub const VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: VkFormat = 1000156011;
pub const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16: VkFormat = 1000156012;
pub const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16: VkFormat = 1000156013;
pub const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16: VkFormat = 1000156014;
pub const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16: VkFormat = 1000156015;
pub const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16: VkFormat = 1000156016;
pub const VK_FORMAT_R12X4_UNORM_PACK16: VkFormat = 1000156017;
pub const VK_FORMAT_R12X4G12X4_UNORM_2PACK16: VkFormat = 1000156018;
pub const VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16: VkFormat = 1000156019;
pub const VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: VkFormat = 1000156020;
pub const VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: VkFormat = 1000156021;
pub const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16: VkFormat = 1000156022;
pub const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16: VkFormat = 1000156023;
pub const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16: VkFormat = 1000156024;
pub const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16: VkFormat = 1000156025;
pub const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16: VkFormat = 1000156026;
pub const VK_FORMAT_G16B16G16R16_422_UNORM: VkFormat = 1000156027;
pub const VK_FORMAT_B16G16R16G16_422_UNORM: VkFormat = 1000156028;
pub const VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM: VkFormat = 1000156029;
pub const VK_FORMAT_G16_B16R16_2PLANE_420_UNORM: VkFormat = 1000156030;
pub const VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM: VkFormat = 1000156031;
pub const VK_FORMAT_G16_B16R16_2PLANE_422_UNORM: VkFormat = 1000156032;
pub const VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM: VkFormat = 1000156033;
pub const VK_FORMAT_G8_B8R8_2PLANE_444_UNORM: VkFormat = 1000330000;
pub const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16: VkFormat = 1000330001;
pub const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16: VkFormat = 1000330002;
pub const VK_FORMAT_G16_B16R16_2PLANE_444_UNORM: VkFormat = 1000330003;
pub const VK_FORMAT_A4R4G4B4_UNORM_PACK16: VkFormat = 1000340000;
pub const VK_FORMAT_A4B4G4R4_UNORM_PACK16: VkFormat = 1000340001;
pub const VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK: VkFormat = 1000066000;
pub const VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK: VkFormat = 1000066001;
pub const VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK: VkFormat = 1000066002;
pub const VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK: VkFormat = 1000066003;
pub const VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK: VkFormat = 1000066004;
pub const VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK: VkFormat = 1000066005;
pub const VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK: VkFormat = 1000066006;
pub const VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK: VkFormat = 1000066007;
pub const VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK: VkFormat = 1000066008;
pub const VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK: VkFormat = 1000066009;
pub const VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK: VkFormat = 1000066010;
pub const VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK: VkFormat = 1000066011;
pub const VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK: VkFormat = 1000066012;
pub const VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK: VkFormat = 1000066013;
pub const VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG: VkFormat = 1000054000;
pub const VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG: VkFormat = 1000054001;
pub const VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG: VkFormat = 1000054002;
pub const VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG: VkFormat = 1000054003;
pub const VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG: VkFormat = 1000054004;
pub const VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG: VkFormat = 1000054005;
pub const VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG: VkFormat = 1000054006;
pub const VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG: VkFormat = 1000054007;
pub const VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT: VkFormat = 1000066000;
pub const VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT: VkFormat = 1000066001;
pub const VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066002;
pub const VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066003;
pub const VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066004;
pub const VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066005;
pub const VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066006;
pub const VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT: VkFormat = 1000066007;
pub const VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066008;
pub const VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066009;
pub const VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT: VkFormat = 1000066010;
pub const VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT: VkFormat = 1000066011;
pub const VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT: VkFormat = 1000066012;
pub const VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT: VkFormat = 1000066013;
pub const VK_FORMAT_G8B8G8R8_422_UNORM_KHR: VkFormat = 1000156000;
pub const VK_FORMAT_B8G8R8G8_422_UNORM_KHR: VkFormat = 1000156001;
pub const VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR: VkFormat = 1000156002;
pub const VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR: VkFormat = 1000156003;
pub const VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR: VkFormat = 1000156004;
pub const VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR: VkFormat = 1000156005;
pub const VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR: VkFormat = 1000156006;
pub const VK_FORMAT_R10X6_UNORM_PACK16_KHR: VkFormat = 1000156007;
pub const VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR: VkFormat = 1000156008;
pub const VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR: VkFormat = 1000156009;
pub const VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR: VkFormat = 1000156010;
pub const VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR: VkFormat = 1000156011;
pub const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156012;
pub const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156013;
pub const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156014;
pub const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156015;
pub const VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR: VkFormat = 1000156016;
pub const VK_FORMAT_R12X4_UNORM_PACK16_KHR: VkFormat = 1000156017;
pub const VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR: VkFormat = 1000156018;
pub const VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR: VkFormat = 1000156019;
pub const VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR: VkFormat = 1000156020;
pub const VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR: VkFormat = 1000156021;
pub const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156022;
pub const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156023;
pub const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156024;
pub const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156025;
pub const VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR: VkFormat = 1000156026;
pub const VK_FORMAT_G16B16G16R16_422_UNORM_KHR: VkFormat = 1000156027;
pub const VK_FORMAT_B16G16R16G16_422_UNORM_KHR: VkFormat = 1000156028;
pub const VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR: VkFormat = 1000156029;
pub const VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR: VkFormat = 1000156030;
pub const VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR: VkFormat = 1000156031;
pub const VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR: VkFormat = 1000156032;
pub const VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR: VkFormat = 1000156033;
pub const VK_FORMAT_G8_B8R8_2PLANE_444_UNORM_EXT: VkFormat = 1000330000;
pub const VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16_EXT: VkFormat = 1000330001;
pub const VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16_EXT: VkFormat = 1000330002;
pub const VK_FORMAT_G16_B16R16_2PLANE_444_UNORM_EXT: VkFormat = 1000330003;
pub const VK_FORMAT_A4R4G4B4_UNORM_PACK16_EXT: VkFormat = 1000340000;
pub const VK_FORMAT_A4B4G4R4_UNORM_PACK16_EXT: VkFormat = 1000340001;
pub const VK_FORMAT_MAX_ENUM: VkFormat = 2147483647;
pub type VkFormat = ::std::os::raw::c_uint;
pub const VK_IMAGE_TILING_OPTIMAL: VkImageTiling = 0;
pub const VK_IMAGE_TILING_LINEAR: VkImageTiling = 1;
pub const VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT: VkImageTiling = 1000158000;
pub const VK_IMAGE_TILING_MAX_ENUM: VkImageTiling = 2147483647;
pub type VkImageTiling = ::std::os::raw::c_uint;
pub const VK_IMAGE_TYPE_1D: VkImageType = 0;
pub const VK_IMAGE_TYPE_2D: VkImageType = 1;
pub const VK_IMAGE_TYPE_3D: VkImageType = 2;
pub const VK_IMAGE_TYPE_MAX_ENUM: VkImageType = 2147483647;
pub type VkImageType = ::std::os::raw::c_uint;
pub const VK_PHYSICAL_DEVICE_TYPE_OTHER: VkPhysicalDeviceType = 0;
pub const VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU: VkPhysicalDeviceType = 1;
pub const VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU: VkPhysicalDeviceType = 2;
pub const VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU: VkPhysicalDeviceType = 3;
pub const VK_PHYSICAL_DEVICE_TYPE_CPU: VkPhysicalDeviceType = 4;
pub const VK_PHYSICAL_DEVICE_TYPE_MAX_ENUM: VkPhysicalDeviceType = 2147483647;
pub type VkPhysicalDeviceType = ::std::os::raw::c_uint;
pub const VK_QUERY_TYPE_OCCLUSION: VkQueryType = 0;
pub const VK_QUERY_TYPE_PIPELINE_STATISTICS: VkQueryType = 1;
pub const VK_QUERY_TYPE_TIMESTAMP: VkQueryType = 2;
pub const VK_QUERY_TYPE_RESULT_STATUS_ONLY_KHR: VkQueryType = 1000023000;
pub const VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT: VkQueryType = 1000028004;
pub const VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR: VkQueryType = 1000116000;
pub const VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR: VkQueryType =
    1000150000;
pub const VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR: VkQueryType =
    1000150001;
pub const VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV: VkQueryType =
    1000165000;
pub const VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL: VkQueryType = 1000210000;
pub const VK_QUERY_TYPE_VIDEO_ENCODE_BITSTREAM_BUFFER_RANGE_KHR: VkQueryType =
    1000299000;
pub const VK_QUERY_TYPE_PRIMITIVES_GENERATED_EXT: VkQueryType = 1000382000;
pub const VK_QUERY_TYPE_MAX_ENUM: VkQueryType = 2147483647;
pub type VkQueryType = ::std::os::raw::c_uint;
pub const VK_SHARING_MODE_EXCLUSIVE: VkSharingMode = 0;
pub const VK_SHARING_MODE_CONCURRENT: VkSharingMode = 1;
pub const VK_SHARING_MODE_MAX_ENUM: VkSharingMode = 2147483647;
pub type VkSharingMode = ::std::os::raw::c_uint;
pub const VK_COMPONENT_SWIZZLE_IDENTITY: VkComponentSwizzle = 0;
pub const VK_COMPONENT_SWIZZLE_ZERO: VkComponentSwizzle = 1;
pub const VK_COMPONENT_SWIZZLE_ONE: VkComponentSwizzle = 2;
pub const VK_COMPONENT_SWIZZLE_R: VkComponentSwizzle = 3;
pub const VK_COMPONENT_SWIZZLE_G: VkComponentSwizzle = 4;
pub const VK_COMPONENT_SWIZZLE_B: VkComponentSwizzle = 5;
pub const VK_COMPONENT_SWIZZLE_A: VkComponentSwizzle = 6;
pub const VK_COMPONENT_SWIZZLE_MAX_ENUM: VkComponentSwizzle = 2147483647;
pub type VkComponentSwizzle = ::std::os::raw::c_uint;
pub const VK_IMAGE_VIEW_TYPE_1D: VkImageViewType = 0;
pub const VK_IMAGE_VIEW_TYPE_2D: VkImageViewType = 1;
pub const VK_IMAGE_VIEW_TYPE_3D: VkImageViewType = 2;
pub const VK_IMAGE_VIEW_TYPE_CUBE: VkImageViewType = 3;
pub const VK_IMAGE_VIEW_TYPE_1D_ARRAY: VkImageViewType = 4;
pub const VK_IMAGE_VIEW_TYPE_2D_ARRAY: VkImageViewType = 5;
pub const VK_IMAGE_VIEW_TYPE_CUBE_ARRAY: VkImageViewType = 6;
pub const VK_IMAGE_VIEW_TYPE_MAX_ENUM: VkImageViewType = 2147483647;
pub type VkImageViewType = ::std::os::raw::c_uint;
pub const VK_BLEND_FACTOR_ZERO: VkBlendFactor = 0;
pub const VK_BLEND_FACTOR_ONE: VkBlendFactor = 1;
pub const VK_BLEND_FACTOR_SRC_COLOR: VkBlendFactor = 2;
pub const VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR: VkBlendFactor = 3;
pub const VK_BLEND_FACTOR_DST_COLOR: VkBlendFactor = 4;
pub const VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR: VkBlendFactor = 5;
pub const VK_BLEND_FACTOR_SRC_ALPHA: VkBlendFactor = 6;
pub const VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA: VkBlendFactor = 7;
pub const VK_BLEND_FACTOR_DST_ALPHA: VkBlendFactor = 8;
pub const VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA: VkBlendFactor = 9;
pub const VK_BLEND_FACTOR_CONSTANT_COLOR: VkBlendFactor = 10;
pub const VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR: VkBlendFactor = 11;
pub const VK_BLEND_FACTOR_CONSTANT_ALPHA: VkBlendFactor = 12;
pub const VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA: VkBlendFactor = 13;
pub const VK_BLEND_FACTOR_SRC_ALPHA_SATURATE: VkBlendFactor = 14;
pub const VK_BLEND_FACTOR_SRC1_COLOR: VkBlendFactor = 15;
pub const VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR: VkBlendFactor = 16;
pub const VK_BLEND_FACTOR_SRC1_ALPHA: VkBlendFactor = 17;
pub const VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA: VkBlendFactor = 18;
pub const VK_BLEND_FACTOR_MAX_ENUM: VkBlendFactor = 2147483647;
pub type VkBlendFactor = ::std::os::raw::c_uint;
pub const VK_BLEND_OP_ADD: VkBlendOp = 0;
pub const VK_BLEND_OP_SUBTRACT: VkBlendOp = 1;
pub const VK_BLEND_OP_REVERSE_SUBTRACT: VkBlendOp = 2;
pub const VK_BLEND_OP_MIN: VkBlendOp = 3;
pub const VK_BLEND_OP_MAX: VkBlendOp = 4;
pub const VK_BLEND_OP_ZERO_EXT: VkBlendOp = 1000148000;
pub const VK_BLEND_OP_SRC_EXT: VkBlendOp = 1000148001;
pub const VK_BLEND_OP_DST_EXT: VkBlendOp = 1000148002;
pub const VK_BLEND_OP_SRC_OVER_EXT: VkBlendOp = 1000148003;
pub const VK_BLEND_OP_DST_OVER_EXT: VkBlendOp = 1000148004;
pub const VK_BLEND_OP_SRC_IN_EXT: VkBlendOp = 1000148005;
pub const VK_BLEND_OP_DST_IN_EXT: VkBlendOp = 1000148006;
pub const VK_BLEND_OP_SRC_OUT_EXT: VkBlendOp = 1000148007;
pub const VK_BLEND_OP_DST_OUT_EXT: VkBlendOp = 1000148008;
pub const VK_BLEND_OP_SRC_ATOP_EXT: VkBlendOp = 1000148009;
pub const VK_BLEND_OP_DST_ATOP_EXT: VkBlendOp = 1000148010;
pub const VK_BLEND_OP_XOR_EXT: VkBlendOp = 1000148011;
pub const VK_BLEND_OP_MULTIPLY_EXT: VkBlendOp = 1000148012;
pub const VK_BLEND_OP_SCREEN_EXT: VkBlendOp = 1000148013;
pub const VK_BLEND_OP_OVERLAY_EXT: VkBlendOp = 1000148014;
pub const VK_BLEND_OP_DARKEN_EXT: VkBlendOp = 1000148015;
pub const VK_BLEND_OP_LIGHTEN_EXT: VkBlendOp = 1000148016;
pub const VK_BLEND_OP_COLORDODGE_EXT: VkBlendOp = 1000148017;
pub const VK_BLEND_OP_COLORBURN_EXT: VkBlendOp = 1000148018;
pub const VK_BLEND_OP_HARDLIGHT_EXT: VkBlendOp = 1000148019;
pub const VK_BLEND_OP_SOFTLIGHT_EXT: VkBlendOp = 1000148020;
pub const VK_BLEND_OP_DIFFERENCE_EXT: VkBlendOp = 1000148021;
pub const VK_BLEND_OP_EXCLUSION_EXT: VkBlendOp = 1000148022;
pub const VK_BLEND_OP_INVERT_EXT: VkBlendOp = 1000148023;
pub const VK_BLEND_OP_INVERT_RGB_EXT: VkBlendOp = 1000148024;
pub const VK_BLEND_OP_LINEARDODGE_EXT: VkBlendOp = 1000148025;
pub const VK_BLEND_OP_LINEARBURN_EXT: VkBlendOp = 1000148026;
pub const VK_BLEND_OP_VIVIDLIGHT_EXT: VkBlendOp = 1000148027;
pub const VK_BLEND_OP_LINEARLIGHT_EXT: VkBlendOp = 1000148028;
pub const VK_BLEND_OP_PINLIGHT_EXT: VkBlendOp = 1000148029;
pub const VK_BLEND_OP_HARDMIX_EXT: VkBlendOp = 1000148030;
pub const VK_BLEND_OP_HSL_HUE_EXT: VkBlendOp = 1000148031;
pub const VK_BLEND_OP_HSL_SATURATION_EXT: VkBlendOp = 1000148032;
pub const VK_BLEND_OP_HSL_COLOR_EXT: VkBlendOp = 1000148033;
pub const VK_BLEND_OP_HSL_LUMINOSITY_EXT: VkBlendOp = 1000148034;
pub const VK_BLEND_OP_PLUS_EXT: VkBlendOp = 1000148035;
pub const VK_BLEND_OP_PLUS_CLAMPED_EXT: VkBlendOp = 1000148036;
pub const VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT: VkBlendOp = 1000148037;
pub const VK_BLEND_OP_PLUS_DARKER_EXT: VkBlendOp = 1000148038;
pub const VK_BLEND_OP_MINUS_EXT: VkBlendOp = 1000148039;
pub const VK_BLEND_OP_MINUS_CLAMPED_EXT: VkBlendOp = 1000148040;
pub const VK_BLEND_OP_CONTRAST_EXT: VkBlendOp = 1000148041;
pub const VK_BLEND_OP_INVERT_OVG_EXT: VkBlendOp = 1000148042;
pub const VK_BLEND_OP_RED_EXT: VkBlendOp = 1000148043;
pub const VK_BLEND_OP_GREEN_EXT: VkBlendOp = 1000148044;
pub const VK_BLEND_OP_BLUE_EXT: VkBlendOp = 1000148045;
pub const VK_BLEND_OP_MAX_ENUM: VkBlendOp = 2147483647;
pub type VkBlendOp = ::std::os::raw::c_uint;
pub const VK_COMPARE_OP_NEVER: VkCompareOp = 0;
pub const VK_COMPARE_OP_LESS: VkCompareOp = 1;
pub const VK_COMPARE_OP_EQUAL: VkCompareOp = 2;
pub const VK_COMPARE_OP_LESS_OR_EQUAL: VkCompareOp = 3;
pub const VK_COMPARE_OP_GREATER: VkCompareOp = 4;
pub const VK_COMPARE_OP_NOT_EQUAL: VkCompareOp = 5;
pub const VK_COMPARE_OP_GREATER_OR_EQUAL: VkCompareOp = 6;
pub const VK_COMPARE_OP_ALWAYS: VkCompareOp = 7;
pub const VK_COMPARE_OP_MAX_ENUM: VkCompareOp = 2147483647;
pub type VkCompareOp = ::std::os::raw::c_uint;
pub const VK_DYNAMIC_STATE_VIEWPORT: VkDynamicState = 0;
pub const VK_DYNAMIC_STATE_SCISSOR: VkDynamicState = 1;
pub const VK_DYNAMIC_STATE_LINE_WIDTH: VkDynamicState = 2;
pub const VK_DYNAMIC_STATE_DEPTH_BIAS: VkDynamicState = 3;
pub const VK_DYNAMIC_STATE_BLEND_CONSTANTS: VkDynamicState = 4;
pub const VK_DYNAMIC_STATE_DEPTH_BOUNDS: VkDynamicState = 5;
pub const VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK: VkDynamicState = 6;
pub const VK_DYNAMIC_STATE_STENCIL_WRITE_MASK: VkDynamicState = 7;
pub const VK_DYNAMIC_STATE_STENCIL_REFERENCE: VkDynamicState = 8;
pub const VK_DYNAMIC_STATE_CULL_MODE: VkDynamicState = 1000267000;
pub const VK_DYNAMIC_STATE_FRONT_FACE: VkDynamicState = 1000267001;
pub const VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY: VkDynamicState = 1000267002;
pub const VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT: VkDynamicState = 1000267003;
pub const VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT: VkDynamicState = 1000267004;
pub const VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE: VkDynamicState = 1000267005;
pub const VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE: VkDynamicState = 1000267006;
pub const VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE: VkDynamicState = 1000267007;
pub const VK_DYNAMIC_STATE_DEPTH_COMPARE_OP: VkDynamicState = 1000267008;
pub const VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE: VkDynamicState = 1000267009;
pub const VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE: VkDynamicState = 1000267010;
pub const VK_DYNAMIC_STATE_STENCIL_OP: VkDynamicState = 1000267011;
pub const VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE: VkDynamicState = 1000377001;
pub const VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE: VkDynamicState = 1000377002;
pub const VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE: VkDynamicState = 1000377004;
pub const VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV: VkDynamicState = 1000087000;
pub const VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT: VkDynamicState = 1000099000;
pub const VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT: VkDynamicState = 1000143000;
pub const VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR: VkDynamicState =
    1000347000;
pub const VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV: VkDynamicState =
    1000164004;
pub const VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV: VkDynamicState =
    1000164006;
pub const VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV: VkDynamicState = 1000205001;
pub const VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR: VkDynamicState = 1000226000;
pub const VK_DYNAMIC_STATE_LINE_STIPPLE_EXT: VkDynamicState = 1000259000;
pub const VK_DYNAMIC_STATE_VERTEX_INPUT_EXT: VkDynamicState = 1000352000;
pub const VK_DYNAMIC_STATE_PATCH_CONTROL_POINTS_EXT: VkDynamicState = 1000377000;
pub const VK_DYNAMIC_STATE_LOGIC_OP_EXT: VkDynamicState = 1000377003;
pub const VK_DYNAMIC_STATE_COLOR_WRITE_ENABLE_EXT: VkDynamicState = 1000381000;
pub const VK_DYNAMIC_STATE_CULL_MODE_EXT: VkDynamicState = 1000267000;
pub const VK_DYNAMIC_STATE_FRONT_FACE_EXT: VkDynamicState = 1000267001;
pub const VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT: VkDynamicState = 1000267002;
pub const VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT: VkDynamicState = 1000267003;
pub const VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT: VkDynamicState = 1000267004;
pub const VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT: VkDynamicState =
    1000267005;
pub const VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT: VkDynamicState = 1000267006;
pub const VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT: VkDynamicState = 1000267007;
pub const VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT: VkDynamicState = 1000267008;
pub const VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT: VkDynamicState = 1000267009;
pub const VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT: VkDynamicState = 1000267010;
pub const VK_DYNAMIC_STATE_STENCIL_OP_EXT: VkDynamicState = 1000267011;
pub const VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT: VkDynamicState =
    1000377001;
pub const VK_DYNAMIC_STATE_DEPTH_BIAS_ENABLE_EXT: VkDynamicState = 1000377002;
pub const VK_DYNAMIC_STATE_PRIMITIVE_RESTART_ENABLE_EXT: VkDynamicState = 1000377004;
pub const VK_DYNAMIC_STATE_MAX_ENUM: VkDynamicState = 2147483647;
pub type VkDynamicState = ::std::os::raw::c_uint;
pub const VK_FRONT_FACE_COUNTER_CLOCKWISE: VkFrontFace = 0;
pub const VK_FRONT_FACE_CLOCKWISE: VkFrontFace = 1;
pub const VK_FRONT_FACE_MAX_ENUM: VkFrontFace = 2147483647;
pub type VkFrontFace = ::std::os::raw::c_uint;
pub const VK_VERTEX_INPUT_RATE_VERTEX: VkVertexInputRate = 0;
pub const VK_VERTEX_INPUT_RATE_INSTANCE: VkVertexInputRate = 1;
pub const VK_VERTEX_INPUT_RATE_MAX_ENUM: VkVertexInputRate = 2147483647;
pub type VkVertexInputRate = ::std::os::raw::c_uint;
pub const VK_PRIMITIVE_TOPOLOGY_POINT_LIST: VkPrimitiveTopology = 0;
pub const VK_PRIMITIVE_TOPOLOGY_LINE_LIST: VkPrimitiveTopology = 1;
pub const VK_PRIMITIVE_TOPOLOGY_LINE_STRIP: VkPrimitiveTopology = 2;
pub const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST: VkPrimitiveTopology = 3;
pub const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP: VkPrimitiveTopology = 4;
pub const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN: VkPrimitiveTopology = 5;
pub const VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY: VkPrimitiveTopology =
    6;
pub const VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY: VkPrimitiveTopology =
    7;
pub const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY:
    VkPrimitiveTopology = 8;
pub const VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY:
    VkPrimitiveTopology = 9;
pub const VK_PRIMITIVE_TOPOLOGY_PATCH_LIST: VkPrimitiveTopology = 10;
pub const VK_PRIMITIVE_TOPOLOGY_MAX_ENUM: VkPrimitiveTopology = 2147483647;
pub type VkPrimitiveTopology = ::std::os::raw::c_uint;
pub const VK_POLYGON_MODE_FILL: VkPolygonMode = 0;
pub const VK_POLYGON_MODE_LINE: VkPolygonMode = 1;
pub const VK_POLYGON_MODE_POINT: VkPolygonMode = 2;
pub const VK_POLYGON_MODE_FILL_RECTANGLE_NV: VkPolygonMode = 1000153000;
pub const VK_POLYGON_MODE_MAX_ENUM: VkPolygonMode = 2147483647;
pub type VkPolygonMode = ::std::os::raw::c_uint;
pub const VK_STENCIL_OP_KEEP: VkStencilOp = 0;
pub const VK_STENCIL_OP_ZERO: VkStencilOp = 1;
pub const VK_STENCIL_OP_REPLACE: VkStencilOp = 2;
pub const VK_STENCIL_OP_INCREMENT_AND_CLAMP: VkStencilOp = 3;
pub const VK_STENCIL_OP_DECREMENT_AND_CLAMP: VkStencilOp = 4;
pub const VK_STENCIL_OP_INVERT: VkStencilOp = 5;
pub const VK_STENCIL_OP_INCREMENT_AND_WRAP: VkStencilOp = 6;
pub const VK_STENCIL_OP_DECREMENT_AND_WRAP: VkStencilOp = 7;
pub const VK_STENCIL_OP_MAX_ENUM: VkStencilOp = 2147483647;
pub type VkStencilOp = ::std::os::raw::c_uint;
pub const VK_LOGIC_OP_CLEAR: VkLogicOp = 0;
pub const VK_LOGIC_OP_AND: VkLogicOp = 1;
pub const VK_LOGIC_OP_AND_REVERSE: VkLogicOp = 2;
pub const VK_LOGIC_OP_COPY: VkLogicOp = 3;
pub const VK_LOGIC_OP_AND_INVERTED: VkLogicOp = 4;
pub const VK_LOGIC_OP_NO_OP: VkLogicOp = 5;
pub const VK_LOGIC_OP_XOR: VkLogicOp = 6;
pub const VK_LOGIC_OP_OR: VkLogicOp = 7;
pub const VK_LOGIC_OP_NOR: VkLogicOp = 8;
pub const VK_LOGIC_OP_EQUIVALENT: VkLogicOp = 9;
pub const VK_LOGIC_OP_INVERT: VkLogicOp = 10;
pub const VK_LOGIC_OP_OR_REVERSE: VkLogicOp = 11;
pub const VK_LOGIC_OP_COPY_INVERTED: VkLogicOp = 12;
pub const VK_LOGIC_OP_OR_INVERTED: VkLogicOp = 13;
pub const VK_LOGIC_OP_NAND: VkLogicOp = 14;
pub const VK_LOGIC_OP_SET: VkLogicOp = 15;
pub const VK_LOGIC_OP_MAX_ENUM: VkLogicOp = 2147483647;
pub type VkLogicOp = ::std::os::raw::c_uint;
pub const VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK: VkBorderColor = 0;
pub const VK_BORDER_COLOR_INT_TRANSPARENT_BLACK: VkBorderColor = 1;
pub const VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK: VkBorderColor = 2;
pub const VK_BORDER_COLOR_INT_OPAQUE_BLACK: VkBorderColor = 3;
pub const VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE: VkBorderColor = 4;
pub const VK_BORDER_COLOR_INT_OPAQUE_WHITE: VkBorderColor = 5;
pub const VK_BORDER_COLOR_FLOAT_CUSTOM_EXT: VkBorderColor = 1000287003;
pub const VK_BORDER_COLOR_INT_CUSTOM_EXT: VkBorderColor = 1000287004;
pub const VK_BORDER_COLOR_MAX_ENUM: VkBorderColor = 2147483647;
pub type VkBorderColor = ::std::os::raw::c_uint;
pub const VK_FILTER_NEAREST: VkFilter = 0;
pub const VK_FILTER_LINEAR: VkFilter = 1;
pub const VK_FILTER_CUBIC_IMG: VkFilter = 1000015000;
pub const VK_FILTER_CUBIC_EXT: VkFilter = 1000015000;
pub const VK_FILTER_MAX_ENUM: VkFilter = 2147483647;
pub type VkFilter = ::std::os::raw::c_uint;
pub const VK_SAMPLER_ADDRESS_MODE_REPEAT: VkSamplerAddressMode = 0;
pub const VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT: VkSamplerAddressMode = 1;
pub const VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE: VkSamplerAddressMode = 2;
pub const VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER: VkSamplerAddressMode = 3;
pub const VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE: VkSamplerAddressMode =
    4;
pub const VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE_KHR:
    VkSamplerAddressMode = 4;
pub const VK_SAMPLER_ADDRESS_MODE_MAX_ENUM: VkSamplerAddressMode = 2147483647;
pub type VkSamplerAddressMode = ::std::os::raw::c_uint;
pub const VK_SAMPLER_MIPMAP_MODE_NEAREST: VkSamplerMipmapMode = 0;
pub const VK_SAMPLER_MIPMAP_MODE_LINEAR: VkSamplerMipmapMode = 1;
pub const VK_SAMPLER_MIPMAP_MODE_MAX_ENUM: VkSamplerMipmapMode = 2147483647;
pub type VkSamplerMipmapMode = ::std::os::raw::c_uint;
pub const VK_DESCRIPTOR_TYPE_SAMPLER: VkDescriptorType = 0;
pub const VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER: VkDescriptorType = 1;
pub const VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE: VkDescriptorType = 2;
pub const VK_DESCRIPTOR_TYPE_STORAGE_IMAGE: VkDescriptorType = 3;
pub const VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER: VkDescriptorType = 4;
pub const VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER: VkDescriptorType = 5;
pub const VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER: VkDescriptorType = 6;
pub const VK_DESCRIPTOR_TYPE_STORAGE_BUFFER: VkDescriptorType = 7;
pub const VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC: VkDescriptorType = 8;
pub const VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC: VkDescriptorType = 9;
pub const VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT: VkDescriptorType = 10;
pub const VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK: VkDescriptorType = 1000138000;
pub const VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR: VkDescriptorType =
    1000150000;
pub const VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV: VkDescriptorType =
    1000165000;
pub const VK_DESCRIPTOR_TYPE_MUTABLE_VALVE: VkDescriptorType = 1000351000;
pub const VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT: VkDescriptorType =
    1000138000;
pub const VK_DESCRIPTOR_TYPE_MAX_ENUM: VkDescriptorType = 2147483647;
pub type VkDescriptorType = ::std::os::raw::c_uint;
pub const VK_ATTACHMENT_LOAD_OP_LOAD: VkAttachmentLoadOp = 0;
pub const VK_ATTACHMENT_LOAD_OP_CLEAR: VkAttachmentLoadOp = 1;
pub const VK_ATTACHMENT_LOAD_OP_DONT_CARE: VkAttachmentLoadOp = 2;
pub const VK_ATTACHMENT_LOAD_OP_NONE_EXT: VkAttachmentLoadOp = 1000400000;
pub const VK_ATTACHMENT_LOAD_OP_MAX_ENUM: VkAttachmentLoadOp = 2147483647;
pub type VkAttachmentLoadOp = ::std::os::raw::c_uint;
pub const VK_ATTACHMENT_STORE_OP_STORE: VkAttachmentStoreOp = 0;
pub const VK_ATTACHMENT_STORE_OP_DONT_CARE: VkAttachmentStoreOp = 1;
pub const VK_ATTACHMENT_STORE_OP_NONE: VkAttachmentStoreOp = 1000301000;
pub const VK_ATTACHMENT_STORE_OP_NONE_KHR: VkAttachmentStoreOp = 1000301000;
pub const VK_ATTACHMENT_STORE_OP_NONE_QCOM: VkAttachmentStoreOp = 1000301000;
pub const VK_ATTACHMENT_STORE_OP_NONE_EXT: VkAttachmentStoreOp = 1000301000;
pub const VK_ATTACHMENT_STORE_OP_MAX_ENUM: VkAttachmentStoreOp = 2147483647;
pub type VkAttachmentStoreOp = ::std::os::raw::c_uint;
pub const VK_PIPELINE_BIND_POINT_GRAPHICS: VkPipelineBindPoint = 0;
pub const VK_PIPELINE_BIND_POINT_COMPUTE: VkPipelineBindPoint = 1;
pub const VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR: VkPipelineBindPoint =
    1000165000;
pub const VK_PIPELINE_BIND_POINT_SUBPASS_SHADING_HUAWEI: VkPipelineBindPoint =
    1000369003;
pub const VK_PIPELINE_BIND_POINT_RAY_TRACING_NV: VkPipelineBindPoint =
    1000165000;
pub const VK_PIPELINE_BIND_POINT_MAX_ENUM: VkPipelineBindPoint = 2147483647;
pub type VkPipelineBindPoint = ::std::os::raw::c_uint;
pub const VK_COMMAND_BUFFER_LEVEL_PRIMARY: VkCommandBufferLevel = 0;
pub const VK_COMMAND_BUFFER_LEVEL_SECONDARY: VkCommandBufferLevel = 1;
pub const VK_COMMAND_BUFFER_LEVEL_MAX_ENUM: VkCommandBufferLevel = 2147483647;
pub type VkCommandBufferLevel = ::std::os::raw::c_uint;
pub const VK_INDEX_TYPE_UINT16: VkIndexType = 0;
pub const VK_INDEX_TYPE_UINT32: VkIndexType = 1;
pub const VK_INDEX_TYPE_NONE_KHR: VkIndexType = 1000165000;
pub const VK_INDEX_TYPE_UINT8_EXT: VkIndexType = 1000265000;
pub const VK_INDEX_TYPE_NONE_NV: VkIndexType = 1000165000;
pub const VK_INDEX_TYPE_MAX_ENUM: VkIndexType = 2147483647;
pub type VkIndexType = ::std::os::raw::c_uint;
pub const VK_SUBPASS_CONTENTS_INLINE: VkSubpassContents = 0;
pub const VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS: VkSubpassContents = 1;
pub const VK_SUBPASS_CONTENTS_MAX_ENUM: VkSubpassContents = 2147483647;
pub type VkSubpassContents = ::std::os::raw::c_uint;
pub const VK_ACCESS_INDIRECT_COMMAND_READ_BIT: VkAccessFlagBits = 1;
pub const VK_ACCESS_INDEX_READ_BIT: VkAccessFlagBits = 2;
pub const VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT: VkAccessFlagBits = 4;
pub const VK_ACCESS_UNIFORM_READ_BIT: VkAccessFlagBits = 8;
pub const VK_ACCESS_INPUT_ATTACHMENT_READ_BIT: VkAccessFlagBits = 16;
pub const VK_ACCESS_SHADER_READ_BIT: VkAccessFlagBits = 32;
pub const VK_ACCESS_SHADER_WRITE_BIT: VkAccessFlagBits = 64;
pub const VK_ACCESS_COLOR_ATTACHMENT_READ_BIT: VkAccessFlagBits = 128;
pub const VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT: VkAccessFlagBits = 256;
pub const VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT: VkAccessFlagBits = 512;
pub const VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT: VkAccessFlagBits = 1024;
pub const VK_ACCESS_TRANSFER_READ_BIT: VkAccessFlagBits = 2048;
pub const VK_ACCESS_TRANSFER_WRITE_BIT: VkAccessFlagBits = 4096;
pub const VK_ACCESS_HOST_READ_BIT: VkAccessFlagBits = 8192;
pub const VK_ACCESS_HOST_WRITE_BIT: VkAccessFlagBits = 16384;
pub const VK_ACCESS_MEMORY_READ_BIT: VkAccessFlagBits = 32768;
pub const VK_ACCESS_MEMORY_WRITE_BIT: VkAccessFlagBits = 65536;
pub const VK_ACCESS_NONE: VkAccessFlagBits = 0;
pub const VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT: VkAccessFlagBits = 33554432;
pub const VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT: VkAccessFlagBits =
    67108864;
pub const VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT: VkAccessFlagBits =
    134217728;
pub const VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT: VkAccessFlagBits = 1048576;
pub const VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT: VkAccessFlagBits =
    524288;
pub const VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR: VkAccessFlagBits =
    2097152;
pub const VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR: VkAccessFlagBits =
    4194304;
pub const VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT: VkAccessFlagBits = 16777216;
pub const VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR:
    VkAccessFlagBits = 8388608;
pub const VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV: VkAccessFlagBits = 131072;
pub const VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV: VkAccessFlagBits = 262144;
pub const VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV: VkAccessFlagBits = 8388608;
pub const VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV: VkAccessFlagBits = 2097152;
pub const VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV: VkAccessFlagBits =
    4194304;
pub const VK_ACCESS_NONE_KHR: VkAccessFlagBits = 0;
pub const VK_ACCESS_FLAG_BITS_MAX_ENUM: VkAccessFlagBits = 2147483647;
pub type VkAccessFlagBits = ::std::os::raw::c_uint;
pub type VkAccessFlags = VkFlags;
pub const VK_IMAGE_ASPECT_COLOR_BIT: VkImageAspectFlagBits = 1;
pub const VK_IMAGE_ASPECT_DEPTH_BIT: VkImageAspectFlagBits = 2;
pub const VK_IMAGE_ASPECT_STENCIL_BIT: VkImageAspectFlagBits = 4;
pub const VK_IMAGE_ASPECT_METADATA_BIT: VkImageAspectFlagBits = 8;
pub const VK_IMAGE_ASPECT_PLANE_0_BIT: VkImageAspectFlagBits = 16;
pub const VK_IMAGE_ASPECT_PLANE_1_BIT: VkImageAspectFlagBits = 32;
pub const VK_IMAGE_ASPECT_PLANE_2_BIT: VkImageAspectFlagBits = 64;
pub const VK_IMAGE_ASPECT_NONE: VkImageAspectFlagBits = 0;
pub const VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT: VkImageAspectFlagBits = 128;
pub const VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT: VkImageAspectFlagBits = 256;
pub const VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT: VkImageAspectFlagBits = 512;
pub const VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT: VkImageAspectFlagBits =
    1024;
pub const VK_IMAGE_ASPECT_PLANE_0_BIT_KHR: VkImageAspectFlagBits = 16;
pub const VK_IMAGE_ASPECT_PLANE_1_BIT_KHR: VkImageAspectFlagBits = 32;
pub const VK_IMAGE_ASPECT_PLANE_2_BIT_KHR: VkImageAspectFlagBits = 64;
pub const VK_IMAGE_ASPECT_NONE_KHR: VkImageAspectFlagBits = 0;
pub const VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM: VkImageAspectFlagBits =
    2147483647;
pub type VkImageAspectFlagBits = ::std::os::raw::c_uint;
pub type VkImageAspectFlags = VkFlags;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT: VkFormatFeatureFlagBits = 1;
pub const VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT: VkFormatFeatureFlagBits = 2;
pub const VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT:
    VkFormatFeatureFlagBits = 4;
pub const VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT:
    VkFormatFeatureFlagBits = 8;
pub const VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT:
    VkFormatFeatureFlagBits = 16;
pub const VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT:
    VkFormatFeatureFlagBits = 32;
pub const VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT: VkFormatFeatureFlagBits = 64;
pub const VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT: VkFormatFeatureFlagBits =
    128;
pub const VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT:
    VkFormatFeatureFlagBits = 256;
pub const VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT:
    VkFormatFeatureFlagBits = 512;
pub const VK_FORMAT_FEATURE_BLIT_SRC_BIT: VkFormatFeatureFlagBits = 1024;
pub const VK_FORMAT_FEATURE_BLIT_DST_BIT: VkFormatFeatureFlagBits = 2048;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT:
    VkFormatFeatureFlagBits = 4096;
pub const VK_FORMAT_FEATURE_TRANSFER_SRC_BIT: VkFormatFeatureFlagBits =
    16384;
pub const VK_FORMAT_FEATURE_TRANSFER_DST_BIT: VkFormatFeatureFlagBits =
    32768;
pub const VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT:
    VkFormatFeatureFlagBits = 131072;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT : VkFormatFeatureFlagBits = 262144 ;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT : VkFormatFeatureFlagBits = 524288 ;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT : VkFormatFeatureFlagBits = 1048576 ;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT : VkFormatFeatureFlagBits = 2097152 ;
pub const VK_FORMAT_FEATURE_DISJOINT_BIT: VkFormatFeatureFlagBits = 4194304;
pub const VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT:
    VkFormatFeatureFlagBits = 8388608;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT:
    VkFormatFeatureFlagBits = 65536;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG:
    VkFormatFeatureFlagBits = 8192;
pub const VK_FORMAT_FEATURE_VIDEO_DECODE_OUTPUT_BIT_KHR:
    VkFormatFeatureFlagBits = 33554432;
pub const VK_FORMAT_FEATURE_VIDEO_DECODE_DPB_BIT_KHR:
    VkFormatFeatureFlagBits = 67108864;
pub const VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR:
    VkFormatFeatureFlagBits = 536870912;
pub const VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT:
    VkFormatFeatureFlagBits = 16777216;
pub const VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkFormatFeatureFlagBits = 1073741824;
pub const VK_FORMAT_FEATURE_VIDEO_ENCODE_INPUT_BIT_KHR:
    VkFormatFeatureFlagBits = 134217728;
pub const VK_FORMAT_FEATURE_VIDEO_ENCODE_DPB_BIT_KHR:
    VkFormatFeatureFlagBits = 268435456;
pub const VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR: VkFormatFeatureFlagBits =
    16384;
pub const VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR: VkFormatFeatureFlagBits =
    32768;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT:
    VkFormatFeatureFlagBits = 65536;
pub const VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR:
    VkFormatFeatureFlagBits = 131072;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR : VkFormatFeatureFlagBits = 262144 ;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR : VkFormatFeatureFlagBits = 524288 ;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR : VkFormatFeatureFlagBits = 1048576 ;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR : VkFormatFeatureFlagBits = 2097152 ;
pub const VK_FORMAT_FEATURE_DISJOINT_BIT_KHR: VkFormatFeatureFlagBits =
    4194304;
pub const VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR:
    VkFormatFeatureFlagBits = 8388608;
pub const VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT:
    VkFormatFeatureFlagBits = 8192;
pub const VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM: VkFormatFeatureFlagBits =
    2147483647;
pub type VkFormatFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkFormatFeatureFlags = VkFlags;
pub const VK_IMAGE_CREATE_SPARSE_BINDING_BIT: VkImageCreateFlagBits = 1;
pub const VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT: VkImageCreateFlagBits = 2;
pub const VK_IMAGE_CREATE_SPARSE_ALIASED_BIT: VkImageCreateFlagBits = 4;
pub const VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT: VkImageCreateFlagBits = 8;
pub const VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT: VkImageCreateFlagBits = 16;
pub const VK_IMAGE_CREATE_ALIAS_BIT: VkImageCreateFlagBits = 1024;
pub const VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT:
    VkImageCreateFlagBits = 64;
pub const VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT: VkImageCreateFlagBits = 32;
pub const VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT:
    VkImageCreateFlagBits = 128;
pub const VK_IMAGE_CREATE_EXTENDED_USAGE_BIT: VkImageCreateFlagBits = 256;
pub const VK_IMAGE_CREATE_PROTECTED_BIT: VkImageCreateFlagBits = 2048;
pub const VK_IMAGE_CREATE_DISJOINT_BIT: VkImageCreateFlagBits = 512;
pub const VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV: VkImageCreateFlagBits = 8192;
pub const VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT:
    VkImageCreateFlagBits = 4096;
pub const VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT: VkImageCreateFlagBits = 16384;
pub const VK_IMAGE_CREATE_2D_VIEW_COMPATIBLE_BIT_EXT: VkImageCreateFlagBits =
    131072;
pub const VK_IMAGE_CREATE_FRAGMENT_DENSITY_MAP_OFFSET_BIT_QCOM:
    VkImageCreateFlagBits = 32768;
pub const VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR:
    VkImageCreateFlagBits = 64;
pub const VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR: VkImageCreateFlagBits =
    32;
pub const VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR:
    VkImageCreateFlagBits = 128;
pub const VK_IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR: VkImageCreateFlagBits = 256;
pub const VK_IMAGE_CREATE_DISJOINT_BIT_KHR: VkImageCreateFlagBits = 512;
pub const VK_IMAGE_CREATE_ALIAS_BIT_KHR: VkImageCreateFlagBits = 1024;
pub const VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM: VkImageCreateFlagBits =
    2147483647;
pub type VkImageCreateFlagBits = ::std::os::raw::c_uint;
pub type VkImageCreateFlags = VkFlags;
pub const VK_SAMPLE_COUNT_1_BIT: VkSampleCountFlagBits = 1;
pub const VK_SAMPLE_COUNT_2_BIT: VkSampleCountFlagBits = 2;
pub const VK_SAMPLE_COUNT_4_BIT: VkSampleCountFlagBits = 4;
pub const VK_SAMPLE_COUNT_8_BIT: VkSampleCountFlagBits = 8;
pub const VK_SAMPLE_COUNT_16_BIT: VkSampleCountFlagBits = 16;
pub const VK_SAMPLE_COUNT_32_BIT: VkSampleCountFlagBits = 32;
pub const VK_SAMPLE_COUNT_64_BIT: VkSampleCountFlagBits = 64;
pub const VK_SAMPLE_COUNT_FLAG_BITS_MAX_ENUM: VkSampleCountFlagBits =
    2147483647;
pub type VkSampleCountFlagBits = ::std::os::raw::c_uint;
pub type VkSampleCountFlags = VkFlags;
pub const VK_IMAGE_USAGE_TRANSFER_SRC_BIT: VkImageUsageFlagBits = 1;
pub const VK_IMAGE_USAGE_TRANSFER_DST_BIT: VkImageUsageFlagBits = 2;
pub const VK_IMAGE_USAGE_SAMPLED_BIT: VkImageUsageFlagBits = 4;
pub const VK_IMAGE_USAGE_STORAGE_BIT: VkImageUsageFlagBits = 8;
pub const VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT: VkImageUsageFlagBits = 16;
pub const VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT: VkImageUsageFlagBits =
    32;
pub const VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT: VkImageUsageFlagBits = 64;
pub const VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT: VkImageUsageFlagBits = 128;
pub const VK_IMAGE_USAGE_VIDEO_DECODE_DST_BIT_KHR: VkImageUsageFlagBits = 1024;
pub const VK_IMAGE_USAGE_VIDEO_DECODE_SRC_BIT_KHR: VkImageUsageFlagBits = 2048;
pub const VK_IMAGE_USAGE_VIDEO_DECODE_DPB_BIT_KHR: VkImageUsageFlagBits = 4096;
pub const VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT: VkImageUsageFlagBits =
    512;
pub const VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkImageUsageFlagBits = 256;
pub const VK_IMAGE_USAGE_VIDEO_ENCODE_DST_BIT_KHR: VkImageUsageFlagBits = 8192;
pub const VK_IMAGE_USAGE_VIDEO_ENCODE_SRC_BIT_KHR: VkImageUsageFlagBits =
    16384;
pub const VK_IMAGE_USAGE_VIDEO_ENCODE_DPB_BIT_KHR: VkImageUsageFlagBits =
    32768;
pub const VK_IMAGE_USAGE_INVOCATION_MASK_BIT_HUAWEI: VkImageUsageFlagBits =
    262144;
pub const VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV: VkImageUsageFlagBits = 256;
pub const VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM: VkImageUsageFlagBits = 2147483647;
pub type VkImageUsageFlagBits = ::std::os::raw::c_uint;
pub type VkImageUsageFlags = VkFlags;
pub const VK_INSTANCE_CREATE_ENUMERATE_PORTABILITY_BIT_KHR:
    VkInstanceCreateFlagBits = 1;
pub const VK_INSTANCE_CREATE_FLAG_BITS_MAX_ENUM: VkInstanceCreateFlagBits =
    2147483647;
pub type VkInstanceCreateFlagBits = ::std::os::raw::c_uint;
pub type VkInstanceCreateFlags = VkFlags;
pub const VK_MEMORY_HEAP_DEVICE_LOCAL_BIT: VkMemoryHeapFlagBits = 1;
pub const VK_MEMORY_HEAP_MULTI_INSTANCE_BIT: VkMemoryHeapFlagBits = 2;
pub const VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR: VkMemoryHeapFlagBits = 2;
pub const VK_MEMORY_HEAP_FLAG_BITS_MAX_ENUM: VkMemoryHeapFlagBits = 2147483647;
pub type VkMemoryHeapFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryHeapFlags = VkFlags;
pub const VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT: VkMemoryPropertyFlagBits =
    1;
pub const VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT: VkMemoryPropertyFlagBits =
    2;
pub const VK_MEMORY_PROPERTY_HOST_COHERENT_BIT: VkMemoryPropertyFlagBits =
    4;
pub const VK_MEMORY_PROPERTY_HOST_CACHED_BIT: VkMemoryPropertyFlagBits = 8;
pub const VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT:
    VkMemoryPropertyFlagBits = 16;
pub const VK_MEMORY_PROPERTY_PROTECTED_BIT: VkMemoryPropertyFlagBits = 32;
pub const VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD:
    VkMemoryPropertyFlagBits = 64;
pub const VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD:
    VkMemoryPropertyFlagBits = 128;
pub const VK_MEMORY_PROPERTY_RDMA_CAPABLE_BIT_NV:
    VkMemoryPropertyFlagBits = 256;
pub const VK_MEMORY_PROPERTY_FLAG_BITS_MAX_ENUM: VkMemoryPropertyFlagBits =
    2147483647;
pub type VkMemoryPropertyFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryPropertyFlags = VkFlags;
pub const VK_QUEUE_GRAPHICS_BIT: VkQueueFlagBits = 1;
pub const VK_QUEUE_COMPUTE_BIT: VkQueueFlagBits = 2;
pub const VK_QUEUE_TRANSFER_BIT: VkQueueFlagBits = 4;
pub const VK_QUEUE_SPARSE_BINDING_BIT: VkQueueFlagBits = 8;
pub const VK_QUEUE_PROTECTED_BIT: VkQueueFlagBits = 16;
pub const VK_QUEUE_VIDEO_DECODE_BIT_KHR: VkQueueFlagBits = 32;
pub const VK_QUEUE_VIDEO_ENCODE_BIT_KHR: VkQueueFlagBits = 64;
pub const VK_QUEUE_FLAG_BITS_MAX_ENUM: VkQueueFlagBits = 2147483647;
pub type VkQueueFlagBits = ::std::os::raw::c_uint;
pub type VkQueueFlags = VkFlags;
pub type VkDeviceCreateFlags = VkFlags;
pub const VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT:
    VkDeviceQueueCreateFlagBits = 1;
pub const VK_DEVICE_QUEUE_CREATE_FLAG_BITS_MAX_ENUM:
    VkDeviceQueueCreateFlagBits = 2147483647;
pub type VkDeviceQueueCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDeviceQueueCreateFlags = VkFlags;
pub const VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT: VkPipelineStageFlagBits = 1;
pub const VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT: VkPipelineStageFlagBits = 2;
pub const VK_PIPELINE_STAGE_VERTEX_INPUT_BIT: VkPipelineStageFlagBits = 4;
pub const VK_PIPELINE_STAGE_VERTEX_SHADER_BIT: VkPipelineStageFlagBits = 8;
pub const VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT:
    VkPipelineStageFlagBits = 16;
pub const VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT:
    VkPipelineStageFlagBits = 32;
pub const VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT: VkPipelineStageFlagBits =
    64;
pub const VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT: VkPipelineStageFlagBits =
    128;
pub const VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT:
    VkPipelineStageFlagBits = 256;
pub const VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT:
    VkPipelineStageFlagBits = 512;
pub const VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT:
    VkPipelineStageFlagBits = 1024;
pub const VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT: VkPipelineStageFlagBits =
    2048;
pub const VK_PIPELINE_STAGE_TRANSFER_BIT: VkPipelineStageFlagBits = 4096;
pub const VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT: VkPipelineStageFlagBits =
    8192;
pub const VK_PIPELINE_STAGE_HOST_BIT: VkPipelineStageFlagBits = 16384;
pub const VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT: VkPipelineStageFlagBits =
    32768;
pub const VK_PIPELINE_STAGE_ALL_COMMANDS_BIT: VkPipelineStageFlagBits =
    65536;
pub const VK_PIPELINE_STAGE_NONE: VkPipelineStageFlagBits = 0;
pub const VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT:
    VkPipelineStageFlagBits = 16777216;
pub const VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT:
    VkPipelineStageFlagBits = 262144;
pub const VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR:
    VkPipelineStageFlagBits = 33554432;
pub const VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR:
    VkPipelineStageFlagBits = 2097152;
pub const VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV: VkPipelineStageFlagBits =
    524288;
pub const VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV: VkPipelineStageFlagBits =
    1048576;
pub const VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT:
    VkPipelineStageFlagBits = 8388608;
pub const VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkPipelineStageFlagBits = 4194304;
pub const VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV:
    VkPipelineStageFlagBits = 131072;
pub const VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV:
    VkPipelineStageFlagBits = 4194304;
pub const VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_NV:
    VkPipelineStageFlagBits = 2097152;
pub const VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_NV:
    VkPipelineStageFlagBits = 33554432;
pub const VK_PIPELINE_STAGE_NONE_KHR: VkPipelineStageFlagBits = 0;
pub const VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM: VkPipelineStageFlagBits =
    2147483647;
pub type VkPipelineStageFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineStageFlags = VkFlags;
pub type VkMemoryMapFlags = VkFlags;
pub const VK_SPARSE_MEMORY_BIND_METADATA_BIT:
    VkSparseMemoryBindFlagBits = 1;
pub const VK_SPARSE_MEMORY_BIND_FLAG_BITS_MAX_ENUM:
    VkSparseMemoryBindFlagBits = 2147483647;
pub type VkSparseMemoryBindFlagBits = ::std::os::raw::c_uint;
pub type VkSparseMemoryBindFlags = VkFlags;
pub const VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT:
    VkSparseImageFormatFlagBits = 1;
pub const VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT:
    VkSparseImageFormatFlagBits = 2;
pub const VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT:
    VkSparseImageFormatFlagBits = 4;
pub const VK_SPARSE_IMAGE_FORMAT_FLAG_BITS_MAX_ENUM:
    VkSparseImageFormatFlagBits = 2147483647;
pub type VkSparseImageFormatFlagBits = ::std::os::raw::c_uint;
pub type VkSparseImageFormatFlags = VkFlags;
pub const VK_FENCE_CREATE_SIGNALED_BIT: VkFenceCreateFlagBits = 1;
pub const VK_FENCE_CREATE_FLAG_BITS_MAX_ENUM: VkFenceCreateFlagBits =
    2147483647;
pub type VkFenceCreateFlagBits = ::std::os::raw::c_uint;
pub type VkFenceCreateFlags = VkFlags;
pub type VkSemaphoreCreateFlags = VkFlags;
pub const VK_EVENT_CREATE_DEVICE_ONLY_BIT: VkEventCreateFlagBits = 1;
pub const VK_EVENT_CREATE_DEVICE_ONLY_BIT_KHR: VkEventCreateFlagBits = 1;
pub const VK_EVENT_CREATE_FLAG_BITS_MAX_ENUM: VkEventCreateFlagBits =
    2147483647;
pub type VkEventCreateFlagBits = ::std::os::raw::c_uint;
pub type VkEventCreateFlags = VkFlags;
pub const VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT : VkQueryPipelineStatisticFlagBits = 1 ;
pub const VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT : VkQueryPipelineStatisticFlagBits = 2 ;
pub const VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 4 ;
pub const VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 8 ;
pub const VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT : VkQueryPipelineStatisticFlagBits = 16 ;
pub const VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT:
    VkQueryPipelineStatisticFlagBits = 32;
pub const VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT:
    VkQueryPipelineStatisticFlagBits = 64;
pub const VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 128 ;
pub const VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT : VkQueryPipelineStatisticFlagBits = 256 ;
pub const VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 512 ;
pub const VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 1024 ;
pub const VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM:
    VkQueryPipelineStatisticFlagBits = 2147483647;
pub type VkQueryPipelineStatisticFlagBits = ::std::os::raw::c_uint;
pub type VkQueryPipelineStatisticFlags = VkFlags;
pub type VkQueryPoolCreateFlags = VkFlags;
pub const VK_QUERY_RESULT_64_BIT: VkQueryResultFlagBits = 1;
pub const VK_QUERY_RESULT_WAIT_BIT: VkQueryResultFlagBits = 2;
pub const VK_QUERY_RESULT_WITH_AVAILABILITY_BIT: VkQueryResultFlagBits = 4;
pub const VK_QUERY_RESULT_PARTIAL_BIT: VkQueryResultFlagBits = 8;
pub const VK_QUERY_RESULT_WITH_STATUS_BIT_KHR: VkQueryResultFlagBits = 16;
pub const VK_QUERY_RESULT_FLAG_BITS_MAX_ENUM: VkQueryResultFlagBits =
    2147483647;
pub type VkQueryResultFlagBits = ::std::os::raw::c_uint;
pub type VkQueryResultFlags = VkFlags;
pub const VK_BUFFER_CREATE_SPARSE_BINDING_BIT: VkBufferCreateFlagBits = 1;
pub const VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT: VkBufferCreateFlagBits = 2;
pub const VK_BUFFER_CREATE_SPARSE_ALIASED_BIT: VkBufferCreateFlagBits = 4;
pub const VK_BUFFER_CREATE_PROTECTED_BIT: VkBufferCreateFlagBits = 8;
pub const VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT:
    VkBufferCreateFlagBits = 16;
pub const VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT:
    VkBufferCreateFlagBits = 16;
pub const VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR:
    VkBufferCreateFlagBits = 16;
pub const VK_BUFFER_CREATE_FLAG_BITS_MAX_ENUM: VkBufferCreateFlagBits =
    2147483647;
pub type VkBufferCreateFlagBits = ::std::os::raw::c_uint;
pub type VkBufferCreateFlags = VkFlags;
pub const VK_BUFFER_USAGE_TRANSFER_SRC_BIT: VkBufferUsageFlagBits = 1;
pub const VK_BUFFER_USAGE_TRANSFER_DST_BIT: VkBufferUsageFlagBits = 2;
pub const VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT: VkBufferUsageFlagBits = 4;
pub const VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT: VkBufferUsageFlagBits = 8;
pub const VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT: VkBufferUsageFlagBits = 16;
pub const VK_BUFFER_USAGE_STORAGE_BUFFER_BIT: VkBufferUsageFlagBits = 32;
pub const VK_BUFFER_USAGE_INDEX_BUFFER_BIT: VkBufferUsageFlagBits = 64;
pub const VK_BUFFER_USAGE_VERTEX_BUFFER_BIT: VkBufferUsageFlagBits = 128;
pub const VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT: VkBufferUsageFlagBits = 256;
pub const VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT: VkBufferUsageFlagBits =
    131072;
pub const VK_BUFFER_USAGE_VIDEO_DECODE_SRC_BIT_KHR: VkBufferUsageFlagBits =
    8192;
pub const VK_BUFFER_USAGE_VIDEO_DECODE_DST_BIT_KHR: VkBufferUsageFlagBits =
    16384;
pub const VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT:
    VkBufferUsageFlagBits = 2048;
pub const VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT:
    VkBufferUsageFlagBits = 4096;
pub const VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT:
    VkBufferUsageFlagBits = 512;
pub const VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR : VkBufferUsageFlagBits = 524288 ;
pub const VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR:
    VkBufferUsageFlagBits = 1048576;
pub const VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR:
    VkBufferUsageFlagBits = 1024;
pub const VK_BUFFER_USAGE_VIDEO_ENCODE_DST_BIT_KHR: VkBufferUsageFlagBits =
    32768;
pub const VK_BUFFER_USAGE_VIDEO_ENCODE_SRC_BIT_KHR: VkBufferUsageFlagBits =
    65536;
pub const VK_BUFFER_USAGE_RAY_TRACING_BIT_NV: VkBufferUsageFlagBits = 1024;
pub const VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_EXT:
    VkBufferUsageFlagBits = 131072;
pub const VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_KHR:
    VkBufferUsageFlagBits = 131072;
pub const VK_BUFFER_USAGE_FLAG_BITS_MAX_ENUM: VkBufferUsageFlagBits =
    2147483647;
pub type VkBufferUsageFlagBits = ::std::os::raw::c_uint;
pub type VkBufferUsageFlags = VkFlags;
pub type VkBufferViewCreateFlags = VkFlags;
pub const VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT:
    VkImageViewCreateFlagBits = 1;
pub const VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT:
    VkImageViewCreateFlagBits = 2;
pub const VK_IMAGE_VIEW_CREATE_FLAG_BITS_MAX_ENUM:
    VkImageViewCreateFlagBits = 2147483647;
pub type VkImageViewCreateFlagBits = ::std::os::raw::c_uint;
pub type VkImageViewCreateFlags = VkFlags;
pub type VkShaderModuleCreateFlags = VkFlags;
pub const VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT:
    VkPipelineCacheCreateFlagBits = 1;
pub const VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT_EXT:
    VkPipelineCacheCreateFlagBits = 1;
pub const VK_PIPELINE_CACHE_CREATE_FLAG_BITS_MAX_ENUM:
    VkPipelineCacheCreateFlagBits = 2147483647;
pub type VkPipelineCacheCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineCacheCreateFlags = VkFlags;
pub const VK_COLOR_COMPONENT_R_BIT: VkColorComponentFlagBits = 1;
pub const VK_COLOR_COMPONENT_G_BIT: VkColorComponentFlagBits = 2;
pub const VK_COLOR_COMPONENT_B_BIT: VkColorComponentFlagBits = 4;
pub const VK_COLOR_COMPONENT_A_BIT: VkColorComponentFlagBits = 8;
pub const VK_COLOR_COMPONENT_FLAG_BITS_MAX_ENUM: VkColorComponentFlagBits =
    2147483647;
pub type VkColorComponentFlagBits = ::std::os::raw::c_uint;
pub type VkColorComponentFlags = VkFlags;
pub const VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT:
    VkPipelineCreateFlagBits = 1;
pub const VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT:
    VkPipelineCreateFlagBits = 2;
pub const VK_PIPELINE_CREATE_DERIVATIVE_BIT: VkPipelineCreateFlagBits = 4;
pub const VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT:
    VkPipelineCreateFlagBits = 8;
pub const VK_PIPELINE_CREATE_DISPATCH_BASE_BIT: VkPipelineCreateFlagBits =
    16;
pub const VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT:
    VkPipelineCreateFlagBits = 256;
pub const VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT:
    VkPipelineCreateFlagBits = 512;
pub const VK_PIPELINE_CREATE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR : VkPipelineCreateFlagBits = 2097152 ;
pub const VK_PIPELINE_CREATE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT : VkPipelineCreateFlagBits = 4194304 ;
pub const VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 16384 ;
pub const VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 32768 ;
pub const VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR:
    VkPipelineCreateFlagBits = 65536;
pub const VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 131072 ;
pub const VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR:
    VkPipelineCreateFlagBits = 4096;
pub const VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR:
    VkPipelineCreateFlagBits = 8192;
pub const VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR : VkPipelineCreateFlagBits = 524288 ;
pub const VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV:
    VkPipelineCreateFlagBits = 32;
pub const VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR:
    VkPipelineCreateFlagBits = 64;
pub const VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR:
    VkPipelineCreateFlagBits = 128;
pub const VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV:
    VkPipelineCreateFlagBits = 262144;
pub const VK_PIPELINE_CREATE_LIBRARY_BIT_KHR: VkPipelineCreateFlagBits =
    2048;
pub const VK_PIPELINE_CREATE_RETAIN_LINK_TIME_OPTIMIZATION_INFO_BIT_EXT:
    VkPipelineCreateFlagBits = 8388608;
pub const VK_PIPELINE_CREATE_LINK_TIME_OPTIMIZATION_BIT_EXT:
    VkPipelineCreateFlagBits = 1024;
pub const VK_PIPELINE_CREATE_RAY_TRACING_ALLOW_MOTION_BIT_NV:
    VkPipelineCreateFlagBits = 1048576;
pub const VK_PIPELINE_CREATE_DISPATCH_BASE: VkPipelineCreateFlagBits = 16;
pub const VK_PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR : VkPipelineCreateFlagBits = 2097152 ;
pub const VK_PIPELINE_RASTERIZATION_STATE_CREATE_FRAGMENT_DENSITY_MAP_ATTACHMENT_BIT_EXT : VkPipelineCreateFlagBits = 4194304 ;
pub const VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR:
    VkPipelineCreateFlagBits = 8;
pub const VK_PIPELINE_CREATE_DISPATCH_BASE_KHR: VkPipelineCreateFlagBits =
    16;
pub const VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT:
    VkPipelineCreateFlagBits = 256;
pub const VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT:
    VkPipelineCreateFlagBits = 512;
pub const VK_PIPELINE_CREATE_FLAG_BITS_MAX_ENUM: VkPipelineCreateFlagBits =
    2147483647;
pub type VkPipelineCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineCreateFlags = VkFlags;
pub const VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT : VkPipelineShaderStageCreateFlagBits = 1 ;
pub const VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT : VkPipelineShaderStageCreateFlagBits = 2 ;
pub const VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT : VkPipelineShaderStageCreateFlagBits = 1 ;
pub const VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT : VkPipelineShaderStageCreateFlagBits = 2 ;
pub const VK_PIPELINE_SHADER_STAGE_CREATE_FLAG_BITS_MAX_ENUM:
    VkPipelineShaderStageCreateFlagBits = 2147483647;
pub type VkPipelineShaderStageCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineShaderStageCreateFlags = VkFlags;
pub const VK_SHADER_STAGE_VERTEX_BIT: VkShaderStageFlagBits = 1;
pub const VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT: VkShaderStageFlagBits = 2;
pub const VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT: VkShaderStageFlagBits =
    4;
pub const VK_SHADER_STAGE_GEOMETRY_BIT: VkShaderStageFlagBits = 8;
pub const VK_SHADER_STAGE_FRAGMENT_BIT: VkShaderStageFlagBits = 16;
pub const VK_SHADER_STAGE_COMPUTE_BIT: VkShaderStageFlagBits = 32;
pub const VK_SHADER_STAGE_ALL_GRAPHICS: VkShaderStageFlagBits = 31;
pub const VK_SHADER_STAGE_ALL: VkShaderStageFlagBits = 2147483647;
pub const VK_SHADER_STAGE_RAYGEN_BIT_KHR: VkShaderStageFlagBits = 256;
pub const VK_SHADER_STAGE_ANY_HIT_BIT_KHR: VkShaderStageFlagBits = 512;
pub const VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR: VkShaderStageFlagBits = 1024;
pub const VK_SHADER_STAGE_MISS_BIT_KHR: VkShaderStageFlagBits = 2048;
pub const VK_SHADER_STAGE_INTERSECTION_BIT_KHR: VkShaderStageFlagBits = 4096;
pub const VK_SHADER_STAGE_CALLABLE_BIT_KHR: VkShaderStageFlagBits = 8192;
pub const VK_SHADER_STAGE_TASK_BIT_NV: VkShaderStageFlagBits = 64;
pub const VK_SHADER_STAGE_MESH_BIT_NV: VkShaderStageFlagBits = 128;
pub const VK_SHADER_STAGE_SUBPASS_SHADING_BIT_HUAWEI: VkShaderStageFlagBits =
    16384;
pub const VK_SHADER_STAGE_RAYGEN_BIT_NV: VkShaderStageFlagBits = 256;
pub const VK_SHADER_STAGE_ANY_HIT_BIT_NV: VkShaderStageFlagBits = 512;
pub const VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV: VkShaderStageFlagBits = 1024;
pub const VK_SHADER_STAGE_MISS_BIT_NV: VkShaderStageFlagBits = 2048;
pub const VK_SHADER_STAGE_INTERSECTION_BIT_NV: VkShaderStageFlagBits = 4096;
pub const VK_SHADER_STAGE_CALLABLE_BIT_NV: VkShaderStageFlagBits = 8192;
pub const VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM: VkShaderStageFlagBits =
    2147483647;
pub type VkShaderStageFlagBits = ::std::os::raw::c_uint;
pub const VK_CULL_MODE_NONE: VkCullModeFlagBits = 0;
pub const VK_CULL_MODE_FRONT_BIT: VkCullModeFlagBits = 1;
pub const VK_CULL_MODE_BACK_BIT: VkCullModeFlagBits = 2;
pub const VK_CULL_MODE_FRONT_AND_BACK: VkCullModeFlagBits = 3;
pub const VK_CULL_MODE_FLAG_BITS_MAX_ENUM: VkCullModeFlagBits = 2147483647;
pub type VkCullModeFlagBits = ::std::os::raw::c_uint;
pub type VkCullModeFlags = VkFlags;
pub type VkPipelineVertexInputStateCreateFlags = VkFlags;
pub type VkPipelineInputAssemblyStateCreateFlags = VkFlags;
pub type VkPipelineTessellationStateCreateFlags = VkFlags;
pub type VkPipelineViewportStateCreateFlags = VkFlags;
pub type VkPipelineRasterizationStateCreateFlags = VkFlags;
pub type VkPipelineMultisampleStateCreateFlags = VkFlags;
pub const VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_ARM : VkPipelineDepthStencilStateCreateFlagBits = 1 ;
pub const VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_ARM : VkPipelineDepthStencilStateCreateFlagBits = 2 ;
pub const VK_PIPELINE_DEPTH_STENCIL_STATE_CREATE_FLAG_BITS_MAX_ENUM : VkPipelineDepthStencilStateCreateFlagBits = 2147483647 ;
pub type VkPipelineDepthStencilStateCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineDepthStencilStateCreateFlags = VkFlags;
pub const VK_PIPELINE_COLOR_BLEND_STATE_CREATE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_BIT_ARM : VkPipelineColorBlendStateCreateFlagBits = 1 ;
pub const VK_PIPELINE_COLOR_BLEND_STATE_CREATE_FLAG_BITS_MAX_ENUM : VkPipelineColorBlendStateCreateFlagBits = 2147483647 ;
pub type VkPipelineColorBlendStateCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineColorBlendStateCreateFlags = VkFlags;
pub type VkPipelineDynamicStateCreateFlags = VkFlags;
pub const VK_PIPELINE_LAYOUT_CREATE_INDEPENDENT_SETS_BIT_EXT:
    VkPipelineLayoutCreateFlagBits = 2;
pub const VK_PIPELINE_LAYOUT_CREATE_FLAG_BITS_MAX_ENUM:
    VkPipelineLayoutCreateFlagBits = 2147483647;
pub type VkPipelineLayoutCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineLayoutCreateFlags = VkFlags;
pub type VkShaderStageFlags = VkFlags;
pub const VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT: VkSamplerCreateFlagBits = 1;
pub const VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT:
    VkSamplerCreateFlagBits = 2;
pub const VK_SAMPLER_CREATE_FLAG_BITS_MAX_ENUM: VkSamplerCreateFlagBits =
    2147483647;
pub type VkSamplerCreateFlagBits = ::std::os::raw::c_uint;
pub type VkSamplerCreateFlags = VkFlags;
pub const VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT:
    VkDescriptorPoolCreateFlagBits = 1;
pub const VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT:
    VkDescriptorPoolCreateFlagBits = 2;
pub const VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE:
    VkDescriptorPoolCreateFlagBits = 4;
pub const VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT_EXT:
    VkDescriptorPoolCreateFlagBits = 2;
pub const VK_DESCRIPTOR_POOL_CREATE_FLAG_BITS_MAX_ENUM:
    VkDescriptorPoolCreateFlagBits = 2147483647;
pub type VkDescriptorPoolCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorPoolCreateFlags = VkFlags;
pub type VkDescriptorPoolResetFlags = VkFlags;
pub const VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT : VkDescriptorSetLayoutCreateFlagBits = 2 ;
pub const VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR : VkDescriptorSetLayoutCreateFlagBits = 1 ;
pub const VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE : VkDescriptorSetLayoutCreateFlagBits = 4 ;
pub const VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT_EXT : VkDescriptorSetLayoutCreateFlagBits = 2 ;
pub const VK_DESCRIPTOR_SET_LAYOUT_CREATE_FLAG_BITS_MAX_ENUM:
    VkDescriptorSetLayoutCreateFlagBits = 2147483647;
pub type VkDescriptorSetLayoutCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorSetLayoutCreateFlags = VkFlags;
pub const VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT:
    VkAttachmentDescriptionFlagBits = 1;
pub const VK_ATTACHMENT_DESCRIPTION_FLAG_BITS_MAX_ENUM:
    VkAttachmentDescriptionFlagBits = 2147483647;
pub type VkAttachmentDescriptionFlagBits = ::std::os::raw::c_uint;
pub type VkAttachmentDescriptionFlags = VkFlags;
pub const VK_DEPENDENCY_BY_REGION_BIT: VkDependencyFlagBits = 1;
pub const VK_DEPENDENCY_DEVICE_GROUP_BIT: VkDependencyFlagBits = 4;
pub const VK_DEPENDENCY_VIEW_LOCAL_BIT: VkDependencyFlagBits = 2;
pub const VK_DEPENDENCY_VIEW_LOCAL_BIT_KHR: VkDependencyFlagBits = 2;
pub const VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR: VkDependencyFlagBits = 4;
pub const VK_DEPENDENCY_FLAG_BITS_MAX_ENUM: VkDependencyFlagBits = 2147483647;
pub type VkDependencyFlagBits = ::std::os::raw::c_uint;
pub type VkDependencyFlags = VkFlags;
pub const VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT:
    VkFramebufferCreateFlagBits = 1;
pub const VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT_KHR:
    VkFramebufferCreateFlagBits = 1;
pub const VK_FRAMEBUFFER_CREATE_FLAG_BITS_MAX_ENUM:
    VkFramebufferCreateFlagBits = 2147483647;
pub type VkFramebufferCreateFlagBits = ::std::os::raw::c_uint;
pub type VkFramebufferCreateFlags = VkFlags;
pub const VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM:
    VkRenderPassCreateFlagBits = 2;
pub const VK_RENDER_PASS_CREATE_FLAG_BITS_MAX_ENUM:
    VkRenderPassCreateFlagBits = 2147483647;
pub type VkRenderPassCreateFlagBits = ::std::os::raw::c_uint;
pub type VkRenderPassCreateFlags = VkFlags;
pub const VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX:
    VkSubpassDescriptionFlagBits = 1;
pub const VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX:
    VkSubpassDescriptionFlagBits = 2;
pub const VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM:
    VkSubpassDescriptionFlagBits = 4;
pub const VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM:
    VkSubpassDescriptionFlagBits = 8;
pub const VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_COLOR_ACCESS_BIT_ARM : VkSubpassDescriptionFlagBits = 16 ;
pub const VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_DEPTH_ACCESS_BIT_ARM : VkSubpassDescriptionFlagBits = 32 ;
pub const VK_SUBPASS_DESCRIPTION_RASTERIZATION_ORDER_ATTACHMENT_STENCIL_ACCESS_BIT_ARM : VkSubpassDescriptionFlagBits = 64 ;
pub const VK_SUBPASS_DESCRIPTION_FLAG_BITS_MAX_ENUM:
    VkSubpassDescriptionFlagBits = 2147483647;
pub type VkSubpassDescriptionFlagBits = ::std::os::raw::c_uint;
pub type VkSubpassDescriptionFlags = VkFlags;
pub const VK_COMMAND_POOL_CREATE_TRANSIENT_BIT:
    VkCommandPoolCreateFlagBits = 1;
pub const VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT:
    VkCommandPoolCreateFlagBits = 2;
pub const VK_COMMAND_POOL_CREATE_PROTECTED_BIT:
    VkCommandPoolCreateFlagBits = 4;
pub const VK_COMMAND_POOL_CREATE_FLAG_BITS_MAX_ENUM:
    VkCommandPoolCreateFlagBits = 2147483647;
pub type VkCommandPoolCreateFlagBits = ::std::os::raw::c_uint;
pub type VkCommandPoolCreateFlags = VkFlags;
pub const VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT:
    VkCommandPoolResetFlagBits = 1;
pub const VK_COMMAND_POOL_RESET_FLAG_BITS_MAX_ENUM:
    VkCommandPoolResetFlagBits = 2147483647;
pub type VkCommandPoolResetFlagBits = ::std::os::raw::c_uint;
pub type VkCommandPoolResetFlags = VkFlags;
pub const VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT:
    VkCommandBufferUsageFlagBits = 1;
pub const VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT:
    VkCommandBufferUsageFlagBits = 2;
pub const VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT:
    VkCommandBufferUsageFlagBits = 4;
pub const VK_COMMAND_BUFFER_USAGE_FLAG_BITS_MAX_ENUM:
    VkCommandBufferUsageFlagBits = 2147483647;
pub type VkCommandBufferUsageFlagBits = ::std::os::raw::c_uint;
pub type VkCommandBufferUsageFlags = VkFlags;
pub const VK_QUERY_CONTROL_PRECISE_BIT: VkQueryControlFlagBits = 1;
pub const VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM: VkQueryControlFlagBits =
    2147483647;
pub type VkQueryControlFlagBits = ::std::os::raw::c_uint;
pub type VkQueryControlFlags = VkFlags;
pub const VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT:
    VkCommandBufferResetFlagBits = 1;
pub const VK_COMMAND_BUFFER_RESET_FLAG_BITS_MAX_ENUM:
    VkCommandBufferResetFlagBits = 2147483647;
pub type VkCommandBufferResetFlagBits = ::std::os::raw::c_uint;
pub type VkCommandBufferResetFlags = VkFlags;
pub const VK_STENCIL_FACE_FRONT_BIT: VkStencilFaceFlagBits = 1;
pub const VK_STENCIL_FACE_BACK_BIT: VkStencilFaceFlagBits = 2;
pub const VK_STENCIL_FACE_FRONT_AND_BACK: VkStencilFaceFlagBits = 3;
pub const VK_STENCIL_FRONT_AND_BACK: VkStencilFaceFlagBits = 3;
pub const VK_STENCIL_FACE_FLAG_BITS_MAX_ENUM: VkStencilFaceFlagBits =
    2147483647;
pub type VkStencilFaceFlagBits = ::std::os::raw::c_uint;
pub type VkStencilFaceFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtent2D {
    pub width: u32,
    pub height: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkOffset2D {
    pub x: i32,
    pub y: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkOffset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRect2D {
    pub offset: VkOffset2D,
    pub extent: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBaseInStructure {
    pub sType: VkStructureType,
    pub pNext: *const VkBaseInStructure,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBaseOutStructure {
    pub sType: VkStructureType,
    pub pNext: *mut VkBaseOutStructure,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawIndexedIndirectCommand {
    pub indexCount: u32,
    pub instanceCount: u32,
    pub firstIndex: u32,
    pub vertexOffset: i32,
    pub firstInstance: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawIndirectCommand {
    pub vertexCount: u32,
    pub instanceCount: u32,
    pub firstVertex: u32,
    pub firstInstance: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresourceRange {
    pub aspectMask: VkImageAspectFlags,
    pub baseMipLevel: u32,
    pub levelCount: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub oldLayout: VkImageLayout,
    pub newLayout: VkImageLayout,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub image: VkImage,
    pub subresourceRange: VkImageSubresourceRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCacheHeaderVersionOne {
    pub headerSize: u32,
    pub headerVersion: VkPipelineCacheHeaderVersion,
    pub vendorID: u32,
    pub deviceID: u32,
    pub pipelineCacheUUID: [u8; 16usize],
}
pub type PFN_vkAllocationFunction = 
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        alignment: size_t,
        allocationScope: VkSystemAllocationScope,
    ) -> *mut ::std::os::raw::c_void
;
pub type PFN_vkFreeFunction = 
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        pMemory: *mut ::std::os::raw::c_void,
    )
;
pub type PFN_vkInternalAllocationNotification = 
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        allocationType: VkInternalAllocationType,
        allocationScope: VkSystemAllocationScope,
    )
;
pub type PFN_vkInternalFreeNotification = 
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        allocationType: VkInternalAllocationType,
        allocationScope: VkSystemAllocationScope,
    )
;
pub type PFN_vkReallocationFunction = 
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        pOriginal: *mut ::std::os::raw::c_void,
        size: size_t,
        alignment: size_t,
        allocationScope: VkSystemAllocationScope,
    ) -> *mut ::std::os::raw::c_void
;
pub type PFN_vkVoidFunction = unsafe extern "C" fn();
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAllocationCallbacks {
    pub pUserData: *mut ::std::os::raw::c_void,
    pub pfnAllocation: PFN_vkAllocationFunction,
    pub pfnReallocation: PFN_vkReallocationFunction,
    pub pfnFree: PFN_vkFreeFunction,
    pub pfnInternalAllocation: PFN_vkInternalAllocationNotification,
    pub pfnInternalFree: PFN_vkInternalFreeNotification,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkApplicationInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pApplicationName: *const ::std::os::raw::c_char,
    pub applicationVersion: u32,
    pub pEngineName: *const ::std::os::raw::c_char,
    pub engineVersion: u32,
    pub apiVersion: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFormatProperties {
    pub linearTilingFeatures: VkFormatFeatureFlags,
    pub optimalTilingFeatures: VkFormatFeatureFlags,
    pub bufferFeatures: VkFormatFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatProperties {
    pub maxExtent: VkExtent3D,
    pub maxMipLevels: u32,
    pub maxArrayLayers: u32,
    pub sampleCounts: VkSampleCountFlags,
    pub maxResourceSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInstanceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkInstanceCreateFlags,
    pub pApplicationInfo: *const VkApplicationInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const ::std::os::raw::c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryHeap {
    pub size: VkDeviceSize,
    pub flags: VkMemoryHeapFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryType {
    pub propertyFlags: VkMemoryPropertyFlags,
    pub heapIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFeatures {
    pub robustBufferAccess: VkBool32,
    pub fullDrawIndexUint32: VkBool32,
    pub imageCubeArray: VkBool32,
    pub independentBlend: VkBool32,
    pub geometryShader: VkBool32,
    pub tessellationShader: VkBool32,
    pub sampleRateShading: VkBool32,
    pub dualSrcBlend: VkBool32,
    pub logicOp: VkBool32,
    pub multiDrawIndirect: VkBool32,
    pub drawIndirectFirstInstance: VkBool32,
    pub depthClamp: VkBool32,
    pub depthBiasClamp: VkBool32,
    pub fillModeNonSolid: VkBool32,
    pub depthBounds: VkBool32,
    pub wideLines: VkBool32,
    pub largePoints: VkBool32,
    pub alphaToOne: VkBool32,
    pub multiViewport: VkBool32,
    pub samplerAnisotropy: VkBool32,
    pub textureCompressionETC2: VkBool32,
    pub textureCompressionASTC_LDR: VkBool32,
    pub textureCompressionBC: VkBool32,
    pub occlusionQueryPrecise: VkBool32,
    pub pipelineStatisticsQuery: VkBool32,
    pub vertexPipelineStoresAndAtomics: VkBool32,
    pub fragmentStoresAndAtomics: VkBool32,
    pub shaderTessellationAndGeometryPointSize: VkBool32,
    pub shaderImageGatherExtended: VkBool32,
    pub shaderStorageImageExtendedFormats: VkBool32,
    pub shaderStorageImageMultisample: VkBool32,
    pub shaderStorageImageReadWithoutFormat: VkBool32,
    pub shaderStorageImageWriteWithoutFormat: VkBool32,
    pub shaderUniformBufferArrayDynamicIndexing: VkBool32,
    pub shaderSampledImageArrayDynamicIndexing: VkBool32,
    pub shaderStorageBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageImageArrayDynamicIndexing: VkBool32,
    pub shaderClipDistance: VkBool32,
    pub shaderCullDistance: VkBool32,
    pub shaderFloat64: VkBool32,
    pub shaderInt64: VkBool32,
    pub shaderInt16: VkBool32,
    pub shaderResourceResidency: VkBool32,
    pub shaderResourceMinLod: VkBool32,
    pub sparseBinding: VkBool32,
    pub sparseResidencyBuffer: VkBool32,
    pub sparseResidencyImage2D: VkBool32,
    pub sparseResidencyImage3D: VkBool32,
    pub sparseResidency2Samples: VkBool32,
    pub sparseResidency4Samples: VkBool32,
    pub sparseResidency8Samples: VkBool32,
    pub sparseResidency16Samples: VkBool32,
    pub sparseResidencyAliased: VkBool32,
    pub variableMultisampleRate: VkBool32,
    pub inheritedQueries: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLimits {
    pub maxImageDimension1D: u32,
    pub maxImageDimension2D: u32,
    pub maxImageDimension3D: u32,
    pub maxImageDimensionCube: u32,
    pub maxImageArrayLayers: u32,
    pub maxTexelBufferElements: u32,
    pub maxUniformBufferRange: u32,
    pub maxStorageBufferRange: u32,
    pub maxPushConstantsSize: u32,
    pub maxMemoryAllocationCount: u32,
    pub maxSamplerAllocationCount: u32,
    pub bufferImageGranularity: VkDeviceSize,
    pub sparseAddressSpaceSize: VkDeviceSize,
    pub maxBoundDescriptorSets: u32,
    pub maxPerStageDescriptorSamplers: u32,
    pub maxPerStageDescriptorUniformBuffers: u32,
    pub maxPerStageDescriptorStorageBuffers: u32,
    pub maxPerStageDescriptorSampledImages: u32,
    pub maxPerStageDescriptorStorageImages: u32,
    pub maxPerStageDescriptorInputAttachments: u32,
    pub maxPerStageResources: u32,
    pub maxDescriptorSetSamplers: u32,
    pub maxDescriptorSetUniformBuffers: u32,
    pub maxDescriptorSetUniformBuffersDynamic: u32,
    pub maxDescriptorSetStorageBuffers: u32,
    pub maxDescriptorSetStorageBuffersDynamic: u32,
    pub maxDescriptorSetSampledImages: u32,
    pub maxDescriptorSetStorageImages: u32,
    pub maxDescriptorSetInputAttachments: u32,
    pub maxVertexInputAttributes: u32,
    pub maxVertexInputBindings: u32,
    pub maxVertexInputAttributeOffset: u32,
    pub maxVertexInputBindingStride: u32,
    pub maxVertexOutputComponents: u32,
    pub maxTessellationGenerationLevel: u32,
    pub maxTessellationPatchSize: u32,
    pub maxTessellationControlPerVertexInputComponents: u32,
    pub maxTessellationControlPerVertexOutputComponents: u32,
    pub maxTessellationControlPerPatchOutputComponents: u32,
    pub maxTessellationControlTotalOutputComponents: u32,
    pub maxTessellationEvaluationInputComponents: u32,
    pub maxTessellationEvaluationOutputComponents: u32,
    pub maxGeometryShaderInvocations: u32,
    pub maxGeometryInputComponents: u32,
    pub maxGeometryOutputComponents: u32,
    pub maxGeometryOutputVertices: u32,
    pub maxGeometryTotalOutputComponents: u32,
    pub maxFragmentInputComponents: u32,
    pub maxFragmentOutputAttachments: u32,
    pub maxFragmentDualSrcAttachments: u32,
    pub maxFragmentCombinedOutputResources: u32,
    pub maxComputeSharedMemorySize: u32,
    pub maxComputeWorkGroupCount: [u32; 3usize],
    pub maxComputeWorkGroupInvocations: u32,
    pub maxComputeWorkGroupSize: [u32; 3usize],
    pub subPixelPrecisionBits: u32,
    pub subTexelPrecisionBits: u32,
    pub mipmapPrecisionBits: u32,
    pub maxDrawIndexedIndexValue: u32,
    pub maxDrawIndirectCount: u32,
    pub maxSamplerLodBias: f32,
    pub maxSamplerAnisotropy: f32,
    pub maxViewports: u32,
    pub maxViewportDimensions: [u32; 2usize],
    pub viewportBoundsRange: [f32; 2usize],
    pub viewportSubPixelBits: u32,
    pub minMemoryMapAlignment: size_t,
    pub minTexelBufferOffsetAlignment: VkDeviceSize,
    pub minUniformBufferOffsetAlignment: VkDeviceSize,
    pub minStorageBufferOffsetAlignment: VkDeviceSize,
    pub minTexelOffset: i32,
    pub maxTexelOffset: u32,
    pub minTexelGatherOffset: i32,
    pub maxTexelGatherOffset: u32,
    pub minInterpolationOffset: f32,
    pub maxInterpolationOffset: f32,
    pub subPixelInterpolationOffsetBits: u32,
    pub maxFramebufferWidth: u32,
    pub maxFramebufferHeight: u32,
    pub maxFramebufferLayers: u32,
    pub framebufferColorSampleCounts: VkSampleCountFlags,
    pub framebufferDepthSampleCounts: VkSampleCountFlags,
    pub framebufferStencilSampleCounts: VkSampleCountFlags,
    pub framebufferNoAttachmentsSampleCounts: VkSampleCountFlags,
    pub maxColorAttachments: u32,
    pub sampledImageColorSampleCounts: VkSampleCountFlags,
    pub sampledImageIntegerSampleCounts: VkSampleCountFlags,
    pub sampledImageDepthSampleCounts: VkSampleCountFlags,
    pub sampledImageStencilSampleCounts: VkSampleCountFlags,
    pub storageImageSampleCounts: VkSampleCountFlags,
    pub maxSampleMaskWords: u32,
    pub timestampComputeAndGraphics: VkBool32,
    pub timestampPeriod: f32,
    pub maxClipDistances: u32,
    pub maxCullDistances: u32,
    pub maxCombinedClipAndCullDistances: u32,
    pub discreteQueuePriorities: u32,
    pub pointSizeRange: [f32; 2usize],
    pub lineWidthRange: [f32; 2usize],
    pub pointSizeGranularity: f32,
    pub lineWidthGranularity: f32,
    pub strictLines: VkBool32,
    pub standardSampleLocations: VkBool32,
    pub optimalBufferCopyOffsetAlignment: VkDeviceSize,
    pub optimalBufferCopyRowPitchAlignment: VkDeviceSize,
    pub nonCoherentAtomSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryProperties {
    pub memoryTypeCount: u32,
    pub memoryTypes: [VkMemoryType; 32usize],
    pub memoryHeapCount: u32,
    pub memoryHeaps: [VkMemoryHeap; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSparseProperties {
    pub residencyStandard2DBlockShape: VkBool32,
    pub residencyStandard2DMultisampleBlockShape: VkBool32,
    pub residencyStandard3DBlockShape: VkBool32,
    pub residencyAlignedMipSize: VkBool32,
    pub residencyNonResidentStrict: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProperties {
    pub apiVersion: u32,
    pub driverVersion: u32,
    pub vendorID: u32,
    pub deviceID: u32,
    pub deviceType: VkPhysicalDeviceType,
    pub deviceName: [::std::os::raw::c_char; 256usize],
    pub pipelineCacheUUID: [u8; 16usize],
    pub limits: VkPhysicalDeviceLimits,
    pub sparseProperties: VkPhysicalDeviceSparseProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyProperties {
    pub queueFlags: VkQueueFlags,
    pub queueCount: u32,
    pub timestampValidBits: u32,
    pub minImageTransferGranularity: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueCount: u32,
    pub pQueuePriorities: *const f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceCreateFlags,
    pub queueCreateInfoCount: u32,
    pub pQueueCreateInfos: *const VkDeviceQueueCreateInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const ::std::os::raw::c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const ::std::os::raw::c_char,
    pub pEnabledFeatures: *const VkPhysicalDeviceFeatures,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtensionProperties {
    pub extensionName: [::std::os::raw::c_char; 256usize],
    pub specVersion: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkLayerProperties {
    pub layerName: [::std::os::raw::c_char; 256usize],
    pub specVersion: u32,
    pub implementationVersion: u32,
    pub description: [::std::os::raw::c_char; 256usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub pWaitDstStageMask: *const VkPipelineStageFlags,
    pub commandBufferCount: u32,
    pub pCommandBuffers: *const VkCommandBuffer,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const VkSemaphore,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMappedMemoryRange {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub allocationSize: VkDeviceSize,
    pub memoryTypeIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryRequirements {
    pub size: VkDeviceSize,
    pub alignment: VkDeviceSize,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseMemoryBind {
    pub resourceOffset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub flags: VkSparseMemoryBindFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseBufferMemoryBindInfo {
    pub buffer: VkBuffer,
    pub bindCount: u32,
    pub pBinds: *const VkSparseMemoryBind,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageOpaqueMemoryBindInfo {
    pub image: VkImage,
    pub bindCount: u32,
    pub pBinds: *const VkSparseMemoryBind,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresource {
    pub aspectMask: VkImageAspectFlags,
    pub mipLevel: u32,
    pub arrayLayer: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryBind {
    pub subresource: VkImageSubresource,
    pub offset: VkOffset3D,
    pub extent: VkExtent3D,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub flags: VkSparseMemoryBindFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryBindInfo {
    pub image: VkImage,
    pub bindCount: u32,
    pub pBinds: *const VkSparseImageMemoryBind,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindSparseInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub bufferBindCount: u32,
    pub pBufferBinds: *const VkSparseBufferMemoryBindInfo,
    pub imageOpaqueBindCount: u32,
    pub pImageOpaqueBinds: *const VkSparseImageOpaqueMemoryBindInfo,
    pub imageBindCount: u32,
    pub pImageBinds: *const VkSparseImageMemoryBindInfo,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const VkSemaphore,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageFormatProperties {
    pub aspectMask: VkImageAspectFlags,
    pub imageGranularity: VkExtent3D,
    pub flags: VkSparseImageFormatFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryRequirements {
    pub formatProperties: VkSparseImageFormatProperties,
    pub imageMipTailFirstLod: u32,
    pub imageMipTailSize: VkDeviceSize,
    pub imageMipTailOffset: VkDeviceSize,
    pub imageMipTailStride: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFenceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkFenceCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSemaphoreCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkEventCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkEventCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkQueryPoolCreateFlags,
    pub queryType: VkQueryType,
    pub queryCount: u32,
    pub pipelineStatistics: VkQueryPipelineStatisticFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferCreateFlags,
    pub size: VkDeviceSize,
    pub usage: VkBufferUsageFlags,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferViewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferViewCreateFlags,
    pub buffer: VkBuffer,
    pub format: VkFormat,
    pub offset: VkDeviceSize,
    pub range: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageCreateFlags,
    pub imageType: VkImageType,
    pub format: VkFormat,
    pub extent: VkExtent3D,
    pub mipLevels: u32,
    pub arrayLayers: u32,
    pub samples: VkSampleCountFlagBits,
    pub tiling: VkImageTiling,
    pub usage: VkImageUsageFlags,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
    pub initialLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubresourceLayout {
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub rowPitch: VkDeviceSize,
    pub arrayPitch: VkDeviceSize,
    pub depthPitch: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkComponentMapping {
    pub r: VkComponentSwizzle,
    pub g: VkComponentSwizzle,
    pub b: VkComponentSwizzle,
    pub a: VkComponentSwizzle,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageViewCreateFlags,
    pub image: VkImage,
    pub viewType: VkImageViewType,
    pub format: VkFormat,
    pub components: VkComponentMapping,
    pub subresourceRange: VkImageSubresourceRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModuleCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkShaderModuleCreateFlags,
    pub codeSize: size_t,
    pub pCode: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCacheCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCacheCreateFlags,
    pub initialDataSize: size_t,
    pub pInitialData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSpecializationMapEntry {
    pub constantID: u32,
    pub offset: u32,
    pub size: size_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSpecializationInfo {
    pub mapEntryCount: u32,
    pub pMapEntries: *const VkSpecializationMapEntry,
    pub dataSize: size_t,
    pub pData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineShaderStageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineShaderStageCreateFlags,
    pub stage: VkShaderStageFlagBits,
    pub module: VkShaderModule,
    pub pName: *const ::std::os::raw::c_char,
    pub pSpecializationInfo: *const VkSpecializationInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkComputePipelineCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stage: VkPipelineShaderStageCreateInfo,
    pub layout: VkPipelineLayout,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub inputRate: VkVertexInputRate,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: VkFormat,
    pub offset: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineVertexInputStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineVertexInputStateCreateFlags,
    pub vertexBindingDescriptionCount: u32,
    pub pVertexBindingDescriptions: *const VkVertexInputBindingDescription,
    pub vertexAttributeDescriptionCount: u32,
    pub pVertexAttributeDescriptions: *const VkVertexInputAttributeDescription,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineInputAssemblyStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineInputAssemblyStateCreateFlags,
    pub topology: VkPrimitiveTopology,
    pub primitiveRestartEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineTessellationStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineTessellationStateCreateFlags,
    pub patchControlPoints: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub minDepth: f32,
    pub maxDepth: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineViewportStateCreateFlags,
    pub viewportCount: u32,
    pub pViewports: *const VkViewport,
    pub scissorCount: u32,
    pub pScissors: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationStateCreateFlags,
    pub depthClampEnable: VkBool32,
    pub rasterizerDiscardEnable: VkBool32,
    pub polygonMode: VkPolygonMode,
    pub cullMode: VkCullModeFlags,
    pub frontFace: VkFrontFace,
    pub depthBiasEnable: VkBool32,
    pub depthBiasConstantFactor: f32,
    pub depthBiasClamp: f32,
    pub depthBiasSlopeFactor: f32,
    pub lineWidth: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineMultisampleStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineMultisampleStateCreateFlags,
    pub rasterizationSamples: VkSampleCountFlagBits,
    pub sampleShadingEnable: VkBool32,
    pub minSampleShading: f32,
    pub pSampleMask: *const VkSampleMask,
    pub alphaToCoverageEnable: VkBool32,
    pub alphaToOneEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkStencilOpState {
    pub failOp: VkStencilOp,
    pub passOp: VkStencilOp,
    pub depthFailOp: VkStencilOp,
    pub compareOp: VkCompareOp,
    pub compareMask: u32,
    pub writeMask: u32,
    pub reference: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDepthStencilStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDepthStencilStateCreateFlags,
    pub depthTestEnable: VkBool32,
    pub depthWriteEnable: VkBool32,
    pub depthCompareOp: VkCompareOp,
    pub depthBoundsTestEnable: VkBool32,
    pub stencilTestEnable: VkBool32,
    pub front: VkStencilOpState,
    pub back: VkStencilOpState,
    pub minDepthBounds: f32,
    pub maxDepthBounds: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendAttachmentState {
    pub blendEnable: VkBool32,
    pub srcColorBlendFactor: VkBlendFactor,
    pub dstColorBlendFactor: VkBlendFactor,
    pub colorBlendOp: VkBlendOp,
    pub srcAlphaBlendFactor: VkBlendFactor,
    pub dstAlphaBlendFactor: VkBlendFactor,
    pub alphaBlendOp: VkBlendOp,
    pub colorWriteMask: VkColorComponentFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineColorBlendStateCreateFlags,
    pub logicOpEnable: VkBool32,
    pub logicOp: VkLogicOp,
    pub attachmentCount: u32,
    pub pAttachments: *const VkPipelineColorBlendAttachmentState,
    pub blendConstants: [f32; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDynamicStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDynamicStateCreateFlags,
    pub dynamicStateCount: u32,
    pub pDynamicStates: *const VkDynamicState,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsPipelineCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub pVertexInputState: *const VkPipelineVertexInputStateCreateInfo,
    pub pInputAssemblyState: *const VkPipelineInputAssemblyStateCreateInfo,
    pub pTessellationState: *const VkPipelineTessellationStateCreateInfo,
    pub pViewportState: *const VkPipelineViewportStateCreateInfo,
    pub pRasterizationState: *const VkPipelineRasterizationStateCreateInfo,
    pub pMultisampleState: *const VkPipelineMultisampleStateCreateInfo,
    pub pDepthStencilState: *const VkPipelineDepthStencilStateCreateInfo,
    pub pColorBlendState: *const VkPipelineColorBlendStateCreateInfo,
    pub pDynamicState: *const VkPipelineDynamicStateCreateInfo,
    pub layout: VkPipelineLayout,
    pub renderPass: VkRenderPass,
    pub subpass: u32,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPushConstantRange {
    pub stageFlags: VkShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLayoutCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineLayoutCreateFlags,
    pub setLayoutCount: u32,
    pub pSetLayouts: *const VkDescriptorSetLayout,
    pub pushConstantRangeCount: u32,
    pub pPushConstantRanges: *const VkPushConstantRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSamplerCreateFlags,
    pub magFilter: VkFilter,
    pub minFilter: VkFilter,
    pub mipmapMode: VkSamplerMipmapMode,
    pub addressModeU: VkSamplerAddressMode,
    pub addressModeV: VkSamplerAddressMode,
    pub addressModeW: VkSamplerAddressMode,
    pub mipLodBias: f32,
    pub anisotropyEnable: VkBool32,
    pub maxAnisotropy: f32,
    pub compareEnable: VkBool32,
    pub compareOp: VkCompareOp,
    pub minLod: f32,
    pub maxLod: f32,
    pub borderColor: VkBorderColor,
    pub unnormalizedCoordinates: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyDescriptorSet {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSet: VkDescriptorSet,
    pub srcBinding: u32,
    pub srcArrayElement: u32,
    pub dstSet: VkDescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorBufferInfo {
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub range: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorImageInfo {
    pub sampler: VkSampler,
    pub imageView: VkImageView,
    pub imageLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolSize {
    pub type_: VkDescriptorType,
    pub descriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorPoolCreateFlags,
    pub maxSets: u32,
    pub poolSizeCount: u32,
    pub pPoolSizes: *const VkDescriptorPoolSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub descriptorPool: VkDescriptorPool,
    pub descriptorSetCount: u32,
    pub pSetLayouts: *const VkDescriptorSetLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutBinding {
    pub binding: u32,
    pub descriptorType: VkDescriptorType,
    pub descriptorCount: u32,
    pub stageFlags: VkShaderStageFlags,
    pub pImmutableSamplers: *const VkSampler,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorSetLayoutCreateFlags,
    pub bindingCount: u32,
    pub pBindings: *const VkDescriptorSetLayoutBinding,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSet {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dstSet: VkDescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: VkDescriptorType,
    pub pImageInfo: *const VkDescriptorImageInfo,
    pub pBufferInfo: *const VkDescriptorBufferInfo,
    pub pTexelBufferView: *const VkBufferView,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescription {
    pub flags: VkAttachmentDescriptionFlags,
    pub format: VkFormat,
    pub samples: VkSampleCountFlagBits,
    pub loadOp: VkAttachmentLoadOp,
    pub storeOp: VkAttachmentStoreOp,
    pub stencilLoadOp: VkAttachmentLoadOp,
    pub stencilStoreOp: VkAttachmentStoreOp,
    pub initialLayout: VkImageLayout,
    pub finalLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReference {
    pub attachment: u32,
    pub layout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkFramebufferCreateFlags,
    pub renderPass: VkRenderPass,
    pub attachmentCount: u32,
    pub pAttachments: *const VkImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescription {
    pub flags: VkSubpassDescriptionFlags,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const VkAttachmentReference,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const VkAttachmentReference,
    pub pResolveAttachments: *const VkAttachmentReference,
    pub pDepthStencilAttachment: *const VkAttachmentReference,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDependency {
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: VkPipelineStageFlags,
    pub dstStageMask: VkPipelineStageFlags,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub dependencyFlags: VkDependencyFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const VkAttachmentDescription,
    pub subpassCount: u32,
    pub pSubpasses: *const VkSubpassDescription,
    pub dependencyCount: u32,
    pub pDependencies: *const VkSubpassDependency,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkCommandPoolCreateFlags,
    pub queueFamilyIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub commandPool: VkCommandPool,
    pub level: VkCommandBufferLevel,
    pub commandBufferCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub renderPass: VkRenderPass,
    pub subpass: u32,
    pub framebuffer: VkFramebuffer,
    pub occlusionQueryEnable: VkBool32,
    pub queryFlags: VkQueryControlFlags,
    pub pipelineStatistics: VkQueryPipelineStatisticFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkCommandBufferUsageFlags,
    pub pInheritanceInfo: *const VkCommandBufferInheritanceInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCopy {
    pub srcOffset: VkDeviceSize,
    pub dstOffset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresourceLayers {
    pub aspectMask: VkImageAspectFlags,
    pub mipLevel: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferImageCopy {
    pub bufferOffset: VkDeviceSize,
    pub bufferRowLength: u32,
    pub bufferImageHeight: u32,
    pub imageSubresource: VkImageSubresourceLayers,
    pub imageOffset: VkOffset3D,
    pub imageExtent: VkExtent3D,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkClearColorValue {
    pub float32: [f32; 4usize],
    pub int32: [i32; 4usize],
    pub uint32: [u32; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkClearValue {
    pub color: VkClearColorValue,
    pub depthStencil: VkClearDepthStencilValue,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkClearAttachment {
    pub aspectMask: VkImageAspectFlags,
    pub colorAttachment: u32,
    pub clearValue: VkClearValue,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkClearRect {
    pub rect: VkRect2D,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageBlit {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffsets: [VkOffset3D; 2usize],
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffsets: [VkOffset3D; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCopy {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageResolve {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub renderPass: VkRenderPass,
    pub framebuffer: VkFramebuffer,
    pub renderArea: VkRect2D,
    pub clearValueCount: u32,
    pub pClearValues: *const VkClearValue,
}
pub type PFN_vkCreateInstance = 
    unsafe extern "C" fn(
        pCreateInfo: *const VkInstanceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pInstance: *mut VkInstance,
    ) -> VkResult
;
pub type PFN_vkDestroyInstance = 
    unsafe extern "C" fn(instance: VkInstance, pAllocator: *const VkAllocationCallbacks)
;
pub type PFN_vkEnumeratePhysicalDevices = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceCount: *mut u32,
        pPhysicalDevices: *mut VkPhysicalDevice,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceFeatures = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures,
    )
;
pub type PFN_vkGetPhysicalDeviceFormatProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties,
    )
;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        pImageFormatProperties: *mut VkImageFormatProperties,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties,
    )
;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties,
    )
;
pub type PFN_vkGetPhysicalDeviceMemoryProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties,
    )
;
pub type PFN_vkGetInstanceProcAddr = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction
;
pub type PFN_vkGetDeviceProcAddr = 
    unsafe extern "C" fn(
        device: VkDevice,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction
;
pub type PFN_vkCreateDevice = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pCreateInfo: *const VkDeviceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDevice: *mut VkDevice,
    ) -> VkResult
;
pub type PFN_vkDestroyDevice = 
    unsafe extern "C" fn(device: VkDevice, pAllocator: *const VkAllocationCallbacks)
;
pub type PFN_vkEnumerateInstanceExtensionProperties = 
    unsafe extern "C" fn(
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult
;
pub type PFN_vkEnumerateDeviceExtensionProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult
;
pub type PFN_vkEnumerateInstanceLayerProperties = 
    unsafe extern "C" fn(pPropertyCount: *mut u32, pProperties: *mut VkLayerProperties) -> VkResult
;
pub type PFN_vkEnumerateDeviceLayerProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkLayerProperties,
    ) -> VkResult
;
pub type PFN_vkGetDeviceQueue = 
    unsafe extern "C" fn(
        device: VkDevice,
        queueFamilyIndex: u32,
        queueIndex: u32,
        pQueue: *mut VkQueue,
    )
;
pub type PFN_vkQueueSubmit = 
    unsafe extern "C" fn(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo,
        fence: VkFence,
    ) -> VkResult
;
pub type PFN_vkQueueWaitIdle =
    unsafe extern "C" fn(queue: VkQueue) -> VkResult;
pub type PFN_vkDeviceWaitIdle =
    unsafe extern "C" fn(device: VkDevice) -> VkResult;
pub type PFN_vkAllocateMemory = 
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkMemoryAllocateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pMemory: *mut VkDeviceMemory,
    ) -> VkResult
;
pub type PFN_vkFreeMemory = 
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkMapMemory = 
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        offset: VkDeviceSize,
        size: VkDeviceSize,
        flags: VkMemoryMapFlags,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> VkResult
;
pub type PFN_vkUnmapMemory =
    unsafe extern "C" fn(device: VkDevice, memory: VkDeviceMemory);
pub type PFN_vkFlushMappedMemoryRanges = 
    unsafe extern "C" fn(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult
;
pub type PFN_vkInvalidateMappedMemoryRanges = 
    unsafe extern "C" fn(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult
;
pub type PFN_vkGetDeviceMemoryCommitment = 
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        pCommittedMemoryInBytes: *mut VkDeviceSize,
    )
;
pub type PFN_vkBindBufferMemory = 
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult
;
pub type PFN_vkBindImageMemory = 
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult
;
pub type PFN_vkGetBufferMemoryRequirements = 
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        pMemoryRequirements: *mut VkMemoryRequirements,
    )
;
pub type PFN_vkGetImageMemoryRequirements = 
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pMemoryRequirements: *mut VkMemoryRequirements,
    )
;
pub type PFN_vkGetImageSparseMemoryRequirements = 
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements,
    )
;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        samples: VkSampleCountFlagBits,
        usage: VkImageUsageFlags,
        tiling: VkImageTiling,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties,
    )
;
pub type PFN_vkQueueBindSparse = 
    unsafe extern "C" fn(
        queue: VkQueue,
        bindInfoCount: u32,
        pBindInfo: *const VkBindSparseInfo,
        fence: VkFence,
    ) -> VkResult
;
pub type PFN_vkCreateFence = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkFenceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult
;
pub type PFN_vkDestroyFence = 
    unsafe extern "C" fn(
        device: VkDevice,
        fence: VkFence,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkResetFences = 
    unsafe extern "C" fn(device: VkDevice, fenceCount: u32, pFences: *const VkFence) -> VkResult
;
pub type PFN_vkGetFenceStatus =
    unsafe extern "C" fn(device: VkDevice, fence: VkFence) -> VkResult;
pub type PFN_vkWaitForFences = 
    unsafe extern "C" fn(
        device: VkDevice,
        fenceCount: u32,
        pFences: *const VkFence,
        waitAll: VkBool32,
        timeout: u64,
    ) -> VkResult
;
pub type PFN_vkCreateSemaphore = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSemaphoreCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSemaphore: *mut VkSemaphore,
    ) -> VkResult
;
pub type PFN_vkDestroySemaphore = 
    unsafe extern "C" fn(
        device: VkDevice,
        semaphore: VkSemaphore,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateEvent = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkEventCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pEvent: *mut VkEvent,
    ) -> VkResult
;
pub type PFN_vkDestroyEvent = 
    unsafe extern "C" fn(
        device: VkDevice,
        event: VkEvent,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetEventStatus =
    unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult;
pub type PFN_vkSetEvent =
    unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult;
pub type PFN_vkResetEvent =
    unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult;
pub type PFN_vkCreateQueryPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkQueryPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pQueryPool: *mut VkQueryPool,
    ) -> VkResult
;
pub type PFN_vkDestroyQueryPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetQueryPoolResults = 
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    ) -> VkResult
;
pub type PFN_vkCreateBuffer = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkBufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pBuffer: *mut VkBuffer,
    ) -> VkResult
;
pub type PFN_vkDestroyBuffer = 
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateBufferView = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkBufferViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkBufferView,
    ) -> VkResult
;
pub type PFN_vkDestroyBufferView = 
    unsafe extern "C" fn(
        device: VkDevice,
        bufferView: VkBufferView,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateImage = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkImageCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pImage: *mut VkImage,
    ) -> VkResult
;
pub type PFN_vkDestroyImage = 
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetImageSubresourceLayout = 
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pSubresource: *const VkImageSubresource,
        pLayout: *mut VkSubresourceLayout,
    )
;
pub type PFN_vkCreateImageView = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkImageViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkImageView,
    ) -> VkResult
;
pub type PFN_vkDestroyImageView = 
    unsafe extern "C" fn(
        device: VkDevice,
        imageView: VkImageView,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateShaderModule = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkShaderModuleCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pShaderModule: *mut VkShaderModule,
    ) -> VkResult
;
pub type PFN_vkDestroyShaderModule = 
    unsafe extern "C" fn(
        device: VkDevice,
        shaderModule: VkShaderModule,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreatePipelineCache = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPipelineCacheCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineCache: *mut VkPipelineCache,
    ) -> VkResult
;
pub type PFN_vkDestroyPipelineCache = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetPipelineCacheData = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult
;
pub type PFN_vkMergePipelineCaches = 
    unsafe extern "C" fn(
        device: VkDevice,
        dstCache: VkPipelineCache,
        srcCacheCount: u32,
        pSrcCaches: *const VkPipelineCache,
    ) -> VkResult
;
pub type PFN_vkCreateGraphicsPipelines = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkGraphicsPipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult
;
pub type PFN_vkCreateComputePipelines = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkComputePipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult
;
pub type PFN_vkDestroyPipeline = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreatePipelineLayout = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPipelineLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineLayout: *mut VkPipelineLayout,
    ) -> VkResult
;
pub type PFN_vkDestroyPipelineLayout = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineLayout: VkPipelineLayout,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateSampler = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSampler: *mut VkSampler,
    ) -> VkResult
;
pub type PFN_vkDestroySampler = 
    unsafe extern "C" fn(
        device: VkDevice,
        sampler: VkSampler,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateDescriptorSetLayout = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSetLayout: *mut VkDescriptorSetLayout,
    ) -> VkResult
;
pub type PFN_vkDestroyDescriptorSetLayout = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSetLayout: VkDescriptorSetLayout,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateDescriptorPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorPool: *mut VkDescriptorPool,
    ) -> VkResult
;
pub type PFN_vkDestroyDescriptorPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkResetDescriptorPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        flags: VkDescriptorPoolResetFlags,
    ) -> VkResult
;
pub type PFN_vkAllocateDescriptorSets = 
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkDescriptorSetAllocateInfo,
        pDescriptorSets: *mut VkDescriptorSet,
    ) -> VkResult
;
pub type PFN_vkFreeDescriptorSets = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
    ) -> VkResult
;
pub type PFN_vkUpdateDescriptorSets = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
        descriptorCopyCount: u32,
        pDescriptorCopies: *const VkCopyDescriptorSet,
    )
;
pub type PFN_vkCreateFramebuffer = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkFramebufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFramebuffer: *mut VkFramebuffer,
    ) -> VkResult
;
pub type PFN_vkDestroyFramebuffer = 
    unsafe extern "C" fn(
        device: VkDevice,
        framebuffer: VkFramebuffer,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateRenderPass = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult
;
pub type PFN_vkDestroyRenderPass = 
    unsafe extern "C" fn(
        device: VkDevice,
        renderPass: VkRenderPass,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetRenderAreaGranularity = 
    unsafe extern "C" fn(device: VkDevice, renderPass: VkRenderPass, pGranularity: *mut VkExtent2D)
;
pub type PFN_vkCreateCommandPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkCommandPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pCommandPool: *mut VkCommandPool,
    ) -> VkResult
;
pub type PFN_vkDestroyCommandPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkResetCommandPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolResetFlags,
    ) -> VkResult
;
pub type PFN_vkAllocateCommandBuffers = 
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkCommandBufferAllocateInfo,
        pCommandBuffers: *mut VkCommandBuffer,
    ) -> VkResult
;
pub type PFN_vkFreeCommandBuffers = 
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    )
;
pub type PFN_vkBeginCommandBuffer = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pBeginInfo: *const VkCommandBufferBeginInfo,
    ) -> VkResult
;
pub type PFN_vkEndCommandBuffer =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer) -> VkResult;
pub type PFN_vkResetCommandBuffer = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        flags: VkCommandBufferResetFlags,
    ) -> VkResult
;
pub type PFN_vkCmdBindPipeline = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
    )
;
pub type PFN_vkCmdSetViewport = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewports: *const VkViewport,
    )
;
pub type PFN_vkCmdSetScissor = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstScissor: u32,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    )
;
pub type PFN_vkCmdSetLineWidth =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, lineWidth: f32);
pub type PFN_vkCmdSetDepthBias = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        depthBiasConstantFactor: f32,
        depthBiasClamp: f32,
        depthBiasSlopeFactor: f32,
    )
;
pub type PFN_vkCmdSetBlendConstants = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, blendConstants: *const f32)
;
pub type PFN_vkCmdSetDepthBounds = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, minDepthBounds: f32, maxDepthBounds: f32)
;
pub type PFN_vkCmdSetStencilCompareMask = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        compareMask: u32,
    )
;
pub type PFN_vkCmdSetStencilWriteMask = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        writeMask: u32,
    )
;
pub type PFN_vkCmdSetStencilReference = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        reference: u32,
    )
;
pub type PFN_vkCmdBindDescriptorSets = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        firstSet: u32,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
        dynamicOffsetCount: u32,
        pDynamicOffsets: *const u32,
    )
;
pub type PFN_vkCmdBindIndexBuffer = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        indexType: VkIndexType,
    )
;
pub type PFN_vkCmdBindVertexBuffers = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
    )
;
pub type PFN_vkCmdDraw = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        vertexCount: u32,
        instanceCount: u32,
        firstVertex: u32,
        firstInstance: u32,
    )
;
pub type PFN_vkCmdDrawIndexed = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        indexCount: u32,
        instanceCount: u32,
        firstIndex: u32,
        vertexOffset: i32,
        firstInstance: u32,
    )
;
pub type PFN_vkCmdDrawIndirect = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    )
;
pub type PFN_vkCmdDrawIndexedIndirect = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    )
;
pub type PFN_vkCmdDispatch = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    )
;
pub type PFN_vkCmdDispatchIndirect = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, buffer: VkBuffer, offset: VkDeviceSize)
;
pub type PFN_vkCmdCopyBuffer = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferCopy,
    )
;
pub type PFN_vkCmdCopyImage = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageCopy,
    )
;
pub type PFN_vkCmdBlitImage = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageBlit,
        filter: VkFilter,
    )
;
pub type PFN_vkCmdCopyBufferToImage = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    )
;
pub type PFN_vkCmdCopyImageToBuffer = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    )
;
pub type PFN_vkCmdUpdateBuffer = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        dataSize: VkDeviceSize,
        pData: *const ::std::os::raw::c_void,
    )
;
pub type PFN_vkCmdFillBuffer = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        size: VkDeviceSize,
        data: u32,
    )
;
pub type PFN_vkCmdClearColorImage = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pColor: *const VkClearColorValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    )
;
pub type PFN_vkCmdClearDepthStencilImage = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pDepthStencil: *const VkClearDepthStencilValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    )
;
pub type PFN_vkCmdClearAttachments = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        attachmentCount: u32,
        pAttachments: *const VkClearAttachment,
        rectCount: u32,
        pRects: *const VkClearRect,
    )
;
pub type PFN_vkCmdResolveImage = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageResolve,
    )
;
pub type PFN_vkCmdSetEvent = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    )
;
pub type PFN_vkCmdResetEvent = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    )
;
pub type PFN_vkCmdWaitEvents = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    )
;
pub type PFN_vkCmdPipelineBarrier = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        dependencyFlags: VkDependencyFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    )
;
pub type PFN_vkCmdBeginQuery = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
    )
;
pub type PFN_vkCmdEndQuery = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, queryPool: VkQueryPool, query: u32)
;
pub type PFN_vkCmdResetQueryPool = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    )
;
pub type PFN_vkCmdWriteTimestamp = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        queryPool: VkQueryPool,
        query: u32,
    )
;
pub type PFN_vkCmdCopyQueryPoolResults = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    )
;
pub type PFN_vkCmdPushConstants = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        layout: VkPipelineLayout,
        stageFlags: VkShaderStageFlags,
        offset: u32,
        size: u32,
        pValues: *const ::std::os::raw::c_void,
    )
;
pub type PFN_vkCmdBeginRenderPass = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        contents: VkSubpassContents,
    )
;
pub type PFN_vkCmdNextSubpass = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, contents: VkSubpassContents)
;
pub type PFN_vkCmdEndRenderPass =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer);
pub type PFN_vkCmdExecuteCommands = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversion_T {
    _unused: [u8; 0],
}
pub type VkSamplerYcbcrConversion = *mut VkSamplerYcbcrConversion_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplate_T {
    _unused: [u8; 0],
}
pub type VkDescriptorUpdateTemplate = *mut VkDescriptorUpdateTemplate_T;
pub const VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES:
    VkPointClippingBehavior = 0;
pub const VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY:
    VkPointClippingBehavior = 1;
pub const VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES_KHR:
    VkPointClippingBehavior = 0;
pub const VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY_KHR:
    VkPointClippingBehavior = 1;
pub const VK_POINT_CLIPPING_BEHAVIOR_MAX_ENUM: VkPointClippingBehavior =
    2147483647;
pub type VkPointClippingBehavior = ::std::os::raw::c_uint;
pub const VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT:
    VkTessellationDomainOrigin = 0;
pub const VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT:
    VkTessellationDomainOrigin = 1;
pub const VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT_KHR:
    VkTessellationDomainOrigin = 0;
pub const VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT_KHR:
    VkTessellationDomainOrigin = 1;
pub const VK_TESSELLATION_DOMAIN_ORIGIN_MAX_ENUM:
    VkTessellationDomainOrigin = 2147483647;
pub type VkTessellationDomainOrigin = ::std::os::raw::c_uint;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY:
    VkSamplerYcbcrModelConversion = 0;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY:
    VkSamplerYcbcrModelConversion = 1;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709:
    VkSamplerYcbcrModelConversion = 2;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601:
    VkSamplerYcbcrModelConversion = 3;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020:
    VkSamplerYcbcrModelConversion = 4;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY_KHR:
    VkSamplerYcbcrModelConversion = 0;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY_KHR:
    VkSamplerYcbcrModelConversion = 1;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709_KHR:
    VkSamplerYcbcrModelConversion = 2;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601_KHR:
    VkSamplerYcbcrModelConversion = 3;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020_KHR:
    VkSamplerYcbcrModelConversion = 4;
pub const VK_SAMPLER_YCBCR_MODEL_CONVERSION_MAX_ENUM:
    VkSamplerYcbcrModelConversion = 2147483647;
pub type VkSamplerYcbcrModelConversion = ::std::os::raw::c_uint;
pub const VK_SAMPLER_YCBCR_RANGE_ITU_FULL: VkSamplerYcbcrRange = 0;
pub const VK_SAMPLER_YCBCR_RANGE_ITU_NARROW: VkSamplerYcbcrRange = 1;
pub const VK_SAMPLER_YCBCR_RANGE_ITU_FULL_KHR: VkSamplerYcbcrRange = 0;
pub const VK_SAMPLER_YCBCR_RANGE_ITU_NARROW_KHR: VkSamplerYcbcrRange = 1;
pub const VK_SAMPLER_YCBCR_RANGE_MAX_ENUM: VkSamplerYcbcrRange = 2147483647;
pub type VkSamplerYcbcrRange = ::std::os::raw::c_uint;
pub const VK_CHROMA_LOCATION_COSITED_EVEN: VkChromaLocation = 0;
pub const VK_CHROMA_LOCATION_MIDPOINT: VkChromaLocation = 1;
pub const VK_CHROMA_LOCATION_COSITED_EVEN_KHR: VkChromaLocation = 0;
pub const VK_CHROMA_LOCATION_MIDPOINT_KHR: VkChromaLocation = 1;
pub const VK_CHROMA_LOCATION_MAX_ENUM: VkChromaLocation = 2147483647;
pub type VkChromaLocation = ::std::os::raw::c_uint;
pub const VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET:
    VkDescriptorUpdateTemplateType = 0;
pub const VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR:
    VkDescriptorUpdateTemplateType = 1;
pub const VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR:
    VkDescriptorUpdateTemplateType = 0;
pub const VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_MAX_ENUM:
    VkDescriptorUpdateTemplateType = 2147483647;
pub type VkDescriptorUpdateTemplateType = ::std::os::raw::c_uint;
pub const VK_SUBGROUP_FEATURE_BASIC_BIT: VkSubgroupFeatureFlagBits = 1;
pub const VK_SUBGROUP_FEATURE_VOTE_BIT: VkSubgroupFeatureFlagBits = 2;
pub const VK_SUBGROUP_FEATURE_ARITHMETIC_BIT: VkSubgroupFeatureFlagBits =
    4;
pub const VK_SUBGROUP_FEATURE_BALLOT_BIT: VkSubgroupFeatureFlagBits = 8;
pub const VK_SUBGROUP_FEATURE_SHUFFLE_BIT: VkSubgroupFeatureFlagBits = 16;
pub const VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT:
    VkSubgroupFeatureFlagBits = 32;
pub const VK_SUBGROUP_FEATURE_CLUSTERED_BIT: VkSubgroupFeatureFlagBits =
    64;
pub const VK_SUBGROUP_FEATURE_QUAD_BIT: VkSubgroupFeatureFlagBits = 128;
pub const VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV:
    VkSubgroupFeatureFlagBits = 256;
pub const VK_SUBGROUP_FEATURE_FLAG_BITS_MAX_ENUM:
    VkSubgroupFeatureFlagBits = 2147483647;
pub type VkSubgroupFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkSubgroupFeatureFlags = VkFlags;
pub const VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT:
    VkPeerMemoryFeatureFlagBits = 1;
pub const VK_PEER_MEMORY_FEATURE_COPY_DST_BIT:
    VkPeerMemoryFeatureFlagBits = 2;
pub const VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT:
    VkPeerMemoryFeatureFlagBits = 4;
pub const VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT:
    VkPeerMemoryFeatureFlagBits = 8;
pub const VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 1;
pub const VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 2;
pub const VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 4;
pub const VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 8;
pub const VK_PEER_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM:
    VkPeerMemoryFeatureFlagBits = 2147483647;
pub type VkPeerMemoryFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkPeerMemoryFeatureFlags = VkFlags;
pub const VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT: VkMemoryAllocateFlagBits = 1;
pub const VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT: VkMemoryAllocateFlagBits =
    2;
pub const VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT:
    VkMemoryAllocateFlagBits = 4;
pub const VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR:
    VkMemoryAllocateFlagBits = 1;
pub const VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT_KHR:
    VkMemoryAllocateFlagBits = 2;
pub const VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR:
    VkMemoryAllocateFlagBits = 4;
pub const VK_MEMORY_ALLOCATE_FLAG_BITS_MAX_ENUM: VkMemoryAllocateFlagBits =
    2147483647;
pub type VkMemoryAllocateFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryAllocateFlags = VkFlags;
pub type VkCommandPoolTrimFlags = VkFlags;
pub type VkDescriptorUpdateTemplateCreateFlags = VkFlags;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalMemoryHandleTypeFlagBits = 1;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT:
    VkExternalMemoryHandleTypeFlagBits = 2;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT:
    VkExternalMemoryHandleTypeFlagBits = 4;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT:
    VkExternalMemoryHandleTypeFlagBits = 8;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT : VkExternalMemoryHandleTypeFlagBits = 16 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT:
    VkExternalMemoryHandleTypeFlagBits = 32;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT:
    VkExternalMemoryHandleTypeFlagBits = 64;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT:
    VkExternalMemoryHandleTypeFlagBits = 512;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID : VkExternalMemoryHandleTypeFlagBits = 1024 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT : VkExternalMemoryHandleTypeFlagBits = 128 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT : VkExternalMemoryHandleTypeFlagBits = 256 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA : VkExternalMemoryHandleTypeFlagBits = 2048 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV:
    VkExternalMemoryHandleTypeFlagBits = 4096;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 1;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 2;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 4 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 8 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 16 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 32;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 64 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM:
    VkExternalMemoryHandleTypeFlagBits = 2147483647;
pub type VkExternalMemoryHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalMemoryHandleTypeFlags = VkFlags;
pub const VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT:
    VkExternalMemoryFeatureFlagBits = 1;
pub const VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT:
    VkExternalMemoryFeatureFlagBits = 2;
pub const VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT:
    VkExternalMemoryFeatureFlagBits = 4;
pub const VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 1;
pub const VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 2;
pub const VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 4;
pub const VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalMemoryFeatureFlagBits = 2147483647;
pub type VkExternalMemoryFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalMemoryFeatureFlags = VkFlags;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalFenceHandleTypeFlagBits = 1;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT:
    VkExternalFenceHandleTypeFlagBits = 2;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT:
    VkExternalFenceHandleTypeFlagBits = 4;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT:
    VkExternalFenceHandleTypeFlagBits = 8;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 1;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 2;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalFenceHandleTypeFlagBits = 4 ;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 8;
pub const VK_EXTERNAL_FENCE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM:
    VkExternalFenceHandleTypeFlagBits = 2147483647;
pub type VkExternalFenceHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalFenceHandleTypeFlags = VkFlags;
pub const VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT:
    VkExternalFenceFeatureFlagBits = 1;
pub const VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT:
    VkExternalFenceFeatureFlagBits = 2;
pub const VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalFenceFeatureFlagBits = 1;
pub const VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalFenceFeatureFlagBits = 2;
pub const VK_EXTERNAL_FENCE_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalFenceFeatureFlagBits = 2147483647;
pub type VkExternalFenceFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalFenceFeatureFlags = VkFlags;
pub const VK_FENCE_IMPORT_TEMPORARY_BIT: VkFenceImportFlagBits = 1;
pub const VK_FENCE_IMPORT_TEMPORARY_BIT_KHR: VkFenceImportFlagBits = 1;
pub const VK_FENCE_IMPORT_FLAG_BITS_MAX_ENUM: VkFenceImportFlagBits =
    2147483647;
pub type VkFenceImportFlagBits = ::std::os::raw::c_uint;
pub type VkFenceImportFlags = VkFlags;
pub const VK_SEMAPHORE_IMPORT_TEMPORARY_BIT: VkSemaphoreImportFlagBits =
    1;
pub const VK_SEMAPHORE_IMPORT_TEMPORARY_BIT_KHR:
    VkSemaphoreImportFlagBits = 1;
pub const VK_SEMAPHORE_IMPORT_FLAG_BITS_MAX_ENUM:
    VkSemaphoreImportFlagBits = 2147483647;
pub type VkSemaphoreImportFlagBits = ::std::os::raw::c_uint;
pub type VkSemaphoreImportFlags = VkFlags;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalSemaphoreHandleTypeFlagBits = 1;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT : VkExternalSemaphoreHandleTypeFlagBits = 2 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT : VkExternalSemaphoreHandleTypeFlagBits = 4 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT:
    VkExternalSemaphoreHandleTypeFlagBits = 16;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA : VkExternalSemaphoreHandleTypeFlagBits = 128 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE_BIT : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 1 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 2 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 4 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 16 ;
pub const VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM : VkExternalSemaphoreHandleTypeFlagBits = 2147483647 ;
pub type VkExternalSemaphoreHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalSemaphoreHandleTypeFlags = VkFlags;
pub const VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT:
    VkExternalSemaphoreFeatureFlagBits = 1;
pub const VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT:
    VkExternalSemaphoreFeatureFlagBits = 2;
pub const VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalSemaphoreFeatureFlagBits = 1;
pub const VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalSemaphoreFeatureFlagBits = 2;
pub const VK_EXTERNAL_SEMAPHORE_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalSemaphoreFeatureFlagBits = 2147483647;
pub type VkExternalSemaphoreFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalSemaphoreFeatureFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubgroupProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subgroupSize: u32,
    pub supportedStages: VkShaderStageFlags,
    pub supportedOperations: VkSubgroupFeatureFlags,
    pub quadOperationsInAllStages: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindBufferMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice16BitStorageFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer16BitAccess: VkBool32,
    pub uniformAndStorageBuffer16BitAccess: VkBool32,
    pub storagePushConstant16: VkBool32,
    pub storageInputOutput16: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryDedicatedRequirements {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub prefersDedicatedAllocation: VkBool32,
    pub requiresDedicatedAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryDedicatedAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub buffer: VkBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryAllocateFlagsInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkMemoryAllocateFlags,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupRenderPassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceMask: u32,
    pub deviceRenderAreaCount: u32,
    pub pDeviceRenderAreas: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupCommandBufferBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphoreDeviceIndices: *const u32,
    pub commandBufferCount: u32,
    pub pCommandBufferDeviceMasks: *const u32,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphoreDeviceIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupBindSparseInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub resourceDeviceIndex: u32,
    pub memoryDeviceIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindBufferMemoryDeviceGroupInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemoryDeviceGroupInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
    pub splitInstanceBindRegionCount: u32,
    pub pSplitInstanceBindRegions: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceGroupProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub physicalDeviceCount: u32,
    pub physicalDevices: [VkPhysicalDevice; 32usize],
    pub subsetAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupDeviceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub physicalDeviceCount: u32,
    pub pPhysicalDevices: *const VkPhysicalDevice,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSparseMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryRequirements2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryRequirements: VkMemoryRequirements,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryRequirements2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryRequirements: VkSparseImageMemoryRequirements,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFeatures2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub features: VkPhysicalDeviceFeatures,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub properties: VkPhysicalDeviceProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub formatProperties: VkFormatProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageFormatProperties: VkImageFormatProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageFormatInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub type_: VkImageType,
    pub tiling: VkImageTiling,
    pub usage: VkImageUsageFlags,
    pub flags: VkImageCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub queueFamilyProperties: VkQueueFamilyProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryProperties: VkPhysicalDeviceMemoryProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub properties: VkSparseImageFormatProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSparseImageFormatInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub type_: VkImageType,
    pub samples: VkSampleCountFlagBits,
    pub usage: VkImageUsageFlags,
    pub tiling: VkImageTiling,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePointClippingProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pointClippingBehavior: VkPointClippingBehavior,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInputAttachmentAspectReference {
    pub subpass: u32,
    pub inputAttachmentIndex: u32,
    pub aspectMask: VkImageAspectFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassInputAttachmentAspectCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub aspectReferenceCount: u32,
    pub pAspectReferences: *const VkInputAttachmentAspectReference,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewUsageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub usage: VkImageUsageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineTessellationDomainOriginStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub domainOrigin: VkTessellationDomainOrigin,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassMultiviewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub subpassCount: u32,
    pub pViewMasks: *const u32,
    pub dependencyCount: u32,
    pub pViewOffsets: *const i32,
    pub correlationMaskCount: u32,
    pub pCorrelationMasks: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub multiview: VkBool32,
    pub multiviewGeometryShader: VkBool32,
    pub multiviewTessellationShader: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxMultiviewViewCount: u32,
    pub maxMultiviewInstanceIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVariablePointersFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub variablePointersStorageBuffer: VkBool32,
    pub variablePointers: VkBool32,
}
pub type VkPhysicalDeviceVariablePointerFeatures = VkPhysicalDeviceVariablePointersFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProtectedMemoryFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub protectedMemory: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProtectedMemoryProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub protectedNoFault: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkProtectedSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub protectedSubmit: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub ycbcrModel: VkSamplerYcbcrModelConversion,
    pub ycbcrRange: VkSamplerYcbcrRange,
    pub components: VkComponentMapping,
    pub xChromaOffset: VkChromaLocation,
    pub yChromaOffset: VkChromaLocation,
    pub chromaFilter: VkFilter,
    pub forceExplicitReconstruction: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub conversion: VkSamplerYcbcrConversion,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImagePlaneMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub planeAspect: VkImageAspectFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImagePlaneMemoryRequirementsInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub planeAspect: VkImageAspectFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSamplerYcbcrConversionFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub samplerYcbcrConversion: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionImageFormatProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub combinedImageSamplerDescriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplateEntry {
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: VkDescriptorType,
    pub offset: size_t,
    pub stride: size_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorUpdateTemplateCreateFlags,
    pub descriptorUpdateEntryCount: u32,
    pub pDescriptorUpdateEntries: *const VkDescriptorUpdateTemplateEntry,
    pub templateType: VkDescriptorUpdateTemplateType,
    pub descriptorSetLayout: VkDescriptorSetLayout,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub pipelineLayout: VkPipelineLayout,
    pub set: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryProperties {
    pub externalMemoryFeatures: VkExternalMemoryFeatureFlags,
    pub exportFromImportedHandleTypes: VkExternalMemoryHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalImageFormatInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalImageFormatProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalMemoryProperties: VkExternalMemoryProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalBufferInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferCreateFlags,
    pub usage: VkBufferUsageFlags,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalBufferProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalMemoryProperties: VkExternalMemoryProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceIDProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceUUID: [u8; 16usize],
    pub driverUUID: [u8; 16usize],
    pub deviceLUID: [u8; 8usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryImageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryBufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportMemoryAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalFenceInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalFenceProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exportFromImportedHandleTypes: VkExternalFenceHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalFenceHandleTypeFlags,
    pub externalFenceFeatures: VkExternalFenceFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportFenceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalFenceHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportSemaphoreCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalSemaphoreHandleTypeFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalSemaphoreInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalSemaphoreProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exportFromImportedHandleTypes: VkExternalSemaphoreHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalSemaphoreHandleTypeFlags,
    pub externalSemaphoreFeatures: VkExternalSemaphoreFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMaintenance3Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutSupport {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supported: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderDrawParametersFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderDrawParameters: VkBool32,
}
pub type VkPhysicalDeviceShaderDrawParameterFeatures = VkPhysicalDeviceShaderDrawParametersFeatures;
pub type PFN_vkEnumerateInstanceVersion =
    unsafe extern "C" fn(pApiVersion: *mut u32) -> VkResult;
pub type PFN_vkBindBufferMemory2 = 
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult
;
pub type PFN_vkBindImageMemory2 = 
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult
;
pub type PFN_vkGetDeviceGroupPeerMemoryFeatures = 
    unsafe extern "C" fn(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    )
;
pub type PFN_vkCmdSetDeviceMask =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, deviceMask: u32);
pub type PFN_vkCmdDispatchBase = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    )
;
pub type PFN_vkEnumeratePhysicalDeviceGroups = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult
;
pub type PFN_vkGetImageMemoryRequirements2 = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetBufferMemoryRequirements2 = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetImageSparseMemoryRequirements2 = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    )
;
pub type PFN_vkGetPhysicalDeviceFeatures2 = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    )
;
pub type PFN_vkGetPhysicalDeviceProperties2 = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceFormatProperties2 = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties2 = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties2 = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceMemoryProperties2 = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties2 = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    )
;
pub type PFN_vkTrimCommandPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    )
;
pub type PFN_vkGetDeviceQueue2 = 
    unsafe extern "C" fn(
        device: VkDevice,
        pQueueInfo: *const VkDeviceQueueInfo2,
        pQueue: *mut VkQueue,
    )
;
pub type PFN_vkCreateSamplerYcbcrConversion = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult
;
pub type PFN_vkDestroySamplerYcbcrConversion = 
    unsafe extern "C" fn(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCreateDescriptorUpdateTemplate = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult
;
pub type PFN_vkDestroyDescriptorUpdateTemplate = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkUpdateDescriptorSetWithTemplate = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    )
;
pub type PFN_vkGetPhysicalDeviceExternalBufferProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    )
;
pub type PFN_vkGetPhysicalDeviceExternalFenceProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    )
;
pub type PFN_vkGetPhysicalDeviceExternalSemaphoreProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    )
;
pub type PFN_vkGetDescriptorSetLayoutSupport = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    )
;
pub const VK_DRIVER_ID_AMD_PROPRIETARY: VkDriverId = 1;
pub const VK_DRIVER_ID_AMD_OPEN_SOURCE: VkDriverId = 2;
pub const VK_DRIVER_ID_MESA_RADV: VkDriverId = 3;
pub const VK_DRIVER_ID_NVIDIA_PROPRIETARY: VkDriverId = 4;
pub const VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS: VkDriverId = 5;
pub const VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA: VkDriverId = 6;
pub const VK_DRIVER_ID_IMAGINATION_PROPRIETARY: VkDriverId = 7;
pub const VK_DRIVER_ID_QUALCOMM_PROPRIETARY: VkDriverId = 8;
pub const VK_DRIVER_ID_ARM_PROPRIETARY: VkDriverId = 9;
pub const VK_DRIVER_ID_GOOGLE_SWIFTSHADER: VkDriverId = 10;
pub const VK_DRIVER_ID_GGP_PROPRIETARY: VkDriverId = 11;
pub const VK_DRIVER_ID_BROADCOM_PROPRIETARY: VkDriverId = 12;
pub const VK_DRIVER_ID_MESA_LLVMPIPE: VkDriverId = 13;
pub const VK_DRIVER_ID_MOLTENVK: VkDriverId = 14;
pub const VK_DRIVER_ID_COREAVI_PROPRIETARY: VkDriverId = 15;
pub const VK_DRIVER_ID_JUICE_PROPRIETARY: VkDriverId = 16;
pub const VK_DRIVER_ID_VERISILICON_PROPRIETARY: VkDriverId = 17;
pub const VK_DRIVER_ID_MESA_TURNIP: VkDriverId = 18;
pub const VK_DRIVER_ID_MESA_V3DV: VkDriverId = 19;
pub const VK_DRIVER_ID_MESA_PANVK: VkDriverId = 20;
pub const VK_DRIVER_ID_SAMSUNG_PROPRIETARY: VkDriverId = 21;
pub const VK_DRIVER_ID_MESA_VENUS: VkDriverId = 22;
pub const VK_DRIVER_ID_AMD_PROPRIETARY_KHR: VkDriverId = 1;
pub const VK_DRIVER_ID_AMD_OPEN_SOURCE_KHR: VkDriverId = 2;
pub const VK_DRIVER_ID_MESA_RADV_KHR: VkDriverId = 3;
pub const VK_DRIVER_ID_NVIDIA_PROPRIETARY_KHR: VkDriverId = 4;
pub const VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS_KHR: VkDriverId = 5;
pub const VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA_KHR: VkDriverId = 6;
pub const VK_DRIVER_ID_IMAGINATION_PROPRIETARY_KHR: VkDriverId = 7;
pub const VK_DRIVER_ID_QUALCOMM_PROPRIETARY_KHR: VkDriverId = 8;
pub const VK_DRIVER_ID_ARM_PROPRIETARY_KHR: VkDriverId = 9;
pub const VK_DRIVER_ID_GOOGLE_SWIFTSHADER_KHR: VkDriverId = 10;
pub const VK_DRIVER_ID_GGP_PROPRIETARY_KHR: VkDriverId = 11;
pub const VK_DRIVER_ID_BROADCOM_PROPRIETARY_KHR: VkDriverId = 12;
pub const VK_DRIVER_ID_MAX_ENUM: VkDriverId = 2147483647;
pub type VkDriverId = ::std::os::raw::c_uint;
pub const VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY:
    VkShaderFloatControlsIndependence = 0;
pub const VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL:
    VkShaderFloatControlsIndependence = 1;
pub const VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE:
    VkShaderFloatControlsIndependence = 2;
pub const VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY_KHR : VkShaderFloatControlsIndependence = 0 ;
pub const VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL_KHR:
    VkShaderFloatControlsIndependence = 1;
pub const VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE_KHR:
    VkShaderFloatControlsIndependence = 2;
pub const VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_MAX_ENUM:
    VkShaderFloatControlsIndependence = 2147483647;
pub type VkShaderFloatControlsIndependence = ::std::os::raw::c_uint;
pub const VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE:
    VkSamplerReductionMode = 0;
pub const VK_SAMPLER_REDUCTION_MODE_MIN: VkSamplerReductionMode = 1;
pub const VK_SAMPLER_REDUCTION_MODE_MAX: VkSamplerReductionMode = 2;
pub const VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_EXT:
    VkSamplerReductionMode = 0;
pub const VK_SAMPLER_REDUCTION_MODE_MIN_EXT: VkSamplerReductionMode = 1;
pub const VK_SAMPLER_REDUCTION_MODE_MAX_EXT: VkSamplerReductionMode = 2;
pub const VK_SAMPLER_REDUCTION_MODE_MAX_ENUM: VkSamplerReductionMode =
    2147483647;
pub type VkSamplerReductionMode = ::std::os::raw::c_uint;
pub const VK_SEMAPHORE_TYPE_BINARY: VkSemaphoreType = 0;
pub const VK_SEMAPHORE_TYPE_TIMELINE: VkSemaphoreType = 1;
pub const VK_SEMAPHORE_TYPE_BINARY_KHR: VkSemaphoreType = 0;
pub const VK_SEMAPHORE_TYPE_TIMELINE_KHR: VkSemaphoreType = 1;
pub const VK_SEMAPHORE_TYPE_MAX_ENUM: VkSemaphoreType = 2147483647;
pub type VkSemaphoreType = ::std::os::raw::c_uint;
pub const VK_RESOLVE_MODE_NONE: VkResolveModeFlagBits = 0;
pub const VK_RESOLVE_MODE_SAMPLE_ZERO_BIT: VkResolveModeFlagBits = 1;
pub const VK_RESOLVE_MODE_AVERAGE_BIT: VkResolveModeFlagBits = 2;
pub const VK_RESOLVE_MODE_MIN_BIT: VkResolveModeFlagBits = 4;
pub const VK_RESOLVE_MODE_MAX_BIT: VkResolveModeFlagBits = 8;
pub const VK_RESOLVE_MODE_NONE_KHR: VkResolveModeFlagBits = 0;
pub const VK_RESOLVE_MODE_SAMPLE_ZERO_BIT_KHR: VkResolveModeFlagBits = 1;
pub const VK_RESOLVE_MODE_AVERAGE_BIT_KHR: VkResolveModeFlagBits = 2;
pub const VK_RESOLVE_MODE_MIN_BIT_KHR: VkResolveModeFlagBits = 4;
pub const VK_RESOLVE_MODE_MAX_BIT_KHR: VkResolveModeFlagBits = 8;
pub const VK_RESOLVE_MODE_FLAG_BITS_MAX_ENUM: VkResolveModeFlagBits =
    2147483647;
pub type VkResolveModeFlagBits = ::std::os::raw::c_uint;
pub type VkResolveModeFlags = VkFlags;
pub const VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT:
    VkDescriptorBindingFlagBits = 1;
pub const VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT:
    VkDescriptorBindingFlagBits = 2;
pub const VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT:
    VkDescriptorBindingFlagBits = 4;
pub const VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT:
    VkDescriptorBindingFlagBits = 8;
pub const VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT_EXT:
    VkDescriptorBindingFlagBits = 1;
pub const VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT_EXT:
    VkDescriptorBindingFlagBits = 2;
pub const VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT_EXT:
    VkDescriptorBindingFlagBits = 4;
pub const VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT_EXT:
    VkDescriptorBindingFlagBits = 8;
pub const VK_DESCRIPTOR_BINDING_FLAG_BITS_MAX_ENUM:
    VkDescriptorBindingFlagBits = 2147483647;
pub type VkDescriptorBindingFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorBindingFlags = VkFlags;
pub const VK_SEMAPHORE_WAIT_ANY_BIT: VkSemaphoreWaitFlagBits = 1;
pub const VK_SEMAPHORE_WAIT_ANY_BIT_KHR: VkSemaphoreWaitFlagBits = 1;
pub const VK_SEMAPHORE_WAIT_FLAG_BITS_MAX_ENUM: VkSemaphoreWaitFlagBits =
    2147483647;
pub type VkSemaphoreWaitFlagBits = ::std::os::raw::c_uint;
pub type VkSemaphoreWaitFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan11Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer16BitAccess: VkBool32,
    pub uniformAndStorageBuffer16BitAccess: VkBool32,
    pub storagePushConstant16: VkBool32,
    pub storageInputOutput16: VkBool32,
    pub multiview: VkBool32,
    pub multiviewGeometryShader: VkBool32,
    pub multiviewTessellationShader: VkBool32,
    pub variablePointersStorageBuffer: VkBool32,
    pub variablePointers: VkBool32,
    pub protectedMemory: VkBool32,
    pub samplerYcbcrConversion: VkBool32,
    pub shaderDrawParameters: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan11Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceUUID: [u8; 16usize],
    pub driverUUID: [u8; 16usize],
    pub deviceLUID: [u8; 8usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: VkBool32,
    pub subgroupSize: u32,
    pub subgroupSupportedStages: VkShaderStageFlags,
    pub subgroupSupportedOperations: VkSubgroupFeatureFlags,
    pub subgroupQuadOperationsInAllStages: VkBool32,
    pub pointClippingBehavior: VkPointClippingBehavior,
    pub maxMultiviewViewCount: u32,
    pub maxMultiviewInstanceIndex: u32,
    pub protectedNoFault: VkBool32,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan12Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub samplerMirrorClampToEdge: VkBool32,
    pub drawIndirectCount: VkBool32,
    pub storageBuffer8BitAccess: VkBool32,
    pub uniformAndStorageBuffer8BitAccess: VkBool32,
    pub storagePushConstant8: VkBool32,
    pub shaderBufferInt64Atomics: VkBool32,
    pub shaderSharedInt64Atomics: VkBool32,
    pub shaderFloat16: VkBool32,
    pub shaderInt8: VkBool32,
    pub descriptorIndexing: VkBool32,
    pub shaderInputAttachmentArrayDynamicIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderUniformBufferArrayNonUniformIndexing: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexing: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexing: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: VkBool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingSampledImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUpdateUnusedWhilePending: VkBool32,
    pub descriptorBindingPartiallyBound: VkBool32,
    pub descriptorBindingVariableDescriptorCount: VkBool32,
    pub runtimeDescriptorArray: VkBool32,
    pub samplerFilterMinmax: VkBool32,
    pub scalarBlockLayout: VkBool32,
    pub imagelessFramebuffer: VkBool32,
    pub uniformBufferStandardLayout: VkBool32,
    pub shaderSubgroupExtendedTypes: VkBool32,
    pub separateDepthStencilLayouts: VkBool32,
    pub hostQueryReset: VkBool32,
    pub timelineSemaphore: VkBool32,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
    pub vulkanMemoryModel: VkBool32,
    pub vulkanMemoryModelDeviceScope: VkBool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: VkBool32,
    pub shaderOutputViewportIndex: VkBool32,
    pub shaderOutputLayer: VkBool32,
    pub subgroupBroadcastDynamicId: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan12Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub driverID: VkDriverId,
    pub driverName: [::std::os::raw::c_char; 256usize],
    pub driverInfo: [::std::os::raw::c_char; 256usize],
    pub conformanceVersion: VkConformanceVersion,
    pub denormBehaviorIndependence: VkShaderFloatControlsIndependence,
    pub roundingModeIndependence: VkShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat32: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat64: VkBool32,
    pub shaderDenormPreserveFloat16: VkBool32,
    pub shaderDenormPreserveFloat32: VkBool32,
    pub shaderDenormPreserveFloat64: VkBool32,
    pub shaderDenormFlushToZeroFloat16: VkBool32,
    pub shaderDenormFlushToZeroFloat32: VkBool32,
    pub shaderDenormFlushToZeroFloat64: VkBool32,
    pub shaderRoundingModeRTEFloat16: VkBool32,
    pub shaderRoundingModeRTEFloat32: VkBool32,
    pub shaderRoundingModeRTEFloat64: VkBool32,
    pub shaderRoundingModeRTZFloat16: VkBool32,
    pub shaderRoundingModeRTZFloat32: VkBool32,
    pub shaderRoundingModeRTZFloat64: VkBool32,
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: VkBool32,
    pub robustBufferAccessUpdateAfterBind: VkBool32,
    pub quadDivergentImplicitLod: VkBool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
    pub supportedDepthResolveModes: VkResolveModeFlags,
    pub supportedStencilResolveModes: VkResolveModeFlags,
    pub independentResolveNone: VkBool32,
    pub independentResolve: VkBool32,
    pub filterMinmaxSingleComponentFormats: VkBool32,
    pub filterMinmaxImageComponentMapping: VkBool32,
    pub maxTimelineSemaphoreValueDifference: u64,
    pub framebufferIntegerColorSampleCounts: VkSampleCountFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatListCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub viewFormatCount: u32,
    pub pViewFormats: *const VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescription2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkAttachmentDescriptionFlags,
    pub format: VkFormat,
    pub samples: VkSampleCountFlagBits,
    pub loadOp: VkAttachmentLoadOp,
    pub storeOp: VkAttachmentStoreOp,
    pub stencilLoadOp: VkAttachmentLoadOp,
    pub stencilStoreOp: VkAttachmentStoreOp,
    pub initialLayout: VkImageLayout,
    pub finalLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReference2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachment: u32,
    pub layout: VkImageLayout,
    pub aspectMask: VkImageAspectFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescription2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSubpassDescriptionFlags,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub viewMask: u32,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const VkAttachmentReference2,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const VkAttachmentReference2,
    pub pResolveAttachments: *const VkAttachmentReference2,
    pub pDepthStencilAttachment: *const VkAttachmentReference2,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDependency2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: VkPipelineStageFlags,
    pub dstStageMask: VkPipelineStageFlags,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub dependencyFlags: VkDependencyFlags,
    pub viewOffset: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassCreateInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const VkAttachmentDescription2,
    pub subpassCount: u32,
    pub pSubpasses: *const VkSubpassDescription2,
    pub dependencyCount: u32,
    pub pDependencies: *const VkSubpassDependency2,
    pub correlatedViewMaskCount: u32,
    pub pCorrelatedViewMasks: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub contents: VkSubpassContents,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassEndInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice8BitStorageFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer8BitAccess: VkBool32,
    pub uniformAndStorageBuffer8BitAccess: VkBool32,
    pub storagePushConstant8: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDriverProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub driverID: VkDriverId,
    pub driverName: [::std::os::raw::c_char; 256usize],
    pub driverInfo: [::std::os::raw::c_char; 256usize],
    pub conformanceVersion: VkConformanceVersion,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderAtomicInt64Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderBufferInt64Atomics: VkBool32,
    pub shaderSharedInt64Atomics: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderFloat16Int8Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderFloat16: VkBool32,
    pub shaderInt8: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFloatControlsProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub denormBehaviorIndependence: VkShaderFloatControlsIndependence,
    pub roundingModeIndependence: VkShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat32: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat64: VkBool32,
    pub shaderDenormPreserveFloat16: VkBool32,
    pub shaderDenormPreserveFloat32: VkBool32,
    pub shaderDenormPreserveFloat64: VkBool32,
    pub shaderDenormFlushToZeroFloat16: VkBool32,
    pub shaderDenormFlushToZeroFloat32: VkBool32,
    pub shaderDenormFlushToZeroFloat64: VkBool32,
    pub shaderRoundingModeRTEFloat16: VkBool32,
    pub shaderRoundingModeRTEFloat32: VkBool32,
    pub shaderRoundingModeRTEFloat64: VkBool32,
    pub shaderRoundingModeRTZFloat16: VkBool32,
    pub shaderRoundingModeRTZFloat32: VkBool32,
    pub shaderRoundingModeRTZFloat64: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutBindingFlagsCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub bindingCount: u32,
    pub pBindingFlags: *const VkDescriptorBindingFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDescriptorIndexingFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderInputAttachmentArrayDynamicIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderUniformBufferArrayNonUniformIndexing: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexing: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexing: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: VkBool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingSampledImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUpdateUnusedWhilePending: VkBool32,
    pub descriptorBindingPartiallyBound: VkBool32,
    pub descriptorBindingVariableDescriptorCount: VkBool32,
    pub runtimeDescriptorArray: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDescriptorIndexingProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: VkBool32,
    pub robustBufferAccessUpdateAfterBind: VkBool32,
    pub quadDivergentImplicitLod: VkBool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetVariableDescriptorCountAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub descriptorSetCount: u32,
    pub pDescriptorCounts: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetVariableDescriptorCountLayoutSupport {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxVariableDescriptorCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescriptionDepthStencilResolve {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub depthResolveMode: VkResolveModeFlagBits,
    pub stencilResolveMode: VkResolveModeFlagBits,
    pub pDepthStencilResolveAttachment: *const VkAttachmentReference2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDepthStencilResolveProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supportedDepthResolveModes: VkResolveModeFlags,
    pub supportedStencilResolveModes: VkResolveModeFlags,
    pub independentResolveNone: VkBool32,
    pub independentResolve: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceScalarBlockLayoutFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub scalarBlockLayout: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageStencilUsageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stencilUsage: VkImageUsageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerReductionModeCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub reductionMode: VkSamplerReductionMode,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSamplerFilterMinmaxProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub filterMinmaxSingleComponentFormats: VkBool32,
    pub filterMinmaxImageComponentMapping: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkanMemoryModelFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub vulkanMemoryModel: VkBool32,
    pub vulkanMemoryModelDeviceScope: VkBool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImagelessFramebufferFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imagelessFramebuffer: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferAttachmentImageInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageCreateFlags,
    pub usage: VkImageUsageFlags,
    pub width: u32,
    pub height: u32,
    pub layerCount: u32,
    pub viewFormatCount: u32,
    pub pViewFormats: *const VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferAttachmentsCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentImageInfoCount: u32,
    pub pAttachmentImageInfos: *const VkFramebufferAttachmentImageInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassAttachmentBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentCount: u32,
    pub pAttachments: *const VkImageView,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub uniformBufferStandardLayout: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSubgroupExtendedTypes: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub separateDepthStencilLayouts: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReferenceStencilLayout {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stencilLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescriptionStencilLayout {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stencilInitialLayout: VkImageLayout,
    pub stencilFinalLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceHostQueryResetFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub hostQueryReset: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTimelineSemaphoreFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub timelineSemaphore: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTimelineSemaphoreProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxTimelineSemaphoreValueDifference: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreTypeCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphoreType: VkSemaphoreType,
    pub initialValue: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTimelineSemaphoreSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreValueCount: u32,
    pub pWaitSemaphoreValues: *const u64,
    pub signalSemaphoreValueCount: u32,
    pub pSignalSemaphoreValues: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreWaitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSemaphoreWaitFlags,
    pub semaphoreCount: u32,
    pub pSemaphores: *const VkSemaphore,
    pub pValues: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreSignalInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub value: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBufferDeviceAddressFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferDeviceAddressInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferOpaqueCaptureAddressCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub opaqueCaptureAddress: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryOpaqueCaptureAddressAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub opaqueCaptureAddress: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemoryOpaqueCaptureAddressInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
}
pub type PFN_vkCmdDrawIndirectCount = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    )
;
pub type PFN_vkCmdDrawIndexedIndirectCount = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    )
;
pub type PFN_vkCreateRenderPass2 = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo2,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult
;
pub type PFN_vkCmdBeginRenderPass2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
    )
;
pub type PFN_vkCmdNextSubpass2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    )
;
pub type PFN_vkCmdEndRenderPass2 = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pSubpassEndInfo: *const VkSubpassEndInfo)
;
pub type PFN_vkResetQueryPool = 
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    )
;
pub type PFN_vkGetSemaphoreCounterValue = 
    unsafe extern "C" fn(device: VkDevice, semaphore: VkSemaphore, pValue: *mut u64) -> VkResult
;
pub type PFN_vkWaitSemaphores = 
    unsafe extern "C" fn(
        device: VkDevice,
        pWaitInfo: *const VkSemaphoreWaitInfo,
        timeout: u64,
    ) -> VkResult
;
pub type PFN_vkSignalSemaphore = 
    unsafe extern "C" fn(device: VkDevice, pSignalInfo: *const VkSemaphoreSignalInfo) -> VkResult
;
pub type PFN_vkGetBufferDeviceAddress = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress
;
pub type PFN_vkGetBufferOpaqueCaptureAddress = 
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkBufferDeviceAddressInfo) -> u64
;
pub type PFN_vkGetDeviceMemoryOpaqueCaptureAddress = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64
;
pub type VkFlags64 = u64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPrivateDataSlot_T {
    _unused: [u8; 0],
}
pub type VkPrivateDataSlot = *mut VkPrivateDataSlot_T;
pub const VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT:
    VkPipelineCreationFeedbackFlagBits = 1;
pub const VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT : VkPipelineCreationFeedbackFlagBits = 2 ;
pub const VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT : VkPipelineCreationFeedbackFlagBits = 4 ;
pub const VK_PIPELINE_CREATION_FEEDBACK_VALID_BIT_EXT:
    VkPipelineCreationFeedbackFlagBits = 1;
pub const VK_PIPELINE_CREATION_FEEDBACK_APPLICATION_PIPELINE_CACHE_HIT_BIT_EXT : VkPipelineCreationFeedbackFlagBits = 2 ;
pub const VK_PIPELINE_CREATION_FEEDBACK_BASE_PIPELINE_ACCELERATION_BIT_EXT : VkPipelineCreationFeedbackFlagBits = 4 ;
pub const VK_PIPELINE_CREATION_FEEDBACK_FLAG_BITS_MAX_ENUM:
    VkPipelineCreationFeedbackFlagBits = 2147483647;
pub type VkPipelineCreationFeedbackFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineCreationFeedbackFlags = VkFlags;
pub const VK_TOOL_PURPOSE_VALIDATION_BIT: VkToolPurposeFlagBits = 1;
pub const VK_TOOL_PURPOSE_PROFILING_BIT: VkToolPurposeFlagBits = 2;
pub const VK_TOOL_PURPOSE_TRACING_BIT: VkToolPurposeFlagBits = 4;
pub const VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT: VkToolPurposeFlagBits = 8;
pub const VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT: VkToolPurposeFlagBits = 16;
pub const VK_TOOL_PURPOSE_DEBUG_REPORTING_BIT_EXT: VkToolPurposeFlagBits = 32;
pub const VK_TOOL_PURPOSE_DEBUG_MARKERS_BIT_EXT: VkToolPurposeFlagBits = 64;
pub const VK_TOOL_PURPOSE_VALIDATION_BIT_EXT: VkToolPurposeFlagBits = 1;
pub const VK_TOOL_PURPOSE_PROFILING_BIT_EXT: VkToolPurposeFlagBits = 2;
pub const VK_TOOL_PURPOSE_TRACING_BIT_EXT: VkToolPurposeFlagBits = 4;
pub const VK_TOOL_PURPOSE_ADDITIONAL_FEATURES_BIT_EXT: VkToolPurposeFlagBits =
    8;
pub const VK_TOOL_PURPOSE_MODIFYING_FEATURES_BIT_EXT: VkToolPurposeFlagBits =
    16;
pub const VK_TOOL_PURPOSE_FLAG_BITS_MAX_ENUM: VkToolPurposeFlagBits =
    2147483647;
pub type VkToolPurposeFlagBits = ::std::os::raw::c_uint;
pub type VkToolPurposeFlags = VkFlags;
pub type VkPrivateDataSlotCreateFlags = VkFlags;
pub type VkPipelineStageFlags2 = VkFlags64;
pub type VkPipelineStageFlagBits2 = VkFlags64;
pub const VK_PIPELINE_STAGE_2_NONE: VkPipelineStageFlagBits2 = 0;
pub const VK_PIPELINE_STAGE_2_NONE_KHR: VkPipelineStageFlagBits2 = 0;
pub const VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT: VkPipelineStageFlagBits2 = 1;
pub const VK_PIPELINE_STAGE_2_TOP_OF_PIPE_BIT_KHR: VkPipelineStageFlagBits2 = 1;
pub const VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT: VkPipelineStageFlagBits2 = 2;
pub const VK_PIPELINE_STAGE_2_DRAW_INDIRECT_BIT_KHR: VkPipelineStageFlagBits2 = 2;
pub const VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT: VkPipelineStageFlagBits2 = 4;
pub const VK_PIPELINE_STAGE_2_VERTEX_INPUT_BIT_KHR: VkPipelineStageFlagBits2 = 4;
pub const VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT: VkPipelineStageFlagBits2 = 8;
pub const VK_PIPELINE_STAGE_2_VERTEX_SHADER_BIT_KHR: VkPipelineStageFlagBits2 = 8;
pub const VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT: VkPipelineStageFlagBits2 = 16;
pub const VK_PIPELINE_STAGE_2_TESSELLATION_CONTROL_SHADER_BIT_KHR: VkPipelineStageFlagBits2 = 16;
pub const VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT: VkPipelineStageFlagBits2 = 32;
pub const VK_PIPELINE_STAGE_2_TESSELLATION_EVALUATION_SHADER_BIT_KHR: VkPipelineStageFlagBits2 = 32;
pub const VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT: VkPipelineStageFlagBits2 = 64;
pub const VK_PIPELINE_STAGE_2_GEOMETRY_SHADER_BIT_KHR: VkPipelineStageFlagBits2 = 64;
pub const VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT: VkPipelineStageFlagBits2 = 128;
pub const VK_PIPELINE_STAGE_2_FRAGMENT_SHADER_BIT_KHR: VkPipelineStageFlagBits2 = 128;
pub const VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT: VkPipelineStageFlagBits2 = 256;
pub const VK_PIPELINE_STAGE_2_EARLY_FRAGMENT_TESTS_BIT_KHR: VkPipelineStageFlagBits2 = 256;
pub const VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT: VkPipelineStageFlagBits2 = 512;
pub const VK_PIPELINE_STAGE_2_LATE_FRAGMENT_TESTS_BIT_KHR: VkPipelineStageFlagBits2 = 512;
pub const VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT: VkPipelineStageFlagBits2 = 1024;
pub const VK_PIPELINE_STAGE_2_COLOR_ATTACHMENT_OUTPUT_BIT_KHR: VkPipelineStageFlagBits2 = 1024;
pub const VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT: VkPipelineStageFlagBits2 = 2048;
pub const VK_PIPELINE_STAGE_2_COMPUTE_SHADER_BIT_KHR: VkPipelineStageFlagBits2 = 2048;
pub const VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT: VkPipelineStageFlagBits2 = 4096;
pub const VK_PIPELINE_STAGE_2_ALL_TRANSFER_BIT_KHR: VkPipelineStageFlagBits2 = 4096;
pub const VK_PIPELINE_STAGE_2_TRANSFER_BIT: VkPipelineStageFlagBits2 = 4096;
pub const VK_PIPELINE_STAGE_2_TRANSFER_BIT_KHR: VkPipelineStageFlagBits2 = 4096;
pub const VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT: VkPipelineStageFlagBits2 = 8192;
pub const VK_PIPELINE_STAGE_2_BOTTOM_OF_PIPE_BIT_KHR: VkPipelineStageFlagBits2 = 8192;
pub const VK_PIPELINE_STAGE_2_HOST_BIT: VkPipelineStageFlagBits2 = 16384;
pub const VK_PIPELINE_STAGE_2_HOST_BIT_KHR: VkPipelineStageFlagBits2 = 16384;
pub const VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT: VkPipelineStageFlagBits2 = 32768;
pub const VK_PIPELINE_STAGE_2_ALL_GRAPHICS_BIT_KHR: VkPipelineStageFlagBits2 = 32768;
pub const VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT: VkPipelineStageFlagBits2 = 65536;
pub const VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT_KHR: VkPipelineStageFlagBits2 = 65536;
pub const VK_PIPELINE_STAGE_2_COPY_BIT: VkPipelineStageFlagBits2 = 4294967296;
pub const VK_PIPELINE_STAGE_2_COPY_BIT_KHR: VkPipelineStageFlagBits2 = 4294967296;
pub const VK_PIPELINE_STAGE_2_RESOLVE_BIT: VkPipelineStageFlagBits2 = 8589934592;
pub const VK_PIPELINE_STAGE_2_RESOLVE_BIT_KHR: VkPipelineStageFlagBits2 = 8589934592;
pub const VK_PIPELINE_STAGE_2_BLIT_BIT: VkPipelineStageFlagBits2 = 17179869184;
pub const VK_PIPELINE_STAGE_2_BLIT_BIT_KHR: VkPipelineStageFlagBits2 = 17179869184;
pub const VK_PIPELINE_STAGE_2_CLEAR_BIT: VkPipelineStageFlagBits2 = 34359738368;
pub const VK_PIPELINE_STAGE_2_CLEAR_BIT_KHR: VkPipelineStageFlagBits2 = 34359738368;
pub const VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT: VkPipelineStageFlagBits2 = 68719476736;
pub const VK_PIPELINE_STAGE_2_INDEX_INPUT_BIT_KHR: VkPipelineStageFlagBits2 = 68719476736;
pub const VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT: VkPipelineStageFlagBits2 = 137438953472;
pub const VK_PIPELINE_STAGE_2_VERTEX_ATTRIBUTE_INPUT_BIT_KHR: VkPipelineStageFlagBits2 =
    137438953472;
pub const VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT: VkPipelineStageFlagBits2 =
    274877906944;
pub const VK_PIPELINE_STAGE_2_PRE_RASTERIZATION_SHADERS_BIT_KHR: VkPipelineStageFlagBits2 =
    274877906944;
pub const VK_PIPELINE_STAGE_2_VIDEO_DECODE_BIT_KHR: VkPipelineStageFlagBits2 = 67108864;
pub const VK_PIPELINE_STAGE_2_VIDEO_ENCODE_BIT_KHR: VkPipelineStageFlagBits2 = 134217728;
pub const VK_PIPELINE_STAGE_2_TRANSFORM_FEEDBACK_BIT_EXT: VkPipelineStageFlagBits2 = 16777216;
pub const VK_PIPELINE_STAGE_2_CONDITIONAL_RENDERING_BIT_EXT: VkPipelineStageFlagBits2 = 262144;
pub const VK_PIPELINE_STAGE_2_COMMAND_PREPROCESS_BIT_NV: VkPipelineStageFlagBits2 = 131072;
pub const VK_PIPELINE_STAGE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: VkPipelineStageFlagBits2 =
    4194304;
pub const VK_PIPELINE_STAGE_2_SHADING_RATE_IMAGE_BIT_NV: VkPipelineStageFlagBits2 = 4194304;
pub const VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_KHR: VkPipelineStageFlagBits2 =
    33554432;
pub const VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_KHR: VkPipelineStageFlagBits2 = 2097152;
pub const VK_PIPELINE_STAGE_2_RAY_TRACING_SHADER_BIT_NV: VkPipelineStageFlagBits2 = 2097152;
pub const VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_BUILD_BIT_NV: VkPipelineStageFlagBits2 =
    33554432;
pub const VK_PIPELINE_STAGE_2_FRAGMENT_DENSITY_PROCESS_BIT_EXT: VkPipelineStageFlagBits2 = 8388608;
pub const VK_PIPELINE_STAGE_2_TASK_SHADER_BIT_NV: VkPipelineStageFlagBits2 = 524288;
pub const VK_PIPELINE_STAGE_2_MESH_SHADER_BIT_NV: VkPipelineStageFlagBits2 = 1048576;
pub const VK_PIPELINE_STAGE_2_SUBPASS_SHADING_BIT_HUAWEI: VkPipelineStageFlagBits2 = 549755813888;
pub const VK_PIPELINE_STAGE_2_INVOCATION_MASK_BIT_HUAWEI: VkPipelineStageFlagBits2 = 1099511627776;
pub type VkAccessFlags2 = VkFlags64;
pub type VkAccessFlagBits2 = VkFlags64;
pub const VK_ACCESS_2_NONE: VkAccessFlagBits2 = 0;
pub const VK_ACCESS_2_NONE_KHR: VkAccessFlagBits2 = 0;
pub const VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT: VkAccessFlagBits2 = 1;
pub const VK_ACCESS_2_INDIRECT_COMMAND_READ_BIT_KHR: VkAccessFlagBits2 = 1;
pub const VK_ACCESS_2_INDEX_READ_BIT: VkAccessFlagBits2 = 2;
pub const VK_ACCESS_2_INDEX_READ_BIT_KHR: VkAccessFlagBits2 = 2;
pub const VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT: VkAccessFlagBits2 = 4;
pub const VK_ACCESS_2_VERTEX_ATTRIBUTE_READ_BIT_KHR: VkAccessFlagBits2 = 4;
pub const VK_ACCESS_2_UNIFORM_READ_BIT: VkAccessFlagBits2 = 8;
pub const VK_ACCESS_2_UNIFORM_READ_BIT_KHR: VkAccessFlagBits2 = 8;
pub const VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT: VkAccessFlagBits2 = 16;
pub const VK_ACCESS_2_INPUT_ATTACHMENT_READ_BIT_KHR: VkAccessFlagBits2 = 16;
pub const VK_ACCESS_2_SHADER_READ_BIT: VkAccessFlagBits2 = 32;
pub const VK_ACCESS_2_SHADER_READ_BIT_KHR: VkAccessFlagBits2 = 32;
pub const VK_ACCESS_2_SHADER_WRITE_BIT: VkAccessFlagBits2 = 64;
pub const VK_ACCESS_2_SHADER_WRITE_BIT_KHR: VkAccessFlagBits2 = 64;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT: VkAccessFlagBits2 = 128;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_READ_BIT_KHR: VkAccessFlagBits2 = 128;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT: VkAccessFlagBits2 = 256;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_WRITE_BIT_KHR: VkAccessFlagBits2 = 256;
pub const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT: VkAccessFlagBits2 = 512;
pub const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_READ_BIT_KHR: VkAccessFlagBits2 = 512;
pub const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT: VkAccessFlagBits2 = 1024;
pub const VK_ACCESS_2_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT_KHR: VkAccessFlagBits2 = 1024;
pub const VK_ACCESS_2_TRANSFER_READ_BIT: VkAccessFlagBits2 = 2048;
pub const VK_ACCESS_2_TRANSFER_READ_BIT_KHR: VkAccessFlagBits2 = 2048;
pub const VK_ACCESS_2_TRANSFER_WRITE_BIT: VkAccessFlagBits2 = 4096;
pub const VK_ACCESS_2_TRANSFER_WRITE_BIT_KHR: VkAccessFlagBits2 = 4096;
pub const VK_ACCESS_2_HOST_READ_BIT: VkAccessFlagBits2 = 8192;
pub const VK_ACCESS_2_HOST_READ_BIT_KHR: VkAccessFlagBits2 = 8192;
pub const VK_ACCESS_2_HOST_WRITE_BIT: VkAccessFlagBits2 = 16384;
pub const VK_ACCESS_2_HOST_WRITE_BIT_KHR: VkAccessFlagBits2 = 16384;
pub const VK_ACCESS_2_MEMORY_READ_BIT: VkAccessFlagBits2 = 32768;
pub const VK_ACCESS_2_MEMORY_READ_BIT_KHR: VkAccessFlagBits2 = 32768;
pub const VK_ACCESS_2_MEMORY_WRITE_BIT: VkAccessFlagBits2 = 65536;
pub const VK_ACCESS_2_MEMORY_WRITE_BIT_KHR: VkAccessFlagBits2 = 65536;
pub const VK_ACCESS_2_SHADER_SAMPLED_READ_BIT: VkAccessFlagBits2 = 4294967296;
pub const VK_ACCESS_2_SHADER_SAMPLED_READ_BIT_KHR: VkAccessFlagBits2 = 4294967296;
pub const VK_ACCESS_2_SHADER_STORAGE_READ_BIT: VkAccessFlagBits2 = 8589934592;
pub const VK_ACCESS_2_SHADER_STORAGE_READ_BIT_KHR: VkAccessFlagBits2 = 8589934592;
pub const VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT: VkAccessFlagBits2 = 17179869184;
pub const VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT_KHR: VkAccessFlagBits2 = 17179869184;
pub const VK_ACCESS_2_VIDEO_DECODE_READ_BIT_KHR: VkAccessFlagBits2 = 34359738368;
pub const VK_ACCESS_2_VIDEO_DECODE_WRITE_BIT_KHR: VkAccessFlagBits2 = 68719476736;
pub const VK_ACCESS_2_VIDEO_ENCODE_READ_BIT_KHR: VkAccessFlagBits2 = 137438953472;
pub const VK_ACCESS_2_VIDEO_ENCODE_WRITE_BIT_KHR: VkAccessFlagBits2 = 274877906944;
pub const VK_ACCESS_2_TRANSFORM_FEEDBACK_WRITE_BIT_EXT: VkAccessFlagBits2 = 33554432;
pub const VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT: VkAccessFlagBits2 = 67108864;
pub const VK_ACCESS_2_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT: VkAccessFlagBits2 = 134217728;
pub const VK_ACCESS_2_CONDITIONAL_RENDERING_READ_BIT_EXT: VkAccessFlagBits2 = 1048576;
pub const VK_ACCESS_2_COMMAND_PREPROCESS_READ_BIT_NV: VkAccessFlagBits2 = 131072;
pub const VK_ACCESS_2_COMMAND_PREPROCESS_WRITE_BIT_NV: VkAccessFlagBits2 = 262144;
pub const VK_ACCESS_2_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR: VkAccessFlagBits2 = 8388608;
pub const VK_ACCESS_2_SHADING_RATE_IMAGE_READ_BIT_NV: VkAccessFlagBits2 = 8388608;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_KHR: VkAccessFlagBits2 = 2097152;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_KHR: VkAccessFlagBits2 = 4194304;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_READ_BIT_NV: VkAccessFlagBits2 = 2097152;
pub const VK_ACCESS_2_ACCELERATION_STRUCTURE_WRITE_BIT_NV: VkAccessFlagBits2 = 4194304;
pub const VK_ACCESS_2_FRAGMENT_DENSITY_MAP_READ_BIT_EXT: VkAccessFlagBits2 = 16777216;
pub const VK_ACCESS_2_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT: VkAccessFlagBits2 = 524288;
pub const VK_ACCESS_2_INVOCATION_MASK_READ_BIT_HUAWEI: VkAccessFlagBits2 = 549755813888;
pub const VK_SUBMIT_PROTECTED_BIT: VkSubmitFlagBits = 1;
pub const VK_SUBMIT_PROTECTED_BIT_KHR: VkSubmitFlagBits = 1;
pub const VK_SUBMIT_FLAG_BITS_MAX_ENUM: VkSubmitFlagBits = 2147483647;
pub type VkSubmitFlagBits = ::std::os::raw::c_uint;
pub type VkSubmitFlags = VkFlags;
pub const VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT:
    VkRenderingFlagBits = 1;
pub const VK_RENDERING_SUSPENDING_BIT: VkRenderingFlagBits = 2;
pub const VK_RENDERING_RESUMING_BIT: VkRenderingFlagBits = 4;
pub const VK_RENDERING_CONTENTS_SECONDARY_COMMAND_BUFFERS_BIT_KHR:
    VkRenderingFlagBits = 1;
pub const VK_RENDERING_SUSPENDING_BIT_KHR: VkRenderingFlagBits = 2;
pub const VK_RENDERING_RESUMING_BIT_KHR: VkRenderingFlagBits = 4;
pub const VK_RENDERING_FLAG_BITS_MAX_ENUM: VkRenderingFlagBits = 2147483647;
pub type VkRenderingFlagBits = ::std::os::raw::c_uint;
pub type VkRenderingFlags = VkFlags;
pub type VkFormatFeatureFlags2 = VkFlags64;
pub type VkFormatFeatureFlagBits2 = VkFlags64;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_BIT: VkFormatFeatureFlagBits2 = 1;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_BIT_KHR: VkFormatFeatureFlagBits2 = 1;
pub const VK_FORMAT_FEATURE_2_STORAGE_IMAGE_BIT: VkFormatFeatureFlagBits2 = 2;
pub const VK_FORMAT_FEATURE_2_STORAGE_IMAGE_BIT_KHR: VkFormatFeatureFlagBits2 = 2;
pub const VK_FORMAT_FEATURE_2_STORAGE_IMAGE_ATOMIC_BIT: VkFormatFeatureFlagBits2 = 4;
pub const VK_FORMAT_FEATURE_2_STORAGE_IMAGE_ATOMIC_BIT_KHR: VkFormatFeatureFlagBits2 = 4;
pub const VK_FORMAT_FEATURE_2_UNIFORM_TEXEL_BUFFER_BIT: VkFormatFeatureFlagBits2 = 8;
pub const VK_FORMAT_FEATURE_2_UNIFORM_TEXEL_BUFFER_BIT_KHR: VkFormatFeatureFlagBits2 = 8;
pub const VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_BIT: VkFormatFeatureFlagBits2 = 16;
pub const VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_BIT_KHR: VkFormatFeatureFlagBits2 = 16;
pub const VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_ATOMIC_BIT: VkFormatFeatureFlagBits2 = 32;
pub const VK_FORMAT_FEATURE_2_STORAGE_TEXEL_BUFFER_ATOMIC_BIT_KHR: VkFormatFeatureFlagBits2 = 32;
pub const VK_FORMAT_FEATURE_2_VERTEX_BUFFER_BIT: VkFormatFeatureFlagBits2 = 64;
pub const VK_FORMAT_FEATURE_2_VERTEX_BUFFER_BIT_KHR: VkFormatFeatureFlagBits2 = 64;
pub const VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BIT: VkFormatFeatureFlagBits2 = 128;
pub const VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BIT_KHR: VkFormatFeatureFlagBits2 = 128;
pub const VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BLEND_BIT: VkFormatFeatureFlagBits2 = 256;
pub const VK_FORMAT_FEATURE_2_COLOR_ATTACHMENT_BLEND_BIT_KHR: VkFormatFeatureFlagBits2 = 256;
pub const VK_FORMAT_FEATURE_2_DEPTH_STENCIL_ATTACHMENT_BIT: VkFormatFeatureFlagBits2 = 512;
pub const VK_FORMAT_FEATURE_2_DEPTH_STENCIL_ATTACHMENT_BIT_KHR: VkFormatFeatureFlagBits2 = 512;
pub const VK_FORMAT_FEATURE_2_BLIT_SRC_BIT: VkFormatFeatureFlagBits2 = 1024;
pub const VK_FORMAT_FEATURE_2_BLIT_SRC_BIT_KHR: VkFormatFeatureFlagBits2 = 1024;
pub const VK_FORMAT_FEATURE_2_BLIT_DST_BIT: VkFormatFeatureFlagBits2 = 2048;
pub const VK_FORMAT_FEATURE_2_BLIT_DST_BIT_KHR: VkFormatFeatureFlagBits2 = 2048;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_LINEAR_BIT: VkFormatFeatureFlagBits2 = 4096;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_LINEAR_BIT_KHR: VkFormatFeatureFlagBits2 = 4096;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_CUBIC_BIT: VkFormatFeatureFlagBits2 = 8192;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT: VkFormatFeatureFlagBits2 = 8192;
pub const VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT: VkFormatFeatureFlagBits2 = 16384;
pub const VK_FORMAT_FEATURE_2_TRANSFER_SRC_BIT_KHR: VkFormatFeatureFlagBits2 = 16384;
pub const VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT: VkFormatFeatureFlagBits2 = 32768;
pub const VK_FORMAT_FEATURE_2_TRANSFER_DST_BIT_KHR: VkFormatFeatureFlagBits2 = 32768;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_MINMAX_BIT: VkFormatFeatureFlagBits2 = 65536;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_FILTER_MINMAX_BIT_KHR: VkFormatFeatureFlagBits2 = 65536;
pub const VK_FORMAT_FEATURE_2_MIDPOINT_CHROMA_SAMPLES_BIT: VkFormatFeatureFlagBits2 = 131072;
pub const VK_FORMAT_FEATURE_2_MIDPOINT_CHROMA_SAMPLES_BIT_KHR: VkFormatFeatureFlagBits2 = 131072;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT:
    VkFormatFeatureFlagBits2 = 262144;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR:
    VkFormatFeatureFlagBits2 = 262144;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT:
    VkFormatFeatureFlagBits2 = 524288;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR : VkFormatFeatureFlagBits2 = 524288 ;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT:
    VkFormatFeatureFlagBits2 = 1048576;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR : VkFormatFeatureFlagBits2 = 1048576 ;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT : VkFormatFeatureFlagBits2 = 2097152 ;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR : VkFormatFeatureFlagBits2 = 2097152 ;
pub const VK_FORMAT_FEATURE_2_DISJOINT_BIT: VkFormatFeatureFlagBits2 = 4194304;
pub const VK_FORMAT_FEATURE_2_DISJOINT_BIT_KHR: VkFormatFeatureFlagBits2 = 4194304;
pub const VK_FORMAT_FEATURE_2_COSITED_CHROMA_SAMPLES_BIT: VkFormatFeatureFlagBits2 = 8388608;
pub const VK_FORMAT_FEATURE_2_COSITED_CHROMA_SAMPLES_BIT_KHR: VkFormatFeatureFlagBits2 = 8388608;
pub const VK_FORMAT_FEATURE_2_STORAGE_READ_WITHOUT_FORMAT_BIT: VkFormatFeatureFlagBits2 =
    2147483648;
pub const VK_FORMAT_FEATURE_2_STORAGE_READ_WITHOUT_FORMAT_BIT_KHR: VkFormatFeatureFlagBits2 =
    2147483648;
pub const VK_FORMAT_FEATURE_2_STORAGE_WRITE_WITHOUT_FORMAT_BIT: VkFormatFeatureFlagBits2 =
    4294967296;
pub const VK_FORMAT_FEATURE_2_STORAGE_WRITE_WITHOUT_FORMAT_BIT_KHR: VkFormatFeatureFlagBits2 =
    4294967296;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_DEPTH_COMPARISON_BIT: VkFormatFeatureFlagBits2 =
    8589934592;
pub const VK_FORMAT_FEATURE_2_SAMPLED_IMAGE_DEPTH_COMPARISON_BIT_KHR: VkFormatFeatureFlagBits2 =
    8589934592;
pub const VK_FORMAT_FEATURE_2_VIDEO_DECODE_OUTPUT_BIT_KHR: VkFormatFeatureFlagBits2 = 33554432;
pub const VK_FORMAT_FEATURE_2_VIDEO_DECODE_DPB_BIT_KHR: VkFormatFeatureFlagBits2 = 67108864;
pub const VK_FORMAT_FEATURE_2_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR:
    VkFormatFeatureFlagBits2 = 536870912;
pub const VK_FORMAT_FEATURE_2_FRAGMENT_DENSITY_MAP_BIT_EXT: VkFormatFeatureFlagBits2 = 16777216;
pub const VK_FORMAT_FEATURE_2_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR: VkFormatFeatureFlagBits2 =
    1073741824;
pub const VK_FORMAT_FEATURE_2_VIDEO_ENCODE_INPUT_BIT_KHR: VkFormatFeatureFlagBits2 = 134217728;
pub const VK_FORMAT_FEATURE_2_VIDEO_ENCODE_DPB_BIT_KHR: VkFormatFeatureFlagBits2 = 268435456;
pub const VK_FORMAT_FEATURE_2_LINEAR_COLOR_ATTACHMENT_BIT_NV: VkFormatFeatureFlagBits2 =
    274877906944;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan13Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub robustImageAccess: VkBool32,
    pub inlineUniformBlock: VkBool32,
    pub descriptorBindingInlineUniformBlockUpdateAfterBind: VkBool32,
    pub pipelineCreationCacheControl: VkBool32,
    pub privateData: VkBool32,
    pub shaderDemoteToHelperInvocation: VkBool32,
    pub shaderTerminateInvocation: VkBool32,
    pub subgroupSizeControl: VkBool32,
    pub computeFullSubgroups: VkBool32,
    pub synchronization2: VkBool32,
    pub textureCompressionASTC_HDR: VkBool32,
    pub shaderZeroInitializeWorkgroupMemory: VkBool32,
    pub dynamicRendering: VkBool32,
    pub shaderIntegerDotProduct: VkBool32,
    pub maintenance4: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan13Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minSubgroupSize: u32,
    pub maxSubgroupSize: u32,
    pub maxComputeWorkgroupSubgroups: u32,
    pub requiredSubgroupSizeStages: VkShaderStageFlags,
    pub maxInlineUniformBlockSize: u32,
    pub maxPerStageDescriptorInlineUniformBlocks: u32,
    pub maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks: u32,
    pub maxDescriptorSetInlineUniformBlocks: u32,
    pub maxDescriptorSetUpdateAfterBindInlineUniformBlocks: u32,
    pub maxInlineUniformTotalSize: u32,
    pub integerDotProduct8BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct8BitSignedAccelerated: VkBool32,
    pub integerDotProduct8BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct4x8BitPackedUnsignedAccelerated: VkBool32,
    pub integerDotProduct4x8BitPackedSignedAccelerated: VkBool32,
    pub integerDotProduct4x8BitPackedMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct16BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct16BitSignedAccelerated: VkBool32,
    pub integerDotProduct16BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct32BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct32BitSignedAccelerated: VkBool32,
    pub integerDotProduct32BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct64BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct64BitSignedAccelerated: VkBool32,
    pub integerDotProduct64BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating8BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating8BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating16BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating16BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating32BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating32BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating64BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating64BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated: VkBool32,
    pub storageTexelBufferOffsetAlignmentBytes: VkDeviceSize,
    pub storageTexelBufferOffsetSingleTexelAlignment: VkBool32,
    pub uniformTexelBufferOffsetAlignmentBytes: VkDeviceSize,
    pub uniformTexelBufferOffsetSingleTexelAlignment: VkBool32,
    pub maxBufferSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCreationFeedback {
    pub flags: VkPipelineCreationFeedbackFlags,
    pub duration: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCreationFeedbackCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pPipelineCreationFeedback: *mut VkPipelineCreationFeedback,
    pub pipelineStageCreationFeedbackCount: u32,
    pub pPipelineStageCreationFeedbacks: *mut VkPipelineCreationFeedback,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderTerminateInvocationFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderTerminateInvocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceToolProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub name: [::std::os::raw::c_char; 256usize],
    pub version: [::std::os::raw::c_char; 256usize],
    pub purposes: VkToolPurposeFlags,
    pub description: [::std::os::raw::c_char; 256usize],
    pub layer: [::std::os::raw::c_char; 256usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderDemoteToHelperInvocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePrivateDataFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub privateData: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDevicePrivateDataCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub privateDataSlotRequestCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPrivateDataSlotCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPrivateDataSlotCreateFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePipelineCreationCacheControlFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pipelineCreationCacheControl: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryBarrier2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcStageMask: VkPipelineStageFlags2,
    pub srcAccessMask: VkAccessFlags2,
    pub dstStageMask: VkPipelineStageFlags2,
    pub dstAccessMask: VkAccessFlags2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryBarrier2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcStageMask: VkPipelineStageFlags2,
    pub srcAccessMask: VkAccessFlags2,
    pub dstStageMask: VkPipelineStageFlags2,
    pub dstAccessMask: VkAccessFlags2,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryBarrier2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcStageMask: VkPipelineStageFlags2,
    pub srcAccessMask: VkAccessFlags2,
    pub dstStageMask: VkPipelineStageFlags2,
    pub dstAccessMask: VkAccessFlags2,
    pub oldLayout: VkImageLayout,
    pub newLayout: VkImageLayout,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub image: VkImage,
    pub subresourceRange: VkImageSubresourceRange,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDependencyInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dependencyFlags: VkDependencyFlags,
    pub memoryBarrierCount: u32,
    pub pMemoryBarriers: *const VkMemoryBarrier2,
    pub bufferMemoryBarrierCount: u32,
    pub pBufferMemoryBarriers: *const VkBufferMemoryBarrier2,
    pub imageMemoryBarrierCount: u32,
    pub pImageMemoryBarriers: *const VkImageMemoryBarrier2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub value: u64,
    pub stageMask: VkPipelineStageFlags2,
    pub deviceIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub commandBuffer: VkCommandBuffer,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubmitInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSubmitFlags,
    pub waitSemaphoreInfoCount: u32,
    pub pWaitSemaphoreInfos: *const VkSemaphoreSubmitInfo,
    pub commandBufferInfoCount: u32,
    pub pCommandBufferInfos: *const VkCommandBufferSubmitInfo,
    pub signalSemaphoreInfoCount: u32,
    pub pSignalSemaphoreInfos: *const VkSemaphoreSubmitInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSynchronization2Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub synchronization2: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderZeroInitializeWorkgroupMemory: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageRobustnessFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub robustImageAccess: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCopy2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcOffset: VkDeviceSize,
    pub dstOffset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyBufferInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcBuffer: VkBuffer,
    pub dstBuffer: VkBuffer,
    pub regionCount: u32,
    pub pRegions: *const VkBufferCopy2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCopy2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyImageInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkImageCopy2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferImageCopy2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub bufferOffset: VkDeviceSize,
    pub bufferRowLength: u32,
    pub bufferImageHeight: u32,
    pub imageSubresource: VkImageSubresourceLayers,
    pub imageOffset: VkOffset3D,
    pub imageExtent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyBufferToImageInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcBuffer: VkBuffer,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkBufferImageCopy2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyImageToBufferInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstBuffer: VkBuffer,
    pub regionCount: u32,
    pub pRegions: *const VkBufferImageCopy2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageBlit2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffsets: [VkOffset3D; 2usize],
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffsets: [VkOffset3D; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBlitImageInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkImageBlit2,
    pub filter: VkFilter,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageResolve2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkResolveImageInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcImage: VkImage,
    pub srcImageLayout: VkImageLayout,
    pub dstImage: VkImage,
    pub dstImageLayout: VkImageLayout,
    pub regionCount: u32,
    pub pRegions: *const VkImageResolve2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubgroupSizeControlFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subgroupSizeControl: VkBool32,
    pub computeFullSubgroups: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubgroupSizeControlProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minSubgroupSize: u32,
    pub maxSubgroupSize: u32,
    pub maxComputeWorkgroupSubgroups: u32,
    pub requiredSubgroupSizeStages: VkShaderStageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineShaderStageRequiredSubgroupSizeCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub requiredSubgroupSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceInlineUniformBlockFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub inlineUniformBlock: VkBool32,
    pub descriptorBindingInlineUniformBlockUpdateAfterBind: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceInlineUniformBlockProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxInlineUniformBlockSize: u32,
    pub maxPerStageDescriptorInlineUniformBlocks: u32,
    pub maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks: u32,
    pub maxDescriptorSetInlineUniformBlocks: u32,
    pub maxDescriptorSetUpdateAfterBindInlineUniformBlocks: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSetInlineUniformBlock {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dataSize: u32,
    pub pData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolInlineUniformBlockCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxInlineUniformBlockBindings: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTextureCompressionASTCHDRFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub textureCompressionASTC_HDR: VkBool32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkRenderingAttachmentInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub imageView: VkImageView,
    pub imageLayout: VkImageLayout,
    pub resolveMode: VkResolveModeFlagBits,
    pub resolveImageView: VkImageView,
    pub resolveImageLayout: VkImageLayout,
    pub loadOp: VkAttachmentLoadOp,
    pub storeOp: VkAttachmentStoreOp,
    pub clearValue: VkClearValue,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderingInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderingFlags,
    pub renderArea: VkRect2D,
    pub layerCount: u32,
    pub viewMask: u32,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const VkRenderingAttachmentInfo,
    pub pDepthAttachment: *const VkRenderingAttachmentInfo,
    pub pStencilAttachment: *const VkRenderingAttachmentInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRenderingCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub viewMask: u32,
    pub colorAttachmentCount: u32,
    pub pColorAttachmentFormats: *const VkFormat,
    pub depthAttachmentFormat: VkFormat,
    pub stencilAttachmentFormat: VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDynamicRenderingFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub dynamicRendering: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceRenderingInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderingFlags,
    pub viewMask: u32,
    pub colorAttachmentCount: u32,
    pub pColorAttachmentFormats: *const VkFormat,
    pub depthAttachmentFormat: VkFormat,
    pub stencilAttachmentFormat: VkFormat,
    pub rasterizationSamples: VkSampleCountFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderIntegerDotProductFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderIntegerDotProduct: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderIntegerDotProductProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub integerDotProduct8BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct8BitSignedAccelerated: VkBool32,
    pub integerDotProduct8BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct4x8BitPackedUnsignedAccelerated: VkBool32,
    pub integerDotProduct4x8BitPackedSignedAccelerated: VkBool32,
    pub integerDotProduct4x8BitPackedMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct16BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct16BitSignedAccelerated: VkBool32,
    pub integerDotProduct16BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct32BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct32BitSignedAccelerated: VkBool32,
    pub integerDotProduct32BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProduct64BitUnsignedAccelerated: VkBool32,
    pub integerDotProduct64BitSignedAccelerated: VkBool32,
    pub integerDotProduct64BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating8BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating8BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating16BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating16BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating32BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating32BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating64BitUnsignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating64BitSignedAccelerated: VkBool32,
    pub integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTexelBufferAlignmentProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageTexelBufferOffsetAlignmentBytes: VkDeviceSize,
    pub storageTexelBufferOffsetSingleTexelAlignment: VkBool32,
    pub uniformTexelBufferOffsetAlignmentBytes: VkDeviceSize,
    pub uniformTexelBufferOffsetSingleTexelAlignment: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFormatProperties3 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub linearTilingFeatures: VkFormatFeatureFlags2,
    pub optimalTilingFeatures: VkFormatFeatureFlags2,
    pub bufferFeatures: VkFormatFeatureFlags2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMaintenance4Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maintenance4: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMaintenance4Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxBufferSize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceBufferMemoryRequirements {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pCreateInfo: *const VkBufferCreateInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceImageMemoryRequirements {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pCreateInfo: *const VkImageCreateInfo,
    pub planeAspect: VkImageAspectFlagBits,
}
pub type PFN_vkGetPhysicalDeviceToolProperties = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pToolCount: *mut u32,
        pToolProperties: *mut VkPhysicalDeviceToolProperties,
    ) -> VkResult
;
pub type PFN_vkCreatePrivateDataSlot = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPrivateDataSlotCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPrivateDataSlot: *mut VkPrivateDataSlot,
    ) -> VkResult
;
pub type PFN_vkDestroyPrivateDataSlot = 
    unsafe extern "C" fn(
        device: VkDevice,
        privateDataSlot: VkPrivateDataSlot,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkSetPrivateData = 
    unsafe extern "C" fn(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlot,
        data: u64,
    ) -> VkResult
;
pub type PFN_vkGetPrivateData = 
    unsafe extern "C" fn(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlot,
        pData: *mut u64,
    )
;
pub type PFN_vkCmdSetEvent2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        pDependencyInfo: *const VkDependencyInfo,
    )
;
pub type PFN_vkCmdResetEvent2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags2,
    )
;
pub type PFN_vkCmdWaitEvents2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        pDependencyInfos: *const VkDependencyInfo,
    )
;
pub type PFN_vkCmdPipelineBarrier2 = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pDependencyInfo: *const VkDependencyInfo)
;
pub type PFN_vkCmdWriteTimestamp2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        stage: VkPipelineStageFlags2,
        queryPool: VkQueryPool,
        query: u32,
    )
;
pub type PFN_vkQueueSubmit2 = 
    unsafe extern "C" fn(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo2,
        fence: VkFence,
    ) -> VkResult
;
pub type PFN_vkCmdCopyBuffer2 = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pCopyBufferInfo: *const VkCopyBufferInfo2)
;
pub type PFN_vkCmdCopyImage2 = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pCopyImageInfo: *const VkCopyImageInfo2)
;
pub type PFN_vkCmdCopyBufferToImage2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyBufferToImageInfo: *const VkCopyBufferToImageInfo2,
    )
;
pub type PFN_vkCmdCopyImageToBuffer2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyImageToBufferInfo: *const VkCopyImageToBufferInfo2,
    )
;
pub type PFN_vkCmdBlitImage2 = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pBlitImageInfo: *const VkBlitImageInfo2)
;
pub type PFN_vkCmdResolveImage2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pResolveImageInfo: *const VkResolveImageInfo2,
    )
;
pub type PFN_vkCmdBeginRendering = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pRenderingInfo: *const VkRenderingInfo)
;
pub type PFN_vkCmdEndRendering =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer);
pub type PFN_vkCmdSetCullMode = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, cullMode: VkCullModeFlags)
;
pub type PFN_vkCmdSetFrontFace = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, frontFace: VkFrontFace)
;
pub type PFN_vkCmdSetPrimitiveTopology = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, primitiveTopology: VkPrimitiveTopology)
;
pub type PFN_vkCmdSetViewportWithCount = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        viewportCount: u32,
        pViewports: *const VkViewport,
    )
;
pub type PFN_vkCmdSetScissorWithCount = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    )
;
pub type PFN_vkCmdBindVertexBuffers2 = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
        pSizes: *const VkDeviceSize,
        pStrides: *const VkDeviceSize,
    )
;
pub type PFN_vkCmdSetDepthTestEnable = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthTestEnable: VkBool32)
;
pub type PFN_vkCmdSetDepthWriteEnable = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthWriteEnable: VkBool32)
;
pub type PFN_vkCmdSetDepthCompareOp = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthCompareOp: VkCompareOp)
;
pub type PFN_vkCmdSetDepthBoundsTestEnable = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthBoundsTestEnable: VkBool32)
;
pub type PFN_vkCmdSetStencilTestEnable = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, stencilTestEnable: VkBool32)
;
pub type PFN_vkCmdSetStencilOp = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        failOp: VkStencilOp,
        passOp: VkStencilOp,
        depthFailOp: VkStencilOp,
        compareOp: VkCompareOp,
    )
;
pub type PFN_vkCmdSetRasterizerDiscardEnable = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, rasterizerDiscardEnable: VkBool32)
;
pub type PFN_vkCmdSetDepthBiasEnable = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthBiasEnable: VkBool32)
;
pub type PFN_vkCmdSetPrimitiveRestartEnable = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, primitiveRestartEnable: VkBool32)
;
pub type PFN_vkGetDeviceBufferMemoryRequirements = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceBufferMemoryRequirements,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetDeviceImageMemoryRequirements = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceImageMemoryRequirements,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetDeviceImageSparseMemoryRequirements = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceImageMemoryRequirements,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceKHR_T {
    _unused: [u8; 0],
}
pub type VkSurfaceKHR = *mut VkSurfaceKHR_T;
pub const VK_PRESENT_MODE_IMMEDIATE_KHR: VkPresentModeKHR = 0;
pub const VK_PRESENT_MODE_MAILBOX_KHR: VkPresentModeKHR = 1;
pub const VK_PRESENT_MODE_FIFO_KHR: VkPresentModeKHR = 2;
pub const VK_PRESENT_MODE_FIFO_RELAXED_KHR: VkPresentModeKHR = 3;
pub const VK_PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR: VkPresentModeKHR = 1000111000;
pub const VK_PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR: VkPresentModeKHR =
    1000111001;
pub const VK_PRESENT_MODE_MAX_ENUM_KHR: VkPresentModeKHR = 2147483647;
pub type VkPresentModeKHR = ::std::os::raw::c_uint;
pub const VK_COLOR_SPACE_SRGB_NONLINEAR_KHR: VkColorSpaceKHR = 0;
pub const VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT: VkColorSpaceKHR = 1000104001;
pub const VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT: VkColorSpaceKHR = 1000104002;
pub const VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT: VkColorSpaceKHR = 1000104003;
pub const VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT: VkColorSpaceKHR = 1000104004;
pub const VK_COLOR_SPACE_BT709_LINEAR_EXT: VkColorSpaceKHR = 1000104005;
pub const VK_COLOR_SPACE_BT709_NONLINEAR_EXT: VkColorSpaceKHR = 1000104006;
pub const VK_COLOR_SPACE_BT2020_LINEAR_EXT: VkColorSpaceKHR = 1000104007;
pub const VK_COLOR_SPACE_HDR10_ST2084_EXT: VkColorSpaceKHR = 1000104008;
pub const VK_COLOR_SPACE_DOLBYVISION_EXT: VkColorSpaceKHR = 1000104009;
pub const VK_COLOR_SPACE_HDR10_HLG_EXT: VkColorSpaceKHR = 1000104010;
pub const VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT: VkColorSpaceKHR = 1000104011;
pub const VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT: VkColorSpaceKHR = 1000104012;
pub const VK_COLOR_SPACE_PASS_THROUGH_EXT: VkColorSpaceKHR = 1000104013;
pub const VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT: VkColorSpaceKHR = 1000104014;
pub const VK_COLOR_SPACE_DISPLAY_NATIVE_AMD: VkColorSpaceKHR = 1000213000;
pub const VK_COLORSPACE_SRGB_NONLINEAR_KHR: VkColorSpaceKHR = 0;
pub const VK_COLOR_SPACE_DCI_P3_LINEAR_EXT: VkColorSpaceKHR = 1000104003;
pub const VK_COLOR_SPACE_MAX_ENUM_KHR: VkColorSpaceKHR = 2147483647;
pub type VkColorSpaceKHR = ::std::os::raw::c_uint;
pub const VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 1;
pub const VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 2;
pub const VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 4;
pub const VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 8;
pub const VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 16;
pub const VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 32;
pub const VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR : VkSurfaceTransformFlagBitsKHR = 64 ;
pub const VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR : VkSurfaceTransformFlagBitsKHR = 128 ;
pub const VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR:
    VkSurfaceTransformFlagBitsKHR = 256;
pub const VK_SURFACE_TRANSFORM_FLAG_BITS_MAX_ENUM_KHR:
    VkSurfaceTransformFlagBitsKHR = 2147483647;
pub type VkSurfaceTransformFlagBitsKHR = ::std::os::raw::c_uint;
pub const VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 1;
pub const VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 2;
pub const VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 4;
pub const VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR:
    VkCompositeAlphaFlagBitsKHR = 8;
pub const VK_COMPOSITE_ALPHA_FLAG_BITS_MAX_ENUM_KHR:
    VkCompositeAlphaFlagBitsKHR = 2147483647;
pub type VkCompositeAlphaFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkCompositeAlphaFlagsKHR = VkFlags;
pub type VkSurfaceTransformFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceCapabilitiesKHR {
    pub minImageCount: u32,
    pub maxImageCount: u32,
    pub currentExtent: VkExtent2D,
    pub minImageExtent: VkExtent2D,
    pub maxImageExtent: VkExtent2D,
    pub maxImageArrayLayers: u32,
    pub supportedTransforms: VkSurfaceTransformFlagsKHR,
    pub currentTransform: VkSurfaceTransformFlagBitsKHR,
    pub supportedCompositeAlpha: VkCompositeAlphaFlagsKHR,
    pub supportedUsageFlags: VkImageUsageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceFormatKHR {
    pub format: VkFormat,
    pub colorSpace: VkColorSpaceKHR,
}
pub type PFN_vkDestroySurfaceKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        surface: VkSurfaceKHR,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetPhysicalDeviceSurfaceSupportKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        surface: VkSurfaceKHR,
        pSupported: *mut VkBool32,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilitiesKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceSurfaceFormatsKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut VkSurfaceFormatKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceSurfacePresentModesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pPresentModeCount: *mut u32,
        pPresentModes: *mut VkPresentModeKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainKHR_T {
    _unused: [u8; 0],
}
pub type VkSwapchainKHR = *mut VkSwapchainKHR_T;
pub const VK_SWAPCHAIN_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR:
    VkSwapchainCreateFlagBitsKHR = 1;
pub const VK_SWAPCHAIN_CREATE_PROTECTED_BIT_KHR:
    VkSwapchainCreateFlagBitsKHR = 2;
pub const VK_SWAPCHAIN_CREATE_MUTABLE_FORMAT_BIT_KHR:
    VkSwapchainCreateFlagBitsKHR = 4;
pub const VK_SWAPCHAIN_CREATE_FLAG_BITS_MAX_ENUM_KHR:
    VkSwapchainCreateFlagBitsKHR = 2147483647;
pub type VkSwapchainCreateFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkSwapchainCreateFlagsKHR = VkFlags;
pub const VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_BIT_KHR:
    VkDeviceGroupPresentModeFlagBitsKHR = 1;
pub const VK_DEVICE_GROUP_PRESENT_MODE_REMOTE_BIT_KHR:
    VkDeviceGroupPresentModeFlagBitsKHR = 2;
pub const VK_DEVICE_GROUP_PRESENT_MODE_SUM_BIT_KHR:
    VkDeviceGroupPresentModeFlagBitsKHR = 4;
pub const VK_DEVICE_GROUP_PRESENT_MODE_LOCAL_MULTI_DEVICE_BIT_KHR : VkDeviceGroupPresentModeFlagBitsKHR = 8 ;
pub const VK_DEVICE_GROUP_PRESENT_MODE_FLAG_BITS_MAX_ENUM_KHR : VkDeviceGroupPresentModeFlagBitsKHR = 2147483647 ;
pub type VkDeviceGroupPresentModeFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkDeviceGroupPresentModeFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSwapchainCreateFlagsKHR,
    pub surface: VkSurfaceKHR,
    pub minImageCount: u32,
    pub imageFormat: VkFormat,
    pub imageColorSpace: VkColorSpaceKHR,
    pub imageExtent: VkExtent2D,
    pub imageArrayLayers: u32,
    pub imageUsage: VkImageUsageFlags,
    pub imageSharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
    pub preTransform: VkSurfaceTransformFlagBitsKHR,
    pub compositeAlpha: VkCompositeAlphaFlagBitsKHR,
    pub presentMode: VkPresentModeKHR,
    pub clipped: VkBool32,
    pub oldSwapchain: VkSwapchainKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub swapchainCount: u32,
    pub pSwapchains: *const VkSwapchainKHR,
    pub pImageIndices: *const u32,
    pub pResults: *mut VkResult,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSwapchainCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchain: VkSwapchainKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemorySwapchainInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchain: VkSwapchainKHR,
    pub imageIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAcquireNextImageInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchain: VkSwapchainKHR,
    pub timeout: u64,
    pub semaphore: VkSemaphore,
    pub fence: VkFence,
    pub deviceMask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupPresentCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub presentMask: [u32; 32usize],
    pub modes: VkDeviceGroupPresentModeFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupPresentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchainCount: u32,
    pub pDeviceMasks: *const u32,
    pub mode: VkDeviceGroupPresentModeFlagBitsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupSwapchainCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub modes: VkDeviceGroupPresentModeFlagsKHR,
}
pub type PFN_vkCreateSwapchainKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSwapchainCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSwapchain: *mut VkSwapchainKHR,
    ) -> VkResult
;
pub type PFN_vkDestroySwapchainKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetSwapchainImagesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pSwapchainImageCount: *mut u32,
        pSwapchainImages: *mut VkImage,
    ) -> VkResult
;
pub type PFN_vkAcquireNextImageKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        timeout: u64,
        semaphore: VkSemaphore,
        fence: VkFence,
        pImageIndex: *mut u32,
    ) -> VkResult
;
pub type PFN_vkQueuePresentKHR = 
    unsafe extern "C" fn(queue: VkQueue, pPresentInfo: *const VkPresentInfoKHR) -> VkResult
;
pub type PFN_vkGetDeviceGroupPresentCapabilitiesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pDeviceGroupPresentCapabilities: *mut VkDeviceGroupPresentCapabilitiesKHR,
    ) -> VkResult
;
pub type PFN_vkGetDeviceGroupSurfacePresentModesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        surface: VkSurfaceKHR,
        pModes: *mut VkDeviceGroupPresentModeFlagsKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDevicePresentRectanglesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pRectCount: *mut u32,
        pRects: *mut VkRect2D,
    ) -> VkResult
;
pub type PFN_vkAcquireNextImage2KHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pAcquireInfo: *const VkAcquireNextImageInfoKHR,
        pImageIndex: *mut u32,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayKHR_T {
    _unused: [u8; 0],
}
pub type VkDisplayKHR = *mut VkDisplayKHR_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeKHR_T {
    _unused: [u8; 0],
}
pub type VkDisplayModeKHR = *mut VkDisplayModeKHR_T;
pub type VkDisplayModeCreateFlagsKHR = VkFlags;
pub const VK_DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 1;
pub const VK_DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 2;
pub const VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 4;
pub const VK_DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 8;
pub const VK_DISPLAY_PLANE_ALPHA_FLAG_BITS_MAX_ENUM_KHR:
    VkDisplayPlaneAlphaFlagBitsKHR = 2147483647;
pub type VkDisplayPlaneAlphaFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkDisplayPlaneAlphaFlagsKHR = VkFlags;
pub type VkDisplaySurfaceCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeParametersKHR {
    pub visibleRegion: VkExtent2D,
    pub refreshRate: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDisplayModeCreateFlagsKHR,
    pub parameters: VkDisplayModeParametersKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModePropertiesKHR {
    pub displayMode: VkDisplayModeKHR,
    pub parameters: VkDisplayModeParametersKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneCapabilitiesKHR {
    pub supportedAlpha: VkDisplayPlaneAlphaFlagsKHR,
    pub minSrcPosition: VkOffset2D,
    pub maxSrcPosition: VkOffset2D,
    pub minSrcExtent: VkExtent2D,
    pub maxSrcExtent: VkExtent2D,
    pub minDstPosition: VkOffset2D,
    pub maxDstPosition: VkOffset2D,
    pub minDstExtent: VkExtent2D,
    pub maxDstExtent: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlanePropertiesKHR {
    pub currentDisplay: VkDisplayKHR,
    pub currentStackIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPropertiesKHR {
    pub display: VkDisplayKHR,
    pub displayName: *const ::std::os::raw::c_char,
    pub physicalDimensions: VkExtent2D,
    pub physicalResolution: VkExtent2D,
    pub supportedTransforms: VkSurfaceTransformFlagsKHR,
    pub planeReorderPossible: VkBool32,
    pub persistentContent: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplaySurfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDisplaySurfaceCreateFlagsKHR,
    pub displayMode: VkDisplayModeKHR,
    pub planeIndex: u32,
    pub planeStackIndex: u32,
    pub transform: VkSurfaceTransformFlagBitsKHR,
    pub globalAlpha: f32,
    pub alphaMode: VkDisplayPlaneAlphaFlagBitsKHR,
    pub imageExtent: VkExtent2D,
}
pub type PFN_vkGetPhysicalDeviceDisplayPropertiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPropertiesKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPlanePropertiesKHR,
    ) -> VkResult
;
pub type PFN_vkGetDisplayPlaneSupportedDisplaysKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        planeIndex: u32,
        pDisplayCount: *mut u32,
        pDisplays: *mut VkDisplayKHR,
    ) -> VkResult
;
pub type PFN_vkGetDisplayModePropertiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayModePropertiesKHR,
    ) -> VkResult
;
pub type PFN_vkCreateDisplayModeKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pCreateInfo: *const VkDisplayModeCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pMode: *mut VkDisplayModeKHR,
    ) -> VkResult
;
pub type PFN_vkGetDisplayPlaneCapabilitiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        mode: VkDisplayModeKHR,
        planeIndex: u32,
        pCapabilities: *mut VkDisplayPlaneCapabilitiesKHR,
    ) -> VkResult
;
pub type PFN_vkCreateDisplayPlaneSurfaceKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkDisplaySurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPresentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcRect: VkRect2D,
    pub dstRect: VkRect2D,
    pub persistent: VkBool32,
}
pub type PFN_vkCreateSharedSwapchainsKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchainCount: u32,
        pCreateInfos: *const VkSwapchainCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSwapchains: *mut VkSwapchainKHR,
    ) -> VkResult
;
pub type VkRenderingFlagsKHR = VkRenderingFlags;
pub use self::VkRenderingFlagBits as VkRenderingFlagBitsKHR;
pub type VkRenderingInfoKHR = VkRenderingInfo;
pub type VkRenderingAttachmentInfoKHR = VkRenderingAttachmentInfo;
pub type VkPipelineRenderingCreateInfoKHR = VkPipelineRenderingCreateInfo;
pub type VkPhysicalDeviceDynamicRenderingFeaturesKHR = VkPhysicalDeviceDynamicRenderingFeatures;
pub type VkCommandBufferInheritanceRenderingInfoKHR = VkCommandBufferInheritanceRenderingInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderingFragmentShadingRateAttachmentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub imageView: VkImageView,
    pub imageLayout: VkImageLayout,
    pub shadingRateAttachmentTexelSize: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderingFragmentDensityMapAttachmentInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub imageView: VkImageView,
    pub imageLayout: VkImageLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentSampleCountInfoAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub colorAttachmentCount: u32,
    pub pColorAttachmentSamples: *const VkSampleCountFlagBits,
    pub depthStencilAttachmentSamples: VkSampleCountFlagBits,
}
pub type VkAttachmentSampleCountInfoNV = VkAttachmentSampleCountInfoAMD;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMultiviewPerViewAttributesInfoNVX {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub perViewAttributes: VkBool32,
    pub perViewAttributesPositionXOnly: VkBool32,
}
pub type PFN_vkCmdBeginRenderingKHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pRenderingInfo: *const VkRenderingInfo)
;
pub type PFN_vkCmdEndRenderingKHR =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer);
pub type VkRenderPassMultiviewCreateInfoKHR = VkRenderPassMultiviewCreateInfo;
pub type VkPhysicalDeviceMultiviewFeaturesKHR = VkPhysicalDeviceMultiviewFeatures;
pub type VkPhysicalDeviceMultiviewPropertiesKHR = VkPhysicalDeviceMultiviewProperties;
pub type VkPhysicalDeviceFeatures2KHR = VkPhysicalDeviceFeatures2;
pub type VkPhysicalDeviceProperties2KHR = VkPhysicalDeviceProperties2;
pub type VkFormatProperties2KHR = VkFormatProperties2;
pub type VkImageFormatProperties2KHR = VkImageFormatProperties2;
pub type VkPhysicalDeviceImageFormatInfo2KHR = VkPhysicalDeviceImageFormatInfo2;
pub type VkQueueFamilyProperties2KHR = VkQueueFamilyProperties2;
pub type VkPhysicalDeviceMemoryProperties2KHR = VkPhysicalDeviceMemoryProperties2;
pub type VkSparseImageFormatProperties2KHR = VkSparseImageFormatProperties2;
pub type VkPhysicalDeviceSparseImageFormatInfo2KHR = VkPhysicalDeviceSparseImageFormatInfo2;
pub type PFN_vkGetPhysicalDeviceFeatures2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    )
;
pub type PFN_vkGetPhysicalDeviceProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceFormatProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceMemoryProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    )
;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    )
;
pub type VkPeerMemoryFeatureFlagsKHR = VkPeerMemoryFeatureFlags;
pub use self::VkPeerMemoryFeatureFlagBits as VkPeerMemoryFeatureFlagBitsKHR;
pub type VkMemoryAllocateFlagsKHR = VkMemoryAllocateFlags;
pub use self::VkMemoryAllocateFlagBits as VkMemoryAllocateFlagBitsKHR;
pub type VkMemoryAllocateFlagsInfoKHR = VkMemoryAllocateFlagsInfo;
pub type VkDeviceGroupRenderPassBeginInfoKHR = VkDeviceGroupRenderPassBeginInfo;
pub type VkDeviceGroupCommandBufferBeginInfoKHR = VkDeviceGroupCommandBufferBeginInfo;
pub type VkDeviceGroupSubmitInfoKHR = VkDeviceGroupSubmitInfo;
pub type VkDeviceGroupBindSparseInfoKHR = VkDeviceGroupBindSparseInfo;
pub type VkBindBufferMemoryDeviceGroupInfoKHR = VkBindBufferMemoryDeviceGroupInfo;
pub type VkBindImageMemoryDeviceGroupInfoKHR = VkBindImageMemoryDeviceGroupInfo;
pub type PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    )
;
pub type PFN_vkCmdSetDeviceMaskKHR =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, deviceMask: u32);
pub type PFN_vkCmdDispatchBaseKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    )
;
pub type VkCommandPoolTrimFlagsKHR = VkCommandPoolTrimFlags;
pub type PFN_vkTrimCommandPoolKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    )
;
pub type VkPhysicalDeviceGroupPropertiesKHR = VkPhysicalDeviceGroupProperties;
pub type VkDeviceGroupDeviceCreateInfoKHR = VkDeviceGroupDeviceCreateInfo;
pub type PFN_vkEnumeratePhysicalDeviceGroupsKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult
;
pub type VkExternalMemoryHandleTypeFlagsKHR = VkExternalMemoryHandleTypeFlags;
pub use self::VkExternalMemoryHandleTypeFlagBits as VkExternalMemoryHandleTypeFlagBitsKHR;
pub type VkExternalMemoryFeatureFlagsKHR = VkExternalMemoryFeatureFlags;
pub use self::VkExternalMemoryFeatureFlagBits as VkExternalMemoryFeatureFlagBitsKHR;
pub type VkExternalMemoryPropertiesKHR = VkExternalMemoryProperties;
pub type VkPhysicalDeviceExternalImageFormatInfoKHR = VkPhysicalDeviceExternalImageFormatInfo;
pub type VkExternalImageFormatPropertiesKHR = VkExternalImageFormatProperties;
pub type VkPhysicalDeviceExternalBufferInfoKHR = VkPhysicalDeviceExternalBufferInfo;
pub type VkExternalBufferPropertiesKHR = VkExternalBufferProperties;
pub type VkPhysicalDeviceIDPropertiesKHR = VkPhysicalDeviceIDProperties;
pub type PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    )
;
pub type VkExternalMemoryImageCreateInfoKHR = VkExternalMemoryImageCreateInfo;
pub type VkExternalMemoryBufferCreateInfoKHR = VkExternalMemoryBufferCreateInfo;
pub type VkExportMemoryAllocateInfoKHR = VkExportMemoryAllocateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
    pub fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryFdPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryGetFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
pub type PFN_vkGetMemoryFdKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetFdInfo: *const VkMemoryGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult
;
pub type PFN_vkGetMemoryFdPropertiesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        fd: ::std::os::raw::c_int,
        pMemoryFdProperties: *mut VkMemoryFdPropertiesKHR,
    ) -> VkResult
;
pub type VkExternalSemaphoreHandleTypeFlagsKHR = VkExternalSemaphoreHandleTypeFlags;
pub use self::VkExternalSemaphoreHandleTypeFlagBits as VkExternalSemaphoreHandleTypeFlagBitsKHR;
pub type VkExternalSemaphoreFeatureFlagsKHR = VkExternalSemaphoreFeatureFlags;
pub use self::VkExternalSemaphoreFeatureFlagBits as VkExternalSemaphoreFeatureFlagBitsKHR;
pub type VkPhysicalDeviceExternalSemaphoreInfoKHR = VkPhysicalDeviceExternalSemaphoreInfo;
pub type VkExternalSemaphorePropertiesKHR = VkExternalSemaphoreProperties;
pub type PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    )
;
pub type VkSemaphoreImportFlagsKHR = VkSemaphoreImportFlags;
pub use self::VkSemaphoreImportFlagBits as VkSemaphoreImportFlagBitsKHR;
pub type VkExportSemaphoreCreateInfoKHR = VkExportSemaphoreCreateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportSemaphoreFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub flags: VkSemaphoreImportFlags,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
    pub fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreGetFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
}
pub type PFN_vkImportSemaphoreFdKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pImportSemaphoreFdInfo: *const VkImportSemaphoreFdInfoKHR,
    ) -> VkResult
;
pub type PFN_vkGetSemaphoreFdKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetFdInfo: *const VkSemaphoreGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePushDescriptorPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxPushDescriptors: u32,
}
pub type PFN_vkCmdPushDescriptorSetKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        set: u32,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
    )
;
pub type PFN_vkCmdPushDescriptorSetWithTemplateKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        layout: VkPipelineLayout,
        set: u32,
        pData: *const ::std::os::raw::c_void,
    )
;
pub type VkPhysicalDeviceShaderFloat16Int8FeaturesKHR = VkPhysicalDeviceShaderFloat16Int8Features;
pub type VkPhysicalDeviceFloat16Int8FeaturesKHR = VkPhysicalDeviceShaderFloat16Int8Features;
pub type VkPhysicalDevice16BitStorageFeaturesKHR = VkPhysicalDevice16BitStorageFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRectLayerKHR {
    pub offset: VkOffset2D,
    pub extent: VkExtent2D,
    pub layer: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentRegionKHR {
    pub rectangleCount: u32,
    pub pRectangles: *const VkRectLayerKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentRegionsKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchainCount: u32,
    pub pRegions: *const VkPresentRegionKHR,
}
pub type VkDescriptorUpdateTemplateKHR = VkDescriptorUpdateTemplate;
pub use self::VkDescriptorUpdateTemplateType as VkDescriptorUpdateTemplateTypeKHR;
pub type VkDescriptorUpdateTemplateCreateFlagsKHR = VkDescriptorUpdateTemplateCreateFlags;
pub type VkDescriptorUpdateTemplateEntryKHR = VkDescriptorUpdateTemplateEntry;
pub type VkDescriptorUpdateTemplateCreateInfoKHR = VkDescriptorUpdateTemplateCreateInfo;
pub type PFN_vkCreateDescriptorUpdateTemplateKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult
;
pub type PFN_vkDestroyDescriptorUpdateTemplateKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkUpdateDescriptorSetWithTemplateKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    )
;
pub type VkPhysicalDeviceImagelessFramebufferFeaturesKHR =
    VkPhysicalDeviceImagelessFramebufferFeatures;
pub type VkFramebufferAttachmentsCreateInfoKHR = VkFramebufferAttachmentsCreateInfo;
pub type VkFramebufferAttachmentImageInfoKHR = VkFramebufferAttachmentImageInfo;
pub type VkRenderPassAttachmentBeginInfoKHR = VkRenderPassAttachmentBeginInfo;
pub type VkRenderPassCreateInfo2KHR = VkRenderPassCreateInfo2;
pub type VkAttachmentDescription2KHR = VkAttachmentDescription2;
pub type VkAttachmentReference2KHR = VkAttachmentReference2;
pub type VkSubpassDescription2KHR = VkSubpassDescription2;
pub type VkSubpassDependency2KHR = VkSubpassDependency2;
pub type VkSubpassBeginInfoKHR = VkSubpassBeginInfo;
pub type VkSubpassEndInfoKHR = VkSubpassEndInfo;
pub type PFN_vkCreateRenderPass2KHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo2,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult
;
pub type PFN_vkCmdBeginRenderPass2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
    )
;
pub type PFN_vkCmdNextSubpass2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pSubpassBeginInfo: *const VkSubpassBeginInfo,
        pSubpassEndInfo: *const VkSubpassEndInfo,
    )
;
pub type PFN_vkCmdEndRenderPass2KHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pSubpassEndInfo: *const VkSubpassEndInfo)
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSharedPresentSurfaceCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub sharedPresentSupportedUsageFlags: VkImageUsageFlags,
}
pub type PFN_vkGetSwapchainStatusKHR = 
    unsafe extern "C" fn(device: VkDevice, swapchain: VkSwapchainKHR) -> VkResult
;
pub type VkExternalFenceHandleTypeFlagsKHR = VkExternalFenceHandleTypeFlags;
pub use self::VkExternalFenceHandleTypeFlagBits as VkExternalFenceHandleTypeFlagBitsKHR;
pub type VkExternalFenceFeatureFlagsKHR = VkExternalFenceFeatureFlags;
pub use self::VkExternalFenceFeatureFlagBits as VkExternalFenceFeatureFlagBitsKHR;
pub type VkPhysicalDeviceExternalFenceInfoKHR = VkPhysicalDeviceExternalFenceInfo;
pub type VkExternalFencePropertiesKHR = VkExternalFenceProperties;
pub type PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    )
;
pub type VkFenceImportFlagsKHR = VkFenceImportFlags;
pub use self::VkFenceImportFlagBits as VkFenceImportFlagBitsKHR;
pub type VkExportFenceCreateInfoKHR = VkExportFenceCreateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportFenceFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fence: VkFence,
    pub flags: VkFenceImportFlags,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
    pub fd: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFenceGetFdInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fence: VkFence,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
}
pub type PFN_vkImportFenceFdKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pImportFenceFdInfo: *const VkImportFenceFdInfoKHR,
    ) -> VkResult
;
pub type PFN_vkGetFenceFdKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetFdInfo: *const VkFenceGetFdInfoKHR,
        pFd: *mut ::std::os::raw::c_int,
    ) -> VkResult
;
pub const VK_PERFORMANCE_COUNTER_UNIT_GENERIC_KHR:
    VkPerformanceCounterUnitKHR = 0;
pub const VK_PERFORMANCE_COUNTER_UNIT_PERCENTAGE_KHR:
    VkPerformanceCounterUnitKHR = 1;
pub const VK_PERFORMANCE_COUNTER_UNIT_NANOSECONDS_KHR:
    VkPerformanceCounterUnitKHR = 2;
pub const VK_PERFORMANCE_COUNTER_UNIT_BYTES_KHR:
    VkPerformanceCounterUnitKHR = 3;
pub const VK_PERFORMANCE_COUNTER_UNIT_BYTES_PER_SECOND_KHR:
    VkPerformanceCounterUnitKHR = 4;
pub const VK_PERFORMANCE_COUNTER_UNIT_KELVIN_KHR:
    VkPerformanceCounterUnitKHR = 5;
pub const VK_PERFORMANCE_COUNTER_UNIT_WATTS_KHR:
    VkPerformanceCounterUnitKHR = 6;
pub const VK_PERFORMANCE_COUNTER_UNIT_VOLTS_KHR:
    VkPerformanceCounterUnitKHR = 7;
pub const VK_PERFORMANCE_COUNTER_UNIT_AMPS_KHR:
    VkPerformanceCounterUnitKHR = 8;
pub const VK_PERFORMANCE_COUNTER_UNIT_HERTZ_KHR:
    VkPerformanceCounterUnitKHR = 9;
pub const VK_PERFORMANCE_COUNTER_UNIT_CYCLES_KHR:
    VkPerformanceCounterUnitKHR = 10;
pub const VK_PERFORMANCE_COUNTER_UNIT_MAX_ENUM_KHR:
    VkPerformanceCounterUnitKHR = 2147483647;
pub type VkPerformanceCounterUnitKHR = ::std::os::raw::c_uint;
pub const VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_BUFFER_KHR:
    VkPerformanceCounterScopeKHR = 0;
pub const VK_PERFORMANCE_COUNTER_SCOPE_RENDER_PASS_KHR:
    VkPerformanceCounterScopeKHR = 1;
pub const VK_PERFORMANCE_COUNTER_SCOPE_COMMAND_KHR:
    VkPerformanceCounterScopeKHR = 2;
pub const VK_QUERY_SCOPE_COMMAND_BUFFER_KHR:
    VkPerformanceCounterScopeKHR = 0;
pub const VK_QUERY_SCOPE_RENDER_PASS_KHR:
    VkPerformanceCounterScopeKHR = 1;
pub const VK_QUERY_SCOPE_COMMAND_KHR: VkPerformanceCounterScopeKHR = 2;
pub const VK_PERFORMANCE_COUNTER_SCOPE_MAX_ENUM_KHR:
    VkPerformanceCounterScopeKHR = 2147483647;
pub type VkPerformanceCounterScopeKHR = ::std::os::raw::c_uint;
pub const VK_PERFORMANCE_COUNTER_STORAGE_INT32_KHR:
    VkPerformanceCounterStorageKHR = 0;
pub const VK_PERFORMANCE_COUNTER_STORAGE_INT64_KHR:
    VkPerformanceCounterStorageKHR = 1;
pub const VK_PERFORMANCE_COUNTER_STORAGE_UINT32_KHR:
    VkPerformanceCounterStorageKHR = 2;
pub const VK_PERFORMANCE_COUNTER_STORAGE_UINT64_KHR:
    VkPerformanceCounterStorageKHR = 3;
pub const VK_PERFORMANCE_COUNTER_STORAGE_FLOAT32_KHR:
    VkPerformanceCounterStorageKHR = 4;
pub const VK_PERFORMANCE_COUNTER_STORAGE_FLOAT64_KHR:
    VkPerformanceCounterStorageKHR = 5;
pub const VK_PERFORMANCE_COUNTER_STORAGE_MAX_ENUM_KHR:
    VkPerformanceCounterStorageKHR = 2147483647;
pub type VkPerformanceCounterStorageKHR = ::std::os::raw::c_uint;
pub const VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_BIT_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 1 ;
pub const VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_BIT_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 2 ;
pub const VK_PERFORMANCE_COUNTER_DESCRIPTION_PERFORMANCE_IMPACTING_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 1 ;
pub const VK_PERFORMANCE_COUNTER_DESCRIPTION_CONCURRENTLY_IMPACTED_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 2 ;
pub const VK_PERFORMANCE_COUNTER_DESCRIPTION_FLAG_BITS_MAX_ENUM_KHR : VkPerformanceCounterDescriptionFlagBitsKHR = 2147483647 ;
pub type VkPerformanceCounterDescriptionFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkPerformanceCounterDescriptionFlagsKHR = VkFlags;
pub const VK_ACQUIRE_PROFILING_LOCK_FLAG_BITS_MAX_ENUM_KHR:
    VkAcquireProfilingLockFlagBitsKHR = 2147483647;
pub type VkAcquireProfilingLockFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkAcquireProfilingLockFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePerformanceQueryFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub performanceCounterQueryPools: VkBool32,
    pub performanceCounterMultipleQueryPools: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePerformanceQueryPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub allowCommandBufferQueryCopies: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceCounterKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub unit: VkPerformanceCounterUnitKHR,
    pub scope: VkPerformanceCounterScopeKHR,
    pub storage: VkPerformanceCounterStorageKHR,
    pub uuid: [u8; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceCounterDescriptionKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub flags: VkPerformanceCounterDescriptionFlagsKHR,
    pub name: [::std::os::raw::c_char; 256usize],
    pub category: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPoolPerformanceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub queueFamilyIndex: u32,
    pub counterIndexCount: u32,
    pub pCounterIndices: *const u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkPerformanceCounterResultKHR {
    pub int32: i32,
    pub int64: i64,
    pub uint32: u32,
    pub uint64: u64,
    pub float32: f32,
    pub float64: f64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAcquireProfilingLockInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkAcquireProfilingLockFlagsKHR,
    pub timeout: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceQuerySubmitInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub counterPassIndex: u32,
}
pub type PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR =
    
        unsafe extern "C" fn(
            physicalDevice: VkPhysicalDevice,
            queueFamilyIndex: u32,
            pCounterCount: *mut u32,
            pCounters: *mut VkPerformanceCounterKHR,
            pCounterDescriptions: *mut VkPerformanceCounterDescriptionKHR,
        ) -> VkResult
    ;
pub type PFN_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPerformanceQueryCreateInfo: *const VkQueryPoolPerformanceCreateInfoKHR,
        pNumPasses: *mut u32,
    )
;
pub type PFN_vkAcquireProfilingLockKHR = 
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkAcquireProfilingLockInfoKHR) -> VkResult
;
pub type PFN_vkReleaseProfilingLockKHR =
    unsafe extern "C" fn(device: VkDevice);
pub use self::VkPointClippingBehavior as VkPointClippingBehaviorKHR;
pub use self::VkTessellationDomainOrigin as VkTessellationDomainOriginKHR;
pub type VkPhysicalDevicePointClippingPropertiesKHR = VkPhysicalDevicePointClippingProperties;
pub type VkRenderPassInputAttachmentAspectCreateInfoKHR =
    VkRenderPassInputAttachmentAspectCreateInfo;
pub type VkInputAttachmentAspectReferenceKHR = VkInputAttachmentAspectReference;
pub type VkImageViewUsageCreateInfoKHR = VkImageViewUsageCreateInfo;
pub type VkPipelineTessellationDomainOriginStateCreateInfoKHR =
    VkPipelineTessellationDomainOriginStateCreateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSurfaceInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub surface: VkSurfaceKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceCapabilities2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub surfaceCapabilities: VkSurfaceCapabilitiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceFormat2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub surfaceFormat: VkSurfaceFormatKHR,
}
pub type PFN_vkGetPhysicalDeviceSurfaceCapabilities2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilities2KHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceSurfaceFormats2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pSurfaceFormatCount: *mut u32,
        pSurfaceFormats: *mut VkSurfaceFormat2KHR,
    ) -> VkResult
;
pub type VkPhysicalDeviceVariablePointerFeaturesKHR = VkPhysicalDeviceVariablePointersFeatures;
pub type VkPhysicalDeviceVariablePointersFeaturesKHR = VkPhysicalDeviceVariablePointersFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub displayProperties: VkDisplayPropertiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub displayPlaneProperties: VkDisplayPlanePropertiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayModeProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub displayModeProperties: VkDisplayModePropertiesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneInfo2KHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub mode: VkDisplayModeKHR,
    pub planeIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPlaneCapabilities2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub capabilities: VkDisplayPlaneCapabilitiesKHR,
}
pub type PFN_vkGetPhysicalDeviceDisplayProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayProperties2KHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceDisplayPlaneProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayPlaneProperties2KHR,
    ) -> VkResult
;
pub type PFN_vkGetDisplayModeProperties2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        display: VkDisplayKHR,
        pPropertyCount: *mut u32,
        pProperties: *mut VkDisplayModeProperties2KHR,
    ) -> VkResult
;
pub type PFN_vkGetDisplayPlaneCapabilities2KHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pDisplayPlaneInfo: *const VkDisplayPlaneInfo2KHR,
        pCapabilities: *mut VkDisplayPlaneCapabilities2KHR,
    ) -> VkResult
;
pub type VkMemoryDedicatedRequirementsKHR = VkMemoryDedicatedRequirements;
pub type VkMemoryDedicatedAllocateInfoKHR = VkMemoryDedicatedAllocateInfo;
pub type VkBufferMemoryRequirementsInfo2KHR = VkBufferMemoryRequirementsInfo2;
pub type VkImageMemoryRequirementsInfo2KHR = VkImageMemoryRequirementsInfo2;
pub type VkImageSparseMemoryRequirementsInfo2KHR = VkImageSparseMemoryRequirementsInfo2;
pub type VkMemoryRequirements2KHR = VkMemoryRequirements2;
pub type VkSparseImageMemoryRequirements2KHR = VkSparseImageMemoryRequirements2;
pub type PFN_vkGetImageMemoryRequirements2KHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetBufferMemoryRequirements2KHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetImageSparseMemoryRequirements2KHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    )
;
pub type VkImageFormatListCreateInfoKHR = VkImageFormatListCreateInfo;
pub type VkSamplerYcbcrConversionKHR = VkSamplerYcbcrConversion;
pub use self::VkChromaLocation as VkChromaLocationKHR;
pub use self::VkSamplerYcbcrModelConversion as VkSamplerYcbcrModelConversionKHR;
pub use self::VkSamplerYcbcrRange as VkSamplerYcbcrRangeKHR;
pub type VkSamplerYcbcrConversionCreateInfoKHR = VkSamplerYcbcrConversionCreateInfo;
pub type VkSamplerYcbcrConversionInfoKHR = VkSamplerYcbcrConversionInfo;
pub type VkBindImagePlaneMemoryInfoKHR = VkBindImagePlaneMemoryInfo;
pub type VkImagePlaneMemoryRequirementsInfoKHR = VkImagePlaneMemoryRequirementsInfo;
pub type VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR =
    VkPhysicalDeviceSamplerYcbcrConversionFeatures;
pub type VkSamplerYcbcrConversionImageFormatPropertiesKHR =
    VkSamplerYcbcrConversionImageFormatProperties;
pub type PFN_vkCreateSamplerYcbcrConversionKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult
;
pub type PFN_vkDestroySamplerYcbcrConversionKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type VkBindBufferMemoryInfoKHR = VkBindBufferMemoryInfo;
pub type VkBindImageMemoryInfoKHR = VkBindImageMemoryInfo;
pub type PFN_vkBindBufferMemory2KHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult
;
pub type PFN_vkBindImageMemory2KHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult
;
pub type VkPhysicalDeviceMaintenance3PropertiesKHR = VkPhysicalDeviceMaintenance3Properties;
pub type VkDescriptorSetLayoutSupportKHR = VkDescriptorSetLayoutSupport;
pub type PFN_vkGetDescriptorSetLayoutSupportKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    )
;
pub type PFN_vkCmdDrawIndirectCountKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    )
;
pub type PFN_vkCmdDrawIndexedIndirectCountKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    )
;
pub type VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR =
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures;
pub type VkPhysicalDevice8BitStorageFeaturesKHR = VkPhysicalDevice8BitStorageFeatures;
pub type VkPhysicalDeviceShaderAtomicInt64FeaturesKHR = VkPhysicalDeviceShaderAtomicInt64Features;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderClockFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSubgroupClock: VkBool32,
    pub shaderDeviceClock: VkBool32,
}
pub const VK_QUEUE_GLOBAL_PRIORITY_LOW_KHR: VkQueueGlobalPriorityKHR = 128;
pub const VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_KHR: VkQueueGlobalPriorityKHR =
    256;
pub const VK_QUEUE_GLOBAL_PRIORITY_HIGH_KHR: VkQueueGlobalPriorityKHR =
    512;
pub const VK_QUEUE_GLOBAL_PRIORITY_REALTIME_KHR: VkQueueGlobalPriorityKHR =
    1024;
pub const VK_QUEUE_GLOBAL_PRIORITY_LOW_EXT: VkQueueGlobalPriorityKHR = 128;
pub const VK_QUEUE_GLOBAL_PRIORITY_MEDIUM_EXT: VkQueueGlobalPriorityKHR =
    256;
pub const VK_QUEUE_GLOBAL_PRIORITY_HIGH_EXT: VkQueueGlobalPriorityKHR =
    512;
pub const VK_QUEUE_GLOBAL_PRIORITY_REALTIME_EXT: VkQueueGlobalPriorityKHR =
    1024;
pub const VK_QUEUE_GLOBAL_PRIORITY_MAX_ENUM_KHR: VkQueueGlobalPriorityKHR =
    2147483647;
pub type VkQueueGlobalPriorityKHR = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueGlobalPriorityCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub globalPriority: VkQueueGlobalPriorityKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub globalPriorityQuery: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyGlobalPriorityPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub priorityCount: u32,
    pub priorities: [VkQueueGlobalPriorityKHR; 16usize],
}
pub use self::VkDriverId as VkDriverIdKHR;
pub type VkConformanceVersionKHR = VkConformanceVersion;
pub type VkPhysicalDeviceDriverPropertiesKHR = VkPhysicalDeviceDriverProperties;
pub use self::VkShaderFloatControlsIndependence as VkShaderFloatControlsIndependenceKHR;
pub type VkPhysicalDeviceFloatControlsPropertiesKHR = VkPhysicalDeviceFloatControlsProperties;
pub use self::VkResolveModeFlagBits as VkResolveModeFlagBitsKHR;
pub type VkResolveModeFlagsKHR = VkResolveModeFlags;
pub type VkSubpassDescriptionDepthStencilResolveKHR = VkSubpassDescriptionDepthStencilResolve;
pub type VkPhysicalDeviceDepthStencilResolvePropertiesKHR =
    VkPhysicalDeviceDepthStencilResolveProperties;
pub use self::VkSemaphoreType as VkSemaphoreTypeKHR;
pub use self::VkSemaphoreWaitFlagBits as VkSemaphoreWaitFlagBitsKHR;
pub type VkSemaphoreWaitFlagsKHR = VkSemaphoreWaitFlags;
pub type VkPhysicalDeviceTimelineSemaphoreFeaturesKHR = VkPhysicalDeviceTimelineSemaphoreFeatures;
pub type VkPhysicalDeviceTimelineSemaphorePropertiesKHR =
    VkPhysicalDeviceTimelineSemaphoreProperties;
pub type VkSemaphoreTypeCreateInfoKHR = VkSemaphoreTypeCreateInfo;
pub type VkTimelineSemaphoreSubmitInfoKHR = VkTimelineSemaphoreSubmitInfo;
pub type VkSemaphoreWaitInfoKHR = VkSemaphoreWaitInfo;
pub type VkSemaphoreSignalInfoKHR = VkSemaphoreSignalInfo;
pub type PFN_vkGetSemaphoreCounterValueKHR = 
    unsafe extern "C" fn(device: VkDevice, semaphore: VkSemaphore, pValue: *mut u64) -> VkResult
;
pub type PFN_vkWaitSemaphoresKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pWaitInfo: *const VkSemaphoreWaitInfo,
        timeout: u64,
    ) -> VkResult
;
pub type PFN_vkSignalSemaphoreKHR = 
    unsafe extern "C" fn(device: VkDevice, pSignalInfo: *const VkSemaphoreSignalInfo) -> VkResult
;
pub type VkPhysicalDeviceVulkanMemoryModelFeaturesKHR = VkPhysicalDeviceVulkanMemoryModelFeatures;
pub type VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR =
    VkPhysicalDeviceShaderTerminateInvocationFeatures;
pub const VK_FRAGMENT_SHADING_RATE_COMBINER_OP_KEEP_KHR:
    VkFragmentShadingRateCombinerOpKHR = 0;
pub const VK_FRAGMENT_SHADING_RATE_COMBINER_OP_REPLACE_KHR:
    VkFragmentShadingRateCombinerOpKHR = 1;
pub const VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MIN_KHR:
    VkFragmentShadingRateCombinerOpKHR = 2;
pub const VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_KHR:
    VkFragmentShadingRateCombinerOpKHR = 3;
pub const VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MUL_KHR:
    VkFragmentShadingRateCombinerOpKHR = 4;
pub const VK_FRAGMENT_SHADING_RATE_COMBINER_OP_MAX_ENUM_KHR:
    VkFragmentShadingRateCombinerOpKHR = 2147483647;
pub type VkFragmentShadingRateCombinerOpKHR = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFragmentShadingRateAttachmentInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pFragmentShadingRateAttachment: *const VkAttachmentReference2,
    pub shadingRateAttachmentTexelSize: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineFragmentShadingRateStateCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fragmentSize: VkExtent2D,
    pub combinerOps: [VkFragmentShadingRateCombinerOpKHR; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pipelineFragmentShadingRate: VkBool32,
    pub primitiveFragmentShadingRate: VkBool32,
    pub attachmentFragmentShadingRate: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRatePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minFragmentShadingRateAttachmentTexelSize: VkExtent2D,
    pub maxFragmentShadingRateAttachmentTexelSize: VkExtent2D,
    pub maxFragmentShadingRateAttachmentTexelSizeAspectRatio: u32,
    pub primitiveFragmentShadingRateWithMultipleViewports: VkBool32,
    pub layeredShadingRateAttachments: VkBool32,
    pub fragmentShadingRateNonTrivialCombinerOps: VkBool32,
    pub maxFragmentSize: VkExtent2D,
    pub maxFragmentSizeAspectRatio: u32,
    pub maxFragmentShadingRateCoverageSamples: u32,
    pub maxFragmentShadingRateRasterizationSamples: VkSampleCountFlagBits,
    pub fragmentShadingRateWithShaderDepthStencilWrites: VkBool32,
    pub fragmentShadingRateWithSampleMask: VkBool32,
    pub fragmentShadingRateWithShaderSampleMask: VkBool32,
    pub fragmentShadingRateWithConservativeRasterization: VkBool32,
    pub fragmentShadingRateWithFragmentShaderInterlock: VkBool32,
    pub fragmentShadingRateWithCustomSampleLocations: VkBool32,
    pub fragmentShadingRateStrictMultiplyCombiner: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub sampleCounts: VkSampleCountFlags,
    pub fragmentSize: VkExtent2D,
}
pub type PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFragmentShadingRateCount: *mut u32,
        pFragmentShadingRates: *mut VkPhysicalDeviceFragmentShadingRateKHR,
    ) -> VkResult
;
pub type PFN_vkCmdSetFragmentShadingRateKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pFragmentSize: *const VkExtent2D,
        combinerOps: *const VkFragmentShadingRateCombinerOpKHR,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceProtectedCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub supportsProtected: VkBool32,
}
pub type VkPhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR =
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures;
pub type VkAttachmentReferenceStencilLayoutKHR = VkAttachmentReferenceStencilLayout;
pub type VkAttachmentDescriptionStencilLayoutKHR = VkAttachmentDescriptionStencilLayout;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePresentWaitFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub presentWait: VkBool32,
}
pub type PFN_vkWaitForPresentKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        presentId: u64,
        timeout: u64,
    ) -> VkResult
;
pub type VkPhysicalDeviceUniformBufferStandardLayoutFeaturesKHR =
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures;
pub type VkPhysicalDeviceBufferDeviceAddressFeaturesKHR =
    VkPhysicalDeviceBufferDeviceAddressFeatures;
pub type VkBufferDeviceAddressInfoKHR = VkBufferDeviceAddressInfo;
pub type VkBufferOpaqueCaptureAddressCreateInfoKHR = VkBufferOpaqueCaptureAddressCreateInfo;
pub type VkMemoryOpaqueCaptureAddressAllocateInfoKHR = VkMemoryOpaqueCaptureAddressAllocateInfo;
pub type VkDeviceMemoryOpaqueCaptureAddressInfoKHR = VkDeviceMemoryOpaqueCaptureAddressInfo;
pub type PFN_vkGetBufferDeviceAddressKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress
;
pub type PFN_vkGetBufferOpaqueCaptureAddressKHR = 
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkBufferDeviceAddressInfo) -> u64
;
pub type PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceMemoryOpaqueCaptureAddressInfo,
    ) -> u64
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeferredOperationKHR_T {
    _unused: [u8; 0],
}
pub type VkDeferredOperationKHR = *mut VkDeferredOperationKHR_T;
pub type PFN_vkCreateDeferredOperationKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocator: *const VkAllocationCallbacks,
        pDeferredOperation: *mut VkDeferredOperationKHR,
    ) -> VkResult
;
pub type PFN_vkDestroyDeferredOperationKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        operation: VkDeferredOperationKHR,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetDeferredOperationMaxConcurrencyKHR = 
    unsafe extern "C" fn(device: VkDevice, operation: VkDeferredOperationKHR) -> u32
;
pub type PFN_vkGetDeferredOperationResultKHR = 
    unsafe extern "C" fn(device: VkDevice, operation: VkDeferredOperationKHR) -> VkResult
;
pub type PFN_vkDeferredOperationJoinKHR = 
    unsafe extern "C" fn(device: VkDevice, operation: VkDeferredOperationKHR) -> VkResult
;
pub const VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_BOOL32_KHR : VkPipelineExecutableStatisticFormatKHR = 0 ;
pub const VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_INT64_KHR : VkPipelineExecutableStatisticFormatKHR = 1 ;
pub const VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_UINT64_KHR : VkPipelineExecutableStatisticFormatKHR = 2 ;
pub const VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_FLOAT64_KHR : VkPipelineExecutableStatisticFormatKHR = 3 ;
pub const VK_PIPELINE_EXECUTABLE_STATISTIC_FORMAT_MAX_ENUM_KHR : VkPipelineExecutableStatisticFormatKHR = 2147483647 ;
pub type VkPipelineExecutableStatisticFormatKHR = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pipelineExecutableInfo: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipeline: VkPipeline,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineExecutablePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stages: VkShaderStageFlags,
    pub name: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
    pub subgroupSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineExecutableInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipeline: VkPipeline,
    pub executableIndex: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkPipelineExecutableStatisticValueKHR {
    pub b32: VkBool32,
    pub i64_: i64,
    pub u64_: u64,
    pub f64_: f64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPipelineExecutableStatisticKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub name: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
    pub format: VkPipelineExecutableStatisticFormatKHR,
    pub value: VkPipelineExecutableStatisticValueKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineExecutableInternalRepresentationKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub name: [::std::os::raw::c_char; 256usize],
    pub description: [::std::os::raw::c_char; 256usize],
    pub isText: VkBool32,
    pub dataSize: size_t,
    pub pData: *mut ::std::os::raw::c_void,
}
pub type PFN_vkGetPipelineExecutablePropertiesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pPipelineInfo: *const VkPipelineInfoKHR,
        pExecutableCount: *mut u32,
        pProperties: *mut VkPipelineExecutablePropertiesKHR,
    ) -> VkResult
;
pub type PFN_vkGetPipelineExecutableStatisticsKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pExecutableInfo: *const VkPipelineExecutableInfoKHR,
        pStatisticCount: *mut u32,
        pStatistics: *mut VkPipelineExecutableStatisticKHR,
    ) -> VkResult
;
pub type PFN_vkGetPipelineExecutableInternalRepresentationsKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pExecutableInfo: *const VkPipelineExecutableInfoKHR,
        pInternalRepresentationCount: *mut u32,
        pInternalRepresentations: *mut VkPipelineExecutableInternalRepresentationKHR,
    ) -> VkResult
;
pub type VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR =
    VkPhysicalDeviceShaderIntegerDotProductFeatures;
pub type VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR =
    VkPhysicalDeviceShaderIntegerDotProductProperties;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLibraryCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub libraryCount: u32,
    pub pLibraries: *const VkPipeline,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentIdKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchainCount: u32,
    pub pPresentIds: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePresentIdFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub presentId: VkBool32,
}
pub type VkPipelineStageFlags2KHR = VkPipelineStageFlags2;
pub type VkPipelineStageFlagBits2KHR = VkPipelineStageFlagBits2;
pub type VkAccessFlags2KHR = VkAccessFlags2;
pub type VkAccessFlagBits2KHR = VkAccessFlagBits2;
pub use self::VkSubmitFlagBits as VkSubmitFlagBitsKHR;
pub type VkSubmitFlagsKHR = VkSubmitFlags;
pub type VkMemoryBarrier2KHR = VkMemoryBarrier2;
pub type VkBufferMemoryBarrier2KHR = VkBufferMemoryBarrier2;
pub type VkImageMemoryBarrier2KHR = VkImageMemoryBarrier2;
pub type VkDependencyInfoKHR = VkDependencyInfo;
pub type VkSubmitInfo2KHR = VkSubmitInfo2;
pub type VkSemaphoreSubmitInfoKHR = VkSemaphoreSubmitInfo;
pub type VkCommandBufferSubmitInfoKHR = VkCommandBufferSubmitInfo;
pub type VkPhysicalDeviceSynchronization2FeaturesKHR = VkPhysicalDeviceSynchronization2Features;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyCheckpointProperties2NV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub checkpointExecutionStageMask: VkPipelineStageFlags2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCheckpointData2NV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stage: VkPipelineStageFlags2,
    pub pCheckpointMarker: *mut ::std::os::raw::c_void,
}
pub type PFN_vkCmdSetEvent2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        pDependencyInfo: *const VkDependencyInfo,
    )
;
pub type PFN_vkCmdResetEvent2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags2,
    )
;
pub type PFN_vkCmdWaitEvents2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        pDependencyInfos: *const VkDependencyInfo,
    )
;
pub type PFN_vkCmdPipelineBarrier2KHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pDependencyInfo: *const VkDependencyInfo)
;
pub type PFN_vkCmdWriteTimestamp2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        stage: VkPipelineStageFlags2,
        queryPool: VkQueryPool,
        query: u32,
    )
;
pub type PFN_vkQueueSubmit2KHR = 
    unsafe extern "C" fn(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo2,
        fence: VkFence,
    ) -> VkResult
;
pub type PFN_vkCmdWriteBufferMarker2AMD = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        stage: VkPipelineStageFlags2,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        marker: u32,
    )
;
pub type PFN_vkGetQueueCheckpointData2NV = 
    unsafe extern "C" fn(
        queue: VkQueue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut VkCheckpointData2NV,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSubgroupUniformControlFlow: VkBool32,
}
pub type VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR =
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub workgroupMemoryExplicitLayout: VkBool32,
    pub workgroupMemoryExplicitLayoutScalarBlockLayout: VkBool32,
    pub workgroupMemoryExplicitLayout8BitAccess: VkBool32,
    pub workgroupMemoryExplicitLayout16BitAccess: VkBool32,
}
pub type VkCopyBufferInfo2KHR = VkCopyBufferInfo2;
pub type VkCopyImageInfo2KHR = VkCopyImageInfo2;
pub type VkCopyBufferToImageInfo2KHR = VkCopyBufferToImageInfo2;
pub type VkCopyImageToBufferInfo2KHR = VkCopyImageToBufferInfo2;
pub type VkBlitImageInfo2KHR = VkBlitImageInfo2;
pub type VkResolveImageInfo2KHR = VkResolveImageInfo2;
pub type VkBufferCopy2KHR = VkBufferCopy2;
pub type VkImageCopy2KHR = VkImageCopy2;
pub type VkImageBlit2KHR = VkImageBlit2;
pub type VkBufferImageCopy2KHR = VkBufferImageCopy2;
pub type VkImageResolve2KHR = VkImageResolve2;
pub type PFN_vkCmdCopyBuffer2KHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pCopyBufferInfo: *const VkCopyBufferInfo2)
;
pub type PFN_vkCmdCopyImage2KHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pCopyImageInfo: *const VkCopyImageInfo2)
;
pub type PFN_vkCmdCopyBufferToImage2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyBufferToImageInfo: *const VkCopyBufferToImageInfo2,
    )
;
pub type PFN_vkCmdCopyImageToBuffer2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCopyImageToBufferInfo: *const VkCopyImageToBufferInfo2,
    )
;
pub type PFN_vkCmdBlitImage2KHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pBlitImageInfo: *const VkBlitImageInfo2)
;
pub type PFN_vkCmdResolveImage2KHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pResolveImageInfo: *const VkResolveImageInfo2,
    )
;
pub type VkFormatFeatureFlags2KHR = VkFormatFeatureFlags2;
pub type VkFormatFeatureFlagBits2KHR = VkFormatFeatureFlagBits2;
pub type VkFormatProperties3KHR = VkFormatProperties3;
pub type VkPhysicalDeviceMaintenance4FeaturesKHR = VkPhysicalDeviceMaintenance4Features;
pub type VkPhysicalDeviceMaintenance4PropertiesKHR = VkPhysicalDeviceMaintenance4Properties;
pub type VkDeviceBufferMemoryRequirementsKHR = VkDeviceBufferMemoryRequirements;
pub type VkDeviceImageMemoryRequirementsKHR = VkDeviceImageMemoryRequirements;
pub type PFN_vkGetDeviceBufferMemoryRequirementsKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceBufferMemoryRequirements,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetDeviceImageMemoryRequirementsKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceImageMemoryRequirements,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkGetDeviceImageSparseMemoryRequirementsKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkDeviceImageMemoryRequirements,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugReportCallbackEXT_T {
    _unused: [u8; 0],
}
pub type VkDebugReportCallbackEXT = *mut VkDebugReportCallbackEXT_T;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_UNKNOWN_EXT:
    VkDebugReportObjectTypeEXT = 0;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_INSTANCE_EXT:
    VkDebugReportObjectTypeEXT = 1;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_PHYSICAL_DEVICE_EXT:
    VkDebugReportObjectTypeEXT = 2;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_EXT:
    VkDebugReportObjectTypeEXT = 3;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_QUEUE_EXT:
    VkDebugReportObjectTypeEXT = 4;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_SEMAPHORE_EXT:
    VkDebugReportObjectTypeEXT = 5;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_BUFFER_EXT:
    VkDebugReportObjectTypeEXT = 6;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_FENCE_EXT:
    VkDebugReportObjectTypeEXT = 7;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DEVICE_MEMORY_EXT:
    VkDebugReportObjectTypeEXT = 8;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_EXT:
    VkDebugReportObjectTypeEXT = 9;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_EXT:
    VkDebugReportObjectTypeEXT = 10;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_EVENT_EXT:
    VkDebugReportObjectTypeEXT = 11;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_QUERY_POOL_EXT:
    VkDebugReportObjectTypeEXT = 12;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_VIEW_EXT:
    VkDebugReportObjectTypeEXT = 13;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_IMAGE_VIEW_EXT:
    VkDebugReportObjectTypeEXT = 14;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_SHADER_MODULE_EXT:
    VkDebugReportObjectTypeEXT = 15;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_CACHE_EXT:
    VkDebugReportObjectTypeEXT = 16;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_LAYOUT_EXT:
    VkDebugReportObjectTypeEXT = 17;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_RENDER_PASS_EXT:
    VkDebugReportObjectTypeEXT = 18;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_PIPELINE_EXT:
    VkDebugReportObjectTypeEXT = 19;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT_EXT:
    VkDebugReportObjectTypeEXT = 20;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_EXT:
    VkDebugReportObjectTypeEXT = 21;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_POOL_EXT:
    VkDebugReportObjectTypeEXT = 22;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_SET_EXT:
    VkDebugReportObjectTypeEXT = 23;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_FRAMEBUFFER_EXT:
    VkDebugReportObjectTypeEXT = 24;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_COMMAND_POOL_EXT:
    VkDebugReportObjectTypeEXT = 25;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_SURFACE_KHR_EXT:
    VkDebugReportObjectTypeEXT = 26;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_SWAPCHAIN_KHR_EXT:
    VkDebugReportObjectTypeEXT = 27;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT_EXT:
    VkDebugReportObjectTypeEXT = 28;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_KHR_EXT:
    VkDebugReportObjectTypeEXT = 29;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DISPLAY_MODE_KHR_EXT:
    VkDebugReportObjectTypeEXT = 30;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT_EXT:
    VkDebugReportObjectTypeEXT = 33;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_EXT:
    VkDebugReportObjectTypeEXT = 1000156000;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_EXT:
    VkDebugReportObjectTypeEXT = 1000085000;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_CU_MODULE_NVX_EXT:
    VkDebugReportObjectTypeEXT = 1000029000;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_CU_FUNCTION_NVX_EXT:
    VkDebugReportObjectTypeEXT = 1000029001;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR_EXT:
    VkDebugReportObjectTypeEXT = 1000150000;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV_EXT:
    VkDebugReportObjectTypeEXT = 1000165000;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_BUFFER_COLLECTION_FUCHSIA_EXT:
    VkDebugReportObjectTypeEXT = 1000366000;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DEBUG_REPORT_EXT:
    VkDebugReportObjectTypeEXT = 28;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_VALIDATION_CACHE_EXT:
    VkDebugReportObjectTypeEXT = 33;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR_EXT : VkDebugReportObjectTypeEXT = 1000085000 ;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR_EXT : VkDebugReportObjectTypeEXT = 1000156000 ;
pub const VK_DEBUG_REPORT_OBJECT_TYPE_MAX_ENUM_EXT:
    VkDebugReportObjectTypeEXT = 2147483647;
pub type VkDebugReportObjectTypeEXT = ::std::os::raw::c_uint;
pub const VK_DEBUG_REPORT_INFORMATION_BIT_EXT: VkDebugReportFlagBitsEXT =
    1;
pub const VK_DEBUG_REPORT_WARNING_BIT_EXT: VkDebugReportFlagBitsEXT = 2;
pub const VK_DEBUG_REPORT_PERFORMANCE_WARNING_BIT_EXT:
    VkDebugReportFlagBitsEXT = 4;
pub const VK_DEBUG_REPORT_ERROR_BIT_EXT: VkDebugReportFlagBitsEXT = 8;
pub const VK_DEBUG_REPORT_DEBUG_BIT_EXT: VkDebugReportFlagBitsEXT = 16;
pub const VK_DEBUG_REPORT_FLAG_BITS_MAX_ENUM_EXT:
    VkDebugReportFlagBitsEXT = 2147483647;
pub type VkDebugReportFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkDebugReportFlagsEXT = VkFlags;
pub type PFN_vkDebugReportCallbackEXT = 
    unsafe extern "C" fn(
        flags: VkDebugReportFlagsEXT,
        objectType: VkDebugReportObjectTypeEXT,
        object: u64,
        location: size_t,
        messageCode: i32,
        pLayerPrefix: *const ::std::os::raw::c_char,
        pMessage: *const ::std::os::raw::c_char,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> VkBool32
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugReportCallbackCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDebugReportFlagsEXT,
    pub pfnCallback: PFN_vkDebugReportCallbackEXT,
    pub pUserData: *mut ::std::os::raw::c_void,
}
pub type PFN_vkCreateDebugReportCallbackEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkDebugReportCallbackCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pCallback: *mut VkDebugReportCallbackEXT,
    ) -> VkResult
;
pub type PFN_vkDestroyDebugReportCallbackEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        callback: VkDebugReportCallbackEXT,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkDebugReportMessageEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        flags: VkDebugReportFlagsEXT,
        objectType: VkDebugReportObjectTypeEXT,
        object: u64,
        location: size_t,
        messageCode: i32,
        pLayerPrefix: *const ::std::os::raw::c_char,
        pMessage: *const ::std::os::raw::c_char,
    )
;
pub const VK_RASTERIZATION_ORDER_STRICT_AMD: VkRasterizationOrderAMD = 0;
pub const VK_RASTERIZATION_ORDER_RELAXED_AMD: VkRasterizationOrderAMD = 1;
pub const VK_RASTERIZATION_ORDER_MAX_ENUM_AMD: VkRasterizationOrderAMD =
    2147483647;
pub type VkRasterizationOrderAMD = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationStateRasterizationOrderAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub rasterizationOrder: VkRasterizationOrderAMD,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugMarkerObjectNameInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkDebugReportObjectTypeEXT,
    pub object: u64,
    pub pObjectName: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugMarkerObjectTagInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkDebugReportObjectTypeEXT,
    pub object: u64,
    pub tagName: u64,
    pub tagSize: size_t,
    pub pTag: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugMarkerMarkerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pMarkerName: *const ::std::os::raw::c_char,
    pub color: [f32; 4usize],
}
pub type PFN_vkDebugMarkerSetObjectTagEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pTagInfo: *const VkDebugMarkerObjectTagInfoEXT,
    ) -> VkResult
;
pub type PFN_vkDebugMarkerSetObjectNameEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pNameInfo: *const VkDebugMarkerObjectNameInfoEXT,
    ) -> VkResult
;
pub type PFN_vkCmdDebugMarkerBeginEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkDebugMarkerMarkerInfoEXT,
    )
;
pub type PFN_vkCmdDebugMarkerEndEXT =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer);
pub type PFN_vkCmdDebugMarkerInsertEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkDebugMarkerMarkerInfoEXT,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDedicatedAllocationImageCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dedicatedAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDedicatedAllocationBufferCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dedicatedAllocation: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDedicatedAllocationMemoryAllocateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub buffer: VkBuffer,
}
pub type VkPipelineRasterizationStateStreamCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTransformFeedbackFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub transformFeedback: VkBool32,
    pub geometryStreams: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTransformFeedbackPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxTransformFeedbackStreams: u32,
    pub maxTransformFeedbackBuffers: u32,
    pub maxTransformFeedbackBufferSize: VkDeviceSize,
    pub maxTransformFeedbackStreamDataSize: u32,
    pub maxTransformFeedbackBufferDataSize: u32,
    pub maxTransformFeedbackBufferDataStride: u32,
    pub transformFeedbackQueries: VkBool32,
    pub transformFeedbackStreamsLinesTriangles: VkBool32,
    pub transformFeedbackRasterizationStreamSelect: VkBool32,
    pub transformFeedbackDraw: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationStateStreamCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationStateStreamCreateFlagsEXT,
    pub rasterizationStream: u32,
}
pub type PFN_vkCmdBindTransformFeedbackBuffersEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
        pSizes: *const VkDeviceSize,
    )
;
pub type PFN_vkCmdBeginTransformFeedbackEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const VkBuffer,
        pCounterBufferOffsets: *const VkDeviceSize,
    )
;
pub type PFN_vkCmdEndTransformFeedbackEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstCounterBuffer: u32,
        counterBufferCount: u32,
        pCounterBuffers: *const VkBuffer,
        pCounterBufferOffsets: *const VkDeviceSize,
    )
;
pub type PFN_vkCmdBeginQueryIndexedEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
        index: u32,
    )
;
pub type PFN_vkCmdEndQueryIndexedEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        index: u32,
    )
;
pub type PFN_vkCmdDrawIndirectByteCountEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        instanceCount: u32,
        firstInstance: u32,
        counterBuffer: VkBuffer,
        counterBufferOffset: VkDeviceSize,
        counterOffset: u32,
        vertexStride: u32,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCuModuleNVX_T {
    _unused: [u8; 0],
}
pub type VkCuModuleNVX = *mut VkCuModuleNVX_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCuFunctionNVX_T {
    _unused: [u8; 0],
}
pub type VkCuFunctionNVX = *mut VkCuFunctionNVX_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCuModuleCreateInfoNVX {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dataSize: size_t,
    pub pData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCuFunctionCreateInfoNVX {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub module: VkCuModuleNVX,
    pub pName: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCuLaunchInfoNVX {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub function: VkCuFunctionNVX,
    pub gridDimX: u32,
    pub gridDimY: u32,
    pub gridDimZ: u32,
    pub blockDimX: u32,
    pub blockDimY: u32,
    pub blockDimZ: u32,
    pub sharedMemBytes: u32,
    pub paramCount: size_t,
    pub pParams: *const *const ::std::os::raw::c_void,
    pub extraCount: size_t,
    pub pExtras: *const *const ::std::os::raw::c_void,
}
pub type PFN_vkCreateCuModuleNVX = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkCuModuleCreateInfoNVX,
        pAllocator: *const VkAllocationCallbacks,
        pModule: *mut VkCuModuleNVX,
    ) -> VkResult
;
pub type PFN_vkCreateCuFunctionNVX = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkCuFunctionCreateInfoNVX,
        pAllocator: *const VkAllocationCallbacks,
        pFunction: *mut VkCuFunctionNVX,
    ) -> VkResult
;
pub type PFN_vkDestroyCuModuleNVX = 
    unsafe extern "C" fn(
        device: VkDevice,
        module: VkCuModuleNVX,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkDestroyCuFunctionNVX = 
    unsafe extern "C" fn(
        device: VkDevice,
        function: VkCuFunctionNVX,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCmdCuLaunchKernelNVX = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pLaunchInfo: *const VkCuLaunchInfoNVX)
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewHandleInfoNVX {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub imageView: VkImageView,
    pub descriptorType: VkDescriptorType,
    pub sampler: VkSampler,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewAddressPropertiesNVX {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceAddress: VkDeviceAddress,
    pub size: VkDeviceSize,
}
pub type PFN_vkGetImageViewHandleNVX = 
    unsafe extern "C" fn(device: VkDevice, pInfo: *const VkImageViewHandleInfoNVX) -> u32
;
pub type PFN_vkGetImageViewAddressNVX = 
    unsafe extern "C" fn(
        device: VkDevice,
        imageView: VkImageView,
        pProperties: *mut VkImageViewAddressPropertiesNVX,
    ) -> VkResult
;
pub type PFN_vkCmdDrawIndirectCountAMD = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    )
;
pub type PFN_vkCmdDrawIndexedIndirectCountAMD = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTextureLODGatherFormatPropertiesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supportsTextureGatherLODBiasAMD: VkBool32,
}
pub const VK_SHADER_INFO_TYPE_STATISTICS_AMD: VkShaderInfoTypeAMD = 0;
pub const VK_SHADER_INFO_TYPE_BINARY_AMD: VkShaderInfoTypeAMD = 1;
pub const VK_SHADER_INFO_TYPE_DISASSEMBLY_AMD: VkShaderInfoTypeAMD = 2;
pub const VK_SHADER_INFO_TYPE_MAX_ENUM_AMD: VkShaderInfoTypeAMD = 2147483647;
pub type VkShaderInfoTypeAMD = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderResourceUsageAMD {
    pub numUsedVgprs: u32,
    pub numUsedSgprs: u32,
    pub ldsSizePerLocalWorkGroup: u32,
    pub ldsUsageSizeInBytes: size_t,
    pub scratchMemUsageInBytes: size_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderStatisticsInfoAMD {
    pub shaderStageMask: VkShaderStageFlags,
    pub resourceUsage: VkShaderResourceUsageAMD,
    pub numPhysicalVgprs: u32,
    pub numPhysicalSgprs: u32,
    pub numAvailableVgprs: u32,
    pub numAvailableSgprs: u32,
    pub computeWorkGroupSize: [u32; 3usize],
}
pub type PFN_vkGetShaderInfoAMD = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        shaderStage: VkShaderStageFlagBits,
        infoType: VkShaderInfoTypeAMD,
        pInfoSize: *mut size_t,
        pInfo: *mut ::std::os::raw::c_void,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCornerSampledImageFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub cornerSampledImage: VkBool32,
}
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_NV : VkExternalMemoryHandleTypeFlagBitsNV = 1 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_NV : VkExternalMemoryHandleTypeFlagBitsNV = 2 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_BIT_NV:
    VkExternalMemoryHandleTypeFlagBitsNV = 4;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_IMAGE_KMT_BIT_NV : VkExternalMemoryHandleTypeFlagBitsNV = 8 ;
pub const VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM_NV : VkExternalMemoryHandleTypeFlagBitsNV = 2147483647 ;
pub type VkExternalMemoryHandleTypeFlagBitsNV = ::std::os::raw::c_uint;
pub type VkExternalMemoryHandleTypeFlagsNV = VkFlags;
pub const VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_NV:
    VkExternalMemoryFeatureFlagBitsNV = 1;
pub const VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_NV:
    VkExternalMemoryFeatureFlagBitsNV = 2;
pub const VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_NV:
    VkExternalMemoryFeatureFlagBitsNV = 4;
pub const VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM_NV:
    VkExternalMemoryFeatureFlagBitsNV = 2147483647;
pub type VkExternalMemoryFeatureFlagBitsNV = ::std::os::raw::c_uint;
pub type VkExternalMemoryFeatureFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalImageFormatPropertiesNV {
    pub imageFormatProperties: VkImageFormatProperties,
    pub externalMemoryFeatures: VkExternalMemoryFeatureFlagsNV,
    pub exportFromImportedHandleTypes: VkExternalMemoryHandleTypeFlagsNV,
    pub compatibleHandleTypes: VkExternalMemoryHandleTypeFlagsNV,
}
pub type PFN_vkGetPhysicalDeviceExternalImageFormatPropertiesNV = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        externalHandleType: VkExternalMemoryHandleTypeFlagsNV,
        pExternalImageFormatProperties: *mut VkExternalImageFormatPropertiesNV,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryImageCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlagsNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportMemoryAllocateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlagsNV,
}
pub const VK_VALIDATION_CHECK_ALL_EXT: VkValidationCheckEXT = 0;
pub const VK_VALIDATION_CHECK_SHADERS_EXT: VkValidationCheckEXT = 1;
pub const VK_VALIDATION_CHECK_MAX_ENUM_EXT: VkValidationCheckEXT = 2147483647;
pub type VkValidationCheckEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationFlagsEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub disabledValidationCheckCount: u32,
    pub pDisabledValidationChecks: *const VkValidationCheckEXT,
}
pub type VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT =
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewASTCDecodeModeEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub decodeMode: VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceASTCDecodeFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub decodeModeSharedExponent: VkBool32,
}
pub const VK_CONDITIONAL_RENDERING_INVERTED_BIT_EXT:
    VkConditionalRenderingFlagBitsEXT = 1;
pub const VK_CONDITIONAL_RENDERING_FLAG_BITS_MAX_ENUM_EXT:
    VkConditionalRenderingFlagBitsEXT = 2147483647;
pub type VkConditionalRenderingFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkConditionalRenderingFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkConditionalRenderingBeginInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub flags: VkConditionalRenderingFlagsEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceConditionalRenderingFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub conditionalRendering: VkBool32,
    pub inheritedConditionalRendering: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceConditionalRenderingInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub conditionalRenderingEnable: VkBool32,
}
pub type PFN_vkCmdBeginConditionalRenderingEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pConditionalRenderingBegin: *const VkConditionalRenderingBeginInfoEXT,
    )
;
pub type PFN_vkCmdEndConditionalRenderingEXT =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViewportWScalingNV {
    pub xcoeff: f32,
    pub ycoeff: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportWScalingStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub viewportWScalingEnable: VkBool32,
    pub viewportCount: u32,
    pub pViewportWScalings: *const VkViewportWScalingNV,
}
pub type PFN_vkCmdSetViewportWScalingNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewportWScalings: *const VkViewportWScalingNV,
    )
;
pub type PFN_vkReleaseDisplayEXT = 
    unsafe extern "C" fn(physicalDevice: VkPhysicalDevice, display: VkDisplayKHR) -> VkResult
;
pub const VK_SURFACE_COUNTER_VBLANK_BIT_EXT:
    VkSurfaceCounterFlagBitsEXT = 1;
pub const VK_SURFACE_COUNTER_VBLANK_EXT: VkSurfaceCounterFlagBitsEXT =
    1;
pub const VK_SURFACE_COUNTER_FLAG_BITS_MAX_ENUM_EXT:
    VkSurfaceCounterFlagBitsEXT = 2147483647;
pub type VkSurfaceCounterFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkSurfaceCounterFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceCapabilities2EXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minImageCount: u32,
    pub maxImageCount: u32,
    pub currentExtent: VkExtent2D,
    pub minImageExtent: VkExtent2D,
    pub maxImageExtent: VkExtent2D,
    pub maxImageArrayLayers: u32,
    pub supportedTransforms: VkSurfaceTransformFlagsKHR,
    pub currentTransform: VkSurfaceTransformFlagBitsKHR,
    pub supportedCompositeAlpha: VkCompositeAlphaFlagsKHR,
    pub supportedUsageFlags: VkImageUsageFlags,
    pub supportedSurfaceCounters: VkSurfaceCounterFlagsEXT,
}
pub type PFN_vkGetPhysicalDeviceSurfaceCapabilities2EXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        surface: VkSurfaceKHR,
        pSurfaceCapabilities: *mut VkSurfaceCapabilities2EXT,
    ) -> VkResult
;
pub const VK_DISPLAY_POWER_STATE_OFF_EXT: VkDisplayPowerStateEXT = 0;
pub const VK_DISPLAY_POWER_STATE_SUSPEND_EXT: VkDisplayPowerStateEXT = 1;
pub const VK_DISPLAY_POWER_STATE_ON_EXT: VkDisplayPowerStateEXT = 2;
pub const VK_DISPLAY_POWER_STATE_MAX_ENUM_EXT: VkDisplayPowerStateEXT =
    2147483647;
pub type VkDisplayPowerStateEXT = ::std::os::raw::c_uint;
pub const VK_DEVICE_EVENT_TYPE_DISPLAY_HOTPLUG_EXT: VkDeviceEventTypeEXT = 0;
pub const VK_DEVICE_EVENT_TYPE_MAX_ENUM_EXT: VkDeviceEventTypeEXT = 2147483647;
pub type VkDeviceEventTypeEXT = ::std::os::raw::c_uint;
pub const VK_DISPLAY_EVENT_TYPE_FIRST_PIXEL_OUT_EXT: VkDisplayEventTypeEXT =
    0;
pub const VK_DISPLAY_EVENT_TYPE_MAX_ENUM_EXT: VkDisplayEventTypeEXT =
    2147483647;
pub type VkDisplayEventTypeEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayPowerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub powerState: VkDisplayPowerStateEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceEventInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceEvent: VkDeviceEventTypeEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayEventInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub displayEvent: VkDisplayEventTypeEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainCounterCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub surfaceCounters: VkSurfaceCounterFlagsEXT,
}
pub type PFN_vkDisplayPowerControlEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        display: VkDisplayKHR,
        pDisplayPowerInfo: *const VkDisplayPowerInfoEXT,
    ) -> VkResult
;
pub type PFN_vkRegisterDeviceEventEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pDeviceEventInfo: *const VkDeviceEventInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult
;
pub type PFN_vkRegisterDisplayEventEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        display: VkDisplayKHR,
        pDisplayEventInfo: *const VkDisplayEventInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult
;
pub type PFN_vkGetSwapchainCounterEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        counter: VkSurfaceCounterFlagBitsEXT,
        pCounterValue: *mut u64,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRefreshCycleDurationGOOGLE {
    pub refreshDuration: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPastPresentationTimingGOOGLE {
    pub presentID: u32,
    pub desiredPresentTime: u64,
    pub actualPresentTime: u64,
    pub earliestPresentTime: u64,
    pub presentMargin: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentTimeGOOGLE {
    pub presentID: u32,
    pub desiredPresentTime: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPresentTimesInfoGOOGLE {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub swapchainCount: u32,
    pub pTimes: *const VkPresentTimeGOOGLE,
}
pub type PFN_vkGetRefreshCycleDurationGOOGLE = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pDisplayTimingProperties: *mut VkRefreshCycleDurationGOOGLE,
    ) -> VkResult
;
pub type PFN_vkGetPastPresentationTimingGOOGLE = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchain: VkSwapchainKHR,
        pPresentationTimingCount: *mut u32,
        pPresentationTimings: *mut VkPastPresentationTimingGOOGLE,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub perViewPositionAllComponents: VkBool32,
}
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_X_NV:
    VkViewportCoordinateSwizzleNV = 0;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_X_NV:
    VkViewportCoordinateSwizzleNV = 1;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Y_NV:
    VkViewportCoordinateSwizzleNV = 2;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Y_NV:
    VkViewportCoordinateSwizzleNV = 3;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_Z_NV:
    VkViewportCoordinateSwizzleNV = 4;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_Z_NV:
    VkViewportCoordinateSwizzleNV = 5;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_POSITIVE_W_NV:
    VkViewportCoordinateSwizzleNV = 6;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_NEGATIVE_W_NV:
    VkViewportCoordinateSwizzleNV = 7;
pub const VK_VIEWPORT_COORDINATE_SWIZZLE_MAX_ENUM_NV:
    VkViewportCoordinateSwizzleNV = 2147483647;
pub type VkViewportCoordinateSwizzleNV = ::std::os::raw::c_uint;
pub type VkPipelineViewportSwizzleStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViewportSwizzleNV {
    pub x: VkViewportCoordinateSwizzleNV,
    pub y: VkViewportCoordinateSwizzleNV,
    pub z: VkViewportCoordinateSwizzleNV,
    pub w: VkViewportCoordinateSwizzleNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportSwizzleStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineViewportSwizzleStateCreateFlagsNV,
    pub viewportCount: u32,
    pub pViewportSwizzles: *const VkViewportSwizzleNV,
}
pub const VK_DISCARD_RECTANGLE_MODE_INCLUSIVE_EXT:
    VkDiscardRectangleModeEXT = 0;
pub const VK_DISCARD_RECTANGLE_MODE_EXCLUSIVE_EXT:
    VkDiscardRectangleModeEXT = 1;
pub const VK_DISCARD_RECTANGLE_MODE_MAX_ENUM_EXT:
    VkDiscardRectangleModeEXT = 2147483647;
pub type VkDiscardRectangleModeEXT = ::std::os::raw::c_uint;
pub type VkPipelineDiscardRectangleStateCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDiscardRectanglePropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxDiscardRectangles: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDiscardRectangleStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDiscardRectangleStateCreateFlagsEXT,
    pub discardRectangleMode: VkDiscardRectangleModeEXT,
    pub discardRectangleCount: u32,
    pub pDiscardRectangles: *const VkRect2D,
}
pub type PFN_vkCmdSetDiscardRectangleEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstDiscardRectangle: u32,
        discardRectangleCount: u32,
        pDiscardRectangles: *const VkRect2D,
    )
;
pub const VK_CONSERVATIVE_RASTERIZATION_MODE_DISABLED_EXT:
    VkConservativeRasterizationModeEXT = 0;
pub const VK_CONSERVATIVE_RASTERIZATION_MODE_OVERESTIMATE_EXT:
    VkConservativeRasterizationModeEXT = 1;
pub const VK_CONSERVATIVE_RASTERIZATION_MODE_UNDERESTIMATE_EXT : VkConservativeRasterizationModeEXT = 2 ;
pub const VK_CONSERVATIVE_RASTERIZATION_MODE_MAX_ENUM_EXT:
    VkConservativeRasterizationModeEXT = 2147483647;
pub type VkConservativeRasterizationModeEXT = ::std::os::raw::c_uint;
pub type VkPipelineRasterizationConservativeStateCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub primitiveOverestimationSize: f32,
    pub maxExtraPrimitiveOverestimationSize: f32,
    pub extraPrimitiveOverestimationSizeGranularity: f32,
    pub primitiveUnderestimation: VkBool32,
    pub conservativePointAndLineRasterization: VkBool32,
    pub degenerateTrianglesRasterized: VkBool32,
    pub degenerateLinesRasterized: VkBool32,
    pub fullyCoveredFragmentShaderInputVariable: VkBool32,
    pub conservativeRasterizationPostDepthCoverage: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationConservativeStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationConservativeStateCreateFlagsEXT,
    pub conservativeRasterizationMode: VkConservativeRasterizationModeEXT,
    pub extraPrimitiveOverestimationSize: f32,
}
pub type VkPipelineRasterizationDepthClipStateCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDepthClipEnableFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub depthClipEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationDepthClipStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationDepthClipStateCreateFlagsEXT,
    pub depthClipEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkXYColorEXT {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkHdrMetadataEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub displayPrimaryRed: VkXYColorEXT,
    pub displayPrimaryGreen: VkXYColorEXT,
    pub displayPrimaryBlue: VkXYColorEXT,
    pub whitePoint: VkXYColorEXT,
    pub maxLuminance: f32,
    pub minLuminance: f32,
    pub maxContentLightLevel: f32,
    pub maxFrameAverageLightLevel: f32,
}
pub type PFN_vkSetHdrMetadataEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        swapchainCount: u32,
        pSwapchains: *const VkSwapchainKHR,
        pMetadata: *const VkHdrMetadataEXT,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsMessengerEXT_T {
    _unused: [u8; 0],
}
pub type VkDebugUtilsMessengerEXT = *mut VkDebugUtilsMessengerEXT_T;
pub type VkDebugUtilsMessengerCallbackDataFlagsEXT = VkFlags;
pub const VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 1;
pub const VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 16;
pub const VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 256;
pub const VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT:
    VkDebugUtilsMessageSeverityFlagBitsEXT = 4096;
pub const VK_DEBUG_UTILS_MESSAGE_SEVERITY_FLAG_BITS_MAX_ENUM_EXT : VkDebugUtilsMessageSeverityFlagBitsEXT = 2147483647 ;
pub type VkDebugUtilsMessageSeverityFlagBitsEXT = ::std::os::raw::c_uint;
pub const VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 1;
pub const VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 2;
pub const VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 4;
pub const VK_DEBUG_UTILS_MESSAGE_TYPE_FLAG_BITS_MAX_ENUM_EXT:
    VkDebugUtilsMessageTypeFlagBitsEXT = 2147483647;
pub type VkDebugUtilsMessageTypeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkDebugUtilsMessageTypeFlagsEXT = VkFlags;
pub type VkDebugUtilsMessageSeverityFlagsEXT = VkFlags;
pub type VkDebugUtilsMessengerCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsLabelEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pLabelName: *const ::std::os::raw::c_char,
    pub color: [f32; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsObjectNameInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkObjectType,
    pub objectHandle: u64,
    pub pObjectName: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsMessengerCallbackDataEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDebugUtilsMessengerCallbackDataFlagsEXT,
    pub pMessageIdName: *const ::std::os::raw::c_char,
    pub messageIdNumber: i32,
    pub pMessage: *const ::std::os::raw::c_char,
    pub queueLabelCount: u32,
    pub pQueueLabels: *const VkDebugUtilsLabelEXT,
    pub cmdBufLabelCount: u32,
    pub pCmdBufLabels: *const VkDebugUtilsLabelEXT,
    pub objectCount: u32,
    pub pObjects: *const VkDebugUtilsObjectNameInfoEXT,
}
pub type PFN_vkDebugUtilsMessengerCallbackEXT = 
    unsafe extern "C" fn(
        messageSeverity: VkDebugUtilsMessageSeverityFlagBitsEXT,
        messageTypes: VkDebugUtilsMessageTypeFlagsEXT,
        pCallbackData: *const VkDebugUtilsMessengerCallbackDataEXT,
        pUserData: *mut ::std::os::raw::c_void,
    ) -> VkBool32
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsMessengerCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDebugUtilsMessengerCreateFlagsEXT,
    pub messageSeverity: VkDebugUtilsMessageSeverityFlagsEXT,
    pub messageType: VkDebugUtilsMessageTypeFlagsEXT,
    pub pfnUserCallback: PFN_vkDebugUtilsMessengerCallbackEXT,
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDebugUtilsObjectTagInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub objectType: VkObjectType,
    pub objectHandle: u64,
    pub tagName: u64,
    pub tagSize: size_t,
    pub pTag: *const ::std::os::raw::c_void,
}
pub type PFN_vkSetDebugUtilsObjectNameEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pNameInfo: *const VkDebugUtilsObjectNameInfoEXT,
    ) -> VkResult
;
pub type PFN_vkSetDebugUtilsObjectTagEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pTagInfo: *const VkDebugUtilsObjectTagInfoEXT,
    ) -> VkResult
;
pub type PFN_vkQueueBeginDebugUtilsLabelEXT = 
    unsafe extern "C" fn(queue: VkQueue, pLabelInfo: *const VkDebugUtilsLabelEXT)
;
pub type PFN_vkQueueEndDebugUtilsLabelEXT =
    unsafe extern "C" fn(queue: VkQueue);
pub type PFN_vkQueueInsertDebugUtilsLabelEXT = 
    unsafe extern "C" fn(queue: VkQueue, pLabelInfo: *const VkDebugUtilsLabelEXT)
;
pub type PFN_vkCmdBeginDebugUtilsLabelEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pLabelInfo: *const VkDebugUtilsLabelEXT)
;
pub type PFN_vkCmdEndDebugUtilsLabelEXT =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer);
pub type PFN_vkCmdInsertDebugUtilsLabelEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pLabelInfo: *const VkDebugUtilsLabelEXT)
;
pub type PFN_vkCreateDebugUtilsMessengerEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkDebugUtilsMessengerCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pMessenger: *mut VkDebugUtilsMessengerEXT,
    ) -> VkResult
;
pub type PFN_vkDestroyDebugUtilsMessengerEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        messenger: VkDebugUtilsMessengerEXT,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkSubmitDebugUtilsMessageEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        messageSeverity: VkDebugUtilsMessageSeverityFlagBitsEXT,
        messageTypes: VkDebugUtilsMessageTypeFlagsEXT,
        pCallbackData: *const VkDebugUtilsMessengerCallbackDataEXT,
    )
;
pub use self::VkSamplerReductionMode as VkSamplerReductionModeEXT;
pub type VkSamplerReductionModeCreateInfoEXT = VkSamplerReductionModeCreateInfo;
pub type VkPhysicalDeviceSamplerFilterMinmaxPropertiesEXT =
    VkPhysicalDeviceSamplerFilterMinmaxProperties;
pub type VkPhysicalDeviceInlineUniformBlockFeaturesEXT = VkPhysicalDeviceInlineUniformBlockFeatures;
pub type VkPhysicalDeviceInlineUniformBlockPropertiesEXT =
    VkPhysicalDeviceInlineUniformBlockProperties;
pub type VkWriteDescriptorSetInlineUniformBlockEXT = VkWriteDescriptorSetInlineUniformBlock;
pub type VkDescriptorPoolInlineUniformBlockCreateInfoEXT =
    VkDescriptorPoolInlineUniformBlockCreateInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSampleLocationEXT {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSampleLocationsInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub sampleLocationsPerPixel: VkSampleCountFlagBits,
    pub sampleLocationGridSize: VkExtent2D,
    pub sampleLocationsCount: u32,
    pub pSampleLocations: *const VkSampleLocationEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentSampleLocationsEXT {
    pub attachmentIndex: u32,
    pub sampleLocationsInfo: VkSampleLocationsInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassSampleLocationsEXT {
    pub subpassIndex: u32,
    pub sampleLocationsInfo: VkSampleLocationsInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassSampleLocationsBeginInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentInitialSampleLocationsCount: u32,
    pub pAttachmentInitialSampleLocations: *const VkAttachmentSampleLocationsEXT,
    pub postSubpassSampleLocationsCount: u32,
    pub pPostSubpassSampleLocations: *const VkSubpassSampleLocationsEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineSampleLocationsStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub sampleLocationsEnable: VkBool32,
    pub sampleLocationsInfo: VkSampleLocationsInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSampleLocationsPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub sampleLocationSampleCounts: VkSampleCountFlags,
    pub maxSampleLocationGridSize: VkExtent2D,
    pub sampleLocationCoordinateRange: [f32; 2usize],
    pub sampleLocationSubPixelBits: u32,
    pub variableSampleLocations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMultisamplePropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxSampleLocationGridSize: VkExtent2D,
}
pub type PFN_vkCmdSetSampleLocationsEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pSampleLocationsInfo: *const VkSampleLocationsInfoEXT,
    )
;
pub type PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        samples: VkSampleCountFlagBits,
        pMultisampleProperties: *mut VkMultisamplePropertiesEXT,
    )
;
pub const VK_BLEND_OVERLAP_UNCORRELATED_EXT: VkBlendOverlapEXT = 0;
pub const VK_BLEND_OVERLAP_DISJOINT_EXT: VkBlendOverlapEXT = 1;
pub const VK_BLEND_OVERLAP_CONJOINT_EXT: VkBlendOverlapEXT = 2;
pub const VK_BLEND_OVERLAP_MAX_ENUM_EXT: VkBlendOverlapEXT = 2147483647;
pub type VkBlendOverlapEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub advancedBlendCoherentOperations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub advancedBlendMaxColorAttachments: u32,
    pub advancedBlendIndependentBlend: VkBool32,
    pub advancedBlendNonPremultipliedSrcColor: VkBool32,
    pub advancedBlendNonPremultipliedDstColor: VkBool32,
    pub advancedBlendCorrelatedOverlap: VkBool32,
    pub advancedBlendAllOperations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendAdvancedStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcPremultiplied: VkBool32,
    pub dstPremultiplied: VkBool32,
    pub blendOverlap: VkBlendOverlapEXT,
}
pub type VkPipelineCoverageToColorStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCoverageToColorStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCoverageToColorStateCreateFlagsNV,
    pub coverageToColorEnable: VkBool32,
    pub coverageToColorLocation: u32,
}
pub const VK_COVERAGE_MODULATION_MODE_NONE_NV:
    VkCoverageModulationModeNV = 0;
pub const VK_COVERAGE_MODULATION_MODE_RGB_NV:
    VkCoverageModulationModeNV = 1;
pub const VK_COVERAGE_MODULATION_MODE_ALPHA_NV:
    VkCoverageModulationModeNV = 2;
pub const VK_COVERAGE_MODULATION_MODE_RGBA_NV:
    VkCoverageModulationModeNV = 3;
pub const VK_COVERAGE_MODULATION_MODE_MAX_ENUM_NV:
    VkCoverageModulationModeNV = 2147483647;
pub type VkCoverageModulationModeNV = ::std::os::raw::c_uint;
pub type VkPipelineCoverageModulationStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCoverageModulationStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCoverageModulationStateCreateFlagsNV,
    pub coverageModulationMode: VkCoverageModulationModeNV,
    pub coverageModulationTableEnable: VkBool32,
    pub coverageModulationTableCount: u32,
    pub pCoverageModulationTable: *const f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSMBuiltinsPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSMCount: u32,
    pub shaderWarpsPerSM: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSMBuiltinsFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSMBuiltins: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrmFormatModifierPropertiesEXT {
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub drmFormatModifierTilingFeatures: VkFormatFeatureFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrmFormatModifierPropertiesListEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifierProperties: *mut VkDrmFormatModifierPropertiesEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub drmFormatModifier: u64,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageDrmFormatModifierListCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifiers: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageDrmFormatModifierExplicitCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub pPlaneLayouts: *const VkSubresourceLayout,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageDrmFormatModifierPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub drmFormatModifier: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrmFormatModifierProperties2EXT {
    pub drmFormatModifier: u64,
    pub drmFormatModifierPlaneCount: u32,
    pub drmFormatModifierTilingFeatures: VkFormatFeatureFlags2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrmFormatModifierPropertiesList2EXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub drmFormatModifierCount: u32,
    pub pDrmFormatModifierProperties: *mut VkDrmFormatModifierProperties2EXT,
}
pub type PFN_vkGetImageDrmFormatModifierPropertiesEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pProperties: *mut VkImageDrmFormatModifierPropertiesEXT,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationCacheEXT_T {
    _unused: [u8; 0],
}
pub type VkValidationCacheEXT = *mut VkValidationCacheEXT_T;
pub const VK_VALIDATION_CACHE_HEADER_VERSION_ONE_EXT:
    VkValidationCacheHeaderVersionEXT = 1;
pub const VK_VALIDATION_CACHE_HEADER_VERSION_MAX_ENUM_EXT:
    VkValidationCacheHeaderVersionEXT = 2147483647;
pub type VkValidationCacheHeaderVersionEXT = ::std::os::raw::c_uint;
pub type VkValidationCacheCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationCacheCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkValidationCacheCreateFlagsEXT,
    pub initialDataSize: size_t,
    pub pInitialData: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModuleValidationCacheCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub validationCache: VkValidationCacheEXT,
}
pub type PFN_vkCreateValidationCacheEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkValidationCacheCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pValidationCache: *mut VkValidationCacheEXT,
    ) -> VkResult
;
pub type PFN_vkDestroyValidationCacheEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        validationCache: VkValidationCacheEXT,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkMergeValidationCachesEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        dstCache: VkValidationCacheEXT,
        srcCacheCount: u32,
        pSrcCaches: *const VkValidationCacheEXT,
    ) -> VkResult
;
pub type PFN_vkGetValidationCacheDataEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        validationCache: VkValidationCacheEXT,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult
;
pub use self::VkDescriptorBindingFlagBits as VkDescriptorBindingFlagBitsEXT;
pub type VkDescriptorBindingFlagsEXT = VkDescriptorBindingFlags;
pub type VkDescriptorSetLayoutBindingFlagsCreateInfoEXT =
    VkDescriptorSetLayoutBindingFlagsCreateInfo;
pub type VkPhysicalDeviceDescriptorIndexingFeaturesEXT = VkPhysicalDeviceDescriptorIndexingFeatures;
pub type VkPhysicalDeviceDescriptorIndexingPropertiesEXT =
    VkPhysicalDeviceDescriptorIndexingProperties;
pub type VkDescriptorSetVariableDescriptorCountAllocateInfoEXT =
    VkDescriptorSetVariableDescriptorCountAllocateInfo;
pub type VkDescriptorSetVariableDescriptorCountLayoutSupportEXT =
    VkDescriptorSetVariableDescriptorCountLayoutSupport;
pub const VK_SHADING_RATE_PALETTE_ENTRY_NO_INVOCATIONS_NV:
    VkShadingRatePaletteEntryNV = 0;
pub const VK_SHADING_RATE_PALETTE_ENTRY_16_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 1;
pub const VK_SHADING_RATE_PALETTE_ENTRY_8_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 2;
pub const VK_SHADING_RATE_PALETTE_ENTRY_4_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 3;
pub const VK_SHADING_RATE_PALETTE_ENTRY_2_INVOCATIONS_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 4;
pub const VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_PIXEL_NV:
    VkShadingRatePaletteEntryNV = 5;
pub const VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X1_PIXELS_NV : VkShadingRatePaletteEntryNV = 6 ;
pub const VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_1X2_PIXELS_NV : VkShadingRatePaletteEntryNV = 7 ;
pub const VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X2_PIXELS_NV : VkShadingRatePaletteEntryNV = 8 ;
pub const VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X2_PIXELS_NV : VkShadingRatePaletteEntryNV = 9 ;
pub const VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_2X4_PIXELS_NV : VkShadingRatePaletteEntryNV = 10 ;
pub const VK_SHADING_RATE_PALETTE_ENTRY_1_INVOCATION_PER_4X4_PIXELS_NV : VkShadingRatePaletteEntryNV = 11 ;
pub const VK_SHADING_RATE_PALETTE_ENTRY_MAX_ENUM_NV:
    VkShadingRatePaletteEntryNV = 2147483647;
pub type VkShadingRatePaletteEntryNV = ::std::os::raw::c_uint;
pub const VK_COARSE_SAMPLE_ORDER_TYPE_DEFAULT_NV:
    VkCoarseSampleOrderTypeNV = 0;
pub const VK_COARSE_SAMPLE_ORDER_TYPE_CUSTOM_NV:
    VkCoarseSampleOrderTypeNV = 1;
pub const VK_COARSE_SAMPLE_ORDER_TYPE_PIXEL_MAJOR_NV:
    VkCoarseSampleOrderTypeNV = 2;
pub const VK_COARSE_SAMPLE_ORDER_TYPE_SAMPLE_MAJOR_NV:
    VkCoarseSampleOrderTypeNV = 3;
pub const VK_COARSE_SAMPLE_ORDER_TYPE_MAX_ENUM_NV:
    VkCoarseSampleOrderTypeNV = 2147483647;
pub type VkCoarseSampleOrderTypeNV = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShadingRatePaletteNV {
    pub shadingRatePaletteEntryCount: u32,
    pub pShadingRatePaletteEntries: *const VkShadingRatePaletteEntryNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportShadingRateImageStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub shadingRateImageEnable: VkBool32,
    pub viewportCount: u32,
    pub pShadingRatePalettes: *const VkShadingRatePaletteNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShadingRateImageFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shadingRateImage: VkBool32,
    pub shadingRateCoarseSampleOrder: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShadingRateImagePropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shadingRateTexelSize: VkExtent2D,
    pub shadingRatePaletteSize: u32,
    pub shadingRateMaxCoarseSamples: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCoarseSampleLocationNV {
    pub pixelX: u32,
    pub pixelY: u32,
    pub sample: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCoarseSampleOrderCustomNV {
    pub shadingRate: VkShadingRatePaletteEntryNV,
    pub sampleCount: u32,
    pub sampleLocationCount: u32,
    pub pSampleLocations: *const VkCoarseSampleLocationNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportCoarseSampleOrderStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub sampleOrderType: VkCoarseSampleOrderTypeNV,
    pub customSampleOrderCount: u32,
    pub pCustomSampleOrders: *const VkCoarseSampleOrderCustomNV,
}
pub type PFN_vkCmdBindShadingRateImageNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        imageView: VkImageView,
        imageLayout: VkImageLayout,
    )
;
pub type PFN_vkCmdSetViewportShadingRatePaletteNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pShadingRatePalettes: *const VkShadingRatePaletteNV,
    )
;
pub type PFN_vkCmdSetCoarseSampleOrderNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        sampleOrderType: VkCoarseSampleOrderTypeNV,
        customSampleOrderCount: u32,
        pCustomSampleOrders: *const VkCoarseSampleOrderCustomNV,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureNV_T {
    _unused: [u8; 0],
}
pub type VkAccelerationStructureNV = *mut VkAccelerationStructureNV_T;
pub const VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_KHR:
    VkRayTracingShaderGroupTypeKHR = 0;
pub const VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_KHR : VkRayTracingShaderGroupTypeKHR = 1 ;
pub const VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_KHR : VkRayTracingShaderGroupTypeKHR = 2 ;
pub const VK_RAY_TRACING_SHADER_GROUP_TYPE_GENERAL_NV:
    VkRayTracingShaderGroupTypeKHR = 0;
pub const VK_RAY_TRACING_SHADER_GROUP_TYPE_TRIANGLES_HIT_GROUP_NV:
    VkRayTracingShaderGroupTypeKHR = 1;
pub const VK_RAY_TRACING_SHADER_GROUP_TYPE_PROCEDURAL_HIT_GROUP_NV : VkRayTracingShaderGroupTypeKHR = 2 ;
pub const VK_RAY_TRACING_SHADER_GROUP_TYPE_MAX_ENUM_KHR:
    VkRayTracingShaderGroupTypeKHR = 2147483647;
pub type VkRayTracingShaderGroupTypeKHR = ::std::os::raw::c_uint;
pub use self::VkRayTracingShaderGroupTypeKHR as VkRayTracingShaderGroupTypeNV;
pub const VK_GEOMETRY_TYPE_TRIANGLES_KHR: VkGeometryTypeKHR = 0;
pub const VK_GEOMETRY_TYPE_AABBS_KHR: VkGeometryTypeKHR = 1;
pub const VK_GEOMETRY_TYPE_INSTANCES_KHR: VkGeometryTypeKHR = 2;
pub const VK_GEOMETRY_TYPE_TRIANGLES_NV: VkGeometryTypeKHR = 0;
pub const VK_GEOMETRY_TYPE_AABBS_NV: VkGeometryTypeKHR = 1;
pub const VK_GEOMETRY_TYPE_MAX_ENUM_KHR: VkGeometryTypeKHR = 2147483647;
pub type VkGeometryTypeKHR = ::std::os::raw::c_uint;
pub use self::VkGeometryTypeKHR as VkGeometryTypeNV;
pub const VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_KHR:
    VkAccelerationStructureTypeKHR = 0;
pub const VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_KHR:
    VkAccelerationStructureTypeKHR = 1;
pub const VK_ACCELERATION_STRUCTURE_TYPE_GENERIC_KHR:
    VkAccelerationStructureTypeKHR = 2;
pub const VK_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL_NV:
    VkAccelerationStructureTypeKHR = 0;
pub const VK_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL_NV:
    VkAccelerationStructureTypeKHR = 1;
pub const VK_ACCELERATION_STRUCTURE_TYPE_MAX_ENUM_KHR:
    VkAccelerationStructureTypeKHR = 2147483647;
pub type VkAccelerationStructureTypeKHR = ::std::os::raw::c_uint;
pub use self::VkAccelerationStructureTypeKHR as VkAccelerationStructureTypeNV;
pub const VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_KHR:
    VkCopyAccelerationStructureModeKHR = 0;
pub const VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_KHR:
    VkCopyAccelerationStructureModeKHR = 1;
pub const VK_COPY_ACCELERATION_STRUCTURE_MODE_SERIALIZE_KHR:
    VkCopyAccelerationStructureModeKHR = 2;
pub const VK_COPY_ACCELERATION_STRUCTURE_MODE_DESERIALIZE_KHR:
    VkCopyAccelerationStructureModeKHR = 3;
pub const VK_COPY_ACCELERATION_STRUCTURE_MODE_CLONE_NV:
    VkCopyAccelerationStructureModeKHR = 0;
pub const VK_COPY_ACCELERATION_STRUCTURE_MODE_COMPACT_NV:
    VkCopyAccelerationStructureModeKHR = 1;
pub const VK_COPY_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR:
    VkCopyAccelerationStructureModeKHR = 2147483647;
pub type VkCopyAccelerationStructureModeKHR = ::std::os::raw::c_uint;
pub use self::VkCopyAccelerationStructureModeKHR as VkCopyAccelerationStructureModeNV;
pub const VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_OBJECT_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 0 ;
pub const VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_BUILD_SCRATCH_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 1 ;
pub const VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_UPDATE_SCRATCH_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 2 ;
pub const VK_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_TYPE_MAX_ENUM_NV : VkAccelerationStructureMemoryRequirementsTypeNV = 2147483647 ;
pub type VkAccelerationStructureMemoryRequirementsTypeNV = ::std::os::raw::c_uint;
pub const VK_GEOMETRY_OPAQUE_BIT_KHR: VkGeometryFlagBitsKHR = 1;
pub const VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_KHR:
    VkGeometryFlagBitsKHR = 2;
pub const VK_GEOMETRY_OPAQUE_BIT_NV: VkGeometryFlagBitsKHR = 1;
pub const VK_GEOMETRY_NO_DUPLICATE_ANY_HIT_INVOCATION_BIT_NV:
    VkGeometryFlagBitsKHR = 2;
pub const VK_GEOMETRY_FLAG_BITS_MAX_ENUM_KHR: VkGeometryFlagBitsKHR =
    2147483647;
pub type VkGeometryFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkGeometryFlagsKHR = VkFlags;
pub type VkGeometryFlagsNV = VkGeometryFlagsKHR;
pub use self::VkGeometryFlagBitsKHR as VkGeometryFlagBitsNV;
pub const VK_GEOMETRY_INSTANCE_TRIANGLE_FACING_CULL_DISABLE_BIT_KHR : VkGeometryInstanceFlagBitsKHR = 1 ;
pub const VK_GEOMETRY_INSTANCE_TRIANGLE_FLIP_FACING_BIT_KHR:
    VkGeometryInstanceFlagBitsKHR = 2;
pub const VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_KHR:
    VkGeometryInstanceFlagBitsKHR = 4;
pub const VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_KHR:
    VkGeometryInstanceFlagBitsKHR = 8;
pub const VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_KHR : VkGeometryInstanceFlagBitsKHR = 2 ;
pub const VK_GEOMETRY_INSTANCE_TRIANGLE_CULL_DISABLE_BIT_NV:
    VkGeometryInstanceFlagBitsKHR = 1;
pub const VK_GEOMETRY_INSTANCE_TRIANGLE_FRONT_COUNTERCLOCKWISE_BIT_NV : VkGeometryInstanceFlagBitsKHR = 2 ;
pub const VK_GEOMETRY_INSTANCE_FORCE_OPAQUE_BIT_NV:
    VkGeometryInstanceFlagBitsKHR = 4;
pub const VK_GEOMETRY_INSTANCE_FORCE_NO_OPAQUE_BIT_NV:
    VkGeometryInstanceFlagBitsKHR = 8;
pub const VK_GEOMETRY_INSTANCE_FLAG_BITS_MAX_ENUM_KHR:
    VkGeometryInstanceFlagBitsKHR = 2147483647;
pub type VkGeometryInstanceFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkGeometryInstanceFlagsKHR = VkFlags;
pub type VkGeometryInstanceFlagsNV = VkGeometryInstanceFlagsKHR;
pub use self::VkGeometryInstanceFlagBitsKHR as VkGeometryInstanceFlagBitsNV;
pub const VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 1 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 2 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 4 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 8 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_KHR : VkBuildAccelerationStructureFlagBitsKHR = 16 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_MOTION_BIT_NV:
    VkBuildAccelerationStructureFlagBitsKHR = 32;
pub const VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_UPDATE_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 1 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_ALLOW_COMPACTION_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 2 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_TRACE_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 4 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_PREFER_FAST_BUILD_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 8 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_LOW_MEMORY_BIT_NV : VkBuildAccelerationStructureFlagBitsKHR = 16 ;
pub const VK_BUILD_ACCELERATION_STRUCTURE_FLAG_BITS_MAX_ENUM_KHR : VkBuildAccelerationStructureFlagBitsKHR = 2147483647 ;
pub type VkBuildAccelerationStructureFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkBuildAccelerationStructureFlagsKHR = VkFlags;
pub type VkBuildAccelerationStructureFlagsNV = VkBuildAccelerationStructureFlagsKHR;
pub use self::VkBuildAccelerationStructureFlagBitsKHR as VkBuildAccelerationStructureFlagBitsNV;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingShaderGroupCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkRayTracingShaderGroupTypeKHR,
    pub generalShader: u32,
    pub closestHitShader: u32,
    pub anyHitShader: u32,
    pub intersectionShader: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingPipelineCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub groupCount: u32,
    pub pGroups: *const VkRayTracingShaderGroupCreateInfoNV,
    pub maxRecursionDepth: u32,
    pub layout: VkPipelineLayout,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryTrianglesNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vertexData: VkBuffer,
    pub vertexOffset: VkDeviceSize,
    pub vertexCount: u32,
    pub vertexStride: VkDeviceSize,
    pub vertexFormat: VkFormat,
    pub indexData: VkBuffer,
    pub indexOffset: VkDeviceSize,
    pub indexCount: u32,
    pub indexType: VkIndexType,
    pub transformData: VkBuffer,
    pub transformOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryAABBNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub aabbData: VkBuffer,
    pub numAABBs: u32,
    pub stride: u32,
    pub offset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryDataNV {
    pub triangles: VkGeometryTrianglesNV,
    pub aabbs: VkGeometryAABBNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeometryNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub geometryType: VkGeometryTypeKHR,
    pub geometry: VkGeometryDataNV,
    pub flags: VkGeometryFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkAccelerationStructureTypeNV,
    pub flags: VkBuildAccelerationStructureFlagsNV,
    pub instanceCount: u32,
    pub geometryCount: u32,
    pub pGeometries: *const VkGeometryNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub compactedSize: VkDeviceSize,
    pub info: VkAccelerationStructureInfoNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindAccelerationStructureMemoryInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructure: VkAccelerationStructureNV,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSetAccelerationStructureNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructureCount: u32,
    pub pAccelerationStructures: *const VkAccelerationStructureNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureMemoryRequirementsInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkAccelerationStructureMemoryRequirementsTypeNV,
    pub accelerationStructure: VkAccelerationStructureNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayTracingPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderGroupHandleSize: u32,
    pub maxRecursionDepth: u32,
    pub maxShaderGroupStride: u32,
    pub shaderGroupBaseAlignment: u32,
    pub maxGeometryCount: u64,
    pub maxInstanceCount: u64,
    pub maxTriangleCount: u64,
    pub maxDescriptorSetAccelerationStructures: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTransformMatrixKHR {
    pub matrix: [[f32; 4usize]; 3usize],
}
pub type VkTransformMatrixNV = VkTransformMatrixKHR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAabbPositionsKHR {
    pub minX: f32,
    pub minY: f32,
    pub minZ: f32,
    pub maxX: f32,
    pub maxY: f32,
    pub maxZ: f32,
}
pub type VkAabbPositionsNV = VkAabbPositionsKHR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureInstanceKHR {
    pub transform: VkTransformMatrixKHR,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub accelerationStructureReference: u64,
}
impl VkAccelerationStructureInstanceKHR {
    #[inline]
    pub fn instanceCustomIndex(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceCustomIndex(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn instanceShaderBindingTableRecordOffset(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceShaderBindingTableRecordOffset(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> VkGeometryInstanceFlagsKHR {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: VkGeometryInstanceFlagsKHR) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        instanceCustomIndex: u32,
        mask: u32,
        instanceShaderBindingTableRecordOffset: u32,
        flags: VkGeometryInstanceFlagsKHR,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let instanceCustomIndex: u32 = unsafe { ::std::mem::transmute(instanceCustomIndex) };
            instanceCustomIndex as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mask: u32 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(32usize, 24u8, {
            let instanceShaderBindingTableRecordOffset: u32 =
                unsafe { ::std::mem::transmute(instanceShaderBindingTableRecordOffset) };
            instanceShaderBindingTableRecordOffset as u64
        });
        __bindgen_bitfield_unit.set(56usize, 8u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type VkAccelerationStructureInstanceNV = VkAccelerationStructureInstanceKHR;
pub type PFN_vkCreateAccelerationStructureNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkAccelerationStructureCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pAccelerationStructure: *mut VkAccelerationStructureNV,
    ) -> VkResult
;
pub type PFN_vkDestroyAccelerationStructureNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureNV,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetAccelerationStructureMemoryRequirementsNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkAccelerationStructureMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut VkMemoryRequirements2KHR,
    )
;
pub type PFN_vkBindAccelerationStructureMemoryNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindAccelerationStructureMemoryInfoNV,
    ) -> VkResult
;
pub type PFN_vkCmdBuildAccelerationStructureNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkAccelerationStructureInfoNV,
        instanceData: VkBuffer,
        instanceOffset: VkDeviceSize,
        update: VkBool32,
        dst: VkAccelerationStructureNV,
        src: VkAccelerationStructureNV,
        scratch: VkBuffer,
        scratchOffset: VkDeviceSize,
    )
;
pub type PFN_vkCmdCopyAccelerationStructureNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dst: VkAccelerationStructureNV,
        src: VkAccelerationStructureNV,
        mode: VkCopyAccelerationStructureModeKHR,
    )
;
pub type PFN_vkCmdTraceRaysNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        raygenShaderBindingTableBuffer: VkBuffer,
        raygenShaderBindingOffset: VkDeviceSize,
        missShaderBindingTableBuffer: VkBuffer,
        missShaderBindingOffset: VkDeviceSize,
        missShaderBindingStride: VkDeviceSize,
        hitShaderBindingTableBuffer: VkBuffer,
        hitShaderBindingOffset: VkDeviceSize,
        hitShaderBindingStride: VkDeviceSize,
        callableShaderBindingTableBuffer: VkBuffer,
        callableShaderBindingOffset: VkDeviceSize,
        callableShaderBindingStride: VkDeviceSize,
        width: u32,
        height: u32,
        depth: u32,
    )
;
pub type PFN_vkCreateRayTracingPipelinesNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkRayTracingPipelineCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult
;
pub type PFN_vkGetRayTracingShaderGroupHandlesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult
;
pub type PFN_vkGetRayTracingShaderGroupHandlesNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult
;
pub type PFN_vkGetAccelerationStructureHandleNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureNV,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult
;
pub type PFN_vkCmdWriteAccelerationStructuresPropertiesNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureNV,
        queryType: VkQueryType,
        queryPool: VkQueryPool,
        firstQuery: u32,
    )
;
pub type PFN_vkCompileDeferredNV = 
    unsafe extern "C" fn(device: VkDevice, pipeline: VkPipeline, shader: u32) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub representativeFragmentTest: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRepresentativeFragmentTestStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub representativeFragmentTestEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageViewImageFormatInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageViewType: VkImageViewType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFilterCubicImageViewImageFormatPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub filterCubic: VkBool32,
    pub filterCubicMinmax: VkBool32,
}
pub use self::VkQueueGlobalPriorityKHR as VkQueueGlobalPriorityEXT;
pub type VkDeviceQueueGlobalPriorityCreateInfoEXT = VkDeviceQueueGlobalPriorityCreateInfoKHR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryHostPointerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
    pub pHostPointer: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryHostPointerPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalMemoryHostPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minImportedHostPointerAlignment: VkDeviceSize,
}
pub type PFN_vkGetMemoryHostPointerPropertiesEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        pHostPointer: *const ::std::os::raw::c_void,
        pMemoryHostPointerProperties: *mut VkMemoryHostPointerPropertiesEXT,
    ) -> VkResult
;
pub type PFN_vkCmdWriteBufferMarkerAMD = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        marker: u32,
    )
;
pub const VK_PIPELINE_COMPILER_CONTROL_FLAG_BITS_MAX_ENUM_AMD : VkPipelineCompilerControlFlagBitsAMD = 2147483647 ;
pub type VkPipelineCompilerControlFlagBitsAMD = ::std::os::raw::c_uint;
pub type VkPipelineCompilerControlFlagsAMD = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCompilerControlCreateInfoAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub compilerControlFlags: VkPipelineCompilerControlFlagsAMD,
}
pub const VK_TIME_DOMAIN_DEVICE_EXT: VkTimeDomainEXT = 0;
pub const VK_TIME_DOMAIN_CLOCK_MONOTONIC_EXT: VkTimeDomainEXT = 1;
pub const VK_TIME_DOMAIN_CLOCK_MONOTONIC_RAW_EXT: VkTimeDomainEXT = 2;
pub const VK_TIME_DOMAIN_QUERY_PERFORMANCE_COUNTER_EXT: VkTimeDomainEXT = 3;
pub const VK_TIME_DOMAIN_MAX_ENUM_EXT: VkTimeDomainEXT = 2147483647;
pub type VkTimeDomainEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCalibratedTimestampInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub timeDomain: VkTimeDomainEXT,
}
pub type PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pTimeDomainCount: *mut u32,
        pTimeDomains: *mut VkTimeDomainEXT,
    ) -> VkResult
;
pub type PFN_vkGetCalibratedTimestampsEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        timestampCount: u32,
        pTimestampInfos: *const VkCalibratedTimestampInfoEXT,
        pTimestamps: *mut u64,
        pMaxDeviation: *mut u64,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderCorePropertiesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderEngineCount: u32,
    pub shaderArraysPerEngineCount: u32,
    pub computeUnitsPerShaderArray: u32,
    pub simdPerComputeUnit: u32,
    pub wavefrontsPerSimd: u32,
    pub wavefrontSize: u32,
    pub sgprsPerSimd: u32,
    pub minSgprAllocation: u32,
    pub maxSgprAllocation: u32,
    pub sgprAllocationGranularity: u32,
    pub vgprsPerSimd: u32,
    pub minVgprAllocation: u32,
    pub maxVgprAllocation: u32,
    pub vgprAllocationGranularity: u32,
}
pub const VK_MEMORY_OVERALLOCATION_BEHAVIOR_DEFAULT_AMD:
    VkMemoryOverallocationBehaviorAMD = 0;
pub const VK_MEMORY_OVERALLOCATION_BEHAVIOR_ALLOWED_AMD:
    VkMemoryOverallocationBehaviorAMD = 1;
pub const VK_MEMORY_OVERALLOCATION_BEHAVIOR_DISALLOWED_AMD:
    VkMemoryOverallocationBehaviorAMD = 2;
pub const VK_MEMORY_OVERALLOCATION_BEHAVIOR_MAX_ENUM_AMD:
    VkMemoryOverallocationBehaviorAMD = 2147483647;
pub type VkMemoryOverallocationBehaviorAMD = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemoryOverallocationCreateInfoAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub overallocationBehavior: VkMemoryOverallocationBehaviorAMD,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxVertexAttribDivisor: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputBindingDivisorDescriptionEXT {
    pub binding: u32,
    pub divisor: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineVertexInputDivisorStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vertexBindingDivisorCount: u32,
    pub pVertexBindingDivisors: *const VkVertexInputBindingDivisorDescriptionEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub vertexAttributeInstanceRateDivisor: VkBool32,
    pub vertexAttributeInstanceRateZeroDivisor: VkBool32,
}
pub use self::VkPipelineCreationFeedbackFlagBits as VkPipelineCreationFeedbackFlagBitsEXT;
pub type VkPipelineCreationFeedbackFlagsEXT = VkPipelineCreationFeedbackFlags;
pub type VkPipelineCreationFeedbackCreateInfoEXT = VkPipelineCreationFeedbackCreateInfo;
pub type VkPipelineCreationFeedbackEXT = VkPipelineCreationFeedback;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceComputeShaderDerivativesFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub computeDerivativeGroupQuads: VkBool32,
    pub computeDerivativeGroupLinear: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMeshShaderFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub taskShader: VkBool32,
    pub meshShader: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMeshShaderPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxDrawMeshTasksCount: u32,
    pub maxTaskWorkGroupInvocations: u32,
    pub maxTaskWorkGroupSize: [u32; 3usize],
    pub maxTaskTotalMemorySize: u32,
    pub maxTaskOutputCount: u32,
    pub maxMeshWorkGroupInvocations: u32,
    pub maxMeshWorkGroupSize: [u32; 3usize],
    pub maxMeshTotalMemorySize: u32,
    pub maxMeshOutputVertices: u32,
    pub maxMeshOutputPrimitives: u32,
    pub maxMeshMultiviewViewCount: u32,
    pub meshOutputPerVertexGranularity: u32,
    pub meshOutputPerPrimitiveGranularity: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawMeshTasksIndirectCommandNV {
    pub taskCount: u32,
    pub firstTask: u32,
}
pub type PFN_vkCmdDrawMeshTasksNV = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, taskCount: u32, firstTask: u32)
;
pub type PFN_vkCmdDrawMeshTasksIndirectNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    )
;
pub type PFN_vkCmdDrawMeshTasksIndirectCountNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        countBuffer: VkBuffer,
        countBufferOffset: VkDeviceSize,
        maxDrawCount: u32,
        stride: u32,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShaderBarycentricFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentShaderBarycentric: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderImageFootprintFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageFootprint: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportExclusiveScissorStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub exclusiveScissorCount: u32,
    pub pExclusiveScissors: *const VkRect2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExclusiveScissorFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exclusiveScissor: VkBool32,
}
pub type PFN_vkCmdSetExclusiveScissorNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstExclusiveScissor: u32,
        exclusiveScissorCount: u32,
        pExclusiveScissors: *const VkRect2D,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyCheckpointPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub checkpointExecutionStageMask: VkPipelineStageFlags,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCheckpointDataNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stage: VkPipelineStageFlagBits,
    pub pCheckpointMarker: *mut ::std::os::raw::c_void,
}
pub type PFN_vkCmdSetCheckpointNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCheckpointMarker: *const ::std::os::raw::c_void,
    )
;
pub type PFN_vkGetQueueCheckpointDataNV = 
    unsafe extern "C" fn(
        queue: VkQueue,
        pCheckpointDataCount: *mut u32,
        pCheckpointData: *mut VkCheckpointDataNV,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderIntegerFunctions2: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceConfigurationINTEL_T {
    _unused: [u8; 0],
}
pub type VkPerformanceConfigurationINTEL = *mut VkPerformanceConfigurationINTEL_T;
pub const VK_PERFORMANCE_CONFIGURATION_TYPE_COMMAND_QUEUE_METRICS_DISCOVERY_ACTIVATED_INTEL : VkPerformanceConfigurationTypeINTEL = 0 ;
pub const VK_PERFORMANCE_CONFIGURATION_TYPE_MAX_ENUM_INTEL:
    VkPerformanceConfigurationTypeINTEL = 2147483647;
pub type VkPerformanceConfigurationTypeINTEL = ::std::os::raw::c_uint;
pub const VK_QUERY_POOL_SAMPLING_MODE_MANUAL_INTEL:
    VkQueryPoolSamplingModeINTEL = 0;
pub const VK_QUERY_POOL_SAMPLING_MODE_MAX_ENUM_INTEL:
    VkQueryPoolSamplingModeINTEL = 2147483647;
pub type VkQueryPoolSamplingModeINTEL = ::std::os::raw::c_uint;
pub const VK_PERFORMANCE_OVERRIDE_TYPE_NULL_HARDWARE_INTEL:
    VkPerformanceOverrideTypeINTEL = 0;
pub const VK_PERFORMANCE_OVERRIDE_TYPE_FLUSH_GPU_CACHES_INTEL:
    VkPerformanceOverrideTypeINTEL = 1;
pub const VK_PERFORMANCE_OVERRIDE_TYPE_MAX_ENUM_INTEL:
    VkPerformanceOverrideTypeINTEL = 2147483647;
pub type VkPerformanceOverrideTypeINTEL = ::std::os::raw::c_uint;
pub const VK_PERFORMANCE_PARAMETER_TYPE_HW_COUNTERS_SUPPORTED_INTEL : VkPerformanceParameterTypeINTEL = 0 ;
pub const VK_PERFORMANCE_PARAMETER_TYPE_STREAM_MARKER_VALID_BITS_INTEL : VkPerformanceParameterTypeINTEL = 1 ;
pub const VK_PERFORMANCE_PARAMETER_TYPE_MAX_ENUM_INTEL:
    VkPerformanceParameterTypeINTEL = 2147483647;
pub type VkPerformanceParameterTypeINTEL = ::std::os::raw::c_uint;
pub const VK_PERFORMANCE_VALUE_TYPE_UINT32_INTEL:
    VkPerformanceValueTypeINTEL = 0;
pub const VK_PERFORMANCE_VALUE_TYPE_UINT64_INTEL:
    VkPerformanceValueTypeINTEL = 1;
pub const VK_PERFORMANCE_VALUE_TYPE_FLOAT_INTEL:
    VkPerformanceValueTypeINTEL = 2;
pub const VK_PERFORMANCE_VALUE_TYPE_BOOL_INTEL:
    VkPerformanceValueTypeINTEL = 3;
pub const VK_PERFORMANCE_VALUE_TYPE_STRING_INTEL:
    VkPerformanceValueTypeINTEL = 4;
pub const VK_PERFORMANCE_VALUE_TYPE_MAX_ENUM_INTEL:
    VkPerformanceValueTypeINTEL = 2147483647;
pub type VkPerformanceValueTypeINTEL = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkPerformanceValueDataINTEL {
    pub value32: u32,
    pub value64: u64,
    pub valueFloat: f32,
    pub valueBool: VkBool32,
    pub valueString: *const ::std::os::raw::c_char,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPerformanceValueINTEL {
    pub type_: VkPerformanceValueTypeINTEL,
    pub data: VkPerformanceValueDataINTEL,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInitializePerformanceApiInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pUserData: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPoolPerformanceQueryCreateInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub performanceCountersSampling: VkQueryPoolSamplingModeINTEL,
}
pub type VkQueryPoolCreateInfoINTEL = VkQueryPoolPerformanceQueryCreateInfoINTEL;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceMarkerInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub marker: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceStreamMarkerInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub marker: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceOverrideInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkPerformanceOverrideTypeINTEL,
    pub enable: VkBool32,
    pub parameter: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPerformanceConfigurationAcquireInfoINTEL {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkPerformanceConfigurationTypeINTEL,
}
pub type PFN_vkInitializePerformanceApiINTEL = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInitializeInfo: *const VkInitializePerformanceApiInfoINTEL,
    ) -> VkResult
;
pub type PFN_vkUninitializePerformanceApiINTEL =
    unsafe extern "C" fn(device: VkDevice);
pub type PFN_vkCmdSetPerformanceMarkerINTEL = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkPerformanceMarkerInfoINTEL,
    ) -> VkResult
;
pub type PFN_vkCmdSetPerformanceStreamMarkerINTEL = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pMarkerInfo: *const VkPerformanceStreamMarkerInfoINTEL,
    ) -> VkResult
;
pub type PFN_vkCmdSetPerformanceOverrideINTEL = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pOverrideInfo: *const VkPerformanceOverrideInfoINTEL,
    ) -> VkResult
;
pub type PFN_vkAcquirePerformanceConfigurationINTEL = 
    unsafe extern "C" fn(
        device: VkDevice,
        pAcquireInfo: *const VkPerformanceConfigurationAcquireInfoINTEL,
        pConfiguration: *mut VkPerformanceConfigurationINTEL,
    ) -> VkResult
;
pub type PFN_vkReleasePerformanceConfigurationINTEL = 
    unsafe extern "C" fn(
        device: VkDevice,
        configuration: VkPerformanceConfigurationINTEL,
    ) -> VkResult
;
pub type PFN_vkQueueSetPerformanceConfigurationINTEL = 
    unsafe extern "C" fn(
        queue: VkQueue,
        configuration: VkPerformanceConfigurationINTEL,
    ) -> VkResult
;
pub type PFN_vkGetPerformanceParameterINTEL = 
    unsafe extern "C" fn(
        device: VkDevice,
        parameter: VkPerformanceParameterTypeINTEL,
        pValue: *mut VkPerformanceValueINTEL,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePCIBusInfoPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pciDomain: u32,
    pub pciBus: u32,
    pub pciDevice: u32,
    pub pciFunction: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDisplayNativeHdrSurfaceCapabilitiesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub localDimmingSupport: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSwapchainDisplayNativeHdrCreateInfoAMD {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub localDimmingEnable: VkBool32,
}
pub type PFN_vkSetLocalDimmingAMD = 
    unsafe extern "C" fn(device: VkDevice, swapChain: VkSwapchainKHR, localDimmingEnable: VkBool32)
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMapFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentDensityMap: VkBool32,
    pub fragmentDensityMapDynamic: VkBool32,
    pub fragmentDensityMapNonSubsampledImages: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMapPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minFragmentDensityTexelSize: VkExtent2D,
    pub maxFragmentDensityTexelSize: VkExtent2D,
    pub fragmentDensityInvocations: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassFragmentDensityMapCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fragmentDensityMapAttachment: VkAttachmentReference,
}
pub type VkPhysicalDeviceScalarBlockLayoutFeaturesEXT = VkPhysicalDeviceScalarBlockLayoutFeatures;
pub type VkPhysicalDeviceSubgroupSizeControlFeaturesEXT =
    VkPhysicalDeviceSubgroupSizeControlFeatures;
pub type VkPhysicalDeviceSubgroupSizeControlPropertiesEXT =
    VkPhysicalDeviceSubgroupSizeControlProperties;
pub type VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT =
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo;
pub const VK_SHADER_CORE_PROPERTIES_FLAG_BITS_MAX_ENUM_AMD:
    VkShaderCorePropertiesFlagBitsAMD = 2147483647;
pub type VkShaderCorePropertiesFlagBitsAMD = ::std::os::raw::c_uint;
pub type VkShaderCorePropertiesFlagsAMD = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderCoreProperties2AMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderCoreFeatures: VkShaderCorePropertiesFlagsAMD,
    pub activeComputeUnitCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCoherentMemoryFeaturesAMD {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceCoherentMemory: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderImageInt64Atomics: VkBool32,
    pub sparseImageInt64Atomics: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryBudgetPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub heapBudget: [VkDeviceSize; 16usize],
    pub heapUsage: [VkDeviceSize; 16usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryPriorityFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryPriority: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryPriorityAllocateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub priority: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub dedicatedAllocationImageAliasing: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBufferDeviceAddressFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
}
pub type VkPhysicalDeviceBufferAddressFeaturesEXT = VkPhysicalDeviceBufferDeviceAddressFeaturesEXT;
pub type VkBufferDeviceAddressInfoEXT = VkBufferDeviceAddressInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferDeviceAddressCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceAddress: VkDeviceAddress,
}
pub type PFN_vkGetBufferDeviceAddressEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferDeviceAddressInfo,
    ) -> VkDeviceAddress
;
pub use self::VkToolPurposeFlagBits as VkToolPurposeFlagBitsEXT;
pub type VkToolPurposeFlagsEXT = VkToolPurposeFlags;
pub type VkPhysicalDeviceToolPropertiesEXT = VkPhysicalDeviceToolProperties;
pub type PFN_vkGetPhysicalDeviceToolPropertiesEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pToolCount: *mut u32,
        pToolProperties: *mut VkPhysicalDeviceToolProperties,
    ) -> VkResult
;
pub type VkImageStencilUsageCreateInfoEXT = VkImageStencilUsageCreateInfo;
pub const VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_EXT:
    VkValidationFeatureEnableEXT = 0;
pub const VK_VALIDATION_FEATURE_ENABLE_GPU_ASSISTED_RESERVE_BINDING_SLOT_EXT : VkValidationFeatureEnableEXT = 1 ;
pub const VK_VALIDATION_FEATURE_ENABLE_BEST_PRACTICES_EXT:
    VkValidationFeatureEnableEXT = 2;
pub const VK_VALIDATION_FEATURE_ENABLE_DEBUG_PRINTF_EXT:
    VkValidationFeatureEnableEXT = 3;
pub const VK_VALIDATION_FEATURE_ENABLE_SYNCHRONIZATION_VALIDATION_EXT : VkValidationFeatureEnableEXT = 4 ;
pub const VK_VALIDATION_FEATURE_ENABLE_MAX_ENUM_EXT:
    VkValidationFeatureEnableEXT = 2147483647;
pub type VkValidationFeatureEnableEXT = ::std::os::raw::c_uint;
pub const VK_VALIDATION_FEATURE_DISABLE_ALL_EXT:
    VkValidationFeatureDisableEXT = 0;
pub const VK_VALIDATION_FEATURE_DISABLE_SHADERS_EXT:
    VkValidationFeatureDisableEXT = 1;
pub const VK_VALIDATION_FEATURE_DISABLE_THREAD_SAFETY_EXT:
    VkValidationFeatureDisableEXT = 2;
pub const VK_VALIDATION_FEATURE_DISABLE_API_PARAMETERS_EXT:
    VkValidationFeatureDisableEXT = 3;
pub const VK_VALIDATION_FEATURE_DISABLE_OBJECT_LIFETIMES_EXT:
    VkValidationFeatureDisableEXT = 4;
pub const VK_VALIDATION_FEATURE_DISABLE_CORE_CHECKS_EXT:
    VkValidationFeatureDisableEXT = 5;
pub const VK_VALIDATION_FEATURE_DISABLE_UNIQUE_HANDLES_EXT:
    VkValidationFeatureDisableEXT = 6;
pub const VK_VALIDATION_FEATURE_DISABLE_SHADER_VALIDATION_CACHE_EXT : VkValidationFeatureDisableEXT = 7 ;
pub const VK_VALIDATION_FEATURE_DISABLE_MAX_ENUM_EXT:
    VkValidationFeatureDisableEXT = 2147483647;
pub type VkValidationFeatureDisableEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkValidationFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub enabledValidationFeatureCount: u32,
    pub pEnabledValidationFeatures: *const VkValidationFeatureEnableEXT,
    pub disabledValidationFeatureCount: u32,
    pub pDisabledValidationFeatures: *const VkValidationFeatureDisableEXT,
}
pub const VK_COMPONENT_TYPE_FLOAT16_NV: VkComponentTypeNV = 0;
pub const VK_COMPONENT_TYPE_FLOAT32_NV: VkComponentTypeNV = 1;
pub const VK_COMPONENT_TYPE_FLOAT64_NV: VkComponentTypeNV = 2;
pub const VK_COMPONENT_TYPE_SINT8_NV: VkComponentTypeNV = 3;
pub const VK_COMPONENT_TYPE_SINT16_NV: VkComponentTypeNV = 4;
pub const VK_COMPONENT_TYPE_SINT32_NV: VkComponentTypeNV = 5;
pub const VK_COMPONENT_TYPE_SINT64_NV: VkComponentTypeNV = 6;
pub const VK_COMPONENT_TYPE_UINT8_NV: VkComponentTypeNV = 7;
pub const VK_COMPONENT_TYPE_UINT16_NV: VkComponentTypeNV = 8;
pub const VK_COMPONENT_TYPE_UINT32_NV: VkComponentTypeNV = 9;
pub const VK_COMPONENT_TYPE_UINT64_NV: VkComponentTypeNV = 10;
pub const VK_COMPONENT_TYPE_MAX_ENUM_NV: VkComponentTypeNV = 2147483647;
pub type VkComponentTypeNV = ::std::os::raw::c_uint;
pub const VK_SCOPE_DEVICE_NV: VkScopeNV = 1;
pub const VK_SCOPE_WORKGROUP_NV: VkScopeNV = 2;
pub const VK_SCOPE_SUBGROUP_NV: VkScopeNV = 3;
pub const VK_SCOPE_QUEUE_FAMILY_NV: VkScopeNV = 5;
pub const VK_SCOPE_MAX_ENUM_NV: VkScopeNV = 2147483647;
pub type VkScopeNV = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCooperativeMatrixPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub MSize: u32,
    pub NSize: u32,
    pub KSize: u32,
    pub AType: VkComponentTypeNV,
    pub BType: VkComponentTypeNV,
    pub CType: VkComponentTypeNV,
    pub DType: VkComponentTypeNV,
    pub scope: VkScopeNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCooperativeMatrixFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub cooperativeMatrix: VkBool32,
    pub cooperativeMatrixRobustBufferAccess: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCooperativeMatrixPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub cooperativeMatrixSupportedStages: VkShaderStageFlags,
}
pub type PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkCooperativeMatrixPropertiesNV,
    ) -> VkResult
;
pub const VK_COVERAGE_REDUCTION_MODE_MERGE_NV: VkCoverageReductionModeNV =
    0;
pub const VK_COVERAGE_REDUCTION_MODE_TRUNCATE_NV:
    VkCoverageReductionModeNV = 1;
pub const VK_COVERAGE_REDUCTION_MODE_MAX_ENUM_NV:
    VkCoverageReductionModeNV = 2147483647;
pub type VkCoverageReductionModeNV = ::std::os::raw::c_uint;
pub type VkPipelineCoverageReductionStateCreateFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCoverageReductionModeFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub coverageReductionMode: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCoverageReductionStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCoverageReductionStateCreateFlagsNV,
    pub coverageReductionMode: VkCoverageReductionModeNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferMixedSamplesCombinationNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub coverageReductionMode: VkCoverageReductionModeNV,
    pub rasterizationSamples: VkSampleCountFlagBits,
    pub depthStencilSamples: VkSampleCountFlags,
    pub colorSamples: VkSampleCountFlags,
}
pub type PFN_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV =
    
        unsafe extern "C" fn(
            physicalDevice: VkPhysicalDevice,
            pCombinationCount: *mut u32,
            pCombinations: *mut VkFramebufferMixedSamplesCombinationNV,
        ) -> VkResult
    ;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentShaderSampleInterlock: VkBool32,
    pub fragmentShaderPixelInterlock: VkBool32,
    pub fragmentShaderShadingRateInterlock: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceYcbcrImageArraysFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub ycbcrImageArrays: VkBool32,
}
pub const VK_PROVOKING_VERTEX_MODE_FIRST_VERTEX_EXT:
    VkProvokingVertexModeEXT = 0;
pub const VK_PROVOKING_VERTEX_MODE_LAST_VERTEX_EXT:
    VkProvokingVertexModeEXT = 1;
pub const VK_PROVOKING_VERTEX_MODE_MAX_ENUM_EXT: VkProvokingVertexModeEXT =
    2147483647;
pub type VkProvokingVertexModeEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProvokingVertexFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub provokingVertexLast: VkBool32,
    pub transformFeedbackPreservesProvokingVertex: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProvokingVertexPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub provokingVertexModePerPipeline: VkBool32,
    pub transformFeedbackPreservesTriangleFanProvokingVertex: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationProvokingVertexStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub provokingVertexMode: VkProvokingVertexModeEXT,
}
pub type VkHeadlessSurfaceCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkHeadlessSurfaceCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkHeadlessSurfaceCreateFlagsEXT,
}
pub type PFN_vkCreateHeadlessSurfaceEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkHeadlessSurfaceCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub const VK_LINE_RASTERIZATION_MODE_DEFAULT_EXT:
    VkLineRasterizationModeEXT = 0;
pub const VK_LINE_RASTERIZATION_MODE_RECTANGULAR_EXT:
    VkLineRasterizationModeEXT = 1;
pub const VK_LINE_RASTERIZATION_MODE_BRESENHAM_EXT:
    VkLineRasterizationModeEXT = 2;
pub const VK_LINE_RASTERIZATION_MODE_RECTANGULAR_SMOOTH_EXT:
    VkLineRasterizationModeEXT = 3;
pub const VK_LINE_RASTERIZATION_MODE_MAX_ENUM_EXT:
    VkLineRasterizationModeEXT = 2147483647;
pub type VkLineRasterizationModeEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLineRasterizationFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rectangularLines: VkBool32,
    pub bresenhamLines: VkBool32,
    pub smoothLines: VkBool32,
    pub stippledRectangularLines: VkBool32,
    pub stippledBresenhamLines: VkBool32,
    pub stippledSmoothLines: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLineRasterizationPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub lineSubPixelPrecisionBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationLineStateCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub lineRasterizationMode: VkLineRasterizationModeEXT,
    pub stippledLineEnable: VkBool32,
    pub lineStippleFactor: u32,
    pub lineStipplePattern: u16,
}
pub type PFN_vkCmdSetLineStippleEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        lineStippleFactor: u32,
        lineStipplePattern: u16,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderAtomicFloatFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderBufferFloat32Atomics: VkBool32,
    pub shaderBufferFloat32AtomicAdd: VkBool32,
    pub shaderBufferFloat64Atomics: VkBool32,
    pub shaderBufferFloat64AtomicAdd: VkBool32,
    pub shaderSharedFloat32Atomics: VkBool32,
    pub shaderSharedFloat32AtomicAdd: VkBool32,
    pub shaderSharedFloat64Atomics: VkBool32,
    pub shaderSharedFloat64AtomicAdd: VkBool32,
    pub shaderImageFloat32Atomics: VkBool32,
    pub shaderImageFloat32AtomicAdd: VkBool32,
    pub sparseImageFloat32Atomics: VkBool32,
    pub sparseImageFloat32AtomicAdd: VkBool32,
}
pub type VkPhysicalDeviceHostQueryResetFeaturesEXT = VkPhysicalDeviceHostQueryResetFeatures;
pub type PFN_vkResetQueryPoolEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub indexTypeUint8: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub extendedDynamicState: VkBool32,
}
pub type PFN_vkCmdSetCullModeEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, cullMode: VkCullModeFlags)
;
pub type PFN_vkCmdSetFrontFaceEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, frontFace: VkFrontFace)
;
pub type PFN_vkCmdSetPrimitiveTopologyEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, primitiveTopology: VkPrimitiveTopology)
;
pub type PFN_vkCmdSetViewportWithCountEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        viewportCount: u32,
        pViewports: *const VkViewport,
    )
;
pub type PFN_vkCmdSetScissorWithCountEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    )
;
pub type PFN_vkCmdBindVertexBuffers2EXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
        pSizes: *const VkDeviceSize,
        pStrides: *const VkDeviceSize,
    )
;
pub type PFN_vkCmdSetDepthTestEnableEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthTestEnable: VkBool32)
;
pub type PFN_vkCmdSetDepthWriteEnableEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthWriteEnable: VkBool32)
;
pub type PFN_vkCmdSetDepthCompareOpEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthCompareOp: VkCompareOp)
;
pub type PFN_vkCmdSetDepthBoundsTestEnableEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthBoundsTestEnable: VkBool32)
;
pub type PFN_vkCmdSetStencilTestEnableEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, stencilTestEnable: VkBool32)
;
pub type PFN_vkCmdSetStencilOpEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        failOp: VkStencilOp,
        passOp: VkStencilOp,
        depthFailOp: VkStencilOp,
        compareOp: VkCompareOp,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderBufferFloat16Atomics: VkBool32,
    pub shaderBufferFloat16AtomicAdd: VkBool32,
    pub shaderBufferFloat16AtomicMinMax: VkBool32,
    pub shaderBufferFloat32AtomicMinMax: VkBool32,
    pub shaderBufferFloat64AtomicMinMax: VkBool32,
    pub shaderSharedFloat16Atomics: VkBool32,
    pub shaderSharedFloat16AtomicAdd: VkBool32,
    pub shaderSharedFloat16AtomicMinMax: VkBool32,
    pub shaderSharedFloat32AtomicMinMax: VkBool32,
    pub shaderSharedFloat64AtomicMinMax: VkBool32,
    pub shaderImageFloat32AtomicMinMax: VkBool32,
    pub sparseImageFloat32AtomicMinMax: VkBool32,
}
pub type VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT =
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsLayoutNV_T {
    _unused: [u8; 0],
}
pub type VkIndirectCommandsLayoutNV = *mut VkIndirectCommandsLayoutNV_T;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_SHADER_GROUP_NV:
    VkIndirectCommandsTokenTypeNV = 0;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_STATE_FLAGS_NV:
    VkIndirectCommandsTokenTypeNV = 1;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_INDEX_BUFFER_NV:
    VkIndirectCommandsTokenTypeNV = 2;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_VERTEX_BUFFER_NV:
    VkIndirectCommandsTokenTypeNV = 3;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_PUSH_CONSTANT_NV:
    VkIndirectCommandsTokenTypeNV = 4;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_INDEXED_NV:
    VkIndirectCommandsTokenTypeNV = 5;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_NV:
    VkIndirectCommandsTokenTypeNV = 6;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_DRAW_TASKS_NV:
    VkIndirectCommandsTokenTypeNV = 7;
pub const VK_INDIRECT_COMMANDS_TOKEN_TYPE_MAX_ENUM_NV:
    VkIndirectCommandsTokenTypeNV = 2147483647;
pub type VkIndirectCommandsTokenTypeNV = ::std::os::raw::c_uint;
pub const VK_INDIRECT_STATE_FLAG_FRONTFACE_BIT_NV:
    VkIndirectStateFlagBitsNV = 1;
pub const VK_INDIRECT_STATE_FLAG_BITS_MAX_ENUM_NV:
    VkIndirectStateFlagBitsNV = 2147483647;
pub type VkIndirectStateFlagBitsNV = ::std::os::raw::c_uint;
pub type VkIndirectStateFlagsNV = VkFlags;
pub const VK_INDIRECT_COMMANDS_LAYOUT_USAGE_EXPLICIT_PREPROCESS_BIT_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 1 ;
pub const VK_INDIRECT_COMMANDS_LAYOUT_USAGE_INDEXED_SEQUENCES_BIT_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 2 ;
pub const VK_INDIRECT_COMMANDS_LAYOUT_USAGE_UNORDERED_SEQUENCES_BIT_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 4 ;
pub const VK_INDIRECT_COMMANDS_LAYOUT_USAGE_FLAG_BITS_MAX_ENUM_NV : VkIndirectCommandsLayoutUsageFlagBitsNV = 2147483647 ;
pub type VkIndirectCommandsLayoutUsageFlagBitsNV = ::std::os::raw::c_uint;
pub type VkIndirectCommandsLayoutUsageFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxGraphicsShaderGroupCount: u32,
    pub maxIndirectSequenceCount: u32,
    pub maxIndirectCommandsTokenCount: u32,
    pub maxIndirectCommandsStreamCount: u32,
    pub maxIndirectCommandsTokenOffset: u32,
    pub maxIndirectCommandsStreamStride: u32,
    pub minSequencesCountBufferOffsetAlignment: u32,
    pub minSequencesIndexBufferOffsetAlignment: u32,
    pub minIndirectCommandsBufferOffsetAlignment: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceGeneratedCommands: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsShaderGroupCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub pVertexInputState: *const VkPipelineVertexInputStateCreateInfo,
    pub pTessellationState: *const VkPipelineTessellationStateCreateInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsPipelineShaderGroupsCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub groupCount: u32,
    pub pGroups: *const VkGraphicsShaderGroupCreateInfoNV,
    pub pipelineCount: u32,
    pub pPipelines: *const VkPipeline,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindShaderGroupIndirectCommandNV {
    pub groupIndex: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindIndexBufferIndirectCommandNV {
    pub bufferAddress: VkDeviceAddress,
    pub size: u32,
    pub indexType: VkIndexType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindVertexBufferIndirectCommandNV {
    pub bufferAddress: VkDeviceAddress,
    pub size: u32,
    pub stride: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSetStateFlagsIndirectCommandNV {
    pub data: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsStreamNV {
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsLayoutTokenNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub tokenType: VkIndirectCommandsTokenTypeNV,
    pub stream: u32,
    pub offset: u32,
    pub vertexBindingUnit: u32,
    pub vertexDynamicStride: VkBool32,
    pub pushconstantPipelineLayout: VkPipelineLayout,
    pub pushconstantShaderStageFlags: VkShaderStageFlags,
    pub pushconstantOffset: u32,
    pub pushconstantSize: u32,
    pub indirectStateFlags: VkIndirectStateFlagsNV,
    pub indexTypeCount: u32,
    pub pIndexTypes: *const VkIndexType,
    pub pIndexTypeValues: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIndirectCommandsLayoutCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkIndirectCommandsLayoutUsageFlagsNV,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub tokenCount: u32,
    pub pTokens: *const VkIndirectCommandsLayoutTokenNV,
    pub streamCount: u32,
    pub pStreamStrides: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeneratedCommandsInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub pipeline: VkPipeline,
    pub indirectCommandsLayout: VkIndirectCommandsLayoutNV,
    pub streamCount: u32,
    pub pStreams: *const VkIndirectCommandsStreamNV,
    pub sequencesCount: u32,
    pub preprocessBuffer: VkBuffer,
    pub preprocessOffset: VkDeviceSize,
    pub preprocessSize: VkDeviceSize,
    pub sequencesCountBuffer: VkBuffer,
    pub sequencesCountOffset: VkDeviceSize,
    pub sequencesIndexBuffer: VkBuffer,
    pub sequencesIndexOffset: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGeneratedCommandsMemoryRequirementsInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub pipeline: VkPipeline,
    pub indirectCommandsLayout: VkIndirectCommandsLayoutNV,
    pub maxSequencesCount: u32,
}
pub type PFN_vkGetGeneratedCommandsMemoryRequirementsNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkGeneratedCommandsMemoryRequirementsInfoNV,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    )
;
pub type PFN_vkCmdPreprocessGeneratedCommandsNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pGeneratedCommandsInfo: *const VkGeneratedCommandsInfoNV,
    )
;
pub type PFN_vkCmdExecuteGeneratedCommandsNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        isPreprocessed: VkBool32,
        pGeneratedCommandsInfo: *const VkGeneratedCommandsInfoNV,
    )
;
pub type PFN_vkCmdBindPipelineShaderGroupNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
        groupIndex: u32,
    )
;
pub type PFN_vkCreateIndirectCommandsLayoutNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkIndirectCommandsLayoutCreateInfoNV,
        pAllocator: *const VkAllocationCallbacks,
        pIndirectCommandsLayout: *mut VkIndirectCommandsLayoutNV,
    ) -> VkResult
;
pub type PFN_vkDestroyIndirectCommandsLayoutNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        indirectCommandsLayout: VkIndirectCommandsLayoutNV,
        pAllocator: *const VkAllocationCallbacks,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceInheritedViewportScissorFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub inheritedViewportScissor2D: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceViewportScissorInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub viewportScissor2D: VkBool32,
    pub viewportDepthCount: u32,
    pub pViewportDepths: *const VkViewport,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub texelBufferAlignment: VkBool32,
}
pub type VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT =
    VkPhysicalDeviceTexelBufferAlignmentProperties;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassTransformBeginInfoQCOM {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub transform: VkSurfaceTransformFlagBitsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceRenderPassTransformInfoQCOM {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub transform: VkSurfaceTransformFlagBitsKHR,
    pub renderArea: VkRect2D,
}
pub const VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATE_EXT:
    VkDeviceMemoryReportEventTypeEXT = 0;
pub const VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_FREE_EXT:
    VkDeviceMemoryReportEventTypeEXT = 1;
pub const VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_IMPORT_EXT:
    VkDeviceMemoryReportEventTypeEXT = 2;
pub const VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_UNIMPORT_EXT:
    VkDeviceMemoryReportEventTypeEXT = 3;
pub const VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_ALLOCATION_FAILED_EXT : VkDeviceMemoryReportEventTypeEXT = 4 ;
pub const VK_DEVICE_MEMORY_REPORT_EVENT_TYPE_MAX_ENUM_EXT:
    VkDeviceMemoryReportEventTypeEXT = 2147483647;
pub type VkDeviceMemoryReportEventTypeEXT = ::std::os::raw::c_uint;
pub type VkDeviceMemoryReportFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDeviceMemoryReportFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceMemoryReport: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemoryReportCallbackDataEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub flags: VkDeviceMemoryReportFlagsEXT,
    pub type_: VkDeviceMemoryReportEventTypeEXT,
    pub memoryObjectId: u64,
    pub size: VkDeviceSize,
    pub objectType: VkObjectType,
    pub objectHandle: u64,
    pub heapIndex: u32,
}
pub type PFN_vkDeviceMemoryReportCallbackEXT = 
    unsafe extern "C" fn(
        pCallbackData: *const VkDeviceMemoryReportCallbackDataEXT,
        pUserData: *mut ::std::os::raw::c_void,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceDeviceMemoryReportCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceMemoryReportFlagsEXT,
    pub pfnUserCallback: PFN_vkDeviceMemoryReportCallbackEXT,
    pub pUserData: *mut ::std::os::raw::c_void,
}
pub type PFN_vkAcquireDrmDisplayEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        drmFd: i32,
        display: VkDisplayKHR,
    ) -> VkResult
;
pub type PFN_vkGetDrmDisplayEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        drmFd: i32,
        connectorId: u32,
        display: *mut VkDisplayKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRobustness2FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub robustBufferAccess2: VkBool32,
    pub robustImageAccess2: VkBool32,
    pub nullDescriptor: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRobustness2PropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub robustStorageBufferAccessSizeAlignment: VkDeviceSize,
    pub robustUniformBufferAccessSizeAlignment: VkDeviceSize,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkSamplerCustomBorderColorCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub customBorderColor: VkClearColorValue,
    pub format: VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCustomBorderColorPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxCustomBorderColorSamplers: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceCustomBorderColorFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub customBorderColors: VkBool32,
    pub customBorderColorWithoutFormat: VkBool32,
}
pub type VkPrivateDataSlotEXT = VkPrivateDataSlot;
pub type VkPrivateDataSlotCreateFlagsEXT = VkPrivateDataSlotCreateFlags;
pub type VkPhysicalDevicePrivateDataFeaturesEXT = VkPhysicalDevicePrivateDataFeatures;
pub type VkDevicePrivateDataCreateInfoEXT = VkDevicePrivateDataCreateInfo;
pub type VkPrivateDataSlotCreateInfoEXT = VkPrivateDataSlotCreateInfo;
pub type PFN_vkCreatePrivateDataSlotEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPrivateDataSlotCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPrivateDataSlot: *mut VkPrivateDataSlot,
    ) -> VkResult
;
pub type PFN_vkDestroyPrivateDataSlotEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        privateDataSlot: VkPrivateDataSlot,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkSetPrivateDataEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlot,
        data: u64,
    ) -> VkResult
;
pub type PFN_vkGetPrivateDataEXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        objectType: VkObjectType,
        objectHandle: u64,
        privateDataSlot: VkPrivateDataSlot,
        pData: *mut u64,
    )
;
pub type VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT =
    VkPhysicalDevicePipelineCreationCacheControlFeatures;
pub const VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_SHADER_DEBUG_INFO_BIT_NV : VkDeviceDiagnosticsConfigFlagBitsNV = 1 ;
pub const VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_RESOURCE_TRACKING_BIT_NV : VkDeviceDiagnosticsConfigFlagBitsNV = 2 ;
pub const VK_DEVICE_DIAGNOSTICS_CONFIG_ENABLE_AUTOMATIC_CHECKPOINTS_BIT_NV : VkDeviceDiagnosticsConfigFlagBitsNV = 4 ;
pub const VK_DEVICE_DIAGNOSTICS_CONFIG_FLAG_BITS_MAX_ENUM_NV:
    VkDeviceDiagnosticsConfigFlagBitsNV = 2147483647;
pub type VkDeviceDiagnosticsConfigFlagBitsNV = ::std::os::raw::c_uint;
pub type VkDeviceDiagnosticsConfigFlagsNV = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDiagnosticsConfigFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub diagnosticsConfig: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceDiagnosticsConfigCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceDiagnosticsConfigFlagsNV,
}
pub const VK_GRAPHICS_PIPELINE_LIBRARY_VERTEX_INPUT_INTERFACE_BIT_EXT : VkGraphicsPipelineLibraryFlagBitsEXT = 1 ;
pub const VK_GRAPHICS_PIPELINE_LIBRARY_PRE_RASTERIZATION_SHADERS_BIT_EXT : VkGraphicsPipelineLibraryFlagBitsEXT = 2 ;
pub const VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_SHADER_BIT_EXT : VkGraphicsPipelineLibraryFlagBitsEXT = 4 ;
pub const VK_GRAPHICS_PIPELINE_LIBRARY_FRAGMENT_OUTPUT_INTERFACE_BIT_EXT : VkGraphicsPipelineLibraryFlagBitsEXT = 8 ;
pub const VK_GRAPHICS_PIPELINE_LIBRARY_FLAG_BITS_MAX_ENUM_EXT : VkGraphicsPipelineLibraryFlagBitsEXT = 2147483647 ;
pub type VkGraphicsPipelineLibraryFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkGraphicsPipelineLibraryFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub graphicsPipelineLibrary: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub graphicsPipelineLibraryFastLinking: VkBool32,
    pub graphicsPipelineLibraryIndependentInterpolationDecoration: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsPipelineLibraryCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub flags: VkGraphicsPipelineLibraryFlagsEXT,
}
pub const VK_FRAGMENT_SHADING_RATE_TYPE_FRAGMENT_SIZE_NV:
    VkFragmentShadingRateTypeNV = 0;
pub const VK_FRAGMENT_SHADING_RATE_TYPE_ENUMS_NV:
    VkFragmentShadingRateTypeNV = 1;
pub const VK_FRAGMENT_SHADING_RATE_TYPE_MAX_ENUM_NV:
    VkFragmentShadingRateTypeNV = 2147483647;
pub type VkFragmentShadingRateTypeNV = ::std::os::raw::c_uint;
pub const VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 0;
pub const VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_1X2_PIXELS_NV:
    VkFragmentShadingRateNV = 1;
pub const VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X1_PIXELS_NV:
    VkFragmentShadingRateNV = 4;
pub const VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X2_PIXELS_NV:
    VkFragmentShadingRateNV = 5;
pub const VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_2X4_PIXELS_NV:
    VkFragmentShadingRateNV = 6;
pub const VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X2_PIXELS_NV:
    VkFragmentShadingRateNV = 9;
pub const VK_FRAGMENT_SHADING_RATE_1_INVOCATION_PER_4X4_PIXELS_NV:
    VkFragmentShadingRateNV = 10;
pub const VK_FRAGMENT_SHADING_RATE_2_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 11;
pub const VK_FRAGMENT_SHADING_RATE_4_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 12;
pub const VK_FRAGMENT_SHADING_RATE_8_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 13;
pub const VK_FRAGMENT_SHADING_RATE_16_INVOCATIONS_PER_PIXEL_NV:
    VkFragmentShadingRateNV = 14;
pub const VK_FRAGMENT_SHADING_RATE_NO_INVOCATIONS_NV:
    VkFragmentShadingRateNV = 15;
pub const VK_FRAGMENT_SHADING_RATE_MAX_ENUM_NV: VkFragmentShadingRateNV =
    2147483647;
pub type VkFragmentShadingRateNV = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentShadingRateEnums: VkBool32,
    pub supersampleFragmentShadingRates: VkBool32,
    pub noInvocationFragmentShadingRates: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxFragmentShadingRateInvocationCount: VkSampleCountFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineFragmentShadingRateEnumStateCreateInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub shadingRateType: VkFragmentShadingRateTypeNV,
    pub shadingRate: VkFragmentShadingRateNV,
    pub combinerOps: [VkFragmentShadingRateCombinerOpKHR; 2usize],
}
pub type PFN_vkCmdSetFragmentShadingRateEnumNV = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        shadingRate: VkFragmentShadingRateNV,
        combinerOps: *const VkFragmentShadingRateCombinerOpKHR,
    )
;
pub const VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_STATIC_NV : VkAccelerationStructureMotionInstanceTypeNV = 0 ;
pub const VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MATRIX_MOTION_NV : VkAccelerationStructureMotionInstanceTypeNV = 1 ;
pub const VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_SRT_MOTION_NV : VkAccelerationStructureMotionInstanceTypeNV = 2 ;
pub const VK_ACCELERATION_STRUCTURE_MOTION_INSTANCE_TYPE_MAX_ENUM_NV : VkAccelerationStructureMotionInstanceTypeNV = 2147483647 ;
pub type VkAccelerationStructureMotionInstanceTypeNV = ::std::os::raw::c_uint;
pub type VkAccelerationStructureMotionInfoFlagsNV = VkFlags;
pub type VkAccelerationStructureMotionInstanceFlagsNV = VkFlags;
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkDeviceOrHostAddressConstKHR {
    pub deviceAddress: VkDeviceAddress,
    pub hostAddress: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryMotionTrianglesDataNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vertexData: VkDeviceOrHostAddressConstKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureMotionInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxInstances: u32,
    pub flags: VkAccelerationStructureMotionInfoFlagsNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureMatrixMotionInstanceNV {
    pub transformT0: VkTransformMatrixKHR,
    pub transformT1: VkTransformMatrixKHR,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub accelerationStructureReference: u64,
}
impl VkAccelerationStructureMatrixMotionInstanceNV {
    #[inline]
    pub fn instanceCustomIndex(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceCustomIndex(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn instanceShaderBindingTableRecordOffset(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceShaderBindingTableRecordOffset(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> VkGeometryInstanceFlagsKHR {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: VkGeometryInstanceFlagsKHR) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        instanceCustomIndex: u32,
        mask: u32,
        instanceShaderBindingTableRecordOffset: u32,
        flags: VkGeometryInstanceFlagsKHR,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let instanceCustomIndex: u32 = unsafe { ::std::mem::transmute(instanceCustomIndex) };
            instanceCustomIndex as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mask: u32 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(32usize, 24u8, {
            let instanceShaderBindingTableRecordOffset: u32 =
                unsafe { ::std::mem::transmute(instanceShaderBindingTableRecordOffset) };
            instanceShaderBindingTableRecordOffset as u64
        });
        __bindgen_bitfield_unit.set(56usize, 8u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSRTDataNV {
    pub sx: f32,
    pub a: f32,
    pub b: f32,
    pub pvx: f32,
    pub sy: f32,
    pub c: f32,
    pub pvy: f32,
    pub sz: f32,
    pub pvz: f32,
    pub qx: f32,
    pub qy: f32,
    pub qz: f32,
    pub qw: f32,
    pub tx: f32,
    pub ty: f32,
    pub tz: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureSRTMotionInstanceNV {
    pub transformT0: VkSRTDataNV,
    pub transformT1: VkSRTDataNV,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
    pub accelerationStructureReference: u64,
}
impl VkAccelerationStructureSRTMotionInstanceNV {
    #[inline]
    pub fn instanceCustomIndex(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceCustomIndex(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn mask(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_mask(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn instanceShaderBindingTableRecordOffset(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(32usize, 24u8) as u32) }
    }
    #[inline]
    pub fn set_instanceShaderBindingTableRecordOffset(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(32usize, 24u8, val as u64)
        }
    }
    #[inline]
    pub fn flags(&self) -> VkGeometryInstanceFlagsKHR {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(56usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_flags(&mut self, val: VkGeometryInstanceFlagsKHR) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(56usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        instanceCustomIndex: u32,
        mask: u32,
        instanceShaderBindingTableRecordOffset: u32,
        flags: VkGeometryInstanceFlagsKHR,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 24u8, {
            let instanceCustomIndex: u32 = unsafe { ::std::mem::transmute(instanceCustomIndex) };
            instanceCustomIndex as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let mask: u32 = unsafe { ::std::mem::transmute(mask) };
            mask as u64
        });
        __bindgen_bitfield_unit.set(32usize, 24u8, {
            let instanceShaderBindingTableRecordOffset: u32 =
                unsafe { ::std::mem::transmute(instanceShaderBindingTableRecordOffset) };
            instanceShaderBindingTableRecordOffset as u64
        });
        __bindgen_bitfield_unit.set(56usize, 8u8, {
            let flags: u32 = unsafe { ::std::mem::transmute(flags) };
            flags as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkAccelerationStructureMotionInstanceDataNV {
    pub staticInstance: VkAccelerationStructureInstanceKHR,
    pub matrixMotionInstance: VkAccelerationStructureMatrixMotionInstanceNV,
    pub srtMotionInstance: VkAccelerationStructureSRTMotionInstanceNV,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureMotionInstanceNV {
    pub type_: VkAccelerationStructureMotionInstanceTypeNV,
    pub flags: VkAccelerationStructureMotionInstanceFlagsNV,
    pub data: VkAccelerationStructureMotionInstanceDataNV,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayTracingMotionBlurFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rayTracingMotionBlur: VkBool32,
    pub rayTracingMotionBlurPipelineTraceRaysIndirect: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub ycbcr2plane444Formats: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMap2FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentDensityMapDeferred: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMap2PropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subsampledLoads: VkBool32,
    pub subsampledCoarseReconstructionEarlyAccess: VkBool32,
    pub maxSubsampledArrayLayers: u32,
    pub maxDescriptorSetSubsampledSamplers: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyCommandTransformInfoQCOM {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub transform: VkSurfaceTransformFlagBitsKHR,
}
pub type VkPhysicalDeviceImageRobustnessFeaturesEXT = VkPhysicalDeviceImageRobustnessFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice4444FormatsFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub formatA4R4G4B4: VkBool32,
    pub formatA4B4G4R4: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesARM {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rasterizationOrderColorAttachmentAccess: VkBool32,
    pub rasterizationOrderDepthAttachmentAccess: VkBool32,
    pub rasterizationOrderStencilAttachmentAccess: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub formatRgba10x6WithoutYCbCrSampler: VkBool32,
}
pub type PFN_vkAcquireWinrtDisplayNV = 
    unsafe extern "C" fn(physicalDevice: VkPhysicalDevice, display: VkDisplayKHR) -> VkResult
;
pub type PFN_vkGetWinrtDisplayNV = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        deviceRelativeId: u32,
        pDisplay: *mut VkDisplayKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMutableDescriptorTypeFeaturesVALVE {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub mutableDescriptorType: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMutableDescriptorTypeListVALVE {
    pub descriptorTypeCount: u32,
    pub pDescriptorTypes: *const VkDescriptorType,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMutableDescriptorTypeCreateInfoVALVE {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub mutableDescriptorTypeListCount: u32,
    pub pMutableDescriptorTypeLists: *const VkMutableDescriptorTypeListVALVE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub vertexInputDynamicState: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputBindingDescription2EXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub binding: u32,
    pub stride: u32,
    pub inputRate: VkVertexInputRate,
    pub divisor: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputAttributeDescription2EXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub location: u32,
    pub binding: u32,
    pub format: VkFormat,
    pub offset: u32,
}
pub type PFN_vkCmdSetVertexInputEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        vertexBindingDescriptionCount: u32,
        pVertexBindingDescriptions: *const VkVertexInputBindingDescription2EXT,
        vertexAttributeDescriptionCount: u32,
        pVertexAttributeDescriptions: *const VkVertexInputAttributeDescription2EXT,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDrmPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub hasPrimary: VkBool32,
    pub hasRender: VkBool32,
    pub primaryMajor: i64,
    pub primaryMinor: i64,
    pub renderMajor: i64,
    pub renderMinor: i64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDepthClipControlFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub depthClipControl: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportDepthClipControlCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub negativeOneToOne: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub primitiveTopologyListRestart: VkBool32,
    pub primitiveTopologyPatchListRestart: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassShadingPipelineCreateInfoHUAWEI {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub renderPass: VkRenderPass,
    pub subpass: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubpassShadingFeaturesHUAWEI {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subpassShading: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubpassShadingPropertiesHUAWEI {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxSubpassShadingWorkgroupSizeAspectRatio: u32,
}
pub type PFN_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI = 
    unsafe extern "C" fn(
        device: VkDevice,
        renderpass: VkRenderPass,
        pMaxWorkgroupSize: *mut VkExtent2D,
    ) -> VkResult
;
pub type PFN_vkCmdSubpassShadingHUAWEI =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer);
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceInvocationMaskFeaturesHUAWEI {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub invocationMask: VkBool32,
}
pub type PFN_vkCmdBindInvocationMaskHUAWEI = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        imageView: VkImageView,
        imageLayout: VkImageLayout,
    )
;
pub type VkRemoteAddressNV = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryGetRemoteAddressInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalMemoryRDMAFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalMemoryRDMA: VkBool32,
}
pub type PFN_vkGetMemoryRemoteAddressNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        pMemoryGetRemoteAddressInfo: *const VkMemoryGetRemoteAddressInfoNV,
        pAddress: *mut VkRemoteAddressNV,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub extendedDynamicState2: VkBool32,
    pub extendedDynamicState2LogicOp: VkBool32,
    pub extendedDynamicState2PatchControlPoints: VkBool32,
}
pub type PFN_vkCmdSetPatchControlPointsEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, patchControlPoints: u32)
;
pub type PFN_vkCmdSetRasterizerDiscardEnableEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, rasterizerDiscardEnable: VkBool32)
;
pub type PFN_vkCmdSetDepthBiasEnableEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, depthBiasEnable: VkBool32)
;
pub type PFN_vkCmdSetLogicOpEXT =
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, logicOp: VkLogicOp);
pub type PFN_vkCmdSetPrimitiveRestartEnableEXT = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, primitiveRestartEnable: VkBool32)
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceColorWriteEnableFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub colorWriteEnable: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorWriteCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentCount: u32,
    pub pColorWriteEnables: *const VkBool32,
}
pub type PFN_vkCmdSetColorWriteEnableEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        attachmentCount: u32,
        pColorWriteEnables: *const VkBool32,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub primitivesGeneratedQuery: VkBool32,
    pub primitivesGeneratedQueryWithRasterizerDiscard: VkBool32,
    pub primitivesGeneratedQueryWithNonZeroStreams: VkBool32,
}
pub type VkPhysicalDeviceGlobalPriorityQueryFeaturesEXT =
    VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR;
pub type VkQueueFamilyGlobalPriorityPropertiesEXT = VkQueueFamilyGlobalPriorityPropertiesKHR;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageViewMinLodFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minLod: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewMinLodCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub minLod: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiDrawFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub multiDraw: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiDrawPropertiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxMultiDrawCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMultiDrawInfoEXT {
    pub firstVertex: u32,
    pub vertexCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMultiDrawIndexedInfoEXT {
    pub firstIndex: u32,
    pub indexCount: u32,
    pub vertexOffset: i32,
}
pub type PFN_vkCmdDrawMultiEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        drawCount: u32,
        pVertexInfo: *const VkMultiDrawInfoEXT,
        instanceCount: u32,
        firstInstance: u32,
        stride: u32,
    )
;
pub type PFN_vkCmdDrawMultiIndexedEXT = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        drawCount: u32,
        pIndexInfo: *const VkMultiDrawIndexedInfoEXT,
        instanceCount: u32,
        firstInstance: u32,
        stride: u32,
        pVertexOffset: *const i32,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImage2DViewOf3DFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub image2DViewOf3D: VkBool32,
    pub sampler2DViewOf3D: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub borderColorSwizzle: VkBool32,
    pub borderColorSwizzleFromImage: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerBorderColorComponentMappingCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub components: VkComponentMapping,
    pub srgb: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pageableDeviceLocalMemory: VkBool32,
}
pub type PFN_vkSetDeviceMemoryPriorityEXT = 
    unsafe extern "C" fn(device: VkDevice, memory: VkDeviceMemory, priority: f32)
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub descriptorSetHostMapping: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetBindingReferenceVALVE {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub descriptorSetLayout: VkDescriptorSetLayout,
    pub binding: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutHostMappingInfoVALVE {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub descriptorOffset: size_t,
    pub descriptorSize: u32,
}
pub type PFN_vkGetDescriptorSetLayoutHostMappingInfoVALVE = 
    unsafe extern "C" fn(
        device: VkDevice,
        pBindingReference: *const VkDescriptorSetBindingReferenceVALVE,
        pHostMapping: *mut VkDescriptorSetLayoutHostMappingInfoVALVE,
    )
;
pub type PFN_vkGetDescriptorSetHostMappingVALVE = 
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        ppData: *mut *mut ::std::os::raw::c_void,
    )
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentDensityMapOffset: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fragmentDensityOffsetGranularity: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassFragmentDensityMapOffsetEndInfoQCOM {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fragmentDensityOffsetCount: u32,
    pub pFragmentDensityOffsets: *const VkOffset2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLinearColorAttachmentFeaturesNV {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub linearColorAttachment: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureKHR_T {
    _unused: [u8; 0],
}
pub type VkAccelerationStructureKHR = *mut VkAccelerationStructureKHR_T;
pub const VK_BUILD_ACCELERATION_STRUCTURE_MODE_BUILD_KHR:
    VkBuildAccelerationStructureModeKHR = 0;
pub const VK_BUILD_ACCELERATION_STRUCTURE_MODE_UPDATE_KHR:
    VkBuildAccelerationStructureModeKHR = 1;
pub const VK_BUILD_ACCELERATION_STRUCTURE_MODE_MAX_ENUM_KHR:
    VkBuildAccelerationStructureModeKHR = 2147483647;
pub type VkBuildAccelerationStructureModeKHR = ::std::os::raw::c_uint;
pub const VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_KHR:
    VkAccelerationStructureBuildTypeKHR = 0;
pub const VK_ACCELERATION_STRUCTURE_BUILD_TYPE_DEVICE_KHR:
    VkAccelerationStructureBuildTypeKHR = 1;
pub const VK_ACCELERATION_STRUCTURE_BUILD_TYPE_HOST_OR_DEVICE_KHR : VkAccelerationStructureBuildTypeKHR = 2 ;
pub const VK_ACCELERATION_STRUCTURE_BUILD_TYPE_MAX_ENUM_KHR:
    VkAccelerationStructureBuildTypeKHR = 2147483647;
pub type VkAccelerationStructureBuildTypeKHR = ::std::os::raw::c_uint;
pub const VK_ACCELERATION_STRUCTURE_COMPATIBILITY_COMPATIBLE_KHR : VkAccelerationStructureCompatibilityKHR = 0 ;
pub const VK_ACCELERATION_STRUCTURE_COMPATIBILITY_INCOMPATIBLE_KHR : VkAccelerationStructureCompatibilityKHR = 1 ;
pub const VK_ACCELERATION_STRUCTURE_COMPATIBILITY_MAX_ENUM_KHR : VkAccelerationStructureCompatibilityKHR = 2147483647 ;
pub type VkAccelerationStructureCompatibilityKHR = ::std::os::raw::c_uint;
pub const VK_ACCELERATION_STRUCTURE_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR : VkAccelerationStructureCreateFlagBitsKHR = 1 ;
pub const VK_ACCELERATION_STRUCTURE_CREATE_MOTION_BIT_NV : VkAccelerationStructureCreateFlagBitsKHR = 4 ;
pub const VK_ACCELERATION_STRUCTURE_CREATE_FLAG_BITS_MAX_ENUM_KHR : VkAccelerationStructureCreateFlagBitsKHR = 2147483647 ;
pub type VkAccelerationStructureCreateFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkAccelerationStructureCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkDeviceOrHostAddressKHR {
    pub deviceAddress: VkDeviceAddress,
    pub hostAddress: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureBuildRangeInfoKHR {
    pub primitiveCount: u32,
    pub primitiveOffset: u32,
    pub firstVertex: u32,
    pub transformOffset: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryTrianglesDataKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vertexFormat: VkFormat,
    pub vertexData: VkDeviceOrHostAddressConstKHR,
    pub vertexStride: VkDeviceSize,
    pub maxVertex: u32,
    pub indexType: VkIndexType,
    pub indexData: VkDeviceOrHostAddressConstKHR,
    pub transformData: VkDeviceOrHostAddressConstKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryAabbsDataKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub data: VkDeviceOrHostAddressConstKHR,
    pub stride: VkDeviceSize,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryInstancesDataKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub arrayOfPointers: VkBool32,
    pub data: VkDeviceOrHostAddressConstKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkAccelerationStructureGeometryDataKHR {
    pub triangles: VkAccelerationStructureGeometryTrianglesDataKHR,
    pub aabbs: VkAccelerationStructureGeometryAabbsDataKHR,
    pub instances: VkAccelerationStructureGeometryInstancesDataKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureGeometryKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub geometryType: VkGeometryTypeKHR,
    pub geometry: VkAccelerationStructureGeometryDataKHR,
    pub flags: VkGeometryFlagsKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkAccelerationStructureBuildGeometryInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkAccelerationStructureTypeKHR,
    pub flags: VkBuildAccelerationStructureFlagsKHR,
    pub mode: VkBuildAccelerationStructureModeKHR,
    pub srcAccelerationStructure: VkAccelerationStructureKHR,
    pub dstAccelerationStructure: VkAccelerationStructureKHR,
    pub geometryCount: u32,
    pub pGeometries: *const VkAccelerationStructureGeometryKHR,
    pub ppGeometries: *const *const VkAccelerationStructureGeometryKHR,
    pub scratchData: VkDeviceOrHostAddressKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub createFlags: VkAccelerationStructureCreateFlagsKHR,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub type_: VkAccelerationStructureTypeKHR,
    pub deviceAddress: VkDeviceAddress,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSetAccelerationStructureKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructureCount: u32,
    pub pAccelerationStructures: *const VkAccelerationStructureKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceAccelerationStructureFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub accelerationStructure: VkBool32,
    pub accelerationStructureCaptureReplay: VkBool32,
    pub accelerationStructureIndirectBuild: VkBool32,
    pub accelerationStructureHostCommands: VkBool32,
    pub descriptorBindingAccelerationStructureUpdateAfterBind: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceAccelerationStructurePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxGeometryCount: u64,
    pub maxInstanceCount: u64,
    pub maxPrimitiveCount: u64,
    pub maxPerStageDescriptorAccelerationStructures: u32,
    pub maxPerStageDescriptorUpdateAfterBindAccelerationStructures: u32,
    pub maxDescriptorSetAccelerationStructures: u32,
    pub maxDescriptorSetUpdateAfterBindAccelerationStructures: u32,
    pub minAccelerationStructureScratchOffsetAlignment: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureDeviceAddressInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructure: VkAccelerationStructureKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureVersionInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pVersionData: *const u8,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkCopyAccelerationStructureToMemoryInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub src: VkAccelerationStructureKHR,
    pub dst: VkDeviceOrHostAddressKHR,
    pub mode: VkCopyAccelerationStructureModeKHR,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkCopyMemoryToAccelerationStructureInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub src: VkDeviceOrHostAddressConstKHR,
    pub dst: VkAccelerationStructureKHR,
    pub mode: VkCopyAccelerationStructureModeKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyAccelerationStructureInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub src: VkAccelerationStructureKHR,
    pub dst: VkAccelerationStructureKHR,
    pub mode: VkCopyAccelerationStructureModeKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAccelerationStructureBuildSizesInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub accelerationStructureSize: VkDeviceSize,
    pub updateScratchSize: VkDeviceSize,
    pub buildScratchSize: VkDeviceSize,
}
pub type PFN_vkCreateAccelerationStructureKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkAccelerationStructureCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pAccelerationStructure: *mut VkAccelerationStructureKHR,
    ) -> VkResult
;
pub type PFN_vkDestroyAccelerationStructureKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructure: VkAccelerationStructureKHR,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCmdBuildAccelerationStructuresKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const VkAccelerationStructureBuildRangeInfoKHR,
    )
;
pub type PFN_vkCmdBuildAccelerationStructuresIndirectKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        pIndirectDeviceAddresses: *const VkDeviceAddress,
        pIndirectStrides: *const u32,
        ppMaxPrimitiveCounts: *const *const u32,
    )
;
pub type PFN_vkBuildAccelerationStructuresKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        infoCount: u32,
        pInfos: *const VkAccelerationStructureBuildGeometryInfoKHR,
        ppBuildRangeInfos: *const *const VkAccelerationStructureBuildRangeInfoKHR,
    ) -> VkResult
;
pub type PFN_vkCopyAccelerationStructureKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyAccelerationStructureInfoKHR,
    ) -> VkResult
;
pub type PFN_vkCopyAccelerationStructureToMemoryKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyAccelerationStructureToMemoryInfoKHR,
    ) -> VkResult
;
pub type PFN_vkCopyMemoryToAccelerationStructureKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pInfo: *const VkCopyMemoryToAccelerationStructureInfoKHR,
    ) -> VkResult
;
pub type PFN_vkWriteAccelerationStructuresPropertiesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureKHR,
        queryType: VkQueryType,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: size_t,
    ) -> VkResult
;
pub type PFN_vkCmdCopyAccelerationStructureKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyAccelerationStructureInfoKHR,
    )
;
pub type PFN_vkCmdCopyAccelerationStructureToMemoryKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyAccelerationStructureToMemoryInfoKHR,
    )
;
pub type PFN_vkCmdCopyMemoryToAccelerationStructureKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pInfo: *const VkCopyMemoryToAccelerationStructureInfoKHR,
    )
;
pub type PFN_vkGetAccelerationStructureDeviceAddressKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkAccelerationStructureDeviceAddressInfoKHR,
    ) -> VkDeviceAddress
;
pub type PFN_vkCmdWriteAccelerationStructuresPropertiesKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        accelerationStructureCount: u32,
        pAccelerationStructures: *const VkAccelerationStructureKHR,
        queryType: VkQueryType,
        queryPool: VkQueryPool,
        firstQuery: u32,
    )
;
pub type PFN_vkGetDeviceAccelerationStructureCompatibilityKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pVersionInfo: *const VkAccelerationStructureVersionInfoKHR,
        pCompatibility: *mut VkAccelerationStructureCompatibilityKHR,
    )
;
pub type PFN_vkGetAccelerationStructureBuildSizesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        buildType: VkAccelerationStructureBuildTypeKHR,
        pBuildInfo: *const VkAccelerationStructureBuildGeometryInfoKHR,
        pMaxPrimitiveCounts: *const u32,
        pSizeInfo: *mut VkAccelerationStructureBuildSizesInfoKHR,
    )
;
pub const VK_SHADER_GROUP_SHADER_GENERAL_KHR: VkShaderGroupShaderKHR = 0;
pub const VK_SHADER_GROUP_SHADER_CLOSEST_HIT_KHR: VkShaderGroupShaderKHR = 1;
pub const VK_SHADER_GROUP_SHADER_ANY_HIT_KHR: VkShaderGroupShaderKHR = 2;
pub const VK_SHADER_GROUP_SHADER_INTERSECTION_KHR: VkShaderGroupShaderKHR =
    3;
pub const VK_SHADER_GROUP_SHADER_MAX_ENUM_KHR: VkShaderGroupShaderKHR =
    2147483647;
pub type VkShaderGroupShaderKHR = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingShaderGroupCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub type_: VkRayTracingShaderGroupTypeKHR,
    pub generalShader: u32,
    pub closestHitShader: u32,
    pub anyHitShader: u32,
    pub intersectionShader: u32,
    pub pShaderGroupCaptureReplayHandle: *const ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingPipelineInterfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxPipelineRayPayloadSize: u32,
    pub maxPipelineRayHitAttributeSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRayTracingPipelineCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub groupCount: u32,
    pub pGroups: *const VkRayTracingShaderGroupCreateInfoKHR,
    pub maxPipelineRayRecursionDepth: u32,
    pub pLibraryInfo: *const VkPipelineLibraryCreateInfoKHR,
    pub pLibraryInterface: *const VkRayTracingPipelineInterfaceCreateInfoKHR,
    pub pDynamicState: *const VkPipelineDynamicStateCreateInfo,
    pub layout: VkPipelineLayout,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayTracingPipelineFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rayTracingPipeline: VkBool32,
    pub rayTracingPipelineShaderGroupHandleCaptureReplay: VkBool32,
    pub rayTracingPipelineShaderGroupHandleCaptureReplayMixed: VkBool32,
    pub rayTracingPipelineTraceRaysIndirect: VkBool32,
    pub rayTraversalPrimitiveCulling: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayTracingPipelinePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderGroupHandleSize: u32,
    pub maxRayRecursionDepth: u32,
    pub maxShaderGroupStride: u32,
    pub shaderGroupBaseAlignment: u32,
    pub shaderGroupHandleCaptureReplaySize: u32,
    pub maxRayDispatchInvocationCount: u32,
    pub shaderGroupHandleAlignment: u32,
    pub maxRayHitAttributeSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkStridedDeviceAddressRegionKHR {
    pub deviceAddress: VkDeviceAddress,
    pub stride: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTraceRaysIndirectCommandKHR {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
pub type PFN_vkCmdTraceRaysKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRaygenShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        width: u32,
        height: u32,
        depth: u32,
    )
;
pub type PFN_vkCreateRayTracingPipelinesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        deferredOperation: VkDeferredOperationKHR,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkRayTracingPipelineCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult
;
pub type PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        firstGroup: u32,
        groupCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult
;
pub type PFN_vkCmdTraceRaysIndirectKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRaygenShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pMissShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pHitShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        pCallableShaderBindingTable: *const VkStridedDeviceAddressRegionKHR,
        indirectDeviceAddress: VkDeviceAddress,
    )
;
pub type PFN_vkGetRayTracingShaderGroupStackSizeKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        group: u32,
        groupShader: VkShaderGroupShaderKHR,
    ) -> VkDeviceSize
;
pub type PFN_vkCmdSetRayTracingPipelineStackSizeKHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pipelineStackSize: u32)
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceRayQueryFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub rayQuery: VkBool32,
}
pub type IDirectFB = ::std::os::raw::c_void;
pub type IDirectFBSurface = ::std::os::raw::c_void;
pub type zx_handle_t = u32;
pub type DWORD = u32;
pub type LPCWSTR = *const wchar_t;
pub type HANDLE = *mut ::std::os::raw::c_void;
pub type HWND = HANDLE;
pub type HINSTANCE = HANDLE;
pub type HMONITOR = HANDLE;
pub type SECURITY_ATTRIBUTES = ::std::os::raw::c_void;
pub type XID = ::std::os::raw::c_ulong;
pub type VisualID = XID;
pub type Window = XID;
pub type Display = ::std::os::raw::c_void;
pub type xcb_connection_t = ::std::os::raw::c_void;
pub type xcb_window_t = u32;
pub type xcb_visualid_t = u32;
pub type RROutput = XID;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ANativeWindow {
    _unused: [u8; 0],
}
pub type VkAndroidSurfaceCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAndroidSurfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkAndroidSurfaceCreateFlagsKHR,
    pub window: *mut ANativeWindow,
}
pub type PFN_vkCreateAndroidSurfaceKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkAndroidSurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AHardwareBuffer {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAndroidHardwareBufferUsageANDROID {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub androidHardwareBufferUsage: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAndroidHardwareBufferPropertiesANDROID {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub allocationSize: VkDeviceSize,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAndroidHardwareBufferFormatPropertiesANDROID {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub format: VkFormat,
    pub externalFormat: u64,
    pub formatFeatures: VkFormatFeatureFlags,
    pub samplerYcbcrConversionComponents: VkComponentMapping,
    pub suggestedYcbcrModel: VkSamplerYcbcrModelConversion,
    pub suggestedYcbcrRange: VkSamplerYcbcrRange,
    pub suggestedXChromaOffset: VkChromaLocation,
    pub suggestedYChromaOffset: VkChromaLocation,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportAndroidHardwareBufferInfoANDROID {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: *mut AHardwareBuffer,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryGetAndroidHardwareBufferInfoANDROID {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalFormatANDROID {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalFormat: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAndroidHardwareBufferFormatProperties2ANDROID {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub format: VkFormat,
    pub externalFormat: u64,
    pub formatFeatures: VkFormatFeatureFlags2,
    pub samplerYcbcrConversionComponents: VkComponentMapping,
    pub suggestedYcbcrModel: VkSamplerYcbcrModelConversion,
    pub suggestedYcbcrRange: VkSamplerYcbcrRange,
    pub suggestedXChromaOffset: VkChromaLocation,
    pub suggestedYChromaOffset: VkChromaLocation,
}
pub type PFN_vkGetAndroidHardwareBufferPropertiesANDROID = 
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: *const AHardwareBuffer,
        pProperties: *mut VkAndroidHardwareBufferPropertiesANDROID,
    ) -> VkResult
;
pub type PFN_vkGetMemoryAndroidHardwareBufferANDROID = 
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkMemoryGetAndroidHardwareBufferInfoANDROID,
        pBuffer: *mut *mut AHardwareBuffer,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoSessionKHR_T {
    _unused: [u8; 0],
}
pub type VkVideoSessionKHR = *mut VkVideoSessionKHR_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoSessionParametersKHR_T {
    _unused: [u8; 0],
}
pub type VkVideoSessionParametersKHR = *mut VkVideoSessionParametersKHR_T;
pub const VK_QUERY_RESULT_STATUS_ERROR_KHR: VkQueryResultStatusKHR = -1;
pub const VK_QUERY_RESULT_STATUS_NOT_READY_KHR: VkQueryResultStatusKHR = 0;
pub const VK_QUERY_RESULT_STATUS_COMPLETE_KHR: VkQueryResultStatusKHR = 1;
pub const VK_QUERY_RESULT_STATUS_MAX_ENUM_KHR: VkQueryResultStatusKHR =
    2147483647;
pub type VkQueryResultStatusKHR = ::std::os::raw::c_int;
pub const VK_VIDEO_CODEC_OPERATION_INVALID_BIT_KHR:
    VkVideoCodecOperationFlagBitsKHR = 0;
pub const VK_VIDEO_CODEC_OPERATION_ENCODE_H264_BIT_EXT:
    VkVideoCodecOperationFlagBitsKHR = 65536;
pub const VK_VIDEO_CODEC_OPERATION_ENCODE_H265_BIT_EXT:
    VkVideoCodecOperationFlagBitsKHR = 131072;
pub const VK_VIDEO_CODEC_OPERATION_DECODE_H264_BIT_EXT:
    VkVideoCodecOperationFlagBitsKHR = 1;
pub const VK_VIDEO_CODEC_OPERATION_DECODE_H265_BIT_EXT:
    VkVideoCodecOperationFlagBitsKHR = 2;
pub const VK_VIDEO_CODEC_OPERATION_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoCodecOperationFlagBitsKHR = 2147483647;
pub type VkVideoCodecOperationFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoCodecOperationFlagsKHR = VkFlags;
pub const VK_VIDEO_CHROMA_SUBSAMPLING_INVALID_BIT_KHR:
    VkVideoChromaSubsamplingFlagBitsKHR = 0;
pub const VK_VIDEO_CHROMA_SUBSAMPLING_MONOCHROME_BIT_KHR:
    VkVideoChromaSubsamplingFlagBitsKHR = 1;
pub const VK_VIDEO_CHROMA_SUBSAMPLING_420_BIT_KHR:
    VkVideoChromaSubsamplingFlagBitsKHR = 2;
pub const VK_VIDEO_CHROMA_SUBSAMPLING_422_BIT_KHR:
    VkVideoChromaSubsamplingFlagBitsKHR = 4;
pub const VK_VIDEO_CHROMA_SUBSAMPLING_444_BIT_KHR:
    VkVideoChromaSubsamplingFlagBitsKHR = 8;
pub const VK_VIDEO_CHROMA_SUBSAMPLING_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoChromaSubsamplingFlagBitsKHR = 2147483647;
pub type VkVideoChromaSubsamplingFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoChromaSubsamplingFlagsKHR = VkFlags;
pub const VK_VIDEO_COMPONENT_BIT_DEPTH_INVALID_KHR:
    VkVideoComponentBitDepthFlagBitsKHR = 0;
pub const VK_VIDEO_COMPONENT_BIT_DEPTH_8_BIT_KHR:
    VkVideoComponentBitDepthFlagBitsKHR = 1;
pub const VK_VIDEO_COMPONENT_BIT_DEPTH_10_BIT_KHR:
    VkVideoComponentBitDepthFlagBitsKHR = 4;
pub const VK_VIDEO_COMPONENT_BIT_DEPTH_12_BIT_KHR:
    VkVideoComponentBitDepthFlagBitsKHR = 16;
pub const VK_VIDEO_COMPONENT_BIT_DEPTH_FLAG_BITS_MAX_ENUM_KHR : VkVideoComponentBitDepthFlagBitsKHR = 2147483647 ;
pub type VkVideoComponentBitDepthFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoComponentBitDepthFlagsKHR = VkFlags;
pub const VK_VIDEO_CAPABILITY_PROTECTED_CONTENT_BIT_KHR:
    VkVideoCapabilityFlagBitsKHR = 1;
pub const VK_VIDEO_CAPABILITY_SEPARATE_REFERENCE_IMAGES_BIT_KHR:
    VkVideoCapabilityFlagBitsKHR = 2;
pub const VK_VIDEO_CAPABILITY_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoCapabilityFlagBitsKHR = 2147483647;
pub type VkVideoCapabilityFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoCapabilityFlagsKHR = VkFlags;
pub const VK_VIDEO_SESSION_CREATE_DEFAULT_KHR:
    VkVideoSessionCreateFlagBitsKHR = 0;
pub const VK_VIDEO_SESSION_CREATE_PROTECTED_CONTENT_BIT_KHR:
    VkVideoSessionCreateFlagBitsKHR = 1;
pub const VK_VIDEO_SESSION_CREATE_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoSessionCreateFlagBitsKHR = 2147483647;
pub type VkVideoSessionCreateFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoSessionCreateFlagsKHR = VkFlags;
pub type VkVideoBeginCodingFlagsKHR = VkFlags;
pub type VkVideoEndCodingFlagsKHR = VkFlags;
pub const VK_VIDEO_CODING_CONTROL_DEFAULT_KHR:
    VkVideoCodingControlFlagBitsKHR = 0;
pub const VK_VIDEO_CODING_CONTROL_RESET_BIT_KHR:
    VkVideoCodingControlFlagBitsKHR = 1;
pub const VK_VIDEO_CODING_CONTROL_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoCodingControlFlagBitsKHR = 2147483647;
pub type VkVideoCodingControlFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoCodingControlFlagsKHR = VkFlags;
pub const VK_VIDEO_CODING_QUALITY_PRESET_NORMAL_BIT_KHR:
    VkVideoCodingQualityPresetFlagBitsKHR = 1;
pub const VK_VIDEO_CODING_QUALITY_PRESET_POWER_BIT_KHR:
    VkVideoCodingQualityPresetFlagBitsKHR = 2;
pub const VK_VIDEO_CODING_QUALITY_PRESET_QUALITY_BIT_KHR:
    VkVideoCodingQualityPresetFlagBitsKHR = 4;
pub const VK_VIDEO_CODING_QUALITY_PRESET_FLAG_BITS_MAX_ENUM_KHR : VkVideoCodingQualityPresetFlagBitsKHR = 2147483647 ;
pub type VkVideoCodingQualityPresetFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoCodingQualityPresetFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyQueryResultStatusProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supported: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoQueueFamilyProperties2KHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub videoCodecOperations: VkVideoCodecOperationFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoProfileKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub videoCodecOperation: VkVideoCodecOperationFlagBitsKHR,
    pub chromaSubsampling: VkVideoChromaSubsamplingFlagsKHR,
    pub lumaBitDepth: VkVideoComponentBitDepthFlagsKHR,
    pub chromaBitDepth: VkVideoComponentBitDepthFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoProfilesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub profileCount: u32,
    pub pProfiles: *const VkVideoProfileKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub capabilityFlags: VkVideoCapabilityFlagsKHR,
    pub minBitstreamBufferOffsetAlignment: VkDeviceSize,
    pub minBitstreamBufferSizeAlignment: VkDeviceSize,
    pub videoPictureExtentGranularity: VkExtent2D,
    pub minExtent: VkExtent2D,
    pub maxExtent: VkExtent2D,
    pub maxReferencePicturesSlotsCount: u32,
    pub maxReferencePicturesActiveCount: u32,
    pub stdHeaderVersion: VkExtensionProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVideoFormatInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageUsage: VkImageUsageFlags,
    pub pVideoProfiles: *const VkVideoProfilesKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoFormatPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub format: VkFormat,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoPictureResourceKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub codedOffset: VkOffset2D,
    pub codedExtent: VkExtent2D,
    pub baseArrayLayer: u32,
    pub imageViewBinding: VkImageView,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoReferenceSlotKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub slotIndex: i8,
    pub pPictureResource: *const VkVideoPictureResourceKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoGetMemoryPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memoryBindIndex: u32,
    pub pMemoryRequirements: *mut VkMemoryRequirements2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoBindMemoryKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memoryBindIndex: u32,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub memorySize: VkDeviceSize,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoSessionCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub queueFamilyIndex: u32,
    pub flags: VkVideoSessionCreateFlagsKHR,
    pub pVideoProfile: *const VkVideoProfileKHR,
    pub pictureFormat: VkFormat,
    pub maxCodedExtent: VkExtent2D,
    pub referencePicturesFormat: VkFormat,
    pub maxReferencePicturesSlotsCount: u32,
    pub maxReferencePicturesActiveCount: u32,
    pub pStdHeaderVersion: *const VkExtensionProperties,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoSessionParametersCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub videoSessionParametersTemplate: VkVideoSessionParametersKHR,
    pub videoSession: VkVideoSessionKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoSessionParametersUpdateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub updateSequenceCount: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoBeginCodingInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkVideoBeginCodingFlagsKHR,
    pub codecQualityPreset: VkVideoCodingQualityPresetFlagsKHR,
    pub videoSession: VkVideoSessionKHR,
    pub videoSessionParameters: VkVideoSessionParametersKHR,
    pub referenceSlotCount: u32,
    pub pReferenceSlots: *const VkVideoReferenceSlotKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEndCodingInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkVideoEndCodingFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoCodingControlInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkVideoCodingControlFlagsKHR,
}
pub type PFN_vkGetPhysicalDeviceVideoCapabilitiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pVideoProfile: *const VkVideoProfileKHR,
        pCapabilities: *mut VkVideoCapabilitiesKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceVideoFormatPropertiesKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pVideoFormatInfo: *const VkPhysicalDeviceVideoFormatInfoKHR,
        pVideoFormatPropertyCount: *mut u32,
        pVideoFormatProperties: *mut VkVideoFormatPropertiesKHR,
    ) -> VkResult
;
pub type PFN_vkCreateVideoSessionKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkVideoSessionCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pVideoSession: *mut VkVideoSessionKHR,
    ) -> VkResult
;
pub type PFN_vkDestroyVideoSessionKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        videoSession: VkVideoSessionKHR,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetVideoSessionMemoryRequirementsKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        videoSession: VkVideoSessionKHR,
        pVideoSessionMemoryRequirementsCount: *mut u32,
        pVideoSessionMemoryRequirements: *mut VkVideoGetMemoryPropertiesKHR,
    ) -> VkResult
;
pub type PFN_vkBindVideoSessionMemoryKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        videoSession: VkVideoSessionKHR,
        videoSessionBindMemoryCount: u32,
        pVideoSessionBindMemories: *const VkVideoBindMemoryKHR,
    ) -> VkResult
;
pub type PFN_vkCreateVideoSessionParametersKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkVideoSessionParametersCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pVideoSessionParameters: *mut VkVideoSessionParametersKHR,
    ) -> VkResult
;
pub type PFN_vkUpdateVideoSessionParametersKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        videoSessionParameters: VkVideoSessionParametersKHR,
        pUpdateInfo: *const VkVideoSessionParametersUpdateInfoKHR,
    ) -> VkResult
;
pub type PFN_vkDestroyVideoSessionParametersKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        videoSessionParameters: VkVideoSessionParametersKHR,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkCmdBeginVideoCodingKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pBeginInfo: *const VkVideoBeginCodingInfoKHR,
    )
;
pub type PFN_vkCmdEndVideoCodingKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pEndCodingInfo: *const VkVideoEndCodingInfoKHR,
    )
;
pub type PFN_vkCmdControlVideoCodingKHR = 
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pCodingControlInfo: *const VkVideoCodingControlInfoKHR,
    )
;
pub const VK_VIDEO_DECODE_CAPABILITY_DEFAULT_KHR:
    VkVideoDecodeCapabilityFlagBitsKHR = 0;
pub const VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_COINCIDE_BIT_KHR : VkVideoDecodeCapabilityFlagBitsKHR = 1 ;
pub const VK_VIDEO_DECODE_CAPABILITY_DPB_AND_OUTPUT_DISTINCT_BIT_KHR : VkVideoDecodeCapabilityFlagBitsKHR = 2 ;
pub const VK_VIDEO_DECODE_CAPABILITY_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoDecodeCapabilityFlagBitsKHR = 2147483647;
pub type VkVideoDecodeCapabilityFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoDecodeCapabilityFlagsKHR = VkFlags;
pub const VK_VIDEO_DECODE_DEFAULT_KHR: VkVideoDecodeFlagBitsKHR = 0;
pub const VK_VIDEO_DECODE_RESERVED_0_BIT_KHR: VkVideoDecodeFlagBitsKHR = 1;
pub const VK_VIDEO_DECODE_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoDecodeFlagBitsKHR = 2147483647;
pub type VkVideoDecodeFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoDecodeFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub flags: VkVideoDecodeCapabilityFlagsKHR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkVideoDecodeFlagsKHR,
    pub srcBuffer: VkBuffer,
    pub srcBufferOffset: VkDeviceSize,
    pub srcBufferRange: VkDeviceSize,
    pub dstPictureResource: VkVideoPictureResourceKHR,
    pub pSetupReferenceSlot: *const VkVideoReferenceSlotKHR,
    pub referenceSlotCount: u32,
    pub pReferenceSlots: *const VkVideoReferenceSlotKHR,
}
pub type PFN_vkCmdDecodeVideoKHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pFrameInfo: *const VkVideoDecodeInfoKHR)
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePortabilitySubsetFeaturesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub constantAlphaColorBlendFactors: VkBool32,
    pub events: VkBool32,
    pub imageViewFormatReinterpretation: VkBool32,
    pub imageViewFormatSwizzle: VkBool32,
    pub imageView2DOn3DImage: VkBool32,
    pub multisampleArrayImage: VkBool32,
    pub mutableComparisonSamplers: VkBool32,
    pub pointPolygons: VkBool32,
    pub samplerMipLodBias: VkBool32,
    pub separateStencilMaskRef: VkBool32,
    pub shaderSampleRateInterpolationFunctions: VkBool32,
    pub tessellationIsolines: VkBool32,
    pub tessellationPointMode: VkBool32,
    pub triangleFans: VkBool32,
    pub vertexAttributeAccessBeyondStride: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePortabilitySubsetPropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub minVertexInputBindingStrideAlignment: u32,
}
pub const VK_VIDEO_ENCODE_DEFAULT_KHR: VkVideoEncodeFlagBitsKHR = 0;
pub const VK_VIDEO_ENCODE_RESERVED_0_BIT_KHR: VkVideoEncodeFlagBitsKHR = 1;
pub const VK_VIDEO_ENCODE_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoEncodeFlagBitsKHR = 2147483647;
pub type VkVideoEncodeFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoEncodeFlagsKHR = VkFlags;
pub const VK_VIDEO_ENCODE_CAPABILITY_DEFAULT_KHR:
    VkVideoEncodeCapabilityFlagBitsKHR = 0;
pub const VK_VIDEO_ENCODE_CAPABILITY_PRECEDING_EXTERNALLY_ENCODED_BYTES_BIT_KHR : VkVideoEncodeCapabilityFlagBitsKHR = 1 ;
pub const VK_VIDEO_ENCODE_CAPABILITY_FLAG_BITS_MAX_ENUM_KHR:
    VkVideoEncodeCapabilityFlagBitsKHR = 2147483647;
pub type VkVideoEncodeCapabilityFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoEncodeCapabilityFlagsKHR = VkFlags;
pub const VK_VIDEO_ENCODE_RATE_CONTROL_MODE_NONE_BIT_KHR:
    VkVideoEncodeRateControlModeFlagBitsKHR = 0;
pub const VK_VIDEO_ENCODE_RATE_CONTROL_MODE_CBR_BIT_KHR:
    VkVideoEncodeRateControlModeFlagBitsKHR = 1;
pub const VK_VIDEO_ENCODE_RATE_CONTROL_MODE_VBR_BIT_KHR:
    VkVideoEncodeRateControlModeFlagBitsKHR = 2;
pub const VK_VIDEO_ENCODE_RATE_CONTROL_MODE_FLAG_BITS_MAX_ENUM_KHR : VkVideoEncodeRateControlModeFlagBitsKHR = 2147483647 ;
pub type VkVideoEncodeRateControlModeFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoEncodeRateControlModeFlagsKHR = VkFlags;
pub const VK_VIDEO_ENCODE_RATE_CONTROL_DEFAULT_KHR:
    VkVideoEncodeRateControlFlagBitsKHR = 0;
pub const VK_VIDEO_ENCODE_RATE_CONTROL_RESERVED_0_BIT_KHR:
    VkVideoEncodeRateControlFlagBitsKHR = 1;
pub const VK_VIDEO_ENCODE_RATE_CONTROL_FLAG_BITS_MAX_ENUM_KHR : VkVideoEncodeRateControlFlagBitsKHR = 2147483647 ;
pub type VkVideoEncodeRateControlFlagBitsKHR = ::std::os::raw::c_uint;
pub type VkVideoEncodeRateControlFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkVideoEncodeFlagsKHR,
    pub qualityLevel: u32,
    pub dstBitstreamBuffer: VkBuffer,
    pub dstBitstreamBufferOffset: VkDeviceSize,
    pub dstBitstreamBufferMaxRange: VkDeviceSize,
    pub srcPictureResource: VkVideoPictureResourceKHR,
    pub pSetupReferenceSlot: *const VkVideoReferenceSlotKHR,
    pub referenceSlotCount: u32,
    pub pReferenceSlots: *const VkVideoReferenceSlotKHR,
    pub precedingExternallyEncodedBytes: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeCapabilitiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub flags: VkVideoEncodeCapabilityFlagsKHR,
    pub rateControlModes: VkVideoEncodeRateControlModeFlagsKHR,
    pub rateControlLayerCount: u8,
    pub qualityLevelCount: u8,
    pub inputImageDataFillAlignment: VkExtent2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeRateControlLayerInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub averageBitrate: u32,
    pub maxBitrate: u32,
    pub frameRateNumerator: u32,
    pub frameRateDenominator: u32,
    pub virtualBufferSizeInMs: u32,
    pub initialVirtualBufferSizeInMs: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeRateControlInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkVideoEncodeRateControlFlagsKHR,
    pub rateControlMode: VkVideoEncodeRateControlModeFlagBitsKHR,
    pub layerCount: u8,
    pub pLayerConfigs: *const VkVideoEncodeRateControlLayerInfoKHR,
}
pub type PFN_vkCmdEncodeVideoKHR = 
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, pEncodeInfo: *const VkVideoEncodeInfoKHR)
;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_MONOCHROME:
    StdVideoH264ChromaFormatIdc = 0;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_420:
    StdVideoH264ChromaFormatIdc = 1;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_422:
    StdVideoH264ChromaFormatIdc = 2;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_444:
    StdVideoH264ChromaFormatIdc = 3;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_INVALID:
    StdVideoH264ChromaFormatIdc = 2147483647;
pub const StdVideoH264ChromaFormatIdc_STD_VIDEO_H264_CHROMA_FORMAT_IDC_MAX_ENUM:
    StdVideoH264ChromaFormatIdc = 2147483647;
pub type StdVideoH264ChromaFormatIdc = ::std::os::raw::c_uint;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_BASELINE: StdVideoH264ProfileIdc = 66;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_MAIN: StdVideoH264ProfileIdc = 77;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_HIGH: StdVideoH264ProfileIdc = 100;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_HIGH_444_PREDICTIVE:
    StdVideoH264ProfileIdc = 244;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_INVALID: StdVideoH264ProfileIdc =
    2147483647;
pub const StdVideoH264ProfileIdc_STD_VIDEO_H264_PROFILE_IDC_MAX_ENUM: StdVideoH264ProfileIdc =
    2147483647;
pub type StdVideoH264ProfileIdc = ::std::os::raw::c_uint;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_0: StdVideoH264Level = 0;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_1: StdVideoH264Level = 1;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_2: StdVideoH264Level = 2;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_1_3: StdVideoH264Level = 3;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_2_0: StdVideoH264Level = 4;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_2_1: StdVideoH264Level = 5;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_2_2: StdVideoH264Level = 6;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_3_0: StdVideoH264Level = 7;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_3_1: StdVideoH264Level = 8;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_3_2: StdVideoH264Level = 9;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_4_0: StdVideoH264Level = 10;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_4_1: StdVideoH264Level = 11;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_4_2: StdVideoH264Level = 12;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_5_0: StdVideoH264Level = 13;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_5_1: StdVideoH264Level = 14;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_5_2: StdVideoH264Level = 15;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_6_0: StdVideoH264Level = 16;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_6_1: StdVideoH264Level = 17;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_6_2: StdVideoH264Level = 18;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_INVALID: StdVideoH264Level = 2147483647;
pub const StdVideoH264Level_STD_VIDEO_H264_LEVEL_MAX_ENUM: StdVideoH264Level = 2147483647;
pub type StdVideoH264Level = ::std::os::raw::c_uint;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_0: StdVideoH264PocType = 0;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_1: StdVideoH264PocType = 1;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_2: StdVideoH264PocType = 2;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_INVALID: StdVideoH264PocType = 2147483647;
pub const StdVideoH264PocType_STD_VIDEO_H264_POC_TYPE_MAX_ENUM: StdVideoH264PocType = 2147483647;
pub type StdVideoH264PocType = ::std::os::raw::c_uint;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_UNSPECIFIED:
    StdVideoH264AspectRatioIdc = 0;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_SQUARE:
    StdVideoH264AspectRatioIdc = 1;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_12_11:
    StdVideoH264AspectRatioIdc = 2;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_10_11:
    StdVideoH264AspectRatioIdc = 3;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_16_11:
    StdVideoH264AspectRatioIdc = 4;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_40_33:
    StdVideoH264AspectRatioIdc = 5;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_24_11:
    StdVideoH264AspectRatioIdc = 6;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_20_11:
    StdVideoH264AspectRatioIdc = 7;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_32_11:
    StdVideoH264AspectRatioIdc = 8;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_80_33:
    StdVideoH264AspectRatioIdc = 9;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_18_11:
    StdVideoH264AspectRatioIdc = 10;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_15_11:
    StdVideoH264AspectRatioIdc = 11;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_64_33:
    StdVideoH264AspectRatioIdc = 12;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_160_99:
    StdVideoH264AspectRatioIdc = 13;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_4_3:
    StdVideoH264AspectRatioIdc = 14;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_3_2:
    StdVideoH264AspectRatioIdc = 15;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_2_1:
    StdVideoH264AspectRatioIdc = 16;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_EXTENDED_SAR:
    StdVideoH264AspectRatioIdc = 255;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_INVALID:
    StdVideoH264AspectRatioIdc = 2147483647;
pub const StdVideoH264AspectRatioIdc_STD_VIDEO_H264_ASPECT_RATIO_IDC_MAX_ENUM:
    StdVideoH264AspectRatioIdc = 2147483647;
pub type StdVideoH264AspectRatioIdc = ::std::os::raw::c_uint;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_DEFAULT:
    StdVideoH264WeightedBipredIdc = 0;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_EXPLICIT:
    StdVideoH264WeightedBipredIdc = 1;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_IMPLICIT:
    StdVideoH264WeightedBipredIdc = 2;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_INVALID:
    StdVideoH264WeightedBipredIdc = 2147483647;
pub const StdVideoH264WeightedBipredIdc_STD_VIDEO_H264_WEIGHTED_BIPRED_IDC_MAX_ENUM:
    StdVideoH264WeightedBipredIdc = 2147483647;
pub type StdVideoH264WeightedBipredIdc = ::std::os::raw::c_uint;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_SUBTRACT : StdVideoH264ModificationOfPicNumsIdc = 0 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_SHORT_TERM_ADD : StdVideoH264ModificationOfPicNumsIdc = 1 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_LONG_TERM : StdVideoH264ModificationOfPicNumsIdc = 2 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_END:
    StdVideoH264ModificationOfPicNumsIdc = 3;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_INVALID : StdVideoH264ModificationOfPicNumsIdc = 2147483647 ;
pub const StdVideoH264ModificationOfPicNumsIdc_STD_VIDEO_H264_MODIFICATION_OF_PIC_NUMS_IDC_MAX_ENUM : StdVideoH264ModificationOfPicNumsIdc = 2147483647 ;
pub type StdVideoH264ModificationOfPicNumsIdc = ::std::os::raw::c_uint;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_END:
    StdVideoH264MemMgmtControlOp = 0;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_SHORT_TERM:
    StdVideoH264MemMgmtControlOp = 1;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_LONG_TERM:
    StdVideoH264MemMgmtControlOp = 2;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_LONG_TERM:
    StdVideoH264MemMgmtControlOp = 3;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_SET_MAX_LONG_TERM_INDEX : StdVideoH264MemMgmtControlOp = 4 ;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_UNMARK_ALL:
    StdVideoH264MemMgmtControlOp = 5;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MARK_CURRENT_AS_LONG_TERM : StdVideoH264MemMgmtControlOp = 6 ;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_INVALID:
    StdVideoH264MemMgmtControlOp = 2147483647;
pub const StdVideoH264MemMgmtControlOp_STD_VIDEO_H264_MEM_MGMT_CONTROL_OP_MAX_ENUM:
    StdVideoH264MemMgmtControlOp = 2147483647;
pub type StdVideoH264MemMgmtControlOp = ::std::os::raw::c_uint;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_0: StdVideoH264CabacInitIdc = 0;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_1: StdVideoH264CabacInitIdc = 1;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_2: StdVideoH264CabacInitIdc = 2;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_INVALID: StdVideoH264CabacInitIdc =
    2147483647;
pub const StdVideoH264CabacInitIdc_STD_VIDEO_H264_CABAC_INIT_IDC_MAX_ENUM:
    StdVideoH264CabacInitIdc = 2147483647;
pub type StdVideoH264CabacInitIdc = ::std::os::raw::c_uint;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_DISABLED : StdVideoH264DisableDeblockingFilterIdc = 0 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_ENABLED : StdVideoH264DisableDeblockingFilterIdc = 1 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_PARTIAL : StdVideoH264DisableDeblockingFilterIdc = 2 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_INVALID : StdVideoH264DisableDeblockingFilterIdc = 2147483647 ;
pub const StdVideoH264DisableDeblockingFilterIdc_STD_VIDEO_H264_DISABLE_DEBLOCKING_FILTER_IDC_MAX_ENUM : StdVideoH264DisableDeblockingFilterIdc = 2147483647 ;
pub type StdVideoH264DisableDeblockingFilterIdc = ::std::os::raw::c_uint;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_P: StdVideoH264SliceType = 0;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_B: StdVideoH264SliceType = 1;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_I: StdVideoH264SliceType = 2;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_INVALID: StdVideoH264SliceType =
    2147483647;
pub const StdVideoH264SliceType_STD_VIDEO_H264_SLICE_TYPE_MAX_ENUM: StdVideoH264SliceType =
    2147483647;
pub type StdVideoH264SliceType = ::std::os::raw::c_uint;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_P: StdVideoH264PictureType = 0;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_B: StdVideoH264PictureType = 1;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_I: StdVideoH264PictureType = 2;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_IDR: StdVideoH264PictureType = 5;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_INVALID: StdVideoH264PictureType =
    2147483647;
pub const StdVideoH264PictureType_STD_VIDEO_H264_PICTURE_TYPE_MAX_ENUM: StdVideoH264PictureType =
    2147483647;
pub type StdVideoH264PictureType = ::std::os::raw::c_uint;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_SPS:
    StdVideoH264NonVclNaluType = 0;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_PPS:
    StdVideoH264NonVclNaluType = 1;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_AUD:
    StdVideoH264NonVclNaluType = 2;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_PREFIX:
    StdVideoH264NonVclNaluType = 3;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_SEQUENCE:
    StdVideoH264NonVclNaluType = 4;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_END_OF_STREAM:
    StdVideoH264NonVclNaluType = 5;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_PRECODED:
    StdVideoH264NonVclNaluType = 6;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_INVALID:
    StdVideoH264NonVclNaluType = 2147483647;
pub const StdVideoH264NonVclNaluType_STD_VIDEO_H264_NON_VCL_NALU_TYPE_MAX_ENUM:
    StdVideoH264NonVclNaluType = 2147483647;
pub type StdVideoH264NonVclNaluType = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SpsVuiFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
impl StdVideoH264SpsVuiFlags {
    #[inline]
    pub fn aspect_ratio_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aspect_ratio_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_appropriate_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_appropriate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_signal_type_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_signal_type_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_full_range_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_full_range_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn color_description_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_color_description_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_loc_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_loc_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn timing_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_frame_rate_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_frame_rate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bitstream_restriction_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bitstream_restriction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nal_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nal_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vcl_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vcl_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        aspect_ratio_info_present_flag: u32,
        overscan_info_present_flag: u32,
        overscan_appropriate_flag: u32,
        video_signal_type_present_flag: u32,
        video_full_range_flag: u32,
        color_description_present_flag: u32,
        chroma_loc_info_present_flag: u32,
        timing_info_present_flag: u32,
        fixed_frame_rate_flag: u32,
        bitstream_restriction_flag: u32,
        nal_hrd_parameters_present_flag: u32,
        vcl_hrd_parameters_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let aspect_ratio_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(aspect_ratio_info_present_flag) };
            aspect_ratio_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let overscan_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_info_present_flag) };
            overscan_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let overscan_appropriate_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_appropriate_flag) };
            overscan_appropriate_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let video_signal_type_present_flag: u32 =
                unsafe { ::std::mem::transmute(video_signal_type_present_flag) };
            video_signal_type_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let video_full_range_flag: u32 =
                unsafe { ::std::mem::transmute(video_full_range_flag) };
            video_full_range_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let color_description_present_flag: u32 =
                unsafe { ::std::mem::transmute(color_description_present_flag) };
            color_description_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let chroma_loc_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(chroma_loc_info_present_flag) };
            chroma_loc_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let timing_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(timing_info_present_flag) };
            timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let fixed_frame_rate_flag: u32 =
                unsafe { ::std::mem::transmute(fixed_frame_rate_flag) };
            fixed_frame_rate_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let bitstream_restriction_flag: u32 =
                unsafe { ::std::mem::transmute(bitstream_restriction_flag) };
            bitstream_restriction_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let nal_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(nal_hrd_parameters_present_flag) };
            nal_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vcl_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vcl_hrd_parameters_present_flag) };
            vcl_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264HrdParameters {
    pub cpb_cnt_minus1: u8,
    pub bit_rate_scale: u8,
    pub cpb_size_scale: u8,
    pub bit_rate_value_minus1: [u32; 32usize],
    pub cpb_size_value_minus1: [u32; 32usize],
    pub cbr_flag: [u8; 32usize],
    pub initial_cpb_removal_delay_length_minus1: u32,
    pub cpb_removal_delay_length_minus1: u32,
    pub dpb_output_delay_length_minus1: u32,
    pub time_offset_length: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SequenceParameterSetVui {
    pub flags: StdVideoH264SpsVuiFlags,
    pub aspect_ratio_idc: StdVideoH264AspectRatioIdc,
    pub sar_width: u16,
    pub sar_height: u16,
    pub video_format: u8,
    pub color_primaries: u8,
    pub transfer_characteristics: u8,
    pub matrix_coefficients: u8,
    pub num_units_in_tick: u32,
    pub time_scale: u32,
    pub pHrdParameters: *const StdVideoH264HrdParameters,
    pub max_num_reorder_frames: u8,
    pub max_dec_frame_buffering: u8,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
impl StdVideoH264SpsFlags {
    #[inline]
    pub fn constraint_set0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set1_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set1_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set2_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set2_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set3_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set3_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set4_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set4_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constraint_set5_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constraint_set5_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn direct_8x8_inference_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_8x8_inference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mb_adaptive_frame_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mb_adaptive_frame_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_mbs_only_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_mbs_only_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn delta_pic_order_always_zero_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_delta_pic_order_always_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn gaps_in_frame_num_value_allowed_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_gaps_in_frame_num_value_allowed_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn qpprime_y_zero_transform_bypass_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_qpprime_y_zero_transform_bypass_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_cropping_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_cropping_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn seq_scaling_matrix_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_seq_scaling_matrix_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        constraint_set0_flag: u32,
        constraint_set1_flag: u32,
        constraint_set2_flag: u32,
        constraint_set3_flag: u32,
        constraint_set4_flag: u32,
        constraint_set5_flag: u32,
        direct_8x8_inference_flag: u32,
        mb_adaptive_frame_field_flag: u32,
        frame_mbs_only_flag: u32,
        delta_pic_order_always_zero_flag: u32,
        separate_colour_plane_flag: u32,
        gaps_in_frame_num_value_allowed_flag: u32,
        qpprime_y_zero_transform_bypass_flag: u32,
        frame_cropping_flag: u32,
        seq_scaling_matrix_present_flag: u32,
        vui_parameters_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let constraint_set0_flag: u32 = unsafe { ::std::mem::transmute(constraint_set0_flag) };
            constraint_set0_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let constraint_set1_flag: u32 = unsafe { ::std::mem::transmute(constraint_set1_flag) };
            constraint_set1_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let constraint_set2_flag: u32 = unsafe { ::std::mem::transmute(constraint_set2_flag) };
            constraint_set2_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let constraint_set3_flag: u32 = unsafe { ::std::mem::transmute(constraint_set3_flag) };
            constraint_set3_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let constraint_set4_flag: u32 = unsafe { ::std::mem::transmute(constraint_set4_flag) };
            constraint_set4_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let constraint_set5_flag: u32 = unsafe { ::std::mem::transmute(constraint_set5_flag) };
            constraint_set5_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let direct_8x8_inference_flag: u32 =
                unsafe { ::std::mem::transmute(direct_8x8_inference_flag) };
            direct_8x8_inference_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let mb_adaptive_frame_field_flag: u32 =
                unsafe { ::std::mem::transmute(mb_adaptive_frame_field_flag) };
            mb_adaptive_frame_field_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let frame_mbs_only_flag: u32 = unsafe { ::std::mem::transmute(frame_mbs_only_flag) };
            frame_mbs_only_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let delta_pic_order_always_zero_flag: u32 =
                unsafe { ::std::mem::transmute(delta_pic_order_always_zero_flag) };
            delta_pic_order_always_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::std::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let gaps_in_frame_num_value_allowed_flag: u32 =
                unsafe { ::std::mem::transmute(gaps_in_frame_num_value_allowed_flag) };
            gaps_in_frame_num_value_allowed_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let qpprime_y_zero_transform_bypass_flag: u32 =
                unsafe { ::std::mem::transmute(qpprime_y_zero_transform_bypass_flag) };
            qpprime_y_zero_transform_bypass_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let frame_cropping_flag: u32 = unsafe { ::std::mem::transmute(frame_cropping_flag) };
            frame_cropping_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let seq_scaling_matrix_present_flag: u32 =
                unsafe { ::std::mem::transmute(seq_scaling_matrix_present_flag) };
            seq_scaling_matrix_present_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let vui_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_parameters_present_flag) };
            vui_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264ScalingLists {
    pub scaling_list_present_mask: u8,
    pub use_default_scaling_matrix_mask: u8,
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 2usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264SequenceParameterSet {
    pub flags: StdVideoH264SpsFlags,
    pub profile_idc: StdVideoH264ProfileIdc,
    pub level_idc: StdVideoH264Level,
    pub seq_parameter_set_id: u8,
    pub chroma_format_idc: StdVideoH264ChromaFormatIdc,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub log2_max_frame_num_minus4: u8,
    pub pic_order_cnt_type: StdVideoH264PocType,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
    pub offset_for_non_ref_pic: i32,
    pub offset_for_top_to_bottom_field: i32,
    pub num_ref_frames_in_pic_order_cnt_cycle: u8,
    pub max_num_ref_frames: u8,
    pub pic_width_in_mbs_minus1: u32,
    pub pic_height_in_map_units_minus1: u32,
    pub frame_crop_left_offset: u32,
    pub frame_crop_right_offset: u32,
    pub frame_crop_top_offset: u32,
    pub frame_crop_bottom_offset: u32,
    pub pOffsetForRefFrame: *const i32,
    pub pScalingLists: *const StdVideoH264ScalingLists,
    pub pSequenceParameterSetVui: *const StdVideoH264SequenceParameterSetVui,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264PpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
impl StdVideoH264PpsFlags {
    #[inline]
    pub fn transform_8x8_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_8x8_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn redundant_pic_cnt_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_redundant_pic_cnt_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_control_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_control_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_idc_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_idc_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_order_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_order_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_scaling_matrix_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_scaling_matrix_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        transform_8x8_mode_flag: u32,
        redundant_pic_cnt_present_flag: u32,
        constrained_intra_pred_flag: u32,
        deblocking_filter_control_present_flag: u32,
        weighted_bipred_idc_flag: u32,
        weighted_pred_flag: u32,
        pic_order_present_flag: u32,
        entropy_coding_mode_flag: u32,
        pic_scaling_matrix_present_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let transform_8x8_mode_flag: u32 =
                unsafe { ::std::mem::transmute(transform_8x8_mode_flag) };
            transform_8x8_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let redundant_pic_cnt_present_flag: u32 =
                unsafe { ::std::mem::transmute(redundant_pic_cnt_present_flag) };
            redundant_pic_cnt_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let deblocking_filter_control_present_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_control_present_flag) };
            deblocking_filter_control_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let weighted_bipred_idc_flag: u32 =
                unsafe { ::std::mem::transmute(weighted_bipred_idc_flag) };
            weighted_bipred_idc_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::std::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pic_order_present_flag: u32 =
                unsafe { ::std::mem::transmute(pic_order_present_flag) };
            pic_order_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let entropy_coding_mode_flag: u32 =
                unsafe { ::std::mem::transmute(entropy_coding_mode_flag) };
            entropy_coding_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let pic_scaling_matrix_present_flag: u32 =
                unsafe { ::std::mem::transmute(pic_scaling_matrix_present_flag) };
            pic_scaling_matrix_present_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH264PictureParameterSet {
    pub flags: StdVideoH264PpsFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub weighted_bipred_idc: StdVideoH264WeightedBipredIdc,
    pub pic_init_qp_minus26: i8,
    pub pic_init_qs_minus26: i8,
    pub chroma_qp_index_offset: i8,
    pub second_chroma_qp_index_offset: i8,
    pub pScalingLists: *const StdVideoH264ScalingLists,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264WeightTableFlags {
    pub luma_weight_l0_flag: u32,
    pub chroma_weight_l0_flag: u32,
    pub luma_weight_l1_flag: u32,
    pub chroma_weight_l1_flag: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264WeightTable {
    pub flags: StdVideoEncodeH264WeightTableFlags,
    pub luma_log2_weight_denom: u8,
    pub chroma_log2_weight_denom: u8,
    pub luma_weight_l0: [i8; 32usize],
    pub luma_offset_l0: [i8; 32usize],
    pub chroma_weight_l0: [[i8; 2usize]; 32usize],
    pub chroma_offset_l0: [[i8; 2usize]; 32usize],
    pub luma_weight_l1: [i8; 32usize],
    pub luma_offset_l1: [i8; 32usize],
    pub chroma_weight_l1: [[i8; 2usize]; 32usize],
    pub chroma_offset_l1: [[i8; 2usize]; 32usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264SliceHeaderFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoEncodeH264SliceHeaderFlags {
    #[inline]
    pub fn direct_spatial_mv_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_direct_spatial_mv_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_ref_idx_active_override_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_ref_idx_active_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_output_of_prior_pics_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_output_of_prior_pics_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn adaptive_ref_pic_marking_mode_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_adaptive_ref_pic_marking_mode_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_prior_references_available_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_prior_references_available_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        direct_spatial_mv_pred_flag: u32,
        num_ref_idx_active_override_flag: u32,
        no_output_of_prior_pics_flag: u32,
        adaptive_ref_pic_marking_mode_flag: u32,
        no_prior_references_available_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let direct_spatial_mv_pred_flag: u32 =
                unsafe { ::std::mem::transmute(direct_spatial_mv_pred_flag) };
            direct_spatial_mv_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let num_ref_idx_active_override_flag: u32 =
                unsafe { ::std::mem::transmute(num_ref_idx_active_override_flag) };
            num_ref_idx_active_override_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let no_output_of_prior_pics_flag: u32 =
                unsafe { ::std::mem::transmute(no_output_of_prior_pics_flag) };
            no_output_of_prior_pics_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let adaptive_ref_pic_marking_mode_flag: u32 =
                unsafe { ::std::mem::transmute(adaptive_ref_pic_marking_mode_flag) };
            adaptive_ref_pic_marking_mode_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let no_prior_references_available_flag: u32 =
                unsafe { ::std::mem::transmute(no_prior_references_available_flag) };
            no_prior_references_available_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoEncodeH264PictureInfoFlags {
    #[inline]
    pub fn idr_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_idr_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_reference_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        idr_flag: u32,
        is_reference_flag: u32,
        used_for_long_term_reference: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let idr_flag: u32 = unsafe { ::std::mem::transmute(idr_flag) };
            idr_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_reference_flag: u32 = unsafe { ::std::mem::transmute(is_reference_flag) };
            is_reference_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoEncodeH264ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefMgmtFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoEncodeH264RefMgmtFlags {
    #[inline]
    pub fn ref_pic_list_modification_l0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_l0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ref_pic_list_modification_l1_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_l1_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_pic_list_modification_l0_flag: u32,
        ref_pic_list_modification_l1_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let ref_pic_list_modification_l0_flag: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_l0_flag) };
            ref_pic_list_modification_l0_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let ref_pic_list_modification_l1_flag: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_l1_flag) };
            ref_pic_list_modification_l1_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefListModEntry {
    pub modification_of_pic_nums_idc: StdVideoH264ModificationOfPicNumsIdc,
    pub abs_diff_pic_num_minus1: u16,
    pub long_term_pic_num: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefPicMarkingEntry {
    pub operation: StdVideoH264MemMgmtControlOp,
    pub difference_of_pic_nums_minus1: u16,
    pub long_term_pic_num: u16,
    pub long_term_frame_idx: u16,
    pub max_long_term_frame_idx_plus1: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264RefMemMgmtCtrlOperations {
    pub flags: StdVideoEncodeH264RefMgmtFlags,
    pub refList0ModOpCount: u8,
    pub pRefList0ModOperations: *const StdVideoEncodeH264RefListModEntry,
    pub refList1ModOpCount: u8,
    pub pRefList1ModOperations: *const StdVideoEncodeH264RefListModEntry,
    pub refPicMarkingOpCount: u8,
    pub pRefPicMarkingOperations: *const StdVideoEncodeH264RefPicMarkingEntry,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264PictureInfo {
    pub flags: StdVideoEncodeH264PictureInfoFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub pictureType: StdVideoH264PictureType,
    pub frame_num: u32,
    pub PicOrderCnt: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264ReferenceInfo {
    pub flags: StdVideoEncodeH264ReferenceInfoFlags,
    pub FrameNum: u32,
    pub PicOrderCnt: i32,
    pub long_term_pic_num: u16,
    pub long_term_frame_idx: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH264SliceHeader {
    pub flags: StdVideoEncodeH264SliceHeaderFlags,
    pub first_mb_in_slice: u32,
    pub slice_type: StdVideoH264SliceType,
    pub idr_pic_id: u16,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub cabac_init_idc: StdVideoH264CabacInitIdc,
    pub disable_deblocking_filter_idc: StdVideoH264DisableDeblockingFilterIdc,
    pub slice_alpha_c0_offset_div2: i8,
    pub slice_beta_offset_div2: i8,
    pub pWeightTable: *const StdVideoEncodeH264WeightTable,
}
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_DIRECT_8X8_INFERENCE_ENABLED_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 1 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_DIRECT_8X8_INFERENCE_DISABLED_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 2 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_SEPARATE_COLOUR_PLANE_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 4 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_QPPRIME_Y_ZERO_TRANSFORM_BYPASS_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 8 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_SCALING_LISTS_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 16 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_HRD_COMPLIANCE_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 32 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_CHROMA_QP_OFFSET_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 64 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_SECOND_CHROMA_QP_OFFSET_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 128 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_PIC_INIT_QP_MINUS26_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 256 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_PRED_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 512 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_BIPRED_EXPLICIT_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 1024 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_BIPRED_IMPLICIT_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 2048 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_WEIGHTED_PRED_NO_TABLE_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 4096 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_TRANSFORM_8X8_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 8192 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_CABAC_BIT_EXT:
    VkVideoEncodeH264CapabilityFlagBitsEXT = 16384;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_CAVLC_BIT_EXT:
    VkVideoEncodeH264CapabilityFlagBitsEXT = 32768;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_DISABLED_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 65536 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_ENABLED_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 131072 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_DEBLOCKING_FILTER_PARTIAL_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 262144 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_DISABLE_DIRECT_SPATIAL_MV_PRED_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 524288 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_MULTIPLE_SLICE_PER_FRAME_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 1048576 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_SLICE_MB_COUNT_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 2097152 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_ROW_UNALIGNED_SLICE_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 4194304 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 8388608 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 16777216 ;
pub const VK_VIDEO_ENCODE_H264_CAPABILITY_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH264CapabilityFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH264CapabilityFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH264CapabilityFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H264_INPUT_MODE_FRAME_BIT_EXT:
    VkVideoEncodeH264InputModeFlagBitsEXT = 1;
pub const VK_VIDEO_ENCODE_H264_INPUT_MODE_SLICE_BIT_EXT:
    VkVideoEncodeH264InputModeFlagBitsEXT = 2;
pub const VK_VIDEO_ENCODE_H264_INPUT_MODE_NON_VCL_BIT_EXT:
    VkVideoEncodeH264InputModeFlagBitsEXT = 4;
pub const VK_VIDEO_ENCODE_H264_INPUT_MODE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH264InputModeFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH264InputModeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH264InputModeFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H264_OUTPUT_MODE_FRAME_BIT_EXT:
    VkVideoEncodeH264OutputModeFlagBitsEXT = 1;
pub const VK_VIDEO_ENCODE_H264_OUTPUT_MODE_SLICE_BIT_EXT:
    VkVideoEncodeH264OutputModeFlagBitsEXT = 2;
pub const VK_VIDEO_ENCODE_H264_OUTPUT_MODE_NON_VCL_BIT_EXT : VkVideoEncodeH264OutputModeFlagBitsEXT = 4 ;
pub const VK_VIDEO_ENCODE_H264_OUTPUT_MODE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH264OutputModeFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH264OutputModeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH264OutputModeFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_UNKNOWN_EXT : VkVideoEncodeH264RateControlStructureFlagBitsEXT = 0 ;
pub const VK_VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_FLAT_BIT_EXT : VkVideoEncodeH264RateControlStructureFlagBitsEXT = 1 ;
pub const VK_VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_DYADIC_BIT_EXT : VkVideoEncodeH264RateControlStructureFlagBitsEXT = 2 ;
pub const VK_VIDEO_ENCODE_H264_RATE_CONTROL_STRUCTURE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH264RateControlStructureFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH264RateControlStructureFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH264RateControlStructureFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264CapabilitiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub flags: VkVideoEncodeH264CapabilityFlagsEXT,
    pub inputModeFlags: VkVideoEncodeH264InputModeFlagsEXT,
    pub outputModeFlags: VkVideoEncodeH264OutputModeFlagsEXT,
    pub maxPPictureL0ReferenceCount: u8,
    pub maxBPictureL0ReferenceCount: u8,
    pub maxL1ReferenceCount: u8,
    pub motionVectorsOverPicBoundariesFlag: VkBool32,
    pub maxBytesPerPicDenom: u32,
    pub maxBitsPerMbDenom: u32,
    pub log2MaxMvLengthHorizontal: u32,
    pub log2MaxMvLengthVertical: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264SessionParametersAddInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub spsStdCount: u32,
    pub pSpsStd: *const StdVideoH264SequenceParameterSet,
    pub ppsStdCount: u32,
    pub pPpsStd: *const StdVideoH264PictureParameterSet,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264SessionParametersCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxSpsStdCount: u32,
    pub maxPpsStdCount: u32,
    pub pParametersAddInfo: *const VkVideoEncodeH264SessionParametersAddInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264DpbSlotInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub slotIndex: i8,
    pub pStdReferenceInfo: *const StdVideoEncodeH264ReferenceInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264ReferenceListsEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub referenceList0EntryCount: u8,
    pub pReferenceList0Entries: *const VkVideoEncodeH264DpbSlotInfoEXT,
    pub referenceList1EntryCount: u8,
    pub pReferenceList1Entries: *const VkVideoEncodeH264DpbSlotInfoEXT,
    pub pMemMgmtCtrlOperations: *const StdVideoEncodeH264RefMemMgmtCtrlOperations,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264NaluSliceEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub mbCount: u32,
    pub pReferenceFinalLists: *const VkVideoEncodeH264ReferenceListsEXT,
    pub pSliceHeaderStd: *const StdVideoEncodeH264SliceHeader,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264VclFrameInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pReferenceFinalLists: *const VkVideoEncodeH264ReferenceListsEXT,
    pub naluSliceEntryCount: u32,
    pub pNaluSliceEntries: *const VkVideoEncodeH264NaluSliceEXT,
    pub pCurrentPictureInfo: *const StdVideoEncodeH264PictureInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264EmitPictureParametersEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub spsId: u8,
    pub emitSpsEnable: VkBool32,
    pub ppsIdEntryCount: u32,
    pub ppsIdEntries: *const u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264ProfileEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stdProfileIdc: StdVideoH264ProfileIdc,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264RateControlInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub gopFrameCount: u32,
    pub idrPeriod: u32,
    pub consecutiveBFrameCount: u32,
    pub rateControlStructure: VkVideoEncodeH264RateControlStructureFlagBitsEXT,
    pub temporalLayerCount: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264QpEXT {
    pub qpI: i32,
    pub qpP: i32,
    pub qpB: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264FrameSizeEXT {
    pub frameISize: u32,
    pub framePSize: u32,
    pub frameBSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH264RateControlLayerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub temporalLayerId: u8,
    pub useInitialRcQp: VkBool32,
    pub initialRcQp: VkVideoEncodeH264QpEXT,
    pub useMinQp: VkBool32,
    pub minQp: VkVideoEncodeH264QpEXT,
    pub useMaxQp: VkBool32,
    pub maxQp: VkVideoEncodeH264QpEXT,
    pub useMaxFrameSize: VkBool32,
    pub maxFrameSize: VkVideoEncodeH264FrameSizeEXT,
}
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_MONOCHROME:
    StdVideoH265ChromaFormatIdc = 0;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_420:
    StdVideoH265ChromaFormatIdc = 1;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_422:
    StdVideoH265ChromaFormatIdc = 2;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_444:
    StdVideoH265ChromaFormatIdc = 3;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_INVALID:
    StdVideoH265ChromaFormatIdc = 2147483647;
pub const StdVideoH265ChromaFormatIdc_STD_VIDEO_H265_CHROMA_FORMAT_IDC_MAX_ENUM:
    StdVideoH265ChromaFormatIdc = 2147483647;
pub type StdVideoH265ChromaFormatIdc = ::std::os::raw::c_uint;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN: StdVideoH265ProfileIdc = 1;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN_10: StdVideoH265ProfileIdc = 2;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAIN_STILL_PICTURE:
    StdVideoH265ProfileIdc = 3;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_FORMAT_RANGE_EXTENSIONS:
    StdVideoH265ProfileIdc = 4;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_SCC_EXTENSIONS: StdVideoH265ProfileIdc =
    9;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_INVALID: StdVideoH265ProfileIdc =
    2147483647;
pub const StdVideoH265ProfileIdc_STD_VIDEO_H265_PROFILE_IDC_MAX_ENUM: StdVideoH265ProfileIdc =
    2147483647;
pub type StdVideoH265ProfileIdc = ::std::os::raw::c_uint;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_1_0: StdVideoH265Level = 0;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_2_0: StdVideoH265Level = 1;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_2_1: StdVideoH265Level = 2;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_3_0: StdVideoH265Level = 3;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_3_1: StdVideoH265Level = 4;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_4_0: StdVideoH265Level = 5;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_4_1: StdVideoH265Level = 6;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_5_0: StdVideoH265Level = 7;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_5_1: StdVideoH265Level = 8;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_5_2: StdVideoH265Level = 9;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_6_0: StdVideoH265Level = 10;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_6_1: StdVideoH265Level = 11;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_6_2: StdVideoH265Level = 12;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_INVALID: StdVideoH265Level = 2147483647;
pub const StdVideoH265Level_STD_VIDEO_H265_LEVEL_MAX_ENUM: StdVideoH265Level = 2147483647;
pub type StdVideoH265Level = ::std::os::raw::c_uint;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_B: StdVideoH265SliceType = 0;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_P: StdVideoH265SliceType = 1;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_I: StdVideoH265SliceType = 2;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_INVALID: StdVideoH265SliceType =
    2147483647;
pub const StdVideoH265SliceType_STD_VIDEO_H265_SLICE_TYPE_MAX_ENUM: StdVideoH265SliceType =
    2147483647;
pub type StdVideoH265SliceType = ::std::os::raw::c_uint;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_P: StdVideoH265PictureType = 0;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_B: StdVideoH265PictureType = 1;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_I: StdVideoH265PictureType = 2;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_IDR: StdVideoH265PictureType = 3;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_INVALID: StdVideoH265PictureType =
    2147483647;
pub const StdVideoH265PictureType_STD_VIDEO_H265_PICTURE_TYPE_MAX_ENUM: StdVideoH265PictureType =
    2147483647;
pub type StdVideoH265PictureType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265DecPicBufMgr {
    pub max_latency_increase_plus1: [u32; 7usize],
    pub max_dec_pic_buffering_minus1: [u8; 7usize],
    pub max_num_reorder_pics: [u8; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SubLayerHrdParameters {
    pub bit_rate_value_minus1: [u32; 32usize],
    pub cpb_size_value_minus1: [u32; 32usize],
    pub cpb_size_du_value_minus1: [u32; 32usize],
    pub bit_rate_du_value_minus1: [u32; 32usize],
    pub cbr_flag: u32,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265HrdFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl StdVideoH265HrdFlags {
    #[inline]
    pub fn nal_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nal_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vcl_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vcl_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_pic_hrd_params_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sub_pic_hrd_params_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sub_pic_cpb_params_in_pic_timing_sei_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sub_pic_cpb_params_in_pic_timing_sei_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_pic_rate_general_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_pic_rate_general_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn fixed_pic_rate_within_cvs_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_fixed_pic_rate_within_cvs_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn low_delay_hrd_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_low_delay_hrd_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        nal_hrd_parameters_present_flag: u32,
        vcl_hrd_parameters_present_flag: u32,
        sub_pic_hrd_params_present_flag: u32,
        sub_pic_cpb_params_in_pic_timing_sei_flag: u32,
        fixed_pic_rate_general_flag: u32,
        fixed_pic_rate_within_cvs_flag: u32,
        low_delay_hrd_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let nal_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(nal_hrd_parameters_present_flag) };
            nal_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let vcl_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vcl_hrd_parameters_present_flag) };
            vcl_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let sub_pic_hrd_params_present_flag: u32 =
                unsafe { ::std::mem::transmute(sub_pic_hrd_params_present_flag) };
            sub_pic_hrd_params_present_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let sub_pic_cpb_params_in_pic_timing_sei_flag: u32 =
                unsafe { ::std::mem::transmute(sub_pic_cpb_params_in_pic_timing_sei_flag) };
            sub_pic_cpb_params_in_pic_timing_sei_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 8u8, {
            let fixed_pic_rate_general_flag: u32 =
                unsafe { ::std::mem::transmute(fixed_pic_rate_general_flag) };
            fixed_pic_rate_general_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 8u8, {
            let fixed_pic_rate_within_cvs_flag: u32 =
                unsafe { ::std::mem::transmute(fixed_pic_rate_within_cvs_flag) };
            fixed_pic_rate_within_cvs_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 8u8, {
            let low_delay_hrd_flag: u32 = unsafe { ::std::mem::transmute(low_delay_hrd_flag) };
            low_delay_hrd_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265HrdParameters {
    pub flags: StdVideoH265HrdFlags,
    pub tick_divisor_minus2: u8,
    pub du_cpb_removal_delay_increment_length_minus1: u8,
    pub dpb_output_delay_du_length_minus1: u8,
    pub bit_rate_scale: u8,
    pub cpb_size_scale: u8,
    pub cpb_size_du_scale: u8,
    pub initial_cpb_removal_delay_length_minus1: u8,
    pub au_cpb_removal_delay_length_minus1: u8,
    pub dpb_output_delay_length_minus1: u8,
    pub cpb_cnt_minus1: [u8; 7usize],
    pub elemental_duration_in_tc_minus1: [u16; 7usize],
    pub pSubLayerHrdParametersNal: [*const StdVideoH265SubLayerHrdParameters; 7usize],
    pub pSubLayerHrdParametersVcl: [*const StdVideoH265SubLayerHrdParameters; 7usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265VpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoH265VpsFlags {
    #[inline]
    pub fn vps_temporal_id_nesting_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_temporal_id_nesting_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_sub_layer_ordering_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_sub_layer_ordering_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_timing_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vps_poc_proportional_to_timing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vps_poc_proportional_to_timing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        vps_temporal_id_nesting_flag: u32,
        vps_sub_layer_ordering_info_present_flag: u32,
        vps_timing_info_present_flag: u32,
        vps_poc_proportional_to_timing_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let vps_temporal_id_nesting_flag: u32 =
                unsafe { ::std::mem::transmute(vps_temporal_id_nesting_flag) };
            vps_temporal_id_nesting_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let vps_sub_layer_ordering_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(vps_sub_layer_ordering_info_present_flag) };
            vps_sub_layer_ordering_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let vps_timing_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(vps_timing_info_present_flag) };
            vps_timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let vps_poc_proportional_to_timing_flag: u32 =
                unsafe { ::std::mem::transmute(vps_poc_proportional_to_timing_flag) };
            vps_poc_proportional_to_timing_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265VideoParameterSet {
    pub flags: StdVideoH265VpsFlags,
    pub vps_video_parameter_set_id: u8,
    pub vps_max_sub_layers_minus1: u8,
    pub vps_num_units_in_tick: u32,
    pub vps_time_scale: u32,
    pub vps_num_ticks_poc_diff_one_minus1: u32,
    pub pDecPicBufMgr: *const StdVideoH265DecPicBufMgr,
    pub pHrdParameters: *const StdVideoH265HrdParameters,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265ScalingLists {
    pub ScalingList4x4: [[u8; 16usize]; 6usize],
    pub ScalingList8x8: [[u8; 64usize]; 6usize],
    pub ScalingList16x16: [[u8; 64usize]; 6usize],
    pub ScalingList32x32: [[u8; 64usize]; 2usize],
    pub ScalingListDCCoef16x16: [u8; 6usize],
    pub ScalingListDCCoef32x32: [u8; 2usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SpsVuiFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
impl StdVideoH265SpsVuiFlags {
    #[inline]
    pub fn aspect_ratio_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_aspect_ratio_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn overscan_appropriate_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_overscan_appropriate_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_signal_type_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_signal_type_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn video_full_range_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_video_full_range_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn colour_description_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_colour_description_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_loc_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_loc_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn neutral_chroma_indication_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_neutral_chroma_indication_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn field_seq_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_seq_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn frame_field_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_frame_field_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn default_display_window_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_default_display_window_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_timing_info_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_timing_info_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_poc_proportional_to_timing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_poc_proportional_to_timing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_hrd_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_hrd_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bitstream_restriction_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bitstream_restriction_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_fixed_structure_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_fixed_structure_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn motion_vectors_over_pic_boundaries_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_motion_vectors_over_pic_boundaries_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn restricted_ref_pic_lists_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_restricted_ref_pic_lists_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        aspect_ratio_info_present_flag: u32,
        overscan_info_present_flag: u32,
        overscan_appropriate_flag: u32,
        video_signal_type_present_flag: u32,
        video_full_range_flag: u32,
        colour_description_present_flag: u32,
        chroma_loc_info_present_flag: u32,
        neutral_chroma_indication_flag: u32,
        field_seq_flag: u32,
        frame_field_info_present_flag: u32,
        default_display_window_flag: u32,
        vui_timing_info_present_flag: u32,
        vui_poc_proportional_to_timing_flag: u32,
        vui_hrd_parameters_present_flag: u32,
        bitstream_restriction_flag: u32,
        tiles_fixed_structure_flag: u32,
        motion_vectors_over_pic_boundaries_flag: u32,
        restricted_ref_pic_lists_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let aspect_ratio_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(aspect_ratio_info_present_flag) };
            aspect_ratio_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let overscan_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_info_present_flag) };
            overscan_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let overscan_appropriate_flag: u32 =
                unsafe { ::std::mem::transmute(overscan_appropriate_flag) };
            overscan_appropriate_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let video_signal_type_present_flag: u32 =
                unsafe { ::std::mem::transmute(video_signal_type_present_flag) };
            video_signal_type_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let video_full_range_flag: u32 =
                unsafe { ::std::mem::transmute(video_full_range_flag) };
            video_full_range_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let colour_description_present_flag: u32 =
                unsafe { ::std::mem::transmute(colour_description_present_flag) };
            colour_description_present_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let chroma_loc_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(chroma_loc_info_present_flag) };
            chroma_loc_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let neutral_chroma_indication_flag: u32 =
                unsafe { ::std::mem::transmute(neutral_chroma_indication_flag) };
            neutral_chroma_indication_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let field_seq_flag: u32 = unsafe { ::std::mem::transmute(field_seq_flag) };
            field_seq_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let frame_field_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(frame_field_info_present_flag) };
            frame_field_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let default_display_window_flag: u32 =
                unsafe { ::std::mem::transmute(default_display_window_flag) };
            default_display_window_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vui_timing_info_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_timing_info_present_flag) };
            vui_timing_info_present_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let vui_poc_proportional_to_timing_flag: u32 =
                unsafe { ::std::mem::transmute(vui_poc_proportional_to_timing_flag) };
            vui_poc_proportional_to_timing_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let vui_hrd_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_hrd_parameters_present_flag) };
            vui_hrd_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let bitstream_restriction_flag: u32 =
                unsafe { ::std::mem::transmute(bitstream_restriction_flag) };
            bitstream_restriction_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let tiles_fixed_structure_flag: u32 =
                unsafe { ::std::mem::transmute(tiles_fixed_structure_flag) };
            tiles_fixed_structure_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let motion_vectors_over_pic_boundaries_flag: u32 =
                unsafe { ::std::mem::transmute(motion_vectors_over_pic_boundaries_flag) };
            motion_vectors_over_pic_boundaries_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let restricted_ref_pic_lists_flag: u32 =
                unsafe { ::std::mem::transmute(restricted_ref_pic_lists_flag) };
            restricted_ref_pic_lists_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SequenceParameterSetVui {
    pub flags: StdVideoH265SpsVuiFlags,
    pub aspect_ratio_idc: u8,
    pub sar_width: u16,
    pub sar_height: u16,
    pub video_format: u8,
    pub colour_primaries: u8,
    pub transfer_characteristics: u8,
    pub matrix_coeffs: u8,
    pub chroma_sample_loc_type_top_field: u8,
    pub chroma_sample_loc_type_bottom_field: u8,
    pub def_disp_win_left_offset: u16,
    pub def_disp_win_right_offset: u16,
    pub def_disp_win_top_offset: u16,
    pub def_disp_win_bottom_offset: u16,
    pub vui_num_units_in_tick: u32,
    pub vui_time_scale: u32,
    pub vui_num_ticks_poc_diff_one_minus1: u32,
    pub pHrdParameters: *const StdVideoH265HrdParameters,
    pub min_spatial_segmentation_idc: u16,
    pub max_bytes_per_pic_denom: u8,
    pub max_bits_per_min_cu_denom: u8,
    pub log2_max_mv_length_horizontal: u8,
    pub log2_max_mv_length_vertical: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PredictorPaletteEntries {
    pub PredictorPaletteEntries: [[u16; 128usize]; 3usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl StdVideoH265SpsFlags {
    #[inline]
    pub fn sps_temporal_id_nesting_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_id_nesting_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn separate_colour_plane_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_separate_colour_plane_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn scaling_list_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_scaling_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_scaling_list_data_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_scaling_list_data_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn amp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_amp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sample_adaptive_offset_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sample_adaptive_offset_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pcm_loop_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pcm_loop_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn long_term_ref_pics_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_long_term_ref_pics_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_temporal_mvp_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_temporal_mvp_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn strong_intra_smoothing_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_strong_intra_smoothing_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn vui_parameters_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_vui_parameters_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_extension_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_range_extension_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_range_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_rotation_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_rotation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_context_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_context_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn implicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_implicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn explicit_rdpcm_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_explicit_rdpcm_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn extended_precision_processing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_extended_precision_processing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_smoothing_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_smoothing_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn high_precision_offsets_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_high_precision_offsets_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn persistent_rice_adaptation_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_persistent_rice_adaptation_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_bypass_alignment_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_bypass_alignment_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_scc_extension_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_scc_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_curr_pic_ref_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_curr_pic_ref_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn palette_mode_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_palette_mode_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sps_palette_predictor_initializer_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sps_palette_predictor_initializer_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn intra_boundary_filtering_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_intra_boundary_filtering_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        sps_temporal_id_nesting_flag: u32,
        separate_colour_plane_flag: u32,
        scaling_list_enabled_flag: u32,
        sps_scaling_list_data_present_flag: u32,
        amp_enabled_flag: u32,
        sample_adaptive_offset_enabled_flag: u32,
        pcm_enabled_flag: u32,
        pcm_loop_filter_disabled_flag: u32,
        long_term_ref_pics_present_flag: u32,
        sps_temporal_mvp_enabled_flag: u32,
        strong_intra_smoothing_enabled_flag: u32,
        vui_parameters_present_flag: u32,
        sps_extension_present_flag: u32,
        sps_range_extension_flag: u32,
        transform_skip_rotation_enabled_flag: u32,
        transform_skip_context_enabled_flag: u32,
        implicit_rdpcm_enabled_flag: u32,
        explicit_rdpcm_enabled_flag: u32,
        extended_precision_processing_flag: u32,
        intra_smoothing_disabled_flag: u32,
        high_precision_offsets_enabled_flag: u32,
        persistent_rice_adaptation_enabled_flag: u32,
        cabac_bypass_alignment_enabled_flag: u32,
        sps_scc_extension_flag: u32,
        sps_curr_pic_ref_enabled_flag: u32,
        palette_mode_enabled_flag: u32,
        sps_palette_predictor_initializer_present_flag: u32,
        intra_boundary_filtering_disabled_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let sps_temporal_id_nesting_flag: u32 =
                unsafe { ::std::mem::transmute(sps_temporal_id_nesting_flag) };
            sps_temporal_id_nesting_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let separate_colour_plane_flag: u32 =
                unsafe { ::std::mem::transmute(separate_colour_plane_flag) };
            separate_colour_plane_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let scaling_list_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(scaling_list_enabled_flag) };
            scaling_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let sps_scaling_list_data_present_flag: u32 =
                unsafe { ::std::mem::transmute(sps_scaling_list_data_present_flag) };
            sps_scaling_list_data_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let amp_enabled_flag: u32 = unsafe { ::std::mem::transmute(amp_enabled_flag) };
            amp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let sample_adaptive_offset_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sample_adaptive_offset_enabled_flag) };
            sample_adaptive_offset_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let pcm_enabled_flag: u32 = unsafe { ::std::mem::transmute(pcm_enabled_flag) };
            pcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let pcm_loop_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(pcm_loop_filter_disabled_flag) };
            pcm_loop_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let long_term_ref_pics_present_flag: u32 =
                unsafe { ::std::mem::transmute(long_term_ref_pics_present_flag) };
            long_term_ref_pics_present_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let sps_temporal_mvp_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sps_temporal_mvp_enabled_flag) };
            sps_temporal_mvp_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let strong_intra_smoothing_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(strong_intra_smoothing_enabled_flag) };
            strong_intra_smoothing_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let vui_parameters_present_flag: u32 =
                unsafe { ::std::mem::transmute(vui_parameters_present_flag) };
            vui_parameters_present_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let sps_extension_present_flag: u32 =
                unsafe { ::std::mem::transmute(sps_extension_present_flag) };
            sps_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let sps_range_extension_flag: u32 =
                unsafe { ::std::mem::transmute(sps_range_extension_flag) };
            sps_range_extension_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let transform_skip_rotation_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_rotation_enabled_flag) };
            transform_skip_rotation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let transform_skip_context_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_context_enabled_flag) };
            transform_skip_context_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let implicit_rdpcm_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(implicit_rdpcm_enabled_flag) };
            implicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let explicit_rdpcm_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(explicit_rdpcm_enabled_flag) };
            explicit_rdpcm_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let extended_precision_processing_flag: u32 =
                unsafe { ::std::mem::transmute(extended_precision_processing_flag) };
            extended_precision_processing_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let intra_smoothing_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(intra_smoothing_disabled_flag) };
            intra_smoothing_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let high_precision_offsets_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(high_precision_offsets_enabled_flag) };
            high_precision_offsets_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let persistent_rice_adaptation_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(persistent_rice_adaptation_enabled_flag) };
            persistent_rice_adaptation_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let cabac_bypass_alignment_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cabac_bypass_alignment_enabled_flag) };
            cabac_bypass_alignment_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let sps_scc_extension_flag: u32 =
                unsafe { ::std::mem::transmute(sps_scc_extension_flag) };
            sps_scc_extension_flag as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let sps_curr_pic_ref_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sps_curr_pic_ref_enabled_flag) };
            sps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let palette_mode_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(palette_mode_enabled_flag) };
            palette_mode_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let sps_palette_predictor_initializer_present_flag: u32 =
                unsafe { ::std::mem::transmute(sps_palette_predictor_initializer_present_flag) };
            sps_palette_predictor_initializer_present_flag as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let intra_boundary_filtering_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(intra_boundary_filtering_disabled_flag) };
            intra_boundary_filtering_disabled_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265SequenceParameterSet {
    pub flags: StdVideoH265SpsFlags,
    pub profile_idc: StdVideoH265ProfileIdc,
    pub level_idc: StdVideoH265Level,
    pub pic_width_in_luma_samples: u32,
    pub pic_height_in_luma_samples: u32,
    pub sps_video_parameter_set_id: u8,
    pub sps_max_sub_layers_minus1: u8,
    pub sps_seq_parameter_set_id: u8,
    pub chroma_format_idc: u8,
    pub bit_depth_luma_minus8: u8,
    pub bit_depth_chroma_minus8: u8,
    pub log2_max_pic_order_cnt_lsb_minus4: u8,
    pub log2_min_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_luma_coding_block_size: u8,
    pub log2_min_luma_transform_block_size_minus2: u8,
    pub log2_diff_max_min_luma_transform_block_size: u8,
    pub max_transform_hierarchy_depth_inter: u8,
    pub max_transform_hierarchy_depth_intra: u8,
    pub num_short_term_ref_pic_sets: u8,
    pub num_long_term_ref_pics_sps: u8,
    pub pcm_sample_bit_depth_luma_minus1: u8,
    pub pcm_sample_bit_depth_chroma_minus1: u8,
    pub log2_min_pcm_luma_coding_block_size_minus3: u8,
    pub log2_diff_max_min_pcm_luma_coding_block_size: u8,
    pub conf_win_left_offset: u32,
    pub conf_win_right_offset: u32,
    pub conf_win_top_offset: u32,
    pub conf_win_bottom_offset: u32,
    pub pDecPicBufMgr: *const StdVideoH265DecPicBufMgr,
    pub pScalingLists: *const StdVideoH265ScalingLists,
    pub pSequenceParameterSetVui: *const StdVideoH265SequenceParameterSetVui,
    pub palette_max_size: u8,
    pub delta_palette_max_predictor_size: u8,
    pub motion_vector_resolution_control_idc: u8,
    pub sps_num_palette_predictor_initializer_minus1: u8,
    pub pPredictorPaletteEntries: *const StdVideoH265PredictorPaletteEntries,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PpsFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl StdVideoH265PpsFlags {
    #[inline]
    pub fn dependent_slice_segments_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segments_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn output_flag_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_output_flag_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn sign_data_hiding_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_sign_data_hiding_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn constrained_intra_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_constrained_intra_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transform_skip_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transform_skip_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cu_qp_delta_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cu_qp_delta_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_chroma_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_chroma_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_pred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_pred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn weighted_bipred_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_weighted_bipred_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn transquant_bypass_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_transquant_bypass_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn entropy_coding_sync_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_entropy_coding_sync_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn uniform_spacing_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_uniform_spacing_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn loop_filter_across_tiles_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_loop_filter_across_tiles_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_control_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_control_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn deblocking_filter_override_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_deblocking_filter_override_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_deblocking_filter_disabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_deblocking_filter_disabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_scaling_list_data_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_scaling_list_data_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn lists_modification_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(20usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_lists_modification_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(20usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_segment_header_extension_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(21usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_segment_header_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(21usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_extension_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(22usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_extension_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(22usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cross_component_prediction_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(23usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cross_component_prediction_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(23usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn chroma_qp_offset_list_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_chroma_qp_offset_list_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_curr_pic_ref_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(25usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_curr_pic_ref_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(25usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn residual_adaptive_colour_transform_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(26usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_residual_adaptive_colour_transform_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(26usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_slice_act_qp_offsets_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(27usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_slice_act_qp_offsets_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(27usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_palette_predictor_initializer_present_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(28usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_palette_predictor_initializer_present_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(28usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn monochrome_palette_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(29usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_monochrome_palette_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(29usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pps_range_extension_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(30usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pps_range_extension_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(30usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        dependent_slice_segments_enabled_flag: u32,
        output_flag_present_flag: u32,
        sign_data_hiding_enabled_flag: u32,
        cabac_init_present_flag: u32,
        constrained_intra_pred_flag: u32,
        transform_skip_enabled_flag: u32,
        cu_qp_delta_enabled_flag: u32,
        pps_slice_chroma_qp_offsets_present_flag: u32,
        weighted_pred_flag: u32,
        weighted_bipred_flag: u32,
        transquant_bypass_enabled_flag: u32,
        tiles_enabled_flag: u32,
        entropy_coding_sync_enabled_flag: u32,
        uniform_spacing_flag: u32,
        loop_filter_across_tiles_enabled_flag: u32,
        pps_loop_filter_across_slices_enabled_flag: u32,
        deblocking_filter_control_present_flag: u32,
        deblocking_filter_override_enabled_flag: u32,
        pps_deblocking_filter_disabled_flag: u32,
        pps_scaling_list_data_present_flag: u32,
        lists_modification_present_flag: u32,
        slice_segment_header_extension_present_flag: u32,
        pps_extension_present_flag: u32,
        cross_component_prediction_enabled_flag: u32,
        chroma_qp_offset_list_enabled_flag: u32,
        pps_curr_pic_ref_enabled_flag: u32,
        residual_adaptive_colour_transform_enabled_flag: u32,
        pps_slice_act_qp_offsets_present_flag: u32,
        pps_palette_predictor_initializer_present_flag: u32,
        monochrome_palette_flag: u32,
        pps_range_extension_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let dependent_slice_segments_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segments_enabled_flag) };
            dependent_slice_segments_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let output_flag_present_flag: u32 =
                unsafe { ::std::mem::transmute(output_flag_present_flag) };
            output_flag_present_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let sign_data_hiding_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(sign_data_hiding_enabled_flag) };
            sign_data_hiding_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let cabac_init_present_flag: u32 =
                unsafe { ::std::mem::transmute(cabac_init_present_flag) };
            cabac_init_present_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let constrained_intra_pred_flag: u32 =
                unsafe { ::std::mem::transmute(constrained_intra_pred_flag) };
            constrained_intra_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let transform_skip_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transform_skip_enabled_flag) };
            transform_skip_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let cu_qp_delta_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cu_qp_delta_enabled_flag) };
            cu_qp_delta_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let pps_slice_chroma_qp_offsets_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_slice_chroma_qp_offsets_present_flag) };
            pps_slice_chroma_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let weighted_pred_flag: u32 = unsafe { ::std::mem::transmute(weighted_pred_flag) };
            weighted_pred_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let weighted_bipred_flag: u32 = unsafe { ::std::mem::transmute(weighted_bipred_flag) };
            weighted_bipred_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let transquant_bypass_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(transquant_bypass_enabled_flag) };
            transquant_bypass_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let tiles_enabled_flag: u32 = unsafe { ::std::mem::transmute(tiles_enabled_flag) };
            tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let entropy_coding_sync_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(entropy_coding_sync_enabled_flag) };
            entropy_coding_sync_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let uniform_spacing_flag: u32 = unsafe { ::std::mem::transmute(uniform_spacing_flag) };
            uniform_spacing_flag as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let loop_filter_across_tiles_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(loop_filter_across_tiles_enabled_flag) };
            loop_filter_across_tiles_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let pps_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_loop_filter_across_slices_enabled_flag) };
            pps_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let deblocking_filter_control_present_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_control_present_flag) };
            deblocking_filter_control_present_flag as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let deblocking_filter_override_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(deblocking_filter_override_enabled_flag) };
            deblocking_filter_override_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let pps_deblocking_filter_disabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_deblocking_filter_disabled_flag) };
            pps_deblocking_filter_disabled_flag as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let pps_scaling_list_data_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_scaling_list_data_present_flag) };
            pps_scaling_list_data_present_flag as u64
        });
        __bindgen_bitfield_unit.set(20usize, 1u8, {
            let lists_modification_present_flag: u32 =
                unsafe { ::std::mem::transmute(lists_modification_present_flag) };
            lists_modification_present_flag as u64
        });
        __bindgen_bitfield_unit.set(21usize, 1u8, {
            let slice_segment_header_extension_present_flag: u32 =
                unsafe { ::std::mem::transmute(slice_segment_header_extension_present_flag) };
            slice_segment_header_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(22usize, 1u8, {
            let pps_extension_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_extension_present_flag) };
            pps_extension_present_flag as u64
        });
        __bindgen_bitfield_unit.set(23usize, 1u8, {
            let cross_component_prediction_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(cross_component_prediction_enabled_flag) };
            cross_component_prediction_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(24usize, 1u8, {
            let chroma_qp_offset_list_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(chroma_qp_offset_list_enabled_flag) };
            chroma_qp_offset_list_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(25usize, 1u8, {
            let pps_curr_pic_ref_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(pps_curr_pic_ref_enabled_flag) };
            pps_curr_pic_ref_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(26usize, 1u8, {
            let residual_adaptive_colour_transform_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(residual_adaptive_colour_transform_enabled_flag) };
            residual_adaptive_colour_transform_enabled_flag as u64
        });
        __bindgen_bitfield_unit.set(27usize, 1u8, {
            let pps_slice_act_qp_offsets_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_slice_act_qp_offsets_present_flag) };
            pps_slice_act_qp_offsets_present_flag as u64
        });
        __bindgen_bitfield_unit.set(28usize, 1u8, {
            let pps_palette_predictor_initializer_present_flag: u32 =
                unsafe { ::std::mem::transmute(pps_palette_predictor_initializer_present_flag) };
            pps_palette_predictor_initializer_present_flag as u64
        });
        __bindgen_bitfield_unit.set(29usize, 1u8, {
            let monochrome_palette_flag: u32 =
                unsafe { ::std::mem::transmute(monochrome_palette_flag) };
            monochrome_palette_flag as u64
        });
        __bindgen_bitfield_unit.set(30usize, 1u8, {
            let pps_range_extension_flag: u32 =
                unsafe { ::std::mem::transmute(pps_range_extension_flag) };
            pps_range_extension_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoH265PictureParameterSet {
    pub flags: StdVideoH265PpsFlags,
    pub pps_pic_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub num_extra_slice_header_bits: u8,
    pub num_ref_idx_l0_default_active_minus1: u8,
    pub num_ref_idx_l1_default_active_minus1: u8,
    pub init_qp_minus26: i8,
    pub diff_cu_qp_delta_depth: u8,
    pub pps_cb_qp_offset: i8,
    pub pps_cr_qp_offset: i8,
    pub num_tile_columns_minus1: u8,
    pub num_tile_rows_minus1: u8,
    pub column_width_minus1: [u16; 19usize],
    pub row_height_minus1: [u16; 21usize],
    pub pps_beta_offset_div2: i8,
    pub pps_tc_offset_div2: i8,
    pub log2_parallel_merge_level_minus2: u8,
    pub pScalingLists: *const StdVideoH265ScalingLists,
    pub log2_max_transform_skip_block_size_minus2: u8,
    pub diff_cu_chroma_qp_offset_depth: u8,
    pub chroma_qp_offset_list_len_minus1: u8,
    pub cb_qp_offset_list: [i8; 6usize],
    pub cr_qp_offset_list: [i8; 6usize],
    pub log2_sao_offset_scale_luma: u8,
    pub log2_sao_offset_scale_chroma: u8,
    pub pps_act_y_qp_offset_plus5: i8,
    pub pps_act_cb_qp_offset_plus5: i8,
    pub pps_act_cr_qp_offset_plus5: i8,
    pub pps_num_palette_predictor_initializer: u8,
    pub luma_bit_depth_entry_minus8: u8,
    pub chroma_bit_depth_entry_minus8: u8,
    pub pPredictorPaletteEntries: *const StdVideoH265PredictorPaletteEntries,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265WeightTableFlags {
    pub luma_weight_l0_flag: u16,
    pub chroma_weight_l0_flag: u16,
    pub luma_weight_l1_flag: u16,
    pub chroma_weight_l1_flag: u16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265WeightTable {
    pub flags: StdVideoEncodeH265WeightTableFlags,
    pub luma_log2_weight_denom: u8,
    pub delta_chroma_log2_weight_denom: i8,
    pub delta_luma_weight_l0: [i8; 15usize],
    pub luma_offset_l0: [i8; 15usize],
    pub delta_chroma_weight_l0: [[i8; 2usize]; 15usize],
    pub delta_chroma_offset_l0: [[i8; 2usize]; 15usize],
    pub delta_luma_weight_l1: [i8; 15usize],
    pub luma_offset_l1: [i8; 15usize],
    pub delta_chroma_weight_l1: [[i8; 2usize]; 15usize],
    pub delta_chroma_offset_l1: [[i8; 2usize]; 15usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265SliceSegmentHeaderFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
impl StdVideoEncodeH265SliceSegmentHeaderFlags {
    #[inline]
    pub fn first_slice_segment_in_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_first_slice_segment_in_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn no_output_of_prior_pics_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_no_output_of_prior_pics_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dependent_slice_segment_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_dependent_slice_segment_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn pic_output_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pic_output_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn short_term_ref_pic_set_sps_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_short_term_ref_pic_set_sps_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_temporal_mvp_enable_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_temporal_mvp_enable_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_luma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_luma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_sao_chroma_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_sao_chroma_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn num_ref_idx_active_override_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_num_ref_idx_active_override_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn mvd_l1_zero_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_mvd_l1_zero_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cabac_init_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cabac_init_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_deblocking_filter_disable_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_deblocking_filter_disable_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn collocated_from_l0_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_collocated_from_l0_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn slice_loop_filter_across_slices_enabled_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_slice_loop_filter_across_slices_enabled_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        first_slice_segment_in_pic_flag: u32,
        no_output_of_prior_pics_flag: u32,
        dependent_slice_segment_flag: u32,
        pic_output_flag: u32,
        short_term_ref_pic_set_sps_flag: u32,
        slice_temporal_mvp_enable_flag: u32,
        slice_sao_luma_flag: u32,
        slice_sao_chroma_flag: u32,
        num_ref_idx_active_override_flag: u32,
        mvd_l1_zero_flag: u32,
        cabac_init_flag: u32,
        slice_deblocking_filter_disable_flag: u32,
        collocated_from_l0_flag: u32,
        slice_loop_filter_across_slices_enabled_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let first_slice_segment_in_pic_flag: u32 =
                unsafe { ::std::mem::transmute(first_slice_segment_in_pic_flag) };
            first_slice_segment_in_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let no_output_of_prior_pics_flag: u32 =
                unsafe { ::std::mem::transmute(no_output_of_prior_pics_flag) };
            no_output_of_prior_pics_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let dependent_slice_segment_flag: u32 =
                unsafe { ::std::mem::transmute(dependent_slice_segment_flag) };
            dependent_slice_segment_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let pic_output_flag: u32 = unsafe { ::std::mem::transmute(pic_output_flag) };
            pic_output_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let short_term_ref_pic_set_sps_flag: u32 =
                unsafe { ::std::mem::transmute(short_term_ref_pic_set_sps_flag) };
            short_term_ref_pic_set_sps_flag as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let slice_temporal_mvp_enable_flag: u32 =
                unsafe { ::std::mem::transmute(slice_temporal_mvp_enable_flag) };
            slice_temporal_mvp_enable_flag as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let slice_sao_luma_flag: u32 = unsafe { ::std::mem::transmute(slice_sao_luma_flag) };
            slice_sao_luma_flag as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let slice_sao_chroma_flag: u32 =
                unsafe { ::std::mem::transmute(slice_sao_chroma_flag) };
            slice_sao_chroma_flag as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let num_ref_idx_active_override_flag: u32 =
                unsafe { ::std::mem::transmute(num_ref_idx_active_override_flag) };
            num_ref_idx_active_override_flag as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let mvd_l1_zero_flag: u32 = unsafe { ::std::mem::transmute(mvd_l1_zero_flag) };
            mvd_l1_zero_flag as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let cabac_init_flag: u32 = unsafe { ::std::mem::transmute(cabac_init_flag) };
            cabac_init_flag as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let slice_deblocking_filter_disable_flag: u32 =
                unsafe { ::std::mem::transmute(slice_deblocking_filter_disable_flag) };
            slice_deblocking_filter_disable_flag as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let collocated_from_l0_flag: u32 =
                unsafe { ::std::mem::transmute(collocated_from_l0_flag) };
            collocated_from_l0_flag as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let slice_loop_filter_across_slices_enabled_flag: u32 =
                unsafe { ::std::mem::transmute(slice_loop_filter_across_slices_enabled_flag) };
            slice_loop_filter_across_slices_enabled_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265SliceSegmentHeader {
    pub flags: StdVideoEncodeH265SliceSegmentHeaderFlags,
    pub slice_type: StdVideoH265SliceType,
    pub num_short_term_ref_pic_sets: u8,
    pub slice_segment_address: u32,
    pub short_term_ref_pic_set_idx: u8,
    pub num_long_term_sps: u8,
    pub num_long_term_pics: u8,
    pub collocated_ref_idx: u8,
    pub num_ref_idx_l0_active_minus1: u8,
    pub num_ref_idx_l1_active_minus1: u8,
    pub MaxNumMergeCand: u8,
    pub slice_cb_qp_offset: i8,
    pub slice_cr_qp_offset: i8,
    pub slice_beta_offset_div2: i8,
    pub slice_tc_offset_div2: i8,
    pub slice_act_y_qp_offset: i8,
    pub slice_act_cb_qp_offset: i8,
    pub slice_act_cr_qp_offset: i8,
    pub pWeightTable: *const StdVideoEncodeH265WeightTable,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceModificationFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoEncodeH265ReferenceModificationFlags {
    #[inline]
    pub fn ref_pic_list_modification_flag_l0(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l0(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn ref_pic_list_modification_flag_l1(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_ref_pic_list_modification_flag_l1(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ref_pic_list_modification_flag_l0: u32,
        ref_pic_list_modification_flag_l1: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let ref_pic_list_modification_flag_l0: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_flag_l0) };
            ref_pic_list_modification_flag_l0 as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let ref_pic_list_modification_flag_l1: u32 =
                unsafe { ::std::mem::transmute(ref_pic_list_modification_flag_l1) };
            ref_pic_list_modification_flag_l1 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceModifications {
    pub flags: StdVideoEncodeH265ReferenceModificationFlags,
    pub referenceList0ModificationsCount: u8,
    pub pReferenceList0Modifications: *const u8,
    pub referenceList1ModificationsCount: u8,
    pub pReferenceList1Modifications: *const u8,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoEncodeH265PictureInfoFlags {
    #[inline]
    pub fn is_reference_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IrapPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IrapPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn long_term_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_long_term_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn discardable_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_discardable_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cross_layer_bla_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cross_layer_bla_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_reference_flag: u32,
        IrapPicFlag: u32,
        long_term_flag: u32,
        discardable_flag: u32,
        cross_layer_bla_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_reference_flag: u32 = unsafe { ::std::mem::transmute(is_reference_flag) };
            is_reference_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let IrapPicFlag: u32 = unsafe { ::std::mem::transmute(IrapPicFlag) };
            IrapPicFlag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let long_term_flag: u32 = unsafe { ::std::mem::transmute(long_term_flag) };
            long_term_flag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let discardable_flag: u32 = unsafe { ::std::mem::transmute(discardable_flag) };
            discardable_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let cross_layer_bla_flag: u32 = unsafe { ::std::mem::transmute(cross_layer_bla_flag) };
            cross_layer_bla_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265PictureInfo {
    pub flags: StdVideoEncodeH265PictureInfoFlags,
    pub PictureType: StdVideoH265PictureType,
    pub sps_video_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub pps_pic_parameter_set_id: u8,
    pub PicOrderCntVal: i32,
    pub TemporalId: u8,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoEncodeH265ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused_for_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unused_for_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
        unused_for_reference: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let unused_for_reference: u32 = unsafe { ::std::mem::transmute(unused_for_reference) };
            unused_for_reference as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoEncodeH265ReferenceInfo {
    pub flags: StdVideoEncodeH265ReferenceInfoFlags,
    pub PicOrderCntVal: i32,
    pub TemporalId: u8,
}
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_SEPARATE_COLOUR_PLANE_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 1 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_SCALING_LISTS_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 2 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_SAMPLE_ADAPTIVE_OFFSET_ENABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 4 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_PCM_ENABLE_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 8 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_SPS_TEMPORAL_MVP_ENABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 16 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_HRD_COMPLIANCE_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 32 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_INIT_QP_MINUS26_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 64 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_LOG2_PARALLEL_MERGE_LEVEL_MINUS2_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 128 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_SIGN_DATA_HIDING_ENABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 256 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_TRANSFORM_SKIP_ENABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 512 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_TRANSFORM_SKIP_DISABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 1024 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_PPS_SLICE_CHROMA_QP_OFFSETS_PRESENT_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 2048 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_PRED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 4096 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_BIPRED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 8192 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_WEIGHTED_PRED_NO_TABLE_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 16384 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_TRANSQUANT_BYPASS_ENABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 32768 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_ENTROPY_CODING_SYNC_ENABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 65536 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_DEBLOCKING_FILTER_OVERRIDE_ENABLED_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 131072 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILE_PER_FRAME_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 262144 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_SLICE_PER_TILE_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 524288 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_MULTIPLE_TILE_PER_SLICE_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 1048576 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_SLICE_SEGMENT_CTB_COUNT_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 2097152 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_ROW_UNALIGNED_SLICE_SEGMENT_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 4194304 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_DEPENDENT_SLICE_SEGMENT_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 8388608 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_DIFFERENT_SLICE_TYPE_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 16777216 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_B_FRAME_IN_L1_LIST_BIT_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 33554432 ;
pub const VK_VIDEO_ENCODE_H265_CAPABILITY_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH265CapabilityFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH265CapabilityFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH265CapabilityFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H265_INPUT_MODE_FRAME_BIT_EXT:
    VkVideoEncodeH265InputModeFlagBitsEXT = 1;
pub const VK_VIDEO_ENCODE_H265_INPUT_MODE_SLICE_SEGMENT_BIT_EXT : VkVideoEncodeH265InputModeFlagBitsEXT = 2 ;
pub const VK_VIDEO_ENCODE_H265_INPUT_MODE_NON_VCL_BIT_EXT:
    VkVideoEncodeH265InputModeFlagBitsEXT = 4;
pub const VK_VIDEO_ENCODE_H265_INPUT_MODE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH265InputModeFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH265InputModeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH265InputModeFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H265_OUTPUT_MODE_FRAME_BIT_EXT:
    VkVideoEncodeH265OutputModeFlagBitsEXT = 1;
pub const VK_VIDEO_ENCODE_H265_OUTPUT_MODE_SLICE_SEGMENT_BIT_EXT : VkVideoEncodeH265OutputModeFlagBitsEXT = 2 ;
pub const VK_VIDEO_ENCODE_H265_OUTPUT_MODE_NON_VCL_BIT_EXT : VkVideoEncodeH265OutputModeFlagBitsEXT = 4 ;
pub const VK_VIDEO_ENCODE_H265_OUTPUT_MODE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH265OutputModeFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH265OutputModeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH265OutputModeFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H265_CTB_SIZE_16_BIT_EXT:
    VkVideoEncodeH265CtbSizeFlagBitsEXT = 1;
pub const VK_VIDEO_ENCODE_H265_CTB_SIZE_32_BIT_EXT:
    VkVideoEncodeH265CtbSizeFlagBitsEXT = 2;
pub const VK_VIDEO_ENCODE_H265_CTB_SIZE_64_BIT_EXT:
    VkVideoEncodeH265CtbSizeFlagBitsEXT = 4;
pub const VK_VIDEO_ENCODE_H265_CTB_SIZE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH265CtbSizeFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH265CtbSizeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH265CtbSizeFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_4_BIT_EXT : VkVideoEncodeH265TransformBlockSizeFlagBitsEXT = 1 ;
pub const VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_8_BIT_EXT : VkVideoEncodeH265TransformBlockSizeFlagBitsEXT = 2 ;
pub const VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_16_BIT_EXT : VkVideoEncodeH265TransformBlockSizeFlagBitsEXT = 4 ;
pub const VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_32_BIT_EXT : VkVideoEncodeH265TransformBlockSizeFlagBitsEXT = 8 ;
pub const VK_VIDEO_ENCODE_H265_TRANSFORM_BLOCK_SIZE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH265TransformBlockSizeFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH265TransformBlockSizeFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH265TransformBlockSizeFlagsEXT = VkFlags;
pub const VK_VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_UNKNOWN_EXT : VkVideoEncodeH265RateControlStructureFlagBitsEXT = 0 ;
pub const VK_VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_FLAT_BIT_EXT : VkVideoEncodeH265RateControlStructureFlagBitsEXT = 1 ;
pub const VK_VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_DYADIC_BIT_EXT : VkVideoEncodeH265RateControlStructureFlagBitsEXT = 2 ;
pub const VK_VIDEO_ENCODE_H265_RATE_CONTROL_STRUCTURE_FLAG_BITS_MAX_ENUM_EXT : VkVideoEncodeH265RateControlStructureFlagBitsEXT = 2147483647 ;
pub type VkVideoEncodeH265RateControlStructureFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoEncodeH265RateControlStructureFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265CapabilitiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub flags: VkVideoEncodeH265CapabilityFlagsEXT,
    pub inputModeFlags: VkVideoEncodeH265InputModeFlagsEXT,
    pub outputModeFlags: VkVideoEncodeH265OutputModeFlagsEXT,
    pub ctbSizes: VkVideoEncodeH265CtbSizeFlagsEXT,
    pub transformBlockSizes: VkVideoEncodeH265TransformBlockSizeFlagsEXT,
    pub maxPPictureL0ReferenceCount: u8,
    pub maxBPictureL0ReferenceCount: u8,
    pub maxL1ReferenceCount: u8,
    pub maxSubLayersCount: u8,
    pub minLog2MinLumaCodingBlockSizeMinus3: u8,
    pub maxLog2MinLumaCodingBlockSizeMinus3: u8,
    pub minLog2MinLumaTransformBlockSizeMinus2: u8,
    pub maxLog2MinLumaTransformBlockSizeMinus2: u8,
    pub minMaxTransformHierarchyDepthInter: u8,
    pub maxMaxTransformHierarchyDepthInter: u8,
    pub minMaxTransformHierarchyDepthIntra: u8,
    pub maxMaxTransformHierarchyDepthIntra: u8,
    pub maxDiffCuQpDeltaDepth: u8,
    pub minMaxNumMergeCand: u8,
    pub maxMaxNumMergeCand: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265SessionParametersAddInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vpsStdCount: u32,
    pub pVpsStd: *const StdVideoH265VideoParameterSet,
    pub spsStdCount: u32,
    pub pSpsStd: *const StdVideoH265SequenceParameterSet,
    pub ppsStdCount: u32,
    pub pPpsStd: *const StdVideoH265PictureParameterSet,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265SessionParametersCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxVpsStdCount: u32,
    pub maxSpsStdCount: u32,
    pub maxPpsStdCount: u32,
    pub pParametersAddInfo: *const VkVideoEncodeH265SessionParametersAddInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265DpbSlotInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub slotIndex: i8,
    pub pStdReferenceInfo: *const StdVideoEncodeH265ReferenceInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265ReferenceListsEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub referenceList0EntryCount: u8,
    pub pReferenceList0Entries: *const VkVideoEncodeH265DpbSlotInfoEXT,
    pub referenceList1EntryCount: u8,
    pub pReferenceList1Entries: *const VkVideoEncodeH265DpbSlotInfoEXT,
    pub pReferenceModifications: *const StdVideoEncodeH265ReferenceModifications,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265NaluSliceSegmentEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub ctbCount: u32,
    pub pReferenceFinalLists: *const VkVideoEncodeH265ReferenceListsEXT,
    pub pSliceSegmentHeaderStd: *const StdVideoEncodeH265SliceSegmentHeader,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265VclFrameInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pReferenceFinalLists: *const VkVideoEncodeH265ReferenceListsEXT,
    pub naluSliceSegmentEntryCount: u32,
    pub pNaluSliceSegmentEntries: *const VkVideoEncodeH265NaluSliceSegmentEXT,
    pub pCurrentPictureInfo: *const StdVideoEncodeH265PictureInfo,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265EmitPictureParametersEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vpsId: u8,
    pub spsId: u8,
    pub emitVpsEnable: VkBool32,
    pub emitSpsEnable: VkBool32,
    pub ppsIdEntryCount: u32,
    pub ppsIdEntries: *const u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265ProfileEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stdProfileIdc: StdVideoH265ProfileIdc,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265RateControlInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub gopFrameCount: u32,
    pub idrPeriod: u32,
    pub consecutiveBFrameCount: u32,
    pub rateControlStructure: VkVideoEncodeH265RateControlStructureFlagBitsEXT,
    pub subLayerCount: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265QpEXT {
    pub qpI: i32,
    pub qpP: i32,
    pub qpB: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265FrameSizeEXT {
    pub frameISize: u32,
    pub framePSize: u32,
    pub frameBSize: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoEncodeH265RateControlLayerInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub temporalId: u8,
    pub useInitialRcQp: VkBool32,
    pub initialRcQp: VkVideoEncodeH265QpEXT,
    pub useMinQp: VkBool32,
    pub minQp: VkVideoEncodeH265QpEXT,
    pub useMaxQp: VkBool32,
    pub maxQp: VkVideoEncodeH265QpEXT,
    pub useMaxFrameSize: VkBool32,
    pub maxFrameSize: VkVideoEncodeH265FrameSizeEXT,
}
pub const StdVideoDecodeH264FieldOrderCount_STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_TOP:
    StdVideoDecodeH264FieldOrderCount = 0;
pub const StdVideoDecodeH264FieldOrderCount_STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_BOTTOM:
    StdVideoDecodeH264FieldOrderCount = 1;
pub const StdVideoDecodeH264FieldOrderCount_STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_INVALID:
    StdVideoDecodeH264FieldOrderCount = 2147483647;
pub const StdVideoDecodeH264FieldOrderCount_STD_VIDEO_DECODE_H264_FIELD_ORDER_COUNT_MAX_ENUM:
    StdVideoDecodeH264FieldOrderCount = 2147483647;
pub type StdVideoDecodeH264FieldOrderCount = ::std::os::raw::c_uint;
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoDecodeH264PictureInfoFlags {
    #[inline]
    pub fn field_pic_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_field_pic_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_intra(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_intra(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bottom_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bottom_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn complementary_field_pair(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_complementary_field_pair(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        field_pic_flag: u32,
        is_intra: u32,
        IdrPicFlag: u32,
        bottom_field_flag: u32,
        is_reference: u32,
        complementary_field_pair: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let field_pic_flag: u32 = unsafe { ::std::mem::transmute(field_pic_flag) };
            field_pic_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_intra: u32 = unsafe { ::std::mem::transmute(is_intra) };
            is_intra as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::std::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let bottom_field_flag: u32 = unsafe { ::std::mem::transmute(bottom_field_flag) };
            bottom_field_flag as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_reference: u32 = unsafe { ::std::mem::transmute(is_reference) };
            is_reference as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let complementary_field_pair: u32 =
                unsafe { ::std::mem::transmute(complementary_field_pair) };
            complementary_field_pair as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264PictureInfo {
    pub flags: StdVideoDecodeH264PictureInfoFlags,
    pub seq_parameter_set_id: u8,
    pub pic_parameter_set_id: u8,
    pub reserved: u16,
    pub frame_num: u16,
    pub idr_pic_id: u16,
    pub PicOrderCnt: [i32; 2usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoDecodeH264ReferenceInfoFlags {
    #[inline]
    pub fn top_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_top_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn bottom_field_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_bottom_field_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_non_existing(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_non_existing(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        top_field_flag: u32,
        bottom_field_flag: u32,
        used_for_long_term_reference: u32,
        is_non_existing: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let top_field_flag: u32 = unsafe { ::std::mem::transmute(top_field_flag) };
            top_field_flag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let bottom_field_flag: u32 = unsafe { ::std::mem::transmute(bottom_field_flag) };
            bottom_field_flag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_non_existing: u32 = unsafe { ::std::mem::transmute(is_non_existing) };
            is_non_existing as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264ReferenceInfo {
    pub flags: StdVideoDecodeH264ReferenceInfoFlags,
    pub FrameNum: u16,
    pub reserved: u16,
    pub PicOrderCnt: [i32; 2usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264MvcElementFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoDecodeH264MvcElementFlags {
    #[inline]
    pub fn non_idr(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_non_idr(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn anchor_pic(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_anchor_pic(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn inter_view(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_inter_view(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        non_idr: u32,
        anchor_pic: u32,
        inter_view: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let non_idr: u32 = unsafe { ::std::mem::transmute(non_idr) };
            non_idr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let anchor_pic: u32 = unsafe { ::std::mem::transmute(anchor_pic) };
            anchor_pic as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let inter_view: u32 = unsafe { ::std::mem::transmute(inter_view) };
            inter_view as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264MvcElement {
    pub flags: StdVideoDecodeH264MvcElementFlags,
    pub viewOrderIndex: u16,
    pub viewId: u16,
    pub temporalId: u16,
    pub priorityId: u16,
    pub numOfAnchorRefsInL0: u16,
    pub viewIdOfAnchorRefsInL0: [u16; 15usize],
    pub numOfAnchorRefsInL1: u16,
    pub viewIdOfAnchorRefsInL1: [u16; 15usize],
    pub numOfNonAnchorRefsInL0: u16,
    pub viewIdOfNonAnchorRefsInL0: [u16; 15usize],
    pub numOfNonAnchorRefsInL1: u16,
    pub viewIdOfNonAnchorRefsInL1: [u16; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH264Mvc {
    pub viewId0: u32,
    pub mvcElementCount: u32,
    pub pMvcElements: *const StdVideoDecodeH264MvcElement,
}
pub const VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_PROGRESSIVE_EXT : VkVideoDecodeH264PictureLayoutFlagBitsEXT = 0 ;
pub const VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_INTERLEAVED_LINES_BIT_EXT : VkVideoDecodeH264PictureLayoutFlagBitsEXT = 1 ;
pub const VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_INTERLACED_SEPARATE_PLANES_BIT_EXT : VkVideoDecodeH264PictureLayoutFlagBitsEXT = 2 ;
pub const VK_VIDEO_DECODE_H264_PICTURE_LAYOUT_FLAG_BITS_MAX_ENUM_EXT : VkVideoDecodeH264PictureLayoutFlagBitsEXT = 2147483647 ;
pub type VkVideoDecodeH264PictureLayoutFlagBitsEXT = ::std::os::raw::c_uint;
pub type VkVideoDecodeH264PictureLayoutFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH264ProfileEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stdProfileIdc: StdVideoH264ProfileIdc,
    pub pictureLayout: VkVideoDecodeH264PictureLayoutFlagsEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH264CapabilitiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxLevel: StdVideoH264Level,
    pub fieldOffsetGranularity: VkOffset2D,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH264SessionParametersAddInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub spsStdCount: u32,
    pub pSpsStd: *const StdVideoH264SequenceParameterSet,
    pub ppsStdCount: u32,
    pub pPpsStd: *const StdVideoH264PictureParameterSet,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH264SessionParametersCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxSpsStdCount: u32,
    pub maxPpsStdCount: u32,
    pub pParametersAddInfo: *const VkVideoDecodeH264SessionParametersAddInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH264PictureInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pStdPictureInfo: *const StdVideoDecodeH264PictureInfo,
    pub slicesCount: u32,
    pub pSlicesDataOffsets: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH264MvcEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pStdMvc: *const StdVideoDecodeH264Mvc,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH264DpbSlotInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pStdReferenceInfo: *const StdVideoDecodeH264ReferenceInfo,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265PictureInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoDecodeH265PictureInfoFlags {
    #[inline]
    pub fn IrapPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IrapPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IdrPicFlag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IdrPicFlag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IsReference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_IsReference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn short_term_ref_pic_set_sps_flag(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_short_term_ref_pic_set_sps_flag(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        IrapPicFlag: u32,
        IdrPicFlag: u32,
        IsReference: u32,
        short_term_ref_pic_set_sps_flag: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let IrapPicFlag: u32 = unsafe { ::std::mem::transmute(IrapPicFlag) };
            IrapPicFlag as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let IdrPicFlag: u32 = unsafe { ::std::mem::transmute(IdrPicFlag) };
            IdrPicFlag as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let IsReference: u32 = unsafe { ::std::mem::transmute(IsReference) };
            IsReference as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let short_term_ref_pic_set_sps_flag: u32 =
                unsafe { ::std::mem::transmute(short_term_ref_pic_set_sps_flag) };
            short_term_ref_pic_set_sps_flag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265PictureInfo {
    pub flags: StdVideoDecodeH265PictureInfoFlags,
    pub sps_video_parameter_set_id: u8,
    pub pps_seq_parameter_set_id: u8,
    pub pps_pic_parameter_set_id: u8,
    pub num_short_term_ref_pic_sets: u8,
    pub PicOrderCntVal: i32,
    pub NumBitsForSTRefPicSetInSlice: u16,
    pub NumDeltaPocsOfRefRpsIdx: u8,
    pub RefPicSetStCurrBefore: [u8; 8usize],
    pub RefPicSetStCurrAfter: [u8; 8usize],
    pub RefPicSetLtCurr: [u8; 8usize],
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265ReferenceInfoFlags {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl StdVideoDecodeH265ReferenceInfoFlags {
    #[inline]
    pub fn used_for_long_term_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_used_for_long_term_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn unused_for_reference(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_unused_for_reference(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_non_existing(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_non_existing(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        used_for_long_term_reference: u32,
        unused_for_reference: u32,
        is_non_existing: u32,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let used_for_long_term_reference: u32 =
                unsafe { ::std::mem::transmute(used_for_long_term_reference) };
            used_for_long_term_reference as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let unused_for_reference: u32 = unsafe { ::std::mem::transmute(unused_for_reference) };
            unused_for_reference as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_non_existing: u32 = unsafe { ::std::mem::transmute(is_non_existing) };
            is_non_existing as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct StdVideoDecodeH265ReferenceInfo {
    pub flags: StdVideoDecodeH265ReferenceInfoFlags,
    pub PicOrderCntVal: i32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH265ProfileEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stdProfileIdc: StdVideoH265ProfileIdc,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH265CapabilitiesEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxLevel: StdVideoH265Level,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH265SessionParametersAddInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub vpsStdCount: u32,
    pub pVpsStd: *const StdVideoH265VideoParameterSet,
    pub spsStdCount: u32,
    pub pSpsStd: *const StdVideoH265SequenceParameterSet,
    pub ppsStdCount: u32,
    pub pPpsStd: *const StdVideoH265PictureParameterSet,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH265SessionParametersCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub maxVpsStdCount: u32,
    pub maxSpsStdCount: u32,
    pub maxPpsStdCount: u32,
    pub pParametersAddInfo: *const VkVideoDecodeH265SessionParametersAddInfoEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH265PictureInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pStdPictureInfo: *mut StdVideoDecodeH265PictureInfo,
    pub slicesCount: u32,
    pub pSlicesDataOffsets: *const u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVideoDecodeH265DpbSlotInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pStdReferenceInfo: *const StdVideoDecodeH265ReferenceInfo,
}
pub type VkDirectFBSurfaceCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDirectFBSurfaceCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDirectFBSurfaceCreateFlagsEXT,
    pub dfb: *mut IDirectFB,
    pub surface: *mut IDirectFBSurface,
}
pub type PFN_vkCreateDirectFBSurfaceEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkDirectFBSurfaceCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceDirectFBPresentationSupportEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        dfb: *mut IDirectFB,
    ) -> VkBool32
;
pub type VkImagePipeSurfaceCreateFlagsFUCHSIA = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImagePipeSurfaceCreateInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImagePipeSurfaceCreateFlagsFUCHSIA,
    pub imagePipeHandle: zx_handle_t,
}
pub type PFN_vkCreateImagePipeSurfaceFUCHSIA = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkImagePipeSurfaceCreateInfoFUCHSIA,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryZirconHandleInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
    pub handle: zx_handle_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryZirconHandlePropertiesFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryGetZirconHandleInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
pub type PFN_vkGetMemoryZirconHandleFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetZirconHandleInfo: *const VkMemoryGetZirconHandleInfoFUCHSIA,
        pZirconHandle: *mut zx_handle_t,
    ) -> VkResult
;
pub type PFN_vkGetMemoryZirconHandlePropertiesFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        zirconHandle: zx_handle_t,
        pMemoryZirconHandleProperties: *mut VkMemoryZirconHandlePropertiesFUCHSIA,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportSemaphoreZirconHandleInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub flags: VkSemaphoreImportFlags,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
    pub zirconHandle: zx_handle_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreGetZirconHandleInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
}
pub type PFN_vkImportSemaphoreZirconHandleFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        pImportSemaphoreZirconHandleInfo: *const VkImportSemaphoreZirconHandleInfoFUCHSIA,
    ) -> VkResult
;
pub type PFN_vkGetSemaphoreZirconHandleFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetZirconHandleInfo: *const VkSemaphoreGetZirconHandleInfoFUCHSIA,
        pZirconHandle: *mut zx_handle_t,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCollectionFUCHSIA_T {
    _unused: [u8; 0],
}
pub type VkBufferCollectionFUCHSIA = *mut VkBufferCollectionFUCHSIA_T;
pub type VkImageFormatConstraintsFlagsFUCHSIA = VkFlags;
pub const VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_RARELY_FUCHSIA : VkImageConstraintsInfoFlagBitsFUCHSIA = 1 ;
pub const VK_IMAGE_CONSTRAINTS_INFO_CPU_READ_OFTEN_FUCHSIA:
    VkImageConstraintsInfoFlagBitsFUCHSIA = 2;
pub const VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_RARELY_FUCHSIA : VkImageConstraintsInfoFlagBitsFUCHSIA = 4 ;
pub const VK_IMAGE_CONSTRAINTS_INFO_CPU_WRITE_OFTEN_FUCHSIA : VkImageConstraintsInfoFlagBitsFUCHSIA = 8 ;
pub const VK_IMAGE_CONSTRAINTS_INFO_PROTECTED_OPTIONAL_FUCHSIA : VkImageConstraintsInfoFlagBitsFUCHSIA = 16 ;
pub const VK_IMAGE_CONSTRAINTS_INFO_FLAG_BITS_MAX_ENUM_FUCHSIA : VkImageConstraintsInfoFlagBitsFUCHSIA = 2147483647 ;
pub type VkImageConstraintsInfoFlagBitsFUCHSIA = ::std::os::raw::c_uint;
pub type VkImageConstraintsInfoFlagsFUCHSIA = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCollectionCreateInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub collectionToken: zx_handle_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryBufferCollectionFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub collection: VkBufferCollectionFUCHSIA,
    pub index: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCollectionImageCreateInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub collection: VkBufferCollectionFUCHSIA,
    pub index: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCollectionConstraintsInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub minBufferCount: u32,
    pub maxBufferCount: u32,
    pub minBufferCountForCamping: u32,
    pub minBufferCountForDedicatedSlack: u32,
    pub minBufferCountForSharedSlack: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferConstraintsInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub createInfo: VkBufferCreateInfo,
    pub requiredFormatFeatures: VkFormatFeatureFlags,
    pub bufferCollectionConstraints: VkBufferCollectionConstraintsInfoFUCHSIA,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCollectionBufferCreateInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub collection: VkBufferCollectionFUCHSIA,
    pub index: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSysmemColorSpaceFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub colorSpace: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCollectionPropertiesFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryTypeBits: u32,
    pub bufferCount: u32,
    pub createInfoIndex: u32,
    pub sysmemPixelFormat: u64,
    pub formatFeatures: VkFormatFeatureFlags,
    pub sysmemColorSpaceIndex: VkSysmemColorSpaceFUCHSIA,
    pub samplerYcbcrConversionComponents: VkComponentMapping,
    pub suggestedYcbcrModel: VkSamplerYcbcrModelConversion,
    pub suggestedYcbcrRange: VkSamplerYcbcrRange,
    pub suggestedXChromaOffset: VkChromaLocation,
    pub suggestedYChromaOffset: VkChromaLocation,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatConstraintsInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub imageCreateInfo: VkImageCreateInfo,
    pub requiredFormatFeatures: VkFormatFeatureFlags,
    pub flags: VkImageFormatConstraintsFlagsFUCHSIA,
    pub sysmemPixelFormat: u64,
    pub colorSpaceCount: u32,
    pub pColorSpaces: *const VkSysmemColorSpaceFUCHSIA,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageConstraintsInfoFUCHSIA {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub formatConstraintsCount: u32,
    pub pFormatConstraints: *const VkImageFormatConstraintsInfoFUCHSIA,
    pub bufferCollectionConstraints: VkBufferCollectionConstraintsInfoFUCHSIA,
    pub flags: VkImageConstraintsInfoFlagsFUCHSIA,
}
pub type PFN_vkCreateBufferCollectionFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkBufferCollectionCreateInfoFUCHSIA,
        pAllocator: *const VkAllocationCallbacks,
        pCollection: *mut VkBufferCollectionFUCHSIA,
    ) -> VkResult
;
pub type PFN_vkSetBufferCollectionImageConstraintsFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        collection: VkBufferCollectionFUCHSIA,
        pImageConstraintsInfo: *const VkImageConstraintsInfoFUCHSIA,
    ) -> VkResult
;
pub type PFN_vkSetBufferCollectionBufferConstraintsFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        collection: VkBufferCollectionFUCHSIA,
        pBufferConstraintsInfo: *const VkBufferConstraintsInfoFUCHSIA,
    ) -> VkResult
;
pub type PFN_vkDestroyBufferCollectionFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        collection: VkBufferCollectionFUCHSIA,
        pAllocator: *const VkAllocationCallbacks,
    )
;
pub type PFN_vkGetBufferCollectionPropertiesFUCHSIA = 
    unsafe extern "C" fn(
        device: VkDevice,
        collection: VkBufferCollectionFUCHSIA,
        pProperties: *mut VkBufferCollectionPropertiesFUCHSIA,
    ) -> VkResult
;
pub type VkIOSSurfaceCreateFlagsMVK = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkIOSSurfaceCreateInfoMVK {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkIOSSurfaceCreateFlagsMVK,
    pub pView: *const ::std::os::raw::c_void,
}
pub type PFN_vkCreateIOSSurfaceMVK = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkIOSSurfaceCreateInfoMVK,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type VkMacOSSurfaceCreateFlagsMVK = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMacOSSurfaceCreateInfoMVK {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkMacOSSurfaceCreateFlagsMVK,
    pub pView: *const ::std::os::raw::c_void,
}
pub type PFN_vkCreateMacOSSurfaceMVK = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkMacOSSurfaceCreateInfoMVK,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type CAMetalLayer = ::std::os::raw::c_void;
pub type VkMetalSurfaceCreateFlagsEXT = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMetalSurfaceCreateInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkMetalSurfaceCreateFlagsEXT,
    pub pLayer: *const CAMetalLayer,
}
pub type PFN_vkCreateMetalSurfaceEXT = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkMetalSurfaceCreateInfoEXT,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type VkScreenSurfaceCreateFlagsQNX = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkScreenSurfaceCreateInfoQNX {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkScreenSurfaceCreateFlagsQNX,
    pub context: *mut _screen_context,
    pub window: *mut _screen_window,
}
pub type PFN_vkCreateScreenSurfaceQNX = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkScreenSurfaceCreateInfoQNX,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceScreenPresentationSupportQNX = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        window: *mut _screen_window,
    ) -> VkBool32
;
pub type VkViSurfaceCreateFlagsNN = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViSurfaceCreateInfoNN {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkViSurfaceCreateFlagsNN,
    pub window: *mut ::std::os::raw::c_void,
}
pub type PFN_vkCreateViSurfaceNN = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkViSurfaceCreateInfoNN,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type VkWaylandSurfaceCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWaylandSurfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkWaylandSurfaceCreateFlagsKHR,
    pub display: *mut wl_display,
    pub surface: *mut wl_surface,
}
pub type PFN_vkCreateWaylandSurfaceKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkWaylandSurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceWaylandPresentationSupportKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        display: *mut wl_display,
    ) -> VkBool32
;
pub type VkWin32SurfaceCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWin32SurfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkWin32SurfaceCreateFlagsKHR,
    pub hinstance: HINSTANCE,
    pub hwnd: HWND,
}
pub type PFN_vkCreateWin32SurfaceKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkWin32SurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR = 
    unsafe extern "C" fn(physicalDevice: VkPhysicalDevice, queueFamilyIndex: u32) -> VkBool32
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportMemoryWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pAttributes: *const SECURITY_ATTRIBUTES,
    pub dwAccess: DWORD,
    pub name: LPCWSTR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryWin32HandlePropertiesKHR {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryTypeBits: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryGetWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
pub type PFN_vkGetMemoryWin32HandleKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetWin32HandleInfo: *const VkMemoryGetWin32HandleInfoKHR,
        pHandle: *mut HANDLE,
    ) -> VkResult
;
pub type PFN_vkGetMemoryWin32HandlePropertiesKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        handleType: VkExternalMemoryHandleTypeFlagBits,
        handle: HANDLE,
        pMemoryWin32HandleProperties: *mut VkMemoryWin32HandlePropertiesKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWin32KeyedMutexAcquireReleaseInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub acquireCount: u32,
    pub pAcquireSyncs: *const VkDeviceMemory,
    pub pAcquireKeys: *const u64,
    pub pAcquireTimeouts: *const u32,
    pub releaseCount: u32,
    pub pReleaseSyncs: *const VkDeviceMemory,
    pub pReleaseKeys: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportSemaphoreWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub flags: VkSemaphoreImportFlags,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportSemaphoreWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pAttributes: *const SECURITY_ATTRIBUTES,
    pub dwAccess: DWORD,
    pub name: LPCWSTR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkD3D12FenceSubmitInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreValuesCount: u32,
    pub pWaitSemaphoreValues: *const u64,
    pub signalSemaphoreValuesCount: u32,
    pub pSignalSemaphoreValues: *const u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreGetWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
}
pub type PFN_vkImportSemaphoreWin32HandleKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pImportSemaphoreWin32HandleInfo: *const VkImportSemaphoreWin32HandleInfoKHR,
    ) -> VkResult
;
pub type PFN_vkGetSemaphoreWin32HandleKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetWin32HandleInfo: *const VkSemaphoreGetWin32HandleInfoKHR,
        pHandle: *mut HANDLE,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportFenceWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fence: VkFence,
    pub flags: VkFenceImportFlags,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportFenceWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pAttributes: *const SECURITY_ATTRIBUTES,
    pub dwAccess: DWORD,
    pub name: LPCWSTR,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFenceGetWin32HandleInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub fence: VkFence,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
}
pub type PFN_vkImportFenceWin32HandleKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pImportFenceWin32HandleInfo: *const VkImportFenceWin32HandleInfoKHR,
    ) -> VkResult
;
pub type PFN_vkGetFenceWin32HandleKHR = 
    unsafe extern "C" fn(
        device: VkDevice,
        pGetWin32HandleInfo: *const VkFenceGetWin32HandleInfoKHR,
        pHandle: *mut HANDLE,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImportMemoryWin32HandleInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagsNV,
    pub handle: HANDLE,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportMemoryWin32HandleInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pAttributes: *const SECURITY_ATTRIBUTES,
    pub dwAccess: DWORD,
}
pub type PFN_vkGetMemoryWin32HandleNV = 
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        handleType: VkExternalMemoryHandleTypeFlagsNV,
        pHandle: *mut HANDLE,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWin32KeyedMutexAcquireReleaseInfoNV {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub acquireCount: u32,
    pub pAcquireSyncs: *const VkDeviceMemory,
    pub pAcquireKeys: *const u64,
    pub pAcquireTimeoutMilliseconds: *const u32,
    pub releaseCount: u32,
    pub pReleaseSyncs: *const VkDeviceMemory,
    pub pReleaseKeys: *const u64,
}
pub const VK_FULL_SCREEN_EXCLUSIVE_DEFAULT_EXT: VkFullScreenExclusiveEXT =
    0;
pub const VK_FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT: VkFullScreenExclusiveEXT =
    1;
pub const VK_FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT:
    VkFullScreenExclusiveEXT = 2;
pub const VK_FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT:
    VkFullScreenExclusiveEXT = 3;
pub const VK_FULL_SCREEN_EXCLUSIVE_MAX_ENUM_EXT: VkFullScreenExclusiveEXT =
    2147483647;
pub type VkFullScreenExclusiveEXT = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceFullScreenExclusiveInfoEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fullScreenExclusive: VkFullScreenExclusiveEXT,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceCapabilitiesFullScreenExclusiveEXT {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub fullScreenExclusiveSupported: VkBool32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSurfaceFullScreenExclusiveWin32InfoEXT {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub hmonitor: HMONITOR,
}
pub type PFN_vkGetPhysicalDeviceSurfacePresentModes2EXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pPresentModeCount: *mut u32,
        pPresentModes: *mut VkPresentModeKHR,
    ) -> VkResult
;
pub type PFN_vkAcquireFullScreenExclusiveModeEXT = 
    unsafe extern "C" fn(device: VkDevice, swapchain: VkSwapchainKHR) -> VkResult
;
pub type PFN_vkReleaseFullScreenExclusiveModeEXT = 
    unsafe extern "C" fn(device: VkDevice, swapchain: VkSwapchainKHR) -> VkResult
;
pub type PFN_vkGetDeviceGroupSurfacePresentModes2EXT = 
    unsafe extern "C" fn(
        device: VkDevice,
        pSurfaceInfo: *const VkPhysicalDeviceSurfaceInfo2KHR,
        pModes: *mut VkDeviceGroupPresentModeFlagsKHR,
    ) -> VkResult
;
pub type VkXcbSurfaceCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkXcbSurfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkXcbSurfaceCreateFlagsKHR,
    pub connection: *mut xcb_connection_t,
    pub window: xcb_window_t,
}
pub type PFN_vkCreateXcbSurfaceKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkXcbSurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        connection: *mut xcb_connection_t,
        visual_id: xcb_visualid_t,
    ) -> VkBool32
;
pub type VkXlibSurfaceCreateFlagsKHR = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkXlibSurfaceCreateInfoKHR {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkXlibSurfaceCreateFlagsKHR,
    pub dpy: *mut Display,
    pub window: Window,
}
pub type PFN_vkCreateXlibSurfaceKHR = 
    unsafe extern "C" fn(
        instance: VkInstance,
        pCreateInfo: *const VkXlibSurfaceCreateInfoKHR,
        pAllocator: *const VkAllocationCallbacks,
        pSurface: *mut VkSurfaceKHR,
    ) -> VkResult
;
pub type PFN_vkGetPhysicalDeviceXlibPresentationSupportKHR = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        queueFamilyIndex: u32,
        dpy: *mut Display,
        visualID: VisualID,
    ) -> VkBool32
;
pub type PFN_vkAcquireXlibDisplayEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        dpy: *mut Display,
        display: VkDisplayKHR,
    ) -> VkResult
;
pub type PFN_vkGetRandROutputDisplayEXT = 
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        dpy: *mut Display,
        rrOutput: RROutput,
        pDisplay: *mut VkDisplayKHR,
    ) -> VkResult
;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _screen_context {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _screen_window {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct wl_display {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct wl_surface {
    pub _address: u8,
}
