#!/usr/bin/python3
#
# generate ISR table
#

beginning = '''\
/*
 * Exception table for PIC32
 * generated by gen_isr_table.py
 */

#include <regdef.h>
#include <cp0defs.h>
.set noreorder
.set nomips16

.section .text.default_isr, "ax"
.ent _default_isr_fn
.global _default_isr_fn
_default_isr_fn:
        jr      ra
        nop
.end _default_isr_fn

# General Exception
.section .gen_handler, "ax"
.ent _gen_exception
.global _gen_exception
_gen_exception:
        la      k0,_general_exception_context
        jr      k0
        nop
.end _gen_exception
'''

vect_fmt = '''\
# vector {0}
.section .vector_{0}, "ax"
.ent _vector_{0}
_vector_{0}:
        la  k0,_vector_{0}_fn
        j   _vector_{0}_context
        nop
.end _vector_{0}
'''

print(beginning)
for i in range(0, 64):
    print(vect_fmt.format(i))
