#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![allow(dead_code)]
/* automatically generated by rust-bindgen */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    storage: Storage,
    align: [Align; 0],
}

impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }

    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        byte & mask == mask
    }

    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());

        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];

        let bit_index = index % 8;
        let mask = 1 << bit_index;

        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }

    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        let mut val = 0;

        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                val |= 1 << i;
            }
        }

        val
    }

    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());

        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            self.set_bit(i + bit_offset, val_bit_is_set);
        }
    }
}
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_char = ::std::os::raw::c_uchar;
pub type u_short = ::std::os::raw::c_ushort;
pub type u_int = ::std::os::raw::c_uint;
pub type u_long = ::std::os::raw::c_ulong;
pub type in_addr_t = __uint32_t;
pub type in_port_t = __uint16_t;
pub type sa_family_t = __uint8_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr {
    pub sa_len: __uint8_t,
    pub sa_family: sa_family_t,
    pub sa_data: [::std::os::raw::c_char; 14usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct in_addr {
    pub s_addr: in_addr_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sockaddr_in {
    pub sin_len: __uint8_t,
    pub sin_family: sa_family_t,
    pub sin_port: in_port_t,
    pub sin_addr: in_addr,
    pub sin_zero: [::std::os::raw::c_char; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct in6_addr {
    pub __u6_addr: in6_addr__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union in6_addr__bindgen_ty_1 {
    pub __u6_addr8: [__uint8_t; 16usize],
    pub __u6_addr16: [__uint16_t; 8usize],
    pub __u6_addr32: [__uint32_t; 4usize],
    _bindgen_union_align: [u32; 4usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sockaddr_in6 {
    pub sin6_len: __uint8_t,
    pub sin6_family: sa_family_t,
    pub sin6_port: in_port_t,
    pub sin6_flowinfo: __uint32_t,
    pub sin6_addr: in6_addr,
    pub sin6_scope_id: __uint32_t,
}
pub const res_9_sendhookact_res_9_goahead: res_9_sendhookact = 0;
pub const res_9_sendhookact_res_9_nextns: res_9_sendhookact = 1;
pub const res_9_sendhookact_res_9_modified: res_9_sendhookact = 2;
pub const res_9_sendhookact_res_9_done: res_9_sendhookact = 3;
pub const res_9_sendhookact_res_9_error: res_9_sendhookact = 4;
pub type res_9_sendhookact = ::std::os::raw::c_uint;
pub type res_send_qhook = ::std::option::Option<
    unsafe extern "C" fn(
        ns: *const *const sockaddr,
        query: *mut *const u_char,
        querylen: *mut ::std::os::raw::c_int,
        ans: *mut u_char,
        anssiz: ::std::os::raw::c_int,
        resplen: *mut ::std::os::raw::c_int,
    ) -> res_9_sendhookact,
>;
pub type res_send_rhook = ::std::option::Option<
    unsafe extern "C" fn(
        ns: *const sockaddr,
        query: *const u_char,
        querylen: ::std::os::raw::c_int,
        ans: *mut u_char,
        anssiz: ::std::os::raw::c_int,
        resplen: *mut ::std::os::raw::c_int,
    ) -> res_9_sendhookact,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __res_9_state_ext {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __res_9_state {
    pub retrans: ::std::os::raw::c_int,
    pub retry: ::std::os::raw::c_int,
    pub options: u_long,
    pub nscount: ::std::os::raw::c_int,
    pub nsaddr_list: [sockaddr_in; 3usize],
    pub id: u_short,
    pub dnsrch: [*mut ::std::os::raw::c_char; 7usize],
    pub defdname: [::std::os::raw::c_char; 256usize],
    pub pfcode: u_long,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize], u8>,
    pub unused: [::std::os::raw::c_char; 3usize],
    pub sort_list: [__res_9_state__bindgen_ty_1; 10usize],
    pub qhook: res_send_qhook,
    pub rhook: res_send_rhook,
    pub res_h_errno: ::std::os::raw::c_int,
    pub _vcsock: ::std::os::raw::c_int,
    pub _flags: u_int,
    pub _pad: u_int,
    pub _u: __res_9_state__bindgen_ty_2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __res_9_state__bindgen_ty_1 {
    pub addr: in_addr,
    pub mask: u_int32_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __res_9_state__bindgen_ty_2 {
    pub pad: [::std::os::raw::c_char; 40usize],
    pub _ext: __res_9_state__bindgen_ty_2__bindgen_ty_1,
    _bindgen_union_align: [u64; 5usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __res_9_state__bindgen_ty_2__bindgen_ty_1 {
    pub nscount: u_int16_t,
    pub nstimes: [u_int16_t; 3usize],
    pub nssocks: [::std::os::raw::c_int; 3usize],
    pub ext: *mut __res_9_state_ext,
}
impl __res_9_state {
    #[inline]
    pub fn ndots(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_ndots(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn nsort(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u32) }
    }
    #[inline]
    pub fn set_nsort(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        ndots: ::std::os::raw::c_uint,
        nsort: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 4u8, {
            let ndots: u32 = unsafe { ::std::mem::transmute(ndots) };
            ndots as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let nsort: u32 = unsafe { ::std::mem::transmute(nsort) };
            nsort as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type res_9_state = *mut __res_9_state;
#[repr(C)]
#[derive(Copy, Clone)]
pub union res_9_sockaddr_union {
    pub sin: sockaddr_in,
    pub sin6: sockaddr_in6,
    pub __align32: i32,
    pub __space: [::std::os::raw::c_char; 128usize],
    _bindgen_union_align: [u32; 32usize],
}
extern "C" {
    #[link_name = "\u{1}_res_9_ninit"]
    pub fn res_9_ninit(arg1: res_9_state) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_res_9_getservers"]
    pub fn res_9_getservers(
        arg1: res_9_state,
        arg2: *mut res_9_sockaddr_union,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
