use clap::ArgMatches;
use minipac::client::Client;
use minipac::hostname::Hostname;
use std::time::Duration;

pub fn ping(matches: &ArgMatches) -> Result<(), String> {
	// Safe to unwrap because it's required
	let hostname = matches.value_of("hostname").unwrap();
	let hostname = Hostname::new(hostname).ok_or_else(|| "Invalid hostname".to_string())?;

	// Safe to unwrap because it's required
	let serv_hostname = matches.value_of("server").unwrap();
	let serv_hostname =
		Hostname::new(serv_hostname).ok_or_else(|| "Invalid server hostname".to_string())?;

	let baud_rate = matches.value_of("baudrate").unwrap_or("1200");
	let baud_rate = baud_rate
		.parse()
		.map_err(|_| "Invalid baud rate".to_string())?;

	let addr = matches.value_of("kiss").unwrap_or("localhost:8001");
	let mut client = Client::new(
		addr,
		hostname,
		serv_hostname,
		Duration::from_secs(3),
		1000,
		3,
		baud_rate,
	)
	.map_err(|e| format!("{}", e))?;

	println!("Pinging {}...", serv_hostname);
	let pong = client.ping().map_err(|e| format!("{}", e))?;
	if pong {
		println!("Pong!");
	} else {
		println!("Could not reach the server.");
	}

	Ok(())
}
