mod client;
mod common;
mod ping;
mod serve;

use clap::{App, AppSettings, Arg, SubCommand};

fn main() {
	let matches = App::new("minitransfer")
		.version("0.1")
		.author("Stephen D www.scd31.com")
		.setting(AppSettings::SubcommandRequiredElseHelp)
		.subcommand(
			SubCommand::with_name("serve")
				.about("Serve a file for download by anyone else")
				.arg(
					Arg::with_name("hostname")
						.help("Your hostname (N0CALL, N0CALL-123, etc.)")
						.required(true),
				)
				.arg(
					Arg::with_name("file")
						.help("The file to serve")
						.required(true),
				)
				.arg(
					Arg::with_name("kiss")
						.help("The address of the KISS server. Default is localhost:8001"),
				)
				.arg(Arg::with_name("baudrate").help("The baudrate to use, in bps. Default 1200")),
		)
		.subcommand(
			SubCommand::with_name("recv")
				.about("Receive a file that's being served by someone else")
				.arg(
					Arg::with_name("hostname")
						.help("Your hostname (N0CALL, N0CALL-123, etc.)")
						.required(true),
				)
				.arg(
					Arg::with_name("server")
						.help("The server's hostname (N0CALL, N0CALL-123, etc.)")
						.required(true),
				)
				.arg(
					Arg::with_name("kiss")
						.help("The address of the KISS server. Default is localhost:8001"),
				)
				.arg(Arg::with_name("baudrate").help("The baudrate to use, in bps. Default 1200")),
		)
		.subcommand(
			SubCommand::with_name("ping")
				.about("Ping a server")
				.arg(
					Arg::with_name("hostname")
						.help("Your hostname (N0CALL, N0CALL-123, etc.)")
						.required(true),
				)
				.arg(
					Arg::with_name("server")
						.help("The server's hostname (N0CALL, N0CALL-123, etc.)")
						.required(true),
				)
				.arg(
					Arg::with_name("kiss")
						.help("The address of the KISS server. Default is localhost:8001"),
				)
				.arg(Arg::with_name("baudrate").help("The baudrate to use, in bps. Default 1200")),
		)
		.get_matches();

	if let Some(matches) = matches.subcommand_matches("serve") {
		if let Err(e) = crate::serve::serve(matches) {
			eprintln!("ERROR: {}", e);
		}
	} else if let Some(matches) = matches.subcommand_matches("recv") {
		if let Err(e) = crate::client::recv(matches) {
			eprintln!("ERROR: {}", e);
		}
	} else if let Some(matches) = matches.subcommand_matches("ping") {
		if let Err(e) = crate::ping::ping(matches) {
			eprintln!("ERROR: {}", e);
		}
	}
}
