# Minitransfer

Minitransfer is a utility for transferring files over packet radio. It is based on the [Minipac protocol](https://gitlab.scd31.com/stephen/minipac). Because it uses Minipac, it has checksum validation and compression.

On a 2400 baud connection, I was able to send a 40 780 byte file in 2 minutes 19 seconds (from the time the program started, to the time it exited). Once compressed, 38 350 bytes of data was actually transferred. This represents an average speed of slightly over 2200 baud.

## Installation

First, [install cargo](https://doc.rust-lang.org/cargo/getting-started/installation.html)

Then, installing minitransfer is as easy as running `cargo install minitransfer'

## Usage

Minitransfer requires a TNC to function. A TNC converts the digital stream of bytes into an audio signal. Although hardware TNCs exist, I use the software TNC [Dire Wolf](https://github.com/wb2osz/direwolf).

## Sending a file

Run `minitransfer serve URCALL-0 yourfile.jpg`. `URCALL-0` is your hostname, which is your callsign and a number between 0 and 255. You can also omit the number (and it will default to 0). This will default to 1200 baud to a KISS TNC on `localhost:8001` (which is where Direwolf will listen by default).

This will set up a server. When a client connects over the air, it will automatically send the file.

## Receiving a file

Run `minitransfer recv URCALL-0 THEIRCL-0`. As with the server, this will default to 1200 baud and `localhost:8001`.

This will connect to the server `THEIRCL-0`. Once it establishes a connection, it will print out the file name and the number of bytes that need to be transferred. The file will be downloaded, and it will exit once complete.

## Pinging a server

Run `minitransfer URCALL-0 THEIRCL-0`. As with other commands, this will default to 1200 baud and `localhost:8001`.

The purpose of this command is to confirm that a connection can be established with the server. This is mainly meant to be used for debugging.
