use crate::event::KeyCode;

pub fn translate_keycode(keycode: u32) -> KeyCode {
    // same as GLFW
    match keycode {
        0x00B => KeyCode::Key0,
        0x002 => KeyCode::Key1,
        0x003 => KeyCode::Key2,
        0x004 => KeyCode::Key3,
        0x005 => KeyCode::Key4,
        0x006 => KeyCode::Key5,
        0x007 => KeyCode::Key6,
        0x008 => KeyCode::Key7,
        0x009 => KeyCode::Key8,
        0x00A => KeyCode::Key9,
        0x01E => KeyCode::A,
        0x030 => KeyCode::B,
        0x02E => KeyCode::C,
        0x020 => KeyCode::D,
        0x012 => KeyCode::E,
        0x021 => KeyCode::F,
        0x022 => KeyCode::G,
        0x023 => KeyCode::H,
        0x017 => KeyCode::I,
        0x024 => KeyCode::J,
        0x025 => KeyCode::K,
        0x026 => KeyCode::L,
        0x032 => KeyCode::M,
        0x031 => KeyCode::N,
        0x018 => KeyCode::O,
        0x019 => KeyCode::P,
        0x010 => KeyCode::Q,
        0x013 => KeyCode::R,
        0x01F => KeyCode::S,
        0x014 => KeyCode::T,
        0x016 => KeyCode::U,
        0x02F => KeyCode::V,
        0x011 => KeyCode::W,
        0x02D => KeyCode::X,
        0x015 => KeyCode::Y,
        0x02C => KeyCode::Z,
        0x028 => KeyCode::Apostrophe,
        0x02B => KeyCode::Backslash,
        0x033 => KeyCode::Comma,
        0x00D => KeyCode::Equal,
        0x029 => KeyCode::GraveAccent,
        0x01A => KeyCode::LeftBracket,
        0x00C => KeyCode::Minus,
        0x034 => KeyCode::Period,
        0x01B => KeyCode::RightBracket,
        0x027 => KeyCode::Semicolon,
        0x035 => KeyCode::Slash,
        0x056 => KeyCode::World2,
        0x00E => KeyCode::Backspace,
        0x153 => KeyCode::Delete,
        0x14F => KeyCode::End,
        0x01C => KeyCode::Enter,
        0x001 => KeyCode::Escape,
        0x147 => KeyCode::Home,
        0x152 => KeyCode::Insert,
        0x15D => KeyCode::Menu,
        0x151 => KeyCode::PageDown,
        0x149 => KeyCode::PageUp,
        0x045 => KeyCode::Pause,
        0x146 => KeyCode::Pause,
        0x039 => KeyCode::Space,
        0x00F => KeyCode::Tab,
        0x03A => KeyCode::CapsLock,
        0x145 => KeyCode::NumLock,
        0x046 => KeyCode::ScrollLock,
        0x03B => KeyCode::F1,
        0x03C => KeyCode::F2,
        0x03D => KeyCode::F3,
        0x03E => KeyCode::F4,
        0x03F => KeyCode::F5,
        0x040 => KeyCode::F6,
        0x041 => KeyCode::F7,
        0x042 => KeyCode::F8,
        0x043 => KeyCode::F9,
        0x044 => KeyCode::F10,
        0x057 => KeyCode::F11,
        0x058 => KeyCode::F12,
        0x064 => KeyCode::F13,
        0x065 => KeyCode::F14,
        0x066 => KeyCode::F15,
        0x067 => KeyCode::F16,
        0x068 => KeyCode::F17,
        0x069 => KeyCode::F18,
        0x06A => KeyCode::F19,
        0x06B => KeyCode::F20,
        0x06C => KeyCode::F21,
        0x06D => KeyCode::F22,
        0x06E => KeyCode::F23,
        0x076 => KeyCode::F24,
        0x038 => KeyCode::LeftAlt,
        0x01D => KeyCode::LeftControl,
        0x02A => KeyCode::LeftShift,
        0x15B => KeyCode::LeftSuper,
        0x137 => KeyCode::PrintScreen,
        0x138 => KeyCode::RightAlt,
        0x11D => KeyCode::RightControl,
        0x036 => KeyCode::RightShift,
        0x15C => KeyCode::RightSuper,
        0x150 => KeyCode::Down,
        0x14B => KeyCode::Left,
        0x14D => KeyCode::Right,
        0x148 => KeyCode::Up,
        0x052 => KeyCode::Kp0,
        0x04F => KeyCode::Kp1,
        0x050 => KeyCode::Kp2,
        0x051 => KeyCode::Kp3,
        0x04B => KeyCode::Kp4,
        0x04C => KeyCode::Kp5,
        0x04D => KeyCode::Kp6,
        0x047 => KeyCode::Kp7,
        0x048 => KeyCode::Kp8,
        0x049 => KeyCode::Kp9,
        0x04E => KeyCode::KpAdd,
        0x053 => KeyCode::KpDecimal,
        0x135 => KeyCode::KpDivide,
        0x11C => KeyCode::KpEnter,
        0x037 => KeyCode::KpMultiply,
        0x04A => KeyCode::KpSubtract,
        _ => KeyCode::Unknown,
    }
}
