/// What should the node do next?
#[derive(Debug)]
pub enum Action {
	Disconnect,
	SendData(Vec<u8>),
	Nothing,
}

/// Handles incoming connections to the server or client.
pub trait Handler: Sized {
	#[must_use]
	fn recv(&mut self, data: &[u8]) -> Action;

	/// Runs ~10 times per second, allowing the handler to send data out
	/// Returned bytes are sent immediately
	#[must_use]
	fn process(&mut self) -> Action;
}
