use crate::hostname::Hostname;
use kiss_tnc::errors::ReadError;

use thiserror::Error;

#[derive(Debug, Error)]
pub enum Error {
	#[error("Disconnected from #{0}")]
	Disconnected(Hostname),

	#[error("Read error: #{0}")]
	ReadError(#[from] ReadError),
}
