use minigrepsv1::Config;
use std::env;
use std::process;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}.", err);
        process::exit(1);
    });

    if let Err(e) = minigrepsv1::run(config) {
        eprintln!("Application error: {}", e);
        process::exit(1);
    }
}
