
use std::env;
use std::process;
use std::fs;
use minigrepss::Config;
/*
12.5
*/
//自定义迭代器实例
struct Counter
{
    count: u32,
}

impl Counter
{
    fn new() -> Counter
    {
        Counter { count: 0 }
    }
}
impl Iterator for Counter
{
    type Item = u32;

    fn next(&mut self) -> Option<Self::Item>
    {
        if self.count<5
        {
            self.count += 1;
            Some(self.count)
        }
        else
        {
            None
        }
    }
}


fn main() 
{
    //1 2 3 4 5    
    //2 3 4 5
    let sum: Vec<u32> = Counter::new()
    .zip(Counter::new().skip(1))
    .map(|(a,b)| a*b)
    .filter(|x| x%3==0).collect();
    //.sum();
    //assert_eq!(18,sum);
    println!("------------{:?}",sum);
    let args: Vec<String> = env::args().collect();

    let config = Config::new(&args).unwrap_or_else//unwrap_or_else定义于标准库的 Result<T, E> 上。使用 unwrap_or_else 可以进行一些自定义的非 panic! 的错误处理。
    (|err| //当 Result 是 Ok 时，这个方法的行为类似于 unwrap：它返回 Ok 内部封装的值。然而，当其值是 Err 时，该方法会调用一个 闭包
        {//传递给闭包中位于两道竖线间的参数 err//err闭包的参数
            println!("Problem parsing arguments: {}", err);
            process::exit(1);//终止程序运行
        }
    );
    //println!("Searching for {}", config.query);
    //println!("In file {}", config.filename);
    if let Err(e) = minigrepss::run(config)
    {
        println!("Application error: {}", e);

        process::exit(1);
    }


    //let args:Vec<String> = env::args().collect();//collect是一个经常需要注明类型的函数
    
    //let query = &args[1];
    //let filename = &args[2];
    //println!("Searching for {}",query);
    //println!("in file {}",filename);

    //let contents = fs::read_to_string(filename).expect("Something went wrong reading the file");
    //println!("With text:\n  {}",contents);


    //println!("{:?}",args);
}


