use std::error::Error;
use std::fs;



#[cfg(test)]
mod tests
{
    use super::*;
    #[test]
    fn calling_next_directly()
    {
        //let mut counter = Counter::new();

    }
    #[test]
    fn one_result()
    {
        let query = "duct";
        let contents = "\
        Rust:
        safe,fast,productive.
        Pick three.";
        //assert_eq!
        //(
            //vec!["safe,fast,productive."],
            //search(query,contents)
        //);
    }
}
pub struct ans
{
    hang_num: i32,
    content: String,
}
pub fn search(query:String,contents: String) -> Vec<ans>//不符合生命周期省略规则
{
    let mut results: Vec<ans> = Vec::new();
    let mut hang_num = 1;
    for line in contents.lines()
    {
        if line.contains(&query)
        {
            let ans1 =ans{
                hang_num: hang_num,
                content: line.to_string(),
            };
            results.push(ans1);
        }
        hang_num = hang_num + 1;
    }
    results
}


pub struct Config 
{
    pub query: String,
    pub filename: String,
}

impl Config 
{
    pub fn new(args: &[String]) -> Result<Config, &'static str> 
    {//返回值为Result时可以使用那些错误处理方式了
        // --snip--
        if args.len() < 3 
        {
            return Err("not enough arguments");
        }

        let query = args[1].clone();
        let filename = args[2].clone();

        Ok(Config { query, filename })
    
    }
}

pub fn run(config: Config) -> Result<(), Box<dyn Error>> 
{
    // --snip--
    println!("{}",config.filename);
    let contents = fs::read_to_string(config.filename)?;

    //println!("With text:\n{}", contents);
    for line in search(config.query, contents) 
    {
        println!("{}--{}", line.hang_num,line.content);
    }
    Ok(())
}
//自定义迭代器实例
struct Counter
{
    count: u32,
}

impl Counter
{
    fn new() -> Counter
    {
        Counter { count: 0 }
    }
}
impl Iterator for Counter
{
    type Item = u32;

    fn next(&mut self) -> Option<Self::Item>
    {
        if self.count<5
        {
            self.count += 1;
            Some(self.count)
        }
        else
        {
            None
        }
    }
}

