use core::fmt;
use std::option;


#[derive(PartialEq, Debug)]
pub struct Shoe {
    pub size: u32,
    pub style: String,
}

pub struct Counter {
    count: u32
}

impl Counter {
    pub fn new() -> Counter {
        Counter { count: 0}
    }
}

impl Iterator for Counter {
    type Item = u32;

    fn next(&mut self) -> Option<Self::Item> {
        self.count += 1;

        if self.count < 6 {
            Some(self.count)
        } else {
            None
        }
    }
}

pub fn shoe_in_my_size(shoes: Vec<Shoe>, shoe_size: u32) -> Vec<Shoe> {
    println!("size: {}", shoe_size);
    shoes.into_iter().filter(|s|s.size == shoe_size).collect()
}

#[test]
fn filters_by_size() {
    let shoes = vec![
        Shoe {size: 40, style: String::from("特步")},
        Shoe {size: 41, style: String::from("耐克")},
        Shoe {size: 40, style: String::from("安踏")},
    ];

    assert_eq!(shoe_in_my_size(shoes, 40), vec![
        Shoe {size:40, style:String::from("特步")},
        Shoe {size:40, style: String::from("安踏")},
    ])
}
#[test]
fn test_counter() {
    let mut c = Counter::new();
    assert_eq!(c.next(), Some(1));
    assert_eq!(c.next(), Some(2));
    assert_eq!(c.next(), Some(3));
    assert_eq!(c.next(), Some(4));
    assert_eq!(c.next(), Some(5));
    assert_eq!(c.next(), None);
}
#[test]
fn using_other_iterator_trait_methods() {
    let sum: u32 = Counter::new().zip(Counter::new().skip(1))
                            .map(|(a,b)| a * b)
                            .filter(|x| x % 3 == 0)
                            .sum();
    assert_eq!(18, sum);
}