//!
//! # 迭代
//! 这是一个`学习迭代`的包
//! 
//! 
/// 高级抽象
/// # Examples
/// ```
/// let arr = minigrep::example::iter::advanced_abstract();
/// 
/// assert_eq!(arr, [3,3,3,3,3]);
/// ```
pub fn advanced_abstract() -> [i32; 5] {
    let buffer: &mut [i32] = &mut [3; 10];
    let coefficients: [i64; 12] = [1; 12];
    let qlp_shift: i16 = 1;

    for i in 12..buffer.len() {
        let prediction = coefficients.iter()
                                        .zip(&buffer[i - 12.. i])
                                        .map(|(&c, &s)| c * s as i64)
                                        .sum::<i64>() >> qlp_shift;
        let delta = buffer[i];
        buffer[i] = prediction as i32 + delta;
    }
    [3; 5]
}

#[test]
fn test_advanced_abstract() {
    assert_eq!(advanced_abstract(), [3,3,3,3,3]);
}