use std::env;
use std::process;
use minigrep_rustbook::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    if let Err(e) = minigrep_rustbook::run(config) {
        eprint!("Application error: {}", e);
        process::exit(1);
    };
}
