

use std::env;
use std::{fs, process};

// use std::error::Error;
//
// struct Config {
//     query: String,
//     filename: String,
// }
// /*
// 提取参数解析过程到函数parse_config里
// 用元组结构获取query 和 filename 参数
// 将配置信息组织封装到一个struct里: 创建结构体，改造parse_config 和 let config =
// 将parse_config 函数 改成 Config struct的new函数
// 考虑 参数解析时可能的错误，比如参数数目不够时的处理，出错时panic
// 将错误处理放到调用方 让调用方去处理（返回错误Result）
// main中调用Config::new时处理错误
//
// 从main中提取逻辑，提取一个run函数，传入config，run函数打开读取文件打印出来
// 文件打开错误处理放到main中让调用时来处理，返回Result。（返回错误，main中处理错误）
//
//
//
// */
// impl Config {
//     pub fn new(args:&[String]) -> Result<Config,&str>{
//         if args.len() < 3{
//             // panic!("not enough argument received");
//             return Err("Not enough argument received")
//         }
//         let query = args[1].clone();
//         let filename = args[2].clone();
//         // Config{query,filename}
//         Ok(Config{query,filename})
//     }
// }
//
// fn run(config:Config) ->  Result<(),Box<dyn Error>>{
//     let contents = fs::read_to_string(config.filename)?;
//     println!("With Contents:\n{}", contents);
//     Ok(())
// }

use minigrep_refine;
use minigrep_refine::{Config,run};


fn main() {
    /* 获取命令行参数
    读取命令行参数并保存
    读取文件内容
    查询每行并保存匹配行
    显示匹配行

    错误处理放main里
     */
    // let args: Vec<String> = env::args().collect();
    // let config = Config::new(&args).unwrap_or_else(|error|{
    //     eprintln!("Parse arg error:{}",error);
    //     process::exit(1);
    // });
    // ============直接使用迭代器============
    // let args: Vec<String> = env::args().collect();
    let config = Config::new(env::args()).unwrap_or_else(|error|{
        eprintln!("Parse arg error:{}",error);
        process::exit(1);
    });
    
    
    println!("commandline args: {} {}", config.query, config.filename);
    if let Err(e) = run(config){
        eprintln!("Captured Error: {}",e);
        process::exit(1);
    }

}
// cargo run --package minigrep -- wewe fdsf.ext
// cargo run --package minigrep -- exeses minigrep\poem.txt
