use std::{env, process};

use minigrep_pbegle::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });
    println!("searching for {}", config.query);
    println!("in file {}", config.filename);

    if let Err(e) = minigrep_pbegle::run(config) {
        eprintln!("Application error: {}", e);

        process::exit(1);
    }
}
