use std::env;
use std::process;
use minigrep_onemelon::Config;

fn main() {
	let args: Vec<String> = env::args().collect();
	
	let config = Config::new(&args).unwrap_or_else(|err| {
		eprintln!("Problem parsing args: {}", err);
		process::exit(0);
	}); 
	
	println!("Searching for {}", config.query);

	if let Err(e) = minigrep_onemelon::run(config) {
		eprintln!("Application wrong: {}", e);
		process::exit(1);
	}	
}
