use std::{env, process};

use minigrep_learning::Config;

fn main() {
    // 当所需函数嵌套了多于一层模块时 通常将父模块引入作用域
    // std::env::args 在其任何参数包含无效 Unicode 字符时会 panic
    // 如果需要接受包含无效 Unicode 字符的参数 使用 std::env::args_os 代替
    // let args: Vec<String> = env::args().collect();
    // unwrap_or_else 使用闭包 如果返回的是Ok 相当于unwrap 如果返回的是Err 定义的 &'static str 会作为参数传递给 |err| 闭包的代码在运行时就可以使用这个值
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    // println!("Searching for {}", config.query);
    // println!("In file {}", config.file_name);

    // 无需返回值 所以不需要 unwrap_or_else 去处理封装的值
    if let Err(err) = minigrep_learning::run(config) {
        eprintln!("Application error:{}", err);
        process::exit(1);
    }
}

