//! # Art
//!
//! A library for modeling artistic concepts

/// 重导出 多余多层嵌套的mod 导出顶级结构 在其他文件中只需要引用顶级结构::mod即可
/// # Examples
/// use art::PrimaryKey;
///
pub use self::kinds::PrimaryColor;
pub use self::kinds::SecondaryColor;
pub use self::utils::mix;

pub mod kinds {
    /// The primary color according to the RYB color model.
    pub enum PrimaryColor {
        Red,
        Yellow,
        Blue,
    }

    /// The secondary colors according to the RYB color model.
    pub enum SecondaryColor {
        Orange,
        Green,
        Purple,
    }
}

pub mod utils {
    use crate::art::kinds::*;

    /// Combines two primary colors in equal amounts to create
    /// a secondary colorl
    pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> SecondaryColor { SecondaryColor::Orange }
}


#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
