use std::{env, process};

use minigrep_iaziz786::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("problem parsing arguments: {}", err);
        process::exit(1);
    });

    if let Err(err) = minigrep_iaziz786::run(config) {
        eprintln!("application error: {}", err);
        process::exit(1);
    }
}
