use std::env;
use std::process;
use minigrep_gdsgd::Config;

fn main() {
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    if let Err(_) = minigrep_gdsgd::run(config) {
        process::exit(1);
    }
}


