use minigrep_cascades::{run, Config};
use std::{env, process};

fn main() {
    // get command line arguments
    let config = Config::new(env::args()).unwrap_or_else(|err| {
        // print error info to stderr
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });
    if let Err(err) = run(config) {
        eprintln!("Problem run: {}", err);
        process::exit(1);
    }
}
