use std::env;
use std::process;
use minigrep_by_abhi::Config;

fn main() {

    let config = Config::new(env::args()).unwrap_or_else(|err| {
        eprintln!("Problem parsing arguments: {}", err);
        process::exit(1);
    });

    println!("Searching for {}", config.query);
    println!("In file {}", config.filename);

    if let Err(e) = minigrep_by_abhi::run(config) {
        eprintln!("application err : {}",e);
        process::exit(1);
    }
}

