use std::{fs,error::Error,env};



  pub fn run(filename:&str)->Result<(),Box<dyn Error>>{
    let contents = fs::read_to_string(filename)?;
  
    println!("With text:\n{}",contents);
  
    Ok(())
  }
  
  pub struct Config {
    pub query:String,

    pub filename:String,

    pub case_sensitive:bool,
  }
  
  impl Config {
    pub fn new(mut args:std::env::Args)-> Result<Config,&'static str>{
  
      args.next();
  
      let query = match args.next() {
          Some(arg)=>arg,
          None =>  return Err("Didn't get a query string"),
      };
  
      let filename = match args.next() {
        Some(arg)=>arg,
        None =>  return Err("Didn't get a query string"),
      };

      let case_sensitive = env::var("CASE_INSENSITIVE").is_err();

      Ok(Config{
        query,filename,case_sensitive,
      })
    }
  }



