# minifemme

[![crates.io version][1]][2] [![docs.rs docs][3]][4]

Rust log-compatible pretty/ndjson logger, based on [femme][5].

A pretty-printer and [ndjson](http://ndjson.org/) logger for the [log](https://docs.rs/log) crate.

- [Documentation][4]
- [Crates.io][2]

## Examples

```rust
minifemme::start(minifemme::LevelFilter::Trace, minifemme::LogMode::Pretty);
log::warn!("Unauthorized access attempt on /login");
log::info!("Listening on port 8080");
```

The main reason behind this crate's existence is that I needed something that works
almost like `femme`, but with the ability to arbitrarily select the log mode.

When using Wasm with `#[cfg(target_arch = "wasm32")]`, the Wasm logger will be used.
The Wasm logger uses `web_sys` crate to send `console.log()` to JavaScript.

## Screenshots

### Pretty Output

<img src="https://git.sr.ht/~ana/minifemme/blob/master/pretty.png" alt="pretty printed logs"/>

### Newline Delimited JSON

<img src="https://git.sr.ht/~ana/minifemme/blob/master/ndjson.png" alt="ndjson"/>

## Installation

```sh
$ cargo add minifemme
```

## License

[MIT](./LICENSE-MIT) OR [Apache-2.0](./LICENSE-APACHE)

[1]: https://img.shields.io/crates/v/minifemme.svg?style=flat-square
[2]: https://crates.io/crates/minifemme
[3]: https://img.shields.io/badge/docs-latest-blue.svg?style=flat-square
[4]: https://docs.rs/minifemme
[5]: https://github.com/lrlna/femme
