use crate::key::Key;
pub const BACKSPACE: &'static str = "Backspace";
pub const TAB: &'static str = "Tab";
pub const ENTER: &'static str = "Enter";
pub const SHIFT_LEFT: &'static str = "ShiftLeft";
pub const SHIFT_RIGHT: &'static str = "ShiftRight";
pub const CONTROL_LEFT: &'static str = "ControlLeft";
pub const CONTROL_RIGHT: &'static str = "ControlRight";
pub const ALT_LEFT: &'static str = "AltLeft";
pub const ALT_RIGHT: &'static str = "AltRight";
pub const PAUSE: &'static str = "Pause";
pub const CAPS_LOCK: &'static str = "CapsLock";
pub const ESCAPE: &'static str = "Escape";
pub const SPACE: &'static str = "Space";
pub const PAGE_UP: &'static str = "PageUp";
pub const PAGE_DOWN: &'static str = "PageDown";
pub const END: &'static str = "End";
pub const HOME: &'static str = "Home";
pub const ARROW_LEFT: &'static str = "ArrowLeft";
pub const ARROW_UP: &'static str = "ArrowUp";
pub const ARROW_RIGHT: &'static str = "ArrowRight";
pub const ARROW_DOWN: &'static str = "ArrowDown";
//pub const PRINT_SCREEN: &'static str = "PrintScreen";
pub const INSERT: &'static str = "Insert";
pub const DELETE: &'static str = "Delete";
pub const DIGIT_0: &'static str = "Digit0";
pub const DIGIT_1: &'static str = "Digit1";
pub const DIGIT_2: &'static str = "Digit2";
pub const DIGIT_3: &'static str = "Digit3";
pub const DIGIT_4: &'static str = "Digit4";
pub const DIGIT_5: &'static str = "Digit5";
pub const DIGIT_6: &'static str = "Digit6";
pub const DIGIT_7: &'static str = "Digit7";
pub const DIGIT_8: &'static str = "Digit8";
pub const DIGIT_9: &'static str = "Digit9";
pub const KEY_A: &'static str = "KeyA";
pub const KEY_B: &'static str = "KeyB";
pub const KEY_C: &'static str = "KeyC";
pub const KEY_D: &'static str = "KeyD";
pub const KEY_E: &'static str = "KeyE";
pub const KEY_F: &'static str = "KeyF";
pub const KEY_G: &'static str = "KeyG";
pub const KEY_H: &'static str = "KeyH";
pub const KEY_I: &'static str = "KeyI";
pub const KEY_J: &'static str = "KeyJ";
pub const KEY_K: &'static str = "KeyK";
pub const KEY_L: &'static str = "KeyL";
pub const KEY_M: &'static str = "KeyM";
pub const KEY_N: &'static str = "KeyN";
pub const KEY_O: &'static str = "KeyO";
pub const KEY_P: &'static str = "KeyP";
pub const KEY_Q: &'static str = "KeyQ";
pub const KEY_R: &'static str = "KeyR";
pub const KEY_S: &'static str = "KeyS";
pub const KEY_T: &'static str = "KeyT";
pub const KEY_U: &'static str = "KeyU";
pub const KEY_V: &'static str = "KeyV";
pub const KEY_W: &'static str = "KeyW";
pub const KEY_X: &'static str = "KeyX";
pub const KEY_Y: &'static str = "KeyY";
pub const KEY_Z: &'static str = "KeyZ";
//pub const META_LEFT: &'static str = "MetaLeft";
//pub const META_RIGHT: &'static str = "MetaRight";
//pub const CONTEXT_MENU: &'static str = "ContextMenu";
pub const NUMPAD_0: &'static str = "Numpad0";
pub const NUMPAD_1: &'static str = "Numpad1";
pub const NUMPAD_2: &'static str = "Numpad2";
pub const NUMPAD_3: &'static str = "Numpad3";
pub const NUMPAD_4: &'static str = "Numpad4";
pub const NUMPAD_5: &'static str = "Numpad5";
pub const NUMPAD_6: &'static str = "Numpad6";
pub const NUMPAD_7: &'static str = "Numpad7";
pub const NUMPAD_8: &'static str = "Numpad8";
pub const NUMPAD_9: &'static str = "Numpad9";
pub const NUMPAD_MULTIPLY: &'static str = "NumpadMultiply";
pub const NUMPAD_ADD: &'static str = "NumpadAdd";
pub const NUMPAD_SUBTRACT: &'static str = "NumpadSubtract";
pub const NUMPAD_DECIMAL: &'static str = "NumpadDecimal";
pub const NUMPAD_DIVIDE: &'static str = "NumpadDivide";
pub const F1: &'static str = "F1";
pub const F2: &'static str = "F2";
pub const F3: &'static str = "F3";
pub const F4: &'static str = "F4";
pub const F5: &'static str = "F5";
pub const F6: &'static str = "F6";
pub const F7: &'static str = "F7";
pub const F8: &'static str = "F8";
pub const F9: &'static str = "F9";
pub const F10: &'static str = "F10";
pub const F11: &'static str = "F11";
pub const F12: &'static str = "F12";
pub const NUM_LOCK: &'static str = "NumLock";
pub const SCROLL_LOCK: &'static str = "ScrollLock";
//pub const VOLUME_MUTE: &'static str = "VolumeMute";
//pub const VOLUME_DOWN: &'static str = "VolumeDown";
//pub const VOLUME_UP: &'static str = "VolumeUp";
//pub const MEDIA_SELECT: &'static str = "MediaSelect";
//pub const LAUNCH_APP1: &'static str = "LaunchApp1";
//pub const LAUNCH_APP2: &'static str = "LaunchApp2";
pub const SEMICOLON: &'static str = "Semicolon";
pub const EQUAL: &'static str = "Equal";
pub const COMMA: &'static str = "Comma";
pub const MINUS: &'static str = "Minus";
pub const PERIOD: &'static str = "Period";
pub const SLASH: &'static str = "Slash";
pub const BACKQUOTE: &'static str = "Backquote";
pub const BRACKET_LEFT: &'static str = "BracketLeft";
pub const BACKSLASH: &'static str = "Backslash";
pub const BRACKET_RIGHT: &'static str = "BracketRight";
pub const QUOTE: &'static str = "Quote";

pub fn event_to_key(event: &web_sys::KeyboardEvent) -> Key {
    match event.code().as_str() {
        BACKSPACE => Key::Backspace,
        TAB => Key::Tab,
        ENTER => Key::Enter,
        SHIFT_LEFT => Key::LeftShift,
        SHIFT_RIGHT => Key::RightShift,
        CONTROL_LEFT => Key::LeftCtrl,
        CONTROL_RIGHT => Key::RightCtrl,
        ALT_LEFT => Key::LeftAlt,
        ALT_RIGHT => Key::RightAlt,
        PAUSE => Key::Pause,
        CAPS_LOCK => Key::CapsLock,
        ESCAPE => Key::Escape,
        SPACE => Key::Space,
        PAGE_UP => Key::PageUp,
        PAGE_DOWN => Key::PageDown,
        END => Key::End,
        HOME => Key::Home,
        ARROW_LEFT => Key::Left,
        ARROW_UP => Key::Up,
        ARROW_RIGHT => Key::Right,
        ARROW_DOWN => Key::Down,
        INSERT => Key::Insert,
        DELETE => Key::Delete,
        DIGIT_0 => Key::Key0,
        DIGIT_1 => Key::Key1,
        DIGIT_2 => Key::Key2,
        DIGIT_3 => Key::Key3,
        DIGIT_4 => Key::Key4,
        DIGIT_5 => Key::Key5,
        DIGIT_6 => Key::Key6,
        DIGIT_7 => Key::Key7,
        DIGIT_8 => Key::Key8,
        DIGIT_9 => Key::Key9,
        KEY_A => Key::A,
        KEY_B => Key::B,
        KEY_C => Key::C,
        KEY_D => Key::D,
        KEY_E => Key::E,
        KEY_F => Key::F,
        KEY_G => Key::G,
        KEY_H => Key::H,
        KEY_I => Key::I,
        KEY_J => Key::J,
        KEY_K => Key::K,
        KEY_L => Key::L,
        KEY_M => Key::M,
        KEY_N => Key::N,
        KEY_O => Key::O,
        KEY_P => Key::P,
        KEY_Q => Key::Q,
        KEY_R => Key::R,
        KEY_S => Key::S,
        KEY_T => Key::T,
        KEY_U => Key::U,
        KEY_V => Key::V,
        KEY_W => Key::W,
        KEY_X => Key::X,
        KEY_Y => Key::Y,
        KEY_Z => Key::Z,
        NUMPAD_0 => Key::NumPad0,
        NUMPAD_1 => Key::NumPad1,
        NUMPAD_2 => Key::NumPad2,
        NUMPAD_3 => Key::NumPad3,
        NUMPAD_4 => Key::NumPad4,
        NUMPAD_5 => Key::NumPad5,
        NUMPAD_6 => Key::NumPad6,
        NUMPAD_7 => Key::NumPad7,
        NUMPAD_8 => Key::NumPad8,
        NUMPAD_9 => Key::NumPad9,
        NUMPAD_MULTIPLY => Key::NumPadAsterisk,
        NUMPAD_ADD => Key::NumPadPlus,
        NUMPAD_SUBTRACT => Key::NumPadMinus,
        NUMPAD_DECIMAL => Key::NumPadDot,
        NUMPAD_DIVIDE => Key::NumPadSlash,
        F1 => Key::F1,
        F2 => Key::F2,
        F3 => Key::F3,
        F4 => Key::F4,
        F5 => Key::F5,
        F6 => Key::F6,
        F7 => Key::F7,
        F8 => Key::F8,
        F9 => Key::F9,
        F10 => Key::F10,
        F11 => Key::F11,
        F12 => Key::F12,
        NUM_LOCK => Key::NumLock,
        SCROLL_LOCK => Key::ScrollLock,
        SEMICOLON => Key::Semicolon,
        EQUAL => Key::Equal,
        COMMA => Key::Comma,
        MINUS => Key::Minus,
        PERIOD => Key::Period,
        SLASH => Key::Slash,
        BACKQUOTE => Key::Backquote,
        BRACKET_LEFT => Key::LeftBracket,
        BACKSLASH => Key::Backslash,
        BRACKET_RIGHT => Key::RightBracket,
        QUOTE => Key::Apostrophe,
        _ => {
            /*
            PRINT_SCREEN=> Key::PrintScreen,
            META_LEFT=> Key::MetaLeft,
            META_RIGHT=> Key::MetaRight,
            CONTEXT_MENU=> Key::ContextMenu,
            VOLUME_MUTE=> Key::VolumeMute,
            VOLUME_DOWN=> Key::VolumeDown,
            VOLUME_UP=> Key::VolumeUp,
            MEDIA_SELECT=> Key::MediaSelect,
            LAUNCH_APP1=> Key::LaunchApp1,
            LAUNCH_APP2=> Key::LaunchApp2,
            */
            // ignore other keys
            Key::Unknown
        }
    }
}
