#[cfg(target_os = "linux")]
use std::convert::TryFrom;
#[cfg(target_os = "windows")]
use std::str::FromStr;

use minifb::{Icon, Key, Window, WindowOptions};

fn main() {
    let mut window = Window::new(
        "Window Icon Test - Press ESC to exit",
        300,
        300,
        WindowOptions {
            resize: true,
            ..WindowOptions::default()
        },
    )
    .expect("Unable to open Window");

    #[cfg(target_os = "windows")]
    window.set_icon(Icon::from_str("resources/icon256.ico").unwrap());

    #[cfg(target_os = "linux")]
    {
        let test: [u64; 1284] = [
            16, 16, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 338034905, 3657433343, 0, 184483840, 234881279, 3053453567,
            3221225727, 1879048447, 0, 0, 0, 0, 0, 0, 0, 1224737023, 3305111807, 3875537151, 0, 0,
            2063597823, 1291845887, 0, 67109119, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 50266112, 3422552319, 0, 0, 3070230783,
            2063597823, 2986344703, 771752191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3422552319, 0, 0,
            3372220671, 1509949695, 704643327, 3355443455, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 0, 3422552319, 0,
            134152192, 3187671295, 251658495, 0, 3439329535, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3422552319,
            0, 0, 2332033279, 1342177535, 167772415, 3338666239, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 0, 3422552319,
            0, 0, 436207871, 3322085628, 3456106751, 1375731967, 4278255360, 4026597120,
            3758161664, 3489726208, 3204513536, 2952855296, 2684419840, 2399207168, 2130771712,
            1845559040, 1593900800, 1308688128, 1040252672, 755040000, 486604544, 234946304,
            4278255360, 4043374336, 3774938880, 3506503424, 3221290752, 2952855296, 2667642624,
            2399207168, 2130771712, 1862336256, 1627453957, 1359017481, 1073805064, 788591627,
            503379721, 218169088, 4278255360, 4043374336, 3758161664, 3506503424, 3221290752,
            2952855296, 2684419840, 2415984384, 2130771712, 1862336256, 1577123584, 1308688128,
            1040252672, 755040000, 486604544, 218169088, 4278190335, 4026532095, 3758096639,
            3489661183, 3221225727, 2952790271, 2667577599, 2415919359, 2130706687, 1862271231,
            1593835775, 1325400319, 1056964863, 771752191, 520093951, 234881279, 4278190335,
            4026532095, 3758096639, 3489661183, 3221225727, 2952790271, 2667577599, 2415919359,
            2130706687, 1862271231, 1593835775, 1325400319, 1056964863, 771752191, 503316735,
            234881279, 4278190335, 4026532095, 3758096639, 3489661183, 3221225727, 2952790271,
            2684354815, 2399142143, 2130706687, 1862271231, 1593835775, 1325400319, 1040187647,
            771752191, 520093951, 234881279, 4294901760, 4043243520, 3774808064, 3506372608,
            3221159936, 2952724480, 2684289024, 2399076352, 2147418112, 1862205440, 1593769984,
            1308557312, 1040121856, 771686400, 503250944, 234815488, 4294901760, 4060020736,
            3758030848, 3506372608, 3221159936, 2952724480, 2684289024, 2415853568, 2130640896,
            1862205440, 1593769984, 1308557312, 1040121856, 771686400, 503250944, 234815488,
            4294901760, 4043243520, 3774808064, 3489595392, 3237937152, 2952724480, 2684289024,
            2415853568, 2147418112, 1862205440, 1593769984, 1325334528, 1056899072, 788463616,
            503250944, 234815488, 32, 32, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            268369920, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 1509949695, 3120562431,
            4009754879, 4194304255, 3690987775, 2130706687, 83886335, 0, 50331903, 1694499071,
            3170894079, 3992977663, 4211081471, 3657433343, 1879048447, 16777471, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3087007999, 2281701631, 1191182591, 1040187647,
            2030043391, 4127195391, 2566914303, 0, 16777471, 3254780159, 2181038335, 1191182591,
            973078783, 2030043391, 4177527039, 2130706687, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 0, 0, 0, 0, 0,
            2214592767, 4093640959, 0, 0, 0, 0, 0, 0, 0, 2298478847, 3909091583, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2214592767, 3607101695, 0, 0, 0, 0, 0, 0,
            0, 1946157311, 4093640959, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 0, 0, 536871167, 1191182591,
            2281701631, 3019899135, 637534463, 0, 0, 0, 100597760, 251592704, 33488896, 0,
            3321889023, 2919235839, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            2550137087, 4278190335, 4278190335, 3405775103, 570425599, 0, 0, 0, 0, 0, 0,
            2046820607, 4043309311, 620757247, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 33488896, 0, 0, 218104063,
            1291845887, 3841982719, 3388997887, 0, 0, 0, 0, 0, 1996488959, 4093640959, 1073742079,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1761607935,
            4278190335, 150995199, 0, 0, 67109119, 2550137087, 3909091583, 889192703, 0, 0,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 0, 0, 0, 0, 0, 2181038335, 3925868799, 0, 0, 218104063,
            3070230783, 3623878911, 570425599, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 805306623, 3288334591, 1795162367, 1040187647, 1023410431, 2231369983, 4211081471,
            1694499071, 0, 369099007, 3456106751, 3825205503, 1174405375, 872415487, 872415487,
            872415487, 872415487, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4293984270, 2046951677, 3422552319, 4110418175,
            4177527039, 3405775103, 1409286399, 0, 0, 1409286399, 4278190335, 4278190335,
            4278190335, 4278190335, 4278190335, 4278190335, 4278190335, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760, 4294901760,
            4294901760, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            4278255360, 4144037632, 4009819904, 3875602176, 3741384448, 3607166720, 3472948992,
            3338731264, 3204513536, 3053518592, 2936078080, 2801860352, 2650865408, 2516647680,
            2382429952, 2264989440, 2113994496, 1996553984, 1862336256, 1728118528, 1577123584,
            1459683072, 1325465344, 1191247616, 1040252672, 922812160, 771817216, 637599488,
            503381760, 385941248, 234946304, 100728576, 4278255360, 4144037632, 4009819904,
            3875602176, 3724607232, 3607166720, 3472948992, 3338731264, 3204513536, 3070295808,
            2936078080, 2801860352, 2667642624, 2516647680, 2399207168, 2264989440, 2130771712,
            1996553984, 1845559040, 1728118528, 1593900800, 1459683072, 1308688128, 1191247616,
            1057029888, 922812160, 788594432, 637599488, 503381760, 369164032, 234946304,
            117505792, 4278255360, 4144037632, 4009819904, 3875602176, 3741384448, 3607166720,
            3472948992, 3338731264, 3204513536, 3053518592, 2919300864, 2801860352, 2650865408,
            2533424896, 2399207168, 2264989440, 2113994496, 1996553984, 1862336256, 1728118528,
            1593900800, 1459683072, 1325465344, 1191247616, 1040252672, 906034944, 771817216,
            654376704, 503381760, 369164032, 234946304, 117505792, 4278255360, 4144037632,
            4009819904, 3858824960, 3741384448, 3607166720, 3472948992, 3338731264, 3204513536,
            3070295808, 2936078080, 2801860352, 2667642624, 2533424896, 2382429952, 2264989440,
            2130771712, 1979776768, 1862336256, 1728118528, 1577123584, 1442905856, 1325465344,
            1191247616, 1040252672, 922812160, 771817216, 637599488, 503381760, 369164032,
            234946304, 100728576, 4278255360, 4144037632, 4009819904, 3875602176, 3741384448,
            3607166720, 3472948992, 3338731264, 3204513536, 3070295808, 2919300864, 2801860352,
            2667642624, 2533424896, 2399207168, 2264989440, 2113994496, 1996553984, 1862336256,
            1728118528, 1593900800, 1442905856, 1342241795, 1174470400, 1057029888, 906034944,
            788594432, 654376704, 503381760, 385941248, 251723520, 100728576, 4278190335,
            4160749823, 4026532095, 3892314367, 3741319423, 3623878911, 3472883967, 3338666239,
            3221225727, 3070230783, 2952790271, 2818572543, 2667577599, 2533359871, 2399142143,
            2264924415, 2147483903, 1996488959, 1862271231, 1728053503, 1593835775, 1459618047,
            1325400319, 1191182591, 1056964863, 922747135, 788529407, 654311679, 520093951,
            385876223, 251658495, 117440767, 4278190335, 4160749823, 4026532095, 3892314367,
            3741319423, 3623878911, 3489661183, 3355443455, 3221225727, 3087007999, 2936013055,
            2801795327, 2667577599, 2533359871, 2399142143, 2281701631, 2130706687, 1996488959,
            1862271231, 1728053503, 1593835775, 1459618047, 1325400319, 1191182591, 1056964863,
            922747135, 788529407, 654311679, 520093951, 385876223, 234881279, 100663551,
            4278190335, 4160749823, 4026532095, 3892314367, 3758096639, 3623878911, 3489661183,
            3355443455, 3221225727, 3087007999, 2936013055, 2801795327, 2667577599, 2550137087,
            2415919359, 2264924415, 2130706687, 1996488959, 1862271231, 1728053503, 1593835775,
            1459618047, 1325400319, 1191182591, 1056964863, 922747135, 788529407, 654311679,
            503316735, 369099007, 251658495, 100663551, 4278190335, 4160749823, 4026532095,
            3892314367, 3758096639, 3623878911, 3489661183, 3355443455, 3204448511, 3087007999,
            2936013055, 2818572543, 2667577599, 2533359871, 2399142143, 2264924415, 2130706687,
            1996488959, 1879048447, 1728053503, 1593835775, 1459618047, 1325400319, 1191182591,
            1056964863, 922747135, 788529407, 654311679, 520093951, 385876223, 251658495,
            117440767, 4278190335, 4160749823, 4026532095, 3892314367, 3758096639, 3623878911,
            3489661183, 3355443455, 3221225727, 3087007999, 2952790271, 2818572543, 2667577599,
            2533359871, 2399142143, 2264924415, 2147483903, 2013266175, 1862271231, 1744830719,
            1610612991, 1476395263, 1342177535, 1191182591, 1056964863, 922747135, 788529407,
            654311679, 520093951, 385876223, 251658495, 100663551, 4294901760, 4160684032,
            4026466304, 3909025792, 3774808064, 3623813120, 3489595392, 3355377664, 3237937152,
            3103719424, 2952724480, 2818506752, 2684289024, 2550071296, 2415853568, 2281635840,
            2147418112, 2013200384, 1878982656, 1744764928, 1593769984, 1476329472, 1325334528,
            1207894016, 1056899072, 939458560, 788463616, 654245888, 520028160, 385810432,
            251592704, 117374976, 4294901760, 4177461248, 4043243520, 3909025792, 3774808064,
            3640590336, 3506372608, 3355377664, 3221159936, 3086942208, 2952724480, 2818506752,
            2701066240, 2550071296, 2415853568, 2281635840, 2147418112, 2013200384, 1878982656,
            1727987712, 1610547200, 1476329472, 1325334528, 1191116800, 1073676288, 922681344,
            788463616, 654245888, 520028160, 385810432, 251592704, 100597760, 4294901760,
            4177461248, 4043243520, 3909025792, 3774808064, 3640590336, 3489595392, 3372154880,
            3237937152, 3103719424, 2952724480, 2818506752, 2700935170, 2550071296, 2415853568,
            2281635840, 2147418112, 2013200384, 1878982656, 1744764928, 1610547200, 1459552256,
            1342111744, 1191116800, 1056899072, 922681344, 788463616, 671023104, 520028160,
            385810432, 251592704, 100597760, 4294901760, 4177461248, 4043243520, 3909025792,
            3774808064, 3640590336, 3489595392, 3372154880, 3237937152, 3086942208, 2969501696,
            2818506752, 2684289024, 2550071296, 2432630784, 2281635840, 2147418112, 2013200384,
            1862205440, 1744764928, 1610547200, 1476329472, 1342111744, 1191116800, 1056899072,
            922681344, 788463616, 654245888, 520028160, 385810432, 251592704, 117374976,
            4294901760, 4177461248, 4043243520, 3909025792, 3774808064, 3623813120, 3506372608,
            3372154880, 3237937152, 3103719424, 2952724480, 2835283968, 2684289024, 2550071296,
            2432630784, 2281635840, 2147418112, 2046492676, 1862205440, 1744764928, 1610547200,
            1476329472, 1342111744, 1207894016, 1056899072, 939458560, 788463616, 654245888,
            536281096, 385810432, 251592704, 134152192,
        ];
        window.set_icon(Icon::try_from(&test[..]).unwrap());
    }

    while window.is_open() && !window.is_key_down(Key::Escape) {
        window.update();
    }
}
