# min_gl

---

This is a small library that brings together **glfw** and **glad** to handle
boilerplate code. The user only needs to create a `Display`, which initializes
and terminates necessary stuff as a smart pointer. Hence, in the lifetime of the
`Display`, **OpenGL** calls can be freely made without any other setup.

---

## Example

```rust
use glfw::WindowEvent;
use min_gl::{gl, Display, Options};

fn main() {
    // Assume this is some application state.
    let mut event_count = 0u32;

    // Just create and done!
    // All library initialization and window creation is handled.
    // They panic if an error occurs.
    let mut disp = Display::new(
        // No defaults; you cannot miss anything!
        Options {
            width: 1280,
            height: 720,
            title: "Display Test".into(),
            fullscreen: false,
            decorated: true,
            samples: 16,
            vsync: true,
        },
        // WindowEvent handling...
        |event| {
            event_count += 1; // Closure can modify state (FnMut).

            match event {
                WindowEvent::Key(k, _, a, _) => println!("Key `{:?}` is {:?}ed!", k, a),
                e => println!("Some {:?} happened!", e),
            }
        },
    );

    // Of course, you can go with more complicated main loops.
    while !disp.get_window().should_close() {
        // All window events...
        disp.update();

        /* ~~~~ drawing start ~~~~ */

        gl::ClearColor(0.7, 0.5, 0.6, 1.0);

        /* ~~~~ drawing end ~~~~ */

        disp.render();
    }

    // No clean up; thanks to idomatic glfw-rs!
    // OpenGL calls are not valid after `disp` is dropped!
    println!("In total {} window events happened!", event_count);
}
```

---

**Glad 2** was used with the fallowing options on _16.02.2022_:

- Generator: Rust
- APIs: gl; Version 4.6 Core
- Extensions: All
- Options: None

[Perma Link](https://gen.glad.sh/#generator=rust&api=gl%3D4.6&profile=gl%3Dcore%2Cgles1%3Dcommon&extensions=GL_3DFX_multisample%2CGL_3DFX_tbuffer%2CGL_3DFX_texture_compression_FXT1%2CGL_AMD_blend_minmax_factor%2CGL_AMD_conservative_depth%2CGL_AMD_debug_output%2CGL_AMD_depth_clamp_separate%2CGL_AMD_draw_buffers_blend%2CGL_AMD_framebuffer_multisample_advanced%2CGL_AMD_framebuffer_sample_positions%2CGL_AMD_gcn_shader%2CGL_AMD_gpu_shader_half_float%2CGL_AMD_gpu_shader_int16%2CGL_AMD_gpu_shader_int64%2CGL_AMD_interleaved_elements%2CGL_AMD_multi_draw_indirect%2CGL_AMD_name_gen_delete%2CGL_AMD_occlusion_query_event%2CGL_AMD_performance_monitor%2CGL_AMD_pinned_memory%2CGL_AMD_query_buffer_object%2CGL_AMD_sample_positions%2CGL_AMD_seamless_cubemap_per_texture%2CGL_AMD_shader_atomic_counter_ops%2CGL_AMD_shader_ballot%2CGL_AMD_shader_explicit_vertex_parameter%2CGL_AMD_shader_gpu_shader_half_float_fetch%2CGL_AMD_shader_image_load_store_lod%2CGL_AMD_shader_stencil_export%2CGL_AMD_shader_trinary_minmax%2CGL_AMD_sparse_texture%2CGL_AMD_stencil_operation_extended%2CGL_AMD_texture_gather_bias_lod%2CGL_AMD_texture_texture4%2CGL_AMD_transform_feedback3_lines_triangles%2CGL_AMD_transform_feedback4%2CGL_AMD_vertex_shader_layer%2CGL_AMD_vertex_shader_tessellator%2CGL_AMD_vertex_shader_viewport_index%2CGL_APPLE_aux_depth_stencil%2CGL_APPLE_client_storage%2CGL_APPLE_element_array%2CGL_APPLE_fence%2CGL_APPLE_float_pixels%2CGL_APPLE_flush_buffer_range%2CGL_APPLE_object_purgeable%2CGL_APPLE_rgb_422%2CGL_APPLE_row_bytes%2CGL_APPLE_specular_vector%2CGL_APPLE_texture_range%2CGL_APPLE_transform_hint%2CGL_APPLE_vertex_array_object%2CGL_APPLE_vertex_array_range%2CGL_APPLE_vertex_program_evaluators%2CGL_APPLE_ycbcr_422%2CGL_ARB_ES2_compatibility%2CGL_ARB_ES3_1_compatibility%2CGL_ARB_ES3_2_compatibility%2CGL_ARB_ES3_compatibility%2CGL_ARB_arrays_of_arrays%2CGL_ARB_base_instance%2CGL_ARB_bindless_texture%2CGL_ARB_blend_func_extended%2CGL_ARB_buffer_storage%2CGL_ARB_cl_event%2CGL_ARB_clear_buffer_object%2CGL_ARB_clear_texture%2CGL_ARB_clip_control%2CGL_ARB_color_buffer_float%2CGL_ARB_compatibility%2CGL_ARB_compressed_texture_pixel_storage%2CGL_ARB_compute_shader%2CGL_ARB_compute_variable_group_size%2CGL_ARB_conditional_render_inverted%2CGL_ARB_conservative_depth%2CGL_ARB_copy_buffer%2CGL_ARB_copy_image%2CGL_ARB_cull_distance%2CGL_ARB_debug_output%2CGL_ARB_depth_buffer_float%2CGL_ARB_depth_clamp%2CGL_ARB_depth_texture%2CGL_ARB_derivative_control%2CGL_ARB_direct_state_access%2CGL_ARB_draw_buffers%2CGL_ARB_draw_buffers_blend%2CGL_ARB_draw_elements_base_vertex%2CGL_ARB_draw_indirect%2CGL_ARB_draw_instanced%2CGL_ARB_enhanced_layouts%2CGL_ARB_explicit_attrib_location%2CGL_ARB_explicit_uniform_location%2CGL_ARB_fragment_coord_conventions%2CGL_ARB_fragment_layer_viewport%2CGL_ARB_fragment_program%2CGL_ARB_fragment_program_shadow%2CGL_ARB_fragment_shader%2CGL_ARB_fragment_shader_interlock%2CGL_ARB_framebuffer_no_attachments%2CGL_ARB_framebuffer_object%2CGL_ARB_framebuffer_sRGB%2CGL_ARB_geometry_shader4%2CGL_ARB_get_program_binary%2CGL_ARB_get_texture_sub_image%2CGL_ARB_gl_spirv%2CGL_ARB_gpu_shader5%2CGL_ARB_gpu_shader_fp64%2CGL_ARB_gpu_shader_int64%2CGL_ARB_half_float_pixel%2CGL_ARB_half_float_vertex%2CGL_ARB_imaging%2CGL_ARB_indirect_parameters%2CGL_ARB_instanced_arrays%2CGL_ARB_internalformat_query%2CGL_ARB_internalformat_query2%2CGL_ARB_invalidate_subdata%2CGL_ARB_map_buffer_alignment%2CGL_ARB_map_buffer_range%2CGL_ARB_matrix_palette%2CGL_ARB_multi_bind%2CGL_ARB_multi_draw_indirect%2CGL_ARB_multisample%2CGL_ARB_multitexture%2CGL_ARB_occlusion_query%2CGL_ARB_occlusion_query2%2CGL_ARB_parallel_shader_compile%2CGL_ARB_pipeline_statistics_query%2CGL_ARB_pixel_buffer_object%2CGL_ARB_point_parameters%2CGL_ARB_point_sprite%2CGL_ARB_polygon_offset_clamp%2CGL_ARB_post_depth_coverage%2CGL_ARB_program_interface_query%2CGL_ARB_provoking_vertex%2CGL_ARB_query_buffer_object%2CGL_ARB_robust_buffer_access_behavior%2CGL_ARB_robustness%2CGL_ARB_robustness_isolation%2CGL_ARB_sample_locations%2CGL_ARB_sample_shading%2CGL_ARB_sampler_objects%2CGL_ARB_seamless_cube_map%2CGL_ARB_seamless_cubemap_per_texture%2CGL_ARB_separate_shader_objects%2CGL_ARB_shader_atomic_counter_ops%2CGL_ARB_shader_atomic_counters%2CGL_ARB_shader_ballot%2CGL_ARB_shader_bit_encoding%2CGL_ARB_shader_clock%2CGL_ARB_shader_draw_parameters%2CGL_ARB_shader_group_vote%2CGL_ARB_shader_image_load_store%2CGL_ARB_shader_image_size%2CGL_ARB_shader_objects%2CGL_ARB_shader_precision%2CGL_ARB_shader_stencil_export%2CGL_ARB_shader_storage_buffer_object%2CGL_ARB_shader_subroutine%2CGL_ARB_shader_texture_image_samples%2CGL_ARB_shader_texture_lod%2CGL_ARB_shader_viewport_layer_array%2CGL_ARB_shading_language_100%2CGL_ARB_shading_language_420pack%2CGL_ARB_shading_language_include%2CGL_ARB_shading_language_packing%2CGL_ARB_shadow%2CGL_ARB_shadow_ambient%2CGL_ARB_sparse_buffer%2CGL_ARB_sparse_texture%2CGL_ARB_sparse_texture2%2CGL_ARB_sparse_texture_clamp%2CGL_ARB_spirv_extensions%2CGL_ARB_stencil_texturing%2CGL_ARB_sync%2CGL_ARB_tessellation_shader%2CGL_ARB_texture_barrier%2CGL_ARB_texture_border_clamp%2CGL_ARB_texture_buffer_object%2CGL_ARB_texture_buffer_object_rgb32%2CGL_ARB_texture_buffer_range%2CGL_ARB_texture_compression%2CGL_ARB_texture_compression_bptc%2CGL_ARB_texture_compression_rgtc%2CGL_ARB_texture_cube_map%2CGL_ARB_texture_cube_map_array%2CGL_ARB_texture_env_add%2CGL_ARB_texture_env_combine%2CGL_ARB_texture_env_crossbar%2CGL_ARB_texture_env_dot3%2CGL_ARB_texture_filter_anisotropic%2CGL_ARB_texture_filter_minmax%2CGL_ARB_texture_float%2CGL_ARB_texture_gather%2CGL_ARB_texture_mirror_clamp_to_edge%2CGL_ARB_texture_mirrored_repeat%2CGL_ARB_texture_multisample%2CGL_ARB_texture_non_power_of_two%2CGL_ARB_texture_query_levels%2CGL_ARB_texture_query_lod%2CGL_ARB_texture_rectangle%2CGL_ARB_texture_rg%2CGL_ARB_texture_rgb10_a2ui%2CGL_ARB_texture_stencil8%2CGL_ARB_texture_storage%2CGL_ARB_texture_storage_multisample%2CGL_ARB_texture_swizzle%2CGL_ARB_texture_view%2CGL_ARB_timer_query%2CGL_ARB_transform_feedback2%2CGL_ARB_transform_feedback3%2CGL_ARB_transform_feedback_instanced%2CGL_ARB_transform_feedback_overflow_query%2CGL_ARB_transpose_matrix%2CGL_ARB_uniform_buffer_object%2CGL_ARB_vertex_array_bgra%2CGL_ARB_vertex_array_object%2CGL_ARB_vertex_attrib_64bit%2CGL_ARB_vertex_attrib_binding%2CGL_ARB_vertex_blend%2CGL_ARB_vertex_buffer_object%2CGL_ARB_vertex_program%2CGL_ARB_vertex_shader%2CGL_ARB_vertex_type_10f_11f_11f_rev%2CGL_ARB_vertex_type_2_10_10_10_rev%2CGL_ARB_viewport_array%2CGL_ARB_window_pos%2CGL_ATI_draw_buffers%2CGL_ATI_element_array%2CGL_ATI_envmap_bumpmap%2CGL_ATI_fragment_shader%2CGL_ATI_map_object_buffer%2CGL_ATI_meminfo%2CGL_ATI_pixel_format_float%2CGL_ATI_pn_triangles%2CGL_ATI_separate_stencil%2CGL_ATI_text_fragment_shader%2CGL_ATI_texture_env_combine3%2CGL_ATI_texture_float%2CGL_ATI_texture_mirror_once%2CGL_ATI_vertex_array_object%2CGL_ATI_vertex_attrib_array_object%2CGL_ATI_vertex_streams%2CGL_EXT_422_pixels%2CGL_EXT_EGL_image_storage%2CGL_EXT_EGL_sync%2CGL_EXT_abgr%2CGL_EXT_bgra%2CGL_EXT_bindable_uniform%2CGL_EXT_blend_color%2CGL_EXT_blend_equation_separate%2CGL_EXT_blend_func_separate%2CGL_EXT_blend_logic_op%2CGL_EXT_blend_minmax%2CGL_EXT_blend_subtract%2CGL_EXT_clip_volume_hint%2CGL_EXT_cmyka%2CGL_EXT_color_subtable%2CGL_EXT_compiled_vertex_array%2CGL_EXT_convolution%2CGL_EXT_coordinate_frame%2CGL_EXT_copy_texture%2CGL_EXT_cull_vertex%2CGL_EXT_debug_label%2CGL_EXT_debug_marker%2CGL_EXT_depth_bounds_test%2CGL_EXT_direct_state_access%2CGL_EXT_draw_buffers2%2CGL_EXT_draw_instanced%2CGL_EXT_draw_range_elements%2CGL_EXT_external_buffer%2CGL_EXT_fog_coord%2CGL_EXT_framebuffer_blit%2CGL_EXT_framebuffer_multisample%2CGL_EXT_framebuffer_multisample_blit_scaled%2CGL_EXT_framebuffer_object%2CGL_EXT_framebuffer_sRGB%2CGL_EXT_geometry_shader4%2CGL_EXT_gpu_program_parameters%2CGL_EXT_gpu_shader4%2CGL_EXT_histogram%2CGL_EXT_index_array_formats%2CGL_EXT_index_func%2CGL_EXT_index_material%2CGL_EXT_index_texture%2CGL_EXT_light_texture%2CGL_EXT_memory_object%2CGL_EXT_memory_object_fd%2CGL_EXT_memory_object_win32%2CGL_EXT_misc_attribute%2CGL_EXT_multi_draw_arrays%2CGL_EXT_multisample%2CGL_EXT_multiview_tessellation_geometry_shader%2CGL_EXT_multiview_texture_multisample%2CGL_EXT_multiview_timer_query%2CGL_EXT_packed_depth_stencil%2CGL_EXT_packed_float%2CGL_EXT_packed_pixels%2CGL_EXT_paletted_texture%2CGL_EXT_pixel_buffer_object%2CGL_EXT_pixel_transform%2CGL_EXT_pixel_transform_color_table%2CGL_EXT_point_parameters%2CGL_EXT_polygon_offset%2CGL_EXT_polygon_offset_clamp%2CGL_EXT_post_depth_coverage%2CGL_EXT_provoking_vertex%2CGL_EXT_raster_multisample%2CGL_EXT_rescale_normal%2CGL_EXT_secondary_color%2CGL_EXT_semaphore%2CGL_EXT_semaphore_fd%2CGL_EXT_semaphore_win32%2CGL_EXT_separate_shader_objects%2CGL_EXT_separate_specular_color%2CGL_EXT_shader_framebuffer_fetch%2CGL_EXT_shader_framebuffer_fetch_non_coherent%2CGL_EXT_shader_image_load_formatted%2CGL_EXT_shader_image_load_store%2CGL_EXT_shader_integer_mix%2CGL_EXT_shadow_funcs%2CGL_EXT_shared_texture_palette%2CGL_EXT_sparse_texture2%2CGL_EXT_stencil_clear_tag%2CGL_EXT_stencil_two_side%2CGL_EXT_stencil_wrap%2CGL_EXT_subtexture%2CGL_EXT_texture%2CGL_EXT_texture3D%2CGL_EXT_texture_array%2CGL_EXT_texture_buffer_object%2CGL_EXT_texture_compression_latc%2CGL_EXT_texture_compression_rgtc%2CGL_EXT_texture_compression_s3tc%2CGL_EXT_texture_cube_map%2CGL_EXT_texture_env_add%2CGL_EXT_texture_env_combine%2CGL_EXT_texture_env_dot3%2CGL_EXT_texture_filter_anisotropic%2CGL_EXT_texture_filter_minmax%2CGL_EXT_texture_integer%2CGL_EXT_texture_lod_bias%2CGL_EXT_texture_mirror_clamp%2CGL_EXT_texture_object%2CGL_EXT_texture_perturb_normal%2CGL_EXT_texture_sRGB%2CGL_EXT_texture_sRGB_R8%2CGL_EXT_texture_sRGB_RG8%2CGL_EXT_texture_sRGB_decode%2CGL_EXT_texture_shadow_lod%2CGL_EXT_texture_shared_exponent%2CGL_EXT_texture_snorm%2CGL_EXT_texture_storage%2CGL_EXT_texture_swizzle%2CGL_EXT_timer_query%2CGL_EXT_transform_feedback%2CGL_EXT_vertex_array%2CGL_EXT_vertex_array_bgra%2CGL_EXT_vertex_attrib_64bit%2CGL_EXT_vertex_shader%2CGL_EXT_vertex_weighting%2CGL_EXT_win32_keyed_mutex%2CGL_EXT_window_rectangles%2CGL_EXT_x11_sync_object%2CGL_GREMEDY_frame_terminator%2CGL_GREMEDY_string_marker%2CGL_HP_convolution_border_modes%2CGL_HP_image_transform%2CGL_HP_occlusion_test%2CGL_HP_texture_lighting%2CGL_IBM_cull_vertex%2CGL_IBM_multimode_draw_arrays%2CGL_IBM_rasterpos_clip%2CGL_IBM_static_data%2CGL_IBM_texture_mirrored_repeat%2CGL_IBM_vertex_array_lists%2CGL_INGR_blend_func_separate%2CGL_INGR_color_clamp%2CGL_INGR_interlace_read%2CGL_INTEL_blackhole_render%2CGL_INTEL_conservative_rasterization%2CGL_INTEL_fragment_shader_ordering%2CGL_INTEL_framebuffer_CMAA%2CGL_INTEL_map_texture%2CGL_INTEL_parallel_arrays%2CGL_INTEL_performance_query%2CGL_KHR_blend_equation_advanced%2CGL_KHR_blend_equation_advanced_coherent%2CGL_KHR_context_flush_control%2CGL_KHR_debug%2CGL_KHR_no_error%2CGL_KHR_parallel_shader_compile%2CGL_KHR_robust_buffer_access_behavior%2CGL_KHR_robustness%2CGL_KHR_shader_subgroup%2CGL_KHR_texture_compression_astc_hdr%2CGL_KHR_texture_compression_astc_ldr%2CGL_KHR_texture_compression_astc_sliced_3d%2CGL_MESAX_texture_stack%2CGL_MESA_framebuffer_flip_x%2CGL_MESA_framebuffer_flip_y%2CGL_MESA_framebuffer_swap_xy%2CGL_MESA_pack_invert%2CGL_MESA_program_binary_formats%2CGL_MESA_resize_buffers%2CGL_MESA_shader_integer_functions%2CGL_MESA_tile_raster_order%2CGL_MESA_window_pos%2CGL_MESA_ycbcr_texture%2CGL_NVX_blend_equation_advanced_multi_draw_buffers%2CGL_NVX_conditional_render%2CGL_NVX_gpu_memory_info%2CGL_NVX_gpu_multicast2%2CGL_NVX_linked_gpu_multicast%2CGL_NVX_progress_fence%2CGL_NV_alpha_to_coverage_dither_control%2CGL_NV_bindless_multi_draw_indirect%2CGL_NV_bindless_multi_draw_indirect_count%2CGL_NV_bindless_texture%2CGL_NV_blend_equation_advanced%2CGL_NV_blend_equation_advanced_coherent%2CGL_NV_blend_minmax_factor%2CGL_NV_blend_square%2CGL_NV_clip_space_w_scaling%2CGL_NV_command_list%2CGL_NV_compute_program5%2CGL_NV_compute_shader_derivatives%2CGL_NV_conditional_render%2CGL_NV_conservative_raster%2CGL_NV_conservative_raster_dilate%2CGL_NV_conservative_raster_pre_snap%2CGL_NV_conservative_raster_pre_snap_triangles%2CGL_NV_conservative_raster_underestimation%2CGL_NV_copy_depth_to_color%2CGL_NV_copy_image%2CGL_NV_deep_texture3D%2CGL_NV_depth_buffer_float%2CGL_NV_depth_clamp%2CGL_NV_draw_texture%2CGL_NV_draw_vulkan_image%2CGL_NV_evaluators%2CGL_NV_explicit_multisample%2CGL_NV_fence%2CGL_NV_fill_rectangle%2CGL_NV_float_buffer%2CGL_NV_fog_distance%2CGL_NV_fragment_coverage_to_color%2CGL_NV_fragment_program%2CGL_NV_fragment_program2%2CGL_NV_fragment_program4%2CGL_NV_fragment_program_option%2CGL_NV_fragment_shader_barycentric%2CGL_NV_fragment_shader_interlock%2CGL_NV_framebuffer_mixed_samples%2CGL_NV_framebuffer_multisample_coverage%2CGL_NV_geometry_program4%2CGL_NV_geometry_shader4%2CGL_NV_geometry_shader_passthrough%2CGL_NV_gpu_multicast%2CGL_NV_gpu_program4%2CGL_NV_gpu_program5%2CGL_NV_gpu_program5_mem_extended%2CGL_NV_gpu_shader5%2CGL_NV_half_float%2CGL_NV_internalformat_sample_query%2CGL_NV_light_max_exponent%2CGL_NV_memory_attachment%2CGL_NV_memory_object_sparse%2CGL_NV_mesh_shader%2CGL_NV_multisample_coverage%2CGL_NV_multisample_filter_hint%2CGL_NV_occlusion_query%2CGL_NV_packed_depth_stencil%2CGL_NV_parameter_buffer_object%2CGL_NV_parameter_buffer_object2%2CGL_NV_path_rendering%2CGL_NV_path_rendering_shared_edge%2CGL_NV_pixel_data_range%2CGL_NV_point_sprite%2CGL_NV_present_video%2CGL_NV_primitive_restart%2CGL_NV_primitive_shading_rate%2CGL_NV_query_resource%2CGL_NV_query_resource_tag%2CGL_NV_register_combiners%2CGL_NV_register_combiners2%2CGL_NV_representative_fragment_test%2CGL_NV_robustness_video_memory_purge%2CGL_NV_sample_locations%2CGL_NV_sample_mask_override_coverage%2CGL_NV_scissor_exclusive%2CGL_NV_shader_atomic_counters%2CGL_NV_shader_atomic_float%2CGL_NV_shader_atomic_float64%2CGL_NV_shader_atomic_fp16_vector%2CGL_NV_shader_atomic_int64%2CGL_NV_shader_buffer_load%2CGL_NV_shader_buffer_store%2CGL_NV_shader_storage_buffer_object%2CGL_NV_shader_subgroup_partitioned%2CGL_NV_shader_texture_footprint%2CGL_NV_shader_thread_group%2CGL_NV_shader_thread_shuffle%2CGL_NV_shading_rate_image%2CGL_NV_stereo_view_rendering%2CGL_NV_tessellation_program5%2CGL_NV_texgen_emboss%2CGL_NV_texgen_reflection%2CGL_NV_texture_barrier%2CGL_NV_texture_compression_vtc%2CGL_NV_texture_env_combine4%2CGL_NV_texture_expand_normal%2CGL_NV_texture_multisample%2CGL_NV_texture_rectangle%2CGL_NV_texture_rectangle_compressed%2CGL_NV_texture_shader%2CGL_NV_texture_shader2%2CGL_NV_texture_shader3%2CGL_NV_timeline_semaphore%2CGL_NV_transform_feedback%2CGL_NV_transform_feedback2%2CGL_NV_uniform_buffer_unified_memory%2CGL_NV_vdpau_interop%2CGL_NV_vdpau_interop2%2CGL_NV_vertex_array_range%2CGL_NV_vertex_array_range2%2CGL_NV_vertex_attrib_integer_64bit%2CGL_NV_vertex_buffer_unified_memory%2CGL_NV_vertex_program%2CGL_NV_vertex_program1_1%2CGL_NV_vertex_program2%2CGL_NV_vertex_program2_option%2CGL_NV_vertex_program3%2CGL_NV_vertex_program4%2CGL_NV_video_capture%2CGL_NV_viewport_array2%2CGL_NV_viewport_swizzle%2CGL_OES_byte_coordinates%2CGL_OES_compressed_paletted_texture%2CGL_OES_fixed_point%2CGL_OES_query_matrix%2CGL_OES_read_format%2CGL_OES_single_precision%2CGL_OML_interlace%2CGL_OML_resample%2CGL_OML_subsample%2CGL_OVR_multiview%2CGL_OVR_multiview2%2CGL_PGI_misc_hints%2CGL_PGI_vertex_hints%2CGL_REND_screen_coordinates%2CGL_S3_s3tc%2CGL_SGIS_detail_texture%2CGL_SGIS_fog_function%2CGL_SGIS_generate_mipmap%2CGL_SGIS_multisample%2CGL_SGIS_pixel_texture%2CGL_SGIS_point_line_texgen%2CGL_SGIS_point_parameters%2CGL_SGIS_sharpen_texture%2CGL_SGIS_texture4D%2CGL_SGIS_texture_border_clamp%2CGL_SGIS_texture_color_mask%2CGL_SGIS_texture_edge_clamp%2CGL_SGIS_texture_filter4%2CGL_SGIS_texture_lod%2CGL_SGIS_texture_select%2CGL_SGIX_async%2CGL_SGIX_async_histogram%2CGL_SGIX_async_pixel%2CGL_SGIX_blend_alpha_minmax%2CGL_SGIX_calligraphic_fragment%2CGL_SGIX_clipmap%2CGL_SGIX_convolution_accuracy%2CGL_SGIX_depth_pass_instrument%2CGL_SGIX_depth_texture%2CGL_SGIX_flush_raster%2CGL_SGIX_fog_offset%2CGL_SGIX_fragment_lighting%2CGL_SGIX_framezoom%2CGL_SGIX_igloo_interface%2CGL_SGIX_instruments%2CGL_SGIX_interlace%2CGL_SGIX_ir_instrument1%2CGL_SGIX_list_priority%2CGL_SGIX_pixel_texture%2CGL_SGIX_pixel_tiles%2CGL_SGIX_polynomial_ffd%2CGL_SGIX_reference_plane%2CGL_SGIX_resample%2CGL_SGIX_scalebias_hint%2CGL_SGIX_shadow%2CGL_SGIX_shadow_ambient%2CGL_SGIX_sprite%2CGL_SGIX_subsample%2CGL_SGIX_tag_sample_buffer%2CGL_SGIX_texture_add_env%2CGL_SGIX_texture_coordinate_clamp%2CGL_SGIX_texture_lod_bias%2CGL_SGIX_texture_multi_buffer%2CGL_SGIX_texture_scale_bias%2CGL_SGIX_vertex_preclip%2CGL_SGIX_ycrcb%2CGL_SGIX_ycrcb_subsample%2CGL_SGIX_ycrcba%2CGL_SGI_color_matrix%2CGL_SGI_color_table%2CGL_SGI_texture_color_table%2CGL_SUNX_constant_data%2CGL_SUN_convolution_border_modes%2CGL_SUN_global_alpha%2CGL_SUN_mesh_array%2CGL_SUN_slice_accum%2CGL_SUN_triangle_list%2CGL_SUN_vertex%2CGL_WIN_phong_shading%2CGL_WIN_specular_fog)

---

Copyright (C) 2022 Cem Geçgel <gecgelcem@outlook.com>
