use mimeograph_router::*;

type Result<T> = std::result::Result<T, Box<dyn std::error::Error>>;

#[get("/")]
pub fn home(_request: http::Request<()>) -> Result<http::Response<String>> {
    http::Response::builder()
        .body(String::from("home"))
        .map_err(Into::into)
}

#[get("/foo/bar/baz")]
pub fn foo_bar_baz(_request: http::Request<()>) -> Result<http::Response<String>> {
    http::Response::builder()
        .body(String::from("hello world"))
        .map_err(Into::into)
}

#[get("/bar/baz/:qux")]
pub fn bar_baz_qux(_request: http::Request<()>, _qux: &str) -> Result<http::Response<String>> {
    http::Response::builder()
        .body(String::default())
        .map_err(Into::into)
}

fn main() {
    let request = http::Request::get("http://mimeograph.roosterbockets.com/foo/bar/baz")
        .body(())
        .unwrap();

    let router = router![home, foo_bar_baz, bar_baz_qux];
    let _response: http::Response<String> = match router(request) {
        // Matched a route
        RouterResult::Handled(Ok(resp)) => resp,
        // There was an error
        RouterResult::Handled(Err(_))  |
        // No routes matched
        RouterResult::NotHandled(_) => panic!("request should have been handled")
    };
}
