use proc_macro::TokenStream;

mod route;
mod router;

type Result<T> = std::result::Result<T, syn::Error>;

pub(crate) static ROUTE_STRUCT_PREFIX: &str = "route_for_";

macro_rules! route_verb {
    ($verb:ident => $method:expr) => {
        #[proc_macro_attribute]
        pub fn $verb(args: TokenStream, input: TokenStream) -> TokenStream {
            route::route_attribute($method, args, input)
        }
    };
}

route_verb!(get => "GET");
route_verb!(put => "POST");
route_verb!(post => "POST");
route_verb!(delete => "DELETE");
route_verb!(head => "HEAD");
route_verb!(patch => "PATCH");
route_verb!(options => "OPTIONS");

#[proc_macro]
pub fn router(input: TokenStream) -> TokenStream {
    router::routes_macro(input)
}
