#![no_std]

extern crate alloc;

use alloc::borrow::Cow;

/// A trait for types that can be routed
pub trait Request {
    /// Return the path portion of a URI.
    fn path(&self) -> Cow<'_, str>;

    /// Returns the http VERB in UPPERCASE
    fn method(&self) -> Cow<'_, str>;
}

#[cfg(feature = "http")]
impl<T> Request for http::Request<T> {
    fn path(&self) -> Cow<'_, str> {
        self.uri().path().into()
    }

    fn method(&self) -> Cow<'_, str> {
        self.method().as_str().into()
    }
}
