use js_sys::{Array, Promise};
use wasm_bindgen::prelude::*;
use web_sys::{Request, RequestInit};

use alloc::string::String;

#[wasm_bindgen]
extern "C" {
    #[wasm_bindgen]
    #[derive(Clone)]
    pub type DurableObjectState;

    #[wasm_bindgen(getter, method)]
    pub fn id(this: &DurableObjectState) -> DurableObjectId;

    #[wasm_bindgen(getter, method)]
    pub fn storage(this: &DurableObjectState) -> DurableObjectStorage;
}

#[wasm_bindgen]
extern "C" {
    #[wasm_bindgen]
    #[derive(Clone)]
    pub type DurableObjectId;

    #[wasm_bindgen(method, js_name=toString)]
    pub fn to_string(this: &DurableObjectId) -> String;
}

#[wasm_bindgen]
extern "C" {
    #[wasm_bindgen]
    #[derive(Clone)]
    pub type DurableObjectStorage;

    #[wasm_bindgen(catch, method)]
    pub fn get(this: &DurableObjectStorage, key: &str) -> Result<Promise, JsValue>;

    /// `keys` is an array of strings
    #[wasm_bindgen(catch, method, js_name=get)]
    pub fn get_all(this: &DurableObjectStorage, keys: Array) -> Result<Promise, JsValue>;

    #[wasm_bindgen(catch, method, js_name=put)]
    pub fn put(this: &DurableObjectStorage, key: &str, value: &JsValue)
        -> Result<Promise, JsValue>;

    // Returns Promise<void>
    #[wasm_bindgen(catch, method, js_name=put)]
    pub fn put_all(this: &DurableObjectStorage, entries: &JsValue) -> Result<Promise, JsValue>;

    #[wasm_bindgen(catch, method)]
    pub fn delete(this: &DurableObjectStorage, key: &str) -> Result<Promise, JsValue>;

    #[wasm_bindgen(catch, method, js_name=deleteAll)]
    pub fn delete_all(this: &DurableObjectStorage) -> Result<Promise, JsValue>;

    #[wasm_bindgen(catch, method)]
    pub fn list(this: &DurableObjectStorage) -> Result<Promise, JsValue>;
}

#[wasm_bindgen]
extern "C" {
    #[wasm_bindgen]
    #[derive(Clone)]
    pub type DurableObjectNamespace;

    #[wasm_bindgen(method, js_name=newUniqueId)]
    pub fn new_unique_id(this: &DurableObjectNamespace) -> DurableObjectId;
    #[wasm_bindgen(method, js_name=idFromName)]
    pub fn id_from_name(this: &DurableObjectNamespace, name: &str) -> DurableObjectId;
    #[wasm_bindgen(method, js_name=idFromString)]
    pub fn id_from_string(this: &DurableObjectNamespace, name: &str) -> DurableObjectId;
    #[wasm_bindgen(method)]
    pub fn get(this: &DurableObjectNamespace, id: DurableObjectId) -> DurableObjectStub;
}

#[wasm_bindgen]
extern "C" {
    #[wasm_bindgen]
    #[derive(Clone)]
    pub type DurableObjectStub;

    #[wasm_bindgen(catch, method)]
    pub fn fetch(this: &DurableObjectStub, request: &Request) -> Result<Promise, JsValue>;

    #[wasm_bindgen(catch, method, js_name=fetch)]
    pub fn fetch_with_path(this: &DurableObjectStub, path: &str) -> Result<Promise, JsValue>;

    #[wasm_bindgen(catch, method, js_name=fetch)]
    pub fn fetch_with_path_and_options(
        this: &DurableObjectStub,
        path: &str,
        options: &RequestInit,
    ) -> Result<Promise, JsValue>;
}
