mod durable_objects;
mod error;
mod html_rewriter;
mod kv;
mod request;
mod response;
mod stream;

pub use durable_objects::*;
pub use error::*;
pub use html_rewriter::*;
pub use kv::*;
pub use request::*;
pub use request::*;
pub use response::*;
pub use stream::*;

use wasm_bindgen::prelude::*;

pub type Result<T> = std::result::Result<T, Error>;

#[wasm_bindgen]
extern "C" {
    #[wasm_bindgen(js_namespace=crypto, js_name=subtle)]
    pub static SUBTLE_CRYPTO: web_sys::SubtleCrypto;

    #[wasm_bindgen(js_name=crypto)]
    pub static CRYPTO: web_sys::Crypto;

    #[wasm_bindgen(catch)]
    pub fn btoa(btoa: &str) -> std::result::Result<String, JsValue>;
}

#[wasm_bindgen]
extern "C" {
    pub type Event;

    #[wasm_bindgen(getter, method)]
    pub fn request(this: &Event) -> Request;

    #[wasm_bindgen(getter, method, js_name = type)]
    pub fn kind(this: &Event) -> String;
}

#[wasm_bindgen]
extern "C" {
    pub type Fetcher;
}

#[wasm_bindgen]
extern "C" {
    #[derive(Clone)]
    pub type Headers;
}

#[wasm_bindgen]
extern "C" {
    #[derive(Clone)]
    pub type Env;

    #[wasm_bindgen(method, getter, js_name=EMOJI_COUNTER)]
    pub fn emoji_counter(this: &Env) -> DurableObjectNamespace;

    #[wasm_bindgen(method, getter, js_name=USER)]
    pub fn user(this: &Env) -> DurableObjectNamespace;

    #[wasm_bindgen(method, getter, js_name=PAGES)]
    pub fn pages(this: &Env) -> KV;

    #[wasm_bindgen(method, getter, js_name=TEMPLATES)]
    pub fn templates(this: &Env) -> KV;

    #[wasm_bindgen(method, getter, js_name=STATICS)]
    pub fn statics(this: &Env) -> KV;

    #[wasm_bindgen(method, getter, js_name=SETTINGS)]
    pub fn settings(this: &Env) -> KV;

    #[wasm_bindgen(method, getter, js_name=AUTH_KEY)]
    pub fn auth_key(this: &Env) -> String;
}
