use js_sys::{Array, Object, Promise};
use wasm_bindgen::prelude::*;

use super::{Request, RequestInit};

#[wasm_bindgen]
extern "C" {
    #[derive(Clone)]
    pub type DurableObjectState;

    #[wasm_bindgen(getter, method)]
    pub fn id(this: &DurableObjectState) -> DurableObjectId;

    #[wasm_bindgen(getter, method)]
    pub fn storage(this: &DurableObjectState) -> DurableObjectStorage;
}

#[wasm_bindgen]
extern "C" {
    pub type DurableObjectId;

    #[wasm_bindgen(method, js_name=toString)]
    pub fn to_string(this: &DurableObjectId) -> String;
}

#[wasm_bindgen]
extern "C" {
    pub type DurableObjectStorage;

    #[wasm_bindgen(method)]
    pub fn get(this: &DurableObjectStorage, key: &str) -> Promise;

    /// `keys` is an array of strings
    #[wasm_bindgen(method, js_name=get)]
    pub fn get_all(this: &DurableObjectStorage, keys: Array) -> Promise;

    #[wasm_bindgen(method, js_name=put)]
    pub fn put_entries(this: &DurableObjectStorage, entries: &Object) -> Promise;

    #[wasm_bindgen(method, js_name=deleteAll)]
    pub fn delete_all(this: &DurableObjectStorage) -> Promise;

    #[wasm_bindgen(method)]
    pub fn list(this: &DurableObjectStorage) -> Promise;
}

#[wasm_bindgen]
extern "C" {
    pub type DurableObjectNamespace;

    #[wasm_bindgen(method, js_name=newUniqueId)]
    pub fn new_unique_id(this: &DurableObjectNamespace) -> DurableObjectId;
    #[wasm_bindgen(method, js_name=idFromName)]
    pub fn id_from_name(this: &DurableObjectNamespace, name: &str) -> DurableObjectId;
    #[wasm_bindgen(method, js_name=idFromString)]
    pub fn id_from_string(this: &DurableObjectNamespace, name: &str) -> DurableObjectId;
    #[wasm_bindgen(method)]
    pub fn get(this: &DurableObjectNamespace, id: DurableObjectId) -> DurableObjectStub;
}

#[wasm_bindgen]
extern "C" {
    pub type DurableObjectStub;

    #[wasm_bindgen(method)]
    pub fn fetch(this: &DurableObjectStub, request: &Request) -> Promise;

    #[wasm_bindgen(method, js_name=fetch)]
    pub fn fetch_with_path(this: &DurableObjectStub, path: &str) -> Promise;

    #[wasm_bindgen(method, js_name=fetch)]
    pub fn fetch_with_path_and_options(
        this: &DurableObjectStub,
        path: &str,
        options: RequestInit,
    ) -> Promise;
}
