pub const TYPES: [(&str, usize, usize); 956] = [
    ("application/andrew-inset", 0, 1),
    ("application/applixware", 1, 1),
    ("application/atom+xml", 2, 1),
    ("application/atomcat+xml", 3, 1),
    ("application/atomdeleted+xml", 4, 1),
    ("application/atomsvc+xml", 5, 1),
    ("application/atsc-dwd+xml", 6, 1),
    ("application/atsc-held+xml", 7, 1),
    ("application/atsc-rsat+xml", 8, 1),
    ("application/bdoc", 9, 1),
    ("application/calendar+xml", 10, 1),
    ("application/ccxml+xml", 11, 1),
    ("application/cdfx+xml", 12, 1),
    ("application/cdmi-capability", 13, 1),
    ("application/cdmi-container", 14, 1),
    ("application/cdmi-domain", 15, 1),
    ("application/cdmi-object", 16, 1),
    ("application/cdmi-queue", 17, 1),
    ("application/cu-seeme", 18, 1),
    ("application/dash+xml", 19, 1),
    ("application/davmount+xml", 20, 1),
    ("application/docbook+xml", 21, 1),
    ("application/dssc+der", 22, 1),
    ("application/dssc+xml", 23, 1),
    ("application/ecmascript", 24, 2),
    ("application/emma+xml", 26, 1),
    ("application/emotionml+xml", 27, 1),
    ("application/epub+zip", 28, 1),
    ("application/exi", 29, 1),
    ("application/express", 30, 1),
    ("application/fdt+xml", 31, 1),
    ("application/font-tdpfr", 32, 1),
    ("application/geo+json", 33, 1),
    ("application/gml+xml", 34, 1),
    ("application/gpx+xml", 35, 1),
    ("application/gxf", 36, 1),
    ("application/gzip", 37, 1),
    ("application/hjson", 38, 1),
    ("application/hyperstudio", 39, 1),
    ("application/inkml+xml", 40, 2),
    ("application/ipfix", 42, 1),
    ("application/its+xml", 43, 1),
    ("application/java-archive", 44, 3),
    ("application/java-serialized-object", 47, 1),
    ("application/java-vm", 48, 1),
    ("application/javascript", 49, 2),
    ("application/json", 51, 2),
    ("application/json5", 53, 1),
    ("application/jsonml+json", 54, 1),
    ("application/ld+json", 55, 1),
    ("application/lgr+xml", 56, 1),
    ("application/lost+xml", 57, 1),
    ("application/mac-binhex40", 58, 1),
    ("application/mac-compactpro", 59, 1),
    ("application/mads+xml", 60, 1),
    ("application/manifest+json", 61, 1),
    ("application/marc", 62, 1),
    ("application/marcxml+xml", 63, 1),
    ("application/mathematica", 64, 3),
    ("application/mathml+xml", 67, 1),
    ("application/mbox", 68, 1),
    ("application/mediaservercontrol+xml", 69, 1),
    ("application/metalink+xml", 70, 1),
    ("application/metalink4+xml", 71, 1),
    ("application/mets+xml", 72, 1),
    ("application/mmt-aei+xml", 73, 1),
    ("application/mmt-usd+xml", 74, 1),
    ("application/mods+xml", 75, 1),
    ("application/mp21", 76, 2),
    ("application/mp4", 78, 2),
    ("application/msword", 80, 2),
    ("application/mxf", 82, 1),
    ("application/n-quads", 83, 1),
    ("application/n-triples", 84, 1),
    ("application/node", 85, 1),
    ("application/octet-stream", 86, 22),
    ("application/oda", 108, 1),
    ("application/oebps-package+xml", 109, 1),
    ("application/ogg", 110, 1),
    ("application/omdoc+xml", 111, 1),
    ("application/onenote", 112, 4),
    ("application/oxps", 116, 1),
    ("application/p2p-overlay+xml", 117, 1),
    ("application/patch-ops-error+xml", 118, 1),
    ("application/pdf", 119, 1),
    ("application/pgp-encrypted", 120, 1),
    ("application/pgp-signature", 121, 2),
    ("application/pics-rules", 123, 1),
    ("application/pkcs10", 124, 1),
    ("application/pkcs7-mime", 125, 2),
    ("application/pkcs7-signature", 127, 1),
    ("application/pkcs8", 128, 1),
    ("application/pkix-attr-cert", 129, 1),
    ("application/pkix-cert", 130, 1),
    ("application/pkix-crl", 131, 1),
    ("application/pkix-pkipath", 132, 1),
    ("application/pkixcmp", 133, 1),
    ("application/pls+xml", 134, 1),
    ("application/postscript", 135, 3),
    ("application/provenance+xml", 138, 1),
    ("application/prs.cww", 139, 1),
    ("application/pskc+xml", 140, 1),
    ("application/raml+yaml", 141, 1),
    ("application/rdf+xml", 142, 2),
    ("application/reginfo+xml", 144, 1),
    ("application/relax-ng-compact-syntax", 145, 1),
    ("application/resource-lists+xml", 146, 1),
    ("application/resource-lists-diff+xml", 147, 1),
    ("application/rls-services+xml", 148, 1),
    ("application/route-apd+xml", 149, 1),
    ("application/route-s-tsid+xml", 150, 1),
    ("application/route-usd+xml", 151, 1),
    ("application/rpki-ghostbusters", 152, 1),
    ("application/rpki-manifest", 153, 1),
    ("application/rpki-roa", 154, 1),
    ("application/rsd+xml", 155, 1),
    ("application/rss+xml", 156, 1),
    ("application/rtf", 157, 1),
    ("application/sbml+xml", 158, 1),
    ("application/scvp-cv-request", 159, 1),
    ("application/scvp-cv-response", 160, 1),
    ("application/scvp-vp-request", 161, 1),
    ("application/scvp-vp-response", 162, 1),
    ("application/sdp", 163, 1),
    ("application/senml+xml", 164, 1),
    ("application/sensml+xml", 165, 1),
    ("application/set-payment-initiation", 166, 1),
    ("application/set-registration-initiation", 167, 1),
    ("application/shf+xml", 168, 1),
    ("application/sieve", 169, 2),
    ("application/smil+xml", 171, 2),
    ("application/sparql-query", 173, 1),
    ("application/sparql-results+xml", 174, 1),
    ("application/srgs", 175, 1),
    ("application/srgs+xml", 176, 1),
    ("application/sru+xml", 177, 1),
    ("application/ssdl+xml", 178, 1),
    ("application/ssml+xml", 179, 1),
    ("application/swid+xml", 180, 1),
    ("application/tei+xml", 181, 2),
    ("application/thraud+xml", 183, 1),
    ("application/timestamped-data", 184, 1),
    ("application/toml", 185, 1),
    ("application/trig", 186, 1),
    ("application/ttml+xml", 187, 1),
    ("application/ubjson", 188, 1),
    ("application/urc-ressheet+xml", 189, 1),
    ("application/urc-targetdesc+xml", 190, 1),
    ("application/vnd.1000minds.decision-model+xml", 191, 1),
    ("application/vnd.3gpp.pic-bw-large", 192, 1),
    ("application/vnd.3gpp.pic-bw-small", 193, 1),
    ("application/vnd.3gpp.pic-bw-var", 194, 1),
    ("application/vnd.3gpp2.tcap", 195, 1),
    ("application/vnd.3m.post-it-notes", 196, 1),
    ("application/vnd.accpac.simply.aso", 197, 1),
    ("application/vnd.accpac.simply.imp", 198, 1),
    ("application/vnd.acucobol", 199, 1),
    ("application/vnd.acucorp", 200, 2),
    (
        "application/vnd.adobe.air-application-installer-package+zip",
        202,
        1,
    ),
    ("application/vnd.adobe.formscentral.fcdt", 203, 1),
    ("application/vnd.adobe.fxp", 204, 2),
    ("application/vnd.adobe.xdp+xml", 206, 1),
    ("application/vnd.adobe.xfdf", 207, 1),
    ("application/vnd.ahead.space", 208, 1),
    ("application/vnd.airzip.filesecure.azf", 209, 1),
    ("application/vnd.airzip.filesecure.azs", 210, 1),
    ("application/vnd.amazon.ebook", 211, 1),
    ("application/vnd.americandynamics.acc", 212, 1),
    ("application/vnd.amiga.ami", 213, 1),
    ("application/vnd.android.package-archive", 214, 1),
    (
        "application/vnd.anser-web-certificate-issue-initiation",
        215,
        1,
    ),
    (
        "application/vnd.anser-web-funds-transfer-initiation",
        216,
        1,
    ),
    ("application/vnd.antix.game-component", 217, 1),
    ("application/vnd.apple.installer+xml", 218, 1),
    ("application/vnd.apple.keynote", 219, 1),
    ("application/vnd.apple.mpegurl", 220, 1),
    ("application/vnd.apple.numbers", 221, 1),
    ("application/vnd.apple.pages", 222, 1),
    ("application/vnd.apple.pkpass", 223, 1),
    ("application/vnd.aristanetworks.swi", 224, 1),
    ("application/vnd.astraea-software.iota", 225, 1),
    ("application/vnd.audiograph", 226, 1),
    ("application/vnd.balsamiq.bmml+xml", 227, 1),
    ("application/vnd.blueice.multipass", 228, 1),
    ("application/vnd.bmi", 229, 1),
    ("application/vnd.businessobjects", 230, 1),
    ("application/vnd.chemdraw+xml", 231, 1),
    ("application/vnd.chipnuts.karaoke-mmd", 232, 1),
    ("application/vnd.cinderella", 233, 1),
    ("application/vnd.citationstyles.style+xml", 234, 1),
    ("application/vnd.claymore", 235, 1),
    ("application/vnd.cloanto.rp9", 236, 1),
    ("application/vnd.clonk.c4group", 237, 5),
    ("application/vnd.cluetrust.cartomobile-config", 242, 1),
    ("application/vnd.cluetrust.cartomobile-config-pkg", 243, 1),
    ("application/vnd.commonspace", 244, 1),
    ("application/vnd.contact.cmsg", 245, 1),
    ("application/vnd.cosmocaller", 246, 1),
    ("application/vnd.crick.clicker", 247, 1),
    ("application/vnd.crick.clicker.keyboard", 248, 1),
    ("application/vnd.crick.clicker.palette", 249, 1),
    ("application/vnd.crick.clicker.template", 250, 1),
    ("application/vnd.crick.clicker.wordbank", 251, 1),
    ("application/vnd.criticaltools.wbs+xml", 252, 1),
    ("application/vnd.ctc-posml", 253, 1),
    ("application/vnd.cups-ppd", 254, 1),
    ("application/vnd.curl.car", 255, 1),
    ("application/vnd.curl.pcurl", 256, 1),
    ("application/vnd.dart", 257, 1),
    ("application/vnd.data-vision.rdz", 258, 1),
    ("application/vnd.dbf", 259, 1),
    ("application/vnd.dece.data", 260, 4),
    ("application/vnd.dece.ttml+xml", 264, 2),
    ("application/vnd.dece.unspecified", 266, 2),
    ("application/vnd.dece.zip", 268, 2),
    ("application/vnd.denovo.fcselayout-link", 270, 1),
    ("application/vnd.dna", 271, 1),
    ("application/vnd.dolby.mlp", 272, 1),
    ("application/vnd.dpgraph", 273, 1),
    ("application/vnd.dreamfactory", 274, 1),
    ("application/vnd.ds-keypoint", 275, 1),
    ("application/vnd.dvb.ait", 276, 1),
    ("application/vnd.dvb.service", 277, 1),
    ("application/vnd.dynageo", 278, 1),
    ("application/vnd.ecowin.chart", 279, 1),
    ("application/vnd.enliven", 280, 1),
    ("application/vnd.epson.esf", 281, 1),
    ("application/vnd.epson.msf", 282, 1),
    ("application/vnd.epson.quickanime", 283, 1),
    ("application/vnd.epson.salt", 284, 1),
    ("application/vnd.epson.ssf", 285, 1),
    ("application/vnd.eszigno3+xml", 286, 2),
    ("application/vnd.ezpix-album", 288, 1),
    ("application/vnd.ezpix-package", 289, 1),
    ("application/vnd.fdf", 290, 1),
    ("application/vnd.fdsn.mseed", 291, 1),
    ("application/vnd.fdsn.seed", 292, 2),
    ("application/vnd.flographit", 294, 1),
    ("application/vnd.fluxtime.clip", 295, 1),
    ("application/vnd.framemaker", 296, 4),
    ("application/vnd.frogans.fnc", 300, 1),
    ("application/vnd.frogans.ltf", 301, 1),
    ("application/vnd.fsc.weblaunch", 302, 1),
    ("application/vnd.fujitsu.oasys", 303, 1),
    ("application/vnd.fujitsu.oasys2", 304, 1),
    ("application/vnd.fujitsu.oasys3", 305, 1),
    ("application/vnd.fujitsu.oasysgp", 306, 1),
    ("application/vnd.fujitsu.oasysprs", 307, 1),
    ("application/vnd.fujixerox.ddd", 308, 1),
    ("application/vnd.fujixerox.docuworks", 309, 1),
    ("application/vnd.fujixerox.docuworks.binder", 310, 1),
    ("application/vnd.fuzzysheet", 311, 1),
    ("application/vnd.genomatix.tuxedo", 312, 1),
    ("application/vnd.geogebra.file", 313, 1),
    ("application/vnd.geogebra.tool", 314, 1),
    ("application/vnd.geometry-explorer", 315, 2),
    ("application/vnd.geonext", 317, 1),
    ("application/vnd.geoplan", 318, 1),
    ("application/vnd.geospace", 319, 1),
    ("application/vnd.gmx", 320, 1),
    ("application/vnd.google-apps.document", 321, 1),
    ("application/vnd.google-apps.presentation", 322, 1),
    ("application/vnd.google-apps.spreadsheet", 323, 1),
    ("application/vnd.google-earth.kml+xml", 324, 1),
    ("application/vnd.google-earth.kmz", 325, 1),
    ("application/vnd.grafeq", 326, 2),
    ("application/vnd.groove-account", 328, 1),
    ("application/vnd.groove-help", 329, 1),
    ("application/vnd.groove-identity-message", 330, 1),
    ("application/vnd.groove-injector", 331, 1),
    ("application/vnd.groove-tool-message", 332, 1),
    ("application/vnd.groove-tool-template", 333, 1),
    ("application/vnd.groove-vcard", 334, 1),
    ("application/vnd.hal+xml", 335, 1),
    ("application/vnd.handheld-entertainment+xml", 336, 1),
    ("application/vnd.hbci", 337, 1),
    ("application/vnd.hhe.lesson-player", 338, 1),
    ("application/vnd.hp-hpgl", 339, 1),
    ("application/vnd.hp-hpid", 340, 1),
    ("application/vnd.hp-hps", 341, 1),
    ("application/vnd.hp-jlyt", 342, 1),
    ("application/vnd.hp-pcl", 343, 1),
    ("application/vnd.hp-pclxl", 344, 1),
    ("application/vnd.hydrostatix.sof-data", 345, 1),
    ("application/vnd.ibm.minipay", 346, 1),
    ("application/vnd.ibm.modcap", 347, 3),
    ("application/vnd.ibm.rights-management", 350, 1),
    ("application/vnd.ibm.secure-container", 351, 1),
    ("application/vnd.iccprofile", 352, 2),
    ("application/vnd.igloader", 354, 1),
    ("application/vnd.immervision-ivp", 355, 1),
    ("application/vnd.immervision-ivu", 356, 1),
    ("application/vnd.insors.igm", 357, 1),
    ("application/vnd.intercon.formnet", 358, 2),
    ("application/vnd.intergeo", 360, 1),
    ("application/vnd.intu.qbo", 361, 1),
    ("application/vnd.intu.qfx", 362, 1),
    ("application/vnd.ipunplugged.rcprofile", 363, 1),
    ("application/vnd.irepository.package+xml", 364, 1),
    ("application/vnd.is-xpr", 365, 1),
    ("application/vnd.isac.fcs", 366, 1),
    ("application/vnd.jam", 367, 1),
    ("application/vnd.jcp.javame.midlet-rms", 368, 1),
    ("application/vnd.jisp", 369, 1),
    ("application/vnd.joost.joda-archive", 370, 1),
    ("application/vnd.kahootz", 371, 2),
    ("application/vnd.kde.karbon", 373, 1),
    ("application/vnd.kde.kchart", 374, 1),
    ("application/vnd.kde.kformula", 375, 1),
    ("application/vnd.kde.kivio", 376, 1),
    ("application/vnd.kde.kontour", 377, 1),
    ("application/vnd.kde.kpresenter", 378, 2),
    ("application/vnd.kde.kspread", 380, 1),
    ("application/vnd.kde.kword", 381, 2),
    ("application/vnd.kenameaapp", 383, 1),
    ("application/vnd.kidspiration", 384, 1),
    ("application/vnd.kinar", 385, 2),
    ("application/vnd.koan", 387, 4),
    ("application/vnd.kodak-descriptor", 391, 1),
    ("application/vnd.las.las+xml", 392, 1),
    ("application/vnd.llamagraphics.life-balance.desktop", 393, 1),
    (
        "application/vnd.llamagraphics.life-balance.exchange+xml",
        394,
        1,
    ),
    ("application/vnd.lotus-1-2-3", 395, 1),
    ("application/vnd.lotus-approach", 396, 1),
    ("application/vnd.lotus-freelance", 397, 1),
    ("application/vnd.lotus-notes", 398, 1),
    ("application/vnd.lotus-organizer", 399, 1),
    ("application/vnd.lotus-screencam", 400, 1),
    ("application/vnd.lotus-wordpro", 401, 1),
    ("application/vnd.macports.portpkg", 402, 1),
    ("application/vnd.mapbox-vector-tile", 403, 1),
    ("application/vnd.mcd", 404, 1),
    ("application/vnd.medcalcdata", 405, 1),
    ("application/vnd.mediastation.cdkey", 406, 1),
    ("application/vnd.mfer", 407, 1),
    ("application/vnd.mfmp", 408, 1),
    ("application/vnd.micrografx.flo", 409, 1),
    ("application/vnd.micrografx.igx", 410, 1),
    ("application/vnd.mif", 411, 1),
    ("application/vnd.mobius.daf", 412, 1),
    ("application/vnd.mobius.dis", 413, 1),
    ("application/vnd.mobius.mbk", 414, 1),
    ("application/vnd.mobius.mqy", 415, 1),
    ("application/vnd.mobius.msl", 416, 1),
    ("application/vnd.mobius.plc", 417, 1),
    ("application/vnd.mobius.txf", 418, 1),
    ("application/vnd.mophun.application", 419, 1),
    ("application/vnd.mophun.certificate", 420, 1),
    ("application/vnd.mozilla.xul+xml", 421, 1),
    ("application/vnd.ms-artgalry", 422, 1),
    ("application/vnd.ms-cab-compressed", 423, 1),
    ("application/vnd.ms-excel", 424, 6),
    ("application/vnd.ms-excel.addin.macroenabled.12", 430, 1),
    (
        "application/vnd.ms-excel.sheet.binary.macroenabled.12",
        431,
        1,
    ),
    ("application/vnd.ms-excel.sheet.macroenabled.12", 432, 1),
    ("application/vnd.ms-excel.template.macroenabled.12", 433, 1),
    ("application/vnd.ms-fontobject", 434, 1),
    ("application/vnd.ms-htmlhelp", 435, 1),
    ("application/vnd.ms-ims", 436, 1),
    ("application/vnd.ms-lrm", 437, 1),
    ("application/vnd.ms-officetheme", 438, 1),
    ("application/vnd.ms-outlook", 439, 1),
    ("application/vnd.ms-pki.seccat", 440, 1),
    ("application/vnd.ms-pki.stl", 441, 1),
    ("application/vnd.ms-powerpoint", 442, 3),
    (
        "application/vnd.ms-powerpoint.addin.macroenabled.12",
        445,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.presentation.macroenabled.12",
        446,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.slide.macroenabled.12",
        447,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.slideshow.macroenabled.12",
        448,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.template.macroenabled.12",
        449,
        1,
    ),
    ("application/vnd.ms-project", 450, 2),
    ("application/vnd.ms-word.document.macroenabled.12", 452, 1),
    ("application/vnd.ms-word.template.macroenabled.12", 453, 1),
    ("application/vnd.ms-works", 454, 4),
    ("application/vnd.ms-wpl", 458, 1),
    ("application/vnd.ms-xpsdocument", 459, 1),
    ("application/vnd.mseq", 460, 1),
    ("application/vnd.musician", 461, 1),
    ("application/vnd.muvee.style", 462, 1),
    ("application/vnd.mynfc", 463, 1),
    ("application/vnd.neurolanguage.nlu", 464, 1),
    ("application/vnd.nitf", 465, 2),
    ("application/vnd.noblenet-directory", 467, 1),
    ("application/vnd.noblenet-sealer", 468, 1),
    ("application/vnd.noblenet-web", 469, 1),
    ("application/vnd.nokia.n-gage.ac+xml", 470, 1),
    ("application/vnd.nokia.n-gage.data", 471, 1),
    ("application/vnd.nokia.n-gage.symbian.install", 472, 1),
    ("application/vnd.nokia.radio-preset", 473, 1),
    ("application/vnd.nokia.radio-presets", 474, 1),
    ("application/vnd.novadigm.edm", 475, 1),
    ("application/vnd.novadigm.edx", 476, 1),
    ("application/vnd.novadigm.ext", 477, 1),
    ("application/vnd.oasis.opendocument.chart", 478, 1),
    ("application/vnd.oasis.opendocument.chart-template", 479, 1),
    ("application/vnd.oasis.opendocument.database", 480, 1),
    ("application/vnd.oasis.opendocument.formula", 481, 1),
    (
        "application/vnd.oasis.opendocument.formula-template",
        482,
        1,
    ),
    ("application/vnd.oasis.opendocument.graphics", 483, 1),
    (
        "application/vnd.oasis.opendocument.graphics-template",
        484,
        1,
    ),
    ("application/vnd.oasis.opendocument.image", 485, 1),
    ("application/vnd.oasis.opendocument.image-template", 486, 1),
    ("application/vnd.oasis.opendocument.presentation", 487, 1),
    (
        "application/vnd.oasis.opendocument.presentation-template",
        488,
        1,
    ),
    ("application/vnd.oasis.opendocument.spreadsheet", 489, 1),
    (
        "application/vnd.oasis.opendocument.spreadsheet-template",
        490,
        1,
    ),
    ("application/vnd.oasis.opendocument.text", 491, 1),
    ("application/vnd.oasis.opendocument.text-master", 492, 1),
    ("application/vnd.oasis.opendocument.text-template", 493, 1),
    ("application/vnd.oasis.opendocument.text-web", 494, 1),
    ("application/vnd.olpc-sugar", 495, 1),
    ("application/vnd.oma.dd2+xml", 496, 1),
    ("application/vnd.openblox.game+xml", 497, 1),
    ("application/vnd.openofficeorg.extension", 498, 1),
    ("application/vnd.openstreetmap.data+xml", 499, 1),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.presentation",
        500,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.slide",
        501,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
        502,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.template",
        503,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
        504,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
        505,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        506,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
        507,
        1,
    ),
    ("application/vnd.osgeo.mapguide.package", 508, 1),
    ("application/vnd.osgi.dp", 509, 1),
    ("application/vnd.osgi.subsystem", 510, 1),
    ("application/vnd.palm", 511, 3),
    ("application/vnd.pawaafile", 514, 1),
    ("application/vnd.pg.format", 515, 1),
    ("application/vnd.pg.osasli", 516, 1),
    ("application/vnd.picsel", 517, 1),
    ("application/vnd.pmi.widget", 518, 1),
    ("application/vnd.pocketlearn", 519, 1),
    ("application/vnd.powerbuilder6", 520, 1),
    ("application/vnd.previewsystems.box", 521, 1),
    ("application/vnd.proteus.magazine", 522, 1),
    ("application/vnd.publishare-delta-tree", 523, 1),
    ("application/vnd.pvi.ptid1", 524, 1),
    ("application/vnd.quark.quarkxpress", 525, 6),
    ("application/vnd.rar", 531, 1),
    ("application/vnd.realvnc.bed", 532, 1),
    ("application/vnd.recordare.musicxml", 533, 1),
    ("application/vnd.recordare.musicxml+xml", 534, 1),
    ("application/vnd.rig.cryptonote", 535, 1),
    ("application/vnd.rim.cod", 536, 1),
    ("application/vnd.rn-realmedia", 537, 1),
    ("application/vnd.rn-realmedia-vbr", 538, 1),
    ("application/vnd.route66.link66+xml", 539, 1),
    ("application/vnd.sailingtracker.track", 540, 1),
    ("application/vnd.seemail", 541, 1),
    ("application/vnd.sema", 542, 1),
    ("application/vnd.semd", 543, 1),
    ("application/vnd.semf", 544, 1),
    ("application/vnd.shana.informed.formdata", 545, 1),
    ("application/vnd.shana.informed.formtemplate", 546, 1),
    ("application/vnd.shana.informed.interchange", 547, 1),
    ("application/vnd.shana.informed.package", 548, 1),
    ("application/vnd.simtech-mindmapper", 549, 2),
    ("application/vnd.smaf", 551, 1),
    ("application/vnd.smart.teacher", 552, 1),
    ("application/vnd.software602.filler.form+xml", 553, 1),
    ("application/vnd.solent.sdkm+xml", 554, 2),
    ("application/vnd.spotfire.dxp", 556, 1),
    ("application/vnd.spotfire.sfs", 557, 1),
    ("application/vnd.stardivision.calc", 558, 1),
    ("application/vnd.stardivision.draw", 559, 1),
    ("application/vnd.stardivision.impress", 560, 1),
    ("application/vnd.stardivision.math", 561, 1),
    ("application/vnd.stardivision.writer", 562, 2),
    ("application/vnd.stardivision.writer-global", 564, 1),
    ("application/vnd.stepmania.package", 565, 1),
    ("application/vnd.stepmania.stepchart", 566, 1),
    ("application/vnd.sun.wadl+xml", 567, 1),
    ("application/vnd.sun.xml.calc", 568, 1),
    ("application/vnd.sun.xml.calc.template", 569, 1),
    ("application/vnd.sun.xml.draw", 570, 1),
    ("application/vnd.sun.xml.draw.template", 571, 1),
    ("application/vnd.sun.xml.impress", 572, 1),
    ("application/vnd.sun.xml.impress.template", 573, 1),
    ("application/vnd.sun.xml.math", 574, 1),
    ("application/vnd.sun.xml.writer", 575, 1),
    ("application/vnd.sun.xml.writer.global", 576, 1),
    ("application/vnd.sun.xml.writer.template", 577, 1),
    ("application/vnd.sus-calendar", 578, 2),
    ("application/vnd.svd", 580, 1),
    ("application/vnd.symbian.install", 581, 2),
    ("application/vnd.syncml+xml", 583, 1),
    ("application/vnd.syncml.dm+wbxml", 584, 1),
    ("application/vnd.syncml.dm+xml", 585, 1),
    ("application/vnd.syncml.dmddf+xml", 586, 1),
    ("application/vnd.tao.intent-module-archive", 587, 1),
    ("application/vnd.tcpdump.pcap", 588, 3),
    ("application/vnd.tmobile-livetv", 591, 1),
    ("application/vnd.trid.tpt", 592, 1),
    ("application/vnd.triscape.mxs", 593, 1),
    ("application/vnd.trueapp", 594, 1),
    ("application/vnd.ufdl", 595, 2),
    ("application/vnd.uiq.theme", 597, 1),
    ("application/vnd.umajin", 598, 1),
    ("application/vnd.unity", 599, 1),
    ("application/vnd.uoml+xml", 600, 1),
    ("application/vnd.vcx", 601, 1),
    ("application/vnd.visio", 602, 4),
    ("application/vnd.visionary", 606, 1),
    ("application/vnd.vsf", 607, 1),
    ("application/vnd.wap.wbxml", 608, 1),
    ("application/vnd.wap.wmlc", 609, 1),
    ("application/vnd.wap.wmlscriptc", 610, 1),
    ("application/vnd.webturbo", 611, 1),
    ("application/vnd.wolfram.player", 612, 1),
    ("application/vnd.wordperfect", 613, 1),
    ("application/vnd.wqd", 614, 1),
    ("application/vnd.wt.stf", 615, 1),
    ("application/vnd.xara", 616, 1),
    ("application/vnd.xfdl", 617, 1),
    ("application/vnd.yamaha.hv-dic", 618, 1),
    ("application/vnd.yamaha.hv-script", 619, 1),
    ("application/vnd.yamaha.hv-voice", 620, 1),
    ("application/vnd.yamaha.openscoreformat", 621, 1),
    ("application/vnd.yamaha.openscoreformat.osfpvg+xml", 622, 1),
    ("application/vnd.yamaha.smaf-audio", 623, 1),
    ("application/vnd.yamaha.smaf-phrase", 624, 1),
    ("application/vnd.yellowriver-custom-menu", 625, 1),
    ("application/vnd.zul", 626, 2),
    ("application/vnd.zzazz.deck+xml", 628, 1),
    ("application/voicexml+xml", 629, 1),
    ("application/wasm", 630, 1),
    ("application/widget", 631, 1),
    ("application/winhlp", 632, 1),
    ("application/wsdl+xml", 633, 1),
    ("application/wspolicy+xml", 634, 1),
    ("application/x-7z-compressed", 635, 1),
    ("application/x-abiword", 636, 1),
    ("application/x-ace-compressed", 637, 1),
    ("application/x-apple-diskimage", 638, 1),
    ("application/x-arj", 639, 1),
    ("application/x-authorware-bin", 640, 4),
    ("application/x-authorware-map", 644, 1),
    ("application/x-authorware-seg", 645, 1),
    ("application/x-bcpio", 646, 1),
    ("application/x-bdoc", 647, 1),
    ("application/x-bittorrent", 648, 1),
    ("application/x-blorb", 649, 2),
    ("application/x-bzip", 651, 1),
    ("application/x-bzip2", 652, 2),
    ("application/x-cbr", 654, 5),
    ("application/x-cdlink", 659, 1),
    ("application/x-cfs-compressed", 660, 1),
    ("application/x-chat", 661, 1),
    ("application/x-chess-pgn", 662, 1),
    ("application/x-chrome-extension", 663, 1),
    ("application/x-cocoa", 664, 1),
    ("application/x-conference", 665, 1),
    ("application/x-cpio", 666, 1),
    ("application/x-csh", 667, 1),
    ("application/x-debian-package", 668, 2),
    ("application/x-dgc-compressed", 670, 1),
    ("application/x-director", 671, 9),
    ("application/x-doom", 680, 1),
    ("application/x-dtbncx+xml", 681, 1),
    ("application/x-dtbook+xml", 682, 1),
    ("application/x-dtbresource+xml", 683, 1),
    ("application/x-dvi", 684, 1),
    ("application/x-envoy", 685, 1),
    ("application/x-eva", 686, 1),
    ("application/x-font-bdf", 687, 1),
    ("application/x-font-ghostscript", 688, 1),
    ("application/x-font-linux-psf", 689, 1),
    ("application/x-font-pcf", 690, 1),
    ("application/x-font-snf", 691, 1),
    ("application/x-font-type1", 692, 4),
    ("application/x-freearc", 696, 1),
    ("application/x-futuresplash", 697, 1),
    ("application/x-gca-compressed", 698, 1),
    ("application/x-glulx", 699, 1),
    ("application/x-gnumeric", 700, 1),
    ("application/x-gramps-xml", 701, 1),
    ("application/x-gtar", 702, 1),
    ("application/x-hdf", 703, 1),
    ("application/x-httpd-php", 704, 1),
    ("application/x-install-instructions", 705, 1),
    ("application/x-iso9660-image", 706, 1),
    ("application/x-iwork-keynote-sffkey", 707, 1),
    ("application/x-iwork-numbers-sffnumbers", 708, 1),
    ("application/x-iwork-pages-sffpages", 709, 1),
    ("application/x-java-archive-diff", 710, 1),
    ("application/x-java-jnlp-file", 711, 1),
    ("application/x-keepass2", 712, 1),
    ("application/x-latex", 713, 1),
    ("application/x-lua-bytecode", 714, 1),
    ("application/x-lzh-compressed", 715, 2),
    ("application/x-makeself", 717, 1),
    ("application/x-mie", 718, 1),
    ("application/x-mobipocket-ebook", 719, 2),
    ("application/x-ms-application", 721, 1),
    ("application/x-ms-shortcut", 722, 1),
    ("application/x-ms-wmd", 723, 1),
    ("application/x-ms-wmz", 724, 1),
    ("application/x-ms-xbap", 725, 1),
    ("application/x-msaccess", 726, 1),
    ("application/x-msbinder", 727, 1),
    ("application/x-mscardfile", 728, 1),
    ("application/x-msclip", 729, 1),
    ("application/x-msdos-program", 730, 1),
    ("application/x-msdownload", 731, 5),
    ("application/x-msmediaview", 736, 3),
    ("application/x-msmetafile", 739, 4),
    ("application/x-msmoney", 743, 1),
    ("application/x-mspublisher", 744, 1),
    ("application/x-msschedule", 745, 1),
    ("application/x-msterminal", 746, 1),
    ("application/x-mswrite", 747, 1),
    ("application/x-netcdf", 748, 2),
    ("application/x-ns-proxy-autoconfig", 750, 1),
    ("application/x-nzb", 751, 1),
    ("application/x-perl", 752, 2),
    ("application/x-pilot", 754, 2),
    ("application/x-pkcs12", 756, 2),
    ("application/x-pkcs7-certificates", 758, 2),
    ("application/x-pkcs7-certreqresp", 760, 1),
    ("application/x-rar-compressed", 761, 1),
    ("application/x-redhat-package-manager", 762, 1),
    ("application/x-research-info-systems", 763, 1),
    ("application/x-sea", 764, 1),
    ("application/x-sh", 765, 1),
    ("application/x-shar", 766, 1),
    ("application/x-shockwave-flash", 767, 1),
    ("application/x-silverlight-app", 768, 1),
    ("application/x-sql", 769, 1),
    ("application/x-stuffit", 770, 1),
    ("application/x-stuffitx", 771, 1),
    ("application/x-subrip", 772, 1),
    ("application/x-sv4cpio", 773, 1),
    ("application/x-sv4crc", 774, 1),
    ("application/x-t3vm-image", 775, 1),
    ("application/x-tads", 776, 1),
    ("application/x-tar", 777, 1),
    ("application/x-tcl", 778, 2),
    ("application/x-tex", 780, 1),
    ("application/x-tex-tfm", 781, 1),
    ("application/x-texinfo", 782, 2),
    ("application/x-tgif", 784, 1),
    ("application/x-ustar", 785, 1),
    ("application/x-virtualbox-hdd", 786, 1),
    ("application/x-virtualbox-ova", 787, 1),
    ("application/x-virtualbox-ovf", 788, 1),
    ("application/x-virtualbox-vbox", 789, 1),
    ("application/x-virtualbox-vbox-extpack", 790, 1),
    ("application/x-virtualbox-vdi", 791, 1),
    ("application/x-virtualbox-vhd", 792, 1),
    ("application/x-virtualbox-vmdk", 793, 1),
    ("application/x-wais-source", 794, 1),
    ("application/x-web-app-manifest+json", 795, 1),
    ("application/x-x509-ca-cert", 796, 3),
    ("application/x-xfig", 799, 1),
    ("application/x-xliff+xml", 800, 1),
    ("application/x-xpinstall", 801, 1),
    ("application/x-xz", 802, 1),
    ("application/x-zmachine", 803, 8),
    ("application/xaml+xml", 811, 1),
    ("application/xcap-att+xml", 812, 1),
    ("application/xcap-caps+xml", 813, 1),
    ("application/xcap-diff+xml", 814, 1),
    ("application/xcap-el+xml", 815, 1),
    ("application/xcap-ns+xml", 816, 1),
    ("application/xenc+xml", 817, 1),
    ("application/xhtml+xml", 818, 2),
    ("application/xliff+xml", 820, 1),
    ("application/xml", 821, 4),
    ("application/xml-dtd", 825, 1),
    ("application/xop+xml", 826, 1),
    ("application/xproc+xml", 827, 1),
    ("application/xslt+xml", 828, 2),
    ("application/xspf+xml", 830, 1),
    ("application/xv+xml", 831, 4),
    ("application/yang", 835, 1),
    ("application/yin+xml", 836, 1),
    ("application/zip", 837, 1),
    ("audio/3gpp", 838, 1),
    ("audio/adpcm", 839, 1),
    ("audio/amr", 840, 1),
    ("audio/basic", 841, 2),
    ("audio/midi", 843, 4),
    ("audio/mobile-xmf", 847, 1),
    ("audio/mp3", 848, 1),
    ("audio/mp4", 849, 2),
    ("audio/mpeg", 851, 6),
    ("audio/ogg", 857, 4),
    ("audio/s3m", 861, 1),
    ("audio/silk", 862, 1),
    ("audio/vnd.dece.audio", 863, 2),
    ("audio/vnd.digital-winds", 865, 1),
    ("audio/vnd.dra", 866, 1),
    ("audio/vnd.dts", 867, 1),
    ("audio/vnd.dts.hd", 868, 1),
    ("audio/vnd.lucent.voice", 869, 1),
    ("audio/vnd.ms-playready.media.pya", 870, 1),
    ("audio/vnd.nuera.ecelp4800", 871, 1),
    ("audio/vnd.nuera.ecelp7470", 872, 1),
    ("audio/vnd.nuera.ecelp9600", 873, 1),
    ("audio/vnd.rip", 874, 1),
    ("audio/wav", 875, 1),
    ("audio/wave", 876, 1),
    ("audio/webm", 877, 1),
    ("audio/x-aac", 878, 1),
    ("audio/x-aiff", 879, 3),
    ("audio/x-caf", 882, 1),
    ("audio/x-flac", 883, 1),
    ("audio/x-m4a", 884, 1),
    ("audio/x-matroska", 885, 1),
    ("audio/x-mpegurl", 886, 1),
    ("audio/x-ms-wax", 887, 1),
    ("audio/x-ms-wma", 888, 1),
    ("audio/x-pn-realaudio", 889, 2),
    ("audio/x-pn-realaudio-plugin", 891, 1),
    ("audio/x-realaudio", 892, 1),
    ("audio/x-wav", 893, 1),
    ("audio/xm", 894, 1),
    ("chemical/x-cdx", 895, 1),
    ("chemical/x-cif", 896, 1),
    ("chemical/x-cmdf", 897, 1),
    ("chemical/x-cml", 898, 1),
    ("chemical/x-csml", 899, 1),
    ("chemical/x-xyz", 900, 1),
    ("font/collection", 901, 1),
    ("font/otf", 902, 1),
    ("font/ttf", 903, 1),
    ("font/woff", 904, 1),
    ("font/woff2", 905, 1),
    ("image/aces", 906, 1),
    ("image/apng", 907, 1),
    ("image/avif", 908, 1),
    ("image/bmp", 909, 1),
    ("image/cgm", 910, 1),
    ("image/dicom-rle", 911, 1),
    ("image/emf", 912, 1),
    ("image/fits", 913, 1),
    ("image/g3fax", 914, 1),
    ("image/gif", 915, 1),
    ("image/heic", 916, 1),
    ("image/heic-sequence", 917, 1),
    ("image/heif", 918, 1),
    ("image/heif-sequence", 919, 1),
    ("image/hej2k", 920, 1),
    ("image/hsj2", 921, 1),
    ("image/ief", 922, 1),
    ("image/jls", 923, 1),
    ("image/jp2", 924, 2),
    ("image/jpeg", 926, 3),
    ("image/jph", 929, 1),
    ("image/jphc", 930, 1),
    ("image/jpm", 931, 1),
    ("image/jpx", 932, 2),
    ("image/jxr", 934, 1),
    ("image/jxra", 935, 1),
    ("image/jxrs", 936, 1),
    ("image/jxs", 937, 1),
    ("image/jxsc", 938, 1),
    ("image/jxsi", 939, 1),
    ("image/jxss", 940, 1),
    ("image/ktx", 941, 1),
    ("image/ktx2", 942, 1),
    ("image/png", 943, 1),
    ("image/prs.btif", 944, 1),
    ("image/prs.pti", 945, 1),
    ("image/sgi", 946, 1),
    ("image/svg+xml", 947, 2),
    ("image/t38", 949, 1),
    ("image/tiff", 950, 2),
    ("image/tiff-fx", 952, 1),
    ("image/vnd.adobe.photoshop", 953, 1),
    ("image/vnd.airzip.accelerator.azv", 954, 1),
    ("image/vnd.dece.graphic", 955, 4),
    ("image/vnd.djvu", 959, 2),
    ("image/vnd.dvb.subtitle", 961, 1),
    ("image/vnd.dwg", 962, 1),
    ("image/vnd.dxf", 963, 1),
    ("image/vnd.fastbidsheet", 964, 1),
    ("image/vnd.fpx", 965, 1),
    ("image/vnd.fst", 966, 1),
    ("image/vnd.fujixerox.edmics-mmr", 967, 1),
    ("image/vnd.fujixerox.edmics-rlc", 968, 1),
    ("image/vnd.microsoft.icon", 969, 1),
    ("image/vnd.ms-dds", 970, 1),
    ("image/vnd.ms-modi", 971, 1),
    ("image/vnd.ms-photo", 972, 1),
    ("image/vnd.net-fpx", 973, 1),
    ("image/vnd.pco.b16", 974, 1),
    ("image/vnd.tencent.tap", 975, 1),
    ("image/vnd.valve.source.texture", 976, 1),
    ("image/vnd.wap.wbmp", 977, 1),
    ("image/vnd.xiff", 978, 1),
    ("image/vnd.zbrush.pcx", 979, 1),
    ("image/webp", 980, 1),
    ("image/wmf", 981, 1),
    ("image/x-3ds", 982, 1),
    ("image/x-cmu-raster", 983, 1),
    ("image/x-cmx", 984, 1),
    ("image/x-freehand", 985, 5),
    ("image/x-icon", 990, 1),
    ("image/x-jng", 991, 1),
    ("image/x-mrsid-image", 992, 1),
    ("image/x-ms-bmp", 993, 1),
    ("image/x-pcx", 994, 1),
    ("image/x-pict", 995, 2),
    ("image/x-portable-anymap", 997, 1),
    ("image/x-portable-bitmap", 998, 1),
    ("image/x-portable-graymap", 999, 1),
    ("image/x-portable-pixmap", 1000, 1),
    ("image/x-rgb", 1001, 1),
    ("image/x-tga", 1002, 1),
    ("image/x-xbitmap", 1003, 1),
    ("image/x-xpixmap", 1004, 1),
    ("image/x-xwindowdump", 1005, 1),
    ("message/disposition-notification", 1006, 1),
    ("message/global", 1007, 1),
    ("message/global-delivery-status", 1008, 1),
    ("message/global-disposition-notification", 1009, 1),
    ("message/global-headers", 1010, 1),
    ("message/rfc822", 1011, 2),
    ("message/vnd.wfa.wsc", 1013, 1),
    ("model/3mf", 1014, 1),
    ("model/gltf+json", 1015, 1),
    ("model/gltf-binary", 1016, 1),
    ("model/iges", 1017, 2),
    ("model/mesh", 1019, 3),
    ("model/mtl", 1022, 1),
    ("model/obj", 1023, 1),
    ("model/step+xml", 1024, 1),
    ("model/step+zip", 1025, 1),
    ("model/step-xml+zip", 1026, 1),
    ("model/stl", 1027, 1),
    ("model/vnd.collada+xml", 1028, 1),
    ("model/vnd.dwf", 1029, 1),
    ("model/vnd.gdl", 1030, 1),
    ("model/vnd.gtw", 1031, 1),
    ("model/vnd.mts", 1032, 1),
    ("model/vnd.opengex", 1033, 1),
    ("model/vnd.parasolid.transmit.binary", 1034, 1),
    ("model/vnd.parasolid.transmit.text", 1035, 1),
    ("model/vnd.sap.vds", 1036, 1),
    ("model/vnd.usdz+zip", 1037, 1),
    ("model/vnd.valve.source.compiled-map", 1038, 1),
    ("model/vnd.vtu", 1039, 1),
    ("model/vrml", 1040, 2),
    ("model/x3d+binary", 1042, 2),
    ("model/x3d+fastinfoset", 1044, 1),
    ("model/x3d+vrml", 1045, 2),
    ("model/x3d+xml", 1047, 2),
    ("model/x3d-vrml", 1049, 1),
    ("text/cache-manifest", 1050, 2),
    ("text/calendar", 1052, 2),
    ("text/coffeescript", 1054, 2),
    ("text/css", 1056, 1),
    ("text/csv", 1057, 1),
    ("text/html", 1058, 3),
    ("text/jade", 1061, 1),
    ("text/jsx", 1062, 1),
    ("text/less", 1063, 1),
    ("text/markdown", 1064, 2),
    ("text/mathml", 1066, 1),
    ("text/mdx", 1067, 1),
    ("text/n3", 1068, 1),
    ("text/plain", 1069, 8),
    ("text/prs.lines.tag", 1077, 1),
    ("text/richtext", 1078, 1),
    ("text/rtf", 1079, 1),
    ("text/sgml", 1080, 2),
    ("text/shex", 1082, 1),
    ("text/slim", 1083, 2),
    ("text/spdx", 1085, 1),
    ("text/stylus", 1086, 2),
    ("text/tab-separated-values", 1088, 1),
    ("text/troff", 1089, 6),
    ("text/turtle", 1095, 1),
    ("text/uri-list", 1096, 3),
    ("text/vcard", 1099, 1),
    ("text/vnd.curl", 1100, 1),
    ("text/vnd.curl.dcurl", 1101, 1),
    ("text/vnd.curl.mcurl", 1102, 1),
    ("text/vnd.curl.scurl", 1103, 1),
    ("text/vnd.dvb.subtitle", 1104, 1),
    ("text/vnd.fly", 1105, 1),
    ("text/vnd.fmi.flexstor", 1106, 1),
    ("text/vnd.graphviz", 1107, 1),
    ("text/vnd.in3d.3dml", 1108, 1),
    ("text/vnd.in3d.spot", 1109, 1),
    ("text/vnd.sun.j2me.app-descriptor", 1110, 1),
    ("text/vnd.wap.wml", 1111, 1),
    ("text/vnd.wap.wmlscript", 1112, 1),
    ("text/vtt", 1113, 1),
    ("text/x-asm", 1114, 2),
    ("text/x-c", 1116, 7),
    ("text/x-component", 1123, 1),
    ("text/x-fortran", 1124, 4),
    ("text/x-handlebars-template", 1128, 1),
    ("text/x-java-source", 1129, 1),
    ("text/x-lua", 1130, 1),
    ("text/x-markdown", 1131, 1),
    ("text/x-nfo", 1132, 1),
    ("text/x-opml", 1133, 1),
    ("text/x-org", 1134, 1),
    ("text/x-pascal", 1135, 2),
    ("text/x-processing", 1137, 1),
    ("text/x-sass", 1138, 1),
    ("text/x-scss", 1139, 1),
    ("text/x-setext", 1140, 1),
    ("text/x-sfv", 1141, 1),
    ("text/x-suse-ymp", 1142, 1),
    ("text/x-uuencode", 1143, 1),
    ("text/x-vcalendar", 1144, 1),
    ("text/x-vcard", 1145, 1),
    ("text/xml", 1146, 1),
    ("text/yaml", 1147, 2),
    ("video/3gpp", 1149, 2),
    ("video/3gpp2", 1151, 1),
    ("video/h261", 1152, 1),
    ("video/h263", 1153, 1),
    ("video/h264", 1154, 1),
    ("video/iso.segment", 1155, 1),
    ("video/jpeg", 1156, 1),
    ("video/jpm", 1157, 2),
    ("video/mj2", 1159, 2),
    ("video/mp2t", 1161, 1),
    ("video/mp4", 1162, 3),
    ("video/mpeg", 1165, 5),
    ("video/ogg", 1170, 1),
    ("video/quicktime", 1171, 2),
    ("video/vnd.dece.hd", 1173, 2),
    ("video/vnd.dece.mobile", 1175, 2),
    ("video/vnd.dece.pd", 1177, 2),
    ("video/vnd.dece.sd", 1179, 2),
    ("video/vnd.dece.video", 1181, 2),
    ("video/vnd.dvb.file", 1183, 1),
    ("video/vnd.fvt", 1184, 1),
    ("video/vnd.mpegurl", 1185, 2),
    ("video/vnd.ms-playready.media.pyv", 1187, 1),
    ("video/vnd.uvvu.mp4", 1188, 2),
    ("video/vnd.vivo", 1190, 1),
    ("video/webm", 1191, 1),
    ("video/x-f4v", 1192, 1),
    ("video/x-fli", 1193, 1),
    ("video/x-flv", 1194, 1),
    ("video/x-m4v", 1195, 1),
    ("video/x-matroska", 1196, 3),
    ("video/x-mng", 1199, 1),
    ("video/x-ms-asf", 1200, 2),
    ("video/x-ms-vob", 1202, 1),
    ("video/x-ms-wm", 1203, 1),
    ("video/x-ms-wmv", 1204, 1),
    ("video/x-ms-wmx", 1205, 1),
    ("video/x-ms-wvx", 1206, 1),
    ("video/x-msvideo", 1207, 1),
    ("video/x-sgi-movie", 1208, 1),
    ("video/x-smv", 1209, 1),
    ("x-conference/x-cooltalk", 1210, 1),
];
