pub const TYPES: [(&str, usize, usize); 951] = [
    ("application/andrew-inset", 0, 1),
    ("application/applixware", 1, 1),
    ("application/atom+xml", 2, 1),
    ("application/atomcat+xml", 3, 1),
    ("application/atomdeleted+xml", 4, 1),
    ("application/atomsvc+xml", 5, 1),
    ("application/atsc-dwd+xml", 6, 1),
    ("application/atsc-held+xml", 7, 1),
    ("application/atsc-rsat+xml", 8, 1),
    ("application/bdoc", 9, 1),
    ("application/calendar+xml", 10, 1),
    ("application/ccxml+xml", 11, 1),
    ("application/cdfx+xml", 12, 1),
    ("application/cdmi-capability", 13, 1),
    ("application/cdmi-container", 14, 1),
    ("application/cdmi-domain", 15, 1),
    ("application/cdmi-object", 16, 1),
    ("application/cdmi-queue", 17, 1),
    ("application/cu-seeme", 18, 1),
    ("application/dash+xml", 19, 1),
    ("application/davmount+xml", 20, 1),
    ("application/docbook+xml", 21, 1),
    ("application/dssc+der", 22, 1),
    ("application/dssc+xml", 23, 1),
    ("application/ecmascript", 24, 2),
    ("application/emma+xml", 26, 1),
    ("application/emotionml+xml", 27, 1),
    ("application/epub+zip", 28, 1),
    ("application/exi", 29, 1),
    ("application/fdt+xml", 30, 1),
    ("application/font-tdpfr", 31, 1),
    ("application/geo+json", 32, 1),
    ("application/gml+xml", 33, 1),
    ("application/gpx+xml", 34, 1),
    ("application/gxf", 35, 1),
    ("application/gzip", 36, 1),
    ("application/hjson", 37, 1),
    ("application/hyperstudio", 38, 1),
    ("application/inkml+xml", 39, 2),
    ("application/ipfix", 41, 1),
    ("application/its+xml", 42, 1),
    ("application/java-archive", 43, 3),
    ("application/java-serialized-object", 46, 1),
    ("application/java-vm", 47, 1),
    ("application/javascript", 48, 2),
    ("application/json", 50, 2),
    ("application/json5", 52, 1),
    ("application/jsonml+json", 53, 1),
    ("application/ld+json", 54, 1),
    ("application/lgr+xml", 55, 1),
    ("application/lost+xml", 56, 1),
    ("application/mac-binhex40", 57, 1),
    ("application/mac-compactpro", 58, 1),
    ("application/mads+xml", 59, 1),
    ("application/manifest+json", 60, 1),
    ("application/marc", 61, 1),
    ("application/marcxml+xml", 62, 1),
    ("application/mathematica", 63, 3),
    ("application/mathml+xml", 66, 1),
    ("application/mbox", 67, 1),
    ("application/mediaservercontrol+xml", 68, 1),
    ("application/metalink+xml", 69, 1),
    ("application/metalink4+xml", 70, 1),
    ("application/mets+xml", 71, 1),
    ("application/mmt-aei+xml", 72, 1),
    ("application/mmt-usd+xml", 73, 1),
    ("application/mods+xml", 74, 1),
    ("application/mp21", 75, 2),
    ("application/mp4", 77, 2),
    ("application/msword", 79, 2),
    ("application/mxf", 81, 1),
    ("application/n-quads", 82, 1),
    ("application/n-triples", 83, 1),
    ("application/node", 84, 1),
    ("application/octet-stream", 85, 22),
    ("application/oda", 107, 1),
    ("application/oebps-package+xml", 108, 1),
    ("application/ogg", 109, 1),
    ("application/omdoc+xml", 110, 1),
    ("application/onenote", 111, 4),
    ("application/oxps", 115, 1),
    ("application/p2p-overlay+xml", 116, 1),
    ("application/patch-ops-error+xml", 117, 1),
    ("application/pdf", 118, 1),
    ("application/pgp-encrypted", 119, 1),
    ("application/pgp-signature", 120, 2),
    ("application/pics-rules", 122, 1),
    ("application/pkcs10", 123, 1),
    ("application/pkcs7-mime", 124, 2),
    ("application/pkcs7-signature", 126, 1),
    ("application/pkcs8", 127, 1),
    ("application/pkix-attr-cert", 128, 1),
    ("application/pkix-cert", 129, 1),
    ("application/pkix-crl", 130, 1),
    ("application/pkix-pkipath", 131, 1),
    ("application/pkixcmp", 132, 1),
    ("application/pls+xml", 133, 1),
    ("application/postscript", 134, 3),
    ("application/provenance+xml", 137, 1),
    ("application/prs.cww", 138, 1),
    ("application/pskc+xml", 139, 1),
    ("application/raml+yaml", 140, 1),
    ("application/rdf+xml", 141, 2),
    ("application/reginfo+xml", 143, 1),
    ("application/relax-ng-compact-syntax", 144, 1),
    ("application/resource-lists+xml", 145, 1),
    ("application/resource-lists-diff+xml", 146, 1),
    ("application/rls-services+xml", 147, 1),
    ("application/route-apd+xml", 148, 1),
    ("application/route-s-tsid+xml", 149, 1),
    ("application/route-usd+xml", 150, 1),
    ("application/rpki-ghostbusters", 151, 1),
    ("application/rpki-manifest", 152, 1),
    ("application/rpki-roa", 153, 1),
    ("application/rsd+xml", 154, 1),
    ("application/rss+xml", 155, 1),
    ("application/rtf", 156, 1),
    ("application/sbml+xml", 157, 1),
    ("application/scvp-cv-request", 158, 1),
    ("application/scvp-cv-response", 159, 1),
    ("application/scvp-vp-request", 160, 1),
    ("application/scvp-vp-response", 161, 1),
    ("application/sdp", 162, 1),
    ("application/senml+xml", 163, 1),
    ("application/sensml+xml", 164, 1),
    ("application/set-payment-initiation", 165, 1),
    ("application/set-registration-initiation", 166, 1),
    ("application/shf+xml", 167, 1),
    ("application/sieve", 168, 2),
    ("application/smil+xml", 170, 2),
    ("application/sparql-query", 172, 1),
    ("application/sparql-results+xml", 173, 1),
    ("application/srgs", 174, 1),
    ("application/srgs+xml", 175, 1),
    ("application/sru+xml", 176, 1),
    ("application/ssdl+xml", 177, 1),
    ("application/ssml+xml", 178, 1),
    ("application/swid+xml", 179, 1),
    ("application/tei+xml", 180, 2),
    ("application/thraud+xml", 182, 1),
    ("application/timestamped-data", 183, 1),
    ("application/toml", 184, 1),
    ("application/trig", 185, 1),
    ("application/ttml+xml", 186, 1),
    ("application/ubjson", 187, 1),
    ("application/urc-ressheet+xml", 188, 1),
    ("application/urc-targetdesc+xml", 189, 1),
    ("application/vnd.1000minds.decision-model+xml", 190, 1),
    ("application/vnd.3gpp.pic-bw-large", 191, 1),
    ("application/vnd.3gpp.pic-bw-small", 192, 1),
    ("application/vnd.3gpp.pic-bw-var", 193, 1),
    ("application/vnd.3gpp2.tcap", 194, 1),
    ("application/vnd.3m.post-it-notes", 195, 1),
    ("application/vnd.accpac.simply.aso", 196, 1),
    ("application/vnd.accpac.simply.imp", 197, 1),
    ("application/vnd.acucobol", 198, 1),
    ("application/vnd.acucorp", 199, 2),
    (
        "application/vnd.adobe.air-application-installer-package+zip",
        201,
        1,
    ),
    ("application/vnd.adobe.formscentral.fcdt", 202, 1),
    ("application/vnd.adobe.fxp", 203, 2),
    ("application/vnd.adobe.xdp+xml", 205, 1),
    ("application/vnd.adobe.xfdf", 206, 1),
    ("application/vnd.ahead.space", 207, 1),
    ("application/vnd.airzip.filesecure.azf", 208, 1),
    ("application/vnd.airzip.filesecure.azs", 209, 1),
    ("application/vnd.amazon.ebook", 210, 1),
    ("application/vnd.americandynamics.acc", 211, 1),
    ("application/vnd.amiga.ami", 212, 1),
    ("application/vnd.android.package-archive", 213, 1),
    (
        "application/vnd.anser-web-certificate-issue-initiation",
        214,
        1,
    ),
    (
        "application/vnd.anser-web-funds-transfer-initiation",
        215,
        1,
    ),
    ("application/vnd.antix.game-component", 216, 1),
    ("application/vnd.apple.installer+xml", 217, 1),
    ("application/vnd.apple.keynote", 218, 1),
    ("application/vnd.apple.mpegurl", 219, 1),
    ("application/vnd.apple.numbers", 220, 1),
    ("application/vnd.apple.pages", 221, 1),
    ("application/vnd.apple.pkpass", 222, 1),
    ("application/vnd.aristanetworks.swi", 223, 1),
    ("application/vnd.astraea-software.iota", 224, 1),
    ("application/vnd.audiograph", 225, 1),
    ("application/vnd.balsamiq.bmml+xml", 226, 1),
    ("application/vnd.blueice.multipass", 227, 1),
    ("application/vnd.bmi", 228, 1),
    ("application/vnd.businessobjects", 229, 1),
    ("application/vnd.chemdraw+xml", 230, 1),
    ("application/vnd.chipnuts.karaoke-mmd", 231, 1),
    ("application/vnd.cinderella", 232, 1),
    ("application/vnd.citationstyles.style+xml", 233, 1),
    ("application/vnd.claymore", 234, 1),
    ("application/vnd.cloanto.rp9", 235, 1),
    ("application/vnd.clonk.c4group", 236, 5),
    ("application/vnd.cluetrust.cartomobile-config", 241, 1),
    ("application/vnd.cluetrust.cartomobile-config-pkg", 242, 1),
    ("application/vnd.commonspace", 243, 1),
    ("application/vnd.contact.cmsg", 244, 1),
    ("application/vnd.cosmocaller", 245, 1),
    ("application/vnd.crick.clicker", 246, 1),
    ("application/vnd.crick.clicker.keyboard", 247, 1),
    ("application/vnd.crick.clicker.palette", 248, 1),
    ("application/vnd.crick.clicker.template", 249, 1),
    ("application/vnd.crick.clicker.wordbank", 250, 1),
    ("application/vnd.criticaltools.wbs+xml", 251, 1),
    ("application/vnd.ctc-posml", 252, 1),
    ("application/vnd.cups-ppd", 253, 1),
    ("application/vnd.curl.car", 254, 1),
    ("application/vnd.curl.pcurl", 255, 1),
    ("application/vnd.dart", 256, 1),
    ("application/vnd.data-vision.rdz", 257, 1),
    ("application/vnd.dbf", 258, 1),
    ("application/vnd.dece.data", 259, 4),
    ("application/vnd.dece.ttml+xml", 263, 2),
    ("application/vnd.dece.unspecified", 265, 2),
    ("application/vnd.dece.zip", 267, 2),
    ("application/vnd.denovo.fcselayout-link", 269, 1),
    ("application/vnd.dna", 270, 1),
    ("application/vnd.dolby.mlp", 271, 1),
    ("application/vnd.dpgraph", 272, 1),
    ("application/vnd.dreamfactory", 273, 1),
    ("application/vnd.ds-keypoint", 274, 1),
    ("application/vnd.dvb.ait", 275, 1),
    ("application/vnd.dvb.service", 276, 1),
    ("application/vnd.dynageo", 277, 1),
    ("application/vnd.ecowin.chart", 278, 1),
    ("application/vnd.enliven", 279, 1),
    ("application/vnd.epson.esf", 280, 1),
    ("application/vnd.epson.msf", 281, 1),
    ("application/vnd.epson.quickanime", 282, 1),
    ("application/vnd.epson.salt", 283, 1),
    ("application/vnd.epson.ssf", 284, 1),
    ("application/vnd.eszigno3+xml", 285, 2),
    ("application/vnd.ezpix-album", 287, 1),
    ("application/vnd.ezpix-package", 288, 1),
    ("application/vnd.fdf", 289, 1),
    ("application/vnd.fdsn.mseed", 290, 1),
    ("application/vnd.fdsn.seed", 291, 2),
    ("application/vnd.flographit", 293, 1),
    ("application/vnd.fluxtime.clip", 294, 1),
    ("application/vnd.framemaker", 295, 4),
    ("application/vnd.frogans.fnc", 299, 1),
    ("application/vnd.frogans.ltf", 300, 1),
    ("application/vnd.fsc.weblaunch", 301, 1),
    ("application/vnd.fujitsu.oasys", 302, 1),
    ("application/vnd.fujitsu.oasys2", 303, 1),
    ("application/vnd.fujitsu.oasys3", 304, 1),
    ("application/vnd.fujitsu.oasysgp", 305, 1),
    ("application/vnd.fujitsu.oasysprs", 306, 1),
    ("application/vnd.fujixerox.ddd", 307, 1),
    ("application/vnd.fujixerox.docuworks", 308, 1),
    ("application/vnd.fujixerox.docuworks.binder", 309, 1),
    ("application/vnd.fuzzysheet", 310, 1),
    ("application/vnd.genomatix.tuxedo", 311, 1),
    ("application/vnd.geogebra.file", 312, 1),
    ("application/vnd.geogebra.tool", 313, 1),
    ("application/vnd.geometry-explorer", 314, 2),
    ("application/vnd.geonext", 316, 1),
    ("application/vnd.geoplan", 317, 1),
    ("application/vnd.geospace", 318, 1),
    ("application/vnd.gmx", 319, 1),
    ("application/vnd.google-apps.document", 320, 1),
    ("application/vnd.google-apps.presentation", 321, 1),
    ("application/vnd.google-apps.spreadsheet", 322, 1),
    ("application/vnd.google-earth.kml+xml", 323, 1),
    ("application/vnd.google-earth.kmz", 324, 1),
    ("application/vnd.grafeq", 325, 2),
    ("application/vnd.groove-account", 327, 1),
    ("application/vnd.groove-help", 328, 1),
    ("application/vnd.groove-identity-message", 329, 1),
    ("application/vnd.groove-injector", 330, 1),
    ("application/vnd.groove-tool-message", 331, 1),
    ("application/vnd.groove-tool-template", 332, 1),
    ("application/vnd.groove-vcard", 333, 1),
    ("application/vnd.hal+xml", 334, 1),
    ("application/vnd.handheld-entertainment+xml", 335, 1),
    ("application/vnd.hbci", 336, 1),
    ("application/vnd.hhe.lesson-player", 337, 1),
    ("application/vnd.hp-hpgl", 338, 1),
    ("application/vnd.hp-hpid", 339, 1),
    ("application/vnd.hp-hps", 340, 1),
    ("application/vnd.hp-jlyt", 341, 1),
    ("application/vnd.hp-pcl", 342, 1),
    ("application/vnd.hp-pclxl", 343, 1),
    ("application/vnd.hydrostatix.sof-data", 344, 1),
    ("application/vnd.ibm.minipay", 345, 1),
    ("application/vnd.ibm.modcap", 346, 3),
    ("application/vnd.ibm.rights-management", 349, 1),
    ("application/vnd.ibm.secure-container", 350, 1),
    ("application/vnd.iccprofile", 351, 2),
    ("application/vnd.igloader", 353, 1),
    ("application/vnd.immervision-ivp", 354, 1),
    ("application/vnd.immervision-ivu", 355, 1),
    ("application/vnd.insors.igm", 356, 1),
    ("application/vnd.intercon.formnet", 357, 2),
    ("application/vnd.intergeo", 359, 1),
    ("application/vnd.intu.qbo", 360, 1),
    ("application/vnd.intu.qfx", 361, 1),
    ("application/vnd.ipunplugged.rcprofile", 362, 1),
    ("application/vnd.irepository.package+xml", 363, 1),
    ("application/vnd.is-xpr", 364, 1),
    ("application/vnd.isac.fcs", 365, 1),
    ("application/vnd.jam", 366, 1),
    ("application/vnd.jcp.javame.midlet-rms", 367, 1),
    ("application/vnd.jisp", 368, 1),
    ("application/vnd.joost.joda-archive", 369, 1),
    ("application/vnd.kahootz", 370, 2),
    ("application/vnd.kde.karbon", 372, 1),
    ("application/vnd.kde.kchart", 373, 1),
    ("application/vnd.kde.kformula", 374, 1),
    ("application/vnd.kde.kivio", 375, 1),
    ("application/vnd.kde.kontour", 376, 1),
    ("application/vnd.kde.kpresenter", 377, 2),
    ("application/vnd.kde.kspread", 379, 1),
    ("application/vnd.kde.kword", 380, 2),
    ("application/vnd.kenameaapp", 382, 1),
    ("application/vnd.kidspiration", 383, 1),
    ("application/vnd.kinar", 384, 2),
    ("application/vnd.koan", 386, 4),
    ("application/vnd.kodak-descriptor", 390, 1),
    ("application/vnd.las.las+xml", 391, 1),
    ("application/vnd.llamagraphics.life-balance.desktop", 392, 1),
    (
        "application/vnd.llamagraphics.life-balance.exchange+xml",
        393,
        1,
    ),
    ("application/vnd.lotus-1-2-3", 394, 1),
    ("application/vnd.lotus-approach", 395, 1),
    ("application/vnd.lotus-freelance", 396, 1),
    ("application/vnd.lotus-notes", 397, 1),
    ("application/vnd.lotus-organizer", 398, 1),
    ("application/vnd.lotus-screencam", 399, 1),
    ("application/vnd.lotus-wordpro", 400, 1),
    ("application/vnd.macports.portpkg", 401, 1),
    ("application/vnd.mapbox-vector-tile", 402, 1),
    ("application/vnd.mcd", 403, 1),
    ("application/vnd.medcalcdata", 404, 1),
    ("application/vnd.mediastation.cdkey", 405, 1),
    ("application/vnd.mfer", 406, 1),
    ("application/vnd.mfmp", 407, 1),
    ("application/vnd.micrografx.flo", 408, 1),
    ("application/vnd.micrografx.igx", 409, 1),
    ("application/vnd.mif", 410, 1),
    ("application/vnd.mobius.daf", 411, 1),
    ("application/vnd.mobius.dis", 412, 1),
    ("application/vnd.mobius.mbk", 413, 1),
    ("application/vnd.mobius.mqy", 414, 1),
    ("application/vnd.mobius.msl", 415, 1),
    ("application/vnd.mobius.plc", 416, 1),
    ("application/vnd.mobius.txf", 417, 1),
    ("application/vnd.mophun.application", 418, 1),
    ("application/vnd.mophun.certificate", 419, 1),
    ("application/vnd.mozilla.xul+xml", 420, 1),
    ("application/vnd.ms-artgalry", 421, 1),
    ("application/vnd.ms-cab-compressed", 422, 1),
    ("application/vnd.ms-excel", 423, 6),
    ("application/vnd.ms-excel.addin.macroenabled.12", 429, 1),
    (
        "application/vnd.ms-excel.sheet.binary.macroenabled.12",
        430,
        1,
    ),
    ("application/vnd.ms-excel.sheet.macroenabled.12", 431, 1),
    ("application/vnd.ms-excel.template.macroenabled.12", 432, 1),
    ("application/vnd.ms-fontobject", 433, 1),
    ("application/vnd.ms-htmlhelp", 434, 1),
    ("application/vnd.ms-ims", 435, 1),
    ("application/vnd.ms-lrm", 436, 1),
    ("application/vnd.ms-officetheme", 437, 1),
    ("application/vnd.ms-outlook", 438, 1),
    ("application/vnd.ms-pki.seccat", 439, 1),
    ("application/vnd.ms-pki.stl", 440, 1),
    ("application/vnd.ms-powerpoint", 441, 3),
    (
        "application/vnd.ms-powerpoint.addin.macroenabled.12",
        444,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.presentation.macroenabled.12",
        445,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.slide.macroenabled.12",
        446,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.slideshow.macroenabled.12",
        447,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.template.macroenabled.12",
        448,
        1,
    ),
    ("application/vnd.ms-project", 449, 2),
    ("application/vnd.ms-word.document.macroenabled.12", 451, 1),
    ("application/vnd.ms-word.template.macroenabled.12", 452, 1),
    ("application/vnd.ms-works", 453, 4),
    ("application/vnd.ms-wpl", 457, 1),
    ("application/vnd.ms-xpsdocument", 458, 1),
    ("application/vnd.mseq", 459, 1),
    ("application/vnd.musician", 460, 1),
    ("application/vnd.muvee.style", 461, 1),
    ("application/vnd.mynfc", 462, 1),
    ("application/vnd.neurolanguage.nlu", 463, 1),
    ("application/vnd.nitf", 464, 2),
    ("application/vnd.noblenet-directory", 466, 1),
    ("application/vnd.noblenet-sealer", 467, 1),
    ("application/vnd.noblenet-web", 468, 1),
    ("application/vnd.nokia.n-gage.ac+xml", 469, 1),
    ("application/vnd.nokia.n-gage.data", 470, 1),
    ("application/vnd.nokia.n-gage.symbian.install", 471, 1),
    ("application/vnd.nokia.radio-preset", 472, 1),
    ("application/vnd.nokia.radio-presets", 473, 1),
    ("application/vnd.novadigm.edm", 474, 1),
    ("application/vnd.novadigm.edx", 475, 1),
    ("application/vnd.novadigm.ext", 476, 1),
    ("application/vnd.oasis.opendocument.chart", 477, 1),
    ("application/vnd.oasis.opendocument.chart-template", 478, 1),
    ("application/vnd.oasis.opendocument.database", 479, 1),
    ("application/vnd.oasis.opendocument.formula", 480, 1),
    (
        "application/vnd.oasis.opendocument.formula-template",
        481,
        1,
    ),
    ("application/vnd.oasis.opendocument.graphics", 482, 1),
    (
        "application/vnd.oasis.opendocument.graphics-template",
        483,
        1,
    ),
    ("application/vnd.oasis.opendocument.image", 484, 1),
    ("application/vnd.oasis.opendocument.image-template", 485, 1),
    ("application/vnd.oasis.opendocument.presentation", 486, 1),
    (
        "application/vnd.oasis.opendocument.presentation-template",
        487,
        1,
    ),
    ("application/vnd.oasis.opendocument.spreadsheet", 488, 1),
    (
        "application/vnd.oasis.opendocument.spreadsheet-template",
        489,
        1,
    ),
    ("application/vnd.oasis.opendocument.text", 490, 1),
    ("application/vnd.oasis.opendocument.text-master", 491, 1),
    ("application/vnd.oasis.opendocument.text-template", 492, 1),
    ("application/vnd.oasis.opendocument.text-web", 493, 1),
    ("application/vnd.olpc-sugar", 494, 1),
    ("application/vnd.oma.dd2+xml", 495, 1),
    ("application/vnd.openblox.game+xml", 496, 1),
    ("application/vnd.openofficeorg.extension", 497, 1),
    ("application/vnd.openstreetmap.data+xml", 498, 1),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.presentation",
        499,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.slide",
        500,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
        501,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.template",
        502,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
        503,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
        504,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        505,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
        506,
        1,
    ),
    ("application/vnd.osgeo.mapguide.package", 507, 1),
    ("application/vnd.osgi.dp", 508, 1),
    ("application/vnd.osgi.subsystem", 509, 1),
    ("application/vnd.palm", 510, 3),
    ("application/vnd.pawaafile", 513, 1),
    ("application/vnd.pg.format", 514, 1),
    ("application/vnd.pg.osasli", 515, 1),
    ("application/vnd.picsel", 516, 1),
    ("application/vnd.pmi.widget", 517, 1),
    ("application/vnd.pocketlearn", 518, 1),
    ("application/vnd.powerbuilder6", 519, 1),
    ("application/vnd.previewsystems.box", 520, 1),
    ("application/vnd.proteus.magazine", 521, 1),
    ("application/vnd.publishare-delta-tree", 522, 1),
    ("application/vnd.pvi.ptid1", 523, 1),
    ("application/vnd.quark.quarkxpress", 524, 6),
    ("application/vnd.rar", 530, 1),
    ("application/vnd.realvnc.bed", 531, 1),
    ("application/vnd.recordare.musicxml", 532, 1),
    ("application/vnd.recordare.musicxml+xml", 533, 1),
    ("application/vnd.rig.cryptonote", 534, 1),
    ("application/vnd.rim.cod", 535, 1),
    ("application/vnd.rn-realmedia", 536, 1),
    ("application/vnd.rn-realmedia-vbr", 537, 1),
    ("application/vnd.route66.link66+xml", 538, 1),
    ("application/vnd.sailingtracker.track", 539, 1),
    ("application/vnd.seemail", 540, 1),
    ("application/vnd.sema", 541, 1),
    ("application/vnd.semd", 542, 1),
    ("application/vnd.semf", 543, 1),
    ("application/vnd.shana.informed.formdata", 544, 1),
    ("application/vnd.shana.informed.formtemplate", 545, 1),
    ("application/vnd.shana.informed.interchange", 546, 1),
    ("application/vnd.shana.informed.package", 547, 1),
    ("application/vnd.simtech-mindmapper", 548, 2),
    ("application/vnd.smaf", 550, 1),
    ("application/vnd.smart.teacher", 551, 1),
    ("application/vnd.software602.filler.form+xml", 552, 1),
    ("application/vnd.solent.sdkm+xml", 553, 2),
    ("application/vnd.spotfire.dxp", 555, 1),
    ("application/vnd.spotfire.sfs", 556, 1),
    ("application/vnd.stardivision.calc", 557, 1),
    ("application/vnd.stardivision.draw", 558, 1),
    ("application/vnd.stardivision.impress", 559, 1),
    ("application/vnd.stardivision.math", 560, 1),
    ("application/vnd.stardivision.writer", 561, 2),
    ("application/vnd.stardivision.writer-global", 563, 1),
    ("application/vnd.stepmania.package", 564, 1),
    ("application/vnd.stepmania.stepchart", 565, 1),
    ("application/vnd.sun.wadl+xml", 566, 1),
    ("application/vnd.sun.xml.calc", 567, 1),
    ("application/vnd.sun.xml.calc.template", 568, 1),
    ("application/vnd.sun.xml.draw", 569, 1),
    ("application/vnd.sun.xml.draw.template", 570, 1),
    ("application/vnd.sun.xml.impress", 571, 1),
    ("application/vnd.sun.xml.impress.template", 572, 1),
    ("application/vnd.sun.xml.math", 573, 1),
    ("application/vnd.sun.xml.writer", 574, 1),
    ("application/vnd.sun.xml.writer.global", 575, 1),
    ("application/vnd.sun.xml.writer.template", 576, 1),
    ("application/vnd.sus-calendar", 577, 2),
    ("application/vnd.svd", 579, 1),
    ("application/vnd.symbian.install", 580, 2),
    ("application/vnd.syncml+xml", 582, 1),
    ("application/vnd.syncml.dm+wbxml", 583, 1),
    ("application/vnd.syncml.dm+xml", 584, 1),
    ("application/vnd.syncml.dmddf+xml", 585, 1),
    ("application/vnd.tao.intent-module-archive", 586, 1),
    ("application/vnd.tcpdump.pcap", 587, 3),
    ("application/vnd.tmobile-livetv", 590, 1),
    ("application/vnd.trid.tpt", 591, 1),
    ("application/vnd.triscape.mxs", 592, 1),
    ("application/vnd.trueapp", 593, 1),
    ("application/vnd.ufdl", 594, 2),
    ("application/vnd.uiq.theme", 596, 1),
    ("application/vnd.umajin", 597, 1),
    ("application/vnd.unity", 598, 1),
    ("application/vnd.uoml+xml", 599, 1),
    ("application/vnd.vcx", 600, 1),
    ("application/vnd.visio", 601, 4),
    ("application/vnd.visionary", 605, 1),
    ("application/vnd.vsf", 606, 1),
    ("application/vnd.wap.wbxml", 607, 1),
    ("application/vnd.wap.wmlc", 608, 1),
    ("application/vnd.wap.wmlscriptc", 609, 1),
    ("application/vnd.webturbo", 610, 1),
    ("application/vnd.wolfram.player", 611, 1),
    ("application/vnd.wordperfect", 612, 1),
    ("application/vnd.wqd", 613, 1),
    ("application/vnd.wt.stf", 614, 1),
    ("application/vnd.xara", 615, 1),
    ("application/vnd.xfdl", 616, 1),
    ("application/vnd.yamaha.hv-dic", 617, 1),
    ("application/vnd.yamaha.hv-script", 618, 1),
    ("application/vnd.yamaha.hv-voice", 619, 1),
    ("application/vnd.yamaha.openscoreformat", 620, 1),
    ("application/vnd.yamaha.openscoreformat.osfpvg+xml", 621, 1),
    ("application/vnd.yamaha.smaf-audio", 622, 1),
    ("application/vnd.yamaha.smaf-phrase", 623, 1),
    ("application/vnd.yellowriver-custom-menu", 624, 1),
    ("application/vnd.zul", 625, 2),
    ("application/vnd.zzazz.deck+xml", 627, 1),
    ("application/voicexml+xml", 628, 1),
    ("application/wasm", 629, 1),
    ("application/widget", 630, 1),
    ("application/winhlp", 631, 1),
    ("application/wsdl+xml", 632, 1),
    ("application/wspolicy+xml", 633, 1),
    ("application/x-7z-compressed", 634, 1),
    ("application/x-abiword", 635, 1),
    ("application/x-ace-compressed", 636, 1),
    ("application/x-apple-diskimage", 637, 1),
    ("application/x-arj", 638, 1),
    ("application/x-authorware-bin", 639, 4),
    ("application/x-authorware-map", 643, 1),
    ("application/x-authorware-seg", 644, 1),
    ("application/x-bcpio", 645, 1),
    ("application/x-bdoc", 646, 1),
    ("application/x-bittorrent", 647, 1),
    ("application/x-blorb", 648, 2),
    ("application/x-bzip", 650, 1),
    ("application/x-bzip2", 651, 2),
    ("application/x-cbr", 653, 5),
    ("application/x-cdlink", 658, 1),
    ("application/x-cfs-compressed", 659, 1),
    ("application/x-chat", 660, 1),
    ("application/x-chess-pgn", 661, 1),
    ("application/x-chrome-extension", 662, 1),
    ("application/x-cocoa", 663, 1),
    ("application/x-conference", 664, 1),
    ("application/x-cpio", 665, 1),
    ("application/x-csh", 666, 1),
    ("application/x-debian-package", 667, 2),
    ("application/x-dgc-compressed", 669, 1),
    ("application/x-director", 670, 9),
    ("application/x-doom", 679, 1),
    ("application/x-dtbncx+xml", 680, 1),
    ("application/x-dtbook+xml", 681, 1),
    ("application/x-dtbresource+xml", 682, 1),
    ("application/x-dvi", 683, 1),
    ("application/x-envoy", 684, 1),
    ("application/x-eva", 685, 1),
    ("application/x-font-bdf", 686, 1),
    ("application/x-font-ghostscript", 687, 1),
    ("application/x-font-linux-psf", 688, 1),
    ("application/x-font-pcf", 689, 1),
    ("application/x-font-snf", 690, 1),
    ("application/x-font-type1", 691, 4),
    ("application/x-freearc", 695, 1),
    ("application/x-futuresplash", 696, 1),
    ("application/x-gca-compressed", 697, 1),
    ("application/x-glulx", 698, 1),
    ("application/x-gnumeric", 699, 1),
    ("application/x-gramps-xml", 700, 1),
    ("application/x-gtar", 701, 1),
    ("application/x-hdf", 702, 1),
    ("application/x-httpd-php", 703, 1),
    ("application/x-install-instructions", 704, 1),
    ("application/x-iso9660-image", 705, 1),
    ("application/x-java-archive-diff", 706, 1),
    ("application/x-java-jnlp-file", 707, 1),
    ("application/x-keepass2", 708, 1),
    ("application/x-latex", 709, 1),
    ("application/x-lua-bytecode", 710, 1),
    ("application/x-lzh-compressed", 711, 2),
    ("application/x-makeself", 713, 1),
    ("application/x-mie", 714, 1),
    ("application/x-mobipocket-ebook", 715, 2),
    ("application/x-ms-application", 717, 1),
    ("application/x-ms-shortcut", 718, 1),
    ("application/x-ms-wmd", 719, 1),
    ("application/x-ms-wmz", 720, 1),
    ("application/x-ms-xbap", 721, 1),
    ("application/x-msaccess", 722, 1),
    ("application/x-msbinder", 723, 1),
    ("application/x-mscardfile", 724, 1),
    ("application/x-msclip", 725, 1),
    ("application/x-msdos-program", 726, 1),
    ("application/x-msdownload", 727, 5),
    ("application/x-msmediaview", 732, 3),
    ("application/x-msmetafile", 735, 4),
    ("application/x-msmoney", 739, 1),
    ("application/x-mspublisher", 740, 1),
    ("application/x-msschedule", 741, 1),
    ("application/x-msterminal", 742, 1),
    ("application/x-mswrite", 743, 1),
    ("application/x-netcdf", 744, 2),
    ("application/x-ns-proxy-autoconfig", 746, 1),
    ("application/x-nzb", 747, 1),
    ("application/x-perl", 748, 2),
    ("application/x-pilot", 750, 2),
    ("application/x-pkcs12", 752, 2),
    ("application/x-pkcs7-certificates", 754, 2),
    ("application/x-pkcs7-certreqresp", 756, 1),
    ("application/x-rar-compressed", 757, 1),
    ("application/x-redhat-package-manager", 758, 1),
    ("application/x-research-info-systems", 759, 1),
    ("application/x-sea", 760, 1),
    ("application/x-sh", 761, 1),
    ("application/x-shar", 762, 1),
    ("application/x-shockwave-flash", 763, 1),
    ("application/x-silverlight-app", 764, 1),
    ("application/x-sql", 765, 1),
    ("application/x-stuffit", 766, 1),
    ("application/x-stuffitx", 767, 1),
    ("application/x-subrip", 768, 1),
    ("application/x-sv4cpio", 769, 1),
    ("application/x-sv4crc", 770, 1),
    ("application/x-t3vm-image", 771, 1),
    ("application/x-tads", 772, 1),
    ("application/x-tar", 773, 1),
    ("application/x-tcl", 774, 2),
    ("application/x-tex", 776, 1),
    ("application/x-tex-tfm", 777, 1),
    ("application/x-texinfo", 778, 2),
    ("application/x-tgif", 780, 1),
    ("application/x-ustar", 781, 1),
    ("application/x-virtualbox-hdd", 782, 1),
    ("application/x-virtualbox-ova", 783, 1),
    ("application/x-virtualbox-ovf", 784, 1),
    ("application/x-virtualbox-vbox", 785, 1),
    ("application/x-virtualbox-vbox-extpack", 786, 1),
    ("application/x-virtualbox-vdi", 787, 1),
    ("application/x-virtualbox-vhd", 788, 1),
    ("application/x-virtualbox-vmdk", 789, 1),
    ("application/x-wais-source", 790, 1),
    ("application/x-web-app-manifest+json", 791, 1),
    ("application/x-x509-ca-cert", 792, 3),
    ("application/x-xfig", 795, 1),
    ("application/x-xliff+xml", 796, 1),
    ("application/x-xpinstall", 797, 1),
    ("application/x-xz", 798, 1),
    ("application/x-zmachine", 799, 8),
    ("application/xaml+xml", 807, 1),
    ("application/xcap-att+xml", 808, 1),
    ("application/xcap-caps+xml", 809, 1),
    ("application/xcap-diff+xml", 810, 1),
    ("application/xcap-el+xml", 811, 1),
    ("application/xcap-ns+xml", 812, 1),
    ("application/xenc+xml", 813, 1),
    ("application/xhtml+xml", 814, 2),
    ("application/xliff+xml", 816, 1),
    ("application/xml", 817, 4),
    ("application/xml-dtd", 821, 1),
    ("application/xop+xml", 822, 1),
    ("application/xproc+xml", 823, 1),
    ("application/xslt+xml", 824, 2),
    ("application/xspf+xml", 826, 1),
    ("application/xv+xml", 827, 4),
    ("application/yang", 831, 1),
    ("application/yin+xml", 832, 1),
    ("application/zip", 833, 1),
    ("audio/3gpp", 834, 1),
    ("audio/adpcm", 835, 1),
    ("audio/amr", 836, 1),
    ("audio/basic", 837, 2),
    ("audio/midi", 839, 4),
    ("audio/mobile-xmf", 843, 1),
    ("audio/mp3", 844, 1),
    ("audio/mp4", 845, 2),
    ("audio/mpeg", 847, 6),
    ("audio/ogg", 853, 4),
    ("audio/s3m", 857, 1),
    ("audio/silk", 858, 1),
    ("audio/vnd.dece.audio", 859, 2),
    ("audio/vnd.digital-winds", 861, 1),
    ("audio/vnd.dra", 862, 1),
    ("audio/vnd.dts", 863, 1),
    ("audio/vnd.dts.hd", 864, 1),
    ("audio/vnd.lucent.voice", 865, 1),
    ("audio/vnd.ms-playready.media.pya", 866, 1),
    ("audio/vnd.nuera.ecelp4800", 867, 1),
    ("audio/vnd.nuera.ecelp7470", 868, 1),
    ("audio/vnd.nuera.ecelp9600", 869, 1),
    ("audio/vnd.rip", 870, 1),
    ("audio/wav", 871, 1),
    ("audio/wave", 872, 1),
    ("audio/webm", 873, 1),
    ("audio/x-aac", 874, 1),
    ("audio/x-aiff", 875, 3),
    ("audio/x-caf", 878, 1),
    ("audio/x-flac", 879, 1),
    ("audio/x-m4a", 880, 1),
    ("audio/x-matroska", 881, 1),
    ("audio/x-mpegurl", 882, 1),
    ("audio/x-ms-wax", 883, 1),
    ("audio/x-ms-wma", 884, 1),
    ("audio/x-pn-realaudio", 885, 2),
    ("audio/x-pn-realaudio-plugin", 887, 1),
    ("audio/x-realaudio", 888, 1),
    ("audio/x-wav", 889, 1),
    ("audio/xm", 890, 1),
    ("chemical/x-cdx", 891, 1),
    ("chemical/x-cif", 892, 1),
    ("chemical/x-cmdf", 893, 1),
    ("chemical/x-cml", 894, 1),
    ("chemical/x-csml", 895, 1),
    ("chemical/x-xyz", 896, 1),
    ("font/collection", 897, 1),
    ("font/otf", 898, 1),
    ("font/ttf", 899, 1),
    ("font/woff", 900, 1),
    ("font/woff2", 901, 1),
    ("image/aces", 902, 1),
    ("image/apng", 903, 1),
    ("image/avif", 904, 1),
    ("image/bmp", 905, 1),
    ("image/cgm", 906, 1),
    ("image/dicom-rle", 907, 1),
    ("image/emf", 908, 1),
    ("image/fits", 909, 1),
    ("image/g3fax", 910, 1),
    ("image/gif", 911, 1),
    ("image/heic", 912, 1),
    ("image/heic-sequence", 913, 1),
    ("image/heif", 914, 1),
    ("image/heif-sequence", 915, 1),
    ("image/hej2k", 916, 1),
    ("image/hsj2", 917, 1),
    ("image/ief", 918, 1),
    ("image/jls", 919, 1),
    ("image/jp2", 920, 2),
    ("image/jpeg", 922, 3),
    ("image/jph", 925, 1),
    ("image/jphc", 926, 1),
    ("image/jpm", 927, 1),
    ("image/jpx", 928, 2),
    ("image/jxr", 930, 1),
    ("image/jxra", 931, 1),
    ("image/jxrs", 932, 1),
    ("image/jxs", 933, 1),
    ("image/jxsc", 934, 1),
    ("image/jxsi", 935, 1),
    ("image/jxss", 936, 1),
    ("image/ktx", 937, 1),
    ("image/ktx2", 938, 1),
    ("image/png", 939, 1),
    ("image/prs.btif", 940, 1),
    ("image/prs.pti", 941, 1),
    ("image/sgi", 942, 1),
    ("image/svg+xml", 943, 2),
    ("image/t38", 945, 1),
    ("image/tiff", 946, 2),
    ("image/tiff-fx", 948, 1),
    ("image/vnd.adobe.photoshop", 949, 1),
    ("image/vnd.airzip.accelerator.azv", 950, 1),
    ("image/vnd.dece.graphic", 951, 4),
    ("image/vnd.djvu", 955, 2),
    ("image/vnd.dvb.subtitle", 957, 1),
    ("image/vnd.dwg", 958, 1),
    ("image/vnd.dxf", 959, 1),
    ("image/vnd.fastbidsheet", 960, 1),
    ("image/vnd.fpx", 961, 1),
    ("image/vnd.fst", 962, 1),
    ("image/vnd.fujixerox.edmics-mmr", 963, 1),
    ("image/vnd.fujixerox.edmics-rlc", 964, 1),
    ("image/vnd.microsoft.icon", 965, 1),
    ("image/vnd.ms-dds", 966, 1),
    ("image/vnd.ms-modi", 967, 1),
    ("image/vnd.ms-photo", 968, 1),
    ("image/vnd.net-fpx", 969, 1),
    ("image/vnd.pco.b16", 970, 1),
    ("image/vnd.tencent.tap", 971, 1),
    ("image/vnd.valve.source.texture", 972, 1),
    ("image/vnd.wap.wbmp", 973, 1),
    ("image/vnd.xiff", 974, 1),
    ("image/vnd.zbrush.pcx", 975, 1),
    ("image/webp", 976, 1),
    ("image/wmf", 977, 1),
    ("image/x-3ds", 978, 1),
    ("image/x-cmu-raster", 979, 1),
    ("image/x-cmx", 980, 1),
    ("image/x-freehand", 981, 5),
    ("image/x-icon", 986, 1),
    ("image/x-jng", 987, 1),
    ("image/x-mrsid-image", 988, 1),
    ("image/x-ms-bmp", 989, 1),
    ("image/x-pcx", 990, 1),
    ("image/x-pict", 991, 2),
    ("image/x-portable-anymap", 993, 1),
    ("image/x-portable-bitmap", 994, 1),
    ("image/x-portable-graymap", 995, 1),
    ("image/x-portable-pixmap", 996, 1),
    ("image/x-rgb", 997, 1),
    ("image/x-tga", 998, 1),
    ("image/x-xbitmap", 999, 1),
    ("image/x-xpixmap", 1000, 1),
    ("image/x-xwindowdump", 1001, 1),
    ("message/disposition-notification", 1002, 1),
    ("message/global", 1003, 1),
    ("message/global-delivery-status", 1004, 1),
    ("message/global-disposition-notification", 1005, 1),
    ("message/global-headers", 1006, 1),
    ("message/rfc822", 1007, 2),
    ("message/vnd.wfa.wsc", 1009, 1),
    ("model/3mf", 1010, 1),
    ("model/gltf+json", 1011, 1),
    ("model/gltf-binary", 1012, 1),
    ("model/iges", 1013, 2),
    ("model/mesh", 1015, 3),
    ("model/mtl", 1018, 1),
    ("model/obj", 1019, 1),
    ("model/step+zip", 1020, 1),
    ("model/step-xml+zip", 1021, 1),
    ("model/stl", 1022, 1),
    ("model/vnd.collada+xml", 1023, 1),
    ("model/vnd.dwf", 1024, 1),
    ("model/vnd.gdl", 1025, 1),
    ("model/vnd.gtw", 1026, 1),
    ("model/vnd.mts", 1027, 1),
    ("model/vnd.opengex", 1028, 1),
    ("model/vnd.parasolid.transmit.binary", 1029, 1),
    ("model/vnd.parasolid.transmit.text", 1030, 1),
    ("model/vnd.sap.vds", 1031, 1),
    ("model/vnd.usdz+zip", 1032, 1),
    ("model/vnd.valve.source.compiled-map", 1033, 1),
    ("model/vnd.vtu", 1034, 1),
    ("model/vrml", 1035, 2),
    ("model/x3d+binary", 1037, 2),
    ("model/x3d+fastinfoset", 1039, 1),
    ("model/x3d+vrml", 1040, 2),
    ("model/x3d+xml", 1042, 2),
    ("model/x3d-vrml", 1044, 1),
    ("text/cache-manifest", 1045, 2),
    ("text/calendar", 1047, 2),
    ("text/coffeescript", 1049, 2),
    ("text/css", 1051, 1),
    ("text/csv", 1052, 1),
    ("text/html", 1053, 3),
    ("text/jade", 1056, 1),
    ("text/jsx", 1057, 1),
    ("text/less", 1058, 1),
    ("text/markdown", 1059, 2),
    ("text/mathml", 1061, 1),
    ("text/mdx", 1062, 1),
    ("text/n3", 1063, 1),
    ("text/plain", 1064, 8),
    ("text/prs.lines.tag", 1072, 1),
    ("text/richtext", 1073, 1),
    ("text/rtf", 1074, 1),
    ("text/sgml", 1075, 2),
    ("text/shex", 1077, 1),
    ("text/slim", 1078, 2),
    ("text/spdx", 1080, 1),
    ("text/stylus", 1081, 2),
    ("text/tab-separated-values", 1083, 1),
    ("text/troff", 1084, 6),
    ("text/turtle", 1090, 1),
    ("text/uri-list", 1091, 3),
    ("text/vcard", 1094, 1),
    ("text/vnd.curl", 1095, 1),
    ("text/vnd.curl.dcurl", 1096, 1),
    ("text/vnd.curl.mcurl", 1097, 1),
    ("text/vnd.curl.scurl", 1098, 1),
    ("text/vnd.dvb.subtitle", 1099, 1),
    ("text/vnd.fly", 1100, 1),
    ("text/vnd.fmi.flexstor", 1101, 1),
    ("text/vnd.graphviz", 1102, 1),
    ("text/vnd.in3d.3dml", 1103, 1),
    ("text/vnd.in3d.spot", 1104, 1),
    ("text/vnd.sun.j2me.app-descriptor", 1105, 1),
    ("text/vnd.wap.wml", 1106, 1),
    ("text/vnd.wap.wmlscript", 1107, 1),
    ("text/vtt", 1108, 1),
    ("text/x-asm", 1109, 2),
    ("text/x-c", 1111, 7),
    ("text/x-component", 1118, 1),
    ("text/x-fortran", 1119, 4),
    ("text/x-handlebars-template", 1123, 1),
    ("text/x-java-source", 1124, 1),
    ("text/x-lua", 1125, 1),
    ("text/x-markdown", 1126, 1),
    ("text/x-nfo", 1127, 1),
    ("text/x-opml", 1128, 1),
    ("text/x-org", 1129, 1),
    ("text/x-pascal", 1130, 2),
    ("text/x-processing", 1132, 1),
    ("text/x-sass", 1133, 1),
    ("text/x-scss", 1134, 1),
    ("text/x-setext", 1135, 1),
    ("text/x-sfv", 1136, 1),
    ("text/x-suse-ymp", 1137, 1),
    ("text/x-uuencode", 1138, 1),
    ("text/x-vcalendar", 1139, 1),
    ("text/x-vcard", 1140, 1),
    ("text/xml", 1141, 1),
    ("text/yaml", 1142, 2),
    ("video/3gpp", 1144, 2),
    ("video/3gpp2", 1146, 1),
    ("video/h261", 1147, 1),
    ("video/h263", 1148, 1),
    ("video/h264", 1149, 1),
    ("video/iso.segment", 1150, 1),
    ("video/jpeg", 1151, 1),
    ("video/jpm", 1152, 2),
    ("video/mj2", 1154, 2),
    ("video/mp2t", 1156, 1),
    ("video/mp4", 1157, 3),
    ("video/mpeg", 1160, 5),
    ("video/ogg", 1165, 1),
    ("video/quicktime", 1166, 2),
    ("video/vnd.dece.hd", 1168, 2),
    ("video/vnd.dece.mobile", 1170, 2),
    ("video/vnd.dece.pd", 1172, 2),
    ("video/vnd.dece.sd", 1174, 2),
    ("video/vnd.dece.video", 1176, 2),
    ("video/vnd.dvb.file", 1178, 1),
    ("video/vnd.fvt", 1179, 1),
    ("video/vnd.mpegurl", 1180, 2),
    ("video/vnd.ms-playready.media.pyv", 1182, 1),
    ("video/vnd.uvvu.mp4", 1183, 2),
    ("video/vnd.vivo", 1185, 1),
    ("video/webm", 1186, 1),
    ("video/x-f4v", 1187, 1),
    ("video/x-fli", 1188, 1),
    ("video/x-flv", 1189, 1),
    ("video/x-m4v", 1190, 1),
    ("video/x-matroska", 1191, 3),
    ("video/x-mng", 1194, 1),
    ("video/x-ms-asf", 1195, 2),
    ("video/x-ms-vob", 1197, 1),
    ("video/x-ms-wm", 1198, 1),
    ("video/x-ms-wmv", 1199, 1),
    ("video/x-ms-wmx", 1200, 1),
    ("video/x-ms-wvx", 1201, 1),
    ("video/x-msvideo", 1202, 1),
    ("video/x-sgi-movie", 1203, 1),
    ("video/x-smv", 1204, 1),
    ("x-conference/x-cooltalk", 1205, 1),
];
