pub const TYPES: [(&str, usize, usize); 948] = [
    ("application/andrew-inset", 0, 1),
    ("application/applixware", 1, 1),
    ("application/atom+xml", 2, 1),
    ("application/atomcat+xml", 3, 1),
    ("application/atomdeleted+xml", 4, 1),
    ("application/atomsvc+xml", 5, 1),
    ("application/atsc-dwd+xml", 6, 1),
    ("application/atsc-held+xml", 7, 1),
    ("application/atsc-rsat+xml", 8, 1),
    ("application/bdoc", 9, 1),
    ("application/calendar+xml", 10, 1),
    ("application/ccxml+xml", 11, 1),
    ("application/cdfx+xml", 12, 1),
    ("application/cdmi-capability", 13, 1),
    ("application/cdmi-container", 14, 1),
    ("application/cdmi-domain", 15, 1),
    ("application/cdmi-object", 16, 1),
    ("application/cdmi-queue", 17, 1),
    ("application/cu-seeme", 18, 1),
    ("application/dash+xml", 19, 1),
    ("application/davmount+xml", 20, 1),
    ("application/docbook+xml", 21, 1),
    ("application/dssc+der", 22, 1),
    ("application/dssc+xml", 23, 1),
    ("application/ecmascript", 24, 2),
    ("application/emma+xml", 26, 1),
    ("application/emotionml+xml", 27, 1),
    ("application/epub+zip", 28, 1),
    ("application/exi", 29, 1),
    ("application/fdt+xml", 30, 1),
    ("application/font-tdpfr", 31, 1),
    ("application/geo+json", 32, 1),
    ("application/gml+xml", 33, 1),
    ("application/gpx+xml", 34, 1),
    ("application/gxf", 35, 1),
    ("application/gzip", 36, 1),
    ("application/hjson", 37, 1),
    ("application/hyperstudio", 38, 1),
    ("application/inkml+xml", 39, 2),
    ("application/ipfix", 41, 1),
    ("application/its+xml", 42, 1),
    ("application/java-archive", 43, 3),
    ("application/java-serialized-object", 46, 1),
    ("application/java-vm", 47, 1),
    ("application/javascript", 48, 2),
    ("application/json", 50, 2),
    ("application/json5", 52, 1),
    ("application/jsonml+json", 53, 1),
    ("application/ld+json", 54, 1),
    ("application/lgr+xml", 55, 1),
    ("application/lost+xml", 56, 1),
    ("application/mac-binhex40", 57, 1),
    ("application/mac-compactpro", 58, 1),
    ("application/mads+xml", 59, 1),
    ("application/manifest+json", 60, 1),
    ("application/marc", 61, 1),
    ("application/marcxml+xml", 62, 1),
    ("application/mathematica", 63, 3),
    ("application/mathml+xml", 66, 1),
    ("application/mbox", 67, 1),
    ("application/mediaservercontrol+xml", 68, 1),
    ("application/metalink+xml", 69, 1),
    ("application/metalink4+xml", 70, 1),
    ("application/mets+xml", 71, 1),
    ("application/mmt-aei+xml", 72, 1),
    ("application/mmt-usd+xml", 73, 1),
    ("application/mods+xml", 74, 1),
    ("application/mp21", 75, 2),
    ("application/mp4", 77, 2),
    ("application/msword", 79, 2),
    ("application/mxf", 81, 1),
    ("application/n-quads", 82, 1),
    ("application/n-triples", 83, 1),
    ("application/node", 84, 1),
    ("application/octet-stream", 85, 22),
    ("application/oda", 107, 1),
    ("application/oebps-package+xml", 108, 1),
    ("application/ogg", 109, 1),
    ("application/omdoc+xml", 110, 1),
    ("application/onenote", 111, 4),
    ("application/oxps", 115, 1),
    ("application/p2p-overlay+xml", 116, 1),
    ("application/patch-ops-error+xml", 117, 1),
    ("application/pdf", 118, 1),
    ("application/pgp-encrypted", 119, 1),
    ("application/pgp-signature", 120, 2),
    ("application/pics-rules", 122, 1),
    ("application/pkcs10", 123, 1),
    ("application/pkcs7-mime", 124, 2),
    ("application/pkcs7-signature", 126, 1),
    ("application/pkcs8", 127, 1),
    ("application/pkix-attr-cert", 128, 1),
    ("application/pkix-cert", 129, 1),
    ("application/pkix-crl", 130, 1),
    ("application/pkix-pkipath", 131, 1),
    ("application/pkixcmp", 132, 1),
    ("application/pls+xml", 133, 1),
    ("application/postscript", 134, 3),
    ("application/provenance+xml", 137, 1),
    ("application/prs.cww", 138, 1),
    ("application/pskc+xml", 139, 1),
    ("application/raml+yaml", 140, 1),
    ("application/rdf+xml", 141, 2),
    ("application/reginfo+xml", 143, 1),
    ("application/relax-ng-compact-syntax", 144, 1),
    ("application/resource-lists+xml", 145, 1),
    ("application/resource-lists-diff+xml", 146, 1),
    ("application/rls-services+xml", 147, 1),
    ("application/route-apd+xml", 148, 1),
    ("application/route-s-tsid+xml", 149, 1),
    ("application/route-usd+xml", 150, 1),
    ("application/rpki-ghostbusters", 151, 1),
    ("application/rpki-manifest", 152, 1),
    ("application/rpki-roa", 153, 1),
    ("application/rsd+xml", 154, 1),
    ("application/rss+xml", 155, 1),
    ("application/rtf", 156, 1),
    ("application/sbml+xml", 157, 1),
    ("application/scvp-cv-request", 158, 1),
    ("application/scvp-cv-response", 159, 1),
    ("application/scvp-vp-request", 160, 1),
    ("application/scvp-vp-response", 161, 1),
    ("application/sdp", 162, 1),
    ("application/senml+xml", 163, 1),
    ("application/sensml+xml", 164, 1),
    ("application/set-payment-initiation", 165, 1),
    ("application/set-registration-initiation", 166, 1),
    ("application/shf+xml", 167, 1),
    ("application/sieve", 168, 2),
    ("application/smil+xml", 170, 2),
    ("application/sparql-query", 172, 1),
    ("application/sparql-results+xml", 173, 1),
    ("application/srgs", 174, 1),
    ("application/srgs+xml", 175, 1),
    ("application/sru+xml", 176, 1),
    ("application/ssdl+xml", 177, 1),
    ("application/ssml+xml", 178, 1),
    ("application/swid+xml", 179, 1),
    ("application/tei+xml", 180, 2),
    ("application/thraud+xml", 182, 1),
    ("application/timestamped-data", 183, 1),
    ("application/toml", 184, 1),
    ("application/ttml+xml", 185, 1),
    ("application/ubjson", 186, 1),
    ("application/urc-ressheet+xml", 187, 1),
    ("application/urc-targetdesc+xml", 188, 1),
    ("application/vnd.1000minds.decision-model+xml", 189, 1),
    ("application/vnd.3gpp.pic-bw-large", 190, 1),
    ("application/vnd.3gpp.pic-bw-small", 191, 1),
    ("application/vnd.3gpp.pic-bw-var", 192, 1),
    ("application/vnd.3gpp2.tcap", 193, 1),
    ("application/vnd.3m.post-it-notes", 194, 1),
    ("application/vnd.accpac.simply.aso", 195, 1),
    ("application/vnd.accpac.simply.imp", 196, 1),
    ("application/vnd.acucobol", 197, 1),
    ("application/vnd.acucorp", 198, 2),
    (
        "application/vnd.adobe.air-application-installer-package+zip",
        200,
        1,
    ),
    ("application/vnd.adobe.formscentral.fcdt", 201, 1),
    ("application/vnd.adobe.fxp", 202, 2),
    ("application/vnd.adobe.xdp+xml", 204, 1),
    ("application/vnd.adobe.xfdf", 205, 1),
    ("application/vnd.ahead.space", 206, 1),
    ("application/vnd.airzip.filesecure.azf", 207, 1),
    ("application/vnd.airzip.filesecure.azs", 208, 1),
    ("application/vnd.amazon.ebook", 209, 1),
    ("application/vnd.americandynamics.acc", 210, 1),
    ("application/vnd.amiga.ami", 211, 1),
    ("application/vnd.android.package-archive", 212, 1),
    (
        "application/vnd.anser-web-certificate-issue-initiation",
        213,
        1,
    ),
    (
        "application/vnd.anser-web-funds-transfer-initiation",
        214,
        1,
    ),
    ("application/vnd.antix.game-component", 215, 1),
    ("application/vnd.apple.installer+xml", 216, 1),
    ("application/vnd.apple.keynote", 217, 1),
    ("application/vnd.apple.mpegurl", 218, 1),
    ("application/vnd.apple.numbers", 219, 1),
    ("application/vnd.apple.pages", 220, 1),
    ("application/vnd.apple.pkpass", 221, 1),
    ("application/vnd.aristanetworks.swi", 222, 1),
    ("application/vnd.astraea-software.iota", 223, 1),
    ("application/vnd.audiograph", 224, 1),
    ("application/vnd.balsamiq.bmml+xml", 225, 1),
    ("application/vnd.blueice.multipass", 226, 1),
    ("application/vnd.bmi", 227, 1),
    ("application/vnd.businessobjects", 228, 1),
    ("application/vnd.chemdraw+xml", 229, 1),
    ("application/vnd.chipnuts.karaoke-mmd", 230, 1),
    ("application/vnd.cinderella", 231, 1),
    ("application/vnd.citationstyles.style+xml", 232, 1),
    ("application/vnd.claymore", 233, 1),
    ("application/vnd.cloanto.rp9", 234, 1),
    ("application/vnd.clonk.c4group", 235, 5),
    ("application/vnd.cluetrust.cartomobile-config", 240, 1),
    ("application/vnd.cluetrust.cartomobile-config-pkg", 241, 1),
    ("application/vnd.commonspace", 242, 1),
    ("application/vnd.contact.cmsg", 243, 1),
    ("application/vnd.cosmocaller", 244, 1),
    ("application/vnd.crick.clicker", 245, 1),
    ("application/vnd.crick.clicker.keyboard", 246, 1),
    ("application/vnd.crick.clicker.palette", 247, 1),
    ("application/vnd.crick.clicker.template", 248, 1),
    ("application/vnd.crick.clicker.wordbank", 249, 1),
    ("application/vnd.criticaltools.wbs+xml", 250, 1),
    ("application/vnd.ctc-posml", 251, 1),
    ("application/vnd.cups-ppd", 252, 1),
    ("application/vnd.curl.car", 253, 1),
    ("application/vnd.curl.pcurl", 254, 1),
    ("application/vnd.dart", 255, 1),
    ("application/vnd.data-vision.rdz", 256, 1),
    ("application/vnd.dbf", 257, 1),
    ("application/vnd.dece.data", 258, 4),
    ("application/vnd.dece.ttml+xml", 262, 2),
    ("application/vnd.dece.unspecified", 264, 2),
    ("application/vnd.dece.zip", 266, 2),
    ("application/vnd.denovo.fcselayout-link", 268, 1),
    ("application/vnd.dna", 269, 1),
    ("application/vnd.dolby.mlp", 270, 1),
    ("application/vnd.dpgraph", 271, 1),
    ("application/vnd.dreamfactory", 272, 1),
    ("application/vnd.ds-keypoint", 273, 1),
    ("application/vnd.dvb.ait", 274, 1),
    ("application/vnd.dvb.service", 275, 1),
    ("application/vnd.dynageo", 276, 1),
    ("application/vnd.ecowin.chart", 277, 1),
    ("application/vnd.enliven", 278, 1),
    ("application/vnd.epson.esf", 279, 1),
    ("application/vnd.epson.msf", 280, 1),
    ("application/vnd.epson.quickanime", 281, 1),
    ("application/vnd.epson.salt", 282, 1),
    ("application/vnd.epson.ssf", 283, 1),
    ("application/vnd.eszigno3+xml", 284, 2),
    ("application/vnd.ezpix-album", 286, 1),
    ("application/vnd.ezpix-package", 287, 1),
    ("application/vnd.fdf", 288, 1),
    ("application/vnd.fdsn.mseed", 289, 1),
    ("application/vnd.fdsn.seed", 290, 2),
    ("application/vnd.flographit", 292, 1),
    ("application/vnd.fluxtime.clip", 293, 1),
    ("application/vnd.framemaker", 294, 4),
    ("application/vnd.frogans.fnc", 298, 1),
    ("application/vnd.frogans.ltf", 299, 1),
    ("application/vnd.fsc.weblaunch", 300, 1),
    ("application/vnd.fujitsu.oasys", 301, 1),
    ("application/vnd.fujitsu.oasys2", 302, 1),
    ("application/vnd.fujitsu.oasys3", 303, 1),
    ("application/vnd.fujitsu.oasysgp", 304, 1),
    ("application/vnd.fujitsu.oasysprs", 305, 1),
    ("application/vnd.fujixerox.ddd", 306, 1),
    ("application/vnd.fujixerox.docuworks", 307, 1),
    ("application/vnd.fujixerox.docuworks.binder", 308, 1),
    ("application/vnd.fuzzysheet", 309, 1),
    ("application/vnd.genomatix.tuxedo", 310, 1),
    ("application/vnd.geogebra.file", 311, 1),
    ("application/vnd.geogebra.tool", 312, 1),
    ("application/vnd.geometry-explorer", 313, 2),
    ("application/vnd.geonext", 315, 1),
    ("application/vnd.geoplan", 316, 1),
    ("application/vnd.geospace", 317, 1),
    ("application/vnd.gmx", 318, 1),
    ("application/vnd.google-apps.document", 319, 1),
    ("application/vnd.google-apps.presentation", 320, 1),
    ("application/vnd.google-apps.spreadsheet", 321, 1),
    ("application/vnd.google-earth.kml+xml", 322, 1),
    ("application/vnd.google-earth.kmz", 323, 1),
    ("application/vnd.grafeq", 324, 2),
    ("application/vnd.groove-account", 326, 1),
    ("application/vnd.groove-help", 327, 1),
    ("application/vnd.groove-identity-message", 328, 1),
    ("application/vnd.groove-injector", 329, 1),
    ("application/vnd.groove-tool-message", 330, 1),
    ("application/vnd.groove-tool-template", 331, 1),
    ("application/vnd.groove-vcard", 332, 1),
    ("application/vnd.hal+xml", 333, 1),
    ("application/vnd.handheld-entertainment+xml", 334, 1),
    ("application/vnd.hbci", 335, 1),
    ("application/vnd.hhe.lesson-player", 336, 1),
    ("application/vnd.hp-hpgl", 337, 1),
    ("application/vnd.hp-hpid", 338, 1),
    ("application/vnd.hp-hps", 339, 1),
    ("application/vnd.hp-jlyt", 340, 1),
    ("application/vnd.hp-pcl", 341, 1),
    ("application/vnd.hp-pclxl", 342, 1),
    ("application/vnd.hydrostatix.sof-data", 343, 1),
    ("application/vnd.ibm.minipay", 344, 1),
    ("application/vnd.ibm.modcap", 345, 3),
    ("application/vnd.ibm.rights-management", 348, 1),
    ("application/vnd.ibm.secure-container", 349, 1),
    ("application/vnd.iccprofile", 350, 2),
    ("application/vnd.igloader", 352, 1),
    ("application/vnd.immervision-ivp", 353, 1),
    ("application/vnd.immervision-ivu", 354, 1),
    ("application/vnd.insors.igm", 355, 1),
    ("application/vnd.intercon.formnet", 356, 2),
    ("application/vnd.intergeo", 358, 1),
    ("application/vnd.intu.qbo", 359, 1),
    ("application/vnd.intu.qfx", 360, 1),
    ("application/vnd.ipunplugged.rcprofile", 361, 1),
    ("application/vnd.irepository.package+xml", 362, 1),
    ("application/vnd.is-xpr", 363, 1),
    ("application/vnd.isac.fcs", 364, 1),
    ("application/vnd.jam", 365, 1),
    ("application/vnd.jcp.javame.midlet-rms", 366, 1),
    ("application/vnd.jisp", 367, 1),
    ("application/vnd.joost.joda-archive", 368, 1),
    ("application/vnd.kahootz", 369, 2),
    ("application/vnd.kde.karbon", 371, 1),
    ("application/vnd.kde.kchart", 372, 1),
    ("application/vnd.kde.kformula", 373, 1),
    ("application/vnd.kde.kivio", 374, 1),
    ("application/vnd.kde.kontour", 375, 1),
    ("application/vnd.kde.kpresenter", 376, 2),
    ("application/vnd.kde.kspread", 378, 1),
    ("application/vnd.kde.kword", 379, 2),
    ("application/vnd.kenameaapp", 381, 1),
    ("application/vnd.kidspiration", 382, 1),
    ("application/vnd.kinar", 383, 2),
    ("application/vnd.koan", 385, 4),
    ("application/vnd.kodak-descriptor", 389, 1),
    ("application/vnd.las.las+xml", 390, 1),
    ("application/vnd.llamagraphics.life-balance.desktop", 391, 1),
    (
        "application/vnd.llamagraphics.life-balance.exchange+xml",
        392,
        1,
    ),
    ("application/vnd.lotus-1-2-3", 393, 1),
    ("application/vnd.lotus-approach", 394, 1),
    ("application/vnd.lotus-freelance", 395, 1),
    ("application/vnd.lotus-notes", 396, 1),
    ("application/vnd.lotus-organizer", 397, 1),
    ("application/vnd.lotus-screencam", 398, 1),
    ("application/vnd.lotus-wordpro", 399, 1),
    ("application/vnd.macports.portpkg", 400, 1),
    ("application/vnd.mapbox-vector-tile", 401, 1),
    ("application/vnd.mcd", 402, 1),
    ("application/vnd.medcalcdata", 403, 1),
    ("application/vnd.mediastation.cdkey", 404, 1),
    ("application/vnd.mfer", 405, 1),
    ("application/vnd.mfmp", 406, 1),
    ("application/vnd.micrografx.flo", 407, 1),
    ("application/vnd.micrografx.igx", 408, 1),
    ("application/vnd.mif", 409, 1),
    ("application/vnd.mobius.daf", 410, 1),
    ("application/vnd.mobius.dis", 411, 1),
    ("application/vnd.mobius.mbk", 412, 1),
    ("application/vnd.mobius.mqy", 413, 1),
    ("application/vnd.mobius.msl", 414, 1),
    ("application/vnd.mobius.plc", 415, 1),
    ("application/vnd.mobius.txf", 416, 1),
    ("application/vnd.mophun.application", 417, 1),
    ("application/vnd.mophun.certificate", 418, 1),
    ("application/vnd.mozilla.xul+xml", 419, 1),
    ("application/vnd.ms-artgalry", 420, 1),
    ("application/vnd.ms-cab-compressed", 421, 1),
    ("application/vnd.ms-excel", 422, 6),
    ("application/vnd.ms-excel.addin.macroenabled.12", 428, 1),
    (
        "application/vnd.ms-excel.sheet.binary.macroenabled.12",
        429,
        1,
    ),
    ("application/vnd.ms-excel.sheet.macroenabled.12", 430, 1),
    ("application/vnd.ms-excel.template.macroenabled.12", 431, 1),
    ("application/vnd.ms-fontobject", 432, 1),
    ("application/vnd.ms-htmlhelp", 433, 1),
    ("application/vnd.ms-ims", 434, 1),
    ("application/vnd.ms-lrm", 435, 1),
    ("application/vnd.ms-officetheme", 436, 1),
    ("application/vnd.ms-outlook", 437, 1),
    ("application/vnd.ms-pki.seccat", 438, 1),
    ("application/vnd.ms-pki.stl", 439, 1),
    ("application/vnd.ms-powerpoint", 440, 3),
    (
        "application/vnd.ms-powerpoint.addin.macroenabled.12",
        443,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.presentation.macroenabled.12",
        444,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.slide.macroenabled.12",
        445,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.slideshow.macroenabled.12",
        446,
        1,
    ),
    (
        "application/vnd.ms-powerpoint.template.macroenabled.12",
        447,
        1,
    ),
    ("application/vnd.ms-project", 448, 2),
    ("application/vnd.ms-word.document.macroenabled.12", 450, 1),
    ("application/vnd.ms-word.template.macroenabled.12", 451, 1),
    ("application/vnd.ms-works", 452, 4),
    ("application/vnd.ms-wpl", 456, 1),
    ("application/vnd.ms-xpsdocument", 457, 1),
    ("application/vnd.mseq", 458, 1),
    ("application/vnd.musician", 459, 1),
    ("application/vnd.muvee.style", 460, 1),
    ("application/vnd.mynfc", 461, 1),
    ("application/vnd.neurolanguage.nlu", 462, 1),
    ("application/vnd.nitf", 463, 2),
    ("application/vnd.noblenet-directory", 465, 1),
    ("application/vnd.noblenet-sealer", 466, 1),
    ("application/vnd.noblenet-web", 467, 1),
    ("application/vnd.nokia.n-gage.ac+xml", 468, 1),
    ("application/vnd.nokia.n-gage.data", 469, 1),
    ("application/vnd.nokia.n-gage.symbian.install", 470, 1),
    ("application/vnd.nokia.radio-preset", 471, 1),
    ("application/vnd.nokia.radio-presets", 472, 1),
    ("application/vnd.novadigm.edm", 473, 1),
    ("application/vnd.novadigm.edx", 474, 1),
    ("application/vnd.novadigm.ext", 475, 1),
    ("application/vnd.oasis.opendocument.chart", 476, 1),
    ("application/vnd.oasis.opendocument.chart-template", 477, 1),
    ("application/vnd.oasis.opendocument.database", 478, 1),
    ("application/vnd.oasis.opendocument.formula", 479, 1),
    (
        "application/vnd.oasis.opendocument.formula-template",
        480,
        1,
    ),
    ("application/vnd.oasis.opendocument.graphics", 481, 1),
    (
        "application/vnd.oasis.opendocument.graphics-template",
        482,
        1,
    ),
    ("application/vnd.oasis.opendocument.image", 483, 1),
    ("application/vnd.oasis.opendocument.image-template", 484, 1),
    ("application/vnd.oasis.opendocument.presentation", 485, 1),
    (
        "application/vnd.oasis.opendocument.presentation-template",
        486,
        1,
    ),
    ("application/vnd.oasis.opendocument.spreadsheet", 487, 1),
    (
        "application/vnd.oasis.opendocument.spreadsheet-template",
        488,
        1,
    ),
    ("application/vnd.oasis.opendocument.text", 489, 1),
    ("application/vnd.oasis.opendocument.text-master", 490, 1),
    ("application/vnd.oasis.opendocument.text-template", 491, 1),
    ("application/vnd.oasis.opendocument.text-web", 492, 1),
    ("application/vnd.olpc-sugar", 493, 1),
    ("application/vnd.oma.dd2+xml", 494, 1),
    ("application/vnd.openblox.game+xml", 495, 1),
    ("application/vnd.openofficeorg.extension", 496, 1),
    ("application/vnd.openstreetmap.data+xml", 497, 1),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.presentation",
        498,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.slide",
        499,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
        500,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.presentationml.template",
        501,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
        502,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.spreadsheetml.template",
        503,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        504,
        1,
    ),
    (
        "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
        505,
        1,
    ),
    ("application/vnd.osgeo.mapguide.package", 506, 1),
    ("application/vnd.osgi.dp", 507, 1),
    ("application/vnd.osgi.subsystem", 508, 1),
    ("application/vnd.palm", 509, 3),
    ("application/vnd.pawaafile", 512, 1),
    ("application/vnd.pg.format", 513, 1),
    ("application/vnd.pg.osasli", 514, 1),
    ("application/vnd.picsel", 515, 1),
    ("application/vnd.pmi.widget", 516, 1),
    ("application/vnd.pocketlearn", 517, 1),
    ("application/vnd.powerbuilder6", 518, 1),
    ("application/vnd.previewsystems.box", 519, 1),
    ("application/vnd.proteus.magazine", 520, 1),
    ("application/vnd.publishare-delta-tree", 521, 1),
    ("application/vnd.pvi.ptid1", 522, 1),
    ("application/vnd.quark.quarkxpress", 523, 6),
    ("application/vnd.rar", 529, 1),
    ("application/vnd.realvnc.bed", 530, 1),
    ("application/vnd.recordare.musicxml", 531, 1),
    ("application/vnd.recordare.musicxml+xml", 532, 1),
    ("application/vnd.rig.cryptonote", 533, 1),
    ("application/vnd.rim.cod", 534, 1),
    ("application/vnd.rn-realmedia", 535, 1),
    ("application/vnd.rn-realmedia-vbr", 536, 1),
    ("application/vnd.route66.link66+xml", 537, 1),
    ("application/vnd.sailingtracker.track", 538, 1),
    ("application/vnd.seemail", 539, 1),
    ("application/vnd.sema", 540, 1),
    ("application/vnd.semd", 541, 1),
    ("application/vnd.semf", 542, 1),
    ("application/vnd.shana.informed.formdata", 543, 1),
    ("application/vnd.shana.informed.formtemplate", 544, 1),
    ("application/vnd.shana.informed.interchange", 545, 1),
    ("application/vnd.shana.informed.package", 546, 1),
    ("application/vnd.simtech-mindmapper", 547, 2),
    ("application/vnd.smaf", 549, 1),
    ("application/vnd.smart.teacher", 550, 1),
    ("application/vnd.software602.filler.form+xml", 551, 1),
    ("application/vnd.solent.sdkm+xml", 552, 2),
    ("application/vnd.spotfire.dxp", 554, 1),
    ("application/vnd.spotfire.sfs", 555, 1),
    ("application/vnd.stardivision.calc", 556, 1),
    ("application/vnd.stardivision.draw", 557, 1),
    ("application/vnd.stardivision.impress", 558, 1),
    ("application/vnd.stardivision.math", 559, 1),
    ("application/vnd.stardivision.writer", 560, 2),
    ("application/vnd.stardivision.writer-global", 562, 1),
    ("application/vnd.stepmania.package", 563, 1),
    ("application/vnd.stepmania.stepchart", 564, 1),
    ("application/vnd.sun.wadl+xml", 565, 1),
    ("application/vnd.sun.xml.calc", 566, 1),
    ("application/vnd.sun.xml.calc.template", 567, 1),
    ("application/vnd.sun.xml.draw", 568, 1),
    ("application/vnd.sun.xml.draw.template", 569, 1),
    ("application/vnd.sun.xml.impress", 570, 1),
    ("application/vnd.sun.xml.impress.template", 571, 1),
    ("application/vnd.sun.xml.math", 572, 1),
    ("application/vnd.sun.xml.writer", 573, 1),
    ("application/vnd.sun.xml.writer.global", 574, 1),
    ("application/vnd.sun.xml.writer.template", 575, 1),
    ("application/vnd.sus-calendar", 576, 2),
    ("application/vnd.svd", 578, 1),
    ("application/vnd.symbian.install", 579, 2),
    ("application/vnd.syncml+xml", 581, 1),
    ("application/vnd.syncml.dm+wbxml", 582, 1),
    ("application/vnd.syncml.dm+xml", 583, 1),
    ("application/vnd.syncml.dmddf+xml", 584, 1),
    ("application/vnd.tao.intent-module-archive", 585, 1),
    ("application/vnd.tcpdump.pcap", 586, 3),
    ("application/vnd.tmobile-livetv", 589, 1),
    ("application/vnd.trid.tpt", 590, 1),
    ("application/vnd.triscape.mxs", 591, 1),
    ("application/vnd.trueapp", 592, 1),
    ("application/vnd.ufdl", 593, 2),
    ("application/vnd.uiq.theme", 595, 1),
    ("application/vnd.umajin", 596, 1),
    ("application/vnd.unity", 597, 1),
    ("application/vnd.uoml+xml", 598, 1),
    ("application/vnd.vcx", 599, 1),
    ("application/vnd.visio", 600, 4),
    ("application/vnd.visionary", 604, 1),
    ("application/vnd.vsf", 605, 1),
    ("application/vnd.wap.wbxml", 606, 1),
    ("application/vnd.wap.wmlc", 607, 1),
    ("application/vnd.wap.wmlscriptc", 608, 1),
    ("application/vnd.webturbo", 609, 1),
    ("application/vnd.wolfram.player", 610, 1),
    ("application/vnd.wordperfect", 611, 1),
    ("application/vnd.wqd", 612, 1),
    ("application/vnd.wt.stf", 613, 1),
    ("application/vnd.xara", 614, 1),
    ("application/vnd.xfdl", 615, 1),
    ("application/vnd.yamaha.hv-dic", 616, 1),
    ("application/vnd.yamaha.hv-script", 617, 1),
    ("application/vnd.yamaha.hv-voice", 618, 1),
    ("application/vnd.yamaha.openscoreformat", 619, 1),
    ("application/vnd.yamaha.openscoreformat.osfpvg+xml", 620, 1),
    ("application/vnd.yamaha.smaf-audio", 621, 1),
    ("application/vnd.yamaha.smaf-phrase", 622, 1),
    ("application/vnd.yellowriver-custom-menu", 623, 1),
    ("application/vnd.zul", 624, 2),
    ("application/vnd.zzazz.deck+xml", 626, 1),
    ("application/voicexml+xml", 627, 1),
    ("application/wasm", 628, 1),
    ("application/widget", 629, 1),
    ("application/winhlp", 630, 1),
    ("application/wsdl+xml", 631, 1),
    ("application/wspolicy+xml", 632, 1),
    ("application/x-7z-compressed", 633, 1),
    ("application/x-abiword", 634, 1),
    ("application/x-ace-compressed", 635, 1),
    ("application/x-apple-diskimage", 636, 1),
    ("application/x-arj", 637, 1),
    ("application/x-authorware-bin", 638, 4),
    ("application/x-authorware-map", 642, 1),
    ("application/x-authorware-seg", 643, 1),
    ("application/x-bcpio", 644, 1),
    ("application/x-bdoc", 645, 1),
    ("application/x-bittorrent", 646, 1),
    ("application/x-blorb", 647, 2),
    ("application/x-bzip", 649, 1),
    ("application/x-bzip2", 650, 2),
    ("application/x-cbr", 652, 5),
    ("application/x-cdlink", 657, 1),
    ("application/x-cfs-compressed", 658, 1),
    ("application/x-chat", 659, 1),
    ("application/x-chess-pgn", 660, 1),
    ("application/x-chrome-extension", 661, 1),
    ("application/x-cocoa", 662, 1),
    ("application/x-conference", 663, 1),
    ("application/x-cpio", 664, 1),
    ("application/x-csh", 665, 1),
    ("application/x-debian-package", 666, 2),
    ("application/x-dgc-compressed", 668, 1),
    ("application/x-director", 669, 9),
    ("application/x-doom", 678, 1),
    ("application/x-dtbncx+xml", 679, 1),
    ("application/x-dtbook+xml", 680, 1),
    ("application/x-dtbresource+xml", 681, 1),
    ("application/x-dvi", 682, 1),
    ("application/x-envoy", 683, 1),
    ("application/x-eva", 684, 1),
    ("application/x-font-bdf", 685, 1),
    ("application/x-font-ghostscript", 686, 1),
    ("application/x-font-linux-psf", 687, 1),
    ("application/x-font-pcf", 688, 1),
    ("application/x-font-snf", 689, 1),
    ("application/x-font-type1", 690, 4),
    ("application/x-freearc", 694, 1),
    ("application/x-futuresplash", 695, 1),
    ("application/x-gca-compressed", 696, 1),
    ("application/x-glulx", 697, 1),
    ("application/x-gnumeric", 698, 1),
    ("application/x-gramps-xml", 699, 1),
    ("application/x-gtar", 700, 1),
    ("application/x-hdf", 701, 1),
    ("application/x-httpd-php", 702, 1),
    ("application/x-install-instructions", 703, 1),
    ("application/x-iso9660-image", 704, 1),
    ("application/x-java-archive-diff", 705, 1),
    ("application/x-java-jnlp-file", 706, 1),
    ("application/x-keepass2", 707, 1),
    ("application/x-latex", 708, 1),
    ("application/x-lua-bytecode", 709, 1),
    ("application/x-lzh-compressed", 710, 2),
    ("application/x-makeself", 712, 1),
    ("application/x-mie", 713, 1),
    ("application/x-mobipocket-ebook", 714, 2),
    ("application/x-ms-application", 716, 1),
    ("application/x-ms-shortcut", 717, 1),
    ("application/x-ms-wmd", 718, 1),
    ("application/x-ms-wmz", 719, 1),
    ("application/x-ms-xbap", 720, 1),
    ("application/x-msaccess", 721, 1),
    ("application/x-msbinder", 722, 1),
    ("application/x-mscardfile", 723, 1),
    ("application/x-msclip", 724, 1),
    ("application/x-msdos-program", 725, 1),
    ("application/x-msdownload", 726, 5),
    ("application/x-msmediaview", 731, 3),
    ("application/x-msmetafile", 734, 4),
    ("application/x-msmoney", 738, 1),
    ("application/x-mspublisher", 739, 1),
    ("application/x-msschedule", 740, 1),
    ("application/x-msterminal", 741, 1),
    ("application/x-mswrite", 742, 1),
    ("application/x-netcdf", 743, 2),
    ("application/x-ns-proxy-autoconfig", 745, 1),
    ("application/x-nzb", 746, 1),
    ("application/x-perl", 747, 2),
    ("application/x-pilot", 749, 2),
    ("application/x-pkcs12", 751, 2),
    ("application/x-pkcs7-certificates", 753, 2),
    ("application/x-pkcs7-certreqresp", 755, 1),
    ("application/x-rar-compressed", 756, 1),
    ("application/x-redhat-package-manager", 757, 1),
    ("application/x-research-info-systems", 758, 1),
    ("application/x-sea", 759, 1),
    ("application/x-sh", 760, 1),
    ("application/x-shar", 761, 1),
    ("application/x-shockwave-flash", 762, 1),
    ("application/x-silverlight-app", 763, 1),
    ("application/x-sql", 764, 1),
    ("application/x-stuffit", 765, 1),
    ("application/x-stuffitx", 766, 1),
    ("application/x-subrip", 767, 1),
    ("application/x-sv4cpio", 768, 1),
    ("application/x-sv4crc", 769, 1),
    ("application/x-t3vm-image", 770, 1),
    ("application/x-tads", 771, 1),
    ("application/x-tar", 772, 1),
    ("application/x-tcl", 773, 2),
    ("application/x-tex", 775, 1),
    ("application/x-tex-tfm", 776, 1),
    ("application/x-texinfo", 777, 2),
    ("application/x-tgif", 779, 1),
    ("application/x-ustar", 780, 1),
    ("application/x-virtualbox-hdd", 781, 1),
    ("application/x-virtualbox-ova", 782, 1),
    ("application/x-virtualbox-ovf", 783, 1),
    ("application/x-virtualbox-vbox", 784, 1),
    ("application/x-virtualbox-vbox-extpack", 785, 1),
    ("application/x-virtualbox-vdi", 786, 1),
    ("application/x-virtualbox-vhd", 787, 1),
    ("application/x-virtualbox-vmdk", 788, 1),
    ("application/x-wais-source", 789, 1),
    ("application/x-web-app-manifest+json", 790, 1),
    ("application/x-x509-ca-cert", 791, 3),
    ("application/x-xfig", 794, 1),
    ("application/x-xliff+xml", 795, 1),
    ("application/x-xpinstall", 796, 1),
    ("application/x-xz", 797, 1),
    ("application/x-zmachine", 798, 8),
    ("application/xaml+xml", 806, 1),
    ("application/xcap-att+xml", 807, 1),
    ("application/xcap-caps+xml", 808, 1),
    ("application/xcap-diff+xml", 809, 1),
    ("application/xcap-el+xml", 810, 1),
    ("application/xcap-ns+xml", 811, 1),
    ("application/xenc+xml", 812, 1),
    ("application/xhtml+xml", 813, 2),
    ("application/xliff+xml", 815, 1),
    ("application/xml", 816, 4),
    ("application/xml-dtd", 820, 1),
    ("application/xop+xml", 821, 1),
    ("application/xproc+xml", 822, 1),
    ("application/xslt+xml", 823, 2),
    ("application/xspf+xml", 825, 1),
    ("application/xv+xml", 826, 4),
    ("application/yang", 830, 1),
    ("application/yin+xml", 831, 1),
    ("application/zip", 832, 1),
    ("audio/3gpp", 833, 1),
    ("audio/adpcm", 834, 1),
    ("audio/amr", 835, 1),
    ("audio/basic", 836, 2),
    ("audio/midi", 838, 4),
    ("audio/mobile-xmf", 842, 1),
    ("audio/mp3", 843, 1),
    ("audio/mp4", 844, 2),
    ("audio/mpeg", 846, 6),
    ("audio/ogg", 852, 4),
    ("audio/s3m", 856, 1),
    ("audio/silk", 857, 1),
    ("audio/vnd.dece.audio", 858, 2),
    ("audio/vnd.digital-winds", 860, 1),
    ("audio/vnd.dra", 861, 1),
    ("audio/vnd.dts", 862, 1),
    ("audio/vnd.dts.hd", 863, 1),
    ("audio/vnd.lucent.voice", 864, 1),
    ("audio/vnd.ms-playready.media.pya", 865, 1),
    ("audio/vnd.nuera.ecelp4800", 866, 1),
    ("audio/vnd.nuera.ecelp7470", 867, 1),
    ("audio/vnd.nuera.ecelp9600", 868, 1),
    ("audio/vnd.rip", 869, 1),
    ("audio/wav", 870, 1),
    ("audio/wave", 871, 1),
    ("audio/webm", 872, 1),
    ("audio/x-aac", 873, 1),
    ("audio/x-aiff", 874, 3),
    ("audio/x-caf", 877, 1),
    ("audio/x-flac", 878, 1),
    ("audio/x-m4a", 879, 1),
    ("audio/x-matroska", 880, 1),
    ("audio/x-mpegurl", 881, 1),
    ("audio/x-ms-wax", 882, 1),
    ("audio/x-ms-wma", 883, 1),
    ("audio/x-pn-realaudio", 884, 2),
    ("audio/x-pn-realaudio-plugin", 886, 1),
    ("audio/x-realaudio", 887, 1),
    ("audio/x-wav", 888, 1),
    ("audio/xm", 889, 1),
    ("chemical/x-cdx", 890, 1),
    ("chemical/x-cif", 891, 1),
    ("chemical/x-cmdf", 892, 1),
    ("chemical/x-cml", 893, 1),
    ("chemical/x-csml", 894, 1),
    ("chemical/x-xyz", 895, 1),
    ("font/collection", 896, 1),
    ("font/otf", 897, 1),
    ("font/ttf", 898, 1),
    ("font/woff", 899, 1),
    ("font/woff2", 900, 1),
    ("image/aces", 901, 1),
    ("image/apng", 902, 1),
    ("image/avif", 903, 1),
    ("image/bmp", 904, 1),
    ("image/cgm", 905, 1),
    ("image/dicom-rle", 906, 1),
    ("image/emf", 907, 1),
    ("image/fits", 908, 1),
    ("image/g3fax", 909, 1),
    ("image/gif", 910, 1),
    ("image/heic", 911, 1),
    ("image/heic-sequence", 912, 1),
    ("image/heif", 913, 1),
    ("image/heif-sequence", 914, 1),
    ("image/hej2k", 915, 1),
    ("image/hsj2", 916, 1),
    ("image/ief", 917, 1),
    ("image/jls", 918, 1),
    ("image/jp2", 919, 2),
    ("image/jpeg", 921, 3),
    ("image/jph", 924, 1),
    ("image/jphc", 925, 1),
    ("image/jpm", 926, 1),
    ("image/jpx", 927, 2),
    ("image/jxr", 929, 1),
    ("image/jxra", 930, 1),
    ("image/jxrs", 931, 1),
    ("image/jxs", 932, 1),
    ("image/jxsc", 933, 1),
    ("image/jxsi", 934, 1),
    ("image/jxss", 935, 1),
    ("image/ktx", 936, 1),
    ("image/ktx2", 937, 1),
    ("image/png", 938, 1),
    ("image/prs.btif", 939, 1),
    ("image/prs.pti", 940, 1),
    ("image/sgi", 941, 1),
    ("image/svg+xml", 942, 2),
    ("image/t38", 944, 1),
    ("image/tiff", 945, 2),
    ("image/tiff-fx", 947, 1),
    ("image/vnd.adobe.photoshop", 948, 1),
    ("image/vnd.airzip.accelerator.azv", 949, 1),
    ("image/vnd.dece.graphic", 950, 4),
    ("image/vnd.djvu", 954, 2),
    ("image/vnd.dvb.subtitle", 956, 1),
    ("image/vnd.dwg", 957, 1),
    ("image/vnd.dxf", 958, 1),
    ("image/vnd.fastbidsheet", 959, 1),
    ("image/vnd.fpx", 960, 1),
    ("image/vnd.fst", 961, 1),
    ("image/vnd.fujixerox.edmics-mmr", 962, 1),
    ("image/vnd.fujixerox.edmics-rlc", 963, 1),
    ("image/vnd.microsoft.icon", 964, 1),
    ("image/vnd.ms-dds", 965, 1),
    ("image/vnd.ms-modi", 966, 1),
    ("image/vnd.ms-photo", 967, 1),
    ("image/vnd.net-fpx", 968, 1),
    ("image/vnd.pco.b16", 969, 1),
    ("image/vnd.tencent.tap", 970, 1),
    ("image/vnd.valve.source.texture", 971, 1),
    ("image/vnd.wap.wbmp", 972, 1),
    ("image/vnd.xiff", 973, 1),
    ("image/vnd.zbrush.pcx", 974, 1),
    ("image/webp", 975, 1),
    ("image/wmf", 976, 1),
    ("image/x-3ds", 977, 1),
    ("image/x-cmu-raster", 978, 1),
    ("image/x-cmx", 979, 1),
    ("image/x-freehand", 980, 5),
    ("image/x-icon", 985, 1),
    ("image/x-jng", 986, 1),
    ("image/x-mrsid-image", 987, 1),
    ("image/x-ms-bmp", 988, 1),
    ("image/x-pcx", 989, 1),
    ("image/x-pict", 990, 2),
    ("image/x-portable-anymap", 992, 1),
    ("image/x-portable-bitmap", 993, 1),
    ("image/x-portable-graymap", 994, 1),
    ("image/x-portable-pixmap", 995, 1),
    ("image/x-rgb", 996, 1),
    ("image/x-tga", 997, 1),
    ("image/x-xbitmap", 998, 1),
    ("image/x-xpixmap", 999, 1),
    ("image/x-xwindowdump", 1000, 1),
    ("message/disposition-notification", 1001, 1),
    ("message/global", 1002, 1),
    ("message/global-delivery-status", 1003, 1),
    ("message/global-disposition-notification", 1004, 1),
    ("message/global-headers", 1005, 1),
    ("message/rfc822", 1006, 2),
    ("message/vnd.wfa.wsc", 1008, 1),
    ("model/3mf", 1009, 1),
    ("model/gltf+json", 1010, 1),
    ("model/gltf-binary", 1011, 1),
    ("model/iges", 1012, 2),
    ("model/mesh", 1014, 3),
    ("model/mtl", 1017, 1),
    ("model/obj", 1018, 1),
    ("model/stl", 1019, 1),
    ("model/vnd.collada+xml", 1020, 1),
    ("model/vnd.dwf", 1021, 1),
    ("model/vnd.gdl", 1022, 1),
    ("model/vnd.gtw", 1023, 1),
    ("model/vnd.mts", 1024, 1),
    ("model/vnd.opengex", 1025, 1),
    ("model/vnd.parasolid.transmit.binary", 1026, 1),
    ("model/vnd.parasolid.transmit.text", 1027, 1),
    ("model/vnd.sap.vds", 1028, 1),
    ("model/vnd.usdz+zip", 1029, 1),
    ("model/vnd.valve.source.compiled-map", 1030, 1),
    ("model/vnd.vtu", 1031, 1),
    ("model/vrml", 1032, 2),
    ("model/x3d+binary", 1034, 2),
    ("model/x3d+fastinfoset", 1036, 1),
    ("model/x3d+vrml", 1037, 2),
    ("model/x3d+xml", 1039, 2),
    ("model/x3d-vrml", 1041, 1),
    ("text/cache-manifest", 1042, 2),
    ("text/calendar", 1044, 2),
    ("text/coffeescript", 1046, 2),
    ("text/css", 1048, 1),
    ("text/csv", 1049, 1),
    ("text/html", 1050, 3),
    ("text/jade", 1053, 1),
    ("text/jsx", 1054, 1),
    ("text/less", 1055, 1),
    ("text/markdown", 1056, 2),
    ("text/mathml", 1058, 1),
    ("text/mdx", 1059, 1),
    ("text/n3", 1060, 1),
    ("text/plain", 1061, 8),
    ("text/prs.lines.tag", 1069, 1),
    ("text/richtext", 1070, 1),
    ("text/rtf", 1071, 1),
    ("text/sgml", 1072, 2),
    ("text/shex", 1074, 1),
    ("text/slim", 1075, 2),
    ("text/spdx", 1077, 1),
    ("text/stylus", 1078, 2),
    ("text/tab-separated-values", 1080, 1),
    ("text/troff", 1081, 6),
    ("text/turtle", 1087, 1),
    ("text/uri-list", 1088, 3),
    ("text/vcard", 1091, 1),
    ("text/vnd.curl", 1092, 1),
    ("text/vnd.curl.dcurl", 1093, 1),
    ("text/vnd.curl.mcurl", 1094, 1),
    ("text/vnd.curl.scurl", 1095, 1),
    ("text/vnd.dvb.subtitle", 1096, 1),
    ("text/vnd.fly", 1097, 1),
    ("text/vnd.fmi.flexstor", 1098, 1),
    ("text/vnd.graphviz", 1099, 1),
    ("text/vnd.in3d.3dml", 1100, 1),
    ("text/vnd.in3d.spot", 1101, 1),
    ("text/vnd.sun.j2me.app-descriptor", 1102, 1),
    ("text/vnd.wap.wml", 1103, 1),
    ("text/vnd.wap.wmlscript", 1104, 1),
    ("text/vtt", 1105, 1),
    ("text/x-asm", 1106, 2),
    ("text/x-c", 1108, 7),
    ("text/x-component", 1115, 1),
    ("text/x-fortran", 1116, 4),
    ("text/x-handlebars-template", 1120, 1),
    ("text/x-java-source", 1121, 1),
    ("text/x-lua", 1122, 1),
    ("text/x-markdown", 1123, 1),
    ("text/x-nfo", 1124, 1),
    ("text/x-opml", 1125, 1),
    ("text/x-org", 1126, 1),
    ("text/x-pascal", 1127, 2),
    ("text/x-processing", 1129, 1),
    ("text/x-sass", 1130, 1),
    ("text/x-scss", 1131, 1),
    ("text/x-setext", 1132, 1),
    ("text/x-sfv", 1133, 1),
    ("text/x-suse-ymp", 1134, 1),
    ("text/x-uuencode", 1135, 1),
    ("text/x-vcalendar", 1136, 1),
    ("text/x-vcard", 1137, 1),
    ("text/xml", 1138, 1),
    ("text/yaml", 1139, 2),
    ("video/3gpp", 1141, 2),
    ("video/3gpp2", 1143, 1),
    ("video/h261", 1144, 1),
    ("video/h263", 1145, 1),
    ("video/h264", 1146, 1),
    ("video/iso.segment", 1147, 1),
    ("video/jpeg", 1148, 1),
    ("video/jpm", 1149, 2),
    ("video/mj2", 1151, 2),
    ("video/mp2t", 1153, 1),
    ("video/mp4", 1154, 3),
    ("video/mpeg", 1157, 5),
    ("video/ogg", 1162, 1),
    ("video/quicktime", 1163, 2),
    ("video/vnd.dece.hd", 1165, 2),
    ("video/vnd.dece.mobile", 1167, 2),
    ("video/vnd.dece.pd", 1169, 2),
    ("video/vnd.dece.sd", 1171, 2),
    ("video/vnd.dece.video", 1173, 2),
    ("video/vnd.dvb.file", 1175, 1),
    ("video/vnd.fvt", 1176, 1),
    ("video/vnd.mpegurl", 1177, 2),
    ("video/vnd.ms-playready.media.pyv", 1179, 1),
    ("video/vnd.uvvu.mp4", 1180, 2),
    ("video/vnd.vivo", 1182, 1),
    ("video/webm", 1183, 1),
    ("video/x-f4v", 1184, 1),
    ("video/x-fli", 1185, 1),
    ("video/x-flv", 1186, 1),
    ("video/x-m4v", 1187, 1),
    ("video/x-matroska", 1188, 3),
    ("video/x-mng", 1191, 1),
    ("video/x-ms-asf", 1192, 2),
    ("video/x-ms-vob", 1194, 1),
    ("video/x-ms-wm", 1195, 1),
    ("video/x-ms-wmv", 1196, 1),
    ("video/x-ms-wmx", 1197, 1),
    ("video/x-ms-wvx", 1198, 1),
    ("video/x-msvideo", 1199, 1),
    ("video/x-sgi-movie", 1200, 1),
    ("video/x-smv", 1201, 1),
    ("x-conference/x-cooltalk", 1202, 1),
];
