use libloading::*;
use crate::generated::vulkan_bundle::{PTR_vkGetInstanceProcAddr, PTR_vkGetDeviceProcAddr};

#[cfg(target_os = "linux")]
const LIB_NAME:&str = "libvulkan.so.1";

#[cfg(target_os = "android")]
const LIB_NAME:&str = "libvulkan.so";

pub struct ProcAddr {
    library: Library
}

impl ProcAddr {
    pub fn new() -> Option<Self> {
        unsafe {
            let vulkan = match Library::new(LIB_NAME) {
                Err(_) => return None,
                Ok(lib) => lib
            };

            Some( Self {
                library: vulkan
            })
        }
    }

    pub fn instance(&self) -> Option<Symbol<PTR_vkGetInstanceProcAddr>> {
        unsafe {
            let i = match self.library.get::<PTR_vkGetInstanceProcAddr>(b"vkGetInstanceProcAddr\0") {
                Ok(sym) => sym,
                Err(_) => return None
            };

            Some(i)
        }
    }

    pub fn device(&self) -> Option<Symbol<PTR_vkGetDeviceProcAddr>> {
        unsafe {
            let d = match self.library.get::<PTR_vkGetDeviceProcAddr>(b"vkGetDeviceProcAddr\0") {
                Ok(sym) => sym,
                Err(_) => return None
            };

            Some(d)
        }
    }

    pub fn library_name() -> &'static str {
        LIB_NAME
    }

}
