BEGIN {
    line = ""
    
    parsing = 0
    inline = 0
    
    is_type = 0
    is_fn = 0
    is_member = 0
    is_ret = 0
    is_end = 0
    
    
    last_match = "" 
}

{
    if(line != "") {
        if(is_type || is_fn) {
            sub("PFN", "PTR", line)
            sub("::std::option::Option<", "", line)
        }
        
        if(is_ret) {
            sub(",$", "", line) 
        }
        
        if(is_end) {
            sub(">;", ";", line)
        }
        
        #print "// last match:", last_match
        print line
        
        line = ""
        is_type = is_fn = is_member = is_ret = is_end = 0
    }
}

/pub type PFN_vk/ {
    parsing = 1
    is_type = NR
    last_match = "type"
    
    line = $0
}

/unsafe extern "C" fn\(/ {
    if(parsing) {
        is_fn = NR
        last_match = "fn"
        
        line = $0
    }
}

/[a-zA-Z_][a-zA-Z0-9_]*[ \t]*:[ \t]*([a-zA-Z_]|[* \t]+)[a-zA-Z0-9_:* \t]*[ \t]*,?/  {
    if(parsing) {
        is_member = NR
        last_match = "member"
        
        line = $0
    }
}

/)[ \t]*[->]?[ \t]*[^,]*,$/ {
    if(parsing != 0) {
        is_ret = NR
        last_match = "ret"
        
        line = $0
    }
}

/>;/ {
    if(parsing) {
        parsing = 0;
        is_end = NR
        last_match = "end"
        
        line = $0
    }
}
