use bindgen;
use std::path::PathBuf;
use std::process::Command;

fn main() {
    // Tell cargo to tell rustc to link the system bzip2
    // shared library.
    //println!("cargo:rustc-link-lib=vulkan_impl");

    // Tell cargo to invalidate the built crate whenever the wrapper changes
    println!("cargo:rerun-if-changed=wrapper.h");

    // The bindgen::Builder is the main entry point
    // to bindgen, and lets you build up options for
    // the resulting bindings.
    let bindings = bindgen::Builder::default()
        // The input header we would like to generate
        // bindings for.
        .header("wrapper.h")
        // Tell cargo to invalidate the built crate whenever any of the
        // included header files changed.
        .parse_callbacks(Box::new(bindgen::CargoCallbacks))
        // Finish the builder and generate the bindings.
        .generate()
        // Unwrap the Result and panic on failure.
        .expect("Unable to generate bindings");

    // Write the bindings to the $OUT_DIR/bindings.rs file.
    let out = "./src/generated";

    let out_path = PathBuf::from(out);
    if std::fs::read_dir(out).is_err() {
        if std::fs::create_dir(out).is_err()  {
            println!("Wrong error!");
            return;
        }
    }
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");

    let mut symbols = Command::new("sh");
    symbols.arg("-c");
    symbols.arg(format!("cat {} | ./vulkan_impl.sh && mv vulkan_bundle.rs {} && rm {}",
                        out_path.join("bindings.rs").to_str().unwrap(),
                        out_path.to_str().unwrap(),
                        out_path.join("bindings.rs").to_str().unwrap()));
    symbols.output().unwrap();
}
