use vulkan::*;
use std::os::raw::c_char;

#[test]
fn instance_extensions() {
    let loader = ProcAddr::new().unwrap();

    let instance_loader = loader.instance().unwrap();

    unsafe {
        let e:PTR_vkEnumerateInstanceExtensionProperties = std::mem::transmute(instance_loader(
            std::ptr::null_mut(), b"vkEnumerateInstanceExtensionProperties\0".as_ptr() as *const c_char));

        let mut count = 0 as u32;
        (e)(std::ptr::null_mut(), &mut count, std::ptr::null_mut());

        let zero: VkExtensionProperties = std::mem::zeroed();
        let mut extensions = Vec::<VkExtensionProperties>::with_capacity(
            count as usize);
        extensions.resize(count as usize, zero);

        (e)(std::ptr::null_mut(), &mut count, extensions.as_mut_ptr());

        println!("Instance extensions");
        for extension in extensions.iter().enumerate() {
            println!("extension #{} - {}", extension.0, std::ffi::CStr::from_ptr(
                extension.1.extensionName.as_ptr().cast()).to_str().unwrap());
        }
    }
}