/* automatically generated by rust-bindgen 0.57.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const VULKAN_H_: u32 = 1;
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 31;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LONG_DOUBLE_USES_FLOAT128: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const VULKAN_CORE_H_: u32 = 1;
pub const VK_VERSION_1_0: u32 = 1;
pub const VK_HEADER_VERSION: u32 = 173;
pub const VK_NULL_HANDLE: u32 = 0;
pub const VK_ATTACHMENT_UNUSED: i32 = -1;
pub const VK_FALSE: u32 = 0;
pub const VK_LOD_CLAMP_NONE: f64 = 1000.0;
pub const VK_QUEUE_FAMILY_IGNORED: i32 = -1;
pub const VK_REMAINING_ARRAY_LAYERS: i32 = -1;
pub const VK_REMAINING_MIP_LEVELS: i32 = -1;
pub const VK_SUBPASS_EXTERNAL: i32 = -1;
pub const VK_TRUE: u32 = 1;
pub const VK_WHOLE_SIZE: i32 = -1;
pub const VK_MAX_MEMORY_TYPES: u32 = 32;
pub const VK_MAX_MEMORY_HEAPS: u32 = 16;
pub const VK_MAX_PHYSICAL_DEVICE_NAME_SIZE: u32 = 256;
pub const VK_UUID_SIZE: u32 = 16;
pub const VK_MAX_EXTENSION_NAME_SIZE: u32 = 256;
pub const VK_MAX_DESCRIPTION_SIZE: u32 = 256;
pub const VK_VERSION_1_1: u32 = 1;
pub const VK_MAX_DEVICE_GROUP_SIZE: u32 = 32;
pub const VK_LUID_SIZE: u32 = 8;
pub const VK_QUEUE_FAMILY_EXTERNAL: i32 = -2;
pub const VK_VERSION_1_2: u32 = 1;
pub const VK_MAX_DRIVER_NAME_SIZE: u32 = 256;
pub const VK_MAX_DRIVER_INFO_SIZE: u32 = 256;
pub const VK_KHR_surface: u32 = 1;
pub const VK_KHR_SURFACE_SPEC_VERSION: u32 = 25;
pub const VK_KHR_SURFACE_EXTENSION_NAME: &'static [u8; 15usize] = b"VK_KHR_surface\0";
pub const VK_KHR_swapchain: u32 = 1;
pub const VK_KHR_SWAPCHAIN_SPEC_VERSION: u32 = 70;
pub const VK_KHR_SWAPCHAIN_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_swapchain\0";
pub const VK_KHR_display: u32 = 1;
pub const VK_KHR_DISPLAY_SPEC_VERSION: u32 = 23;
pub const VK_KHR_DISPLAY_EXTENSION_NAME: &'static [u8; 15usize] = b"VK_KHR_display\0";
pub const VK_KHR_display_swapchain: u32 = 1;
pub const VK_KHR_DISPLAY_SWAPCHAIN_SPEC_VERSION: u32 = 10;
pub const VK_KHR_DISPLAY_SWAPCHAIN_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_display_swapchain\0";
pub const VK_KHR_sampler_mirror_clamp_to_edge: u32 = 1;
pub const VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_SPEC_VERSION: u32 = 3;
pub const VK_KHR_SAMPLER_MIRROR_CLAMP_TO_EDGE_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_KHR_sampler_mirror_clamp_to_edge\0";
pub const VK_KHR_multiview: u32 = 1;
pub const VK_KHR_MULTIVIEW_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MULTIVIEW_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_multiview\0";
pub const VK_KHR_get_physical_device_properties2: u32 = 1;
pub const VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION: u32 = 2;
pub const VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME: &'static [u8; 39usize] =
    b"VK_KHR_get_physical_device_properties2\0";
pub const VK_KHR_device_group: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_SPEC_VERSION: u32 = 4;
pub const VK_KHR_DEVICE_GROUP_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_device_group\0";
pub const VK_KHR_shader_draw_parameters: u32 = 1;
pub const VK_KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_DRAW_PARAMETERS_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_KHR_shader_draw_parameters\0";
pub const VK_KHR_maintenance1: u32 = 1;
pub const VK_KHR_MAINTENANCE1_SPEC_VERSION: u32 = 2;
pub const VK_KHR_MAINTENANCE1_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance1\0";
pub const VK_KHR_device_group_creation: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_device_group_creation\0";
pub const VK_MAX_DEVICE_GROUP_SIZE_KHR: u32 = 32;
pub const VK_KHR_external_memory_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_KHR_external_memory_capabilities\0";
pub const VK_LUID_SIZE_KHR: u32 = 8;
pub const VK_KHR_external_memory: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_KHR_external_memory\0";
pub const VK_QUEUE_FAMILY_EXTERNAL_KHR: i32 = -2;
pub const VK_KHR_external_memory_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_MEMORY_FD_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_external_memory_fd\0";
pub const VK_KHR_external_semaphore_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_EXTENSION_NAME: &'static [u8; 39usize] =
    b"VK_KHR_external_semaphore_capabilities\0";
pub const VK_KHR_external_semaphore: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_external_semaphore\0";
pub const VK_KHR_external_semaphore_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_SEMAPHORE_FD_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_external_semaphore_fd\0";
pub const VK_KHR_push_descriptor: u32 = 1;
pub const VK_KHR_PUSH_DESCRIPTOR_SPEC_VERSION: u32 = 2;
pub const VK_KHR_PUSH_DESCRIPTOR_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_KHR_push_descriptor\0";
pub const VK_KHR_shader_float16_int8: u32 = 1;
pub const VK_KHR_SHADER_FLOAT16_INT8_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_FLOAT16_INT8_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_shader_float16_int8\0";
pub const VK_KHR_16bit_storage: u32 = 1;
pub const VK_KHR_16BIT_STORAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_16BIT_STORAGE_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_KHR_16bit_storage\0";
pub const VK_KHR_incremental_present: u32 = 1;
pub const VK_KHR_INCREMENTAL_PRESENT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_INCREMENTAL_PRESENT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_incremental_present\0";
pub const VK_KHR_descriptor_update_template: u32 = 1;
pub const VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_KHR_descriptor_update_template\0";
pub const VK_KHR_imageless_framebuffer: u32 = 1;
pub const VK_KHR_IMAGELESS_FRAMEBUFFER_SPEC_VERSION: u32 = 1;
pub const VK_KHR_IMAGELESS_FRAMEBUFFER_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_imageless_framebuffer\0";
pub const VK_KHR_create_renderpass2: u32 = 1;
pub const VK_KHR_CREATE_RENDERPASS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_CREATE_RENDERPASS_2_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_create_renderpass2\0";
pub const VK_KHR_shared_presentable_image: u32 = 1;
pub const VK_KHR_SHARED_PRESENTABLE_IMAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHARED_PRESENTABLE_IMAGE_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_shared_presentable_image\0";
pub const VK_KHR_external_fence_capabilities: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_CAPABILITIES_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_KHR_external_fence_capabilities\0";
pub const VK_KHR_external_fence: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_EXTENSION_NAME: &'static [u8; 22usize] = b"VK_KHR_external_fence\0";
pub const VK_KHR_external_fence_fd: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_FD_SPEC_VERSION: u32 = 1;
pub const VK_KHR_EXTERNAL_FENCE_FD_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_external_fence_fd\0";
pub const VK_KHR_performance_query: u32 = 1;
pub const VK_KHR_PERFORMANCE_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PERFORMANCE_QUERY_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_performance_query\0";
pub const VK_KHR_maintenance2: u32 = 1;
pub const VK_KHR_MAINTENANCE2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE2_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance2\0";
pub const VK_KHR_get_surface_capabilities2: u32 = 1;
pub const VK_KHR_GET_SURFACE_CAPABILITIES_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_SURFACE_CAPABILITIES_2_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_KHR_get_surface_capabilities2\0";
pub const VK_KHR_variable_pointers: u32 = 1;
pub const VK_KHR_VARIABLE_POINTERS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_VARIABLE_POINTERS_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_variable_pointers\0";
pub const VK_KHR_get_display_properties2: u32 = 1;
pub const VK_KHR_GET_DISPLAY_PROPERTIES_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_DISPLAY_PROPERTIES_2_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_KHR_get_display_properties2\0";
pub const VK_KHR_dedicated_allocation: u32 = 1;
pub const VK_KHR_DEDICATED_ALLOCATION_SPEC_VERSION: u32 = 3;
pub const VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_KHR_dedicated_allocation\0";
pub const VK_KHR_storage_buffer_storage_class: u32 = 1;
pub const VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_KHR_storage_buffer_storage_class\0";
pub const VK_KHR_relaxed_block_layout: u32 = 1;
pub const VK_KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RELAXED_BLOCK_LAYOUT_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_KHR_relaxed_block_layout\0";
pub const VK_KHR_get_memory_requirements2: u32 = 1;
pub const VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_get_memory_requirements2\0";
pub const VK_KHR_image_format_list: u32 = 1;
pub const VK_KHR_IMAGE_FORMAT_LIST_SPEC_VERSION: u32 = 1;
pub const VK_KHR_IMAGE_FORMAT_LIST_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_image_format_list\0";
pub const VK_KHR_sampler_ycbcr_conversion: u32 = 1;
pub const VK_KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION: u32 = 14;
pub const VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_sampler_ycbcr_conversion\0";
pub const VK_KHR_bind_memory2: u32 = 1;
pub const VK_KHR_BIND_MEMORY_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_BIND_MEMORY_2_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_bind_memory2\0";
pub const VK_KHR_maintenance3: u32 = 1;
pub const VK_KHR_MAINTENANCE3_SPEC_VERSION: u32 = 1;
pub const VK_KHR_MAINTENANCE3_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_maintenance3\0";
pub const VK_KHR_draw_indirect_count: u32 = 1;
pub const VK_KHR_DRAW_INDIRECT_COUNT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DRAW_INDIRECT_COUNT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_draw_indirect_count\0";
pub const VK_KHR_shader_subgroup_extended_types: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_SUBGROUP_EXTENDED_TYPES_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_shader_subgroup_extended_types\0";
pub const VK_KHR_8bit_storage: u32 = 1;
pub const VK_KHR_8BIT_STORAGE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_8BIT_STORAGE_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_8bit_storage\0";
pub const VK_KHR_shader_atomic_int64: u32 = 1;
pub const VK_KHR_SHADER_ATOMIC_INT64_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_ATOMIC_INT64_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_shader_atomic_int64\0";
pub const VK_KHR_shader_clock: u32 = 1;
pub const VK_KHR_SHADER_CLOCK_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_CLOCK_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_KHR_shader_clock\0";
pub const VK_KHR_driver_properties: u32 = 1;
pub const VK_KHR_DRIVER_PROPERTIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DRIVER_PROPERTIES_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_KHR_driver_properties\0";
pub const VK_MAX_DRIVER_NAME_SIZE_KHR: u32 = 256;
pub const VK_MAX_DRIVER_INFO_SIZE_KHR: u32 = 256;
pub const VK_KHR_shader_float_controls: u32 = 1;
pub const VK_KHR_SHADER_FLOAT_CONTROLS_SPEC_VERSION: u32 = 4;
pub const VK_KHR_SHADER_FLOAT_CONTROLS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_shader_float_controls\0";
pub const VK_KHR_depth_stencil_resolve: u32 = 1;
pub const VK_KHR_DEPTH_STENCIL_RESOLVE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_DEPTH_STENCIL_RESOLVE_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_depth_stencil_resolve\0";
pub const VK_KHR_swapchain_mutable_format: u32 = 1;
pub const VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SWAPCHAIN_MUTABLE_FORMAT_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_swapchain_mutable_format\0";
pub const VK_KHR_timeline_semaphore: u32 = 1;
pub const VK_KHR_TIMELINE_SEMAPHORE_SPEC_VERSION: u32 = 2;
pub const VK_KHR_TIMELINE_SEMAPHORE_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_KHR_timeline_semaphore\0";
pub const VK_KHR_vulkan_memory_model: u32 = 1;
pub const VK_KHR_VULKAN_MEMORY_MODEL_SPEC_VERSION: u32 = 3;
pub const VK_KHR_VULKAN_MEMORY_MODEL_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_KHR_vulkan_memory_model\0";
pub const VK_KHR_shader_terminate_invocation: u32 = 1;
pub const VK_KHR_SHADER_TERMINATE_INVOCATION_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_TERMINATE_INVOCATION_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_KHR_shader_terminate_invocation\0";
pub const VK_KHR_fragment_shading_rate: u32 = 1;
pub const VK_KHR_FRAGMENT_SHADING_RATE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_FRAGMENT_SHADING_RATE_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_fragment_shading_rate\0";
pub const VK_KHR_spirv_1_4: u32 = 1;
pub const VK_KHR_SPIRV_1_4_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SPIRV_1_4_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_spirv_1_4\0";
pub const VK_KHR_surface_protected_capabilities: u32 = 1;
pub const VK_KHR_SURFACE_PROTECTED_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SURFACE_PROTECTED_CAPABILITIES_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_surface_protected_capabilities\0";
pub const VK_KHR_separate_depth_stencil_layouts: u32 = 1;
pub const VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SEPARATE_DEPTH_STENCIL_LAYOUTS_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_separate_depth_stencil_layouts\0";
pub const VK_KHR_uniform_buffer_standard_layout: u32 = 1;
pub const VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_UNIFORM_BUFFER_STANDARD_LAYOUT_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_uniform_buffer_standard_layout\0";
pub const VK_KHR_buffer_device_address: u32 = 1;
pub const VK_KHR_BUFFER_DEVICE_ADDRESS_SPEC_VERSION: u32 = 1;
pub const VK_KHR_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_KHR_buffer_device_address\0";
pub const VK_KHR_deferred_host_operations: u32 = 1;
pub const VK_KHR_DEFERRED_HOST_OPERATIONS_SPEC_VERSION: u32 = 4;
pub const VK_KHR_DEFERRED_HOST_OPERATIONS_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_deferred_host_operations\0";
pub const VK_KHR_pipeline_executable_properties: u32 = 1;
pub const VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PIPELINE_EXECUTABLE_PROPERTIES_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_KHR_pipeline_executable_properties\0";
pub const VK_KHR_pipeline_library: u32 = 1;
pub const VK_KHR_PIPELINE_LIBRARY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_PIPELINE_LIBRARY_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_KHR_pipeline_library\0";
pub const VK_KHR_shader_non_semantic_info: u32 = 1;
pub const VK_KHR_SHADER_NON_SEMANTIC_INFO_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SHADER_NON_SEMANTIC_INFO_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_KHR_shader_non_semantic_info\0";
pub const VK_KHR_synchronization2: u32 = 1;
pub const VK_KHR_SYNCHRONIZATION_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_SYNCHRONIZATION_2_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_KHR_synchronization2\0";
pub const VK_KHR_zero_initialize_workgroup_memory: u32 = 1;
pub const VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_ZERO_INITIALIZE_WORKGROUP_MEMORY_EXTENSION_NAME: &'static [u8; 40usize] =
    b"VK_KHR_zero_initialize_workgroup_memory\0";
pub const VK_KHR_workgroup_memory_explicit_layout: u32 = 1;
pub const VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_EXTENSION_NAME: &'static [u8; 40usize] =
    b"VK_KHR_workgroup_memory_explicit_layout\0";
pub const VK_KHR_copy_commands2: u32 = 1;
pub const VK_KHR_COPY_COMMANDS_2_SPEC_VERSION: u32 = 1;
pub const VK_KHR_COPY_COMMANDS_2_EXTENSION_NAME: &'static [u8; 22usize] =
    b"VK_KHR_copy_commands2\0";
pub const VK_EXT_debug_report: u32 = 1;
pub const VK_EXT_DEBUG_REPORT_SPEC_VERSION: u32 = 9;
pub const VK_EXT_DEBUG_REPORT_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_debug_report\0";
pub const VK_NV_glsl_shader: u32 = 1;
pub const VK_NV_GLSL_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_NV_GLSL_SHADER_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_NV_glsl_shader\0";
pub const VK_EXT_depth_range_unrestricted: u32 = 1;
pub const VK_EXT_DEPTH_RANGE_UNRESTRICTED_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DEPTH_RANGE_UNRESTRICTED_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_EXT_depth_range_unrestricted\0";
pub const VK_IMG_filter_cubic: u32 = 1;
pub const VK_IMG_FILTER_CUBIC_SPEC_VERSION: u32 = 1;
pub const VK_IMG_FILTER_CUBIC_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_IMG_filter_cubic\0";
pub const VK_AMD_rasterization_order: u32 = 1;
pub const VK_AMD_RASTERIZATION_ORDER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_RASTERIZATION_ORDER_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_AMD_rasterization_order\0";
pub const VK_AMD_shader_trinary_minmax: u32 = 1;
pub const VK_AMD_SHADER_TRINARY_MINMAX_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_TRINARY_MINMAX_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_AMD_shader_trinary_minmax\0";
pub const VK_AMD_shader_explicit_vertex_parameter: u32 = 1;
pub const VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER_EXTENSION_NAME: &'static [u8; 40usize] =
    b"VK_AMD_shader_explicit_vertex_parameter\0";
pub const VK_EXT_debug_marker: u32 = 1;
pub const VK_EXT_DEBUG_MARKER_SPEC_VERSION: u32 = 4;
pub const VK_EXT_DEBUG_MARKER_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_debug_marker\0";
pub const VK_AMD_gcn_shader: u32 = 1;
pub const VK_AMD_GCN_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_GCN_SHADER_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_AMD_gcn_shader\0";
pub const VK_NV_dedicated_allocation: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_NV_dedicated_allocation\0";
pub const VK_EXT_transform_feedback: u32 = 1;
pub const VK_EXT_TRANSFORM_FEEDBACK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TRANSFORM_FEEDBACK_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_transform_feedback\0";
pub const VK_NVX_image_view_handle: u32 = 1;
pub const VK_NVX_IMAGE_VIEW_HANDLE_SPEC_VERSION: u32 = 2;
pub const VK_NVX_IMAGE_VIEW_HANDLE_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NVX_image_view_handle\0";
pub const VK_AMD_draw_indirect_count: u32 = 1;
pub const VK_AMD_DRAW_INDIRECT_COUNT_SPEC_VERSION: u32 = 2;
pub const VK_AMD_DRAW_INDIRECT_COUNT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_AMD_draw_indirect_count\0";
pub const VK_AMD_negative_viewport_height: u32 = 1;
pub const VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_SPEC_VERSION: u32 = 1;
pub const VK_AMD_NEGATIVE_VIEWPORT_HEIGHT_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_AMD_negative_viewport_height\0";
pub const VK_AMD_gpu_shader_half_float: u32 = 1;
pub const VK_AMD_GPU_SHADER_HALF_FLOAT_SPEC_VERSION: u32 = 2;
pub const VK_AMD_GPU_SHADER_HALF_FLOAT_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_AMD_gpu_shader_half_float\0";
pub const VK_AMD_shader_ballot: u32 = 1;
pub const VK_AMD_SHADER_BALLOT_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_BALLOT_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_AMD_shader_ballot\0";
pub const VK_AMD_texture_gather_bias_lod: u32 = 1;
pub const VK_AMD_TEXTURE_GATHER_BIAS_LOD_SPEC_VERSION: u32 = 1;
pub const VK_AMD_TEXTURE_GATHER_BIAS_LOD_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_AMD_texture_gather_bias_lod\0";
pub const VK_AMD_shader_info: u32 = 1;
pub const VK_AMD_SHADER_INFO_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_INFO_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_AMD_shader_info\0";
pub const VK_AMD_shader_image_load_store_lod: u32 = 1;
pub const VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_IMAGE_LOAD_STORE_LOD_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_AMD_shader_image_load_store_lod\0";
pub const VK_NV_corner_sampled_image: u32 = 1;
pub const VK_NV_CORNER_SAMPLED_IMAGE_SPEC_VERSION: u32 = 2;
pub const VK_NV_CORNER_SAMPLED_IMAGE_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_NV_corner_sampled_image\0";
pub const VK_IMG_format_pvrtc: u32 = 1;
pub const VK_IMG_FORMAT_PVRTC_SPEC_VERSION: u32 = 1;
pub const VK_IMG_FORMAT_PVRTC_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_IMG_format_pvrtc\0";
pub const VK_NV_external_memory_capabilities: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_NV_external_memory_capabilities\0";
pub const VK_NV_external_memory: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_NV_EXTERNAL_MEMORY_EXTENSION_NAME: &'static [u8; 22usize] = b"VK_NV_external_memory\0";
pub const VK_EXT_validation_flags: u32 = 1;
pub const VK_EXT_VALIDATION_FLAGS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_VALIDATION_FLAGS_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_validation_flags\0";
pub const VK_EXT_shader_subgroup_ballot: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_BALLOT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_BALLOT_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_shader_subgroup_ballot\0";
pub const VK_EXT_shader_subgroup_vote: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_VOTE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_SUBGROUP_VOTE_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_shader_subgroup_vote\0";
pub const VK_EXT_texture_compression_astc_hdr: u32 = 1;
pub const VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_EXT_texture_compression_astc_hdr\0";
pub const VK_EXT_astc_decode_mode: u32 = 1;
pub const VK_EXT_ASTC_DECODE_MODE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ASTC_DECODE_MODE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_astc_decode_mode\0";
pub const VK_EXT_conditional_rendering: u32 = 1;
pub const VK_EXT_CONDITIONAL_RENDERING_SPEC_VERSION: u32 = 2;
pub const VK_EXT_CONDITIONAL_RENDERING_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_conditional_rendering\0";
pub const VK_NV_clip_space_w_scaling: u32 = 1;
pub const VK_NV_CLIP_SPACE_W_SCALING_SPEC_VERSION: u32 = 1;
pub const VK_NV_CLIP_SPACE_W_SCALING_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_NV_clip_space_w_scaling\0";
pub const VK_EXT_direct_mode_display: u32 = 1;
pub const VK_EXT_DIRECT_MODE_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DIRECT_MODE_DISPLAY_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_direct_mode_display\0";
pub const VK_EXT_display_surface_counter: u32 = 1;
pub const VK_EXT_DISPLAY_SURFACE_COUNTER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISPLAY_SURFACE_COUNTER_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_EXT_display_surface_counter\0";
pub const VK_EXT_display_control: u32 = 1;
pub const VK_EXT_DISPLAY_CONTROL_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISPLAY_CONTROL_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_EXT_display_control\0";
pub const VK_GOOGLE_display_timing: u32 = 1;
pub const VK_GOOGLE_DISPLAY_TIMING_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_DISPLAY_TIMING_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_GOOGLE_display_timing\0";
pub const VK_NV_sample_mask_override_coverage: u32 = 1;
pub const VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_SPEC_VERSION: u32 = 1;
pub const VK_NV_SAMPLE_MASK_OVERRIDE_COVERAGE_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_NV_sample_mask_override_coverage\0";
pub const VK_NV_geometry_shader_passthrough: u32 = 1;
pub const VK_NV_GEOMETRY_SHADER_PASSTHROUGH_SPEC_VERSION: u32 = 1;
pub const VK_NV_GEOMETRY_SHADER_PASSTHROUGH_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_geometry_shader_passthrough\0";
pub const VK_NV_viewport_array2: u32 = 1;
pub const VK_NV_VIEWPORT_ARRAY2_SPEC_VERSION: u32 = 1;
pub const VK_NV_VIEWPORT_ARRAY2_EXTENSION_NAME: &'static [u8; 22usize] = b"VK_NV_viewport_array2\0";
pub const VK_NVX_multiview_per_view_attributes: u32 = 1;
pub const VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_SPEC_VERSION: u32 = 1;
pub const VK_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES_EXTENSION_NAME: &'static [u8; 37usize] =
    b"VK_NVX_multiview_per_view_attributes\0";
pub const VK_NV_viewport_swizzle: u32 = 1;
pub const VK_NV_VIEWPORT_SWIZZLE_SPEC_VERSION: u32 = 1;
pub const VK_NV_VIEWPORT_SWIZZLE_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_NV_viewport_swizzle\0";
pub const VK_EXT_discard_rectangles: u32 = 1;
pub const VK_EXT_DISCARD_RECTANGLES_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DISCARD_RECTANGLES_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_discard_rectangles\0";
pub const VK_EXT_conservative_rasterization: u32 = 1;
pub const VK_EXT_CONSERVATIVE_RASTERIZATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_CONSERVATIVE_RASTERIZATION_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_EXT_conservative_rasterization\0";
pub const VK_EXT_depth_clip_enable: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_ENABLE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_DEPTH_CLIP_ENABLE_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_EXT_depth_clip_enable\0";
pub const VK_EXT_swapchain_colorspace: u32 = 1;
pub const VK_EXT_SWAPCHAIN_COLOR_SPACE_SPEC_VERSION: u32 = 4;
pub const VK_EXT_SWAPCHAIN_COLOR_SPACE_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_swapchain_colorspace\0";
pub const VK_EXT_hdr_metadata: u32 = 1;
pub const VK_EXT_HDR_METADATA_SPEC_VERSION: u32 = 2;
pub const VK_EXT_HDR_METADATA_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_hdr_metadata\0";
pub const VK_EXT_external_memory_dma_buf: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_DMA_BUF_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_DMA_BUF_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_EXT_external_memory_dma_buf\0";
pub const VK_EXT_queue_family_foreign: u32 = 1;
pub const VK_EXT_QUEUE_FAMILY_FOREIGN_SPEC_VERSION: u32 = 1;
pub const VK_EXT_QUEUE_FAMILY_FOREIGN_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_queue_family_foreign\0";
pub const VK_QUEUE_FAMILY_FOREIGN_EXT: i32 = -3;
pub const VK_EXT_debug_utils: u32 = 1;
pub const VK_EXT_DEBUG_UTILS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DEBUG_UTILS_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_EXT_debug_utils\0";
pub const VK_EXT_sampler_filter_minmax: u32 = 1;
pub const VK_EXT_SAMPLER_FILTER_MINMAX_SPEC_VERSION: u32 = 2;
pub const VK_EXT_SAMPLER_FILTER_MINMAX_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_sampler_filter_minmax\0";
pub const VK_AMD_gpu_shader_int16: u32 = 1;
pub const VK_AMD_GPU_SHADER_INT16_SPEC_VERSION: u32 = 2;
pub const VK_AMD_GPU_SHADER_INT16_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_AMD_gpu_shader_int16\0";
pub const VK_AMD_mixed_attachment_samples: u32 = 1;
pub const VK_AMD_MIXED_ATTACHMENT_SAMPLES_SPEC_VERSION: u32 = 1;
pub const VK_AMD_MIXED_ATTACHMENT_SAMPLES_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_AMD_mixed_attachment_samples\0";
pub const VK_AMD_shader_fragment_mask: u32 = 1;
pub const VK_AMD_SHADER_FRAGMENT_MASK_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_FRAGMENT_MASK_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_AMD_shader_fragment_mask\0";
pub const VK_EXT_inline_uniform_block: u32 = 1;
pub const VK_EXT_INLINE_UNIFORM_BLOCK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_INLINE_UNIFORM_BLOCK_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_inline_uniform_block\0";
pub const VK_EXT_shader_stencil_export: u32 = 1;
pub const VK_EXT_SHADER_STENCIL_EXPORT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_STENCIL_EXPORT_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_shader_stencil_export\0";
pub const VK_EXT_sample_locations: u32 = 1;
pub const VK_EXT_SAMPLE_LOCATIONS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SAMPLE_LOCATIONS_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_sample_locations\0";
pub const VK_EXT_blend_operation_advanced: u32 = 1;
pub const VK_EXT_BLEND_OPERATION_ADVANCED_SPEC_VERSION: u32 = 2;
pub const VK_EXT_BLEND_OPERATION_ADVANCED_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_EXT_blend_operation_advanced\0";
pub const VK_NV_fragment_coverage_to_color: u32 = 1;
pub const VK_NV_FRAGMENT_COVERAGE_TO_COLOR_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_COVERAGE_TO_COLOR_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_NV_fragment_coverage_to_color\0";
pub const VK_NV_framebuffer_mixed_samples: u32 = 1;
pub const VK_NV_FRAMEBUFFER_MIXED_SAMPLES_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAMEBUFFER_MIXED_SAMPLES_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_NV_framebuffer_mixed_samples\0";
pub const VK_NV_fill_rectangle: u32 = 1;
pub const VK_NV_FILL_RECTANGLE_SPEC_VERSION: u32 = 1;
pub const VK_NV_FILL_RECTANGLE_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_NV_fill_rectangle\0";
pub const VK_NV_shader_sm_builtins: u32 = 1;
pub const VK_NV_SHADER_SM_BUILTINS_SPEC_VERSION: u32 = 1;
pub const VK_NV_SHADER_SM_BUILTINS_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NV_shader_sm_builtins\0";
pub const VK_EXT_post_depth_coverage: u32 = 1;
pub const VK_EXT_POST_DEPTH_COVERAGE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_POST_DEPTH_COVERAGE_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_post_depth_coverage\0";
pub const VK_EXT_image_drm_format_modifier: u32 = 1;
pub const VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_IMAGE_DRM_FORMAT_MODIFIER_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_EXT_image_drm_format_modifier\0";
pub const VK_EXT_validation_cache: u32 = 1;
pub const VK_EXT_VALIDATION_CACHE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_VALIDATION_CACHE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_validation_cache\0";
pub const VK_EXT_descriptor_indexing: u32 = 1;
pub const VK_EXT_DESCRIPTOR_INDEXING_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DESCRIPTOR_INDEXING_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_descriptor_indexing\0";
pub const VK_EXT_shader_viewport_index_layer: u32 = 1;
pub const VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_VIEWPORT_INDEX_LAYER_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_EXT_shader_viewport_index_layer\0";
pub const VK_NV_shading_rate_image: u32 = 1;
pub const VK_NV_SHADING_RATE_IMAGE_SPEC_VERSION: u32 = 3;
pub const VK_NV_SHADING_RATE_IMAGE_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NV_shading_rate_image\0";
pub const VK_NV_ray_tracing: u32 = 1;
pub const VK_NV_RAY_TRACING_SPEC_VERSION: u32 = 3;
pub const VK_NV_RAY_TRACING_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_NV_ray_tracing\0";
pub const VK_SHADER_UNUSED_KHR: i32 = -1;
pub const VK_SHADER_UNUSED_NV: i32 = -1;
pub const VK_NV_representative_fragment_test: u32 = 1;
pub const VK_NV_REPRESENTATIVE_FRAGMENT_TEST_SPEC_VERSION: u32 = 2;
pub const VK_NV_REPRESENTATIVE_FRAGMENT_TEST_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_NV_representative_fragment_test\0";
pub const VK_EXT_filter_cubic: u32 = 1;
pub const VK_EXT_FILTER_CUBIC_SPEC_VERSION: u32 = 3;
pub const VK_EXT_FILTER_CUBIC_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_filter_cubic\0";
pub const VK_QCOM_render_pass_shader_resolve: u32 = 1;
pub const VK_QCOM_RENDER_PASS_SHADER_RESOLVE_SPEC_VERSION: u32 = 4;
pub const VK_QCOM_RENDER_PASS_SHADER_RESOLVE_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_QCOM_render_pass_shader_resolve\0";
pub const VK_EXT_global_priority: u32 = 1;
pub const VK_EXT_GLOBAL_PRIORITY_SPEC_VERSION: u32 = 2;
pub const VK_EXT_GLOBAL_PRIORITY_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_EXT_global_priority\0";
pub const VK_EXT_external_memory_host: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_HOST_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTERNAL_MEMORY_HOST_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_external_memory_host\0";
pub const VK_AMD_buffer_marker: u32 = 1;
pub const VK_AMD_BUFFER_MARKER_SPEC_VERSION: u32 = 1;
pub const VK_AMD_BUFFER_MARKER_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_AMD_buffer_marker\0";
pub const VK_AMD_pipeline_compiler_control: u32 = 1;
pub const VK_AMD_PIPELINE_COMPILER_CONTROL_SPEC_VERSION: u32 = 1;
pub const VK_AMD_PIPELINE_COMPILER_CONTROL_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_AMD_pipeline_compiler_control\0";
pub const VK_EXT_calibrated_timestamps: u32 = 1;
pub const VK_EXT_CALIBRATED_TIMESTAMPS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_CALIBRATED_TIMESTAMPS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_calibrated_timestamps\0";
pub const VK_AMD_shader_core_properties: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_SPEC_VERSION: u32 = 2;
pub const VK_AMD_SHADER_CORE_PROPERTIES_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_AMD_shader_core_properties\0";
pub const VK_AMD_memory_overallocation_behavior: u32 = 1;
pub const VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_SPEC_VERSION: u32 = 1;
pub const VK_AMD_MEMORY_OVERALLOCATION_BEHAVIOR_EXTENSION_NAME: &'static [u8; 38usize] =
    b"VK_AMD_memory_overallocation_behavior\0";
pub const VK_EXT_vertex_attribute_divisor: u32 = 1;
pub const VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_SPEC_VERSION: u32 = 3;
pub const VK_EXT_VERTEX_ATTRIBUTE_DIVISOR_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_EXT_vertex_attribute_divisor\0";
pub const VK_EXT_pipeline_creation_feedback: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_FEEDBACK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_FEEDBACK_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_EXT_pipeline_creation_feedback\0";
pub const VK_NV_shader_subgroup_partitioned: u32 = 1;
pub const VK_NV_SHADER_SUBGROUP_PARTITIONED_SPEC_VERSION: u32 = 1;
pub const VK_NV_SHADER_SUBGROUP_PARTITIONED_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_shader_subgroup_partitioned\0";
pub const VK_NV_compute_shader_derivatives: u32 = 1;
pub const VK_NV_COMPUTE_SHADER_DERIVATIVES_SPEC_VERSION: u32 = 1;
pub const VK_NV_COMPUTE_SHADER_DERIVATIVES_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_NV_compute_shader_derivatives\0";
pub const VK_NV_mesh_shader: u32 = 1;
pub const VK_NV_MESH_SHADER_SPEC_VERSION: u32 = 1;
pub const VK_NV_MESH_SHADER_EXTENSION_NAME: &'static [u8; 18usize] = b"VK_NV_mesh_shader\0";
pub const VK_NV_fragment_shader_barycentric: u32 = 1;
pub const VK_NV_FRAGMENT_SHADER_BARYCENTRIC_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_SHADER_BARYCENTRIC_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_fragment_shader_barycentric\0";
pub const VK_NV_shader_image_footprint: u32 = 1;
pub const VK_NV_SHADER_IMAGE_FOOTPRINT_SPEC_VERSION: u32 = 2;
pub const VK_NV_SHADER_IMAGE_FOOTPRINT_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_NV_shader_image_footprint\0";
pub const VK_NV_scissor_exclusive: u32 = 1;
pub const VK_NV_SCISSOR_EXCLUSIVE_SPEC_VERSION: u32 = 1;
pub const VK_NV_SCISSOR_EXCLUSIVE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_NV_scissor_exclusive\0";
pub const VK_NV_device_diagnostic_checkpoints: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_SPEC_VERSION: u32 = 2;
pub const VK_NV_DEVICE_DIAGNOSTIC_CHECKPOINTS_EXTENSION_NAME: &'static [u8; 36usize] =
    b"VK_NV_device_diagnostic_checkpoints\0";
pub const VK_INTEL_shader_integer_functions2: u32 = 1;
pub const VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_SPEC_VERSION: u32 = 1;
pub const VK_INTEL_SHADER_INTEGER_FUNCTIONS_2_EXTENSION_NAME: &'static [u8; 35usize] =
    b"VK_INTEL_shader_integer_functions2\0";
pub const VK_INTEL_performance_query: u32 = 1;
pub const VK_INTEL_PERFORMANCE_QUERY_SPEC_VERSION: u32 = 2;
pub const VK_INTEL_PERFORMANCE_QUERY_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_INTEL_performance_query\0";
pub const VK_EXT_pci_bus_info: u32 = 1;
pub const VK_EXT_PCI_BUS_INFO_SPEC_VERSION: u32 = 2;
pub const VK_EXT_PCI_BUS_INFO_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_pci_bus_info\0";
pub const VK_AMD_display_native_hdr: u32 = 1;
pub const VK_AMD_DISPLAY_NATIVE_HDR_SPEC_VERSION: u32 = 1;
pub const VK_AMD_DISPLAY_NATIVE_HDR_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_AMD_display_native_hdr\0";
pub const VK_EXT_fragment_density_map: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_fragment_density_map\0";
pub const VK_EXT_scalar_block_layout: u32 = 1;
pub const VK_EXT_SCALAR_BLOCK_LAYOUT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SCALAR_BLOCK_LAYOUT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_scalar_block_layout\0";
pub const VK_GOOGLE_hlsl_functionality1: u32 = 1;
pub const VK_GOOGLE_HLSL_FUNCTIONALITY1_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_HLSL_FUNCTIONALITY1_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_GOOGLE_hlsl_functionality1\0";
pub const VK_GOOGLE_decorate_string: u32 = 1;
pub const VK_GOOGLE_DECORATE_STRING_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_DECORATE_STRING_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_GOOGLE_decorate_string\0";
pub const VK_EXT_subgroup_size_control: u32 = 1;
pub const VK_EXT_SUBGROUP_SIZE_CONTROL_SPEC_VERSION: u32 = 2;
pub const VK_EXT_SUBGROUP_SIZE_CONTROL_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_subgroup_size_control\0";
pub const VK_AMD_shader_core_properties2: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_2_SPEC_VERSION: u32 = 1;
pub const VK_AMD_SHADER_CORE_PROPERTIES_2_EXTENSION_NAME: &'static [u8; 31usize] =
    b"VK_AMD_shader_core_properties2\0";
pub const VK_AMD_device_coherent_memory: u32 = 1;
pub const VK_AMD_DEVICE_COHERENT_MEMORY_SPEC_VERSION: u32 = 1;
pub const VK_AMD_DEVICE_COHERENT_MEMORY_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_AMD_device_coherent_memory\0";
pub const VK_EXT_shader_image_atomic_int64: u32 = 1;
pub const VK_EXT_SHADER_IMAGE_ATOMIC_INT64_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_IMAGE_ATOMIC_INT64_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_EXT_shader_image_atomic_int64\0";
pub const VK_EXT_memory_budget: u32 = 1;
pub const VK_EXT_MEMORY_BUDGET_SPEC_VERSION: u32 = 1;
pub const VK_EXT_MEMORY_BUDGET_EXTENSION_NAME: &'static [u8; 21usize] = b"VK_EXT_memory_budget\0";
pub const VK_EXT_memory_priority: u32 = 1;
pub const VK_EXT_MEMORY_PRIORITY_SPEC_VERSION: u32 = 1;
pub const VK_EXT_MEMORY_PRIORITY_EXTENSION_NAME: &'static [u8; 23usize] =
    b"VK_EXT_memory_priority\0";
pub const VK_NV_dedicated_allocation_image_aliasing: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEDICATED_ALLOCATION_IMAGE_ALIASING_EXTENSION_NAME: &'static [u8; 42usize] =
    b"VK_NV_dedicated_allocation_image_aliasing\0";
pub const VK_EXT_buffer_device_address: u32 = 1;
pub const VK_EXT_BUFFER_DEVICE_ADDRESS_SPEC_VERSION: u32 = 2;
pub const VK_EXT_BUFFER_DEVICE_ADDRESS_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_buffer_device_address\0";
pub const VK_EXT_tooling_info: u32 = 1;
pub const VK_EXT_TOOLING_INFO_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TOOLING_INFO_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_tooling_info\0";
pub const VK_EXT_separate_stencil_usage: u32 = 1;
pub const VK_EXT_SEPARATE_STENCIL_USAGE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SEPARATE_STENCIL_USAGE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_separate_stencil_usage\0";
pub const VK_EXT_validation_features: u32 = 1;
pub const VK_EXT_VALIDATION_FEATURES_SPEC_VERSION: u32 = 4;
pub const VK_EXT_VALIDATION_FEATURES_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_validation_features\0";
pub const VK_NV_cooperative_matrix: u32 = 1;
pub const VK_NV_COOPERATIVE_MATRIX_SPEC_VERSION: u32 = 1;
pub const VK_NV_COOPERATIVE_MATRIX_EXTENSION_NAME: &'static [u8; 25usize] =
    b"VK_NV_cooperative_matrix\0";
pub const VK_NV_coverage_reduction_mode: u32 = 1;
pub const VK_NV_COVERAGE_REDUCTION_MODE_SPEC_VERSION: u32 = 1;
pub const VK_NV_COVERAGE_REDUCTION_MODE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_NV_coverage_reduction_mode\0";
pub const VK_EXT_fragment_shader_interlock: u32 = 1;
pub const VK_EXT_FRAGMENT_SHADER_INTERLOCK_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_SHADER_INTERLOCK_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_EXT_fragment_shader_interlock\0";
pub const VK_EXT_ycbcr_image_arrays: u32 = 1;
pub const VK_EXT_YCBCR_IMAGE_ARRAYS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_YCBCR_IMAGE_ARRAYS_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_ycbcr_image_arrays\0";
pub const VK_EXT_headless_surface: u32 = 1;
pub const VK_EXT_HEADLESS_SURFACE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_HEADLESS_SURFACE_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_headless_surface\0";
pub const VK_EXT_line_rasterization: u32 = 1;
pub const VK_EXT_LINE_RASTERIZATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_LINE_RASTERIZATION_EXTENSION_NAME: &'static [u8; 26usize] =
    b"VK_EXT_line_rasterization\0";
pub const VK_EXT_shader_atomic_float: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_ATOMIC_FLOAT_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_shader_atomic_float\0";
pub const VK_EXT_host_query_reset: u32 = 1;
pub const VK_EXT_HOST_QUERY_RESET_SPEC_VERSION: u32 = 1;
pub const VK_EXT_HOST_QUERY_RESET_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_host_query_reset\0";
pub const VK_EXT_index_type_uint8: u32 = 1;
pub const VK_EXT_INDEX_TYPE_UINT8_SPEC_VERSION: u32 = 1;
pub const VK_EXT_INDEX_TYPE_UINT8_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_index_type_uint8\0";
pub const VK_EXT_extended_dynamic_state: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_SPEC_VERSION: u32 = 1;
pub const VK_EXT_EXTENDED_DYNAMIC_STATE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_extended_dynamic_state\0";
pub const VK_EXT_shader_demote_to_helper_invocation: u32 = 1;
pub const VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_SPEC_VERSION: u32 = 1;
pub const VK_EXT_SHADER_DEMOTE_TO_HELPER_INVOCATION_EXTENSION_NAME: &'static [u8; 42usize] =
    b"VK_EXT_shader_demote_to_helper_invocation\0";
pub const VK_NV_device_generated_commands: u32 = 1;
pub const VK_NV_DEVICE_GENERATED_COMMANDS_SPEC_VERSION: u32 = 3;
pub const VK_NV_DEVICE_GENERATED_COMMANDS_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_NV_device_generated_commands\0";
pub const VK_EXT_texel_buffer_alignment: u32 = 1;
pub const VK_EXT_TEXEL_BUFFER_ALIGNMENT_SPEC_VERSION: u32 = 1;
pub const VK_EXT_TEXEL_BUFFER_ALIGNMENT_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_EXT_texel_buffer_alignment\0";
pub const VK_QCOM_render_pass_transform: u32 = 1;
pub const VK_QCOM_RENDER_PASS_TRANSFORM_SPEC_VERSION: u32 = 1;
pub const VK_QCOM_RENDER_PASS_TRANSFORM_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_QCOM_render_pass_transform\0";
pub const VK_EXT_device_memory_report: u32 = 1;
pub const VK_EXT_DEVICE_MEMORY_REPORT_SPEC_VERSION: u32 = 2;
pub const VK_EXT_DEVICE_MEMORY_REPORT_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_EXT_device_memory_report\0";
pub const VK_EXT_robustness2: u32 = 1;
pub const VK_EXT_ROBUSTNESS_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_ROBUSTNESS_2_EXTENSION_NAME: &'static [u8; 19usize] = b"VK_EXT_robustness2\0";
pub const VK_EXT_custom_border_color: u32 = 1;
pub const VK_EXT_CUSTOM_BORDER_COLOR_SPEC_VERSION: u32 = 12;
pub const VK_EXT_CUSTOM_BORDER_COLOR_EXTENSION_NAME: &'static [u8; 27usize] =
    b"VK_EXT_custom_border_color\0";
pub const VK_GOOGLE_user_type: u32 = 1;
pub const VK_GOOGLE_USER_TYPE_SPEC_VERSION: u32 = 1;
pub const VK_GOOGLE_USER_TYPE_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_GOOGLE_user_type\0";
pub const VK_EXT_private_data: u32 = 1;
pub const VK_EXT_PRIVATE_DATA_SPEC_VERSION: u32 = 1;
pub const VK_EXT_PRIVATE_DATA_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_private_data\0";
pub const VK_EXT_pipeline_creation_cache_control: u32 = 1;
pub const VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_SPEC_VERSION: u32 = 3;
pub const VK_EXT_PIPELINE_CREATION_CACHE_CONTROL_EXTENSION_NAME: &'static [u8; 39usize] =
    b"VK_EXT_pipeline_creation_cache_control\0";
pub const VK_NV_device_diagnostics_config: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTICS_CONFIG_SPEC_VERSION: u32 = 1;
pub const VK_NV_DEVICE_DIAGNOSTICS_CONFIG_EXTENSION_NAME: &'static [u8; 32usize] =
    b"VK_NV_device_diagnostics_config\0";
pub const VK_QCOM_render_pass_store_ops: u32 = 1;
pub const VK_QCOM_render_pass_store_ops_SPEC_VERSION: u32 = 2;
pub const VK_QCOM_render_pass_store_ops_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_QCOM_render_pass_store_ops\0";
pub const VK_NV_fragment_shading_rate_enums: u32 = 1;
pub const VK_NV_FRAGMENT_SHADING_RATE_ENUMS_SPEC_VERSION: u32 = 1;
pub const VK_NV_FRAGMENT_SHADING_RATE_ENUMS_EXTENSION_NAME: &'static [u8; 34usize] =
    b"VK_NV_fragment_shading_rate_enums\0";
pub const VK_EXT_fragment_density_map2: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_2_SPEC_VERSION: u32 = 1;
pub const VK_EXT_FRAGMENT_DENSITY_MAP_2_EXTENSION_NAME: &'static [u8; 29usize] =
    b"VK_EXT_fragment_density_map2\0";
pub const VK_QCOM_rotated_copy_commands: u32 = 1;
pub const VK_QCOM_ROTATED_COPY_COMMANDS_SPEC_VERSION: u32 = 0;
pub const VK_QCOM_ROTATED_COPY_COMMANDS_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_QCOM_rotated_copy_commands\0";
pub const VK_EXT_image_robustness: u32 = 1;
pub const VK_EXT_IMAGE_ROBUSTNESS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_IMAGE_ROBUSTNESS_EXTENSION_NAME: &'static [u8; 24usize] =
    b"VK_EXT_image_robustness\0";
pub const VK_EXT_4444_formats: u32 = 1;
pub const VK_EXT_4444_FORMATS_SPEC_VERSION: u32 = 1;
pub const VK_EXT_4444_FORMATS_EXTENSION_NAME: &'static [u8; 20usize] = b"VK_EXT_4444_formats\0";
pub const VK_NV_acquire_winrt_display: u32 = 1;
pub const VK_NV_ACQUIRE_WINRT_DISPLAY_SPEC_VERSION: u32 = 1;
pub const VK_NV_ACQUIRE_WINRT_DISPLAY_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_NV_acquire_winrt_display\0";
pub const VK_VALVE_mutable_descriptor_type: u32 = 1;
pub const VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_SPEC_VERSION: u32 = 1;
pub const VK_VALVE_MUTABLE_DESCRIPTOR_TYPE_EXTENSION_NAME: &'static [u8; 33usize] =
    b"VK_VALVE_mutable_descriptor_type\0";
pub const VK_KHR_acceleration_structure: u32 = 1;
pub const VK_KHR_ACCELERATION_STRUCTURE_SPEC_VERSION: u32 = 11;
pub const VK_KHR_ACCELERATION_STRUCTURE_EXTENSION_NAME: &'static [u8; 30usize] =
    b"VK_KHR_acceleration_structure\0";
pub const VK_KHR_ray_tracing_pipeline: u32 = 1;
pub const VK_KHR_RAY_TRACING_PIPELINE_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RAY_TRACING_PIPELINE_EXTENSION_NAME: &'static [u8; 28usize] =
    b"VK_KHR_ray_tracing_pipeline\0";
pub const VK_KHR_ray_query: u32 = 1;
pub const VK_KHR_RAY_QUERY_SPEC_VERSION: u32 = 1;
pub const VK_KHR_RAY_QUERY_EXTENSION_NAME: &'static [u8; 17usize] = b"VK_KHR_ray_query\0";
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
#[test]
fn bindgen_test_layout_max_align_t() {
    assert_eq!(
        ::std::mem::size_of::<max_align_t>(),
        32usize,
        concat!("Size of: ", stringify!(max_align_t))
    );
    assert_eq!(
        ::std::mem::align_of::<max_align_t>(),
        16usize,
        concat!("Alignment of ", stringify!(max_align_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce1 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<max_align_t>())).__clang_max_align_nonce2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(max_align_t),
            "::",
            stringify!(__clang_max_align_nonce2)
        )
    );
}
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type VkBool32 = u32;
pub type VkDeviceAddress = u64;
pub type VkDeviceSize = u64;
pub type VkFlags = u32;
pub type VkSampleMask = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBuffer_T {
    _unused: [u8; 0],
}
pub type VkBuffer = *mut VkBuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImage_T {
    _unused: [u8; 0],
}
pub type VkImage = *mut VkImage_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInstance_T {
    _unused: [u8; 0],
}
pub type VkInstance = *mut VkInstance_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice_T {
    _unused: [u8; 0],
}
pub type VkPhysicalDevice = *mut VkPhysicalDevice_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDevice_T {
    _unused: [u8; 0],
}
pub type VkDevice = *mut VkDevice_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueue_T {
    _unused: [u8; 0],
}
pub type VkQueue = *mut VkQueue_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphore_T {
    _unused: [u8; 0],
}
pub type VkSemaphore = *mut VkSemaphore_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBuffer_T {
    _unused: [u8; 0],
}
pub type VkCommandBuffer = *mut VkCommandBuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFence_T {
    _unused: [u8; 0],
}
pub type VkFence = *mut VkFence_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceMemory_T {
    _unused: [u8; 0],
}
pub type VkDeviceMemory = *mut VkDeviceMemory_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkEvent_T {
    _unused: [u8; 0],
}
pub type VkEvent = *mut VkEvent_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPool_T {
    _unused: [u8; 0],
}
pub type VkQueryPool = *mut VkQueryPool_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferView_T {
    _unused: [u8; 0],
}
pub type VkBufferView = *mut VkBufferView_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageView_T {
    _unused: [u8; 0],
}
pub type VkImageView = *mut VkImageView_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModule_T {
    _unused: [u8; 0],
}
pub type VkShaderModule = *mut VkShaderModule_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCache_T {
    _unused: [u8; 0],
}
pub type VkPipelineCache = *mut VkPipelineCache_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLayout_T {
    _unused: [u8; 0],
}
pub type VkPipelineLayout = *mut VkPipelineLayout_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipeline_T {
    _unused: [u8; 0],
}
pub type VkPipeline = *mut VkPipeline_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPass_T {
    _unused: [u8; 0],
}
pub type VkRenderPass = *mut VkRenderPass_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayout_T {
    _unused: [u8; 0],
}
pub type VkDescriptorSetLayout = *mut VkDescriptorSetLayout_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSampler_T {
    _unused: [u8; 0],
}
pub type VkSampler = *mut VkSampler_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSet_T {
    _unused: [u8; 0],
}
pub type VkDescriptorSet = *mut VkDescriptorSet_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPool_T {
    _unused: [u8; 0],
}
pub type VkDescriptorPool = *mut VkDescriptorPool_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebuffer_T {
    _unused: [u8; 0],
}
pub type VkFramebuffer = *mut VkFramebuffer_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandPool_T {
    _unused: [u8; 0],
}
pub type VkCommandPool = *mut VkCommandPool_T;
pub const VkResult_VK_SUCCESS: VkResult = 0;
pub const VkResult_VK_NOT_READY: VkResult = 1;
pub const VkResult_VK_TIMEOUT: VkResult = 2;
pub const VkResult_VK_EVENT_SET: VkResult = 3;
pub const VkResult_VK_EVENT_RESET: VkResult = 4;
pub const VkResult_VK_INCOMPLETE: VkResult = 5;
pub const VkResult_VK_ERROR_OUT_OF_HOST_MEMORY: VkResult = -1;
pub const VkResult_VK_ERROR_OUT_OF_DEVICE_MEMORY: VkResult = -2;
pub const VkResult_VK_ERROR_INITIALIZATION_FAILED: VkResult = -3;
pub const VkResult_VK_ERROR_DEVICE_LOST: VkResult = -4;
pub const VkResult_VK_ERROR_MEMORY_MAP_FAILED: VkResult = -5;
pub const VkResult_VK_ERROR_LAYER_NOT_PRESENT: VkResult = -6;
pub const VkResult_VK_ERROR_EXTENSION_NOT_PRESENT: VkResult = -7;
pub const VkResult_VK_ERROR_FEATURE_NOT_PRESENT: VkResult = -8;
pub const VkResult_VK_ERROR_INCOMPATIBLE_DRIVER: VkResult = -9;
pub const VkResult_VK_ERROR_TOO_MANY_OBJECTS: VkResult = -10;
pub const VkResult_VK_ERROR_FORMAT_NOT_SUPPORTED: VkResult = -11;
pub const VkResult_VK_ERROR_FRAGMENTED_POOL: VkResult = -12;
pub const VkResult_VK_ERROR_UNKNOWN: VkResult = -13;
pub const VkResult_VK_ERROR_OUT_OF_POOL_MEMORY: VkResult = -1000069000;
pub const VkResult_VK_ERROR_INVALID_EXTERNAL_HANDLE: VkResult = -1000072003;
pub const VkResult_VK_ERROR_FRAGMENTATION: VkResult = -1000161000;
pub const VkResult_VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS: VkResult = -1000257000;
pub const VkResult_VK_ERROR_SURFACE_LOST_KHR: VkResult = -1000000000;
pub const VkResult_VK_ERROR_NATIVE_WINDOW_IN_USE_KHR: VkResult = -1000000001;
pub const VkResult_VK_SUBOPTIMAL_KHR: VkResult = 1000001003;
pub const VkResult_VK_ERROR_OUT_OF_DATE_KHR: VkResult = -1000001004;
pub const VkResult_VK_ERROR_INCOMPATIBLE_DISPLAY_KHR: VkResult = -1000003001;
pub const VkResult_VK_ERROR_VALIDATION_FAILED_EXT: VkResult = -1000011001;
pub const VkResult_VK_ERROR_INVALID_SHADER_NV: VkResult = -1000012000;
pub const VkResult_VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT: VkResult = -1000158000;
pub const VkResult_VK_ERROR_NOT_PERMITTED_EXT: VkResult = -1000174001;
pub const VkResult_VK_ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT: VkResult = -1000255000;
pub const VkResult_VK_THREAD_IDLE_KHR: VkResult = 1000268000;
pub const VkResult_VK_THREAD_DONE_KHR: VkResult = 1000268001;
pub const VkResult_VK_OPERATION_DEFERRED_KHR: VkResult = 1000268002;
pub const VkResult_VK_OPERATION_NOT_DEFERRED_KHR: VkResult = 1000268003;
pub const VkResult_VK_PIPELINE_COMPILE_REQUIRED_EXT: VkResult = 1000297000;
pub const VkResult_VK_ERROR_OUT_OF_POOL_MEMORY_KHR: VkResult = -1000069000;
pub const VkResult_VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR: VkResult = -1000072003;
pub const VkResult_VK_ERROR_FRAGMENTATION_EXT: VkResult = -1000161000;
pub const VkResult_VK_ERROR_INVALID_DEVICE_ADDRESS_EXT: VkResult = -1000257000;
pub const VkResult_VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS_KHR: VkResult = -1000257000;
pub const VkResult_VK_ERROR_PIPELINE_COMPILE_REQUIRED_EXT: VkResult = 1000297000;
pub const VkResult_VK_RESULT_MAX_ENUM: VkResult = 2147483647;
pub type VkResult = ::std::os::raw::c_int;
pub const VkStructureType_VK_STRUCTURE_TYPE_APPLICATION_INFO: VkStructureType = 0;
pub const VkStructureType_VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO: VkStructureType = 1;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO: VkStructureType = 2;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO: VkStructureType = 3;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBMIT_INFO: VkStructureType = 4;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO: VkStructureType = 5;
pub const VkStructureType_VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE: VkStructureType = 6;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_SPARSE_INFO: VkStructureType = 7;
pub const VkStructureType_VK_STRUCTURE_TYPE_FENCE_CREATE_INFO: VkStructureType = 8;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO: VkStructureType = 9;
pub const VkStructureType_VK_STRUCTURE_TYPE_EVENT_CREATE_INFO: VkStructureType = 10;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO: VkStructureType = 11;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO: VkStructureType = 12;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO: VkStructureType = 13;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO: VkStructureType = 14;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO: VkStructureType = 15;
pub const VkStructureType_VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: VkStructureType = 16;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO: VkStructureType = 17;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO: VkStructureType = 18;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO:
    VkStructureType = 19;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO:
    VkStructureType = 20;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO:
    VkStructureType = 21;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO: VkStructureType =
    22;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO:
    VkStructureType = 23;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO:
    VkStructureType = 24;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO:
    VkStructureType = 25;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO:
    VkStructureType = 26;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO: VkStructureType =
    27;
pub const VkStructureType_VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO: VkStructureType = 28;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO: VkStructureType = 29;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO: VkStructureType = 30;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO: VkStructureType = 31;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO: VkStructureType = 32;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO: VkStructureType = 33;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO: VkStructureType = 34;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET: VkStructureType = 35;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET: VkStructureType = 36;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO: VkStructureType = 37;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO: VkStructureType = 38;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO: VkStructureType = 39;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO: VkStructureType = 40;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO: VkStructureType = 41;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO: VkStructureType = 42;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO: VkStructureType = 43;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER: VkStructureType = 44;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER: VkStructureType = 45;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_BARRIER: VkStructureType = 46;
pub const VkStructureType_VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO: VkStructureType = 47;
pub const VkStructureType_VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO: VkStructureType = 48;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: VkStructureType =
    1000094000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO: VkStructureType = 1000157000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO: VkStructureType = 1000157001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
    VkStructureType = 1000083000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: VkStructureType =
    1000127000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: VkStructureType =
    1000127001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: VkStructureType =
    1000060000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: VkStructureType =
    1000060003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
    VkStructureType = 1000060004;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: VkStructureType = 1000060005;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: VkStructureType =
    1000060006;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: VkStructureType =
    1000060013;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: VkStructureType =
    1000060014;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES: VkStructureType =
    1000070000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: VkStructureType =
    1000070001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2: VkStructureType =
    1000146000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2: VkStructureType =
    1000146001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2:
    VkStructureType = 1000146002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2: VkStructureType = 1000146003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2: VkStructureType =
    1000146004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: VkStructureType =
    1000059000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2: VkStructureType =
    1000059001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2: VkStructureType = 1000059002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2: VkStructureType = 1000059003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2: VkStructureType =
    1000059004;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2: VkStructureType = 1000059005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2: VkStructureType =
    1000059006;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2: VkStructureType =
    1000059007;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2:
    VkStructureType = 1000059008;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
    VkStructureType = 1000117000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO:
    VkStructureType = 1000117001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: VkStructureType =
    1000117002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO : VkStructureType = 1000117003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: VkStructureType =
    1000053000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: VkStructureType =
    1000053001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: VkStructureType =
    1000053002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: VkStructureType = 1000145000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
    VkStructureType = 1000145001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
    VkStructureType = 1000145002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2: VkStructureType = 1000145003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO: VkStructureType =
    1000156000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: VkStructureType =
    1000156001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: VkStructureType =
    1000156002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: VkStructureType =
    1000156003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
    VkStructureType = 1000156004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
    VkStructureType = 1000156005;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO:
    VkStructureType = 1000085000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
    VkStructureType = 1000071000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: VkStructureType =
    1000071001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO: VkStructureType =
    1000071002;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES: VkStructureType =
    1000071003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: VkStructureType =
    1000071004;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: VkStructureType =
    1000072000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: VkStructureType =
    1000072001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: VkStructureType =
    1000072002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO: VkStructureType =
    1000112000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES: VkStructureType = 1000112001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: VkStructureType = 1000113000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: VkStructureType =
    1000077000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO:
    VkStructureType = 1000076000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES: VkStructureType =
    1000076001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
    VkStructureType = 1000168000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT: VkStructureType =
    1000168001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
    VkStructureType = 1000063000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: VkStructureType =
    49;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: VkStructureType =
    50;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: VkStructureType =
    51;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: VkStructureType =
    52;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: VkStructureType =
    1000147000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2: VkStructureType = 1000109000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2: VkStructureType = 1000109001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2: VkStructureType = 1000109002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2: VkStructureType = 1000109003;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2: VkStructureType = 1000109004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO: VkStructureType = 1000109005;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_END_INFO: VkStructureType = 1000109006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: VkStructureType =
    1000177000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: VkStructureType =
    1000196000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
    VkStructureType = 1000180000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
    VkStructureType = 1000082000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
    VkStructureType = 1000197000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO:
    VkStructureType = 1000161000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
    VkStructureType = 1000161001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
    VkStructureType = 1000161002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO : VkStructureType = 1000161003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT : VkStructureType = 1000161004 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
    VkStructureType = 1000199000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE:
    VkStructureType = 1000199001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
    VkStructureType = 1000221000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: VkStructureType =
    1000246000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
    VkStructureType = 1000130000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: VkStructureType =
    1000130001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
    VkStructureType = 1000211000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
    VkStructureType = 1000108000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: VkStructureType =
    1000108001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO: VkStructureType =
    1000108002;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: VkStructureType =
    1000108003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES : VkStructureType = 1000253000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES : VkStructureType = 1000175000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES : VkStructureType = 1000241000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: VkStructureType =
    1000241001;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: VkStructureType =
    1000241002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
    VkStructureType = 1000261000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
    VkStructureType = 1000207000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
    VkStructureType = 1000207001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: VkStructureType =
    1000207002;
pub const VkStructureType_VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: VkStructureType =
    1000207003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO: VkStructureType = 1000207004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO: VkStructureType = 1000207005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
    VkStructureType = 1000257000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO: VkStructureType =
    1000244001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO:
    VkStructureType = 1000257002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO:
    VkStructureType = 1000257003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO:
    VkStructureType = 1000257004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR: VkStructureType = 1000001000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_INFO_KHR: VkStructureType = 1000001001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR: VkStructureType =
    1000060007;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR: VkStructureType =
    1000060008;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: VkStructureType =
    1000060009;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR: VkStructureType =
    1000060010;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: VkStructureType =
    1000060011;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR:
    VkStructureType = 1000060012;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR: VkStructureType =
    1000002000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000002001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: VkStructureType = 1000003000;
pub const VkStructureType_VK_STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000004000;
pub const VkStructureType_VK_STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000005000;
pub const VkStructureType_VK_STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000006000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000008000;
pub const VkStructureType_VK_STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR: VkStructureType =
    1000009000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: VkStructureType =
    1000011000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD:
    VkStructureType = 1000018000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT: VkStructureType =
    1000022000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT: VkStructureType =
    1000022001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT: VkStructureType =
    1000022002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV:
    VkStructureType = 1000026000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV:
    VkStructureType = 1000026001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV:
    VkStructureType = 1000026002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
    VkStructureType = 1000028000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
    VkStructureType = 1000028001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
    VkStructureType = 1000028002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX: VkStructureType =
    1000030000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX: VkStructureType =
    1000030001;
pub const VkStructureType_VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD:
    VkStructureType = 1000041000;
pub const VkStructureType_VK_STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP:
    VkStructureType = 1000049000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV:
    VkStructureType = 1000050000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: VkStructureType =
    1000056000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: VkStructureType =
    1000056001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV: VkStructureType =
    1000057000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV: VkStructureType =
    1000057001;
pub const VkStructureType_VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV:
    VkStructureType = 1000058000;
pub const VkStructureType_VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: VkStructureType = 1000061000;
pub const VkStructureType_VK_STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN: VkStructureType = 1000062000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT : VkStructureType = 1000066000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: VkStructureType =
    1000067000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT:
    VkStructureType = 1000067001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR: VkStructureType =
    1000073002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000073003;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: VkStructureType = 1000074000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR: VkStructureType = 1000074001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR: VkStructureType = 1000074002;
pub const VkStructureType_VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR:
    VkStructureType = 1000075000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
    VkStructureType = 1000078000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR:
    VkStructureType = 1000078001;
pub const VkStructureType_VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR: VkStructureType =
    1000078002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000078003;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR: VkStructureType =
    1000079000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR: VkStructureType = 1000079001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
    VkStructureType = 1000080000;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT : VkStructureType = 1000081000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
    VkStructureType = 1000081001;
pub const VkStructureType_VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT: VkStructureType =
    1000081002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: VkStructureType = 1000084000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV:
    VkStructureType = 1000087000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT: VkStructureType =
    1000090000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT: VkStructureType = 1000091000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT: VkStructureType = 1000091001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT: VkStructureType = 1000091002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: VkStructureType =
    1000091003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: VkStructureType = 1000092000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX : VkStructureType = 1000097000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV:
    VkStructureType = 1000098000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT:
    VkStructureType = 1000099000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000099001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT : VkStructureType = 1000101000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT : VkStructureType = 1000101001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
    VkStructureType = 1000102000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT : VkStructureType = 1000102001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_HDR_METADATA_EXT: VkStructureType = 1000105000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR:
    VkStructureType = 1000111000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR: VkStructureType =
    1000114002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR: VkStructureType = 1000115000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR: VkStructureType = 1000115001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR:
    VkStructureType = 1000116000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR:
    VkStructureType = 1000116001;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR:
    VkStructureType = 1000116002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR: VkStructureType =
    1000116003;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR: VkStructureType =
    1000116004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR: VkStructureType = 1000116005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR: VkStructureType =
    1000116006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR: VkStructureType =
    1000119000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR: VkStructureType =
    1000119001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR: VkStructureType = 1000119002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR: VkStructureType = 1000121000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR: VkStructureType =
    1000121001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR: VkStructureType =
    1000121002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR: VkStructureType = 1000121003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR: VkStructureType =
    1000121004;
pub const VkStructureType_VK_STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK: VkStructureType =
    1000122000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK: VkStructureType =
    1000123000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: VkStructureType =
    1000128000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT: VkStructureType =
    1000128001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT: VkStructureType = 1000128002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT:
    VkStructureType = 1000128003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: VkStructureType =
    1000128004;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID: VkStructureType =
    1000129000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID:
    VkStructureType = 1000129001;
pub const VkStructureType_VK_STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID:
    VkStructureType = 1000129002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
    VkStructureType = 1000129003;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID:
    VkStructureType = 1000129004;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID: VkStructureType = 1000129005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT:
    VkStructureType = 1000138000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT:
    VkStructureType = 1000138001;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT:
    VkStructureType = 1000138002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT:
    VkStructureType = 1000138003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: VkStructureType = 1000143000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT:
    VkStructureType = 1000143001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000143002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT:
    VkStructureType = 1000143003;
pub const VkStructureType_VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT: VkStructureType =
    1000143004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT : VkStructureType = 1000148000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT : VkStructureType = 1000148001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000148002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV:
    VkStructureType = 1000149000;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR:
    VkStructureType = 1000150007;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR:
    VkStructureType = 1000150000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR:
    VkStructureType = 1000150002;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR:
    VkStructureType = 1000150003;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR:
    VkStructureType = 1000150004;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR:
    VkStructureType = 1000150005;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR: VkStructureType =
    1000150006;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR:
    VkStructureType = 1000150009;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR: VkStructureType =
    1000150010;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR:
    VkStructureType = 1000150011;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR:
    VkStructureType = 1000150012;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR:
    VkStructureType = 1000150013;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR : VkStructureType = 1000150014 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR:
    VkStructureType = 1000150017;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR:
    VkStructureType = 1000150020;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR:
    VkStructureType = 1000347000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR:
    VkStructureType = 1000347001;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR: VkStructureType =
    1000150015;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR:
    VkStructureType = 1000150016;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR:
    VkStructureType = 1000150018;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR:
    VkStructureType = 1000348013;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV:
    VkStructureType = 1000152000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV:
    VkStructureType = 1000154000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV:
    VkStructureType = 1000154001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
    VkStructureType = 1000158000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
    VkStructureType = 1000158002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
    VkStructureType = 1000158003;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
    VkStructureType = 1000158004;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT:
    VkStructureType = 1000158005;
pub const VkStructureType_VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT: VkStructureType =
    1000160000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT:
    VkStructureType = 1000160001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV : VkStructureType = 1000164000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV:
    VkStructureType = 1000164001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV:
    VkStructureType = 1000164002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV : VkStructureType = 1000164005 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV: VkStructureType =
    1000165000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV: VkStructureType =
    1000165001;
pub const VkStructureType_VK_STRUCTURE_TYPE_GEOMETRY_NV: VkStructureType = 1000165003;
pub const VkStructureType_VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV: VkStructureType = 1000165004;
pub const VkStructureType_VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV: VkStructureType = 1000165005;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV:
    VkStructureType = 1000165006;
pub const VkStructureType_VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV:
    VkStructureType = 1000165007;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV:
    VkStructureType = 1000165008;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV:
    VkStructureType = 1000165009;
pub const VkStructureType_VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV:
    VkStructureType = 1000165011;
pub const VkStructureType_VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV: VkStructureType =
    1000165012;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV : VkStructureType = 1000166000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV : VkStructureType = 1000166001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT:
    VkStructureType = 1000170000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT:
    VkStructureType = 1000170001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT:
    VkStructureType = 1000174000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: VkStructureType =
    1000178000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT: VkStructureType =
    1000178001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT:
    VkStructureType = 1000178002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
    VkStructureType = 1000181000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD:
    VkStructureType = 1000183000;
pub const VkStructureType_VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT: VkStructureType =
    1000184000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD:
    VkStructureType = 1000185000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD:
    VkStructureType = 1000189000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT : VkStructureType = 1000190000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000190001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT : VkStructureType = 1000190002 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP: VkStructureType = 1000191000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT:
    VkStructureType = 1000192000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV : VkStructureType = 1000201000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV:
    VkStructureType = 1000202000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV:
    VkStructureType = 1000202001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV : VkStructureType = 1000203000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV:
    VkStructureType = 1000204000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV : VkStructureType = 1000205000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV:
    VkStructureType = 1000205002;
pub const VkStructureType_VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV: VkStructureType = 1000206000;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV: VkStructureType =
    1000206001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL : VkStructureType = 1000209000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL:
    VkStructureType = 1000210000;
pub const VkStructureType_VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL: VkStructureType =
    1000210001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL: VkStructureType =
    1000210002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL: VkStructureType =
    1000210003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL: VkStructureType =
    1000210004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL:
    VkStructureType = 1000210005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
    VkStructureType = 1000212000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD:
    VkStructureType = 1000213000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD:
    VkStructureType = 1000213001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA: VkStructureType =
    1000214000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR : VkStructureType = 1000215000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000217000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT:
    VkStructureType = 1000218000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT:
    VkStructureType = 1000218001;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT:
    VkStructureType = 1000218002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT:
    VkStructureType = 1000225000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT : VkStructureType = 1000225001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT:
    VkStructureType = 1000225002;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR:
    VkStructureType = 1000226000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR:
    VkStructureType = 1000226001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR:
    VkStructureType = 1000226002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR:
    VkStructureType = 1000226003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR:
    VkStructureType = 1000226004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD:
    VkStructureType = 1000227000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD:
    VkStructureType = 1000229000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT : VkStructureType = 1000234000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
    VkStructureType = 1000237000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT:
    VkStructureType = 1000238000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT: VkStructureType =
    1000238001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: VkStructureType =
    1000239000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV : VkStructureType = 1000240000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT:
    VkStructureType = 1000244000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT: VkStructureType =
    1000244002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT: VkStructureType =
    1000245000;
pub const VkStructureType_VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: VkStructureType = 1000247000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV:
    VkStructureType = 1000249000;
pub const VkStructureType_VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV: VkStructureType =
    1000249001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV:
    VkStructureType = 1000249002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV:
    VkStructureType = 1000250000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV:
    VkStructureType = 1000250001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV:
    VkStructureType = 1000250002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT : VkStructureType = 1000251000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT:
    VkStructureType = 1000252000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT:
    VkStructureType = 1000255000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT:
    VkStructureType = 1000255002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT:
    VkStructureType = 1000255001;
pub const VkStructureType_VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000256000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
    VkStructureType = 1000259000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT:
    VkStructureType = 1000259001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
    VkStructureType = 1000259002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT:
    VkStructureType = 1000260000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
    VkStructureType = 1000265000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
    VkStructureType = 1000267000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR : VkStructureType = 1000269000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR: VkStructureType = 1000269001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR: VkStructureType =
    1000269002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR: VkStructureType =
    1000269003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR: VkStructureType =
    1000269004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR:
    VkStructureType = 1000269005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT : VkStructureType = 1000276000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV : VkStructureType = 1000277000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV: VkStructureType =
    1000277001;
pub const VkStructureType_VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV:
    VkStructureType = 1000277002;
pub const VkStructureType_VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV: VkStructureType =
    1000277003;
pub const VkStructureType_VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV:
    VkStructureType = 1000277004;
pub const VkStructureType_VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV: VkStructureType =
    1000277005;
pub const VkStructureType_VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV:
    VkStructureType = 1000277006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV : VkStructureType = 1000277007 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
    VkStructureType = 1000281000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT : VkStructureType = 1000281001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM : VkStructureType = 1000282000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM: VkStructureType =
    1000282001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT:
    VkStructureType = 1000284000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT:
    VkStructureType = 1000284001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT:
    VkStructureType = 1000284002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
    VkStructureType = 1000286000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
    VkStructureType = 1000286001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT:
    VkStructureType = 1000287000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
    VkStructureType = 1000287001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
    VkStructureType = 1000287002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: VkStructureType =
    1000290000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT:
    VkStructureType = 1000295000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT: VkStructureType =
    1000295001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT: VkStructureType =
    1000295002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT : VkStructureType = 1000297000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV:
    VkStructureType = 1000300000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV:
    VkStructureType = 1000300001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR: VkStructureType = 1000314000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR: VkStructureType =
    1000314001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR: VkStructureType =
    1000314002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR: VkStructureType = 1000314003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR: VkStructureType = 1000314004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR: VkStructureType = 1000314005;
pub const VkStructureType_VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR: VkStructureType =
    1000314006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR:
    VkStructureType = 1000314007;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV:
    VkStructureType = 1000314008;
pub const VkStructureType_VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV: VkStructureType = 1000314009;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR : VkStructureType = 1000325000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV : VkStructureType = 1000326000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV : VkStructureType = 1000326001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV : VkStructureType = 1000326002 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT:
    VkStructureType = 1000332000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT : VkStructureType = 1000332001 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM: VkStructureType =
    1000333000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT:
    VkStructureType = 1000335000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR : VkStructureType = 1000336000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR: VkStructureType = 1000337000;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR: VkStructureType = 1000337001;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR: VkStructureType =
    1000337002;
pub const VkStructureType_VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR: VkStructureType =
    1000337003;
pub const VkStructureType_VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR: VkStructureType = 1000337004;
pub const VkStructureType_VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR: VkStructureType = 1000337005;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR: VkStructureType = 1000337006;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR: VkStructureType = 1000337007;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR: VkStructureType = 1000337008;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR: VkStructureType = 1000337009;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR: VkStructureType = 1000337010;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
    VkStructureType = 1000340000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT: VkStructureType =
    1000346000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_VALVE : VkStructureType = 1000351000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_VALVE:
    VkStructureType = 1000351002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA:
    VkStructureType = 1000364000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA:
    VkStructureType = 1000364001;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA: VkStructureType =
    1000364002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA:
    VkStructureType = 1000365000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA:
    VkStructureType = 1000365001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SCREEN_SURFACE_CREATE_INFO_QNX: VkStructureType =
    1000378000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES:
    VkStructureType = 1000063000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT: VkStructureType =
    1000011000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR: VkStructureType =
    1000053000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR:
    VkStructureType = 1000053001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR:
    VkStructureType = 1000053002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR: VkStructureType =
    1000059000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR: VkStructureType =
    1000059001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR: VkStructureType = 1000059002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR: VkStructureType =
    1000059003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR:
    VkStructureType = 1000059004;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR: VkStructureType =
    1000059005;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR:
    VkStructureType = 1000059006;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR: VkStructureType =
    1000059007;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR:
    VkStructureType = 1000059008;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR: VkStructureType =
    1000060000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR:
    VkStructureType = 1000060003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR:
    VkStructureType = 1000060004;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR: VkStructureType =
    1000060005;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR: VkStructureType =
    1000060006;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR:
    VkStructureType = 1000060013;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR:
    VkStructureType = 1000060014;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR: VkStructureType =
    1000070000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR: VkStructureType =
    1000070001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR:
    VkStructureType = 1000071000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR: VkStructureType =
    1000071001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR:
    VkStructureType = 1000071002;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR: VkStructureType =
    1000071003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR: VkStructureType =
    1000071004;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR:
    VkStructureType = 1000072000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR: VkStructureType =
    1000072001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR: VkStructureType =
    1000072002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR:
    VkStructureType = 1000076000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR: VkStructureType =
    1000076001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR: VkStructureType =
    1000077000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR:
    VkStructureType = 1000082000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR:
    VkStructureType = 1000082000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR:
    VkStructureType = 1000083000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR:
    VkStructureType = 1000085000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES2_EXT: VkStructureType = 1000090000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR:
    VkStructureType = 1000108000;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR:
    VkStructureType = 1000108001;
pub const VkStructureType_VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR: VkStructureType =
    1000108002;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR: VkStructureType =
    1000108003;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR: VkStructureType =
    1000109000;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR: VkStructureType =
    1000109001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR: VkStructureType = 1000109002;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR: VkStructureType = 1000109003;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR: VkStructureType =
    1000109004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR: VkStructureType = 1000109005;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_END_INFO_KHR: VkStructureType = 1000109006;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR:
    VkStructureType = 1000112000;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR: VkStructureType =
    1000112001;
pub const VkStructureType_VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR: VkStructureType =
    1000113000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR:
    VkStructureType = 1000117000;
pub const VkStructureType_VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR:
    VkStructureType = 1000117001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR: VkStructureType =
    1000117002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR : VkStructureType = 1000117003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR:
    VkStructureType = 1000120000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR: VkStructureType =
    1000127000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR: VkStructureType =
    1000127001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT:
    VkStructureType = 1000130000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT:
    VkStructureType = 1000130001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR: VkStructureType =
    1000146000;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR: VkStructureType =
    1000146001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR:
    VkStructureType = 1000146002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR: VkStructureType = 1000146003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR:
    VkStructureType = 1000146004;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR: VkStructureType =
    1000147000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR:
    VkStructureType = 1000156000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR: VkStructureType =
    1000156001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR: VkStructureType =
    1000156002;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR:
    VkStructureType = 1000156003;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR : VkStructureType = 1000156004 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR:
    VkStructureType = 1000156005;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR: VkStructureType =
    1000157000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR: VkStructureType =
    1000157001;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT:
    VkStructureType = 1000161000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT:
    VkStructureType = 1000161001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT:
    VkStructureType = 1000161002;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT : VkStructureType = 1000161003 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT : VkStructureType = 1000161004 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR:
    VkStructureType = 1000168000;
pub const VkStructureType_VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR: VkStructureType =
    1000168001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR : VkStructureType = 1000175000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR:
    VkStructureType = 1000177000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR:
    VkStructureType = 1000180000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR: VkStructureType =
    1000196000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR:
    VkStructureType = 1000197000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR:
    VkStructureType = 1000199000;
pub const VkStructureType_VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR:
    VkStructureType = 1000199001;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR:
    VkStructureType = 1000207000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR:
    VkStructureType = 1000207001;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR: VkStructureType =
    1000207002;
pub const VkStructureType_VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR: VkStructureType =
    1000207003;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR: VkStructureType = 1000207004;
pub const VkStructureType_VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR: VkStructureType = 1000207005;
pub const VkStructureType_VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL: VkStructureType =
    1000210000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR:
    VkStructureType = 1000211000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT:
    VkStructureType = 1000221000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR : VkStructureType = 1000241000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR:
    VkStructureType = 1000241001;
pub const VkStructureType_VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR:
    VkStructureType = 1000241002;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT:
    VkStructureType = 1000244000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT: VkStructureType =
    1000244001;
pub const VkStructureType_VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT: VkStructureType =
    1000246000;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR : VkStructureType = 1000253000 ;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR:
    VkStructureType = 1000257000;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR: VkStructureType =
    1000244001;
pub const VkStructureType_VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR:
    VkStructureType = 1000257002;
pub const VkStructureType_VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR:
    VkStructureType = 1000257003;
pub const VkStructureType_VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR:
    VkStructureType = 1000257004;
pub const VkStructureType_VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT:
    VkStructureType = 1000261000;
pub const VkStructureType_VK_STRUCTURE_TYPE_MAX_ENUM: VkStructureType = 2147483647;
pub type VkStructureType = ::std::os::raw::c_uint;
pub const VkImageLayout_VK_IMAGE_LAYOUT_UNDEFINED: VkImageLayout = 0;
pub const VkImageLayout_VK_IMAGE_LAYOUT_GENERAL: VkImageLayout = 1;
pub const VkImageLayout_VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL: VkImageLayout = 2;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout = 3;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout = 4;
pub const VkImageLayout_VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL: VkImageLayout = 5;
pub const VkImageLayout_VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL: VkImageLayout = 6;
pub const VkImageLayout_VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL: VkImageLayout = 7;
pub const VkImageLayout_VK_IMAGE_LAYOUT_PREINITIALIZED: VkImageLayout = 8;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout =
    1000117000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout =
    1000117001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL: VkImageLayout = 1000241000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL: VkImageLayout = 1000241001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL: VkImageLayout = 1000241002;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL: VkImageLayout = 1000241003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_PRESENT_SRC_KHR: VkImageLayout = 1000001002;
pub const VkImageLayout_VK_IMAGE_LAYOUT_SHARED_PRESENT_KHR: VkImageLayout = 1000111000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_SHADING_RATE_OPTIMAL_NV: VkImageLayout = 1000164003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_FRAGMENT_DENSITY_MAP_OPTIMAL_EXT: VkImageLayout =
    1000218000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000314000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000314001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR:
    VkImageLayout = 1000117000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR:
    VkImageLayout = 1000117001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_FRAGMENT_SHADING_RATE_ATTACHMENT_OPTIMAL_KHR:
    VkImageLayout = 1000164003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000241000;
pub const VkImageLayout_VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000241001;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL_KHR: VkImageLayout = 1000241002;
pub const VkImageLayout_VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL_KHR: VkImageLayout = 1000241003;
pub const VkImageLayout_VK_IMAGE_LAYOUT_MAX_ENUM: VkImageLayout = 2147483647;
pub type VkImageLayout = ::std::os::raw::c_uint;
pub const VkObjectType_VK_OBJECT_TYPE_UNKNOWN: VkObjectType = 0;
pub const VkObjectType_VK_OBJECT_TYPE_INSTANCE: VkObjectType = 1;
pub const VkObjectType_VK_OBJECT_TYPE_PHYSICAL_DEVICE: VkObjectType = 2;
pub const VkObjectType_VK_OBJECT_TYPE_DEVICE: VkObjectType = 3;
pub const VkObjectType_VK_OBJECT_TYPE_QUEUE: VkObjectType = 4;
pub const VkObjectType_VK_OBJECT_TYPE_SEMAPHORE: VkObjectType = 5;
pub const VkObjectType_VK_OBJECT_TYPE_COMMAND_BUFFER: VkObjectType = 6;
pub const VkObjectType_VK_OBJECT_TYPE_FENCE: VkObjectType = 7;
pub const VkObjectType_VK_OBJECT_TYPE_DEVICE_MEMORY: VkObjectType = 8;
pub const VkObjectType_VK_OBJECT_TYPE_BUFFER: VkObjectType = 9;
pub const VkObjectType_VK_OBJECT_TYPE_IMAGE: VkObjectType = 10;
pub const VkObjectType_VK_OBJECT_TYPE_EVENT: VkObjectType = 11;
pub const VkObjectType_VK_OBJECT_TYPE_QUERY_POOL: VkObjectType = 12;
pub const VkObjectType_VK_OBJECT_TYPE_BUFFER_VIEW: VkObjectType = 13;
pub const VkObjectType_VK_OBJECT_TYPE_IMAGE_VIEW: VkObjectType = 14;
pub const VkObjectType_VK_OBJECT_TYPE_SHADER_MODULE: VkObjectType = 15;
pub const VkObjectType_VK_OBJECT_TYPE_PIPELINE_CACHE: VkObjectType = 16;
pub const VkObjectType_VK_OBJECT_TYPE_PIPELINE_LAYOUT: VkObjectType = 17;
pub const VkObjectType_VK_OBJECT_TYPE_RENDER_PASS: VkObjectType = 18;
pub const VkObjectType_VK_OBJECT_TYPE_PIPELINE: VkObjectType = 19;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT: VkObjectType = 20;
pub const VkObjectType_VK_OBJECT_TYPE_SAMPLER: VkObjectType = 21;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_POOL: VkObjectType = 22;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_SET: VkObjectType = 23;
pub const VkObjectType_VK_OBJECT_TYPE_FRAMEBUFFER: VkObjectType = 24;
pub const VkObjectType_VK_OBJECT_TYPE_COMMAND_POOL: VkObjectType = 25;
pub const VkObjectType_VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION: VkObjectType = 1000156000;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE: VkObjectType = 1000085000;
pub const VkObjectType_VK_OBJECT_TYPE_SURFACE_KHR: VkObjectType = 1000000000;
pub const VkObjectType_VK_OBJECT_TYPE_SWAPCHAIN_KHR: VkObjectType = 1000001000;
pub const VkObjectType_VK_OBJECT_TYPE_DISPLAY_KHR: VkObjectType = 1000002000;
pub const VkObjectType_VK_OBJECT_TYPE_DISPLAY_MODE_KHR: VkObjectType = 1000002001;
pub const VkObjectType_VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT: VkObjectType = 1000011000;
pub const VkObjectType_VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT: VkObjectType = 1000128000;
pub const VkObjectType_VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR: VkObjectType = 1000150000;
pub const VkObjectType_VK_OBJECT_TYPE_VALIDATION_CACHE_EXT: VkObjectType = 1000160000;
pub const VkObjectType_VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV: VkObjectType = 1000165000;
pub const VkObjectType_VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL: VkObjectType = 1000210000;
pub const VkObjectType_VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR: VkObjectType = 1000268000;
pub const VkObjectType_VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV: VkObjectType = 1000277000;
pub const VkObjectType_VK_OBJECT_TYPE_PRIVATE_DATA_SLOT_EXT: VkObjectType = 1000295000;
pub const VkObjectType_VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR: VkObjectType = 1000085000;
pub const VkObjectType_VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR: VkObjectType = 1000156000;
pub const VkObjectType_VK_OBJECT_TYPE_MAX_ENUM: VkObjectType = 2147483647;
pub type VkObjectType = ::std::os::raw::c_uint;
pub const VkVendorId_VK_VENDOR_ID_VIV: VkVendorId = 65537;
pub const VkVendorId_VK_VENDOR_ID_VSI: VkVendorId = 65538;
pub const VkVendorId_VK_VENDOR_ID_KAZAN: VkVendorId = 65539;
pub const VkVendorId_VK_VENDOR_ID_CODEPLAY: VkVendorId = 65540;
pub const VkVendorId_VK_VENDOR_ID_MESA: VkVendorId = 65541;
pub const VkVendorId_VK_VENDOR_ID_POCL: VkVendorId = 65542;
pub const VkVendorId_VK_VENDOR_ID_MAX_ENUM: VkVendorId = 2147483647;
pub type VkVendorId = ::std::os::raw::c_uint;
pub const VkPipelineCacheHeaderVersion_VK_PIPELINE_CACHE_HEADER_VERSION_ONE:
    VkPipelineCacheHeaderVersion = 1;
pub const VkPipelineCacheHeaderVersion_VK_PIPELINE_CACHE_HEADER_VERSION_MAX_ENUM:
    VkPipelineCacheHeaderVersion = 2147483647;
pub type VkPipelineCacheHeaderVersion = ::std::os::raw::c_uint;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_COMMAND: VkSystemAllocationScope = 0;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_OBJECT: VkSystemAllocationScope = 1;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_CACHE: VkSystemAllocationScope = 2;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_DEVICE: VkSystemAllocationScope = 3;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE: VkSystemAllocationScope = 4;
pub const VkSystemAllocationScope_VK_SYSTEM_ALLOCATION_SCOPE_MAX_ENUM: VkSystemAllocationScope =
    2147483647;
pub type VkSystemAllocationScope = ::std::os::raw::c_uint;
pub const VkInternalAllocationType_VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE:
    VkInternalAllocationType = 0;
pub const VkInternalAllocationType_VK_INTERNAL_ALLOCATION_TYPE_MAX_ENUM: VkInternalAllocationType =
    2147483647;
pub type VkInternalAllocationType = ::std::os::raw::c_uint;
pub const VkFormat_VK_FORMAT_UNDEFINED: VkFormat = 0;
pub const VkFormat_VK_FORMAT_R4G4_UNORM_PACK8: VkFormat = 1;
pub const VkFormat_VK_FORMAT_R4G4B4A4_UNORM_PACK16: VkFormat = 2;
pub const VkFormat_VK_FORMAT_B4G4R4A4_UNORM_PACK16: VkFormat = 3;
pub const VkFormat_VK_FORMAT_R5G6B5_UNORM_PACK16: VkFormat = 4;
pub const VkFormat_VK_FORMAT_B5G6R5_UNORM_PACK16: VkFormat = 5;
pub const VkFormat_VK_FORMAT_R5G5B5A1_UNORM_PACK16: VkFormat = 6;
pub const VkFormat_VK_FORMAT_B5G5R5A1_UNORM_PACK16: VkFormat = 7;
pub const VkFormat_VK_FORMAT_A1R5G5B5_UNORM_PACK16: VkFormat = 8;
pub const VkFormat_VK_FORMAT_R8_UNORM: VkFormat = 9;
pub const VkFormat_VK_FORMAT_R8_SNORM: VkFormat = 10;
pub const VkFormat_VK_FORMAT_R8_USCALED: VkFormat = 11;
pub const VkFormat_VK_FORMAT_R8_SSCALED: VkFormat = 12;
pub const VkFormat_VK_FORMAT_R8_UINT: VkFormat = 13;
pub const VkFormat_VK_FORMAT_R8_SINT: VkFormat = 14;
pub const VkFormat_VK_FORMAT_R8_SRGB: VkFormat = 15;
pub const VkFormat_VK_FORMAT_R8G8_UNORM: VkFormat = 16;
pub const VkFormat_VK_FORMAT_R8G8_SNORM: VkFormat = 17;
pub const VkFormat_VK_FORMAT_R8G8_USCALED: VkFormat = 18;
pub const VkFormat_VK_FORMAT_R8G8_SSCALED: VkFormat = 19;
pub const VkFormat_VK_FORMAT_R8G8_UINT: VkFormat = 20;
pub const VkFormat_VK_FORMAT_R8G8_SINT: VkFormat = 21;
pub const VkFormat_VK_FORMAT_R8G8_SRGB: VkFormat = 22;
pub const VkFormat_VK_FORMAT_R8G8B8_UNORM: VkFormat = 23;
pub const VkFormat_VK_FORMAT_R8G8B8_SNORM: VkFormat = 24;
pub const VkFormat_VK_FORMAT_R8G8B8_USCALED: VkFormat = 25;
pub const VkFormat_VK_FORMAT_R8G8B8_SSCALED: VkFormat = 26;
pub const VkFormat_VK_FORMAT_R8G8B8_UINT: VkFormat = 27;
pub const VkFormat_VK_FORMAT_R8G8B8_SINT: VkFormat = 28;
pub const VkFormat_VK_FORMAT_R8G8B8_SRGB: VkFormat = 29;
pub const VkFormat_VK_FORMAT_B8G8R8_UNORM: VkFormat = 30;
pub const VkFormat_VK_FORMAT_B8G8R8_SNORM: VkFormat = 31;
pub const VkFormat_VK_FORMAT_B8G8R8_USCALED: VkFormat = 32;
pub const VkFormat_VK_FORMAT_B8G8R8_SSCALED: VkFormat = 33;
pub const VkFormat_VK_FORMAT_B8G8R8_UINT: VkFormat = 34;
pub const VkFormat_VK_FORMAT_B8G8R8_SINT: VkFormat = 35;
pub const VkFormat_VK_FORMAT_B8G8R8_SRGB: VkFormat = 36;
pub const VkFormat_VK_FORMAT_R8G8B8A8_UNORM: VkFormat = 37;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SNORM: VkFormat = 38;
pub const VkFormat_VK_FORMAT_R8G8B8A8_USCALED: VkFormat = 39;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SSCALED: VkFormat = 40;
pub const VkFormat_VK_FORMAT_R8G8B8A8_UINT: VkFormat = 41;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SINT: VkFormat = 42;
pub const VkFormat_VK_FORMAT_R8G8B8A8_SRGB: VkFormat = 43;
pub const VkFormat_VK_FORMAT_B8G8R8A8_UNORM: VkFormat = 44;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SNORM: VkFormat = 45;
pub const VkFormat_VK_FORMAT_B8G8R8A8_USCALED: VkFormat = 46;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SSCALED: VkFormat = 47;
pub const VkFormat_VK_FORMAT_B8G8R8A8_UINT: VkFormat = 48;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SINT: VkFormat = 49;
pub const VkFormat_VK_FORMAT_B8G8R8A8_SRGB: VkFormat = 50;
pub const VkFormat_VK_FORMAT_A8B8G8R8_UNORM_PACK32: VkFormat = 51;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SNORM_PACK32: VkFormat = 52;
pub const VkFormat_VK_FORMAT_A8B8G8R8_USCALED_PACK32: VkFormat = 53;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SSCALED_PACK32: VkFormat = 54;
pub const VkFormat_VK_FORMAT_A8B8G8R8_UINT_PACK32: VkFormat = 55;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SINT_PACK32: VkFormat = 56;
pub const VkFormat_VK_FORMAT_A8B8G8R8_SRGB_PACK32: VkFormat = 57;
pub const VkFormat_VK_FORMAT_A2R10G10B10_UNORM_PACK32: VkFormat = 58;
pub const VkFormat_VK_FORMAT_A2R10G10B10_SNORM_PACK32: VkFormat = 59;
pub const VkFormat_VK_FORMAT_A2R10G10B10_USCALED_PACK32: VkFormat = 60;
pub const VkFormat_VK_FORMAT_A2R10G10B10_SSCALED_PACK32: VkFormat = 61;
pub const VkFormat_VK_FORMAT_A2R10G10B10_UINT_PACK32: VkFormat = 62;
pub const VkFormat_VK_FORMAT_A2R10G10B10_SINT_PACK32: VkFormat = 63;
pub const VkFormat_VK_FORMAT_A2B10G10R10_UNORM_PACK32: VkFormat = 64;
pub const VkFormat_VK_FORMAT_A2B10G10R10_SNORM_PACK32: VkFormat = 65;
pub const VkFormat_VK_FORMAT_A2B10G10R10_USCALED_PACK32: VkFormat = 66;
pub const VkFormat_VK_FORMAT_A2B10G10R10_SSCALED_PACK32: VkFormat = 67;
pub const VkFormat_VK_FORMAT_A2B10G10R10_UINT_PACK32: VkFormat = 68;
pub const VkFormat_VK_FORMAT_A2B10G10R10_SINT_PACK32: VkFormat = 69;
pub const VkFormat_VK_FORMAT_R16_UNORM: VkFormat = 70;
pub const VkFormat_VK_FORMAT_R16_SNORM: VkFormat = 71;
pub const VkFormat_VK_FORMAT_R16_USCALED: VkFormat = 72;
pub const VkFormat_VK_FORMAT_R16_SSCALED: VkFormat = 73;
pub const VkFormat_VK_FORMAT_R16_UINT: VkFormat = 74;
pub const VkFormat_VK_FORMAT_R16_SINT: VkFormat = 75;
pub const VkFormat_VK_FORMAT_R16_SFLOAT: VkFormat = 76;
pub const VkFormat_VK_FORMAT_R16G16_UNORM: VkFormat = 77;
pub const VkFormat_VK_FORMAT_R16G16_SNORM: VkFormat = 78;
pub const VkFormat_VK_FORMAT_R16G16_USCALED: VkFormat = 79;
pub const VkFormat_VK_FORMAT_R16G16_SSCALED: VkFormat = 80;
pub const VkFormat_VK_FORMAT_R16G16_UINT: VkFormat = 81;
pub const VkFormat_VK_FORMAT_R16G16_SINT: VkFormat = 82;
pub const VkFormat_VK_FORMAT_R16G16_SFLOAT: VkFormat = 83;
pub const VkFormat_VK_FORMAT_R16G16B16_UNORM: VkFormat = 84;
pub const VkFormat_VK_FORMAT_R16G16B16_SNORM: VkFormat = 85;
pub const VkFormat_VK_FORMAT_R16G16B16_USCALED: VkFormat = 86;
pub const VkFormat_VK_FORMAT_R16G16B16_SSCALED: VkFormat = 87;
pub const VkFormat_VK_FORMAT_R16G16B16_UINT: VkFormat = 88;
pub const VkFormat_VK_FORMAT_R16G16B16_SINT: VkFormat = 89;
pub const VkFormat_VK_FORMAT_R16G16B16_SFLOAT: VkFormat = 90;
pub const VkFormat_VK_FORMAT_R16G16B16A16_UNORM: VkFormat = 91;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SNORM: VkFormat = 92;
pub const VkFormat_VK_FORMAT_R16G16B16A16_USCALED: VkFormat = 93;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SSCALED: VkFormat = 94;
pub const VkFormat_VK_FORMAT_R16G16B16A16_UINT: VkFormat = 95;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SINT: VkFormat = 96;
pub const VkFormat_VK_FORMAT_R16G16B16A16_SFLOAT: VkFormat = 97;
pub const VkFormat_VK_FORMAT_R32_UINT: VkFormat = 98;
pub const VkFormat_VK_FORMAT_R32_SINT: VkFormat = 99;
pub const VkFormat_VK_FORMAT_R32_SFLOAT: VkFormat = 100;
pub const VkFormat_VK_FORMAT_R32G32_UINT: VkFormat = 101;
pub const VkFormat_VK_FORMAT_R32G32_SINT: VkFormat = 102;
pub const VkFormat_VK_FORMAT_R32G32_SFLOAT: VkFormat = 103;
pub const VkFormat_VK_FORMAT_R32G32B32_UINT: VkFormat = 104;
pub const VkFormat_VK_FORMAT_R32G32B32_SINT: VkFormat = 105;
pub const VkFormat_VK_FORMAT_R32G32B32_SFLOAT: VkFormat = 106;
pub const VkFormat_VK_FORMAT_R32G32B32A32_UINT: VkFormat = 107;
pub const VkFormat_VK_FORMAT_R32G32B32A32_SINT: VkFormat = 108;
pub const VkFormat_VK_FORMAT_R32G32B32A32_SFLOAT: VkFormat = 109;
pub const VkFormat_VK_FORMAT_R64_UINT: VkFormat = 110;
pub const VkFormat_VK_FORMAT_R64_SINT: VkFormat = 111;
pub const VkFormat_VK_FORMAT_R64_SFLOAT: VkFormat = 112;
pub const VkFormat_VK_FORMAT_R64G64_UINT: VkFormat = 113;
pub const VkFormat_VK_FORMAT_R64G64_SINT: VkFormat = 114;
pub const VkFormat_VK_FORMAT_R64G64_SFLOAT: VkFormat = 115;
pub const VkFormat_VK_FORMAT_R64G64B64_UINT: VkFormat = 116;
pub const VkFormat_VK_FORMAT_R64G64B64_SINT: VkFormat = 117;
pub const VkFormat_VK_FORMAT_R64G64B64_SFLOAT: VkFormat = 118;
pub const VkFormat_VK_FORMAT_R64G64B64A64_UINT: VkFormat = 119;
pub const VkFormat_VK_FORMAT_R64G64B64A64_SINT: VkFormat = 120;
pub const VkFormat_VK_FORMAT_R64G64B64A64_SFLOAT: VkFormat = 121;
pub const VkFormat_VK_FORMAT_B10G11R11_UFLOAT_PACK32: VkFormat = 122;
pub const VkFormat_VK_FORMAT_E5B9G9R9_UFLOAT_PACK32: VkFormat = 123;
pub const VkFormat_VK_FORMAT_D16_UNORM: VkFormat = 124;
pub const VkFormat_VK_FORMAT_X8_D24_UNORM_PACK32: VkFormat = 125;
pub const VkFormat_VK_FORMAT_D32_SFLOAT: VkFormat = 126;
pub const VkFormat_VK_FORMAT_S8_UINT: VkFormat = 127;
pub const VkFormat_VK_FORMAT_D16_UNORM_S8_UINT: VkFormat = 128;
pub const VkFormat_VK_FORMAT_D24_UNORM_S8_UINT: VkFormat = 129;
pub const VkFormat_VK_FORMAT_D32_SFLOAT_S8_UINT: VkFormat = 130;
pub const VkFormat_VK_FORMAT_BC1_RGB_UNORM_BLOCK: VkFormat = 131;
pub const VkFormat_VK_FORMAT_BC1_RGB_SRGB_BLOCK: VkFormat = 132;
pub const VkFormat_VK_FORMAT_BC1_RGBA_UNORM_BLOCK: VkFormat = 133;
pub const VkFormat_VK_FORMAT_BC1_RGBA_SRGB_BLOCK: VkFormat = 134;
pub const VkFormat_VK_FORMAT_BC2_UNORM_BLOCK: VkFormat = 135;
pub const VkFormat_VK_FORMAT_BC2_SRGB_BLOCK: VkFormat = 136;
pub const VkFormat_VK_FORMAT_BC3_UNORM_BLOCK: VkFormat = 137;
pub const VkFormat_VK_FORMAT_BC3_SRGB_BLOCK: VkFormat = 138;
pub const VkFormat_VK_FORMAT_BC4_UNORM_BLOCK: VkFormat = 139;
pub const VkFormat_VK_FORMAT_BC4_SNORM_BLOCK: VkFormat = 140;
pub const VkFormat_VK_FORMAT_BC5_UNORM_BLOCK: VkFormat = 141;
pub const VkFormat_VK_FORMAT_BC5_SNORM_BLOCK: VkFormat = 142;
pub const VkFormat_VK_FORMAT_BC6H_UFLOAT_BLOCK: VkFormat = 143;
pub const VkFormat_VK_FORMAT_BC6H_SFLOAT_BLOCK: VkFormat = 144;
pub const VkFormat_VK_FORMAT_BC7_UNORM_BLOCK: VkFormat = 145;
pub const VkFormat_VK_FORMAT_BC7_SRGB_BLOCK: VkFormat = 146;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK: VkFormat = 147;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK: VkFormat = 148;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK: VkFormat = 149;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK: VkFormat = 150;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK: VkFormat = 151;
pub const VkFormat_VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK: VkFormat = 152;
pub const VkFormat_VK_FORMAT_EAC_R11_UNORM_BLOCK: VkFormat = 153;
pub const VkFormat_VK_FORMAT_EAC_R11_SNORM_BLOCK: VkFormat = 154;
pub const VkFormat_VK_FORMAT_EAC_R11G11_UNORM_BLOCK: VkFormat = 155;
pub const VkFormat_VK_FORMAT_EAC_R11G11_SNORM_BLOCK: VkFormat = 156;
pub const VkFormat_VK_FORMAT_ASTC_4x4_UNORM_BLOCK: VkFormat = 157;
pub const VkFormat_VK_FORMAT_ASTC_4x4_SRGB_BLOCK: VkFormat = 158;
pub const VkFormat_VK_FORMAT_ASTC_5x4_UNORM_BLOCK: VkFormat = 159;
pub const VkFormat_VK_FORMAT_ASTC_5x4_SRGB_BLOCK: VkFormat = 160;
pub const VkFormat_VK_FORMAT_ASTC_5x5_UNORM_BLOCK: VkFormat = 161;
pub const VkFormat_VK_FORMAT_ASTC_5x5_SRGB_BLOCK: VkFormat = 162;
pub const VkFormat_VK_FORMAT_ASTC_6x5_UNORM_BLOCK: VkFormat = 163;
pub const VkFormat_VK_FORMAT_ASTC_6x5_SRGB_BLOCK: VkFormat = 164;
pub const VkFormat_VK_FORMAT_ASTC_6x6_UNORM_BLOCK: VkFormat = 165;
pub const VkFormat_VK_FORMAT_ASTC_6x6_SRGB_BLOCK: VkFormat = 166;
pub const VkFormat_VK_FORMAT_ASTC_8x5_UNORM_BLOCK: VkFormat = 167;
pub const VkFormat_VK_FORMAT_ASTC_8x5_SRGB_BLOCK: VkFormat = 168;
pub const VkFormat_VK_FORMAT_ASTC_8x6_UNORM_BLOCK: VkFormat = 169;
pub const VkFormat_VK_FORMAT_ASTC_8x6_SRGB_BLOCK: VkFormat = 170;
pub const VkFormat_VK_FORMAT_ASTC_8x8_UNORM_BLOCK: VkFormat = 171;
pub const VkFormat_VK_FORMAT_ASTC_8x8_SRGB_BLOCK: VkFormat = 172;
pub const VkFormat_VK_FORMAT_ASTC_10x5_UNORM_BLOCK: VkFormat = 173;
pub const VkFormat_VK_FORMAT_ASTC_10x5_SRGB_BLOCK: VkFormat = 174;
pub const VkFormat_VK_FORMAT_ASTC_10x6_UNORM_BLOCK: VkFormat = 175;
pub const VkFormat_VK_FORMAT_ASTC_10x6_SRGB_BLOCK: VkFormat = 176;
pub const VkFormat_VK_FORMAT_ASTC_10x8_UNORM_BLOCK: VkFormat = 177;
pub const VkFormat_VK_FORMAT_ASTC_10x8_SRGB_BLOCK: VkFormat = 178;
pub const VkFormat_VK_FORMAT_ASTC_10x10_UNORM_BLOCK: VkFormat = 179;
pub const VkFormat_VK_FORMAT_ASTC_10x10_SRGB_BLOCK: VkFormat = 180;
pub const VkFormat_VK_FORMAT_ASTC_12x10_UNORM_BLOCK: VkFormat = 181;
pub const VkFormat_VK_FORMAT_ASTC_12x10_SRGB_BLOCK: VkFormat = 182;
pub const VkFormat_VK_FORMAT_ASTC_12x12_UNORM_BLOCK: VkFormat = 183;
pub const VkFormat_VK_FORMAT_ASTC_12x12_SRGB_BLOCK: VkFormat = 184;
pub const VkFormat_VK_FORMAT_G8B8G8R8_422_UNORM: VkFormat = 1000156000;
pub const VkFormat_VK_FORMAT_B8G8R8G8_422_UNORM: VkFormat = 1000156001;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM: VkFormat = 1000156002;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_420_UNORM: VkFormat = 1000156003;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM: VkFormat = 1000156004;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_422_UNORM: VkFormat = 1000156005;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM: VkFormat = 1000156006;
pub const VkFormat_VK_FORMAT_R10X6_UNORM_PACK16: VkFormat = 1000156007;
pub const VkFormat_VK_FORMAT_R10X6G10X6_UNORM_2PACK16: VkFormat = 1000156008;
pub const VkFormat_VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16: VkFormat = 1000156009;
pub const VkFormat_VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: VkFormat = 1000156010;
pub const VkFormat_VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: VkFormat = 1000156011;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16: VkFormat = 1000156012;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16: VkFormat = 1000156013;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16: VkFormat = 1000156014;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16: VkFormat = 1000156015;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16: VkFormat = 1000156016;
pub const VkFormat_VK_FORMAT_R12X4_UNORM_PACK16: VkFormat = 1000156017;
pub const VkFormat_VK_FORMAT_R12X4G12X4_UNORM_2PACK16: VkFormat = 1000156018;
pub const VkFormat_VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16: VkFormat = 1000156019;
pub const VkFormat_VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: VkFormat = 1000156020;
pub const VkFormat_VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: VkFormat = 1000156021;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16: VkFormat = 1000156022;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16: VkFormat = 1000156023;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16: VkFormat = 1000156024;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16: VkFormat = 1000156025;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16: VkFormat = 1000156026;
pub const VkFormat_VK_FORMAT_G16B16G16R16_422_UNORM: VkFormat = 1000156027;
pub const VkFormat_VK_FORMAT_B16G16R16G16_422_UNORM: VkFormat = 1000156028;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM: VkFormat = 1000156029;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_420_UNORM: VkFormat = 1000156030;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM: VkFormat = 1000156031;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_422_UNORM: VkFormat = 1000156032;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM: VkFormat = 1000156033;
pub const VkFormat_VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG: VkFormat = 1000054000;
pub const VkFormat_VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG: VkFormat = 1000054001;
pub const VkFormat_VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG: VkFormat = 1000054002;
pub const VkFormat_VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG: VkFormat = 1000054003;
pub const VkFormat_VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG: VkFormat = 1000054004;
pub const VkFormat_VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG: VkFormat = 1000054005;
pub const VkFormat_VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG: VkFormat = 1000054006;
pub const VkFormat_VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG: VkFormat = 1000054007;
pub const VkFormat_VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT: VkFormat = 1000066000;
pub const VkFormat_VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT: VkFormat = 1000066001;
pub const VkFormat_VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066002;
pub const VkFormat_VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066003;
pub const VkFormat_VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066004;
pub const VkFormat_VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066005;
pub const VkFormat_VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066006;
pub const VkFormat_VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT: VkFormat = 1000066007;
pub const VkFormat_VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT: VkFormat = 1000066008;
pub const VkFormat_VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT: VkFormat = 1000066009;
pub const VkFormat_VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT: VkFormat = 1000066010;
pub const VkFormat_VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT: VkFormat = 1000066011;
pub const VkFormat_VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT: VkFormat = 1000066012;
pub const VkFormat_VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT: VkFormat = 1000066013;
pub const VkFormat_VK_FORMAT_A4R4G4B4_UNORM_PACK16_EXT: VkFormat = 1000340000;
pub const VkFormat_VK_FORMAT_A4B4G4R4_UNORM_PACK16_EXT: VkFormat = 1000340001;
pub const VkFormat_VK_FORMAT_G8B8G8R8_422_UNORM_KHR: VkFormat = 1000156000;
pub const VkFormat_VK_FORMAT_B8G8R8G8_422_UNORM_KHR: VkFormat = 1000156001;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR: VkFormat = 1000156002;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR: VkFormat = 1000156003;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR: VkFormat = 1000156004;
pub const VkFormat_VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR: VkFormat = 1000156005;
pub const VkFormat_VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR: VkFormat = 1000156006;
pub const VkFormat_VK_FORMAT_R10X6_UNORM_PACK16_KHR: VkFormat = 1000156007;
pub const VkFormat_VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR: VkFormat = 1000156008;
pub const VkFormat_VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR: VkFormat = 1000156009;
pub const VkFormat_VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR: VkFormat = 1000156010;
pub const VkFormat_VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR: VkFormat = 1000156011;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156012;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156013;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156014;
pub const VkFormat_VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156015;
pub const VkFormat_VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR: VkFormat = 1000156016;
pub const VkFormat_VK_FORMAT_R12X4_UNORM_PACK16_KHR: VkFormat = 1000156017;
pub const VkFormat_VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR: VkFormat = 1000156018;
pub const VkFormat_VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR: VkFormat = 1000156019;
pub const VkFormat_VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR: VkFormat = 1000156020;
pub const VkFormat_VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR: VkFormat = 1000156021;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156022;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR: VkFormat = 1000156023;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156024;
pub const VkFormat_VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR: VkFormat = 1000156025;
pub const VkFormat_VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR: VkFormat = 1000156026;
pub const VkFormat_VK_FORMAT_G16B16G16R16_422_UNORM_KHR: VkFormat = 1000156027;
pub const VkFormat_VK_FORMAT_B16G16R16G16_422_UNORM_KHR: VkFormat = 1000156028;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR: VkFormat = 1000156029;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR: VkFormat = 1000156030;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR: VkFormat = 1000156031;
pub const VkFormat_VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR: VkFormat = 1000156032;
pub const VkFormat_VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR: VkFormat = 1000156033;
pub const VkFormat_VK_FORMAT_MAX_ENUM: VkFormat = 2147483647;
pub type VkFormat = ::std::os::raw::c_uint;
pub const VkImageTiling_VK_IMAGE_TILING_OPTIMAL: VkImageTiling = 0;
pub const VkImageTiling_VK_IMAGE_TILING_LINEAR: VkImageTiling = 1;
pub const VkImageTiling_VK_IMAGE_TILING_DRM_FORMAT_MODIFIER_EXT: VkImageTiling = 1000158000;
pub const VkImageTiling_VK_IMAGE_TILING_MAX_ENUM: VkImageTiling = 2147483647;
pub type VkImageTiling = ::std::os::raw::c_uint;
pub const VkImageType_VK_IMAGE_TYPE_1D: VkImageType = 0;
pub const VkImageType_VK_IMAGE_TYPE_2D: VkImageType = 1;
pub const VkImageType_VK_IMAGE_TYPE_3D: VkImageType = 2;
pub const VkImageType_VK_IMAGE_TYPE_MAX_ENUM: VkImageType = 2147483647;
pub type VkImageType = ::std::os::raw::c_uint;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_OTHER: VkPhysicalDeviceType = 0;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU: VkPhysicalDeviceType = 1;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU: VkPhysicalDeviceType = 2;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU: VkPhysicalDeviceType = 3;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_CPU: VkPhysicalDeviceType = 4;
pub const VkPhysicalDeviceType_VK_PHYSICAL_DEVICE_TYPE_MAX_ENUM: VkPhysicalDeviceType = 2147483647;
pub type VkPhysicalDeviceType = ::std::os::raw::c_uint;
pub const VkQueryType_VK_QUERY_TYPE_OCCLUSION: VkQueryType = 0;
pub const VkQueryType_VK_QUERY_TYPE_PIPELINE_STATISTICS: VkQueryType = 1;
pub const VkQueryType_VK_QUERY_TYPE_TIMESTAMP: VkQueryType = 2;
pub const VkQueryType_VK_QUERY_TYPE_TRANSFORM_FEEDBACK_STREAM_EXT: VkQueryType = 1000028004;
pub const VkQueryType_VK_QUERY_TYPE_PERFORMANCE_QUERY_KHR: VkQueryType = 1000116000;
pub const VkQueryType_VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_KHR: VkQueryType =
    1000150000;
pub const VkQueryType_VK_QUERY_TYPE_ACCELERATION_STRUCTURE_SERIALIZATION_SIZE_KHR: VkQueryType =
    1000150001;
pub const VkQueryType_VK_QUERY_TYPE_ACCELERATION_STRUCTURE_COMPACTED_SIZE_NV: VkQueryType =
    1000165000;
pub const VkQueryType_VK_QUERY_TYPE_PERFORMANCE_QUERY_INTEL: VkQueryType = 1000210000;
pub const VkQueryType_VK_QUERY_TYPE_MAX_ENUM: VkQueryType = 2147483647;
pub type VkQueryType = ::std::os::raw::c_uint;
pub const VkSharingMode_VK_SHARING_MODE_EXCLUSIVE: VkSharingMode = 0;
pub const VkSharingMode_VK_SHARING_MODE_CONCURRENT: VkSharingMode = 1;
pub const VkSharingMode_VK_SHARING_MODE_MAX_ENUM: VkSharingMode = 2147483647;
pub type VkSharingMode = ::std::os::raw::c_uint;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_IDENTITY: VkComponentSwizzle = 0;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_ZERO: VkComponentSwizzle = 1;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_ONE: VkComponentSwizzle = 2;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_R: VkComponentSwizzle = 3;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_G: VkComponentSwizzle = 4;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_B: VkComponentSwizzle = 5;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_A: VkComponentSwizzle = 6;
pub const VkComponentSwizzle_VK_COMPONENT_SWIZZLE_MAX_ENUM: VkComponentSwizzle = 2147483647;
pub type VkComponentSwizzle = ::std::os::raw::c_uint;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_1D: VkImageViewType = 0;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_2D: VkImageViewType = 1;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_3D: VkImageViewType = 2;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_CUBE: VkImageViewType = 3;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_1D_ARRAY: VkImageViewType = 4;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_2D_ARRAY: VkImageViewType = 5;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_CUBE_ARRAY: VkImageViewType = 6;
pub const VkImageViewType_VK_IMAGE_VIEW_TYPE_MAX_ENUM: VkImageViewType = 2147483647;
pub type VkImageViewType = ::std::os::raw::c_uint;
pub const VkBlendFactor_VK_BLEND_FACTOR_ZERO: VkBlendFactor = 0;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE: VkBlendFactor = 1;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC_COLOR: VkBlendFactor = 2;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR: VkBlendFactor = 3;
pub const VkBlendFactor_VK_BLEND_FACTOR_DST_COLOR: VkBlendFactor = 4;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR: VkBlendFactor = 5;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC_ALPHA: VkBlendFactor = 6;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA: VkBlendFactor = 7;
pub const VkBlendFactor_VK_BLEND_FACTOR_DST_ALPHA: VkBlendFactor = 8;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA: VkBlendFactor = 9;
pub const VkBlendFactor_VK_BLEND_FACTOR_CONSTANT_COLOR: VkBlendFactor = 10;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR: VkBlendFactor = 11;
pub const VkBlendFactor_VK_BLEND_FACTOR_CONSTANT_ALPHA: VkBlendFactor = 12;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA: VkBlendFactor = 13;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC_ALPHA_SATURATE: VkBlendFactor = 14;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC1_COLOR: VkBlendFactor = 15;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR: VkBlendFactor = 16;
pub const VkBlendFactor_VK_BLEND_FACTOR_SRC1_ALPHA: VkBlendFactor = 17;
pub const VkBlendFactor_VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA: VkBlendFactor = 18;
pub const VkBlendFactor_VK_BLEND_FACTOR_MAX_ENUM: VkBlendFactor = 2147483647;
pub type VkBlendFactor = ::std::os::raw::c_uint;
pub const VkBlendOp_VK_BLEND_OP_ADD: VkBlendOp = 0;
pub const VkBlendOp_VK_BLEND_OP_SUBTRACT: VkBlendOp = 1;
pub const VkBlendOp_VK_BLEND_OP_REVERSE_SUBTRACT: VkBlendOp = 2;
pub const VkBlendOp_VK_BLEND_OP_MIN: VkBlendOp = 3;
pub const VkBlendOp_VK_BLEND_OP_MAX: VkBlendOp = 4;
pub const VkBlendOp_VK_BLEND_OP_ZERO_EXT: VkBlendOp = 1000148000;
pub const VkBlendOp_VK_BLEND_OP_SRC_EXT: VkBlendOp = 1000148001;
pub const VkBlendOp_VK_BLEND_OP_DST_EXT: VkBlendOp = 1000148002;
pub const VkBlendOp_VK_BLEND_OP_SRC_OVER_EXT: VkBlendOp = 1000148003;
pub const VkBlendOp_VK_BLEND_OP_DST_OVER_EXT: VkBlendOp = 1000148004;
pub const VkBlendOp_VK_BLEND_OP_SRC_IN_EXT: VkBlendOp = 1000148005;
pub const VkBlendOp_VK_BLEND_OP_DST_IN_EXT: VkBlendOp = 1000148006;
pub const VkBlendOp_VK_BLEND_OP_SRC_OUT_EXT: VkBlendOp = 1000148007;
pub const VkBlendOp_VK_BLEND_OP_DST_OUT_EXT: VkBlendOp = 1000148008;
pub const VkBlendOp_VK_BLEND_OP_SRC_ATOP_EXT: VkBlendOp = 1000148009;
pub const VkBlendOp_VK_BLEND_OP_DST_ATOP_EXT: VkBlendOp = 1000148010;
pub const VkBlendOp_VK_BLEND_OP_XOR_EXT: VkBlendOp = 1000148011;
pub const VkBlendOp_VK_BLEND_OP_MULTIPLY_EXT: VkBlendOp = 1000148012;
pub const VkBlendOp_VK_BLEND_OP_SCREEN_EXT: VkBlendOp = 1000148013;
pub const VkBlendOp_VK_BLEND_OP_OVERLAY_EXT: VkBlendOp = 1000148014;
pub const VkBlendOp_VK_BLEND_OP_DARKEN_EXT: VkBlendOp = 1000148015;
pub const VkBlendOp_VK_BLEND_OP_LIGHTEN_EXT: VkBlendOp = 1000148016;
pub const VkBlendOp_VK_BLEND_OP_COLORDODGE_EXT: VkBlendOp = 1000148017;
pub const VkBlendOp_VK_BLEND_OP_COLORBURN_EXT: VkBlendOp = 1000148018;
pub const VkBlendOp_VK_BLEND_OP_HARDLIGHT_EXT: VkBlendOp = 1000148019;
pub const VkBlendOp_VK_BLEND_OP_SOFTLIGHT_EXT: VkBlendOp = 1000148020;
pub const VkBlendOp_VK_BLEND_OP_DIFFERENCE_EXT: VkBlendOp = 1000148021;
pub const VkBlendOp_VK_BLEND_OP_EXCLUSION_EXT: VkBlendOp = 1000148022;
pub const VkBlendOp_VK_BLEND_OP_INVERT_EXT: VkBlendOp = 1000148023;
pub const VkBlendOp_VK_BLEND_OP_INVERT_RGB_EXT: VkBlendOp = 1000148024;
pub const VkBlendOp_VK_BLEND_OP_LINEARDODGE_EXT: VkBlendOp = 1000148025;
pub const VkBlendOp_VK_BLEND_OP_LINEARBURN_EXT: VkBlendOp = 1000148026;
pub const VkBlendOp_VK_BLEND_OP_VIVIDLIGHT_EXT: VkBlendOp = 1000148027;
pub const VkBlendOp_VK_BLEND_OP_LINEARLIGHT_EXT: VkBlendOp = 1000148028;
pub const VkBlendOp_VK_BLEND_OP_PINLIGHT_EXT: VkBlendOp = 1000148029;
pub const VkBlendOp_VK_BLEND_OP_HARDMIX_EXT: VkBlendOp = 1000148030;
pub const VkBlendOp_VK_BLEND_OP_HSL_HUE_EXT: VkBlendOp = 1000148031;
pub const VkBlendOp_VK_BLEND_OP_HSL_SATURATION_EXT: VkBlendOp = 1000148032;
pub const VkBlendOp_VK_BLEND_OP_HSL_COLOR_EXT: VkBlendOp = 1000148033;
pub const VkBlendOp_VK_BLEND_OP_HSL_LUMINOSITY_EXT: VkBlendOp = 1000148034;
pub const VkBlendOp_VK_BLEND_OP_PLUS_EXT: VkBlendOp = 1000148035;
pub const VkBlendOp_VK_BLEND_OP_PLUS_CLAMPED_EXT: VkBlendOp = 1000148036;
pub const VkBlendOp_VK_BLEND_OP_PLUS_CLAMPED_ALPHA_EXT: VkBlendOp = 1000148037;
pub const VkBlendOp_VK_BLEND_OP_PLUS_DARKER_EXT: VkBlendOp = 1000148038;
pub const VkBlendOp_VK_BLEND_OP_MINUS_EXT: VkBlendOp = 1000148039;
pub const VkBlendOp_VK_BLEND_OP_MINUS_CLAMPED_EXT: VkBlendOp = 1000148040;
pub const VkBlendOp_VK_BLEND_OP_CONTRAST_EXT: VkBlendOp = 1000148041;
pub const VkBlendOp_VK_BLEND_OP_INVERT_OVG_EXT: VkBlendOp = 1000148042;
pub const VkBlendOp_VK_BLEND_OP_RED_EXT: VkBlendOp = 1000148043;
pub const VkBlendOp_VK_BLEND_OP_GREEN_EXT: VkBlendOp = 1000148044;
pub const VkBlendOp_VK_BLEND_OP_BLUE_EXT: VkBlendOp = 1000148045;
pub const VkBlendOp_VK_BLEND_OP_MAX_ENUM: VkBlendOp = 2147483647;
pub type VkBlendOp = ::std::os::raw::c_uint;
pub const VkCompareOp_VK_COMPARE_OP_NEVER: VkCompareOp = 0;
pub const VkCompareOp_VK_COMPARE_OP_LESS: VkCompareOp = 1;
pub const VkCompareOp_VK_COMPARE_OP_EQUAL: VkCompareOp = 2;
pub const VkCompareOp_VK_COMPARE_OP_LESS_OR_EQUAL: VkCompareOp = 3;
pub const VkCompareOp_VK_COMPARE_OP_GREATER: VkCompareOp = 4;
pub const VkCompareOp_VK_COMPARE_OP_NOT_EQUAL: VkCompareOp = 5;
pub const VkCompareOp_VK_COMPARE_OP_GREATER_OR_EQUAL: VkCompareOp = 6;
pub const VkCompareOp_VK_COMPARE_OP_ALWAYS: VkCompareOp = 7;
pub const VkCompareOp_VK_COMPARE_OP_MAX_ENUM: VkCompareOp = 2147483647;
pub type VkCompareOp = ::std::os::raw::c_uint;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT: VkDynamicState = 0;
pub const VkDynamicState_VK_DYNAMIC_STATE_SCISSOR: VkDynamicState = 1;
pub const VkDynamicState_VK_DYNAMIC_STATE_LINE_WIDTH: VkDynamicState = 2;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_BIAS: VkDynamicState = 3;
pub const VkDynamicState_VK_DYNAMIC_STATE_BLEND_CONSTANTS: VkDynamicState = 4;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_BOUNDS: VkDynamicState = 5;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK: VkDynamicState = 6;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_WRITE_MASK: VkDynamicState = 7;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_REFERENCE: VkDynamicState = 8;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_W_SCALING_NV: VkDynamicState = 1000087000;
pub const VkDynamicState_VK_DYNAMIC_STATE_DISCARD_RECTANGLE_EXT: VkDynamicState = 1000099000;
pub const VkDynamicState_VK_DYNAMIC_STATE_SAMPLE_LOCATIONS_EXT: VkDynamicState = 1000143000;
pub const VkDynamicState_VK_DYNAMIC_STATE_RAY_TRACING_PIPELINE_STACK_SIZE_KHR: VkDynamicState =
    1000347000;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_SHADING_RATE_PALETTE_NV: VkDynamicState =
    1000164004;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_COARSE_SAMPLE_ORDER_NV: VkDynamicState =
    1000164006;
pub const VkDynamicState_VK_DYNAMIC_STATE_EXCLUSIVE_SCISSOR_NV: VkDynamicState = 1000205001;
pub const VkDynamicState_VK_DYNAMIC_STATE_FRAGMENT_SHADING_RATE_KHR: VkDynamicState = 1000226000;
pub const VkDynamicState_VK_DYNAMIC_STATE_LINE_STIPPLE_EXT: VkDynamicState = 1000259000;
pub const VkDynamicState_VK_DYNAMIC_STATE_CULL_MODE_EXT: VkDynamicState = 1000267000;
pub const VkDynamicState_VK_DYNAMIC_STATE_FRONT_FACE_EXT: VkDynamicState = 1000267001;
pub const VkDynamicState_VK_DYNAMIC_STATE_PRIMITIVE_TOPOLOGY_EXT: VkDynamicState = 1000267002;
pub const VkDynamicState_VK_DYNAMIC_STATE_VIEWPORT_WITH_COUNT_EXT: VkDynamicState = 1000267003;
pub const VkDynamicState_VK_DYNAMIC_STATE_SCISSOR_WITH_COUNT_EXT: VkDynamicState = 1000267004;
pub const VkDynamicState_VK_DYNAMIC_STATE_VERTEX_INPUT_BINDING_STRIDE_EXT: VkDynamicState =
    1000267005;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_TEST_ENABLE_EXT: VkDynamicState = 1000267006;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_WRITE_ENABLE_EXT: VkDynamicState = 1000267007;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_COMPARE_OP_EXT: VkDynamicState = 1000267008;
pub const VkDynamicState_VK_DYNAMIC_STATE_DEPTH_BOUNDS_TEST_ENABLE_EXT: VkDynamicState = 1000267009;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_TEST_ENABLE_EXT: VkDynamicState = 1000267010;
pub const VkDynamicState_VK_DYNAMIC_STATE_STENCIL_OP_EXT: VkDynamicState = 1000267011;
pub const VkDynamicState_VK_DYNAMIC_STATE_MAX_ENUM: VkDynamicState = 2147483647;
pub type VkDynamicState = ::std::os::raw::c_uint;
pub const VkFrontFace_VK_FRONT_FACE_COUNTER_CLOCKWISE: VkFrontFace = 0;
pub const VkFrontFace_VK_FRONT_FACE_CLOCKWISE: VkFrontFace = 1;
pub const VkFrontFace_VK_FRONT_FACE_MAX_ENUM: VkFrontFace = 2147483647;
pub type VkFrontFace = ::std::os::raw::c_uint;
pub const VkVertexInputRate_VK_VERTEX_INPUT_RATE_VERTEX: VkVertexInputRate = 0;
pub const VkVertexInputRate_VK_VERTEX_INPUT_RATE_INSTANCE: VkVertexInputRate = 1;
pub const VkVertexInputRate_VK_VERTEX_INPUT_RATE_MAX_ENUM: VkVertexInputRate = 2147483647;
pub type VkVertexInputRate = ::std::os::raw::c_uint;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_POINT_LIST: VkPrimitiveTopology = 0;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_LIST: VkPrimitiveTopology = 1;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_STRIP: VkPrimitiveTopology = 2;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST: VkPrimitiveTopology = 3;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP: VkPrimitiveTopology = 4;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN: VkPrimitiveTopology = 5;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY: VkPrimitiveTopology =
    6;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY: VkPrimitiveTopology =
    7;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY:
    VkPrimitiveTopology = 8;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY:
    VkPrimitiveTopology = 9;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_PATCH_LIST: VkPrimitiveTopology = 10;
pub const VkPrimitiveTopology_VK_PRIMITIVE_TOPOLOGY_MAX_ENUM: VkPrimitiveTopology = 2147483647;
pub type VkPrimitiveTopology = ::std::os::raw::c_uint;
pub const VkPolygonMode_VK_POLYGON_MODE_FILL: VkPolygonMode = 0;
pub const VkPolygonMode_VK_POLYGON_MODE_LINE: VkPolygonMode = 1;
pub const VkPolygonMode_VK_POLYGON_MODE_POINT: VkPolygonMode = 2;
pub const VkPolygonMode_VK_POLYGON_MODE_FILL_RECTANGLE_NV: VkPolygonMode = 1000153000;
pub const VkPolygonMode_VK_POLYGON_MODE_MAX_ENUM: VkPolygonMode = 2147483647;
pub type VkPolygonMode = ::std::os::raw::c_uint;
pub const VkStencilOp_VK_STENCIL_OP_KEEP: VkStencilOp = 0;
pub const VkStencilOp_VK_STENCIL_OP_ZERO: VkStencilOp = 1;
pub const VkStencilOp_VK_STENCIL_OP_REPLACE: VkStencilOp = 2;
pub const VkStencilOp_VK_STENCIL_OP_INCREMENT_AND_CLAMP: VkStencilOp = 3;
pub const VkStencilOp_VK_STENCIL_OP_DECREMENT_AND_CLAMP: VkStencilOp = 4;
pub const VkStencilOp_VK_STENCIL_OP_INVERT: VkStencilOp = 5;
pub const VkStencilOp_VK_STENCIL_OP_INCREMENT_AND_WRAP: VkStencilOp = 6;
pub const VkStencilOp_VK_STENCIL_OP_DECREMENT_AND_WRAP: VkStencilOp = 7;
pub const VkStencilOp_VK_STENCIL_OP_MAX_ENUM: VkStencilOp = 2147483647;
pub type VkStencilOp = ::std::os::raw::c_uint;
pub const VkLogicOp_VK_LOGIC_OP_CLEAR: VkLogicOp = 0;
pub const VkLogicOp_VK_LOGIC_OP_AND: VkLogicOp = 1;
pub const VkLogicOp_VK_LOGIC_OP_AND_REVERSE: VkLogicOp = 2;
pub const VkLogicOp_VK_LOGIC_OP_COPY: VkLogicOp = 3;
pub const VkLogicOp_VK_LOGIC_OP_AND_INVERTED: VkLogicOp = 4;
pub const VkLogicOp_VK_LOGIC_OP_NO_OP: VkLogicOp = 5;
pub const VkLogicOp_VK_LOGIC_OP_XOR: VkLogicOp = 6;
pub const VkLogicOp_VK_LOGIC_OP_OR: VkLogicOp = 7;
pub const VkLogicOp_VK_LOGIC_OP_NOR: VkLogicOp = 8;
pub const VkLogicOp_VK_LOGIC_OP_EQUIVALENT: VkLogicOp = 9;
pub const VkLogicOp_VK_LOGIC_OP_INVERT: VkLogicOp = 10;
pub const VkLogicOp_VK_LOGIC_OP_OR_REVERSE: VkLogicOp = 11;
pub const VkLogicOp_VK_LOGIC_OP_COPY_INVERTED: VkLogicOp = 12;
pub const VkLogicOp_VK_LOGIC_OP_OR_INVERTED: VkLogicOp = 13;
pub const VkLogicOp_VK_LOGIC_OP_NAND: VkLogicOp = 14;
pub const VkLogicOp_VK_LOGIC_OP_SET: VkLogicOp = 15;
pub const VkLogicOp_VK_LOGIC_OP_MAX_ENUM: VkLogicOp = 2147483647;
pub type VkLogicOp = ::std::os::raw::c_uint;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK: VkBorderColor = 0;
pub const VkBorderColor_VK_BORDER_COLOR_INT_TRANSPARENT_BLACK: VkBorderColor = 1;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK: VkBorderColor = 2;
pub const VkBorderColor_VK_BORDER_COLOR_INT_OPAQUE_BLACK: VkBorderColor = 3;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE: VkBorderColor = 4;
pub const VkBorderColor_VK_BORDER_COLOR_INT_OPAQUE_WHITE: VkBorderColor = 5;
pub const VkBorderColor_VK_BORDER_COLOR_FLOAT_CUSTOM_EXT: VkBorderColor = 1000287003;
pub const VkBorderColor_VK_BORDER_COLOR_INT_CUSTOM_EXT: VkBorderColor = 1000287004;
pub const VkBorderColor_VK_BORDER_COLOR_MAX_ENUM: VkBorderColor = 2147483647;
pub type VkBorderColor = ::std::os::raw::c_uint;
pub const VkFilter_VK_FILTER_NEAREST: VkFilter = 0;
pub const VkFilter_VK_FILTER_LINEAR: VkFilter = 1;
pub const VkFilter_VK_FILTER_CUBIC_IMG: VkFilter = 1000015000;
pub const VkFilter_VK_FILTER_CUBIC_EXT: VkFilter = 1000015000;
pub const VkFilter_VK_FILTER_MAX_ENUM: VkFilter = 2147483647;
pub type VkFilter = ::std::os::raw::c_uint;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_REPEAT: VkSamplerAddressMode = 0;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT: VkSamplerAddressMode = 1;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE: VkSamplerAddressMode = 2;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER: VkSamplerAddressMode = 3;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE: VkSamplerAddressMode =
    4;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE_KHR:
    VkSamplerAddressMode = 4;
pub const VkSamplerAddressMode_VK_SAMPLER_ADDRESS_MODE_MAX_ENUM: VkSamplerAddressMode = 2147483647;
pub type VkSamplerAddressMode = ::std::os::raw::c_uint;
pub const VkSamplerMipmapMode_VK_SAMPLER_MIPMAP_MODE_NEAREST: VkSamplerMipmapMode = 0;
pub const VkSamplerMipmapMode_VK_SAMPLER_MIPMAP_MODE_LINEAR: VkSamplerMipmapMode = 1;
pub const VkSamplerMipmapMode_VK_SAMPLER_MIPMAP_MODE_MAX_ENUM: VkSamplerMipmapMode = 2147483647;
pub type VkSamplerMipmapMode = ::std::os::raw::c_uint;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_SAMPLER: VkDescriptorType = 0;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER: VkDescriptorType = 1;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE: VkDescriptorType = 2;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_IMAGE: VkDescriptorType = 3;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER: VkDescriptorType = 4;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER: VkDescriptorType = 5;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER: VkDescriptorType = 6;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_BUFFER: VkDescriptorType = 7;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC: VkDescriptorType = 8;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC: VkDescriptorType = 9;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT: VkDescriptorType = 10;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_INLINE_UNIFORM_BLOCK_EXT: VkDescriptorType =
    1000138000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_KHR: VkDescriptorType =
    1000150000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_ACCELERATION_STRUCTURE_NV: VkDescriptorType =
    1000165000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_MUTABLE_VALVE: VkDescriptorType = 1000351000;
pub const VkDescriptorType_VK_DESCRIPTOR_TYPE_MAX_ENUM: VkDescriptorType = 2147483647;
pub type VkDescriptorType = ::std::os::raw::c_uint;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_LOAD: VkAttachmentLoadOp = 0;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_CLEAR: VkAttachmentLoadOp = 1;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_DONT_CARE: VkAttachmentLoadOp = 2;
pub const VkAttachmentLoadOp_VK_ATTACHMENT_LOAD_OP_MAX_ENUM: VkAttachmentLoadOp = 2147483647;
pub type VkAttachmentLoadOp = ::std::os::raw::c_uint;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_STORE: VkAttachmentStoreOp = 0;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_DONT_CARE: VkAttachmentStoreOp = 1;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_NONE_QCOM: VkAttachmentStoreOp = 1000301000;
pub const VkAttachmentStoreOp_VK_ATTACHMENT_STORE_OP_MAX_ENUM: VkAttachmentStoreOp = 2147483647;
pub type VkAttachmentStoreOp = ::std::os::raw::c_uint;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_GRAPHICS: VkPipelineBindPoint = 0;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_COMPUTE: VkPipelineBindPoint = 1;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_RAY_TRACING_KHR: VkPipelineBindPoint =
    1000165000;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_RAY_TRACING_NV: VkPipelineBindPoint =
    1000165000;
pub const VkPipelineBindPoint_VK_PIPELINE_BIND_POINT_MAX_ENUM: VkPipelineBindPoint = 2147483647;
pub type VkPipelineBindPoint = ::std::os::raw::c_uint;
pub const VkCommandBufferLevel_VK_COMMAND_BUFFER_LEVEL_PRIMARY: VkCommandBufferLevel = 0;
pub const VkCommandBufferLevel_VK_COMMAND_BUFFER_LEVEL_SECONDARY: VkCommandBufferLevel = 1;
pub const VkCommandBufferLevel_VK_COMMAND_BUFFER_LEVEL_MAX_ENUM: VkCommandBufferLevel = 2147483647;
pub type VkCommandBufferLevel = ::std::os::raw::c_uint;
pub const VkIndexType_VK_INDEX_TYPE_UINT16: VkIndexType = 0;
pub const VkIndexType_VK_INDEX_TYPE_UINT32: VkIndexType = 1;
pub const VkIndexType_VK_INDEX_TYPE_NONE_KHR: VkIndexType = 1000165000;
pub const VkIndexType_VK_INDEX_TYPE_UINT8_EXT: VkIndexType = 1000265000;
pub const VkIndexType_VK_INDEX_TYPE_NONE_NV: VkIndexType = 1000165000;
pub const VkIndexType_VK_INDEX_TYPE_MAX_ENUM: VkIndexType = 2147483647;
pub type VkIndexType = ::std::os::raw::c_uint;
pub const VkSubpassContents_VK_SUBPASS_CONTENTS_INLINE: VkSubpassContents = 0;
pub const VkSubpassContents_VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS: VkSubpassContents = 1;
pub const VkSubpassContents_VK_SUBPASS_CONTENTS_MAX_ENUM: VkSubpassContents = 2147483647;
pub type VkSubpassContents = ::std::os::raw::c_uint;
pub const VkAccessFlagBits_VK_ACCESS_INDIRECT_COMMAND_READ_BIT: VkAccessFlagBits = 1;
pub const VkAccessFlagBits_VK_ACCESS_INDEX_READ_BIT: VkAccessFlagBits = 2;
pub const VkAccessFlagBits_VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT: VkAccessFlagBits = 4;
pub const VkAccessFlagBits_VK_ACCESS_UNIFORM_READ_BIT: VkAccessFlagBits = 8;
pub const VkAccessFlagBits_VK_ACCESS_INPUT_ATTACHMENT_READ_BIT: VkAccessFlagBits = 16;
pub const VkAccessFlagBits_VK_ACCESS_SHADER_READ_BIT: VkAccessFlagBits = 32;
pub const VkAccessFlagBits_VK_ACCESS_SHADER_WRITE_BIT: VkAccessFlagBits = 64;
pub const VkAccessFlagBits_VK_ACCESS_COLOR_ATTACHMENT_READ_BIT: VkAccessFlagBits = 128;
pub const VkAccessFlagBits_VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT: VkAccessFlagBits = 256;
pub const VkAccessFlagBits_VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT: VkAccessFlagBits = 512;
pub const VkAccessFlagBits_VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT: VkAccessFlagBits = 1024;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFER_READ_BIT: VkAccessFlagBits = 2048;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFER_WRITE_BIT: VkAccessFlagBits = 4096;
pub const VkAccessFlagBits_VK_ACCESS_HOST_READ_BIT: VkAccessFlagBits = 8192;
pub const VkAccessFlagBits_VK_ACCESS_HOST_WRITE_BIT: VkAccessFlagBits = 16384;
pub const VkAccessFlagBits_VK_ACCESS_MEMORY_READ_BIT: VkAccessFlagBits = 32768;
pub const VkAccessFlagBits_VK_ACCESS_MEMORY_WRITE_BIT: VkAccessFlagBits = 65536;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFORM_FEEDBACK_WRITE_BIT_EXT: VkAccessFlagBits = 33554432;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT: VkAccessFlagBits =
    67108864;
pub const VkAccessFlagBits_VK_ACCESS_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT: VkAccessFlagBits =
    134217728;
pub const VkAccessFlagBits_VK_ACCESS_CONDITIONAL_RENDERING_READ_BIT_EXT: VkAccessFlagBits = 1048576;
pub const VkAccessFlagBits_VK_ACCESS_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT: VkAccessFlagBits =
    524288;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_KHR: VkAccessFlagBits =
    2097152;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_KHR: VkAccessFlagBits =
    4194304;
pub const VkAccessFlagBits_VK_ACCESS_SHADING_RATE_IMAGE_READ_BIT_NV: VkAccessFlagBits = 8388608;
pub const VkAccessFlagBits_VK_ACCESS_FRAGMENT_DENSITY_MAP_READ_BIT_EXT: VkAccessFlagBits = 16777216;
pub const VkAccessFlagBits_VK_ACCESS_COMMAND_PREPROCESS_READ_BIT_NV: VkAccessFlagBits = 131072;
pub const VkAccessFlagBits_VK_ACCESS_COMMAND_PREPROCESS_WRITE_BIT_NV: VkAccessFlagBits = 262144;
pub const VkAccessFlagBits_VK_ACCESS_NONE_KHR: VkAccessFlagBits = 0;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_READ_BIT_NV: VkAccessFlagBits = 2097152;
pub const VkAccessFlagBits_VK_ACCESS_ACCELERATION_STRUCTURE_WRITE_BIT_NV: VkAccessFlagBits =
    4194304;
pub const VkAccessFlagBits_VK_ACCESS_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT_KHR:
    VkAccessFlagBits = 8388608;
pub const VkAccessFlagBits_VK_ACCESS_FLAG_BITS_MAX_ENUM: VkAccessFlagBits = 2147483647;
pub type VkAccessFlagBits = ::std::os::raw::c_uint;
pub type VkAccessFlags = VkFlags;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_COLOR_BIT: VkImageAspectFlagBits = 1;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_DEPTH_BIT: VkImageAspectFlagBits = 2;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_STENCIL_BIT: VkImageAspectFlagBits = 4;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_METADATA_BIT: VkImageAspectFlagBits = 8;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_0_BIT: VkImageAspectFlagBits = 16;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_1_BIT: VkImageAspectFlagBits = 32;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_2_BIT: VkImageAspectFlagBits = 64;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT: VkImageAspectFlagBits = 128;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT: VkImageAspectFlagBits = 256;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT: VkImageAspectFlagBits = 512;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT: VkImageAspectFlagBits =
    1024;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_0_BIT_KHR: VkImageAspectFlagBits = 16;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_1_BIT_KHR: VkImageAspectFlagBits = 32;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_PLANE_2_BIT_KHR: VkImageAspectFlagBits = 64;
pub const VkImageAspectFlagBits_VK_IMAGE_ASPECT_FLAG_BITS_MAX_ENUM: VkImageAspectFlagBits =
    2147483647;
pub type VkImageAspectFlagBits = ::std::os::raw::c_uint;
pub type VkImageAspectFlags = VkFlags;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT: VkFormatFeatureFlagBits = 1;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT: VkFormatFeatureFlagBits = 2;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT:
    VkFormatFeatureFlagBits = 4;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT:
    VkFormatFeatureFlagBits = 8;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT:
    VkFormatFeatureFlagBits = 16;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT:
    VkFormatFeatureFlagBits = 32;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT: VkFormatFeatureFlagBits = 64;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT: VkFormatFeatureFlagBits =
    128;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT:
    VkFormatFeatureFlagBits = 256;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT:
    VkFormatFeatureFlagBits = 512;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_BLIT_SRC_BIT: VkFormatFeatureFlagBits = 1024;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_BLIT_DST_BIT: VkFormatFeatureFlagBits = 2048;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT:
    VkFormatFeatureFlagBits = 4096;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_SRC_BIT: VkFormatFeatureFlagBits =
    16384;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_DST_BIT: VkFormatFeatureFlagBits =
    32768;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT:
    VkFormatFeatureFlagBits = 131072;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT : VkFormatFeatureFlagBits = 262144 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT : VkFormatFeatureFlagBits = 524288 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT : VkFormatFeatureFlagBits = 1048576 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT : VkFormatFeatureFlagBits = 2097152 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_DISJOINT_BIT: VkFormatFeatureFlagBits = 4194304;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT:
    VkFormatFeatureFlagBits = 8388608;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT:
    VkFormatFeatureFlagBits = 65536;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG:
    VkFormatFeatureFlagBits = 8192;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR:
    VkFormatFeatureFlagBits = 536870912;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT:
    VkFormatFeatureFlagBits = 16777216;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkFormatFeatureFlagBits = 1073741824;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR: VkFormatFeatureFlagBits =
    16384;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR: VkFormatFeatureFlagBits =
    32768;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT:
    VkFormatFeatureFlagBits = 65536;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR:
    VkFormatFeatureFlagBits = 131072;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR : VkFormatFeatureFlagBits = 262144 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR : VkFormatFeatureFlagBits = 524288 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR : VkFormatFeatureFlagBits = 1048576 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR : VkFormatFeatureFlagBits = 2097152 ;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_DISJOINT_BIT_KHR: VkFormatFeatureFlagBits =
    4194304;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR:
    VkFormatFeatureFlagBits = 8388608;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT:
    VkFormatFeatureFlagBits = 8192;
pub const VkFormatFeatureFlagBits_VK_FORMAT_FEATURE_FLAG_BITS_MAX_ENUM: VkFormatFeatureFlagBits =
    2147483647;
pub type VkFormatFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkFormatFeatureFlags = VkFlags;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPARSE_BINDING_BIT: VkImageCreateFlagBits = 1;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT: VkImageCreateFlagBits = 2;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPARSE_ALIASED_BIT: VkImageCreateFlagBits = 4;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT: VkImageCreateFlagBits = 8;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT: VkImageCreateFlagBits = 16;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_ALIAS_BIT: VkImageCreateFlagBits = 1024;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT:
    VkImageCreateFlagBits = 64;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT: VkImageCreateFlagBits = 32;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT:
    VkImageCreateFlagBits = 128;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_EXTENDED_USAGE_BIT: VkImageCreateFlagBits = 256;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_PROTECTED_BIT: VkImageCreateFlagBits = 2048;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_DISJOINT_BIT: VkImageCreateFlagBits = 512;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_CORNER_SAMPLED_BIT_NV: VkImageCreateFlagBits = 8192;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_EXT:
    VkImageCreateFlagBits = 4096;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SUBSAMPLED_BIT_EXT: VkImageCreateFlagBits = 16384;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_KHR:
    VkImageCreateFlagBits = 64;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR: VkImageCreateFlagBits =
    32;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR:
    VkImageCreateFlagBits = 128;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR: VkImageCreateFlagBits = 256;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_DISJOINT_BIT_KHR: VkImageCreateFlagBits = 512;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_ALIAS_BIT_KHR: VkImageCreateFlagBits = 1024;
pub const VkImageCreateFlagBits_VK_IMAGE_CREATE_FLAG_BITS_MAX_ENUM: VkImageCreateFlagBits =
    2147483647;
pub type VkImageCreateFlagBits = ::std::os::raw::c_uint;
pub type VkImageCreateFlags = VkFlags;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_1_BIT: VkSampleCountFlagBits = 1;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_2_BIT: VkSampleCountFlagBits = 2;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_4_BIT: VkSampleCountFlagBits = 4;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_8_BIT: VkSampleCountFlagBits = 8;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_16_BIT: VkSampleCountFlagBits = 16;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_32_BIT: VkSampleCountFlagBits = 32;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_64_BIT: VkSampleCountFlagBits = 64;
pub const VkSampleCountFlagBits_VK_SAMPLE_COUNT_FLAG_BITS_MAX_ENUM: VkSampleCountFlagBits =
    2147483647;
pub type VkSampleCountFlagBits = ::std::os::raw::c_uint;
pub type VkSampleCountFlags = VkFlags;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_TRANSFER_SRC_BIT: VkImageUsageFlagBits = 1;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_TRANSFER_DST_BIT: VkImageUsageFlagBits = 2;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_SAMPLED_BIT: VkImageUsageFlagBits = 4;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_STORAGE_BIT: VkImageUsageFlagBits = 8;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT: VkImageUsageFlagBits = 16;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT: VkImageUsageFlagBits =
    32;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT: VkImageUsageFlagBits = 64;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT: VkImageUsageFlagBits = 128;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_SHADING_RATE_IMAGE_BIT_NV: VkImageUsageFlagBits = 256;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_FRAGMENT_DENSITY_MAP_BIT_EXT: VkImageUsageFlagBits =
    512;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkImageUsageFlagBits = 256;
pub const VkImageUsageFlagBits_VK_IMAGE_USAGE_FLAG_BITS_MAX_ENUM: VkImageUsageFlagBits = 2147483647;
pub type VkImageUsageFlagBits = ::std::os::raw::c_uint;
pub type VkImageUsageFlags = VkFlags;
pub type VkInstanceCreateFlags = VkFlags;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_DEVICE_LOCAL_BIT: VkMemoryHeapFlagBits = 1;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_MULTI_INSTANCE_BIT: VkMemoryHeapFlagBits = 2;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR: VkMemoryHeapFlagBits = 2;
pub const VkMemoryHeapFlagBits_VK_MEMORY_HEAP_FLAG_BITS_MAX_ENUM: VkMemoryHeapFlagBits = 2147483647;
pub type VkMemoryHeapFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryHeapFlags = VkFlags;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT: VkMemoryPropertyFlagBits =
    1;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT: VkMemoryPropertyFlagBits =
    2;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_HOST_COHERENT_BIT: VkMemoryPropertyFlagBits =
    4;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_HOST_CACHED_BIT: VkMemoryPropertyFlagBits = 8;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT:
    VkMemoryPropertyFlagBits = 16;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_PROTECTED_BIT: VkMemoryPropertyFlagBits = 32;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_DEVICE_COHERENT_BIT_AMD:
    VkMemoryPropertyFlagBits = 64;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_DEVICE_UNCACHED_BIT_AMD:
    VkMemoryPropertyFlagBits = 128;
pub const VkMemoryPropertyFlagBits_VK_MEMORY_PROPERTY_FLAG_BITS_MAX_ENUM: VkMemoryPropertyFlagBits =
    2147483647;
pub type VkMemoryPropertyFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryPropertyFlags = VkFlags;
pub const VkQueueFlagBits_VK_QUEUE_GRAPHICS_BIT: VkQueueFlagBits = 1;
pub const VkQueueFlagBits_VK_QUEUE_COMPUTE_BIT: VkQueueFlagBits = 2;
pub const VkQueueFlagBits_VK_QUEUE_TRANSFER_BIT: VkQueueFlagBits = 4;
pub const VkQueueFlagBits_VK_QUEUE_SPARSE_BINDING_BIT: VkQueueFlagBits = 8;
pub const VkQueueFlagBits_VK_QUEUE_PROTECTED_BIT: VkQueueFlagBits = 16;
pub const VkQueueFlagBits_VK_QUEUE_FLAG_BITS_MAX_ENUM: VkQueueFlagBits = 2147483647;
pub type VkQueueFlagBits = ::std::os::raw::c_uint;
pub type VkQueueFlags = VkFlags;
pub type VkDeviceCreateFlags = VkFlags;
pub const VkDeviceQueueCreateFlagBits_VK_DEVICE_QUEUE_CREATE_PROTECTED_BIT:
    VkDeviceQueueCreateFlagBits = 1;
pub const VkDeviceQueueCreateFlagBits_VK_DEVICE_QUEUE_CREATE_FLAG_BITS_MAX_ENUM:
    VkDeviceQueueCreateFlagBits = 2147483647;
pub type VkDeviceQueueCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDeviceQueueCreateFlags = VkFlags;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT: VkPipelineStageFlagBits = 1;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT: VkPipelineStageFlagBits = 2;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_VERTEX_INPUT_BIT: VkPipelineStageFlagBits = 4;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_VERTEX_SHADER_BIT: VkPipelineStageFlagBits = 8;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT:
    VkPipelineStageFlagBits = 16;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT:
    VkPipelineStageFlagBits = 32;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT: VkPipelineStageFlagBits =
    64;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT: VkPipelineStageFlagBits =
    128;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT:
    VkPipelineStageFlagBits = 256;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT:
    VkPipelineStageFlagBits = 512;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT:
    VkPipelineStageFlagBits = 1024;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT: VkPipelineStageFlagBits =
    2048;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TRANSFER_BIT: VkPipelineStageFlagBits = 4096;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT: VkPipelineStageFlagBits =
    8192;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_HOST_BIT: VkPipelineStageFlagBits = 16384;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT: VkPipelineStageFlagBits =
    32768;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ALL_COMMANDS_BIT: VkPipelineStageFlagBits =
    65536;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TRANSFORM_FEEDBACK_BIT_EXT:
    VkPipelineStageFlagBits = 16777216;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_CONDITIONAL_RENDERING_BIT_EXT:
    VkPipelineStageFlagBits = 262144;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_KHR:
    VkPipelineStageFlagBits = 33554432;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_KHR:
    VkPipelineStageFlagBits = 2097152;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_SHADING_RATE_IMAGE_BIT_NV:
    VkPipelineStageFlagBits = 4194304;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_TASK_SHADER_BIT_NV: VkPipelineStageFlagBits =
    524288;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_MESH_SHADER_BIT_NV: VkPipelineStageFlagBits =
    1048576;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FRAGMENT_DENSITY_PROCESS_BIT_EXT:
    VkPipelineStageFlagBits = 8388608;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_COMMAND_PREPROCESS_BIT_NV:
    VkPipelineStageFlagBits = 131072;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_NONE_KHR: VkPipelineStageFlagBits = 0;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_RAY_TRACING_SHADER_BIT_NV:
    VkPipelineStageFlagBits = 2097152;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_ACCELERATION_STRUCTURE_BUILD_BIT_NV:
    VkPipelineStageFlagBits = 33554432;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FRAGMENT_SHADING_RATE_ATTACHMENT_BIT_KHR:
    VkPipelineStageFlagBits = 4194304;
pub const VkPipelineStageFlagBits_VK_PIPELINE_STAGE_FLAG_BITS_MAX_ENUM: VkPipelineStageFlagBits =
    2147483647;
pub type VkPipelineStageFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineStageFlags = VkFlags;
pub type VkMemoryMapFlags = VkFlags;
pub const VkSparseMemoryBindFlagBits_VK_SPARSE_MEMORY_BIND_METADATA_BIT:
    VkSparseMemoryBindFlagBits = 1;
pub const VkSparseMemoryBindFlagBits_VK_SPARSE_MEMORY_BIND_FLAG_BITS_MAX_ENUM:
    VkSparseMemoryBindFlagBits = 2147483647;
pub type VkSparseMemoryBindFlagBits = ::std::os::raw::c_uint;
pub type VkSparseMemoryBindFlags = VkFlags;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT:
    VkSparseImageFormatFlagBits = 1;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT:
    VkSparseImageFormatFlagBits = 2;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT:
    VkSparseImageFormatFlagBits = 4;
pub const VkSparseImageFormatFlagBits_VK_SPARSE_IMAGE_FORMAT_FLAG_BITS_MAX_ENUM:
    VkSparseImageFormatFlagBits = 2147483647;
pub type VkSparseImageFormatFlagBits = ::std::os::raw::c_uint;
pub type VkSparseImageFormatFlags = VkFlags;
pub const VkFenceCreateFlagBits_VK_FENCE_CREATE_SIGNALED_BIT: VkFenceCreateFlagBits = 1;
pub const VkFenceCreateFlagBits_VK_FENCE_CREATE_FLAG_BITS_MAX_ENUM: VkFenceCreateFlagBits =
    2147483647;
pub type VkFenceCreateFlagBits = ::std::os::raw::c_uint;
pub type VkFenceCreateFlags = VkFlags;
pub type VkSemaphoreCreateFlags = VkFlags;
pub const VkEventCreateFlagBits_VK_EVENT_CREATE_DEVICE_ONLY_BIT_KHR: VkEventCreateFlagBits = 1;
pub const VkEventCreateFlagBits_VK_EVENT_CREATE_FLAG_BITS_MAX_ENUM: VkEventCreateFlagBits =
    2147483647;
pub type VkEventCreateFlagBits = ::std::os::raw::c_uint;
pub type VkEventCreateFlags = VkFlags;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT : VkQueryPipelineStatisticFlagBits = 1 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT : VkQueryPipelineStatisticFlagBits = 2 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 4 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 8 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT : VkQueryPipelineStatisticFlagBits = 16 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT:
    VkQueryPipelineStatisticFlagBits = 32;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT:
    VkQueryPipelineStatisticFlagBits = 64;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 128 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT : VkQueryPipelineStatisticFlagBits = 256 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 512 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT : VkQueryPipelineStatisticFlagBits = 1024 ;
pub const VkQueryPipelineStatisticFlagBits_VK_QUERY_PIPELINE_STATISTIC_FLAG_BITS_MAX_ENUM:
    VkQueryPipelineStatisticFlagBits = 2147483647;
pub type VkQueryPipelineStatisticFlagBits = ::std::os::raw::c_uint;
pub type VkQueryPipelineStatisticFlags = VkFlags;
pub type VkQueryPoolCreateFlags = VkFlags;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_64_BIT: VkQueryResultFlagBits = 1;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_WAIT_BIT: VkQueryResultFlagBits = 2;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_WITH_AVAILABILITY_BIT: VkQueryResultFlagBits = 4;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_PARTIAL_BIT: VkQueryResultFlagBits = 8;
pub const VkQueryResultFlagBits_VK_QUERY_RESULT_FLAG_BITS_MAX_ENUM: VkQueryResultFlagBits =
    2147483647;
pub type VkQueryResultFlagBits = ::std::os::raw::c_uint;
pub type VkQueryResultFlags = VkFlags;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_SPARSE_BINDING_BIT: VkBufferCreateFlagBits = 1;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT: VkBufferCreateFlagBits = 2;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_SPARSE_ALIASED_BIT: VkBufferCreateFlagBits = 4;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_PROTECTED_BIT: VkBufferCreateFlagBits = 8;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT:
    VkBufferCreateFlagBits = 16;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_EXT:
    VkBufferCreateFlagBits = 16;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR:
    VkBufferCreateFlagBits = 16;
pub const VkBufferCreateFlagBits_VK_BUFFER_CREATE_FLAG_BITS_MAX_ENUM: VkBufferCreateFlagBits =
    2147483647;
pub type VkBufferCreateFlagBits = ::std::os::raw::c_uint;
pub type VkBufferCreateFlags = VkFlags;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFER_SRC_BIT: VkBufferUsageFlagBits = 1;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFER_DST_BIT: VkBufferUsageFlagBits = 2;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT: VkBufferUsageFlagBits = 4;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT: VkBufferUsageFlagBits = 8;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT: VkBufferUsageFlagBits = 16;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_STORAGE_BUFFER_BIT: VkBufferUsageFlagBits = 32;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_INDEX_BUFFER_BIT: VkBufferUsageFlagBits = 64;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_VERTEX_BUFFER_BIT: VkBufferUsageFlagBits = 128;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT: VkBufferUsageFlagBits = 256;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT: VkBufferUsageFlagBits =
    131072;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_BUFFER_BIT_EXT:
    VkBufferUsageFlagBits = 2048;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_TRANSFORM_FEEDBACK_COUNTER_BUFFER_BIT_EXT:
    VkBufferUsageFlagBits = 4096;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_CONDITIONAL_RENDERING_BIT_EXT:
    VkBufferUsageFlagBits = 512;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_BUILD_INPUT_READ_ONLY_BIT_KHR : VkBufferUsageFlagBits = 524288 ;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_ACCELERATION_STRUCTURE_STORAGE_BIT_KHR:
    VkBufferUsageFlagBits = 1048576;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_BINDING_TABLE_BIT_KHR:
    VkBufferUsageFlagBits = 1024;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_RAY_TRACING_BIT_NV: VkBufferUsageFlagBits = 1024;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_EXT:
    VkBufferUsageFlagBits = 131072;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT_KHR:
    VkBufferUsageFlagBits = 131072;
pub const VkBufferUsageFlagBits_VK_BUFFER_USAGE_FLAG_BITS_MAX_ENUM: VkBufferUsageFlagBits =
    2147483647;
pub type VkBufferUsageFlagBits = ::std::os::raw::c_uint;
pub type VkBufferUsageFlags = VkFlags;
pub type VkBufferViewCreateFlags = VkFlags;
pub const VkImageViewCreateFlagBits_VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DYNAMIC_BIT_EXT:
    VkImageViewCreateFlagBits = 1;
pub const VkImageViewCreateFlagBits_VK_IMAGE_VIEW_CREATE_FRAGMENT_DENSITY_MAP_DEFERRED_BIT_EXT:
    VkImageViewCreateFlagBits = 2;
pub const VkImageViewCreateFlagBits_VK_IMAGE_VIEW_CREATE_FLAG_BITS_MAX_ENUM:
    VkImageViewCreateFlagBits = 2147483647;
pub type VkImageViewCreateFlagBits = ::std::os::raw::c_uint;
pub type VkImageViewCreateFlags = VkFlags;
pub const VkShaderModuleCreateFlagBits_VK_SHADER_MODULE_CREATE_FLAG_BITS_MAX_ENUM:
    VkShaderModuleCreateFlagBits = 2147483647;
pub type VkShaderModuleCreateFlagBits = ::std::os::raw::c_uint;
pub type VkShaderModuleCreateFlags = VkFlags;
pub const VkPipelineCacheCreateFlagBits_VK_PIPELINE_CACHE_CREATE_EXTERNALLY_SYNCHRONIZED_BIT_EXT:
    VkPipelineCacheCreateFlagBits = 1;
pub const VkPipelineCacheCreateFlagBits_VK_PIPELINE_CACHE_CREATE_FLAG_BITS_MAX_ENUM:
    VkPipelineCacheCreateFlagBits = 2147483647;
pub type VkPipelineCacheCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineCacheCreateFlags = VkFlags;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_R_BIT: VkColorComponentFlagBits = 1;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_G_BIT: VkColorComponentFlagBits = 2;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_B_BIT: VkColorComponentFlagBits = 4;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_A_BIT: VkColorComponentFlagBits = 8;
pub const VkColorComponentFlagBits_VK_COLOR_COMPONENT_FLAG_BITS_MAX_ENUM: VkColorComponentFlagBits =
    2147483647;
pub type VkColorComponentFlagBits = ::std::os::raw::c_uint;
pub type VkColorComponentFlags = VkFlags;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT:
    VkPipelineCreateFlagBits = 1;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT:
    VkPipelineCreateFlagBits = 2;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DERIVATIVE_BIT: VkPipelineCreateFlagBits = 4;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT:
    VkPipelineCreateFlagBits = 8;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISPATCH_BASE_BIT: VkPipelineCreateFlagBits =
    16;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_ANY_HIT_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 16384 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_CLOSEST_HIT_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 32768 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_MISS_SHADERS_BIT_KHR:
    VkPipelineCreateFlagBits = 65536;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_NO_NULL_INTERSECTION_SHADERS_BIT_KHR : VkPipelineCreateFlagBits = 131072 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_SKIP_TRIANGLES_BIT_KHR:
    VkPipelineCreateFlagBits = 4096;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_SKIP_AABBS_BIT_KHR:
    VkPipelineCreateFlagBits = 8192;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_RAY_TRACING_SHADER_GROUP_HANDLE_CAPTURE_REPLAY_BIT_KHR : VkPipelineCreateFlagBits = 524288 ;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DEFER_COMPILE_BIT_NV:
    VkPipelineCreateFlagBits = 32;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_CAPTURE_STATISTICS_BIT_KHR:
    VkPipelineCreateFlagBits = 64;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_CAPTURE_INTERNAL_REPRESENTATIONS_BIT_KHR:
    VkPipelineCreateFlagBits = 128;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_INDIRECT_BINDABLE_BIT_NV:
    VkPipelineCreateFlagBits = 262144;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_LIBRARY_BIT_KHR: VkPipelineCreateFlagBits =
    2048;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_FAIL_ON_PIPELINE_COMPILE_REQUIRED_BIT_EXT:
    VkPipelineCreateFlagBits = 256;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_EARLY_RETURN_ON_FAILURE_BIT_EXT:
    VkPipelineCreateFlagBits = 512;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISPATCH_BASE: VkPipelineCreateFlagBits = 16;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR:
    VkPipelineCreateFlagBits = 8;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_DISPATCH_BASE_KHR: VkPipelineCreateFlagBits =
    16;
pub const VkPipelineCreateFlagBits_VK_PIPELINE_CREATE_FLAG_BITS_MAX_ENUM: VkPipelineCreateFlagBits =
    2147483647;
pub type VkPipelineCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineCreateFlags = VkFlags;
pub const VkPipelineShaderStageCreateFlagBits_VK_PIPELINE_SHADER_STAGE_CREATE_ALLOW_VARYING_SUBGROUP_SIZE_BIT_EXT : VkPipelineShaderStageCreateFlagBits = 1 ;
pub const VkPipelineShaderStageCreateFlagBits_VK_PIPELINE_SHADER_STAGE_CREATE_REQUIRE_FULL_SUBGROUPS_BIT_EXT : VkPipelineShaderStageCreateFlagBits = 2 ;
pub const VkPipelineShaderStageCreateFlagBits_VK_PIPELINE_SHADER_STAGE_CREATE_FLAG_BITS_MAX_ENUM:
    VkPipelineShaderStageCreateFlagBits = 2147483647;
pub type VkPipelineShaderStageCreateFlagBits = ::std::os::raw::c_uint;
pub type VkPipelineShaderStageCreateFlags = VkFlags;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_VERTEX_BIT: VkShaderStageFlagBits = 1;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT: VkShaderStageFlagBits = 2;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT: VkShaderStageFlagBits =
    4;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_GEOMETRY_BIT: VkShaderStageFlagBits = 8;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_FRAGMENT_BIT: VkShaderStageFlagBits = 16;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_COMPUTE_BIT: VkShaderStageFlagBits = 32;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ALL_GRAPHICS: VkShaderStageFlagBits = 31;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ALL: VkShaderStageFlagBits = 2147483647;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_RAYGEN_BIT_KHR: VkShaderStageFlagBits = 256;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ANY_HIT_BIT_KHR: VkShaderStageFlagBits = 512;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CLOSEST_HIT_BIT_KHR: VkShaderStageFlagBits = 1024;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_MISS_BIT_KHR: VkShaderStageFlagBits = 2048;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_INTERSECTION_BIT_KHR: VkShaderStageFlagBits = 4096;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CALLABLE_BIT_KHR: VkShaderStageFlagBits = 8192;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_TASK_BIT_NV: VkShaderStageFlagBits = 64;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_MESH_BIT_NV: VkShaderStageFlagBits = 128;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_RAYGEN_BIT_NV: VkShaderStageFlagBits = 256;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_ANY_HIT_BIT_NV: VkShaderStageFlagBits = 512;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CLOSEST_HIT_BIT_NV: VkShaderStageFlagBits = 1024;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_MISS_BIT_NV: VkShaderStageFlagBits = 2048;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_INTERSECTION_BIT_NV: VkShaderStageFlagBits = 4096;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_CALLABLE_BIT_NV: VkShaderStageFlagBits = 8192;
pub const VkShaderStageFlagBits_VK_SHADER_STAGE_FLAG_BITS_MAX_ENUM: VkShaderStageFlagBits =
    2147483647;
pub type VkShaderStageFlagBits = ::std::os::raw::c_uint;
pub const VkCullModeFlagBits_VK_CULL_MODE_NONE: VkCullModeFlagBits = 0;
pub const VkCullModeFlagBits_VK_CULL_MODE_FRONT_BIT: VkCullModeFlagBits = 1;
pub const VkCullModeFlagBits_VK_CULL_MODE_BACK_BIT: VkCullModeFlagBits = 2;
pub const VkCullModeFlagBits_VK_CULL_MODE_FRONT_AND_BACK: VkCullModeFlagBits = 3;
pub const VkCullModeFlagBits_VK_CULL_MODE_FLAG_BITS_MAX_ENUM: VkCullModeFlagBits = 2147483647;
pub type VkCullModeFlagBits = ::std::os::raw::c_uint;
pub type VkCullModeFlags = VkFlags;
pub type VkPipelineVertexInputStateCreateFlags = VkFlags;
pub type VkPipelineInputAssemblyStateCreateFlags = VkFlags;
pub type VkPipelineTessellationStateCreateFlags = VkFlags;
pub type VkPipelineViewportStateCreateFlags = VkFlags;
pub type VkPipelineRasterizationStateCreateFlags = VkFlags;
pub type VkPipelineMultisampleStateCreateFlags = VkFlags;
pub type VkPipelineDepthStencilStateCreateFlags = VkFlags;
pub type VkPipelineColorBlendStateCreateFlags = VkFlags;
pub type VkPipelineDynamicStateCreateFlags = VkFlags;
pub type VkPipelineLayoutCreateFlags = VkFlags;
pub type VkShaderStageFlags = VkFlags;
pub const VkSamplerCreateFlagBits_VK_SAMPLER_CREATE_SUBSAMPLED_BIT_EXT: VkSamplerCreateFlagBits = 1;
pub const VkSamplerCreateFlagBits_VK_SAMPLER_CREATE_SUBSAMPLED_COARSE_RECONSTRUCTION_BIT_EXT:
    VkSamplerCreateFlagBits = 2;
pub const VkSamplerCreateFlagBits_VK_SAMPLER_CREATE_FLAG_BITS_MAX_ENUM: VkSamplerCreateFlagBits =
    2147483647;
pub type VkSamplerCreateFlagBits = ::std::os::raw::c_uint;
pub type VkSamplerCreateFlags = VkFlags;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT:
    VkDescriptorPoolCreateFlagBits = 1;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT:
    VkDescriptorPoolCreateFlagBits = 2;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_HOST_ONLY_BIT_VALVE:
    VkDescriptorPoolCreateFlagBits = 4;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT_EXT:
    VkDescriptorPoolCreateFlagBits = 2;
pub const VkDescriptorPoolCreateFlagBits_VK_DESCRIPTOR_POOL_CREATE_FLAG_BITS_MAX_ENUM:
    VkDescriptorPoolCreateFlagBits = 2147483647;
pub type VkDescriptorPoolCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorPoolCreateFlags = VkFlags;
pub type VkDescriptorPoolResetFlags = VkFlags;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT : VkDescriptorSetLayoutCreateFlagBits = 2 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR : VkDescriptorSetLayoutCreateFlagBits = 1 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_HOST_ONLY_POOL_BIT_VALVE : VkDescriptorSetLayoutCreateFlagBits = 4 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_UPDATE_AFTER_BIND_POOL_BIT_EXT : VkDescriptorSetLayoutCreateFlagBits = 2 ;
pub const VkDescriptorSetLayoutCreateFlagBits_VK_DESCRIPTOR_SET_LAYOUT_CREATE_FLAG_BITS_MAX_ENUM:
    VkDescriptorSetLayoutCreateFlagBits = 2147483647;
pub type VkDescriptorSetLayoutCreateFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorSetLayoutCreateFlags = VkFlags;
pub const VkAttachmentDescriptionFlagBits_VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT:
    VkAttachmentDescriptionFlagBits = 1;
pub const VkAttachmentDescriptionFlagBits_VK_ATTACHMENT_DESCRIPTION_FLAG_BITS_MAX_ENUM:
    VkAttachmentDescriptionFlagBits = 2147483647;
pub type VkAttachmentDescriptionFlagBits = ::std::os::raw::c_uint;
pub type VkAttachmentDescriptionFlags = VkFlags;
pub const VkDependencyFlagBits_VK_DEPENDENCY_BY_REGION_BIT: VkDependencyFlagBits = 1;
pub const VkDependencyFlagBits_VK_DEPENDENCY_DEVICE_GROUP_BIT: VkDependencyFlagBits = 4;
pub const VkDependencyFlagBits_VK_DEPENDENCY_VIEW_LOCAL_BIT: VkDependencyFlagBits = 2;
pub const VkDependencyFlagBits_VK_DEPENDENCY_VIEW_LOCAL_BIT_KHR: VkDependencyFlagBits = 2;
pub const VkDependencyFlagBits_VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR: VkDependencyFlagBits = 4;
pub const VkDependencyFlagBits_VK_DEPENDENCY_FLAG_BITS_MAX_ENUM: VkDependencyFlagBits = 2147483647;
pub type VkDependencyFlagBits = ::std::os::raw::c_uint;
pub type VkDependencyFlags = VkFlags;
pub const VkFramebufferCreateFlagBits_VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT:
    VkFramebufferCreateFlagBits = 1;
pub const VkFramebufferCreateFlagBits_VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT_KHR:
    VkFramebufferCreateFlagBits = 1;
pub const VkFramebufferCreateFlagBits_VK_FRAMEBUFFER_CREATE_FLAG_BITS_MAX_ENUM:
    VkFramebufferCreateFlagBits = 2147483647;
pub type VkFramebufferCreateFlagBits = ::std::os::raw::c_uint;
pub type VkFramebufferCreateFlags = VkFlags;
pub const VkRenderPassCreateFlagBits_VK_RENDER_PASS_CREATE_TRANSFORM_BIT_QCOM:
    VkRenderPassCreateFlagBits = 2;
pub const VkRenderPassCreateFlagBits_VK_RENDER_PASS_CREATE_FLAG_BITS_MAX_ENUM:
    VkRenderPassCreateFlagBits = 2147483647;
pub type VkRenderPassCreateFlagBits = ::std::os::raw::c_uint;
pub type VkRenderPassCreateFlags = VkFlags;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_PER_VIEW_ATTRIBUTES_BIT_NVX:
    VkSubpassDescriptionFlagBits = 1;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_PER_VIEW_POSITION_X_ONLY_BIT_NVX:
    VkSubpassDescriptionFlagBits = 2;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_FRAGMENT_REGION_BIT_QCOM:
    VkSubpassDescriptionFlagBits = 4;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_SHADER_RESOLVE_BIT_QCOM:
    VkSubpassDescriptionFlagBits = 8;
pub const VkSubpassDescriptionFlagBits_VK_SUBPASS_DESCRIPTION_FLAG_BITS_MAX_ENUM:
    VkSubpassDescriptionFlagBits = 2147483647;
pub type VkSubpassDescriptionFlagBits = ::std::os::raw::c_uint;
pub type VkSubpassDescriptionFlags = VkFlags;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_TRANSIENT_BIT:
    VkCommandPoolCreateFlagBits = 1;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT:
    VkCommandPoolCreateFlagBits = 2;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_PROTECTED_BIT:
    VkCommandPoolCreateFlagBits = 4;
pub const VkCommandPoolCreateFlagBits_VK_COMMAND_POOL_CREATE_FLAG_BITS_MAX_ENUM:
    VkCommandPoolCreateFlagBits = 2147483647;
pub type VkCommandPoolCreateFlagBits = ::std::os::raw::c_uint;
pub type VkCommandPoolCreateFlags = VkFlags;
pub const VkCommandPoolResetFlagBits_VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT:
    VkCommandPoolResetFlagBits = 1;
pub const VkCommandPoolResetFlagBits_VK_COMMAND_POOL_RESET_FLAG_BITS_MAX_ENUM:
    VkCommandPoolResetFlagBits = 2147483647;
pub type VkCommandPoolResetFlagBits = ::std::os::raw::c_uint;
pub type VkCommandPoolResetFlags = VkFlags;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT:
    VkCommandBufferUsageFlagBits = 1;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT:
    VkCommandBufferUsageFlagBits = 2;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT:
    VkCommandBufferUsageFlagBits = 4;
pub const VkCommandBufferUsageFlagBits_VK_COMMAND_BUFFER_USAGE_FLAG_BITS_MAX_ENUM:
    VkCommandBufferUsageFlagBits = 2147483647;
pub type VkCommandBufferUsageFlagBits = ::std::os::raw::c_uint;
pub type VkCommandBufferUsageFlags = VkFlags;
pub const VkQueryControlFlagBits_VK_QUERY_CONTROL_PRECISE_BIT: VkQueryControlFlagBits = 1;
pub const VkQueryControlFlagBits_VK_QUERY_CONTROL_FLAG_BITS_MAX_ENUM: VkQueryControlFlagBits =
    2147483647;
pub type VkQueryControlFlagBits = ::std::os::raw::c_uint;
pub type VkQueryControlFlags = VkFlags;
pub const VkCommandBufferResetFlagBits_VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT:
    VkCommandBufferResetFlagBits = 1;
pub const VkCommandBufferResetFlagBits_VK_COMMAND_BUFFER_RESET_FLAG_BITS_MAX_ENUM:
    VkCommandBufferResetFlagBits = 2147483647;
pub type VkCommandBufferResetFlagBits = ::std::os::raw::c_uint;
pub type VkCommandBufferResetFlags = VkFlags;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_FRONT_BIT: VkStencilFaceFlagBits = 1;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_BACK_BIT: VkStencilFaceFlagBits = 2;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_FRONT_AND_BACK: VkStencilFaceFlagBits = 3;
pub const VkStencilFaceFlagBits_VK_STENCIL_FRONT_AND_BACK: VkStencilFaceFlagBits = 3;
pub const VkStencilFaceFlagBits_VK_STENCIL_FACE_FLAG_BITS_MAX_ENUM: VkStencilFaceFlagBits =
    2147483647;
pub type VkStencilFaceFlagBits = ::std::os::raw::c_uint;
pub type VkStencilFaceFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtent2D {
    pub width: u32,
    pub height: u32,
}
#[test]
fn bindgen_test_layout_VkExtent2D() {
    assert_eq!(
        ::std::mem::size_of::<VkExtent2D>(),
        8usize,
        concat!("Size of: ", stringify!(VkExtent2D))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExtent2D>(),
        4usize,
        concat!("Alignment of ", stringify!(VkExtent2D))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExtent2D>())).width as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExtent2D),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExtent2D>())).height as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExtent2D),
            "::",
            stringify!(height)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExtent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
#[test]
fn bindgen_test_layout_VkExtent3D() {
    assert_eq!(
        ::std::mem::size_of::<VkExtent3D>(),
        12usize,
        concat!("Size of: ", stringify!(VkExtent3D))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExtent3D>(),
        4usize,
        concat!("Alignment of ", stringify!(VkExtent3D))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExtent3D>())).width as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExtent3D),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExtent3D>())).height as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExtent3D),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExtent3D>())).depth as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExtent3D),
            "::",
            stringify!(depth)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkOffset2D {
    pub x: i32,
    pub y: i32,
}
#[test]
fn bindgen_test_layout_VkOffset2D() {
    assert_eq!(
        ::std::mem::size_of::<VkOffset2D>(),
        8usize,
        concat!("Size of: ", stringify!(VkOffset2D))
    );
    assert_eq!(
        ::std::mem::align_of::<VkOffset2D>(),
        4usize,
        concat!("Alignment of ", stringify!(VkOffset2D))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkOffset2D>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkOffset2D),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkOffset2D>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkOffset2D),
            "::",
            stringify!(y)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkOffset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
#[test]
fn bindgen_test_layout_VkOffset3D() {
    assert_eq!(
        ::std::mem::size_of::<VkOffset3D>(),
        12usize,
        concat!("Size of: ", stringify!(VkOffset3D))
    );
    assert_eq!(
        ::std::mem::align_of::<VkOffset3D>(),
        4usize,
        concat!("Alignment of ", stringify!(VkOffset3D))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkOffset3D>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkOffset3D),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkOffset3D>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkOffset3D),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkOffset3D>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkOffset3D),
            "::",
            stringify!(z)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRect2D {
    pub offset: VkOffset2D,
    pub extent: VkExtent2D,
}
#[test]
fn bindgen_test_layout_VkRect2D() {
    assert_eq!(
        ::std::mem::size_of::<VkRect2D>(),
        16usize,
        concat!("Size of: ", stringify!(VkRect2D))
    );
    assert_eq!(
        ::std::mem::align_of::<VkRect2D>(),
        4usize,
        concat!("Alignment of ", stringify!(VkRect2D))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRect2D>())).offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRect2D),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRect2D>())).extent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRect2D),
            "::",
            stringify!(extent)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBaseInStructure {
    pub sType: VkStructureType,
    pub pNext: *const VkBaseInStructure,
}
#[test]
fn bindgen_test_layout_VkBaseInStructure() {
    assert_eq!(
        ::std::mem::size_of::<VkBaseInStructure>(),
        16usize,
        concat!("Size of: ", stringify!(VkBaseInStructure))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBaseInStructure>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBaseInStructure))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBaseInStructure>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBaseInStructure),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBaseInStructure>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBaseInStructure),
            "::",
            stringify!(pNext)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBaseOutStructure {
    pub sType: VkStructureType,
    pub pNext: *mut VkBaseOutStructure,
}
#[test]
fn bindgen_test_layout_VkBaseOutStructure() {
    assert_eq!(
        ::std::mem::size_of::<VkBaseOutStructure>(),
        16usize,
        concat!("Size of: ", stringify!(VkBaseOutStructure))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBaseOutStructure>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBaseOutStructure))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBaseOutStructure>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBaseOutStructure),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBaseOutStructure>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBaseOutStructure),
            "::",
            stringify!(pNext)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkBufferMemoryBarrier() {
    assert_eq!(
        ::std::mem::size_of::<VkBufferMemoryBarrier>(),
        56usize,
        concat!("Size of: ", stringify!(VkBufferMemoryBarrier))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBufferMemoryBarrier>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBufferMemoryBarrier))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).srcAccessMask as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(srcAccessMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).dstAccessMask as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(dstAccessMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).srcQueueFamilyIndex as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(srcQueueFamilyIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).dstQueueFamilyIndex as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(dstQueueFamilyIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).buffer as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).offset as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferMemoryBarrier>())).size as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryBarrier),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}
#[test]
fn bindgen_test_layout_VkDispatchIndirectCommand() {
    assert_eq!(
        ::std::mem::size_of::<VkDispatchIndirectCommand>(),
        12usize,
        concat!("Size of: ", stringify!(VkDispatchIndirectCommand))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDispatchIndirectCommand>(),
        4usize,
        concat!("Alignment of ", stringify!(VkDispatchIndirectCommand))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDispatchIndirectCommand>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDispatchIndirectCommand),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDispatchIndirectCommand>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDispatchIndirectCommand),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDispatchIndirectCommand>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDispatchIndirectCommand),
            "::",
            stringify!(z)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawIndexedIndirectCommand {
    pub indexCount: u32,
    pub instanceCount: u32,
    pub firstIndex: u32,
    pub vertexOffset: i32,
    pub firstInstance: u32,
}
#[test]
fn bindgen_test_layout_VkDrawIndexedIndirectCommand() {
    assert_eq!(
        ::std::mem::size_of::<VkDrawIndexedIndirectCommand>(),
        20usize,
        concat!("Size of: ", stringify!(VkDrawIndexedIndirectCommand))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDrawIndexedIndirectCommand>(),
        4usize,
        concat!("Alignment of ", stringify!(VkDrawIndexedIndirectCommand))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndexedIndirectCommand>())).indexCount as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndexedIndirectCommand),
            "::",
            stringify!(indexCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndexedIndirectCommand>())).instanceCount as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndexedIndirectCommand),
            "::",
            stringify!(instanceCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndexedIndirectCommand>())).firstIndex as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndexedIndirectCommand),
            "::",
            stringify!(firstIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndexedIndirectCommand>())).vertexOffset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndexedIndirectCommand),
            "::",
            stringify!(vertexOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndexedIndirectCommand>())).firstInstance as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndexedIndirectCommand),
            "::",
            stringify!(firstInstance)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDrawIndirectCommand {
    pub vertexCount: u32,
    pub instanceCount: u32,
    pub firstVertex: u32,
    pub firstInstance: u32,
}
#[test]
fn bindgen_test_layout_VkDrawIndirectCommand() {
    assert_eq!(
        ::std::mem::size_of::<VkDrawIndirectCommand>(),
        16usize,
        concat!("Size of: ", stringify!(VkDrawIndirectCommand))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDrawIndirectCommand>(),
        4usize,
        concat!("Alignment of ", stringify!(VkDrawIndirectCommand))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndirectCommand>())).vertexCount as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndirectCommand),
            "::",
            stringify!(vertexCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndirectCommand>())).instanceCount as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndirectCommand),
            "::",
            stringify!(instanceCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndirectCommand>())).firstVertex as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndirectCommand),
            "::",
            stringify!(firstVertex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDrawIndirectCommand>())).firstInstance as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDrawIndirectCommand),
            "::",
            stringify!(firstInstance)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresourceRange {
    pub aspectMask: VkImageAspectFlags,
    pub baseMipLevel: u32,
    pub levelCount: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[test]
fn bindgen_test_layout_VkImageSubresourceRange() {
    assert_eq!(
        ::std::mem::size_of::<VkImageSubresourceRange>(),
        20usize,
        concat!("Size of: ", stringify!(VkImageSubresourceRange))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageSubresourceRange>(),
        4usize,
        concat!("Alignment of ", stringify!(VkImageSubresourceRange))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceRange>())).aspectMask as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceRange),
            "::",
            stringify!(aspectMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceRange>())).baseMipLevel as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceRange),
            "::",
            stringify!(baseMipLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceRange>())).levelCount as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceRange),
            "::",
            stringify!(levelCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceRange>())).baseArrayLayer as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceRange),
            "::",
            stringify!(baseArrayLayer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceRange>())).layerCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceRange),
            "::",
            stringify!(layerCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub oldLayout: VkImageLayout,
    pub newLayout: VkImageLayout,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub image: VkImage,
    pub subresourceRange: VkImageSubresourceRange,
}
#[test]
fn bindgen_test_layout_VkImageMemoryBarrier() {
    assert_eq!(
        ::std::mem::size_of::<VkImageMemoryBarrier>(),
        72usize,
        concat!("Size of: ", stringify!(VkImageMemoryBarrier))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageMemoryBarrier>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageMemoryBarrier))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageMemoryBarrier>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageMemoryBarrier>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryBarrier>())).srcAccessMask as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(srcAccessMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryBarrier>())).dstAccessMask as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(dstAccessMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageMemoryBarrier>())).oldLayout as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(oldLayout)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageMemoryBarrier>())).newLayout as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(newLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryBarrier>())).srcQueueFamilyIndex as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(srcQueueFamilyIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryBarrier>())).dstQueueFamilyIndex as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(dstQueueFamilyIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageMemoryBarrier>())).image as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryBarrier>())).subresourceRange as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryBarrier),
            "::",
            stringify!(subresourceRange)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryBarrier {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
}
#[test]
fn bindgen_test_layout_VkMemoryBarrier() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryBarrier>(),
        24usize,
        concat!("Size of: ", stringify!(VkMemoryBarrier))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryBarrier>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryBarrier))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryBarrier>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryBarrier),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryBarrier>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryBarrier),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryBarrier>())).srcAccessMask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryBarrier),
            "::",
            stringify!(srcAccessMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryBarrier>())).dstAccessMask as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryBarrier),
            "::",
            stringify!(dstAccessMask)
        )
    );
}
pub type PFN_vkAllocationFunction = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        alignment: size_t,
        allocationScope: VkSystemAllocationScope,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type PFN_vkFreeFunction = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        pMemory: *mut ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkInternalAllocationNotification = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        allocationType: VkInternalAllocationType,
        allocationScope: VkSystemAllocationScope,
    ),
>;
pub type PFN_vkInternalFreeNotification = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        size: size_t,
        allocationType: VkInternalAllocationType,
        allocationScope: VkSystemAllocationScope,
    ),
>;
pub type PFN_vkReallocationFunction = ::std::option::Option<
    unsafe extern "C" fn(
        pUserData: *mut ::std::os::raw::c_void,
        pOriginal: *mut ::std::os::raw::c_void,
        size: size_t,
        alignment: size_t,
        allocationScope: VkSystemAllocationScope,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type PFN_vkVoidFunction = ::std::option::Option<unsafe extern "C" fn()>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAllocationCallbacks {
    pub pUserData: *mut ::std::os::raw::c_void,
    pub pfnAllocation: PFN_vkAllocationFunction,
    pub pfnReallocation: PFN_vkReallocationFunction,
    pub pfnFree: PFN_vkFreeFunction,
    pub pfnInternalAllocation: PFN_vkInternalAllocationNotification,
    pub pfnInternalFree: PFN_vkInternalFreeNotification,
}
#[test]
fn bindgen_test_layout_VkAllocationCallbacks() {
    assert_eq!(
        ::std::mem::size_of::<VkAllocationCallbacks>(),
        48usize,
        concat!("Size of: ", stringify!(VkAllocationCallbacks))
    );
    assert_eq!(
        ::std::mem::align_of::<VkAllocationCallbacks>(),
        8usize,
        concat!("Alignment of ", stringify!(VkAllocationCallbacks))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAllocationCallbacks>())).pUserData as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAllocationCallbacks),
            "::",
            stringify!(pUserData)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAllocationCallbacks>())).pfnAllocation as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAllocationCallbacks),
            "::",
            stringify!(pfnAllocation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAllocationCallbacks>())).pfnReallocation as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAllocationCallbacks),
            "::",
            stringify!(pfnReallocation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAllocationCallbacks>())).pfnFree as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAllocationCallbacks),
            "::",
            stringify!(pfnFree)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAllocationCallbacks>())).pfnInternalAllocation as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAllocationCallbacks),
            "::",
            stringify!(pfnInternalAllocation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAllocationCallbacks>())).pfnInternalFree as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAllocationCallbacks),
            "::",
            stringify!(pfnInternalFree)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkApplicationInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub pApplicationName: *const ::std::os::raw::c_char,
    pub applicationVersion: u32,
    pub pEngineName: *const ::std::os::raw::c_char,
    pub engineVersion: u32,
    pub apiVersion: u32,
}
#[test]
fn bindgen_test_layout_VkApplicationInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkApplicationInfo>(),
        48usize,
        concat!("Size of: ", stringify!(VkApplicationInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkApplicationInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkApplicationInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkApplicationInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkApplicationInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkApplicationInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkApplicationInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkApplicationInfo>())).pApplicationName as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkApplicationInfo),
            "::",
            stringify!(pApplicationName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkApplicationInfo>())).applicationVersion as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkApplicationInfo),
            "::",
            stringify!(applicationVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkApplicationInfo>())).pEngineName as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkApplicationInfo),
            "::",
            stringify!(pEngineName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkApplicationInfo>())).engineVersion as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkApplicationInfo),
            "::",
            stringify!(engineVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkApplicationInfo>())).apiVersion as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkApplicationInfo),
            "::",
            stringify!(apiVersion)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFormatProperties {
    pub linearTilingFeatures: VkFormatFeatureFlags,
    pub optimalTilingFeatures: VkFormatFeatureFlags,
    pub bufferFeatures: VkFormatFeatureFlags,
}
#[test]
fn bindgen_test_layout_VkFormatProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkFormatProperties>(),
        12usize,
        concat!("Size of: ", stringify!(VkFormatProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkFormatProperties>(),
        4usize,
        concat!("Alignment of ", stringify!(VkFormatProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFormatProperties>())).linearTilingFeatures as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFormatProperties),
            "::",
            stringify!(linearTilingFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFormatProperties>())).optimalTilingFeatures as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFormatProperties),
            "::",
            stringify!(optimalTilingFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFormatProperties>())).bufferFeatures as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFormatProperties),
            "::",
            stringify!(bufferFeatures)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatProperties {
    pub maxExtent: VkExtent3D,
    pub maxMipLevels: u32,
    pub maxArrayLayers: u32,
    pub sampleCounts: VkSampleCountFlags,
    pub maxResourceSize: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkImageFormatProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkImageFormatProperties>(),
        32usize,
        concat!("Size of: ", stringify!(VkImageFormatProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageFormatProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageFormatProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatProperties>())).maxExtent as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties),
            "::",
            stringify!(maxExtent)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatProperties>())).maxMipLevels as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties),
            "::",
            stringify!(maxMipLevels)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatProperties>())).maxArrayLayers as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties),
            "::",
            stringify!(maxArrayLayers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatProperties>())).sampleCounts as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties),
            "::",
            stringify!(sampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatProperties>())).maxResourceSize as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties),
            "::",
            stringify!(maxResourceSize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInstanceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkInstanceCreateFlags,
    pub pApplicationInfo: *const VkApplicationInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const ::std::os::raw::c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_VkInstanceCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkInstanceCreateInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VkInstanceCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkInstanceCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkInstanceCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkInstanceCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkInstanceCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkInstanceCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInstanceCreateInfo>())).pApplicationInfo as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(pApplicationInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInstanceCreateInfo>())).enabledLayerCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(enabledLayerCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInstanceCreateInfo>())).ppEnabledLayerNames as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(ppEnabledLayerNames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInstanceCreateInfo>())).enabledExtensionCount as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(enabledExtensionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInstanceCreateInfo>())).ppEnabledExtensionNames as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInstanceCreateInfo),
            "::",
            stringify!(ppEnabledExtensionNames)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryHeap {
    pub size: VkDeviceSize,
    pub flags: VkMemoryHeapFlags,
}
#[test]
fn bindgen_test_layout_VkMemoryHeap() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryHeap>(),
        16usize,
        concat!("Size of: ", stringify!(VkMemoryHeap))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryHeap>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryHeap))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryHeap>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryHeap),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryHeap>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryHeap),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryType {
    pub propertyFlags: VkMemoryPropertyFlags,
    pub heapIndex: u32,
}
#[test]
fn bindgen_test_layout_VkMemoryType() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryType>(),
        8usize,
        concat!("Size of: ", stringify!(VkMemoryType))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryType>(),
        4usize,
        concat!("Alignment of ", stringify!(VkMemoryType))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryType>())).propertyFlags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryType),
            "::",
            stringify!(propertyFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryType>())).heapIndex as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryType),
            "::",
            stringify!(heapIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFeatures {
    pub robustBufferAccess: VkBool32,
    pub fullDrawIndexUint32: VkBool32,
    pub imageCubeArray: VkBool32,
    pub independentBlend: VkBool32,
    pub geometryShader: VkBool32,
    pub tessellationShader: VkBool32,
    pub sampleRateShading: VkBool32,
    pub dualSrcBlend: VkBool32,
    pub logicOp: VkBool32,
    pub multiDrawIndirect: VkBool32,
    pub drawIndirectFirstInstance: VkBool32,
    pub depthClamp: VkBool32,
    pub depthBiasClamp: VkBool32,
    pub fillModeNonSolid: VkBool32,
    pub depthBounds: VkBool32,
    pub wideLines: VkBool32,
    pub largePoints: VkBool32,
    pub alphaToOne: VkBool32,
    pub multiViewport: VkBool32,
    pub samplerAnisotropy: VkBool32,
    pub textureCompressionETC2: VkBool32,
    pub textureCompressionASTC_LDR: VkBool32,
    pub textureCompressionBC: VkBool32,
    pub occlusionQueryPrecise: VkBool32,
    pub pipelineStatisticsQuery: VkBool32,
    pub vertexPipelineStoresAndAtomics: VkBool32,
    pub fragmentStoresAndAtomics: VkBool32,
    pub shaderTessellationAndGeometryPointSize: VkBool32,
    pub shaderImageGatherExtended: VkBool32,
    pub shaderStorageImageExtendedFormats: VkBool32,
    pub shaderStorageImageMultisample: VkBool32,
    pub shaderStorageImageReadWithoutFormat: VkBool32,
    pub shaderStorageImageWriteWithoutFormat: VkBool32,
    pub shaderUniformBufferArrayDynamicIndexing: VkBool32,
    pub shaderSampledImageArrayDynamicIndexing: VkBool32,
    pub shaderStorageBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageImageArrayDynamicIndexing: VkBool32,
    pub shaderClipDistance: VkBool32,
    pub shaderCullDistance: VkBool32,
    pub shaderFloat64: VkBool32,
    pub shaderInt64: VkBool32,
    pub shaderInt16: VkBool32,
    pub shaderResourceResidency: VkBool32,
    pub shaderResourceMinLod: VkBool32,
    pub sparseBinding: VkBool32,
    pub sparseResidencyBuffer: VkBool32,
    pub sparseResidencyImage2D: VkBool32,
    pub sparseResidencyImage3D: VkBool32,
    pub sparseResidency2Samples: VkBool32,
    pub sparseResidency4Samples: VkBool32,
    pub sparseResidency8Samples: VkBool32,
    pub sparseResidency16Samples: VkBool32,
    pub sparseResidencyAliased: VkBool32,
    pub variableMultisampleRate: VkBool32,
    pub inheritedQueries: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceFeatures>(),
        220usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceFeatures))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceFeatures>(),
        4usize,
        concat!("Alignment of ", stringify!(VkPhysicalDeviceFeatures))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).robustBufferAccess as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(robustBufferAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).fullDrawIndexUint32 as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(fullDrawIndexUint32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).imageCubeArray as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(imageCubeArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).independentBlend as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(independentBlend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).geometryShader as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(geometryShader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).tessellationShader as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(tessellationShader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sampleRateShading as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sampleRateShading)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).dualSrcBlend as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(dualSrcBlend)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).logicOp as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(logicOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).multiDrawIndirect as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(multiDrawIndirect)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).drawIndirectFirstInstance
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(drawIndirectFirstInstance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).depthClamp as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(depthClamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).depthBiasClamp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(depthBiasClamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).fillModeNonSolid as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(fillModeNonSolid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).depthBounds as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(depthBounds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).wideLines as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(wideLines)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).largePoints as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(largePoints)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).alphaToOne as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(alphaToOne)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).multiViewport as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(multiViewport)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).samplerAnisotropy as *const _
                as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(samplerAnisotropy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).textureCompressionETC2 as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(textureCompressionETC2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).textureCompressionASTC_LDR
                as *const _ as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(textureCompressionASTC_LDR)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).textureCompressionBC as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(textureCompressionBC)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).occlusionQueryPrecise as *const _
                as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(occlusionQueryPrecise)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).pipelineStatisticsQuery as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(pipelineStatisticsQuery)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).vertexPipelineStoresAndAtomics
                as *const _ as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(vertexPipelineStoresAndAtomics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).fragmentStoresAndAtomics
                as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(fragmentStoresAndAtomics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>()))
                .shaderTessellationAndGeometryPointSize as *const _ as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderTessellationAndGeometryPointSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderImageGatherExtended
                as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderImageGatherExtended)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderStorageImageExtendedFormats
                as *const _ as usize
        },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderStorageImageExtendedFormats)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderStorageImageMultisample
                as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderStorageImageMultisample)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderStorageImageReadWithoutFormat
                as *const _ as usize
        },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderStorageImageReadWithoutFormat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>()))
                .shaderStorageImageWriteWithoutFormat as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderStorageImageWriteWithoutFormat)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>()))
                .shaderUniformBufferArrayDynamicIndexing as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderUniformBufferArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>()))
                .shaderSampledImageArrayDynamicIndexing as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderSampledImageArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>()))
                .shaderStorageBufferArrayDynamicIndexing as *const _ as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderStorageBufferArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>()))
                .shaderStorageImageArrayDynamicIndexing as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderStorageImageArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderClipDistance as *const _
                as usize
        },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderClipDistance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderCullDistance as *const _
                as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderCullDistance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderFloat64 as *const _ as usize
        },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderInt64 as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderInt64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderInt16 as *const _ as usize
        },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderInt16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderResourceResidency as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderResourceResidency)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).shaderResourceMinLod as *const _
                as usize
        },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(shaderResourceMinLod)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseBinding as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseBinding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidencyBuffer as *const _
                as usize
        },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidencyBuffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidencyImage2D as *const _
                as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidencyImage2D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidencyImage3D as *const _
                as usize
        },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidencyImage3D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidency2Samples as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidency2Samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidency4Samples as *const _
                as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidency4Samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidency8Samples as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidency8Samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidency16Samples
                as *const _ as usize
        },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidency16Samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).sparseResidencyAliased as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(sparseResidencyAliased)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).variableMultisampleRate as *const _
                as usize
        },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(variableMultisampleRate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures>())).inheritedQueries as *const _
                as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures),
            "::",
            stringify!(inheritedQueries)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceLimits {
    pub maxImageDimension1D: u32,
    pub maxImageDimension2D: u32,
    pub maxImageDimension3D: u32,
    pub maxImageDimensionCube: u32,
    pub maxImageArrayLayers: u32,
    pub maxTexelBufferElements: u32,
    pub maxUniformBufferRange: u32,
    pub maxStorageBufferRange: u32,
    pub maxPushConstantsSize: u32,
    pub maxMemoryAllocationCount: u32,
    pub maxSamplerAllocationCount: u32,
    pub bufferImageGranularity: VkDeviceSize,
    pub sparseAddressSpaceSize: VkDeviceSize,
    pub maxBoundDescriptorSets: u32,
    pub maxPerStageDescriptorSamplers: u32,
    pub maxPerStageDescriptorUniformBuffers: u32,
    pub maxPerStageDescriptorStorageBuffers: u32,
    pub maxPerStageDescriptorSampledImages: u32,
    pub maxPerStageDescriptorStorageImages: u32,
    pub maxPerStageDescriptorInputAttachments: u32,
    pub maxPerStageResources: u32,
    pub maxDescriptorSetSamplers: u32,
    pub maxDescriptorSetUniformBuffers: u32,
    pub maxDescriptorSetUniformBuffersDynamic: u32,
    pub maxDescriptorSetStorageBuffers: u32,
    pub maxDescriptorSetStorageBuffersDynamic: u32,
    pub maxDescriptorSetSampledImages: u32,
    pub maxDescriptorSetStorageImages: u32,
    pub maxDescriptorSetInputAttachments: u32,
    pub maxVertexInputAttributes: u32,
    pub maxVertexInputBindings: u32,
    pub maxVertexInputAttributeOffset: u32,
    pub maxVertexInputBindingStride: u32,
    pub maxVertexOutputComponents: u32,
    pub maxTessellationGenerationLevel: u32,
    pub maxTessellationPatchSize: u32,
    pub maxTessellationControlPerVertexInputComponents: u32,
    pub maxTessellationControlPerVertexOutputComponents: u32,
    pub maxTessellationControlPerPatchOutputComponents: u32,
    pub maxTessellationControlTotalOutputComponents: u32,
    pub maxTessellationEvaluationInputComponents: u32,
    pub maxTessellationEvaluationOutputComponents: u32,
    pub maxGeometryShaderInvocations: u32,
    pub maxGeometryInputComponents: u32,
    pub maxGeometryOutputComponents: u32,
    pub maxGeometryOutputVertices: u32,
    pub maxGeometryTotalOutputComponents: u32,
    pub maxFragmentInputComponents: u32,
    pub maxFragmentOutputAttachments: u32,
    pub maxFragmentDualSrcAttachments: u32,
    pub maxFragmentCombinedOutputResources: u32,
    pub maxComputeSharedMemorySize: u32,
    pub maxComputeWorkGroupCount: [u32; 3usize],
    pub maxComputeWorkGroupInvocations: u32,
    pub maxComputeWorkGroupSize: [u32; 3usize],
    pub subPixelPrecisionBits: u32,
    pub subTexelPrecisionBits: u32,
    pub mipmapPrecisionBits: u32,
    pub maxDrawIndexedIndexValue: u32,
    pub maxDrawIndirectCount: u32,
    pub maxSamplerLodBias: f32,
    pub maxSamplerAnisotropy: f32,
    pub maxViewports: u32,
    pub maxViewportDimensions: [u32; 2usize],
    pub viewportBoundsRange: [f32; 2usize],
    pub viewportSubPixelBits: u32,
    pub minMemoryMapAlignment: size_t,
    pub minTexelBufferOffsetAlignment: VkDeviceSize,
    pub minUniformBufferOffsetAlignment: VkDeviceSize,
    pub minStorageBufferOffsetAlignment: VkDeviceSize,
    pub minTexelOffset: i32,
    pub maxTexelOffset: u32,
    pub minTexelGatherOffset: i32,
    pub maxTexelGatherOffset: u32,
    pub minInterpolationOffset: f32,
    pub maxInterpolationOffset: f32,
    pub subPixelInterpolationOffsetBits: u32,
    pub maxFramebufferWidth: u32,
    pub maxFramebufferHeight: u32,
    pub maxFramebufferLayers: u32,
    pub framebufferColorSampleCounts: VkSampleCountFlags,
    pub framebufferDepthSampleCounts: VkSampleCountFlags,
    pub framebufferStencilSampleCounts: VkSampleCountFlags,
    pub framebufferNoAttachmentsSampleCounts: VkSampleCountFlags,
    pub maxColorAttachments: u32,
    pub sampledImageColorSampleCounts: VkSampleCountFlags,
    pub sampledImageIntegerSampleCounts: VkSampleCountFlags,
    pub sampledImageDepthSampleCounts: VkSampleCountFlags,
    pub sampledImageStencilSampleCounts: VkSampleCountFlags,
    pub storageImageSampleCounts: VkSampleCountFlags,
    pub maxSampleMaskWords: u32,
    pub timestampComputeAndGraphics: VkBool32,
    pub timestampPeriod: f32,
    pub maxClipDistances: u32,
    pub maxCullDistances: u32,
    pub maxCombinedClipAndCullDistances: u32,
    pub discreteQueuePriorities: u32,
    pub pointSizeRange: [f32; 2usize],
    pub lineWidthRange: [f32; 2usize],
    pub pointSizeGranularity: f32,
    pub lineWidthGranularity: f32,
    pub strictLines: VkBool32,
    pub standardSampleLocations: VkBool32,
    pub optimalBufferCopyOffsetAlignment: VkDeviceSize,
    pub optimalBufferCopyRowPitchAlignment: VkDeviceSize,
    pub nonCoherentAtomSize: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceLimits() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceLimits>(),
        504usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceLimits))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceLimits>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPhysicalDeviceLimits))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxImageDimension1D as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxImageDimension1D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxImageDimension2D as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxImageDimension2D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxImageDimension3D as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxImageDimension3D)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxImageDimensionCube as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxImageDimensionCube)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxImageArrayLayers as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxImageArrayLayers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxTexelBufferElements as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTexelBufferElements)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxUniformBufferRange as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxUniformBufferRange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxStorageBufferRange as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxStorageBufferRange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPushConstantsSize as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPushConstantsSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxMemoryAllocationCount as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxMemoryAllocationCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxSamplerAllocationCount as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxSamplerAllocationCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).bufferImageGranularity as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(bufferImageGranularity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).sparseAddressSpaceSize as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(sparseAddressSpaceSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxBoundDescriptorSets as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxBoundDescriptorSets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPerStageDescriptorSamplers
                as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPerStageDescriptorSamplers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPerStageDescriptorUniformBuffers
                as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPerStageDescriptorUniformBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPerStageDescriptorStorageBuffers
                as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPerStageDescriptorStorageBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPerStageDescriptorSampledImages
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPerStageDescriptorSampledImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPerStageDescriptorStorageImages
                as *const _ as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPerStageDescriptorStorageImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPerStageDescriptorInputAttachments
                as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPerStageDescriptorInputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxPerStageResources as *const _
                as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxPerStageResources)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetSamplers as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetSamplers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetUniformBuffers
                as *const _ as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetUniformBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetUniformBuffersDynamic
                as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetUniformBuffersDynamic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetStorageBuffers
                as *const _ as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetStorageBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetStorageBuffersDynamic
                as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetStorageBuffersDynamic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetSampledImages
                as *const _ as usize
        },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetSampledImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetStorageImages
                as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetStorageImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDescriptorSetInputAttachments
                as *const _ as usize
        },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDescriptorSetInputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxVertexInputAttributes as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxVertexInputAttributes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxVertexInputBindings as *const _
                as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxVertexInputBindings)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxVertexInputAttributeOffset
                as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxVertexInputAttributeOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxVertexInputBindingStride
                as *const _ as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxVertexInputBindingStride)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxVertexOutputComponents as *const _
                as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxVertexOutputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxTessellationGenerationLevel
                as *const _ as usize
        },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationGenerationLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxTessellationPatchSize as *const _
                as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationPatchSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>()))
                .maxTessellationControlPerVertexInputComponents as *const _ as usize
        },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationControlPerVertexInputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>()))
                .maxTessellationControlPerVertexOutputComponents as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationControlPerVertexOutputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>()))
                .maxTessellationControlPerPatchOutputComponents as *const _ as usize
        },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationControlPerPatchOutputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>()))
                .maxTessellationControlTotalOutputComponents as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationControlTotalOutputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>()))
                .maxTessellationEvaluationInputComponents as *const _ as usize
        },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationEvaluationInputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>()))
                .maxTessellationEvaluationOutputComponents as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTessellationEvaluationOutputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxGeometryShaderInvocations
                as *const _ as usize
        },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxGeometryShaderInvocations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxGeometryInputComponents
                as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxGeometryInputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxGeometryOutputComponents
                as *const _ as usize
        },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxGeometryOutputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxGeometryOutputVertices as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxGeometryOutputVertices)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxGeometryTotalOutputComponents
                as *const _ as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxGeometryTotalOutputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxFragmentInputComponents
                as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxFragmentInputComponents)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxFragmentOutputAttachments
                as *const _ as usize
        },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxFragmentOutputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxFragmentDualSrcAttachments
                as *const _ as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxFragmentDualSrcAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxFragmentCombinedOutputResources
                as *const _ as usize
        },
        212usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxFragmentCombinedOutputResources)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxComputeSharedMemorySize
                as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxComputeSharedMemorySize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxComputeWorkGroupCount as *const _
                as usize
        },
        220usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxComputeWorkGroupCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxComputeWorkGroupInvocations
                as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxComputeWorkGroupInvocations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxComputeWorkGroupSize as *const _
                as usize
        },
        236usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxComputeWorkGroupSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).subPixelPrecisionBits as *const _
                as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(subPixelPrecisionBits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).subTexelPrecisionBits as *const _
                as usize
        },
        252usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(subTexelPrecisionBits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).mipmapPrecisionBits as *const _
                as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(mipmapPrecisionBits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDrawIndexedIndexValue as *const _
                as usize
        },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDrawIndexedIndexValue)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxDrawIndirectCount as *const _
                as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxDrawIndirectCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxSamplerLodBias as *const _
                as usize
        },
        268usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxSamplerLodBias)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxSamplerAnisotropy as *const _
                as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxSamplerAnisotropy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxViewports as *const _ as usize
        },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxViewports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxViewportDimensions as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxViewportDimensions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).viewportBoundsRange as *const _
                as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(viewportBoundsRange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).viewportSubPixelBits as *const _
                as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(viewportSubPixelBits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).minMemoryMapAlignment as *const _
                as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(minMemoryMapAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).minTexelBufferOffsetAlignment
                as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(minTexelBufferOffsetAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).minUniformBufferOffsetAlignment
                as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(minUniformBufferOffsetAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).minStorageBufferOffsetAlignment
                as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(minStorageBufferOffsetAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).minTexelOffset as *const _ as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(minTexelOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxTexelOffset as *const _ as usize
        },
        340usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTexelOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).minTexelGatherOffset as *const _
                as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(minTexelGatherOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxTexelGatherOffset as *const _
                as usize
        },
        348usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxTexelGatherOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).minInterpolationOffset as *const _
                as usize
        },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(minInterpolationOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxInterpolationOffset as *const _
                as usize
        },
        356usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxInterpolationOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).subPixelInterpolationOffsetBits
                as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(subPixelInterpolationOffsetBits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxFramebufferWidth as *const _
                as usize
        },
        364usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxFramebufferWidth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxFramebufferHeight as *const _
                as usize
        },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxFramebufferHeight)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxFramebufferLayers as *const _
                as usize
        },
        372usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxFramebufferLayers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).framebufferColorSampleCounts
                as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(framebufferColorSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).framebufferDepthSampleCounts
                as *const _ as usize
        },
        380usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(framebufferDepthSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).framebufferStencilSampleCounts
                as *const _ as usize
        },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(framebufferStencilSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).framebufferNoAttachmentsSampleCounts
                as *const _ as usize
        },
        388usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(framebufferNoAttachmentsSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxColorAttachments as *const _
                as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxColorAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).sampledImageColorSampleCounts
                as *const _ as usize
        },
        396usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(sampledImageColorSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).sampledImageIntegerSampleCounts
                as *const _ as usize
        },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(sampledImageIntegerSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).sampledImageDepthSampleCounts
                as *const _ as usize
        },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(sampledImageDepthSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).sampledImageStencilSampleCounts
                as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(sampledImageStencilSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).storageImageSampleCounts as *const _
                as usize
        },
        412usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(storageImageSampleCounts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxSampleMaskWords as *const _
                as usize
        },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxSampleMaskWords)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).timestampComputeAndGraphics
                as *const _ as usize
        },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(timestampComputeAndGraphics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).timestampPeriod as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(timestampPeriod)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxClipDistances as *const _ as usize
        },
        428usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxClipDistances)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxCullDistances as *const _ as usize
        },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxCullDistances)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).maxCombinedClipAndCullDistances
                as *const _ as usize
        },
        436usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(maxCombinedClipAndCullDistances)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).discreteQueuePriorities as *const _
                as usize
        },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(discreteQueuePriorities)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).pointSizeRange as *const _ as usize
        },
        444usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(pointSizeRange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).lineWidthRange as *const _ as usize
        },
        452usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(lineWidthRange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).pointSizeGranularity as *const _
                as usize
        },
        460usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(pointSizeGranularity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).lineWidthGranularity as *const _
                as usize
        },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(lineWidthGranularity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).strictLines as *const _ as usize
        },
        468usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(strictLines)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).standardSampleLocations as *const _
                as usize
        },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(standardSampleLocations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).optimalBufferCopyOffsetAlignment
                as *const _ as usize
        },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(optimalBufferCopyOffsetAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).optimalBufferCopyRowPitchAlignment
                as *const _ as usize
        },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(optimalBufferCopyRowPitchAlignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceLimits>())).nonCoherentAtomSize as *const _
                as usize
        },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceLimits),
            "::",
            stringify!(nonCoherentAtomSize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryProperties {
    pub memoryTypeCount: u32,
    pub memoryTypes: [VkMemoryType; 32usize],
    pub memoryHeapCount: u32,
    pub memoryHeaps: [VkMemoryHeap; 16usize],
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceMemoryProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceMemoryProperties>(),
        520usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceMemoryProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceMemoryProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceMemoryProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMemoryProperties>())).memoryTypeCount as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMemoryProperties),
            "::",
            stringify!(memoryTypeCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMemoryProperties>())).memoryTypes as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMemoryProperties),
            "::",
            stringify!(memoryTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMemoryProperties>())).memoryHeapCount as *const _
                as usize
        },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMemoryProperties),
            "::",
            stringify!(memoryHeapCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMemoryProperties>())).memoryHeaps as *const _
                as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMemoryProperties),
            "::",
            stringify!(memoryHeaps)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSparseProperties {
    pub residencyStandard2DBlockShape: VkBool32,
    pub residencyStandard2DMultisampleBlockShape: VkBool32,
    pub residencyStandard3DBlockShape: VkBool32,
    pub residencyAlignedMipSize: VkBool32,
    pub residencyNonResidentStrict: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceSparseProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceSparseProperties>(),
        20usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceSparseProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceSparseProperties>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceSparseProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseProperties>()))
                .residencyStandard2DBlockShape as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseProperties),
            "::",
            stringify!(residencyStandard2DBlockShape)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseProperties>()))
                .residencyStandard2DMultisampleBlockShape as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseProperties),
            "::",
            stringify!(residencyStandard2DMultisampleBlockShape)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseProperties>()))
                .residencyStandard3DBlockShape as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseProperties),
            "::",
            stringify!(residencyStandard3DBlockShape)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseProperties>())).residencyAlignedMipSize
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseProperties),
            "::",
            stringify!(residencyAlignedMipSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseProperties>())).residencyNonResidentStrict
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseProperties),
            "::",
            stringify!(residencyNonResidentStrict)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPhysicalDeviceProperties {
    pub apiVersion: u32,
    pub driverVersion: u32,
    pub vendorID: u32,
    pub deviceID: u32,
    pub deviceType: VkPhysicalDeviceType,
    pub deviceName: [::std::os::raw::c_char; 256usize],
    pub pipelineCacheUUID: [u8; 16usize],
    pub limits: VkPhysicalDeviceLimits,
    pub sparseProperties: VkPhysicalDeviceSparseProperties,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceProperties>(),
        824usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPhysicalDeviceProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).apiVersion as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(apiVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).driverVersion as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(driverVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).vendorID as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(vendorID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).deviceID as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(deviceID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).deviceType as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(deviceType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).deviceName as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(deviceName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).pipelineCacheUUID as *const _
                as usize
        },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(pipelineCacheUUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).limits as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(limits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties>())).sparseProperties as *const _
                as usize
        },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties),
            "::",
            stringify!(sparseProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyProperties {
    pub queueFlags: VkQueueFlags,
    pub queueCount: u32,
    pub timestampValidBits: u32,
    pub minImageTransferGranularity: VkExtent3D,
}
#[test]
fn bindgen_test_layout_VkQueueFamilyProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkQueueFamilyProperties>(),
        24usize,
        concat!("Size of: ", stringify!(VkQueueFamilyProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkQueueFamilyProperties>(),
        4usize,
        concat!("Alignment of ", stringify!(VkQueueFamilyProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkQueueFamilyProperties>())).queueFlags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueueFamilyProperties),
            "::",
            stringify!(queueFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkQueueFamilyProperties>())).queueCount as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueueFamilyProperties),
            "::",
            stringify!(queueCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkQueueFamilyProperties>())).timestampValidBits as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueueFamilyProperties),
            "::",
            stringify!(timestampValidBits)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkQueueFamilyProperties>())).minImageTransferGranularity
                as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueueFamilyProperties),
            "::",
            stringify!(minImageTransferGranularity)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueCount: u32,
    pub pQueuePriorities: *const f32,
}
#[test]
fn bindgen_test_layout_VkDeviceQueueCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceQueueCreateInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkDeviceQueueCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceQueueCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDeviceQueueCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceQueueCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceQueueCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceQueueCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceQueueCreateInfo>())).queueFamilyIndex as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueCreateInfo),
            "::",
            stringify!(queueFamilyIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceQueueCreateInfo>())).queueCount as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueCreateInfo),
            "::",
            stringify!(queueCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceQueueCreateInfo>())).pQueuePriorities as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueCreateInfo),
            "::",
            stringify!(pQueuePriorities)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceCreateFlags,
    pub queueCreateInfoCount: u32,
    pub pQueueCreateInfos: *const VkDeviceQueueCreateInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const ::std::os::raw::c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const ::std::os::raw::c_char,
    pub pEnabledFeatures: *const VkPhysicalDeviceFeatures,
}
#[test]
fn bindgen_test_layout_VkDeviceCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceCreateInfo>(),
        72usize,
        concat!("Size of: ", stringify!(VkDeviceCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDeviceCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceCreateInfo>())).queueCreateInfoCount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(queueCreateInfoCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceCreateInfo>())).pQueueCreateInfos as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(pQueueCreateInfos)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceCreateInfo>())).enabledLayerCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(enabledLayerCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceCreateInfo>())).ppEnabledLayerNames as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(ppEnabledLayerNames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceCreateInfo>())).enabledExtensionCount as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(enabledExtensionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceCreateInfo>())).ppEnabledExtensionNames as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(ppEnabledExtensionNames)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceCreateInfo>())).pEnabledFeatures as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceCreateInfo),
            "::",
            stringify!(pEnabledFeatures)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkExtensionProperties {
    pub extensionName: [::std::os::raw::c_char; 256usize],
    pub specVersion: u32,
}
#[test]
fn bindgen_test_layout_VkExtensionProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkExtensionProperties>(),
        260usize,
        concat!("Size of: ", stringify!(VkExtensionProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExtensionProperties>(),
        4usize,
        concat!("Alignment of ", stringify!(VkExtensionProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExtensionProperties>())).extensionName as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExtensionProperties),
            "::",
            stringify!(extensionName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExtensionProperties>())).specVersion as *const _ as usize
        },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExtensionProperties),
            "::",
            stringify!(specVersion)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkLayerProperties {
    pub layerName: [::std::os::raw::c_char; 256usize],
    pub specVersion: u32,
    pub implementationVersion: u32,
    pub description: [::std::os::raw::c_char; 256usize],
}
#[test]
fn bindgen_test_layout_VkLayerProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkLayerProperties>(),
        520usize,
        concat!("Size of: ", stringify!(VkLayerProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkLayerProperties>(),
        4usize,
        concat!("Alignment of ", stringify!(VkLayerProperties))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkLayerProperties>())).layerName as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkLayerProperties),
            "::",
            stringify!(layerName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkLayerProperties>())).specVersion as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(VkLayerProperties),
            "::",
            stringify!(specVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkLayerProperties>())).implementationVersion as *const _ as usize
        },
        260usize,
        concat!(
            "Offset of field: ",
            stringify!(VkLayerProperties),
            "::",
            stringify!(implementationVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkLayerProperties>())).description as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(VkLayerProperties),
            "::",
            stringify!(description)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub pWaitDstStageMask: *const VkPipelineStageFlags,
    pub commandBufferCount: u32,
    pub pCommandBuffers: *const VkCommandBuffer,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const VkSemaphore,
}
#[test]
fn bindgen_test_layout_VkSubmitInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSubmitInfo>(),
        72usize,
        concat!("Size of: ", stringify!(VkSubmitInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubmitInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSubmitInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).waitSemaphoreCount as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(waitSemaphoreCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).pWaitSemaphores as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(pWaitSemaphores)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).pWaitDstStageMask as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(pWaitDstStageMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).commandBufferCount as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(commandBufferCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).pCommandBuffers as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(pCommandBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubmitInfo>())).signalSemaphoreCount as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(signalSemaphoreCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubmitInfo>())).pSignalSemaphores as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubmitInfo),
            "::",
            stringify!(pSignalSemaphores)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMappedMemoryRange {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub memory: VkDeviceMemory,
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkMappedMemoryRange() {
    assert_eq!(
        ::std::mem::size_of::<VkMappedMemoryRange>(),
        40usize,
        concat!("Size of: ", stringify!(VkMappedMemoryRange))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMappedMemoryRange>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMappedMemoryRange))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMappedMemoryRange>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMappedMemoryRange),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMappedMemoryRange>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMappedMemoryRange),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMappedMemoryRange>())).memory as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMappedMemoryRange),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMappedMemoryRange>())).offset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMappedMemoryRange),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMappedMemoryRange>())).size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMappedMemoryRange),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub allocationSize: VkDeviceSize,
    pub memoryTypeIndex: u32,
}
#[test]
fn bindgen_test_layout_VkMemoryAllocateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryAllocateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkMemoryAllocateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryAllocateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryAllocateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryAllocateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryAllocateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryAllocateInfo>())).allocationSize as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateInfo),
            "::",
            stringify!(allocationSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryAllocateInfo>())).memoryTypeIndex as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateInfo),
            "::",
            stringify!(memoryTypeIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryRequirements {
    pub size: VkDeviceSize,
    pub alignment: VkDeviceSize,
    pub memoryTypeBits: u32,
}
#[test]
fn bindgen_test_layout_VkMemoryRequirements() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryRequirements>(),
        24usize,
        concat!("Size of: ", stringify!(VkMemoryRequirements))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryRequirements>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryRequirements))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryRequirements>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryRequirements),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryRequirements>())).alignment as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryRequirements),
            "::",
            stringify!(alignment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryRequirements>())).memoryTypeBits as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryRequirements),
            "::",
            stringify!(memoryTypeBits)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseMemoryBind {
    pub resourceOffset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub flags: VkSparseMemoryBindFlags,
}
#[test]
fn bindgen_test_layout_VkSparseMemoryBind() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseMemoryBind>(),
        40usize,
        concat!("Size of: ", stringify!(VkSparseMemoryBind))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseMemoryBind>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSparseMemoryBind))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseMemoryBind>())).resourceOffset as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseMemoryBind),
            "::",
            stringify!(resourceOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseMemoryBind>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseMemoryBind),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseMemoryBind>())).memory as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseMemoryBind),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseMemoryBind>())).memoryOffset as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseMemoryBind),
            "::",
            stringify!(memoryOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseMemoryBind>())).flags as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseMemoryBind),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseBufferMemoryBindInfo {
    pub buffer: VkBuffer,
    pub bindCount: u32,
    pub pBinds: *const VkSparseMemoryBind,
}
#[test]
fn bindgen_test_layout_VkSparseBufferMemoryBindInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseBufferMemoryBindInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkSparseBufferMemoryBindInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseBufferMemoryBindInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSparseBufferMemoryBindInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseBufferMemoryBindInfo>())).buffer as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseBufferMemoryBindInfo),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseBufferMemoryBindInfo>())).bindCount as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseBufferMemoryBindInfo),
            "::",
            stringify!(bindCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseBufferMemoryBindInfo>())).pBinds as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseBufferMemoryBindInfo),
            "::",
            stringify!(pBinds)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageOpaqueMemoryBindInfo {
    pub image: VkImage,
    pub bindCount: u32,
    pub pBinds: *const VkSparseMemoryBind,
}
#[test]
fn bindgen_test_layout_VkSparseImageOpaqueMemoryBindInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseImageOpaqueMemoryBindInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkSparseImageOpaqueMemoryBindInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseImageOpaqueMemoryBindInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkSparseImageOpaqueMemoryBindInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageOpaqueMemoryBindInfo>())).image as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageOpaqueMemoryBindInfo),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageOpaqueMemoryBindInfo>())).bindCount as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageOpaqueMemoryBindInfo),
            "::",
            stringify!(bindCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageOpaqueMemoryBindInfo>())).pBinds as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageOpaqueMemoryBindInfo),
            "::",
            stringify!(pBinds)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresource {
    pub aspectMask: VkImageAspectFlags,
    pub mipLevel: u32,
    pub arrayLayer: u32,
}
#[test]
fn bindgen_test_layout_VkImageSubresource() {
    assert_eq!(
        ::std::mem::size_of::<VkImageSubresource>(),
        12usize,
        concat!("Size of: ", stringify!(VkImageSubresource))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageSubresource>(),
        4usize,
        concat!("Alignment of ", stringify!(VkImageSubresource))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageSubresource>())).aspectMask as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresource),
            "::",
            stringify!(aspectMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageSubresource>())).mipLevel as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresource),
            "::",
            stringify!(mipLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageSubresource>())).arrayLayer as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresource),
            "::",
            stringify!(arrayLayer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryBind {
    pub subresource: VkImageSubresource,
    pub offset: VkOffset3D,
    pub extent: VkExtent3D,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
    pub flags: VkSparseMemoryBindFlags,
}
#[test]
fn bindgen_test_layout_VkSparseImageMemoryBind() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseImageMemoryBind>(),
        64usize,
        concat!("Size of: ", stringify!(VkSparseImageMemoryBind))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseImageMemoryBind>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSparseImageMemoryBind))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryBind>())).subresource as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBind),
            "::",
            stringify!(subresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseImageMemoryBind>())).offset as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBind),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseImageMemoryBind>())).extent as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBind),
            "::",
            stringify!(extent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseImageMemoryBind>())).memory as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBind),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryBind>())).memoryOffset as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBind),
            "::",
            stringify!(memoryOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSparseImageMemoryBind>())).flags as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBind),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryBindInfo {
    pub image: VkImage,
    pub bindCount: u32,
    pub pBinds: *const VkSparseImageMemoryBind,
}
#[test]
fn bindgen_test_layout_VkSparseImageMemoryBindInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseImageMemoryBindInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkSparseImageMemoryBindInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseImageMemoryBindInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSparseImageMemoryBindInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryBindInfo>())).image as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBindInfo),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryBindInfo>())).bindCount as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBindInfo),
            "::",
            stringify!(bindCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryBindInfo>())).pBinds as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryBindInfo),
            "::",
            stringify!(pBinds)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindSparseInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const VkSemaphore,
    pub bufferBindCount: u32,
    pub pBufferBinds: *const VkSparseBufferMemoryBindInfo,
    pub imageOpaqueBindCount: u32,
    pub pImageOpaqueBinds: *const VkSparseImageOpaqueMemoryBindInfo,
    pub imageBindCount: u32,
    pub pImageBinds: *const VkSparseImageMemoryBindInfo,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const VkSemaphore,
}
#[test]
fn bindgen_test_layout_VkBindSparseInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBindSparseInfo>(),
        96usize,
        concat!("Size of: ", stringify!(VkBindSparseInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBindSparseInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBindSparseInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindSparseInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindSparseInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindSparseInfo>())).waitSemaphoreCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(waitSemaphoreCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindSparseInfo>())).pWaitSemaphores as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(pWaitSemaphores)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindSparseInfo>())).bufferBindCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(bufferBindCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindSparseInfo>())).pBufferBinds as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(pBufferBinds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindSparseInfo>())).imageOpaqueBindCount as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(imageOpaqueBindCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindSparseInfo>())).pImageOpaqueBinds as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(pImageOpaqueBinds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindSparseInfo>())).imageBindCount as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(imageBindCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindSparseInfo>())).pImageBinds as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(pImageBinds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindSparseInfo>())).signalSemaphoreCount as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(signalSemaphoreCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindSparseInfo>())).pSignalSemaphores as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindSparseInfo),
            "::",
            stringify!(pSignalSemaphores)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageFormatProperties {
    pub aspectMask: VkImageAspectFlags,
    pub imageGranularity: VkExtent3D,
    pub flags: VkSparseImageFormatFlags,
}
#[test]
fn bindgen_test_layout_VkSparseImageFormatProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseImageFormatProperties>(),
        20usize,
        concat!("Size of: ", stringify!(VkSparseImageFormatProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseImageFormatProperties>(),
        4usize,
        concat!("Alignment of ", stringify!(VkSparseImageFormatProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageFormatProperties>())).aspectMask as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageFormatProperties),
            "::",
            stringify!(aspectMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageFormatProperties>())).imageGranularity as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageFormatProperties),
            "::",
            stringify!(imageGranularity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageFormatProperties>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageFormatProperties),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryRequirements {
    pub formatProperties: VkSparseImageFormatProperties,
    pub imageMipTailFirstLod: u32,
    pub imageMipTailSize: VkDeviceSize,
    pub imageMipTailOffset: VkDeviceSize,
    pub imageMipTailStride: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkSparseImageMemoryRequirements() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseImageMemoryRequirements>(),
        48usize,
        concat!("Size of: ", stringify!(VkSparseImageMemoryRequirements))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseImageMemoryRequirements>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSparseImageMemoryRequirements))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements>())).formatProperties as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements),
            "::",
            stringify!(formatProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements>())).imageMipTailFirstLod
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements),
            "::",
            stringify!(imageMipTailFirstLod)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements>())).imageMipTailSize as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements),
            "::",
            stringify!(imageMipTailSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements>())).imageMipTailOffset
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements),
            "::",
            stringify!(imageMipTailOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements>())).imageMipTailStride
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements),
            "::",
            stringify!(imageMipTailStride)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFenceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkFenceCreateFlags,
}
#[test]
fn bindgen_test_layout_VkFenceCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkFenceCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkFenceCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkFenceCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkFenceCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFenceCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFenceCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFenceCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFenceCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFenceCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFenceCreateInfo),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSemaphoreCreateFlags,
}
#[test]
fn bindgen_test_layout_VkSemaphoreCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSemaphoreCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkSemaphoreCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSemaphoreCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSemaphoreCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreCreateInfo),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkEventCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkEventCreateFlags,
}
#[test]
fn bindgen_test_layout_VkEventCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkEventCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkEventCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkEventCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkEventCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkEventCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkEventCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkEventCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkEventCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkEventCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkEventCreateInfo),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueryPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkQueryPoolCreateFlags,
    pub queryType: VkQueryType,
    pub queryCount: u32,
    pub pipelineStatistics: VkQueryPipelineStatisticFlags,
}
#[test]
fn bindgen_test_layout_VkQueryPoolCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkQueryPoolCreateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkQueryPoolCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkQueryPoolCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkQueryPoolCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkQueryPoolCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueryPoolCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkQueryPoolCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueryPoolCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkQueryPoolCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueryPoolCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkQueryPoolCreateInfo>())).queryType as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueryPoolCreateInfo),
            "::",
            stringify!(queryType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkQueryPoolCreateInfo>())).queryCount as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueryPoolCreateInfo),
            "::",
            stringify!(queryCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkQueryPoolCreateInfo>())).pipelineStatistics as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueryPoolCreateInfo),
            "::",
            stringify!(pipelineStatistics)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferCreateFlags,
    pub size: VkDeviceSize,
    pub usage: VkBufferUsageFlags,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}
#[test]
fn bindgen_test_layout_VkBufferCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBufferCreateInfo>(),
        56usize,
        concat!("Size of: ", stringify!(VkBufferCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBufferCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBufferCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCreateInfo>())).size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCreateInfo>())).usage as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(usage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCreateInfo>())).sharingMode as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(sharingMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferCreateInfo>())).queueFamilyIndexCount as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(queueFamilyIndexCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferCreateInfo>())).pQueueFamilyIndices as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCreateInfo),
            "::",
            stringify!(pQueueFamilyIndices)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferViewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferViewCreateFlags,
    pub buffer: VkBuffer,
    pub format: VkFormat,
    pub offset: VkDeviceSize,
    pub range: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkBufferViewCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBufferViewCreateInfo>(),
        56usize,
        concat!("Size of: ", stringify!(VkBufferViewCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBufferViewCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBufferViewCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferViewCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferViewCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferViewCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferViewCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferViewCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferViewCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferViewCreateInfo>())).buffer as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferViewCreateInfo),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferViewCreateInfo>())).format as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferViewCreateInfo),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferViewCreateInfo>())).offset as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferViewCreateInfo),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferViewCreateInfo>())).range as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferViewCreateInfo),
            "::",
            stringify!(range)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageCreateFlags,
    pub imageType: VkImageType,
    pub format: VkFormat,
    pub extent: VkExtent3D,
    pub mipLevels: u32,
    pub arrayLayers: u32,
    pub samples: VkSampleCountFlagBits,
    pub tiling: VkImageTiling,
    pub usage: VkImageUsageFlags,
    pub sharingMode: VkSharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
    pub initialLayout: VkImageLayout,
}
#[test]
fn bindgen_test_layout_VkImageCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkImageCreateInfo>(),
        88usize,
        concat!("Size of: ", stringify!(VkImageCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).imageType as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(imageType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).format as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).extent as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(extent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).mipLevels as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(mipLevels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).arrayLayers as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(arrayLayers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).samples as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).tiling as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(tiling)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).usage as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(usage)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).sharingMode as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(sharingMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageCreateInfo>())).queueFamilyIndexCount as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(queueFamilyIndexCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageCreateInfo>())).pQueueFamilyIndices as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(pQueueFamilyIndices)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCreateInfo>())).initialLayout as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCreateInfo),
            "::",
            stringify!(initialLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubresourceLayout {
    pub offset: VkDeviceSize,
    pub size: VkDeviceSize,
    pub rowPitch: VkDeviceSize,
    pub arrayPitch: VkDeviceSize,
    pub depthPitch: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkSubresourceLayout() {
    assert_eq!(
        ::std::mem::size_of::<VkSubresourceLayout>(),
        40usize,
        concat!("Size of: ", stringify!(VkSubresourceLayout))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubresourceLayout>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSubresourceLayout))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubresourceLayout>())).offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubresourceLayout),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubresourceLayout>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubresourceLayout),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubresourceLayout>())).rowPitch as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubresourceLayout),
            "::",
            stringify!(rowPitch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubresourceLayout>())).arrayPitch as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubresourceLayout),
            "::",
            stringify!(arrayPitch)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubresourceLayout>())).depthPitch as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubresourceLayout),
            "::",
            stringify!(depthPitch)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkComponentMapping {
    pub r: VkComponentSwizzle,
    pub g: VkComponentSwizzle,
    pub b: VkComponentSwizzle,
    pub a: VkComponentSwizzle,
}
#[test]
fn bindgen_test_layout_VkComponentMapping() {
    assert_eq!(
        ::std::mem::size_of::<VkComponentMapping>(),
        16usize,
        concat!("Size of: ", stringify!(VkComponentMapping))
    );
    assert_eq!(
        ::std::mem::align_of::<VkComponentMapping>(),
        4usize,
        concat!("Alignment of ", stringify!(VkComponentMapping))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkComponentMapping>())).r as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComponentMapping),
            "::",
            stringify!(r)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkComponentMapping>())).g as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComponentMapping),
            "::",
            stringify!(g)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkComponentMapping>())).b as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComponentMapping),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkComponentMapping>())).a as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComponentMapping),
            "::",
            stringify!(a)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageViewCreateFlags,
    pub image: VkImage,
    pub viewType: VkImageViewType,
    pub format: VkFormat,
    pub components: VkComponentMapping,
    pub subresourceRange: VkImageSubresourceRange,
}
#[test]
fn bindgen_test_layout_VkImageViewCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkImageViewCreateInfo>(),
        80usize,
        concat!("Size of: ", stringify!(VkImageViewCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageViewCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageViewCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageViewCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageViewCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageViewCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageViewCreateInfo>())).image as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageViewCreateInfo>())).viewType as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(viewType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageViewCreateInfo>())).format as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageViewCreateInfo>())).components as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageViewCreateInfo>())).subresourceRange as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewCreateInfo),
            "::",
            stringify!(subresourceRange)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkShaderModuleCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkShaderModuleCreateFlags,
    pub codeSize: size_t,
    pub pCode: *const u32,
}
#[test]
fn bindgen_test_layout_VkShaderModuleCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkShaderModuleCreateInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkShaderModuleCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkShaderModuleCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkShaderModuleCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkShaderModuleCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkShaderModuleCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkShaderModuleCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkShaderModuleCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkShaderModuleCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkShaderModuleCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkShaderModuleCreateInfo>())).codeSize as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkShaderModuleCreateInfo),
            "::",
            stringify!(codeSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkShaderModuleCreateInfo>())).pCode as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkShaderModuleCreateInfo),
            "::",
            stringify!(pCode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineCacheCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCacheCreateFlags,
    pub initialDataSize: size_t,
    pub pInitialData: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_VkPipelineCacheCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineCacheCreateInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkPipelineCacheCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineCacheCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPipelineCacheCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPipelineCacheCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineCacheCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPipelineCacheCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineCacheCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPipelineCacheCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineCacheCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineCacheCreateInfo>())).initialDataSize as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineCacheCreateInfo),
            "::",
            stringify!(initialDataSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineCacheCreateInfo>())).pInitialData as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineCacheCreateInfo),
            "::",
            stringify!(pInitialData)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSpecializationMapEntry {
    pub constantID: u32,
    pub offset: u32,
    pub size: size_t,
}
#[test]
fn bindgen_test_layout_VkSpecializationMapEntry() {
    assert_eq!(
        ::std::mem::size_of::<VkSpecializationMapEntry>(),
        16usize,
        concat!("Size of: ", stringify!(VkSpecializationMapEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSpecializationMapEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSpecializationMapEntry))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSpecializationMapEntry>())).constantID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSpecializationMapEntry),
            "::",
            stringify!(constantID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSpecializationMapEntry>())).offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSpecializationMapEntry),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSpecializationMapEntry>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSpecializationMapEntry),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSpecializationInfo {
    pub mapEntryCount: u32,
    pub pMapEntries: *const VkSpecializationMapEntry,
    pub dataSize: size_t,
    pub pData: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_VkSpecializationInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSpecializationInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkSpecializationInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSpecializationInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSpecializationInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSpecializationInfo>())).mapEntryCount as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSpecializationInfo),
            "::",
            stringify!(mapEntryCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSpecializationInfo>())).pMapEntries as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSpecializationInfo),
            "::",
            stringify!(pMapEntries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSpecializationInfo>())).dataSize as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSpecializationInfo),
            "::",
            stringify!(dataSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSpecializationInfo>())).pData as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSpecializationInfo),
            "::",
            stringify!(pData)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineShaderStageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineShaderStageCreateFlags,
    pub stage: VkShaderStageFlagBits,
    pub module: VkShaderModule,
    pub pName: *const ::std::os::raw::c_char,
    pub pSpecializationInfo: *const VkSpecializationInfo,
}
#[test]
fn bindgen_test_layout_VkPipelineShaderStageCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineShaderStageCreateInfo>(),
        48usize,
        concat!("Size of: ", stringify!(VkPipelineShaderStageCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineShaderStageCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPipelineShaderStageCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineShaderStageCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineShaderStageCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineShaderStageCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineShaderStageCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineShaderStageCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineShaderStageCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineShaderStageCreateInfo>())).stage as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineShaderStageCreateInfo),
            "::",
            stringify!(stage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineShaderStageCreateInfo>())).module as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineShaderStageCreateInfo),
            "::",
            stringify!(module)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineShaderStageCreateInfo>())).pName as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineShaderStageCreateInfo),
            "::",
            stringify!(pName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineShaderStageCreateInfo>())).pSpecializationInfo
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineShaderStageCreateInfo),
            "::",
            stringify!(pSpecializationInfo)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkComputePipelineCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stage: VkPipelineShaderStageCreateInfo,
    pub layout: VkPipelineLayout,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[test]
fn bindgen_test_layout_VkComputePipelineCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkComputePipelineCreateInfo>(),
        96usize,
        concat!("Size of: ", stringify!(VkComputePipelineCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkComputePipelineCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkComputePipelineCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkComputePipelineCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComputePipelineCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkComputePipelineCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComputePipelineCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkComputePipelineCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComputePipelineCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkComputePipelineCreateInfo>())).stage as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComputePipelineCreateInfo),
            "::",
            stringify!(stage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkComputePipelineCreateInfo>())).layout as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComputePipelineCreateInfo),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkComputePipelineCreateInfo>())).basePipelineHandle as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComputePipelineCreateInfo),
            "::",
            stringify!(basePipelineHandle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkComputePipelineCreateInfo>())).basePipelineIndex as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkComputePipelineCreateInfo),
            "::",
            stringify!(basePipelineIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub inputRate: VkVertexInputRate,
}
#[test]
fn bindgen_test_layout_VkVertexInputBindingDescription() {
    assert_eq!(
        ::std::mem::size_of::<VkVertexInputBindingDescription>(),
        12usize,
        concat!("Size of: ", stringify!(VkVertexInputBindingDescription))
    );
    assert_eq!(
        ::std::mem::align_of::<VkVertexInputBindingDescription>(),
        4usize,
        concat!("Alignment of ", stringify!(VkVertexInputBindingDescription))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkVertexInputBindingDescription>())).binding as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkVertexInputBindingDescription),
            "::",
            stringify!(binding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkVertexInputBindingDescription>())).stride as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkVertexInputBindingDescription),
            "::",
            stringify!(stride)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkVertexInputBindingDescription>())).inputRate as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkVertexInputBindingDescription),
            "::",
            stringify!(inputRate)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkVertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: VkFormat,
    pub offset: u32,
}
#[test]
fn bindgen_test_layout_VkVertexInputAttributeDescription() {
    assert_eq!(
        ::std::mem::size_of::<VkVertexInputAttributeDescription>(),
        16usize,
        concat!("Size of: ", stringify!(VkVertexInputAttributeDescription))
    );
    assert_eq!(
        ::std::mem::align_of::<VkVertexInputAttributeDescription>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VkVertexInputAttributeDescription)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkVertexInputAttributeDescription>())).location as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkVertexInputAttributeDescription),
            "::",
            stringify!(location)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkVertexInputAttributeDescription>())).binding as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkVertexInputAttributeDescription),
            "::",
            stringify!(binding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkVertexInputAttributeDescription>())).format as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkVertexInputAttributeDescription),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkVertexInputAttributeDescription>())).offset as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkVertexInputAttributeDescription),
            "::",
            stringify!(offset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineVertexInputStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineVertexInputStateCreateFlags,
    pub vertexBindingDescriptionCount: u32,
    pub pVertexBindingDescriptions: *const VkVertexInputBindingDescription,
    pub vertexAttributeDescriptionCount: u32,
    pub pVertexAttributeDescriptions: *const VkVertexInputAttributeDescription,
}
#[test]
fn bindgen_test_layout_VkPipelineVertexInputStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineVertexInputStateCreateInfo>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(VkPipelineVertexInputStateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineVertexInputStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineVertexInputStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineVertexInputStateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineVertexInputStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineVertexInputStateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineVertexInputStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineVertexInputStateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineVertexInputStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineVertexInputStateCreateInfo>()))
                .vertexBindingDescriptionCount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineVertexInputStateCreateInfo),
            "::",
            stringify!(vertexBindingDescriptionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineVertexInputStateCreateInfo>()))
                .pVertexBindingDescriptions as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineVertexInputStateCreateInfo),
            "::",
            stringify!(pVertexBindingDescriptions)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineVertexInputStateCreateInfo>()))
                .vertexAttributeDescriptionCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineVertexInputStateCreateInfo),
            "::",
            stringify!(vertexAttributeDescriptionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineVertexInputStateCreateInfo>()))
                .pVertexAttributeDescriptions as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineVertexInputStateCreateInfo),
            "::",
            stringify!(pVertexAttributeDescriptions)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineInputAssemblyStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineInputAssemblyStateCreateFlags,
    pub topology: VkPrimitiveTopology,
    pub primitiveRestartEnable: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPipelineInputAssemblyStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineInputAssemblyStateCreateInfo>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkPipelineInputAssemblyStateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineInputAssemblyStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineInputAssemblyStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineInputAssemblyStateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineInputAssemblyStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineInputAssemblyStateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineInputAssemblyStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineInputAssemblyStateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineInputAssemblyStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineInputAssemblyStateCreateInfo>())).topology as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineInputAssemblyStateCreateInfo),
            "::",
            stringify!(topology)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineInputAssemblyStateCreateInfo>()))
                .primitiveRestartEnable as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineInputAssemblyStateCreateInfo),
            "::",
            stringify!(primitiveRestartEnable)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineTessellationStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineTessellationStateCreateFlags,
    pub patchControlPoints: u32,
}
#[test]
fn bindgen_test_layout_VkPipelineTessellationStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineTessellationStateCreateInfo>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPipelineTessellationStateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineTessellationStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineTessellationStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineTessellationStateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineTessellationStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineTessellationStateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineTessellationStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineTessellationStateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineTessellationStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineTessellationStateCreateInfo>())).patchControlPoints
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineTessellationStateCreateInfo),
            "::",
            stringify!(patchControlPoints)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkViewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub minDepth: f32,
    pub maxDepth: f32,
}
#[test]
fn bindgen_test_layout_VkViewport() {
    assert_eq!(
        ::std::mem::size_of::<VkViewport>(),
        24usize,
        concat!("Size of: ", stringify!(VkViewport))
    );
    assert_eq!(
        ::std::mem::align_of::<VkViewport>(),
        4usize,
        concat!("Alignment of ", stringify!(VkViewport))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkViewport>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkViewport),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkViewport>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkViewport),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkViewport>())).width as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkViewport),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkViewport>())).height as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkViewport),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkViewport>())).minDepth as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkViewport),
            "::",
            stringify!(minDepth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkViewport>())).maxDepth as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkViewport),
            "::",
            stringify!(maxDepth)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineViewportStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineViewportStateCreateFlags,
    pub viewportCount: u32,
    pub pViewports: *const VkViewport,
    pub scissorCount: u32,
    pub pScissors: *const VkRect2D,
}
#[test]
fn bindgen_test_layout_VkPipelineViewportStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineViewportStateCreateInfo>(),
        48usize,
        concat!("Size of: ", stringify!(VkPipelineViewportStateCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineViewportStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineViewportStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineViewportStateCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineViewportStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineViewportStateCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineViewportStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineViewportStateCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineViewportStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineViewportStateCreateInfo>())).viewportCount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineViewportStateCreateInfo),
            "::",
            stringify!(viewportCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineViewportStateCreateInfo>())).pViewports as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineViewportStateCreateInfo),
            "::",
            stringify!(pViewports)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineViewportStateCreateInfo>())).scissorCount as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineViewportStateCreateInfo),
            "::",
            stringify!(scissorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineViewportStateCreateInfo>())).pScissors as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineViewportStateCreateInfo),
            "::",
            stringify!(pScissors)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineRasterizationStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineRasterizationStateCreateFlags,
    pub depthClampEnable: VkBool32,
    pub rasterizerDiscardEnable: VkBool32,
    pub polygonMode: VkPolygonMode,
    pub cullMode: VkCullModeFlags,
    pub frontFace: VkFrontFace,
    pub depthBiasEnable: VkBool32,
    pub depthBiasConstantFactor: f32,
    pub depthBiasClamp: f32,
    pub depthBiasSlopeFactor: f32,
    pub lineWidth: f32,
}
#[test]
fn bindgen_test_layout_VkPipelineRasterizationStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineRasterizationStateCreateInfo>(),
        64usize,
        concat!(
            "Size of: ",
            stringify!(VkPipelineRasterizationStateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineRasterizationStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineRasterizationStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).depthClampEnable
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(depthClampEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>()))
                .rasterizerDiscardEnable as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(rasterizerDiscardEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).polygonMode
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(polygonMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).cullMode as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(cullMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).frontFace as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(frontFace)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).depthBiasEnable
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(depthBiasEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>()))
                .depthBiasConstantFactor as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(depthBiasConstantFactor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).depthBiasClamp
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(depthBiasClamp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).depthBiasSlopeFactor
                as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(depthBiasSlopeFactor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineRasterizationStateCreateInfo>())).lineWidth as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineRasterizationStateCreateInfo),
            "::",
            stringify!(lineWidth)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineMultisampleStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineMultisampleStateCreateFlags,
    pub rasterizationSamples: VkSampleCountFlagBits,
    pub sampleShadingEnable: VkBool32,
    pub minSampleShading: f32,
    pub pSampleMask: *const VkSampleMask,
    pub alphaToCoverageEnable: VkBool32,
    pub alphaToOneEnable: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPipelineMultisampleStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineMultisampleStateCreateInfo>(),
        48usize,
        concat!(
            "Size of: ",
            stringify!(VkPipelineMultisampleStateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineMultisampleStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineMultisampleStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).rasterizationSamples
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(rasterizationSamples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).sampleShadingEnable
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(sampleShadingEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).minSampleShading
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(minSampleShading)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).pSampleMask as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(pSampleMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).alphaToCoverageEnable
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(alphaToCoverageEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineMultisampleStateCreateInfo>())).alphaToOneEnable
                as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineMultisampleStateCreateInfo),
            "::",
            stringify!(alphaToOneEnable)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkStencilOpState {
    pub failOp: VkStencilOp,
    pub passOp: VkStencilOp,
    pub depthFailOp: VkStencilOp,
    pub compareOp: VkCompareOp,
    pub compareMask: u32,
    pub writeMask: u32,
    pub reference: u32,
}
#[test]
fn bindgen_test_layout_VkStencilOpState() {
    assert_eq!(
        ::std::mem::size_of::<VkStencilOpState>(),
        28usize,
        concat!("Size of: ", stringify!(VkStencilOpState))
    );
    assert_eq!(
        ::std::mem::align_of::<VkStencilOpState>(),
        4usize,
        concat!("Alignment of ", stringify!(VkStencilOpState))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkStencilOpState>())).failOp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkStencilOpState),
            "::",
            stringify!(failOp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkStencilOpState>())).passOp as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkStencilOpState),
            "::",
            stringify!(passOp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkStencilOpState>())).depthFailOp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkStencilOpState),
            "::",
            stringify!(depthFailOp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkStencilOpState>())).compareOp as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkStencilOpState),
            "::",
            stringify!(compareOp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkStencilOpState>())).compareMask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkStencilOpState),
            "::",
            stringify!(compareMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkStencilOpState>())).writeMask as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkStencilOpState),
            "::",
            stringify!(writeMask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkStencilOpState>())).reference as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkStencilOpState),
            "::",
            stringify!(reference)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDepthStencilStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDepthStencilStateCreateFlags,
    pub depthTestEnable: VkBool32,
    pub depthWriteEnable: VkBool32,
    pub depthCompareOp: VkCompareOp,
    pub depthBoundsTestEnable: VkBool32,
    pub stencilTestEnable: VkBool32,
    pub front: VkStencilOpState,
    pub back: VkStencilOpState,
    pub minDepthBounds: f32,
    pub maxDepthBounds: f32,
}
#[test]
fn bindgen_test_layout_VkPipelineDepthStencilStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineDepthStencilStateCreateInfo>(),
        104usize,
        concat!(
            "Size of: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineDepthStencilStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineDepthStencilStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).depthTestEnable
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(depthTestEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).depthWriteEnable
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(depthWriteEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).depthCompareOp
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(depthCompareOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).depthBoundsTestEnable
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(depthBoundsTestEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).stencilTestEnable
                as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(stencilTestEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).front as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(front)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).back as *const _
                as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(back)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).minDepthBounds
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(minDepthBounds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDepthStencilStateCreateInfo>())).maxDepthBounds
                as *const _ as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDepthStencilStateCreateInfo),
            "::",
            stringify!(maxDepthBounds)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendAttachmentState {
    pub blendEnable: VkBool32,
    pub srcColorBlendFactor: VkBlendFactor,
    pub dstColorBlendFactor: VkBlendFactor,
    pub colorBlendOp: VkBlendOp,
    pub srcAlphaBlendFactor: VkBlendFactor,
    pub dstAlphaBlendFactor: VkBlendFactor,
    pub alphaBlendOp: VkBlendOp,
    pub colorWriteMask: VkColorComponentFlags,
}
#[test]
fn bindgen_test_layout_VkPipelineColorBlendAttachmentState() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineColorBlendAttachmentState>(),
        32usize,
        concat!("Size of: ", stringify!(VkPipelineColorBlendAttachmentState))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineColorBlendAttachmentState>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineColorBlendAttachmentState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).blendEnable as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(blendEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).srcColorBlendFactor
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(srcColorBlendFactor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).dstColorBlendFactor
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(dstColorBlendFactor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).colorBlendOp as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(colorBlendOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).srcAlphaBlendFactor
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(srcAlphaBlendFactor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).dstAlphaBlendFactor
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(dstAlphaBlendFactor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).alphaBlendOp as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(alphaBlendOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendAttachmentState>())).colorWriteMask
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendAttachmentState),
            "::",
            stringify!(colorWriteMask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineColorBlendStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineColorBlendStateCreateFlags,
    pub logicOpEnable: VkBool32,
    pub logicOp: VkLogicOp,
    pub attachmentCount: u32,
    pub pAttachments: *const VkPipelineColorBlendAttachmentState,
    pub blendConstants: [f32; 4usize],
}
#[test]
fn bindgen_test_layout_VkPipelineColorBlendStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineColorBlendStateCreateInfo>(),
        56usize,
        concat!("Size of: ", stringify!(VkPipelineColorBlendStateCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineColorBlendStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineColorBlendStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).logicOpEnable
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(logicOpEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).logicOp as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(logicOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).attachmentCount
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(attachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).pAttachments as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(pAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineColorBlendStateCreateInfo>())).blendConstants
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineColorBlendStateCreateInfo),
            "::",
            stringify!(blendConstants)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineDynamicStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineDynamicStateCreateFlags,
    pub dynamicStateCount: u32,
    pub pDynamicStates: *const VkDynamicState,
}
#[test]
fn bindgen_test_layout_VkPipelineDynamicStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineDynamicStateCreateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkPipelineDynamicStateCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineDynamicStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineDynamicStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDynamicStateCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDynamicStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDynamicStateCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDynamicStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDynamicStateCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDynamicStateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDynamicStateCreateInfo>())).dynamicStateCount
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDynamicStateCreateInfo),
            "::",
            stringify!(dynamicStateCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineDynamicStateCreateInfo>())).pDynamicStates as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineDynamicStateCreateInfo),
            "::",
            stringify!(pDynamicStates)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkGraphicsPipelineCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const VkPipelineShaderStageCreateInfo,
    pub pVertexInputState: *const VkPipelineVertexInputStateCreateInfo,
    pub pInputAssemblyState: *const VkPipelineInputAssemblyStateCreateInfo,
    pub pTessellationState: *const VkPipelineTessellationStateCreateInfo,
    pub pViewportState: *const VkPipelineViewportStateCreateInfo,
    pub pRasterizationState: *const VkPipelineRasterizationStateCreateInfo,
    pub pMultisampleState: *const VkPipelineMultisampleStateCreateInfo,
    pub pDepthStencilState: *const VkPipelineDepthStencilStateCreateInfo,
    pub pColorBlendState: *const VkPipelineColorBlendStateCreateInfo,
    pub pDynamicState: *const VkPipelineDynamicStateCreateInfo,
    pub layout: VkPipelineLayout,
    pub renderPass: VkRenderPass,
    pub subpass: u32,
    pub basePipelineHandle: VkPipeline,
    pub basePipelineIndex: i32,
}
#[test]
fn bindgen_test_layout_VkGraphicsPipelineCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkGraphicsPipelineCreateInfo>(),
        144usize,
        concat!("Size of: ", stringify!(VkGraphicsPipelineCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkGraphicsPipelineCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkGraphicsPipelineCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).stageCount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(stageCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pStages as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pStages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pVertexInputState as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pVertexInputState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pInputAssemblyState as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pInputAssemblyState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pTessellationState as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pTessellationState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pViewportState as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pViewportState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pRasterizationState as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pRasterizationState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pMultisampleState as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pMultisampleState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pDepthStencilState as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pDepthStencilState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pColorBlendState as *const _
                as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pColorBlendState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).pDynamicState as *const _
                as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(pDynamicState)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).layout as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).renderPass as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(renderPass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).subpass as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(subpass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).basePipelineHandle as *const _
                as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(basePipelineHandle)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkGraphicsPipelineCreateInfo>())).basePipelineIndex as *const _
                as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(VkGraphicsPipelineCreateInfo),
            "::",
            stringify!(basePipelineIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPushConstantRange {
    pub stageFlags: VkShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}
#[test]
fn bindgen_test_layout_VkPushConstantRange() {
    assert_eq!(
        ::std::mem::size_of::<VkPushConstantRange>(),
        12usize,
        concat!("Size of: ", stringify!(VkPushConstantRange))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPushConstantRange>(),
        4usize,
        concat!("Alignment of ", stringify!(VkPushConstantRange))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPushConstantRange>())).stageFlags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPushConstantRange),
            "::",
            stringify!(stageFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPushConstantRange>())).offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPushConstantRange),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPushConstantRange>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPushConstantRange),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineLayoutCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkPipelineLayoutCreateFlags,
    pub setLayoutCount: u32,
    pub pSetLayouts: *const VkDescriptorSetLayout,
    pub pushConstantRangeCount: u32,
    pub pPushConstantRanges: *const VkPushConstantRange,
}
#[test]
fn bindgen_test_layout_VkPipelineLayoutCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineLayoutCreateInfo>(),
        48usize,
        concat!("Size of: ", stringify!(VkPipelineLayoutCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineLayoutCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPipelineLayoutCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineLayoutCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineLayoutCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineLayoutCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineLayoutCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineLayoutCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineLayoutCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineLayoutCreateInfo>())).setLayoutCount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineLayoutCreateInfo),
            "::",
            stringify!(setLayoutCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineLayoutCreateInfo>())).pSetLayouts as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineLayoutCreateInfo),
            "::",
            stringify!(pSetLayouts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineLayoutCreateInfo>())).pushConstantRangeCount
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineLayoutCreateInfo),
            "::",
            stringify!(pushConstantRangeCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineLayoutCreateInfo>())).pPushConstantRanges as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineLayoutCreateInfo),
            "::",
            stringify!(pPushConstantRanges)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSamplerCreateFlags,
    pub magFilter: VkFilter,
    pub minFilter: VkFilter,
    pub mipmapMode: VkSamplerMipmapMode,
    pub addressModeU: VkSamplerAddressMode,
    pub addressModeV: VkSamplerAddressMode,
    pub addressModeW: VkSamplerAddressMode,
    pub mipLodBias: f32,
    pub anisotropyEnable: VkBool32,
    pub maxAnisotropy: f32,
    pub compareEnable: VkBool32,
    pub compareOp: VkCompareOp,
    pub minLod: f32,
    pub maxLod: f32,
    pub borderColor: VkBorderColor,
    pub unnormalizedCoordinates: VkBool32,
}
#[test]
fn bindgen_test_layout_VkSamplerCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSamplerCreateInfo>(),
        80usize,
        concat!("Size of: ", stringify!(VkSamplerCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSamplerCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSamplerCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).magFilter as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(magFilter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).minFilter as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(minFilter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).mipmapMode as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(mipmapMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerCreateInfo>())).addressModeU as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(addressModeU)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerCreateInfo>())).addressModeV as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(addressModeV)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerCreateInfo>())).addressModeW as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(addressModeW)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).mipLodBias as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(mipLodBias)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerCreateInfo>())).anisotropyEnable as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(anisotropyEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerCreateInfo>())).maxAnisotropy as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(maxAnisotropy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerCreateInfo>())).compareEnable as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(compareEnable)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).compareOp as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(compareOp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).minLod as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(minLod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).maxLod as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(maxLod)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSamplerCreateInfo>())).borderColor as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(borderColor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerCreateInfo>())).unnormalizedCoordinates as *const _
                as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerCreateInfo),
            "::",
            stringify!(unnormalizedCoordinates)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCopyDescriptorSet {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSet: VkDescriptorSet,
    pub srcBinding: u32,
    pub srcArrayElement: u32,
    pub dstSet: VkDescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
}
#[test]
fn bindgen_test_layout_VkCopyDescriptorSet() {
    assert_eq!(
        ::std::mem::size_of::<VkCopyDescriptorSet>(),
        56usize,
        concat!("Size of: ", stringify!(VkCopyDescriptorSet))
    );
    assert_eq!(
        ::std::mem::align_of::<VkCopyDescriptorSet>(),
        8usize,
        concat!("Alignment of ", stringify!(VkCopyDescriptorSet))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCopyDescriptorSet>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCopyDescriptorSet>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCopyDescriptorSet>())).srcSet as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(srcSet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCopyDescriptorSet>())).srcBinding as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(srcBinding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCopyDescriptorSet>())).srcArrayElement as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(srcArrayElement)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCopyDescriptorSet>())).dstSet as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(dstSet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCopyDescriptorSet>())).dstBinding as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(dstBinding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCopyDescriptorSet>())).dstArrayElement as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(dstArrayElement)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCopyDescriptorSet>())).descriptorCount as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCopyDescriptorSet),
            "::",
            stringify!(descriptorCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorBufferInfo {
    pub buffer: VkBuffer,
    pub offset: VkDeviceSize,
    pub range: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkDescriptorBufferInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorBufferInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkDescriptorBufferInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorBufferInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorBufferInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDescriptorBufferInfo>())).buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorBufferInfo),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDescriptorBufferInfo>())).offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorBufferInfo),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDescriptorBufferInfo>())).range as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorBufferInfo),
            "::",
            stringify!(range)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorImageInfo {
    pub sampler: VkSampler,
    pub imageView: VkImageView,
    pub imageLayout: VkImageLayout,
}
#[test]
fn bindgen_test_layout_VkDescriptorImageInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorImageInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkDescriptorImageInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorImageInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorImageInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDescriptorImageInfo>())).sampler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorImageInfo),
            "::",
            stringify!(sampler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDescriptorImageInfo>())).imageView as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorImageInfo),
            "::",
            stringify!(imageView)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorImageInfo>())).imageLayout as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorImageInfo),
            "::",
            stringify!(imageLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolSize {
    pub type_: VkDescriptorType,
    pub descriptorCount: u32,
}
#[test]
fn bindgen_test_layout_VkDescriptorPoolSize() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorPoolSize>(),
        8usize,
        concat!("Size of: ", stringify!(VkDescriptorPoolSize))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorPoolSize>(),
        4usize,
        concat!("Alignment of ", stringify!(VkDescriptorPoolSize))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDescriptorPoolSize>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolSize),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorPoolSize>())).descriptorCount as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolSize),
            "::",
            stringify!(descriptorCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorPoolCreateFlags,
    pub maxSets: u32,
    pub poolSizeCount: u32,
    pub pPoolSizes: *const VkDescriptorPoolSize,
}
#[test]
fn bindgen_test_layout_VkDescriptorPoolCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorPoolCreateInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkDescriptorPoolCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorPoolCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorPoolCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorPoolCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorPoolCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorPoolCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorPoolCreateInfo>())).maxSets as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolCreateInfo),
            "::",
            stringify!(maxSets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorPoolCreateInfo>())).poolSizeCount as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolCreateInfo),
            "::",
            stringify!(poolSizeCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorPoolCreateInfo>())).pPoolSizes as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorPoolCreateInfo),
            "::",
            stringify!(pPoolSizes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub descriptorPool: VkDescriptorPool,
    pub descriptorSetCount: u32,
    pub pSetLayouts: *const VkDescriptorSetLayout,
}
#[test]
fn bindgen_test_layout_VkDescriptorSetAllocateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorSetAllocateInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkDescriptorSetAllocateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorSetAllocateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorSetAllocateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetAllocateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetAllocateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetAllocateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetAllocateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetAllocateInfo>())).descriptorPool as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetAllocateInfo),
            "::",
            stringify!(descriptorPool)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetAllocateInfo>())).descriptorSetCount as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetAllocateInfo),
            "::",
            stringify!(descriptorSetCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetAllocateInfo>())).pSetLayouts as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetAllocateInfo),
            "::",
            stringify!(pSetLayouts)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutBinding {
    pub binding: u32,
    pub descriptorType: VkDescriptorType,
    pub descriptorCount: u32,
    pub stageFlags: VkShaderStageFlags,
    pub pImmutableSamplers: *const VkSampler,
}
#[test]
fn bindgen_test_layout_VkDescriptorSetLayoutBinding() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorSetLayoutBinding>(),
        24usize,
        concat!("Size of: ", stringify!(VkDescriptorSetLayoutBinding))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorSetLayoutBinding>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorSetLayoutBinding))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBinding>())).binding as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBinding),
            "::",
            stringify!(binding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBinding>())).descriptorType as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBinding),
            "::",
            stringify!(descriptorType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBinding>())).descriptorCount as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBinding),
            "::",
            stringify!(descriptorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBinding>())).stageFlags as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBinding),
            "::",
            stringify!(stageFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBinding>())).pImmutableSamplers as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBinding),
            "::",
            stringify!(pImmutableSamplers)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorSetLayoutCreateFlags,
    pub bindingCount: u32,
    pub pBindings: *const VkDescriptorSetLayoutBinding,
}
#[test]
fn bindgen_test_layout_VkDescriptorSetLayoutCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorSetLayoutCreateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkDescriptorSetLayoutCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorSetLayoutCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorSetLayoutCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutCreateInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutCreateInfo>())).bindingCount as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutCreateInfo),
            "::",
            stringify!(bindingCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutCreateInfo>())).pBindings as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutCreateInfo),
            "::",
            stringify!(pBindings)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkWriteDescriptorSet {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub dstSet: VkDescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: VkDescriptorType,
    pub pImageInfo: *const VkDescriptorImageInfo,
    pub pBufferInfo: *const VkDescriptorBufferInfo,
    pub pTexelBufferView: *const VkBufferView,
}
#[test]
fn bindgen_test_layout_VkWriteDescriptorSet() {
    assert_eq!(
        ::std::mem::size_of::<VkWriteDescriptorSet>(),
        64usize,
        concat!("Size of: ", stringify!(VkWriteDescriptorSet))
    );
    assert_eq!(
        ::std::mem::align_of::<VkWriteDescriptorSet>(),
        8usize,
        concat!("Alignment of ", stringify!(VkWriteDescriptorSet))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkWriteDescriptorSet>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkWriteDescriptorSet>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkWriteDescriptorSet>())).dstSet as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(dstSet)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkWriteDescriptorSet>())).dstBinding as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(dstBinding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkWriteDescriptorSet>())).dstArrayElement as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(dstArrayElement)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkWriteDescriptorSet>())).descriptorCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(descriptorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkWriteDescriptorSet>())).descriptorType as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(descriptorType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkWriteDescriptorSet>())).pImageInfo as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(pImageInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkWriteDescriptorSet>())).pBufferInfo as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(pBufferInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkWriteDescriptorSet>())).pTexelBufferView as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkWriteDescriptorSet),
            "::",
            stringify!(pTexelBufferView)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescription {
    pub flags: VkAttachmentDescriptionFlags,
    pub format: VkFormat,
    pub samples: VkSampleCountFlagBits,
    pub loadOp: VkAttachmentLoadOp,
    pub storeOp: VkAttachmentStoreOp,
    pub stencilLoadOp: VkAttachmentLoadOp,
    pub stencilStoreOp: VkAttachmentStoreOp,
    pub initialLayout: VkImageLayout,
    pub finalLayout: VkImageLayout,
}
#[test]
fn bindgen_test_layout_VkAttachmentDescription() {
    assert_eq!(
        ::std::mem::size_of::<VkAttachmentDescription>(),
        36usize,
        concat!("Size of: ", stringify!(VkAttachmentDescription))
    );
    assert_eq!(
        ::std::mem::align_of::<VkAttachmentDescription>(),
        4usize,
        concat!("Alignment of ", stringify!(VkAttachmentDescription))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription>())).format as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription>())).samples as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription>())).loadOp as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(loadOp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription>())).storeOp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(storeOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription>())).stencilLoadOp as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(stencilLoadOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription>())).stencilStoreOp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(stencilStoreOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription>())).initialLayout as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(initialLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription>())).finalLayout as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription),
            "::",
            stringify!(finalLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReference {
    pub attachment: u32,
    pub layout: VkImageLayout,
}
#[test]
fn bindgen_test_layout_VkAttachmentReference() {
    assert_eq!(
        ::std::mem::size_of::<VkAttachmentReference>(),
        8usize,
        concat!("Size of: ", stringify!(VkAttachmentReference))
    );
    assert_eq!(
        ::std::mem::align_of::<VkAttachmentReference>(),
        4usize,
        concat!("Alignment of ", stringify!(VkAttachmentReference))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentReference>())).attachment as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReference),
            "::",
            stringify!(attachment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentReference>())).layout as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReference),
            "::",
            stringify!(layout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkFramebufferCreateFlags,
    pub renderPass: VkRenderPass,
    pub attachmentCount: u32,
    pub pAttachments: *const VkImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}
#[test]
fn bindgen_test_layout_VkFramebufferCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkFramebufferCreateInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VkFramebufferCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkFramebufferCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkFramebufferCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).renderPass as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(renderPass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).attachmentCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(attachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).pAttachments as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(pAttachments)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).width as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).height as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFramebufferCreateInfo>())).layers as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferCreateInfo),
            "::",
            stringify!(layers)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescription {
    pub flags: VkSubpassDescriptionFlags,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const VkAttachmentReference,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const VkAttachmentReference,
    pub pResolveAttachments: *const VkAttachmentReference,
    pub pDepthStencilAttachment: *const VkAttachmentReference,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}
#[test]
fn bindgen_test_layout_VkSubpassDescription() {
    assert_eq!(
        ::std::mem::size_of::<VkSubpassDescription>(),
        72usize,
        concat!("Size of: ", stringify!(VkSubpassDescription))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubpassDescription>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSubpassDescription))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDescription>())).flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).pipelineBindPoint as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(pipelineBindPoint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).inputAttachmentCount as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(inputAttachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).pInputAttachments as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(pInputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).colorAttachmentCount as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(colorAttachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).pColorAttachments as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(pColorAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).pResolveAttachments as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(pResolveAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).pDepthStencilAttachment as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(pDepthStencilAttachment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).preserveAttachmentCount as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(preserveAttachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription>())).pPreserveAttachments as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription),
            "::",
            stringify!(pPreserveAttachments)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDependency {
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: VkPipelineStageFlags,
    pub dstStageMask: VkPipelineStageFlags,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub dependencyFlags: VkDependencyFlags,
}
#[test]
fn bindgen_test_layout_VkSubpassDependency() {
    assert_eq!(
        ::std::mem::size_of::<VkSubpassDependency>(),
        28usize,
        concat!("Size of: ", stringify!(VkSubpassDependency))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubpassDependency>(),
        4usize,
        concat!("Alignment of ", stringify!(VkSubpassDependency))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDependency>())).srcSubpass as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency),
            "::",
            stringify!(srcSubpass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDependency>())).dstSubpass as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency),
            "::",
            stringify!(dstSubpass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency>())).srcStageMask as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency),
            "::",
            stringify!(srcStageMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency>())).dstStageMask as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency),
            "::",
            stringify!(dstStageMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency>())).srcAccessMask as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency),
            "::",
            stringify!(srcAccessMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency>())).dstAccessMask as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency),
            "::",
            stringify!(dstAccessMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency>())).dependencyFlags as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency),
            "::",
            stringify!(dependencyFlags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const VkAttachmentDescription,
    pub subpassCount: u32,
    pub pSubpasses: *const VkSubpassDescription,
    pub dependencyCount: u32,
    pub pDependencies: *const VkSubpassDependency,
}
#[test]
fn bindgen_test_layout_VkRenderPassCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkRenderPassCreateInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VkRenderPassCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkRenderPassCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkRenderPassCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).attachmentCount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(attachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).pAttachments as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(pAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).subpassCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(subpassCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).pSubpasses as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(pSubpasses)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).dependencyCount as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(dependencyCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo>())).pDependencies as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo),
            "::",
            stringify!(pDependencies)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandPoolCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkCommandPoolCreateFlags,
    pub queueFamilyIndex: u32,
}
#[test]
fn bindgen_test_layout_VkCommandPoolCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkCommandPoolCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkCommandPoolCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkCommandPoolCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkCommandPoolCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCommandPoolCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandPoolCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCommandPoolCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandPoolCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCommandPoolCreateInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandPoolCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandPoolCreateInfo>())).queueFamilyIndex as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandPoolCreateInfo),
            "::",
            stringify!(queueFamilyIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub commandPool: VkCommandPool,
    pub level: VkCommandBufferLevel,
    pub commandBufferCount: u32,
}
#[test]
fn bindgen_test_layout_VkCommandBufferAllocateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkCommandBufferAllocateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkCommandBufferAllocateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkCommandBufferAllocateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkCommandBufferAllocateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferAllocateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferAllocateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferAllocateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferAllocateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferAllocateInfo>())).commandPool as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferAllocateInfo),
            "::",
            stringify!(commandPool)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferAllocateInfo>())).level as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferAllocateInfo),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferAllocateInfo>())).commandBufferCount as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferAllocateInfo),
            "::",
            stringify!(commandBufferCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferInheritanceInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub renderPass: VkRenderPass,
    pub subpass: u32,
    pub framebuffer: VkFramebuffer,
    pub occlusionQueryEnable: VkBool32,
    pub queryFlags: VkQueryControlFlags,
    pub pipelineStatistics: VkQueryPipelineStatisticFlags,
}
#[test]
fn bindgen_test_layout_VkCommandBufferInheritanceInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkCommandBufferInheritanceInfo>(),
        56usize,
        concat!("Size of: ", stringify!(VkCommandBufferInheritanceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkCommandBufferInheritanceInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkCommandBufferInheritanceInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).renderPass as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(renderPass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).subpass as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(subpass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).framebuffer as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(framebuffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).occlusionQueryEnable
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(occlusionQueryEnable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).queryFlags as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(queryFlags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferInheritanceInfo>())).pipelineStatistics
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferInheritanceInfo),
            "::",
            stringify!(pipelineStatistics)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkCommandBufferBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkCommandBufferUsageFlags,
    pub pInheritanceInfo: *const VkCommandBufferInheritanceInfo,
}
#[test]
fn bindgen_test_layout_VkCommandBufferBeginInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkCommandBufferBeginInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkCommandBufferBeginInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkCommandBufferBeginInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkCommandBufferBeginInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCommandBufferBeginInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferBeginInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCommandBufferBeginInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferBeginInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkCommandBufferBeginInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferBeginInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkCommandBufferBeginInfo>())).pInheritanceInfo as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkCommandBufferBeginInfo),
            "::",
            stringify!(pInheritanceInfo)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferCopy {
    pub srcOffset: VkDeviceSize,
    pub dstOffset: VkDeviceSize,
    pub size: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkBufferCopy() {
    assert_eq!(
        ::std::mem::size_of::<VkBufferCopy>(),
        24usize,
        concat!("Size of: ", stringify!(VkBufferCopy))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBufferCopy>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBufferCopy))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCopy>())).srcOffset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCopy),
            "::",
            stringify!(srcOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCopy>())).dstOffset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCopy),
            "::",
            stringify!(dstOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferCopy>())).size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferCopy),
            "::",
            stringify!(size)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSubresourceLayers {
    pub aspectMask: VkImageAspectFlags,
    pub mipLevel: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[test]
fn bindgen_test_layout_VkImageSubresourceLayers() {
    assert_eq!(
        ::std::mem::size_of::<VkImageSubresourceLayers>(),
        16usize,
        concat!("Size of: ", stringify!(VkImageSubresourceLayers))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageSubresourceLayers>(),
        4usize,
        concat!("Alignment of ", stringify!(VkImageSubresourceLayers))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceLayers>())).aspectMask as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceLayers),
            "::",
            stringify!(aspectMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceLayers>())).mipLevel as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceLayers),
            "::",
            stringify!(mipLevel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceLayers>())).baseArrayLayer as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceLayers),
            "::",
            stringify!(baseArrayLayer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSubresourceLayers>())).layerCount as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSubresourceLayers),
            "::",
            stringify!(layerCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferImageCopy {
    pub bufferOffset: VkDeviceSize,
    pub bufferRowLength: u32,
    pub bufferImageHeight: u32,
    pub imageSubresource: VkImageSubresourceLayers,
    pub imageOffset: VkOffset3D,
    pub imageExtent: VkExtent3D,
}
#[test]
fn bindgen_test_layout_VkBufferImageCopy() {
    assert_eq!(
        ::std::mem::size_of::<VkBufferImageCopy>(),
        56usize,
        concat!("Size of: ", stringify!(VkBufferImageCopy))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBufferImageCopy>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBufferImageCopy))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferImageCopy>())).bufferOffset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferImageCopy),
            "::",
            stringify!(bufferOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferImageCopy>())).bufferRowLength as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferImageCopy),
            "::",
            stringify!(bufferRowLength)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferImageCopy>())).bufferImageHeight as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferImageCopy),
            "::",
            stringify!(bufferImageHeight)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferImageCopy>())).imageSubresource as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferImageCopy),
            "::",
            stringify!(imageSubresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferImageCopy>())).imageOffset as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferImageCopy),
            "::",
            stringify!(imageOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBufferImageCopy>())).imageExtent as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferImageCopy),
            "::",
            stringify!(imageExtent)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkClearColorValue {
    pub float32: [f32; 4usize],
    pub int32: [i32; 4usize],
    pub uint32: [u32; 4usize],
    _bindgen_union_align: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_VkClearColorValue() {
    assert_eq!(
        ::std::mem::size_of::<VkClearColorValue>(),
        16usize,
        concat!("Size of: ", stringify!(VkClearColorValue))
    );
    assert_eq!(
        ::std::mem::align_of::<VkClearColorValue>(),
        4usize,
        concat!("Alignment of ", stringify!(VkClearColorValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearColorValue>())).float32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearColorValue),
            "::",
            stringify!(float32)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearColorValue>())).int32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearColorValue),
            "::",
            stringify!(int32)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearColorValue>())).uint32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearColorValue),
            "::",
            stringify!(uint32)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}
#[test]
fn bindgen_test_layout_VkClearDepthStencilValue() {
    assert_eq!(
        ::std::mem::size_of::<VkClearDepthStencilValue>(),
        8usize,
        concat!("Size of: ", stringify!(VkClearDepthStencilValue))
    );
    assert_eq!(
        ::std::mem::align_of::<VkClearDepthStencilValue>(),
        4usize,
        concat!("Alignment of ", stringify!(VkClearDepthStencilValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearDepthStencilValue>())).depth as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearDepthStencilValue),
            "::",
            stringify!(depth)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkClearDepthStencilValue>())).stencil as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearDepthStencilValue),
            "::",
            stringify!(stencil)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union VkClearValue {
    pub color: VkClearColorValue,
    pub depthStencil: VkClearDepthStencilValue,
    _bindgen_union_align: [u32; 4usize],
}
#[test]
fn bindgen_test_layout_VkClearValue() {
    assert_eq!(
        ::std::mem::size_of::<VkClearValue>(),
        16usize,
        concat!("Size of: ", stringify!(VkClearValue))
    );
    assert_eq!(
        ::std::mem::align_of::<VkClearValue>(),
        4usize,
        concat!("Alignment of ", stringify!(VkClearValue))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearValue>())).color as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearValue),
            "::",
            stringify!(color)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearValue>())).depthStencil as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearValue),
            "::",
            stringify!(depthStencil)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkClearAttachment {
    pub aspectMask: VkImageAspectFlags,
    pub colorAttachment: u32,
    pub clearValue: VkClearValue,
}
#[test]
fn bindgen_test_layout_VkClearAttachment() {
    assert_eq!(
        ::std::mem::size_of::<VkClearAttachment>(),
        24usize,
        concat!("Size of: ", stringify!(VkClearAttachment))
    );
    assert_eq!(
        ::std::mem::align_of::<VkClearAttachment>(),
        4usize,
        concat!("Alignment of ", stringify!(VkClearAttachment))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearAttachment>())).aspectMask as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearAttachment),
            "::",
            stringify!(aspectMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkClearAttachment>())).colorAttachment as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearAttachment),
            "::",
            stringify!(colorAttachment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearAttachment>())).clearValue as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearAttachment),
            "::",
            stringify!(clearValue)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkClearRect {
    pub rect: VkRect2D,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}
#[test]
fn bindgen_test_layout_VkClearRect() {
    assert_eq!(
        ::std::mem::size_of::<VkClearRect>(),
        24usize,
        concat!("Size of: ", stringify!(VkClearRect))
    );
    assert_eq!(
        ::std::mem::align_of::<VkClearRect>(),
        4usize,
        concat!("Alignment of ", stringify!(VkClearRect))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearRect>())).rect as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearRect),
            "::",
            stringify!(rect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearRect>())).baseArrayLayer as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearRect),
            "::",
            stringify!(baseArrayLayer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkClearRect>())).layerCount as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkClearRect),
            "::",
            stringify!(layerCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageBlit {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffsets: [VkOffset3D; 2usize],
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffsets: [VkOffset3D; 2usize],
}
#[test]
fn bindgen_test_layout_VkImageBlit() {
    assert_eq!(
        ::std::mem::size_of::<VkImageBlit>(),
        80usize,
        concat!("Size of: ", stringify!(VkImageBlit))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageBlit>(),
        4usize,
        concat!("Alignment of ", stringify!(VkImageBlit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageBlit>())).srcSubresource as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageBlit),
            "::",
            stringify!(srcSubresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageBlit>())).srcOffsets as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageBlit),
            "::",
            stringify!(srcOffsets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageBlit>())).dstSubresource as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageBlit),
            "::",
            stringify!(dstSubresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageBlit>())).dstOffsets as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageBlit),
            "::",
            stringify!(dstOffsets)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageCopy {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[test]
fn bindgen_test_layout_VkImageCopy() {
    assert_eq!(
        ::std::mem::size_of::<VkImageCopy>(),
        68usize,
        concat!("Size of: ", stringify!(VkImageCopy))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageCopy>(),
        4usize,
        concat!("Alignment of ", stringify!(VkImageCopy))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCopy>())).srcSubresource as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCopy),
            "::",
            stringify!(srcSubresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCopy>())).srcOffset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCopy),
            "::",
            stringify!(srcOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCopy>())).dstSubresource as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCopy),
            "::",
            stringify!(dstSubresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCopy>())).dstOffset as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCopy),
            "::",
            stringify!(dstOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageCopy>())).extent as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageCopy),
            "::",
            stringify!(extent)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageResolve {
    pub srcSubresource: VkImageSubresourceLayers,
    pub srcOffset: VkOffset3D,
    pub dstSubresource: VkImageSubresourceLayers,
    pub dstOffset: VkOffset3D,
    pub extent: VkExtent3D,
}
#[test]
fn bindgen_test_layout_VkImageResolve() {
    assert_eq!(
        ::std::mem::size_of::<VkImageResolve>(),
        68usize,
        concat!("Size of: ", stringify!(VkImageResolve))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageResolve>(),
        4usize,
        concat!("Alignment of ", stringify!(VkImageResolve))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageResolve>())).srcSubresource as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageResolve),
            "::",
            stringify!(srcSubresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageResolve>())).srcOffset as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageResolve),
            "::",
            stringify!(srcOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageResolve>())).dstSubresource as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageResolve),
            "::",
            stringify!(dstSubresource)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageResolve>())).dstOffset as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageResolve),
            "::",
            stringify!(dstOffset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageResolve>())).extent as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageResolve),
            "::",
            stringify!(extent)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub renderPass: VkRenderPass,
    pub framebuffer: VkFramebuffer,
    pub renderArea: VkRect2D,
    pub clearValueCount: u32,
    pub pClearValues: *const VkClearValue,
}
#[test]
fn bindgen_test_layout_VkRenderPassBeginInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkRenderPassBeginInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VkRenderPassBeginInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkRenderPassBeginInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkRenderPassBeginInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassBeginInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassBeginInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassBeginInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassBeginInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassBeginInfo>())).renderPass as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassBeginInfo),
            "::",
            stringify!(renderPass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassBeginInfo>())).framebuffer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassBeginInfo),
            "::",
            stringify!(framebuffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassBeginInfo>())).renderArea as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassBeginInfo),
            "::",
            stringify!(renderArea)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassBeginInfo>())).clearValueCount as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassBeginInfo),
            "::",
            stringify!(clearValueCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassBeginInfo>())).pClearValues as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassBeginInfo),
            "::",
            stringify!(pClearValues)
        )
    );
}
pub type PFN_vkCreateInstance = ::std::option::Option<
    unsafe extern "C" fn(
        pCreateInfo: *const VkInstanceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pInstance: *mut VkInstance,
    ) -> VkResult,
>;
pub type PFN_vkDestroyInstance = ::std::option::Option<
    unsafe extern "C" fn(instance: VkInstance, pAllocator: *const VkAllocationCallbacks),
>;
pub type PFN_vkEnumeratePhysicalDevices = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceCount: *mut u32,
        pPhysicalDevices: *mut VkPhysicalDevice,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceFeatures = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures,
    ),
>;
pub type PFN_vkGetPhysicalDeviceFormatProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        pImageFormatProperties: *mut VkImageFormatProperties,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceMemoryProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties,
    ),
>;
pub type PFN_vkGetInstanceProcAddr = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction,
>;
pub type PFN_vkGetDeviceProcAddr = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction,
>;
pub type PFN_vkCreateDevice = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pCreateInfo: *const VkDeviceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDevice: *mut VkDevice,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDevice = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, pAllocator: *const VkAllocationCallbacks),
>;
pub type PFN_vkEnumerateInstanceExtensionProperties = ::std::option::Option<
    unsafe extern "C" fn(
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult,
>;
pub type PFN_vkEnumerateDeviceExtensionProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult,
>;
pub type PFN_vkEnumerateInstanceLayerProperties = ::std::option::Option<
    unsafe extern "C" fn(pPropertyCount: *mut u32, pProperties: *mut VkLayerProperties) -> VkResult,
>;
pub type PFN_vkEnumerateDeviceLayerProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkLayerProperties,
    ) -> VkResult,
>;
pub type PFN_vkGetDeviceQueue = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queueFamilyIndex: u32,
        queueIndex: u32,
        pQueue: *mut VkQueue,
    ),
>;
pub type PFN_vkQueueSubmit = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo,
        fence: VkFence,
    ) -> VkResult,
>;
pub type PFN_vkQueueWaitIdle =
    ::std::option::Option<unsafe extern "C" fn(queue: VkQueue) -> VkResult>;
pub type PFN_vkDeviceWaitIdle =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice) -> VkResult>;
pub type PFN_vkAllocateMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkMemoryAllocateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pMemory: *mut VkDeviceMemory,
    ) -> VkResult,
>;
pub type PFN_vkFreeMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkMapMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        offset: VkDeviceSize,
        size: VkDeviceSize,
        flags: VkMemoryMapFlags,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkUnmapMemory =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, memory: VkDeviceMemory)>;
pub type PFN_vkFlushMappedMemoryRanges = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult,
>;
pub type PFN_vkInvalidateMappedMemoryRanges = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult,
>;
pub type PFN_vkGetDeviceMemoryCommitment = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        memory: VkDeviceMemory,
        pCommittedMemoryInBytes: *mut VkDeviceSize,
    ),
>;
pub type PFN_vkBindBufferMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult,
>;
pub type PFN_vkBindImageMemory = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult,
>;
pub type PFN_vkGetBufferMemoryRequirements = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        pMemoryRequirements: *mut VkMemoryRequirements,
    ),
>;
pub type PFN_vkGetImageMemoryRequirements = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pMemoryRequirements: *mut VkMemoryRequirements,
    ),
>;
pub type PFN_vkGetImageSparseMemoryRequirements = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements,
    ),
>;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        samples: VkSampleCountFlagBits,
        usage: VkImageUsageFlags,
        tiling: VkImageTiling,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties,
    ),
>;
pub type PFN_vkQueueBindSparse = ::std::option::Option<
    unsafe extern "C" fn(
        queue: VkQueue,
        bindInfoCount: u32,
        pBindInfo: *const VkBindSparseInfo,
        fence: VkFence,
    ) -> VkResult,
>;
pub type PFN_vkCreateFence = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkFenceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult,
>;
pub type PFN_vkDestroyFence = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        fence: VkFence,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkResetFences = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, fenceCount: u32, pFences: *const VkFence) -> VkResult,
>;
pub type PFN_vkGetFenceStatus =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, fence: VkFence) -> VkResult>;
pub type PFN_vkWaitForFences = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        fenceCount: u32,
        pFences: *const VkFence,
        waitAll: VkBool32,
        timeout: u64,
    ) -> VkResult,
>;
pub type PFN_vkCreateSemaphore = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSemaphoreCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSemaphore: *mut VkSemaphore,
    ) -> VkResult,
>;
pub type PFN_vkDestroySemaphore = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        semaphore: VkSemaphore,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateEvent = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkEventCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pEvent: *mut VkEvent,
    ) -> VkResult,
>;
pub type PFN_vkDestroyEvent = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        event: VkEvent,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetEventStatus =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult>;
pub type PFN_vkSetEvent =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult>;
pub type PFN_vkResetEvent =
    ::std::option::Option<unsafe extern "C" fn(device: VkDevice, event: VkEvent) -> VkResult>;
pub type PFN_vkCreateQueryPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkQueryPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pQueryPool: *mut VkQueryPool,
    ) -> VkResult,
>;
pub type PFN_vkDestroyQueryPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetQueryPoolResults = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    ) -> VkResult,
>;
pub type PFN_vkCreateBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkBufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pBuffer: *mut VkBuffer,
    ) -> VkResult,
>;
pub type PFN_vkDestroyBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        buffer: VkBuffer,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateBufferView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkBufferViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkBufferView,
    ) -> VkResult,
>;
pub type PFN_vkDestroyBufferView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bufferView: VkBufferView,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateImage = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkImageCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pImage: *mut VkImage,
    ) -> VkResult,
>;
pub type PFN_vkDestroyImage = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetImageSubresourceLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        image: VkImage,
        pSubresource: *const VkImageSubresource,
        pLayout: *mut VkSubresourceLayout,
    ),
>;
pub type PFN_vkCreateImageView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkImageViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkImageView,
    ) -> VkResult,
>;
pub type PFN_vkDestroyImageView = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        imageView: VkImageView,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateShaderModule = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkShaderModuleCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pShaderModule: *mut VkShaderModule,
    ) -> VkResult,
>;
pub type PFN_vkDestroyShaderModule = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        shaderModule: VkShaderModule,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreatePipelineCache = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPipelineCacheCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineCache: *mut VkPipelineCache,
    ) -> VkResult,
>;
pub type PFN_vkDestroyPipelineCache = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetPipelineCacheData = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult,
>;
pub type PFN_vkMergePipelineCaches = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        dstCache: VkPipelineCache,
        srcCacheCount: u32,
        pSrcCaches: *const VkPipelineCache,
    ) -> VkResult,
>;
pub type PFN_vkCreateGraphicsPipelines = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkGraphicsPipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult,
>;
pub type PFN_vkCreateComputePipelines = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkComputePipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult,
>;
pub type PFN_vkDestroyPipeline = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipeline: VkPipeline,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreatePipelineLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkPipelineLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineLayout: *mut VkPipelineLayout,
    ) -> VkResult,
>;
pub type PFN_vkDestroyPipelineLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pipelineLayout: VkPipelineLayout,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateSampler = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSampler: *mut VkSampler,
    ) -> VkResult,
>;
pub type PFN_vkDestroySampler = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        sampler: VkSampler,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateDescriptorSetLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSetLayout: *mut VkDescriptorSetLayout,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDescriptorSetLayout = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSetLayout: VkDescriptorSetLayout,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateDescriptorPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorPool: *mut VkDescriptorPool,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDescriptorPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkResetDescriptorPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        flags: VkDescriptorPoolResetFlags,
    ) -> VkResult,
>;
pub type PFN_vkAllocateDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkDescriptorSetAllocateInfo,
        pDescriptorSets: *mut VkDescriptorSet,
    ) -> VkResult,
>;
pub type PFN_vkFreeDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
    ) -> VkResult,
>;
pub type PFN_vkUpdateDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
        descriptorCopyCount: u32,
        pDescriptorCopies: *const VkCopyDescriptorSet,
    ),
>;
pub type PFN_vkCreateFramebuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkFramebufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFramebuffer: *mut VkFramebuffer,
    ) -> VkResult,
>;
pub type PFN_vkDestroyFramebuffer = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        framebuffer: VkFramebuffer,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateRenderPass = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult,
>;
pub type PFN_vkDestroyRenderPass = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        renderPass: VkRenderPass,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkGetRenderAreaGranularity = ::std::option::Option<
    unsafe extern "C" fn(device: VkDevice, renderPass: VkRenderPass, pGranularity: *mut VkExtent2D),
>;
pub type PFN_vkCreateCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkCommandPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pCommandPool: *mut VkCommandPool,
    ) -> VkResult,
>;
pub type PFN_vkDestroyCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkResetCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolResetFlags,
    ) -> VkResult,
>;
pub type PFN_vkAllocateCommandBuffers = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pAllocateInfo: *const VkCommandBufferAllocateInfo,
        pCommandBuffers: *mut VkCommandBuffer,
    ) -> VkResult,
>;
pub type PFN_vkFreeCommandBuffers = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    ),
>;
pub type PFN_vkBeginCommandBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pBeginInfo: *const VkCommandBufferBeginInfo,
    ) -> VkResult,
>;
pub type PFN_vkEndCommandBuffer =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer) -> VkResult>;
pub type PFN_vkResetCommandBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        flags: VkCommandBufferResetFlags,
    ) -> VkResult,
>;
pub type PFN_vkCmdBindPipeline = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
    ),
>;
pub type PFN_vkCmdSetViewport = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewports: *const VkViewport,
    ),
>;
pub type PFN_vkCmdSetScissor = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstScissor: u32,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    ),
>;
pub type PFN_vkCmdSetLineWidth =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer, lineWidth: f32)>;
pub type PFN_vkCmdSetDepthBias = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        depthBiasConstantFactor: f32,
        depthBiasClamp: f32,
        depthBiasSlopeFactor: f32,
    ),
>;
pub type PFN_vkCmdSetBlendConstants = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, blendConstants: *const f32),
>;
pub type PFN_vkCmdSetDepthBounds = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, minDepthBounds: f32, maxDepthBounds: f32),
>;
pub type PFN_vkCmdSetStencilCompareMask = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        compareMask: u32,
    ),
>;
pub type PFN_vkCmdSetStencilWriteMask = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        writeMask: u32,
    ),
>;
pub type PFN_vkCmdSetStencilReference = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        reference: u32,
    ),
>;
pub type PFN_vkCmdBindDescriptorSets = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        firstSet: u32,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
        dynamicOffsetCount: u32,
        pDynamicOffsets: *const u32,
    ),
>;
pub type PFN_vkCmdBindIndexBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        indexType: VkIndexType,
    ),
>;
pub type PFN_vkCmdBindVertexBuffers = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
    ),
>;
pub type PFN_vkCmdDraw = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        vertexCount: u32,
        instanceCount: u32,
        firstVertex: u32,
        firstInstance: u32,
    ),
>;
pub type PFN_vkCmdDrawIndexed = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        indexCount: u32,
        instanceCount: u32,
        firstIndex: u32,
        vertexOffset: i32,
        firstInstance: u32,
    ),
>;
pub type PFN_vkCmdDrawIndirect = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDrawIndexedIndirect = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    ),
>;
pub type PFN_vkCmdDispatch = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ),
>;
pub type PFN_vkCmdDispatchIndirect = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, buffer: VkBuffer, offset: VkDeviceSize),
>;
pub type PFN_vkCmdCopyBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferCopy,
    ),
>;
pub type PFN_vkCmdCopyImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageCopy,
    ),
>;
pub type PFN_vkCmdBlitImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageBlit,
        filter: VkFilter,
    ),
>;
pub type PFN_vkCmdCopyBufferToImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    ),
>;
pub type PFN_vkCmdCopyImageToBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    ),
>;
pub type PFN_vkCmdUpdateBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        dataSize: VkDeviceSize,
        pData: *const ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkCmdFillBuffer = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        size: VkDeviceSize,
        data: u32,
    ),
>;
pub type PFN_vkCmdClearColorImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pColor: *const VkClearColorValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    ),
>;
pub type PFN_vkCmdClearDepthStencilImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pDepthStencil: *const VkClearDepthStencilValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    ),
>;
pub type PFN_vkCmdClearAttachments = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        attachmentCount: u32,
        pAttachments: *const VkClearAttachment,
        rectCount: u32,
        pRects: *const VkClearRect,
    ),
>;
pub type PFN_vkCmdResolveImage = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageResolve,
    ),
>;
pub type PFN_vkCmdSetEvent = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    ),
>;
pub type PFN_vkCmdResetEvent = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    ),
>;
pub type PFN_vkCmdWaitEvents = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    ),
>;
pub type PFN_vkCmdPipelineBarrier = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        dependencyFlags: VkDependencyFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    ),
>;
pub type PFN_vkCmdBeginQuery = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
    ),
>;
pub type PFN_vkCmdEndQuery = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, queryPool: VkQueryPool, query: u32),
>;
pub type PFN_vkCmdResetQueryPool = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    ),
>;
pub type PFN_vkCmdWriteTimestamp = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        queryPool: VkQueryPool,
        query: u32,
    ),
>;
pub type PFN_vkCmdCopyQueryPoolResults = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    ),
>;
pub type PFN_vkCmdPushConstants = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        layout: VkPipelineLayout,
        stageFlags: VkShaderStageFlags,
        offset: u32,
        size: u32,
        pValues: *const ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkCmdBeginRenderPass = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        contents: VkSubpassContents,
    ),
>;
pub type PFN_vkCmdNextSubpass = ::std::option::Option<
    unsafe extern "C" fn(commandBuffer: VkCommandBuffer, contents: VkSubpassContents),
>;
pub type PFN_vkCmdEndRenderPass =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer)>;
pub type PFN_vkCmdExecuteCommands = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    ),
>;
extern "C" {
    pub fn vkCreateInstance(
        pCreateInfo: *const VkInstanceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pInstance: *mut VkInstance,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyInstance(instance: VkInstance, pAllocator: *const VkAllocationCallbacks);
}
extern "C" {
    pub fn vkEnumeratePhysicalDevices(
        instance: VkInstance,
        pPhysicalDeviceCount: *mut u32,
        pPhysicalDevices: *mut VkPhysicalDevice,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceFeatures(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceFormatProperties(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceImageFormatProperties(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        tiling: VkImageTiling,
        usage: VkImageUsageFlags,
        flags: VkImageCreateFlags,
        pImageFormatProperties: *mut VkImageFormatProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceProperties(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceQueueFamilyProperties(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceMemoryProperties(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties,
    );
}
extern "C" {
    pub fn vkGetInstanceProcAddr(
        instance: VkInstance,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction;
}
extern "C" {
    pub fn vkGetDeviceProcAddr(
        device: VkDevice,
        pName: *const ::std::os::raw::c_char,
    ) -> PFN_vkVoidFunction;
}
extern "C" {
    pub fn vkCreateDevice(
        physicalDevice: VkPhysicalDevice,
        pCreateInfo: *const VkDeviceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDevice: *mut VkDevice,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDevice(device: VkDevice, pAllocator: *const VkAllocationCallbacks);
}
extern "C" {
    pub fn vkEnumerateInstanceExtensionProperties(
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEnumerateDeviceExtensionProperties(
        physicalDevice: VkPhysicalDevice,
        pLayerName: *const ::std::os::raw::c_char,
        pPropertyCount: *mut u32,
        pProperties: *mut VkExtensionProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEnumerateInstanceLayerProperties(
        pPropertyCount: *mut u32,
        pProperties: *mut VkLayerProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEnumerateDeviceLayerProperties(
        physicalDevice: VkPhysicalDevice,
        pPropertyCount: *mut u32,
        pProperties: *mut VkLayerProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceQueue(
        device: VkDevice,
        queueFamilyIndex: u32,
        queueIndex: u32,
        pQueue: *mut VkQueue,
    );
}
extern "C" {
    pub fn vkQueueSubmit(
        queue: VkQueue,
        submitCount: u32,
        pSubmits: *const VkSubmitInfo,
        fence: VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkQueueWaitIdle(queue: VkQueue) -> VkResult;
}
extern "C" {
    pub fn vkDeviceWaitIdle(device: VkDevice) -> VkResult;
}
extern "C" {
    pub fn vkAllocateMemory(
        device: VkDevice,
        pAllocateInfo: *const VkMemoryAllocateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pMemory: *mut VkDeviceMemory,
    ) -> VkResult;
}
extern "C" {
    pub fn vkFreeMemory(
        device: VkDevice,
        memory: VkDeviceMemory,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkMapMemory(
        device: VkDevice,
        memory: VkDeviceMemory,
        offset: VkDeviceSize,
        size: VkDeviceSize,
        flags: VkMemoryMapFlags,
        ppData: *mut *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkUnmapMemory(device: VkDevice, memory: VkDeviceMemory);
}
extern "C" {
    pub fn vkFlushMappedMemoryRanges(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult;
}
extern "C" {
    pub fn vkInvalidateMappedMemoryRanges(
        device: VkDevice,
        memoryRangeCount: u32,
        pMemoryRanges: *const VkMappedMemoryRange,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceMemoryCommitment(
        device: VkDevice,
        memory: VkDeviceMemory,
        pCommittedMemoryInBytes: *mut VkDeviceSize,
    );
}
extern "C" {
    pub fn vkBindBufferMemory(
        device: VkDevice,
        buffer: VkBuffer,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    pub fn vkBindImageMemory(
        device: VkDevice,
        image: VkImage,
        memory: VkDeviceMemory,
        memoryOffset: VkDeviceSize,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetBufferMemoryRequirements(
        device: VkDevice,
        buffer: VkBuffer,
        pMemoryRequirements: *mut VkMemoryRequirements,
    );
}
extern "C" {
    pub fn vkGetImageMemoryRequirements(
        device: VkDevice,
        image: VkImage,
        pMemoryRequirements: *mut VkMemoryRequirements,
    );
}
extern "C" {
    pub fn vkGetImageSparseMemoryRequirements(
        device: VkDevice,
        image: VkImage,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceSparseImageFormatProperties(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        type_: VkImageType,
        samples: VkSampleCountFlagBits,
        usage: VkImageUsageFlags,
        tiling: VkImageTiling,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties,
    );
}
extern "C" {
    pub fn vkQueueBindSparse(
        queue: VkQueue,
        bindInfoCount: u32,
        pBindInfo: *const VkBindSparseInfo,
        fence: VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateFence(
        device: VkDevice,
        pCreateInfo: *const VkFenceCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFence: *mut VkFence,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyFence(
        device: VkDevice,
        fence: VkFence,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkResetFences(device: VkDevice, fenceCount: u32, pFences: *const VkFence) -> VkResult;
}
extern "C" {
    pub fn vkGetFenceStatus(device: VkDevice, fence: VkFence) -> VkResult;
}
extern "C" {
    pub fn vkWaitForFences(
        device: VkDevice,
        fenceCount: u32,
        pFences: *const VkFence,
        waitAll: VkBool32,
        timeout: u64,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateSemaphore(
        device: VkDevice,
        pCreateInfo: *const VkSemaphoreCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSemaphore: *mut VkSemaphore,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySemaphore(
        device: VkDevice,
        semaphore: VkSemaphore,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateEvent(
        device: VkDevice,
        pCreateInfo: *const VkEventCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pEvent: *mut VkEvent,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyEvent(
        device: VkDevice,
        event: VkEvent,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetEventStatus(device: VkDevice, event: VkEvent) -> VkResult;
}
extern "C" {
    pub fn vkSetEvent(device: VkDevice, event: VkEvent) -> VkResult;
}
extern "C" {
    pub fn vkResetEvent(device: VkDevice, event: VkEvent) -> VkResult;
}
extern "C" {
    pub fn vkCreateQueryPool(
        device: VkDevice,
        pCreateInfo: *const VkQueryPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pQueryPool: *mut VkQueryPool,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyQueryPool(
        device: VkDevice,
        queryPool: VkQueryPool,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetQueryPoolResults(
        device: VkDevice,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dataSize: size_t,
        pData: *mut ::std::os::raw::c_void,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateBuffer(
        device: VkDevice,
        pCreateInfo: *const VkBufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pBuffer: *mut VkBuffer,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyBuffer(
        device: VkDevice,
        buffer: VkBuffer,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateBufferView(
        device: VkDevice,
        pCreateInfo: *const VkBufferViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkBufferView,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyBufferView(
        device: VkDevice,
        bufferView: VkBufferView,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateImage(
        device: VkDevice,
        pCreateInfo: *const VkImageCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pImage: *mut VkImage,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyImage(
        device: VkDevice,
        image: VkImage,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetImageSubresourceLayout(
        device: VkDevice,
        image: VkImage,
        pSubresource: *const VkImageSubresource,
        pLayout: *mut VkSubresourceLayout,
    );
}
extern "C" {
    pub fn vkCreateImageView(
        device: VkDevice,
        pCreateInfo: *const VkImageViewCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pView: *mut VkImageView,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyImageView(
        device: VkDevice,
        imageView: VkImageView,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateShaderModule(
        device: VkDevice,
        pCreateInfo: *const VkShaderModuleCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pShaderModule: *mut VkShaderModule,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyShaderModule(
        device: VkDevice,
        shaderModule: VkShaderModule,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreatePipelineCache(
        device: VkDevice,
        pCreateInfo: *const VkPipelineCacheCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineCache: *mut VkPipelineCache,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyPipelineCache(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetPipelineCacheData(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        pDataSize: *mut size_t,
        pData: *mut ::std::os::raw::c_void,
    ) -> VkResult;
}
extern "C" {
    pub fn vkMergePipelineCaches(
        device: VkDevice,
        dstCache: VkPipelineCache,
        srcCacheCount: u32,
        pSrcCaches: *const VkPipelineCache,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateGraphicsPipelines(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkGraphicsPipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCreateComputePipelines(
        device: VkDevice,
        pipelineCache: VkPipelineCache,
        createInfoCount: u32,
        pCreateInfos: *const VkComputePipelineCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelines: *mut VkPipeline,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyPipeline(
        device: VkDevice,
        pipeline: VkPipeline,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreatePipelineLayout(
        device: VkDevice,
        pCreateInfo: *const VkPipelineLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pPipelineLayout: *mut VkPipelineLayout,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyPipelineLayout(
        device: VkDevice,
        pipelineLayout: VkPipelineLayout,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateSampler(
        device: VkDevice,
        pCreateInfo: *const VkSamplerCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSampler: *mut VkSampler,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySampler(
        device: VkDevice,
        sampler: VkSampler,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateDescriptorSetLayout(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pSetLayout: *mut VkDescriptorSetLayout,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDescriptorSetLayout(
        device: VkDevice,
        descriptorSetLayout: VkDescriptorSetLayout,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateDescriptorPool(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorPool: *mut VkDescriptorPool,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDescriptorPool(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkResetDescriptorPool(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        flags: VkDescriptorPoolResetFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkAllocateDescriptorSets(
        device: VkDevice,
        pAllocateInfo: *const VkDescriptorSetAllocateInfo,
        pDescriptorSets: *mut VkDescriptorSet,
    ) -> VkResult;
}
extern "C" {
    pub fn vkFreeDescriptorSets(
        device: VkDevice,
        descriptorPool: VkDescriptorPool,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
    ) -> VkResult;
}
extern "C" {
    pub fn vkUpdateDescriptorSets(
        device: VkDevice,
        descriptorWriteCount: u32,
        pDescriptorWrites: *const VkWriteDescriptorSet,
        descriptorCopyCount: u32,
        pDescriptorCopies: *const VkCopyDescriptorSet,
    );
}
extern "C" {
    pub fn vkCreateFramebuffer(
        device: VkDevice,
        pCreateInfo: *const VkFramebufferCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pFramebuffer: *mut VkFramebuffer,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyFramebuffer(
        device: VkDevice,
        framebuffer: VkFramebuffer,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateRenderPass(
        device: VkDevice,
        pCreateInfo: *const VkRenderPassCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pRenderPass: *mut VkRenderPass,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyRenderPass(
        device: VkDevice,
        renderPass: VkRenderPass,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkGetRenderAreaGranularity(
        device: VkDevice,
        renderPass: VkRenderPass,
        pGranularity: *mut VkExtent2D,
    );
}
extern "C" {
    pub fn vkCreateCommandPool(
        device: VkDevice,
        pCreateInfo: *const VkCommandPoolCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pCommandPool: *mut VkCommandPool,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyCommandPool(
        device: VkDevice,
        commandPool: VkCommandPool,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkResetCommandPool(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolResetFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkAllocateCommandBuffers(
        device: VkDevice,
        pAllocateInfo: *const VkCommandBufferAllocateInfo,
        pCommandBuffers: *mut VkCommandBuffer,
    ) -> VkResult;
}
extern "C" {
    pub fn vkFreeCommandBuffers(
        device: VkDevice,
        commandPool: VkCommandPool,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    );
}
extern "C" {
    pub fn vkBeginCommandBuffer(
        commandBuffer: VkCommandBuffer,
        pBeginInfo: *const VkCommandBufferBeginInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkEndCommandBuffer(commandBuffer: VkCommandBuffer) -> VkResult;
}
extern "C" {
    pub fn vkResetCommandBuffer(
        commandBuffer: VkCommandBuffer,
        flags: VkCommandBufferResetFlags,
    ) -> VkResult;
}
extern "C" {
    pub fn vkCmdBindPipeline(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        pipeline: VkPipeline,
    );
}
extern "C" {
    pub fn vkCmdSetViewport(
        commandBuffer: VkCommandBuffer,
        firstViewport: u32,
        viewportCount: u32,
        pViewports: *const VkViewport,
    );
}
extern "C" {
    pub fn vkCmdSetScissor(
        commandBuffer: VkCommandBuffer,
        firstScissor: u32,
        scissorCount: u32,
        pScissors: *const VkRect2D,
    );
}
extern "C" {
    pub fn vkCmdSetLineWidth(commandBuffer: VkCommandBuffer, lineWidth: f32);
}
extern "C" {
    pub fn vkCmdSetDepthBias(
        commandBuffer: VkCommandBuffer,
        depthBiasConstantFactor: f32,
        depthBiasClamp: f32,
        depthBiasSlopeFactor: f32,
    );
}
extern "C" {
    pub fn vkCmdSetBlendConstants(commandBuffer: VkCommandBuffer, blendConstants: *const f32);
}
extern "C" {
    pub fn vkCmdSetDepthBounds(
        commandBuffer: VkCommandBuffer,
        minDepthBounds: f32,
        maxDepthBounds: f32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilCompareMask(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        compareMask: u32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilWriteMask(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        writeMask: u32,
    );
}
extern "C" {
    pub fn vkCmdSetStencilReference(
        commandBuffer: VkCommandBuffer,
        faceMask: VkStencilFaceFlags,
        reference: u32,
    );
}
extern "C" {
    pub fn vkCmdBindDescriptorSets(
        commandBuffer: VkCommandBuffer,
        pipelineBindPoint: VkPipelineBindPoint,
        layout: VkPipelineLayout,
        firstSet: u32,
        descriptorSetCount: u32,
        pDescriptorSets: *const VkDescriptorSet,
        dynamicOffsetCount: u32,
        pDynamicOffsets: *const u32,
    );
}
extern "C" {
    pub fn vkCmdBindIndexBuffer(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        indexType: VkIndexType,
    );
}
extern "C" {
    pub fn vkCmdBindVertexBuffers(
        commandBuffer: VkCommandBuffer,
        firstBinding: u32,
        bindingCount: u32,
        pBuffers: *const VkBuffer,
        pOffsets: *const VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdDraw(
        commandBuffer: VkCommandBuffer,
        vertexCount: u32,
        instanceCount: u32,
        firstVertex: u32,
        firstInstance: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndexed(
        commandBuffer: VkCommandBuffer,
        indexCount: u32,
        instanceCount: u32,
        firstIndex: u32,
        vertexOffset: i32,
        firstInstance: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndirect(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDrawIndexedIndirect(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
        drawCount: u32,
        stride: u32,
    );
}
extern "C" {
    pub fn vkCmdDispatch(
        commandBuffer: VkCommandBuffer,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    );
}
extern "C" {
    pub fn vkCmdDispatchIndirect(
        commandBuffer: VkCommandBuffer,
        buffer: VkBuffer,
        offset: VkDeviceSize,
    );
}
extern "C" {
    pub fn vkCmdCopyBuffer(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferCopy,
    );
}
extern "C" {
    pub fn vkCmdCopyImage(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageCopy,
    );
}
extern "C" {
    pub fn vkCmdBlitImage(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageBlit,
        filter: VkFilter,
    );
}
extern "C" {
    pub fn vkCmdCopyBufferToImage(
        commandBuffer: VkCommandBuffer,
        srcBuffer: VkBuffer,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    );
}
extern "C" {
    pub fn vkCmdCopyImageToBuffer(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstBuffer: VkBuffer,
        regionCount: u32,
        pRegions: *const VkBufferImageCopy,
    );
}
extern "C" {
    pub fn vkCmdUpdateBuffer(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        dataSize: VkDeviceSize,
        pData: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn vkCmdFillBuffer(
        commandBuffer: VkCommandBuffer,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        size: VkDeviceSize,
        data: u32,
    );
}
extern "C" {
    pub fn vkCmdClearColorImage(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pColor: *const VkClearColorValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    );
}
extern "C" {
    pub fn vkCmdClearDepthStencilImage(
        commandBuffer: VkCommandBuffer,
        image: VkImage,
        imageLayout: VkImageLayout,
        pDepthStencil: *const VkClearDepthStencilValue,
        rangeCount: u32,
        pRanges: *const VkImageSubresourceRange,
    );
}
extern "C" {
    pub fn vkCmdClearAttachments(
        commandBuffer: VkCommandBuffer,
        attachmentCount: u32,
        pAttachments: *const VkClearAttachment,
        rectCount: u32,
        pRects: *const VkClearRect,
    );
}
extern "C" {
    pub fn vkCmdResolveImage(
        commandBuffer: VkCommandBuffer,
        srcImage: VkImage,
        srcImageLayout: VkImageLayout,
        dstImage: VkImage,
        dstImageLayout: VkImageLayout,
        regionCount: u32,
        pRegions: *const VkImageResolve,
    );
}
extern "C" {
    pub fn vkCmdSetEvent(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    );
}
extern "C" {
    pub fn vkCmdResetEvent(
        commandBuffer: VkCommandBuffer,
        event: VkEvent,
        stageMask: VkPipelineStageFlags,
    );
}
extern "C" {
    pub fn vkCmdWaitEvents(
        commandBuffer: VkCommandBuffer,
        eventCount: u32,
        pEvents: *const VkEvent,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    );
}
extern "C" {
    pub fn vkCmdPipelineBarrier(
        commandBuffer: VkCommandBuffer,
        srcStageMask: VkPipelineStageFlags,
        dstStageMask: VkPipelineStageFlags,
        dependencyFlags: VkDependencyFlags,
        memoryBarrierCount: u32,
        pMemoryBarriers: *const VkMemoryBarrier,
        bufferMemoryBarrierCount: u32,
        pBufferMemoryBarriers: *const VkBufferMemoryBarrier,
        imageMemoryBarrierCount: u32,
        pImageMemoryBarriers: *const VkImageMemoryBarrier,
    );
}
extern "C" {
    pub fn vkCmdBeginQuery(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        query: u32,
        flags: VkQueryControlFlags,
    );
}
extern "C" {
    pub fn vkCmdEndQuery(commandBuffer: VkCommandBuffer, queryPool: VkQueryPool, query: u32);
}
extern "C" {
    pub fn vkCmdResetQueryPool(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
    );
}
extern "C" {
    pub fn vkCmdWriteTimestamp(
        commandBuffer: VkCommandBuffer,
        pipelineStage: VkPipelineStageFlagBits,
        queryPool: VkQueryPool,
        query: u32,
    );
}
extern "C" {
    pub fn vkCmdCopyQueryPoolResults(
        commandBuffer: VkCommandBuffer,
        queryPool: VkQueryPool,
        firstQuery: u32,
        queryCount: u32,
        dstBuffer: VkBuffer,
        dstOffset: VkDeviceSize,
        stride: VkDeviceSize,
        flags: VkQueryResultFlags,
    );
}
extern "C" {
    pub fn vkCmdPushConstants(
        commandBuffer: VkCommandBuffer,
        layout: VkPipelineLayout,
        stageFlags: VkShaderStageFlags,
        offset: u32,
        size: u32,
        pValues: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn vkCmdBeginRenderPass(
        commandBuffer: VkCommandBuffer,
        pRenderPassBegin: *const VkRenderPassBeginInfo,
        contents: VkSubpassContents,
    );
}
extern "C" {
    pub fn vkCmdNextSubpass(commandBuffer: VkCommandBuffer, contents: VkSubpassContents);
}
extern "C" {
    pub fn vkCmdEndRenderPass(commandBuffer: VkCommandBuffer);
}
extern "C" {
    pub fn vkCmdExecuteCommands(
        commandBuffer: VkCommandBuffer,
        commandBufferCount: u32,
        pCommandBuffers: *const VkCommandBuffer,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversion_T {
    _unused: [u8; 0],
}
pub type VkSamplerYcbcrConversion = *mut VkSamplerYcbcrConversion_T;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplate_T {
    _unused: [u8; 0],
}
pub type VkDescriptorUpdateTemplate = *mut VkDescriptorUpdateTemplate_T;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES:
    VkPointClippingBehavior = 0;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY:
    VkPointClippingBehavior = 1;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES_KHR:
    VkPointClippingBehavior = 0;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY_KHR:
    VkPointClippingBehavior = 1;
pub const VkPointClippingBehavior_VK_POINT_CLIPPING_BEHAVIOR_MAX_ENUM: VkPointClippingBehavior =
    2147483647;
pub type VkPointClippingBehavior = ::std::os::raw::c_uint;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT:
    VkTessellationDomainOrigin = 0;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT:
    VkTessellationDomainOrigin = 1;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT_KHR:
    VkTessellationDomainOrigin = 0;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT_KHR:
    VkTessellationDomainOrigin = 1;
pub const VkTessellationDomainOrigin_VK_TESSELLATION_DOMAIN_ORIGIN_MAX_ENUM:
    VkTessellationDomainOrigin = 2147483647;
pub type VkTessellationDomainOrigin = ::std::os::raw::c_uint;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY:
    VkSamplerYcbcrModelConversion = 0;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY:
    VkSamplerYcbcrModelConversion = 1;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709:
    VkSamplerYcbcrModelConversion = 2;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601:
    VkSamplerYcbcrModelConversion = 3;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020:
    VkSamplerYcbcrModelConversion = 4;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY_KHR:
    VkSamplerYcbcrModelConversion = 0;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY_KHR:
    VkSamplerYcbcrModelConversion = 1;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709_KHR:
    VkSamplerYcbcrModelConversion = 2;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601_KHR:
    VkSamplerYcbcrModelConversion = 3;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020_KHR:
    VkSamplerYcbcrModelConversion = 4;
pub const VkSamplerYcbcrModelConversion_VK_SAMPLER_YCBCR_MODEL_CONVERSION_MAX_ENUM:
    VkSamplerYcbcrModelConversion = 2147483647;
pub type VkSamplerYcbcrModelConversion = ::std::os::raw::c_uint;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_FULL: VkSamplerYcbcrRange = 0;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_NARROW: VkSamplerYcbcrRange = 1;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_FULL_KHR: VkSamplerYcbcrRange = 0;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_ITU_NARROW_KHR: VkSamplerYcbcrRange = 1;
pub const VkSamplerYcbcrRange_VK_SAMPLER_YCBCR_RANGE_MAX_ENUM: VkSamplerYcbcrRange = 2147483647;
pub type VkSamplerYcbcrRange = ::std::os::raw::c_uint;
pub const VkChromaLocation_VK_CHROMA_LOCATION_COSITED_EVEN: VkChromaLocation = 0;
pub const VkChromaLocation_VK_CHROMA_LOCATION_MIDPOINT: VkChromaLocation = 1;
pub const VkChromaLocation_VK_CHROMA_LOCATION_COSITED_EVEN_KHR: VkChromaLocation = 0;
pub const VkChromaLocation_VK_CHROMA_LOCATION_MIDPOINT_KHR: VkChromaLocation = 1;
pub const VkChromaLocation_VK_CHROMA_LOCATION_MAX_ENUM: VkChromaLocation = 2147483647;
pub type VkChromaLocation = ::std::os::raw::c_uint;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET:
    VkDescriptorUpdateTemplateType = 0;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR:
    VkDescriptorUpdateTemplateType = 1;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR:
    VkDescriptorUpdateTemplateType = 0;
pub const VkDescriptorUpdateTemplateType_VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_MAX_ENUM:
    VkDescriptorUpdateTemplateType = 2147483647;
pub type VkDescriptorUpdateTemplateType = ::std::os::raw::c_uint;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_BASIC_BIT: VkSubgroupFeatureFlagBits = 1;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_VOTE_BIT: VkSubgroupFeatureFlagBits = 2;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_ARITHMETIC_BIT: VkSubgroupFeatureFlagBits =
    4;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_BALLOT_BIT: VkSubgroupFeatureFlagBits = 8;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_SHUFFLE_BIT: VkSubgroupFeatureFlagBits = 16;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT:
    VkSubgroupFeatureFlagBits = 32;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_CLUSTERED_BIT: VkSubgroupFeatureFlagBits =
    64;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_QUAD_BIT: VkSubgroupFeatureFlagBits = 128;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_PARTITIONED_BIT_NV:
    VkSubgroupFeatureFlagBits = 256;
pub const VkSubgroupFeatureFlagBits_VK_SUBGROUP_FEATURE_FLAG_BITS_MAX_ENUM:
    VkSubgroupFeatureFlagBits = 2147483647;
pub type VkSubgroupFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkSubgroupFeatureFlags = VkFlags;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT:
    VkPeerMemoryFeatureFlagBits = 1;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_DST_BIT:
    VkPeerMemoryFeatureFlagBits = 2;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT:
    VkPeerMemoryFeatureFlagBits = 4;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT:
    VkPeerMemoryFeatureFlagBits = 8;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 1;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 2;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 4;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR:
    VkPeerMemoryFeatureFlagBits = 8;
pub const VkPeerMemoryFeatureFlagBits_VK_PEER_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM:
    VkPeerMemoryFeatureFlagBits = 2147483647;
pub type VkPeerMemoryFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkPeerMemoryFeatureFlags = VkFlags;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT: VkMemoryAllocateFlagBits = 1;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT: VkMemoryAllocateFlagBits =
    2;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT:
    VkMemoryAllocateFlagBits = 4;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR:
    VkMemoryAllocateFlagBits = 1;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT_KHR:
    VkMemoryAllocateFlagBits = 2;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT_KHR:
    VkMemoryAllocateFlagBits = 4;
pub const VkMemoryAllocateFlagBits_VK_MEMORY_ALLOCATE_FLAG_BITS_MAX_ENUM: VkMemoryAllocateFlagBits =
    2147483647;
pub type VkMemoryAllocateFlagBits = ::std::os::raw::c_uint;
pub type VkMemoryAllocateFlags = VkFlags;
pub type VkCommandPoolTrimFlags = VkFlags;
pub type VkDescriptorUpdateTemplateCreateFlags = VkFlags;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalMemoryHandleTypeFlagBits = 1;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT:
    VkExternalMemoryHandleTypeFlagBits = 2;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT:
    VkExternalMemoryHandleTypeFlagBits = 4;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT:
    VkExternalMemoryHandleTypeFlagBits = 8;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT : VkExternalMemoryHandleTypeFlagBits = 16 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT:
    VkExternalMemoryHandleTypeFlagBits = 32;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT:
    VkExternalMemoryHandleTypeFlagBits = 64;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT:
    VkExternalMemoryHandleTypeFlagBits = 512;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID : VkExternalMemoryHandleTypeFlagBits = 1024 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT : VkExternalMemoryHandleTypeFlagBits = 128 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT : VkExternalMemoryHandleTypeFlagBits = 256 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_ZIRCON_VMO_BIT_FUCHSIA : VkExternalMemoryHandleTypeFlagBits = 2048 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 1;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 2;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 4 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 8 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 16 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR:
    VkExternalMemoryHandleTypeFlagBits = 32;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR : VkExternalMemoryHandleTypeFlagBits = 64 ;
pub const VkExternalMemoryHandleTypeFlagBits_VK_EXTERNAL_MEMORY_HANDLE_TYPE_FLAG_BITS_MAX_ENUM:
    VkExternalMemoryHandleTypeFlagBits = 2147483647;
pub type VkExternalMemoryHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalMemoryHandleTypeFlags = VkFlags;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT:
    VkExternalMemoryFeatureFlagBits = 1;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT:
    VkExternalMemoryFeatureFlagBits = 2;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT:
    VkExternalMemoryFeatureFlagBits = 4;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 1;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 2;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalMemoryFeatureFlagBits = 4;
pub const VkExternalMemoryFeatureFlagBits_VK_EXTERNAL_MEMORY_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalMemoryFeatureFlagBits = 2147483647;
pub type VkExternalMemoryFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalMemoryFeatureFlags = VkFlags;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalFenceHandleTypeFlagBits = 1;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT:
    VkExternalFenceHandleTypeFlagBits = 2;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT:
    VkExternalFenceHandleTypeFlagBits = 4;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT:
    VkExternalFenceHandleTypeFlagBits = 8;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 1;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 2;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalFenceHandleTypeFlagBits = 4 ;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT_KHR:
    VkExternalFenceHandleTypeFlagBits = 8;
pub const VkExternalFenceHandleTypeFlagBits_VK_EXTERNAL_FENCE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM:
    VkExternalFenceHandleTypeFlagBits = 2147483647;
pub type VkExternalFenceHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalFenceHandleTypeFlags = VkFlags;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT:
    VkExternalFenceFeatureFlagBits = 1;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT:
    VkExternalFenceFeatureFlagBits = 2;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalFenceFeatureFlagBits = 1;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalFenceFeatureFlagBits = 2;
pub const VkExternalFenceFeatureFlagBits_VK_EXTERNAL_FENCE_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalFenceFeatureFlagBits = 2147483647;
pub type VkExternalFenceFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalFenceFeatureFlags = VkFlags;
pub const VkFenceImportFlagBits_VK_FENCE_IMPORT_TEMPORARY_BIT: VkFenceImportFlagBits = 1;
pub const VkFenceImportFlagBits_VK_FENCE_IMPORT_TEMPORARY_BIT_KHR: VkFenceImportFlagBits = 1;
pub const VkFenceImportFlagBits_VK_FENCE_IMPORT_FLAG_BITS_MAX_ENUM: VkFenceImportFlagBits =
    2147483647;
pub type VkFenceImportFlagBits = ::std::os::raw::c_uint;
pub type VkFenceImportFlags = VkFlags;
pub const VkSemaphoreImportFlagBits_VK_SEMAPHORE_IMPORT_TEMPORARY_BIT: VkSemaphoreImportFlagBits =
    1;
pub const VkSemaphoreImportFlagBits_VK_SEMAPHORE_IMPORT_TEMPORARY_BIT_KHR:
    VkSemaphoreImportFlagBits = 1;
pub const VkSemaphoreImportFlagBits_VK_SEMAPHORE_IMPORT_FLAG_BITS_MAX_ENUM:
    VkSemaphoreImportFlagBits = 2147483647;
pub type VkSemaphoreImportFlagBits = ::std::os::raw::c_uint;
pub type VkSemaphoreImportFlags = VkFlags;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT:
    VkExternalSemaphoreHandleTypeFlagBits = 1;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT : VkExternalSemaphoreHandleTypeFlagBits = 2 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT : VkExternalSemaphoreHandleTypeFlagBits = 4 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT:
    VkExternalSemaphoreHandleTypeFlagBits = 16;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_ZIRCON_EVENT_BIT_FUCHSIA : VkExternalSemaphoreHandleTypeFlagBits = 128 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE_BIT : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 1 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 2 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 4 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 8 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT_KHR : VkExternalSemaphoreHandleTypeFlagBits = 16 ;
pub const VkExternalSemaphoreHandleTypeFlagBits_VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_FLAG_BITS_MAX_ENUM : VkExternalSemaphoreHandleTypeFlagBits = 2147483647 ;
pub type VkExternalSemaphoreHandleTypeFlagBits = ::std::os::raw::c_uint;
pub type VkExternalSemaphoreHandleTypeFlags = VkFlags;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT:
    VkExternalSemaphoreFeatureFlagBits = 1;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT:
    VkExternalSemaphoreFeatureFlagBits = 2;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT_KHR:
    VkExternalSemaphoreFeatureFlagBits = 1;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT_KHR:
    VkExternalSemaphoreFeatureFlagBits = 2;
pub const VkExternalSemaphoreFeatureFlagBits_VK_EXTERNAL_SEMAPHORE_FEATURE_FLAG_BITS_MAX_ENUM:
    VkExternalSemaphoreFeatureFlagBits = 2147483647;
pub type VkExternalSemaphoreFeatureFlagBits = ::std::os::raw::c_uint;
pub type VkExternalSemaphoreFeatureFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSubgroupProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub subgroupSize: u32,
    pub supportedStages: VkShaderStageFlags,
    pub supportedOperations: VkSubgroupFeatureFlags,
    pub quadOperationsInAllStages: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceSubgroupProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceSubgroupProperties>(),
        32usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceSubgroupProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceSubgroupProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceSubgroupProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSubgroupProperties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSubgroupProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSubgroupProperties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSubgroupProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSubgroupProperties>())).subgroupSize as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSubgroupProperties),
            "::",
            stringify!(subgroupSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSubgroupProperties>())).supportedStages
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSubgroupProperties),
            "::",
            stringify!(supportedStages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSubgroupProperties>())).supportedOperations
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSubgroupProperties),
            "::",
            stringify!(supportedOperations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSubgroupProperties>())).quadOperationsInAllStages
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSubgroupProperties),
            "::",
            stringify!(quadOperationsInAllStages)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindBufferMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkBindBufferMemoryInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBindBufferMemoryInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkBindBufferMemoryInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBindBufferMemoryInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBindBufferMemoryInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindBufferMemoryInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindBufferMemoryInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindBufferMemoryInfo>())).buffer as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryInfo),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindBufferMemoryInfo>())).memory as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryInfo),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindBufferMemoryInfo>())).memoryOffset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryInfo),
            "::",
            stringify!(memoryOffset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub memory: VkDeviceMemory,
    pub memoryOffset: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkBindImageMemoryInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBindImageMemoryInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkBindImageMemoryInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBindImageMemoryInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBindImageMemoryInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindImageMemoryInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindImageMemoryInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindImageMemoryInfo>())).image as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryInfo),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkBindImageMemoryInfo>())).memory as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryInfo),
            "::",
            stringify!(memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImageMemoryInfo>())).memoryOffset as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryInfo),
            "::",
            stringify!(memoryOffset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice16BitStorageFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer16BitAccess: VkBool32,
    pub uniformAndStorageBuffer16BitAccess: VkBool32,
    pub storagePushConstant16: VkBool32,
    pub storageInputOutput16: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDevice16BitStorageFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDevice16BitStorageFeatures>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDevice16BitStorageFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDevice16BitStorageFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDevice16BitStorageFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice16BitStorageFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice16BitStorageFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice16BitStorageFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice16BitStorageFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice16BitStorageFeatures>()))
                .storageBuffer16BitAccess as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice16BitStorageFeatures),
            "::",
            stringify!(storageBuffer16BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice16BitStorageFeatures>()))
                .uniformAndStorageBuffer16BitAccess as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice16BitStorageFeatures),
            "::",
            stringify!(uniformAndStorageBuffer16BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice16BitStorageFeatures>())).storagePushConstant16
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice16BitStorageFeatures),
            "::",
            stringify!(storagePushConstant16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice16BitStorageFeatures>())).storageInputOutput16
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice16BitStorageFeatures),
            "::",
            stringify!(storageInputOutput16)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryDedicatedRequirements {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub prefersDedicatedAllocation: VkBool32,
    pub requiresDedicatedAllocation: VkBool32,
}
#[test]
fn bindgen_test_layout_VkMemoryDedicatedRequirements() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryDedicatedRequirements>(),
        24usize,
        concat!("Size of: ", stringify!(VkMemoryDedicatedRequirements))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryDedicatedRequirements>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryDedicatedRequirements))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedRequirements>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedRequirements),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedRequirements>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedRequirements),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedRequirements>())).prefersDedicatedAllocation
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedRequirements),
            "::",
            stringify!(prefersDedicatedAllocation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedRequirements>())).requiresDedicatedAllocation
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedRequirements),
            "::",
            stringify!(requiresDedicatedAllocation)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryDedicatedAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
    pub buffer: VkBuffer,
}
#[test]
fn bindgen_test_layout_VkMemoryDedicatedAllocateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryDedicatedAllocateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkMemoryDedicatedAllocateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryDedicatedAllocateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryDedicatedAllocateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedAllocateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedAllocateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedAllocateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedAllocateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedAllocateInfo>())).image as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedAllocateInfo),
            "::",
            stringify!(image)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryDedicatedAllocateInfo>())).buffer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryDedicatedAllocateInfo),
            "::",
            stringify!(buffer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryAllocateFlagsInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkMemoryAllocateFlags,
    pub deviceMask: u32,
}
#[test]
fn bindgen_test_layout_VkMemoryAllocateFlagsInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryAllocateFlagsInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkMemoryAllocateFlagsInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryAllocateFlagsInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryAllocateFlagsInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryAllocateFlagsInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateFlagsInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryAllocateFlagsInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateFlagsInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryAllocateFlagsInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateFlagsInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryAllocateFlagsInfo>())).deviceMask as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryAllocateFlagsInfo),
            "::",
            stringify!(deviceMask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupRenderPassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceMask: u32,
    pub deviceRenderAreaCount: u32,
    pub pDeviceRenderAreas: *const VkRect2D,
}
#[test]
fn bindgen_test_layout_VkDeviceGroupRenderPassBeginInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceGroupRenderPassBeginInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkDeviceGroupRenderPassBeginInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceGroupRenderPassBeginInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkDeviceGroupRenderPassBeginInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupRenderPassBeginInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupRenderPassBeginInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupRenderPassBeginInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupRenderPassBeginInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupRenderPassBeginInfo>())).deviceMask as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupRenderPassBeginInfo),
            "::",
            stringify!(deviceMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupRenderPassBeginInfo>())).deviceRenderAreaCount
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupRenderPassBeginInfo),
            "::",
            stringify!(deviceRenderAreaCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupRenderPassBeginInfo>())).pDeviceRenderAreas
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupRenderPassBeginInfo),
            "::",
            stringify!(pDeviceRenderAreas)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupCommandBufferBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceMask: u32,
}
#[test]
fn bindgen_test_layout_VkDeviceGroupCommandBufferBeginInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceGroupCommandBufferBeginInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkDeviceGroupCommandBufferBeginInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceGroupCommandBufferBeginInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkDeviceGroupCommandBufferBeginInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupCommandBufferBeginInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupCommandBufferBeginInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupCommandBufferBeginInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupCommandBufferBeginInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupCommandBufferBeginInfo>())).deviceMask as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupCommandBufferBeginInfo),
            "::",
            stringify!(deviceMask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphoreDeviceIndices: *const u32,
    pub commandBufferCount: u32,
    pub pCommandBufferDeviceMasks: *const u32,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphoreDeviceIndices: *const u32,
}
#[test]
fn bindgen_test_layout_VkDeviceGroupSubmitInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceGroupSubmitInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VkDeviceGroupSubmitInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceGroupSubmitInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDeviceGroupSubmitInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).waitSemaphoreCount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(waitSemaphoreCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).pWaitSemaphoreDeviceIndices
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(pWaitSemaphoreDeviceIndices)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).commandBufferCount as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(commandBufferCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).pCommandBufferDeviceMasks
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(pCommandBufferDeviceMasks)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).signalSemaphoreCount as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(signalSemaphoreCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupSubmitInfo>())).pSignalSemaphoreDeviceIndices
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupSubmitInfo),
            "::",
            stringify!(pSignalSemaphoreDeviceIndices)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupBindSparseInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub resourceDeviceIndex: u32,
    pub memoryDeviceIndex: u32,
}
#[test]
fn bindgen_test_layout_VkDeviceGroupBindSparseInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceGroupBindSparseInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkDeviceGroupBindSparseInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceGroupBindSparseInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDeviceGroupBindSparseInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupBindSparseInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupBindSparseInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupBindSparseInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupBindSparseInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupBindSparseInfo>())).resourceDeviceIndex as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupBindSparseInfo),
            "::",
            stringify!(resourceDeviceIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupBindSparseInfo>())).memoryDeviceIndex as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupBindSparseInfo),
            "::",
            stringify!(memoryDeviceIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindBufferMemoryDeviceGroupInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
}
#[test]
fn bindgen_test_layout_VkBindBufferMemoryDeviceGroupInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBindBufferMemoryDeviceGroupInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkBindBufferMemoryDeviceGroupInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBindBufferMemoryDeviceGroupInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkBindBufferMemoryDeviceGroupInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindBufferMemoryDeviceGroupInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryDeviceGroupInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindBufferMemoryDeviceGroupInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryDeviceGroupInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindBufferMemoryDeviceGroupInfo>())).deviceIndexCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryDeviceGroupInfo),
            "::",
            stringify!(deviceIndexCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindBufferMemoryDeviceGroupInfo>())).pDeviceIndices as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindBufferMemoryDeviceGroupInfo),
            "::",
            stringify!(pDeviceIndices)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImageMemoryDeviceGroupInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub deviceIndexCount: u32,
    pub pDeviceIndices: *const u32,
    pub splitInstanceBindRegionCount: u32,
    pub pSplitInstanceBindRegions: *const VkRect2D,
}
#[test]
fn bindgen_test_layout_VkBindImageMemoryDeviceGroupInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBindImageMemoryDeviceGroupInfo>(),
        48usize,
        concat!("Size of: ", stringify!(VkBindImageMemoryDeviceGroupInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBindImageMemoryDeviceGroupInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkBindImageMemoryDeviceGroupInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImageMemoryDeviceGroupInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryDeviceGroupInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImageMemoryDeviceGroupInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryDeviceGroupInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImageMemoryDeviceGroupInfo>())).deviceIndexCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryDeviceGroupInfo),
            "::",
            stringify!(deviceIndexCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImageMemoryDeviceGroupInfo>())).pDeviceIndices as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryDeviceGroupInfo),
            "::",
            stringify!(pDeviceIndices)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImageMemoryDeviceGroupInfo>()))
                .splitInstanceBindRegionCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryDeviceGroupInfo),
            "::",
            stringify!(splitInstanceBindRegionCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImageMemoryDeviceGroupInfo>())).pSplitInstanceBindRegions
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImageMemoryDeviceGroupInfo),
            "::",
            stringify!(pSplitInstanceBindRegions)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceGroupProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub physicalDeviceCount: u32,
    pub physicalDevices: [VkPhysicalDevice; 32usize],
    pub subsetAllocation: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceGroupProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceGroupProperties>(),
        288usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceGroupProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceGroupProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPhysicalDeviceGroupProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceGroupProperties>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceGroupProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceGroupProperties>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceGroupProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceGroupProperties>())).physicalDeviceCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceGroupProperties),
            "::",
            stringify!(physicalDeviceCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceGroupProperties>())).physicalDevices as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceGroupProperties),
            "::",
            stringify!(physicalDevices)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceGroupProperties>())).subsetAllocation as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceGroupProperties),
            "::",
            stringify!(subsetAllocation)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceGroupDeviceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub physicalDeviceCount: u32,
    pub pPhysicalDevices: *const VkPhysicalDevice,
}
#[test]
fn bindgen_test_layout_VkDeviceGroupDeviceCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceGroupDeviceCreateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkDeviceGroupDeviceCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceGroupDeviceCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDeviceGroupDeviceCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupDeviceCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupDeviceCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupDeviceCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupDeviceCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupDeviceCreateInfo>())).physicalDeviceCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupDeviceCreateInfo),
            "::",
            stringify!(physicalDeviceCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceGroupDeviceCreateInfo>())).pPhysicalDevices as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceGroupDeviceCreateInfo),
            "::",
            stringify!(pPhysicalDevices)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBufferMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub buffer: VkBuffer,
}
#[test]
fn bindgen_test_layout_VkBufferMemoryRequirementsInfo2() {
    assert_eq!(
        ::std::mem::size_of::<VkBufferMemoryRequirementsInfo2>(),
        24usize,
        concat!("Size of: ", stringify!(VkBufferMemoryRequirementsInfo2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBufferMemoryRequirementsInfo2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBufferMemoryRequirementsInfo2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferMemoryRequirementsInfo2>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryRequirementsInfo2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferMemoryRequirementsInfo2>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryRequirementsInfo2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBufferMemoryRequirementsInfo2>())).buffer as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBufferMemoryRequirementsInfo2),
            "::",
            stringify!(buffer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
}
#[test]
fn bindgen_test_layout_VkImageMemoryRequirementsInfo2() {
    assert_eq!(
        ::std::mem::size_of::<VkImageMemoryRequirementsInfo2>(),
        24usize,
        concat!("Size of: ", stringify!(VkImageMemoryRequirementsInfo2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageMemoryRequirementsInfo2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageMemoryRequirementsInfo2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryRequirementsInfo2>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryRequirementsInfo2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryRequirementsInfo2>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryRequirementsInfo2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageMemoryRequirementsInfo2>())).image as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageMemoryRequirementsInfo2),
            "::",
            stringify!(image)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageSparseMemoryRequirementsInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub image: VkImage,
}
#[test]
fn bindgen_test_layout_VkImageSparseMemoryRequirementsInfo2() {
    assert_eq!(
        ::std::mem::size_of::<VkImageSparseMemoryRequirementsInfo2>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkImageSparseMemoryRequirementsInfo2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageSparseMemoryRequirementsInfo2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkImageSparseMemoryRequirementsInfo2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSparseMemoryRequirementsInfo2>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSparseMemoryRequirementsInfo2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSparseMemoryRequirementsInfo2>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSparseMemoryRequirementsInfo2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageSparseMemoryRequirementsInfo2>())).image as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageSparseMemoryRequirementsInfo2),
            "::",
            stringify!(image)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkMemoryRequirements2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryRequirements: VkMemoryRequirements,
}
#[test]
fn bindgen_test_layout_VkMemoryRequirements2() {
    assert_eq!(
        ::std::mem::size_of::<VkMemoryRequirements2>(),
        40usize,
        concat!("Size of: ", stringify!(VkMemoryRequirements2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkMemoryRequirements2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkMemoryRequirements2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryRequirements2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryRequirements2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkMemoryRequirements2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryRequirements2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkMemoryRequirements2>())).memoryRequirements as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkMemoryRequirements2),
            "::",
            stringify!(memoryRequirements)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageMemoryRequirements2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryRequirements: VkSparseImageMemoryRequirements,
}
#[test]
fn bindgen_test_layout_VkSparseImageMemoryRequirements2() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseImageMemoryRequirements2>(),
        64usize,
        concat!("Size of: ", stringify!(VkSparseImageMemoryRequirements2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseImageMemoryRequirements2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkSparseImageMemoryRequirements2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements2>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements2>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageMemoryRequirements2>())).memoryRequirements
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageMemoryRequirements2),
            "::",
            stringify!(memoryRequirements)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFeatures2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub features: VkPhysicalDeviceFeatures,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceFeatures2() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceFeatures2>(),
        240usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceFeatures2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceFeatures2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPhysicalDeviceFeatures2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPhysicalDeviceFeatures2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkPhysicalDeviceFeatures2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFeatures2>())).features as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFeatures2),
            "::",
            stringify!(features)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPhysicalDeviceProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub properties: VkPhysicalDeviceProperties,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceProperties2() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceProperties2>(),
        840usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceProperties2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceProperties2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPhysicalDeviceProperties2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties2>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties2>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProperties2>())).properties as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProperties2),
            "::",
            stringify!(properties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub formatProperties: VkFormatProperties,
}
#[test]
fn bindgen_test_layout_VkFormatProperties2() {
    assert_eq!(
        ::std::mem::size_of::<VkFormatProperties2>(),
        32usize,
        concat!("Size of: ", stringify!(VkFormatProperties2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkFormatProperties2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkFormatProperties2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFormatProperties2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFormatProperties2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkFormatProperties2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFormatProperties2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFormatProperties2>())).formatProperties as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFormatProperties2),
            "::",
            stringify!(formatProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imageFormatProperties: VkImageFormatProperties,
}
#[test]
fn bindgen_test_layout_VkImageFormatProperties2() {
    assert_eq!(
        ::std::mem::size_of::<VkImageFormatProperties2>(),
        48usize,
        concat!("Size of: ", stringify!(VkImageFormatProperties2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageFormatProperties2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageFormatProperties2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageFormatProperties2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkImageFormatProperties2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatProperties2>())).imageFormatProperties as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatProperties2),
            "::",
            stringify!(imageFormatProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImageFormatInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub type_: VkImageType,
    pub tiling: VkImageTiling,
    pub usage: VkImageUsageFlags,
    pub flags: VkImageCreateFlags,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceImageFormatInfo2() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceImageFormatInfo2>(),
        40usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceImageFormatInfo2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceImageFormatInfo2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceImageFormatInfo2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImageFormatInfo2>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImageFormatInfo2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImageFormatInfo2>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImageFormatInfo2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImageFormatInfo2>())).format as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImageFormatInfo2),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImageFormatInfo2>())).type_ as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImageFormatInfo2),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImageFormatInfo2>())).tiling as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImageFormatInfo2),
            "::",
            stringify!(tiling)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImageFormatInfo2>())).usage as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImageFormatInfo2),
            "::",
            stringify!(usage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImageFormatInfo2>())).flags as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImageFormatInfo2),
            "::",
            stringify!(flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkQueueFamilyProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub queueFamilyProperties: VkQueueFamilyProperties,
}
#[test]
fn bindgen_test_layout_VkQueueFamilyProperties2() {
    assert_eq!(
        ::std::mem::size_of::<VkQueueFamilyProperties2>(),
        40usize,
        concat!("Size of: ", stringify!(VkQueueFamilyProperties2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkQueueFamilyProperties2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkQueueFamilyProperties2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkQueueFamilyProperties2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueueFamilyProperties2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkQueueFamilyProperties2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueueFamilyProperties2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkQueueFamilyProperties2>())).queueFamilyProperties as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkQueueFamilyProperties2),
            "::",
            stringify!(queueFamilyProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMemoryProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub memoryProperties: VkPhysicalDeviceMemoryProperties,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceMemoryProperties2() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceMemoryProperties2>(),
        536usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceMemoryProperties2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceMemoryProperties2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceMemoryProperties2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMemoryProperties2>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMemoryProperties2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMemoryProperties2>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMemoryProperties2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMemoryProperties2>())).memoryProperties
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMemoryProperties2),
            "::",
            stringify!(memoryProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSparseImageFormatProperties2 {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub properties: VkSparseImageFormatProperties,
}
#[test]
fn bindgen_test_layout_VkSparseImageFormatProperties2() {
    assert_eq!(
        ::std::mem::size_of::<VkSparseImageFormatProperties2>(),
        40usize,
        concat!("Size of: ", stringify!(VkSparseImageFormatProperties2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSparseImageFormatProperties2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSparseImageFormatProperties2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageFormatProperties2>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageFormatProperties2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageFormatProperties2>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageFormatProperties2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSparseImageFormatProperties2>())).properties as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSparseImageFormatProperties2),
            "::",
            stringify!(properties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSparseImageFormatInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub type_: VkImageType,
    pub samples: VkSampleCountFlagBits,
    pub usage: VkImageUsageFlags,
    pub tiling: VkImageTiling,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceSparseImageFormatInfo2() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceSparseImageFormatInfo2>(),
        40usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceSparseImageFormatInfo2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseImageFormatInfo2>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseImageFormatInfo2>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseImageFormatInfo2>())).format as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseImageFormatInfo2>())).type_ as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseImageFormatInfo2>())).samples as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseImageFormatInfo2>())).usage as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2),
            "::",
            stringify!(usage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSparseImageFormatInfo2>())).tiling as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSparseImageFormatInfo2),
            "::",
            stringify!(tiling)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevicePointClippingProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub pointClippingBehavior: VkPointClippingBehavior,
}
#[test]
fn bindgen_test_layout_VkPhysicalDevicePointClippingProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDevicePointClippingProperties>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDevicePointClippingProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDevicePointClippingProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDevicePointClippingProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevicePointClippingProperties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevicePointClippingProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevicePointClippingProperties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevicePointClippingProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevicePointClippingProperties>()))
                .pointClippingBehavior as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevicePointClippingProperties),
            "::",
            stringify!(pointClippingBehavior)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkInputAttachmentAspectReference {
    pub subpass: u32,
    pub inputAttachmentIndex: u32,
    pub aspectMask: VkImageAspectFlags,
}
#[test]
fn bindgen_test_layout_VkInputAttachmentAspectReference() {
    assert_eq!(
        ::std::mem::size_of::<VkInputAttachmentAspectReference>(),
        12usize,
        concat!("Size of: ", stringify!(VkInputAttachmentAspectReference))
    );
    assert_eq!(
        ::std::mem::align_of::<VkInputAttachmentAspectReference>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(VkInputAttachmentAspectReference)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInputAttachmentAspectReference>())).subpass as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInputAttachmentAspectReference),
            "::",
            stringify!(subpass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInputAttachmentAspectReference>())).inputAttachmentIndex
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInputAttachmentAspectReference),
            "::",
            stringify!(inputAttachmentIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkInputAttachmentAspectReference>())).aspectMask as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkInputAttachmentAspectReference),
            "::",
            stringify!(aspectMask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassInputAttachmentAspectCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub aspectReferenceCount: u32,
    pub pAspectReferences: *const VkInputAttachmentAspectReference,
}
#[test]
fn bindgen_test_layout_VkRenderPassInputAttachmentAspectCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkRenderPassInputAttachmentAspectCreateInfo>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkRenderPassInputAttachmentAspectCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkRenderPassInputAttachmentAspectCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkRenderPassInputAttachmentAspectCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassInputAttachmentAspectCreateInfo>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassInputAttachmentAspectCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassInputAttachmentAspectCreateInfo>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassInputAttachmentAspectCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassInputAttachmentAspectCreateInfo>()))
                .aspectReferenceCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassInputAttachmentAspectCreateInfo),
            "::",
            stringify!(aspectReferenceCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassInputAttachmentAspectCreateInfo>()))
                .pAspectReferences as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassInputAttachmentAspectCreateInfo),
            "::",
            stringify!(pAspectReferences)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageViewUsageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub usage: VkImageUsageFlags,
}
#[test]
fn bindgen_test_layout_VkImageViewUsageCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkImageViewUsageCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkImageViewUsageCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageViewUsageCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageViewUsageCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageViewUsageCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewUsageCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageViewUsageCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewUsageCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageViewUsageCreateInfo>())).usage as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageViewUsageCreateInfo),
            "::",
            stringify!(usage)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPipelineTessellationDomainOriginStateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub domainOrigin: VkTessellationDomainOrigin,
}
#[test]
fn bindgen_test_layout_VkPipelineTessellationDomainOriginStateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPipelineTessellationDomainOriginStateCreateInfo>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPipelineTessellationDomainOriginStateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPipelineTessellationDomainOriginStateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPipelineTessellationDomainOriginStateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineTessellationDomainOriginStateCreateInfo>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineTessellationDomainOriginStateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineTessellationDomainOriginStateCreateInfo>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineTessellationDomainOriginStateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPipelineTessellationDomainOriginStateCreateInfo>()))
                .domainOrigin as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPipelineTessellationDomainOriginStateCreateInfo),
            "::",
            stringify!(domainOrigin)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassMultiviewCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub subpassCount: u32,
    pub pViewMasks: *const u32,
    pub dependencyCount: u32,
    pub pViewOffsets: *const i32,
    pub correlationMaskCount: u32,
    pub pCorrelationMasks: *const u32,
}
#[test]
fn bindgen_test_layout_VkRenderPassMultiviewCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkRenderPassMultiviewCreateInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VkRenderPassMultiviewCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkRenderPassMultiviewCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkRenderPassMultiviewCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).subpassCount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(subpassCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).pViewMasks as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(pViewMasks)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).dependencyCount as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(dependencyCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).pViewOffsets as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(pViewOffsets)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).correlationMaskCount
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(correlationMaskCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassMultiviewCreateInfo>())).pCorrelationMasks
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassMultiviewCreateInfo),
            "::",
            stringify!(pCorrelationMasks)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub multiview: VkBool32,
    pub multiviewGeometryShader: VkBool32,
    pub multiviewTessellationShader: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceMultiviewFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceMultiviewFeatures>(),
        32usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceMultiviewFeatures))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceMultiviewFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceMultiviewFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewFeatures>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewFeatures>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewFeatures>())).multiview as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewFeatures),
            "::",
            stringify!(multiview)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewFeatures>())).multiviewGeometryShader
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewFeatures),
            "::",
            stringify!(multiviewGeometryShader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewFeatures>()))
                .multiviewTessellationShader as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewFeatures),
            "::",
            stringify!(multiviewTessellationShader)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMultiviewProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxMultiviewViewCount: u32,
    pub maxMultiviewInstanceIndex: u32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceMultiviewProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceMultiviewProperties>(),
        24usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceMultiviewProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceMultiviewProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceMultiviewProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewProperties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewProperties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewProperties>())).maxMultiviewViewCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewProperties),
            "::",
            stringify!(maxMultiviewViewCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMultiviewProperties>()))
                .maxMultiviewInstanceIndex as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMultiviewProperties),
            "::",
            stringify!(maxMultiviewInstanceIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVariablePointersFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub variablePointersStorageBuffer: VkBool32,
    pub variablePointers: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceVariablePointersFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceVariablePointersFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceVariablePointersFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceVariablePointersFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceVariablePointersFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVariablePointersFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVariablePointersFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVariablePointersFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVariablePointersFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVariablePointersFeatures>()))
                .variablePointersStorageBuffer as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVariablePointersFeatures),
            "::",
            stringify!(variablePointersStorageBuffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVariablePointersFeatures>())).variablePointers
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVariablePointersFeatures),
            "::",
            stringify!(variablePointers)
        )
    );
}
pub type VkPhysicalDeviceVariablePointerFeatures = VkPhysicalDeviceVariablePointersFeatures;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProtectedMemoryFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub protectedMemory: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceProtectedMemoryFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceProtectedMemoryFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceProtectedMemoryFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceProtectedMemoryFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceProtectedMemoryFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProtectedMemoryFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProtectedMemoryFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProtectedMemoryFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProtectedMemoryFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProtectedMemoryFeatures>())).protectedMemory
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProtectedMemoryFeatures),
            "::",
            stringify!(protectedMemory)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceProtectedMemoryProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub protectedNoFault: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceProtectedMemoryProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceProtectedMemoryProperties>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceProtectedMemoryProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceProtectedMemoryProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceProtectedMemoryProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProtectedMemoryProperties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProtectedMemoryProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProtectedMemoryProperties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProtectedMemoryProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceProtectedMemoryProperties>())).protectedNoFault
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceProtectedMemoryProperties),
            "::",
            stringify!(protectedNoFault)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDeviceQueueInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueIndex: u32,
}
#[test]
fn bindgen_test_layout_VkDeviceQueueInfo2() {
    assert_eq!(
        ::std::mem::size_of::<VkDeviceQueueInfo2>(),
        32usize,
        concat!("Size of: ", stringify!(VkDeviceQueueInfo2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDeviceQueueInfo2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDeviceQueueInfo2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceQueueInfo2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueInfo2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceQueueInfo2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueInfo2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceQueueInfo2>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueInfo2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDeviceQueueInfo2>())).queueFamilyIndex as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueInfo2),
            "::",
            stringify!(queueFamilyIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkDeviceQueueInfo2>())).queueIndex as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDeviceQueueInfo2),
            "::",
            stringify!(queueIndex)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkProtectedSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub protectedSubmit: VkBool32,
}
#[test]
fn bindgen_test_layout_VkProtectedSubmitInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkProtectedSubmitInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkProtectedSubmitInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkProtectedSubmitInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkProtectedSubmitInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkProtectedSubmitInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkProtectedSubmitInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkProtectedSubmitInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkProtectedSubmitInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkProtectedSubmitInfo>())).protectedSubmit as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkProtectedSubmitInfo),
            "::",
            stringify!(protectedSubmit)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub format: VkFormat,
    pub ycbcrModel: VkSamplerYcbcrModelConversion,
    pub ycbcrRange: VkSamplerYcbcrRange,
    pub components: VkComponentMapping,
    pub xChromaOffset: VkChromaLocation,
    pub yChromaOffset: VkChromaLocation,
    pub chromaFilter: VkFilter,
    pub forceExplicitReconstruction: VkBool32,
}
#[test]
fn bindgen_test_layout_VkSamplerYcbcrConversionCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSamplerYcbcrConversionCreateInfo>(),
        64usize,
        concat!("Size of: ", stringify!(VkSamplerYcbcrConversionCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSamplerYcbcrConversionCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkSamplerYcbcrConversionCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).format as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).ycbcrModel as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(ycbcrModel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).ycbcrRange as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(ycbcrRange)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).components as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(components)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).xChromaOffset as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(xChromaOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).yChromaOffset as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(yChromaOffset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>())).chromaFilter as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(chromaFilter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionCreateInfo>()))
                .forceExplicitReconstruction as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionCreateInfo),
            "::",
            stringify!(forceExplicitReconstruction)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub conversion: VkSamplerYcbcrConversion,
}
#[test]
fn bindgen_test_layout_VkSamplerYcbcrConversionInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSamplerYcbcrConversionInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkSamplerYcbcrConversionInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSamplerYcbcrConversionInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSamplerYcbcrConversionInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionInfo>())).conversion as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionInfo),
            "::",
            stringify!(conversion)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkBindImagePlaneMemoryInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub planeAspect: VkImageAspectFlagBits,
}
#[test]
fn bindgen_test_layout_VkBindImagePlaneMemoryInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkBindImagePlaneMemoryInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkBindImagePlaneMemoryInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkBindImagePlaneMemoryInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkBindImagePlaneMemoryInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImagePlaneMemoryInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImagePlaneMemoryInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImagePlaneMemoryInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImagePlaneMemoryInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkBindImagePlaneMemoryInfo>())).planeAspect as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkBindImagePlaneMemoryInfo),
            "::",
            stringify!(planeAspect)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImagePlaneMemoryRequirementsInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub planeAspect: VkImageAspectFlagBits,
}
#[test]
fn bindgen_test_layout_VkImagePlaneMemoryRequirementsInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkImagePlaneMemoryRequirementsInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkImagePlaneMemoryRequirementsInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImagePlaneMemoryRequirementsInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkImagePlaneMemoryRequirementsInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImagePlaneMemoryRequirementsInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImagePlaneMemoryRequirementsInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImagePlaneMemoryRequirementsInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImagePlaneMemoryRequirementsInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImagePlaneMemoryRequirementsInfo>())).planeAspect as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImagePlaneMemoryRequirementsInfo),
            "::",
            stringify!(planeAspect)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSamplerYcbcrConversionFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub samplerYcbcrConversion: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceSamplerYcbcrConversionFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceSamplerYcbcrConversionFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceSamplerYcbcrConversionFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceSamplerYcbcrConversionFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceSamplerYcbcrConversionFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSamplerYcbcrConversionFeatures>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSamplerYcbcrConversionFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSamplerYcbcrConversionFeatures>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSamplerYcbcrConversionFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSamplerYcbcrConversionFeatures>()))
                .samplerYcbcrConversion as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSamplerYcbcrConversionFeatures),
            "::",
            stringify!(samplerYcbcrConversion)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerYcbcrConversionImageFormatProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub combinedImageSamplerDescriptorCount: u32,
}
#[test]
fn bindgen_test_layout_VkSamplerYcbcrConversionImageFormatProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkSamplerYcbcrConversionImageFormatProperties>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkSamplerYcbcrConversionImageFormatProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkSamplerYcbcrConversionImageFormatProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkSamplerYcbcrConversionImageFormatProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionImageFormatProperties>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionImageFormatProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionImageFormatProperties>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionImageFormatProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerYcbcrConversionImageFormatProperties>()))
                .combinedImageSamplerDescriptorCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerYcbcrConversionImageFormatProperties),
            "::",
            stringify!(combinedImageSamplerDescriptorCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplateEntry {
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: VkDescriptorType,
    pub offset: size_t,
    pub stride: size_t,
}
#[test]
fn bindgen_test_layout_VkDescriptorUpdateTemplateEntry() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorUpdateTemplateEntry>(),
        32usize,
        concat!("Size of: ", stringify!(VkDescriptorUpdateTemplateEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorUpdateTemplateEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorUpdateTemplateEntry))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateEntry>())).dstBinding as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateEntry),
            "::",
            stringify!(dstBinding)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateEntry>())).dstArrayElement as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateEntry),
            "::",
            stringify!(dstArrayElement)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateEntry>())).descriptorCount as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateEntry),
            "::",
            stringify!(descriptorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateEntry>())).descriptorType as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateEntry),
            "::",
            stringify!(descriptorType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateEntry>())).offset as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateEntry),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateEntry>())).stride as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateEntry),
            "::",
            stringify!(stride)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorUpdateTemplateCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkDescriptorUpdateTemplateCreateFlags,
    pub descriptorUpdateEntryCount: u32,
    pub pDescriptorUpdateEntries: *const VkDescriptorUpdateTemplateEntry,
    pub templateType: VkDescriptorUpdateTemplateType,
    pub descriptorSetLayout: VkDescriptorSetLayout,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub pipelineLayout: VkPipelineLayout,
    pub set: u32,
}
#[test]
fn bindgen_test_layout_VkDescriptorUpdateTemplateCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorUpdateTemplateCreateInfo>(),
        72usize,
        concat!(
            "Size of: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorUpdateTemplateCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>()))
                .descriptorUpdateEntryCount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(descriptorUpdateEntryCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>()))
                .pDescriptorUpdateEntries as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(pDescriptorUpdateEntries)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).templateType
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(templateType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).descriptorSetLayout
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(descriptorSetLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).pipelineBindPoint
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(pipelineBindPoint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).pipelineLayout
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(pipelineLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorUpdateTemplateCreateInfo>())).set as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorUpdateTemplateCreateInfo),
            "::",
            stringify!(set)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryProperties {
    pub externalMemoryFeatures: VkExternalMemoryFeatureFlags,
    pub exportFromImportedHandleTypes: VkExternalMemoryHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalMemoryHandleTypeFlags,
}
#[test]
fn bindgen_test_layout_VkExternalMemoryProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkExternalMemoryProperties>(),
        12usize,
        concat!("Size of: ", stringify!(VkExternalMemoryProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExternalMemoryProperties>(),
        4usize,
        concat!("Alignment of ", stringify!(VkExternalMemoryProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryProperties>())).externalMemoryFeatures
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryProperties),
            "::",
            stringify!(externalMemoryFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryProperties>())).exportFromImportedHandleTypes
                as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryProperties),
            "::",
            stringify!(exportFromImportedHandleTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryProperties>())).compatibleHandleTypes as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryProperties),
            "::",
            stringify!(compatibleHandleTypes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalImageFormatInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceExternalImageFormatInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceExternalImageFormatInfo>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceExternalImageFormatInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceExternalImageFormatInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceExternalImageFormatInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalImageFormatInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalImageFormatInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalImageFormatInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalImageFormatInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalImageFormatInfo>())).handleType
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalImageFormatInfo),
            "::",
            stringify!(handleType)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalImageFormatProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalMemoryProperties: VkExternalMemoryProperties,
}
#[test]
fn bindgen_test_layout_VkExternalImageFormatProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkExternalImageFormatProperties>(),
        32usize,
        concat!("Size of: ", stringify!(VkExternalImageFormatProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExternalImageFormatProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExternalImageFormatProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalImageFormatProperties>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalImageFormatProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalImageFormatProperties>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalImageFormatProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalImageFormatProperties>())).externalMemoryProperties
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalImageFormatProperties),
            "::",
            stringify!(externalMemoryProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalBufferInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkBufferCreateFlags,
    pub usage: VkBufferUsageFlags,
    pub handleType: VkExternalMemoryHandleTypeFlagBits,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceExternalBufferInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceExternalBufferInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceExternalBufferInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceExternalBufferInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceExternalBufferInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalBufferInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalBufferInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalBufferInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalBufferInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalBufferInfo>())).flags as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalBufferInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalBufferInfo>())).usage as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalBufferInfo),
            "::",
            stringify!(usage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalBufferInfo>())).handleType as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalBufferInfo),
            "::",
            stringify!(handleType)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalBufferProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub externalMemoryProperties: VkExternalMemoryProperties,
}
#[test]
fn bindgen_test_layout_VkExternalBufferProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkExternalBufferProperties>(),
        32usize,
        concat!("Size of: ", stringify!(VkExternalBufferProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExternalBufferProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExternalBufferProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalBufferProperties>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalBufferProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalBufferProperties>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalBufferProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalBufferProperties>())).externalMemoryProperties
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalBufferProperties),
            "::",
            stringify!(externalMemoryProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceIDProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceUUID: [u8; 16usize],
    pub driverUUID: [u8; 16usize],
    pub deviceLUID: [u8; 8usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceIDProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceIDProperties>(),
        64usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceIDProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceIDProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkPhysicalDeviceIDProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceIDProperties>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceIDProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceIDProperties>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceIDProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceIDProperties>())).deviceUUID as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceIDProperties),
            "::",
            stringify!(deviceUUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceIDProperties>())).driverUUID as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceIDProperties),
            "::",
            stringify!(driverUUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceIDProperties>())).deviceLUID as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceIDProperties),
            "::",
            stringify!(deviceLUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceIDProperties>())).deviceNodeMask as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceIDProperties),
            "::",
            stringify!(deviceNodeMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceIDProperties>())).deviceLUIDValid as *const _
                as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceIDProperties),
            "::",
            stringify!(deviceLUIDValid)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryImageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[test]
fn bindgen_test_layout_VkExternalMemoryImageCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkExternalMemoryImageCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkExternalMemoryImageCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExternalMemoryImageCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExternalMemoryImageCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryImageCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryImageCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryImageCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryImageCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryImageCreateInfo>())).handleTypes as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryImageCreateInfo),
            "::",
            stringify!(handleTypes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalMemoryBufferCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[test]
fn bindgen_test_layout_VkExternalMemoryBufferCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkExternalMemoryBufferCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkExternalMemoryBufferCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExternalMemoryBufferCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkExternalMemoryBufferCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryBufferCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryBufferCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryBufferCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryBufferCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalMemoryBufferCreateInfo>())).handleTypes as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalMemoryBufferCreateInfo),
            "::",
            stringify!(handleTypes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportMemoryAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalMemoryHandleTypeFlags,
}
#[test]
fn bindgen_test_layout_VkExportMemoryAllocateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkExportMemoryAllocateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkExportMemoryAllocateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExportMemoryAllocateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExportMemoryAllocateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExportMemoryAllocateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportMemoryAllocateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExportMemoryAllocateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportMemoryAllocateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExportMemoryAllocateInfo>())).handleTypes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportMemoryAllocateInfo),
            "::",
            stringify!(handleTypes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalFenceInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalFenceHandleTypeFlagBits,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceExternalFenceInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceExternalFenceInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceExternalFenceInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceExternalFenceInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceExternalFenceInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalFenceInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalFenceInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalFenceInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalFenceInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalFenceInfo>())).handleType as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalFenceInfo),
            "::",
            stringify!(handleType)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalFenceProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exportFromImportedHandleTypes: VkExternalFenceHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalFenceHandleTypeFlags,
    pub externalFenceFeatures: VkExternalFenceFeatureFlags,
}
#[test]
fn bindgen_test_layout_VkExternalFenceProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkExternalFenceProperties>(),
        32usize,
        concat!("Size of: ", stringify!(VkExternalFenceProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExternalFenceProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExternalFenceProperties))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExternalFenceProperties>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalFenceProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExternalFenceProperties>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalFenceProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalFenceProperties>())).exportFromImportedHandleTypes
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalFenceProperties),
            "::",
            stringify!(exportFromImportedHandleTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalFenceProperties>())).compatibleHandleTypes as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalFenceProperties),
            "::",
            stringify!(compatibleHandleTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalFenceProperties>())).externalFenceFeatures as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalFenceProperties),
            "::",
            stringify!(externalFenceFeatures)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportFenceCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalFenceHandleTypeFlags,
}
#[test]
fn bindgen_test_layout_VkExportFenceCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkExportFenceCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkExportFenceCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExportFenceCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExportFenceCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExportFenceCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportFenceCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkExportFenceCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportFenceCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExportFenceCreateInfo>())).handleTypes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportFenceCreateInfo),
            "::",
            stringify!(handleTypes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExportSemaphoreCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleTypes: VkExternalSemaphoreHandleTypeFlags,
}
#[test]
fn bindgen_test_layout_VkExportSemaphoreCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkExportSemaphoreCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkExportSemaphoreCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExportSemaphoreCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExportSemaphoreCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExportSemaphoreCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportSemaphoreCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExportSemaphoreCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportSemaphoreCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExportSemaphoreCreateInfo>())).handleTypes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExportSemaphoreCreateInfo),
            "::",
            stringify!(handleTypes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceExternalSemaphoreInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub handleType: VkExternalSemaphoreHandleTypeFlagBits,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceExternalSemaphoreInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceExternalSemaphoreInfo>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceExternalSemaphoreInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceExternalSemaphoreInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceExternalSemaphoreInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalSemaphoreInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalSemaphoreInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalSemaphoreInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalSemaphoreInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceExternalSemaphoreInfo>())).handleType as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceExternalSemaphoreInfo),
            "::",
            stringify!(handleType)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkExternalSemaphoreProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub exportFromImportedHandleTypes: VkExternalSemaphoreHandleTypeFlags,
    pub compatibleHandleTypes: VkExternalSemaphoreHandleTypeFlags,
    pub externalSemaphoreFeatures: VkExternalSemaphoreFeatureFlags,
}
#[test]
fn bindgen_test_layout_VkExternalSemaphoreProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkExternalSemaphoreProperties>(),
        32usize,
        concat!("Size of: ", stringify!(VkExternalSemaphoreProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkExternalSemaphoreProperties>(),
        8usize,
        concat!("Alignment of ", stringify!(VkExternalSemaphoreProperties))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalSemaphoreProperties>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalSemaphoreProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalSemaphoreProperties>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalSemaphoreProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalSemaphoreProperties>())).exportFromImportedHandleTypes
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalSemaphoreProperties),
            "::",
            stringify!(exportFromImportedHandleTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalSemaphoreProperties>())).compatibleHandleTypes
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalSemaphoreProperties),
            "::",
            stringify!(compatibleHandleTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkExternalSemaphoreProperties>())).externalSemaphoreFeatures
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkExternalSemaphoreProperties),
            "::",
            stringify!(externalSemaphoreFeatures)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceMaintenance3Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceMaintenance3Properties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceMaintenance3Properties>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceMaintenance3Properties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceMaintenance3Properties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceMaintenance3Properties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMaintenance3Properties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMaintenance3Properties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMaintenance3Properties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMaintenance3Properties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMaintenance3Properties>())).maxPerSetDescriptors
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMaintenance3Properties),
            "::",
            stringify!(maxPerSetDescriptors)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceMaintenance3Properties>()))
                .maxMemoryAllocationSize as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceMaintenance3Properties),
            "::",
            stringify!(maxMemoryAllocationSize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutSupport {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supported: VkBool32,
}
#[test]
fn bindgen_test_layout_VkDescriptorSetLayoutSupport() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorSetLayoutSupport>(),
        24usize,
        concat!("Size of: ", stringify!(VkDescriptorSetLayoutSupport))
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorSetLayoutSupport>(),
        8usize,
        concat!("Alignment of ", stringify!(VkDescriptorSetLayoutSupport))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutSupport>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutSupport),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutSupport>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutSupport),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutSupport>())).supported as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutSupport),
            "::",
            stringify!(supported)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderDrawParametersFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderDrawParameters: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceShaderDrawParametersFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceShaderDrawParametersFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceShaderDrawParametersFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceShaderDrawParametersFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceShaderDrawParametersFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderDrawParametersFeatures>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderDrawParametersFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderDrawParametersFeatures>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderDrawParametersFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderDrawParametersFeatures>()))
                .shaderDrawParameters as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderDrawParametersFeatures),
            "::",
            stringify!(shaderDrawParameters)
        )
    );
}
pub type VkPhysicalDeviceShaderDrawParameterFeatures = VkPhysicalDeviceShaderDrawParametersFeatures;
pub type PFN_vkEnumerateInstanceVersion =
    ::std::option::Option<unsafe extern "C" fn(pApiVersion: *mut u32) -> VkResult>;
pub type PFN_vkBindBufferMemory2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult,
>;
pub type PFN_vkBindImageMemory2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult,
>;
pub type PFN_vkGetDeviceGroupPeerMemoryFeatures = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    ),
>;
pub type PFN_vkCmdSetDeviceMask =
    ::std::option::Option<unsafe extern "C" fn(commandBuffer: VkCommandBuffer, deviceMask: u32)>;
pub type PFN_vkCmdDispatchBase = ::std::option::Option<
    unsafe extern "C" fn(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    ),
>;
pub type PFN_vkEnumeratePhysicalDeviceGroups = ::std::option::Option<
    unsafe extern "C" fn(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult,
>;
pub type PFN_vkGetImageMemoryRequirements2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    ),
>;
pub type PFN_vkGetBufferMemoryRequirements2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    ),
>;
pub type PFN_vkGetImageSparseMemoryRequirements2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceFeatures2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceFormatProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceImageFormatProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult,
>;
pub type PFN_vkGetPhysicalDeviceQueueFamilyProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceMemoryProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    ),
>;
pub type PFN_vkGetPhysicalDeviceSparseImageFormatProperties2 = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    ),
>;
pub type PFN_vkTrimCommandPool = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    ),
>;
pub type PFN_vkGetDeviceQueue2 = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pQueueInfo: *const VkDeviceQueueInfo2,
        pQueue: *mut VkQueue,
    ),
>;
pub type PFN_vkCreateSamplerYcbcrConversion = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult,
>;
pub type PFN_vkDestroySamplerYcbcrConversion = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkCreateDescriptorUpdateTemplate = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult,
>;
pub type PFN_vkDestroyDescriptorUpdateTemplate = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    ),
>;
pub type PFN_vkUpdateDescriptorSetWithTemplate = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    ),
>;
pub type PFN_vkGetPhysicalDeviceExternalBufferProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceExternalFenceProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    ),
>;
pub type PFN_vkGetPhysicalDeviceExternalSemaphoreProperties = ::std::option::Option<
    unsafe extern "C" fn(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    ),
>;
pub type PFN_vkGetDescriptorSetLayoutSupport = ::std::option::Option<
    unsafe extern "C" fn(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    ),
>;
extern "C" {
    pub fn vkEnumerateInstanceVersion(pApiVersion: *mut u32) -> VkResult;
}
extern "C" {
    pub fn vkBindBufferMemory2(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindBufferMemoryInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkBindImageMemory2(
        device: VkDevice,
        bindInfoCount: u32,
        pBindInfos: *const VkBindImageMemoryInfo,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetDeviceGroupPeerMemoryFeatures(
        device: VkDevice,
        heapIndex: u32,
        localDeviceIndex: u32,
        remoteDeviceIndex: u32,
        pPeerMemoryFeatures: *mut VkPeerMemoryFeatureFlags,
    );
}
extern "C" {
    pub fn vkCmdSetDeviceMask(commandBuffer: VkCommandBuffer, deviceMask: u32);
}
extern "C" {
    pub fn vkCmdDispatchBase(
        commandBuffer: VkCommandBuffer,
        baseGroupX: u32,
        baseGroupY: u32,
        baseGroupZ: u32,
        groupCountX: u32,
        groupCountY: u32,
        groupCountZ: u32,
    );
}
extern "C" {
    pub fn vkEnumeratePhysicalDeviceGroups(
        instance: VkInstance,
        pPhysicalDeviceGroupCount: *mut u32,
        pPhysicalDeviceGroupProperties: *mut VkPhysicalDeviceGroupProperties,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetImageMemoryRequirements2(
        device: VkDevice,
        pInfo: *const VkImageMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetBufferMemoryRequirements2(
        device: VkDevice,
        pInfo: *const VkBufferMemoryRequirementsInfo2,
        pMemoryRequirements: *mut VkMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetImageSparseMemoryRequirements2(
        device: VkDevice,
        pInfo: *const VkImageSparseMemoryRequirementsInfo2,
        pSparseMemoryRequirementCount: *mut u32,
        pSparseMemoryRequirements: *mut VkSparseImageMemoryRequirements2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceFeatures2(
        physicalDevice: VkPhysicalDevice,
        pFeatures: *mut VkPhysicalDeviceFeatures2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceProperties2(
        physicalDevice: VkPhysicalDevice,
        pProperties: *mut VkPhysicalDeviceProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceFormatProperties2(
        physicalDevice: VkPhysicalDevice,
        format: VkFormat,
        pFormatProperties: *mut VkFormatProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceImageFormatProperties2(
        physicalDevice: VkPhysicalDevice,
        pImageFormatInfo: *const VkPhysicalDeviceImageFormatInfo2,
        pImageFormatProperties: *mut VkImageFormatProperties2,
    ) -> VkResult;
}
extern "C" {
    pub fn vkGetPhysicalDeviceQueueFamilyProperties2(
        physicalDevice: VkPhysicalDevice,
        pQueueFamilyPropertyCount: *mut u32,
        pQueueFamilyProperties: *mut VkQueueFamilyProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceMemoryProperties2(
        physicalDevice: VkPhysicalDevice,
        pMemoryProperties: *mut VkPhysicalDeviceMemoryProperties2,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceSparseImageFormatProperties2(
        physicalDevice: VkPhysicalDevice,
        pFormatInfo: *const VkPhysicalDeviceSparseImageFormatInfo2,
        pPropertyCount: *mut u32,
        pProperties: *mut VkSparseImageFormatProperties2,
    );
}
extern "C" {
    pub fn vkTrimCommandPool(
        device: VkDevice,
        commandPool: VkCommandPool,
        flags: VkCommandPoolTrimFlags,
    );
}
extern "C" {
    pub fn vkGetDeviceQueue2(
        device: VkDevice,
        pQueueInfo: *const VkDeviceQueueInfo2,
        pQueue: *mut VkQueue,
    );
}
extern "C" {
    pub fn vkCreateSamplerYcbcrConversion(
        device: VkDevice,
        pCreateInfo: *const VkSamplerYcbcrConversionCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pYcbcrConversion: *mut VkSamplerYcbcrConversion,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroySamplerYcbcrConversion(
        device: VkDevice,
        ycbcrConversion: VkSamplerYcbcrConversion,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkCreateDescriptorUpdateTemplate(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorUpdateTemplateCreateInfo,
        pAllocator: *const VkAllocationCallbacks,
        pDescriptorUpdateTemplate: *mut VkDescriptorUpdateTemplate,
    ) -> VkResult;
}
extern "C" {
    pub fn vkDestroyDescriptorUpdateTemplate(
        device: VkDevice,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pAllocator: *const VkAllocationCallbacks,
    );
}
extern "C" {
    pub fn vkUpdateDescriptorSetWithTemplate(
        device: VkDevice,
        descriptorSet: VkDescriptorSet,
        descriptorUpdateTemplate: VkDescriptorUpdateTemplate,
        pData: *const ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceExternalBufferProperties(
        physicalDevice: VkPhysicalDevice,
        pExternalBufferInfo: *const VkPhysicalDeviceExternalBufferInfo,
        pExternalBufferProperties: *mut VkExternalBufferProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceExternalFenceProperties(
        physicalDevice: VkPhysicalDevice,
        pExternalFenceInfo: *const VkPhysicalDeviceExternalFenceInfo,
        pExternalFenceProperties: *mut VkExternalFenceProperties,
    );
}
extern "C" {
    pub fn vkGetPhysicalDeviceExternalSemaphoreProperties(
        physicalDevice: VkPhysicalDevice,
        pExternalSemaphoreInfo: *const VkPhysicalDeviceExternalSemaphoreInfo,
        pExternalSemaphoreProperties: *mut VkExternalSemaphoreProperties,
    );
}
extern "C" {
    pub fn vkGetDescriptorSetLayoutSupport(
        device: VkDevice,
        pCreateInfo: *const VkDescriptorSetLayoutCreateInfo,
        pSupport: *mut VkDescriptorSetLayoutSupport,
    );
}
pub const VkDriverId_VK_DRIVER_ID_AMD_PROPRIETARY: VkDriverId = 1;
pub const VkDriverId_VK_DRIVER_ID_AMD_OPEN_SOURCE: VkDriverId = 2;
pub const VkDriverId_VK_DRIVER_ID_MESA_RADV: VkDriverId = 3;
pub const VkDriverId_VK_DRIVER_ID_NVIDIA_PROPRIETARY: VkDriverId = 4;
pub const VkDriverId_VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS: VkDriverId = 5;
pub const VkDriverId_VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA: VkDriverId = 6;
pub const VkDriverId_VK_DRIVER_ID_IMAGINATION_PROPRIETARY: VkDriverId = 7;
pub const VkDriverId_VK_DRIVER_ID_QUALCOMM_PROPRIETARY: VkDriverId = 8;
pub const VkDriverId_VK_DRIVER_ID_ARM_PROPRIETARY: VkDriverId = 9;
pub const VkDriverId_VK_DRIVER_ID_GOOGLE_SWIFTSHADER: VkDriverId = 10;
pub const VkDriverId_VK_DRIVER_ID_GGP_PROPRIETARY: VkDriverId = 11;
pub const VkDriverId_VK_DRIVER_ID_BROADCOM_PROPRIETARY: VkDriverId = 12;
pub const VkDriverId_VK_DRIVER_ID_MESA_LLVMPIPE: VkDriverId = 13;
pub const VkDriverId_VK_DRIVER_ID_MOLTENVK: VkDriverId = 14;
pub const VkDriverId_VK_DRIVER_ID_AMD_PROPRIETARY_KHR: VkDriverId = 1;
pub const VkDriverId_VK_DRIVER_ID_AMD_OPEN_SOURCE_KHR: VkDriverId = 2;
pub const VkDriverId_VK_DRIVER_ID_MESA_RADV_KHR: VkDriverId = 3;
pub const VkDriverId_VK_DRIVER_ID_NVIDIA_PROPRIETARY_KHR: VkDriverId = 4;
pub const VkDriverId_VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS_KHR: VkDriverId = 5;
pub const VkDriverId_VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA_KHR: VkDriverId = 6;
pub const VkDriverId_VK_DRIVER_ID_IMAGINATION_PROPRIETARY_KHR: VkDriverId = 7;
pub const VkDriverId_VK_DRIVER_ID_QUALCOMM_PROPRIETARY_KHR: VkDriverId = 8;
pub const VkDriverId_VK_DRIVER_ID_ARM_PROPRIETARY_KHR: VkDriverId = 9;
pub const VkDriverId_VK_DRIVER_ID_GOOGLE_SWIFTSHADER_KHR: VkDriverId = 10;
pub const VkDriverId_VK_DRIVER_ID_GGP_PROPRIETARY_KHR: VkDriverId = 11;
pub const VkDriverId_VK_DRIVER_ID_BROADCOM_PROPRIETARY_KHR: VkDriverId = 12;
pub const VkDriverId_VK_DRIVER_ID_MAX_ENUM: VkDriverId = 2147483647;
pub type VkDriverId = ::std::os::raw::c_uint;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY:
    VkShaderFloatControlsIndependence = 0;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL:
    VkShaderFloatControlsIndependence = 1;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE:
    VkShaderFloatControlsIndependence = 2;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY_KHR : VkShaderFloatControlsIndependence = 0 ;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL_KHR:
    VkShaderFloatControlsIndependence = 1;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE_KHR:
    VkShaderFloatControlsIndependence = 2;
pub const VkShaderFloatControlsIndependence_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_MAX_ENUM:
    VkShaderFloatControlsIndependence = 2147483647;
pub type VkShaderFloatControlsIndependence = ::std::os::raw::c_uint;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE:
    VkSamplerReductionMode = 0;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MIN: VkSamplerReductionMode = 1;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MAX: VkSamplerReductionMode = 2;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE_EXT:
    VkSamplerReductionMode = 0;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MIN_EXT: VkSamplerReductionMode = 1;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MAX_EXT: VkSamplerReductionMode = 2;
pub const VkSamplerReductionMode_VK_SAMPLER_REDUCTION_MODE_MAX_ENUM: VkSamplerReductionMode =
    2147483647;
pub type VkSamplerReductionMode = ::std::os::raw::c_uint;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_BINARY: VkSemaphoreType = 0;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_TIMELINE: VkSemaphoreType = 1;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_BINARY_KHR: VkSemaphoreType = 0;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_TIMELINE_KHR: VkSemaphoreType = 1;
pub const VkSemaphoreType_VK_SEMAPHORE_TYPE_MAX_ENUM: VkSemaphoreType = 2147483647;
pub type VkSemaphoreType = ::std::os::raw::c_uint;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_NONE: VkResolveModeFlagBits = 0;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_SAMPLE_ZERO_BIT: VkResolveModeFlagBits = 1;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_AVERAGE_BIT: VkResolveModeFlagBits = 2;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MIN_BIT: VkResolveModeFlagBits = 4;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MAX_BIT: VkResolveModeFlagBits = 8;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_NONE_KHR: VkResolveModeFlagBits = 0;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_SAMPLE_ZERO_BIT_KHR: VkResolveModeFlagBits = 1;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_AVERAGE_BIT_KHR: VkResolveModeFlagBits = 2;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MIN_BIT_KHR: VkResolveModeFlagBits = 4;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_MAX_BIT_KHR: VkResolveModeFlagBits = 8;
pub const VkResolveModeFlagBits_VK_RESOLVE_MODE_FLAG_BITS_MAX_ENUM: VkResolveModeFlagBits =
    2147483647;
pub type VkResolveModeFlagBits = ::std::os::raw::c_uint;
pub type VkResolveModeFlags = VkFlags;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT:
    VkDescriptorBindingFlagBits = 1;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT:
    VkDescriptorBindingFlagBits = 2;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT:
    VkDescriptorBindingFlagBits = 4;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT:
    VkDescriptorBindingFlagBits = 8;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT_EXT:
    VkDescriptorBindingFlagBits = 1;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT_EXT:
    VkDescriptorBindingFlagBits = 2;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT_EXT:
    VkDescriptorBindingFlagBits = 4;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT_EXT:
    VkDescriptorBindingFlagBits = 8;
pub const VkDescriptorBindingFlagBits_VK_DESCRIPTOR_BINDING_FLAG_BITS_MAX_ENUM:
    VkDescriptorBindingFlagBits = 2147483647;
pub type VkDescriptorBindingFlagBits = ::std::os::raw::c_uint;
pub type VkDescriptorBindingFlags = VkFlags;
pub const VkSemaphoreWaitFlagBits_VK_SEMAPHORE_WAIT_ANY_BIT: VkSemaphoreWaitFlagBits = 1;
pub const VkSemaphoreWaitFlagBits_VK_SEMAPHORE_WAIT_ANY_BIT_KHR: VkSemaphoreWaitFlagBits = 1;
pub const VkSemaphoreWaitFlagBits_VK_SEMAPHORE_WAIT_FLAG_BITS_MAX_ENUM: VkSemaphoreWaitFlagBits =
    2147483647;
pub type VkSemaphoreWaitFlagBits = ::std::os::raw::c_uint;
pub type VkSemaphoreWaitFlags = VkFlags;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan11Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer16BitAccess: VkBool32,
    pub uniformAndStorageBuffer16BitAccess: VkBool32,
    pub storagePushConstant16: VkBool32,
    pub storageInputOutput16: VkBool32,
    pub multiview: VkBool32,
    pub multiviewGeometryShader: VkBool32,
    pub multiviewTessellationShader: VkBool32,
    pub variablePointersStorageBuffer: VkBool32,
    pub variablePointers: VkBool32,
    pub protectedMemory: VkBool32,
    pub samplerYcbcrConversion: VkBool32,
    pub shaderDrawParameters: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceVulkan11Features() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceVulkan11Features>(),
        64usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceVulkan11Features))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceVulkan11Features>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceVulkan11Features)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).storageBuffer16BitAccess
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(storageBuffer16BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>()))
                .uniformAndStorageBuffer16BitAccess as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(uniformAndStorageBuffer16BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).storagePushConstant16
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(storagePushConstant16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).storageInputOutput16
                as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(storageInputOutput16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).multiview as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(multiview)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).multiviewGeometryShader
                as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(multiviewGeometryShader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).multiviewTessellationShader
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(multiviewTessellationShader)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>()))
                .variablePointersStorageBuffer as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(variablePointersStorageBuffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).variablePointers
                as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(variablePointers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).protectedMemory as *const _
                as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(protectedMemory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).samplerYcbcrConversion
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(samplerYcbcrConversion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Features>())).shaderDrawParameters
                as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Features),
            "::",
            stringify!(shaderDrawParameters)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan11Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub deviceUUID: [u8; 16usize],
    pub driverUUID: [u8; 16usize],
    pub deviceLUID: [u8; 8usize],
    pub deviceNodeMask: u32,
    pub deviceLUIDValid: VkBool32,
    pub subgroupSize: u32,
    pub subgroupSupportedStages: VkShaderStageFlags,
    pub subgroupSupportedOperations: VkSubgroupFeatureFlags,
    pub subgroupQuadOperationsInAllStages: VkBool32,
    pub pointClippingBehavior: VkPointClippingBehavior,
    pub maxMultiviewViewCount: u32,
    pub maxMultiviewInstanceIndex: u32,
    pub protectedNoFault: VkBool32,
    pub maxPerSetDescriptors: u32,
    pub maxMemoryAllocationSize: VkDeviceSize,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceVulkan11Properties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceVulkan11Properties>(),
        112usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceVulkan11Properties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceVulkan11Properties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceVulkan11Properties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).deviceUUID as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(deviceUUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).driverUUID as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(driverUUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).deviceLUID as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(deviceLUID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).deviceNodeMask
                as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(deviceNodeMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).deviceLUIDValid
                as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(deviceLUIDValid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).subgroupSize as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(subgroupSize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).subgroupSupportedStages
                as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(subgroupSupportedStages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>()))
                .subgroupSupportedOperations as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(subgroupSupportedOperations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>()))
                .subgroupQuadOperationsInAllStages as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(subgroupQuadOperationsInAllStages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).pointClippingBehavior
                as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(pointClippingBehavior)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).maxMultiviewViewCount
                as *const _ as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(maxMultiviewViewCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).maxMultiviewInstanceIndex
                as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(maxMultiviewInstanceIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).protectedNoFault
                as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(protectedNoFault)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).maxPerSetDescriptors
                as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(maxPerSetDescriptors)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan11Properties>())).maxMemoryAllocationSize
                as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan11Properties),
            "::",
            stringify!(maxMemoryAllocationSize)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkan12Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub samplerMirrorClampToEdge: VkBool32,
    pub drawIndirectCount: VkBool32,
    pub storageBuffer8BitAccess: VkBool32,
    pub uniformAndStorageBuffer8BitAccess: VkBool32,
    pub storagePushConstant8: VkBool32,
    pub shaderBufferInt64Atomics: VkBool32,
    pub shaderSharedInt64Atomics: VkBool32,
    pub shaderFloat16: VkBool32,
    pub shaderInt8: VkBool32,
    pub descriptorIndexing: VkBool32,
    pub shaderInputAttachmentArrayDynamicIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderUniformBufferArrayNonUniformIndexing: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexing: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexing: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: VkBool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingSampledImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUpdateUnusedWhilePending: VkBool32,
    pub descriptorBindingPartiallyBound: VkBool32,
    pub descriptorBindingVariableDescriptorCount: VkBool32,
    pub runtimeDescriptorArray: VkBool32,
    pub samplerFilterMinmax: VkBool32,
    pub scalarBlockLayout: VkBool32,
    pub imagelessFramebuffer: VkBool32,
    pub uniformBufferStandardLayout: VkBool32,
    pub shaderSubgroupExtendedTypes: VkBool32,
    pub separateDepthStencilLayouts: VkBool32,
    pub hostQueryReset: VkBool32,
    pub timelineSemaphore: VkBool32,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
    pub vulkanMemoryModel: VkBool32,
    pub vulkanMemoryModelDeviceScope: VkBool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: VkBool32,
    pub shaderOutputViewportIndex: VkBool32,
    pub shaderOutputLayer: VkBool32,
    pub subgroupBroadcastDynamicId: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceVulkan12Features() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceVulkan12Features>(),
        208usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceVulkan12Features))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceVulkan12Features>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceVulkan12Features)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).samplerMirrorClampToEdge
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(samplerMirrorClampToEdge)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).drawIndirectCount
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(drawIndirectCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).storageBuffer8BitAccess
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(storageBuffer8BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .uniformAndStorageBuffer8BitAccess as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(uniformAndStorageBuffer8BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).storagePushConstant8
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(storagePushConstant8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).shaderBufferInt64Atomics
                as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderBufferInt64Atomics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).shaderSharedInt64Atomics
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderSharedInt64Atomics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).shaderFloat16 as *const _
                as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).shaderInt8 as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderInt8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).descriptorIndexing
                as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderInputAttachmentArrayDynamicIndexing as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderInputAttachmentArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderUniformTexelBufferArrayDynamicIndexing as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderUniformTexelBufferArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderStorageTexelBufferArrayDynamicIndexing as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderStorageTexelBufferArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderUniformBufferArrayNonUniformIndexing as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderUniformBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderSampledImageArrayNonUniformIndexing as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderSampledImageArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderStorageBufferArrayNonUniformIndexing as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderStorageBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderStorageImageArrayNonUniformIndexing as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderStorageImageArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderInputAttachmentArrayNonUniformIndexing as *const _ as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderInputAttachmentArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderUniformTexelBufferArrayNonUniformIndexing as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderUniformTexelBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .shaderStorageTexelBufferArrayNonUniformIndexing as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderStorageTexelBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingUniformBufferUpdateAfterBind as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingUniformBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingSampledImageUpdateAfterBind as *const _ as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingSampledImageUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingStorageImageUpdateAfterBind as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingStorageImageUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingStorageBufferUpdateAfterBind as *const _ as usize
        },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingStorageBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingUniformTexelBufferUpdateAfterBind as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingUniformTexelBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingStorageTexelBufferUpdateAfterBind as *const _ as usize
        },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingStorageTexelBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingUpdateUnusedWhilePending as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingUpdateUnusedWhilePending)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingPartiallyBound as *const _ as usize
        },
        124usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingPartiallyBound)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .descriptorBindingVariableDescriptorCount as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(descriptorBindingVariableDescriptorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).runtimeDescriptorArray
                as *const _ as usize
        },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(runtimeDescriptorArray)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).samplerFilterMinmax
                as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(samplerFilterMinmax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).scalarBlockLayout
                as *const _ as usize
        },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(scalarBlockLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).imagelessFramebuffer
                as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(imagelessFramebuffer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).uniformBufferStandardLayout
                as *const _ as usize
        },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(uniformBufferStandardLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).shaderSubgroupExtendedTypes
                as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderSubgroupExtendedTypes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).separateDepthStencilLayouts
                as *const _ as usize
        },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(separateDepthStencilLayouts)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).hostQueryReset as *const _
                as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(hostQueryReset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).timelineSemaphore
                as *const _ as usize
        },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(timelineSemaphore)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).bufferDeviceAddress
                as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(bufferDeviceAddress)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .bufferDeviceAddressCaptureReplay as *const _ as usize
        },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(bufferDeviceAddressCaptureReplay)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .bufferDeviceAddressMultiDevice as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(bufferDeviceAddressMultiDevice)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).vulkanMemoryModel
                as *const _ as usize
        },
        180usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(vulkanMemoryModel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .vulkanMemoryModelDeviceScope as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(vulkanMemoryModelDeviceScope)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>()))
                .vulkanMemoryModelAvailabilityVisibilityChains as *const _ as usize
        },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(vulkanMemoryModelAvailabilityVisibilityChains)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).shaderOutputViewportIndex
                as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderOutputViewportIndex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).shaderOutputLayer
                as *const _ as usize
        },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(shaderOutputLayer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Features>())).subgroupBroadcastDynamicId
                as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Features),
            "::",
            stringify!(subgroupBroadcastDynamicId)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}
#[test]
fn bindgen_test_layout_VkConformanceVersion() {
    assert_eq!(
        ::std::mem::size_of::<VkConformanceVersion>(),
        4usize,
        concat!("Size of: ", stringify!(VkConformanceVersion))
    );
    assert_eq!(
        ::std::mem::align_of::<VkConformanceVersion>(),
        1usize,
        concat!("Alignment of ", stringify!(VkConformanceVersion))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkConformanceVersion>())).major as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkConformanceVersion),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkConformanceVersion>())).minor as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(VkConformanceVersion),
            "::",
            stringify!(minor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkConformanceVersion>())).subminor as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(VkConformanceVersion),
            "::",
            stringify!(subminor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkConformanceVersion>())).patch as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(VkConformanceVersion),
            "::",
            stringify!(patch)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPhysicalDeviceVulkan12Properties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub driverID: VkDriverId,
    pub driverName: [::std::os::raw::c_char; 256usize],
    pub driverInfo: [::std::os::raw::c_char; 256usize],
    pub conformanceVersion: VkConformanceVersion,
    pub denormBehaviorIndependence: VkShaderFloatControlsIndependence,
    pub roundingModeIndependence: VkShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat32: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat64: VkBool32,
    pub shaderDenormPreserveFloat16: VkBool32,
    pub shaderDenormPreserveFloat32: VkBool32,
    pub shaderDenormPreserveFloat64: VkBool32,
    pub shaderDenormFlushToZeroFloat16: VkBool32,
    pub shaderDenormFlushToZeroFloat32: VkBool32,
    pub shaderDenormFlushToZeroFloat64: VkBool32,
    pub shaderRoundingModeRTEFloat16: VkBool32,
    pub shaderRoundingModeRTEFloat32: VkBool32,
    pub shaderRoundingModeRTEFloat64: VkBool32,
    pub shaderRoundingModeRTZFloat16: VkBool32,
    pub shaderRoundingModeRTZFloat32: VkBool32,
    pub shaderRoundingModeRTZFloat64: VkBool32,
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: VkBool32,
    pub robustBufferAccessUpdateAfterBind: VkBool32,
    pub quadDivergentImplicitLod: VkBool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
    pub supportedDepthResolveModes: VkResolveModeFlags,
    pub supportedStencilResolveModes: VkResolveModeFlags,
    pub independentResolveNone: VkBool32,
    pub independentResolve: VkBool32,
    pub filterMinmaxSingleComponentFormats: VkBool32,
    pub filterMinmaxImageComponentMapping: VkBool32,
    pub maxTimelineSemaphoreValueDifference: u64,
    pub framebufferIntegerColorSampleCounts: VkSampleCountFlags,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceVulkan12Properties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceVulkan12Properties>(),
        736usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceVulkan12Properties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceVulkan12Properties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceVulkan12Properties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).driverID as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(driverID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).driverName as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(driverName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).driverInfo as *const _
                as usize
        },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(driverInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).conformanceVersion
                as *const _ as usize
        },
        532usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(conformanceVersion)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .denormBehaviorIndependence as *const _ as usize
        },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(denormBehaviorIndependence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).roundingModeIndependence
                as *const _ as usize
        },
        540usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(roundingModeIndependence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderSignedZeroInfNanPreserveFloat16 as *const _ as usize
        },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderSignedZeroInfNanPreserveFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderSignedZeroInfNanPreserveFloat32 as *const _ as usize
        },
        548usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderSignedZeroInfNanPreserveFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderSignedZeroInfNanPreserveFloat64 as *const _ as usize
        },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderSignedZeroInfNanPreserveFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderDenormPreserveFloat16 as *const _ as usize
        },
        556usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderDenormPreserveFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderDenormPreserveFloat32 as *const _ as usize
        },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderDenormPreserveFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderDenormPreserveFloat64 as *const _ as usize
        },
        564usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderDenormPreserveFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderDenormFlushToZeroFloat16 as *const _ as usize
        },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderDenormFlushToZeroFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderDenormFlushToZeroFloat32 as *const _ as usize
        },
        572usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderDenormFlushToZeroFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderDenormFlushToZeroFloat64 as *const _ as usize
        },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderDenormFlushToZeroFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderRoundingModeRTEFloat16 as *const _ as usize
        },
        580usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderRoundingModeRTEFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderRoundingModeRTEFloat32 as *const _ as usize
        },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderRoundingModeRTEFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderRoundingModeRTEFloat64 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderRoundingModeRTEFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderRoundingModeRTZFloat16 as *const _ as usize
        },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderRoundingModeRTZFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderRoundingModeRTZFloat32 as *const _ as usize
        },
        596usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderRoundingModeRTZFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderRoundingModeRTZFloat64 as *const _ as usize
        },
        600usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderRoundingModeRTZFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxUpdateAfterBindDescriptorsInAllPools as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxUpdateAfterBindDescriptorsInAllPools)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderUniformBufferArrayNonUniformIndexingNative as *const _ as usize
        },
        608usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderUniformBufferArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderSampledImageArrayNonUniformIndexingNative as *const _ as usize
        },
        612usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderSampledImageArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderStorageBufferArrayNonUniformIndexingNative as *const _ as usize
        },
        616usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderStorageBufferArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderStorageImageArrayNonUniformIndexingNative as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderStorageImageArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .shaderInputAttachmentArrayNonUniformIndexingNative as *const _ as usize
        },
        624usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(shaderInputAttachmentArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .robustBufferAccessUpdateAfterBind as *const _ as usize
        },
        628usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(robustBufferAccessUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).quadDivergentImplicitLod
                as *const _ as usize
        },
        632usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(quadDivergentImplicitLod)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxPerStageDescriptorUpdateAfterBindSamplers as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindSamplers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxPerStageDescriptorUpdateAfterBindUniformBuffers as *const _ as usize
        },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindUniformBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxPerStageDescriptorUpdateAfterBindStorageBuffers as *const _ as usize
        },
        644usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindStorageBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxPerStageDescriptorUpdateAfterBindSampledImages as *const _ as usize
        },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindSampledImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxPerStageDescriptorUpdateAfterBindStorageImages as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindStorageImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxPerStageDescriptorUpdateAfterBindInputAttachments as *const _
                as usize
        },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindInputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxPerStageUpdateAfterBindResources as *const _ as usize
        },
        660usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxPerStageUpdateAfterBindResources)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindSamplers as *const _ as usize
        },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindSamplers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindUniformBuffers as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindUniformBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindUniformBuffersDynamic as *const _
                as usize
        },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindUniformBuffersDynamic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindStorageBuffers as *const _ as usize
        },
        676usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindStorageBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindStorageBuffersDynamic as *const _
                as usize
        },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindStorageBuffersDynamic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindSampledImages as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindSampledImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindStorageImages as *const _ as usize
        },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindStorageImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxDescriptorSetUpdateAfterBindInputAttachments as *const _ as usize
        },
        692usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindInputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .supportedDepthResolveModes as *const _ as usize
        },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(supportedDepthResolveModes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .supportedStencilResolveModes as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(supportedStencilResolveModes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).independentResolveNone
                as *const _ as usize
        },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(independentResolveNone)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>())).independentResolve
                as *const _ as usize
        },
        708usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(independentResolve)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .filterMinmaxSingleComponentFormats as *const _ as usize
        },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(filterMinmaxSingleComponentFormats)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .filterMinmaxImageComponentMapping as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(filterMinmaxImageComponentMapping)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .maxTimelineSemaphoreValueDifference as *const _ as usize
        },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(maxTimelineSemaphoreValueDifference)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkan12Properties>()))
                .framebufferIntegerColorSampleCounts as *const _ as usize
        },
        728usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkan12Properties),
            "::",
            stringify!(framebufferIntegerColorSampleCounts)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageFormatListCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub viewFormatCount: u32,
    pub pViewFormats: *const VkFormat,
}
#[test]
fn bindgen_test_layout_VkImageFormatListCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkImageFormatListCreateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkImageFormatListCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageFormatListCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageFormatListCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatListCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatListCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatListCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatListCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatListCreateInfo>())).viewFormatCount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatListCreateInfo),
            "::",
            stringify!(viewFormatCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageFormatListCreateInfo>())).pViewFormats as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageFormatListCreateInfo),
            "::",
            stringify!(pViewFormats)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescription2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkAttachmentDescriptionFlags,
    pub format: VkFormat,
    pub samples: VkSampleCountFlagBits,
    pub loadOp: VkAttachmentLoadOp,
    pub storeOp: VkAttachmentStoreOp,
    pub stencilLoadOp: VkAttachmentLoadOp,
    pub stencilStoreOp: VkAttachmentStoreOp,
    pub initialLayout: VkImageLayout,
    pub finalLayout: VkImageLayout,
}
#[test]
fn bindgen_test_layout_VkAttachmentDescription2() {
    assert_eq!(
        ::std::mem::size_of::<VkAttachmentDescription2>(),
        56usize,
        concat!("Size of: ", stringify!(VkAttachmentDescription2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkAttachmentDescription2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkAttachmentDescription2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription2>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription2>())).format as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(format)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription2>())).samples as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(samples)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentDescription2>())).loadOp as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(loadOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription2>())).storeOp as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(storeOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription2>())).stencilLoadOp as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(stencilLoadOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription2>())).stencilStoreOp as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(stencilStoreOp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription2>())).initialLayout as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(initialLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescription2>())).finalLayout as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescription2),
            "::",
            stringify!(finalLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReference2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachment: u32,
    pub layout: VkImageLayout,
    pub aspectMask: VkImageAspectFlags,
}
#[test]
fn bindgen_test_layout_VkAttachmentReference2() {
    assert_eq!(
        ::std::mem::size_of::<VkAttachmentReference2>(),
        32usize,
        concat!("Size of: ", stringify!(VkAttachmentReference2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkAttachmentReference2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkAttachmentReference2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentReference2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReference2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentReference2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReference2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentReference2>())).attachment as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReference2),
            "::",
            stringify!(attachment)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkAttachmentReference2>())).layout as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReference2),
            "::",
            stringify!(layout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentReference2>())).aspectMask as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReference2),
            "::",
            stringify!(aspectMask)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescription2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSubpassDescriptionFlags,
    pub pipelineBindPoint: VkPipelineBindPoint,
    pub viewMask: u32,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const VkAttachmentReference2,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const VkAttachmentReference2,
    pub pResolveAttachments: *const VkAttachmentReference2,
    pub pDepthStencilAttachment: *const VkAttachmentReference2,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}
#[test]
fn bindgen_test_layout_VkSubpassDescription2() {
    assert_eq!(
        ::std::mem::size_of::<VkSubpassDescription2>(),
        88usize,
        concat!("Size of: ", stringify!(VkSubpassDescription2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubpassDescription2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSubpassDescription2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDescription2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDescription2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDescription2>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).pipelineBindPoint as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(pipelineBindPoint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDescription2>())).viewMask as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(viewMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).inputAttachmentCount as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(inputAttachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).pInputAttachments as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(pInputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).colorAttachmentCount as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(colorAttachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).pColorAttachments as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(pColorAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).pResolveAttachments as *const _
                as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(pResolveAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).pDepthStencilAttachment as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(pDepthStencilAttachment)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).preserveAttachmentCount as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(preserveAttachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescription2>())).pPreserveAttachments as *const _
                as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescription2),
            "::",
            stringify!(pPreserveAttachments)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDependency2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: VkPipelineStageFlags,
    pub dstStageMask: VkPipelineStageFlags,
    pub srcAccessMask: VkAccessFlags,
    pub dstAccessMask: VkAccessFlags,
    pub dependencyFlags: VkDependencyFlags,
    pub viewOffset: i32,
}
#[test]
fn bindgen_test_layout_VkSubpassDependency2() {
    assert_eq!(
        ::std::mem::size_of::<VkSubpassDependency2>(),
        48usize,
        concat!("Size of: ", stringify!(VkSubpassDependency2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubpassDependency2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSubpassDependency2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDependency2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDependency2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDependency2>())).srcSubpass as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(srcSubpass)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDependency2>())).dstSubpass as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(dstSubpass)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency2>())).srcStageMask as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(srcStageMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency2>())).dstStageMask as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(dstStageMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency2>())).srcAccessMask as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(srcAccessMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency2>())).dstAccessMask as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(dstAccessMask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDependency2>())).dependencyFlags as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(dependencyFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassDependency2>())).viewOffset as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDependency2),
            "::",
            stringify!(viewOffset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassCreateInfo2 {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkRenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const VkAttachmentDescription2,
    pub subpassCount: u32,
    pub pSubpasses: *const VkSubpassDescription2,
    pub dependencyCount: u32,
    pub pDependencies: *const VkSubpassDependency2,
    pub correlatedViewMaskCount: u32,
    pub pCorrelatedViewMasks: *const u32,
}
#[test]
fn bindgen_test_layout_VkRenderPassCreateInfo2() {
    assert_eq!(
        ::std::mem::size_of::<VkRenderPassCreateInfo2>(),
        80usize,
        concat!("Size of: ", stringify!(VkRenderPassCreateInfo2))
    );
    assert_eq!(
        ::std::mem::align_of::<VkRenderPassCreateInfo2>(),
        8usize,
        concat!("Alignment of ", stringify!(VkRenderPassCreateInfo2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).attachmentCount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(attachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).pAttachments as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(pAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).subpassCount as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(subpassCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).pSubpasses as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(pSubpasses)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).dependencyCount as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(dependencyCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).pDependencies as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(pDependencies)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).correlatedViewMaskCount as *const _
                as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(correlatedViewMaskCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassCreateInfo2>())).pCorrelatedViewMasks as *const _
                as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassCreateInfo2),
            "::",
            stringify!(pCorrelatedViewMasks)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub contents: VkSubpassContents,
}
#[test]
fn bindgen_test_layout_VkSubpassBeginInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSubpassBeginInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkSubpassBeginInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubpassBeginInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSubpassBeginInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassBeginInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassBeginInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassBeginInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassBeginInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassBeginInfo>())).contents as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassBeginInfo),
            "::",
            stringify!(contents)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassEndInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_VkSubpassEndInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSubpassEndInfo>(),
        16usize,
        concat!("Size of: ", stringify!(VkSubpassEndInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubpassEndInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSubpassEndInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassEndInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassEndInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSubpassEndInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassEndInfo),
            "::",
            stringify!(pNext)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDevice8BitStorageFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub storageBuffer8BitAccess: VkBool32,
    pub uniformAndStorageBuffer8BitAccess: VkBool32,
    pub storagePushConstant8: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDevice8BitStorageFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDevice8BitStorageFeatures>(),
        32usize,
        concat!("Size of: ", stringify!(VkPhysicalDevice8BitStorageFeatures))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDevice8BitStorageFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDevice8BitStorageFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice8BitStorageFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice8BitStorageFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice8BitStorageFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice8BitStorageFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice8BitStorageFeatures>())).storageBuffer8BitAccess
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice8BitStorageFeatures),
            "::",
            stringify!(storageBuffer8BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice8BitStorageFeatures>()))
                .uniformAndStorageBuffer8BitAccess as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice8BitStorageFeatures),
            "::",
            stringify!(uniformAndStorageBuffer8BitAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDevice8BitStorageFeatures>())).storagePushConstant8
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDevice8BitStorageFeatures),
            "::",
            stringify!(storagePushConstant8)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct VkPhysicalDeviceDriverProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub driverID: VkDriverId,
    pub driverName: [::std::os::raw::c_char; 256usize],
    pub driverInfo: [::std::os::raw::c_char; 256usize],
    pub conformanceVersion: VkConformanceVersion,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceDriverProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceDriverProperties>(),
        536usize,
        concat!("Size of: ", stringify!(VkPhysicalDeviceDriverProperties))
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceDriverProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceDriverProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDriverProperties>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDriverProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDriverProperties>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDriverProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDriverProperties>())).driverID as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDriverProperties),
            "::",
            stringify!(driverID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDriverProperties>())).driverName as *const _
                as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDriverProperties),
            "::",
            stringify!(driverName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDriverProperties>())).driverInfo as *const _
                as usize
        },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDriverProperties),
            "::",
            stringify!(driverInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDriverProperties>())).conformanceVersion
                as *const _ as usize
        },
        532usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDriverProperties),
            "::",
            stringify!(conformanceVersion)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderAtomicInt64Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderBufferInt64Atomics: VkBool32,
    pub shaderSharedInt64Atomics: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceShaderAtomicInt64Features() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceShaderAtomicInt64Features>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceShaderAtomicInt64Features)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceShaderAtomicInt64Features>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceShaderAtomicInt64Features)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderAtomicInt64Features>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderAtomicInt64Features),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderAtomicInt64Features>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderAtomicInt64Features),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderAtomicInt64Features>()))
                .shaderBufferInt64Atomics as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderAtomicInt64Features),
            "::",
            stringify!(shaderBufferInt64Atomics)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderAtomicInt64Features>()))
                .shaderSharedInt64Atomics as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderAtomicInt64Features),
            "::",
            stringify!(shaderSharedInt64Atomics)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderFloat16Int8Features {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderFloat16: VkBool32,
    pub shaderInt8: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceShaderFloat16Int8Features() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceShaderFloat16Int8Features>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceShaderFloat16Int8Features)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceShaderFloat16Int8Features>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceShaderFloat16Int8Features)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderFloat16Int8Features>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderFloat16Int8Features),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderFloat16Int8Features>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderFloat16Int8Features),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderFloat16Int8Features>())).shaderFloat16
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderFloat16Int8Features),
            "::",
            stringify!(shaderFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderFloat16Int8Features>())).shaderInt8
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderFloat16Int8Features),
            "::",
            stringify!(shaderInt8)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceFloatControlsProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub denormBehaviorIndependence: VkShaderFloatControlsIndependence,
    pub roundingModeIndependence: VkShaderFloatControlsIndependence,
    pub shaderSignedZeroInfNanPreserveFloat16: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat32: VkBool32,
    pub shaderSignedZeroInfNanPreserveFloat64: VkBool32,
    pub shaderDenormPreserveFloat16: VkBool32,
    pub shaderDenormPreserveFloat32: VkBool32,
    pub shaderDenormPreserveFloat64: VkBool32,
    pub shaderDenormFlushToZeroFloat16: VkBool32,
    pub shaderDenormFlushToZeroFloat32: VkBool32,
    pub shaderDenormFlushToZeroFloat64: VkBool32,
    pub shaderRoundingModeRTEFloat16: VkBool32,
    pub shaderRoundingModeRTEFloat32: VkBool32,
    pub shaderRoundingModeRTEFloat64: VkBool32,
    pub shaderRoundingModeRTZFloat16: VkBool32,
    pub shaderRoundingModeRTZFloat32: VkBool32,
    pub shaderRoundingModeRTZFloat64: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceFloatControlsProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceFloatControlsProperties>(),
        88usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceFloatControlsProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceFloatControlsProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .denormBehaviorIndependence as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(denormBehaviorIndependence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .roundingModeIndependence as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(roundingModeIndependence)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderSignedZeroInfNanPreserveFloat16 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderSignedZeroInfNanPreserveFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderSignedZeroInfNanPreserveFloat32 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderSignedZeroInfNanPreserveFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderSignedZeroInfNanPreserveFloat64 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderSignedZeroInfNanPreserveFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderDenormPreserveFloat16 as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderDenormPreserveFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderDenormPreserveFloat32 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderDenormPreserveFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderDenormPreserveFloat64 as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderDenormPreserveFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderDenormFlushToZeroFloat16 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderDenormFlushToZeroFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderDenormFlushToZeroFloat32 as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderDenormFlushToZeroFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderDenormFlushToZeroFloat64 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderDenormFlushToZeroFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderRoundingModeRTEFloat16 as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderRoundingModeRTEFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderRoundingModeRTEFloat32 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderRoundingModeRTEFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderRoundingModeRTEFloat64 as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderRoundingModeRTEFloat64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderRoundingModeRTZFloat16 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderRoundingModeRTZFloat16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderRoundingModeRTZFloat32 as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderRoundingModeRTZFloat32)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceFloatControlsProperties>()))
                .shaderRoundingModeRTZFloat64 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceFloatControlsProperties),
            "::",
            stringify!(shaderRoundingModeRTZFloat64)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetLayoutBindingFlagsCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub bindingCount: u32,
    pub pBindingFlags: *const VkDescriptorBindingFlags,
}
#[test]
fn bindgen_test_layout_VkDescriptorSetLayoutBindingFlagsCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorSetLayoutBindingFlagsCreateInfo>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkDescriptorSetLayoutBindingFlagsCreateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorSetLayoutBindingFlagsCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkDescriptorSetLayoutBindingFlagsCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBindingFlagsCreateInfo>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBindingFlagsCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBindingFlagsCreateInfo>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBindingFlagsCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBindingFlagsCreateInfo>())).bindingCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBindingFlagsCreateInfo),
            "::",
            stringify!(bindingCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetLayoutBindingFlagsCreateInfo>())).pBindingFlags
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetLayoutBindingFlagsCreateInfo),
            "::",
            stringify!(pBindingFlags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDescriptorIndexingFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderInputAttachmentArrayDynamicIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: VkBool32,
    pub shaderUniformBufferArrayNonUniformIndexing: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexing: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexing: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: VkBool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: VkBool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: VkBool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingSampledImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageImageUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: VkBool32,
    pub descriptorBindingUpdateUnusedWhilePending: VkBool32,
    pub descriptorBindingPartiallyBound: VkBool32,
    pub descriptorBindingVariableDescriptorCount: VkBool32,
    pub runtimeDescriptorArray: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceDescriptorIndexingFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceDescriptorIndexingFeatures>(),
        96usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceDescriptorIndexingFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderInputAttachmentArrayDynamicIndexing as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderInputAttachmentArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderUniformTexelBufferArrayDynamicIndexing as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderUniformTexelBufferArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderStorageTexelBufferArrayDynamicIndexing as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderStorageTexelBufferArrayDynamicIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderUniformBufferArrayNonUniformIndexing as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderUniformBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderSampledImageArrayNonUniformIndexing as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderSampledImageArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderStorageBufferArrayNonUniformIndexing as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderStorageBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderStorageImageArrayNonUniformIndexing as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderStorageImageArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderInputAttachmentArrayNonUniformIndexing as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderInputAttachmentArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderUniformTexelBufferArrayNonUniformIndexing as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderUniformTexelBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .shaderStorageTexelBufferArrayNonUniformIndexing as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(shaderStorageTexelBufferArrayNonUniformIndexing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingUniformBufferUpdateAfterBind as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingUniformBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingSampledImageUpdateAfterBind as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingSampledImageUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingStorageImageUpdateAfterBind as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingStorageImageUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingStorageBufferUpdateAfterBind as *const _ as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingStorageBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingUniformTexelBufferUpdateAfterBind as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingUniformTexelBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingStorageTexelBufferUpdateAfterBind as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingStorageTexelBufferUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingUpdateUnusedWhilePending as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingUpdateUnusedWhilePending)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingPartiallyBound as *const _ as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingPartiallyBound)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .descriptorBindingVariableDescriptorCount as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(descriptorBindingVariableDescriptorCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingFeatures>()))
                .runtimeDescriptorArray as *const _ as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingFeatures),
            "::",
            stringify!(runtimeDescriptorArray)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDescriptorIndexingProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxUpdateAfterBindDescriptorsInAllPools: u32,
    pub shaderUniformBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderSampledImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageBufferArrayNonUniformIndexingNative: VkBool32,
    pub shaderStorageImageArrayNonUniformIndexingNative: VkBool32,
    pub shaderInputAttachmentArrayNonUniformIndexingNative: VkBool32,
    pub robustBufferAccessUpdateAfterBind: VkBool32,
    pub quadDivergentImplicitLod: VkBool32,
    pub maxPerStageDescriptorUpdateAfterBindSamplers: u32,
    pub maxPerStageDescriptorUpdateAfterBindUniformBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageBuffers: u32,
    pub maxPerStageDescriptorUpdateAfterBindSampledImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindStorageImages: u32,
    pub maxPerStageDescriptorUpdateAfterBindInputAttachments: u32,
    pub maxPerStageUpdateAfterBindResources: u32,
    pub maxDescriptorSetUpdateAfterBindSamplers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindUniformBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffers: u32,
    pub maxDescriptorSetUpdateAfterBindStorageBuffersDynamic: u32,
    pub maxDescriptorSetUpdateAfterBindSampledImages: u32,
    pub maxDescriptorSetUpdateAfterBindStorageImages: u32,
    pub maxDescriptorSetUpdateAfterBindInputAttachments: u32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceDescriptorIndexingProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceDescriptorIndexingProperties>(),
        112usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceDescriptorIndexingProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxUpdateAfterBindDescriptorsInAllPools as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxUpdateAfterBindDescriptorsInAllPools)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .shaderUniformBufferArrayNonUniformIndexingNative as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(shaderUniformBufferArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .shaderSampledImageArrayNonUniformIndexingNative as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(shaderSampledImageArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .shaderStorageBufferArrayNonUniformIndexingNative as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(shaderStorageBufferArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .shaderStorageImageArrayNonUniformIndexingNative as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(shaderStorageImageArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .shaderInputAttachmentArrayNonUniformIndexingNative as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(shaderInputAttachmentArrayNonUniformIndexingNative)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .robustBufferAccessUpdateAfterBind as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(robustBufferAccessUpdateAfterBind)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .quadDivergentImplicitLod as *const _ as usize
        },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(quadDivergentImplicitLod)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxPerStageDescriptorUpdateAfterBindSamplers as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindSamplers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxPerStageDescriptorUpdateAfterBindUniformBuffers as *const _ as usize
        },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindUniformBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxPerStageDescriptorUpdateAfterBindStorageBuffers as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindStorageBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxPerStageDescriptorUpdateAfterBindSampledImages as *const _ as usize
        },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindSampledImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxPerStageDescriptorUpdateAfterBindStorageImages as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindStorageImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxPerStageDescriptorUpdateAfterBindInputAttachments as *const _
                as usize
        },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxPerStageDescriptorUpdateAfterBindInputAttachments)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxPerStageUpdateAfterBindResources as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxPerStageUpdateAfterBindResources)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindSamplers as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindSamplers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindUniformBuffers as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindUniformBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindUniformBuffersDynamic as *const _
                as usize
        },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindUniformBuffersDynamic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindStorageBuffers as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindStorageBuffers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindStorageBuffersDynamic as *const _
                as usize
        },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindStorageBuffersDynamic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindSampledImages as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindSampledImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindStorageImages as *const _ as usize
        },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindStorageImages)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDescriptorIndexingProperties>()))
                .maxDescriptorSetUpdateAfterBindInputAttachments as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDescriptorIndexingProperties),
            "::",
            stringify!(maxDescriptorSetUpdateAfterBindInputAttachments)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetVariableDescriptorCountAllocateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub descriptorSetCount: u32,
    pub pDescriptorCounts: *const u32,
}
#[test]
fn bindgen_test_layout_VkDescriptorSetVariableDescriptorCountAllocateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorSetVariableDescriptorCountAllocateInfo>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkDescriptorSetVariableDescriptorCountAllocateInfo)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorSetVariableDescriptorCountAllocateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkDescriptorSetVariableDescriptorCountAllocateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetVariableDescriptorCountAllocateInfo>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetVariableDescriptorCountAllocateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetVariableDescriptorCountAllocateInfo>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetVariableDescriptorCountAllocateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetVariableDescriptorCountAllocateInfo>()))
                .descriptorSetCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetVariableDescriptorCountAllocateInfo),
            "::",
            stringify!(descriptorSetCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetVariableDescriptorCountAllocateInfo>()))
                .pDescriptorCounts as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetVariableDescriptorCountAllocateInfo),
            "::",
            stringify!(pDescriptorCounts)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkDescriptorSetVariableDescriptorCountLayoutSupport {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxVariableDescriptorCount: u32,
}
#[test]
fn bindgen_test_layout_VkDescriptorSetVariableDescriptorCountLayoutSupport() {
    assert_eq!(
        ::std::mem::size_of::<VkDescriptorSetVariableDescriptorCountLayoutSupport>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkDescriptorSetVariableDescriptorCountLayoutSupport)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkDescriptorSetVariableDescriptorCountLayoutSupport>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkDescriptorSetVariableDescriptorCountLayoutSupport)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetVariableDescriptorCountLayoutSupport>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetVariableDescriptorCountLayoutSupport),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetVariableDescriptorCountLayoutSupport>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetVariableDescriptorCountLayoutSupport),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkDescriptorSetVariableDescriptorCountLayoutSupport>()))
                .maxVariableDescriptorCount as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkDescriptorSetVariableDescriptorCountLayoutSupport),
            "::",
            stringify!(maxVariableDescriptorCount)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSubpassDescriptionDepthStencilResolve {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub depthResolveMode: VkResolveModeFlagBits,
    pub stencilResolveMode: VkResolveModeFlagBits,
    pub pDepthStencilResolveAttachment: *const VkAttachmentReference2,
}
#[test]
fn bindgen_test_layout_VkSubpassDescriptionDepthStencilResolve() {
    assert_eq!(
        ::std::mem::size_of::<VkSubpassDescriptionDepthStencilResolve>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkSubpassDescriptionDepthStencilResolve)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkSubpassDescriptionDepthStencilResolve>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkSubpassDescriptionDepthStencilResolve)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescriptionDepthStencilResolve>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescriptionDepthStencilResolve),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescriptionDepthStencilResolve>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescriptionDepthStencilResolve),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescriptionDepthStencilResolve>())).depthResolveMode
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescriptionDepthStencilResolve),
            "::",
            stringify!(depthResolveMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescriptionDepthStencilResolve>())).stencilResolveMode
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescriptionDepthStencilResolve),
            "::",
            stringify!(stencilResolveMode)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSubpassDescriptionDepthStencilResolve>()))
                .pDepthStencilResolveAttachment as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSubpassDescriptionDepthStencilResolve),
            "::",
            stringify!(pDepthStencilResolveAttachment)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceDepthStencilResolveProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub supportedDepthResolveModes: VkResolveModeFlags,
    pub supportedStencilResolveModes: VkResolveModeFlags,
    pub independentResolveNone: VkBool32,
    pub independentResolve: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceDepthStencilResolveProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceDepthStencilResolveProperties>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceDepthStencilResolveProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDepthStencilResolveProperties>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDepthStencilResolveProperties>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDepthStencilResolveProperties>()))
                .supportedDepthResolveModes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties),
            "::",
            stringify!(supportedDepthResolveModes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDepthStencilResolveProperties>()))
                .supportedStencilResolveModes as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties),
            "::",
            stringify!(supportedStencilResolveModes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDepthStencilResolveProperties>()))
                .independentResolveNone as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties),
            "::",
            stringify!(independentResolveNone)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceDepthStencilResolveProperties>()))
                .independentResolve as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceDepthStencilResolveProperties),
            "::",
            stringify!(independentResolve)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceScalarBlockLayoutFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub scalarBlockLayout: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceScalarBlockLayoutFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceScalarBlockLayoutFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceScalarBlockLayoutFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceScalarBlockLayoutFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceScalarBlockLayoutFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceScalarBlockLayoutFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceScalarBlockLayoutFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceScalarBlockLayoutFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceScalarBlockLayoutFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceScalarBlockLayoutFeatures>())).scalarBlockLayout
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceScalarBlockLayoutFeatures),
            "::",
            stringify!(scalarBlockLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkImageStencilUsageCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub stencilUsage: VkImageUsageFlags,
}
#[test]
fn bindgen_test_layout_VkImageStencilUsageCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkImageStencilUsageCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkImageStencilUsageCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkImageStencilUsageCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkImageStencilUsageCreateInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageStencilUsageCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageStencilUsageCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageStencilUsageCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageStencilUsageCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkImageStencilUsageCreateInfo>())).stencilUsage as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkImageStencilUsageCreateInfo),
            "::",
            stringify!(stencilUsage)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSamplerReductionModeCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub reductionMode: VkSamplerReductionMode,
}
#[test]
fn bindgen_test_layout_VkSamplerReductionModeCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSamplerReductionModeCreateInfo>(),
        24usize,
        concat!("Size of: ", stringify!(VkSamplerReductionModeCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSamplerReductionModeCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkSamplerReductionModeCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerReductionModeCreateInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerReductionModeCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerReductionModeCreateInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerReductionModeCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSamplerReductionModeCreateInfo>())).reductionMode as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSamplerReductionModeCreateInfo),
            "::",
            stringify!(reductionMode)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSamplerFilterMinmaxProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub filterMinmaxSingleComponentFormats: VkBool32,
    pub filterMinmaxImageComponentMapping: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceSamplerFilterMinmaxProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceSamplerFilterMinmaxProperties>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceSamplerFilterMinmaxProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceSamplerFilterMinmaxProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceSamplerFilterMinmaxProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSamplerFilterMinmaxProperties>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSamplerFilterMinmaxProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSamplerFilterMinmaxProperties>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSamplerFilterMinmaxProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSamplerFilterMinmaxProperties>()))
                .filterMinmaxSingleComponentFormats as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSamplerFilterMinmaxProperties),
            "::",
            stringify!(filterMinmaxSingleComponentFormats)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSamplerFilterMinmaxProperties>()))
                .filterMinmaxImageComponentMapping as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSamplerFilterMinmaxProperties),
            "::",
            stringify!(filterMinmaxImageComponentMapping)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceVulkanMemoryModelFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub vulkanMemoryModel: VkBool32,
    pub vulkanMemoryModelDeviceScope: VkBool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceVulkanMemoryModelFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceVulkanMemoryModelFeatures>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceVulkanMemoryModelFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceVulkanMemoryModelFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceVulkanMemoryModelFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkanMemoryModelFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkanMemoryModelFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkanMemoryModelFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkanMemoryModelFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkanMemoryModelFeatures>())).vulkanMemoryModel
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkanMemoryModelFeatures),
            "::",
            stringify!(vulkanMemoryModel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkanMemoryModelFeatures>()))
                .vulkanMemoryModelDeviceScope as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkanMemoryModelFeatures),
            "::",
            stringify!(vulkanMemoryModelDeviceScope)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceVulkanMemoryModelFeatures>()))
                .vulkanMemoryModelAvailabilityVisibilityChains as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceVulkanMemoryModelFeatures),
            "::",
            stringify!(vulkanMemoryModelAvailabilityVisibilityChains)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceImagelessFramebufferFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub imagelessFramebuffer: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceImagelessFramebufferFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceImagelessFramebufferFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceImagelessFramebufferFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceImagelessFramebufferFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceImagelessFramebufferFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImagelessFramebufferFeatures>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImagelessFramebufferFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImagelessFramebufferFeatures>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImagelessFramebufferFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceImagelessFramebufferFeatures>()))
                .imagelessFramebuffer as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceImagelessFramebufferFeatures),
            "::",
            stringify!(imagelessFramebuffer)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferAttachmentImageInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkImageCreateFlags,
    pub usage: VkImageUsageFlags,
    pub width: u32,
    pub height: u32,
    pub layerCount: u32,
    pub viewFormatCount: u32,
    pub pViewFormats: *const VkFormat,
}
#[test]
fn bindgen_test_layout_VkFramebufferAttachmentImageInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkFramebufferAttachmentImageInfo>(),
        48usize,
        concat!("Size of: ", stringify!(VkFramebufferAttachmentImageInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkFramebufferAttachmentImageInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkFramebufferAttachmentImageInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).flags as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).usage as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(usage)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).width as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).height as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).layerCount as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(layerCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).viewFormatCount as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(viewFormatCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentImageInfo>())).pViewFormats as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentImageInfo),
            "::",
            stringify!(pViewFormats)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkFramebufferAttachmentsCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentImageInfoCount: u32,
    pub pAttachmentImageInfos: *const VkFramebufferAttachmentImageInfo,
}
#[test]
fn bindgen_test_layout_VkFramebufferAttachmentsCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkFramebufferAttachmentsCreateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkFramebufferAttachmentsCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkFramebufferAttachmentsCreateInfo>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkFramebufferAttachmentsCreateInfo)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentsCreateInfo>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentsCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentsCreateInfo>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentsCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentsCreateInfo>())).attachmentImageInfoCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentsCreateInfo),
            "::",
            stringify!(attachmentImageInfoCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkFramebufferAttachmentsCreateInfo>())).pAttachmentImageInfos
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkFramebufferAttachmentsCreateInfo),
            "::",
            stringify!(pAttachmentImageInfos)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkRenderPassAttachmentBeginInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub attachmentCount: u32,
    pub pAttachments: *const VkImageView,
}
#[test]
fn bindgen_test_layout_VkRenderPassAttachmentBeginInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkRenderPassAttachmentBeginInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkRenderPassAttachmentBeginInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkRenderPassAttachmentBeginInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkRenderPassAttachmentBeginInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassAttachmentBeginInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassAttachmentBeginInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassAttachmentBeginInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassAttachmentBeginInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassAttachmentBeginInfo>())).attachmentCount as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassAttachmentBeginInfo),
            "::",
            stringify!(attachmentCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkRenderPassAttachmentBeginInfo>())).pAttachments as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkRenderPassAttachmentBeginInfo),
            "::",
            stringify!(pAttachments)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub uniformBufferStandardLayout: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceUniformBufferStandardLayoutFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceUniformBufferStandardLayoutFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceUniformBufferStandardLayoutFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceUniformBufferStandardLayoutFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceUniformBufferStandardLayoutFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceUniformBufferStandardLayoutFeatures>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceUniformBufferStandardLayoutFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceUniformBufferStandardLayoutFeatures>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceUniformBufferStandardLayoutFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceUniformBufferStandardLayoutFeatures>()))
                .uniformBufferStandardLayout as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceUniformBufferStandardLayoutFeatures),
            "::",
            stringify!(uniformBufferStandardLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub shaderSubgroupExtendedTypes: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>()))
                .shaderSubgroupExtendedTypes as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures),
            "::",
            stringify!(shaderSubgroupExtendedTypes)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub separateDepthStencilLayouts: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>()))
                .separateDepthStencilLayouts as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures),
            "::",
            stringify!(separateDepthStencilLayouts)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentReferenceStencilLayout {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stencilLayout: VkImageLayout,
}
#[test]
fn bindgen_test_layout_VkAttachmentReferenceStencilLayout() {
    assert_eq!(
        ::std::mem::size_of::<VkAttachmentReferenceStencilLayout>(),
        24usize,
        concat!("Size of: ", stringify!(VkAttachmentReferenceStencilLayout))
    );
    assert_eq!(
        ::std::mem::align_of::<VkAttachmentReferenceStencilLayout>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkAttachmentReferenceStencilLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentReferenceStencilLayout>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReferenceStencilLayout),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentReferenceStencilLayout>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReferenceStencilLayout),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentReferenceStencilLayout>())).stencilLayout as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentReferenceStencilLayout),
            "::",
            stringify!(stencilLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkAttachmentDescriptionStencilLayout {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub stencilInitialLayout: VkImageLayout,
    pub stencilFinalLayout: VkImageLayout,
}
#[test]
fn bindgen_test_layout_VkAttachmentDescriptionStencilLayout() {
    assert_eq!(
        ::std::mem::size_of::<VkAttachmentDescriptionStencilLayout>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkAttachmentDescriptionStencilLayout)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkAttachmentDescriptionStencilLayout>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkAttachmentDescriptionStencilLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescriptionStencilLayout>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescriptionStencilLayout),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescriptionStencilLayout>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescriptionStencilLayout),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescriptionStencilLayout>())).stencilInitialLayout
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescriptionStencilLayout),
            "::",
            stringify!(stencilInitialLayout)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkAttachmentDescriptionStencilLayout>())).stencilFinalLayout
                as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkAttachmentDescriptionStencilLayout),
            "::",
            stringify!(stencilFinalLayout)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceHostQueryResetFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub hostQueryReset: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceHostQueryResetFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceHostQueryResetFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceHostQueryResetFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceHostQueryResetFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceHostQueryResetFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceHostQueryResetFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceHostQueryResetFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceHostQueryResetFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceHostQueryResetFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceHostQueryResetFeatures>())).hostQueryReset
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceHostQueryResetFeatures),
            "::",
            stringify!(hostQueryReset)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTimelineSemaphoreFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub timelineSemaphore: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceTimelineSemaphoreFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceTimelineSemaphoreFeatures>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceTimelineSemaphoreFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceTimelineSemaphoreFeatures>())).sType as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceTimelineSemaphoreFeatures>())).pNext as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceTimelineSemaphoreFeatures>())).timelineSemaphore
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreFeatures),
            "::",
            stringify!(timelineSemaphore)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceTimelineSemaphoreProperties {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub maxTimelineSemaphoreValueDifference: u64,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceTimelineSemaphoreProperties() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceTimelineSemaphoreProperties>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreProperties)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceTimelineSemaphoreProperties>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreProperties)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceTimelineSemaphoreProperties>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreProperties),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceTimelineSemaphoreProperties>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreProperties),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceTimelineSemaphoreProperties>()))
                .maxTimelineSemaphoreValueDifference as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceTimelineSemaphoreProperties),
            "::",
            stringify!(maxTimelineSemaphoreValueDifference)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreTypeCreateInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphoreType: VkSemaphoreType,
    pub initialValue: u64,
}
#[test]
fn bindgen_test_layout_VkSemaphoreTypeCreateInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSemaphoreTypeCreateInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkSemaphoreTypeCreateInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSemaphoreTypeCreateInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSemaphoreTypeCreateInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreTypeCreateInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreTypeCreateInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreTypeCreateInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreTypeCreateInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSemaphoreTypeCreateInfo>())).semaphoreType as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreTypeCreateInfo),
            "::",
            stringify!(semaphoreType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSemaphoreTypeCreateInfo>())).initialValue as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreTypeCreateInfo),
            "::",
            stringify!(initialValue)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkTimelineSemaphoreSubmitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub waitSemaphoreValueCount: u32,
    pub pWaitSemaphoreValues: *const u64,
    pub signalSemaphoreValueCount: u32,
    pub pSignalSemaphoreValues: *const u64,
}
#[test]
fn bindgen_test_layout_VkTimelineSemaphoreSubmitInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkTimelineSemaphoreSubmitInfo>(),
        48usize,
        concat!("Size of: ", stringify!(VkTimelineSemaphoreSubmitInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkTimelineSemaphoreSubmitInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkTimelineSemaphoreSubmitInfo))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkTimelineSemaphoreSubmitInfo>())).sType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkTimelineSemaphoreSubmitInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkTimelineSemaphoreSubmitInfo>())).pNext as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkTimelineSemaphoreSubmitInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkTimelineSemaphoreSubmitInfo>())).waitSemaphoreValueCount
                as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkTimelineSemaphoreSubmitInfo),
            "::",
            stringify!(waitSemaphoreValueCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkTimelineSemaphoreSubmitInfo>())).pWaitSemaphoreValues
                as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkTimelineSemaphoreSubmitInfo),
            "::",
            stringify!(pWaitSemaphoreValues)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkTimelineSemaphoreSubmitInfo>())).signalSemaphoreValueCount
                as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkTimelineSemaphoreSubmitInfo),
            "::",
            stringify!(signalSemaphoreValueCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkTimelineSemaphoreSubmitInfo>())).pSignalSemaphoreValues
                as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VkTimelineSemaphoreSubmitInfo),
            "::",
            stringify!(pSignalSemaphoreValues)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreWaitInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub flags: VkSemaphoreWaitFlags,
    pub semaphoreCount: u32,
    pub pSemaphores: *const VkSemaphore,
    pub pValues: *const u64,
}
#[test]
fn bindgen_test_layout_VkSemaphoreWaitInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSemaphoreWaitInfo>(),
        40usize,
        concat!("Size of: ", stringify!(VkSemaphoreWaitInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSemaphoreWaitInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSemaphoreWaitInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreWaitInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreWaitInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreWaitInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreWaitInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreWaitInfo>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreWaitInfo),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkSemaphoreWaitInfo>())).semaphoreCount as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreWaitInfo),
            "::",
            stringify!(semaphoreCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreWaitInfo>())).pSemaphores as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreWaitInfo),
            "::",
            stringify!(pSemaphores)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreWaitInfo>())).pValues as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreWaitInfo),
            "::",
            stringify!(pValues)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkSemaphoreSignalInfo {
    pub sType: VkStructureType,
    pub pNext: *const ::std::os::raw::c_void,
    pub semaphore: VkSemaphore,
    pub value: u64,
}
#[test]
fn bindgen_test_layout_VkSemaphoreSignalInfo() {
    assert_eq!(
        ::std::mem::size_of::<VkSemaphoreSignalInfo>(),
        32usize,
        concat!("Size of: ", stringify!(VkSemaphoreSignalInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VkSemaphoreSignalInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VkSemaphoreSignalInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreSignalInfo>())).sType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreSignalInfo),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreSignalInfo>())).pNext as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreSignalInfo),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreSignalInfo>())).semaphore as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreSignalInfo),
            "::",
            stringify!(semaphore)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VkSemaphoreSignalInfo>())).value as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VkSemaphoreSignalInfo),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct VkPhysicalDeviceBufferDeviceAddressFeatures {
    pub sType: VkStructureType,
    pub pNext: *mut ::std::os::raw::c_void,
    pub bufferDeviceAddress: VkBool32,
    pub bufferDeviceAddressCaptureReplay: VkBool32,
    pub bufferDeviceAddressMultiDevice: VkBool32,
}
#[test]
fn bindgen_test_layout_VkPhysicalDeviceBufferDeviceAddressFeatures() {
    assert_eq!(
        ::std::mem::size_of::<VkPhysicalDeviceBufferDeviceAddressFeatures>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(VkPhysicalDeviceBufferDeviceAddressFeatures)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<VkPhysicalDeviceBufferDeviceAddressFeatures>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(VkPhysicalDeviceBufferDeviceAddressFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceBufferDeviceAddressFeatures>())).sType
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceBufferDeviceAddressFeatures),
            "::",
            stringify!(sType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceBufferDeviceAddressFeatures>())).pNext
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VkPhysicalDeviceBufferDeviceAddressFeatures),
            "::",
            stringify!(pNext)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VkPhysicalDeviceBufferDeviceAddressFeatures>()))
                .bufferDeviceAddress as *const _ as usize
        },
    